#[doc = "🌱"]
pub const SEEDLING: crate::Emoji = crate::Emoji {
    glyph: "🌱",
    codepoint: "1F331",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "seedling",
    group: "Animals & Nature",
    subgroup: "plant-other",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("saailing"),
            keywords: &["jonk", "plant", "saailing"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ችግኝ"),
            keywords: &["ተክል", "ችግኝ", "አፍላ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("شتلة"),
            keywords: &["شتلة", "نبتة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("অংক\u{9c1}ৰ"),
            keywords: &["অংক\u{9c1}ৰ", "প\u{9c1}লি"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("şitil"),
            keywords: &["bitki", "cavan", "şitil"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("расада"),
            keywords: &["малады", "расада", "расліна", "саджанец", "флянс"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("кълн"),
            keywords: &["кълн", "младо", "растение"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("চ\u{9be}র\u{9be} গ\u{9be}ছ"),
            keywords: &["গ\u{9be}ছ", "চ\u{9be}র\u{9be} গ\u{9be}ছ", "নবীন"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("strujenn yaouank"),
            keywords: &["strujenn", "yaouank"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("rasad"),
            keywords: &["biljka", "rasad", "sjeme"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("brot"),
            keywords: &["brot", "nou", "planta"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄉𑄎\u{11127} 𑄍𑄢"),
            keywords: &["𑄉𑄎\u{11127} 𑄍𑄢"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᎦᏔᏛᏅ"),
            keywords: &["ᎠᏓ", "ᎤᎦᏔᏛᏅ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("výhonek"),
            keywords: &["klíček", "klíčící", "mladý", "rostlina", "výhonek"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("eginblanhigyn"),
            keywords: &["blodyn", "eginblanhigyn", "ifanc"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("spire"),
            keywords: &["plantespire", "spire"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Spross"),
            keywords: &["Spross", "junge Pflanze"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("φιντάνι"),
            keywords: &["νέο", "φιντάνι", "φυτό"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("seedling"),
            keywords: &["seedling", "young"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("planta joven"),
            keywords: &["planta joven", "plantón"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("plántula"),
            keywords: &["hojas", "plantita", "plántula"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("planta de semillero"),
            keywords: &["planta de semillero", "plantita"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("võrse"),
            keywords: &["idu", "taim", "võrse"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("kimua"),
            keywords: &["gazte", "kimua", "landare"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("جوانه"),
            keywords: &["جوان", "جوانه", "گیاه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("taimi"),
            keywords: &["kasvi", "taimi", "verso"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("binhi"),
            keywords: &["binhi", "halaman", "punla", "seedling", "tibtib"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("fræplanta"),
            keywords: &["fræ", "fræplanta", "planta"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("jeune pousse"),
            keywords: &["jeune plant", "jeune pousse", "plantule"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("síolphlanda"),
            keywords: &["síolphlanda", "óg"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("sìolag"),
            keywords: &["sìolag", "òg"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("plántula"),
            keywords: &["planta", "plántula", "xerminar"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("નાનો છોડ"),
            keywords: &["નાનો", "નાનો છોડ", "બીજ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("dashe"),
            keywords: &["dashe", "ƙarami"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("נבט"),
            keywords: &["נבט", "צמח", "שתיל"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("अ\u{902}क\u{941}र"),
            keywords: &["अ\u{902}क\u{941}र", "य\u{941}वा", "य\u{941}वा पौधा"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("sadnica"),
            keywords: &["biljka", "mlado", "sadnica"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("palánta"),
            keywords: &["növény", "palánta"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ծիլ"),
            keywords: &["բույս", "ծիլ", "մատղաշ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("semai"),
            keywords: &["muda", "semai", "tanaman"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("mkpụrụ"),
            keywords: &["mkpụrụ", "obere nwa"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("græðlingur"),
            keywords: &["græðlingur", "planta"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("germoglio"),
            keywords: &["germoglio", "piantina"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("新芽"),
            keywords: &["双葉", "新芽", "芽"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("pembibitan"),
            keywords: &["cilik", "pembibitan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ნათესარი"),
            keywords: &["ახალგაზრდა", "მცენარე", "ნათესარი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("imɣi aleqqaq"),
            keywords: &["imɣi aleqqaq"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("көшет"),
            keywords: &["жаңа", "көшет", "өсімдік"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("spire"),
            keywords: &["plantespire", "spire"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ក\u{17bc}នឈើ"),
            keywords: &["ក\u{17bc}នឈើ", "ក\u{17bc}នរ\u{17bb}ក\u{17d2}ខជាត\u{17b7}"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮೊಳಕ\u{cc6} ಒಡ\u{cc6}ಯುತ\u{ccd}ತ\u{cbf}ರುವ ಸಸ\u{ccd}ಯ"),
            keywords: &[
                "ಚ\u{cbf}ಕ\u{ccd}ಕ ಸಸ\u{ccd}ಯ",
                "ಮೊಳಕ\u{cc6} ಒಡ\u{cc6}ಯುತ\u{ccd}ತ\u{cbf}ರುವ ಸಸ\u{ccd}ಯ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("새싹"),
            keywords: &["새싹", "싹이 돋다"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("बियो"),
            keywords: &["बियो", "सान"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("көчөт"),
            keywords: &["жаш", "көчөт", "өсүмдүк"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Keimling"),
            keywords: &["Keimling", "jonk"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເບ\u{ec9}ຍໄມ\u{ec9}"),
            keywords: &["ພ\u{eb7}ດ", "ເບ\u{ec9}ຍໄມ\u{ec9}"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("daigas"),
            keywords: &["augalas", "daigas", "jaunas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("asns"),
            keywords: &["asns", "augs"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tipu"),
            keywords: &["hōu", "tipu"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("садница"),
            keywords: &["расад", "растение", "садница", "стебленце", "фиданка"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("തൈ"),
            keywords: &["ചെടി", "തളിര\u{d4d}", "തൈ", "മരം വളർത\u{d4d}തൽ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("үрсэлгээ"),
            keywords: &["ургамал", "үрсэлгээ"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("न\u{941}कत\u{947}च तयार झाल\u{947}ल\u{947} रोप"),
            keywords: &[
                "तर\u{941}ण",
                "न\u{941}कत\u{947}च तयार झाल\u{947}ल\u{947} रोप",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("anak benih"),
            keywords: &["anak benih", "muda"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("żerriegħa"),
            keywords: &["żerriegħa", "żgħażagħ"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပျ\u{102d}\u{102f}းပင\u{103a}"),
            keywords: &["ပျ\u{102d}\u{102f}းပင\u{103a}", "အပင\u{103a}ငယ\u{103a}"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("spire"),
            keywords: &["plante", "spire", "ung"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("अ\u{902}क\u{941}र"),
            keywords: &["अ\u{902}क\u{941}र", "बिर\u{942}वा", "भर\u{94d}खरको"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("zaailing"),
            keywords: &["jong", "zaailing"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("spire"),
            keywords: &["plante", "spire", "ung"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଚ\u{b3e}ର\u{b3e}"),
            keywords: &["ଚ\u{b3e}ର\u{b3e}", "ଛୋଟ ଗଛ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪ\u{a41}\u{a70}ਗਰਿਆ ਬੀਜ"),
            keywords: &["ਜਵਾਨ", "ਪ\u{a41}\u{a70}ਗਰਿਆ ਬੀਜ", "ਬ\u{a42}ਟਾ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("پنیری"),
            keywords: &["جوان", "پنیری"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Yọ\u{301}ng Plant"),
            keywords: &["Yọng", "Yọ\u{301}ng Plant"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("sadzonka"),
            keywords: &["pęd", "roślinka", "sadzonka"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("تخم"),
            keywords: &["تخم", "تخم، ځوان"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("muda de planta"),
            keywords: &["muda", "muda de planta", "plantinha"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("rebento"),
            keywords: &["nova", "planta", "rebento"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("wayna mallki"),
            keywords: &["wayna", "wayna mallki"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("răsad"),
            keywords: &["plantă", "răsad", "tânără"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-246"),
            keywords: &["E10-246"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("росток"),
            keywords: &[
                "молодое растение",
                "молодой",
                "новое растение",
                "новый",
                "растение",
                "росток",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("urugemwe"),
            keywords: &["gito", "urugemwe"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ٻج وارو گل"),
            keywords: &["جوان", "ٻج وارو گل"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("බ\u{dd3}ජ පැළය"),
            keywords: &["නොමේර\u{dd4}", "පැළය", "බ\u{dd3}ජ පැළය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("sadenica"),
            keywords: &["mladá", "rastlina", "sadenica"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("sadika"),
            keywords: &["mlado", "rastlina", "sadika"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("geed naqan"),
            keywords: &["geed naqan", "soo baxaya"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("filiz"),
            keywords: &["bimë", "e re", "filiz"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("младица"),
            keywords: &["младица", "младо"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["младица"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("mladica"),
            keywords: &["mladica", "mlado"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["mladica"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("skott"),
            keywords: &["grodd", "skott"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mche"),
            keywords: &["mche", "mmea"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("முளைக\u{bcd}கும\u{bcd} செடி"),
            keywords: &[
                "புதிய தொடக\u{bcd}கம\u{bcd}",
                "முளைக\u{bcd}கும\u{bcd} செடி",
                "வளர\u{bcd}ச\u{bcd}சி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("న\u{c3e}రుమ\u{c4a}క\u{c4d}క"),
            keywords: &[
                "అంకురము",
                "న\u{c3e}రుమ\u{c4a}క\u{c4d}క",
                "మ\u{c4a}లక",
                "ల\u{c47}త చ\u{c46}ట\u{c4d}టు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("навниҳол"),
            keywords: &["навниҳол", "ҷавон"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ต\u{e49}นอ\u{e48}อน"),
            keywords: &["ต\u{e49}นอ\u{e48}อน", "พ\u{e37}ช"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("şine"),
            keywords: &["ýaş", "şine"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("pulopula"),
            keywords: &["pulopula"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("filizlenme"),
            keywords: &["fide", "filizlenme", "genç"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("مايسا"),
            keywords: &["مايسا", "ياش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("сіянець"),
            keywords: &["паросток", "рослина", "сіянець"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ننھا پودا"),
            keywords: &["ننھا", "پودا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ko‘chat"),
            keywords: &["ko‘chat", "o‘simlik", "yosh"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("cây non"),
            keywords: &["cây non", "non"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("semis"),
            keywords: &["ndaw", "semis"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("imbewana"),
            keywords: &["imbewana", "omtsha"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ihoro eso"),
            keywords: &["Ihoro eso", "wẹ\u{301}wẹ\u{301}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("幼苗"),
            keywords: &["幼小", "幼苗"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("幼苗"),
            keywords: &["幼小", "幼苗"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("幼苗"),
            keywords: &["发芽", "幼苗", "芽", "苗"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("苗"),
            keywords: &["發芽", "苗"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("幼苗"),
            keywords: &["幼苗"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("imbewu"),
            keywords: &["imbewu", "isitshalo", "okuncane"],
        },
    ],
};
#[doc = "🪴"]
pub const POTTED_PLANT: crate::Emoji = crate::Emoji {
    glyph: "🪴",
    codepoint: "1FAB4",
    status: crate::Status::FullyQualified,
    introduction_version: 13f32,
    name: "potted plant",
    group: "Animals & Nature",
    subgroup: "plant-other",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("potplant"),
            keywords: &[
                "groei",
                "huis",
                "huisplant",
                "plant",
                "potplant",
                "vertroetel",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("በሸክላ የተተከለ አትክልት"),
            keywords: &["በሸክላ የተተከለ አትክልት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("نبتة في وعاء"),
            keywords: &[
                "بدون فائدة",
                "رعاية",
                "زراعة",
                "ممل",
                "منزل",
                "نبتة",
                "نبتة في وعاء",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("প\u{9be}ত\u{9cd}ৰত ৰোৱ\u{9be} গছ"),
            keywords: &[
                "গছ",
                "ঘৰ",
                "প\u{9be}ত\u{9cd}ৰত ৰোৱ\u{9be} গছ",
                "প\u{9cd}ৰতিপ\u{9be}লন কৰ\u{9be}",
                "ব\u{9c3}দ\u{9cd}ধি হোৱ\u{9be}",
                "ব\u{9cd}যৱহ\u{9be}ৰহীন",
                "ৰোৱ\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("dibçək bitkisi"),
            keywords: &[
                "becərmək",
                "bitki",
                "dibçək bitkisi",
                "ev",
                "faydasız",
                "qazma",
                "yetişdirmə",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("вазон"),
            keywords: &[
                "бескарысны",
                "вазон",
                "вырошчванне",
                "вырошчваць",
                "дом",
                "нудна",
                "расліна",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("растение в саксия"),
            keywords: &[
                "безполезно",
                "къща",
                "отглеждане",
                "порастване",
                "растение",
                "растение в саксия",
                "скучно",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("টবে ল\u{9be}গ\u{9be}নো গ\u{9be}ছ"),
            keywords: &[
                "অকেজো",
                "উদ\u{9cd}ভিত",
                "টবে ল\u{9be}গ\u{9be}নো গ\u{9be}ছ",
                "প\u{9cd}রতিপ\u{9be}লন",
                "ব\u{9be}ড\u{9bc}ি",
                "বোরিং",
                "ল\u{9be}গ\u{9be}নো",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("plantenn podet"),
            keywords: &["plantenn", "plantenn podet", "pod", "ti"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("biljka u saksiji"),
            keywords: &[
                "beskorisno",
                "biljka",
                "biljka u saksiji",
                "dosadno",
                "kuća",
                "raste",
                "zalijevanje",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("planta amb test"),
            keywords: &[
                "avorrit",
                "casa",
                "créixer",
                "inútil",
                "planta",
                "planta amb test",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᎪᏗ"),
            keywords: &["ᎠᎵᏍᏕᎸᏗ", "ᎤᏛᎯᏍᏙᏗ", "ᎦᎪᏗ", "ᎦᎵᏦᏕ", "ᏄᎵᏍᎨᏗᏴᎾ", "ᏙᎯ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("květina v květináči"),
            keywords: &[
                "dům",
                "květina v květináči",
                "nuda",
                "nudný",
                "péče",
                "rostlina",
                "růst",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("planhigyn mewn pot"),
            keywords: &[
                "diddefnydd",
                "diflas",
                "meithrin",
                "planhigyn",
                "planhigyn mewn pot",
                "tyfu",
                "tŷ",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("potteplante"),
            keywords: &[
                "hjem",
                "hus",
                "kedelig",
                "nære",
                "plante",
                "pleje",
                "potteplante",
                "vokse",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Topfpflanze"),
            keywords: &[
                "Haus",
                "Pflanze",
                "Topfpflanze",
                "langweilig",
                "nutzlos",
                "pflegen",
                "wachsen",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("φυτό σε γλάστρα"),
            keywords: &[
                "άχρηστο",
                "βαρετό",
                "καλλιεργώ",
                "σπίτι",
                "φυτρώνω",
                "φυτό",
                "φυτό σε γλάστρα",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("potted plant"),
            keywords: &[
                "boring",
                "grow",
                "house",
                "nurturing",
                "plant",
                "potted plant",
                "useless",
            ],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["grow", "house", "nurturing", "plant", "potted plant"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("pot plant"),
            keywords: &["grow", "house", "nurturing", "plant", "pot plant"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["grow", "house", "nurturing", "plant", "potted plant"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &[
                "boring",
                "grow",
                "house",
                "nurturing",
                "plant",
                "potted plant",
                "useless",
            ],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("planta de maceta"),
            keywords: &["crecer", "maceta", "planta", "planta de maceta", "tiesto"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("planta en una maceta"),
            keywords: &["planta en una maceta"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("planta en una maceta"),
            keywords: &["planta en una maceta"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("potilill"),
            keywords: &[
                "hoolitsema",
                "igav",
                "kasutu",
                "kasvatama",
                "potilill",
                "taim",
                "tuba",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("loreontziko landare"),
            keywords: &["etxea", "hazi", "landarea", "loreontziko landare", "zaindu"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("گیاه گلدانی"),
            keywords: &[
                "بی\u{200c}ثمر",
                "خانه",
                "رشد",
                "مراقبت",
                "کسل\u{200c}کننده",
                "گیاه",
                "گیاه گلدانی",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("ruukkukasvi"),
            keywords: &[
                "hoivata",
                "hyödytön",
                "kasvaa",
                "kasvi",
                "kokousfiikus",
                "koti",
                "ruukkukasvi",
                "tylsä",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("nakapasong halaman"),
            keywords: &[
                "bahay",
                "boring",
                "halaman",
                "nakapasong halaman",
                "pag-alaga",
                "palakihin",
                "walang silbi",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("urtapottur"),
            keywords: &["planta", "pottaplanta", "pottur", "urtapottur", "veksur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("plante en pot"),
            keywords: &[
                "décoration",
                "ennuyeux",
                "intérieur",
                "plante en pot",
                "pousser",
                "prendre soin",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "ennuyeux",
                "faire pousser",
                "intérieur",
                "inutile",
                "plante",
                "plante en pot",
                "prendre soin",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("planda pota"),
            keywords: &["cothú", "fás", "leadránach", "planda pota"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("lus ann am poit"),
            keywords: &[
                "altram",
                "altramadh",
                "dòrainneach",
                "fàs",
                "gun fheum",
                "lus",
                "lus ann am poit",
                "ràsanach",
                "taigh",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("planta en testo"),
            keywords: &["planta en testo", "plantar", "tarro", "testo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ક\u{ac2}\u{a82}ડામા\u{a82} ઉગાડ\u{ac7}લી વનસ\u{acd}પતિ"),
            keywords: &[
                "ઉછ\u{ac7}રવ\u{ac1}\u{a82}",
                "ક\u{ac2}\u{a82}ડામા\u{a82} ઉગાડ\u{ac7}લી વનસ\u{acd}પતિ",
                "ઘર",
                "છોડ",
                "નિર\u{ac1}પયોગી",
                "બોરિ\u{a82}ગ",
                "વ\u{ac3}દ\u{acd}ધિ પામવ\u{ac1}\u{a82}",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("צמח בעציץ"),
            keywords: &["משעמם", "עציץ", "עציץ לבית", "צמח", "צמח בעציץ"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("गमल\u{947} म\u{947}\u{902} लगा पौधा"),
            keywords: &[
                "उगना",
                "उबाऊ",
                "गमल\u{947} म\u{947}\u{902} लगा पौधा",
                "पालन-पोषण",
                "पौधा",
                "ब\u{947}कार",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("biljka u tegli"),
            keywords: &[
                "beskorisno",
                "biljka",
                "biljka u tegli",
                "dosadno",
                "kuća",
                "rasti",
                "uzgoj",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("cserepes növény"),
            keywords: &[
                "cserepes növény",
                "gondozás",
                "hasztalan",
                "növény",
                "szoba",
                "unalmas",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("թաղարով բույս"),
            keywords: &[
                "աճեցնել",
                "բույս",
                "թաղարով բույս",
                "խնամք",
                "ձանձրալի",
                "տուն",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tanaman pot"),
            keywords: &[
                "membosankan",
                "merawat",
                "rumah",
                "tanaman",
                "tanaman pot",
                "tumbuh",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("pottaplanta"),
            keywords: &["gagnslaus", "hús", "næra", "planta", "pottaplanta", "vaxa"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("pianta in vaso"),
            keywords: &[
                "casa",
                "coltivare",
                "curare",
                "inutile",
                "noioso",
                "pianta",
                "pianta in vaso",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("鉢植え"),
            keywords: &["ベランダ", "植木鉢", "植物", "水やり", "緑", "苗", "鉢植え"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tanduran njero adah"),
            keywords: &[
                "mboseni",
                "ngopeni",
                "omah",
                "ora migunani",
                "tanduran",
                "tanduran njero adah",
                "tukul",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მცენარე ქოთანში"),
            keywords: &[
                "გაზრდა",
                "მოვლა",
                "მოსაბეზრებელი",
                "მცენარე",
                "მცენარე ქოთანში",
                "სახლი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("бөлме өсімдігі"),
            keywords: &[
                "бөлме өсімдігі",
                "пайдасыз",
                "қазу",
                "үй",
                "өсу",
                "өсімдік",
                "өсіру",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("រ\u{17bb}ក\u{17d2}ខជាត\u{17b7}ដា\u{17c6}ក\u{17d2}ន\u{17bb}ងផើង"),
            keywords: &[
                "ការថែទា\u{17c6}",
                "គ\u{17bd}រឱ\u{17d2}យធ\u{17bb}ញ",
                "ដ\u{17bb}ះ",
                "ផ\u{17d2}ទះ",
                "រ\u{17bb}ក\u{17d2}ខជាត\u{17b7}",
                "រ\u{17bb}ក\u{17d2}ខជាត\u{17b7}ដា\u{17c6}ក\u{17d2}ន\u{17bb}ងផើង",
                "ឥតប\u{17d2}រយោជន\u{17cd}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕುಂಡದಲ\u{ccd}ಲ\u{cbf}ರುವ ಗ\u{cbf}ಡ"),
            keywords: &[
                "ಅನುಪಯುಕ\u{ccd}ತ",
                "ಕುಂಡದಲ\u{ccd}ಲ\u{cbf}ರುವ ಗ\u{cbf}ಡ",
                "ನೀರಸ",
                "ಪೋಷಣ\u{cc6}",
                "ಬ\u{cc6}ಳ\u{cc6}ಯ\u{cbf}ರ\u{cbf}",
                "ಮನ\u{cc6}",
                "ಸಸ\u{ccd}ಯ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("분재"),
            keywords: &["분재", "식물", "자라다", "지루한", "집", "키우다"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("क\u{941}\u{902}डीतल\u{947}\u{902} रोप"),
            keywords: &[
                "क\u{941}\u{902}डीतल\u{947}\u{902} रोप",
                "घर",
                "पोर",
                "पोशण",
                "ब\u{947}जार",
                "वाड",
                "वापरनाशिल\u{94d}ल\u{947}\u{902}",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("идиштеги өсүмдүк"),
            keywords: &["идиштеги өсүмдүк"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຕ\u{ebb}\u{ec9}ນໄມ\u{ec9}ທ\u{eb5}\u{ec8}ປ\u{eb9}ກໃນໂຖ"),
            keywords: &[
                "ການເບ\u{eb4}\u{ec8}ງແຍງຕ\u{ebb}\u{ec9}ນໄມ\u{ec9}",
                "ຕ\u{ebb}\u{ec9}ນໄມ\u{ec9}",
                "ຕ\u{ebb}\u{ec9}ນໄມ\u{ec9}ທ\u{eb5}\u{ec8}ປ\u{eb9}ກໃນໂຖ",
                "ບ\u{ecd}\u{ec8}ມ\u{eb5}ປະໂຫຍດ",
                "ປ\u{eb9}ກ",
                "ເຮ\u{eb7}ອນ",
                "ໜ\u{ec9}າເບ\u{eb7}\u{ec8}ອ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("pasodintas augalas"),
            keywords: &[
                "augalas",
                "augti",
                "bevertis",
                "namas",
                "nuobodus",
                "pasodintas augalas",
                "puoselėti",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("augs podiņā"),
            keywords: &[
                "audzēt",
                "augs",
                "augs podiņā",
                "augt",
                "garlaicība",
                "māja",
                "nevajadzīgs",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("растение во саксија"),
            keywords: &[
                "бескорисно",
                "здодевно",
                "куќа",
                "негување",
                "растение",
                "растение во саксија",
                "растење",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ചട\u{d4d}ടിയിൽ വളർത\u{d4d}ത\u{d41}ന\u{d4d}ന ചെടി"),
            keywords: &[
                "ഒന\u{d4d}നിന\u{d41}ം കൊള\u{d4d}ള\u{d3e}ത\u{d4d}തത\u{d4d}",
                "ചട\u{d4d}ടിയിൽ വളർത\u{d4d}ത\u{d41}ന\u{d4d}ന ചെടി",
                "ചെടി",
                "പരിപ\u{d3e}ലനം",
                "മട\u{d41}പ\u{d4d}പ\u{d4d}",
                "വളര\u{d41}ക",
                "വീട\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("ваартай ургамал"),
            keywords: &[
                "байшин",
                "ваартай ургамал",
                "уйтгартай",
                "ургамал",
                "ургуулах",
                "хэрэгцээгүй",
                "өсөх",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("क\u{941}\u{902}डीत लावायच\u{947} रोपट\u{947}"),
            keywords: &[
                "क\u{941}\u{902}डीत लावायच\u{947} रोपट\u{947}",
                "घर",
                "निर\u{942}पयोगी",
                "बोरि\u{902}ग",
                "रोपट\u{947}",
                "लागवड करण\u{947}",
                "स\u{902}गोपन करण\u{947}",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("pokok dalam pasu"),
            keywords: &[
                "bosan",
                "menyemai",
                "pokok",
                "pokok dalam pasu",
                "rumah",
                "tidak berguna",
                "tumbuh",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အ\u{102d}\u{102f}းထ\u{1032}စ\u{102d}\u{102f}က\u{103a}သောအပင\u{103a}"),
            keywords: &[
                "ကြ\u{102e}းထ\u{103d}ား",
                "ပျင\u{103a}း",
                "ပြ\u{102f}စ\u{102f}",
                "အပင\u{103a}",
                "အသ\u{102f}\u{1036}းမဝင\u{103a}",
                "အ\u{102d}မ\u{103a}",
                "အ\u{102d}\u{102f}းထ\u{1032}စ\u{102d}\u{102f}က\u{103a}သောအပင\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("potteplante"),
            keywords: &[
                "dyrke",
                "hus",
                "kjedelig",
                "plante",
                "potteplante",
                "ubrukelig",
                "vanne",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("गमलामा राखिएको विर\u{941}वा"),
            keywords: &[
                "उम\u{94d}रन\u{947}",
                "गमलामा राखिएको विर\u{941}वा",
                "घर",
                "पोषण",
                "बिर\u{941}वा",
                "ब\u{947}काम",
                "बोरिङ",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("potplant"),
            keywords: &[
                "groeien",
                "huis",
                "nutteloos",
                "plant",
                "potplant",
                "saai",
                "verzorgen",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("potteplante"),
            keywords: &[
                "dyrke",
                "hus",
                "keisamt",
                "plante",
                "potteplante",
                "ubrukeleg",
                "vatne",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପ\u{b3e}ତ\u{b4d}ରରେ ଥ\u{b3f}ବ\u{b3e} ଗଛ"),
            keywords: &[
                "ଅଦରକ\u{b3e}ରୀ",
                "ଘର",
                "ଚ\u{b3e}ର\u{b3e}",
                "ପ\u{b3e}ତ\u{b4d}ରରେ ଥ\u{b3f}ବ\u{b3e} ଗଛ",
                "ପୋଷକ",
                "ବ\u{b43}ଦ\u{b4d}ଧ\u{b3f}",
                "ବୋର\u{b3f}ଙ\u{b4d}ଗ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਗਮਲ\u{a47} ਵਾਲਾ ਪ\u{a4c}ਦਾ"),
            keywords: &[
                "ਅਕਾਊ",
                "ਉਗਾਉਣਾ",
                "ਗਮਲ\u{a47} ਵਾਲਾ ਪ\u{a4c}ਦਾ",
                "ਘਰ",
                "ਪਾਲਣ-ਪ\u{a4b}ਸ\u{a3c}ਣ",
                "ਬ\u{a42}ਟਾ",
                "ਬ\u{a47}ਕਾਰ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Plant Ínsaíd Pọt"),
            keywords: &[
                "Gro",
                "Haus",
                "Lúk Áftá Sọ\u{301}mtin Ọ Sọ\u{301}mbọ\u{301}di Wẹ\u{301}n I De Gro",
                "Plant",
                "Plant Wé Dé Fọ Pọt",
                "Plant Ínsaíd Pọt",
                "Pẹ\u{301}sin Nọ\u{301} Dé Íntrẹ\u{301}stẹd Fọ Sọ\u{301}mtin",
                "Yúzlẹs",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("roślina doniczkowa"),
            keywords: &[
                "dom",
                "kwiat doniczkowy",
                "podlewać",
                "roślina",
                "roślina doniczkowa",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د ننګرۍ بوټی"),
            keywords: &[
                "بې هدفه",
                "تنګوونکی",
                "د ننګرۍ بوټی",
                "لويدل",
                "لويدونکی",
                "ډيم",
                "کور",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("vaso com planta"),
            keywords: &[
                "casa",
                "chato",
                "nutrir",
                "planta",
                "plantar",
                "sem utilidade",
                "vaso com planta",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("macetapi sachʼa"),
            keywords: &[
                "macetapi sachʼa",
                "majiy",
                "mana ruwanapaq",
                "nutrir",
                "paqariy",
                "sachʼa",
                "wasi",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("plantă în ghiveci"),
            keywords: &[
                "casă",
                "crește",
                "cultiva",
                "ghiveci",
                "plantă",
                "plantă în ghiveci",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E13-037"),
            keywords: &["E13-037"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("растение в горшке"),
            keywords: &[
                "бесплодный",
                "выращивать",
                "горшок",
                "дом",
                "растение",
                "растение в горшке",
                "скука",
                "скучно",
                "цветок",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪونڊي ۾ ٻوٽو"),
            keywords: &[
                "اجايو",
                "بيزار ٿيڻ",
                "وڌڻ",
                "ٻوٽو",
                "پرورش ڪرڻ",
                "ڪونڊي ۾ ٻوٽو",
                "ڪونڏي ۾ گل",
                "گهر",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("පෝච\u{dca}ච\u{dd2} කළ පැලය"),
            keywords: &[
                "කම\u{dca}මැල\u{dd2}",
                "න\u{dd2}වස",
                "න\u{dd2}ෂ\u{dca}එල",
                "පෝච\u{dca}ච\u{dd2} කළ පැලය",
                "පෝෂණය",
                "වර\u{dca}ධනය",
                "ශ\u{dcf}කය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("kvetináč"),
            keywords: &["doma", "kvetináč", "rastlina", "rás´´ť", "zalievať"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("lončnica"),
            keywords: &[
                "dolgčas",
                "gojenje",
                "hiša",
                "lončnica",
                "neuporabno",
                "rasti",
                "rastlina",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("dhirta guriga"),
            keywords: &[
                "aan waxtar lahayn",
                "caaajis",
                "dhir",
                "dhirta guriga",
                "guri",
                "kobcinta",
                "korin",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("bimë në vazo"),
            keywords: &[
                "bimë",
                "bimë në vazo",
                "kot",
                "mërzitës",
                "rritje",
                "shtëpi",
                "ushqyes",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("биљка у саксији"),
            keywords: &[
                "бескорисно",
                "биљка",
                "биљка у саксији",
                "досадно",
                "кућа",
                "нега",
                "расте",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["биљка у саксији"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("biljka u saksiji"),
            keywords: &[
                "beskorisno",
                "biljka",
                "biljka u saksiji",
                "dosadno",
                "kuća",
                "nega",
                "raste",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["biljka u saksiji"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("krukväxt"),
            keywords: &["inomhus", "krukväxt", "odla", "växt"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mmea ndani ya mkebe"),
            keywords: &[
                "bila faida",
                "kutunza",
                "mea",
                "mmea",
                "mmea ndani ya mkebe",
                "nyumba",
                "uchoshi",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பூந\u{bcd}தொட\u{bcd}டியில\u{bcd} உள\u{bcd}ள த\u{bbe}வரம\u{bcd}"),
            keywords: &[
                "செடி",
                "துளைத\u{bcd}தல\u{bcd}",
                "பயனற\u{bcd}றது",
                "பூந\u{bcd}தொட\u{bcd}டியில\u{bcd} உள\u{bcd}ள த\u{bbe}வரம\u{bcd}",
                "வளர\u{bcd}",
                "வளர\u{bcd}ப\u{bcd}பது",
                "வ\u{bc0}டு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("కుండ\u{c40}ల\u{c4b} న\u{c3e}టబడ\u{c3f}న మ\u{c4a}క\u{c4d}క"),
            keywords: &[
                "ఇల\u{c4d}లు",
                "కుండ\u{c40}ల\u{c4b} న\u{c3e}టబడ\u{c3f}న మ\u{c4a}క\u{c4d}క",
                "ప\u{c46}ంచడం",
                "ప\u{c46}రగడం",
                "బ\u{c4b}ర\u{c3f}ంగ\u{c4d}",
                "మ\u{c4a}క\u{c4d}క",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ไม\u{e49}กระถาง"),
            keywords: &[
                "น\u{e48}าเบ\u{e37}\u{e48}อ",
                "บ\u{e49}าน",
                "พ\u{e37}ช",
                "เพาะปล\u{e39}ก",
                "เล\u{e35}\u{e49}ยงต\u{e49}นไม\u{e49}",
                "ไม\u{e49}กระถาง",
                "ไร\u{e49}ประโยชน\u{e4c}",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gorşokdaky ösümlik"),
            keywords: &[
                "gorşokdaky ösümlik",
                "içgysgynç",
                "peýdasyz",
                "ösmek",
                "ösümlik",
                "öý",
                "ýetişdirmek",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ʻakau ʻihe kulo"),
            keywords: &["ʻakau ʻihe kulo"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("saksı bitkisi"),
            keywords: &[
                "bitki",
                "ev",
                "ev bitkisi",
                "saksı",
                "saksı bitkisi",
                "yetiştirme",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("рослина в горщику"),
            keywords: &[
                "безглузда",
                "вирощувати",
                "догляд",
                "домашня",
                "нудна",
                "рослина",
                "рослина в горщику",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("گملے میں پودا"),
            keywords: &[
                "اکتاہٹ",
                "اگنا",
                "بیکار",
                "نشوونما",
                "پودا",
                "گملے میں پودا",
                "گھر",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("tuvakdagi oʻsimlik"),
            keywords: &[
                "foydasiz",
                "oʻsimlik",
                "oʻsish",
                "parvarishlash",
                "tuvakdagi oʻsimlik",
                "uy",
                "zerikarli",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("cây trồng trong chậu"),
            keywords: &[
                "cây trồng trong chậu",
                "nhà",
                "nhàm chán",
                "nuôi dưỡng",
                "phát triển",
                "trồng",
                "vô dụng",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("盆栽"),
            keywords: &["培育", "屋", "悶", "成長", "植物", "無用", "盆栽"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("盆栽"),
            keywords: &["培育", "屋", "成长", "无用", "植物", "盆栽", "闷"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("盆栽植物"),
            keywords: &["培育", "房子", "枯燥", "植物", "生长", "盆栽植物"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("盆景"),
            keywords: &["室內植物", "植物", "生長", "盆景", "觀賞"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isitshalo esisesitsheni"),
            keywords: &[
                "akusizi ngalutho",
                "indlu",
                "isitshalo",
                "isitshalo esisesitsheni",
                "ukudubula",
                "ukukhula",
                "ukukhulisa",
            ],
        },
    ],
};
#[doc = "🌲"]
pub const EVERGREEN_TREE: crate::Emoji = crate::Emoji {
    glyph: "🌲",
    codepoint: "1F332",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "evergreen tree",
    group: "Animals & Nature",
    subgroup: "plant-other",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("immergroen boom"),
            keywords: &["boom", "immergroen", "plant"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሁሌም አረንጓዴ"),
            keywords: &["ሁሌም አረንጓዴ", "ተክል", "ዛፍ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("شجرة دائمة الخضرة"),
            keywords: &["شجرة", "شجرة دائمة الخضرة", "نبات"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("চিৰসেউজ ব\u{9c3}ক\u{9cd}ষ"),
            keywords: &["গছ", "চিৰসেউজ ব\u{9c3}ক\u{9cd}ষ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("həmişəyaşıl"),
            keywords: &["ağac", "bitki", "həmişəyaşıl"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("вечназялёнае дрэва"),
            keywords: &["вечназялёнае дрэва", "дрэва", "расліна", "хвоя"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Вечнозелено дърво"),
            keywords: &["Вечнозелено дърво", "дърво", "растение"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("চিরহরিৎ"),
            keywords: &["গ\u{9be}ছ", "চিরহরিৎ"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("avalpineg"),
            keywords: &["avalpineg", "gwez"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("zimzelen"),
            keywords: &["biljka", "drvo", "zimzelen"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("arbre de fulla perenne"),
            keywords: &["arbre", "arbre de fulla perenne", "perenne"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄦𑄬𑄣\u{11134} 𑄉𑄌\u{11134}"),
            keywords: &["𑄦𑄬𑄣\u{11134} 𑄉𑄌\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏥᎾ ᎢᏡᎬᎢ"),
            keywords: &["ᎠᏥᎾ ᎢᏡᎬᎢ", "ᎢᏡᎬᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("jehličnatý strom"),
            keywords: &["jehličnatý strom", "rostlina", "strom", "stálezelený"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("bythwyrdd"),
            keywords: &["bythwyrdd", "coeden", "planhigyn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("nåletræ"),
            keywords: &["nåletræ", "stedsegrøn", "træ"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Nadelbaum"),
            keywords: &["Baum", "Nadelbaum", "Pflanze"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("αειθαλές δέντρο"),
            keywords: &["αειθαλές δέντρο", "δέντρο", "φυτό"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("evergreen tree"),
            keywords: &["evergreen tree", "tree"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("árbol de hoja perenne"),
            keywords: &["hoja perenne", "perenne", "árbol", "árbol de hoja perenne"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &[
                "perenne",
                "pino",
                "siempreverde",
                "árbol",
                "árbol de hoja perenne",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("igihaljas puu"),
            keywords: &["igihaljas", "puu", "taim"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("hosto iraukorreko zuhaitza"),
            keywords: &["hosto iraukorreko zuhaitza", "landare", "zuhaitz"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("همیشه\u{200c}سبز"),
            keywords: &["درخت", "همیشه\u{200c}سبز", "گیاه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("ikivihreä"),
            keywords: &["ikivihreä", "kasvi", "puu"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("evergreen"),
            keywords: &["evergreen", "halaman", "puno"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("veturgrønt træ"),
            keywords: &["træ", "veturgrønt"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("conifère"),
            keywords: &["arbre", "conifère"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["arbre", "conifère", "feuillage persistant"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("crann síorghlas"),
            keywords: &["crann", "crann síorghlas"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("craobh sìor-uaine"),
            keywords: &["craobh", "craobh sìor-uaine"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("árbore de folla perenne"),
            keywords: &["abeto", "árbore", "árbore de folla perenne"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સદાબહાર વ\u{ac3}ક\u{acd}ષ"),
            keywords: &["વ\u{ac3}ક\u{acd}ષ", "સદાબહાર"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("bishiya mai tsanwa"),
            keywords: &["bishiya", "bishiya mai tsanwa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("עץ ירוק-עד"),
            keywords: &["ירוק-עד", "עץ", "צמח"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("सदाबहार व\u{943}क\u{94d}ष"),
            keywords: &["प\u{947}ड\u{93c}", "व\u{943}क\u{94d}ष", "सदाबहार"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("zimzeleno drvo"),
            keywords: &["biljka", "drvo", "zimzeleno drvo"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("örökzöld"),
            keywords: &["fa", "növény", "örökzöld"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("եղևնի"),
            keywords: &["բույս", "եղևնի", "ծառ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("pohon hijau abadi"),
            keywords: &["pohon", "pohon hijau abadi", "tanaman"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("osisi na-adị ndụ kwa mgbe"),
            keywords: &["osisi na-adị ndụ kwa mgbe", "osisi nnukwu"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("sígrænt tré"),
            keywords: &["sígrænt", "tré"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("albero sempreverde"),
            keywords: &["albero", "sempreverde"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("常緑樹"),
            keywords: &["常緑樹", "木"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("wit cemara"),
            keywords: &["wit", "wit cemara"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მარადმწვანე"),
            keywords: &["მარადმწვანე", "მცენარე", "ხე"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("tumert"),
            keywords: &["tumert"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("шырша"),
            keywords: &["ағаш", "шырша", "өсімдік"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("grantræ"),
            keywords: &["grantræ", "stedsegrøn", "træ"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ដើមឈើបៃតងជាន\u{17b7}ច\u{17d2}ច"),
            keywords: &["ដើមឈើ", "ដើមឈើបៃតងជាន\u{17b7}ច\u{17d2}ច"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಹಚ\u{ccd}ಚಹಸ\u{cbf}ರ\u{cbf}ನ ಮರ"),
            keywords: &[
                "ಮರ",
                "ಸದಾ ಹಚ\u{ccd}ಚಹಸುರಾದ ಮರ",
                "ಹಚ\u{ccd}ಚಹಸ\u{cbf}ರ\u{cbf}ನ ಮರ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("소나무"),
            keywords: &["나무", "상록수", "소나무"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("सदाबहार झाड"),
            keywords: &["झाड", "सदाबहार झाड"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("арча"),
            keywords: &["арча", "дарак"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Dännebam"),
            keywords: &["Bam", "Dännebam"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຕ\u{ebb}\u{ec9}ນໄມ\u{ec9}ຂຽວຕະຫ\u{ebc}ອດປ\u{eb5}"),
            keywords: &[
                "ຕ\u{ebb}\u{ec9}ນໄມ\u{ec9}",
                "ຕ\u{ebb}\u{ec9}ນໄມ\u{ec9}ຂຽວຕະຫ\u{ebc}ອດປ\u{eb5}",
                "ພ\u{eb7}ດ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("amžinai žaliuojantis medis"),
            keywords: &["amžinai žaliuojantis medis", "medis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("skujkoks"),
            keywords: &["augs", "koks", "skujkoks"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("rākau māota"),
            keywords: &["rākau", "rākau māota"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("зимзелено дрво"),
            keywords: &["дрво", "зимзелено", "растение"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("നിത\u{d4d}യഹരിത വ\u{d43}ക\u{d4d}ഷം"),
            keywords: &[
                "നിത\u{d4d}യഹരിത വ\u{d43}ക\u{d4d}ഷം",
                "പച\u{d4d}ചപ\u{d4d}പ\u{d4d}",
                "മരം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("гацуур"),
            keywords: &["гацуур", "зул сар", "мод", "шинэ жил"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("सदाहरित झाड"),
            keywords: &["झाड", "सदाहरित झाड"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("malar hijau"),
            keywords: &["malar hijau", "pokok"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("siġra tħaddar"),
            keywords: &["siġra", "siġra tħaddar"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အမြ\u{1032}စ\u{102d}မ\u{103a}း သစ\u{103a}ပင\u{103a}"),
            keywords: &[
                "သစ\u{103a}ပင\u{103a}",
                "အမြ\u{1032}စ\u{102d}မ\u{103a}း သစ\u{103a}ပင\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("bartre"),
            keywords: &[
                "barnåler",
                "bartre",
                "eviggrønt tre",
                "gran",
                "juletre",
                "tre",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("सदाबहार"),
            keywords: &["बिर\u{942}वा", "र\u{942}ख", "सदाबहार"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("naaldboom"),
            keywords: &["boom", "naaldboom"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("bartre"),
            keywords: &[
                "barnåler",
                "bartre",
                "eviggrønt tre",
                "gran",
                "juletre",
                "tre",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଚ\u{b3f}ରସବ\u{b41}ଜ ଗଛ"),
            keywords: &["ଗଛ", "ଚ\u{b3f}ରସବ\u{b41}ଜ ଗଛ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸਦਾਬਹਾਰ ਰ\u{a41}\u{a71}ਖ"),
            keywords: &["ਰ\u{a41}\u{a71}ਖ", "ਸਦਾਬਹਾਰ ਰ\u{a41}\u{a71}ਖ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("سدا بہار درخت"),
            keywords: &["درخت", "سدا بہار درخت"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Ẹvagrín Tri"),
            keywords: &["Tri", "Ẹvagrín Tri"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("wiecznie zielone drzewo"),
            keywords: &["drzewo iglaste", "wiecznie zielone drzewo"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("تل زرغون ونه"),
            keywords: &["تل زرغون ونه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("conífera"),
            keywords: &["conífera", "árvore"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("árvore de folha perene"),
            keywords: &["planta", "árvore", "árvore de folha perene"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("sachʼa perenne laqhiwan"),
            keywords: &["sachʼa perenne laqhiwan", "sach’a"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("arbore conifer"),
            keywords: &["arbore conifer", "brad", "conifer", "copac"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-247"),
            keywords: &["E10-247"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("елка"),
            keywords: &["вечнозеленое дерево", "дерево", "елка", "ель"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("igiti gihora gitoshye"),
            keywords: &["igiti", "igiti gihora gitoshye"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("سدا بهار وڻ"),
            keywords: &["سدا بهار وڻ", "وڻ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("සද\u{dcf}හර\u{dd2}ත ශ\u{dcf}කය"),
            keywords: &["ගස", "පැළය", "සද\u{dcf}හර\u{dd2}ත ශ\u{dcf}කය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("ihličnatý strom"),
            keywords: &["ihličnatý strom", "neopadavý", "rastlina", "strom"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("zimzeleno drevo"),
            keywords: &["drevo", "rastlina", "zimzeleno drevo"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("geed abaareed"),
            keywords: &["geed", "geed abaareed"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("gjelbërim i përjetshëm"),
            keywords: &["bimë", "gjelbërim i përjetshëm", "pemë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("четинар"),
            keywords: &["дрво", "четинар"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["четинар"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("četinar"),
            keywords: &["drvo", "četinar"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["četinar"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("barrträd"),
            keywords: &["barrträd", "gran", "träd", "vintergrön"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mmea wenye majani mwaka mzima"),
            keywords: &["mmea", "mmea wenye majani mwaka mzima", "mti"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பசுமை மரம\u{bcd}"),
            keywords: &[
                "கிறிஸ\u{bcd}துமஸ\u{bcd} க\u{bbe}லம\u{bcd}",
                "கிறிஸ\u{bcd}துமஸ\u{bcd} மரம\u{bcd}",
                "பசுமை",
                "மரம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("సతతహర\u{c3f}తం"),
            keywords: &[
                "ఆకులు ర\u{c3e}లకుండ\u{c47} పచ\u{c4d}చగ\u{c3e} ఉండ\u{c47} చ\u{c46}ట\u{c4d}టు",
                "ఎప\u{c4d}పుడూ పచ\u{c4d}చగ\u{c3e} ఉండ\u{c47} చ\u{c46}ట\u{c4d}టు",
                "సతతహర\u{c3f}త చ\u{c46}ట\u{c4d}టు",
                "సతతహర\u{c3f}తం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("дарахти ҳамешасабз"),
            keywords: &["дарахт", "дарахти ҳамешасабз"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ต\u{e49}นสน"),
            keywords: &["ต\u{e49}นสน", "ต\u{e49}นไม\u{e49}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("hemişe gök öwüsýän agaç"),
            keywords: &["agaç", "hemişe gök öwüsýän agaç"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ʻakau lanumata maʻu pē"),
            keywords: &["ʻakau lanumata maʻu pē"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yaprak dökmeyen ağaç"),
            keywords: &["ağaç", "yaprak dökmeyen", "yaprak dökmeyen ağaç"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئارچا"),
            keywords: &["ئارچا", "دەرەخ"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("вічнозелене дерево"),
            keywords: &["вічнозелене дерево", "дерево", "рослина"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سدا بہار"),
            keywords: &["درخت", "سدا بہار", "پودا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("archa"),
            keywords: &["archa", "daraxt", "o‘simlik"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("cây thường xanh"),
            keywords: &["cây", "cây thường xanh", "thực vật"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("garab gu am xob yuy dund"),
            keywords: &["garab", "garab gu am xob yuy dund"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umthi ohlala uluhlaza"),
            keywords: &["umthi", "umthi ohlala uluhlaza"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Igi Aruwe"),
            keywords: &["Igi", "Igi Aruwe"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("常青樹"),
            keywords: &["常青樹", "樹"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("常青树"),
            keywords: &["常青树", "树"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("松树"),
            keywords: &["常青树", "松树", "树"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("常青樹"),
            keywords: &["常青樹", "樹"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("常綠樹"),
            keywords: &["常綠樹", "樹"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("i-evergreen"),
            keywords: &["i-evergreen", "isihlahla", "isitshalo"],
        },
    ],
};
#[doc = "🌳"]
pub const DECIDUOUS_TREE: crate::Emoji = crate::Emoji {
    glyph: "🌳",
    codepoint: "1F333",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "deciduous tree",
    group: "Animals & Nature",
    subgroup: "plant-other",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("bladwisselende boom"),
            keywords: &[
                "bladwisselend",
                "bladwisselende boom",
                "blare",
                "boom",
                "plant",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ባለጥላ ዛፍ"),
            keywords: &["ባለ ጥላ ተክል", "ባለጥላ ዛፍ", "ዛፍ", "ጥላ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("شجرة زائلة الخضرة"),
            keywords: &["تساقط", "شجرة", "شجرة زائلة الخضرة", "متساقط", "نبات"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("পৰ\u{9cd}ণপ\u{9be}তী গছ"),
            keywords: &[
                "গছ",
                "ছ\u{9be}\u{981} দিয\u{9bc}\u{9be}",
                "পৰ\u{9cd}ণপ\u{9be}তী",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("enliyarpaqlı ağac"),
            keywords: &["ağac", "bitki", "enliyarpaqlı", "tökmək"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("ліставое дрэва"),
            keywords: &["ападанне", "дрэва", "ліставое дрэва", "ліставы", "расліна"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Листопадно дърво"),
            keywords: &[
                "Листопадно дърво",
                "дърво",
                "листопадно",
                "растение",
                "широколистно",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("পর\u{9cd}ণমোচী গ\u{9be}ছ"),
            keywords: &["গ\u{9be}ছ", "ছ\u{9be}\u{981}ট\u{9be}", "পর\u{9cd}ণমোচী"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("deliaoueg"),
            keywords: &["deliaoueg", "gwez"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("bjelogorično drvo"),
            keywords: &[
                "bjelogorica",
                "bjelogorično drvo",
                "drvo",
                "hrast",
                "listopadno",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("arbre de fulla caduca"),
            keywords: &["arbre", "arbre de fulla caduca", "caduc"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄎\u{1112e}𑄝\u{1112a}𑄢\u{11134} 𑄉𑄌\u{11134}"),
            keywords: &["𑄎\u{1112e}𑄝\u{1112a}𑄢\u{11134} 𑄉𑄌\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᎵᏍᏚᏬᏍᎬᎢ ᎢᏡᎬᎢ"),
            keywords: &["ᎠᏚᏩᏂᎩᏍᏗ", "ᎢᏡᎬᎢ", "ᎦᎵᏍᏚᏬᏍᎬᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("listnatý strom"),
            keywords: &["listnatý strom", "opadavý", "rostlina", "strom"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("coeden gollddail"),
            keywords: &["coeden", "coeden gollddail", "collddail", "planhigyn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("løvtræ"),
            keywords: &["løvfældende træ", "løvtræ"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Laubbaum"),
            keywords: &["Baum", "Laub", "Laubbaum", "Pflanze"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("φυλλοβόλο δέντρο"),
            keywords: &["δέντρο", "ρίχνει τα φύλλα του", "φυλλοβόλο", "φυτό"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("deciduous tree"),
            keywords: &["deciduous", "shedding", "tree"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("árbol de hoja caduca"),
            keywords: &[
                "caducifolio",
                "hoja caduca",
                "árbol",
                "árbol de hoja caduca",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("árbol caducifolio"),
            keywords: &["caducas", "caducifolio", "hojas", "árbol"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("lehtpuu"),
            keywords: &["leht", "lehtpuu", "puu", "taim"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("hosto erorkorreko zuhaitza"),
            keywords: &[
                "erorkor",
                "hosto",
                "hosto erorkorreko zuhaitza",
                "landare",
                "zuhaitz",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("درخت سبز"),
            keywords: &["برگ\u{200c}ریز", "درخت", "درخت سبز", "گیاه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("lehtipuu"),
            keywords: &["kasvi", "lehtipuu", "palmu", "puu"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("punong nalalagas ang dahon"),
            keywords: &[
                "deciduous",
                "halaman",
                "lagas-dahon",
                "naglalagas ng dahon",
                "puno",
                "punong nalalagas ang dahon",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("træ sum fellir bløðini"),
            keywords: &["bløð", "fellir", "træ", "træ sum fellir bløðini"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("arbre à feuilles caduques"),
            keywords: &[
                "arbre",
                "arbre à feuilles caduques",
                "feuilles caduques",
                "feuillu",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("crann duillsilteach"),
            keywords: &[
                "caitheamh an duilliúir",
                "crann duillsilteach",
                "duillsilteach",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("craobh sheargach"),
            keywords: &["craobh", "craobh sheargach", "seargach"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("árbore de folla caduca"),
            keywords: &["árbore", "árbore de folla caduca"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ખરાઉ વ\u{ac3}ક\u{acd}ષ"),
            keywords: &["ખરાઉ", "પર\u{acd}ણ ખરવા", "વ\u{ac3}ક\u{acd}ષ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("bishiya mai kaɗe ganye"),
            keywords: &[
                "bishiya",
                "bishiya mai kaɗe ganye",
                "kaɗewa",
                "mai kaɗe ganye",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("עץ נשיר"),
            keywords: &["משיר", "עץ", "עץ נשיר", "צמח"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("छायादार प\u{947}ड\u{93c}"),
            keywords: &[
                "छाया",
                "छायादार प\u{947}ड\u{93c}",
                "पर\u{94d}णपाती",
                "व\u{943}क\u{94d}ष",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("listopadno drvo"),
            keywords: &["biljka", "drvo", "listopadno"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("lombhullató fa"),
            keywords: &["fa", "lombhullató", "növény"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("սաղարթավոր ծառ"),
            keywords: &["բույս", "ծառ", "սաղարթավոր"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("pohon meranggas"),
            keywords: &["gugur", "pohon", "pohon meranggas", "tanaman"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("osisi nke dị ụtọ"),
            keywords: &["dị ụtọ", "na-ekpuchi", "osisi", "osisi nke dị ụtọ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("sumargrænt tré"),
            keywords: &["lauftré", "sumargrænt tré", "tré"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("albero deciduo"),
            keywords: &["albero", "caduco", "deciduo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("落葉樹"),
            keywords: &["木", "落葉樹"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("wit godhonge rontok"),
            keywords: &["gogrok", "rontok", "wit", "wit godhonge rontok"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ფოთლოვანი ხე"),
            keywords: &["მცენარე", "ფოთლოვანი", "ხე"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("aseklu bu yifer"),
            keywords: &["aseklu bu yifer"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жапырақты ағаш"),
            keywords: &["ағаш", "дәмді", "жапырақты ағаш", "түсу", "өсімдік"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("træ"),
            keywords: &["løvfældende træ", "træ"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ដើមជ\u{17d2}រ\u{17bb}ះស\u{17d2}ល\u{17b9}ក"),
            keywords: &["ដើមជ\u{17d2}រ\u{17bb}ះស\u{17d2}ល\u{17b9}ក", "ដើមឈើ"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಉದುರುವ ಮರ"),
            keywords: &["ಉದುರುವ ಮರ", "ಮರ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("나무"),
            keywords: &["나무", "낙엽수"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("पानझडी झाड"),
            keywords: &["झाड", "पानझडी", "पाना\u{902} पडप"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жалбырактуу дарак"),
            keywords: &["дарак", "жалбырактуу"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Lafbam"),
            keywords: &["Bam", "Laf", "Lafbam", "falen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຕ\u{ebb}\u{ec9}ນໄມ\u{ec9}ປ\u{ec8}ຽນໃບ"),
            keywords: &[
                "ຕ\u{ebb}\u{ec9}ນໄມ\u{ec9}",
                "ຕ\u{ebb}\u{ec9}ນໄມ\u{ec9}ປ\u{ec8}ຽນໃບ",
                "ຮ\u{ebb}\u{ec8}ມ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("lapuotis"),
            keywords: &["augalas", "lapuotis", "medis", "mesti"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("lapu koks"),
            keywords: &["augs", "koks", "lapas", "lapu koks"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("rākau whakamakere rau"),
            keywords: &[
                "rākau",
                "rākau whakamakere rau",
                "tukurau",
                "whakamakere rau",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("листопадно дрво"),
            keywords: &["дрво", "листопадно", "растение"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഇലപൊഴിയ\u{d41}ം മരം"),
            keywords: &["ഇലകൊഴിയൽ", "ഇലപൊഴിയ\u{d41}ം മരം", "ശിശിരം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("навчит мод"),
            keywords: &["мод", "навч", "навчит мод"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("छायादार झाड"),
            keywords: &[
                "छायादार",
                "छायादार झाड",
                "पर\u{94d}णपाती",
                "व\u{943}क\u{94d}ष",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("pokok daun luruh"),
            keywords: &[
                "daun luruh",
                "luruh",
                "pokok daun luruh",
                "pokok luruh daun",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("siġra deċiduża"),
            keywords: &["deċiduża", "iwaqqgħu", "siġra"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ရ\u{103d}က\u{103a}ပြတ\u{103a}ပင\u{103a}"),
            keywords: &[
                "ရ\u{103d}က\u{103a}ပြတ\u{103a}ပင\u{103a}",
                "သစ\u{103a}ပင\u{103a}",
                "သစ\u{103a}ရ\u{103d}က\u{103a}ကြ\u{103d}ေခြင\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("løvtre"),
            keywords: &["blader", "løvtre", "tre"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("पतझढ र\u{942}ख"),
            keywords: &["पतझढ र\u{942}ख", "पर\u{94d}णपाती र\u{942}ख"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("loofboom"),
            keywords: &["bladeren verliezen", "boom", "loof verliezen", "loofboom"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("lauvtre"),
            keywords: &["blad", "lauvtre", "tre"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପର\u{b4d}ଣ\u{b4d}ଣମୋଚ\u{b3f} ଗଛ"),
            keywords: &[
                "ପର\u{b4d}ଣ\u{b4d}ଣପ\u{b3e}ତ\u{b3f}",
                "ପର\u{b4d}ଣ\u{b4d}ଣମୋଚ\u{b3f} ଗଛ",
                "ବ\u{b43}କ\u{b4d}ଷ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਝਾੜ ਦਾ ਰ\u{a41}\u{a71}ਖ"),
            keywords: &[
                "ਝਾੜ",
                "ਝਾੜ ਦਾ ਰ\u{a41}\u{a71}ਖ",
                "ਝਾੜ ਦ\u{a47} ਰ\u{a41}\u{a71}ਖ",
                "ਰ\u{a41}\u{a71}ਖ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("پت جھڑا درخت"),
            keywords: &["درخت", "شیڈنگ", "پت جھڑا", "پت جھڑا درخت"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Tri Wé Gẹ\u{301}t Plẹ\u{301}ntí Líf"),
            keywords: &[
                "Shẹ\u{301}din: Wẹ\u{301}n Sọ\u{301}mtin Laik Plant De Lúz Im Lif Fọ Náchọ\u{301}rál Wè",
                "Tri",
                "Tri Wé Gẹ\u{301}t Plẹ\u{301}ntí Líf",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("drzewo liściaste"),
            keywords: &["drzewo liściaste", "roślina"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("غورځونکي ونې"),
            keywords: &["غورځونکي ونې", "غورځونکې ونې، غورځونکې، ونه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("árvore caidiça"),
            keywords: &["caidiça", "desfolha", "árvore"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("árvore de folha caduca"),
            keywords: &["caduca", "árvore", "árvore de folha caduca"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("sachʼa caduca laqhiwan"),
            keywords: &["caduco", "laqhi", "sachʼa caduca laqhiwan", "sach’a"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("arbore foios"),
            keywords: &["arbore foios", "copac", "frunze căzătoare"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-248"),
            keywords: &["E10-248"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("дерево"),
            keywords: &["дерево", "зеленое", "растение"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("igiti gita amababi"),
            keywords: &[
                "gukokoka kw’amababi",
                "gukokoka kw’amababi y’igiti",
                "igiti",
                "igiti gita amababi",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("پتا ڇاڙيندڙ وڻ"),
            keywords: &["پتا ڇاڙيندڙ وڻ", "پتا ڇاڙيندڙ، وڻ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("පතනශ\u{dd3}ල ගස"),
            keywords: &["ගස", "පතනය", "පතනශ\u{dd3}ල"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("listnatý strom"),
            keywords: &["listnatý strom", "opadavý", "rastlina", "strom"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("listnato drevo"),
            keywords: &["drevo", "listnato", "odpadanje", "rastlina"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("geed magool"),
            keywords: &["caleen daadin", "geed", "magool"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("pemë gjetherënëse"),
            keywords: &["bimë", "gjetherënëse", "pemë", "rënie"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("листопадно дрво"),
            keywords: &["дрво", "листопадно", "опадање"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["листопадно дрво"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("listopadno drvo"),
            keywords: &["drvo", "listopadno", "opadanje"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["listopadno drvo"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("lövträd"),
            keywords: &["lövfällande", "lövträd", "träd"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mti unaopukutika majani yake"),
            keywords: &[
                "kupuputika",
                "mmea",
                "mti",
                "mti unaopukutika majani yake",
                "puputika majani",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("இலையுதிர\u{bcd} மரம\u{bcd}"),
            keywords: &["இலையுதிர\u{bcd} மரம\u{bcd}", "பசுமை", "மரம\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఆకుర\u{c3e}ల\u{c47} చ\u{c46}ట\u{c4d}టు"),
            keywords: &[
                "ఆకుర\u{c3e}ల\u{c47} చ\u{c46}ట\u{c4d}టు",
                "ఆకులు ర\u{c3e}ల\u{c47} అడవ\u{c3f} మ\u{c4a}క\u{c4d}క",
                "ఆకులు ర\u{c3e}ల\u{c47} చ\u{c46}ట\u{c4d}టు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("дарахти паҳнбарг"),
            keywords: &["дарахт", "дарахти паҳнбарг", "паҳнбарг", "резиш"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ต\u{e49}นไม\u{e49}ร\u{e48}มร\u{e37}\u{e48}น"),
            keywords: &[
                "ต\u{e49}นไม\u{e49}",
                "ต\u{e49}นไม\u{e49}ร\u{e48}มร\u{e37}\u{e48}น",
                "ร\u{e48}มเงา",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýaprakly agaç"),
            keywords: &["agaç", "kölegeli", "ýaprakly"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ʻakau fakatōlau"),
            keywords: &["ʻakau fakatōlau"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yaprak döken ağaç"),
            keywords: &["ağaç", "yaprak döken", "yaprak döken ağaç"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("يوپۇرماق تاشلار"),
            keywords: &["تاشلاش", "دەرەخ", "ياپراق", "يوپۇرماق تاشلار"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("листяне дерево"),
            keywords: &["дерево", "листяне дерево", "листяний", "опадає", "рослина"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("پت جھڑ درخت"),
            keywords: &["درخت", "پت جھڑ", "پت جھڑ درخت", "پودا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("bargli daraxt"),
            keywords: &["bargli", "daraxt", "toʻkilish"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("cây rụng lá"),
            keywords: &["cây", "cây rụng lá", "rơi", "rụng lá"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("garab gu am xob yuy dee"),
            keywords: &["garab", "garab gu am xob yuy dee", "ruus", "wàññiku"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umthi ovuthulukayo"),
            keywords: &["ovuthulukayo", "ukuvuthulula", "umthi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Igi Igbo"),
            keywords: &["Igi Igbo", "Igi to nta ewe lôdọ dún", "igi", "ti"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("落葉樹"),
            keywords: &["樹", "每年落葉", "脫落", "落葉樹"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("落叶树"),
            keywords: &["树", "每年落叶", "脱落", "落叶树"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("落叶树"),
            keywords: &["树", "落叶", "落叶树", "落叶植物"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("落葉樹"),
            keywords: &["樹", "落葉樹"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("i-deciduous tree"),
            keywords: &["i-deciduous tree", "isihlahla", "isitshalo"],
        },
    ],
};
#[doc = "🌴"]
pub const PALM_TREE: crate::Emoji = crate::Emoji {
    glyph: "🌴",
    codepoint: "1F334",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "palm tree",
    group: "Animals & Nature",
    subgroup: "plant-other",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("palmboom"),
            keywords: &["boom", "palm", "palmboom", "plant"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ዘንባባ"),
            keywords: &["ተክል", "ዘንባባ", "ዛፍ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("نخلة"),
            keywords: &["شجرة", "نبات", "نخلة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ত\u{9be}ল গছ"),
            keywords: &["গছ", "ত\u{9be}ল"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("palma ağacı"),
            keywords: &["ağac", "bitki", "palma", "palma ağacı"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("пальма"),
            keywords: &["дрэва", "пальма", "пальмавае дрэва", "расліна"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("палма"),
            keywords: &["дърво", "палма", "растение"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("প\u{9be}ম গ\u{9be}ছ"),
            keywords: &["গ\u{9be}ছ", "প\u{9be}ম"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("gwez-palmez"),
            keywords: &["gwez", "gwez-palmez", "palmez"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("palma"),
            keywords: &["drvo", "palma"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("palmera"),
            keywords: &["arbre", "palma", "palmera", "planta"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄖𑄣\u{11134} 𑄉𑄌\u{11134}"),
            keywords: &["𑄖𑄣\u{11134} 𑄉𑄌\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏧᎦᏄᏓᏅᎯᏛ ᎢᏡᎬᎢ"),
            keywords: &["ᎢᏡᎬᎢ", "ᏧᎦᏄᏓᏅᎯᏛ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("palma"),
            keywords: &["palma", "rostlina", "strom"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("palmwydden"),
            keywords: &["coeden", "palmwydden", "planhigyn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("palme"),
            keywords: &["palme", "palmetræ"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Palme"),
            keywords: &["Baum", "Palme", "Pflanze"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("φοίνικας"),
            keywords: &["δέντρο", "φοίνικας", "φυτό"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("palm tree"),
            keywords: &["palm", "tree"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("palmera"),
            keywords: &["palmera", "árbol", "árbol de palma"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["cocos", "palmera", "árbol"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("palmipuu"),
            keywords: &["palm", "palmipuu", "puu", "taim"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("palmondoa"),
            keywords: &["palmondoa", "zuhaitza"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("نخل"),
            keywords: &["درخت", "نخل", "گیاه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("palmu"),
            keywords: &["kasvi", "palmu", "puu"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("palmera"),
            keywords: &["halaman", "palm", "palmera", "puno"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("plámatræ"),
            keywords: &["plámatræ", "pálmi", "træ"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("palmier"),
            keywords: &["arbre", "palmier"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("pailm"),
            keywords: &["crann", "pailm"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("craobh-phailm"),
            keywords: &["craobh", "craobh-phailm", "pailm"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("palmeira"),
            keywords: &["palmeira", "árbore"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("તાડન\u{ac1}\u{a82} વ\u{ac3}ક\u{acd}ષ"),
            keywords: &[
                "તાડ",
                "તાડન\u{ac1}\u{a82} વ\u{ac3}ક\u{acd}ષ",
                "વ\u{ac3}ક\u{acd}ષ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("bishiyar kwakwa"),
            keywords: &["bishiya", "bishiyar kwakwa", "kwakwa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("עץ דקל"),
            keywords: &["טרופי", "עץ", "עץ דקל", "צמח"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ताड\u{93c} का प\u{947}ड\u{93c}"),
            keywords: &[
                "ताड\u{93c}",
                "ताड\u{93c} का प\u{947}ड\u{93c}",
                "व\u{943}क\u{94d}ष",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("palma"),
            keywords: &["biljka", "drvo", "palma"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("pálmafa"),
            keywords: &["fa", "növény", "pálma", "pálmafa"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("արմավենի"),
            keywords: &["արմավենի", "բույս", "ծառ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("pohon palem"),
            keywords: &["palem", "pohon", "tanaman"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("osisi nkwụ"),
            keywords: &["nkwụ", "osisi"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("pálmatré"),
            keywords: &["pálmatré", "pálmi", "tré"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("palma"),
            keywords: &["albero", "palma"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ヤシの木"),
            keywords: &["ヤシ", "ヤシの木", "木"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("wit kambil"),
            keywords: &["kambil", "wit"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("პალმა"),
            keywords: &["მცენარე", "პალმა", "ხე"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("tazdayt"),
            keywords: &["tazdayt"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("пальма"),
            keywords: &["ағаш", "пальма", "өсімдік"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("palme"),
            keywords: &["palme", "palmetræ"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ដើមដ\u{17bc}ង"),
            keywords: &["ដ\u{17bc}ង", "ដើមឈើ", "ដើមដ\u{17bc}ង", "ត\u{17d2}នោត"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ತಾಳ\u{cc6} ಮರ"),
            keywords: &["ತಾಳ\u{cc6}", "ತಾಳ\u{cc6} ಮರ", "ಪಾಮ\u{ccd} ಟ\u{ccd}ರೀ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("야자수"),
            keywords: &["나무", "야자수", "열대 나무"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("भिल\u{94d}लाच\u{947}\u{902} झाड"),
            keywords: &["झाड", "भिल\u{94d}ल", "भिल\u{94d}लाच\u{947}\u{902} झाड"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("пальма дарагы"),
            keywords: &["дарак", "пальма", "пальма дарагы"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Palm"),
            keywords: &["Bam", "Palm"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຕ\u{ebb}\u{ec9}ນປາມ"),
            keywords: &["ຕ\u{ebb}\u{ec9}ນປາມ", "ຕ\u{ebb}\u{ec9}ນໝາກພ\u{ec9}າວ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("palmė"),
            keywords: &["medis", "palmė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("palma"),
            keywords: &["augs", "koks", "palma"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("nīkau"),
            keywords: &["nīkau", "rākau"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("палма"),
            keywords: &["дрво", "палма", "растение"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പന"),
            keywords: &["പന", "മരം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("дал мод"),
            keywords: &["дал", "мод", "ургамал"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ताडाच\u{947} झाड"),
            keywords: &["झाड", "ताडाच\u{947} झाड", "पाम", "पाम व\u{943}क\u{94d}ष"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("pokok palma"),
            keywords: &["palma", "pokok"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("siġra tal-palm"),
            keywords: &["palm", "siġra", "siġra tal-palm"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ထန\u{103a}းပင\u{103a}"),
            keywords: &["ထန\u{103a}းပင\u{103a}", "သစ\u{103a}ပင\u{103a}"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("palme"),
            keywords: &["palme", "palmetre", "tre"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("खज\u{941}रको र\u{942}ख"),
            keywords: &[
                "खज\u{941}र",
                "खज\u{941}रको र\u{942}ख",
                "बिर\u{942}वा",
                "र\u{942}ख",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("palmboom"),
            keywords: &["boom", "palm", "palmboom"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("palme"),
            keywords: &["palme", "palmetre", "tre"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ତ\u{b3e}ଳ ଗଛ"),
            keywords: &["ଗଛ", "ତ\u{b3e}ଳ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਤਾੜ"),
            keywords: &[
                "ਤਾੜ",
                "ਪਾਮ",
                "ਪਾਮ ਦ\u{a47} ਰ\u{a41}\u{a71}ਖ",
                "ਰ\u{a41}\u{a71}ਖ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کھجور دا درخت"),
            keywords: &["درخت", "کھجور دا درخت", "ہتھ دا سیدھا رخ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Pám Tri"),
            keywords: &["Pam", "Pám Tri", "Tri"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("palma"),
            keywords: &["drzewo", "palma"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د خجورې ونه"),
            keywords: &["خجوره، ونه", "د خجورې ونه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("palmeira"),
            keywords: &["palmeira", "árvore"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("palmeira"),
            keywords: &["palma", "palmeira", "planta", "árvore"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("chunta"),
            keywords: &["chunta", "sach’a"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("palmier"),
            keywords: &["copac", "palmier"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-249"),
            keywords: &["E10-249"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("пальма"),
            keywords: &["дерево", "пальма"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("igiti cy’umukindo"),
            keywords: &["cy’umukindo", "igiti"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("کجي جو وڻ"),
            keywords: &["کجي جو وڻ", "کجي، وڻ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ත\u{dcf}ල ගස"),
            keywords: &["ගස", "ත\u{dcf}ල", "පැළය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("palma"),
            keywords: &["palma", "rastlina", "strom"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("palma"),
            keywords: &["drevo", "palma", "rastlina"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("geed timir"),
            keywords: &["geed", "timir"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("palmë"),
            keywords: &["bimë", "palmë", "pemë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("палма"),
            keywords: &["дрво", "палма"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["палма"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("palma"),
            keywords: &["drvo", "palma"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["palma"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("palm"),
            keywords: &["palm", "träd"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mnazi"),
            keywords: &["mmea", "mnazi", "mti"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பனை மரம\u{bcd}"),
            keywords: &[
                "கடற\u{bcd}கரை",
                "கேளிக\u{bcd}கை",
                "பனை மரம\u{bcd}",
                "மரம\u{bcd}",
                "விடுமுறை",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("త\u{c3e}ట\u{c3f} చ\u{c46}ట\u{c4d}టు"),
            keywords: &[
                "చ\u{c46}ట\u{c4d}టు",
                "త\u{c3e}ట\u{c3f} చ\u{c46}ట\u{c4d}టు",
                "మ\u{c4a}క\u{c4d}క",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("дарахти нахл"),
            keywords: &["дарахт", "дарахти нахл", "нахл"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ต\u{e49}นมะพร\u{e49}าว"),
            keywords: &["ต\u{e49}นปาล\u{e4c}ม", "ต\u{e49}นมะพร\u{e49}าว"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("palma agajy"),
            keywords: &["agaç", "palma", "palma agajy"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fuʻu niu"),
            keywords: &["fuʻu niu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("palmiye ağacı"),
            keywords: &["ağaç", "palmiye", "palmiye ağacı"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("پالما"),
            keywords: &["دەرەخ", "پالما"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("пальма"),
            keywords: &["дерево", "пальма", "рослина"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("پام کا درخت"),
            keywords: &["درخت", "پام", "پام کا درخت", "پودا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("palma daraxti"),
            keywords: &["daraxt", "palma", "palma daraxti"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("cây cọ"),
            keywords: &["cây", "cây cọ"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("garabu-tiir"),
            keywords: &["garabu", "garabu-tiir", "tiir"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umthi wesundu"),
            keywords: &["isundu", "umthi", "umthi wesundu"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ọpẹ"),
            keywords: &["igi", "Ọpẹ", "ọpẹ"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("棕櫚樹"),
            keywords: &["棕櫚", "棕櫚樹", "樹"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("棕榈树"),
            keywords: &["树", "棕榈", "棕榈树"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("棕榈树"),
            keywords: &["棕榈树"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("棕櫚樹"),
            keywords: &["棕櫚樹", "樹"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isundu"),
            keywords: &["isihlahla", "isitshalo", "isundu"],
        },
    ],
};
#[doc = "🌵"]
pub const CACTUS: crate::Emoji = crate::Emoji {
    glyph: "🌵",
    codepoint: "1F335",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "cactus",
    group: "Animals & Nature",
    subgroup: "plant-other",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("kaktus"),
            keywords: &["kaktus", "plant"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ቁልቋል"),
            keywords: &["ቁልቋል", "ተክል"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("صبار"),
            keywords: &["صبار", "نبات"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("কেক\u{9cd}ট\u{9be}ছ"),
            keywords: &["উদ\u{9cd}ভিদ", "কেক\u{9cd}ট\u{9be}ছ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kaktus"),
            keywords: &["bitki", "kaktus"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("кактус"),
            keywords: &["кактус", "расліна"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("кактус"),
            keywords: &["кактус", "растение"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ক\u{9cd}য\u{9be}কট\u{9be}স"),
            keywords: &["ক\u{9cd}য\u{9be}কট\u{9be}স", "গ\u{9be}ছ"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kaktuz"),
            keywords: &["kaktuz", "plant"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("kaktus"),
            keywords: &["biljka", "kaktus"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cactus"),
            keywords: &["cactus", "planta"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄇\u{11133}𑄠𑄇\u{11134}𑄑𑄌\u{11134}"),
            keywords: &["𑄇\u{11133}𑄠𑄇\u{11134}𑄑𑄌\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᎵᎡᏍᎩ"),
            keywords: &["ᎤᎵᎡᏍᎩ", "ᎦᎪᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("kaktus"),
            keywords: &["kaktus", "rostlina"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cactws"),
            keywords: &["cactws", "planhigyn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kaktus"),
            keywords: &["kaktus", "kaktusplante", "plante"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Kaktus"),
            keywords: &["Kaktus", "Pflanze"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κάκτος"),
            keywords: &["κάκτος", "φυτό"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("cactus"),
            keywords: &["cactus", "plant"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cactus"),
            keywords: &["cactus", "planta"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kaktus"),
            keywords: &["kaktus", "taim"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("kaktusa"),
            keywords: &["kaktusa", "landare"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کاکتوس"),
            keywords: &["کاکتوس", "گیاه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kaktus"),
            keywords: &["kaktus", "kasvi"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("cactus"),
            keywords: &["cactus", "disyerto", "halaman"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("kaktus"),
            keywords: &["kaktus", "planta"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("cactus"),
            keywords: &["cactus", "plante"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cachtas"),
            keywords: &["cachtas", "planda"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cactas"),
            keywords: &["cactas", "flùr", "lus"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cacto"),
            keywords: &["cacto", "planta"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ક\u{ac7}ક\u{acd}ટસ"),
            keywords: &["ક\u{ac7}ક\u{acd}ટસ", "છોડ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kyarana"),
            keywords: &["kyarana", "shuke"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("קקטוס"),
            keywords: &["מדבר", "צמח", "קוצים", "קוצני", "קקטוס"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("क\u{948}क\u{94d}टस"),
            keywords: &["क\u{948}क\u{94d}टस", "पौधा"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("kaktus"),
            keywords: &["biljka", "kaktus"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("kaktusz"),
            keywords: &["kaktusz", "növény"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կակտուս"),
            keywords: &["բույս", "կակտուս"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kaktus"),
            keywords: &["kaktus", "tanaman"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("kaktus"),
            keywords: &["kaktus", "osisi"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kaktus"),
            keywords: &["kaktus", "planta"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("cactus"),
            keywords: &["cactus", "pianta"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("サボテン"),
            keywords: &["サボテン", "植物"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kaktus"),
            keywords: &["kaktus", "tanduran"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("კაქტუსი"),
            keywords: &["კაქტუსი", "მცენარე"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("Tasiɣawt"),
            keywords: &["Tasiɣawt"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("кактус"),
            keywords: &["кактус", "өсімдік"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("kaktus"),
            keywords: &["kaktus", "kaktusplante", "plante"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ដើមដ\u{17c6}បងយក\u{17d2}ស"),
            keywords: &["ដើម", "ដើមដ\u{17c6}បងយក\u{17d2}ស", "ដ\u{17c6}បងយក\u{17d2}ស"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕಳ\u{ccd}ಳ\u{cbf}"),
            keywords: &[
                "ಕಳ\u{ccd}ಳ\u{cbf}",
                "ಕ\u{ccd}ಯಾಕ\u{ccd}ಟಸ\u{ccd}",
                "ಸಸ\u{ccd}ಯ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("선인장"),
            keywords: &["나무", "선인장", "식물"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("निवलकाणी"),
            keywords: &["निवलकाणी", "वनस\u{94d}पत"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кактус"),
            keywords: &["кактус", "өсүмдүк"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Kaktus"),
            keywords: &["Kaktus", "Planz"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຕ\u{ebb}\u{ec9}ນໜາມ"),
            keywords: &["ຕ\u{ebb}\u{ec9}ນໜາມ", "ພ\u{eb7}ດ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("kaktusas"),
            keywords: &["augalas", "kaktusas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("kaktuss"),
            keywords: &["augs", "kaktuss"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tātā tiotio"),
            keywords: &["tipu", "tātā tiotio"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("кактус"),
            keywords: &["кактус", "растение"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കള\u{d4d}ളിമ\u{d41}ൾച\u{d4d}ചെടി"),
            keywords: &[
                "കള\u{d4d}ളിച\u{d4d}ചെടി",
                "കള\u{d4d}ളിമ\u{d41}ൾച\u{d4d}ചെടി",
                "ചെടി",
                "മര\u{d41}ച\u{d4d}ചെടി",
                "മര\u{d41}ഭ\u{d42}മി",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("кактус"),
            keywords: &["кактус", "ургамал"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("निवड\u{941}\u{902}ग"),
            keywords: &["निवड\u{941}\u{902}ग", "वनस\u{94d}पती"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kaktus"),
            keywords: &["kaktus", "tumbuhan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("kaktus"),
            keywords: &["kaktus", "pjanta"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ရ\u{103e}ားစောင\u{103a}းပင\u{103a}"),
            keywords: &["ရ\u{103e}ားစောင\u{103a}းပင\u{103a}", "အပင\u{103a}"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kaktus"),
            keywords: &["kaktus", "plante"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("सिउ\u{901}डी"),
            keywords: &["बिर\u{942}वा", "सिउ\u{901}डी"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("cactus"),
            keywords: &["cactus", "plant"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kaktus"),
            keywords: &["kaktus", "plante"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ନ\u{b3e}ଗଫେଣୀ"),
            keywords: &["ଗଛ", "ନ\u{b3e}ଗଫେଣୀ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਨਾਗਫਨੀ"),
            keywords: &["ਨਾਗਫਨੀ", "ਬ\u{a42}ਟਾ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ناگ پھنی"),
            keywords: &["بوٹا", "ناگ پھنی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Káktọ\u{301}s Plant"),
            keywords: &["Káktọs", "Káktọ\u{301}s Plant", "Plant"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kaktus"),
            keywords: &["kaktus", "roślina"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("کیکټس"),
            keywords: &["کيکټس، بوټی", "کیکټس"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("cacto"),
            keywords: &["cacto", "planta"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cato"),
            keywords: &["cato", "planta"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("kisqa"),
            keywords: &["kisqa", "mallki"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("cactus"),
            keywords: &["cactus", "plantă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-250"),
            keywords: &["E10-250"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("кактус"),
            keywords: &["зеленое", "кактус", "колючки", "растение"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("kagitusi"),
            keywords: &["ikimera", "kagitusi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ٿوهر"),
            keywords: &["ٻوٽو", "ٿوهر"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("පතොක\u{dca}"),
            keywords: &["පතොක\u{dca}", "පැළය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("kaktus"),
            keywords: &["kaktus", "rastlina"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("kaktus"),
            keywords: &["kaktus", "rastlina"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("tiin"),
            keywords: &["dhir", "tiin"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kaktus"),
            keywords: &["bimë", "kaktus"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("кактус"),
            keywords: &["биљкa", "кактус"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("kaktus"),
            keywords: &["biljka", "kaktus"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("kaktus"),
            keywords: &["kaktus", "växt"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("dungusi kakati"),
            keywords: &["dungusi kakati", "mmea"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கற\u{bcd}ற\u{bbe}ழை"),
            keywords: &["கற\u{bcd}ற\u{bbe}ழை", "கள\u{bcd}ளி", "ப\u{bbe}லைவனம\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("బ\u{c4d}రహ\u{c4d}మజ\u{c46}ముడు"),
            keywords: &[
                "న\u{c3e}గద\u{c3e}ళ\u{c3f} చ\u{c46}ట\u{c4d}టు",
                "బ\u{c4d}రహ\u{c4d}మజ\u{c46}ముడు",
                "ముళ\u{c4d}ల చ\u{c46}ట\u{c4d}టు",
                "మ\u{c4a}క\u{c4d}క",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("гули ханҷарӣ"),
            keywords: &["гули ханҷарӣ", "растанӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ตะบองเพชร"),
            keywords: &["ตะบองเพชร", "พ\u{e37}ช"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("kaktus"),
            keywords: &["kaktus", "ösümlik"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kakatisi"),
            keywords: &["kakatisi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kaktüs"),
            keywords: &["bitki", "kaktüs"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("كاكتۇس"),
            keywords: &["ئۆسۈملۈك", "كاكتۇس"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("кактус"),
            keywords: &["кактус", "рослина"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کیکٹس"),
            keywords: &["پودا", "کیکٹس"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kaktus"),
            keywords: &["kaktus", "o‘simlik"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("cây xương rồng"),
            keywords: &["cây xương rồng", "thực vật"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("gargamboose"),
            keywords: &["garab", "gargamboose"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-cactus"),
            keywords: &["i-cactus", "isityalo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Igi Ọrọ\u{301}"),
            keywords: &["Igi Ọrọ\u{301}", "õgbìn"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("仙人掌"),
            keywords: &["仙人掌", "植物"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("仙人掌"),
            keywords: &["仙人掌", "植物"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("仙人掌"),
            keywords: &["仙人掌", "沙漠"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("仙人掌"),
            keywords: &["仙人掌", "多肉植物"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["仙人掌", "植物"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("i-cactus"),
            keywords: &["i-cactus", "isitshalo"],
        },
    ],
};
#[doc = "🌾"]
pub const SHEAF_OF_RICE: crate::Emoji = crate::Emoji {
    glyph: "🌾",
    codepoint: "1F33E",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "sheaf of rice",
    group: "Animals & Nature",
    subgroup: "plant-other",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("rysgerf"),
            keywords: &["gerf", "plant", "rys", "rysgerf"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የሩዝ ተክል ዞላ"),
            keywords: &["ሩዝ", "ተክል", "የሩዝ ተክል ዞላ", "ጆሮ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}حزمة من الأرز"),
            keywords: &["سنبلة أرز", "\u{202b}حزمة من الأرز"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ধ\u{9be}নৰ চিৰ\u{9be}"),
            keywords: &[
                "কৰ\u{9cd}ণ",
                "চ\u{9be}উল",
                "ধ\u{9be}ন",
                "ধ\u{9be}নৰ চিৰ\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("düyü sünbülü"),
            keywords: &["bitki", "düyü", "düyü sünbülü", "qulaq"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("колас рыса"),
            keywords: &["зерне", "колас", "колас рыса", "расліна", "рыс"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("оризов клас"),
            keywords: &["клас", "ориз", "оризов клас", "растение"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ধ\u{9be}নের আ\u{981}টি"),
            keywords: &["গ\u{9be}ছ", "ধ\u{9be}ন", "ধ\u{9be}নের আ\u{981}টি", "শীষ"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("plant riz"),
            keywords: &["plant", "riz"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("snop riže"),
            keywords: &["biljka", "riža", "snop", "snop riže", "zrno"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("espiga d’arròs"),
            keywords: &["arròs", "espiga", "espiga d’arròs"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏍᏓᏴᏓᏅ Ꮎ ᏓᎵᏆ"),
            keywords: &["ᎠᏍᏓᏴᏓᏅ Ꮎ ᏓᎵᏆ", "ᎤᎦᏔᏛᏅᎢ", "ᎦᎴᏂ", "ᏓᎵᏆ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("rýžové klasy"),
            keywords: &[
                "klas",
                "obilí",
                "otep",
                "rostlina",
                "rýže",
                "rýžové klasy",
                "snop",
                "zrno",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("ysgub o reis"),
            keywords: &["gronyn", "planhigyn", "reis", "ysgub o reis"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("risplante"),
            keywords: &["ris", "risplante"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Reisähre"),
            keywords: &["Pflanze", "Reis", "Reisähre", "Ähre"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("όρυζα"),
            keywords: &["ρύζι", "φυτό", "όρυζα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("sheaf of rice"),
            keywords: &["ear", "grain", "rice", "sheaf of rice"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("ear of rice"),
            keywords: &["ear of rice", "grain", "rice", "sheaf"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("sheaf of rice"),
            keywords: &["ear", "grain", "rice", "sheaf", "sheaf of rice"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("espiga de arroz"),
            keywords: &["arroz", "espiga", "espiga de arroz", "planta"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("riisitaim"),
            keywords: &["riis", "riisitaim", "taim", "vihk"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("arroz-zurtointxoak"),
            keywords: &["arroz", "arroz-zurtointxoak", "landare", "pikor"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("خوشه برنج"),
            keywords: &["برنج", "خوشه", "دسته", "گیاه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("riisikasvi"),
            keywords: &["kasvi", "riisi", "riisikasvi", "tähkä"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("bigkis ng palay"),
            keywords: &[
                "agrikultura",
                "ani",
                "bigas",
                "bigkis ng palay",
                "pagkain",
                "palay",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("ríshólgi"),
            keywords: &["hólgi", "rís", "ríshólgi"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("plant de riz"),
            keywords: &["plant de riz", "riz"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["plant", "plant de riz", "riz"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("punann ríse"),
            keywords: &["dias", "grán", "punann ríse", "rís"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("dias rìs"),
            keywords: &["dias", "gràinnean", "rìs"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("planta de arroz"),
            keywords: &["arroz", "cereais", "planta", "planta de arroz"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ડા\u{a82}ગર"),
            keywords: &["ચોખા", "ડા\u{a82}ગર", "ડ\u{ac2}\u{a82}ડ\u{ac1}"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("damin shinkafa"),
            keywords: &["damin shinkafa", "hatsi", "shinkafa", "zangarniya"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("שיבולי אורז"),
            keywords: &["אורז", "צמח", "שיבולי אורז", "שיבולים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("चावल का पौधा"),
            keywords: &["चावल", "चावल का पौधा", "चावल की बाली", "बाली"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("klas riže"),
            keywords: &["biljka", "klas", "klas riže", "riža"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("rizs"),
            keywords: &["növény", "rizs"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բրնձի հասկեր"),
            keywords: &["ականջ", "բույս", "բրինձ", "բրնձի հասկեր"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("seikat padi"),
            keywords: &["bulir", "nasi", "seikat padi", "tanaman"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ngwù nke òsikapa"),
            keywords: &["mkpụrụ", "ngwù nke òsikapa", "nti", "osikapa"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hrísgrjónaplanta"),
            keywords: &["ax", "hrísgrjón", "hrísgrjónaax", "hrísgrjónaplanta"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("pianta di riso"),
            keywords: &["pianta di riso", "riso", "spiga", "spiga di riso"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("稲"),
            keywords: &["ススキ", "稲", "稲穂", "草"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("pari saiket"),
            keywords: &["gandum", "kuping", "pari", "pari saiket"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ბრინჯის კონა"),
            keywords: &["ბრინჯი", "ბრინჯის კონა", "მცენარე", "ყური"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("taceṛṛaft n ṛṛuz"),
            keywords: &["taceṛṛaft n ṛṛuz"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("күріш бұтақтары"),
            keywords: &["күріш", "күріш бұтақтары", "құлақ", "өсімдік"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("risplante"),
            keywords: &["ris", "risplante"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("កណ\u{17d2}ដាប\u{17cb}ស\u{17d2}រ\u{17bc}វ"),
            keywords: &[
                "កណ\u{17d2}ដាប\u{17cb}ស\u{17d2}រ\u{17bc}វ",
                "ក\u{17bd}រ",
                "គ\u{17d2}រាប\u{17cb}",
                "ស\u{17d2}រ\u{17bc}វ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಭತ\u{ccd}ತದ ತ\u{cc6}ನ\u{cc6}"),
            keywords: &["ಧಾನ\u{ccd}ಯ", "ಭತ\u{ccd}ತದ ತ\u{cc6}ನ\u{cc6}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("벼"),
            keywords: &["벼", "벼이삭", "이삭"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("भाताच\u{947}\u{902} कणस"),
            keywords: &[
                "कान",
                "ता\u{902}द\u{941}ळ",
                "धान\u{94d}य",
                "भाताच\u{947}\u{902} कणस",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("бир боо күрүч"),
            keywords: &["бир боо күрүч", "күрүч", "өсүмдүк"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Räishallem"),
            keywords: &["Hallem", "Kär", "Räis", "Räishallem"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຮວງເຂ\u{ebb}\u{ec9}າ"),
            keywords: &[
                "ຕ\u{ebb}\u{ec9}ນເຂ\u{ebb}\u{ec9}າ",
                "ຮວງ",
                "ຮວງເຂ\u{ebb}\u{ec9}າ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("ryžių pėdas"),
            keywords: &["augalas", "ryžiai", "ryžių pėdas", "varpa"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("rīsa augs"),
            keywords: &["augs", "rīsa augs", "rīsi"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kākati raihi"),
            keywords: &["kākati raihi", "pata", "puku", "raihi"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("сноп ориз"),
            keywords: &["ориз", "растение", "сноп"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("നെൽക\u{d4d}കതിർ"),
            keywords: &[
                "അരി",
                "കതിർ",
                "ഞ\u{d3e}റ\u{d4d}",
                "നെല\u{d4d}ല\u{d4d}",
                "നെൽക\u{d4d}കതിർ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("будааны тариан түрүү"),
            keywords: &["будаа", "будааны тариан түрүү", "тариан түрүү", "үр ургац"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ता\u{902}दळाची प\u{947}\u{902}ढी"),
            keywords: &[
                "कणीस",
                "ता\u{902}दळाची प\u{947}\u{902}ढी",
                "ता\u{902}द\u{941}ळ",
                "धान\u{94d}य",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("seberkas padi"),
            keywords: &["padi", "seberkas padi", "telinga", "tumbuhan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("għarma ross"),
            keywords: &["għarma ross", "qamħ", "ross", "widna"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ကောက\u{103a}န\u{103e}\u{1036}ပင\u{103a}"),
            keywords: &[
                "ကောက\u{103a}န\u{103e}\u{1036}ပင\u{103a}",
                "ဆန\u{103a}",
                "အဆန\u{103a}",
                "အန\u{103e}\u{1036}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("risplante"),
            keywords: &["aks", "plante", "ris", "risplante", "siv", "strå"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("चामलको सिफ"),
            keywords: &["कान", "चामल", "चामलको सिफ", "बिर\u{942}वा"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("rijstplant"),
            keywords: &["aar", "graan", "rijst", "rijstplant"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("risplante"),
            keywords: &["aks", "plante", "ris", "risplante", "siv", "strå"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଧ\u{b3e}ନ କଳେଇ"),
            keywords: &[
                "କେଣ\u{b4d}ଡ\u{b3e}",
                "ଧ\u{b3e}ନ",
                "ଧ\u{b3e}ନ କଳେଇ",
                "ଧ\u{b3e}ନ ଗଛ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਝ\u{a4b}ਨਾ"),
            keywords: &[
                "ਚ\u{a4c}ਲ",
                "ਚ\u{a4c}ਲ ਦਾ ਸਿ\u{a71}ਟਾ",
                "ਝ\u{a4b}ਨਾ",
                "ਸਿ\u{a71}ਟਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("چولاں دا پلندہ"),
            keywords: &["بیج", "چول", "چولاں دا پلندہ", "کان"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Rais Bọ\u{301}ndul"),
            keywords: &[
                "Gren",
                "Rais",
                "Rais Bọ\u{301}ndul",
                "Sid",
                "Tọ\u{301}p Pát Ọf Gren Wiá Sid Dè",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("pędy ryżu"),
            keywords: &["pędy ryżu", "roślina", "ryż"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("شولې"),
            keywords: &["شولې", "غوږ، دانه، وريجې، شولې"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("planta de arroz"),
            keywords: &["arroz", "espiga", "espiga de arroz", "planta de arroz"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("feixe de arroz"),
            keywords: &["arroz", "espiga", "feixe de arroz", "planta"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("pʼanqa arrozmanta"),
            keywords: &["arroz", "muru", "ninri", "pʼanqa arrozmanta"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("snop de orez"),
            keywords: &["cereală", "snop", "snop de orez", "spic"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-259"),
            keywords: &["E10-259"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("колос"),
            keywords: &["зерно", "колос", "рис"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikibabi cy’umuceri"),
            keywords: &["ikibabi cy’umuceri", "impeke", "ugutwi", "umuceri"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("چانور جو پلندو"),
            keywords: &["چانور جو پلندو", "ڪن، چانور، اناج"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ගොයම\u{dca} පඳ\u{dd4}ර"),
            keywords: &[
                "ගොයම\u{dca} පඳ\u{dd4}ර",
                "ධ\u{dcf}න\u{dca}\u{200d}ය",
                "පැළය",
                "බත\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("snop ryže"),
            keywords: &["klas", "rastlina", "ryža", "snop ryže"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("snop riža"),
            keywords: &["klas", "rastlina", "riž", "snop riža"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("geedka bariiska"),
            keywords: &["dhag", "geed bariis", "geedka bariiska", "haruur"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kapule orizi"),
            keywords: &["bimë", "kalli", "kapule orizi", "oriz"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("сноп пиринча"),
            keywords: &["житарица", "клас", "пиринач", "сноп пиринча"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("сноп риже"),
            keywords: &["сноп риже"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("snop pirinča"),
            keywords: &["klas", "pirinač", "snop pirinča", "žitarica"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("snop riže"),
            keywords: &["snop riže"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("risax"),
            keywords: &["planta", "ris", "risax", "risplanta"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("shada la mchele"),
            keywords: &["mchele", "mmea", "shada la mchele", "sikio"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("நெற\u{bcd}கதிர\u{bcd}"),
            keywords: &["அரிசி", "அறுவடை", "நெற\u{bcd}கதிர\u{bcd}", "வயல\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("వర\u{c3f} పన"),
            keywords: &["వర\u{c3f} పన", "వర\u{c3f} మ\u{c4a}క\u{c4d}క"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("дарзаи биринҷ"),
            keywords: &["биринҷ", "гӯш", "дарзаи биринҷ", "дона"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("รวงข\u{e49}าว"),
            keywords: &["ต\u{e49}นข\u{e49}าว", "รวงข\u{e49}าว"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("şaly"),
            keywords: &["dänen", "hoşa", "tüwi", "şaly"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("haʻinga laise"),
            keywords: &["haʻinga laise"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("pirinç bitkisi"),
            keywords: &["başak", "pirinç", "pirinç başağı", "pirinç bitkisi"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("شال"),
            keywords: &["دان", "شال", "قۇلاق", "گۈرۈچ"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("сніпок рису"),
            keywords: &["колос", "рис", "рисовий колосок", "рослина", "сніпок рису"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("چاولوں کا گٹھا"),
            keywords: &["پودا", "چاول", "چاولوں کا گٹھا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("sholi poyasi"),
            keywords: &["boshoq", "guruch", "o‘simlik", "sholi poyasi"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bó lúa"),
            keywords: &["bó lúa", "bông lúa", "gạo", "thực vật"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("sayu ceeb"),
            keywords: &["ceeb", "nopp", "pepp", "sayu ceeb"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isithungu serayisi"),
            keywords: &["indlebe", "inkozo", "irayisi", "isithungu serayisi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Idi Ti Irẹsi"),
            keywords: &["Etí", "Idi Ti Irẹsi", "Irẹsi", "ọkà"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("禾束"),
            keywords: &["禾束", "穀物", "穗", "米"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("禾束"),
            keywords: &["禾束", "穗", "米", "谷物"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("稻子"),
            keywords: &["稻", "稻子", "米", "粮食"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("水稻"),
            keywords: &["水稻", "稻子"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("稻穗"),
            keywords: &["稻穗", "穀物"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("uhlamvu lwelayisi"),
            keywords: &[
                "ilayisi",
                "indlebe",
                "isitshalo",
                "uhlamvu",
                "uhlamvu lwelayisi",
            ],
        },
    ],
};
#[doc = "🌿"]
pub const HERB: crate::Emoji = crate::Emoji {
    glyph: "🌿",
    codepoint: "1F33F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "herb",
    group: "Animals & Nature",
    subgroup: "plant-other",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("krui"),
            keywords: &["blaar", "krui", "kruie", "plant"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ቅጠል"),
            keywords: &["ቅጠል", "ተክል"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("عشب"),
            keywords: &["عشب", "ورق"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ঔষধি"),
            keywords: &["ঔষধি", "প\u{9be}ত"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("dərman bitkisi"),
            keywords: &["bitki", "dərman bitkisi", "yarpaq"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("лекавая трава"),
            keywords: &["лекавая трава", "лекавы", "ліст", "расліна"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("билка"),
            keywords: &["билка", "лист", "растение"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ঔষধি"),
            keywords: &["ঔষধি", "গ\u{9be}ছ", "প\u{9be}ত\u{9be}"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("louzaouenn"),
            keywords: &["delienn", "louzaouenn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("ljekovita biljka"),
            keywords: &["bijka", "list", "ljekovita biljka"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("herba"),
            keywords: &["fulla", "herba", "planta"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᎿᏍᏕᎳ"),
            keywords: &["ᎤᎦᎶᎦ", "ᎤᎿᏍᏕᎳ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("bylina"),
            keywords: &["bylina", "bylinka", "list", "lístek", "rostlina"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("llysieuyn"),
            keywords: &["deilen", "llysieuyn", "planhigyn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("urt"),
            keywords: &["blade", "urt"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Kräuter"),
            keywords: &["Blätter", "Kräuter"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("βότανο"),
            keywords: &["βότανο", "φυτό", "φύλλο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("herb"),
            keywords: &["herb", "leaf"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("hierba"),
            keywords: &["hierba", "hoja", "verde"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("maitsetaim"),
            keywords: &["leht", "maitsetaim", "taim"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("belarra"),
            keywords: &["belarra", "hosto", "landare"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("گیاه دارویی"),
            keywords: &["برگ", "گیاه", "گیاه دارویی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("yrtti"),
            keywords: &["kasvi", "lehti", "yrtti"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("halamang-gamot"),
            keywords: &["dahon", "gamot", "halaman", "halamang-gamot", "herb"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("urt"),
            keywords: &["planta", "urt"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("feuille"),
            keywords: &["feuille", "plante"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("luibh"),
            keywords: &["duilleog", "luibh"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("luibh"),
            keywords: &["duilleag", "luibh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("planta"),
            keywords: &["follas", "planta"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("જડીબ\u{ac1}ટ\u{acd}ટી"),
            keywords: &["જડીબ\u{ac1}ટ\u{acd}ટી", "પર\u{acd}ણ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("ganye"),
            keywords: &["ganye"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("צמח תבלין"),
            keywords: &["גבעול", "עלה", "ענף", "צמח", "צמח תבלין"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("जड\u{93c}ी–ब\u{942}टी, पत\u{94d}ती"),
            keywords: &[
                "जड\u{93c}ी–ब\u{942}टी",
                "जड\u{93c}ी–ब\u{942}टी, पत\u{94d}ती",
                "पत\u{94d}ती",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("biljka"),
            keywords: &["biljka", "list"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("gyógynövény"),
            keywords: &["gyógynövény", "levél", "növény"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("խոտաբույս"),
            keywords: &["բույս", "խոտաբույս", "տերև"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("herba"),
            keywords: &["daun", "herba", "tanaman"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("mgbọrọgwụ\u{300}"),
            keywords: &["akwụkwọnri", "mgbọrọgwụ\u{300}"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kryddjurt"),
            keywords: &["krydd", "kryddjurt", "lauf"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("pianta"),
            keywords: &["foglia", "pianta"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ハーブ"),
            keywords: &["ハーブ", "草", "葉", "薬草"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("jamu"),
            keywords: &["godhong", "jamu"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სამკურნალო მცენარე"),
            keywords: &["მცენარე", "სამკურნალო მცენარე", "ფოთოლი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("ifer"),
            keywords: &["ifer"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("шөп"),
            keywords: &["жапырақ", "шөп", "өсімдік"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("urt"),
            keywords: &["blade", "urt"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ជ\u{17b8}រ"),
            keywords: &["ជ\u{17b8}រ", "ស\u{17d2}ល\u{17b9}ក"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮ\u{cc2}ಲ\u{cbf}ಕ\u{cc6}"),
            keywords: &["ಎಲ\u{cc6}", "ಮ\u{cc2}ಲ\u{cbf}ಕ\u{cc6}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("풀"),
            keywords: &["잎", "잎사귀", "풀"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("रोप"),
            keywords: &["पान", "रोप"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("чөп"),
            keywords: &["жалбырак", "чөп"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Kräider"),
            keywords: &["Blat", "Kräider"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ສະໝ\u{eb8}ນໄພ"),
            keywords: &["ສະໝ\u{eb8}ນໄພ", "ໃບໄມ\u{ec9}"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("žolelė"),
            keywords: &["lapas", "žolelė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("augs"),
            keywords: &["augs", "lapa"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("amiami"),
            keywords: &["amiami", "rau"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("билка"),
            keywords: &["билка", "лист", "растение"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഔഷധച\u{d4d}ചെടി"),
            keywords: &[
                "ആയ\u{d41}ർവേദം",
                "ഔഷധം",
                "ഔഷധച\u{d4d}ചെടി",
                "പച\u{d4d}ചില",
                "മര\u{d41}ന\u{d4d}ന\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("ургамал"),
            keywords: &["навч", "ургамал"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("औषधी वनस\u{94d}पती"),
            keywords: &["औषधी वनस\u{94d}पती", "पान\u{947}"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("herba"),
            keywords: &["daun", "herba"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ħwawar"),
            keywords: &["werqa", "ħwawar"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဆေးဖက\u{103a}ဝင\u{103a}အပင\u{103a}"),
            keywords: &["ဆေးဖက\u{103a}ဝင\u{103a}အပင\u{103a}", "အရ\u{103d}က\u{103a}"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("urteblader"),
            keywords: &["blader", "plante", "urt", "urteblader"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("जडीब\u{941}टी"),
            keywords: &["जडीब\u{941}टी", "पात", "बिर\u{942}वा"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("kruid"),
            keywords: &["blad", "kruid"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("urteblad"),
            keywords: &["blad", "plante", "urt", "urteblad"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଜଡ\u{b3c}\u{b3f} ବ\u{b41}ଟ\u{b3f}"),
            keywords: &["ଜଡ\u{b3c}\u{b3f} ବ\u{b41}ଟ\u{b3f}", "ପତ\u{b4d}ର"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਜੜ\u{a4d}ਹੀ-ਬ\u{a42}ਟੀ"),
            keywords: &[
                "ਜੜ\u{a42}ੀ-ਬ\u{a42}ਟੀ",
                "ਜੜ\u{a4d}ਹੀ-ਬ\u{a42}ਟੀ",
                "ਪ\u{a71}ਤਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("جڑی بوٹی"),
            keywords: &["بت\u{651}ا", "جڑی بوٹی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Hab Plant Wé De Mék Fud Swit"),
            keywords: &["Hab", "Hab Plant Wé De Mék Fud Swit", "Lif"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("zioło"),
            keywords: &["liście", "zioła", "zioło"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("بوټی"),
            keywords: &["بوټی", "بوټی، پاڼه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("erva"),
            keywords: &["erva", "folha"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("erva aromática"),
            keywords: &["erva aromática", "folha", "planta"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("qhura"),
            keywords: &["laqhi", "qhura"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("plantă aromatică"),
            keywords: &["plantă", "plantă aromatică"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-260"),
            keywords: &["E10-260"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("веточка"),
            keywords: &["веточка", "трава"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("icyatsi"),
            keywords: &["Ikibabi", "icyatsi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("جڙي ٻوٽيون"),
            keywords: &["جڙي ٻوٽيون", "پن"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ඔස\u{dd4} පැළය"),
            keywords: &["ඔස\u{dd4} පැළය", "පත\u{dca}\u{200d}රය", "පැළය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("bylina"),
            keywords: &["bylina", "bylinka", "list", "rastlina"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("zelišče"),
            keywords: &["list", "rastlina", "zelišče"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("geed"),
            keywords: &["caleen", "geed"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("erëza"),
            keywords: &["bimë", "erëza", "gjethe"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("биљка"),
            keywords: &["биљка", "лист"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["биљка"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("biljka"),
            keywords: &["biljka", "list"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["biljka"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("ört"),
            keywords: &["blad", "ört"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mimea ya msimu"),
            keywords: &["mimea ya msimu", "mmea", "tawi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மூலிகை"),
            keywords: &["இலைகள\u{bcd}", "செடி", "மருந\u{bcd}து", "மூலிகை"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మూల\u{c3f}క"),
            keywords: &["ఓషధ\u{c3f}", "గుల\u{c4d}మం", "మూల\u{c3f}క"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("алаф"),
            keywords: &["алаф", "барг"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("สม\u{e38}นไพร"),
            keywords: &["สม\u{e38}นไพร", "ใบไม\u{e49}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("dermanlyk ot"),
            keywords: &["dermanlyk ot", "ýaprak"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ʻakau faitoʻo"),
            keywords: &["ʻakau faitoʻo"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("ot"),
            keywords: &["ot", "yaprak"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئوت-چۆپ"),
            keywords: &["ئوت-چۆپ", "يوپۇرماق"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("лікарська рослина"),
            keywords: &["листок", "лікарська рослина", "рослина"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("جڑی بوٹی"),
            keywords: &["جڑی بوٹی", "پتا", "پودا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("o‘simlik"),
            keywords: &["barg", "o‘simlik"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("thảo mộc"),
            keywords: &["lá cây", "thảo mộc"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("ñax"),
            keywords: &["xob", "ñax"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isityalo"),
            keywords: &["igqabi", "isityalo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Egbo Igi"),
            keywords: &["Egbo Igi", "Ewéẹ"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("香草"),
            keywords: &["葉", "香草"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("香草"),
            keywords: &["叶", "香草"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("药草"),
            keywords: &["草药", "药草", "香草"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("草藥"),
            keywords: &["植物", "草藥", "葉子", "香草"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("草本植物"),
            keywords: &["九層塔", "牛至草", "羅勒", "草本植物", "香草"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("iqabunga"),
            keywords: &["iqabunga", "isitshalo"],
        },
    ],
};
#[doc = "☘\u{fe0f}"]
pub const SHAMROCK: crate::Emoji = crate::Emoji {
    glyph: "☘\u{fe0f}",
    codepoint: "2618 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "shamrock",
    group: "Animals & Nature",
    subgroup: "plant-other",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "☘",
        codepoint: "2618",
        status: crate::Status::Unqualified,
        introduction_version: 1f32,
        name: "shamrock",
        group: "Animals & Nature",
        subgroup: "plant-other",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("klawer"),
            keywords: &["klawer", "plant"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሻምሮክ ቅጠል"),
            keywords: &["ሻምሮክ ቅጠል", "ተክል"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("نبات النفل"),
            keywords: &["نبات", "نبات النفل"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("শ\u{9cd}ব\u{9be}মৰক"),
            keywords: &["উদ\u{9cd}ভিদ", "শ\u{9cd}ব\u{9be}মৰক"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("yonca"),
            keywords: &["bitki", "yonca"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("трыліснік"),
            keywords: &["расліна", "трыліснік"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("детелина"),
            keywords: &["детелина", "растение"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("শ\u{9be}মরক"),
            keywords: &["গ\u{9be}ছ", "শ\u{9be}মরক"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("melchon"),
            keywords: &["melchon", "plant"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("djetelina"),
            keywords: &["biljka", "djetelina"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("trèvol"),
            keywords: &["planta", "trèvol"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏧᎦᎶᎦ"),
            keywords: &["ᎦᎪᏗ", "ᏧᎦᎶᎦ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("trojlístek"),
            keywords: &["jetel", "rostlina", "trojlístek"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("samrog"),
            keywords: &["planhigyn", "samrog"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kløver"),
            keywords: &["kløver", "plante"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Kleeblatt"),
            keywords: &["Kleeblatt", "Pflanze"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("τριφύλλι"),
            keywords: &["τριφύλλι", "φυτό"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("shamrock"),
            keywords: &["plant", "shamrock"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("trébol"),
            keywords: &["planta", "trébol"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("ristik"),
            keywords: &["ristik", "taim"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("hirusta"),
            keywords: &["hirusta", "landare"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("برگ شبدر"),
            keywords: &["برگ شبدر", "گیاه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kolmiapila"),
            keywords: &["kasvi", "kolmiapila"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("shamrock"),
            keywords: &["dahon", "halaman", "shamrock"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("smæra"),
            keywords: &["planta", "smæra"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("trèfle"),
            keywords: &["plante", "trèfle"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("trèfle à trois feuilles"),
            keywords: &[
                "plante",
                "trois feuilles",
                "trèfle",
                "trèfle à trois feuilles",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("seamróg"),
            keywords: &["planda", "seamróg"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("seamrag"),
            keywords: &["flùr", "lus", "seamrag"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("trevo"),
            keywords: &["planta", "trevo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ત\u{acd}રિદલ પા\u{a82}દડાવાળો એક છોડ"),
            keywords: &[
                "છોડ",
                "ત\u{acd}રણ પર\u{acd}ણ",
                "ત\u{acd}રિદલ પા\u{a82}દડાવાળો એક છોડ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("shamrock"),
            keywords: &["shamrock", "shuke"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("תלתן"),
            keywords: &["עלה", "צמח", "תלתן"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("श\u{948}मरॉक"),
            keywords: &[
                "तीन पत\u{94d}तिया\u{902}",
                "पत\u{94d}ता",
                "पौधा",
                "श\u{948}मरॉक",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("djetelina"),
            keywords: &["biljka", "djetelina"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("lóhere"),
            keywords: &["lóhere", "növény"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("երեքնուկ"),
            keywords: &["բույս", "երեքնուկ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("shamrock"),
            keywords: &["shamrock", "tanaman"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("akwụkwọnri shamrock"),
            keywords: &["akwụkwọnri shamrock", "osisi"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("músarsmári"),
            keywords: &["músarsmári", "planta", "smári"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("trifoglio"),
            keywords: &["Irlanda", "foglia", "trifoglio"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("クローバー"),
            keywords: &["クローバー", "草", "葉"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("semanggi"),
            keywords: &["semanggi", "tanduran"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სამყურა"),
            keywords: &["მცენარე", "სამყურა"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("ikeffis"),
            keywords: &["ikeffis"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қоян саумалдық"),
            keywords: &["қоян саумалдық", "өсімдік"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("kløver"),
            keywords: &["kløver", "plante"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សាមរ\u{17c9}ក"),
            keywords: &["រ\u{17bb}ក\u{17d2}ខជាត\u{17b7}", "សាមរ\u{17c9}ក"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಶಾಮ\u{ccd}ರಾಕ\u{ccd}"),
            keywords: &["ಗ\u{cbf}ಡ", "ಶಾಮ\u{ccd}ರಾಕ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("토끼풀"),
            keywords: &["세잎", "토끼풀", "풀"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("श\u{945}मरॉक"),
            keywords: &["वनस\u{94d}पत", "श\u{945}मरॉक"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("беде"),
            keywords: &["беде", "өсүмдүк"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Kléi"),
            keywords: &["Kléi", "Planz"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ດອກແຊມຣ\u{eb1}ອກ"),
            keywords: &["ດອກແຊມຣ\u{eb1}ອກ", "ພ\u{eb7}ດ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("trilapis dobilas"),
            keywords: &["augalas", "trilapis dobilas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("āboliņa lapa"),
            keywords: &["lapa", "āboliņa lapa", "āboliņš"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("hamitoka"),
            keywords: &["hamitoka", "tipu"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("детелина"),
            keywords: &["детелина", "растение"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഷ\u{d3e}ംറോക\u{d4d}ക\u{d4d}"),
            keywords: &["ചെടി", "ഷ\u{d3e}ംറോക\u{d4d}ക\u{d4d}"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("айргана"),
            keywords: &["айргана", "ургамал"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("त\u{94d}रिदळी पाना\u{902}च\u{947} रोप"),
            keywords: &["त\u{94d}रिदळी पाना\u{902}च\u{947} रोप", "वनस\u{94d}पती"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("syamrok"),
            keywords: &["syamrok", "tumbuhan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("xamrok"),
            keywords: &["pjanta", "xamrok"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပ\u{1032}မျ\u{102d}\u{102f}းရင\u{103a}း အပင\u{103a}ငယ\u{103a}"),
            keywords: &[
                "ပ\u{1032}မျ\u{102d}\u{102f}းရင\u{103a}း အပင\u{103a}ငယ\u{103a}",
                "အပင\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("trekløver"),
            keywords: &["kløver", "plante", "trekløver"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("सामरक"),
            keywords: &["बिर\u{942}वा", "सामरक"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("klavertjedrie"),
            keywords: &["klavertjedrie", "plant"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("trekløver"),
            keywords: &["kløver", "plante", "trekløver"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ତ\u{b4d}ର\u{b3f}ପତ\u{b4d}ର ଉଦ\u{b4d}ଭ\u{b3f}ଦ"),
            keywords: &[
                "ଉଦ\u{b4d}ଭ\u{b3f}ଦ",
                "ତ\u{b4d}ର\u{b3f}ପତ\u{b4d}ର ଉଦ\u{b4d}ଭ\u{b3f}ଦ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸ\u{a3c}\u{a48}ਮਰ\u{a4c}ਕ"),
            keywords: &[
                "ਤਿ\u{a70}ਨ ਪ\u{a71}ਤਿਆ\u{a02} ਵਾਲੀ ਘਾਹ",
                "ਬ\u{a42}ਟਾ",
                "ਸ\u{a3c}\u{a48}ਮਰ\u{a4c}ਕ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("چ\u{650}یٹا لونگ"),
            keywords: &["بوٹا", "چ\u{650}یٹا لونگ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Shámrọ\u{301}k Plant"),
            keywords: &["Plant", "Shámrọ\u{301}k Plant"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("koniczyna"),
            keywords: &["koniczyna", "koniczynka", "roślina"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("شفتل"),
            keywords: &["بوټي، شفتل", "شفتل"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("trevo"),
            keywords: &["trevo", "trevo de três folhas"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["planta", "trevo"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("ispinku"),
            keywords: &["ispinku", "mallki"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("trifoi"),
            keywords: &["plantă", "trifoi"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-050"),
            keywords: &["E10-050"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("трилистник"),
            keywords: &["Ирландия", "клевер", "растение", "трилистник"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ubwoko bw’ikibabi"),
            keywords: &["ikimera", "ubwoko bw’ikibabi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("شيمراڪ"),
            keywords: &["شيمراڪ", "ٻوٽو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ත\u{dd4}න\u{dca}පෙත\u{dd2} මල"),
            keywords: &["ත\u{dd4}න\u{dca}පෙත\u{dd2} මල", "පැළය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("trojlístok"),
            keywords: &["rastlina", "trojlístok"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("deteljica"),
            keywords: &["deteljica", "rastlina"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("dhir gaaban saddex caleen leh"),
            keywords: &["dhir", "dhir gaaban saddex caleen leh"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("tërfil"),
            keywords: &["bimë", "tërfil"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("детелина"),
            keywords: &["биљкa", "детелина"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("дјетелина"),
            keywords: &["дјетелина"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("detelina"),
            keywords: &["biljka", "detelina"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("djetelina"),
            keywords: &["djetelina"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("treklöver"),
            keywords: &["Irland", "treklöver"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("shamroki"),
            keywords: &["mmea", "shamroki"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("முச\u{bcd}சிற\u{bcd}றிலை"),
            keywords: &["இலை", "பச\u{bcd}சை இலை", "முச\u{bcd}சிற\u{bcd}றிலை"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మూడు ఆకులు ఉన\u{c4d}న గర\u{c3f}క"),
            keywords: &["ఆకు", "గర\u{c3f}క", "మూడు ఆకులు ఉన\u{c4d}న గర\u{c3f}క"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("себарга"),
            keywords: &["растанӣ", "себарга"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ใบโคลเวอร\u{e4c}"),
            keywords: &["พ\u{e37}ช", "ใบโคลเวอร\u{e4c}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("üç ýaprakly"),
            keywords: &["ösümlik", "üç ýaprakly"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("sameloki"),
            keywords: &["sameloki"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yonca"),
            keywords: &["bitki", "yonca"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئۈچقۇلاق"),
            keywords: &["ئۆسۈملۈك", "ئۈچقۇلاق"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("трилисник"),
            keywords: &["рослина", "трилисник"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("تین پتی پھول"),
            keywords: &["تین پتی پھول", "پودا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("sebarga"),
            keywords: &["o‘simlik", "sebarga"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("cỏ ba lá"),
            keywords: &["cỏ ba lá", "thực vật"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("tereefal"),
            keywords: &["garab", "tereefal"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-shamrock"),
            keywords: &["i-shamrock", "isityalo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ṣámrọkì"),
            keywords: &["õgbìn", "ṣámrọkì"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("三葉草"),
            keywords: &["三葉草", "植物"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("三叶草"),
            keywords: &["三叶草", "植物"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("三叶草"),
            keywords: &["三叶草", "苜蓿", "酢浆草"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("三葉草"),
            keywords: &["三葉草", "草"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("i-shamrock"),
            keywords: &["i-shamrock", "isitshalo"],
        },
    ],
};
#[doc = "🍀"]
pub const FOUR_LEAF_CLOVER: crate::Emoji = crate::Emoji {
    glyph: "🍀",
    codepoint: "1F340",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "four leaf clover",
    group: "Animals & Nature",
    subgroup: "plant-other",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("vierblaarklawer"),
            keywords: &["4", "blaar", "klawer", "plant", "vier", "vierblaarklawer"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ድንብላል"),
            keywords: &["4", "ቅጠል", "ተክል", "አራት", "ድንብላል"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ورقة برسيم رباعية"),
            keywords: &["4", "أربعة", "برسيم", "نبات", "ورقة", "ورقة برسيم رباعية"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("চ\u{9be}ৰি প\u{9be}তৰ ঘ\u{9be}\u{981}হ"),
            keywords: &[
                "চ\u{9be}ৰি",
                "চ\u{9be}ৰি প\u{9be}তৰ ঘ\u{9be}\u{981}হ",
                "চ\u{9be}ৰিখিল\u{9be} প\u{9be}তৰ ঘ\u{9be}\u{981}হ",
                "প\u{9be}ত",
                "৪",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("dörd yarpaq yonca"),
            keywords: &["4", "bitki", "dörd", "yarpaq", "yonca"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("чатырохлістая канюшына"),
            keywords: &["4", "канюшына", "ліст", "расліна", "чатырохлістая канюшына"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Четирилистна детелина"),
            keywords: &[
                "Четирилистна детелина",
                "детелина",
                "листо",
                "растение",
                "четирилистен",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("চ\u{9be}রটি প\u{9be}ত\u{9be}র ত\u{9cd}রিপত\u{9cd}রবিশেষ"),
            keywords: &[
                "4",
                "ক\u{9cd}লোভ\u{9be}র",
                "গ\u{9be}ছ",
                "চ\u{9be}র",
                "চ\u{9be}রটি প\u{9be}ত\u{9be}র ত\u{9cd}রিপত\u{9cd}রবিশেষ",
                "প\u{9be}ত\u{9be}",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("melchon peder"),
            keywords: &["4", "melchon peder", "plant"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("djetelina s četiri lista"),
            keywords: &[
                "biljka",
                "djetelina",
                "djetelina s četiri lista",
                "list",
                "četiri",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("trèvol de quatre fulles"),
            keywords: &["4", "fulles", "quatre", "trèvol", "trèvol de quatre fulles"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏅᎩ ᏧᎦᎶᎩ ᎩᎦᎨ ᎠᏥᎸᏍᎩ"),
            keywords: &["4", "ᎤᎦᎶᎦ", "ᎩᎦᎨ ᎠᏥᎸᏍᎩ", "ᏅᎩ", "ᏅᎩ ᏧᎦᎶᎩ ᎩᎦᎨ ᎠᏥᎸᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("čtyřlístek"),
            keywords: &["4", "jetel", "list", "rostlina", "čtyři", "čtyřlístek"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("meillionen pedair deilen"),
            keywords: &[
                "4",
                "deilen",
                "meillionen",
                "meillionen pedair deilen",
                "pedwar",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("firkløver"),
            keywords: &["firkløver", "held", "heldig", "kløver"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Glücksklee"),
            keywords: &["Glück", "Glücksklee", "Kleeblatt", "vier", "vierblättrig"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("τετράφυλλο τριφύλλι"),
            keywords: &[
                "4",
                "τέσσερα",
                "τετράφυλλο τριφύλλι",
                "τριφύλλι",
                "φυτό",
                "φύλλο",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("four leaf clover"),
            keywords: &["4", "clover", "four", "four-leaf clover", "leaf"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("four-leaf clover"),
            keywords: &[""],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("trébol de cuatro hojas"),
            keywords: &["suerte", "trébol", "trébol de cuatro hojas"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "cuatro",
                "hojas",
                "suerte",
                "trébol",
                "trébol de cuatro hojas",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("nelja lehega ristik"),
            keywords: &["leht", "neli", "nelja lehega ristik", "ristik", "taim"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("lau hostoko hirusta"),
            keywords: &["hirusta", "hosto", "landare", "lau", "lau hostoko hirusta"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("شبدر چهاربرگ"),
            keywords: &["برگ", "شبدر", "شبدر چهاربرگ", "چهار", "گیاه", "۴"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("neliapila"),
            keywords: &["kasvi", "lehti", "neliapila", "nelilehtinen", "neljä"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("four-leaf clover"),
            keywords: &["4", "apat", "clover", "dahon", "four-leaf clover"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("smæra við fýra"),
            keywords: &["4", "fýra", "smæra", "smæra við fýra"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("trèfle à quatre feuilles"),
            keywords: &["chance", "trèfle", "trèfle à quatre feuilles"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "chance",
                "quatre feuilles",
                "trèfle",
                "trèfle à quatre feuilles",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("seamair Mhuire"),
            keywords: &["4", "ceithre", "duilleog", "seamair", "seamair Mhuire"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("seamrag cheithir-dhuilleagach"),
            keywords: &[
                "4",
                "ceithir",
                "duilleag",
                "seamrag",
                "seamrag cheithir-dhuilleagach",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("trevo de catro follas"),
            keywords: &["4", "planta", "sorte", "trevo de catro follas"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ચાર પર\u{acd}ણ ત\u{acd}રિદલ"),
            keywords: &["ચાર", "ત\u{acd}રિદલ", "નસીબદાર", "પર\u{acd}ણ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("clover mai ganyen huɗu"),
            keywords: &["4", "clover", "clover mai ganyen huɗu", "ganye", "huɗu"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("תלתן ארבעה עלים"),
            keywords: &["מזל", "עלה", "צמח", "תלתן", "תלתן ארבעה עלים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("चार पत\u{94d}ती वाली द\u{942}ब"),
            keywords: &[
                "चार",
                "चार पत\u{94d}ती वाली द\u{942}ब",
                "तिपतिया",
                "पत\u{94d}ती",
                "भाग\u{94d}यशाली",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("četverolisna djetelina"),
            keywords: &["4", "biljka", "djetelina", "list", "četverolisna djetelina"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("négylevelű lóhere"),
            keywords: &["lóhere", "négylevelű", "szerencse"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("քառատերև երեքնուկ"),
            keywords: &[
                "4",
                "բույս",
                "երեքնուկ",
                "չորս",
                "տերև",
                "քառատերև երեքնուկ",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("empat daun semanggi"),
            keywords: &["4", "daun", "empat", "semanggi", "tanaman"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("akwụkwọnri mgba anọ"),
            keywords: &["4", "akwụkwọnri", "akwụkwọnri mgba anọ", "anọ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("fjögurra laufa smári"),
            keywords: &["fjögurra laufa smári", "happamerki", "smári"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("quadrifoglio"),
            keywords: &["foglia", "fortuna", "quadrifoglio", "quattro"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("四つ葉のクローバー"),
            keywords: &["4", "クローバー", "四つ葉のクローバー", "草", "葉"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("semanggi godhong papat"),
            keywords: &["4", "godhong", "papat", "semanggi"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ოთხფოთლიანი სამყურა"),
            keywords: &[
                "4",
                "მცენარე",
                "ოთხი",
                "ოთხფოთლიანი სამყურა",
                "სამყურა",
                "ფოთოლი",
            ],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("ikeffis bu kuẓ n wafriwen"),
            keywords: &["ikeffis bu kuẓ n wafriwen"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("төрт жапырақты жоңышқа"),
            keywords: &["4", "жапырақ", "жоңышқа", "төрт", "төрт жапырақты жоңышқа"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("firkløver"),
            keywords: &["firkløver", "held", "heldig", "kløver"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "ស\u{17d2}ល\u{17b9}កផ\u{17d2}កាឆែកជាប\u{17bd}នសន\u{17d2}ល\u{17b9}ក (ក\u{17d2}ល\u{17bc}វើ)",
            ),
            keywords: &[
                "4",
                "ក\u{17d2}ល\u{17bc}វើ",
                "ប\u{17bd}ន",
                "ស\u{17d2}ល\u{17b9}ក",
                "ស\u{17d2}ល\u{17b9}កឆែកជាប\u{17bd}ន",
                "ស\u{17d2}ល\u{17b9}កផ\u{17d2}កាឆែកជាប\u{17bd}នសន\u{17d2}ល\u{17b9}ក (ក\u{17d2}ល\u{17bc}វើ)",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ನಾಲ\u{ccd}ಕು ಎಲ\u{cc6}ಯ ಗರ\u{cbf}ಕ\u{cc6}"),
            keywords: &["ಎಲ\u{cc6}", "ನಾಲ\u{ccd}ಕು ಎಲ\u{cc6}ಯ ಗರ\u{cbf}ಕ\u{cc6}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("네잎클로버"),
            keywords: &["네잎클로버", "클로버", "행운"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("चार पानाचो पर\u{94d}ण"),
            keywords: &[
                "4",
                "चार",
                "चार पानाचो पर\u{94d}ण",
                "चार-पाना\u{902}चो पर\u{94d}ण",
                "पर\u{94d}ण",
                "पान",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("төрт жалбырактуу беде"),
            keywords: &[
                "4",
                "беде",
                "жалбырак",
                "төрт",
                "төрт жалбырактуу беде",
                "өсүмдүк",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("véierbliederegt Kléiblat"),
            keywords: &["4", "Blat", "Kléi", "véier", "véierbliederegt Kléiblat"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ດອກຈ\u{eb4}ກສ\u{eb5}\u{ec8}ຊ\u{eb5}ກ"),
            keywords: &[
                "ດອກຈ\u{eb4}ກສ\u{eb5}\u{ec8}ຊ\u{eb5}ກ",
                "ໂຊກດ\u{eb5}",
                "ໃບໄມ\u{ec9}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("keturlapis dobilas"),
            keywords: &["4", "dobilas", "keturi", "keturlapis dobilas", "lapas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("četrlapu āboliņš"),
            keywords: &["4", "augs", "lapa", "āboliņš", "četrlapu āboliņš"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("koroa whā rau"),
            keywords: &["4", "koroa", "rau", "whā"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("детелина со четири листа"),
            keywords: &[
                "детелина",
                "детелина со четири листа",
                "лист",
                "растение",
                "четири",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ന\u{d3e}ലിതൾ ചെടി"),
            keywords: &[
                "ഇലകൾ",
                "ന\u{d3e}ലിതൾ",
                "ന\u{d3e}ലിതൾ ചെടി",
                "പ\u{d41}ഷ\u{d4d}പം",
                "പ\u{d42}",
                "പ\u{d42}വ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("4 навчтай хошоонгор"),
            keywords: &["4", "4 навчтай хошоонгор", "навч", "ургамал", "хошоонгор"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("चार पातीची वनस\u{94d}पती"),
            keywords: &[
                "चार",
                "चार पातीची वनस\u{94d}पती",
                "चार पात\u{94d}या\u{902}च\u{947} पान",
                "तीन पाती गवत",
                "पान",
                "४",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("daun bunga cengkih"),
            keywords: &["4", "bunga cengkih", "daun", "daun bunga cengkih", "empat"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("silla ta’ erba’ werqiet"),
            keywords: &["4", "erba’", "silla", "silla ta’ erba’ werqiet", "werqa"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "လေးရ\u{103d}က\u{103a}ဆ\u{102d}\u{102f}င\u{103a} ပ\u{1032}ရ\u{102d}\u{102f}င\u{103a}းပင\u{103a}",
            ),
            keywords: &[
                "ပ\u{1032}ရ\u{102d}\u{102f}င\u{103a}းပင\u{103a}",
                "လေး",
                "လေးရ\u{103d}က\u{103a}ဆ\u{102d}\u{102f}င\u{103a} ပ\u{1032}ရ\u{102d}\u{102f}င\u{103a}းပင\u{103a}",
                "အရ\u{103d}က\u{103a}",
                "၄",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("firkløver"),
            keywords: &["4", "firkløver", "flaks", "hell", "kløver", "plante"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("क\u{94d}लोभरको चारवटा पात"),
            keywords: &[
                "क\u{94d}लोभर",
                "क\u{94d}लोभरको चारवटा पात",
                "चार",
                "पात",
                "४",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("klavertjevier"),
            keywords: &["4", "blad", "klaver", "klavertjevier", "vier"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("firkløver"),
            keywords: &["4", "firkløver", "flaks", "hell", "kløver", "plante"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଚ\u{b3e}ର\u{b3f} ପତ\u{b4d}ର ବ\u{b3f}ଶ\u{b3f}ଷ\u{b4d}ଟ ତ\u{b43}ଣ"),
            keywords: &[
                "ଚ\u{b3e}ର\u{b3f}",
                "ଚ\u{b3e}ର\u{b3f} ପତ\u{b4d}ର ବ\u{b3f}ଶ\u{b3f}ଷ\u{b4d}ଟ ତ\u{b43}ଣ",
                "ଚ\u{b3e}ର\u{b3f}-ପତ\u{b4d}ର ବ\u{b3f}ଶ\u{b3f}ଷ\u{b4d}ଟ ପଶ\u{b41}ଖ\u{b3e}ଦ\u{b4d}ୟ ଉପଯୋଗୀ ତ\u{b43}ଣ",
                "ପତ\u{b4d}ର",
                "ପଶ\u{b41}ଖ\u{b3e}ଦ\u{b4d}ୟ ଉପଯୋଗୀ ତ\u{b43}ଣ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਚਾਰ ਪ\u{a71}ਤਿਆ\u{a02} ਵਾਲਾ ਲ\u{a4c}\u{a02}ਗ"),
            keywords: &[
                "ਚਾਰ",
                "ਚਾਰ ਪ\u{a71}ਤਿਆ\u{a02} ਵਾਲਾ ਲ\u{a4c}\u{a02}ਗ",
                "ਪ\u{a71}ਤਾ",
                "ਬ\u{a42}ਟਾ",
                "ਲ\u{a4c}\u{a02}ਗ",
                "ਸ\u{a41}ਭਾਗਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("سہ شاخے چار پت\u{651}ے"),
            keywords: &[
                "4",
                "بت\u{651}ا",
                "سہ شاخہ",
                "سہ شاخے چار پت\u{651}ے",
                "چار",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fọ\u{301} Líf Klóva"),
            keywords: &[
                "4",
                "Fọ\u{300}",
                "Fọ\u{301} Líf Klóva",
                "Fọ\u{301}-Líf Klóva",
                "Klóva",
                "Lif",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("czterolistna koniczyna"),
            keywords: &[
                "czterolistna koniczyna",
                "koniczyna",
                "koniczynka",
                "szczęście",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د څلورو پاڼو شفتل"),
            keywords: &[
                "د څلورو پاڼو شفتل",
                "۴، شفتل، څلور، د څلورو پاڼو شفتل، پاڼه",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("trevo de quatro folhas"),
            keywords: &["folhas", "quatro", "trevo", "trevo de quatro folhas"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &[
                "4",
                "folha",
                "planta",
                "quatro",
                "trevo",
                "trevo de quatro folhas",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("ispinku tawa laqhiwan"),
            keywords: &["4", "ispinku tawa laqhiwan", "laqhi", "tawa", "trevol"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("trifoi cu patru foi"),
            keywords: &["frunze", "patru", "trifoi", "trifoi cu patru foi"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-261"),
            keywords: &["E10-261"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("четырехлистный клевер"),
            keywords: &["клевер", "удача", "четыре", "четырехлистный клевер"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("igiti gifite amababi ane"),
            keywords: &[
                "4",
                "amababi",
                "igiti gifite amababi ane",
                "kane",
                "ubwoko bw’igihingwa",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("چار پنن وارو گاه"),
            keywords: &["4، گاه، چار، پن", "چار پنن وارو گاه"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("උඳ\u{dd4}ප\u{dd2}යල\u{dd2}ය"),
            keywords: &[
                "4",
                "උඳ\u{dd4}ප\u{dd2}යල\u{dd2}ය",
                "ත\u{dd2}පත\u{dca}\u{200d}ර",
                "පත\u{dca}\u{200d}රය",
                "පැළය",
                "හතර",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("štvorlístok"),
            keywords: &["list", "rastlina", "ďatelina", "štvorlístok", "štyri"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("štiriperesna deteljica"),
            keywords: &[
                "4",
                "detelja",
                "list",
                "rastlina",
                "štiri",
                "štiriperesna deteljica",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("geed afar caleenle"),
            keywords: &["4", "afar", "caleen", "geed", "geed afar caleenle"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("tërfil me katër fletë"),
            keywords: &["4", "gjethe", "tërfil", "tërfil me katër fletë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("детелина са четири листа"),
            keywords: &[
                "4",
                "детелина",
                "детелина са четири листа",
                "лист",
                "четири",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("дјетелина са четири листа"),
            keywords: &["дјетелина са четири листа"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("detelina sa četiri lista"),
            keywords: &[
                "4",
                "detelina",
                "detelina sa četiri lista",
                "list",
                "četiri",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("djetelina sa četiri lista"),
            keywords: &["djetelina sa četiri lista"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("fyrklöver"),
            keywords: &["Irland", "fyrklöver", "klöver", "lycka", "tur"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("klova yenye majani manne"),
            keywords: &[
                "4",
                "klova",
                "klova yenye majani manne",
                "mmea",
                "nne",
                "tawi",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ந\u{bbe}ன\u{bcd}கு இலை க\u{bcd}ளோவர\u{bcd}"),
            keywords: &[
                "அதிர\u{bcd}ஷ\u{bcd}டம\u{bcd}",
                "இலைகள\u{bcd}",
                "ந\u{bbe}ன\u{bcd}கு",
                "ந\u{bbe}ன\u{bcd}கு இலை க\u{bcd}ளோவர\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("న\u{c3e}లుగు ర\u{c47}కుల ఆకు"),
            keywords: &["అదృష\u{c4d}ట ఆకు", "న\u{c3e}లుగు ర\u{c47}కుల ఆకు"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("бедаи чорбарга"),
            keywords: &["4", "барг", "беда", "бедаи чорбарга", "чор"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ใบโคลเวอร\u{e4c} 4 แฉก"),
            keywords: &["โชคด\u{e35}", "ใบโคลเวอร\u{e4c} 4 แฉก", "ใบไม\u{e49}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("dört ýaprakly ýorunja"),
            keywords: &["4", "dört", "dört ýaprakly ýorunja", "ýaprak", "ýorunja"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kihikihipālangi lau ʻe fā"),
            keywords: &["kihikihipālangi lau ʻe fā"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("dört yapraklı yonca"),
            keywords: &["dört", "dört yapraklı yonca", "yaprak", "yonca", "şanslı"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("تۆتياپراق"),
            keywords: &["4", "تۆت", "تۆتياپراق", "ياپراق", "يوپۇرماق"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("чотирилисткова конюшина"),
            keywords: &[
                "4",
                "конюшина",
                "листок",
                "рослина",
                "чотири",
                "чотирилисткова конюшина",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("چار پتیوں والی گھاس"),
            keywords: &["پتا", "پودا", "چار", "چار پتیوں والی گھاس"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("to‘rt yaproqli beda bargi"),
            keywords: &[
                "4",
                "barg",
                "beda",
                "oʻsimlik",
                "toʻrt",
                "to‘rt yaproqli beda bargi",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("cỏ bốn lá"),
            keywords: &["4", "bốn", "cỏ bốn lá", "lá cây", "thực vật"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("treefalu ñeenti xob"),
            keywords: &["4", "treefal", "treefalu ñeenti xob", "xob", "ñeent"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ifula elinamagqabi amane"),
            keywords: &["4", "ifula", "ifula elinamagqabi amane", "igqabi", "isine"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ahoro Elewe Merin"),
            keywords: &["4", "Ahoro", "Ahoro Elewe Merin", "Ewé", "mẹ\u{301}rin"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("四葉草"),
            keywords: &["4", "四", "四葉草", "草", "葉"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("四叶草"),
            keywords: &["4", "叶", "四", "四叶草", "草"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("四叶草"),
            keywords: &["四叶草", "幸运"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("幸運草"),
            keywords: &["四葉草", "幸運草"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("四葉草"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("i-four leaf clover"),
            keywords: &["i-four leaf clover", "iqabunga", "isitshalo", "okune"],
        },
    ],
};
#[doc = "🍁"]
pub const MAPLE_LEAF: crate::Emoji = crate::Emoji {
    glyph: "🍁",
    codepoint: "1F341",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "maple leaf",
    group: "Animals & Nature",
    subgroup: "plant-other",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("esdoringblaar"),
            keywords: &["blaar", "esdoring", "esdoringblaar", "plant", "val"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ማፕል ቅጠል"),
            keywords: &["ማፕል", "ቅጠል", "ተክል", "የሚወድቅ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}ورقة شجر القيقب"),
            keywords: &["سقوط", "قيقب", "نبات", "ورقة", "\u{202b}ورقة شجر القيقب"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("মেপলৰ প\u{9be}ত"),
            keywords: &["প\u{9be}ত", "মেপল", "মেপলৰ প\u{9be}ত", "সৰি পৰ\u{9be}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("ağcaqayın yarpağı"),
            keywords: &[
                "ağcaqayın",
                "ağcaqayın yarpağı",
                "bitki",
                "tökülmək",
                "yarpaq",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("кляновы ліст"),
            keywords: &["ападанне", "кляновы ліст", "клён", "ліст", "расліна"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Кленов лист"),
            keywords: &["Кленов лист", "клен", "лист", "падащ", "растение"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ম\u{9cd}য\u{9be}পেল প\u{9be}ত\u{9be}"),
            keywords: &[
                "গ\u{9be}ছ",
                "পতনশীল",
                "প\u{9be}ত\u{9be}",
                "ম\u{9cd}য\u{9be}পেল",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("delienn skav-gwracʼh"),
            keywords: &["delienn", "skav-gwracʼh"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("javorov list"),
            keywords: &["hrast", "javor", "javorov list", "list", "opada"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("fulla d’auró"),
            keywords: &["auró", "fulla", "fulla d’auró"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄟\u{11133}𑄠𑄛\u{11127}𑄣\u{11134} 𑄛𑄘"),
            keywords: &["𑄟\u{11133}𑄠𑄛\u{11127}𑄣\u{11134} 𑄛𑄘"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏢᏩᎩ ᎤᏆᎶᎩ"),
            keywords: &["ᎤᎦᎶᎦ", "ᏢᏩᎩ", "ᏢᏩᎩ ᎤᏆᎶᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("javorový list"),
            keywords: &["javor", "javorový list", "list", "padající", "rostlina"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("deilen masarnen"),
            keywords: &["cwympo", "deilen", "masarnen"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("ahornblad"),
            keywords: &["ahorn", "ahornblad", "efterår", "efterårsblad"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Ahornblatt"),
            keywords: &["Ahorn", "Ahornblatt", "Blatt", "Herbst", "Laub", "Pflanze"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("φύλλο σφενδάμου"),
            keywords: &["πέφτει", "σφένδαμος", "φυτό", "φύλλο", "φύλλο σφενδάμου"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("maple leaf"),
            keywords: &["falling", "leaf", "maple"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("hoja de arce"),
            keywords: &["arce", "hoja", "hoja de arce"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["arce", "hoja", "hoja de arce", "maple"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("vahtraleht"),
            keywords: &["langev", "leht", "taim", "vaher", "vahtraleht"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("astigarraren hostoa"),
            keywords: &["astigarra", "astigarraren hostoa", "erori", "hostoa"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("برگ افرا"),
            keywords: &["افتادن", "افرا", "برگ", "برگ\u{200c}ریز", "پاییز", "گیاه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("vaahteranlehti"),
            keywords: &["kasvi", "lehti", "putoava", "vaahtera", "vaahteranlehti"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("dahon ng maple"),
            keywords: &["dahon", "dahon ng maple", "halaman", "maple", "taglagas"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("ahornsblað"),
            keywords: &["ahornsblað"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("feuille d’érable"),
            keywords: &["feuille", "feuille d’érable"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["feuille", "feuille d’érable", "érable"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("duilleog mhailpe"),
            keywords: &["duilleog", "duilleog mhailpe", "mailp", "titim"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("duilleag o chraobh-mhalpais"),
            keywords: &[
                "craobh",
                "duilleag",
                "duilleag o chraobh-mhalpais",
                "foghar",
                "malpais",
                "tuiteam",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("folla de pradairo"),
            keywords: &[
                "folla",
                "folla de pradairo",
                "planta",
                "pradairo",
                "sicómoro",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("મ\u{ac7}પલ પર\u{acd}ણ"),
            keywords: &[
                "ખરી પડ\u{ac7}લ\u{ac1}\u{a82} પર\u{acd}ણ",
                "પર\u{acd}ણ",
                "મ\u{ac7}પલ પર\u{acd}ણ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("ganyen maple"),
            keywords: &["faɗuwa", "ganye", "ganyen maple", "maple"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("עלה מייפל"),
            keywords: &[
                "מייפל",
                "סירופ",
                "סתיו",
                "עלה מייפל",
                "עלים נושרים",
                "פנקייק",
                "קנדה",
                "שלכת",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("म\u{948}पल की पत\u{94d}ती"),
            keywords: &[
                "गिरी ह\u{941}ई पत\u{94d}ती",
                "चिनार की पत\u{94d}ती",
                "पत\u{94d}ता",
                "म\u{948}पल की पत\u{94d}ती",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("javorov list"),
            keywords: &["biljka", "javor", "javorov list", "list", "padanje"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("juharlevél"),
            keywords: &["juhar", "juharlevél", "levél", "növény"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("թխկու տերև"),
            keywords: &["բույս", "ընկնող", "թխկի", "թխկու տերև", "տերև"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("daun maple"),
            keywords: &["daun", "gugur", "maple", "tanaman"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("akwụkwọnri mgbe ise"),
            keywords: &["akwụkwọnri", "akwụkwọnri mgbe ise", "mgbe ise", "na-ada"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hlynslauf"),
            keywords: &["hlynslauf", "hlynur", "lauf", "laufblað"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("foglia d’acero"),
            keywords: &["foglia", "foglia caduta", "foglia d’acero"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("かえで"),
            keywords: &["かえで", "もみじ", "紅葉"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("godhong mapel"),
            keywords: &["godhong", "mapel", "rontok"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ნეკერჩხლის ფოთოლი"),
            keywords: &[
                "ვარდნა",
                "მცენარე",
                "ნეკერჩხალი",
                "ნეკერჩხლის ფოთოლი",
                "ფოთოლი",
            ],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("ifer n kikev"),
            keywords: &["ifer n kikev"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("үйеңкі жапырағы"),
            keywords: &[
                "жапырақ",
                "жерге түсу",
                "үйеңкі",
                "үйеңкі жапырағы",
                "өсімдік",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("blad"),
            keywords: &["ahorn", "ahornblad", "blad", "efterår", "efterårsblad"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ស\u{17d2}ល\u{17b9}កម\u{17c9}ាផល"),
            keywords: &[
                "ជ\u{17d2}រ\u{17bb}ះ",
                "ម\u{17c9}ាផល",
                "ស\u{17d2}ល\u{17b9}ក",
                "ស\u{17d2}ល\u{17b9}កម\u{17c9}ាផល",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮ\u{ccd}ಯಾಪಲ\u{ccd} ಲೀಫ\u{ccd}"),
            keywords: &[
                "ಬ\u{cbf}ದ\u{ccd}ದ ಎಲ\u{cc6}",
                "ಮ\u{ccd}ಯಾಪಲ\u{ccd} ಲೀಫ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("단풍잎"),
            keywords: &["단풍잎", "이파리", "잎", "잎사귀"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("म\u{945}पल पान"),
            keywords: &["गळप", "पान", "म\u{945}पल"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("клён жалбырагы"),
            keywords: &["жалбырак", "клён", "клён жалбырагы", "түшкөн", "өсүмдүк"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Ahornblat"),
            keywords: &["Ahorn", "Ahornblat", "Blat", "falend"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໃບແມບໂພ"),
            keywords: &["ໃບແມບໂພ", "ໃບໄມ\u{ec9}"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("klevo lapas"),
            keywords: &["klevas", "klevo lapas", "krenta", "lapas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("kļavas lapa"),
            keywords: &["augs", "kļava", "kļavas lapa", "lapa"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("rau mapera"),
            keywords: &["hinga", "mapera", "rau"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("јаворов лист"),
            keywords: &["лист", "растение", "јавор", "јаворов лист"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മേപ\u{d4d}പിൾ ഇല"),
            keywords: &["ഇല", "ഉണക\u{d4d}കയില", "മേപ\u{d4d}പിളില", "മേപ\u{d4d}പിൾ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("агч модны навч"),
            keywords: &["агч", "агч модны навч", "мод", "навч", "ургамал"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("चिनारच\u{94d}या झाडाच\u{947} पान"),
            keywords: &[
                "गळणार\u{947}",
                "चिनारच\u{94d}या झाडाच\u{947} पान",
                "पान चिनार",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("daun mapel"),
            keywords: &["daun", "luruh", "mapel"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("werqa tal-aġġru"),
            keywords: &["aġġru", "jaqgħu", "werqa", "werqa tal-aġġru"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("မေပယ\u{103a}ရ\u{103d}က\u{103a}"),
            keywords: &[
                "မေပယ\u{103a}",
                "မေပယ\u{103a}ရ\u{103d}က\u{103a}",
                "သစ\u{103a}ရ\u{103d}က\u{103a}ကြ\u{103d}ေခြင\u{103a}း",
                "အရ\u{103d}က\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("lønneblad"),
            keywords: &["blad", "høstblad", "lønn", "lønneblad"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("म\u{947}पलको पात"),
            keywords: &[
                "झर\u{947}को",
                "पात",
                "बिर\u{942}वा",
                "म\u{947}पल",
                "म\u{947}पलको पात",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("esdoornblad"),
            keywords: &["blad", "esdoorn", "esdoornblad", "vallend"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("lønneblad"),
            keywords: &["blad", "haustblad", "lønn", "lønneblad"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମ\u{b4d}ୟ\u{b3e}ପଲ\u{b4d}\u{200d} ପତ\u{b4d}ର"),
            keywords: &[
                "ଏକ ପ\u{b4d}ରକ\u{b3e}ର ବ\u{b43}କ\u{b4d}ଷ",
                "ଖସ\u{b3f} ପଡ\u{b3c}\u{b3f}ବ\u{b3e}",
                "ପତ\u{b4d}ର",
                "ମ\u{b4d}ୟ\u{b3e}ପଲ\u{b4d}\u{200d} ପତ\u{b4d}ର",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਚਿਨਾਰ ਪ\u{a71}ਤਾ"),
            keywords: &[
                "ਚਿਨਾਰ ਪ\u{a71}ਤਾ",
                "ਪ\u{a71}ਤਾ",
                "ਪ\u{a71}ਤਾ ਡਿ\u{a71}ਗਣਾ",
                "ਬ\u{a42}ਟਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("شکر دے درخت دا پت\u{651}ا"),
            keywords: &[
                "بت\u{651}ا",
                "شکر دے درخت دا پت\u{651}ا",
                "میپل",
                "ڈ\u{650}گنا",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Mápúl Tri Lif"),
            keywords: &["De Fọl", "Lif", "Mápúl Tri", "Mápúl Tri Lif"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("liść klonowy"),
            keywords: &["liść", "liść jesienny", "liść klonowy", "liść klonu"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("میپل پاڼی"),
            keywords: &["غورځېدونکې، پاڼه، ميپل", "میپل پاڼی"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("folha de bordo"),
            keywords: &["folha", "folha caída", "folha de bordo"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("folha de ácer"),
            keywords: &["folha", "folha de ácer", "planta", "queda", "ácer"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("arce laqhi"),
            keywords: &["arce", "laqhi", "urmasqa"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("frunză de arțar"),
            keywords: &["arțar", "frunză", "frunză de arțar", "frunză în cădere"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-262"),
            keywords: &["E10-262"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("кленовый лист"),
            keywords: &["клен", "кленовый лист", "красный", "лист", "осень"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikibabi cy’igiti cya maple"),
            keywords: &[
                "ibabi",
                "ikibabi cy’igiti cya maple",
                "kugwa",
                "ubwoko bw’igiti",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ميپل جو پن"),
            keywords: &["ميپل جو پن", "ڇڙندڙ، پن، ميپل"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("මේපල\u{dca} පත\u{dca}\u{200d}රය"),
            keywords: &["පත\u{dca}\u{200d}රය", "පැළය", "මේපල\u{dca}", "වැටෙන"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("javorový list"),
            keywords: &["javor", "javorový list", "list", "opadavý", "rastlina"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("javorov list"),
            keywords: &["javor", "javorov list", "list", "padanje", "rastlina"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("caleen jiifta"),
            keywords: &["caleen", "dhacaysa", "jiifta"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("gjethe panje"),
            keywords: &["bimë", "gjethe", "gjethe panje", "panjë", "që bie"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("јаворов лист"),
            keywords: &["лист", "падање", "јавор", "јаворов лист"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["јаворов лист"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("javorov list"),
            keywords: &["javor", "javorov list", "list", "padanje"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["javorov list"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("lönnlöv"),
            keywords: &["höst", "lönnlöv", "löv"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("jani la mshira"),
            keywords: &["jani", "jani la mshira", "kuanguka", "mmea", "mshira"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மேப\u{bcd}பிள\u{bcd} இலை"),
            keywords: &[
                "இலை",
                "இலையுதிர\u{bcd}க\u{bbe}லம\u{bcd}",
                "மேப\u{bcd}பிள\u{bcd} இலை",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మ\u{c3e}పుల\u{c4d} ఆకు"),
            keywords: &[
                "గంగర\u{c47}గు ఆకు",
                "మ\u{c3e}పుల\u{c4d}",
                "మ\u{c3e}పుల\u{c4d} ఆకు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("барги заранг"),
            keywords: &["афтидан", "барг", "барги заранг", "заранг"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ใบเมเป\u{e34}\u{e49}ล"),
            keywords: &["ใบเมเป\u{e34}\u{e49}ล", "ใบไม\u{e49}ร\u{e48}วง"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("kerkaw ýapragy"),
            keywords: &["gaçýan", "kerkaw", "kerkaw ýapragy", "ýaprak"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("lauʻi-mapele"),
            keywords: &["lauʻi-mapele"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("akçaağaç yaprağı"),
            keywords: &["akçaağaç yaprağı", "düşen yaprak", "yaprak"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئېرەن يوپۇرمىقى"),
            keywords: &["ئېرەن", "ئېرەن يوپۇرمىقى", "يوپۇرماق", "چۈشۈش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("кленовий листок"),
            keywords: &["клен", "кленовий листок", "листок", "опадати", "рослина"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("میپل کے پتے"),
            keywords: &["میپل", "میپل کے پتے", "پودا", "گرنا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("zarang bargi"),
            keywords: &["barg", "xazon", "zarang", "zarang bargi"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("lá phong"),
            keywords: &["lá cây", "lá phong", "rụng"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kobu kanadaa"),
            keywords: &["daanu", "kanadaa", "kobu kanadaa", "xob"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umthi we-maple"),
            keywords: &["i-maple", "igqabi", "ukuwa", "umthi we-maple"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ewe Mapulu"),
            keywords: &["Ewe Mapulu", "Ewé", "Jàbọ", "igi"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("楓葉"),
            keywords: &["楓樹", "楓葉", "落葉", "葉"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("枫叶"),
            keywords: &["叶", "枫叶", "枫树", "落叶"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("枫叶"),
            keywords: &["加拿大", "枫叶", "秋"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("楓葉"),
            keywords: &["楓葉", "紅葉"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["楓葉", "紅葉", "葉子"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("i-maple leaf"),
            keywords: &["i-maple leaf", "iqabunga", "isitshalo", "ukuwa"],
        },
    ],
};
#[doc = "🍂"]
pub const FALLEN_LEAF: crate::Emoji = crate::Emoji {
    glyph: "🍂",
    codepoint: "1F342",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "fallen leaf",
    group: "Animals & Nature",
    subgroup: "plant-other",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("vallende blaar"),
            keywords: &["blaar", "plant", "val", "vallende blaar"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የረገፈ ቅጠል"),
            keywords: &["ቅጠል", "ተክል", "የሚወድቅ", "የረገፈ ቅጠል"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("أوراق متساقطة"),
            keywords: &["أوراق متساقطة", "سقوط", "نبات", "ورقة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("সৰ\u{9be} প\u{9be}ত"),
            keywords: &["প\u{9be}ত", "সৰ\u{9be} প\u{9be}ত", "সৰি পৰ\u{9be}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("tökülən yarpaq"),
            keywords: &["bitki", "tökülmək", "tökülən yarpaq", "yarpaq"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("апалы ліст"),
            keywords: &["ападанне", "апалы ліст", "восень", "ліст", "расліна"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Паднало листо"),
            keywords: &["Паднало листо", "листо", "падащ", "растение"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("প\u{9be}ত\u{9be} পড\u{9bc}\u{9be}"),
            keywords: &[
                "গ\u{9be}ছ",
                "পতনশীল",
                "প\u{9be}ত\u{9be}",
                "প\u{9be}ত\u{9be} পড\u{9bc}\u{9be}",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("delioù secʼh"),
            keywords: &["delienn", "delioù secʼh"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("opao list"),
            keywords: &["biljka", "lišče", "opada", "opao list"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("fulla seca"),
            keywords: &["fulla", "fulla que cau", "seca"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄛\u{11127}𑄢𑄬𑄖\u{11133}𑄠\u{11134} 𑄛𑄘"),
            keywords: &["𑄛\u{11127}𑄢𑄬𑄖\u{11133}𑄠\u{11134} 𑄛𑄘"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᎵᏍᏚᎪᏒᎩ"),
            keywords: &["ᎤᎦᎶᎦ", "ᎤᎵᏍᏚᎪᏒᎩ", "ᎪᎰᏍᎦ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("spadlý list"),
            keywords: &["list", "padající", "rostlina", "spadlý list"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("deilen yn cwympo"),
            keywords: &["cwympo", "deilen", "deilen yn cwympo", "planhigyn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("faldende blade"),
            keywords: &["blade", "efterårsblade", "faldende blade"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Laub"),
            keywords: &["Blatt", "Blätter", "Herbst", "Laub", "Pflanze"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πεσμένα φύλλα"),
            keywords: &["πεσμένα φύλλα", "πεσμένο", "φυτό", "φύλλο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("fallen leaf"),
            keywords: &["fallen leaf", "falling", "leaf"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("hojas caídas"),
            keywords: &["caída", "hojas", "hojas caídas"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("langenud leht"),
            keywords: &["langenud leht", "langev", "leht", "taim"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("eroritako hostoa"),
            keywords: &["erori", "eroritako hostoa", "hosto", "landare"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("برگ\u{200c}ریزان"),
            keywords: &["افتادن", "برگ", "برگ\u{200c}ریزان", "پاییز", "گیاه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("pudonnut lehti"),
            keywords: &["kasvi", "lehti", "pudonnut lehti", "putoava"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("nalagas na dahon"),
            keywords: &["dahon", "halaman", "nalagas na dahon", "taglagas"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("fallið blað"),
            keywords: &["blað", "falli", "fallið blað"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("feuille morte"),
            keywords: &["feuille", "feuille morte"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["feuille", "morte"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("duilleog thite"),
            keywords: &["duilleog", "duilleog thite", "titim"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("duilleagan an fhoghair"),
            keywords: &["duilleag", "duilleagan an fhoghair", "foghar", "tuiteam"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("folla seca"),
            keywords: &["folla", "folla seca", "outono", "planta"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ખરતી પા\u{a82}દડીઓ"),
            keywords: &["ખરતી", "ખર\u{ac7}લી", "પા\u{a82}દડી", "પા\u{a82}દડીઓ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("ganyen da ya faɗi"),
            keywords: &["faɗuwa", "ganye", "ganyen da ya faɗi"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("עלי שלכת"),
            keywords: &["סתיו", "עלי שלכת", "עלים", "צמח", "שלכת"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("गिरी ह\u{941}ई पत\u{94d}ती"),
            keywords: &[
                "गिरता ह\u{941}आ",
                "गिरता ह\u{941}आ पत\u{94d}ता",
                "गिरती ह\u{941}ई पत\u{94d}तिया\u{902}",
                "गिरा ह\u{941}आ पत\u{94d}ता",
                "गिरी ह\u{941}ई पत\u{94d}ती",
                "पत\u{94d}तिया\u{902}",
                "पत\u{94d}ती",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("otpali list"),
            keywords: &["biljka", "list", "otpali list", "padanje"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("lehullott levél"),
            keywords: &["lehullott", "levél", "növény"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ընկած տերև"),
            keywords: &["բույս", "ընկած տերև", "ընկնող", "տերև"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("daun berguguran"),
            keywords: &["daun", "daun berguguran", "gugur", "tanaman"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("akwụkwọ dara àdà"),
            keywords: &["akwụkwọ dara àdà", "akwụkwọnri", "na-ada"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("fallandi lauf"),
            keywords: &["fallandi", "fallandi laufblöð", "haust", "lauf", "laufblað"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("foglia caduta"),
            keywords: &["cadute foglia", "foglia caduta", "foglie", "foglie cadute"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("落ち葉"),
            keywords: &["木の葉", "枯れ葉", "落ち葉"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("godhong gogrok"),
            keywords: &["godhong", "gogrok"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ჩამოვარდნილი ფოთოლი"),
            keywords: &["ვარდნა", "მცენარე", "ფოთოლი", "ჩამოვარდნილი ფოთოლი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("ifer alvivec (ifer ucelvu)"),
            keywords: &["ifer alvivec (ifer ucelvu)"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("сарғайып түскен жапырақтар"),
            keywords: &[
                "жапырақ",
                "жерге түсу",
                "сарғайып түскен жапырақтар",
                "өсімдік",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("faldende blade"),
            keywords: &["blade", "efterårsblade", "faldende blade"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ស\u{17d2}ល\u{17b9}\u{200b}កឈើជ\u{17d2}រ\u{17bb}ះ"),
            keywords: &[
                "ជ\u{17d2}រ\u{17bb}ះ",
                "ស\u{17d2}ល\u{17b9}\u{200b}កឈើ",
                "ស\u{17d2}ល\u{17b9}\u{200b}កឈើជ\u{17d2}រ\u{17bb}ះ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಉದುರ\u{cbf}ದ ಎಲ\u{cc6}"),
            keywords: &[
                "ಉದುರ\u{cbf}ದ ಎಲ\u{cc6}",
                "ಬ\u{cbf}ದ\u{ccd}ದ ಎಲ\u{cc6}ಗಳು",
                "ಬೀಳುವ ಎಲ\u{cc6}ಗಳು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("낙엽"),
            keywords: &["낙엽", "단풍잎", "이파리", "잎", "잎사귀"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("गळ\u{941}न पडपी पान"),
            keywords: &["गळ\u{941}न पडपी पान", "पडटा", "पान"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("түшкөн жалбырак"),
            keywords: &["жалбырак", "түшкөн", "өсүмдүк"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Hierschtblat"),
            keywords: &["Blat", "Hierschtblat", "falend"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໃບໄມ\u{ec9}ຫ\u{ebc}\u{ebb}\u{ec8}ນ"),
            keywords: &[
                "ພ\u{eb7}ດ",
                "ໃບໄມ\u{ec9}",
                "ໃບໄມ\u{ec9}ຫ\u{ebc}\u{ebb}\u{ec8}ນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("nukritęs lapas"),
            keywords: &["krenta", "lapas", "nukritęs lapas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("nokritusi lapa"),
            keywords: &["augs", "krist", "lapa", "nokritusi lapa"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("rau makere"),
            keywords: &["makere ana", "rau", "rau makere"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("паднат лист"),
            keywords: &["лист", "паднат лист", "паѓа", "растение"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഉണങ\u{d4d}ങി വീഴ\u{d41}ന\u{d4d}ന ഇല"),
            keywords: &[
                "ഇലകൾ",
                "ഉണക\u{d4d}കയില",
                "ഉണങ\u{d4d}ങി വീഴ\u{d41}ന\u{d4d}ന ഇല",
                "കരിയില",
                "വീണ ഇല",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("унаж байгаа навч"),
            keywords: &["навч", "унаж байгаа навч", "унах", "ургамал"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("गळल\u{947}ल\u{947} पान"),
            keywords: &[
                "गळणार\u{947}",
                "गळल\u{947}ल\u{947} पान",
                "गळाल\u{947}ल\u{947} पान",
                "पान",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("daun luruh"),
            keywords: &["daun", "luruh", "tumbuhan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("werqa mwaqqa’"),
            keywords: &["jaqgħu", "werqa", "werqa mwaqqa’"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ရ\u{103d}က\u{103a}ကြ\u{103d}ေ"),
            keywords: &[
                "ကြ\u{103d}ေကျခြင\u{103a}း",
                "ရ\u{103d}က\u{103a}ကြ\u{103d}ေ",
                "သစ\u{103a}ရ\u{103d}က\u{103a}ကြ\u{103d}ေခြင\u{103a}း",
                "အရ\u{103d}က\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("høstblad"),
            keywords: &["blad", "fallende", "høstblad", "løv"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("झर\u{947}को पात"),
            keywords: &["झर\u{947}को", "पात", "बिर\u{942}वा"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("vallende bladeren"),
            keywords: &["blad", "vallend", "vallende bladeren"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("haustblad"),
            keywords: &["blad", "fallande", "haustblad", "lauv"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଝଡ\u{b3c}\u{b3f} ପଡ\u{b3c}\u{b3f}ଥ\u{b3f}ବ\u{b3e} ପତ\u{b4d}ର"),
            keywords: &[
                "ଝଡ\u{b3c}\u{b3f} ପଡ\u{b3c}\u{b3f}ଥ\u{b3f}ବ\u{b3e}",
                "ଝଡ\u{b3c}\u{b3f} ପଡ\u{b3c}\u{b3f}ଥ\u{b3f}ବ\u{b3e} ପତ\u{b4d}ର",
                "ପତ\u{b4d}ର",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਝੜ\u{a47} ਪ\u{a71}ਤ\u{a47}"),
            keywords: &[
                "ਝੜਨਾ",
                "ਝੜ\u{a47} ਪ\u{a71}ਤ\u{a47}",
                "ਡਿਗਣਾ",
                "ਪ\u{a71}ਤਾ",
                "ਪ\u{a71}ਤ\u{a47}",
                "ਪ\u{a71}ਤ\u{a47} ਡਿ\u{a71}ਗਣਾ",
                "ਬ\u{a42}ਟਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ڈگدا پت\u{651}ا"),
            keywords: &["بت\u{651}ا", "ڈ\u{650}گنا", "ڈگدا پت\u{651}ا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Lif Wé Fọ\u{301}l Fọ Graund"),
            keywords: &["De Fọl", "Lif", "Lif Wé Fọ\u{301}l Fọ Graund"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("spadające liście"),
            keywords: &["liście", "roślina", "spadające liście", "spadanie"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("غورځېدلې پاڼه"),
            keywords: &["غورځېدلې پاڼه", "غورځېدلې پاڼه، غورځېدونکې، پاڼه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("folhas caídas"),
            keywords: &["cair", "caídas", "folha", "folhas"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("folha caída"),
            keywords: &["folha", "folha caída", "planta", "queda"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("urmasqa laqhi"),
            keywords: &["laqhi", "urmasqa"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("frunză în cădere"),
            keywords: &["cădere", "frunză", "frunză în cădere"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-263"),
            keywords: &["E10-263"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("падающие листья"),
            keywords: &["листья", "осень", "падающие листья"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikibabi cyaguye"),
            keywords: &["ibabi", "ikibabi cyaguye", "kugwa"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڇڻيل پن"),
            keywords: &["ڇڙندڙ، پن", "ڇڻيل پن"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("වැටෙන කොළය"),
            keywords: &["කොළය", "පැළය", "වැටෙන"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("opadnutý list"),
            keywords: &["list", "opadavý", "opadnutý list", "rastlina"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("padlo listje"),
            keywords: &["list", "padanje", "padlo listje", "rastlina"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("caleen dhacday"),
            keywords: &["caleen", "caleen dhacday", "dhacaysa"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("gjethe e rënë"),
            keywords: &["bimë", "gjethe", "gjethe e rënë", "që bie"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("опали лист"),
            keywords: &["лист", "опали лист", "падање"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["опали лист"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("opali list"),
            keywords: &["list", "opali list", "padanje"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["opali list"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("fallande löv"),
            keywords: &["fallande löv", "faller", "fallna löv", "höst", "löv"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("jani lililoanguka"),
            keywords: &["jani lililoanguka", "kuanguka", "majani", "mmea"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("உதிரும\u{bcd} இலைகள\u{bcd}"),
            keywords: &[
                "இலைகள\u{bcd}",
                "இலையுதிர\u{bcd}க\u{bbe}லம\u{bcd}",
                "உதிரும\u{bcd} இலைகள\u{bcd}",
                "வறட\u{bcd}சி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ర\u{c3e}ల\u{c3f}న ఆకు"),
            keywords: &[
                "ఆకు",
                "ఆకులు",
                "ఆకులు ర\u{c3e}లడం",
                "ర\u{c3e}ల\u{c3f}న ఆకు",
                "ర\u{c3e}ల\u{c47} ఆకులు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("барги хазон"),
            keywords: &["афтидан", "барг", "барги хазон"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ใบไม\u{e49}ร\u{e48}วง"),
            keywords: &[
                "พ\u{e37}ช",
                "ร\u{e48}วง",
                "ใบไม\u{e49}",
                "ใบไม\u{e49}ร\u{e48}วง",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýere gaçan ýaprak"),
            keywords: &["gaçýan", "ýaprak", "ýere gaçan ýaprak"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("lau kuo tō"),
            keywords: &["lau kuo tō"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("düşen yapraklar"),
            keywords: &["düşen", "düşmüş", "yaprak", "yapraklar"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("چۈشكەن يوپۇرماق"),
            keywords: &["يوپۇرماق", "چۈشكەن يوپۇرماق", "چۈشۈش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("опале листя"),
            keywords: &["листок", "опадати", "опале листя", "рослина"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("گرے ہوئے پتے"),
            keywords: &["پتا", "پودا", "گرنا", "گرے ہوئے پتے"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("xazon bargi"),
            keywords: &["barg", "o‘simlik", "xazon", "xazon bargi"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("lá rụng"),
            keywords: &["lá", "rụng", "thực vật"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("xob yu daanu"),
            keywords: &["daanu", "xob", "xob yu daanu"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("igqabi eliwileyo"),
            keywords: &["igqabi", "igqabi eliwileyo", "ukuwa"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Irawe"),
            keywords: &["Irawe", "Jàbọ", "igi"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("落葉"),
            keywords: &["落葉", "葉"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("落叶"),
            keywords: &["叶", "落叶"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("落叶"),
            keywords: &["叶", "秋", "落叶"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("落葉"),
            keywords: &["枯葉", "落葉"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("iqabunga eliqathakile"),
            keywords: &["iqabunga", "iqabunga eliqathakile", "isitshalo", "ukuwa"],
        },
    ],
};
#[doc = "🍃"]
pub const LEAF_FLUTTERING_IN_WIND: crate::Emoji = crate::Emoji {
    glyph: "🍃",
    codepoint: "1F343",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "leaf fluttering in wind",
    group: "Animals & Nature",
    subgroup: "plant-other",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("blaar wat in die wind fladder"),
            keywords: &[
                "blaar",
                "blaar wat in die wind fladder",
                "fladder",
                "plant",
                "waai",
                "wind",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("በአየር ላይ የሚንሳፈፉ ቅጠሎች"),
            keywords: &["ቅጠል", "በአየር ላይ የሚንሳፈፉ ቅጠሎች", "ተንሳፋፊ", "ተክል", "ነፋስ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ورقة متطايرة"),
            keywords: &["رياح", "ريح", "نبات", "هبوب", "ورقة", "ورقة متطايرة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("বত\u{9be}হত উৰ\u{9be} প\u{9be}ত"),
            keywords: &[
                "প\u{9be}ত",
                "বত\u{9be}হ",
                "বত\u{9be}হ বল\u{9be}",
                "বত\u{9be}হত উৰ\u{9be} প\u{9be}ত",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("küləkdə əsən yarpaq"),
            keywords: &[
                "bitki",
                "külək",
                "küləkdə əsən yarpaq",
                "titrəmək",
                "yarpaq",
                "əsmək",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("ліст кружыцца ў паветры"),
            keywords: &[
                "ападанне",
                "вецер",
                "ліст",
                "ліст кружыцца ў паветры",
                "расліна",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Листо, носено от вятъра"),
            keywords: &[
                "Листо, носено от вятъра",
                "вятър",
                "листо",
                "носен",
                "растение",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ব\u{9be}ত\u{9be}সের মধ\u{9cd}যে প\u{9be}ত\u{9be} ওড\u{9bc}\u{9be}"),
            keywords: &[
                "গ\u{9be}ছ",
                "ঝ\u{9be}পট\u{9be}নি",
                "প\u{9be}ত\u{9be}",
                "ব\u{9be}ত\u{9be}সের মধ\u{9cd}যে প\u{9be}ত\u{9be} ওড\u{9bc}\u{9be}",
                "হ\u{9be}ওয\u{9bc}\u{9be}",
                "হ\u{9be}ল\u{9cd}ক\u{9be} হ\u{9be}ওয\u{9bc}\u{9be}",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("delienn en avel"),
            keywords: &["avel", "delienn", "delienn en avel"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("list leprša"),
            keywords: &["lepršanje", "list", "list leprša", "puhanje", "vjetar"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("fulla que vola amb el vent"),
            keywords: &["fulla", "fulla que vola amb el vent", "vent"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᎦᎶᎦ ᎦᏃᏰ ᎦᏃᎸᏍᎬᎢ"),
            keywords: &["ᎠᏦᏔᏍᏗ", "ᎤᎦᎶᎦ", "ᎤᎦᎶᎦ ᎦᏃᏰ ᎦᏃᎸᏍᎬᎢ", "ᎦᏃᎸᏍᎦ", "ᏓᎵᏐᏰ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("padající list ve větru"),
            keywords: &[
                "foukat",
                "list",
                "lístek",
                "padající list ve větru",
                "rostlina",
                "třepetající",
                "třepetat",
                "třepotající",
                "třepotat",
                "vánek",
                "vítr",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("deilen yn crynu yn y gwynt"),
            keywords: &[
                "chwythu",
                "crynu",
                "deilen",
                "deilen yn crynu yn y gwynt",
                "planhigyn",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("blade i vinden"),
            keywords: &["blad", "blade i vinden", "blæst", "vind"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Blätter im Wind"),
            keywords: &[
                "Blatt",
                "Blätter",
                "Blätter im Wind",
                "Laub",
                "Pflanze",
                "Wind",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("φύλλα στον άνεμο"),
            keywords: &[
                "άνεμος",
                "αέρας",
                "ανεμίζω",
                "φυτό",
                "φύλλα στον άνεμο",
                "φύλλο",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("leaf fluttering in wind"),
            keywords: &["blow", "flutter", "leaf", "leaf fluttering in wind", "wind"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("hojas revoloteando al viento"),
            keywords: &[
                "hoja",
                "hojas revoloteando al viento",
                "revolotear",
                "soplar",
                "viento",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("hoja al viento"),
            keywords: &["hoja al viento", "hojas", "soplar", "viento"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("tuules lendlev leht"),
            keywords: &["leht", "taim", "tuul", "tuules lendlev leht"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("haizeaz hegan ari den hostoa"),
            keywords: &["haize", "haizeaz hegan ari den hostoa", "hosto", "korronte"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("رقص برگ در باد"),
            keywords: &[
                "باد",
                "برگ",
                "حرکت در باد",
                "رقص برگ در باد",
                "وزیدن",
                "گیاه",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("lehti tuulessa"),
            keywords: &["kasvi", "lehti", "lehti tuulessa", "puhaltaa", "tuuli"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("dahong nililipad ng hangin"),
            keywords: &[
                "dahon",
                "dahong nililipad ng hangin",
                "halaman",
                "hangin",
                "nililipad",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("flagsandi bløð"),
            keywords: &["bløð", "flagsandi", "vindur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("feuille virevoltante"),
            keywords: &["feuille", "feuille virevoltante", "souffle", "vent"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["feuille", "virevoltante"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("duilleog ag séideadh sa ghaoth"),
            keywords: &[
                "duilleog",
                "duilleog ag séideadh sa ghaoth",
                "duilleog sa ghaoth",
                "gaoth",
                "séideadh",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("duilleag a’ falbh leis a’ ghaoith"),
            keywords: &[
                "duilleag",
                "duilleag a’ falbh leis a’ ghaoith",
                "gaoth",
                "sèideadh",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("folla ao vento"),
            keywords: &["folla", "folla ao vento", "planta", "vento"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પવનમા\u{a82} ઉડત\u{ac1}\u{a82} પર\u{acd}ણ"),
            keywords: &[
                "પર\u{acd}ણ",
                "પવન",
                "પવનમા\u{a82} ઉડત\u{ac1}\u{a82} પર\u{acd}ણ",
                "ફ\u{ac2}\u{a82}કાતો પવન",
                "ફ\u{ac2}\u{a82}કાવ\u{ac1}\u{a82}",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("ganye mai yin filfilwa a iska"),
            keywords: &[
                "ganye",
                "ganye mai yin filfilwa a iska",
                "iska",
                "kaɗa",
                "yi filfilwa",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("עלה עף ברוח"),
            keywords: &[
                "סתיו",
                "עלה נידף",
                "עלה עף ברוח",
                "עלים",
                "עלים עפים ברוח",
                "צמח",
                "רוח",
                "שלכת",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("हवा म\u{947}\u{902} पत\u{94d}ती"),
            keywords: &[
                "गिरता ह\u{941}आ",
                "गिरती पत\u{94d}ती",
                "पत\u{94d}ती",
                "हवा",
                "हवा म\u{947}\u{902} पत\u{94d}तिया\u{902}",
                "हवा म\u{947}\u{902} पत\u{94d}ती",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("list koji treperi na vjetru"),
            keywords: &[
                "list",
                "list koji treperi na vjetru",
                "puhanje",
                "treperenje",
                "vjetar",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("szélfútta levél"),
            keywords: &[
                "hulló",
                "lebegő",
                "levél",
                "növény",
                "szél",
                "szélfútta levél",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ճախրող տերևներ"),
            keywords: &["բույս", "թրթռալ", "ճախրող տերևներ", "տերև", "փչել", "քամի"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("daun tertiup angin"),
            keywords: &[
                "angin",
                "daun",
                "daun tertiup angin",
                "tanaman",
                "terbang",
                "tiup",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("akwụkwọ na-efesasi n’ikukù"),
            keywords: &[
                "akwụkwọ na-efesasi n’ikukù",
                "akwụkwọnri",
                "fepụ",
                "ikuku",
                "mfesasi",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("lauf í vindi"),
            keywords: &["lauf", "lauf í vindi", "laufblað", "vindur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("foglia al vento"),
            keywords: &["foglia", "foglia al vento", "vento", "vento che soffia"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("風に揺れる葉"),
            keywords: &["木の葉", "落ち葉", "風", "風に揺れる葉"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("godhong ngawe-ngawe kena angin"),
            keywords: &[
                "angin",
                "godhong",
                "godhong ngawe-awe kena angin",
                "godhong ngawe-ngawe kena angin",
                "ketiup",
                "ngawe-awe",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ქარში მოფარფატე ფოთოლი"),
            keywords: &[
                "მცენარე",
                "ფარფატი ფოთოლი",
                "ქარი",
                "ქარში მოფარფატე ფოთოლი",
            ],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("tamjiwect n ifriwen"),
            keywords: &["tamjiwect n ifriwen"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("желге ұшқан жапырақтар"),
            keywords: &[
                "жел",
                "жел соғу",
                "желге ұшу",
                "желге ұшқан жапырақтар",
                "өсімдік",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("blad i vinden"),
            keywords: &["blad", "blad i vinden", "blæst", "vind"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ស\u{17d2}ល\u{17b9}កឈើរសាត\u{17cb}តាមខ\u{17d2}យល\u{17cb}"),
            keywords: &[
                "ខ\u{17d2}យល\u{17cb}",
                "បក\u{17cb}",
                "ស\u{17d2}ល\u{17b9}កឈើ",
                "ស\u{17d2}ល\u{17b9}កឈើរសាត\u{17cb}តាមខ\u{17d2}យល\u{17cb}",
                "ស\u{17d2}ល\u{17b9}កឈើហើរ",
                "ហើរ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಗಾಳ\u{cbf}ಯಲ\u{ccd}ಲ\u{cbf} ತೇಲುತ\u{ccd}ತ\u{cbf}ರುವ ಎಲ\u{cc6}"),
            keywords: &[
                "ಗಾಳ\u{cbf} ಊದುವ",
                "ಗಾಳ\u{cbf}ಯಲ\u{ccd}ಲ\u{cbf} ಎಲ\u{cc6}",
                "ಗಾಳ\u{cbf}ಯಲ\u{ccd}ಲ\u{cbf} ತೇಲುತ\u{ccd}ತ\u{cbf}ರುವ ಎಲ\u{cc6}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("바람에 흔들리는 나뭇잎"),
            keywords: &["가을 낙엽", "바람에 떨어지는 잎", "바람에 흔들리는 나뭇잎"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("वाऱ\u{94d}यार हालपी पान"),
            keywords: &[
                "पान",
                "वार\u{947}\u{902}",
                "वाऱ\u{94d}यार हालपी पान",
                "व\u{94d}हा\u{902}वता",
                "हालता",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("шамалдан дирилдеген жалбырак"),
            keywords: &[
                "дирилде",
                "жалбырак",
                "шамал",
                "шамалдан дирилдеген жалбырак",
                "өсүмдүк",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("am Wand fléiend Blat"),
            keywords: &["Blat", "Wand", "am Wand fléiend Blat", "blosen", "fléien"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໃບໄມ\u{ec9}ປ\u{eb4}ວຕາມລ\u{ebb}ມ"),
            keywords: &[
                "ປ\u{eb4}ວ",
                "ລ\u{ebb}ມ",
                "ໃບໄມ\u{ec9}",
                "ໃບໄມ\u{ec9}ປ\u{eb4}ວຕາມລ\u{ebb}ມ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("lapas vėjyje"),
            keywords: &["lapas", "lapas vėjyje", "pūsti", "skrajoti", "vėjas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("vējā plīvojoša lapa"),
            keywords: &["augs", "lapa", "plīvot", "vējā plīvojoša lapa", "vējš"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("rau kapakapa hau"),
            keywords: &["hau", "kapakapa", "puhi", "rau"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("лист што се вее на ветрот"),
            keywords: &["вее", "ветер", "дува", "лист", "лист што се вее на ветрот"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ക\u{d3e}റ\u{d4d}റിൽ പറക\u{d4d}ക\u{d41}ന\u{d4d}ന ഇല"),
            keywords: &[
                "ക\u{d3e}റ\u{d4d}റിലെ ഇല",
                "ക\u{d3e}റ\u{d4d}റിൽ പറക\u{d4d}ക\u{d41}ന\u{d4d}ന ഇല",
                "ക\u{d3e}റ\u{d4d}റ\u{d4d}",
                "പറക\u{d4d}ക\u{d41}ന\u{d4d}ന ഇല",
                "മർമ\u{d4d}മരം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("салхинд хийсч буй навч"),
            keywords: &["навч", "салхи", "салхинд хийсч буй навч", "хийсэх"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("हव\u{947}त तर\u{902}गणार\u{947} पान"),
            keywords: &[
                "उडणार\u{947}",
                "पान",
                "वारा",
                "वाऱ\u{94d}यावर उडणार\u{947} पान",
                "वाहणारा वारा",
                "हव\u{947}त तर\u{902}गणार\u{947} पान",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("daun melayang ditiup angin"),
            keywords: &[
                "angin",
                "daun",
                "daun melayang ditiup angin",
                "kibar",
                "tiup",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("werqa tixxejjer fir-riħ"),
            keywords: &[
                "onfoħ",
                "riħ",
                "tixxejjer",
                "werqa",
                "werqa tixxejjer fir-riħ",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "လေန\u{103e}င\u{103a}ရာလ\u{103d}င\u{1037}\u{103a}နေသည\u{1037}\u{103a} အရ\u{103d}က\u{103a}",
            ),
            keywords: &[
                "တဖျပ\u{103a}ဖျပ\u{103a} ရစ\u{103a}ဝ\u{1032}ကျသည\u{103a}",
                "လေ",
                "လေန\u{103e}င\u{103a}ရာ လ\u{103d}င\u{1037}\u{103a}နေသည\u{1037}\u{103a} အရ\u{103d}က\u{103a}",
                "လေန\u{103e}င\u{103a}ရာလ\u{103d}င\u{1037}\u{103a}နေသည\u{1037}\u{103a} အရ\u{103d}က\u{103a}",
                "လ\u{103d}င\u{1037}\u{103a}သည\u{103a}",
                "အရ\u{103d}က\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("blader i vind"),
            keywords: &[
                "blader i vind",
                "blåse",
                "blåser",
                "blåst",
                "løv i vind",
                "vind",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("हावामा फरफराइहर\u{947}को पात"),
            keywords: &[
                "पात",
                "फरफराएको",
                "फ\u{94d}लटर",
                "हावा",
                "हावामा फरफराइहर\u{947}को पात",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("blad in de wind"),
            keywords: &["blad", "blad in de wind", "waaiend", "waait", "wind"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("blad i vind"),
            keywords: &["blad i vind", "blåse", "blåser", "lauv i vind", "vind"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପବନରେ ହଲ\u{b41}ଥ\u{b3f}ବ\u{b3e} ପତ\u{b4d}ର"),
            keywords: &[
                "ପତ\u{b4d}ର",
                "ପତ\u{b4d}ର ଉଡ\u{b3f}ବ\u{b3e}",
                "ପବନ ବହ\u{b3f}ବ\u{b3e}",
                "ପବନ ବୋହ\u{b3f}ବ\u{b3e}",
                "ପବନରେ ହଲ\u{b41}ଥ\u{b3f}ବ\u{b3e} ପତ\u{b4d}ର",
                "ବ\u{b3e}ୟ\u{b41}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਹਵਾ ਵਿ\u{a71}ਚ ਲਹਿਰਾਉ\u{a02}ਦ\u{a47} ਪ\u{a71}ਤ\u{a47}"),
            keywords: &[
                "ਪ\u{a71}ਤਾ",
                "ਬ\u{a42}ਟਾ",
                "ਵਗਣਾ",
                "ਹਵਾ",
                "ਹਵਾ ਵਿ\u{a71}ਚ ਪ\u{a71}ਤਾ",
                "ਹਵਾ ਵਿ\u{a71}ਚ ਲਹਿਰਾਉ\u{a02}ਦ\u{a47} ਪ\u{a71}ਤ\u{a47}",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ہوا وچ پھڑپھڑاندا پت\u{651}ا"),
            keywords: &[
                "اڈا لے جانا",
                "بت\u{651}ا",
                "پ\u{64e}راں نوں پھڑپھڑانا",
                "ہوا",
                "ہوا وچ پھڑپھڑاندا پت\u{651}ا",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Lif Wé Wind De Blo"),
            keywords: &["Blo", "Lif", "Lif Wé Wind De Blo", "Shek", "Wind"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("liście na wietrze"),
            keywords: &[
                "liście na wietrze",
                "podmuch",
                "roślina",
                "trzepotanie",
                "wiatr",
                "wicher",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("په باد کې خوزېدونکې پاڼه"),
            keywords: &[
                "الوتل، خوزېدل، پاڼه، په باد کې خوزېدونکې پاڼه، باد",
                "په باد کې خوزېدونکې پاڼه",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("folha ao vento"),
            keywords: &["folha", "folha ao vento", "soprando", "vento"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("folha a esvoaçar ao vento"),
            keywords: &[
                "esvoaçar",
                "folha",
                "folha a esvoaçar ao vento",
                "planta",
                "soprar",
                "vento",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("wayrapi laqhikuna"),
            keywords: &["laqhi", "pharaqiy", "phukuy", "wayra", "wayrapi laqhikuna"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("frunză plutind în aer"),
            keywords: &["frunză", "frunză plutind în aer", "plutire", "vânt"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-264"),
            keywords: &["E10-264"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("листья на ветру"),
            keywords: &["ветер", "листья", "листья на ветру"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikibabi gihuhwa n’umuyaga"),
            keywords: &[
                "guhuha",
                "ibabi",
                "ikibabi gihuhwa n’umuyaga",
                "kwizunguza",
                "umuyaga",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("هوا ۾ لڏندڙ پن"),
            keywords: &["لهر، هلندڙ، پن، هوا", "هوا ۾ لڏندڙ پن"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ස\u{dd4}ළඟේ ප\u{dcf}වෙන කොළ"),
            keywords: &[
                "කොළය",
                "ප\u{dcf}වෙන",
                "ස\u{dd4}ළඟ",
                "ස\u{dd4}ළඟට ගස\u{dcf}ගෙන යන",
                "ස\u{dd4}ළඟේ ප\u{dcf}වෙන කොළ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("list vo vetre"),
            keywords: &[
                "fúkať",
                "list",
                "list vo vetre",
                "rastlina",
                "vietor",
                "vánok",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("listje, ki se vrtinči v vetru"),
            keywords: &[
                "list",
                "listje, ki se vrtinči v vetru",
                "pihati",
                "rastlina",
                "veter",
                "vrtinčiti se",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("caleen dhex buubaysa dabaysha"),
            keywords: &[
                "buubid",
                "caleen",
                "caleen dhex buubaysa dabaysha",
                "dabayl",
                "heebaabid",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("gjethe që fluturon në erë"),
            keywords: &["erë", "fluturoj", "gjethe", "gjethe që fluturon në erë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("лист који лепрша на ветру"),
            keywords: &[
                "ветар",
                "дување",
                "лепршање",
                "лист",
                "лист који лепрша на ветру",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("лист који лепрша на вјетру"),
            keywords: &["лист који лепрша на вјетру"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("list koji leprša na vetru"),
            keywords: &[
                "duvanje",
                "lepršanje",
                "list",
                "list koji leprša na vetru",
                "vetar",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("list koji leprša na vjetru"),
            keywords: &["list koji leprša na vjetru"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("löv i vinden"),
            keywords: &[
                "blåser",
                "fladdrande",
                "höst",
                "löv",
                "löv i vinden",
                "vind",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("jani linalopepea kwenye upepo"),
            keywords: &[
                "jani linalopepea kwenye upepo",
                "mmea",
                "pepea",
                "puliza",
                "tawi",
                "upepo",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("க\u{bbe}ற\u{bcd}றில\u{bcd} ஆடும\u{bcd} இலைகள\u{bcd}"),
            keywords: &[
                "இலைகள\u{bcd}",
                "இலையுதிர\u{bcd}க\u{bbe}லம\u{bcd}",
                "உதிரும\u{bcd} இலைகள\u{bcd}",
                "க\u{bbe}ற\u{bcd}றில\u{bcd} ஆடும\u{bcd} இலைகள\u{bcd}",
                "பசுமை",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("గ\u{c3e}ల\u{c3f}క\u{c3f} వణ\u{c3f}క\u{c47} ఆకు"),
            keywords: &[
                "గ\u{c3e}ల\u{c3f}",
                "గ\u{c3e}ల\u{c3f}క\u{c3f} వణ\u{c3f}క\u{c47} ఆకు",
                "గ\u{c3e}ల\u{c3f}ల\u{c4b} ఆకు",
                "గ\u{c3e}ల\u{c3f}ల\u{c4b} త\u{c47}లడం",
                "గ\u{c3e}ల\u{c3f}ల\u{c4b} త\u{c47}ల\u{c47} ఆకులు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("барги дар шамол лаппида истода"),
            keywords: &[
                "барг",
                "барги дар шамол лаппида истода",
                "лаппидан",
                "пуф кардан",
                "шамол",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ใบไม\u{e49}ปล\u{e34}ว"),
            keywords: &[
                "ปล\u{e34}ว",
                "พ\u{e37}ช",
                "ลมพ\u{e31}ด",
                "ใบไม\u{e49}",
                "ใบไม\u{e49}ปล\u{e34}ว",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("şemala galgaýan ýaprak"),
            keywords: &[
                "galgamak",
                "üflemek",
                "ýaprak",
                "şemal",
                "şemala galgaýan ýaprak",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("lau ngaungaue matangi"),
            keywords: &["lau ngaungaue matangi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("rüzgardaki yaprak"),
            keywords: &["esen", "rüzgar", "rüzgardaki yaprak", "yaprak"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("لەيلىگەن يوپۇرماق"),
            keywords: &[
                "شامال",
                "لەيلىگەن يوپۇرماق",
                "لەيلەش",
                "لەپىلدەش",
                "يوپۇرماق",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("листя, що кружляє за вітром"),
            keywords: &[
                "вітер",
                "дути",
                "кружляти",
                "листок",
                "листя",
                "листя, що кружляє за вітром",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ہوا میں پھڑپھڑاتے پتے"),
            keywords: &["پتا", "پودا", "ہوا", "ہوا میں پھڑپھڑاتے پتے"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("shamolda uchayotgan barg"),
            keywords: &[
                "barg",
                "o‘simlik",
                "shamol",
                "shamolda uchayotgan barg",
                "uchish",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("lá rung rinh trong gió"),
            keywords: &["gió", "lá cây", "lá rung rinh trong gió", "rung", "thổi"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("xob wu gelaw yëngal"),
            keywords: &["ngelaw", "xob", "xob wu gelaw yëngal", "yëngu", "ëf"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("igqabi eliphaphathekayo emoyeni"),
            keywords: &[
                "igqabi",
                "igqabi eliphaphathekayo emoyeni",
                "phaphatheka",
                "phaphathekisa",
                "umoya",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ewe Ti N Fanka Ninu Iji"),
            keywords: &["Ewe Ti N Fanka Ninu Iji", "Ewé", "afẹfẹ", "fo bákàn", "fẹ"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("風中嘅飄葉"),
            keywords: &["吹", "葉", "風", "風中嘅飄葉", "飄動"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("风中嘅飘叶"),
            keywords: &["叶", "吹", "风", "风中嘅飘叶", "飘动"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("风吹叶落"),
            keywords: &["叶子", "树叶", "随风飘舞", "风吹叶落"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("隨風飄落的葉子"),
            keywords: &["隨風飄落的葉子", "風吹葉落"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("隨風飄落嘅樹葉"),
            keywords: &["落葉", "隨風飄落嘅樹葉"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("iqabunga eliphephethwa umoya"),
            keywords: &[
                "iqabunga",
                "iqabunga eliphephethwa umoya",
                "isitshalo",
                "phephetha",
                "umoya",
            ],
        },
    ],
};
