#[doc = "💐"]
pub const BOUQUET: crate::Emoji = crate::Emoji {
    glyph: "💐",
    codepoint: "1F490",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "bouquet",
    group: "Animals & Nature",
    subgroup: "plant-flower",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("ruiker"),
            keywords: &["blom", "plant", "romanse", "ruiker"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("እቅፍ አበባ"),
            keywords: &["ተክል", "አበባ", "እቅፍ አበባ", "ፍቅር"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("باقة زهور"),
            keywords: &["باقة زهور", "رومانسية", "ورد"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("তোৰ\u{9be}"),
            keywords: &["তোৰ\u{9be}", "ফ\u{9c1}ল"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("buket"),
            keywords: &["buket", "gül"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("букет"),
            keywords: &["букет", "кветка", "расліна"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("букет"),
            keywords: &["букет", "растение", "романтика", "цвете"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ফ\u{9c1}লের তোড\u{9bc}\u{9be}"),
            keywords: &[
                "গ\u{9be}ছ",
                "ফ\u{9c1}ল",
                "ফ\u{9c1}লের তোড\u{9bc}\u{9be}",
                "রোম\u{9be}ন\u{9cd}স",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("boked bleunioù"),
            keywords: &["bleunioù", "boked"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("buket"),
            keywords: &["biljka", "buket", "cvijet"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("ram de flors"),
            keywords: &["flor", "planta", "ram de flors"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏧᏂᏥᎸᏍᎩ"),
            keywords: &["ᎤᏥᎸᏍᎩ", "ᏧᏂᏥᎸᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("kytice"),
            keywords: &[
                "květina",
                "kytice",
                "kytička",
                "kytka",
                "pugét",
                "romance",
                "romantika",
                "rostlina",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("tusw"),
            keywords: &["blodyn", "planhigyn", "tusw"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("blomsterbuket"),
            keywords: &["blomster", "blomsterbuket", "buket"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Blumenstrauß"),
            keywords: &["Blumen", "Blumenstrauß", "Bouquet"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("Blumenstrauss"),
            keywords: &["Blumen", "Blumenstrauss", "Bouquet"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μπουκέτο λουλούδια"),
            keywords: &["λουλούδι", "μπουκέτο λουλούδια", "ρομαντισμός", "φυτό"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("bouquet"),
            keywords: &["bouquet", "flower"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("ramo de flores"),
            keywords: &["bouquet", "flores", "ramo", "ramo de flores", "romance"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kimp"),
            keywords: &["kimp", "lill", "romantika", "taim"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("lore sorta"),
            keywords: &["lore", "sorta"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دسته گل"),
            keywords: &["دسته گل", "عاشقانه", "گل", "گیاه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kukkakimppu"),
            keywords: &["kasvi", "kukka", "kukkakimppu", "romantiikka"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("bungkos ng mga bulaklak"),
            keywords: &[
                "bouquet",
                "bulaklak",
                "bungkos ng mga bulaklak",
                "halaman",
                "pag-ibig",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("blómutyssi"),
            keywords: &["blomstur", "blóma", "blómutyssi", "buket"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("bouquet"),
            keywords: &["bouquet", "fleur", "plante"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("crobhaing bláthanna"),
            keywords: &["bláth", "crobhaing bláthanna"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("bad fhlùraichean"),
            keywords: &["bad fhlùraichean", "flùr"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("ramo de flores"),
            keywords: &["flores", "ramo", "ramo de flores"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("બ\u{ac1}ક\u{ac7}"),
            keywords: &["પ\u{ac1}ષ\u{acd}પ", "બ\u{ac1}ક\u{ac7}", "રોમા\u{a82}સ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("jerin fure"),
            keywords: &["fure", "jerin fure"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("זר פרחים"),
            keywords: &["זר", "פרחים", "רומנטי", "רומנטיקה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("फ\u{942}ल, फ\u{942}लग\u{941}च\u{94d}छ"),
            keywords: &[
                "प\u{94d}यार",
                "फ\u{942}ल",
                "फ\u{942}ल, फ\u{942}लग\u{941}च\u{94d}छ",
                "फ\u{942}लग\u{941}च\u{94d}छ",
                "ब\u{941}क\u{947}",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("buket"),
            keywords: &["biljka", "buket", "cvijet", "romantika"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("csokor"),
            keywords: &["csokor", "romantika", "virág", "virágcsokor"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ծաղկեփունջ"),
            keywords: &["բույս", "ծաղիկ", "ծաղկեփունջ", "սիրավեպ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("karangan bunga"),
            keywords: &["bunga", "karangan bunga", "romantis", "tanaman"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ukwu-ihe"),
            keywords: &["okooko", "ukwu-ihe"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("blómvöndur"),
            keywords: &["blóm", "blómvöndur", "rómantík"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("mazzo di fiori"),
            keywords: &["fiore", "mazzo di fiori", "romanticismo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("花束"),
            keywords: &["ブーケ", "花", "花束"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("buket"),
            keywords: &["buket", "kembang"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("თაიგული"),
            keywords: &["თაიგული", "მცენარე", "რომანტიკა", "ყვავილი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("tafuseț"),
            keywords: &["tafuseț"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("гул шоғы"),
            keywords: &["гул шоғы", "гүл", "романтика", "өсімдік"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("blomsterbuket"),
            keywords: &["blomster", "blomsterbuket", "buket"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("បាច\u{17cb}ផ\u{17d2}កា"),
            keywords: &["បាច\u{17cb}ផ\u{17d2}កា", "ផ\u{17d2}កា"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪುಷ\u{ccd}ಪಗುಚ\u{ccd}ಛ"),
            keywords: &["ಪುಷ\u{ccd}ಪಗುಚ\u{ccd}ಛ", "ಹ\u{cc2}ವು"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("꽃다발"),
            keywords: &["꽃", "꽃다발", "부케"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ग\u{941}च\u{94d}छ"),
            keywords: &["ग\u{941}च\u{94d}छ", "फ\u{942}ल"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("гүлдесте"),
            keywords: &["гүл", "гүлдесте", "романтика", "өсүмдүк"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Blummebouquet"),
            keywords: &["Blumm", "Blummebouquet"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຊ\u{ecd}\u{ec8}ດອກໄມ\u{ec9}"),
            keywords: &["ຊ\u{ecd}\u{ec8}ດອກໄມ\u{ec9}", "ດອກໄມ\u{ec9}"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("puokštė"),
            keywords: &["gėlė", "puokštė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("pušķis"),
            keywords: &["pušķis", "romantika", "ziedi"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tākai putiputi"),
            keywords: &["putiputi", "tākai putiputi"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("букет"),
            keywords: &["букет", "растение", "романтика", "цвет"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പ\u{d42}ച\u{d4d}ചെണ\u{d4d}ട\u{d4d}"),
            keywords: &[
                "പ\u{d41}ഷ\u{d4d}പം",
                "പ\u{d42}ച\u{d4d}ചെണ\u{d4d}ട\u{d4d}",
                "പ\u{d4d}രണയം",
                "ബൊക\u{d4d}കെ",
                "റൊമ\u{d3e}ൻസ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("цэцгийн баглаа"),
            keywords: &["баглаа", "ургамал", "цэцгийн баглаа", "цэцэг"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("प\u{941}ष\u{94d}पग\u{941}च\u{94d}छ"),
            keywords: &["प\u{941}ष\u{94d}पग\u{941}च\u{94d}छ", "फ\u{942}ल"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("sejambak bunga"),
            keywords: &["bunga", "sejambak bunga"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("bukkett"),
            keywords: &["bukkett", "fjura"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပန\u{103a}းစည\u{103a}း"),
            keywords: &["ပန\u{103a}း", "ပန\u{103a}းစည\u{103a}း"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("bukett"),
            keywords: &["blomst", "blomster", "bukett", "romantikk"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ब\u{941}क\u{947}"),
            keywords: &[
                "फ\u{942}ल",
                "बिर\u{942}वा",
                "ब\u{941}क\u{947}",
                "मनोरन\u{94d}जन",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("boeket"),
            keywords: &["bloem", "boeket"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("bukett"),
            keywords: &["blomster", "blomstrar", "bukett", "romantikk"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପ\u{b41}ଷ\u{b4d}ପଗ\u{b41}ଚ\u{b4d}ଛ"),
            keywords: &["ପ\u{b41}ଷ\u{b4d}ପଗ\u{b41}ଚ\u{b4d}ଛ", "ଫ\u{b41}ଲ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਗ\u{a41}ਲਦਸਤਾ"),
            keywords: &["ਗ\u{a41}ਲਦਸਤਾ", "ਪਿਆਰ", "ਫ\u{a41}\u{a71}ਲ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("گلدستہ"),
            keywords: &["پھ\u{64f}ل", "گلدستہ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Bọ\u{301}nch Ọf Fláwa"),
            keywords: &["Bọ\u{301}nch Ọf Fláwa", "Fláwa"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("bukiet kwiatów"),
            keywords: &["bukiet", "bukiet kwiatów", "kwiaty"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("دګلوګېډى"),
            keywords: &["دګلوګېډى", "دګلوګېډى، ګل"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("buquê"),
            keywords: &["buquê", "flor"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("ramo de flores"),
            keywords: &["flor", "planta", "ramo de flores", "romance"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("tʼikakunamanta"),
            keywords: &["tʼikakunamanta", "t’ika"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("buchet de flori"),
            keywords: &["buchet de flori", "cadou", "flori"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-589"),
            keywords: &["E10-589"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("букет"),
            keywords: &["букет", "любовь", "цветы"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umufungo w’indabyo"),
            keywords: &["umufungo w’indabyo", "ururabo"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("گلدستو"),
            keywords: &["گل", "گلدستو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("මල\u{dca} පොක\u{dd4}ර"),
            keywords: &[
                "ප\u{dca}\u{200d}රේමය",
                "පැලය",
                "මල",
                "මල\u{dca} පොක\u{dd4}ර",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("kytica"),
            keywords: &["kvetina", "kytica", "rastlina", "romanca"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("šopek"),
            keywords: &["rastlina", "romanca", "roža", "šopek"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("ubaxyo"),
            keywords: &["ubax", "ubaxyo", "ubayo"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("buqetë"),
            keywords: &["bimë", "buqetë", "lule", "romancë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("букет"),
            keywords: &["букет", "цвет"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["букет"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("buket"),
            keywords: &["buket", "cvet"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["buket"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("blombukett"),
            keywords: &["blombukett", "blommor", "kärlek"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("shada la maua"),
            keywords: &["mapenzi", "mmea", "shada la maua", "ua"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மலர\u{bcd}க\u{bcd}கொத\u{bcd}து"),
            keywords: &[
                "க\u{bbe}தல\u{bcd}",
                "பூங\u{bcd}கொத\u{bcd}து",
                "மலர\u{bcd}கள\u{bcd}",
                "மலர\u{bcd}க\u{bcd}கொத\u{bcd}து",
                "ரொம\u{bbe}ன\u{bcd}ஸ\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("పూలగుత\u{c4d}త\u{c3f}"),
            keywords: &["గుత\u{c4d}త\u{c3f}", "పూలగుత\u{c4d}త\u{c3f}", "పూలు"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("Гулдаста"),
            keywords: &["Гулдаста", "гул"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ช\u{e48}อดอกไม\u{e49}"),
            keywords: &["ช\u{e48}อดอกไม\u{e49}", "ดอกไม\u{e49}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("desse"),
            keywords: &["desse", "gül"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("haʻinga matalaʻiʻakau"),
            keywords: &["haʻinga matalaʻiʻakau"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("buket"),
            keywords: &["buket", "romantizm", "çiçek"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("گۈلدەستە"),
            keywords: &["چېچەك", "گۈلدەستە"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("букет"),
            keywords: &["букет", "квітка", "кохання", "рослина"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("گلدستہ"),
            keywords: &["پودہ", "پھول", "گلدستہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("guldasta"),
            keywords: &["gul", "guldasta", "o‘simlik", "romantika"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bó hoa"),
            keywords: &["bó", "hoa"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("takkufulër"),
            keywords: &["fulër", "takkufulër"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-bouquet"),
            keywords: &["i-bouquet", "intyatyambo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Àsè"),
            keywords: &["Odòdó", "Àsè"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("花束"),
            keywords: &["花", "花束"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("花束"),
            keywords: &["花", "花束"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("花束"),
            keywords: &["花束", "鲜花"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("花束"),
            keywords: &["花束", "鮮花"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["一紮花", "花束", "鬱金香花束"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isixha sezimbali"),
            keywords: &["imbali", "isitshalo", "isixha sezimbali"],
        },
    ],
};
#[doc = "🌸"]
pub const CHERRY_BLOSSOM: crate::Emoji = crate::Emoji {
    glyph: "🌸",
    codepoint: "1F338",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "cherry blossom",
    group: "Animals & Nature",
    subgroup: "plant-flower",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("kersiebloeisel"),
            keywords: &["bloeisel", "blom", "kersie", "kersiebloeisel", "plant"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የሚፈካ ቼሪ አበባ"),
            keywords: &["ተክል", "ቼሪ", "አበባ", "የሚፈካ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}زهرة الكرز"),
            keywords: &["زهرة", "\u{202b}زهرة الكرز"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("চেৰী প\u{9c1}ষ\u{9cd}প"),
            keywords: &["চেৰী", "প\u{9c1}ষ\u{9cd}প", "ফ\u{9c1}ল"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("albalı çiçəyi"),
            keywords: &["albalı", "albalı çiçəyi", "bitki", "gül", "çiçək"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("вішнёвая квецень"),
            keywords: &["вішня", "вішнёвая квецень", "кветка", "квецень", "расліна"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Черешов цвят"),
            keywords: &["Черешов цвят", "растение", "цвете", "цвят", "череша"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("চেরি ব\u{9cd}লজম"),
            keywords: &[
                "গ\u{9be}ছ",
                "চেরি",
                "চেরি ব\u{9cd}লজম",
                "ফ\u{9c1}ল",
                "বিকশিত হওয\u{9bc}\u{9be}",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("bleunienn gerez"),
            keywords: &["bleunienn gerez", "bleuñv", "kerez"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("cvijet višnje"),
            keywords: &["behar", "biljka", "cvijet", "cvijet višnje"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("flor de cirerer"),
            keywords: &["cirerer", "flor", "flor de cirerer"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎩᏔᏯ ᎤᏥᎸᏅ"),
            keywords: &["ᎤᏥᎸᏅ", "ᎤᏥᎸᏍᎩ", "ᎩᏔᏯ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("třešňový květ"),
            keywords: &["květ", "květina", "rostlina", "třešeň", "třešňový květ"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("blodeuyn ceirios"),
            keywords: &["blodeuyn", "blodyn", "ceirios", "planhigyn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kirsebærblomst"),
            keywords: &[
                "blomst",
                "blomstrende kirsebær",
                "kirsebær",
                "kirsebærblomst",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Kirschblüte"),
            keywords: &["Blume", "Blüte", "Kirschblüte", "Kirsche", "Pflanze"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("άνθος κερασιάς"),
            keywords: &["άνθος", "άνθος κερασιάς", "κερασιά", "λουλούδι", "φυτό"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("cherry blossom"),
            keywords: &["blossom", "cherry", "flower"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("flor de cerezo"),
            keywords: &["cerezo", "flor", "flor de cerezo", "primavera"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kirsiõis"),
            keywords: &["kirsiõis", "kirss", "lill", "taim", "õis"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("gereziondo-lorea"),
            keywords: &["gereziondo-lorea", "gereziondoa", "loratu", "lorea"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("شکوفه گیلاس"),
            keywords: &["شکوفه", "گل", "گیاه", "گیلاس"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kirsikankukka"),
            keywords: &["kasvi", "kirsikankukka", "kirsikka", "kukka"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("cherry blossom"),
            keywords: &["bulaklak", "cherry blossom", "halaman", "sakura"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("kirsuberblóma"),
            keywords: &["blomstur", "blóma", "kirsuber", "kirsuberblóma"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("fleur de cerisier"),
            keywords: &["fleur", "fleur de cerisier"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["cerisier", "fleur", "fleur de cerisier"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("bláth silíní"),
            keywords: &["bláth", "bláth silíní", "silín"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("blàth siris"),
            keywords: &["blàth", "flùr", "siris"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("flor de cerdeira"),
            keywords: &["cerdeira", "cereixa", "flor", "flor de cerdeira"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ચ\u{ac7}રી બ\u{acd}લોઝમ"),
            keywords: &[
                "ચ\u{ac7}રી",
                "ચ\u{ac7}રી બ\u{acd}લોઝમ",
                "પ\u{ac1}ષ\u{acd}પ",
                "પ\u{ac1}ષ\u{acd}પ જોવ\u{ac1}\u{a82}",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("hudar cherry"),
            keywords: &["cherry", "fure", "huda", "hudar cherry"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פריחת דובדבן"),
            keywords: &["דובדבן", "פרח", "פריחה", "פריחת דובדבן", "פריחת הדובדבן"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("च\u{948}री ब\u{94d}लॉसम"),
            keywords: &[
                "च\u{948}री",
                "च\u{948}री ब\u{94d}लॉसम",
                "फ\u{942}ल",
                "फ\u{942}ल द\u{947}खना",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("trešnjin cvijet"),
            keywords: &["biljka", "cvijet", "trešnja", "trešnjin cvijet"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("cseresznyevirág"),
            keywords: &["cseresznye", "cseresznyevirág", "virág"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բալենու ծաղիկ"),
            keywords: &["բալ", "բալենու ծաղիկ", "բույս", "ծաղիկ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("sakura"),
            keywords: &["bunga", "mekar", "sakura", "tanaman"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nchapụta cheri"),
            keywords: &["cheri", "nchapụta", "okooko"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kirsuberjablóm"),
            keywords: &["blóm", "kirsuber", "kirsuberjablóm"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("fiore di ciliegio"),
            keywords: &["ciliegio", "fiore", "fiore di ciliegio"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("桜"),
            keywords: &["桜", "花"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("sakura"),
            keywords: &["kembang", "mekar", "sakura"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("აყვავებული ალუბალი"),
            keywords: &[
                "ალუბალი",
                "აყვავება",
                "აყვავებული ალუბალი",
                "ბალი",
                "მცენარე",
                "ყვავილი",
            ],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("ajeğğig n taknisya"),
            keywords: &["ajeğğig n taknisya"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("шие гүлі"),
            keywords: &["гүл", "шие", "шие гүлі", "өсімдік"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("kirsebærblomst"),
            keywords: &[
                "blomst",
                "blomstrende kirsebær",
                "kirsebær",
                "kirsebærblomst",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ផ\u{17d2}កាឈើរ\u{17b8}រ\u{17b8}ក"),
            keywords: &[
                "ឈើរ\u{17b8}",
                "ផ\u{17d2}កា",
                "ផ\u{17d2}កាឈើរ\u{17b8}រ\u{17b8}ក",
                "រ\u{17b8}ក",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಚ\u{cc6}ರ\u{ccd}ರ\u{cbf} ಹ\u{cc2}ವು"),
            keywords: &[
                "ಚ\u{cc6}ರ\u{ccd}ರ\u{cbf}",
                "ಚ\u{cc6}ರ\u{ccd}ರ\u{cbf} ಹ\u{cc2}ವು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("벚꽃"),
            keywords: &["꽃", "꽃송이", "벚꽃"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("जास\u{94d}व\u{902}द कळी"),
            keywords: &["कळी", "जास\u{94d}व\u{902}द", "फ\u{942}ल"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("чие гүлү"),
            keywords: &["гүл", "чие", "чие гүлү", "өсүмдүк"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Kiischtebléi"),
            keywords: &["Blumm", "Bléi", "Kiischt", "Kiischtebléi"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ດອກເຊ\u{eb5}ຣ\u{eb5}ບານ"),
            keywords: &["ດອກເຊ\u{eb5}ຣ\u{eb5}ບານ", "ດອກໄມ\u{ec9}"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("vyšnios žiedas"),
            keywords: &["gėlė", "vyšnia", "vyšnios žiedas", "žydėti"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("ķiršu zieds"),
            keywords: &["augs", "zieds", "ķirši", "ķiršu zieds"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("putiputi tieri"),
            keywords: &["putiputi", "puāwai", "tieri"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("цут од цреша"),
            keywords: &["растение", "цвет", "цреша", "цут", "цут од цреша"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ചെറി പ\u{d41}ഷ\u{d4d}പം"),
            keywords: &[
                "ചെറി",
                "പ\u{d41}ഷ\u{d4d}പം",
                "പ\u{d42}വ\u{d4d}",
                "ബ\u{d4d}ലോസ\u{d4d}സം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("интоорын цэцэг"),
            keywords: &["интоор", "интоорын цэцэг", "ургамал", "цэцэг"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("उमलल\u{947}ली च\u{947}री"),
            keywords: &[
                "उमलल\u{947}ली च\u{947}री",
                "च\u{947}री",
                "च\u{947}री फ\u{941}लण\u{947}",
                "फ\u{941}लल\u{947}ली च\u{947}री",
                "फ\u{942}ल",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bunga sakura"),
            keywords: &["bunga", "mekar", "sakura", "tumbuhan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("fjur taċ-ċirasa"),
            keywords: &["fjur", "fjur taċ-ċirasa", "fjuri", "ċirasa"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ချယ\u{103a}ရ\u{102e}ပန\u{103a}း"),
            keywords: &[
                "ချယ\u{103a}ရ\u{102e}ပန\u{103a}း",
                "ပန\u{103a}း",
                "ပန\u{103a}းပ\u{103d}င\u{1037}\u{103a}ခြင\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kirsebærblomst"),
            keywords: &["blomst", "kirsebær", "kirsebærblomst"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("च\u{947}री फ\u{941}ल\u{94d}न\u{947}"),
            keywords: &[
                "च\u{947}री",
                "फ\u{941}ल\u{94d}न\u{947}",
                "फ\u{942}ल",
                "बिर\u{942}वा",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("kersenbloesem"),
            keywords: &["bloem", "bloesem", "kers", "kersenbloesem"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kirsebærblomster"),
            keywords: &["blomster", "kirsebær", "kirsebærblomster"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଚେରୀ ବ\u{b4d}ଲସମ\u{b4d} ଫ\u{b41}ଲ"),
            keywords: &[
                "ଚେର\u{b3f}",
                "ଚେରୀ ବ\u{b4d}ଲସମ\u{b4d} ଫ\u{b41}ଲ",
                "ଫ\u{b41}ଲ",
                "ଫ\u{b41}ଲ କଢ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਚ\u{a48}ਰੀ ਫ\u{a41}\u{a71}ਲ"),
            keywords: &[
                "ਚ\u{a48}ਰੀ",
                "ਫ\u{a41}\u{a71}ਲ",
                "ਫ\u{a41}\u{a71}ਲ ਦ\u{a47}ਖਣਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("چیری دا ک\u{650}ھلنا"),
            keywords: &[
                "پھلاں دا ک\u{650}ھلنا",
                "پھ\u{64f}ل",
                "چیری",
                "چیری دا ک\u{650}ھلنا",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Chẹ\u{301}rí Fláwa"),
            keywords: &[
                "Bọ\u{301}nch Ọf Fláwa",
                "Chẹ\u{301}ri",
                "Chẹ\u{301}rí Fláwa",
                "Fláwa",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kwiat wiśni"),
            keywords: &["kwiat wiśni", "kwitnąca wiśnia"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د سرکۍ ګل"),
            keywords: &["د سرکۍ ګل", "ګل، سرکۍ، ګل"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("flor de cerejeira"),
            keywords: &["cereja", "cerejeira", "flor", "flor de cerejeira"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cerejeira em flor"),
            keywords: &[
                "cerejeira",
                "cerejeira em flor",
                "em flor",
                "flor",
                "planta",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("cerezo tʼika"),
            keywords: &["cerezo tʼika", "cherry", "t’ika"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("floare de cireș"),
            keywords: &["cireș", "floare", "floare de cireș", "parfum", "pom"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-253"),
            keywords: &["E10-253"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("цветок вишни"),
            keywords: &["сакура", "цветок", "цветок вишни"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("igiti gifite imbuto z’umutuku"),
            keywords: &["igiti gifite imbuto z’umutuku", "kwera", "sheri", "ururabo"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("چيري بلاسم"),
            keywords: &["بلاسم، چيري، گل", "چيري بلاسم"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("චෙර\u{dd2} මල"),
            keywords: &["චෙර\u{dd2}", "පැළය", "මල", "මල\u{dca} ප\u{dd2}ප\u{dd3}ම"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("čerešňový kvet"),
            keywords: &["kvet", "kvetina", "rastlina", "čerešňa", "čerešňový kvet"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("češnjev cvet"),
            keywords: &["cvet", "rastlina", "roža", "češnja", "češnjev cvet"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("ubaxa buundada"),
            keywords: &["ubax", "ubax cas", "ubax geed", "ubaxa buundada"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("lule qershie"),
            keywords: &["lule", "lule qershie", "lulëzim", "pemë", "qershi"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("цвет трешње"),
            keywords: &["трешња", "цвет", "цвет трешње"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("цвијет трешње"),
            keywords: &["цвијет трешње"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("cvet trešnje"),
            keywords: &["cvet", "cvet trešnje", "trešnja"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("cvijet trešnje"),
            keywords: &["cvijet trešnje"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("körsbärsblomma"),
            keywords: &["blomma", "körsbär", "körsbärsblomma"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("ua la mcheri"),
            keywords: &["chanua", "cheri", "mmea", "ua", "ua la mcheri"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("செர\u{bcd}ரி பில\u{bbe}ஸம\u{bcd}"),
            keywords: &[
                "செர\u{bcd}ரி பில\u{bbe}ஸம\u{bcd}",
                "செர\u{bcd}ரிபில\u{bbe}ஸம\u{bcd}",
                "மலர\u{bcd}",
                "வசந\u{bcd}தம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("చ\u{c46}ర\u{c4d}ర\u{c40} పువ\u{c4d}వు"),
            keywords: &["చ\u{c46}ర\u{c4d}ర\u{c40}", "పువ\u{c4d}వు"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("гули гелос"),
            keywords: &["гелос", "гул", "гул кардан", "гули гелос"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ดอกซาก\u{e38}ระ"),
            keywords: &["ดอกซาก\u{e38}ระ", "ดอกไม\u{e49}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ülje güli"),
            keywords: &["gül", "güllemek", "ülje güli"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("matalaʻi-seli"),
            keywords: &["matalaʻi-seli"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kiraz çiçeği"),
            keywords: &["kiraz", "kiraz çiçeği", "çiçek", "çiçek izleme"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("گىلاس چېچىكى"),
            keywords: &["غۇنچە", "گىلاس", "گىلاس چېچىكى", "گۈل"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("вишневий цвіт"),
            keywords: &["вишневий цвіт", "вишня", "квітка", "рослина", "цвіт"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("چیری بلاسم"),
            keywords: &["بلاسم", "پودہ", "پھول", "چیری"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("gilos guli"),
            keywords: &["gilos", "gilos guli", "gul", "gullash"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("hoa anh đào"),
            keywords: &["hoa", "hoa anh đào", "thực vật"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("fulóor yu am melo sëriis"),
            keywords: &["fulër", "fulóor yu am melo sëriis", "sëriis"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("intyatyambo ye-cherry"),
            keywords: &[
                "i-cherry",
                "intyatyambo",
                "intyatyambo ye-cherry",
                "ukudubula",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Iruwe Ṣẹri"),
            keywords: &["Iruwe Ṣẹri", "Odòdó", "ìtànná", "ṣẹẹri"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("櫻花"),
            keywords: &["櫻花", "花", "開花"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("樱花"),
            keywords: &["开花", "樱花", "花"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("樱花"),
            keywords: &["樱花", "花"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("櫻花"),
            keywords: &["櫻花", "花"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ukhukhula kwembali"),
            keywords: &["imbali", "isitsahlo", "ukhukhula kwembali", "ukuqhakaza"],
        },
    ],
};
#[doc = "💮"]
pub const WHITE_FLOWER: crate::Emoji = crate::Emoji {
    glyph: "💮",
    codepoint: "1F4AE",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "white flower",
    group: "Animals & Nature",
    subgroup: "plant-flower",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("wit blom"),
            keywords: &["blom", "wit"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ነጭ አበባ"),
            keywords: &["ነጭ አበባ", "አበባ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وردة بيضاء"),
            keywords: &["زهور", "طابع", "وردة بيضاء"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("বগ\u{9be} ফ\u{9c1}ল"),
            keywords: &["ফ\u{9c1}ল", "বগ\u{9be} ফ\u{9c1}ল"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("ağ gül"),
            keywords: &["ağ gül", "gül"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("белая кветка"),
            keywords: &["белая кветка", "кветка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Бяло цвете"),
            keywords: &["Бяло цвете", "цвете"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("স\u{9be}দ\u{9be} ফ\u{9c1}ল"),
            keywords: &["ফ\u{9c1}ল", "স\u{9be}দ\u{9be} ফ\u{9c1}ল"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("bleunienn wenn"),
            keywords: &["bleunienn wenn", "bleuñv"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("bijeli cvijet"),
            keywords: &["bijeli cvijet", "cvijet"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("flor blanca"),
            keywords: &["blanca", "flor"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄘\u{1112a}𑄛\u{11134} 𑄜\u{1112a}𑄣\u{11134}"),
            keywords: &["𑄘\u{1112a}𑄛\u{11134} 𑄜\u{1112a}𑄣\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏁᎦ ᎤᏥᎸᏍᎩ"),
            keywords: &["ᎤᏁᎦ ᎤᏥᎸᏍᎩ", "ᎤᏥᎸᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("bílá květina"),
            keywords: &["bílá květina", "květ", "květina"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("blodyn gwyn"),
            keywords: &["blodyn", "blodyn gwyn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("hvid blomst"),
            keywords: &["blomst", "hvid blomst"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Blumenstempel"),
            keywords: &["Blume", "Blumenstempel"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("λευκό λουλούδι"),
            keywords: &["λευκό λουλούδι", "λουλούδι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("white flower"),
            keywords: &["flower", "white flower"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("flor blanca"),
            keywords: &["blanca", "flor"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["flor", "flor blanca", "sello"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("valge lill"),
            keywords: &["lill", "valge lill"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("lore zuria"),
            keywords: &["lore", "lore zuria"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("گل سفید"),
            keywords: &["گل", "گل سفید"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("valkoinen kukka"),
            keywords: &["kukka", "valkoinen kukka"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("white flower"),
            keywords: &["bulaklak", "puti", "white flower"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("hvít blóma"),
            keywords: &["blomstur", "blóma", "hvít blóma"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("fleur blanche"),
            keywords: &["fleur", "fleur blanche"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["blanche", "fleur"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("bláth bán"),
            keywords: &["bláth", "bláth bán"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("flùr geal"),
            keywords: &["flùr", "flùr geal"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("flor branca"),
            keywords: &["flor", "flor branca"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("શ\u{acd}વ\u{ac7}ત ફ\u{ac2}લ"),
            keywords: &[
                "ફ\u{ac2}લ",
                "ફ\u{ac2}લનો સિક\u{acd}કો",
                "શ\u{acd}વ\u{ac7}ત ફ\u{ac2}લ",
                "સરસ કર\u{acd}ય\u{ac1}\u{a82}નો સિક\u{acd}કો",
                "સિક\u{acd}કો",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("farin fure"),
            keywords: &["farin fure", "fure"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פרח לבן"),
            keywords: &["עיטור", "פרח", "פרח לבן"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("फ\u{942}ल की छाप"),
            keywords: &[
                "छाप",
                "फ\u{942}ल",
                "फ\u{942}ल की छाप",
                "बह\u{941}त अच\u{94d}छ\u{947} काम की छाप",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("bijeli cvijet"),
            keywords: &["bijeli cvijet", "cvijet"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("fehér virág"),
            keywords: &["fehér virág", "növény", "virág"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("սպիտակ ծաղիկ"),
            keywords: &["ծաղիկ", "սպիտակ ծաղիկ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("bunga putih"),
            keywords: &["bunga", "bunga putih"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("okooko ọcha"),
            keywords: &["okooko", "okooko ọcha"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hvítt blóm"),
            keywords: &["blóm", "hvítt blóm", "stimpill"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("fiore bianco"),
            keywords: &["fiore", "fiore bianco", "simbolo ben fatto"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("大変よくできました"),
            keywords: &["はなまる", "よくできました", "大変よくできました", "花"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kembang putih"),
            keywords: &["kembang", "kembang putih"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("თეთრი ყვავილი"),
            keywords: &["თეთრი ყვავილი", "ყვავილი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("ajeğğig amellal"),
            keywords: &["ajeğğig amellal"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ақ гүл"),
            keywords: &["ақ гүл", "гүл"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("blomsterstempel"),
            keywords: &["blomsterstempel", "stempel"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ផ\u{17d2}កាស"),
            keywords: &["ផ\u{17d2}កា", "ផ\u{17d2}កាស", "រ\u{17b8}ក\u{200b}"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬ\u{cbf}ಳ\u{cbf} ಹ\u{cc2}ವು"),
            keywords: &[
                "ಬ\u{cbf}ಳ\u{cbf} ಹ\u{cc2}ವು",
                "ಹ\u{cc2}ವ\u{cbf}ನ ಚೀಟ\u{cbf}",
                "ಹ\u{cc2}ವು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("흰 꽃"),
            keywords: &["꽃", "꽃 도장", "꽃 표시", "흰 꽃"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("धव\u{947}\u{902} फ\u{942}ल"),
            keywords: &["धव\u{947}\u{902} फ\u{942}ल", "फ\u{942}ल"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("ак гүл"),
            keywords: &["ак гүл", "гүл"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("wäiss Blumm"),
            keywords: &["Blumm", "wäiss Blumm"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ດອກໄມ\u{ec9}ສ\u{eb5}ຂາວ"),
            keywords: &["ດອກໄມ\u{ec9}", "ດອກໄມ\u{ec9}ສ\u{eb5}ຂາວ", "ສ\u{eb5}ຂາວ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("balta gėlė"),
            keywords: &["balta gėlė", "gėlė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("balts zieds"),
            keywords: &["augs", "balts zieds", "zieds"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("putiputi mā"),
            keywords: &["putiputi", "putiputi mā"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("бел цвет"),
            keywords: &["бел", "цвет"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വെള\u{d41}ത\u{d4d}ത പ\u{d42}വ\u{d4d}"),
            keywords: &[
                "പ\u{d41}ഷ\u{d4d}പ മ\u{d41}ദ\u{d4d}ര",
                "പ\u{d42}വ\u{d4d}",
                "മ\u{d41}ദ\u{d4d}ര",
                "വെള\u{d41}ത\u{d4d}ത പ\u{d42}വ\u{d4d}",
                "സ\u{d4d}റ\u{d4d}റ\u{d3e}മ\u{d4d}പ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("цагаан цэцэг"),
            keywords: &["ургамал", "цагаан", "цэцэг"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("पा\u{902}ढर\u{947} फ\u{942}ल"),
            keywords: &["पा\u{902}ढर\u{947} फ\u{942}ल", "फ\u{942}ल"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bunga putih"),
            keywords: &["bunga", "bunga putih"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("fjura bajda"),
            keywords: &["fjura", "fjura bajda"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပန\u{103a}းဖြ\u{1030}"),
            keywords: &["ပန\u{103a}း", "ပန\u{103a}းဖြ\u{1030}"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("hvit blomst"),
            keywords: &["blomst", "blomsterstempel", "hvit blomst", "stempel"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{947}तो फ\u{942}ल"),
            keywords: &["फ\u{942}ल", "स\u{947}तो फ\u{942}ल"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("witte bloem"),
            keywords: &["bloem", "witte bloem"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kvit blomster"),
            keywords: &["blomster", "blomsterstempel", "kvit blomster", "stempel"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଧଳ\u{b3e} ଫ\u{b41}ଲ"),
            keywords: &["ଧଳ\u{b3e} ଫ\u{b41}ଲ", "ଫ\u{b41}ଲ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਚਿ\u{a71}ਟਾ ਫ\u{a41}\u{a71}ਲ"),
            keywords: &[
                "ਚਿ\u{a71}ਟਾ ਫ\u{a41}\u{a71}ਲ",
                "ਫ\u{a41}\u{a71}ਲ",
                "ਮ\u{a4b}ਹਰ",
                "ਵਧੀਆ ਮ\u{a4b}ਹਰ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("چٹ\u{651}ا پھول"),
            keywords: &["پھ\u{64f}ل", "چٹ\u{651}ا پھول"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Waít Fláwa"),
            keywords: &["Fláwa", "Waít Fláwa"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("biały kwiat"),
            keywords: &["biały kwiat", "kontury"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سپين ګل"),
            keywords: &["سپين ګل", "ګل، سپين ګل"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("flor branca"),
            keywords: &["flor", "flor branca"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("flor branca"),
            keywords: &["flor", "flor branca"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("yuraq tʼika"),
            keywords: &["t’ika", "yuraq tʼika"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("floare albă"),
            keywords: &["floare", "floare albă", "puritate"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-619"),
            keywords: &["E10-619"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("белый цветок"),
            keywords: &["белый", "цветок"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ururabo rw’umweru"),
            keywords: &["ururabo", "ururabo rw’umweru"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("اڇو گل"),
            keywords: &["اڇو گل", "گل"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ස\u{dd4}ද\u{dd4} මල"),
            keywords: &["මල", "ස\u{dd4}ද\u{dd4} මල"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("biely kvet"),
            keywords: &["biely kvet", "kvetina", "rastlina", "romanca"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("bela cvetlica"),
            keywords: &["bela cvetlica", "roža"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("ubax cad"),
            keywords: &["ubax", "ubax cad"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("lule e bardhë"),
            keywords: &["lule", "lule e bardhë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("бели цвет"),
            keywords: &["бели цвет", "цвeт"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("бијели цвијет"),
            keywords: &["бијели цвијет"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("beli cvet"),
            keywords: &["beli cvet", "cvet"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("bijeli cvijet"),
            keywords: &["bijeli cvijet"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("vit blomma"),
            keywords: &["blomma", "vit blomma"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("ua jeupe"),
            keywords: &["ua", "ua jeupe"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வெள\u{bcd}ளைநிறப\u{bcd} பூ"),
            keywords: &[
                "அருமை என\u{bcd}பதைக\u{bcd} குறிக\u{bcd}கும\u{bcd} முத\u{bcd}திரை",
                "மலர\u{bcd}",
                "முத\u{bcd}திரை",
                "வெள\u{bcd}ளை",
                "வெள\u{bcd}ளைநிறப\u{bcd} பூ",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("త\u{c46}ల\u{c4d}లన\u{c3f} పుష\u{c4d}పం"),
            keywords: &[
                "త\u{c46}లుపు",
                "త\u{c46}ల\u{c4d}లన\u{c3f} పుష\u{c4d}పం",
                "పువ\u{c4d}వు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("гули сафед"),
            keywords: &["гул", "гули сафед"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ตราดอกไม\u{e49}"),
            keywords: &["ดอกไม\u{e49}", "ตราดอกไม\u{e49}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ak gül"),
            keywords: &["ak gül", "gül"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("matalaʻiʻakau hinehina"),
            keywords: &["matalaʻiʻakau hinehina"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("beyaz çiçek"),
            keywords: &["beyaz çiçek", "damga", "iyi çalışma damgası", "çiçek"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئاق گۈل"),
            keywords: &["ئاق گۈل", "چېچەك"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("біла квітка"),
            keywords: &["біла квітка", "квітка"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سفید پھول"),
            keywords: &["سفید پھول", "پھول"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("oq gul"),
            keywords: &["gul", "oq gul"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("hoa trắng"),
            keywords: &["hoa", "hoa trắng"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("fulóor bu weex"),
            keywords: &["fulër", "fulóor bu weex"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("intyatyambo emhlophe"),
            keywords: &["intyatyambo", "intyatyambo emhlophe"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ododo Funfun"),
            keywords: &["Ododo Funfun", "Odòdó"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("白花"),
            keywords: &["白花", "花"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("白花"),
            keywords: &["白花", "花"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("白花"),
            keywords: &["白花", "花"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("白花"),
            keywords: &["白花", "花"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["白色花朵", "白花"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("imbali emhlophe"),
            keywords: &["imbali", "imbali emhlophe"],
        },
    ],
};
#[doc = "🏵\u{fe0f}"]
pub const ROSETTE: crate::Emoji = crate::Emoji {
    glyph: "🏵\u{fe0f}",
    codepoint: "1F3F5 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "rosette",
    group: "Animals & Nature",
    subgroup: "plant-flower",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🏵",
        codepoint: "1F3F5",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "rosette",
        group: "Animals & Nature",
        subgroup: "plant-flower",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("roset"),
            keywords: &["plant", "roset"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሮዜት"),
            keywords: &["ሮዜት", "ተክል"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وردية"),
            keywords: &["نبات", "وردية"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ৰ’চেট"),
            keywords: &["গছ", "ৰ’চেট"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("rozetka"),
            keywords: &["bitki", "rozetka"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("разетка"),
            keywords: &["разетка", "расліна"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("розета"),
            keywords: &["растение", "розета"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ফিতে দিয\u{9bc}ে তৈরি গোল\u{9be}পের ব\u{9cd}য\u{9be}জ"),
            keywords: &[
                "গ\u{9be}ছ",
                "ফিতে দিয\u{9bc}ে তৈরি গোল\u{9be}পের ব\u{9cd}য\u{9be}জ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("rozetenn"),
            keywords: &["plantenn", "rozetenn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("rozeta"),
            keywords: &["biljka", "rozeta"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("roseta"),
            keywords: &["planta", "roseta"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎧᏁᏍᏗ"),
            keywords: &["ᎠᎧᏁᏍᏗ", "ᎦᎪᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("rozeta"),
            keywords: &["květ", "květina", "rostlina", "rozeta"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("rhosglwm"),
            keywords: &["planhigyn", "rhosglwm"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("roset"),
            keywords: &["plante", "roset"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Rosette"),
            keywords: &["Pflanze", "Rosette"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ροζέτα"),
            keywords: &["ροζέτα", "φυτό"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("rosette"),
            keywords: &["plant", "rosette"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("roseta"),
            keywords: &["flor", "planta", "roseta"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("rosett"),
            keywords: &["lill", "rosett", "taim"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("kondekorazioa"),
            keywords: &["kondekorazioa", "landare", "saria"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("گل رزت"),
            keywords: &["گل", "گل رزت", "گیاه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("ruusuke"),
            keywords: &["kasvi", "ruusuke"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("rosette"),
            keywords: &["bulaklak", "disenyo", "halaman", "rosette"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("rósuprýði"),
            keywords: &["blomstur", "blóma", "planta", "rósuprýði", "stovnhviril"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("rosette"),
            keywords: &["plante", "rosette"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("róiséad"),
            keywords: &["planda", "róiséad"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("ròsag"),
            keywords: &["flùr", "lus", "ròsag"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("roseta"),
            keywords: &["flor", "roseta"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ફીતન\u{ac1}\u{a82} ગ\u{ac1}લાબ"),
            keywords: &["છોડ", "ફીતન\u{ac1}\u{a82} ગ\u{ac1}લાબ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("rosette"),
            keywords: &["rosette", "shuke"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פרח צהוב"),
            keywords: &["פרח", "צהוב"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("प\u{941}ष\u{94d}प, रिबन का प\u{941}ष\u{94d}प"),
            keywords: &[
                "प\u{941}ष\u{94d}प",
                "प\u{941}ष\u{94d}प, रिबन का प\u{941}ष\u{94d}प",
                "रिबन का प\u{941}ष\u{94d}प",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("rozeta"),
            keywords: &["biljka", "rozeta"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("rozetta"),
            keywords: &["növény", "rozetta", "virág"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("վարդանախշ"),
            keywords: &["բույս", "վարդանախշ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("hiasan mawar"),
            keywords: &["hiasan mawar", "tanaman"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("akwụkwọ ndịka okooko"),
            keywords: &["akwụkwọ ndịka okooko", "osisi"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("rósarmynstur"),
            keywords: &["blóm", "planta", "rós", "rósarmynstur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("rosetta"),
            keywords: &["fiore", "rosetta"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("花飾り"),
            keywords: &["植物", "花", "花飾り"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("roseta"),
            keywords: &["roseta", "tanduran"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("როზეტი"),
            keywords: &["მცენარე", "როზეტი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("tawardit"),
            keywords: &["tawardit"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("розетка"),
            keywords: &["розетка", "өсімдік"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("roset"),
            keywords: &["plante", "roset"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ផ\u{17d2}កាពាក\u{17cb}ត\u{17bb}បតែង"),
            keywords: &[
                "ត\u{17bb}បតែង",
                "ផ\u{17d2}កា",
                "ផ\u{17d2}កាពាក\u{17cb}ត\u{17bb}បតែង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ರೊಸ\u{cc6}ಟ\u{ccd}"),
            keywords: &["ಗ\u{cbf}ಡ", "ರೊಸ\u{cc6}ಟ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("장미"),
            keywords: &["꽃", "장미"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("फ\u{942}ल"),
            keywords: &["ग\u{941}च\u{94d}छ", "फ\u{942}ल", "रोप"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жапайы роза"),
            keywords: &["жапайы роза", "өсүмдүк"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Rosett"),
            keywords: &["Planz", "Rosett"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໂບດອກກ\u{eb8}ຫ\u{ebc}າບ"),
            keywords: &["ດອກໄມ\u{ec9}", "ພ\u{eb7}ດ", "ໂບ", "ໂບດອກກ\u{eb8}ຫ\u{ebc}າບ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("rozetė"),
            keywords: &["augalas", "rozetė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("rozete"),
            keywords: &["augs", "rozete", "zieds"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("rōhiti"),
            keywords: &["rōhiti", "tipu"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("розета"),
            keywords: &["растение", "розета", "цвет"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("റൊസെറ\u{d4d}റ\u{d4d}"),
            keywords: &["ചെടി", "റൊസെറ\u{d4d}റ\u{d4d}"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("сарнай хэлбэртэй чимэглэл"),
            keywords: &["Сарнай", "сарнай хэлбэртэй чимэглэл", "хэлбэр", "чимэглэл"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("दगडावर कोरल\u{947}ल\u{947} ग\u{941}लाबाच\u{947}फ\u{942}ल"),
            keywords: &[
                "दगडावर कोरल\u{947}ल\u{947} ग\u{941}लाबाच\u{947} फ\u{942}ल",
                "दगडावर कोरल\u{947}ल\u{947} ग\u{941}लाबाच\u{947}फ\u{942}ल",
                "वनस\u{94d}पती",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("roset"),
            keywords: &["roset", "tumbuhan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("rożetta"),
            keywords: &["pjanta", "rożetta"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "န\u{103e}င\u{103a}းဆ\u{102e}ပ\u{103d}င\u{1037}\u{103a}ပ\u{102f}\u{1036}စ\u{1036}",
            ),
            keywords: &[
                "န\u{103e}င\u{103a}းဆ\u{102e}ပ\u{103d}င\u{1037}\u{103a}ပ\u{102f}\u{1036}စ\u{1036}",
                "န\u{103e}င\u{103a}းဆ\u{102e}ပ\u{103d}င\u{1037}\u{103a}ပ\u{102f}\u{1036}စ\u{1036} ရင\u{103a}ထ\u{102d}\u{102f}း",
                "အပင\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("rosett"),
            keywords: &["plante", "rosett"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("थाली"),
            keywords: &["थाली", "बिर\u{942}वा"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("rozet"),
            keywords: &["plant", "rozet"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("rosett"),
            keywords: &["plante", "rosett"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ରୋଜେଟ\u{b4d}"),
            keywords: &["ଉଦ\u{b4d}ଭ\u{b3f}ଦ", "ରୋଜେଟ\u{b4d}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸਨਮਾਨ ਚਿ\u{a70}ਨ\u{a4d}ਹ, ਰਿਬਨ ਦਾ ਬਣਿਆ ਹ\u{a4b}ਇਆ ਫ\u{a41}\u{a71}ਲ"),
            keywords: &[
                "ਬ\u{a42}ਟਾ",
                "ਸਨਮਾਨ ਚਿ\u{a70}ਨ\u{a4d}ਹ, ਰਿਬਨ ਦਾ ਬਣਿਆ ਹ\u{a4b}ਇਆ ਫ\u{a41}\u{a71}ਲ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("چمکدار فیتے دا بنیا پ\u{64f}ھل"),
            keywords: &["بوٹا", "چمکدار فیتے دا بنیا پ\u{64f}ھل"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Rozẹt"),
            keywords: &["Plant", "Rozẹt"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("rozeta"),
            keywords: &["kwiat", "rozeta", "roślina"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("وريښمين ګلى"),
            keywords: &["بوټى، وريښمين ګل", "وريښمين ګلى"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("roseta"),
            keywords: &["flor", "roseta"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("rosácea"),
            keywords: &["planta", "rosácea"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("muyu whipala"),
            keywords: &["mallki", "muyu whipala"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("rozetă"),
            keywords: &["plantă", "rozetă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-435"),
            keywords: &["E10-435"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("розетка"),
            keywords: &["растение", "розетка"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("rozete"),
            keywords: &["ikimera", "rozete"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("گل نما"),
            keywords: &["ٻوٽو", "گل نما"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("රොසට\u{dca} මල"),
            keywords: &["පැළය", "රොසට\u{dca} මල"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("ružička"),
            keywords: &["rastlina", "ružička"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("rozeta"),
            keywords: &["rastlina", "rozeta"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("ubaxa sharraxa"),
            keywords: &["dhir", "ubaxa sharraxa"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("rozetë"),
            keywords: &["bimë", "rozetë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("розета"),
            keywords: &["биљкa", "розета"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("rozeta"),
            keywords: &["biljka", "rozeta"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("bandros"),
            keywords: &["bandros", "blomma"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("waridi"),
            keywords: &["mmea", "waridi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வட\u{bcd}டவடிவப\u{bcd} பூ"),
            keywords: &[
                "பூ",
                "மலர\u{bcd}",
                "வட\u{bcd}ட மலர\u{bcd}",
                "வட\u{bcd}டப\u{bcd} பூ",
                "வட\u{bcd}டவடிவப\u{bcd} பூ",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "ర\u{c3f}బ\u{c4d}బన\u{c4d}\u{200c}త\u{c4b} తయ\u{c3e}రు చ\u{c47}స\u{c3f}న గుల\u{c3e}బ\u{c3f} పువ\u{c4d}వు",
            ),
            keywords: &[
                "గుల\u{c3e}బ\u{c3f} పువ\u{c4d}వు",
                "ర\u{c3f}బ\u{c4d}బన\u{c4d}",
                "ర\u{c3f}బ\u{c4d}బన\u{c4d}\u{200c}త\u{c4b} తయ\u{c3e}రు చ\u{c47}స\u{c3f}న గుల\u{c3e}బ\u{c3f} పువ\u{c4d}వు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("гулдоира"),
            keywords: &["гулдоира", "растанӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ลายดอกก\u{e38}หลาบ"),
            keywords: &["ดอกไม\u{e49}", "ลายดอกก\u{e38}หลาบ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("bezeg güli"),
            keywords: &["bezeg güli", "ösümlik"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("potupotutatau"),
            keywords: &["potupotutatau"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("çiçek rozet"),
            keywords: &["bitki", "gülce", "çiçek rozet"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئەتىر"),
            keywords: &["ئۆسۈملۈك", "ئەتىر"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("розета"),
            keywords: &["розета", "розетка", "рослина"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("گلاب کا نقش"),
            keywords: &["پودا", "پھول", "گلاب کا نقش"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("to‘pbarggul"),
            keywords: &["o‘simlik", "to‘pbarggul"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nơ hoa hồng"),
            keywords: &["nơ hoa hồng", "thực vật"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("roset"),
            keywords: &["garab", "roset"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-rosette"),
            keywords: &["i-rosette", "isityalo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ohun Odòdó ọṣọ"),
            keywords: &["Ohun Odòdó ọṣọ", "õgbìn"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("花環"),
            keywords: &["植物", "花環"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("花环"),
            keywords: &["植物", "花环"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("圆形花饰"),
            keywords: &["圆形花饰", "花"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("花朵"),
            keywords: &["花", "花朵"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("玫瑰花飾"),
            keywords: &["玫瑰花飾", "黃色玫瑰花飾"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("irosette"),
            keywords: &["irosette", "isitshalo"],
        },
    ],
};
#[doc = "🌹"]
pub const ROSE: crate::Emoji = crate::Emoji {
    glyph: "🌹",
    codepoint: "1F339",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "rose",
    group: "Animals & Nature",
    subgroup: "plant-flower",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("roos"),
            keywords: &["blom", "plant", "roos"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ጽጌሬዳ"),
            keywords: &["ተክል", "አበባ", "ጽጌሬዳ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وردة"),
            keywords: &["زهرة", "وردة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("গোল\u{9be}প"),
            keywords: &["গোল\u{9be}প", "ফ\u{9c1}ল"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qızılgül"),
            keywords: &["bitki", "gül", "qızılgül"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("ружа"),
            keywords: &["кветка", "расліна", "ружа"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("роза"),
            keywords: &["растение", "роза", "цвете"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("গোল\u{9be}প"),
            keywords: &["গোল\u{9be}প", "ফ\u{9c1}ল"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("rozenn"),
            keywords: &["bleunienn", "rozenn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("ruža"),
            keywords: &["biljka", "cvijet", "ruža"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("rosa"),
            keywords: &["flor", "planta", "rosa"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄉\u{1112e}𑄣𑄛\u{11134} 𑄜\u{1112a}𑄣\u{11134}"),
            keywords: &["𑄉\u{1112e}𑄣𑄛\u{11134} 𑄜\u{1112a}𑄣\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎶᏏ"),
            keywords: &["ᎤᏥᎸᏍᎩ", "ᎶᏏ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("růže"),
            keywords: &["květ", "květina", "rostlina", "růže"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("rhosyn"),
            keywords: &["blodyn", "rhosyn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("rose"),
            keywords: &["blomst", "rose"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Rose"),
            keywords: &["Blume", "Blüte", "Pflanze", "Rose"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("τριαντάφυλλο"),
            keywords: &["λουλούδι", "τριαντάφυλλο", "φυτό"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("rose"),
            keywords: &["flower", "rose"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("rosa"),
            keywords: &["flor", "rosa"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["amor", "flor", "planta", "rosa"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("roos"),
            keywords: &["lill", "roos", "taim"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("arrosa"),
            keywords: &["arrosa", "landare", "lore"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("رز"),
            keywords: &["رز", "گل", "گیاه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("ruusu"),
            keywords: &["kasvi", "kukka", "ruusu"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("rosas"),
            keywords: &["bulaklak", "halaman", "pag-ibig", "romansa", "rosas"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("rósa"),
            keywords: &["blomstur", "blóma", "rósa"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("rose"),
            keywords: &["fleur", "rose"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("rós"),
            keywords: &["rós"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("ròs"),
            keywords: &["flùr", "ròs"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("rosa"),
            keywords: &["flor", "rosa"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ગ\u{ac1}લાબ"),
            keywords: &["ગ\u{ac1}લાબ", "ફ\u{ac2}લ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("furen wardi"),
            keywords: &["fure", "furen wardi"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("ורד"),
            keywords: &["ורד", "פרח", "רומנטי", "רומנטיקה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ग\u{941}लाब"),
            keywords: &["ग\u{941}लाब", "फ\u{942}ल"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("ruža"),
            keywords: &["biljka", "cvijet", "ruža"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("rózsa"),
            keywords: &["növény", "rózsa", "virág"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("վարդ"),
            keywords: &["բույս", "ծաղիկ", "վարդ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("mawar"),
            keywords: &["bunga", "mawar", "tanaman"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("rozu"),
            keywords: &["okooko", "rozu"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("rós"),
            keywords: &["blóm", "rós"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("rosa"),
            keywords: &["fiore", "rosa"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("バラ"),
            keywords: &["バラ", "花"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("mawar"),
            keywords: &["kembang", "mawar"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ვარდი"),
            keywords: &["ვარდი", "მცენარე", "ყვავილი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("tawerdett"),
            keywords: &["tawerdett"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("әтіргүл"),
            keywords: &["гүл", "әтіргүл", "өсімдік"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("rose"),
            keywords: &["blomst", "rose"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ផ\u{17d2}កាក\u{17bb}លាប"),
            keywords: &["ក\u{17bb}លាប", "ផ\u{17d2}កា", "ផ\u{17d2}កាក\u{17bb}លាប"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಗುಲಾಬ\u{cbf}"),
            keywords: &["ಗುಲಾಬ\u{cbf}", "ಸಸ\u{ccd}ಯ", "ಹ\u{cc2}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("장미꽃"),
            keywords: &["꽃", "장미꽃"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ग\u{941}लाब"),
            keywords: &["ग\u{941}लाब", "फ\u{942}ल"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("роза"),
            keywords: &["гүл", "роза", "өсүмдүк"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Rous"),
            keywords: &["Blumm", "Rous"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ດອກກ\u{eb8}ຫ\u{ebc}າບ"),
            keywords: &[
                "ດອກກ\u{eb8}ຫ\u{ebc}າບ",
                "ດອກໄມ\u{ec9}",
                "ຕ\u{ebb}\u{ec9}ນໄມ\u{ec9}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("rožė"),
            keywords: &["augalas", "gėlė", "rožė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("roze"),
            keywords: &["augs", "roze", "zieds"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("rōhi"),
            keywords: &["putiputi", "rōhi"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("роза"),
            keywords: &["растение", "роза", "цвет"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("റോസ\u{d3e}പ\u{d4d}പ\u{d42}"),
            keywords: &[
                "ചെടി",
                "പ\u{d41}ഷ\u{d4d}പം",
                "പ\u{d42}വ\u{d4d}",
                "റോസ\u{d3e}ച\u{d4d}ചെടി",
                "റോസ\u{d3e}പ\u{d41}ഷ\u{d4d}പം",
                "റോസ\u{d3e}പ\u{d4d}പ\u{d42}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("сарнай"),
            keywords: &["сарнай", "ургамал"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ग\u{941}लाब"),
            keywords: &["ग\u{941}लाब", "फ\u{942}ल"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bunga mawar"),
            keywords: &["bunga", "bunga mawar", "tumbuhan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("warda"),
            keywords: &["fjura", "warda"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("န\u{103e}င\u{103a}းဆ\u{102e}ပန\u{103a}း"),
            keywords: &["န\u{103e}င\u{103a}းဆ\u{102e}ပန\u{103a}း", "ပန\u{103a}း"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("rose"),
            keywords: &["blomst", "rose"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ग\u{941}लाफ"),
            keywords: &["ग\u{941}लाफ", "फ\u{942}ल", "बिर\u{942}वा"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("roos"),
            keywords: &["bloem", "roos"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("rose"),
            keywords: &["blomster", "rose"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଗୋଲ\u{b3e}ପ"),
            keywords: &["ଗୋଲ\u{b3e}ପ", "ଫ\u{b41}ଲ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਗ\u{a41}ਲਾਬ"),
            keywords: &["ਗ\u{a41}ਲਾਬ", "ਫ\u{a41}\u{a71}ਲ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("گلاب"),
            keywords: &["پھ\u{64f}ل", "گلاب"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Roz"),
            keywords: &["Fláwa", "Roz"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("róża"),
            keywords: &["kwiat", "roślina", "róża"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ګلاب"),
            keywords: &["ګل، ګلاب", "ګلاب"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosa"),
            keywords: &["flor", "rosa"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["flor", "rosa", "vermelha"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("rosa"),
            keywords: &["rosa", "t’ika"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("trandafir"),
            keywords: &["floare", "trandafir"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-254"),
            keywords: &["E10-254"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("роза"),
            keywords: &["бутон", "красная", "роза", "цветок"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("iroza"),
            keywords: &["iroza", "ururabo"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("گلاب جو گل"),
            keywords: &["گل", "گلاب جو گل"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("රෝස මල"),
            keywords: &["පැළය", "මල", "රෝස මල"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("ruža"),
            keywords: &["kvetina", "rastlina", "ruža"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("vrtnica"),
            keywords: &["rastlina", "roža", "vrtnica"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("ubax koob"),
            keywords: &["ubax", "ubax koob"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("trëndafil"),
            keywords: &["bimë", "lule", "trëndafil"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("ружа"),
            keywords: &["ружа", "цвет"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["ружа"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("ruža"),
            keywords: &["cvet", "ruža"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["ruža"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("ros"),
            keywords: &["blomma", "ros"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("ua la waridi"),
            keywords: &["mmea", "ua", "ua la waridi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ரோஜ\u{bbe}"),
            keywords: &[
                "க\u{bbe}தல\u{bcd}",
                "சிவப\u{bcd}பு ரோஜ\u{bbe}",
                "மலர\u{bcd}",
                "ரோஜ\u{bbe}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ర\u{c4b}జ\u{c3e} పువ\u{c4d}వు"),
            keywords: &[
                "గుల\u{c3e}బ\u{c3f} పువ\u{c4d}వు",
                "పువ\u{c4d}వు",
                "మ\u{c4a}క\u{c4d}క",
                "ర\u{c4b}జ\u{c3e} పువ\u{c4d}వు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("садбарг"),
            keywords: &["гул", "садбарг"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ดอกก\u{e38}หลาบ"),
            keywords: &["ก\u{e38}หลาบแดง", "ดอกก\u{e38}หลาบ", "ดอกไม\u{e49}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("bägül"),
            keywords: &["bägül", "gül"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("lose"),
            keywords: &["lose"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("gül"),
            keywords: &["bitki", "gül", "çiçek"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئەتىرگۈل"),
            keywords: &["ئەتىرگۈل", "چېچەك"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("троянда"),
            keywords: &["квітка", "рослина", "троянда"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("گلاب"),
            keywords: &["پودا", "پھول", "گلاب"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("atirgul"),
            keywords: &["atirgul", "gul", "o‘simlik"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("hoa hồng"),
            keywords: &["hoa", "hoa hồng"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("róos"),
            keywords: &["fulër", "róos"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-rose"),
            keywords: &["i-rose", "intyatyambo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ododo"),
            keywords: &["Ododo", "Odòdó"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("玫瑰"),
            keywords: &["玫瑰", "花"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("玫瑰"),
            keywords: &["玫瑰", "花"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("玫瑰"),
            keywords: &["玫瑰", "花"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("玫瑰"),
            keywords: &["玫瑰", "花"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["玫瑰", "玫瑰花", "紅玫瑰"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("irose"),
            keywords: &["imbali", "irose", "isitshalo"],
        },
    ],
};
#[doc = "🥀"]
pub const WILTED_FLOWER: crate::Emoji = crate::Emoji {
    glyph: "🥀",
    codepoint: "1F940",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "wilted flower",
    group: "Animals & Nature",
    subgroup: "plant-flower",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("verlepte blom"),
            keywords: &["blom", "droog", "verlep", "verlepte blom", "warm"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የጠወለገ አበባ"),
            keywords: &["መጠውለግ", "አበባ", "የጠወለገ አበባ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وردة ذابلة"),
            keywords: &["ذابلة", "زهرة", "وردة ذابلة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ৰঙ\u{9be} ফ\u{9c1}ল"),
            keywords: &["ফ\u{9c1}ল", "ৰঙ\u{9be} ফ\u{9c1}ল"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("solmuş gül"),
            keywords: &["gül", "solmaq", "solmuş gül"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("завялая кветка"),
            keywords: &["завялая", "кветка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("повехнало цвете"),
            keywords: &["повехнало", "цвете"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("নেত\u{9be}নো ফ\u{9c1}ল"),
            keywords: &["নেত\u{9be}নো", "ফ\u{9c1}ল"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("boked goeñvet"),
            keywords: &["boked", "boked goeñvet", "goeñviñ"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("uveli cvijet"),
            keywords: &["cvijet", "uveli cvijet", "uvelo"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("rosa pansida"),
            keywords: &["flor", "marcida", "mústia", "pansida", "rosa"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏩᏅᏬᏒ ᎠᏥᎸᏍᎩ"),
            keywords: &["ᎤᏥᎸᏍᎩ", "ᎤᏩᏅᏬᏒ ᎠᏥᎸᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("zvadlá květina"),
            keywords: &[
                "květ",
                "květina",
                "uvadlá",
                "uvadnutá",
                "zvadlá květina",
                "zvadnutá",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("blodyn wedi gwiwo"),
            keywords: &["blodyn", "blodyn wedi gwiwo", "wedi gwiwo"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("vissen blomst"),
            keywords: &["afblomstret", "blomst", "visnet", "vissen"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("welke Blume"),
            keywords: &["Blume", "verwelkt", "welke Blume"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μαραμένο λουλούδι"),
            keywords: &["λουλούδι", "μαραμένο λουλούδι", "μαραμένος"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("wilted flower"),
            keywords: &["flower", "wilted"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("flor marchita"),
            keywords: &["flor", "marchita", "marchitada", "marchitarse", "tristeza"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["flor", "marchita", "tristeza"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("närbunud lill"),
            keywords: &["lill", "närbunud"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("lore zimela"),
            keywords: &["lore zimela", "lorea", "zimela"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("گل پژمرده"),
            keywords: &["دل شکسته", "غمگین", "پژمرده", "گل"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("nuutunut kukka"),
            keywords: &["kukka", "nuutunut"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("nalantang bulaklak"),
            keywords: &["bulaklak", "lanta", "nalantang bulaklak"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("følna blóma"),
            keywords: &["blomstur", "blóma", "følna"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("fleur fanée"),
            keywords: &["fanée", "fleur"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("bláth sleabhctha"),
            keywords: &["bláth", "sleabhctha"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("flùr seacte"),
            keywords: &["flùr", "seacta", "seacte"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("flor murcha"),
            keywords: &["flor", "murcha", "planta"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("મ\u{ac1}ર\u{acd}જાય\u{ac7}લ\u{ac1}\u{a82} ફ\u{ac2}લ"),
            keywords: &["ફ\u{ac2}લ", "મ\u{ac1}ર\u{acd}જાય\u{ac7}લ\u{ac1}\u{a82}"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("laƙwassen fure"),
            keywords: &["fure", "laƙwasse", "laƙwassen fure"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פרח נובל"),
            keywords: &["נגמרה האהבה", "נובל", "פרח"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("म\u{941}रझाया ह\u{941}आ फ\u{942}ल"),
            keywords: &[
                "फ\u{942}ल",
                "म\u{941}रझाया",
                "म\u{941}रझाया ह\u{941}आ फ\u{942}ल",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("uveo cvijet"),
            keywords: &["cvijet", "uveo"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("hervadt virág"),
            keywords: &["hervadt", "virág"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("թառամած ծաղիկ"),
            keywords: &["թառամած", "ծաղիկ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("bunga layu"),
            keywords: &["bunga", "kecewa", "layu"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("okooko kpọnwụrụ akpọnwụ"),
            keywords: &["kpọnwụrụ akpọnwụ", "okooko", "okooko kpọnwụrụ akpọnwụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("sölnað blóm"),
            keywords: &["blóm", "rós", "sölnað blóm"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("fiore appassito"),
            keywords: &["appassito", "fiore"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("しおれた花"),
            keywords: &["しおれた", "しおれた花", "花"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kembang layu"),
            keywords: &["kembang", "layu"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("დამჭკნარი ყვავილი"),
            keywords: &["დამჭკნარი", "ყვავილი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("ajeğğig akiwan"),
            keywords: &["ajeğğig akiwan"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("солған гүл"),
            keywords: &["гүл", "солған"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("vissen blomst"),
            keywords: &["afblomstret", "blomst", "visnet", "vissen"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ផ\u{17d2}កាស\u{17d2}រពោន"),
            keywords: &["ផ\u{17d2}កា", "ផ\u{17d2}កាស\u{17d2}រពោន", "ស\u{17d2}រពោន"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬಾಡ\u{cbf}ದ ಹ\u{cc2}ವು"),
            keywords: &[
                "ಬಾಡ\u{cbf}ದ ಹ\u{cc2}ವು",
                "ಬಾಡುವ\u{cbf}ಕ\u{cc6}",
                "ಹ\u{cc2}ವು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("시든 꽃"),
            keywords: &["꺾인 고개", "꽃", "시든 꽃", "시듦"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("बाविल\u{94d}ल\u{947}\u{902} फ\u{942}ल"),
            keywords: &["फ\u{942}ल", "बाविल\u{94d}ल\u{947}\u{902}"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("соолуган гүл"),
            keywords: &["гүл", "соолуган"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("verwielegt Blumm"),
            keywords: &["Blumm", "verwielegt"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ດອກໄມ\u{ec9}ແຫ\u{ec8}ວ"),
            keywords: &[
                "ດອກໄມ\u{ec9}",
                "ດອກໄມ\u{ec9}ແຫ\u{ec8}ວ",
                "ຫ\u{ec8}ຽວ",
                "ແຫ\u{ec8}ວ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("gležna gėlė"),
            keywords: &["gležna", "gėlė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("novītusi puķe"),
            keywords: &["novītusi", "puķe"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("putiputi kautaka"),
            keywords: &["menge", "putiputi", "putiputi kautaka"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("овенато цвеќе"),
            keywords: &["овенато", "цвеќе"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വ\u{d3e}ടിയ പ\u{d41}ഷ\u{d4d}പം"),
            keywords: &[
                "പ\u{d41}ഷ\u{d4d}പം",
                "പ\u{d42}വ\u{d4d}",
                "വ\u{d3e}ടിയ പ\u{d41}ഷ\u{d4d}പം",
                "വ\u{d3e}ടിയത\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хатсан цэцэг"),
            keywords: &["хатсан", "цэцэг"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("कोमजल\u{947}ल\u{947} फ\u{941}ल"),
            keywords: &[
                "कोमजल\u{947}ल\u{947} फ\u{941}ल",
                "कोम\u{947}जल\u{947}ल\u{947} फ\u{942}ल",
                "फ\u{942}ल",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bunga layu"),
            keywords: &["bunga", "layu"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("fjura mitbiela"),
            keywords: &["fjura", "mitbiela"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပန\u{103a}းည\u{103e}\u{102d}\u{102f}းတစ\u{103a}ပ\u{103d}င\u{1037}\u{103a}"),
            keywords: &[
                "ည\u{103e}\u{102d}\u{102f}းန\u{103d}မ\u{103a}း",
                "ပန\u{103a}း",
                "ပန\u{103a}းည\u{103e}\u{102d}\u{102f}းတစ\u{103a}ပ\u{103d}င\u{1037}\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("vissen blomst"),
            keywords: &["blomst", "tørket", "vissen"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ओइलिएको फ\u{942}ल"),
            keywords: &["आइलिएको", "ओइलिएको फ\u{942}ल", "फ\u{942}ल"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("verwelkte bloem"),
            keywords: &["bloem", "verwelkt", "verwelkte bloem"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("vissen blomster"),
            keywords: &["blomster", "tørka", "vissen"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମଉଳ\u{b3f} ପଡ\u{b3c}\u{b3f}ଥ\u{b3f}ବ\u{b3e} ଫ\u{b41}ଲ"),
            keywords: &[
                "ଫ\u{b41}ଲ । ମଉଳ\u{b3f} ପଡ\u{b3f}ଛ\u{b3f}",
                "ମଉଳ\u{b3f} ପଡ\u{b3c}\u{b3f}ଥ\u{b3f}ବ\u{b3e} ଫ\u{b41}ଲ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਮ\u{a41}ਰਝਾਇਆ ਫ\u{a41}\u{a71}ਲ"),
            keywords: &["ਫ\u{a41}\u{a71}ਲ", "ਮ\u{a41}ਰਝਾਇਆ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("مرجھایا ہویا پھول"),
            keywords: &["مرجھایا ہوئیا", "مرجھایا ہویا پھول", "پھ\u{64f}ل"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fláwa Wé Dọ\u{301}n De Dai"),
            keywords: &["Fláwa", "Fláwa Wé Dọ\u{301}n De Dai"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("zwiędły kwiat"),
            keywords: &["kwiat", "róża", "więdnąć", "zwiędły kwiat"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("مړاوي ګل"),
            keywords: &["مړاوي ګل"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("flor murcha"),
            keywords: &["flor", "murcha", "murchando"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["flor", "murcha"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("naqʼisqa tʼika"),
            keywords: &["naqʼisqa tʼika", "naq’isqa", "t’ika"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("floare ofilită"),
            keywords: &["floare", "floare ofilită", "ofilire"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1056"),
            keywords: &["E10-1056"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("увядший цветок"),
            keywords: &["увядший", "цветок"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ururabo rwenda kuvunika"),
            keywords: &["rwenda kuvunika", "ururabo", "ururabo rwenda kuvunika"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪومايل گل"),
            keywords: &["ڪومايل گل", "گل، ڪومايل"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("මැර\u{dd4}ණ\u{dd4} මල"),
            keywords: &["මල", "මැර\u{dd4}ණ\u{dd4}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("zvädnutá kvetina"),
            keywords: &["kvetina", "zvädnutá"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("ovenela roža"),
            keywords: &["ovenela", "roža"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("ubaxa didilaaca"),
            keywords: &["ubax", "ubaxa didilaaca"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("lule e vyshkur"),
            keywords: &["lule", "lule e vyshkur", "vyshkje"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("увели цвет"),
            keywords: &["увели цвет", "увело", "цвет"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("увели цвијет"),
            keywords: &["увели цвијет"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("uveli cvet"),
            keywords: &["cvet", "uveli cvet", "uvelo"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("uveli cvijet"),
            keywords: &["uveli cvijet"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("vissnad blomma"),
            keywords: &["blomma", "torkad", "vissen", "vissnad blomma"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("ua lililonyauka"),
            keywords: &["ua", "ua lililonyauka"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வ\u{bbe}டிய பூ"),
            keywords: &["பூ", "வ\u{bbe}டிய பூ", "வ\u{bbe}டியது"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("వ\u{c3e}ల\u{c3f}ప\u{c4b}య\u{c3f}న పువ\u{c4d}వు"),
            keywords: &["పువ\u{c4d}వు", "వ\u{c3e}ల\u{c3f}ప\u{c4b}య\u{c3f}న"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("гули пажмурда"),
            keywords: &["гул", "гули пажмурда", "пажмурда"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ดอกไม\u{e49}เห\u{e35}\u{e48}ยว"),
            keywords: &[
                "ก\u{e38}หลาบ",
                "ดอกไม\u{e49}",
                "ดอกไม\u{e49}เห\u{e35}\u{e48}ยว",
                "เฉา",
                "เห\u{e35}\u{e48}ยว",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("sülleren gül"),
            keywords: &["gül", "sülleren"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mae"),
            keywords: &["mae"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("solmuş çiçek"),
            keywords: &["solmuş", "çiçek"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("سۇلغان گۈل"),
            keywords: &["سۇلغان گۈل", "سۇلۇش", "گۈل"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("привʼяла троянда"),
            keywords: &["завʼяла троянда", "зів’яла", "квітка", "привʼяла троянда"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("مرجھایا ہوا پھول"),
            keywords: &["مرجھایا", "مرجھایا ہوا پھول", "پھول"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("so‘nayotgan gul"),
            keywords: &["gul", "quriyotgan", "so‘nayotgan"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("hoa héo"),
            keywords: &["hoa", "héo"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("fulóor bu waw"),
            keywords: &["bu waw", "fulër", "fulóor bu waw"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("intyatyambo ebunileyo"),
            keywords: &["ebunileyo", "intyatyambo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ododo witi"),
            keywords: &["ododo witi", "rẹ\u{300}", "òdòdó"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("凋謝嘅花"),
            keywords: &["凋謝", "凋謝嘅花", "花"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("凋谢嘅花"),
            keywords: &["凋谢", "凋谢嘅花", "花"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("枯萎的花"),
            keywords: &["枯萎的花", "花"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("枯萎花朵"),
            keywords: &["凋零", "枯萎", "枯萎花朵", "花"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("枯萎嘅玫瑰"),
            keywords: &["凋謝嘅玫瑰", "凋謝嘅花", "枯萎", "枯萎嘅玫瑰", "枯萎嘅花"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("bunile"),
            keywords: &["bunile", "imbali"],
        },
    ],
};
#[doc = "🌺"]
pub const HIBISCUS: crate::Emoji = crate::Emoji {
    glyph: "🌺",
    codepoint: "1F33A",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "hibiscus",
    group: "Animals & Nature",
    subgroup: "plant-flower",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("hibiskus"),
            keywords: &["blom", "hibiskus", "plant"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሂቢስከስ አበባ"),
            keywords: &["ሂቢስከስ አበባ", "ተክል", "አበባ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("كركديه"),
            keywords: &["زهرة", "كركديه"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("জব\u{9be}ফ\u{9c1}ল"),
            keywords: &["জব\u{9be}ফ\u{9c1}ল", "ফ\u{9c1}ল"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("hibiskus"),
            keywords: &["bitki", "gül", "hibiskus"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("гібіскус"),
            keywords: &["гібіскус", "кветка", "расліна"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("хибискус"),
            keywords: &["растение", "хибискус", "цвете"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("জব\u{9be}"),
            keywords: &["গ\u{9be}ছ", "জব\u{9be}", "ফ\u{9c1}ল"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("hibiskuz"),
            keywords: &["bleunienn", "hibiskuz"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("hibiskus"),
            keywords: &["biljka", "cvijet", "hibiskus"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("hibisc"),
            keywords: &["flor", "hibisc", "planta"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎭᏈᏍᎬᏏ"),
            keywords: &["ᎤᏥᎸᏍᎩ", "ᎭᏈᏍᎬᏏ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("ibišek"),
            keywords: &["ibišek", "květ", "květina", "rostlina"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("hibisgws"),
            keywords: &["blodyn", "hibisgws", "planhigyn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("hibiscus"),
            keywords: &["blomst", "hawaiiblomst", "hibiscus"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Hibiskus"),
            keywords: &["Blume", "Blüte", "Hibiskus", "Pflanze"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ιβίσκος"),
            keywords: &["ιβίσκος", "λουλούδι", "φυτό"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("hibiscus"),
            keywords: &["flower", "hibiscus"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("flor de hibisco"),
            keywords: &["flor", "flor de hibisco", "hibisco"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("flor de jamaica"),
            keywords: &["flor", "flor de jamaica", "hibiscus"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("hibisk"),
            keywords: &["hibisk", "lill", "taim"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("hibiskoa"),
            keywords: &["hibiskoa", "landare", "lore"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("گل ختمی"),
            keywords: &["گل", "گل بامیه", "گل ختمی", "گیاه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kiinanruusu"),
            keywords: &["kasvi", "kiinanruusu", "kukka"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("gumamela"),
            keywords: &["bulaklak", "gumamela", "halaman", "hibiscus"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("hawaiiblóma"),
            keywords: &["blomstur", "blóma", "hawaiiblóma"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("hibiscus"),
            keywords: &["fleur", "hibiscus"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("roiseog"),
            keywords: &["bláth", "roiseog"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("ìbisg"),
            keywords: &["flùr", "ìbisg"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("flor de hibisco"),
            keywords: &["flor", "flor de hibisco"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("જાસ\u{ac2}દ"),
            keywords: &["જાસ\u{ac2}દ", "ફ\u{ac2}લ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("furen Hibiscus"),
            keywords: &["fure", "furen Hibiscus"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("היביסקוס"),
            keywords: &["היביסקוס", "פרח"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ग\u{941}ड\u{93c}हल, हिबिस\u{94d}कस"),
            keywords: &[
                "अड\u{93c}ह\u{941}ल",
                "ग\u{941}ड\u{93c}हल",
                "ग\u{941}ड\u{93c}हल, हिबिस\u{94d}कस",
                "जपाप\u{941}ष\u{94d}प",
                "फ\u{942}ल",
                "हिबिस\u{94d}कस",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("hibiskus"),
            keywords: &["biljka", "cvijet", "hibiskus"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("hibiszkusz"),
            keywords: &["hibiszkusz", "növény", "virág"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("հիբիսկուս"),
            keywords: &["բույս", "ծաղիկ", "հիբիսկուս"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kembang sepatu"),
            keywords: &["bunga", "kembang sepatu", "tanaman"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("okooko bibuskus"),
            keywords: &["okooko", "okooko bibuskus"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("Havaírós"),
            keywords: &["Havaírós", "blóm"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("ibisco"),
            keywords: &["fiore", "ibisco"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ハイビスカス"),
            keywords: &["ハイビスカス", "花"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kembang sepatu"),
            keywords: &["kembang", "kembang sepatu"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ჰიბისკუსი"),
            keywords: &["მცენარე", "ყვავილი", "ჰიბისკუსი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("tivinṣeṛt"),
            keywords: &["tivinṣeṛt"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("бөрітарақ"),
            keywords: &["бөрітарақ", "гүл", "өсімдік"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("hibiscus"),
            keywords: &["blomst", "hawaiiblomst", "hibiscus"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ផ\u{17d2}ការ\u{17c6}យោល"),
            keywords: &["ផ\u{17d2}កា", "ផ\u{17d2}ការ\u{17c6}យោល", "រ\u{17c6}យោល"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ದಾಸವಾಳ"),
            keywords: &["ದಾಸವಾಳ", "ಹ\u{cc2}ವು"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("무궁화"),
            keywords: &["꽃", "무궁화"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("दसणीफ\u{942}ल"),
            keywords: &["दशीण", "दसणीफ\u{942}ल", "फ\u{942}ल"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("гибискус"),
            keywords: &["гибискус", "гүл", "өсүмдүк"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Hibiskus"),
            keywords: &["Blumm", "Hibiskus"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ດອກພ\u{eb8}ດ"),
            keywords: &["ດອກພ\u{eb8}ດ", "ດອກໄມ\u{ec9}"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("kinrožė"),
            keywords: &["augalas", "gėlė", "kinrožė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("hibisks"),
            keywords: &["augs", "hibisks", "zieds"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("puarangi"),
            keywords: &["puarangi", "putiputi"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("хибискус"),
            keywords: &["растение", "хибискус", "цвет"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ചെമ\u{d4d}പരത\u{d4d}തി"),
            keywords: &[
                "ചെടി",
                "ചെമ\u{d4d}പരത\u{d4d}തി",
                "പ\u{d41}ഷ\u{d4d}പം",
                "പ\u{d42}",
                "പ\u{d42}വ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("гибискус сарнай"),
            keywords: &["гибискус", "сарнай", "ургамал"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("जास\u{94d}व\u{902}द"),
            keywords: &["जास\u{94d}व\u{902}द", "फ\u{942}ल"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bunga raya"),
            keywords: &["bunga", "bunga raya"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("hibiscus"),
            keywords: &["fjura", "hibiscus"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ခေါင\u{103a}ရန\u{103a}းပန\u{103a}း"),
            keywords: &["ခေါင\u{103a}ရန\u{103a}းပန\u{103a}း", "ပန\u{103a}း"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("hibiskus"),
            keywords: &["blomst", "hibiskus"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("हाइबिस\u{94d}कस"),
            keywords: &["फ\u{942}ल", "बिर\u{942}वा", "हाइबिस\u{94d}कस"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("hibiscus"),
            keywords: &["bloem", "hibiscus"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("hibiskus"),
            keywords: &["blomster", "hibiskus"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ହ\u{b3f}ବ\u{b3f}ସକସ\u{b4d}\u{200d}"),
            keywords: &["ଫ\u{b41}ଲ", "ହ\u{b3f}ବ\u{b3f}ସକସ\u{b4d}\u{200d}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਗ\u{a41}ੜਹਲ"),
            keywords: &["ਗ\u{a41}\u{a41}ੜਹਲ", "ਗ\u{a41}ੜਹਲ", "ਫ\u{a41}\u{a71}ਲ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("جنس بٹوا"),
            keywords: &["جنس بٹوا", "پھ\u{64f}ل"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Haibískọs"),
            keywords: &["Fláwa", "Haibískọs"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kwiat hibiskusa"),
            keywords: &["kwiat hibiskusa", "kwiatek", "kwitnie", "roślina"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("هميش ګل"),
            keywords: &["هميش ګل", "ګل، هميش ګل"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("hibisco"),
            keywords: &["flor", "hibisco"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["flor", "hibisco"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("hibisco"),
            keywords: &["hibisco", "t’ika"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("hibiscus"),
            keywords: &["floare", "hibiscus"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-255"),
            keywords: &["E10-255"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("гибискус"),
            keywords: &["гибискус", "китайская роза", "цветок"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ibisikisi"),
            keywords: &["ibisikisi", "ururabo"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("گل خطمي"),
            keywords: &["گل", "گل خطمي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("වද මල"),
            keywords: &["පැළය", "මල", "වද මල"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("ibištek"),
            keywords: &["ibištek", "kvetina", "rastlina"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("hibiskus"),
            keywords: &["hibiskus", "rastlina", "roža"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("jirrid leh"),
            keywords: &["Ubax", "jirrid leh"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("hibisk"),
            keywords: &["bimë", "hibisk", "lule"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("хибискус"),
            keywords: &["хибискус", "цвет"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["хибискус"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("hibiskus"),
            keywords: &["cvet", "hibiskus"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["hibiskus"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("hibiskus"),
            keywords: &["blomma", "hibiskus"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("haibiskasi"),
            keywords: &["haibiskasi", "mmea", "ua"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("செம\u{bcd}பருத\u{bcd}தி"),
            keywords: &["செம\u{bcd}பருத\u{bcd}தி", "பூ", "மலர\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మంద\u{c3e}రం"),
            keywords: &[
                "ఎర\u{c4d}ర రంగు పువ\u{c4d}వు",
                "కస\u{c4d}తూర\u{c3f}బ\u{c46}ండు",
                "మంద\u{c3e}రం",
                "మ\u{c4a}క\u{c4d}క",
                "లత\u{c3e}కస\u{c4d}తూర\u{c3f}క",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("гибискус"),
            keywords: &["гибискус", "гул"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ดอกชบา"),
            keywords: &["ชบา", "ดอกชบา", "ดอกไม\u{e49}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("hytaý bägüli"),
            keywords: &["gül", "hytaý bägüli"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kaute"),
            keywords: &["kaute"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("çingülü"),
            keywords: &["bitki", "hatmi çiçeği", "çingülü", "çiçek"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("چېچەكياغاچ"),
            keywords: &["چېچەك", "چېچەكياغاچ"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("гібіскус"),
            keywords: &["гібіскус", "квітка", "рослина"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("گل خطمی"),
            keywords: &["پودا", "پھول", "گل خطمی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("xitoy atirguli"),
            keywords: &["gul", "o‘simlik", "xitoy atirguli"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("hoa dâm bụt"),
            keywords: &["hoa", "hoa dâm bụt"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("ibiskus"),
            keywords: &["fulër", "ibiskus"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umlolwa"),
            keywords: &["intyatyambo", "umlolwa"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ododo Ibisikọsi"),
            keywords: &["Ododo Ibisikọsi", "Odòdó"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("槿"),
            keywords: &["槿", "花"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("槿"),
            keywords: &["槿", "花"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("芙蓉"),
            keywords: &["木槿", "芙蓉", "花"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("芙蓉"),
            keywords: &["芙蓉", "花"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("扶桑花"),
            keywords: &["扶桑花", "杜鵑花", "芙蓉", "芙蓉花", "花"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ihibiscus"),
            keywords: &["ihibiscus", "imbali", "isitshalo"],
        },
    ],
};
#[doc = "🌻"]
pub const SUNFLOWER: crate::Emoji = crate::Emoji {
    glyph: "🌻",
    codepoint: "1F33B",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "sunflower",
    group: "Animals & Nature",
    subgroup: "plant-flower",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("sonneblom"),
            keywords: &["blom", "plant", "son", "sonneblom"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የሱፍ አበባ"),
            keywords: &["ተክል", "አበባ", "የሱፍ አበባ", "ፀሐይ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("دوار الشمس"),
            keywords: &["دوار الشمس", "عباد الشمس"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("স\u{9c2}ৰ\u{9cd}য\u{9cd}যম\u{9c1}খী"),
            keywords: &[
                "ফ\u{9c1}ল",
                "স\u{9c2}ৰ\u{9cd}য\u{9cd}য",
                "স\u{9c2}ৰ\u{9cd}য\u{9cd}যম\u{9c1}খী",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("günəbaxan"),
            keywords: &["bitki", "gül", "günəbaxan", "günəş"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("сланечнік"),
            keywords: &["кветка", "расліна", "сланечнік", "сонца"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("слънчоглед"),
            keywords: &["растение", "слънце", "слънчоглед", "цвете"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("স\u{9c2}র\u{9cd}যম\u{9c1}খি"),
            keywords: &[
                "ফ\u{9c1}ল",
                "স\u{9c2}র\u{9cd}য",
                "স\u{9c2}র\u{9cd}যম\u{9c1}খি",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("tro-heol"),
            keywords: &["bleunienn", "tro-heol"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("suncokret"),
            keywords: &["biljka", "cvijet", "sunce", "suncokret"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("gira-sol"),
            keywords: &["flor", "gira-sol", "planta", "sol"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏅᏓᏗᎧᏅᏩᏗᏙᎯ"),
            keywords: &["ᎤᏥᎸᏍᎩ", "ᏅᏓ ᎢᎦ ᎡᎯ", "ᏅᏓᏗᎧᏅᏩᏗᏙᎯ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("slunečnice"),
            keywords: &["květ", "květina", "rostlina", "slunce", "slunečnice"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("blodyn haul"),
            keywords: &["blodyn", "blodyn yr haul", "haul"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("solsikke"),
            keywords: &["blomst", "solsikke"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Sonnenblume"),
            keywords: &["Blume", "Blüte", "Pflanze", "Sonne", "Sonnenblume"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ηλιοτρόπιο"),
            keywords: &["ηλιοτρόπιο", "λουλούδι", "φυτό"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("sunflower"),
            keywords: &["flower", "sun", "sunflower"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("girasol"),
            keywords: &["girasol", "pipas", "planta", "semillas", "sol"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["flor", "girasol", "planta"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("päevalill"),
            keywords: &["lill", "päevalill", "päike", "taim"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ekilorea"),
            keywords: &["eguzki", "ekilorea", "landare", "lore"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("گل آفتابگردان"),
            keywords: &["خورشید", "گل", "گل آفتابگردان", "گیاه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("auringonkukka"),
            keywords: &["auringonkukka", "aurinko", "kasvi", "kukka"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("mirasol"),
            keywords: &["araw", "bulaklak", "halaman", "mirasol", "sunflower"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("sólblóma"),
            keywords: &["blomstur", "blóma", "sólblóma"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("tournesol"),
            keywords: &["fleur", "tournesol"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("lus na gréine"),
            keywords: &["bláth", "lus na gréine"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("neòinean-grèine"),
            keywords: &["flùr", "grian", "neòinean", "neòinean-grèine"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("xirasol"),
            keywords: &["flor", "xirasol"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{ac2}ર\u{acd}યમ\u{ac1}ખી"),
            keywords: &["ફ\u{ac2}લ", "સ\u{ac2}ર\u{acd}યમ\u{ac1}ખી"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("furenrana"),
            keywords: &["fure", "furenrana", "rana"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("חמניה"),
            keywords: &["חמניה", "פרח"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("स\u{942}र\u{94d}यम\u{941}खी"),
            keywords: &[
                "फ\u{942}ल",
                "सनफ\u{93c}\u{94d}लॉवर",
                "स\u{942}र\u{94d}यम\u{941}खी",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("suncokret"),
            keywords: &["biljka", "cvijet", "sunce", "suncokret"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("napraforgó"),
            keywords: &["nap", "napraforgó", "növény", "virág"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("արևածաղիկ"),
            keywords: &["արև", "արևածաղիկ", "բույս", "ծաղիկ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("bunga matahari"),
            keywords: &["bunga", "matahari", "tanaman"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("okookoanwụ"),
            keywords: &["anwụ", "okooko", "okookoanwụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("sólblóm"),
            keywords: &["blóm", "sól", "sólblóm"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("girasole"),
            keywords: &["fiore", "girasole"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ヒマワリ"),
            keywords: &["ヒマワリ", "花"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kembang sengenge"),
            keywords: &["kembang", "sengenge"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მზესუმზირა"),
            keywords: &["მზე", "მზესუმზირა", "მცენარე", "ყვავილი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("mager iṭṭij"),
            keywords: &["mager iṭṭij"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("күнбағыс"),
            keywords: &["гүл", "күн", "күнбағыс", "өсімдік"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("solsikke"),
            keywords: &["blomst", "solsikke"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ផ\u{17d2}កាឈ\u{17bc}ករ\u{17d0}ត\u{17d2}ន"),
            keywords: &["ផ\u{17d2}កា", "ផ\u{17d2}កាឈ\u{17bc}ករ\u{17d0}ត\u{17d2}ន"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸ\u{cc2}ರ\u{ccd}ಯಕಾಂತ\u{cbf}"),
            keywords: &["ಸ\u{cc2}ರ\u{ccd}ಯಕಾಂತ\u{cbf}", "ಹ\u{cc2}ವು"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("해바라기"),
            keywords: &["꽃", "해바라기"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("स\u{941}र\u{94d}यफ\u{942}ल"),
            keywords: &[
                "फ\u{942}ल",
                "स\u{941}र\u{94d}य",
                "स\u{941}र\u{94d}यफ\u{942}ल",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("күн карама"),
            keywords: &["гүл", "күн", "күн карама", "өсүмдүк"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Sonneblumm"),
            keywords: &["Blumm", "Sonn", "Sonneblumm"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ດອກຕາເວ\u{eb1}ນ"),
            keywords: &["ດອກຕາເວ\u{eb1}ນ", "ດອກໄມ\u{ec9}"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("saulėgrąža"),
            keywords: &["gėlė", "saulė", "saulėgrąža"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("saulespuķe"),
            keywords: &["augs", "saulespuķe", "zieds"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("putiputirā"),
            keywords: &["putiputi", "putiputirā", "rā"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("сончоглед"),
            keywords: &["растение", "сонце", "сончоглед", "цвет"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("സ\u{d42}ര\u{d4d}യക\u{d3e}ന\u{d4d}തി"),
            keywords: &[
                "ചെടി",
                "പ\u{d41}ഷ\u{d4d}പം",
                "പ\u{d42}",
                "പ\u{d42}വ\u{d4d}",
                "സ\u{d42}ര\u{d4d}യക\u{d3e}ന\u{d4d}തി",
                "സ\u{d42}ര\u{d4d}യൻ",
                "സൺഫ\u{d4d}ലവർ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("наран цэцэг"),
            keywords: &["наран цэцэг", "ургамал"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("स\u{942}र\u{94d}यफ\u{942}ल"),
            keywords: &[
                "फ\u{942}ल",
                "स\u{942}र\u{94d}य",
                "स\u{942}र\u{94d}यफ\u{942}ल",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bunga matahari"),
            keywords: &["bunga", "matahari"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ġirasol"),
            keywords: &["fjura", "xemx", "ġirasol"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("နေကြာပန\u{103a}း"),
            keywords: &["နေ", "နေကြာပန\u{103a}း", "ပန\u{103a}း"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("solsikke"),
            keywords: &["blomst", "sol", "solsikke"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{942}र\u{94d}यम\u{941}खी"),
            keywords: &[
                "फ\u{942}ल",
                "बिर\u{942}वा",
                "स\u{942}र\u{94d}य",
                "स\u{942}र\u{94d}यम\u{941}खी",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("zonnebloem"),
            keywords: &["bloem", "zon", "zonnebloem"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("solsikke"),
            keywords: &["blomster", "sol", "solsikke"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସ\u{b42}ର\u{b4d}ଯ\u{b4d}ୟମ\u{b41}ଖୀ"),
            keywords: &[
                "ଫ\u{b41}ଲ",
                "ସ\u{b42}ର\u{b4d}ଯ\u{b4d}ୟ",
                "ସ\u{b42}ର\u{b4d}ଯ\u{b4d}ୟମ\u{b41}ଖୀ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸ\u{a42}ਰਜਮ\u{a41}ਖੀ"),
            keywords: &["ਫ\u{a41}\u{a71}ਲ", "ਸ\u{a42}ਰਜਮ\u{a41}ਖੀ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("سورج مکھی"),
            keywords: &["سورج", "سورج مکھی", "پھ\u{64f}ل"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Sọ\u{301}nfláwa"),
            keywords: &["Fláwa", "Sọn", "Sọ\u{301}nfláwa"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("słonecznik"),
            keywords: &["kwiat", "roślina", "słonecznik", "słońce"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("لمر ګلی"),
            keywords: &["لمر ګلی", "ګل، لمر، لمر ګلى"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("girassol"),
            keywords: &["flor", "girassol"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["flor", "girassol", "sol"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("girasol"),
            keywords: &["girasol", "inti", "t’ika"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("floarea soarelui"),
            keywords: &["floare", "floarea soarelui", "galben", "plantă", "soare"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-256"),
            keywords: &["E10-256"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("подсолнух"),
            keywords: &["подсолнух", "солнце", "цветок"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("igihwagari"),
            keywords: &["igihwagari", "izuba", "ururabo"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("سورج مکي"),
            keywords: &["سورج مکي", "گل، سورج"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ස\u{dd6}ර\u{dd2}යක\u{dcf}න\u{dca}ත මල"),
            keywords: &["ඉර", "පැළය", "මල", "ස\u{dd6}ර\u{dd2}යක\u{dcf}න\u{dca}ත මල"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("slnečnica"),
            keywords: &["kvetina", "rastlina", "slnečnica", "slnko"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("sončnica"),
            keywords: &["rastlina", "roža", "sonce", "sončnica"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("gabbaldaye"),
            keywords: &["gabbaldaye", "qorrax", "ubax"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("luledielli"),
            keywords: &["bimë", "diell", "lule", "luledielli"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("сунцокрет"),
            keywords: &["сунце", "сунцокрет", "цвет"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["сунцокрет"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("suncokret"),
            keywords: &["cvet", "sunce", "suncokret"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["suncokret"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("solros"),
            keywords: &["blomma", "solros"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("alizeti"),
            keywords: &["alizeti", "jua", "mmea", "ua"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சூரியக\u{bbe}ந\u{bcd}தி"),
            keywords: &["சூரியக\u{bbe}ந\u{bcd}தி", "சூரியன\u{bcd}", "மலர\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ప\u{c4a}ద\u{c4d}దు త\u{c3f}రుగుడు పువ\u{c4d}వు"),
            keywords: &[
                "పువ\u{c4d}వు",
                "ప\u{c4a}ద\u{c4d}దు త\u{c3f}రుగుడు",
                "ప\u{c4a}ద\u{c4d}దు త\u{c3f}రుగుడు పువ\u{c4d}వు",
                "మ\u{c4a}క\u{c4d}క",
                "సూర\u{c4d}యక\u{c3e}ంతం పువ\u{c4d}వు",
                "సూర\u{c4d}యుడు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("офтобпараст"),
            keywords: &["гул", "офтоб", "офтобпараст"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ดอกทานตะว\u{e31}น"),
            keywords: &["ดอกทานตะว\u{e31}น", "ดอกไม\u{e49}", "ทานตะว\u{e31}น"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("günebakar"),
            keywords: &["gül", "gün", "günebakar"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("siolaʻā"),
            keywords: &["siolaʻā"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("ayçiçeği"),
            keywords: &["ayçiçeği", "bitki", "güneş", "çiçek"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئاپتاپپەرەس"),
            keywords: &["ئاپتاپپەرەس", "كۈن", "چېچەك"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("соняшник"),
            keywords: &["квітка", "рослина", "сонце", "соняшник"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سورج مکھی کا پھول"),
            keywords: &["سورج", "سورج مکھی کا پھول", "پودا", "پھول"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kungaboqar"),
            keywords: &["gul", "kungaboqar", "o‘simlik", "quyosh"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("hoa hướng dương"),
            keywords: &["hoa", "hoa hướng dương", "mặt trời"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("fulóoru jant"),
            keywords: &["fulër", "fulóoru jant", "jant"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ujongilanga"),
            keywords: &["ilanga", "intyatyambo", "ujongilanga"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ìtàná"),
            keywords: &["Odòdó", "Ìtàná", "Òòrùn"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("太陽花"),
            keywords: &["太陽", "太陽花", "花"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("太阳花"),
            keywords: &["太阳", "太阳花", "花"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("向日葵"),
            keywords: &["向日葵", "太阳花", "花"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("向日葵"),
            keywords: &["向日葵", "花"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["向日葵", "太陽花", "花"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ujikanelanga"),
            keywords: &["imbali", "isitshalo", "ujikanelanga"],
        },
    ],
};
#[doc = "🌼"]
pub const BLOSSOM: crate::Emoji = crate::Emoji {
    glyph: "🌼",
    codepoint: "1F33C",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "blossom",
    group: "Animals & Nature",
    subgroup: "plant-flower",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("bloeisel"),
            keywords: &["bloeisel", "blom", "plant"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የአበባ ፍካት"),
            keywords: &["ተክል", "አበባ", "የአበባ ፍካት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}زهرة"),
            keywords: &["\u{202b}زهرة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("প\u{9c1}ষ\u{9cd}প"),
            keywords: &["প\u{9c1}ষ\u{9cd}প", "ফ\u{9c1}ল"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("çiçək"),
            keywords: &["bitki", "gül", "çiçək"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("квецень"),
            keywords: &["кветка", "квецень", "расліна"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("цвят"),
            keywords: &["растение", "цвете", "цвят"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ফ\u{9c1}ল"),
            keywords: &["গ\u{9be}ছ", "ফ\u{9c1}ল"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("broñs"),
            keywords: &["bleunienn", "broñs"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("procvjetati"),
            keywords: &["biljka", "cvijet", "procvjetati"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("flor"),
            keywords: &["flor", "planta"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏥᎸᏅ"),
            keywords: &["ᎤᏥᎸᏅ", "ᎤᏥᎸᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("květ"),
            keywords: &["květ", "květina", "rostlina"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("blodeuyn"),
            keywords: &["blodeuyn", "blodyn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("blomst"),
            keywords: &["blomst", "gul blomst"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("gelbe Blüte"),
            keywords: &["Blume", "Blüte", "Pflanze", "gelbe Blüte"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("άνθος"),
            keywords: &["άνθος", "λουλούδι", "φυτό"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("blossom"),
            keywords: &["blossom", "flower"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["blossom", "daisy", "flower"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("flor"),
            keywords: &["campo", "flor", "planta", "primavera"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["flor", "florecer"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("õis"),
            keywords: &["lill", "taim", "õis"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("lorea"),
            keywords: &["landare", "lore", "lorea"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("شکوفه"),
            keywords: &["شکوفه", "گل", "گیاه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kukinta"),
            keywords: &["kasvi", "kukinta", "kukka"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("bulaklak"),
            keywords: &["bulaklak", "halaman"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("blóma"),
            keywords: &["blomstur", "blóma"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("bourgeon"),
            keywords: &["bourgeon", "fleur"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("bláthú"),
            keywords: &["bláth", "bláthú"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("blàth"),
            keywords: &["blàth", "flùr"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("flor"),
            keywords: &["flor"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ચ\u{ac7}રી"),
            keywords: &["ચ\u{ac7}રી", "પ\u{ac1}ષ\u{acd}પ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("huda"),
            keywords: &["fure", "huda"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פריחה"),
            keywords: &["אביב", "פרח", "פריחה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("फ\u{942}ल खिलना"),
            keywords: &[
                "प\u{941}ष\u{94d}प प\u{941}\u{902}ज",
                "फ\u{942}ल",
                "फ\u{942}ल खिलना",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("cvjetanje"),
            keywords: &["biljka", "cvijet", "cvjetanje"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("virágzás"),
            keywords: &["növény", "virág", "virágzás"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ծաղիկ"),
            keywords: &["բույս", "ծաղիկ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("mekar"),
            keywords: &["bunga", "mekar", "tanaman"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nchapụta"),
            keywords: &["nchapụta", "okooko"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("blóm"),
            keywords: &["blóm", "planta"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("fiore"),
            keywords: &["bocciolo", "fiore"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("開花"),
            keywords: &["咲いた花", "花", "開花"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("sekar"),
            keywords: &["kembang", "sekar"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ყვავილობა"),
            keywords: &["მცენარე", "ყვავილი", "ყვავილობა"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("amgud"),
            keywords: &["amgud"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ашылған гүл"),
            keywords: &["ашылған гүл", "гүл", "өсімдік"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("blomst"),
            keywords: &["blomst", "gul blomst"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ផ\u{17d2}ការ\u{17b8}ក"),
            keywords: &["ផ\u{17d2}ការ\u{17b8}ក", "រ\u{17b8}ក"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಅರಳುವ ಹ\u{cc2}ವು"),
            keywords: &["ಅರಳ\u{cbf}ದ ಹ\u{cc2}ವು", "ಅರಳುವ ಹ\u{cc2}ವು"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("꽃송이"),
            keywords: &["꽃", "꽃송이"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("फ\u{941}लप"),
            keywords: &["फ\u{941}लप", "फ\u{942}ल"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("гүлдөө"),
            keywords: &["гүл", "гүлдөө", "өсүмдүк"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Margréitchen"),
            keywords: &["Blumm", "Margréitchen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ດອກໄມ\u{ec9}ບານ"),
            keywords: &["ດອກໄມ\u{ec9}", "ດອກໄມ\u{ec9}ບານ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("gėlės žiedas"),
            keywords: &["augalas", "gėlė", "gėlės žiedas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("zieds"),
            keywords: &["augs", "zieds"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("puāwai"),
            keywords: &["putiputi", "puāwai"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("цут"),
            keywords: &["растение", "цвет", "цут"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പ\u{d42}വ\u{d4d}"),
            keywords: &["ചെടി", "പ\u{d41}ഷ\u{d4d}പം", "പ\u{d42}", "പ\u{d42}വ\u{d4d}"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("цэцэг"),
            keywords: &["ургамал", "цэцэг"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("उमलल\u{947}ल\u{947} फ\u{942}ल"),
            keywords: &["उमलल\u{947}ल\u{947} फ\u{942}ल", "फ\u{942}ल"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bunga mekar"),
            keywords: &["bunga", "mekar"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("fjur"),
            keywords: &["fjur", "fjura"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပန\u{103a}းပ\u{103d}င\u{1037}\u{103a}"),
            keywords: &[
                "ပန\u{103a}း",
                "ပန\u{103a}းပ\u{103d}င\u{1037}\u{103a}",
                "ပန\u{103a}းပ\u{103d}င\u{1037}\u{103a}ခြင\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("blomst"),
            keywords: &["blomst", "plante"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("फ\u{941}ल\u{94d}न\u{947}"),
            keywords: &["फ\u{941}ल\u{94d}न\u{947}", "फ\u{942}ल", "बिर\u{942}वा"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("bloesem"),
            keywords: &["bloem", "bloesem"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("blomster"),
            keywords: &["blomster", "plante"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଫ\u{b41}ଲ କଢ\u{b3c}"),
            keywords: &["ଫ\u{b41}ଲ", "ଫ\u{b41}ଲ କଢ\u{b3c}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਖਿੜਨਾ"),
            keywords: &["ਖਿੜਨਾ", "ਫ\u{a41}\u{a71}ਲ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("پھلاں دا ک\u{650}ھلنا"),
            keywords: &["پھلاں دا ک\u{650}ھلنا", "پھ\u{64f}ل"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Faín Fláwa"),
            keywords: &["Bọ\u{301}nch Ọf Fláwa", "Faín Fláwa", "Fláwa"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kwiat"),
            keywords: &["kwiat", "kwiatek", "kwitnie", "roślina"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("غوزه"),
            keywords: &["غوزه", "غوزه، ګل"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("flor"),
            keywords: &["flor", "florescer"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("malmequer"),
            keywords: &["flor", "malmequer"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("cerezo"),
            keywords: &["cerezo", "tʼika"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("boboc"),
            keywords: &["boboc", "eforescență", "floare", "înflorire"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-257"),
            keywords: &["E10-257"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("цветок"),
            keywords: &["растение", "цветок"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ururabyo"),
            keywords: &["ururabo", "ururabyo"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ٽڙيل"),
            keywords: &["بلاسم", "ٽڙيل", "گل"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("මල"),
            keywords: &["පැළය", "මල"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("kvet"),
            keywords: &["kvet", "kvetina", "rastlina"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("cvet"),
            keywords: &["cvet", "rastlina", "roža"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("ubax geed"),
            keywords: &["ubax", "ubax geed"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("lule"),
            keywords: &["bimë", "lule"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("цвет"),
            keywords: &["цвет"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("цвијет"),
            keywords: &["цвијет"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("cvet"),
            keywords: &["cvet"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("cvijet"),
            keywords: &["cvijet"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("blomma"),
            keywords: &["blomma", "blomster", "växt"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("maua mengi"),
            keywords: &["maua mengi", "mmea", "ua"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மஞ\u{bcd}சள\u{bcd} மலர\u{bcd}"),
            keywords: &[
                "பில\u{bbe}ஸம\u{bcd}",
                "மஞ\u{bcd}சள\u{bcd} மலர\u{bcd}",
                "மலர\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మ\u{c4a}గ\u{c4d}గ"),
            keywords: &[
                "పువ\u{c4d}వు",
                "పుష\u{c4d}పం",
                "మ\u{c4a}క\u{c4d}క",
                "మ\u{c4a}గ\u{c4d}గ",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("гул кардан"),
            keywords: &["гул", "гул кардан"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ดอกไม\u{e49}บาน"),
            keywords: &["ดอกไม\u{e49}", "ดอกไม\u{e49}บาน"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("açylan gül"),
            keywords: &["açylan gül", "gül"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("matalaʻiʻakau"),
            keywords: &["matalaʻiʻakau"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("çiçek açma"),
            keywords: &["bitki", "çiçek", "çiçek açma"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("چېچەك"),
            keywords: &["چېچەك"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("жовта квітка"),
            keywords: &["жовта квітка", "квітка", "рослина"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("شگوفہ"),
            keywords: &["شگوفہ", "پودا", "پھول"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("gul"),
            keywords: &["gul", "o‘simlik"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("hoa"),
            keywords: &["hoa", "thực vật"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("fulóor"),
            keywords: &["fulër", "fulóor"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-blossom"),
            keywords: &["i-blossom", "intyatyambo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Iruwe"),
            keywords: &["Iruwe", "Odòdó"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("開花"),
            keywords: &["花", "開花"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("开花"),
            keywords: &["开花", "花"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("开花"),
            keywords: &["开花", "花"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("開花"),
            keywords: &["花", "開花"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("花朵"),
            keywords: &["花", "花朵", "開花"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ukuqhakaza"),
            keywords: &["imbali", "isitshalo", "ukuqhakaza"],
        },
    ],
};
#[doc = "🌷"]
pub const TULIP: crate::Emoji = crate::Emoji {
    glyph: "🌷",
    codepoint: "1F337",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "tulip",
    group: "Animals & Nature",
    subgroup: "plant-flower",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("tulp"),
            keywords: &["blom", "plant", "tulp"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ቱሊፕ አበባ"),
            keywords: &["ተክል", "ቱሊፕ አበባ", "አበባ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}زهرة التوليب"),
            keywords: &["زهرة", "\u{202b}زهرة التوليب"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("টিউলিপ"),
            keywords: &["টিউলিপ", "ফ\u{9c1}ল"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("liliya"),
            keywords: &["bitki", "gül", "liliya"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("цюльпан"),
            keywords: &["кветка", "расліна", "цюльпан"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("лале"),
            keywords: &["лале", "растение", "цвете"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("টিউলিপ"),
            keywords: &["গ\u{9be}ছ", "টিউলিপ", "ফ\u{9c1}ল"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("tulipezenn"),
            keywords: &["bleunienn", "tulipezenn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("tulipan"),
            keywords: &["biljka", "cvijet", "tulipan"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("tulipa"),
            keywords: &["flor", "planta", "tulipa"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏚᎵᏈ"),
            keywords: &["ᎤᏥᎸᏍᎩ", "ᏚᎵᏈ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("tulipán"),
            keywords: &["květ", "květina", "rostlina", "tulipán"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("tiwlip"),
            keywords: &["blodyn", "tiwlip"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("tulipan"),
            keywords: &["blomst", "tulipan"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Tulpe"),
            keywords: &["Blume", "Blüte", "Pflanze", "Tulpe"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("τουλίπα"),
            keywords: &["λουλούδι", "τουλίπα", "φυτό"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("tulip"),
            keywords: &["flower", "tulip"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("tulipán"),
            keywords: &["flor", "tulipán"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["flor", "tulipán"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("tulp"),
            keywords: &["lill", "taim", "tulp"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("tulipa"),
            keywords: &["landare", "lore", "tulipa"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("لاله"),
            keywords: &["لاله", "گل", "گیاه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("tulppaani"),
            keywords: &["kasvi", "kukka", "tulppaani"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("tulip"),
            keywords: &["bulaklak", "halaman", "tulip"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("tulipán"),
            keywords: &["blomstur", "blóma", "tulipán"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("tulipe"),
            keywords: &["fleur", "tulipe"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("tiúilip"),
            keywords: &["bláth", "tiúilip"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("tuiliop"),
            keywords: &["flùr", "tuiliop"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("tulipán"),
            keywords: &["flor", "tulipán"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ટ\u{acd}ય\u{ac2}લિપ"),
            keywords: &["ટ\u{acd}ય\u{ac2}લિપ", "ફ\u{ac2}લ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("tulip"),
            keywords: &["fure", "tulip"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("צבעוני"),
            keywords: &["הולנד", "פרח", "צבעוני"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ट\u{94d}य\u{942}लिप"),
            keywords: &["ट\u{94d}य\u{942}लिप", "फ\u{942}ल"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("tulipan"),
            keywords: &["biljka", "cvijet", "tulipan"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("tulipán"),
            keywords: &["növény", "tulipán", "virág"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կակաչ"),
            keywords: &["բույս", "ծաղիկ", "կակաչ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tulip"),
            keywords: &["bunga", "tanaman", "tulip"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("tulip"),
            keywords: &["okooko", "tulip"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("túlípani"),
            keywords: &["blóm", "túlípani"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("tulipano"),
            keywords: &["fiore", "tulipano"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("チューリップ"),
            keywords: &["チューリップ", "花"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tulip"),
            keywords: &["kembang", "tulip"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ტიტა"),
            keywords: &["მცენარე", "ტიტა", "ყვავილი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("taxlult"),
            keywords: &["taxlult"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қызғалдақ"),
            keywords: &["гүл", "қызғалдақ", "өсімдік"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("tulipan"),
            keywords: &["blomst", "tulipan"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ផ\u{17d2}កាទ\u{17bc}ល\u{17b8}ប"),
            keywords: &[
                "ទ\u{17bc}ល\u{17b8}ប",
                "ផ\u{17d2}កា",
                "ផ\u{17d2}កាទ\u{17bc}ល\u{17b8}ប",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಟುಲ\u{cbf}ಪ\u{ccd}"),
            keywords: &["ಟುಲ\u{cbf}ಪ\u{ccd}", "ಹ\u{cc2}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("튤립"),
            keywords: &["꽃", "튤립"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ट\u{941}लिप"),
            keywords: &["ट\u{941}लिप", "फ\u{942}ल"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жоогазын"),
            keywords: &["гүл", "жоогазын", "өсүмдүк"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Tulp"),
            keywords: &["Blumm", "Tulp"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ດອກທ\u{eb4}ວລ\u{eb4}ບ"),
            keywords: &["ດອກທ\u{eb4}ວລ\u{eb4}ບ", "ດອກໄມ\u{ec9}"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("tulpė"),
            keywords: &["augalas", "gėlė", "tulpė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("tulpe"),
            keywords: &["augs", "tulpe", "zieds"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tūripi"),
            keywords: &["putiputi", "tūripi"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("лале"),
            keywords: &["лале", "растение", "цвет"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ട\u{d4d}യ\u{d42}ലിപ\u{d4d}"),
            keywords: &[
                "ചെടി",
                "ട\u{d42}ളിപ\u{d4d}",
                "ട\u{d4d}യ\u{d42}ലിപ\u{d4d}",
                "പ\u{d41}ഷ\u{d4d}പം",
                "പ\u{d42}വ\u{d4d}",
                "റ\u{d4d}റ\u{d42}ലിപ\u{d4d}പ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("алтан зул цэцэг"),
            keywords: &["алтан зул", "алтан зул цэцэг", "ургамал", "цэцэг"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ट\u{94d}य\u{941}लिप फ\u{942}ल"),
            keywords: &["ट\u{94d}य\u{941}लिप", "फ\u{942}ल"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bunga tulip"),
            keywords: &["bunga", "tulip"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("tulipan"),
            keywords: &["fjura", "tulipan"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ကျ\u{1030}းလစ\u{103a}ပန\u{103a}း"),
            keywords: &["ကျ\u{1030}းလစ\u{103a}ပန\u{103a}း", "ပန\u{103a}း"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("tulipan"),
            keywords: &["blomst", "tulipan"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ट\u{941}लिप"),
            keywords: &["ट\u{941}लिप", "फ\u{942}ल", "बिर\u{942}वा"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("tulp"),
            keywords: &["bloem", "tulp"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("tulipan"),
            keywords: &["blomster", "tulipan"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଟ\u{b4d}ୟ\u{b41}ଲ\u{b3f}ପ\u{b4d}"),
            keywords: &["ଟ\u{b4d}ୟ\u{b41}ଲ\u{b3f}ପ\u{b4d}", "ଫ\u{b41}ଲ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਟਯ\u{a42}ਲਿਪ"),
            keywords: &["ਟਯ\u{a42}ਲਿਪ", "ਫ\u{a41}\u{a71}ਲ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("گل\u{650} لالہ"),
            keywords: &["پھ\u{64f}ل", "گل\u{650} لالہ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Túlip"),
            keywords: &["Fláwa", "Túlip"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("tulipan"),
            keywords: &["kwiat", "kwiatek", "pąk", "tulipan"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("غاټول"),
            keywords: &["غاټول", "ګل، غاټول"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("tulipa"),
            keywords: &["flor", "tulipa"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("túlipa"),
            keywords: &["flor", "túlipa"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("tulipán"),
            keywords: &["tulipan", "tulipán", "tʼika"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("lalea"),
            keywords: &["floare", "lalea", "plantă", "primăvară"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-252"),
            keywords: &["E10-252"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("тюльпан"),
            keywords: &["тюльпан", "цветок"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ururabyo rwa tulipu"),
            keywords: &["ururabo", "ururabyo rwa tulipu"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("نرگس جو گل"),
            keywords: &["نرگس جو گل", "گل"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ට\u{dd2}ය\u{dd4}ල\u{dd2}ප\u{dca}"),
            keywords: &["ට\u{dd2}ය\u{dd4}ල\u{dd2}ප\u{dca}", "පැළය", "මල"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("tulipán"),
            keywords: &["kvetina", "rastlina", "tulipán"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("tulipan"),
            keywords: &["rastlina", "roža", "tulipan"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("ubax caano"),
            keywords: &["ubax", "ubax caano"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("tulipan"),
            keywords: &["bimë", "lule", "tulipan"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("лала"),
            keywords: &["лала", "цвет"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["лала"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("lala"),
            keywords: &["cvet", "lala"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["lala"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("tulpan"),
            keywords: &["blomma", "tulpan"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("tulipu"),
            keywords: &["mmea", "tulipu", "ua"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பூவரசு"),
            keywords: &[
                "இலைகள\u{bcd}",
                "செடி",
                "ட\u{bcd}யுலிப\u{bcd}",
                "பூவரசு",
                "மலர\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("చ\u{c3f}త\u{c4d}రవర\u{c4d}ణ\u{c3e}లు గల పుష\u{c4d}పం"),
            keywords: &[
                "చ\u{c3f}త\u{c4d}రవర\u{c4d}ణం",
                "చ\u{c3f}త\u{c4d}రవర\u{c4d}ణ\u{c3e}లు గల పుష\u{c4d}పం",
                "పుష\u{c4d}పం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("лола"),
            keywords: &["гул", "лола"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ท\u{e34}วล\u{e34}ป"),
            keywords: &["ดอกไม\u{e49}", "ท\u{e34}วล\u{e34}ป"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("çigildem"),
            keywords: &["gül", "çigildem"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tiulipe"),
            keywords: &["tiulipe"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("lale"),
            keywords: &["bitki", "lale", "çiçek"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("كۈركۈم"),
            keywords: &["كۈركۈم", "چېچەك"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("тюльпан"),
            keywords: &["квітка", "рослина", "тюльпан"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("نرگس کا پھول"),
            keywords: &["نرگس کا پھول", "پودا", "پھول"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("lola"),
            keywords: &["gul", "lola", "o‘simlik"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("hoa tulip"),
            keywords: &["hoa", "hoa tulip"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("tulip"),
            keywords: &["fulër", "tulip"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-tulip"),
            keywords: &["i-tulip", "intyatyambo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Tulipu"),
            keywords: &["Odòdó", "Tulipu"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("鬱金香"),
            keywords: &["花", "鬱金香"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("郁金香"),
            keywords: &["花", "郁金香"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("郁金香"),
            keywords: &["花", "郁金香"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("鬱金香"),
            keywords: &["花", "鬱金香"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("i-tulip"),
            keywords: &["i-tulip", "imbali", "isitshalo"],
        },
    ],
};
