#[doc = "🐊"]
pub const CROCODILE: crate::Emoji = crate::Emoji {
    glyph: "🐊",
    codepoint: "1F40A",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "crocodile",
    group: "Animals & Nature",
    subgroup: "animal-reptile",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("krokodil"),
            keywords: &["krokodil"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("አዞ"),
            keywords: &["አዞ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("تمساح"),
            keywords: &["تمساح", "حيوان"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ঘৰিয\u{9bc}\u{9be}ল"),
            keywords: &["ঘৰিয\u{9bc}\u{9be}ল"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("timsah"),
            keywords: &["timsah"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("кракадзіл"),
            keywords: &["кракадзіл"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("крокодил"),
            keywords: &["воден хищник", "крокодил"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ক\u{9c1}মির"),
            keywords: &["ক\u{9c1}মির"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("krokodil"),
            keywords: &["krokodil", "loen"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("krokodil"),
            keywords: &["krokodil"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cocodril"),
            keywords: &["cocodril"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄇\u{1112a}𑄟\u{1112e}𑄢\u{11134}"),
            keywords: &["𑄇\u{1112a}𑄟\u{1112e}𑄢\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏧᎳᏍᎩ"),
            keywords: &["ᏧᎳᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("krokodýl"),
            keywords: &["aligátor", "krokodýl"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("crocodeil"),
            keywords: &["crocodeil"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("krokodille"),
            keywords: &["dyr", "krokodille"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Krokodil"),
            keywords: &["Krokodil", "Tier"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κροκόδειλος"),
            keywords: &["κροκόδειλος"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("crocodile"),
            keywords: &["crocodile"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["alligator", "croc", "crocodile"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cocodrilo"),
            keywords: &["caimán", "cocodrilo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["animal", "cocodrilo", "lagarto", "reptil"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("krokodill"),
            keywords: &["krokodill"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("krokodiloa"),
            keywords: &["krokodilo", "krokodiloa"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("تمساح"),
            keywords: &["تمساح", "سوسمار", "کروکودیل"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("krokotiili"),
            keywords: &["krokotiili"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("buwaya"),
            keywords: &["buwaya", "hayop"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("krokodilla"),
            keywords: &["dýr", "krokodilla"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("crocodile"),
            keywords: &["animal", "crocodile", "reptile"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["crocodile"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("crogall"),
            keywords: &["crogall"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("crogall"),
            keywords: &["crogall"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("crocodilo"),
            keywords: &["crocodilo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("મગર"),
            keywords: &["પ\u{acd}રાણી", "મગર"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kada"),
            keywords: &["kada"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("תנין"),
            keywords: &["אליגטור", "קרוקודיל", "תמסח", "תנין"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("मगरमच\u{94d}छ"),
            keywords: &["पश\u{941}", "मगरमच\u{94d}छ"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("krokodil"),
            keywords: &["krokodil"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("krokodil"),
            keywords: &["krokodil"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կոկորդիլոս"),
            keywords: &["կոկորդիլոս"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("buaya"),
            keywords: &["buaya"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("agụiyi"),
            keywords: &["agụiyi"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("krókódíll"),
            keywords: &["krókódíll", "krókókíll"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("coccodrillo"),
            keywords: &["animale", "coccodrillo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ワニ"),
            keywords: &["ワニ", "動物", "爬虫類"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("baya"),
            keywords: &["baya"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ნიანგი"),
            keywords: &["ნიანგი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қолтырауын"),
            keywords: &["қолтырауын"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("krokodille"),
            keywords: &["dyr", "krokodille"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ក\u{17d2}រពើ"),
            keywords: &["ក\u{17d2}រពើ"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮೊಸಳ\u{cc6}"),
            keywords: &["ಮೊಸಳ\u{cc6}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("악어"),
            keywords: &["동물", "악어"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("मानग\u{947}\u{902}"),
            keywords: &["मानग\u{947}\u{902}"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("крокодил"),
            keywords: &["крокодил"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Krokodil"),
            keywords: &["Krokodil"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ແຂ\u{ec9}"),
            keywords: &["ສ\u{eb1}ດ", "ແຂ\u{ec9}"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("krokodilas"),
            keywords: &["krokodilas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("krokodils"),
            keywords: &["aligators", "krokodils"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("nguturoa"),
            keywords: &["nguturoa"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("крокодил"),
            keywords: &["влекач", "крокодил"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മ\u{d41}തല"),
            keywords: &["മ\u{d41}തല", "മ\u{d43}ഗം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("матар"),
            keywords: &["матар"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("मगर"),
            keywords: &["मगर"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("buaya"),
            keywords: &["buaya"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("kukkudrill"),
            keywords: &["kukkudrill"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("မ\u{102d}ကျောင\u{103a}း"),
            keywords: &["မ\u{102d}ကျောင\u{103a}း"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("krokodille"),
            keywords: &["dyr", "krokodille"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("गोही"),
            keywords: &["गोही"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("krokodil"),
            keywords: &["krokodil"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("krokodille"),
            keywords: &["dyr", "krokodille"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କ\u{b41}ମ\u{b4d}ଭୀର"),
            keywords: &["କ\u{b41}ମ\u{b4d}ଭୀର"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਮਗਰਮ\u{a71}ਛ"),
            keywords: &["ਜਾਨਵਰ", "ਮਗਰਮ\u{a71}ਛ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("مگرمچھ"),
            keywords: &["مگرمچھ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Krókodail"),
            keywords: &["Krókodail"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("krokodyl"),
            keywords: &["aligator", "krokodyl"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("تمساح"),
            keywords: &["تمساح"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("crocodilo"),
            keywords: &["animal", "crocodilo"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["crocodilo", "jacaré"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("kayman"),
            keywords: &["kayman"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("crocodil"),
            keywords: &["crocodil", "reptilă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-455"),
            keywords: &["E10-455"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("крокодил"),
            keywords: &["аллигатор", "зеленый", "крокодил"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ingona"),
            keywords: &["ingona"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("واڳون"),
            keywords: &["واڳون"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ක\u{dd2}ඹ\u{dd4}ල\u{dcf}"),
            keywords: &["ක\u{dd2}ඹ\u{dd4}ල\u{dcf}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("krokodíl"),
            keywords: &["krokodíl"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("krokodil"),
            keywords: &["krokodil"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("yaxaas"),
            keywords: &["yaxaas"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("krokodil"),
            keywords: &["krokodil"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("крокодил"),
            keywords: &["крoкoдил", "крокодил"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["крокодил"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("krokodil"),
            keywords: &["krokodil"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["krokodil"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("krokodil"),
            keywords: &["djur", "krokodil"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mamba"),
            keywords: &["mamba"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("முதலை"),
            keywords: &["ஊர\u{bcd}வது", "முதலை", "விலங\u{bcd}கு"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మ\u{c4a}సల\u{c3f}"),
            keywords: &["జంతువు", "మ\u{c4a}సల\u{c3f}"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тимсоҳ"),
            keywords: &["тимсоҳ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("จระเข\u{e49}"),
            keywords: &["จระเข\u{e49}", "ส\u{e31}ตว\u{e4c}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("krokodil"),
            keywords: &["krokodil"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kalokataile"),
            keywords: &["kalokataile"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("timsah"),
            keywords: &["hayvan", "timsah"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("تىمساھ"),
            keywords: &["تىمساھ"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("крокодил"),
            keywords: &["крокодил"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("مگرمچھ"),
            keywords: &["جانور", "مگرمچھ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("timsoh"),
            keywords: &["timsoh"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("cá sấu"),
            keywords: &["cá sấu"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("jasit"),
            keywords: &["jasit"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ingwenya"),
            keywords: &["ingwenya"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ọni"),
            keywords: &["Ọni"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("鱷魚"),
            keywords: &["鱷魚"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("鳄鱼"),
            keywords: &["鳄鱼"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("鳄鱼"),
            keywords: &["鳄鱼"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("鱷魚"),
            keywords: &["鱷", "鱷魚"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ingwenya"),
            keywords: &["ingwenya"],
        },
    ],
};
#[doc = "🐢"]
pub const TURTLE: crate::Emoji = crate::Emoji {
    glyph: "🐢",
    codepoint: "1F422",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "turtle",
    group: "Animals & Nature",
    subgroup: "animal-reptile",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("waterskilpad"),
            keywords: &["waterskilpad"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ኤሊ"),
            keywords: &["ኤሊ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سلحفاة"),
            keywords: &["حيوان", "سلحفاة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ক\u{9be}ছ"),
            keywords: &["কচ\u{9cd}ছপ", "ক\u{9be}ছ", "নদীত চৰ\u{9be} ক\u{9be}ছ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("tısbağa"),
            keywords: &["bağa", "su tısbağası", "tısbağa"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("чарапаха"),
            keywords: &["чарапаха"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("костенурка"),
            keywords: &["костенурка"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("কচ\u{9cd}ছপ"),
            keywords: &["কচ\u{9cd}ছপ"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("baot"),
            keywords: &["baot", "loen"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("kornjača"),
            keywords: &["kornjača"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("tortuga"),
            keywords: &["tortuga"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄘\u{1112a}𑄢\u{11134}"),
            keywords: &["𑄘\u{1112a}𑄢\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏓᎦᏏ"),
            keywords: &["ᎠᎹᏱ ᎡᎯ ᏓᎦᏏ", "ᏓᎦᏏ", "ᏓᎦᏏ ᎡᏆ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("želva"),
            keywords: &["obojživelník", "želva"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("crwban y môr"),
            keywords: &["crwban", "crwban y môr", "terapin"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("skildpadde"),
            keywords: &["dyr", "skildpadde"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Schildkröte"),
            keywords: &["Schildkröte", "Tier"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("χελώνα"),
            keywords: &["χελώνα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("turtle"),
            keywords: &["terrapin", "tortoise", "turtle"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("tortuga"),
            keywords: &["galápago", "tortuga"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["animal", "reptil", "tortuga"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kilpkonn"),
            keywords: &["kilpkonn"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("dortoka"),
            keywords: &["dortoka", "dortokoa"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("لاک\u{200c}پشت"),
            keywords: &[
                "سنگ\u{200c}پشت",
                "لاک\u{200c}پشت",
                "کاسه\u{200c}پشت",
                "کاس\u{200c}پشت",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kilpikonna"),
            keywords: &["kilpikonna"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pagong"),
            keywords: &["hayop", "pagong"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("skjaldbøka"),
            keywords: &[
                "dýr",
                "havskjaldbøka",
                "landskjaldbøka",
                "mýriskjaldbøka",
                "skjaldbøka",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("tortue"),
            keywords: &["animal", "reptile", "tortue"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["tortue"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("turtar"),
            keywords: &["tiripín", "toirtís", "turtar"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("turtar"),
            keywords: &["seilche", "sligeanach", "toirtis", "turtar"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("tartaruga"),
            keywords: &["tartaruga"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("કાચબો"),
            keywords: &["કાચબો", "પ\u{acd}રાણી"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kififfiya"),
            keywords: &["kififfiya", "kififfiyar kogi", "kunkuru"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("צב"),
            keywords: &["צב", "שלחופה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("कछ\u{941}आ"),
            keywords: &["कछ\u{941}आ", "पश\u{941}"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("kornjača"),
            keywords: &["kornjača"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("teknős"),
            keywords: &["teknőc", "teknős", "teknősbéka"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կրիա"),
            keywords: &["կրիա"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kura-kura"),
            keywords: &["kura-kura", "penyu", "terrapin"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("mbè"),
            keywords: &["mbè", "mbè mmiri", "nwa mbè"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("skjaldbaka"),
            keywords: &["skjaldbaka"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("tartaruga"),
            keywords: &["animale", "tartaruga"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("カメ"),
            keywords: &["カメ", "動物", "爬虫類"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kura-kura"),
            keywords: &["bulus", "kura-kura", "penyu"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("კუ"),
            keywords: &["ბაკანი", "კუ"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("тасбақа"),
            keywords: &["тасбақа"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("skildpadde"),
            keywords: &["dyr", "skildpadde"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("អណ\u{17d2}តើក"),
            keywords: &["អណ\u{17d2}ដើក", "អណ\u{17d2}តើក", "អណ\u{17d2}តើកត\u{17bc}ច"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಆಮ\u{cc6}"),
            keywords: &["ಆಮ\u{cc6}", "ಟ\u{cc6}ರಾಪ\u{cbf}ನ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("거북이"),
            keywords: &["거북이", "동물"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("कासव"),
            keywords: &["कासय", "कासव", "ट\u{947}रापीन"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("ташбака"),
            keywords: &["ташбака"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Deckelsmouk"),
            keywords: &["Deckelsmouk", "Douseschildkröt", "Schildkröt"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເຕ\u{ebb}\u{ec8}າ"),
            keywords: &["ສ\u{eb1}ດ", "ເຕ\u{ebb}\u{ec8}າ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("vėžlys"),
            keywords: &["vėžlys"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("bruņurupucis"),
            keywords: &["bruņurupucis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("honu"),
            keywords: &["honu", "terapine"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("желка"),
            keywords: &["желка"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ആമ"),
            keywords: &["ആമ", "മ\u{d43}ഗം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("яст мэлхий"),
            keywords: &["яст мэлхий"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("कासव"),
            keywords: &["कासव"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("penyu"),
            keywords: &["penyu"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("fekruna"),
            keywords: &["fekruna", "terrapin"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လ\u{102d}ပ\u{103a}"),
            keywords: &["လ\u{102d}ပ\u{103a}"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("skilpadde"),
            keywords: &["dyr", "skilpadde"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("कछ\u{941}वा"),
            keywords: &["कछ\u{941}वा"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("schildpad"),
            keywords: &["schildpad", "waterschildpad"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("skjelpadde"),
            keywords: &["dyr", "skjelpadde"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କଇ\u{b01}ଛ"),
            keywords: &["କଇ\u{b01}ଛ", "କଚ\u{b4d}ଛପ", "ଟେର\u{b3e}ପ\u{b3f}ନ\u{b4d}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕ\u{a71}ਛ\u{a42}ਕ\u{a41}\u{a70}ਮਾ"),
            keywords: &[
                "ਕ\u{a71}ਛ\u{a42}ਆ",
                "ਕ\u{a71}ਛ\u{a42}ਕ\u{a41}\u{a70}ਮਾ",
                "ਜਾਨਵਰ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کچھوا"),
            keywords: &["میٹھے پانی دا کچھوا", "کچھوا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Tọ\u{301}tul"),
            keywords: &[
                "Tẹ\u{301}rapin: Wọ\u{301}n Smọ\u{301}l Anímọl Wé Rizẹ\u{301}mbúl Tọ\u{301}tis",
                "Tọ\u{301}tis",
                "Tọ\u{301}tul",
                "Tọ\u{301}tul: Wọ\u{301}n Bíg Anímọl Wé Rizẹ\u{301}mbúl Tọ\u{301}tis",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("żółw"),
            keywords: &["żółw"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("شمشتۍ"),
            keywords: &["شمشتۍ", "کيشپ، شمشتۍ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("tartaruga"),
            keywords: &["animal", "tartaruga"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["cágado", "tartaruga"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("tortuga"),
            keywords: &["miskʼi yakumanta tortuga", "tortuga"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("broască țestoasă"),
            keywords: &["broască țestoasă", "carapace", "țestoasă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-479"),
            keywords: &["E10-479"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("черепаха"),
            keywords: &["зеленая", "черепаха"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("akanyamasyo"),
            keywords: &["akanyamasyo", "akanyamasyo ko mu mazi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪمي"),
            keywords: &["ڪمي", "ڪمي، ڪمي، ڪمي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ඉබ\u{dca}බ\u{dcf}"),
            keywords: &["ඉබ\u{dca}බ\u{dcf}", "කැස\u{dca}බෑව\u{dcf}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("korytnačka"),
            keywords: &["korytnačka"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("želva"),
            keywords: &["želva"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("qubo"),
            keywords: &["diin", "qubo", "qubo dhal ah"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("breshkë"),
            keywords: &["breshkë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("корњача"),
            keywords: &["корњача"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["корњача"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("kornjača"),
            keywords: &["kornjača"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["kornjača"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("sköldpadda"),
            keywords: &["havssköldpadda", "padda", "sköldpadda"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mzee kobe"),
            keywords: &["kobe", "mzee kobe"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஆமை"),
            keywords: &[
                "ஆமை",
                "ஊர\u{bcd}வன",
                "கடல\u{bbe}மை",
                "விலங\u{bcd}கினம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("త\u{c3e}బ\u{c47}లు"),
            keywords: &["జంతువు", "త\u{c3e}బ\u{c47}లు"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("сангпушти обӣ"),
            keywords: &[
                "сангпушт",
                "сангпушт обӣ",
                "сангпушти даштӣ",
                "сангпушти обӣ",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เต\u{e48}า"),
            keywords: &["ส\u{e31}ตว\u{e4c}", "เต\u{e48}า"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("pyşdyl"),
            keywords: &["pyşbaga", "pyşdyl", "suw pyşdyly"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fonu"),
            keywords: &["fonu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kaplumbağa"),
            keywords: &["hayvan", "kaplumbağa"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("تاشپاقا"),
            keywords: &["تاشپاقا", "سۇ تاشپاقىسى", "قاپ"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("черепаха"),
            keywords: &["черепаха"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کچھوا"),
            keywords: &["جانور", "کچھوا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("toshbaqa"),
            keywords: &["toshbaqa"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("rùa"),
            keywords: &["con rùa", "rùa", "rùa nước ngọt"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("mbonaat"),
            keywords: &["mbonaat", "mbonaatu-ndox"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ufudo"),
            keywords: &["ufudo", "ufudo lwamanzi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Adaba"),
            keywords: &["Adaba", "Awun", "awun kékeré", "ìjàpá"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("海龜"),
            keywords: &["水龜", "海龜", "陸龜"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("海龟"),
            keywords: &["水龟", "海龟", "陆龟"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("龟"),
            keywords: &["乌龟", "海龟", "龟"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("烏龜"),
            keywords: &["烏龜", "龜"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["小烏龜", "烏龜"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ufudu"),
            keywords: &["ufudu"],
        },
    ],
};
#[doc = "🦎"]
pub const LIZARD: crate::Emoji = crate::Emoji {
    glyph: "🦎",
    codepoint: "1F98E",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "lizard",
    group: "Animals & Nature",
    subgroup: "animal-reptile",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("akkedis"),
            keywords: &["akkedis", "geitjie", "reptiel"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("እንሽላሊት"),
            keywords: &["በደረታቸው የሚሳቡ እንስሳት", "እንሽላሊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سحلية"),
            keywords: &["زواحف", "سحلية"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("জেঠী"),
            keywords: &["জেঠী", "সৰীস\u{9c3}প"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kərtənkələ"),
            keywords: &["kərtənkələ", "sürünən"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("яшчарка"),
            keywords: &["рэптылія", "яшчарка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("гущер"),
            keywords: &["влечуго", "гущер"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("টিকটিকি"),
            keywords: &["টিকটিকি", "সরীস\u{9c3}প"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("glazard"),
            keywords: &["glazard", "loen"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("gušter"),
            keywords: &["gušter", "reptil"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("llangardaix"),
            keywords: &["animal", "llangardaix", "rèptil"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄑\u{1112a}𑄖\u{11134}𑄑\u{1112a}𑄝\u{11128}"),
            keywords: &["𑄑\u{1112a}𑄖\u{11134}𑄑\u{1112a}𑄝\u{11128}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏘᏲᎭᎵ"),
            keywords: &["ᎠᎾᏓᏏᏂᏙᎯ", "ᏘᏲᎭᎵ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("ještěrka"),
            keywords: &["ještěrka", "plaz"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("madfall"),
            keywords: &["madfall", "ymlusgiad"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("firben"),
            keywords: &["dyr", "firben", "krybdyr", "reptil"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Eidechse"),
            keywords: &["Eidechse", "Reptil"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σαύρα"),
            keywords: &["ερπετό", "σαύρα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("lizard"),
            keywords: &["lizard", "reptile"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("lagarto"),
            keywords: &["lagartija", "lagarto", "reptil"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("lagartija"),
            keywords: &["animal", "lagartija", "lagarto", "reptil"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("sisalik"),
            keywords: &["roomaja", "sisalik"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("sugandila"),
            keywords: &["narrasti", "sugandila"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("مارمولک"),
            keywords: &["خزنده", "مارمولک"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("lisko"),
            keywords: &["lisko", "matelija"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("butiki"),
            keywords: &["butiki", "reptile"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("oydla"),
            keywords: &["dýr", "edlur", "ferføtlur", "oydla"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("lézard"),
            keywords: &["animal", "lézard", "reptile"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("earc luachra"),
            keywords: &["earc luachra", "reiptíl"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("laghairt"),
            keywords: &["laghairt", "snàigeach"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("lagarto"),
            keywords: &["animal", "lagarto", "réptil"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ગરોળી"),
            keywords: &["ગરોળી", "સરિસ\u{ac3}પ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kadangare"),
            keywords: &["ja jiki", "kadangare"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לטאה"),
            keywords: &["זוחל", "לטאה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("छिपकली"),
            keywords: &["छिपकली", "सा\u{901}प"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("gušter"),
            keywords: &["gušter", "reptil"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("gyík"),
            keywords: &["gyík", "hüllő"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մողես"),
            keywords: &["մողես", "սողուն"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kadal"),
            keywords: &["kadal", "reptil"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ngwere"),
            keywords: &["ihe na-arị arị", "ngwere"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("eðla"),
            keywords: &["eðla", "skriðdýr"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("lucertola"),
            keywords: &["animale", "lucertola", "rettile"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("トカゲ"),
            keywords: &["トカゲ", "動物", "爬虫類"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("cecak"),
            keywords: &["cecak"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ხვლიკი"),
            keywords: &["ქვეწარმავალი", "ხვლიკი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("кесіртке"),
            keywords: &["бауырымен жорғалаушы", "кесіртке"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("firben"),
            keywords: &["dyr", "firben", "krybdyr", "reptil"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ជ\u{17b8}ងចក\u{17cb}"),
            keywords: &["ជ\u{17b8}ងចក\u{17cb}", "ត\u{17bb}កែ", "ល\u{17d2}ម\u{17bc}ន"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಹಲ\u{ccd}ಲ\u{cbf}"),
            keywords: &["ಸರೀಸೃಪ", "ಹಲ\u{ccd}ಲ\u{cbf}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("도마뱀"),
            keywords: &["도마뱀", "동물", "파충류"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("पाल"),
            keywords: &["पाल", "सरपटपी"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кескелдирик"),
            keywords: &["кескелдирик", "рептилия"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Eidechs"),
            keywords: &["Eidechs", "Reptil"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ສ\u{eb1}ດເລ\u{eb7}ອຄານ"),
            keywords: &[
                "ກ\u{eb1}ບແກ\u{ec9}",
                "ກ\u{eb1}ບໂກ\u{ec9}",
                "ສ\u{eb1}ດເລ\u{eb7}ອຄານ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("driežas"),
            keywords: &["driežas", "roplys"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("ķirzaka"),
            keywords: &["rāpulis", "ķirzaka"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("mokomoko"),
            keywords: &["mokomoko", "ngārara"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("гуштер"),
            keywords: &["влекач", "гуштер"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പല\u{d4d}ലി"),
            keywords: &["ഉരഗം", "പല\u{d4d}ലി"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("гүрвэл"),
            keywords: &["гүрвэл", "хэвлээр явагч"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("पाल"),
            keywords: &["पाल", "सरीस\u{943}प"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("cicak"),
            keywords: &["cicak", "reptilia"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("wiża’"),
            keywords: &["rettili", "wiża’"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အ\u{102d}မ\u{103a}မြ\u{103e}ောင\u{103a}"),
            keywords: &[
                "တ\u{103d}ားသ\u{103d}ားသတ\u{1039}တဝါ",
                "အ\u{102d}မ\u{103a}မြ\u{103e}ောင\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("firfisle"),
            keywords: &["dyr", "firfisle", "reptil", "øgle"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("छ\u{947}पारो"),
            keywords: &["घिस\u{94d}रिन\u{947} जनावर", "छ\u{947}पारो"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("hagedis"),
            keywords: &["gekko", "hagedis", "reptiel"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("firfisle"),
            keywords: &["dyr", "firfisle", "reptil", "øgle"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଝ\u{b3f}ଟ\u{b3f}ପ\u{b3f}ଟ\u{b3f}"),
            keywords: &[
                "ଝ\u{b3f}ଟ\u{b3f}ପ\u{b3f}ଟ\u{b3f}",
                "ଝ\u{b3f}ଟ\u{b3f}ପ\u{b3f}ଟ\u{b3f} । ସରୀସ\u{b43}ପ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕਿਰਲੀ"),
            keywords: &["ਕਿਰਲੀ", "ਸ\u{a71}ਪ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کوڑ-کرلی"),
            keywords: &["رینگن آلا جانور", "کوڑ-کرلی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Lízad"),
            keywords: &["Lízad", "Ánímọl"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("jaszczurka"),
            keywords: &["gad", "jaszczurka"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("لټکه"),
            keywords: &["لټکه", "لټکه، ريپټايل"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("lagartixa"),
            keywords: &["animal", "lagartixa", "réptil"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("lagarto"),
            keywords: &["lagarto", "réptil"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("qaraywa"),
            keywords: &["ararankha", "qaraywa"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("șopârlă"),
            keywords: &["reptilă", "târâtoare", "șopârlă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1110"),
            keywords: &["E10-1110"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("ящерица"),
            keywords: &["зеленая", "рептилия", "ящерица"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umuserebanya"),
            keywords: &["igikururanda", "umuserebanya"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪرڙي"),
            keywords: &["ڪرڙي", "ڪرڙي، ريڙهيون پائيندڙ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කට\u{dd4}ස\u{dca}ස\u{dcf}"),
            keywords: &["උරගය\u{dcf}", "කට\u{dd4}ස\u{dca}ස\u{dcf}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("jašterica"),
            keywords: &["jašterica", "plaz"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("kuščar"),
            keywords: &["kuščar", "plazilec"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("qoroto"),
            keywords: &["qoroto", "xammaarato"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("hardhucë"),
            keywords: &["hardhucë", "zvarranik"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("гуштер"),
            keywords: &["гуштер", "рептил"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["гуштер"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("gušter"),
            keywords: &["gušter", "reptil"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["gušter"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("ödla"),
            keywords: &["kräldjur", "ödla"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mjusi"),
            keywords: &["kenge", "mjusi", "mnyama anayetamba"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பல\u{bcd}லி"),
            keywords: &["பல\u{bcd}லி"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("బల\u{c4d}ల\u{c3f}"),
            keywords: &["బల\u{c4d}ల\u{c3f}", "సర\u{c40}సృపం"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("калтакалос"),
            keywords: &["калтакалос", "хазанда"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("จ\u{e34}\u{e49}งจก"),
            keywords: &[
                "จ\u{e34}\u{e49}งจก",
                "ต\u{e38}\u{e4a}กแก",
                "เล\u{e37}\u{e49}อยคลาน",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("hažžyk"),
            keywords: &["hažžyk", "suwulgan", "süýreniji"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("moko"),
            keywords: &["moko"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kertenkele"),
            keywords: &["kertenkele", "sürüngen"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("كەسلەنچۈك"),
            keywords: &["ئۆمىلىگۈچى", "كەسلەنچۈك"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("ящірка"),
            keywords: &["плазун", "рептилія", "ящірка"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("چھپکلی"),
            keywords: &["جانور", "رینگنا", "چھپکلی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kaltakesak"),
            keywords: &["kaltakesak", "sudralib yuruvchi"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("thằn lằn"),
            keywords: &["bò sát", "thằn lằn"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("sindax"),
            keywords: &["luy raam", "sindax"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("icikilishe"),
            keywords: &["icikilishe", "isirhubuluzi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Aláǹgba"),
            keywords: &["Aláǹgba", "aláǹgbà", "ẹranko tí nfí àìyà fà"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("蜥蜴"),
            keywords: &["爬行動物", "蜥蜴"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("蜥蜴"),
            keywords: &["爬行动物", "蜥蜴"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("蜥蜴"),
            keywords: &["爬行动物", "蜥蜴"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("蜥蜴"),
            keywords: &["爬行動物", "蜥蜴"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isibankwa"),
            keywords: &["huquzela ngesisu", "isibankwa"],
        },
    ],
};
#[doc = "🐍"]
pub const SNAKE: crate::Emoji = crate::Emoji {
    glyph: "🐍",
    codepoint: "1F40D",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "snake",
    group: "Animals & Nature",
    subgroup: "animal-reptile",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("slang"),
            keywords: &["Ophiochus", "Slangdraer", "diereriem", "slang"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("እባብ"),
            keywords: &["ተሸካሚ", "እባብ", "ኦፊዩከስ", "ዞዲያክ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ثعبان"),
            keywords: &["ثعبان", "حية"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("স\u{9be}প"),
            keywords: &["অফিউক\u{9be}চ", "ব\u{9be}হক", "স\u{9be}প", "ৰ\u{9be}শি"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("ilan"),
            keywords: &["daşıyan", "ilan", "ilandaşıyan", "zodiak"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("змяя"),
            keywords: &["задыяк", "змеяносец", "змяя", "спакушальнік", "яд"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("змия"),
            keywords: &["змиеносец", "змия", "зодиак", "зодиакален знак", "зодия"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("স\u{9be}প"),
            keywords: &[
                "অফিউক\u{9be}স",
                "ব\u{9be}হক",
                "র\u{9be}শিচক\u{9cd}র",
                "স\u{9be}প",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("naer"),
            keywords: &["loen", "naer"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("zmija"),
            keywords: &["horoskopski znak", "nositelj", "zmija", "zmijonosac"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("serp"),
            keywords: &["rèptil", "serp", "serpentari", "zodíac"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄥𑄛\u{11134}"),
            keywords: &["𑄥𑄛\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎢᎾᏓ"),
            keywords: &["ᎠᏍᎦᏯ ᎢᎾᏓ ᎧᏂᏙᎯ", "ᎢᎾᏓ", "ᏃᏈᏏ ᏓᏟᎶᏍᏗᎲᎢ", "ᏗᎧᏂᏙᎯ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("had"),
            keywords: &["had", "hadonoš", "plaz", "zvěrokruh"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("neidr"),
            keywords: &["neidr", "ophiuchus", "sidydd"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("slange"),
            keywords: &["dyr", "slange"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Schlange"),
            keywords: &[
                "Schlange",
                "Schlangenträger",
                "Sternzeichen",
                "Tier",
                "Tierkreis",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("φίδι"),
            keywords: &["Οφιούχος", "ζώδιο", "κομιστής", "φίδι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("snake"),
            keywords: &["Ophiuchus", "bearer", "serpent", "snake", "zodiac"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("serpiente"),
            keywords: &["culebra", "reptil", "serpiente", "víbora"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["animal", "reptil", "serpiente", "víbora"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["Ofiuco", "culebra", "serpiente", "víbora", "zodiaco"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("madu"),
            keywords: &["madu", "maokandja", "sodiaak"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("sugea"),
            keywords: &["mezulari", "ofiuko", "suge", "sugea", "zodiako"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("مار"),
            keywords: &["افعی", "اهریمن", "حامل", "زودیاک", "مار", "مارگیر"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("käärme"),
            keywords: &[
                "horoskooppi",
                "horoskooppimerkki",
                "käärme",
                "käärmeenkantaja",
                "viestintuoja",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("ahas"),
            keywords: &["ahas", "hayop", "ophiuchus", "serpiyente", "zodiac"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("slanga"),
            keywords: &["dýr", "serpentin", "slanga", "stjørnumerki"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("serpent"),
            keywords: &["animal", "reptile", "serpent"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["serpent", "serpentaire", "zodiaque"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("nathair"),
            keywords: &[
                "Ophiuchus",
                "nathair",
                "nathair nimhe",
                "sealbhóir",
                "stoidiaca",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("nathair"),
            keywords: &["giùlanair", "grian-chriosach", "nathair", "ophiuchus"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("serpe"),
            keywords: &["Ofiúco", "réptil", "serpe", "zodíaco"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સાપ"),
            keywords: &["પ\u{acd}રાણી", "સાપ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("maciji"),
            keywords: &["Ophiuchus", "maciji", "maɗauki", "zodiac"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("נחש"),
            keywords: &["ארסי", "נחש"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("सा\u{902}प"),
            keywords: &["पश\u{941}", "सा\u{902}प"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("zmija"),
            keywords: &["ophiuchus", "zmija", "zmijonosac", "zodijak"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("kígyó"),
            keywords: &["csillagjegy", "kígyó", "állatöv"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("օձ"),
            keywords: &["կենդանակերպ", "օձ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("ular"),
            keywords: &["ofiukus", "pembawa", "ular", "zodiak"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("agwọ"),
            keywords: &["Akaranribaama", "agwọ", "zodịak", "ọgba mgbochi"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("snákur"),
            keywords: &["naðra", "naðurvaldi", "snákur", "stjörnumerki"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("serpente"),
            keywords: &["animale", "serpente"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ヘビ"),
            keywords: &["ヘビ", "動物", "星座", "毒", "爬虫類"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("ula"),
            keywords: &["Ophiuchus", "sawer", "sing nggawa", "ula", "zodiak"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("გველი"),
            keywords: &["გველი", "გველისმჭერი", "ზოდიაქო", "ჰოროსკოპი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жылан"),
            keywords: &["жылан", "зодиак", "көтеруші"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("slange"),
            keywords: &["dyr", "slange"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ពស\u{17cb}"),
            keywords: &["ពស\u{17cb}"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಹಾವು"),
            keywords: &["ರಾಶ\u{cbf}ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}", "ಸರ\u{cbf}ಸೃಪ", "ಹಾವು"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("뱀"),
            keywords: &["동물", "뱀"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("जिवाण\u{947}\u{902}"),
            keywords: &["जिवाण\u{947}\u{902}", "फणो आसपी", "रास", "वाहक", "सरपटपी"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жылан"),
            keywords: &["жылан", "зодиак"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Schlaang"),
            keywords: &["Ophiuchus", "Schlaang", "Schlaangenträger", "Stärzeechen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ງ\u{eb9}"),
            keywords: &["ງ\u{eb9}", "ສ\u{eb1}ດ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("gyvatė"),
            keywords: &["gyvatnešis", "gyvatė", "zodiakas", "žaltys"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("čūska"),
            keywords: &["ziņnesis", "zodiaks", "čūska"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("nākahi"),
            keywords: &["Ophiuchus", "kaihāpai", "nākahi", "poutiriao"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("змија"),
            keywords: &["влекач", "змија"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പ\u{d3e}മ\u{d4d}പ\u{d4d}"),
            keywords: &[
                "ഉരഗം",
                "ന\u{d3e}ഗം",
                "പ\u{d3e}മ\u{d4d}പ\u{d4d}",
                "ര\u{d3e}ശി ചക\u{d4d}രം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("могой"),
            keywords: &["могой", "хэвлээр явагч", "өрнийн зурхай"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("साप"),
            keywords: &["ऑफिय\u{941}कस", "ब\u{947}अरर", "राशी", "साप"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("ular"),
            keywords: &["ophiuchus", "pembawa", "ular", "zodiak"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("serp"),
            keywords: &["Ophiuchus", "portatur", "serp", "serpent", "żodjaku"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("မြ\u{103d}ေ"),
            keywords: &[
                "ဆယ\u{1037}\u{103a}န\u{103e}စ\u{103a}ရာသ\u{102e}ခ\u{103d}င\u{103a}",
                "မြ\u{103d}ေ",
                "မြ\u{103d}ေနဂါး",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("slange"),
            keywords: &[
                "dyr",
                "orm",
                "slange",
                "slangebæreren",
                "stjernebilde",
                "stjernetegn",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("सा\u{901}प"),
            keywords: &["राशि", "सा\u{901}प"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("slang"),
            keywords: &[
                "ophiuchus",
                "serpent",
                "slang",
                "slangendrager",
                "sterrenbeeld",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("slange"),
            keywords: &[
                "dyr",
                "orm",
                "slange",
                "slangeberaren",
                "stjernebilete",
                "stjerneteikn",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସ\u{b3e}ପ"),
            keywords: &[
                "ଓଫ\u{b3f}ଚସ\u{b4d}\u{200c}",
                "ବ\u{b3f}ୟରର\u{b4d}\u{200c}",
                "ର\u{b3e}ଶ\u{b3f}ଚକ\u{b4d}ର",
                "ଶ\u{b3e}ପ",
                "ସର\u{b4d}ପ\u{b3e}ଣ\u{b4d}ଟ",
                "ସ\u{b3e}ପ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸ\u{a71}ਪ"),
            keywords: &["ਜਾਨਵਰ", "ਸ\u{a71}ਪ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("سپ"),
            keywords: &["اژدھا", "ب\u{64f}رج", "بیرا", "سپ", "علم النجوم"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Snek"),
            keywords: &[
                "Pẹ\u{301}sin Wé Bríng Mẹ\u{301}sej",
                "Pẹ\u{301}sin Wé Kárí Sọ\u{301}mtin Kọm",
                "Snek",
                "Sápẹnt",
                "Zódiak",
                "Ọfiúkus: Zódiák Sain Ọf Man Wé Hól Snek",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("wąż"),
            keywords: &["dusiciel", "jadowity", "wąż", "żmija"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("مار"),
            keywords: &["بيرر، اوپيوچس، ښامار، مار، مرغومی", "مار"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("cobra"),
            keywords: &["animal", "cobra", "réptil", "serpente"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["cobra", "ofiúco", "serpente", "serpentário", "signo"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("amaru"),
            keywords: &["Ophiuchus", "amaru", "hapiq", "zodiaco"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("șarpe"),
            keywords: &["ofiucus", "reptilă", "zodiac", "șarpe"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-458"),
            keywords: &["E10-458"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("змея"),
            keywords: &[
                "гадюка",
                "змееносец",
                "змея",
                "знак",
                "зодиак",
                "опасность",
                "яд",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("inzoka"),
            keywords: &["Ofiyukusi", "inzoka", "utwaye", "zodiyake"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("نانگ"),
            keywords: &["حامل، نانگ جهليندڙ، نانگ، برج", "نانگ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("නය\u{dcf}"),
            keywords: &[
                "ඔප\u{dd2}කස\u{dca}",
                "නය\u{dcf}",
                "භ\u{dcf}රකර\u{dd4}",
                "ර\u{dcf}ශ\u{dd2} චක\u{dca}\u{200d}රය",
                "සර\u{dca}පය\u{dcf}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("had"),
            keywords: &["had", "plaz"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("kača"),
            keywords: &["kača", "kačenosec", "prinašalec", "zodiak"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("mas"),
            keywords: &["abeeso", "dhala", "mactab meecaad", "mas", "sangaaba"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("gjarpër"),
            keywords: &["gjarpër", "mbajtës", "ofiuku", "zodiak"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("змија"),
            keywords: &["гуја", "зoдиjaк", "змиja", "змиjoнoша", "змија"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["змија"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("zmija"),
            keywords: &["guja", "zmija", "zmijonoša", "zodijak"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["zmija"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("orm"),
            keywords: &["djur", "orm"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("nyoka"),
            keywords: &["dubu", "joka", "nyoka", "opichasi", "zodiaki"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ப\u{bbe}ம\u{bcd}பு"),
            keywords: &["ந\u{bbe}கம\u{bcd}", "ப\u{bbe}ம\u{bcd}பு", "விலங\u{bcd}கு"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ప\u{c3e}ము"),
            keywords: &["జంతువు", "ప\u{c3e}ము", "సర\u{c4d}పం"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("мор"),
            keywords: &["бурҷи дувоздаҳгона", "доранда", "мор", "Ҳаввоъ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ง\u{e39}"),
            keywords: &["ง\u{e39}", "ส\u{e31}ตว\u{e4c}", "อสรพ\u{e34}ษ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýylan"),
            keywords: &["göteriji", "täleýnama", "Ýylançy", "ýylan"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ngata"),
            keywords: &["ngata"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yılan"),
            keywords: &["hayvan", "yılan"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("يىلان"),
            keywords: &["ئەجدىھا", "تۇرۇش", "مۆچەل", "يىلان"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("змія"),
            keywords: &["гадюка", "змій", "змія", "змієносець", "зодіак"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سانپ"),
            keywords: &["جانور", "سانپ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ilon"),
            keywords: &["burj", "ilon"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("rắn"),
            keywords: &["chòm sao xà phu", "cung hoàng đạo", "rắn", "vật mang"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("jaan"),
            keywords: &["Ophiuchus", "gàddukat", "jaan", "sojak"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("inyoka"),
            keywords: &["i-Ophiuchus", "i-zodiac", "inyoka", "irhamncwa", "umthwali"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ejò"),
            keywords: &["Ejò", "Ophiuchus", "ejò", "olùgbé", "àmi oṣù ìbí"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("蛇"),
            keywords: &["巨蛇", "持有人", "星座", "蛇", "蛇夫座"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("蛇"),
            keywords: &["巨蛇", "持有人", "星座", "蛇", "蛇夫座"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("蛇"),
            keywords: &["持票人", "狡猾的人", "蛇", "蛇夫座", "黄道十二宫"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("蛇"),
            keywords: &["蛇", "青蛇"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["星座", "毒蛇", "蛇", "蛇夫座"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("inyoka"),
            keywords: &["inkanyezi", "inyoka", "isithiyi"],
        },
    ],
};
#[doc = "🐲"]
pub const DRAGON_FACE: crate::Emoji = crate::Emoji {
    glyph: "🐲",
    codepoint: "1F432",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "dragon face",
    group: "Animals & Nature",
    subgroup: "animal-reptile",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("draakgesig"),
            keywords: &["draak", "draakgesig", "fantasie", "gesig"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የድራጎን ፊት"),
            keywords: &["ተረት ተረት", "ዘንዶ", "የድራጎን ፊት", "ፊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وجه تنين"),
            keywords: &["تنين", "حيوان", "وجه"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ড\u{9cd}ৰেগনৰ ম\u{9c1}খ"),
            keywords: &[
                "ড\u{9cd}ৰেগন",
                "ড\u{9cd}ৰেগনৰ ম\u{9c1}খ",
                "পৰীৰ স\u{9be}ধ\u{9c1}",
                "ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("əjdaha üzü"),
            keywords: &["nağıl", "üz", "əjdaha", "əjdaha üzü"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("галава цмока"),
            keywords: &["галава цмока", "дракон", "казачны", "пыска", "цмок"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Глава на дракон"),
            keywords: &["Глава на дракон", "глава", "дракон", "приказка"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ড\u{9cd}র\u{9be}গনের ম\u{9c1}খ"),
            keywords: &[
                "ড\u{9cd}র\u{9be}গন",
                "ড\u{9cd}র\u{9be}গনের ম\u{9c1}খ",
                "ম\u{9c1}খ",
                "র\u{9c2}পকথ\u{9be}",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("penn dragon"),
            keywords: &["dragon", "penn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("glava zmaja"),
            keywords: &["bajka", "glava zmaja", "lice", "zmaj"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara de drac"),
            keywords: &["cara", "cara de drac", "drac"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄓\u{11133}𑄢𑄉\u{11127}𑄚\u{11134} 𑄟\u{11131}"),
            keywords: &["𑄓\u{11133}𑄢𑄉\u{11127}𑄚\u{11134} 𑄟\u{11131}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᎦᏖᎾ ᎤᎧᏛ"),
            keywords: &["ᎠᏓᏪᎯ ᎧᏃᎮᏓ", "ᎤᎦᏖᎾ", "ᎤᎧᏛ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("hlava draka"),
            keywords: &["drak", "hlava draka", "pohádka", "smajlík", "tvář", "výraz"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wyneb draig"),
            keywords: &["draig", "stori dylwyth teg", "wyneb"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("dragehoved"),
            keywords: &["drage", "dragehoved", "hoved"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Drachengesicht"),
            keywords: &["Drache", "Drachengesicht", "Gesicht", "Tier"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πρόσωπο δράκου"),
            keywords: &["δράκος", "παραμύθι", "πρόσωπο", "πρόσωπο δράκου"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("dragon face"),
            keywords: &["dragon", "face", "fairy tale"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara de dragón"),
            keywords: &["cara", "cara de dragón", "cuento", "dragón", "fantasía"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["animal", "cara de dragón", "cuento", "dragón", "fantasía"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["animal", "cara de dragón", "cuento", "dragón", "fantasía"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("draakoni nägu"),
            keywords: &["draakon", "draakoni nägu", "muinasjutt", "nägu"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("herensuge-aurpegia"),
            keywords: &["aurpegia", "herensuge-aurpegia", "herensugea", "ipuina"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("صورت اژدها"),
            keywords: &["افسانه", "اژدها", "جن و پری", "صورت"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("lohikäärmeen naama"),
            keywords: &["lohikäärme", "lohikäärmeen naama", "naama", "satu"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("mukha ng dragon"),
            keywords: &[
                "dragon",
                "fairy tale",
                "fantasy",
                "mukha",
                "mukha ng dragon",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("andlit á dreka"),
            keywords: &["andlit", "andlit á dreka", "dreki", "ævintýr"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("tête de dragon"),
            keywords: &["animal", "dragon", "tête de dragon"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["dragon", "tête", "tête de dragon"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("aghaidh dragain"),
            keywords: &["aghaidh", "aghaidh dragain", "dragan", "finscéal"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodann dràgoin"),
            keywords: &["aodann", "aodann dràgoin", "dràgon", "faoinsgeul"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara de dragón"),
            keywords: &["cara de dragón", "dragón"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("દ\u{ac8}ત\u{acd}યનો ચહ\u{ac7}રો"),
            keywords: &[
                "ચહ\u{ac7}રો",
                "દ\u{ac8}ત\u{acd}ય",
                "દ\u{ac8}ત\u{acd}યનો ચહ\u{ac7}રો",
                "પ\u{acd}રાણી",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("fuskar dabbar daragon"),
            keywords: &[
                "dabbar daragon",
                "fuska",
                "fuskar dabbar daragon",
                "labarin aljana",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פני דרקון"),
            keywords: &["אגדה", "אגדי", "דרקון", "סיני", "פני דרקון"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("द\u{948}त\u{94d}य का च\u{947}हरा"),
            keywords: &[
                "च\u{947}हरा",
                "द\u{948}त\u{94d}य",
                "द\u{948}त\u{94d}य का च\u{947}हरा",
                "पश\u{941}",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("lice zmaja"),
            keywords: &["bajka", "lice", "lice zmaja", "zmaj"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("sárkányfej"),
            keywords: &["fantasy", "fej", "mese", "sárkány", "sárkányfej"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("վիշապի մռութ"),
            keywords: &["դեմք", "հեքիաթ", "մռութ", "վիշապ", "վիշապի մռութ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah naga"),
            keywords: &["dongeng", "muka", "naga", "wajah"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihu dragọn"),
            keywords: &["akọrọakọ", "dragọn", "ihu"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("drekahöfuð"),
            keywords: &["drekahöfuð", "dreki", "höfuð"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("testa di drago"),
            keywords: &["animale", "drago", "faccina", "testa di drago"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ドラゴンの顔"),
            keywords: &["ドラゴン", "ドラゴンの顔", "動物", "竜", "顔", "龍"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai naga"),
            keywords: &["dongeng", "naga", "rai"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("დრაკონის სახე"),
            keywords: &[
                "გველეშაპი",
                "დრაკონი",
                "დრაკონის სახე",
                "ზღაპარი",
                "სახე",
                "ურჩხული",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("айдаһардың беті"),
            keywords: &["айдаһар", "айдаһардың беті", "бет", "ертегі"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("drageansigt"),
            keywords: &["drage", "drageansigt", "hoved"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ក\u{17d2}បាលនាគ"),
            keywords: &["ក\u{17d2}បាលនាគ", "នាគ"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಡ\u{ccd}ರ\u{ccd}ಯಾಗನ\u{ccd} ಮುಖ"),
            keywords: &[
                "ಡ\u{ccd}ರ\u{ccd}ಯಾಗನ\u{ccd}",
                "ಡ\u{ccd}ರ\u{ccd}ಯಾಗನ\u{ccd} ಮುಖ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("용 얼굴"),
            keywords: &["동물", "드래곤", "용", "용 얼굴", "용띠"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ड\u{94d}र\u{945}गोन च\u{947}रो"),
            keywords: &["च\u{947}रो", "ड\u{94d}र\u{945}गोन", "परी कथा"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("ажыдаардын башы"),
            keywords: &["ажыдаар", "ажыдаардын башы", "баш", "жомок"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Draachegesiicht"),
            keywords: &["Draach", "Draachegesiicht", "Gesiicht", "Mäerchen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec9}າມ\u{eb1}ງກອນ"),
            keywords: &["ມ\u{eb1}ງກອນ", "ສ\u{eb1}ດ", "ໜ\u{ec9}າມ\u{eb1}ງກອນ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("drakono snukis"),
            keywords: &["drakonas", "drakono snukis", "pasaka", "veidas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("pūķa galva"),
            keywords: &["galva", "pūķa galva", "pūķis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kanohi tarakona"),
            keywords: &["kanohi", "pakiwaitara", "tarakona"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("глава на змеј"),
            keywords: &["глава", "глава на змеј", "змеј", "лице", "сказна"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഡ\u{d4d}ര\u{d3e}ഗൺ മ\u{d41}ഖം"),
            keywords: &[
                "ഡ\u{d4d}ര\u{d3e}ഗൺ",
                "മ\u{d41}ഖം",
                "മ\u{d41}ത\u{d4d}തശ\u{d4d}ശിക\u{d4d}കഥ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("лууны толгой"),
            keywords: &["луу", "лууны толгой", "царай", "үлгэр"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ड\u{94d}र\u{945}गनचा च\u{947}हरा"),
            keywords: &[
                "च\u{947}हरा",
                "ड\u{94d}र\u{945}गन",
                "ड\u{94d}र\u{945}गनचा च\u{947}हरा",
                "परी कथा",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka naga"),
            keywords: &["cerita dongeng", "muka", "naga"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("wiċċ ta’ dragun"),
            keywords: &["dragun", "wiċċ", "wiċċ ta’ dragun", "ħrafa"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("နဂါးရ\u{102f}ပ\u{103a}"),
            keywords: &[
                "နဂါး",
                "နဂါးရ\u{102f}ပ\u{103a}",
                "နတ\u{103a}သမ\u{102e}းပ\u{102f}\u{1036}ပြင\u{103a}",
                "မျက\u{103a}န\u{103e}ာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("dragefjes"),
            keywords: &["drage", "dragefjes", "dyr", "eventyr", "fjes"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ड\u{94d}रयागनको अन\u{941}हार"),
            keywords: &[
                "अन\u{941}हार",
                "ड\u{94d}रयागन",
                "ड\u{94d}रयागनको अन\u{941}हार",
                "परीको कथा",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("drakengezicht"),
            keywords: &["draak", "drakengezicht", "gezicht", "sprookje"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("drakefjes"),
            keywords: &["drake", "drakefjes", "dyr", "eventyr", "fjes"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଡ\u{b4d}ର\u{b3e}ଗନ\u{b4d}\u{200c} ମ\u{b41}ହ\u{b01}"),
            keywords: &[
                "ଜୀବ",
                "ଡ\u{b4d}ର\u{b3e}ଗନ\u{b4d}\u{200c}",
                "ପରୀ କ\u{b3e}ହ\u{b3e}ଣୀ",
                "ମ\u{b41}ହ\u{b01}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਡਰ\u{a48}ਗਨ ਦਾ ਚਿਹਰਾ"),
            keywords: &["ਚਿਹਰਾ", "ਜਾਨਵਰ", "ਡਰ\u{a48}ਗਨ", "ਡਰ\u{a48}ਗਨ ਦਾ ਚਿਹਰਾ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("اژدھا دی شکل"),
            keywords: &["اژدھا", "اژدھا دی شکل", "دی شکل", "پریاں دی کہانی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Drágọn Fes"),
            keywords: &[
                "Bíg Wíkẹ\u{301}d Anímọl",
                "Bíg Wíkẹ\u{301}d Anímọl Wé Im Nem Na Drágọn",
                "Drágọn",
                "Fes",
                "Torí Abaut Spírit-dẹm Wé Rizẹ\u{301}mbúl Taíní Húmánbin",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("głowa smoka"),
            keywords: &["bajka", "baśń", "głowa smoka", "smok"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ژدهار مخ"),
            keywords: &["ژدهار مخ", "ژدهار، مخ، د ښاپيرو کيسه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto de dragão"),
            keywords: &["animal", "dragão", "rosto", "rosto de dragão"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara de dragão"),
            keywords: &["cara", "cara de dragão", "conto de fadas", "dragão"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("dragon uya"),
            keywords: &["dragon", "hadas willana", "uya"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("față de dragon"),
            keywords: &[
                "balaur",
                "basm",
                "fantastic",
                "față",
                "față de dragon",
                "poveste",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-495"),
            keywords: &["E10-495"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("голова дракона"),
            keywords: &[
                "голова дракона",
                "дракон",
                "морда",
                "сказка",
                "фентези",
                "фэнтези",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("isura ya darago"),
            keywords: &["darago", "isura", "isura ya darago", "umugani mugufi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("بلا مهانڊو"),
            keywords: &["بلا مهانڊو", "بلا، مهانڊو، پرين جي ڪهاڻي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("මකර ම\u{dd4}හ\u{dd4}ණ"),
            keywords: &[
                "මකර ම\u{dd4}හ\u{dd4}ණ",
                "මකර\u{dcf}",
                "ම\u{dd4}හ\u{dd4}ණ",
                "ස\u{dd4}රංගන\u{dcf} කථ\u{dcf}ව",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("hlava draka"),
            keywords: &["drak", "hlava", "hlava draka", "rozprávka", "šarkan"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("zmajski obraz"),
            keywords: &["obraz", "pravljica", "zmaj", "zmajski obraz"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waji masduulaagi"),
            keywords: &["masduulaagi", "sheeko quraafi", "waji"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrë dragoi"),
            keywords: &["dragua", "fytyrë", "fytyrë dragoi", "përrallë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("лице змаја"),
            keywords: &["бajкa", "змaj", "лице", "лице змаја"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["лице змаја"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("lice zmaja"),
            keywords: &["bajka", "lice", "lice zmaja", "zmaj"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["lice zmaja"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("drakansikte"),
            keywords: &["djur", "drakansikte", "drake"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uso wa dragoni"),
            keywords: &["dragoni", "kichimbakazi", "uso", "uso wa dragoni"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("டிர\u{bbe}கன\u{bcd} முகம\u{bcd}"),
            keywords: &[
                "டிர\u{bbe}கன\u{bcd} முகம\u{bcd}",
                "பறக\u{bcd}கும\u{bcd} ந\u{bbe}கம\u{bcd}",
                "மிருகம\u{bcd}",
                "முகம\u{bcd}",
                "விலங\u{bcd}கு முகம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ర\u{c46}క\u{c4d}కలు గల భయంకర సర\u{c4d}ప ముఖం"),
            keywords: &[
                "ముఖం",
                "ర\u{c46}క\u{c4d}కలు",
                "ర\u{c46}క\u{c4d}కలు గల భయంకర సర\u{c4d}ప ముఖం",
                "సర\u{c4d}పం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("афти аждаҳор"),
            keywords: &["аждаҳор", "афсона", "афти аждаҳор", "рӯй"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หน\u{e49}าม\u{e31}งกร"),
            keywords: &["ส\u{e31}ตว\u{e4c}", "หน\u{e49}าม\u{e31}งกร"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("aždarha ýüz"),
            keywords: &["aždarha", "erteki", "ýüz"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mataʻi-talākoni"),
            keywords: &["mataʻi-talākoni"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("ejderha yüzü"),
            keywords: &["ejderha", "ejderha yüzü", "hayvan", "yüz"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئەجدىھا چىراي"),
            keywords: &["ئەجدىھا", "چىراي", "چۆچەك"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("голова дракона"),
            keywords: &["голова", "голова дракона", "дракон", "казка"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ڈریگن کا چہرہ"),
            keywords: &["جانور", "چہرہ", "ڈریگن", "ڈریگن کا چہرہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ajdar qiyofasi"),
            keywords: &[
                "ajdar",
                "ajdar qiyofasi",
                "ajdarho",
                "ertak",
                "qiyofa",
                "yuz",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt rồng"),
            keywords: &["khuôn mặt", "mặt rồng", "rồng", "truyện cổ tích"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kanamu dragoŋ"),
            keywords: &["dragoŋ", "kanam", "kanamu dragoŋ", "léebu fee"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ubuso be-dragon"),
            keywords: &["i-dragon", "intsomi", "ubuso", "ubuso be-dragon"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Oju Dragoni"),
            keywords: &["Drágónì", "Oju Dragoni", "oju", "ìtàn àrõnì"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("龍臉"),
            keywords: &["童話", "臉", "龍", "龍臉"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("龙脸"),
            keywords: &["童话", "脸", "龙", "龙脸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("龙头"),
            keywords: &["龙", "龙头"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("龍頭"),
            keywords: &["龍", "龍頭"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("龍樣"),
            keywords: &["龍", "龍樣"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubuso benyoka"),
            keywords: &["insumansumane", "inyoka", "ubuso", "ubuso benyoka"],
        },
    ],
};
#[doc = "🐉"]
pub const DRAGON: crate::Emoji = crate::Emoji {
    glyph: "🐉",
    codepoint: "1F409",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "dragon",
    group: "Animals & Nature",
    subgroup: "animal-reptile",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("draak"),
            keywords: &["draak", "sprokie"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ድራጎን"),
            keywords: &["ተረት ተረት", "ድራጎን"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("تنين"),
            keywords: &["تنين", "حيوان"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ড\u{9cd}ৰেগন"),
            keywords: &["ড\u{9cd}ৰেগন", "পৰীৰ স\u{9be}ধ\u{9c1}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("əjdaha"),
            keywords: &["nağıl", "əjdaha"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("цмок"),
            keywords: &["дракон", "казачны", "цмок"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("дракон"),
            keywords: &["дракон", "приказка"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ড\u{9cd}র\u{9be}গন"),
            keywords: &["ড\u{9cd}র\u{9be}গন", "র\u{9c2}পকথ\u{9be}"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("dragon"),
            keywords: &["dragon", "loen"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("zmaj"),
            keywords: &["bajka", "zmaj"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("drac"),
            keywords: &["conte", "drac", "fades", "fantasia"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄓\u{11133}𑄢𑄉\u{11127}𑄚\u{11134}"),
            keywords: &["𑄓\u{11133}𑄢𑄉\u{11127}𑄚\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎢᎾᏓ ᏗᎪᏯᏗ"),
            keywords: &["ᎠᏓᏪᎯ", "ᎢᎾᏓ ᏗᎪᏯᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("drak"),
            keywords: &["drak", "pohádka"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("draig"),
            keywords: &["draig", "stori dylwyth teg"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("drage"),
            keywords: &["drage", "eventyr"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Drache"),
            keywords: &["Drache", "Märchen", "Tier"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("δράκος"),
            keywords: &["δράκος", "παραμύθι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("dragon"),
            keywords: &["dragon", "fairy tale"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("dragón"),
            keywords: &["animal", "cuento", "dragón", "fantasía"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["animal", "cuento", "dragón", "fantasía"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("draakon"),
            keywords: &["draakon", "muinasjutt"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("herensugea"),
            keywords: &["herensugea", "ipuin"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("اژدها"),
            keywords: &["افسانه", "اژدها", "جن و پری"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("lohikäärme"),
            keywords: &["lohikäärme", "satu"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("dragon"),
            keywords: &["dragon", "fairy tale", "fantasy"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("dreki"),
            keywords: &["dreki", "ævintýr"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("dragon"),
            keywords: &["animal", "dragon"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["contes", "dragon", "fantastique", "fées", "merveilleux"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("dragan"),
            keywords: &["dragan", "finscéal"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("dràgon"),
            keywords: &["dràgon", "faoinsgeul"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("dragón"),
            keywords: &["dragón"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ડ\u{acd}ર\u{ac7}ગન"),
            keywords: &["ડ\u{acd}ર\u{ac7}ગન", "પ\u{acd}રાણી"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("daragon"),
            keywords: &["daragon", "labarin aljana"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("דרקון"),
            keywords: &["אגדה", "אגדי", "דרקון", "סיני"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("द\u{948}त\u{94d}य"),
            keywords: &["द\u{948}त\u{94d}य", "पश\u{941}"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("zmaj"),
            keywords: &["bajka", "zmaj"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("sárkány"),
            keywords: &["mese", "sárkány"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("վիշապ"),
            keywords: &["հեքիաթ", "վիշապ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("naga"),
            keywords: &["dongeng", "naga"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("dragọn"),
            keywords: &["akọrọakọ", "dragọn"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("dreki"),
            keywords: &["dreki", "ævintýri"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("drago"),
            keywords: &["animale", "drago"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ドラゴン"),
            keywords: &["ドラゴン", "動物", "竜", "龍"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("naga"),
            keywords: &["dongeng", "naga"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("დრაკონი"),
            keywords: &["დრაკონი", "ზღაპარი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("айдаһар"),
            keywords: &["айдаһар", "ертегі"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("drage"),
            keywords: &["drage", "eventyr"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("នាគ"),
            keywords: &["នាគ"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಡ\u{ccd}ರ\u{ccd}ಯಾಗನ\u{ccd}"),
            keywords: &[
                "ಕಾಲ\u{ccd}ಪನ\u{cbf}ಕ ಕಥ\u{cc6}",
                "ಡ\u{ccd}ರ\u{ccd}ಯಾಗನ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("용"),
            keywords: &["동물", "드래곤", "용"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ड\u{94d}र\u{945}गोन"),
            keywords: &["ड\u{94d}र\u{945}गोन", "परीकथा"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("ажыдаар"),
            keywords: &["ажыдаар", "жомок"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Draach"),
            keywords: &["Draach", "Mäerchen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ມ\u{eb1}ງກອນ"),
            keywords: &["ມ\u{eb1}ງກອນ", "ສ\u{eb1}ດ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("drakonas"),
            keywords: &["drakonas", "pasaka"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("pūķis"),
            keywords: &["pasaka", "pūķis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tarakona"),
            keywords: &["pakiwaitara", "tarakona"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("змеј"),
            keywords: &["змеј", "сказна", "фантазија"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഡ\u{d4d}ര\u{d3e}ഗൺ"),
            keywords: &[
                "ഡ\u{d4d}ര\u{d3e}ഗൺ",
                "മ\u{d41}ത\u{d4d}തശ\u{d4d}ശിക\u{d4d}കഥ",
                "മ\u{d43}ഗം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("луу"),
            keywords: &["луу", "шидэт үлгэр"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ड\u{94d}र\u{945}गन"),
            keywords: &["ड\u{94d}र\u{945}गन", "परी कथा"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("naga"),
            keywords: &["cerita dongeng", "naga"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("dragun"),
            keywords: &["dragun", "ħrafa"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("နဂါး"),
            keywords: &["နဂါး", "ပ\u{102f}\u{1036}ပြင\u{103a}"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("drage"),
            keywords: &["drage", "dyr", "eventyr"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ड\u{94d}रयागन"),
            keywords: &["ड\u{94d}रयागन", "परीको कथा"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("draak"),
            keywords: &["draak", "sprookje"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("drake"),
            keywords: &["drake", "dyr", "eventyr"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଡ\u{b4d}ର\u{b3e}ଗନ\u{b4d}\u{200c}"),
            keywords: &[
                "ଡ\u{b4d}ର\u{b3e}ଗନ\u{b4d}\u{200c}",
                "ପରୀ କ\u{b3e}ହ\u{b3e}ଣୀ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਡਰ\u{a48}ਗਨ"),
            keywords: &["ਜਾਨਵਰ", "ਡਰ\u{a48}ਗਨ", "ਡ\u{a4d}ਰ\u{a48}ਗਨ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("اژدھا"),
            keywords: &["اژدھا", "پریاں دی کہانی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Bíg Wíkẹ\u{301}d Anímọl Wé Im Nem Na Drágọn"),
            keywords: &[
                "Bíg Wíkẹ\u{301}d Anímọl",
                "Bíg Wíkẹ\u{301}d Anímọl Wé Im Nem Na Drágọn",
                "Drágọn",
                "Torí Abaut Spírit-dẹm Wé Rizẹ\u{301}mbúl Taíní Húmánbin",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("smok"),
            keywords: &["bajka", "baśń", "smok"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ژدهار"),
            keywords: &["ژدهار", "ژدهار، د ښاپيرو کيسه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("dragão"),
            keywords: &["animal", "dragão"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["conto de fadas", "dragão"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("dragon"),
            keywords: &["dragon", "hadas willana"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("dragon"),
            keywords: &["balaur", "dragon", "poveste"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-454"),
            keywords: &["E10-454"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("дракон"),
            keywords: &["голова", "дракон", "сказка", "фентези", "фэнтези"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("darago"),
            keywords: &["darago", "umugani mugufi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("بلا"),
            keywords: &["بلا", "پرين جي ڪهاڻي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("මකර\u{dcf}"),
            keywords: &["මකර\u{dcf}", "ස\u{dd4}රංංඟන\u{dcf} කථ\u{dcf}ව"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("drak"),
            keywords: &["drak", "rozprávka", "šarkan"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("zmaj"),
            keywords: &["pravljica", "zmaj"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("masduulaagi"),
            keywords: &["masduulaagi", "sheeko quraafi"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("dragua"),
            keywords: &["dragua", "përrallë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("змај"),
            keywords: &["бajкa", "змај"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("zmaj"),
            keywords: &["bajka", "zmaj"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("drake"),
            keywords: &["djur", "drake"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("dragoni"),
            keywords: &["dragoni", "kichimbakazi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("டிர\u{bbe}கன\u{bcd}"),
            keywords: &[
                "டிர\u{bbe}கன\u{bcd}",
                "பறக\u{bcd}கும\u{bcd} ந\u{bbe}கம\u{bcd}",
                "மிருகம\u{bcd}",
                "விலங\u{bcd}கு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ర\u{c46}క\u{c4d}కలు గల భయంకర సర\u{c4d}పం"),
            keywords: &[
                "ర\u{c46}క\u{c4d}కలు",
                "ర\u{c46}క\u{c4d}కలు గల భయంకర సర\u{c4d}పం",
                "సర\u{c4d}పం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("аждаҳор"),
            keywords: &["аждаҳор", "афсона"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ม\u{e31}งกร"),
            keywords: &["ม\u{e31}งกร", "ส\u{e31}ตว\u{e4c}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("aždarha"),
            keywords: &["aždarha", "erteki"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("talākoni"),
            keywords: &["talākoni"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("ejderha"),
            keywords: &["ejderha", "hayvan"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئەجدىھا"),
            keywords: &["ئەجدىھا", "چۆچەك"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("дракон"),
            keywords: &["дракон", "казка"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ڈریگن"),
            keywords: &["جانور", "ڈریگن"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ajdar"),
            keywords: &["ajdar", "ertak"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("rồng"),
            keywords: &["rồng", "truyện cổ tích"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("dragoŋ"),
            keywords: &["dragoŋ", "léebu fee"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-dragon"),
            keywords: &["i-dragon", "intsomi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Drágónì"),
            keywords: &["Drágónì", "ìtàn àrõnì"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("龍"),
            keywords: &["童話", "龍"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("龙"),
            keywords: &["童话", "龙"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("龙"),
            keywords: &["龙"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("龍"),
            keywords: &["龍"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("udrakho"),
            keywords: &["insumansumane", "udrakho"],
        },
    ],
};
#[doc = "🦕"]
pub const SAUROPOD: crate::Emoji = crate::Emoji {
    glyph: "🦕",
    codepoint: "1F995",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "sauropod",
    group: "Animals & Nature",
    subgroup: "animal-reptile",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("souropode"),
            keywords: &[
                "bragiosourus",
                "brontosourus",
                "dinosourus",
                "diplodicus",
                "souropode",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ዳይኖሰር"),
            keywords: &["ዳይኖሰር"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ديناصور صوروبودا"),
            keywords: &["ديناصور صوروبودا"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("চৰ’পড"),
            keywords: &[
                "চৰ’পড",
                "ডিপ\u{9cd}ল’ড’ক\u{9be}চ",
                "ব\u{9cd}ৰণ\u{9cd}ট’চৰ\u{9be}চ",
                "ব\u{9cd}ৰেকিঅ’চৰ\u{9be}চ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("sauropod"),
            keywords: &["braxiozavr", "brontozavr", "diplodok", "sauropod"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("заўрапод"),
            keywords: &["брантазаўр", "брахіязаўр", "дыпладок", "заўрапод"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("завропод"),
            keywords: &["брахиозавър", "бронтозавър", "диплодок", "завропод"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("সরোপড"),
            keywords: &[
                "ডিপ\u{9cd}লোক\u{9be}স",
                "ব\u{9cd}রন\u{9cd}টোসর\u{9be}স",
                "ব\u{9cd}র\u{9be}কিয\u{9bc}োসর\u{9be}স",
                "সরোপড",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("saoropod"),
            keywords: &["dinosaor", "saoropod"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("sauropod"),
            keywords: &["brahiosaurus", "brontosaurus", "diplodok", "sauropod"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("sauròpode"),
            keywords: &["braquiosaure", "brontosaure", "diplodocus", "sauròpode"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏘᏲᎭᎵ ᎤᎳᏏᏕᎾ"),
            keywords: &["ᎢᏅ ᎢᎦᏘ ᏘᏲᎭᎵ", "ᎧᏃᎨᏂ ᏘᏲᎭᎵ", "ᏔᎵ ᎦᏖᏍᎨ", "ᏘᏲᎭᎵ ᎤᎳᏏᏕᎾ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("brontosaurus"),
            keywords: &[
                "brachiosaurus",
                "brontosaurus",
                "dinosaurus",
                "diplodocus",
                "sauropod",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("sawropod"),
            keywords: &["braciosor", "brontosor", "diplodocws", "sawropod"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("sauropod"),
            keywords: &["brachiosaurus", "brontosaurus", "diplodocus", "sauropod"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Sauropode"),
            keywords: &[
                "Brachiosaurus",
                "Brontosaurus",
                "Dino",
                "Dinosaurier",
                "Diplodocus",
                "Saurier",
                "Sauropode",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σαυρόποδο"),
            keywords: &["βραχιόσαυρος", "βροντόσαυρος", "διπλόδοκος", "σαυρόποδο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("sauropod"),
            keywords: &["brachiosaurus", "brontosaurus", "diplodocus", "sauropod"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("saurópodo"),
            keywords: &["braquiosaurio", "brontosaurio", "diplodocus", "saurópodo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("sauropood"),
            keywords: &[
                "brahhiosaurus",
                "brontosaurus",
                "diplodookus",
                "sauropod",
                "sauropood",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("sauropodo"),
            keywords: &["brankiosaurio", "brontosaurio", "diplodoko", "sauropodo"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("سوسمار"),
            keywords: &["برانتوسور", "برکیوسور", "دایناسور دوپا", "سوسمار"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("sauropodi"),
            keywords: &["brontosaurus", "dinosaurus", "sauropodi"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("sauropod"),
            keywords: &["brachiosaurus", "brontosaurus", "diplodocus", "sauropod"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("Brontosaurus"),
            keywords: &["Brontosaurus", "apatosaurus", "dinosaurur", "dýr"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("sauropode"),
            keywords: &[
                "animal",
                "brachiosaure",
                "brontosaure",
                "diplodocus",
                "sauropode",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("sárapód"),
            keywords: &["brachiosaurus", "brontasár", "diplodocus", "sárapód"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("dìneasar"),
            keywords: &[
                "brachiosaurus",
                "brontosaurus",
                "diplodocus",
                "dìneasar",
                "sauropod",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("saurópodo"),
            keywords: &[
                "branquiosauro",
                "brontosauro",
                "dinosauro",
                "diplodoco",
                "saurópodo",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સોરોપોડ"),
            keywords: &["સોરોપોડ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("sauropod"),
            keywords: &["brachiosaurus", "brontosaurus", "diplodocus", "sauropod"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סרופוד"),
            keywords: &["ברונטוזאורוס", "ברכיוזאורוס", "דיפלודוקוס", "סרופוד"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("सोरोपॉड"),
            keywords: &[
                "डायनोसौर",
                "डिप\u{94d}लोडॉकस",
                "ब\u{94d}र\u{948}कियोसॉरस",
                "ब\u{94d}रॉन\u{94d}टोसॉरस",
                "सॉरोपॉड",
                "सोरोपॉड",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("sauropod"),
            keywords: &["brahiosaur", "brontosaur", "diplodok", "sauropod"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("sauropoda"),
            keywords: &["brachiosaurus", "brontosaurus", "diplodocus", "sauropoda"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("զավրոպոդ"),
            keywords: &["բրախիոզավր", "բրոնտոզավր", "դիպլոդոկ", "զավրոպոդ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("sauropod"),
            keywords: &["brachiosaurus", "brontosaurus", "diplodocus", "sauropod"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("sauropod"),
            keywords: &["brachiosaurus", "brontosaurus", "diplodocus", "sauropod"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("graseðla"),
            keywords: &["finngálkn", "graseðla", "þórseðla", "þórseðlubróðir"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("sauropode"),
            keywords: &["brachiosauro", "brontosauro", "diplodoco", "sauropode"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("草食恐竜"),
            keywords: &[
                "ディプロドクス",
                "ブラキオサウルス",
                "恐竜",
                "竜脚類",
                "草食恐竜",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("sauropod"),
            keywords: &["brachiosaurus", "brontosaurus", "diplodocus", "sauropod"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ზაუროპოდი"),
            keywords: &["ბრაქიოზავრი", "ბრონტოზავრი", "დიპლოდოკუსი", "ზაუროპოდი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("зауропод"),
            keywords: &["зауропод"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("sauropod"),
            keywords: &["brachiosaurus", "brontosaurus", "diplodocus", "sauropod"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸ\u{ccc}ರೊಪಾಡ\u{ccd}"),
            keywords: &[
                "ಡ\u{cbf}ಪ\u{ccd}ಲೊಡೋಕಸ\u{ccd}",
                "ಬ\u{ccd}ರಾಂಕ\u{ccd}ಟೊಸರಸ\u{ccd}",
                "ಬ\u{ccd}ರ\u{ccd}ಯಾಚ\u{cbf}ಯೊಸರಸ\u{ccd}",
                "ಸ\u{ccc}ರೊಪಾಡ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("초식 공룡"),
            keywords: &["뇌룡", "초식 공룡"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("सौरोपॉड"),
            keywords: &[
                "डिप\u{94d}लोडॉकस",
                "ब\u{94d}राकीयोसॉरस",
                "ब\u{94d}रोन\u{94d}टोसॉरस",
                "सौरोपॉड",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("заврапод"),
            keywords: &["брахиозавр", "бронтозавр", "диплодок", "заврапод"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Dinosaurier"),
            keywords: &["Brachiosaurus", "Brontosaurus", "Dinosaurier", "Diplodokus"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເຊ\u{ebb}າໂຣພອດ"),
            keywords: &[
                "ດ\u{eb4}ໂພລໂດຄ\u{eb1}ສ",
                "ບຣອນໂທຊ\u{ecd}ຣ\u{eb1}ສ",
                "ບຣາຊ\u{eb4}ໂອຊ\u{ecd}ຣ\u{eb1}ສ",
                "ເຊ\u{ebb}າໂຣພອດ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("sauropodas"),
            keywords: &["brachiozauras", "brontozauas", "diplodokas", "sauropodas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("zauropods"),
            keywords: &["brahiozaurs", "brontozaurs", "diplodoks", "zauropods"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("sauropod"),
            keywords: &["brachiosaurus", "brontosaurus", "diplodocus", "sauropod"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("сауропод"),
            keywords: &["брахиосаурус", "бронтосаурус", "диплодокус", "сауропод"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("സോറോപോഡ\u{d4d}"),
            keywords: &[
                "ദിനോസർ",
                "ബ\u{d4d}രോണ\u{d4d}ടോസോറസ\u{d4d}",
                "സോറോപോഡ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("сауропод"),
            keywords: &["брачиосаурус", "бронтосарус", "диплодокус", "сауропод"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("सॉरोपॉड"),
            keywords: &[
                "डिप\u{94d}लोडोकस",
                "ब\u{94d}रा\u{901}टोसॉरस",
                "ब\u{94d}राचिओसॉरस",
                "सॉरोपॉड",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("sauropod"),
            keywords: &["brakiosaurus", "brontosaurus", "diplodokus", "sauropod"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("sawropodu"),
            keywords: &["brakkjosawru", "brontosawru", "diplodoku", "sawropodu"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဆော\u{103a}ရ\u{102d}\u{102f}ပေါ\u{1037}ဒ\u{103a}"),
            keywords: &[
                "ဆော\u{103a}ရ\u{102d}\u{102f}ပေါ\u{1037}ဒ\u{103a}",
                "ဒ\u{102d}\u{102f}င\u{103a}ပလ\u{102d}\u{102f}ဒ\u{102d}\u{102f}းကပ\u{103a}စ\u{103a}",
                "ဘရာခ\u{102e}ယ\u{102d}\u{102f}ဆောရက\u{103a}စ\u{103a}",
                "ဘရ\u{103d}န\u{103a}တ\u{102d}\u{102f}ဆောရက\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("sauropod"),
            keywords: &[
                "brachiosaurus",
                "brontosaurus",
                "dinosaur",
                "diplodocus",
                "sauropod",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("सौ\u{902}रोपड"),
            keywords: &[
                "डिप\u{94d}लोडोकस",
                "ब\u{94d}राचियोसरस",
                "ब\u{94d}रोन\u{94d}टोसरस",
                "सौ\u{902}रोपड",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("sauropode"),
            keywords: &["brachiosaurus", "brontosaurus", "diplodocus", "sauropode"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("sauropod"),
            keywords: &[
                "brachiosaurus",
                "brontosaurus",
                "dinosaur",
                "diplodocus",
                "sauropod",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସୌରୋପଡ\u{b4d}"),
            keywords: &[
                "ଡ\u{b3f}ପ\u{b4d}ଲୋଡୋକସ\u{b4d}\u{200d}",
                "ବ\u{b4d}ର\u{b3e}ଚ\u{b3f}ସ\u{b3e}ରସ\u{b4d}\u{200d}",
                "ବ\u{b4d}ରୋଣ\u{b4d}ଟୋସ\u{b3e}ରସ\u{b4d}\u{200d}",
                "ସୌରୋପଡ\u{b4d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸ\u{a4c}ਰ\u{a4b}ਪ\u{a4b}ਡ"),
            keywords: &[
                "ਡਿਪਲ\u{a4b}ਡ\u{a4b}ਕਸ",
                "ਬਰ\u{a47}ਕਿਓਸ\u{a4c}ਰਸ",
                "ਬ\u{a4d}ਰ\u{a4b}\u{a02}ਟ\u{a4b}ਸ\u{a4c}ਰਸ",
                "ਸ\u{a4c}ਰ\u{a4b}ਪ\u{a4b}ਡ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("سارپا"),
            keywords: &[
                "برکیوسور",
                "سارپا",
                "عظیم الجثہ ڈینو سار",
                "لمی کوڑا جئی د\u{64f}م اتے بھاریاں لت\u{651}اں آلا",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Sórópọd"),
            keywords: &[
                "Sórópọd",
                "Óldín Taím Bíg Anímọl Wé Im Nem Na Brakiosọ\u{301}rọs",
                "Óldín Taím Bíg Anímọl Wé Im Nem Na Brọ\u{301}ntosọ\u{301}rọs",
                "Óldín Taím Bíg Anímọl Wé Im Nem Na Diplọ\u{301}díkọs",
                "Óldín Taím Bíg Anímọl Wé Im Nem Na Sọ\u{301}rópọd",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("zauropod"),
            keywords: &["zauropod"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سوروپډ"),
            keywords: &["سوروپډ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("saurópode"),
            keywords: &["braquiossauro", "brontossuro", "diplódoco", "saurópode"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("sauropodo"),
            keywords: &["braquiosauro", "brontosauro", "diplodocus", "sauropodo"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("sauropod"),
            keywords: &["brahiozaur", "brontozaur", "diplodocus", "sauropod"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1117"),
            keywords: &["E10-1117"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("зауропод"),
            keywords: &[
                "брахиозавр",
                "бронтозавр",
                "динозавр",
                "диплодок",
                "зауропод",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("Dinozoro yo mu bwoko bwa Sauropod"),
            keywords: &[
                "Dinozoro yo mu bwoko bwa Brachiosaurus",
                "Dinozoro yo mu bwoko bwa Brontosaurusi",
                "Dinozoro yo mu bwoko bwa Diplodocus",
                "Dinozoro yo mu bwoko bwa Sauropod",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("سارپا"),
            keywords: &["سارپا", "ڊائنوسار"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ස\u{dcf}ර\u{dd6}පෝඩ\u{dca}"),
            keywords: &[
                "ඩ\u{dd2}ප\u{dca}ලෝඩොකස\u{dca}",
                "බ\u{dca}රෝන\u{dca}ටෝසොරස\u{dca}",
                "බ\u{dca}\u{200d}රච\u{dd2}යෝසොසරස\u{dca}",
                "ස\u{dcf}ර\u{dd6}පෝඩ\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("sauropód"),
            keywords: &[
                "brachiosaurus",
                "brontosaurus",
                "dinosaurus",
                "diplodocus",
                "sauropód",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("zavropod"),
            keywords: &["brahiozaver", "brontozaver", "diplodok", "zavropod"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("sauropod-ka"),
            keywords: &["dhaynasoorkii danbe", "sauropod-ka"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("sauropod"),
            keywords: &["brakiozaur", "dinozaur me 4 këmbë", "sauropod"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("сауропод"),
            keywords: &["брахиосаур", "бронтосаур", "диплодокус", "сауропод"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("sauropod"),
            keywords: &["brahiosaur", "brontosaur", "diplodokus", "sauropod"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("sauropod"),
            keywords: &["brachiosaurus", "brontosaurus", "diplodocus", "sauropod"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("sauropodi"),
            keywords: &[
                "brachiosaurusi",
                "brontosaurusi",
                "diplodocusi",
                "sauropodi",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சரோப\u{bbe}ட\u{bcd}"),
            keywords: &["சரோப\u{bbe}ட\u{bcd}", "டைனோசர\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("స\u{c3e}రప\u{c3e}డ\u{c4d}"),
            keywords: &[
                "డ\u{c3f}ప\u{c4d}ల\u{c4b}డ\u{c4b}కస\u{c4d}",
                "బ\u{c4d}ర\u{c3e}ంచ\u{c40}య\u{c4b}స\u{c3e}రస\u{c4d}",
                "బ\u{c4d}ర\u{c4b}ంట\u{c4b}స\u{c3e}రస\u{c4d}",
                "స\u{c3e}రప\u{c3e}డ\u{c4d}",
                "స\u{c4c}ర\u{c4b}ప\u{c4b}డ\u{c3e}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("динозаври завропод"),
            keywords: &["брахиозавр", "бронтозавр", "динозаври завропод", "диплодок"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ไดโนเสาร\u{e4c}"),
            keywords: &[
                "ซอโรพอด",
                "บรอนโตซอร\u{e31}ส",
                "ไดพลอโดค\u{e31}ส",
                "ไดโนเสาร\u{e4c}",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("zauropod"),
            keywords: &["brahiozawr", "brontozawr", "diplodokus", "zauropod"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("saulopoti"),
            keywords: &["saulopoti"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("soropod"),
            keywords: &[
                "brachiosaurus",
                "brontosaurus",
                "brontozor",
                "diplodocus",
                "soropod",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("كەسلەنچۈك پۇتلۇقلار"),
            keywords: &[
                "برونتوزاۋر",
                "بىرونتوزاۋر",
                "دىپلودوكۇس",
                "كەسلەنچۈك پۇتلۇقلار",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("завропод"),
            keywords: &[
                "апатозавр",
                "брахіозавр",
                "бронтозавр",
                "диплодок",
                "завропод",
                "зауропод",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سارپا"),
            keywords: &["جسیم سبزی خور ڈائنوساروں کا ایک طبقہ", "سارپا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("zauropod"),
            keywords: &["braxiozavr", "brontozavr", "diplodok", "zauropod"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("khủng long chân thằn lằn"),
            keywords: &[
                "khủng long chân thằn lằn",
                "khủng long to ăn cây cối",
                "thằn lằn hai óc",
                "uyển long",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("soropod"),
            keywords: &["brachiosorus", "brontosorus", "diplodocus", "soropod"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-sauropod"),
            keywords: &[
                "i-brachiosaurus",
                "i-brontosaurus",
                "i-diplodocus",
                "i-sauropod",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("sauropod"),
            keywords: &["brachiosaurus", "brontosaurus", "diplodocus", "sauropod"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("蜥腳類動物"),
            keywords: &["粱龍", "腕龍", "蜥腳類動物", "雷龍"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("蜥脚类动物"),
            keywords: &["粱龙", "腕龙", "蜥脚类动物", "雷龙"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("蜥蜴类"),
            keywords: &["梁龙", "腕龙", "蜥蜴类", "雷龙"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("蜥腳類恐龍"),
            keywords: &["蜥腳類恐龍"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("恐龍"),
            keywords: &["恐龍", "腕龍", "蜥腳類恐龍"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("i-sauropod"),
            keywords: &["brachiosaurus", "brontosaurus", "diplodocus", "i-sauropod"],
        },
    ],
};
#[doc = "🦖"]
pub const T_REX: crate::Emoji = crate::Emoji {
    glyph: "🦖",
    codepoint: "1F996",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "T-Rex",
    group: "Animals & Nature",
    subgroup: "animal-reptile",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("T-Rex"),
            keywords: &["T-Rex", "Tirannosourus Rex"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ታይኖሳረስ ዳይኖሰር"),
            keywords: &["ታይኖሳረስ", "ታይኖሳረስ ዳይኖሰር"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("التيرانوصور"),
            keywords: &["التيرانوصور"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("টি-ৰেক\u{9cd}স"),
            keywords: &[
                "টি-ৰেক\u{9cd}স",
                "ট\u{9cd}ৰ\u{9be}ইৰেনচৰ\u{9be}চ ৰেক\u{9cd}স",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("Tireks"),
            keywords: &["Tirannozavr Reks", "Tireks"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("тыраназаўр"),
            keywords: &["тыраназаўр", "тыраназаўр рэкс", "тырэкс"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("тиранозавър"),
            keywords: &["тиранозавър", "тиранозавър рекс"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("টি-রেক\u{9cd}স"),
            keywords: &["টি-রেক\u{9cd}স", "টির\u{9be}নোসর\u{9be}স রেক\u{9cd}স"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("tiranosaor roue"),
            keywords: &["dinosaor", "tiranosaor roue"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("T-Rex"),
            keywords: &["T-Rex", "Tiranosaurus Reks"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("tiranosaure"),
            keywords: &["Tyrannosaurus Rex", "tiranosaure"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("Ꭴ-ᎤᎬᏫᏳᎯ"),
            keywords: &["Ꭴ-ᎤᎬᏫᏳᎯ", "ᎤᎵᏍᎦᏂ ᏘᏲᎭᎵ ᎤᎬᏫᏳᎯ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("tyranosaurus rex"),
            keywords: &["dinosaurus", "t-rex", "tyranosaurus rex"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("T-Rex"),
            keywords: &["T-Rex", "Tyranosor Rex"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("T-Rex"),
            keywords: &["T-Rex", "Tyrannosaurus Rex"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("T-Rex"),
            keywords: &[
                "Dino",
                "Dinosaurier",
                "Saurier",
                "T-Rex",
                "Tyrannosaurus Rex",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("τυραννόσαυρος"),
            keywords: &["τυραννόσαυρος"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("T-Rex"),
            keywords: &["T-Rex", "Tyrannosaurus Rex"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["T-Rex", "T. Rex", "T. rex", "Tyrannosaurus Rex"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("t-rex"),
            keywords: &["t-rex", "tiranosaurio", "tiranosaurio rex"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("türannosaurus"),
            keywords: &["türannosaurus"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("T-Rex"),
            keywords: &["T-Rex", "tiranosaurio rex"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("تی\u{200c}رکس"),
            keywords: &["تیرانوسوروس", "تی\u{200c}رکس", "مارمولک ستمگر"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("tyrannosaurus rex"),
            keywords: &["dinosaurus", "hirmulisko", "tyrannosaurus rex"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("T-Rex"),
            keywords: &["T-Rex", "Tyrannosaurus Rex"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("T-rex"),
            keywords: &["T-rex", "Tyrannosaurus rex", "dinosaurur", "dýr"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("T-Rex"),
            keywords: &["T-Rex", "Tyrannosaurus Rex", "tyrannosaure"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("T. rex"),
            keywords: &["T. rex", "Tyrannosaurus Rex"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("T-Rex"),
            keywords: &["T-Rex", "tyrannosaurus rex"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("t-rex"),
            keywords: &["T-Rex", "Tyrannosaurus Rex", "t-rex"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("Tyrannosaurus rex"),
            keywords: &["Tyrannosaurus rex", "dinosauro"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ટી-ર\u{ac7}ક\u{acd}સ"),
            keywords: &["ટી-ર\u{ac7}ક\u{acd}સ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("T-Rex"),
            keywords: &["T-Rex", "Tyrannosaurus Rex"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("טי-רקס"),
            keywords: &["טי-רקס", "טירנוזאורוס-רקס"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("टी-र\u{947}क\u{94d}स"),
            keywords: &["टी-र\u{947}क\u{94d}स"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("tiranosaur"),
            keywords: &["t-rex", "tiranosaur"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("T. rex"),
            keywords: &["T. rex", "Tyrannosaurus rex"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("տիրանոզավր ռեքս"),
            keywords: &["տիրանոզավր ռեքս"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("T-Rex"),
            keywords: &["T-Rex", "Tyrannosaurus Rex"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("Ụdị ngwere egbeigwe"),
            keywords: &["Ngwere egbeigwe", "Ụdị ngwere egbeigwe"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("Grameðla"),
            keywords: &["Grameðla"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("T-Rex"),
            keywords: &["T-Rex", "Tirannosauro Rex"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ティラノサウルス"),
            keywords: &["ティラノサウルス", "恐竜"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("T-Rex"),
            keywords: &["T-Rex", "Tyrannosaurus Rex"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ტი-რექსი"),
            keywords: &["ტი-რექსი", "ტირანოზავრი რექსი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("Ти-рекс"),
            keywords: &["Ти-рекс", "Тираннозавр рекс"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("T-Rex"),
            keywords: &["T-Rex", "Tyrannosaurus Rex"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಟ\u{cbf}-ರ\u{cc6}ಕ\u{ccd}ಸ\u{ccd}"),
            keywords: &[
                "ಟ\u{cbf}-ರ\u{cc6}ಕ\u{ccd}ಸ\u{ccd}",
                "ಟೈರ\u{ccd}ನೊಸರಸ\u{ccd} ರ\u{cc6}ಕ\u{ccd}ಸ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("티라노사우루스"),
            keywords: &["티라노사우루스", "티렉스"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("टी-र\u{945}क\u{94d}स"),
            keywords: &[
                "टायर\u{945}नोसॉरस र\u{945}क\u{94d}स",
                "टी-र\u{945}क\u{94d}स",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("тираннозавр рекс"),
            keywords: &["Ти-рекс", "тираннозавр рекс"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("T-Rex"),
            keywords: &["T-Rex", "Tyrannosaurus Rex"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("\u{eb7}ທ\u{eb5}ເຣ\u{eb1}ກ"),
            keywords: &[
                "\u{eb7}ທ\u{eb5}ເຣ\u{eb1}ກ",
                "ໄທແຣນໂນຊ\u{ecd}ຣ\u{eb1}ສ ເຣ\u{eb1}ກ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("Reksas"),
            keywords: &["Reksas", "tiranozauras Reksas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("tiranozaurs"),
            keywords: &["tiranozaurs", "tiranozaurs rekss"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("T-Rex"),
            keywords: &["T-Rex", "Tyrannosaurus Rex"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("Т-рекс"),
            keywords: &["Т-рекс", "Тираносаурус рекс"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ടി-റെക\u{d4d}\u{200c}സ\u{d4d}"),
            keywords: &[
                "ടി-റെക\u{d4d}\u{200c}സ\u{d4d}",
                "റ\u{d4d}റിറ\u{d3e}നോസോറസ\u{d4d} റെക\u{d4d}\u{200c}സ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("Т-рекс"),
            keywords: &["Т-рекс", "Тиранозавр рекс"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("टी-र\u{945}क\u{94d}स"),
            keywords: &[
                "टी-र\u{945}क\u{94d}स",
                "ट\u{945}र\u{945}नोसॉरस र\u{945}क\u{94d}स",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("T-Rex"),
            keywords: &["T-Rex", "Tyrannosaurus Rex"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("T-Rex"),
            keywords: &["T-Rex", "Tirannosawru Rex"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("တ\u{102e} ရက\u{103a}စ\u{103a}"),
            keywords: &[
                "တ\u{102d}\u{102f}င\u{103a}ရန\u{103a}န\u{102d}\u{102f}ဆောရက\u{103a}စ\u{103a} ရက\u{103a}စ\u{103a}",
                "တ\u{102e} ရက\u{103a}စ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("T-Rex"),
            keywords: &["T-Rex", "Tyrannosaurus Rex", "dinosaur"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("टि-र\u{947}क\u{94d}स"),
            keywords: &["टाइरानोसरस र\u{947}क\u{94d}स", "टि-र\u{947}क\u{94d}स"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("T-Rex"),
            keywords: &["T-Rex", "Tyrannosaurus Rex"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("T-Rex"),
            keywords: &["T-Rex", "Tyrannosaurus Rex", "dinosaur"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଟ\u{b3f}-ରେକ\u{b4d}ସ"),
            keywords: &[
                "ଟ\u{b3e}ଇର\u{b3e}ନୋସ\u{b3e}ରସ\u{b4d}\u{200d} ରେକ\u{b4d}ସ",
                "ଟ\u{b3f}-ରେକ\u{b4d}ସ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਟੀ-ਰ\u{a48}ਕਸ"),
            keywords: &["ਟਾਈਰ\u{a48}ਨ\u{a4b}ਸ\u{a4b}ਰਸ ਰ\u{a48}ਕਸ", "ਟੀ-ਰ\u{a48}ਕਸ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ٹی-ریکس"),
            keywords: &["ٹی-ریکس", "گوشت خور ڈائنو سار"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("T-Rẹks"),
            keywords: &[
                "T-Rẹks",
                "Óldín Taím Bíg Anímọl Wé Im Nem Na Tiránọsọ\u{301}rus",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("t-rex"),
            keywords: &["t-rex"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ټي-ریکس"),
            keywords: &["ټایرانوساروس-ریکس", "ټي-ریکس"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("tiranossauro rex"),
            keywords: &["T-Rex", "tiranossauro rex"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("T-Rex"),
            keywords: &["T-Rex", "Tiranosaurio Rex"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("T-Rex"),
            keywords: &["T-Rex", "Tyrannosaurus Rex"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1118"),
            keywords: &["E10-1118"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("Ти-Рекс"),
            keywords: &["Ти-Рекс", "динозавр", "рекс", "тираннозавр"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("Dinozoro yo mu bwoko bwa T-Rex"),
            keywords: &[
                "Dinozoro yo mu bwoko bwa T-Rex",
                "Dinozoro yo mu bwoko bwa Tyrannosaurus Rex",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڊائنوسار"),
            keywords: &["ڊائنوسار"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ට\u{dd3}-රෙක\u{dca}ස\u{dca}"),
            keywords: &[
                "ට\u{dd2}ර\u{dcf}න\u{dcf}ශ\u{dca}රෝරස\u{dca} රෙක\u{dca}ස\u{dca} ටය\u{dd2}ර\u{dcf}න\u{dca}නොසෝරස\u{dca}",
                "ට\u{dd3}-රෙක\u{dca}ස\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("tyrannosaurus"),
            keywords: &["dinosaurus", "rex", "tyrannosaurus"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("tiranozaver"),
            keywords: &["tiranozaver"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waa wax la aqoon"),
            keywords: &["lama yaqaano", "waa wax la aqoon"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("tiranozaur-reks"),
            keywords: &["dinozaur me 2 këmbë", "tiranozaur-reks"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("тираносаурус рекс"),
            keywords: &["тираносаурус рекс"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("tiranosaurus reks"),
            keywords: &["tiranosaurus reks"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("T-rex"),
            keywords: &["T-rex", "Tyrannosaurus Rex"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("T-Rex"),
            keywords: &["T-Rex", "Tyrannosaria Rex"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("டி-ரெக\u{bcd}ஸ\u{bcd}"),
            keywords: &["டி-ரெக\u{bcd}ஸ\u{bcd}", "டைனோசர\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ట\u{c3f}-ర\u{c46}క\u{c4d}స\u{c4d}"),
            keywords: &[
                "ట\u{c3f}-ర\u{c46}క\u{c4d}స\u{c4d}",
                "ట\u{c48}ర\u{c3e}న\u{c4b}స\u{c3e}రస\u{c4d} ర\u{c46}క\u{c4d}స\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("Т-Рекс"),
            keywords: &["Т-Рекс", "Тираннозавр Рекс"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ท\u{e35}เร\u{e47}กซ\u{e4c}"),
            keywords: &[
                "ท\u{e35}เร\u{e47}กซ\u{e4c}",
                "ไทแรนโนซอร\u{e31}ส เร\u{e47}กซ\u{e4c}",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("Tiranozawr Reks"),
            keywords: &["Tiranozawr Reks"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tainosauli nifo māsila"),
            keywords: &["tainosauli nifo māsila"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("T-Rex"),
            keywords: &["T-Rex", "Tyrannosaurus Rex"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ت-رېكس"),
            keywords: &["ت-رېكس", "تىراننوزاۋر رېكس"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("тиранозавр"),
            keywords: &["Тиранозавр Рекс", "тиранозавр", "тиранозавр королівський"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ٹی ریکس"),
            keywords: &["ٹائرانوسرس ریکس", "ٹی ریکس"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("T-Reks"),
            keywords: &["T-Reks", "reks", "tirannozavr"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("khủng long bạo chúa"),
            keywords: &["Khủng long bạo chúa", "khủng long bạo chúa"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("T-Rex"),
            keywords: &["T-Rex", "Tyrannosorus Rex"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("I-T-Rex"),
            keywords: &["I-T-Rex", "I-Tyrannosaurus Rex"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("T-Rex"),
            keywords: &["T-Rex", "Tyrannosaurus Rex"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("暴龍"),
            keywords: &["暴龍"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("暴龙"),
            keywords: &["暴龙"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("霸王龙"),
            keywords: &["暴龙君主", "霸王龙"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("暴龍"),
            keywords: &["暴龍"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["恐龍", "暴龍", "霸王龍"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("i-T-Rex"),
            keywords: &["i-T-Rex", "i-Tyrannosaurus Rex"],
        },
    ],
};
