#[doc = "🐳"]
pub const SPOUTING_WHALE: crate::Emoji = crate::Emoji {
    glyph: "🐳",
    codepoint: "1F433",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "spouting whale",
    group: "Animals & Nature",
    subgroup: "animal-marine",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("walvis wat spuit"),
            keywords: &["gesig", "spuit", "walvis", "walvis wat spuit"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ውሃ የሚያንቦጫርቅ ዓሣ ነባሪ"),
            keywords: &["ውሃ የሚያንቦጫርቅ", "ውሃ የሚያንቦጫርቅ ዓሣ ነባሪ", "ዓሣ ነባሪ", "ፊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("حوت بنافورة"),
            keywords: &["حوت", "حوت بنافورة", "حيوان", "نافورة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ফো\u{981}ৱ\u{9be}ৰ\u{9be} মৰ\u{9be} তিমি ম\u{9be}ছ"),
            keywords: &[
                "তিমি ম\u{9be}ছ",
                "ফো\u{981}ৱ\u{9be}ৰ\u{9be} মৰ\u{9be}",
                "ফো\u{981}ৱ\u{9be}ৰ\u{9be} মৰ\u{9be} তিমি ম\u{9be}ছ",
                "ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("su püskürdən balina"),
            keywords: &["balina", "püskürtmək", "su püskürdən balina", "üz"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("фантануючы кіт"),
            keywords: &["кіт", "пыска", "фантан", "фантанаванне", "фантануючы кіт"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Пръскащ кит"),
            keywords: &["Пръскащ кит", "кит", "пръскащ"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("উৎস\u{9be}রিত তিমি"),
            keywords: &[
                "উৎস\u{9be}রিত তিমি",
                "জল ছোড\u{9bc}\u{9be}",
                "তিমি",
                "ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("kit koji izdiše"),
            keywords: &["izdiše", "kit", "kit koji izdiše"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("balena que treu aigua"),
            keywords: &["aigua", "balena", "balena que treu aigua"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎧᏬᎵᏕᏍᎬ ᏓᏆ"),
            keywords: &["ᎤᎧᏛ", "ᎧᏬᎵᏕᏍᎬ", "ᏓᏆ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("velryba stříkající vodu"),
            keywords: &[
                "odfukující",
                "smajlík",
                "stříkající",
                "tvář",
                "velryba",
                "velryba stříkající vodu",
                "vodotrysk",
                "výraz",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("morfil yn chwythu dŵr"),
            keywords: &["dŵr", "morfil", "morfil yn chwythu dŵr", "wyneb"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("hval med vandsprøjt"),
            keywords: &["dyr", "hval", "hval med vandsprøjt"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("blasender Wal"),
            keywords: &["Tier", "Wal", "blasender Wal"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("φάλαινα που πετά νερό"),
            keywords: &["πετάω νερό", "πρόσωπο", "φάλαινα", "φάλαινα που πετά νερό"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("spouting whale"),
            keywords: &["face", "spouting", "whale"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("ballena soltando un chorro"),
            keywords: &[
                "animal",
                "ballena",
                "ballena soltando un chorro",
                "chorro de agua",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("ballena soplando un chorro de agua"),
            keywords: &[
                "animal",
                "ballena",
                "ballena soplando un chorro de agua",
                "chorro",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("vett pritsiv vaal"),
            keywords: &["nägu", "vaal", "vesi", "vett pritsiv vaal"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ura jaurtitzen ari den balea"),
            keywords: &[
                "aurpegia",
                "balea",
                "ura jaurti",
                "ura jaurtitzen ari den balea",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("نهنگ در حال آب\u{200c}فشانی"),
            keywords: &[
                "آب\u{200c}فشانی",
                "صورت",
                "نهنگ",
                "نهنگ در حال آب\u{200c}فشانی",
                "وال",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("suihkuttava valas"),
            keywords: &["naama", "suihkuttaa", "suihkuttava valas", "valas"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("balyenang bumubuga ng tubig"),
            keywords: &["balyena", "balyenang bumubuga ng tubig", "hayop", "isda"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("hvalur sum sprænur"),
            keywords: &[
                "dýr",
                "goysa",
                "hvalur",
                "hvalur sum sprænur",
                "spræna",
                "vatn",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("baleine soufflant par son évent"),
            keywords: &["animal", "baleine", "baleine soufflant par son évent"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("baleine qui expulse de l’eau"),
            keywords: &[
                "baleine",
                "baleine qui expulse de l’eau",
                "expulse de l’eau",
                "souffle",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("míol mór ag séideadh"),
            keywords: &["aghaidh", "míol mór", "míol mór ag séideadh", "séideadh"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("muc-mhara a’ sèideadh"),
            keywords: &["aodann", "muc-mhara", "muc-mhara a’ sèideadh", "sèideadh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("balea botando un chorro"),
            keywords: &["balea", "balea botando un chorro", "chorro"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પાણી ઉછાળતી વ\u{acd}હ\u{ac7}લ"),
            keywords: &[
                "પાણી ઉછાળતી વ\u{acd}હ\u{ac7}લ",
                "પાણી ઉછાળવ\u{ac1}\u{a82}",
                "પ\u{acd}રાણી",
                "વ\u{acd}હ\u{ac7}લ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("dabbar whale mai fitowar da ruwa"),
            keywords: &[
                "dabbar whale",
                "dabbar whale mai fitowar da ruwa",
                "fuska",
                "mai fitowar da ruwa",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לווייתן מתיז סילון מים"),
            keywords: &["לווייתן", "מים", "מתיז", "סילון"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("फ\u{941}हार छोड\u{93c}ती ह\u{94d}व\u{947}ल"),
            keywords: &[
                "पश\u{941}",
                "फ\u{941}हार छोड\u{93c}ती ह\u{94d}व\u{947}ल",
                "फ\u{941}हार छोड\u{93c}ना",
                "ह\u{94d}व\u{947}ल",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("kit koji izbacuje mlaz vode"),
            keywords: &["kit", "kit koji izbacuje mlaz vode", "lice", "mlaz"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("fröcskölő bálna"),
            keywords: &["bálna", "fej", "fröcskölés", "fröcskölő bálna"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ջուր ցայտեցնող կետաձուկ"),
            keywords: &["դեմք", "կետաձուկ", "ջուր ցայտեցնող կետաձուկ", "ցայտում"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("ikan paus menyembur"),
            keywords: &["ikan paus menyembur", "muka", "paus", "sembur", "wajah"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nnukwu azụ whelụ na-agbọpụ mmiri"),
            keywords: &[
                "ihu",
                "na-agbọpụ mmiri",
                "nnukwu azụ whelụ",
                "nnukwu azụ whelụ na-agbọpụ mmiri",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("blásandi hvalur"),
            keywords: &["blásandi hvalur", "hvalur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("balena che spruzza acqua"),
            keywords: &["animale", "balena", "balena che spruzza acqua", "spruzzare"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("潮吹きクジラ"),
            keywords: &["クジラ", "動物", "潮吹き", "潮吹きクジラ"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("paus nyembur"),
            keywords: &["nyembur", "paus", "rai"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ვეშაპი ჭავლით"),
            keywords: &["ვეშაპი", "ვეშაპი ჭავლით", "სახე", "ჭავლი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("су бүркіп тұрған кит"),
            keywords: &["бет", "кит", "су бүрку", "су бүркіп тұрған кит"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("hval med vandsprøjt"),
            keywords: &["dyr", "hval", "hval med vandsprøjt"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ត\u{17d2}រ\u{17b8}បាឡែនបាញ\u{17cb}ទ\u{17b9}ក"),
            keywords: &[
                "ត\u{17d2}រ\u{17b8}បាឡែនបាញ\u{17cb}ទ\u{17b9}ក",
                "បាញ\u{17cb}ទ\u{17b9}ក",
                "បាឡែន",
                "ម\u{17bb}ខ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ನೀರು ಚ\u{cbf}ಮ\u{ccd}ಮುತ\u{ccd}ತ\u{cbf}ರುವ ತ\u{cbf}ಮ\u{cbf}ಂಗ\u{cbf}ಲ"),
            keywords: &[
                "ತ\u{cbf}ಮ\u{cbf}ಂಗ\u{cbf}ಲ",
                "ನೀರು ಚ\u{cbf}ಮ\u{ccd}ಮುತ\u{ccd}ತ\u{cbf}ರುವ ತ\u{cbf}ಮ\u{cbf}ಂಗ\u{cbf}ಲ",
                "ಸ\u{ccd}ಪ\u{ccc}ಟ\u{cbf}ಂಗ\u{ccd} ತ\u{cbf}ಮ\u{cbf}ಂಗ\u{cbf}ಲ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("물 뿜는 고래"),
            keywords: &["동물", "물 뿜는 고래"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("उदकाचो फवारो सोडपी द\u{947}वमासो"),
            keywords: &[
                "उदकाचो फवारो सोडपी",
                "उदकाचो फवारो सोडपी द\u{947}वमासो",
                "च\u{947}रो",
                "द\u{947}वमासो",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("суу чачып жаткан кит"),
            keywords: &["бет", "кит", "суу чачуу", "суу чачып жаткан кит"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("sprëtzende Wal"),
            keywords: &["Gesiicht", "Wal", "sprëtzend", "sprëtzende Wal"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ປາວານພ\u{ebb}\u{ec8}ນນ\u{ecd}\u{ec9}າ"),
            keywords: &[
                "ປາວານ",
                "ປາວານພ\u{ebb}\u{ec8}ນນ\u{ecd}\u{ec9}າ",
                "ສ\u{eb1}ດ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("purškiantis banginis"),
            keywords: &["banginis", "purkšti", "purškiantis banginis", "veidas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("valis šļāc ūdeni"),
            keywords: &["valis", "valis šļāc ūdeni", "ūdens"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tohorā pupuhi"),
            keywords: &["kanohi", "pupuhi", "tohorā"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("кит што прска вода"),
            keywords: &["вода", "кит", "кит што прска вода", "прска", "цицач"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വെള\u{d4d}ളം ചീറ\u{d4d}റ\u{d41}ന\u{d4d}ന തിമിംഗലം"),
            keywords: &[
                "തിമിംഗലം",
                "മ\u{d41}ഖം",
                "വെള\u{d4d}ളം ചീറ\u{d4d}റ\u{d41}ക",
                "വെള\u{d4d}ളം ചീറ\u{d4d}റ\u{d41}ന\u{d4d}ന തിമിംഗലം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("ус оргилуулж байгаа халим"),
            keywords: &[
                "далай",
                "оргилуулах",
                "ус",
                "ус оргилуулж байгаа халим",
                "халим",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("पाण\u{94d}याचा फवारा उडविणारा व\u{94d}ह\u{947}ल"),
            keywords: &[
                "च\u{947}हरा",
                "पाण\u{94d}याचा फवारा उडविणारा व\u{94d}ह\u{947}ल",
                "पाण\u{94d}याचा फवारा उडविण\u{947}",
                "व\u{94d}ह\u{947}ल",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("ikan paus memancutkan air"),
            keywords: &["ikan paus", "ikan paus memancutkan air", "muka", "pancutan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("baliena tfawwar l-ilma"),
            keywords: &["baliena", "baliena tfawwar l-ilma", "tfawwar", "wiċċ"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ရေမ\u{103e}\u{102f}တ\u{103a}ထ\u{102f}တ\u{103a}နေသည\u{1037}\u{103a} ဝေလငါး"),
            keywords: &[
                "မျက\u{103a}န\u{103e}ာ",
                "ရေပန\u{103a}း",
                "ရေမ\u{103e}\u{102f}တ\u{103a}ထ\u{102f}တ\u{103a}နေသည\u{1037}\u{103a} ဝေလငါး",
                "ဝေလငါး",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("sprutende hval"),
            keywords: &["dyr", "hval", "sprutende hval", "spruter"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{94d}पाउटिङ\u{94d} ह\u{94d}व\u{947}ल"),
            keywords: &["अन\u{941}हार", "स\u{94d}पाउटिङ\u{94d}", "ह\u{94d}व\u{947}ल"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("spuitende walvis"),
            keywords: &["gezicht", "spuitend", "spuitende walvis", "walvis"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("sprutande kval"),
            keywords: &["dyr", "kval", "sprutande kval", "sprutar"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ଜଳ ବ\u{b3f}ଚ\u{b4d}ଛ\u{b41}ର\u{b3f}ତ କର\u{b41}ଥ\u{b3f}ବ\u{b3e} ତ\u{b3f}ମ\u{b3f}",
            ),
            keywords: &[
                "ଜଳ ବ\u{b3f}ଚ\u{b4d}ଛ\u{b41}ର\u{b3f}ତ କର\u{b41}ଥ\u{b3f}ବ\u{b3e} ତ\u{b3f}ମ\u{b3f}",
                "ତ\u{b3f}ମ\u{b3f} ମ\u{b3e}ଛ",
                "ମ\u{b41}ହ\u{b01}",
                "ସ\u{b4d}ପ\u{b3e}ଉଟ\u{b3f}ଂ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸਪਾਊਟਿ\u{a70}ਗ ਵ\u{a47}ਲ\u{a4d}ਹ"),
            keywords: &[
                "ਜਾਨਵਰ",
                "ਵ\u{a47}ਲ\u{a4d}ਹ",
                "ਸਪਾਉਟਿ\u{a70}ਗ",
                "ਸਪਾਊਟਿ\u{a70}ਗ ਵ\u{a47}ਲ\u{a4d}ਹ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("پانی وچ ا\u{64f}چھلدی وہیل"),
            keywords: &["دی شکل", "وہیل", "پانی وچ ا\u{64f}چھلدی وہیل", "پرنالہ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Weil Wé De Bló Wọtá"),
            keywords: &[
                "Bló Wọtá",
                "Fes",
                "Pọ\u{301}mp Wọta",
                "Weil",
                "Weil Wé De Bló Wọtá",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("wieloryb tryskający wodą"),
            keywords: &[
                "fontanna",
                "strumień wody",
                "wieloryb",
                "wieloryb tryskający wodą",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ګرداوی ويل"),
            keywords: &["مخ، ګرداوی، ويل", "ګرداوی ويل"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("baleia esguichando água"),
            keywords: &["animal", "baleia", "baleia esguichando água", "esguicho"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("baleia com esguicho de água"),
            keywords: &["baleia", "baleia com esguicho de água", "cara", "esguichar"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("ballena yakuta chʼamqachkan"),
            keywords: &[
                "ballena",
                "ballena yakuta chʼamqachkan",
                "chʼamqachkan",
                "uya",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("balenă împroșcând apă"),
            keywords: &["apă", "balenă", "balenă împroșcând apă", "jet"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-496"),
            keywords: &["E10-496"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("кит с фонтанчиком"),
            keywords: &["брызги", "вода", "кит", "кит с фонтанчиком"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("balene ihumeka"),
            keywords: &["balene ihumeka", "isura", "kujojoba", "urufi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("اسپائوٽنگ وهيل"),
            keywords: &["اسپائوٽنگ وهيل", "مهانڊو، اسپائوٽنگ، وهيل"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ද\u{dd2}ය ව\u{dd2}ද\u{dd2}න තල\u{dca}මස\u{dcf}"),
            keywords: &[
                "තල\u{dca}මස\u{dcf}",
                "ද\u{dd2}ය ව\u{dd2}ද\u{dd2}න තල\u{dca}මස\u{dcf}",
                "ම\u{dd4}හ\u{dd4}ණ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("veľryba s\u{a0}gejzírom"),
            keywords: &["gejzír", "veľryba", "veľryba s\u{a0}gejzírom"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("kit, ki brizga vodo"),
            keywords: &["brizganje", "kit", "kit, ki brizga vodo", "obraz"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("nibiriga mataga"),
            keywords: &["mataggaya", "nibiri", "nibiriga mataga", "waji"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("balenë që hedh ujë"),
            keywords: &["balenë", "balenë që hedh ujë", "fytyrë", "hedh ujë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("кит који прска"),
            keywords: &["кит", "кит који прска", "млaз"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["кит који прска"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("kit koji prska"),
            keywords: &["kit", "kit koji prska", "mlaz"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["kit koji prska"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("val som sprutar vatten"),
            keywords: &["djur", "val", "val som sprutar vatten", "vatten"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("nyangumi anayerusha maji"),
            keywords: &["kurusha", "nyangumi", "nyangumi anayerusha maji", "uso"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some(
                "தண\u{bcd}ண\u{bc0}ரைப\u{bcd} ப\u{bc0}ய\u{bcd}ச\u{bcd}சி அடிக\u{bcd}கும\u{bcd} திமிங\u{bcd}கலம\u{bcd}",
            ),
            keywords: &[
                "தண\u{bcd}ண\u{bc0}ரைப\u{bcd} ப\u{bc0}ய\u{bcd}ச\u{bcd}சி அடிக\u{bcd}கும\u{bcd} திமிங\u{bcd}கலம\u{bcd}",
                "திமிங\u{bcd}கலம\u{bcd}",
                "விலங\u{bcd}கினம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("న\u{c40}ళ\u{c4d}లు ఎగజ\u{c3f}మ\u{c4d}మ\u{c47} త\u{c3f}మ\u{c3f}ంగలం"),
            keywords: &[
                "న\u{c40}ళ\u{c4d}లు",
                "న\u{c40}ళ\u{c4d}లు ఎగజ\u{c3f}మ\u{c4d}మ\u{c47} త\u{c3f}మ\u{c3f}ంగలం",
                "ముఖం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("наҳанги фаввора зада истода"),
            keywords: &[
                "наҳанг",
                "наҳанги фаввора зада истода",
                "рӯй",
                "фаввора зада истода",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ปลาวาฬพ\u{e48}นน\u{e49}ำ"),
            keywords: &["ปลาวาฬ", "ปลาวาฬพ\u{e48}นน\u{e49}ำ", "ส\u{e31}ตว\u{e4c}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("suw pürkýän kit"),
            keywords: &["kit", "suw pürkmek", "suw pürkýän kit", "ýüz"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tofuaʻa puhi"),
            keywords: &["tofuaʻa puhi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("su püskürten balina"),
            keywords: &["balina", "hayvan", "su püskürten", "su püskürten balina"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("پۇشقۇرۇۋاتقان كىت"),
            keywords: &["كىت", "پۇشقۇرۇش", "پۇشقۇرۇۋاتقان كىت", "چىراي"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("кит, що пускає фонтан"),
            keywords: &["кит", "кит, що пускає фонтан", "фонтан"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("پانی کا فوارہ نکالتی وہیل"),
            keywords: &["جانور", "وہیل", "پانی کا فوارہ نکالتی وہیل"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("favvora hosil qilayotgan kit"),
            keywords: &["favvora hosil qilayotgan kit", "kit", "sachratish", "yuz"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("cá voi đang phun nước"),
            keywords: &["cá voi", "cá voi đang phun nước", "mặt", "phun nước"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("baleen bu puucatu"),
            keywords: &["baleen", "baleen bu puucatu", "kanam", "sàll wu ñaw"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umnenge otsazisa amanzi"),
            keywords: &[
                "tsazisa amanzi",
                "ubuso",
                "umnenge",
                "umnenge otsazisa amanzi",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ẹja Nla Atutọ"),
            keywords: &["Oju", "yọ jade tì ipá", "Ẹja Nla", "Ẹja Nla Atutọ"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("噴緊水嘅鯨魚"),
            keywords: &["嘖水", "噴緊水嘅鯨魚", "臉", "鯨魚"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("喷紧水嘅鲸鱼"),
            keywords: &["啧水", "喷紧水嘅鲸鱼", "脸", "鲸鱼"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("喷水的鲸"),
            keywords: &["喷水", "喷水的鲸", "鲸"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("鯨魚"),
            keywords: &["鯨魚", "鯨魚噴水"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umkhomo ekhipha amanzi"),
            keywords: &[
                "ubuso",
                "ukukhipha amanzi",
                "umkhomo",
                "umkhomo ekhipha amanzi",
            ],
        },
    ],
};
#[doc = "🐋"]
pub const WHALE: crate::Emoji = crate::Emoji {
    glyph: "🐋",
    codepoint: "1F40B",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "whale",
    group: "Animals & Nature",
    subgroup: "animal-marine",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("walvis"),
            keywords: &["Jona", "walvis"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("አሣ ነባሪ"),
            keywords: &["አሣ ነባሪ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("حوت"),
            keywords: &["حوت", "حيوان"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("তিমি ম\u{9be}ছ"),
            keywords: &["তিমি", "তিমি ম\u{9be}ছ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kit"),
            keywords: &["balina", "kit"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("кіт"),
            keywords: &["кіт"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("кит"),
            keywords: &["кит", "морски бозайник"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("তিমি"),
            keywords: &["তিমি"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("balum"),
            keywords: &["balum", "loen"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("kit"),
            keywords: &["kit"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("balena"),
            keywords: &["balena"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄖\u{11128}𑄟\u{11128} 𑄟𑄌\u{11134}"),
            keywords: &["𑄖\u{11128}𑄟\u{11128} 𑄟𑄌\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏓᏆ"),
            keywords: &["ᏓᏆ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("velryba"),
            keywords: &["kytovec", "plejtvák", "velryba"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("morfil"),
            keywords: &["morfil"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("hval"),
            keywords: &["dyr", "hval"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Wal"),
            keywords: &["Tier", "Wal"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("φάλαινα"),
            keywords: &["φάλαινα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("whale"),
            keywords: &["whale"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("ballena"),
            keywords: &["ballena", "cachalote", "cetáceo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["animal", "ballena"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["ballena", "cetáceo"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("vaal"),
            keywords: &["vaal"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("balea"),
            keywords: &["bale", "balea"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("نهنگ"),
            keywords: &["نهنگ", "وال"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("valas"),
            keywords: &["valas"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("balyena"),
            keywords: &["balyena", "hayop", "isda", "willy"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("hvalur"),
            keywords: &["dýr", "hvalur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("baleine"),
            keywords: &["animal", "baleine"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["baleine"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("míol mór"),
            keywords: &["míol mór"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("muc-mhara"),
            keywords: &["muc-mhara"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("balea"),
            keywords: &["balea"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("વ\u{acd}હ\u{ac7}લ"),
            keywords: &["પ\u{acd}રાણી", "વ\u{acd}હ\u{ac7}લ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("dabbar whale"),
            keywords: &["dabbar whale"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לוויתן"),
            keywords: &["לוויתן"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ह\u{94d}व\u{947}ल"),
            keywords: &["पश\u{941}", "ह\u{94d}व\u{947}ल"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("kit"),
            keywords: &["kit"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("bálna"),
            keywords: &["bálna"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կետ"),
            keywords: &["կետ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("ikan paus"),
            keywords: &["ikan", "paus"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nnukwu azụ whelụ"),
            keywords: &["nnukwu azụ whelụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hvalur"),
            keywords: &["hvalur", "keikó"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("balena"),
            keywords: &["animale", "balena"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("クジラ"),
            keywords: &["クジラ", "動物"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("paus"),
            keywords: &["paus"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ვეშაპი"),
            keywords: &["ვეშაპი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("кит"),
            keywords: &["кит"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("hval"),
            keywords: &["dyr", "hval"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ត\u{17d2}រ\u{17b8}បាឡែន"),
            keywords: &["ត\u{17d2}រ\u{17b8}", "ត\u{17d2}រ\u{17b8}បាឡែន", "បាឡែន"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ತ\u{cbf}ಮ\u{cbf}ಂಗ\u{cbf}ಲ"),
            keywords: &["ತ\u{cbf}ಮ\u{cbf}ಂಗ\u{cbf}ಲ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("고래"),
            keywords: &["고래", "동물"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("द\u{947}वमासो"),
            keywords: &["द\u{947}वमासो"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кит"),
            keywords: &["кит"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Wal"),
            keywords: &["Wal"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ປາວານ"),
            keywords: &["ປາວານ", "ສ\u{eb1}ດ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("banginis"),
            keywords: &["banginis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("valis"),
            keywords: &["valis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tohorā"),
            keywords: &["tohorā"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("кит"),
            keywords: &["кит", "цицач"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("തിമിംഗലം"),
            keywords: &["തിമിംഗലം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("халим"),
            keywords: &["халим"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("व\u{94d}ह\u{947}ल"),
            keywords: &["व\u{94d}ह\u{947}ल"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("ikan paus"),
            keywords: &["ikan paus"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("baliena"),
            keywords: &["baliena"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဝလေငါး"),
            keywords: &["ဝလေငါး"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("hval"),
            keywords: &["dyr", "hval"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ह\u{94d}व\u{947}ल"),
            keywords: &["ह\u{94d}व\u{947}ल"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("walvis"),
            keywords: &["walvis"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kval"),
            keywords: &["dyr", "kval"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ତ\u{b3f}ମ\u{b3f}"),
            keywords: &["ତ\u{b3f}ମ\u{b3f}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਵ\u{a47}ਲ\u{a4d}ਹ"),
            keywords: &["ਵ\u{a47}ਲ\u{a4d}ਹ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("وہیل"),
            keywords: &["وہیل"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Weil"),
            keywords: &["Weil"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("wieloryb"),
            keywords: &["wieloryb"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ويل"),
            keywords: &["ويل"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("baleia"),
            keywords: &["animal", "baleia"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["baleia"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("ballena"),
            keywords: &["ballena"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("balenă"),
            keywords: &["balenă", "mamifer acvatic", "uriaș"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-456"),
            keywords: &["E10-456"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("кит"),
            keywords: &["кит", "океан"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("barene"),
            keywords: &["barene"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("وهيل"),
            keywords: &["وهيل"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("තල\u{dca}මහ\u{dcf}"),
            keywords: &["තල\u{dca}මහ\u{dcf}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("veľryba"),
            keywords: &["veľryba"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("kit"),
            keywords: &["kit"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("nibiri"),
            keywords: &["nibiri"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("balenë"),
            keywords: &["balenë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("кит"),
            keywords: &["кит"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("kit"),
            keywords: &["kit"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("val"),
            keywords: &["djur", "val"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("nyangumi"),
            keywords: &["nyangumi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("திமிங\u{bcd}கலம\u{bcd}"),
            keywords: &[
                "திமிங\u{bcd}கலம\u{bcd}",
                "ந\u{bc0}ர\u{bcd}வ\u{bbe}ழ\u{bcd} உயிரி",
                "ப\u{bbe}லூட\u{bcd}டி",
                "விலங\u{bcd}கு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("త\u{c3f}మ\u{c3f}ంగలం"),
            keywords: &["జంతువు", "త\u{c3f}మ\u{c3f}ంగలం", "త\u{c3f}మ\u{c3f}ంగళం"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("наҳанг"),
            keywords: &["наҳанг"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ปลาวาฬ"),
            keywords: &["ปลาวาฬ", "ส\u{e31}ตว\u{e4c}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("kit"),
            keywords: &["kit"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tofuaʻa"),
            keywords: &["tofuaʻa"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("balina"),
            keywords: &["balina", "hayvan"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("كىت"),
            keywords: &["كىت"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("кит"),
            keywords: &["кит"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("وہیل"),
            keywords: &["جانور", "وہیل"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kit"),
            keywords: &["kit"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("cá voi"),
            keywords: &["cá voi"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("baleen"),
            keywords: &["baleen"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umnenge"),
            keywords: &["umnenge"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ẹja Nla"),
            keywords: &["Ẹja Nla"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("鯨魚"),
            keywords: &["鯨魚"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("鲸鱼"),
            keywords: &["鲸鱼"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("鲸鱼"),
            keywords: &["鲸鱼"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("藍鯨"),
            keywords: &["藍鯨", "鯨"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("座頭鯨"),
            keywords: &["座頭鯨", "鯨魚"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umkhomo"),
            keywords: &["umkhomo"],
        },
    ],
};
#[doc = "🐬"]
pub const DOLPHIN: crate::Emoji = crate::Emoji {
    glyph: "🐬",
    codepoint: "1F42C",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "dolphin",
    group: "Animals & Nature",
    subgroup: "animal-marine",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("dolfyn"),
            keywords: &["dolfyn", "vin"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ዶልፊን"),
            keywords: &["ዶልፊን", "ፍሊፐር"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("دولفين"),
            keywords: &["حيوان", "دولفين"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ডলফিন"),
            keywords: &["ডলফিন", "ফ\u{9cd}লিপ\u{9be}ৰ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("delfin"),
            keywords: &["delfin", "üzgəc"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("дэльфін"),
            keywords: &["акіян", "дэльфін", "плаўнік"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("делфин"),
            keywords: &["делфин", "морски бозайник"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ডলফিন"),
            keywords: &[
                "ডলফিন",
                "স\u{9be}ম\u{9c1}দ\u{9cd}রিক প\u{9cd}র\u{9be}ণীর স\u{9be}\u{981}ত\u{9be}র",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("delfin"),
            keywords: &["delfin", "loen"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("delfin"),
            keywords: &["delfin"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("dofí"),
            keywords: &["aleta", "dofí"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄓\u{11127}𑄣\u{11134}𑄜\u{11128}𑄚\u{11134}"),
            keywords: &["𑄓\u{11127}𑄣\u{11134}𑄜\u{11128}𑄚\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᎵᏆᏕᎩ"),
            keywords: &["ᎧᎷᏆᏕᎩ", "ᏗᎵᏆᏕᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("delfín"),
            keywords: &["delfín", "delfínek", "skákající"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("dolffin"),
            keywords: &["dolffin", "flipper"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("delfin"),
            keywords: &["delfin", "dyr"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Delfin"),
            keywords: &["Delfin", "Tier"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("δελφίνι"),
            keywords: &["δελφίνι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("dolphin"),
            keywords: &["dolphin", "flipper"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["dolphin", "porpoise"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("delfín"),
            keywords: &["cetáceo", "delfín"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["animal", "delfín"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("delfiin"),
            keywords: &["delfiin", "loib"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("izurdea"),
            keywords: &["flipper", "izurdea"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دلفین"),
            keywords: &["دلفین"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("delfiini"),
            keywords: &["delfiini", "flipper"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("dolphin"),
            keywords: &["dolphin", "flipper", "hayop", "isda"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("delfin"),
            keywords: &["delfin", "dýr"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("dauphin"),
            keywords: &["animal", "dauphin"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["dauphin", "flipper"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("deilf"),
            keywords: &["deilf", "lapa"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("leumadair-mara"),
            keywords: &["leumadair", "leumadair-mara"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("golfiño"),
            keywords: &["delfín", "golfiño"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ડોલ\u{acd}ફિન"),
            keywords: &["ડોલ\u{acd}ફિન", "પ\u{acd}રાણી"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kifin dolphin"),
            keywords: &["kifin dolphin", "reshe mara yatsa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("דולפין"),
            keywords: &["דולפין", "פליפר", "קופץ"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("डॉल\u{94d}फ\u{93c}िन"),
            keywords: &["डॉल\u{94d}फ\u{93c}िन", "पश\u{941}"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("dupin"),
            keywords: &["Flipper", "delfin", "dupin"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("delfin"),
            keywords: &["delfin"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("դելֆին"),
            keywords: &["դելֆին"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("lumba-lumba"),
            keywords: &["lumba-lumba"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nnukwu azụ dọlphịnụ"),
            keywords: &["nnukwu azụ dọlphịnụ", "ntụli elu"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("höfrungur"),
            keywords: &["höfrungur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("delfino"),
            keywords: &["animale", "delfino"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("イルカ"),
            keywords: &["イルカ", "動物"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("lumba-lumba"),
            keywords: &["fliper", "lumba-lumba"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("დელფინი"),
            keywords: &["დელფინი", "ფარფლი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("дельфин"),
            keywords: &["дельфин", "жүзбеқанат"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("delfin"),
            keywords: &["delfin", "dyr"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ត\u{17d2}រ\u{17b8}ដ\u{17bc}ហ\u{17d2}វ\u{17b8}ន"),
            keywords: &[
                "ដ\u{17bc}ហ\u{17d2}វ\u{17b8}ន",
                "ត\u{17d2}រ\u{17b8}",
                "ត\u{17d2}រ\u{17b8}ដ\u{17bc}ហ\u{17d2}វ\u{17b8}ន",
                "ផ\u{17d2}សោត",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಡಾಲ\u{ccd}ಫ\u{cbf}ನ\u{ccd}"),
            keywords: &[
                "ಡಾಲ\u{ccd}ಫ\u{cbf}ನ\u{ccd}",
                "ಫ\u{ccd}ಲ\u{cbf}ಪ\u{ccd}ಪರ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("돌고래"),
            keywords: &["돌고래", "동물"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("डोल\u{94d}फीन"),
            keywords: &["डोल\u{94d}फीन", "फ\u{94d}लिपर"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("дельфин"),
            keywords: &["дельфин", "ласт"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Delfin"),
            keywords: &["Delfin", "Flipper"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ປາຂ\u{ec8}າ"),
            keywords: &["ປາຂ\u{ec8}າ", "ສ\u{eb1}ດ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("delfinas"),
            keywords: &["delfinas", "fliperis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("delfīns"),
            keywords: &["delfīns", "peldpleznas"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("aihe"),
            keywords: &["aihe", "pakihau"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("делфин"),
            keywords: &["делфин", "цицач"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഡോൾഫിൻ"),
            keywords: &["ഡോൾഫിൻ", "ഫ\u{d4d}ലിപ\u{d4d}പർ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("далайн гахай"),
            keywords: &["далайн гахай", "сэлүүр"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("डॉल\u{94d}फिन"),
            keywords: &["डॉल\u{94d}फिन", "फ\u{94d}लिपर"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("ikan lumba-lumba"),
            keywords: &["ikan lumba-lumba", "sirip"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("denfil"),
            keywords: &["denfil", "ġewnaħ"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လင\u{103a}းပ\u{102d}\u{102f}င\u{103a}"),
            keywords: &["လင\u{103a}းပ\u{102d}\u{102f}င\u{103a}"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("delfin"),
            keywords: &["delfin", "dyr"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("डल\u{94d}फिन"),
            keywords: &["डल\u{94d}फिन", "फ\u{94d}लिप\u{94d}पर"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("dolfijn"),
            keywords: &["dolfijn", "flipper"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("delfin"),
            keywords: &["delfin", "dyr"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଡଲଫ\u{b3f}ନ\u{b4d}\u{200c}"),
            keywords: &[
                "ଡଲଫ\u{b3f}ନ\u{b4d}\u{200c}",
                "ଫ\u{b4d}ଲ\u{b3f}ପର\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਡਾਲਫਿਨ"),
            keywords: &["ਜਾਨਵਰ", "ਡਾਲਫਿਨ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ڈولفن"),
            keywords: &["مچھی دا چوڑا پ\u{64e}ر", "ڈولفن"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Dọ\u{301}lfin"),
            keywords: &[
                "Dọ\u{301}lfin",
                "Flípa: Rọ\u{301}bá Tin Wé Pẹ\u{301}sin De Wiá Fọ Lẹg Tọ Hẹ\u{301}lẹ\u{301}p Am Swím Fást Fast",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("delfin"),
            keywords: &["delfin"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("دولفين"),
            keywords: &["دولفين", "دولفين، فليپر"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("golfinho"),
            keywords: &["animal", "golfinho"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["golfinho"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("delfin"),
            keywords: &["delfin", "rikracha"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("delfin"),
            keywords: &["delfin", "inteligent", "mamifer acvatic"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-489"),
            keywords: &["E10-489"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("дельфин"),
            keywords: &["вода", "дельфин", "море", "океан"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("igifi kinini"),
            keywords: &["igifi kinini", "inkweto bogana"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڊالفن"),
            keywords: &["پر", "ڊالفن"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ඩොල\u{dca}ෆ\u{dd2}න\u{dca}"),
            keywords: &["අවල\u{dca} පත", "ඩොල\u{dca}ෆ\u{dd2}න\u{dca}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("delfín"),
            keywords: &["delfín", "plutva"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("delfin"),
            keywords: &["delfin", "fliper"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("hoon-baro"),
            keywords: &["hoon-baro", "sayn dabaal"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("delfin"),
            keywords: &["delfin", "pendë notimi"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("делфин"),
            keywords: &["делфин", "пераје"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("delfin"),
            keywords: &["delfin", "peraje"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("delfin"),
            keywords: &["delfin", "djur"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("pomboo"),
            keywords: &["kikono", "pomboo"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ட\u{bbe}ல\u{bcd}பின\u{bcd}"),
            keywords: &[
                "ட\u{bbe}ல\u{bcd}பின\u{bcd}",
                "ப\u{bbe}லூட\u{bcd}டி",
                "விலங\u{bcd}கினம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("డ\u{c3e}ల\u{c4d}ఫ\u{c3f}న\u{c4d}"),
            keywords: &["జంతువు", "డ\u{c3e}ల\u{c4d}ఫ\u{c3f}న\u{c4d}"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("делфин"),
            keywords: &["делфин", "қаноти моҳӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ปลาโลมา"),
            keywords: &["ปลาโลมา", "ส\u{e31}ตว\u{e4c}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("delfin"),
            keywords: &["delfin", "ýüzgüç"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("pungopunga"),
            keywords: &["pungopunga"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yunus"),
            keywords: &["hayvan", "yunus"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("دېلفىن"),
            keywords: &["دېلفىن", "پالاقچە"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("дельфін"),
            keywords: &["дельфін", "плавець"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ڈولفن"),
            keywords: &["جانور", "ڈولفن"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("delfin"),
            keywords: &["delfin", "suzgich"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("cá heo"),
            keywords: &["chân chèo", "cá heo"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("dófeŋ"),
            keywords: &["dófeŋ", "flipër"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ihlengesi"),
            keywords: &["i-flipper", "ihlengesi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Dọfini"),
            keywords: &["Dọfini", "Ohun lúwë"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("海豚"),
            keywords: &["海豚", "鰭"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("海豚"),
            keywords: &["海豚", "鳍"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("海豚"),
            keywords: &["海豚", "鸭脚板"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("海豚"),
            keywords: &["海豚"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ihlengethwa"),
            keywords: &["ihlengethwa", "okuphendukayo"],
        },
    ],
};
#[doc = "🦭"]
pub const SEAL: crate::Emoji = crate::Emoji {
    glyph: "🦭",
    codepoint: "1F9AD",
    status: crate::Status::FullyQualified,
    introduction_version: 13f32,
    name: "seal",
    group: "Animals & Nature",
    subgroup: "animal-marine",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("rob"),
            keywords: &["rob", "seeleeu"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ምልክት"),
            keywords: &["ምልክት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("فقمة"),
            keywords: &["أسد البحر", "عجل البحر", "فقمة", "كلب البحر"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("চীল"),
            keywords: &["চি ল\u{9be}য\u{9bc}ন", "চীল"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("suiti"),
            keywords: &["dəniş şiri", "suiti"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("цюлень"),
            keywords: &["марскі леў", "цюлень"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("тюлен"),
            keywords: &["морски лъв", "тюлен"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("সিল"),
            keywords: &["সি ল\u{9be}য\u{9bc}ন", "সিল"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("reunig"),
            keywords: &["morleon", "reunig"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("foka"),
            keywords: &["foka", "morski lav"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("foca"),
            keywords: &["foca", "lleó marí"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᏏᏫᏍᎩ"),
            keywords: &["ᏗᏏᏛᏂ", "ᏗᏏᏫᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("tuleň"),
            keywords: &["lachtan", "lvoun", "tuleň"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("morlo"),
            keywords: &["morlew", "morlo"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("sæl"),
            keywords: &["sæl", "søløve"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Seehund"),
            keywords: &["Seehund", "Seelöwe"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: None,
            keywords: &["Seehund"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("φώκια"),
            keywords: &["θαλάσσιος λέοντας", "φώκια"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("seal"),
            keywords: &["sea Lion", "seal"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["sea lion", "seal"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["sea lion", "seal"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("foca"),
            keywords: &["foca", "león marino"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["foca", "león marino", "lobo marino"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("foca"),
            keywords: &["foca"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("foca"),
            keywords: &["foca"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("hüljes"),
            keywords: &["hüljes", "merilõvi"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("itsas txakur"),
            keywords: &["foka", "itsas txakur", "itsas txakurra"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ف\u{64f}ک"),
            keywords: &["شیر دریایی", "ف\u{64f}ک"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("hylje"),
            keywords: &["hylje", "merileijona"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("seal"),
            keywords: &["sea Lion", "seal"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("kópur"),
            keywords: &["kópur", "sjóljón"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("phoque"),
            keywords: &["lion de mer", "otarie", "phoque"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("phoque"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("rón"),
            keywords: &["rón"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("ròn"),
            keywords: &["leòmhann-mara", "ròn"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("foca"),
            keywords: &["foca", "león mariño"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સીલ"),
            keywords: &["સીલ", "સીલ માછલી"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("כלב ים"),
            keywords: &["אריה ים", "כלב ים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("सील"),
            keywords: &["सी लायन", "सील"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("tuljan"),
            keywords: &["morski lav", "tuljan"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("fóka"),
            keywords: &["fóka", "oroszlánfóka"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ծովափիղ"),
            keywords: &["ծովացուլ", "ծովափիղ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("anjing laut"),
            keywords: &["Singa laut", "anjing laut"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("selur"),
            keywords: &["selur", "sæljón"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("foca"),
            keywords: &["foca", "leone marino", "otaria"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("アザラシ"),
            keywords: &["アザラシ", "アシカ", "トド", "動物", "海獣"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("seal"),
            keywords: &["seal", "singo laut"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სელაპი"),
            keywords: &["ზღვის ლომი", "სელაპი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("итбалық"),
            keywords: &["итбалық", "теңіз арыстаны"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ឆ\u{17d2}មាទ\u{17b9}ក"),
            keywords: &["ឆ\u{17d2}មាទ\u{17b9}ក", "តោសម\u{17bb}ទ\u{17d2}រ"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸೀಲ\u{ccd}"),
            keywords: &["ಸಮುದ\u{ccd}ರ ಸ\u{cbf}ಂಹ", "ಸೀಲ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("물개"),
            keywords: &["물개", "바다사자"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("सील"),
            keywords: &["सी लायन", "सील"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("тюлень"),
            keywords: &["тюлень"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ແມວ\u{200b}ນ\u{ec9}ຳ"),
            keywords: &[
                "ສ\u{eb1}ດ",
                "ແມວ\u{200b}ນ\u{ec9}ຳ",
                "\u{200b}ນາກ\u{200b}ນ\u{ec9}ຳ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("ruonis"),
            keywords: &["jūrų liūtas", "ruonis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("ronis"),
            keywords: &["jūras lauva", "ronis"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("фока"),
            keywords: &["морски лав", "фока"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("സീൽ"),
            keywords: &["കടൽ സിംഹം", "സീൽ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("далайн хав"),
            keywords: &["далайн арслан", "далайн хав"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some(
                "हिमाच\u{94d}छादित ट\u{942}ण\u{94d}द\u{94d}रा प\u{94d}रद\u{947}शातील जलचर प\u{94d}राणी",
            ),
            keywords: &[
                "सम\u{941}द\u{94d}रावर आढळणारा मोठ\u{947} कान असणारा प\u{94d}राणी",
                "हिमाच\u{94d}छादित ट\u{942}ण\u{94d}द\u{94d}रा प\u{94d}रद\u{947}शातील जलचर प\u{94d}राणी",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("anjing laut"),
            keywords: &["Singa laut", "anjing laut"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပင\u{103a}လယ\u{103a}ဖျ\u{1036}"),
            keywords: &[
                "ပင\u{103a}လယ\u{103a}ဖျ\u{1036}",
                "ပင\u{103a}လယ\u{103a}ဖျ\u{1036}ကြ\u{102e}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("sel"),
            keywords: &["dyr", "sel", "sjøløve"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("सिल"),
            keywords: &["सिल", "सिल लायन"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("zeehond"),
            keywords: &["zeehond", "zeeleeuw"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("sel"),
            keywords: &["dyr", "sel", "sjøløve"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସ\u{b3f}ଲ\u{b4d}\u{200c}"),
            keywords: &["ସ\u{b3f} ଲ\u{b3e}ୟନ", "ସ\u{b3f}ଲ\u{b4d}\u{200c}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸੀਲ ਮ\u{a71}ਛੀ"),
            keywords: &["ਸਮ\u{a41}\u{a70}ਦਰੀ ਸ\u{a3c}\u{a47}ਰ", "ਸੀਲ ਮ\u{a71}ਛੀ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Wọtá Anímọl Wé Im Nem Na Siil"),
            keywords: &[
                "Bíg-Díp-Wọtá Láyọn",
                "Sí Láyọn",
                "Wọtá Anímọl Wé Im Nem Na Siil",
                "Wọ\u{301}n Wọtá Anímọl Wé Im Nem Na Siil",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("foka"),
            keywords: &["foka", "lew morski"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سيل"),
            keywords: &["د اوبو زمری", "سيل"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("foca"),
            keywords: &["foca", "leão marinho"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("foca"),
            keywords: &["foca", "mamaquchamanta Leon"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("focă"),
            keywords: &["focă", "leu de mare"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E13-032"),
            keywords: &["E13-032"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("тюлень"),
            keywords: &["морской лев", "нерпа", "тюлень"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("سيل"),
            keywords: &["سي ليون", "سيل"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ස\u{dd3}ල\u{dca} මත\u{dca}ස\u{dca}\u{200d}යය\u{dcf}"),
            keywords: &[
                "ම\u{dd4}හ\u{dd4}ද\u{dd4} ස\u{dd2}ංහය\u{dcf}",
                "ස\u{dd3}ල\u{dca} මත\u{dca}ස\u{dca}\u{200d}යය\u{dcf}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("uškatec"),
            keywords: &["more", "tuleň", "uškatec"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("tjulenj"),
            keywords: &["morski lev", "tjulenj"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("shaabad"),
            keywords: &["libaax badeed", "shaabad"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fokë"),
            keywords: &["fokë", "fokë luan"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("фока"),
            keywords: &["морски лав", "фока"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("foka"),
            keywords: &["foka", "morski lav"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("säl"),
            keywords: &["sjölejon", "säl"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("sili"),
            keywords: &["sili", "sili mkubwa"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கடல\u{bcd} சிங\u{bcd}கம\u{bcd}"),
            keywords: &[
                "கடல\u{bcd} சிங\u{bcd}கம\u{bcd}",
                "கடல\u{bcd}ந\u{bbe}ய\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("స\u{c40}ల\u{c4d}"),
            keywords: &["స\u{c40} లయన\u{c4d}", "స\u{c40}ల\u{c4d}"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("แมวน\u{e49}ำ"),
            keywords: &["ส\u{e34}งโตทะเล", "แมวน\u{e49}ำ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("düwlen"),
            keywords: &["deňiz ýolbarsy", "düwlen"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kulītahi"),
            keywords: &["kulītahi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("fok"),
            keywords: &["ayı balığı", "denizaslanı", "fok", "fok balığı"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("тюлень"),
            keywords: &["морський лев", "тюлень"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سیل"),
            keywords: &["بڑا سیل", "سیل"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("dengiz mushugi"),
            keywords: &["dengiz mushugi", "dengiz sheri"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("chó biển"),
            keywords: &["chó biển", "sư tử biển"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("海豹"),
            keywords: &["海獅", "海豹"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("海豹"),
            keywords: &["海狮", "海豹"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("海豹"),
            keywords: &["海狮", "海豹"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("海豹"),
            keywords: &["海獅", "海豹"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("i-seal"),
            keywords: &["i-seal", "ibhubesi lasolwandle"],
        },
    ],
};
#[doc = "🐟"]
pub const FISH: crate::Emoji = crate::Emoji {
    glyph: "🐟",
    codepoint: "1F41F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "fish",
    group: "Animals & Nature",
    subgroup: "animal-marine",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("vis"),
            keywords: &["Pisces", "diereriem", "vis"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ዓሣ"),
            keywords: &["ዓሣ", "ዞዲያክ", "ፖይሲስ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سمكة"),
            keywords: &["برج", "حيوان", "سمكة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ম\u{9be}ছ"),
            keywords: &["ম\u{9be}ছ", "মীন ৰ\u{9be}শি", "ৰ\u{9be}শি"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("balıq"),
            keywords: &["balıq", "balıqlar", "zodiak"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("рыба"),
            keywords: &["задыяк", "рыба", "рыбы"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("риба"),
            keywords: &["зодиак", "зодиакален знак", "зодия", "риба", "риби"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ম\u{9be}ছ"),
            keywords: &["ম\u{9be}ছ", "মীন", "র\u{9be}শিচক\u{9cd}র"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("pesk"),
            keywords: &["loen", "pesk", "pesked"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("riba"),
            keywords: &["riba", "ribe"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("peix"),
            keywords: &["Peixos", "peix", "zodíac"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄟𑄌\u{11134}"),
            keywords: &["𑄟𑄌\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏣᏗ"),
            keywords: &["ᎠᏂᏔᎵ ᎠᏣᏗ", "ᎠᏣᏗ", "ᏃᏈᏏ ᏓᏟᎶᏍᏗᎲᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("ryba"),
            keywords: &["ryba", "ryby", "zvěrokruh"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("pysgodyn"),
            keywords: &["Sidydd", "pysgod", "pysgodyn", "y Pysgod"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("fisk"),
            keywords: &["dyr", "fisk"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Fisch"),
            keywords: &["Fisch", "Fische", "Sternzeichen", "Tier", "Tierkreis"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ψάρι"),
            keywords: &["ζώδιο", "ιχθείς", "ψάρι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("fish"),
            keywords: &["Pisces", "fish", "zodiac"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["Pisces", "fish", "zodiac"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("pez"),
            keywords: &["pececillo", "pescado", "pez", "piscis", "zodiaco"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["animal", "pez"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kala"),
            keywords: &["kala", "sodiaak"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("arrain"),
            keywords: &["arrain", "pisces", "zodiako"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ماهی"),
            keywords: &["برج فلکی", "حوت", "زودیاک", "ماهی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kala"),
            keywords: &["horoskooppi", "horoskooppimerkki", "kala", "kalat"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("isda"),
            keywords: &["hayop", "isda", "pisces", "zodiac"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("fiskur"),
            keywords: &["dýr", "fiskur", "stjørnumerki"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("poisson"),
            keywords: &["animal", "poisson", "poissons", "zodiaque"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("iasc"),
            keywords: &["Na hÉisc", "iasc", "stoidiaca"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("iasg"),
            keywords: &["grian-chriosach", "iasg", "pisces", "èisg"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("peixe"),
            keywords: &["Pisces", "peixe", "zodíaco"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("માછલી"),
            keywords: &["પ\u{acd}રાણી", "માછલી"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kifi"),
            keywords: &["Pisces", "kifi", "zodiac"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("דג"),
            keywords: &["גלגל המזלות", "דג", "מזל דגים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("मछली"),
            keywords: &["पश\u{941}", "मछली"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("riba"),
            keywords: &["riba", "ribe", "zodijak"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("hal"),
            keywords: &["csillagjegy", "hal", "halak", "állatöv"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ձուկ"),
            keywords: &["կենդանակերպ", "ձկներ", "ձուկ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("ikan"),
            keywords: &["ikan", "pisces", "zodiak"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("azụ\u{300}"),
            keywords: &["Akara ngosi", "azụ\u{300}", "zodịak"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("fiskur"),
            keywords: &["fiskar", "fiskur", "stjörnumerki"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("pesce"),
            keywords: &["animale", "pesce", "segno zodiacale dei Pesci"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("魚"),
            keywords: &["動物", "星座", "魚"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("iwak"),
            keywords: &["Pisces", "iwak", "zodiak"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("თევზი"),
            keywords: &["ზოდიაქო", "თევზები", "თევზი", "ჰოროსკოპი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("балық"),
            keywords: &["балық", "балықтар", "зодиак"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("fisk"),
            keywords: &["dyr", "fisk"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ត\u{17d2}រ\u{17b8}"),
            keywords: &["ត\u{17d2}រ\u{17b8}"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮೀನು"),
            keywords: &["ಮೀನ ರಾಶ\u{cbf}", "ಮೀನು"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("물고기"),
            keywords: &["동물", "물고기", "생선"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("न\u{941}स\u{94d}त\u{947}\u{902}"),
            keywords: &["न\u{941}स\u{94d}त\u{947}\u{902}", "मीनरास", "रास"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("балык"),
            keywords: &["балык", "зодиак"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Fësch"),
            keywords: &["Fësch", "Stärzeechen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ປາ"),
            keywords: &["ປາ", "ສ\u{eb1}ດ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("žuvis"),
            keywords: &["zodiakas", "žuvis", "žuvys"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("zivs"),
            keywords: &["zivis", "zivs", "zodiaks"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("ika"),
            keywords: &["Pisces", "ika", "poutiriao"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("риба"),
            keywords: &["риба", "риби", "хороскоп"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മത\u{d4d}സ\u{d4d}യം"),
            keywords: &[
                "മത\u{d4d}സ\u{d4d}യം",
                "മീനമ\u{d3e}സം",
                "ര\u{d3e}ശി ചക\u{d4d}രം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("загас"),
            keywords: &["загас", "загасны орд", "өрнийн зурхай"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("मासा"),
            keywords: &["मासा", "मीन", "राशी"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("ikan"),
            keywords: &["ikan", "pisces", "zodiak"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ħut"),
            keywords: &["Pisces", "ħut", "żodjaku"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ငါး"),
            keywords: &[
                "ငါး",
                "ဆယ\u{1037}\u{103a}န\u{103e}စ\u{103a}ရာသ\u{102e}ခ\u{103d}င\u{103a}",
                "မ\u{102d}န\u{103a}ရာသ\u{102e}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("fisk"),
            keywords: &["dyr", "fisk", "fiskene", "stjernebilde", "stjernetegn"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("माछा"),
            keywords: &["माछा", "राशि"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("vis"),
            keywords: &["sterrenbeeld", "vis", "vissen"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("fisk"),
            keywords: &["dyr", "fisk", "fiskane", "stjernebilete", "stjerneteikn"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମ\u{b3e}ଛ"),
            keywords: &[
                "ମ\u{b3e}ଛ",
                "ମୀନ ର\u{b3e}ଶ\u{b3f}",
                "ର\u{b3e}ଶ\u{b3f}ଚକ\u{b4d}ର",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਮ\u{a71}ਛੀ"),
            keywords: &["ਜਾਨਵਰ", "ਮ\u{a71}ਛੀ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("مچھی"),
            keywords: &["ب\u{64f}رج", "ب\u{64f}رج حوت", "مچھی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fish"),
            keywords: &["Fish", "Paísiz", "Zódiak"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("ryba"),
            keywords: &["ryba", "zodiak"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("کب"),
            keywords: &["زوډیک", "پیسس", "کب"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("peixe"),
            keywords: &["Peixes", "animal", "peixe", "zodíaco"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["peixe", "peixes", "signo"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("callwa"),
            keywords: &["Piscis", "callwa", "zodiaco"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("pește"),
            keywords: &["pește", "pești", "zodiac"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-476"),
            keywords: &["E10-476"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("рыба"),
            keywords: &["знак зодиака", "зодиак", "рыба", "рыбы"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ifi"),
            keywords: &["Ifi", "ifi", "zodiyake"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مڇي"),
            keywords: &["حوت، برج", "مڇي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ම\u{dcf}ළ\u{dd4}ව\u{dcf}"),
            keywords: &[
                "ම\u{dcf}ළ\u{dd4}ව\u{dcf}",
                "ම\u{dd3}න ර\u{dcf}ශ\u{dd2}ය",
                "ර\u{dcf}ශ\u{dd2} චක\u{dca}\u{200d}රය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("ryba"),
            keywords: &["ryba"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("riba"),
            keywords: &["riba", "ribi", "zodiak"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("kalluun"),
            keywords: &["kalluun", "kalluun kolonyo", "mactab meecaad"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("peshk"),
            keywords: &["peshk", "peshqit", "zodiak"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("риба"),
            keywords: &["зoдиjaк", "рибe", "риба"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("riba"),
            keywords: &["riba", "ribe", "zodijak"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("fisk"),
            keywords: &["fisk", "fiskarna", "stjärntecken"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("samaki"),
            keywords: &["samaki", "zodiaki"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ம\u{bc0}ன\u{bcd}"),
            keywords: &[
                "ந\u{bc0}ர\u{bcd}வ\u{bbe}ழ\u{bcd} உயிரினம\u{bcd}",
                "ம\u{bc0}ன\u{bcd}",
                "விலங\u{bcd}கினம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("చ\u{c47}ప"),
            keywords: &["చ\u{c47}ప", "జంతువు"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("моҳӣ"),
            keywords: &["бурҷи дувоздаҳгона", "моҳӣ", "Ҳут"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ปลา"),
            keywords: &["ปลา", "ราศ\u{e35}", "ราศ\u{e35}ม\u{e35}น"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("balyk"),
            keywords: &["Balyk", "balyk", "täleýnama"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ika"),
            keywords: &["ika"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("balık"),
            keywords: &["balık", "hayvan"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("بېلىق"),
            keywords: &["بېلىق", "مۆچەل"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("риба"),
            keywords: &["зодіак", "риба", "риби"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("مچھلی"),
            keywords: &["جانور", "مچھلی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("baliq"),
            keywords: &["baliq", "burj"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("cá"),
            keywords: &["cung hoàng đạo", "cung song ngư", "cá"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("jën"),
            keywords: &["Jën ji", "jën", "sojak"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("intlanzi"),
            keywords: &["I-Pisces", "i-zodiac", "intlanzi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ẹja"),
            keywords: &["Pisces", "àmi oṣù ìbí", "Ẹja"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("魚"),
            keywords: &["星座", "雙魚座", "魚"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("鱼"),
            keywords: &["双鱼座", "星座", "鱼"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("鱼"),
            keywords: &["双鱼座", "鱼", "黄道十二宫"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("魚"),
            keywords: &["魚"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("inhlanzi"),
            keywords: &["inhlanzi", "izinkanyezi", "pisces"],
        },
    ],
};
#[doc = "🐠"]
pub const TROPICAL_FISH: crate::Emoji = crate::Emoji {
    glyph: "🐠",
    codepoint: "1F420",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "tropical fish",
    group: "Animals & Nature",
    subgroup: "animal-marine",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("tropiese vis"),
            keywords: &["tropies", "tropiese vis", "vis"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የምድር ወገብ አካባቢ ዓሣ"),
            keywords: &["ዓሣ", "የምድር ወገብ አካባቢ", "የምድር ወገብ አካባቢ ዓሣ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سمكة استوائية"),
            keywords: &["حيوان", "سمكة", "سمكة استوائية"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("গ\u{9cd}ৰীষ\u{9cd}মমণ\u{9cd}ডলীয\u{9bc} ম\u{9be}ছ"),
            keywords: &["গ\u{9cd}ৰীষ\u{9cd}মমণ\u{9cd}ডলীয\u{9bc}", "ম\u{9be}ছ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("tropik balıq"),
            keywords: &["balıq", "tropik"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("трапічная рыба"),
            keywords: &["рыба", "трапічная рыба", "тропікі"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Тропическа риба"),
            keywords: &["Тропическа риба", "риба", "тропическа"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ট\u{9cd}রপিক\u{9cd}য\u{9be}ল ম\u{9be}ছ"),
            keywords: &[
                "ক\u{9cd}র\u{9be}ন\u{9cd}তীয\u{9bc}",
                "ট\u{9cd}রপিক\u{9cd}য\u{9be}ল ম\u{9be}ছ",
                "ম\u{9be}ছ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("pesk trovanel"),
            keywords: &["pesk", "trovanel"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("tropska riba"),
            keywords: &["riba", "tropska"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("peix tropical"),
            keywords: &["peix", "tropical"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏗᏞᎦ ᎠᏣᏗ"),
            keywords: &["ᎠᏣᏗ", "ᎤᏗᏞᎦ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("tropická ryba"),
            keywords: &["ryba", "tropická ryba", "tropický"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("pysgod trofannol"),
            keywords: &["pysgod trofannol", "pysgodyn", "trofannol"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("tropisk fisk"),
            keywords: &["dyr", "fisk", "tropisk fisk"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Tropenfisch"),
            keywords: &["Fisch", "Tier", "Tropenfisch"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("τροπικό ψάρι"),
            keywords: &["τροπικό", "ψάρι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("tropical fish"),
            keywords: &["fish", "tropical"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("reef fish"),
            keywords: &["fish", "reef fish", "tropical"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("pez tropical"),
            keywords: &["animal", "pescado", "pez", "pez tropical"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["animal", "pez", "tropical"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("troopiline kala"),
            keywords: &["kala", "troopiline"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("arrain tropikala"),
            keywords: &["arrain tropikala", "arraina", "tropikala"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ماهی استوایی"),
            keywords: &["استوایی", "ماهی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("trooppinen kala"),
            keywords: &["kala", "trooppinen"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("tropical fish"),
            keywords: &["hayop", "isda", "tropical", "tropical fish"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("tropiskur fiskur"),
            keywords: &["dýr", "fiskur", "tropiskur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("poisson tropical"),
            keywords: &["animal", "poisson", "poisson tropical"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["poisson", "tropical"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("iasc teochreasa"),
            keywords: &["iasc", "iasc teochreasa", "teochriosach"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("iasg tropaigeach"),
            keywords: &["iasg", "tropaigeach"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("peixe tropical"),
            keywords: &["peixe", "tropical"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ઉષ\u{acd}ણકટિબ\u{a82}ધીય માછલી"),
            keywords: &["ઉષ\u{acd}ણકટિબ\u{a82}ધીય માછલી", "પ\u{acd}રાણી", "માછલી"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kifi na wuri mai zafi"),
            keywords: &["kifi", "kifi na wuri mai zafi", "wuri mai zafi"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("דג טרופי"),
            keywords: &["דג", "טרופי"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ऊष\u{94d}णकटिब\u{902}धीय मछली"),
            keywords: &["ऊष\u{94d}णकटिब\u{902}धीय मछली", "पश\u{941}", "मछली"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("tropska ribica"),
            keywords: &["riba", "tropi", "tropska ribica"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("trópusi hal"),
            keywords: &["díszhal", "hal", "trópusi"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("արևադարձային ձուկ"),
            keywords: &["արևադարձային", "ձուկ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("ikan tropis"),
            keywords: &["ikan", "tropis"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("azụ\u{300} mmiri"),
            keywords: &["azụ\u{300}", "azụ\u{300} mmiri", "ebe okpomọọkụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hitabeltisfiskur"),
            keywords: &["fiskur", "hitabelti", "hitabeltisfiskur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("pesce tropicale"),
            keywords: &["animale", "pesce", "pesce tropicale"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("熱帯魚"),
            keywords: &["動物", "熱帯魚", "魚"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("iwak tropis"),
            keywords: &["iwak", "tropis"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ტროპიკული თევზი"),
            keywords: &["თევზი", "ტროპიკული"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("тропикалық балық"),
            keywords: &["балық", "тропикалық"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("tropisk fisk"),
            keywords: &["dyr", "fisk", "tropisk fisk"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ត\u{17d2}រ\u{17b8}ត\u{17c6}បន\u{17cb}ត\u{17d2}រ\u{17bc}ព\u{17b7}ច"),
            keywords: &[
                "ត\u{17d2}រ\u{17b8}",
                "ត\u{17d2}រ\u{17b8}ត\u{17c6}បន\u{17cb}ត\u{17d2}រ\u{17bc}ព\u{17b7}ច",
                "ត\u{17d2}រ\u{17bc}ព\u{17b7}ច",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಉಷ\u{ccd}ಣವಲಯ ಮೀನು"),
            keywords: &["ಉಷ\u{ccd}ಣವಲಯ ಮೀನು", "ಉಷ\u{ccd}ಣವಲಯದ ಮೀನುಗಳು", "ಮೀನು"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("열대어"),
            keywords: &["동물", "물고기", "열대어"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("उष\u{94d}णकटीब\u{902}धातल\u{947}\u{902} न\u{941}स\u{94d}त\u{947}\u{902}"),
            keywords: &[
                "उष\u{94d}णकटीब\u{902}धातल\u{947}\u{902} न\u{941}स\u{94d}त\u{947}\u{902}",
                "उष\u{94d}णकटीब\u{902}धीय",
                "न\u{941}स\u{94d}त\u{947}\u{902}",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("тропикалык балык"),
            keywords: &["балык", "тропикалык"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("tropesche Fësch"),
            keywords: &["Fësch", "tropesch", "tropesche Fësch"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ປາເຂດຮ\u{ec9}ອນ"),
            keywords: &["ປາ", "ປາເຂດຮ\u{ec9}ອນ", "ສ\u{eb1}ດ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("tropinė žuvis"),
            keywords: &["tropinė", "žuvis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("tropu zivs"),
            keywords: &["tropi", "tropu zivs", "zivs"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("ika pārūrū"),
            keywords: &["ika", "pārūrū"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("тропска риба"),
            keywords: &["риба", "тропска"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ട\u{d4d}രോപ\u{d4d}പിക\u{d4d}കൽ ഫിഷ\u{d4d}"),
            keywords: &[
                "ഉഷ\u{d4d}\u{200c}ണമേഖല",
                "ട\u{d4d}രോപ\u{d4d}പിക\u{d4d}കൽ ഫിഷ\u{d4d}",
                "മത\u{d4d}സ\u{d4d}യം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("халуун орны загас"),
            keywords: &["загас", "халуун орны загас", "халуун орон"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ट\u{94d}रॉपिकल मासा"),
            keywords: &["उष\u{94d}णकटिब\u{902}धीय", "ट\u{94d}रॉपिकल मासा", "मासा"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("ikan tropika"),
            keywords: &["ikan", "tropika"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ħut tropikali"),
            keywords: &["tropikali", "ħut"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အပ\u{1030}ပ\u{102d}\u{102f}င\u{103a}း ငါး"),
            keywords: &["ငါး", "အပ\u{1030}ပ\u{102d}\u{102f}င\u{103a}း"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("tropisk fisk"),
            keywords: &["dyr", "fisk", "tropisk"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("उष\u{94d}णप\u{94d}रद\u{947}शीय माछा"),
            keywords: &["उष\u{94d}णप\u{94d}रद\u{947}शीय", "माछा"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("tropische vis"),
            keywords: &["tropisch", "tropische vis", "vis"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("tropisk fisk"),
            keywords: &["dyr", "fisk", "tropisk"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଗ\u{b4d}ରୀଷ\u{b4d}ମମଣ\u{b4d}ଡଳୀୟ ମ\u{b3e}ଛ"),
            keywords: &[
                "ଉଷ\u{b4d}ମ ମଣ\u{b4d}ଡଳ",
                "ଗ\u{b4d}ରୀଷ\u{b4d}ମମଣ\u{b4d}ଡଳୀୟ ମ\u{b3e}ଛ",
                "ମ\u{b3e}ଛ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਤਪਤ-ਖ\u{a70}ਡੀ ਮ\u{a71}ਛੀ"),
            keywords: &["ਜਾਨਵਰ", "ਤਪਤ-ਖ\u{a70}ਡੀ ਮ\u{a71}ਛੀ", "ਮ\u{a71}ਛੀ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("گرم علاقے دی مچھی"),
            keywords: &["شدید گرم", "مچھی", "گرم علاقے دی مچھی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Họ\u{301}t Ríjọ\u{301}n Fish"),
            keywords: &["Fish", "Họ\u{301}t Ríjọn", "Họ\u{301}t Ríjọ\u{301}n Fish"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("ryba tropikalna"),
            keywords: &["ryba", "tropikalna"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ګرمسير کب"),
            keywords: &["ګرمسير کب"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("peixe tropical"),
            keywords: &["animal", "peixe", "peixe tropical"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["peixe", "tropical"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("tropical callwa"),
            keywords: &["callwa", "tropical"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("pește tropical"),
            keywords: &["exotic", "pește tropical", "pești", "tropical"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-477"),
            keywords: &["E10-477"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("тропическая рыба"),
            keywords: &["рыба", "тропики", "тропическая рыба", "экзотическая"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ifi yo muri toropike"),
            keywords: &["Ifi yo muri Turopike", "ifi yo muri toropike"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مداريني مڇي"),
            keywords: &["مداريني مڇي", "مڇي، مداريني"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("න\u{dd2}වර\u{dca}තන ම\u{dcf}ළ\u{dd4}ව\u{dcf}"),
            keywords: &["න\u{dd2}වර\u{dca}තන", "ම\u{dcf}ළ\u{dd4}ව\u{dcf}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("tropická ryba"),
            keywords: &["ryba", "tropická"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("tropska riba"),
            keywords: &["riba", "tropska riba", "tropsko"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("kalluunka kulaylaha"),
            keywords: &["kalluun", "kalluunka kulaylaha", "kulaylaha"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("peshk tropikal"),
            keywords: &["peshk", "tropikal"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("тропска риба"),
            keywords: &["рибa", "тропскa", "тропска риба"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["тропска риба"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("tropska riba"),
            keywords: &["riba", "tropska"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["tropska riba"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("tropisk fisk"),
            keywords: &["djur", "fisk", "tropisk"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("samaki wa tropiki"),
            keywords: &["samaki", "samaki wa tropiki", "tropikali"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("நன\u{bcd}ன\u{bc0}ர\u{bcd} ம\u{bc0}ன\u{bcd}"),
            keywords: &[
                "நன\u{bcd}ன\u{bc0}ர\u{bcd} ம\u{bc0}ன\u{bcd}",
                "ந\u{bc0}ர\u{bcd}வ\u{bbe}ழ\u{bcd} உயிரினம\u{bcd}",
                "ம\u{bc0}ன\u{bcd}",
                "விலங\u{bcd}கினம\u{bcd}",
                "வெப\u{bcd}பமண\u{bcd}டல ம\u{bc0}ன\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("అయనవృత\u{c4d}త\u{c40}య చ\u{c47}ప"),
            keywords: &[
                "అయనవృత\u{c4d}త\u{c40}య చ\u{c47}ప",
                "అయనవృత\u{c4d}త\u{c40}యం",
                "చ\u{c47}ప",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("моҳии тропикӣ"),
            keywords: &["моҳии тропикӣ", "моҳӣ", "тропикӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ปลาเขตร\u{e49}อน"),
            keywords: &["ปลา", "ปลาเขตร\u{e49}อน", "ส\u{e31}ตว\u{e4c}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("tropiki balyk"),
            keywords: &["balyk", "tropiki"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ika he hakau"),
            keywords: &["ika he hakau"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("tropikal balık"),
            keywords: &["balık", "hayvan", "tropikal balık"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئىسسىق بەلباغ بېلىقى"),
            keywords: &["ئىسسىق", "ئىسسىق بەلباغ بېلىقى", "بېلىق"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("тропічна риба"),
            keywords: &["риба", "тропічна риба", "тропічний"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ٹراپکل مچھلی"),
            keywords: &["مچھلی", "ٹراپکل"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("tropik baliq"),
            keywords: &["baliq", "tropik"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("cá nhiệt đới"),
            keywords: &["cá", "cá nhiệt đới", "nhiệt đới"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("jënu tàngoor"),
            keywords: &["jën", "jënu tàngoor", "tàngoor"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("intlanzi yetropiki"),
            keywords: &["intlanzi", "intlanzi yetropiki", "itropiki"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ẹja oorùn"),
            keywords: &["oorùn", "Ẹja"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("熱帶魚"),
            keywords: &["熱帶", "熱帶魚", "魚"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("热带鱼"),
            keywords: &["热带", "热带鱼", "鱼"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("热带鱼"),
            keywords: &["热带", "热带鱼", "鱼"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("熱帶魚"),
            keywords: &["熱帶魚", "魚"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ufishi"),
            keywords: &["ufishi"],
        },
    ],
};
#[doc = "🐡"]
pub const BLOWFISH: crate::Emoji = crate::Emoji {
    glyph: "🐡",
    codepoint: "1F421",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "blowfish",
    group: "Animals & Nature",
    subgroup: "animal-marine",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("blaasoppie"),
            keywords: &["blaasoppie", "vis"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ብሎውፊሽ"),
            keywords: &["ብሎውፊሽ", "ዓሣ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سمكة منتفخة"),
            keywords: &["حيوان", "سمكة", "سمكة منتفخة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ব\u{9cd}লোফিছ"),
            keywords: &["ব\u{9cd}লোফিছ", "ম\u{9be}ছ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("iynəqarın balıq"),
            keywords: &["balıq", "iynəqarın balıq"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("іголкабрухавая рыба"),
            keywords: &["рыба", "фугу", "іголкабрухавая рыба"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Риба балон"),
            keywords: &["Риба балон", "риба"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ব\u{9cd}লোফিশ"),
            keywords: &["ব\u{9cd}লোফিশ", "ম\u{9be}ছ"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("loar-vor"),
            keywords: &["loar-vor", "pesk"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("napuhača"),
            keywords: &["napuhača", "riba"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("peix globus"),
            keywords: &["globus", "peix"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏦᏔᏍᎩᎠᏣᏗ"),
            keywords: &["ᎠᏣᏗ", "ᎠᏦᏔᏍᎩᎠᏣᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("ježík"),
            keywords: &["ježík", "ryba", "čtverzubec"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("chwydd bysgodyn"),
            keywords: &["chwydd bysgodyn", "pysgod"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kuglefisk"),
            keywords: &["dyr", "fisk", "kuglefisk"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Kugelfisch"),
            keywords: &["Fisch", "Kugelfisch", "Tier"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("γουρουνόψαρο"),
            keywords: &["γουρουνόψαρο", "φούσκα", "ψάρι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("blowfish"),
            keywords: &["blowfish", "fish"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("pez globo"),
            keywords: &["animal", "globo", "pez"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("siilkala"),
            keywords: &["kala", "siilkala"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("globo-arraina"),
            keywords: &["arrain", "globo-arraina"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ماهی بادکنکی"),
            keywords: &["ماهی", "ماهی بادکنکی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("pallokala"),
            keywords: &["kala", "pallokala"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("blowfish"),
            keywords: &["blowfish", "hayop", "isda"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("ígulfiskur"),
            keywords: &["dýr", "fiskur", "ígulfiskur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("poisson-lune"),
            keywords: &["animal", "poisson", "poisson-lune"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("poisson-globe"),
            keywords: &["poisson", "poisson-globe"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("iasc torcánach"),
            keywords: &["iasc", "iasc torcánach"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("iasg-sèididh"),
            keywords: &["iasg", "iasg-sèididh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("peixe globo"),
            keywords: &["globo", "peixe"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("બ\u{acd}લોફિશ"),
            keywords: &["પ\u{acd}રાણી", "બ\u{acd}લોફિશ", "બ\u{acd}લોફીશ", "માછલી"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kifi mai kumburawa"),
            keywords: &["kifi", "kifi mai kumburawa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("אבו נפחא"),
            keywords: &["אבו נפחא", "דג", "קוצים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ग\u{941}ब\u{94d}बारा मछली"),
            keywords: &["ग\u{941}ब\u{94d}बारा मछली", "पश\u{941}", "मछली"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("riba napuhača"),
            keywords: &["riba", "riba napuhača"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("gömbhal"),
            keywords: &["gömbhal", "hal"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("փքաձուկ"),
            keywords: &["ձուկ", "փքաձուկ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("ikan gembung"),
            keywords: &["ikan", "ikan gembung"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("azụ\u{300} nwere ike itóó abụba"),
            keywords: &["azụ\u{300}", "azụ\u{300} nwere ike itóó abụba"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("blöðrufiskur"),
            keywords: &["blöðrufiskur", "fiskur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("pesce palla"),
            keywords: &["animale", "pesce", "pesce palla"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("フグ"),
            keywords: &["フグ", "動物", "魚"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("iwak buntal"),
            keywords: &["buntal", "iwak"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მუცელნემსა"),
            keywords: &["თევზი", "მუცელნემსა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("кірпібалық"),
            keywords: &["балық", "кірпібалық"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("kuglefisk"),
            keywords: &["dyr", "fisk", "kuglefisk"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ត\u{17d2}រ\u{17b8}ក\u{17c6}ពត"),
            keywords: &["ត\u{17d2}រ\u{17b8}", "ត\u{17d2}រ\u{17b8}ក\u{17c6}ពត"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಉಬ\u{ccd}ಬುಮೀನು"),
            keywords: &["ಉಬ\u{ccd}ಬುಮೀನು", "ಮೀನು"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("복어"),
            keywords: &["동물", "물고기", "복어"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ब\u{94d}लोफीश"),
            keywords: &["न\u{941}स\u{94d}त\u{947}\u{902}", "ब\u{94d}लोफीश"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("үйлөнмө балык"),
            keywords: &["балык", "үйлөнмө балык"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Kugelfësch"),
            keywords: &["Fësch", "Kugelfësch"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ປາເປ\u{ebb}\u{ec9}າ"),
            keywords: &["ປາ", "ປາເປ\u{ebb}\u{ec9}າ", "ສ\u{eb1}ດ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("fugu"),
            keywords: &["fugu", "žuvis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("balonzivs"),
            keywords: &["balonzivs", "zivs"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("ikapupuhi"),
            keywords: &["ika", "ikapupuhi"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("риба со боцки"),
            keywords: &["боцки", "риба", "риба со боцки"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ബ\u{d4d}ലോഫിഷ\u{d4d}"),
            keywords: &["ബ\u{d4d}ലോഫിഷ\u{d4d}", "മത\u{d4d}സ\u{d4d}യം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("нохой загас"),
            keywords: &["загас", "нохой загас"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ब\u{94d}लोफिश"),
            keywords: &["ब\u{94d}लोफिश", "मासा"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("ikan buntal"),
            keywords: &["ikan", "ikan buntal"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("blowfish"),
            keywords: &["blowfish", "ħut"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ငါးပ\u{1030}ဖောင\u{103a}း"),
            keywords: &["ငါး", "ငါးပ\u{1030}ဖောင\u{103a}း"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kulefisk"),
            keywords: &["dyr", "fisk", "kulefisk"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ब\u{94d}लो माछा"),
            keywords: &["ब\u{94d}लो माछा", "माछा"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("kogelvis"),
            keywords: &["kogelvis", "vis"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kulefisk"),
            keywords: &["dyr", "fisk", "kulefisk"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବ\u{b4d}ଲୋଫ\u{b3f}ଶ\u{b4d}\u{200d}"),
            keywords: &["ବ\u{b4d}ଲୋଫ\u{b3f}ଶ\u{b4d}\u{200d}", "ମ\u{b3e}ଛ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬਲ\u{a4b}ਫਿਸ\u{a3c}"),
            keywords: &["ਜਾਨਵਰ", "ਬਲ\u{a4b}ਫਿਸ\u{a3c}", "ਮ\u{a71}ਛੀ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("دھونک مچھی"),
            keywords: &["دھونک مچھی", "مچھی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Blófish"),
            keywords: &["Blófish", "Fish"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("ryba rozdymka"),
            keywords: &["rozdymka", "ryba rozdymka"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("بلوکب"),
            keywords: &["بلوکب", "کب"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("baiacu"),
            keywords: &["animal", "baiacu", "peixe"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("peixe-balão"),
            keywords: &["peixe", "peixe-balão"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("pez globo"),
            keywords: &["callwa", "pez globo"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("pește balon"),
            keywords: &["pește", "pește balon", "pește țepos"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-478"),
            keywords: &["E10-478"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("рыба-еж"),
            keywords: &["еж", "иголки", "рыба", "рыба-еж"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ifi imeze nka balo"),
            keywords: &["ifi", "ifi imeze nka balo"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("بلوفش"),
            keywords: &["بلوفش", "مڇي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ඉහඳ ම\u{dcf}ළ\u{dd4}ව\u{dcf}"),
            keywords: &["ඉහඳ ම\u{dcf}ළ\u{dd4}ව\u{dcf}", "ම\u{dcf}ළ\u{dd4}ව\u{dcf}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("štvorzubec"),
            keywords: &["ryba", "štvorzubec"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("riba napihovalka"),
            keywords: &["riba", "riba napihovalka", "tropsko"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("kalluunka baaqa"),
            keywords: &["kalluun", "kalluunka baaqa"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("peshk tullumbace"),
            keywords: &["peshk", "peshk tullumbace"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("надувана риба"),
            keywords: &["надувана риба", "рибa"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("naduvana riba"),
            keywords: &["naduvana riba", "riba"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("blåsfisk"),
            keywords: &["blåsfisk", "djur", "fisk"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("aina ya samaki"),
            keywords: &["aina ya samaki", "samaki"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஊதிப\u{bcd}பெருக\u{bcd}கமடையும\u{bcd} ம\u{bc0}ன\u{bcd}"),
            keywords: &[
                "ஊதிப\u{bcd}பெருக\u{bcd}கமடையும\u{bcd} ம\u{bc0}ன\u{bcd}",
                "குளோப\u{bcd} ம\u{bc0}ன\u{bcd}",
                "ந\u{bc0}ர\u{bcd}வ\u{bbe}ழ\u{bcd} உயிரினம\u{bcd}",
                "ம\u{bc0}ன\u{bcd}",
                "விலங\u{bcd}கினம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ముళ\u{c4d}లచ\u{c47}ప"),
            keywords: &["చ\u{c47}ప", "జంతువు", "ముళ\u{c4d}లచ\u{c47}ప"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("сагмоҳӣ"),
            keywords: &["моҳӣ", "сагмоҳӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ปลาป\u{e31}กเป\u{e49}า"),
            keywords: &["ปลา", "ปลาป\u{e31}กเป\u{e49}า", "ส\u{e31}ตว\u{e4c}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("çişýän balyk"),
            keywords: &["balyk", "çişýän balyk"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("sokisoki"),
            keywords: &["sokisoki"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("balon balığı"),
            keywords: &["balon balığı", "balık", "hayvan"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("توقماق بېلىق"),
            keywords: &["بېلىق", "توقماق بېلىق"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("риба-куля"),
            keywords: &["риба", "риба-куля"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بلو مچھلی"),
            keywords: &["بلو مچھلی", "مچھلی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("qorni katta baliq"),
            keywords: &["baliq", "qorni katta baliq"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("cá nóc"),
            keywords: &["cá", "cá nóc"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("bun fokkin"),
            keywords: &["bun fokkin", "jën"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-blowfish"),
            keywords: &["i-blowfish", "intlanzi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ẹja Awura"),
            keywords: &["Ẹja", "Ẹja Awura"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("雞泡魚"),
            keywords: &["雞泡魚", "魚"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("鸡泡鱼"),
            keywords: &["鱼", "鸡泡鱼"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("河豚"),
            keywords: &["河豚", "鱼"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("河豚"),
            keywords: &["河豚", "魚"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("inhlanzi efuthekile"),
            keywords: &["inhlanzi", "inhlanzi efuthekile"],
        },
    ],
};
#[doc = "🦈"]
pub const SHARK: crate::Emoji = crate::Emoji {
    glyph: "🦈",
    codepoint: "1F988",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "shark",
    group: "Animals & Nature",
    subgroup: "animal-marine",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("haai"),
            keywords: &["haai", "vis"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሻርክ"),
            keywords: &["ሻርክ", "አሣ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سمكة قرش"),
            keywords: &["سمكة قرش", "قرش"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("শ\u{9cd}ব\u{9be}ৰ\u{9cd}ক"),
            keywords: &["ম\u{9be}ছ", "শ\u{9cd}ব\u{9be}ৰ\u{9cd}ক"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("akula"),
            keywords: &["akula", "balıq", "yırtıcı"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("акула"),
            keywords: &["акула", "рыба"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("акула"),
            keywords: &["акула", "риба"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("হ\u{9be}ঙ\u{9cd}গর"),
            keywords: &["ম\u{9be}ছ", "হ\u{9be}ঙ\u{9cd}গর"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("rinkin"),
            keywords: &["pesk", "rinkin"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("ajkula"),
            keywords: &["ajkula", "riba"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("tauró"),
            keywords: &["animal", "peix", "tauró"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄦𑄋\u{1112e}𑄢\u{11134} 𑄟𑄌\u{11134}"),
            keywords: &["𑄦𑄋\u{1112e}𑄢\u{11134} 𑄟𑄌\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᎧᏳᎦ"),
            keywords: &["ᎠᏣᏗ", "ᏗᎧᏳᎦ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("žralok"),
            keywords: &["ryba", "žralok"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("siarc"),
            keywords: &["pysgodyn", "siarc"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("haj"),
            keywords: &["dyr", "fisk", "haj"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Hai"),
            keywords: &["Hai", "Haifisch"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("καρχαρίας"),
            keywords: &["καρχαρίας", "ψάρι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("shark"),
            keywords: &["fish", "shark"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("tiburón"),
            keywords: &["pez", "tiburón"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["animal", "pez", "tiburón"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("hai"),
            keywords: &["hai", "kala"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("marrazoa"),
            keywords: &["arrain", "marrazo", "marrazoa"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کوسه"),
            keywords: &["ماهی", "کوسه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("hai"),
            keywords: &["hai", "kala"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pating"),
            keywords: &["isda", "pating"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("hávur"),
            keywords: &["dýr", "hávur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("requin"),
            keywords: &["animal", "poisson", "requin"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("siorc"),
            keywords: &["iasc", "siorc"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cearban"),
            keywords: &["cearban", "iasg", "siorc"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("tiburón"),
            keywords: &["animal", "escualo", "peixe", "quenlla", "tiburón"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("શાર\u{acd}ક"),
            keywords: &["માછલી", "શાર\u{acd}ક"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kifin shark"),
            keywords: &["kifi", "kifin shark"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("כריש"),
            keywords: &["דג", "כריש"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("शार\u{94d}क"),
            keywords: &["मछली", "शार\u{94d}क"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("morski pas"),
            keywords: &["morski pas", "riba"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("cápa"),
            keywords: &["cápa", "hal"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("շնաձուկ"),
            keywords: &["ձուկ", "շնաձուկ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("hiu"),
            keywords: &["hiu", "ikan"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("Nnukwu azụ"),
            keywords: &["Nnukwu azụ", "azụ", "nnukwu"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hákarl"),
            keywords: &["fiskur", "hákarl", "sjávardýr"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("squalo"),
            keywords: &["aggressività", "animale", "pesce", "squalo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("サメ"),
            keywords: &["サメ", "動物", "魚"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("hiu"),
            keywords: &["hiu", "iwak"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ზვიგენი"),
            keywords: &["ზვიგენი", "თევზი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("акула"),
            keywords: &["акула", "балық"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("haj"),
            keywords: &["dyr", "fisk", "haj"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ត\u{17d2}រ\u{17b8}ឆ\u{17d2}លាម"),
            keywords: &["ត\u{17d2}រ\u{17b8}", "ត\u{17d2}រ\u{17b8}ឆ\u{17d2}លាម"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಶಾರ\u{ccd}ಕ\u{ccd}"),
            keywords: &["ಮೀನು", "ಶಾರ\u{ccd}ಕ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("상어"),
            keywords: &["바다생물", "상어", "어류"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("मोरी"),
            keywords: &["न\u{941}स\u{94d}त\u{947}\u{902}", "मोरी", "शार\u{94d}क"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("акула"),
            keywords: &["акула", "балык"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Hai"),
            keywords: &["Fësch", "Hai"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ສະຫ\u{ebc}າມ"),
            keywords: &["ປາ", "ສະຫ\u{ebc}າມ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("ryklys"),
            keywords: &["ryklys", "žuvis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("haizivs"),
            keywords: &["haizivs", "zivs"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("mangō"),
            keywords: &["ika", "mangō"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("ајкула"),
            keywords: &["ајкула", "риба"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("സ\u{d4d}ര\u{d3e}വ\u{d4d}"),
            keywords: &["മൽസ\u{d4d}യം", "സ\u{d4d}ര\u{d3e}വ\u{d4d}"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("акул"),
            keywords: &["акул", "загас"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("शार\u{94d}क"),
            keywords: &["मासा", "शार\u{94d}क"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("jerung"),
            keywords: &["ikan", "jerung"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("kelb il-baħar"),
            keywords: &["kelb il-baħar", "ħut"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ငါးမန\u{103a}း"),
            keywords: &["ငါး", "ငါးမန\u{103a}း"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("hai"),
            keywords: &["fisk", "hai"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("शार\u{94d}क माछा"),
            keywords: &["माछा", "शार\u{94d}क"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("haai"),
            keywords: &["haai", "vis"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("hai"),
            keywords: &["fisk", "hai"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଶ\u{b3e}ର\u{b4d}କ\u{b4d}\u{200c}"),
            keywords: &[
                "ଶ\u{b3e}ର\u{b4d}କ\u{b4d}\u{200c}",
                "ଶ\u{b3e}ର\u{b4d}କ\u{b4d}\u{200c} । ମ\u{b3e}ଛ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸ\u{a3c}ਾਰਕ"),
            keywords: &["ਮ\u{a71}ਛੀ", "ਸ\u{a3c}ਾਰਕ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("شارک"),
            keywords: &["شارک", "مچھی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Shak"),
            keywords: &["Fish", "Shak"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("rekin"),
            keywords: &["rekin", "ryba"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("شارک"),
            keywords: &["شارک", "کب شارک"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("tubarão"),
            keywords: &["peixe", "tubarão"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("tiburon"),
            keywords: &["challwa", "tiburon"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("rechin"),
            keywords: &["pește", "rechin"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1104"),
            keywords: &["E10-1104"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("акула"),
            keywords: &["акула", "рыба"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("roke"),
            keywords: &["ifi", "igifi ndyanyama", "roke"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("شارڪ"),
            keywords: &["شارڪ", "شارڪ، مڇي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("මෝර\u{dcf}"),
            keywords: &["ම\u{dcf}ළ\u{dd4}ව\u{dcf}", "මෝර\u{dcf}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("žralok"),
            keywords: &["ryba", "žralok"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("morski pes"),
            keywords: &["morski pes", "riba"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("kalluun libaax"),
            keywords: &["kalluun", "kalluun libaax"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("peshkaqen"),
            keywords: &["peshk", "peshkaqen"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("ајкула"),
            keywords: &["ајкула", "риба"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("ajkula"),
            keywords: &["ajkula", "riba"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("haj"),
            keywords: &["fisk", "haj"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("papa"),
            keywords: &["papa", "samaki"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சுற\u{bbe}"),
            keywords: &["சுற\u{bbe}", "ம\u{bc0}ன\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("స\u{c4a}రచ\u{c47}ప"),
            keywords: &["చ\u{c47}ప", "స\u{c4a}రచ\u{c47}ప"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("кӯсамоҳӣ"),
            keywords: &["кӯсамоҳӣ", "моҳӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ฉลาม"),
            keywords: &["ฉลาม", "ปลา"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("akula"),
            keywords: &["akula", "balyk"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ʻanga"),
            keywords: &["ʻanga"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("köpek balığı"),
            keywords: &["balık", "köpek balığı"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("لەھەڭ"),
            keywords: &["بېلىق", "لەھەڭ"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("акула"),
            keywords: &["акула", "риба"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("شارک"),
            keywords: &["شارک", "مچھلی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("akula"),
            keywords: &["akula", "baliq"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("cá mập"),
            keywords: &["cá", "cá mập"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("rekeŋ"),
            keywords: &["jën", "rekeŋ"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ukrebe"),
            keywords: &["intlanzi", "ukrebe"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ṣáàkì"),
            keywords: &["Ṣáàkì", "ṣáàkì", "ẹja"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("鯊魚"),
            keywords: &["魚", "鯊魚"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("鲨鱼"),
            keywords: &["鱼", "鲨鱼"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("鲨鱼"),
            keywords: &["鱼", "鲨", "鲨鱼"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("鯊魚"),
            keywords: &["魚", "鯊魚"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["鯊", "鯊魚"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ushaka"),
            keywords: &["ufishi", "ushaka"],
        },
    ],
};
#[doc = "🐙"]
pub const OCTOPUS: crate::Emoji = crate::Emoji {
    glyph: "🐙",
    codepoint: "1F419",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "octopus",
    group: "Animals & Nature",
    subgroup: "animal-marine",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("seekat"),
            keywords: &["seekat"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ኦክቶፐስ"),
            keywords: &["ኦክቶፐስ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("أخطبوط"),
            keywords: &["أخطبوط", "حيوان"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("অক\u{9cd}টোপ\u{9be}ছ"),
            keywords: &["অক\u{9cd}টোপ\u{9be}ছ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("osminoq"),
            keywords: &["osminoq"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("васьміног"),
            keywords: &["васьміног"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("октопод"),
            keywords: &["октопод"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("অক\u{9cd}টোপ\u{9be}স"),
            keywords: &["অক\u{9cd}টোপ\u{9be}স"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("morgazh"),
            keywords: &["loen", "morgazh"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("hobotnica"),
            keywords: &["hobotnica"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("pop"),
            keywords: &["pop"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄃\u{11127}𑄇\u{11134}𑄑\u{1112e}𑄛𑄌\u{11134}"),
            keywords: &["𑄃\u{11127}𑄇\u{11134}𑄑\u{1112e}𑄛𑄌\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏓᏢᎢ"),
            keywords: &["ᎠᏓᏢᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("chobotnice"),
            keywords: &[
                "chobotnice",
                "chobotnička",
                "hlavonožec",
                "krakatice",
                "měkkýš",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("octopws"),
            keywords: &["octopws"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("blæksprutte"),
            keywords: &["blæksprutte", "dyr"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Oktopus"),
            keywords: &["Krake", "Oktopus", "Tier", "Tintenfisch"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("χταπόδι"),
            keywords: &["χταπόδι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("octopus"),
            keywords: &["octopus"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("pulpo"),
            keywords: &["cefalópodo", "octópodo", "pulpo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["animal", "pulpo", "tentáculos"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kaheksajalg"),
            keywords: &["kaheksajalg"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("olagarroa"),
            keywords: &["olagarro", "olagarroa"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("هشت\u{200c}پا"),
            keywords: &["اختاپوس", "هشت\u{200c}پا"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("mustekala"),
            keywords: &["mustekala"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pugita"),
            keywords: &["hayop", "lamang-dagat", "octopus", "pugita"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("høgguslokkur við átta ørmum"),
            keywords: &[
                "dýr",
                "høgguslokkur",
                "høgguslokkur við átta ørmum",
                "áttaarmaður",
                "áttermdur",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("pieuvre"),
            keywords: &["animal", "mollusque", "pieuvre"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["pieuvre"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("ochtapas"),
            keywords: &["ochtapas"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("ochd-chasach"),
            keywords: &["ochd-chasach"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("polbo"),
            keywords: &["polbo", "tentáculos"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ઓક\u{acd}ટોપસ"),
            keywords: &["ઓક\u{acd}ટોપસ", "પ\u{acd}રાણી"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("dabbar octopus"),
            keywords: &["dabbar octopus"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("תמנון"),
            keywords: &["תמנון"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ऑक\u{94d}टोपस"),
            keywords: &["ऑक\u{94d}टोपस", "पश\u{941}"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("hobotnica"),
            keywords: &["hobotnica"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("polip"),
            keywords: &["oktopusz", "polip"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ութոտնուկ"),
            keywords: &["ութոտնուկ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("gurita"),
            keywords: &["gurita"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("anụ mmiri"),
            keywords: &["anụ mmiri"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kolkrabbi"),
            keywords: &["kolkrabbi"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("polpo"),
            keywords: &["animale", "polpo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("タコ"),
            keywords: &["タコ", "動物"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("gurita"),
            keywords: &["gurita"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("რვაფეხა"),
            keywords: &["რვაფეხა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("сегізаяқ"),
            keywords: &["сегізаяқ"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("blæksprutte"),
            keywords: &["blæksprutte", "dyr"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17b9}ក"),
            keywords: &["ម\u{17b9}ក"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಆಕ\u{ccd}ಟೋಪಸ\u{ccd}"),
            keywords: &["ಆಕ\u{ccd}ಟೋಪಸ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("문어"),
            keywords: &["동물", "문어", "점쟁이", "페드로"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ऑक\u{94d}टोपस"),
            keywords: &["ऑक\u{94d}टोपस"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("сегиз бут"),
            keywords: &["осьминог", "сегиз бут"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Tëntefësch"),
            keywords: &["Tëntefësch"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ປາມ\u{eb6}ກ"),
            keywords: &["ປາມ\u{eb6}ກ", "ສ\u{eb1}ດ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("aštuonkojis"),
            keywords: &["aštuonkojis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("astoņkājis"),
            keywords: &["astoņkājis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("wheke"),
            keywords: &["wheke"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("октопод"),
            keywords: &["октопод"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("നീര\u{d3e}ളി"),
            keywords: &["നീര\u{d3e}ളി"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("наймаалж"),
            keywords: &["наймаалж"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ऑक\u{94d}टोपस"),
            keywords: &["ऑक\u{94d}टोपस"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("sotong kurita"),
            keywords: &["sotong", "sotong kurita"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("qarnita"),
            keywords: &["qarnita"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဘဝ\u{1032}"),
            keywords: &[
                "ဘဝ\u{1032}",
                "ဘဝ\u{103e}\u{1032} ရဘဝ\u{103e}ေ\u{1032} ဘဝ\u{103e}\u{1032} ဘဝ\u{103d}\u{1032} ဘဝြ\u{1032} ဘဝ\u{1032}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("blekksprut"),
            keywords: &["blekksprut", "bløtdyr", "dyr"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("अक\u{94d}टोपस"),
            keywords: &["अक\u{94d}टोपस"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("octopus"),
            keywords: &["octopus"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("blekksprut"),
            keywords: &["blautdyr", "blekksprut", "dyr"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଅକ\u{b4d}ଟୋପସ\u{b4d}\u{200c}"),
            keywords: &["ଅକ\u{b4d}ଟୋପସ\u{b4d}\u{200c}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਆਕਟ\u{a4b}ਪਸ"),
            keywords: &["ਆਕਟ\u{a4b}ਪਸ", "ਜਾਨਵਰ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("اکٹوپس"),
            keywords: &["اکٹوپس"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Wọ\u{301}n Wọtá Kríchọ Wé Im Nem Na Ọ\u{301}ktọ\u{301}pọs"),
            keywords: &[
                "Wọ\u{301}n Kríchọ Wé De Lív Fọ Wọtá An Wé Im Nem Na Ọ\u{301}ktọ\u{301}pọs",
                "Wọ\u{301}n Wọtá Kríchọ Wé Im Nem Na Ọ\u{301}ktọ\u{301}pọs",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("ośmiornica"),
            keywords: &["ośmiornica"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("اکتوپس"),
            keywords: &["اکتوپس"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("polvo"),
            keywords: &["animal", "polvo"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["polvo"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("pulpo"),
            keywords: &["pulpo"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("caracatiță"),
            keywords: &["caracatiță", "tentacule"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-470"),
            keywords: &["E10-470"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("осьминог"),
            keywords: &["осьминог", "щупальца"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("igikoko cyo mumazi"),
            keywords: &["igikoko cyo mumazi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪيڪڙو"),
            keywords: &["ڪيڪڙو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("බ\u{dd6}වල\u{dca}ල\u{dcf}"),
            keywords: &["බ\u{dd6}වල\u{dca}ල\u{dcf}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("chobotnica"),
            keywords: &["chobotnica"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("hobotnica"),
            keywords: &["hobotnica"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("farammugo"),
            keywords: &["farammugo"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("oktapod"),
            keywords: &["oktapod"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("октопод"),
            keywords: &["октопод", "хoбoтницa"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["октопод"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("oktopod"),
            keywords: &["hobotnica", "oktopod"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["oktopod"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("bläckfisk"),
            keywords: &["bläckfisk", "djur"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("pweza"),
            keywords: &["pweza"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஆக\u{bcd}டோபஸ\u{bcd}"),
            keywords: &[
                "ஆக\u{bcd}டோபஸ\u{bcd}",
                "பேய\u{bcd}க\u{bcd}கணவ\u{bbe}ய\u{bcd}",
                "விலங\u{bcd}கு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఆక\u{c4d}ట\u{c4b}పస\u{c4d}"),
            keywords: &[
                "ఆక\u{c4d}ట\u{c4b}పస\u{c4d}",
                "ఎన\u{c3f}మ\u{c3f}ద\u{c3f} క\u{c3e}ళ\u{c4d}ల సముద\u{c4d}ర జంతువు",
                "జంతువు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ҳаштпо"),
            keywords: &["ҳаштпо"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ปลาหม\u{e36}กย\u{e31}กษ\u{e4c}"),
            keywords: &[
                "ปลาหม\u{e36}ก",
                "ปลาหม\u{e36}กย\u{e31}กษ\u{e4c}",
                "ส\u{e31}ตว\u{e4c}",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("osminog"),
            keywords: &["osminog"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("feke"),
            keywords: &["feke"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("ahtapot"),
            keywords: &["ahtapot", "hayvan"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("سەككىز ئاياغ"),
            keywords: &["سەككىز ئاياغ"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("восьминіг"),
            keywords: &["восьминіг"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("آکٹوپس"),
            keywords: &["آکٹوپس", "جانور"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("sakkizoyoq"),
            keywords: &["sakkizoyoq"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bạch tuộc"),
            keywords: &["bạch tuộc"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("oktopis"),
            keywords: &["oktopis"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ingwane"),
            keywords: &["ingwane"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ẹja ẹlẹsẹ mẹjọ"),
            keywords: &["Ẹja ẹlẹsẹ mẹjọ"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("章魚"),
            keywords: &["章魚"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("章鱼"),
            keywords: &["章鱼"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("章鱼"),
            keywords: &["八爪", "章鱼", "鱼"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("章魚"),
            keywords: &["八爪魚", "章魚"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("i-okthophasi"),
            keywords: &["i-okthophasi"],
        },
    ],
};
#[doc = "🐚"]
pub const SPIRAL_SHELL: crate::Emoji = crate::Emoji {
    glyph: "🐚",
    codepoint: "1F41A",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "spiral shell",
    group: "Animals & Nature",
    subgroup: "animal-marine",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("spiraalskulp"),
            keywords: &["skulp", "spiraal", "spiraalskulp"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሽብልል የቀንድ አውጣ ሼል"),
            keywords: &["ሺል", "ሽብልል የቀንድ አውጣ ሼል", "ጥቅልል"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}صدفة حلزونية"),
            keywords: &["حيوان", "\u{202b}صدفة حلزونية"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("শ\u{9be}ম\u{9c1}কৰ খোল\u{9be}"),
            keywords: &[
                "খোল\u{9be}",
                "শ\u{9be}ম\u{9c1}ক",
                "শ\u{9be}ম\u{9c1}কৰ খোল\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("spiral balıqqulağı"),
            keywords: &["balıqqulağı", "spiral"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("спіральная ракушка"),
            keywords: &["ракушка", "спіраль", "спіральная ракушка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Спирална раковина"),
            keywords: &["Спирална раковина", "раковина"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ঝিন\u{9c1}কের খোলস"),
            keywords: &["ঝিন\u{9c1}ক", "ঝিন\u{9c1}কের খোলস", "সর\u{9cd}পিল"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("krogenn droellennek"),
            keywords: &["krogenn", "krogenn droellennek", "troellenn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("spiralna školjka"),
            keywords: &["spirala", "spiralna školjka", "školjka"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cargol de mar"),
            keywords: &["cargol", "cargol de mar", "mar"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏕᏲᎯ ᎠᏯᏍᎦᎸᎢ"),
            keywords: &["ᎠᏕᏲᎯ", "ᎠᏯᏍᎦᎸᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("ulita"),
            keywords: &["lastura", "mušle", "spirála", "ulita", "škeble"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cragen droellog"),
            keywords: &["cragen", "cragen droellog", "troellog"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("konkylie"),
            keywords: &["dyr", "konkylie"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Schneckenhaus"),
            keywords: &["Muschel", "Schneckenhaus", "Tier"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σπειροειδές κοχύλι"),
            keywords: &["κοχύλι", "σπειροειδές"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("spiral shell"),
            keywords: &["shell", "spiral"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("concha de mar"),
            keywords: &["animal", "concha", "concha de mar"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("caracola marina"),
            keywords: &["animal", "caracol", "caracola", "caracola marina", "marino"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("caracol marino"),
            keywords: &["caracol marino"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("caracola marina"),
            keywords: &["caracola marina"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("spiraalne teokarp"),
            keywords: &["karp", "spiraalne", "spiraalne teokarp"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("oskol espirala"),
            keywords: &["eskola", "espirala", "oskol espirala"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("صدف مارپیچی"),
            keywords: &["صدف", "صدف مارپیچی", "مارپیچ"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kotilo"),
            keywords: &["kotilo", "kuori"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pilipit na kabibe"),
            keywords: &["hayop", "kabibe", "lamang-dagat", "pilipit na kabibe"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("skel"),
            keywords: &["skel", "sniglahús", "snyril"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("coquille en spirale"),
            keywords: &["coquille", "coquille en spirale", "spirale"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["coquille", "coquille en spirale", "spirale"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("sliogán"),
            keywords: &["bís", "sliogán"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("slige shnìomhanach"),
            keywords: &["slige", "slige shnìomhanach", "snìomh", "snìomhanach"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("bucina mariña"),
            keywords: &["bucina", "bucina mariña", "bucio", "buguina", "corno"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સર\u{acd}પાકાર શ\u{ac7}લ"),
            keywords: &["પ\u{acd}રાણી", "શ\u{ac7}લ", "સર\u{acd}પાકાર શ\u{ac7}લ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("lanƙwasasshen ƙumba"),
            keywords: &["lanƙwasasshe", "lanƙwasasshen ƙumba", "ƙumba"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("צדף מסולסל"),
            keywords: &["מסולסל", "צדף"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("गोल श\u{902}ख"),
            keywords: &["गोल श\u{902}ख", "पश\u{941}", "श\u{902}ख"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("spiralna školjka"),
            keywords: &["spirala", "spiralna školjka", "školja"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("tengeri csiga"),
            keywords: &["kagyló", "spirális", "tengeri csiga"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("պարուրաձև խխունջախեցի"),
            keywords: &["խխունջ", "պարույր", "պարուրաձև խխունջախեցի"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("cangkang spiral"),
            keywords: &["cangkang", "spiral"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("okpokoro okirikiri"),
            keywords: &["okirikiri", "okpokoro"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kuðungur"),
            keywords: &["kuðungur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("conchiglia"),
            keywords: &["animale", "conchiglia", "conchiglia a spirale"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("巻き貝"),
            keywords: &["動物", "巻き貝", "貝"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("keong spiral"),
            keywords: &["keong", "spiral"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სპირალური ნიჟარა"),
            keywords: &["ნიჟარა", "სპირალური"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("шиыршықты бақалшық"),
            keywords: &["бақалшық", "шиыршықты"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("konkylie"),
            keywords: &["dyr", "konkylie"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សម\u{17d2}បកខ\u{17d2}យង"),
            keywords: &["រាងគ\u{17bc}ថខ\u{17d2}យង", "សម\u{17d2}បកខ\u{17d2}យង"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸ\u{ccd}ಪೈರಲ\u{ccd} ಶ\u{cc6}ಲ\u{ccd}"),
            keywords: &[
                "ಶ\u{cc6}ಲ\u{ccd}",
                "ಸುರುಳ\u{cbf}ಯಾಕಾರದ ಶ\u{cc6}ಲ\u{ccd}",
                "ಸ\u{ccd}ಪೈರಲ\u{ccd} ಶ\u{cc6}ಲ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("달팽이집"),
            keywords: &["달팽이 껍질", "달팽이집", "동물"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("चक\u{94d}राकार श\u{902}ख"),
            keywords: &["चक\u{94d}राकार", "श\u{902}ख"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("үлүл кабыгы"),
            keywords: &["кабык", "үлүл", "үлүл кабыгы"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Spiralmuschel"),
            keywords: &["Muschel", "Spiral", "Spiralmuschel"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຫ\u{ec9}ອຍ"),
            keywords: &["ສ\u{eb1}ດ", "ຫອຍ", "ຫ\u{ec9}ອຍ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("susisukusi kriauklė"),
            keywords: &["kriauklė", "spiralė", "susisukusi kriauklė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("gliemežvāks"),
            keywords: &["gliemežvāks", "spirāle"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("anga tōrino"),
            keywords: &["anga", "tōrino"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("спирална школка"),
            keywords: &["спирала", "спирална школка", "школка"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ചിപ\u{d4d}പി"),
            keywords: &["കക\u{d4d}ക", "ചിപ\u{d4d}പി", "ശംഖ\u{d4d}", "ഷെൽ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("дунгийн хясаа"),
            keywords: &["дун", "дунгийн хясаа", "хясаа"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("नागमोडी श\u{902}ख"),
            keywords: &["नागमोडी", "नागमोडी श\u{902}ख", "शि\u{902}पला"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kulit kerang berpilin"),
            keywords: &["berpilin", "kulit kerang", "kulit kerang berpilin"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("qoxra spirali"),
            keywords: &["qoxra", "spirali"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ခရ\u{102f}ခ\u{103d}\u{1036}"),
            keywords: &[
                "ကြောင\u{103a}လ\u{102d}မ\u{103a}",
                "ခရ\u{102f}ခ\u{103d}\u{1036}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("spiralskjell"),
            keywords: &["dyr", "skjell", "spiralskjell"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{94d}पाइरल स\u{947}ल"),
            keywords: &["स\u{947}ल", "स\u{94d}पाइरल स\u{947}ल", "स\u{94d}पिरल"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("schelp"),
            keywords: &["schelp", "spiraal"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("spiralskjel"),
            keywords: &["dyr", "skjel", "spiralskjel"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କ\u{b41}ଣ\u{b4d}ଡଳ\u{b3e}କ\u{b3e}ର ଶ\u{b3e}ମ\u{b41}କ\u{b3e}"),
            keywords: &[
                "କ\u{b41}ଣ\u{b4d}ଡଳ\u{b3e}କ\u{b3e}ର ଶ\u{b3e}ମ\u{b41}କ\u{b3e}",
                "କ\u{b41}ଣ\u{b4d}ଡଳ\u{b3f}ତ",
                "ଖୋଳପ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਚ\u{a42}ੜੀਦਾਰ ਘ\u{a4b}ਗਾ"),
            keywords: &["ਘ\u{a4b}ਗਾ", "ਚ\u{a42}ੜੀਦਾਰ ਘ\u{a4b}ਗਾ", "ਜਾਨਵਰ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("مرغولے دی شکل آلا شیل"),
            keywords: &["خول", "مرغولے دار", "مرغولے دی شکل آلا شیل"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Snel Shẹl"),
            keywords: &["Raund", "Shẹl", "Snel Shẹl"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("muszla spiralna"),
            keywords: &["muszelka", "muszla spiralna", "spirala"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ګول سيپۍ"),
            keywords: &["ګول سيپۍ", "ګول، سيپۍ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("caramujo"),
            keywords: &["animal", "caramujo"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("búzio"),
            keywords: &["búzio", "concha", "espiral"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("chʼuru"),
            keywords: &["chʼuru", "ch’uru", "muyuq"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("cochilie spiralată"),
            keywords: &["cochilie", "cochilie spiralată", "spirală"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-471"),
            keywords: &["E10-471"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("раковина"),
            keywords: &["раковина", "ракушка", "спираль"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("igikonoshwa"),
            keywords: &["Igikonoshwa", "igikonoshwa"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ور وڪڙ واري ڪوڏي"),
            keywords: &["ور وڪڙ واري ڪوڏي", "ڪوڏي، ور وڪڙ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("සර\u{dca}ප\u{dd2}ල කට\u{dd4}ව"),
            keywords: &[
                "සර\u{dca}ප\u{dd2}ල කට\u{dd4}ව",
                "සර\u{dca}ප\u{dd2}ල\u{dcf}ක\u{dcf}ර",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("špirálovitá mušľa"),
            keywords: &["mušľa", "špirálovitá"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("spiralna školjka"),
            keywords: &["spiralna školjka", "spiralno", "školjka"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("xanjaleel wareegaya"),
            keywords: &["kor u wareegaya", "xanjaleel", "xanjaleel wareegaya"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("guaskë spirale"),
            keywords: &["guaskë", "spirale"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("спирална шкољка"),
            keywords: &["спирaлa", "спирална шкољка", "шкoљкa"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["спирална шкољка"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("spiralna školjka"),
            keywords: &["spirala", "spiralna školjka", "školjka"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["spiralna školjka"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("snäcka"),
            keywords: &["djur", "snäcka", "snäckskal"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kombe la mzunguko"),
            keywords: &["kombe", "kombe la mzunguko", "mzunguko"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சிப\u{bcd}பி"),
            keywords: &["சிப\u{bcd}பி", "விலங\u{bcd}கு"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("శంఖ\u{c3e}కృత\u{c3f} గవ\u{c4d}వ"),
            keywords: &[
                "గుల\u{c4d}ల",
                "జంతువు",
                "శంఖ\u{c3e}కృత\u{c3f} గవ\u{c4d}వ",
                "శంఖ\u{c3e}కృత\u{c3f} గుల\u{c4d}ల",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("садафи морпеч"),
            keywords: &["морпеч", "садаф", "садафи морпеч"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หอย"),
            keywords: &["ส\u{e31}ตว\u{e4c}", "หอย"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("spiral çaňňalak"),
            keywords: &["spiral", "çaňňalak"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("keleʻa"),
            keywords: &["keleʻa"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("deniz kabuğu"),
            keywords: &["deniz kabuğu", "hayvan", "spiral deniz kabuğu"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قۇلۇلە قېپى"),
            keywords: &["قاسراق", "قاپ", "قۇلۇلە قېپى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("морська мушля"),
            keywords: &["морська мушля", "мушля", "спіральний"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("مرغولے دار شیل"),
            keywords: &["جانور", "شیل", "مرغولے دار شیل"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("spiral qobiq"),
            keywords: &["qobiq", "spiral"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("vỏ xoắn ốc"),
            keywords: &["vỏ", "vỏ xoắn ốc", "xoắn ốc"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("xoru espiraal"),
            keywords: &["espiraal", "xor", "xoru espiraal"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iqokobhe elijikelezayo"),
            keywords: &["iqokobhe", "iqokobhe elijikelezayo", "ujikelezayo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Onikaraun Pinpin"),
            keywords: &["Ikarahun", "Onikaraun Pinpin", "àyíká"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("螺"),
            keywords: &["殼", "螺", "螺旋形"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("螺"),
            keywords: &["壳", "螺", "螺旋形"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("海螺"),
            keywords: &["海螺", "螺"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("海螺"),
            keywords: &["海螺", "貝殼"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("貝殼"),
            keywords: &["螺殼", "貝殼"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("igobolondo elizungezile"),
            keywords: &["igobolondo elizungezile", "ingobolondo", "okuzungezile"],
        },
    ],
};
