#[doc = "🐌"]
pub const SNAIL: crate::Emoji = crate::Emoji {
    glyph: "🐌",
    codepoint: "1F40C",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "snail",
    group: "Animals & Nature",
    subgroup: "animal-bug",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("slak"),
            keywords: &["slak"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ቀንድ አውጣ"),
            keywords: &["ቀንድ አውጣ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("حلزون"),
            keywords: &["حلزون", "حيوان", "قوقع"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("শ\u{9be}ম\u{9c1}ক"),
            keywords: &["শ\u{9be}ম\u{9c1}ক"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("ilbiz"),
            keywords: &["ilbiz"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("смоўж"),
            keywords: &["смоўж"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("охлюв"),
            keywords: &["охлюв"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("শ\u{9be}ম\u{9c1}ক"),
            keywords: &["শ\u{9be}ম\u{9c1}ক"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("maligorn"),
            keywords: &["loen", "maligorn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("puž"),
            keywords: &["puž"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cargol"),
            keywords: &["cargol"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄥𑄟\u{1112a}𑄇\u{11134}"),
            keywords: &["𑄥𑄟\u{1112a}𑄇\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎡᎳᏆ"),
            keywords: &["ᎡᎳᏆ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("hlemýžď"),
            keywords: &["hlemýžď", "šnek"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("malwoden"),
            keywords: &["malwoden"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("snegl"),
            keywords: &["dyr", "langsom", "snegl"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Schnecke"),
            keywords: &["Schnecke", "Tier"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σαλιγκάρι"),
            keywords: &["σαλίγκαρος", "σαλιγκάρι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("snail"),
            keywords: &["snail"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["mollusc", "snail"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("caracol"),
            keywords: &["caracol", "caracola", "molusco"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["animal", "babosa", "baboso", "caracol", "insecto"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("tigu"),
            keywords: &["tigu"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("barraskiloa"),
            keywords: &["barraskilo", "barraskiloa"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("حلزون"),
            keywords: &["حلزون", "لیسک"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("etana"),
            keywords: &["etana"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("kuhol"),
            keywords: &["hayop", "kuhol", "lamang-dagat", "snail", "suso"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("snigil"),
            keywords: &["snigil"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("escargot"),
            keywords: &["animal", "escargot"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["escargot"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("seilide"),
            keywords: &["seilide"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("seilcheag"),
            keywords: &["cramag", "gobhar-breac", "seilcheag"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("caracol"),
            keywords: &["caracol"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ગોકળગાય"),
            keywords: &["ગોકળગાય", "પ\u{acd}રાણી"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("dodon koɗi"),
            keywords: &["dodon koɗi"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("חלזון"),
            keywords: &["חלזון", "שבלול"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("घो\u{902}घा"),
            keywords: &["घो\u{902}घा", "पश\u{941}"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("puž"),
            keywords: &["puž"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("csiga"),
            keywords: &["csiga"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("խխունջ"),
            keywords: &["դանդաղաշարժ", "խեցի", "խխունջ", "տնակ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("siput"),
            keywords: &["keong", "siput"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ejù"),
            keywords: &["ejù"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("snigill"),
            keywords: &["snigill"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("lumaca"),
            keywords: &["animale", "lumaca"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("かたつむり"),
            keywords: &["かたつむり", "でんでん虫", "虫"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("bekicot"),
            keywords: &["bekicot"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ლოკოკინა"),
            keywords: &["ლოკოკინა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ұлу"),
            keywords: &["ұлу"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("snegl"),
            keywords: &["dyr", "snegl"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ខ\u{17d2}យង"),
            keywords: &["ខ\u{17d2}យង"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬಸವನ ಹುಳು"),
            keywords: &["ಬಸವನ ಹುಳು"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("달팽이"),
            keywords: &["곤충", "달팽이", "동물", "벌레"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("गोगलगाय"),
            keywords: &["गोगलगाय"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("үлүл"),
            keywords: &["үлүл"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Schleek"),
            keywords: &["Schleek"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຫອຍທາດ"),
            keywords: &["ສ\u{eb1}ດ", "ຫອຍທາດ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("sraigė"),
            keywords: &["sraigė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("gliemezis"),
            keywords: &["gliemezis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("hātaretare"),
            keywords: &["hātaretare"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("полжав"),
            keywords: &["полжав"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഒച\u{d4d}ച\u{d4d}"),
            keywords: &["ഒച\u{d4d}ച\u{d4d}", "പ\u{d4d}ര\u{d3e}ണി", "മ\u{d43}ഗം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("эмгэн хумс"),
            keywords: &["эмгэн хумс"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("गोगलगाय"),
            keywords: &["गोगलगाय"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("siput"),
            keywords: &["siput"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("bebbuxu"),
            keywords: &["bebbuxu"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ခရ\u{102f}"),
            keywords: &["ခရ\u{102f}"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("snegle"),
            keywords: &["dyr", "snegle"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("चिप\u{94d}ल\u{947}किरा"),
            keywords: &["चिप\u{94d}ल\u{947}किरा", "स\u{94d}न\u{947}ल"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("slak"),
            keywords: &["slak"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("snigel"),
            keywords: &["dyr", "snigel"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଗେଣ\u{b4d}ଡ\u{b3e}"),
            keywords: &["ଗେଣ\u{b4d}ଡ\u{b3e}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਘ\u{a4b}ਗਾ"),
            keywords: &["ਘ\u{a4b}ਗਾ", "ਜਾਨਵਰ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("گھونگا"),
            keywords: &["گھونگا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Snel"),
            keywords: &["Snel"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("ślimak"),
            keywords: &["ślimak"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("شاپېټی"),
            keywords: &["شاپېټی"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("caracol"),
            keywords: &["animal", "caracol"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["caracol", "caracoleta"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("churu"),
            keywords: &["churu"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("melc"),
            keywords: &["melc"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-457"),
            keywords: &["E10-457"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("улитка"),
            keywords: &["раковина", "улитка"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikinyamunjonjorerwa"),
            keywords: &["ikinyamunjonjorerwa"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("سيپي"),
            keywords: &["سيپي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ගොළ\u{dd4}බෙල\u{dca}ල\u{dcf}"),
            keywords: &["ගොළ\u{dd4}බෙල\u{dca}ල\u{dcf}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("slimák"),
            keywords: &["slimák"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("polž"),
            keywords: &["polž"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("dixiri qolof leh"),
            keywords: &["dixiri qolof leh"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kërmill"),
            keywords: &["kërmill"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("пуж"),
            keywords: &["пуж"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("puž"),
            keywords: &["puž"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("snigel"),
            keywords: &["djur", "snigel"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("konokono"),
            keywords: &["konokono"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("நத\u{bcd}தை"),
            keywords: &["நத\u{bcd}தை", "விலங\u{bcd}கு"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("నత\u{c4d}త"),
            keywords: &["జంతువు", "నత\u{c4d}త"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тӯқумшуллуқ"),
            keywords: &["тӯқумшуллуқ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หอยทาก"),
            keywords: &["ส\u{e31}ตว\u{e4c}", "หอยทาก"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ulitka"),
            keywords: &["ulitka"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ʻelili"),
            keywords: &["ʻelili"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("salyangoz"),
            keywords: &["salyangoz"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قۇلۇلە"),
            keywords: &["قۇلۇلە"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("равлик"),
            keywords: &["павлик-равлик", "петрик", "равлик", "слимак"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("گھونگھا"),
            keywords: &["جانور", "گھونگھا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("shilliqqurt"),
            keywords: &["shilliqqurt"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("ốc sên"),
            keywords: &["ốc sên"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("eskargoo"),
            keywords: &["eskargoo"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("inkumba"),
            keywords: &["inkumba"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ìgbín"),
            keywords: &["Ìgbín"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("蝸牛"),
            keywords: &["蝸牛"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("蜗牛"),
            keywords: &["蜗牛"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("蜗牛"),
            keywords: &["蜗牛"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("蝸牛"),
            keywords: &["蝸牛"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umnenke"),
            keywords: &["umnenke"],
        },
    ],
};
#[doc = "🦋"]
pub const BUTTERFLY: crate::Emoji = crate::Emoji {
    glyph: "🦋",
    codepoint: "1F98B",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "butterfly",
    group: "Animals & Nature",
    subgroup: "animal-bug",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("skoenlapper"),
            keywords: &["insek", "mooi", "skoenlapper"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ቢራቢሮ"),
            keywords: &["ቆንጆ", "ቢራቢሮ", "ነፍሳት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("فراشة"),
            keywords: &["جمال", "حشرة", "فراشة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("পখিল\u{9be}"),
            keywords: &["পখিল\u{9be}", "পোক", "মোহনীয\u{9bc}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kəpənək"),
            keywords: &["həşərat", "kəpənək", "uçan canlı"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("матылёк"),
            keywords: &["матылёк", "насякомае", "прыгожы"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("пеперуда"),
            keywords: &["красиво", "насекомо", "пеперуда"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("প\u{9cd}রজ\u{9be}পতি"),
            keywords: &["পতঙ\u{9cd}গ", "প\u{9cd}রজ\u{9be}পতি", "স\u{9c1}ন\u{9cd}দর"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("balafenn"),
            keywords: &["amprevan", "balafenn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("leptir"),
            keywords: &["insekt", "leptir", "ljepota"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("papallona"),
            keywords: &["animal", "insecte", "papallona"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄛𑄖\u{11133}𑄦\u{11134}𑄛\u{11127}𑄖\u{11134}\u{11128}"),
            keywords: &["𑄛𑄖\u{11133}𑄦\u{11134}𑄛\u{11127}𑄖\u{11134}\u{11128}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏍᏗ ᎧᎹᎹ"),
            keywords: &["ᎤᏍᏗ ᎧᎹᎹ", "ᎤᏬᏚᎯ", "ᎧᎹᎹ", "ᏥᏍᎪᏯ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("motýl"),
            keywords: &["hmyz", "krásný", "motýl"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("pili-pala"),
            keywords: &["pert", "pili-pala", "pryfyn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("sommerfugl"),
            keywords: &["dyr", "insekt", "sommer", "sommerfugl", "vinger"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Schmetterling"),
            keywords: &["Schmetterling", "schön"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πεταλούδα"),
            keywords: &["έντομο", "πεταλούδα", "όμορφος"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("butterfly"),
            keywords: &["butterfly", "insect", "pretty"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["butterfly", "insect", "moth"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("mariposa"),
            keywords: &["bonito", "insecto", "mariposa"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["bonita", "insecto", "mariposa"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["animal", "bonita", "insecto", "mariposa"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("liblikas"),
            keywords: &["ilus", "liblikas", "putukas"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("pinpilinpauxa"),
            keywords: &["intsektu", "pinpilinpauxa", "polit"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پروانه"),
            keywords: &["حشره", "زیبا", "عاشق", "پروانه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("perhonen"),
            keywords: &["hyönteinen", "perhonen", "sievä"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("paru-paro"),
            keywords: &["insekto", "maganda", "paru-paro"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("firvaldur"),
            keywords: &["firvaldur", "skordýr", "summarfuglur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("papillon"),
            keywords: &["insecte", "mignon", "papillon"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("féileacán"),
            keywords: &["feithid", "féileacán", "gleoite"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("dealan-dè"),
            keywords: &[
                "amadan-dè",
                "biastag",
                "bèisteag",
                "bòidheach",
                "dealan-dè",
                "dearbadan-dè",
                "fiolan",
                "meanbh-fhrìde",
                "àlainn",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("bolboreta"),
            keywords: &["animal", "bolboreta", "insecto"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("બટરફ\u{acd}લાઇ"),
            keywords: &["જ\u{a82}ત\u{ac1}", "બટરફ\u{acd}લાઇ", "સ\u{ac1}\u{a82}દર"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("malam-buɗe-mana-littafi"),
            keywords: &["kyakkyawa", "malam-buɗe-mana-littafi", "ƙwaro"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פרפר"),
            keywords: &["חרק", "יופי", "פרפר"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("तितली"),
            keywords: &["कीड\u{93c}ा", "तितली", "स\u{941}\u{902}दर"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("leptir"),
            keywords: &["insekt", "leptir", "ljepota"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("pillangó"),
            keywords: &["pillangó", "rovar", "szép"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("թիթեռ"),
            keywords: &["գեղեցիկ", "թիթեռ", "միջատ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kupu-kupu"),
            keywords: &["cantik", "kupu-kupu", "serangga"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("mbubara"),
            keywords: &["ahụhụ", "mara mma", "mbubara", "mbụbara"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("fiðrildi"),
            keywords: &["dýr", "fiðrildi", "skordýr"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("farfalla"),
            keywords: &["animale", "farfalla", "insetto"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("チョウ"),
            keywords: &["チョウ", "虫"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kupu"),
            keywords: &["endah", "kupu", "serangga"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("პეპელა"),
            keywords: &["ლამაზი", "მწერი", "პეპელა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("көбелек"),
            keywords: &["жәндік", "көбелек"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("sommerfugl"),
            keywords: &["dyr", "insekt", "sommer", "sommerfugl", "vinger"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("មេអ\u{17c6}បៅ"),
            keywords: &[
                "មេអ\u{17c6}បៅ",
                "សត\u{17d2}វល\u{17d2}អ\u{17b7}ត",
                "ស\u{17d2}អាត",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಚ\u{cbf}ಟ\u{ccd}ಟ\u{cc6}"),
            keywords: &["ಕೀಟ", "ಚಂದ", "ಚ\u{cbf}ಟ\u{ccd}ಟ\u{cc6}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("나비"),
            keywords: &["곤충", "나비", "날개"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("फ\u{941}लपाखर\u{941}\u{902}"),
            keywords: &["किटक", "फ\u{941}लपाखर\u{941}\u{902}", "स\u{941}\u{902}दर"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("көпөлөк"),
            keywords: &["курт-кумурска", "көпөлөк", "сулуулук"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Päiperlek"),
            keywords: &["Insekt", "Päiperlek", "schéin"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ແມງກະເບ\u{eb7}\u{ec9}ອ"),
            keywords: &[
                "ແມງກະເບ\u{eb7}\u{ec9}ອ",
                "ແມງໄມ\u{ec9}",
                "ໜ\u{ec9}າຮ\u{eb1}ກ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("drugelis"),
            keywords: &["drugelis", "gražus", "vabzdys"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("taurenis"),
            keywords: &["insekts", "skaists", "taurenis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pūrerehua"),
            keywords: &["pēpeke", "pūrerehua", "ātaahua"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("пеперутка"),
            keywords: &["инсект", "пеперутка", "убавина"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ചിത\u{d4d}രശലഭം"),
            keywords: &["ചിത\u{d4d}രശലഭം", "പ\u{d42}മ\u{d4d}പ\u{d3e}റ\u{d4d}റ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("эрвээхэй"),
            keywords: &["шавьж", "эрвээхэй"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("फ\u{941}लपाखर\u{942}"),
            keywords: &["किडा", "फ\u{941}लपाखर\u{942}", "स\u{941}\u{902}दर"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("rama-rama"),
            keywords: &["cantik", "rama-rama", "serangga"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("farfett"),
            keywords: &["farfett", "insett", "sabiħ"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လ\u{102d}ပ\u{103a}ပြာ"),
            keywords: &[
                "ချစ\u{103a}စဖ\u{103d}ယ\u{103a}",
                "ပ\u{102d}\u{102f}းမ\u{103d}\u{103e}ား",
                "လ\u{102d}ပ\u{103a}ပြာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("sommerfugl"),
            keywords: &["dyr", "insekt", "pen", "sommer", "sommerfugl"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("प\u{941}तली"),
            keywords: &["किरा", "प\u{941}तली", "राम\u{94d}रो"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("vlinder"),
            keywords: &["insect", "mooi", "vlinder"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("sommarfugl"),
            keywords: &["dyr", "insekt", "pen", "sommar", "sommarfugl"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପ\u{b4d}ରଜ\u{b3e}ପତ\u{b3f}"),
            keywords: &[
                "ପ\u{b4d}ରଜ\u{b3e}ପତ\u{b3f}",
                "ପ\u{b4d}ରଜ\u{b3e}ପତ\u{b3f} । କୀଟ । ସ\u{b41}ନ\u{b4d}ଦର",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਤਿਤਲੀ"),
            keywords: &["ਕੀੜਾ", "ਤਿਤਲੀ", "ਸ\u{a41}\u{a70}ਦਰ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("تتلی"),
            keywords: &["تتلی", "حشرات", "سوہنا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Bọtaflai"),
            keywords: &["Bọtaflai", "Bọtáflai", "Flai", "Ínsẹkt"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("motyl"),
            keywords: &["kolorowy", "motyl", "owad"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("کمبلۍ"),
            keywords: &["پتنګ", "پتنګ، حشره، ښايسته", "کمبلۍ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("borboleta"),
            keywords: &["beleza", "borboleta", "inseto"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["bonita", "borboleta", "insecto", "inseto"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("pillpintu"),
            keywords: &["ch’uspi", "k’acha", "pillpintu"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("fluture"),
            keywords: &["fluture", "frumos", "insectă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1107"),
            keywords: &["E10-1107"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("бабочка"),
            keywords: &["бабочка", "красота", "мотылек", "насекомое"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikinyugunyugu"),
            keywords: &["agakoko", "cyiza", "ikinyugunyugu"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("پوپٽ"),
            keywords: &["پوپٽ", "پوپٽ، جيت، خوبصورت"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("සමනළය\u{dcf}"),
            keywords: &[
                "කෘම\u{dd2}ය\u{dcf}",
                "සමනළය\u{dcf}",
                "ස\u{dd4}ර\u{dd4}බ\u{dd4}හ\u{dd4}ට\u{dd2}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("motýľ"),
            keywords: &["hmyz", "motýľ"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("metulj"),
            keywords: &["insekt", "lep", "metulj"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("balanbaalis"),
            keywords: &["balanbaalis", "cayayaan", "qurux badan"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("flutur"),
            keywords: &["e bukur", "flutur", "insekt"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("лептир"),
            keywords: &["инсект", "лепо", "лептир"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["лептир"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("leptir"),
            keywords: &["insekt", "lepo", "leptir"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["leptir"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("fjäril"),
            keywords: &["fjäril", "insekt", "sommar", "vacker"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kipepeo"),
            keywords: &["kipepeo", "maridadi", "mdudu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பட\u{bcd}ட\u{bbe}ம\u{bcd}பூச\u{bcd}சி"),
            keywords: &[
                "பட\u{bcd}ட\u{bbe}ம\u{bcd}பூச\u{bcd}சி",
                "பூச\u{bcd}சி",
                "வண\u{bcd}ணம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("స\u{c40}త\u{c3e}క\u{c4b}కచ\u{c3f}లుక"),
            keywords: &[
                "అందం",
                "క\u{c40}టకం",
                "స\u{c40}త\u{c3e}క\u{c4b}కచ\u{c3f}లుక",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("шапалак"),
            keywords: &["зебо", "шапалак", "ҳашарот"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ผ\u{e35}เส\u{e37}\u{e49}อ"),
            keywords: &["ผ\u{e35}เส\u{e37}\u{e49}อ", "สวย", "แมลง"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("kebelek"),
            keywords: &["enaýyja", "kebelek", "mör-möjek"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("pepe"),
            keywords: &["pepe"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kelebek"),
            keywords: &["böcek", "kelebek", "şirin"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("كېپىنەك"),
            keywords: &["قۇرت", "كېپىنەك", "چىرايلىق", "ھاشارات"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("метелик"),
            keywords: &["гарний", "комаха", "метелик"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("تتلی"),
            keywords: &["تتلی", "خوبصورت", "کیڑہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kapalak"),
            keywords: &["go‘zallik", "hasharot", "kapalak"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bướm"),
            keywords: &["bướm", "côn trùng", "đẹp"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("lëppaalëp"),
            keywords: &["gunóor", "lëppaalëp", "rafet"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ibhabhathane"),
            keywords: &["entle", "ibhabhathane", "isinambuzane"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Labalaba"),
            keywords: &["Labalaba", "arẹwà", "kòkòrò", "labalábá"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("蝴蝶"),
            keywords: &["昆蟲", "蝴蝶", "靚"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("蝴蝶"),
            keywords: &["昆虫", "蝴蝶", "靓"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("蝴蝶"),
            keywords: &["昆虫", "漂亮", "美丽", "蝴蝶"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("蝴蝶"),
            keywords: &["昆蟲", "美", "蝴蝶"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["藍色蝴蝶", "蝴蝶"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("uvemvane"),
            keywords: &["isinambuzane", "ubuhle", "uvemvane"],
        },
    ],
};
#[doc = "🐛"]
pub const BUG: crate::Emoji = crate::Emoji {
    glyph: "🐛",
    codepoint: "1F41B",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "bug",
    group: "Animals & Nature",
    subgroup: "animal-bug",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("gogga"),
            keywords: &["gogga", "insek", "ruspe"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ትኋን"),
            keywords: &["ትኋን", "ነፍሳት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("بق"),
            keywords: &["أم أربعة وأربعين", "بق", "يرقانة حيوان"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("পোক"),
            keywords: &["পতঙ\u{9cd}গ", "পোক"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("böcək"),
            keywords: &["böcək", "həşərat"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("кузурка"),
            keywords: &["кузурка", "насякомае"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("буболечка"),
            keywords: &["буболечка", "насекомо"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ক\u{9cd}ষ\u{9c1}দ\u{9cd}র কীট"),
            keywords: &["ক\u{9cd}ষ\u{9c1}দ\u{9cd}র কীট", "পোক\u{9be}"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("biskoulenn"),
            keywords: &["amprevan", "biskoulenn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("buba"),
            keywords: &["buba", "insekt"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("eruga"),
            keywords: &["eruga", "insecte"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄇\u{11127}𑄢\u{11127}𑄢\u{11134} 𑄛\u{1112a}𑄇\u{11134}"),
            keywords: &["𑄇\u{11127}𑄢\u{11127}𑄢\u{11134} 𑄛\u{1112a}𑄇\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏥᏍᎪᏯ"),
            keywords: &["ᏥᏍᎪᏯ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("housenka"),
            keywords: &["hmyz", "housenka"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("pryf"),
            keywords: &["chwilen", "pryf"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("larve"),
            keywords: &["dyr", "larve", "sommerfuglelarve", "tusindben"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Raupe"),
            keywords: &["Insekt", "Raupe", "Tier"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κάμπια"),
            keywords: &["έντομο", "κάμπια"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("bug"),
            keywords: &["bug", "insect"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("caterpillar"),
            keywords: &["bug", "caterpillar", "insect", "worm"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("insecto"),
            keywords: &["bicho", "gusano", "insecto"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("oruga"),
            keywords: &["animal", "insecto", "oruga"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("röövik"),
            keywords: &["putukas", "röövik"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("zomorroa"),
            keywords: &["intsektu", "zomorroa"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("حشره"),
            keywords: &["باگ", "حشره"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("ötökkä"),
            keywords: &["hyönteinen", "ötökkä"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("insekto"),
            keywords: &["bug", "insekto", "uod"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("skordýr"),
            keywords: &["skordýr"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("chenille"),
            keywords: &["animal", "chenille", "insecte"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["chenille", "insecte"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("míol"),
            keywords: &["feithid", "míol"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("biastag"),
            keywords: &["biastag", "bèisteag", "daolag", "fiolan", "meanbh-fhrìde"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cempés"),
            keywords: &["becho", "bicho", "cempés", "verme"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("જ\u{a82}ત\u{ac1}"),
            keywords: &["ઇયળ", "કાનખજ\u{ac2}રો", "જ\u{a82}ત\u{ac1}", "પ\u{acd}રાણી"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("ƙwaro"),
            keywords: &["ƙwaro"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("זחל"),
            keywords: &["זחל", "חרק"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("इल\u{94d}ली"),
            keywords: &["इल\u{94d}ली", "कनखज\u{942}रा", "कीड\u{93c}ा", "पश\u{941}"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("gusjenica"),
            keywords: &["gusjenica", "insekt"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("rovar"),
            keywords: &["bogár", "rovar"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("միջատ"),
            keywords: &["թրթուր", "միջատ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("serangga kecil"),
            keywords: &["serangga", "serangga kecil"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("Chinchi"),
            keywords: &["Chinchi", "ahụhụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("skordýr"),
            keywords: &["margfætla", "skordýr"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("insetto"),
            keywords: &["animale", "bruco", "insetto", "millepiedi"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("毛虫"),
            keywords: &["毛虫", "芋虫", "虫"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("uler"),
            keywords: &["serangga", "uler"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ბაღლინჯო"),
            keywords: &["ბაღლინჯო", "მწერი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жәндік"),
            keywords: &["жәндік", "шыбын-шіркей"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("larve"),
            keywords: &["dyr", "larve", "sommerfuglelarve", "tusindben"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សត\u{17d2}វល\u{17d2}អ\u{17b7}ត"),
            keywords: &["ដង\u{17d2}ក\u{17bc}វ", "សត\u{17d2}វល\u{17d2}អ\u{17b7}ត"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕೀಟ"),
            keywords: &["ಕೀಟ", "ಶತಪದ\u{cbf}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("송충이"),
            keywords: &["동물", "벌레", "송충이"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("भिक\u{942}ण"),
            keywords: &["किटक", "भिक\u{942}ण"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("курт"),
            keywords: &["курт", "курт-кумурска"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Kiewerlek"),
            keywords: &["Insekt", "Kiewerlek"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ແມງໄມ\u{ec9}"),
            keywords: &["ສ\u{eb1}ດ", "ແມງໄມ\u{ec9}"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("vabalas"),
            keywords: &["vabalas", "vabzdys"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("kukainis"),
            keywords: &["blakts", "kukainis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tātaka"),
            keywords: &["pēpeke", "tātaka"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("бубачка"),
            keywords: &["бубачка", "инсект"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പഴ\u{d41}ത\u{d3e}ര"),
            keywords: &["പഴ\u{d41}ത\u{d3e}ര", "പ\u{d4d}ര\u{d3e}ണി", "മ\u{d43}ഗം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хорхой"),
            keywords: &["хорхой", "шавж"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("अळी"),
            keywords: &["अळी", "किडा"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("ulat"),
            keywords: &["serangga", "ulat"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("insett"),
            keywords: &["insett"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပ\u{102d}\u{102f}းကောင\u{103a}ကလေး"),
            keywords: &[
                "ပ\u{102d}\u{102f}းကောင\u{103a}",
                "ပ\u{102d}\u{102f}းကောင\u{103a}ကလေး",
                "အင\u{103a}းဆက\u{103a}ပ\u{102d}\u{102f}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("insekt"),
            keywords: &["dyr", "insekt", "kryp", "larve", "åme"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("उड\u{941}स"),
            keywords: &["उड\u{941}स", "किरा"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("insect"),
            keywords: &["beestje", "insect"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("insekt"),
            keywords: &["dyr", "insekt", "kryp", "larve", "åme"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଓଡ\u{b3c}ଶ"),
            keywords: &["ଓଡ\u{b3c}ଶ", "କୀଟ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸ\u{a41}\u{a70}ਡੀ"),
            keywords: &["ਕ\u{a70}ਨਖਜ\u{a42}ਰਾ", "ਖਟਮਲ", "ਜਾਨਵਰ", "ਸ\u{a41}\u{a70}ਡੀ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کھٹمل"),
            keywords: &["حشرات", "کھٹمل"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Smọ\u{301}l Ínsẹkt"),
            keywords: &["Smọ\u{301}l Ínsẹkt", "Ínsẹkt"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("gąsienica"),
            keywords: &["gąsienica", "insekt", "owad"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سپږۍ"),
            keywords: &["سپږۍ", "شپږۍ، حشره"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("inseto"),
            keywords: &["animal", "centopeia", "inseto", "lagarta"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("lagarta"),
            keywords: &["bicho", "insecto", "inseto", "lagarta"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("khuru"),
            keywords: &["ch’uspi", "khuru"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("gândac"),
            keywords: &["gândac", "insectă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-472"),
            keywords: &["E10-472"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("гусеница"),
            keywords: &["гусеница", "насекомое"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("kemura ibibazo"),
            keywords: &["agakoko", "kemura ibibazo"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مونگهڻ"),
            keywords: &["جيت", "مونگهڻ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("මක\u{dd4}ණ\u{dcf}"),
            keywords: &["කෘම\u{dd2}ය\u{dcf}", "මක\u{dd4}ණ\u{dcf}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("húsenica"),
            keywords: &["hmyz", "húsenica"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("žuželka"),
            keywords: &["žuželka"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("kutaan"),
            keywords: &["cayayaan", "kutaan"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("shumëkëmbësh"),
            keywords: &["insekt", "shumëkëmbësh"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("гусеница"),
            keywords: &["гусеница", "инсeкт"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("гусјеница"),
            keywords: &["гусјеница"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("gusenica"),
            keywords: &["gusenica", "insekt"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("gusjenica"),
            keywords: &["gusjenica"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("tusenfoting"),
            keywords: &["djur", "kryp", "larv", "tusenfoting"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mdudu"),
            keywords: &["mdudu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மூட\u{bcd}டைப\u{bcd} பூச\u{bcd}சி"),
            keywords: &[
                "கம\u{bcd}பளிப\u{bcd}புழு",
                "பூர\u{bbe}ன\u{bcd}",
                "மூட\u{bcd}டைப\u{bcd} பூச\u{bcd}சி",
                "விலங\u{bcd}கு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("నల\u{c4d}ల\u{c3f}"),
            keywords: &[
                "క\u{c3e}ళ\u{c4d}లజర\u{c4d}ర\u{c3f}",
                "గ\u{c4a}ంగళ\u{c3f} పురుగు",
                "జంతువు",
                "నల\u{c4d}ల\u{c3f}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("гамбуск"),
            keywords: &["гамбуск", "ҳашарот"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("แมลง"),
            keywords: &["ส\u{e31}ตว\u{e4c}", "แมลง"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("mör-möjek"),
            keywords: &["mör-möjek", "mör-möjekler"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kutu"),
            keywords: &["kutu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("tırtıl"),
            keywords: &["böcek", "hayvan", "kırkayak", "tırtıl"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قۇرت"),
            keywords: &["قۇرت", "ھاشارات"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("комаха"),
            keywords: &["комаха", "комашина", "комашка"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کن کھجورا"),
            keywords: &["کن کھجورا", "کیڑا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("taxtakana"),
            keywords: &["taxtakana", "xasharot"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("con bọ"),
            keywords: &["con bọ", "côn trùng"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("gunóor"),
            keywords: &["gunóor", "gunóor bu sew"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("incukuthu"),
            keywords: &["incukuthu", "isinambuzane"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ìyanjú Àṣìṣe"),
            keywords: &["kòkòrò", "Ìyanjú Àṣìṣe"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("毛蟲"),
            keywords: &["昆蟲", "毛蟲", "蟲"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("毛虫"),
            keywords: &["昆虫", "毛虫"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("毛毛虫"),
            keywords: &["毛毛虫", "毛虫"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("毛毛蟲"),
            keywords: &["毛毛蟲", "毛蟲"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("毛蟲"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isilokozane"),
            keywords: &["isilokozane"],
        },
    ],
};
#[doc = "🐜"]
pub const ANT: crate::Emoji = crate::Emoji {
    glyph: "🐜",
    codepoint: "1F41C",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "ant",
    group: "Animals & Nature",
    subgroup: "animal-bug",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("mier"),
            keywords: &["insek", "mier"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ጉንዳን"),
            keywords: &["ነፍሳት", "ጉንዳን"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("نملة"),
            keywords: &["حيوان", "نملة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("পৰ\u{9c1}ৱ\u{9be}"),
            keywords: &["পোক", "পৰ\u{9c1}ৱ\u{9be}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qarışqa"),
            keywords: &["həşərat", "qarışqa"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("мураш"),
            keywords: &["мураш", "насякомае"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("мравка"),
            keywords: &["мравка", "насекомо"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("পিপড\u{9bc}ে"),
            keywords: &["পিপড\u{9bc}ে", "পোক\u{9be}"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("merienenn"),
            keywords: &["amprevan", "merienenn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("mrav"),
            keywords: &["insekt", "mrav"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("formiga"),
            keywords: &["formiga", "insecte"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏙᏒᏓᎵ"),
            keywords: &["ᏙᏒᏓᎵ", "ᏥᏍᎪᏯ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("mravenec"),
            keywords: &["hmyz", "mravenec"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("morgrugyn"),
            keywords: &["chwilen", "morgrugyn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("myre"),
            keywords: &["dyr", "myre"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Ameise"),
            keywords: &["Ameise", "Insekt", "Tier"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μυρμήγκι"),
            keywords: &["έντομο", "μυρμήγκι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("ant"),
            keywords: &["ant", "insect"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("hormiga"),
            keywords: &["antenas", "hormiga", "insecto"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["animal", "hormiga", "insecto"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["homiga", "hormiga", "insecto"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("sipelgas"),
            keywords: &["putukas", "sipelgas"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("inurria"),
            keywords: &["intsektu", "inurria"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("مورچه"),
            keywords: &["حشره", "ماهی", "مورچه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("muurahainen"),
            keywords: &["hyönteinen", "muurahainen"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("langgam"),
            keywords: &["insekto", "langgam"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("meyra"),
            keywords: &["meyra", "skordýr"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("fourmi"),
            keywords: &["animal", "fourmi", "insecte"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["fourmi", "insecte"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("seangán"),
            keywords: &["feithid", "seangán"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("seangan"),
            keywords: &["biastag", "bèisteag", "fiolan", "meanbh-fhrìde", "seangan"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("formiga"),
            keywords: &["formiga"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("કીડી"),
            keywords: &["કીડી", "પ\u{acd}રાણી"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("cinnaka"),
            keywords: &["cinnaka", "ƙwaro"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("נמלה"),
            keywords: &["חרק", "נמלה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ची\u{902}टी"),
            keywords: &["ची\u{902}टी", "पश\u{941}"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("mrav"),
            keywords: &["insekt", "mrav"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("hangya"),
            keywords: &["hangya", "rovar"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մրջյուն"),
            keywords: &["աշխատասեր", "միջատ", "մրջյուն"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("semut"),
            keywords: &["semut", "serangga"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("agbịsị"),
            keywords: &["agbịsị", "ahụhụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("maur"),
            keywords: &["maur", "skordýr"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("formica"),
            keywords: &["animale", "formica"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("アリ"),
            keywords: &["アリ", "虫"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("semut"),
            keywords: &["semut", "serangga"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ჭიანჭველა"),
            keywords: &["მწერი", "ჭიანჭველა"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("taweṭṭuft"),
            keywords: &["taweṭṭuft"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("құмырсқа"),
            keywords: &["шыбын-шіркей", "құмырсқа"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("myre"),
            keywords: &["dyr", "myre"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ស\u{17d2}រមោច"),
            keywords: &["សត\u{17d2}វល\u{17d2}អ\u{17b7}ត", "ស\u{17d2}រមោច"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಇರುವ\u{cc6}"),
            keywords: &["ಇರುವ\u{cc6}", "ಕೀಟ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("개미"),
            keywords: &["개미", "곤충", "벌레"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("म\u{942}य"),
            keywords: &["किटक", "म\u{942}य"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кумурска"),
            keywords: &["кумурска", "курт-кумурска"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Seejomes"),
            keywords: &["Insekt", "Seejomes"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ມ\u{ebb}ດ"),
            keywords: &["ມ\u{ebb}ດ", "ສ\u{eb1}ດ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("skruzdėlė"),
            keywords: &["skruzdėlė", "vabzdys"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("skudra"),
            keywords: &["kukainis", "skudra"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pōpokorua"),
            keywords: &["pēpeke", "pōpokorua"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("мравка"),
            keywords: &["инсект", "мравка"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഉറ\u{d41}മ\u{d4d}പ\u{d4d}"),
            keywords: &[
                "ഉറ\u{d41}മ\u{d4d}പ\u{d4d}",
                "പ\u{d4d}ര\u{d3e}ണി",
                "മ\u{d43}ഗം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("шоргоолж"),
            keywords: &["шавж", "шоргоолж"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("म\u{941}\u{902}गी"),
            keywords: &["किडा", "म\u{941}\u{902}गी"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("semut"),
            keywords: &["semut", "serangga"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("nemla"),
            keywords: &["insett", "nemla"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပ\u{102f}ရ\u{103d}က\u{103a}ဆ\u{102d}တ\u{103a}"),
            keywords: &[
                "ပ\u{102f}ရ\u{103d}က\u{103a}ဆ\u{102d}တ\u{103a}",
                "အင\u{103a}းဆက\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("maur"),
            keywords: &["dyr", "insekt", "maur"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("कमिला"),
            keywords: &["कमिला", "किरा"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("mier"),
            keywords: &["insect", "mier"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("maur"),
            keywords: &["dyr", "insekt", "maur"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପ\u{b3f}ମ\u{b4d}ପ\u{b41}ଡ\u{b3c}\u{b3f}"),
            keywords: &["କୀଟ", "ପ\u{b3f}ମ\u{b4d}ପ\u{b41}ଡ\u{b3c}\u{b3f}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕੀੜੀ"),
            keywords: &["ਕੀੜੀ", "ਜਾਨਵਰ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کیڑی"),
            keywords: &["حشرات", "کیڑی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Ant"),
            keywords: &["Ant", "Ínsẹkt"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("mrówka"),
            keywords: &["insekt", "mrówka", "owad"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ميږی"),
            keywords: &["ميږی", "ميږی، حشره"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("formiga"),
            keywords: &["formiga", "inseto"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["formiga", "insecto", "inseto"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("sikʼimira"),
            keywords: &["khuru", "sikʼimira"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("furnică"),
            keywords: &["colonie", "furnică", "hărnicie", "insectă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-473"),
            keywords: &["E10-473"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("муравей"),
            keywords: &["муравей", "насекомое"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umuswa"),
            keywords: &["agakoko", "umuswa"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ماڪوڙي"),
            keywords: &["جيت", "ماڪوڙي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ක\u{dd6}ඹ\u{dd2}ය\u{dcf}"),
            keywords: &["ක\u{dd6}ඹ\u{dd2}ය\u{dcf}", "කෘම\u{dd2}ය\u{dcf}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("mravec"),
            keywords: &["hmyz", "mravec"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("mravlja"),
            keywords: &["mravlja", "žuželka"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("quraanjo"),
            keywords: &["cayayaan", "quraanjo"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("milingonë"),
            keywords: &["insekt", "milingonë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("мрав"),
            keywords: &["инсeкт", "мрав"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("mrav"),
            keywords: &["insekt", "mrav"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("myra"),
            keywords: &["djur", "insekt", "myra"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("siafu"),
            keywords: &["mdudu", "siafu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("எறும\u{bcd}பு"),
            keywords: &["எறும\u{bcd}பு", "பூச\u{bcd}சி", "விலங\u{bcd}கினம\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("చ\u{c40}మ"),
            keywords: &["చ\u{c40}మ", "జంతువు"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("мурча"),
            keywords: &["мурча", "ҳашарот"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("มด"),
            keywords: &["มด", "แมลง"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("garynja"),
            keywords: &["garynja", "mör-möjekler"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("lō"),
            keywords: &["lō"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("karınca"),
            keywords: &["böcek", "karınca"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("چۈمۈلە"),
            keywords: &["چۈمۈلە", "ھاشارات"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("мураха"),
            keywords: &["комаха", "мураха"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("چیونٹی"),
            keywords: &["چیونٹی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("chumoli"),
            keywords: &["chumoli", "xasharot"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("kiến"),
            keywords: &["côn trùng", "kiến"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("sànqaleñ"),
            keywords: &["gunóor bu sew", "sànqaleñ"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("imbovane"),
            keywords: &["imbovane", "isinambuzane"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Kokoro"),
            keywords: &["Kokoro", "kòkòrò"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("螞蟻"),
            keywords: &["昆蟲", "螞蟻"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("蚂蚁"),
            keywords: &["昆虫", "蚂蚁"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("蚂蚁"),
            keywords: &["蚂蚁"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("螞蟻"),
            keywords: &["螞蟻", "蟻"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("intuthwane"),
            keywords: &["intuthwane"],
        },
    ],
};
#[doc = "🐝"]
pub const HONEYBEE: crate::Emoji = crate::Emoji {
    glyph: "🐝",
    codepoint: "1F41D",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "honeybee",
    group: "Animals & Nature",
    subgroup: "animal-bug",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("heuningby"),
            keywords: &["by", "heuningby", "insek"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ንብ"),
            keywords: &["ትንኝ", "ንብ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("نحلة"),
            keywords: &["حيوان", "عسل نحل", "نحل", "نحلة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("মৌম\u{9be}খি"),
            keywords: &["পতঙ\u{9cd}গ", "ম\u{9be}খি", "মৌম\u{9be}খি"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("bal arısı"),
            keywords: &["arı", "bal arısı", "həşərat"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("пчала"),
            keywords: &["меданосная пчала", "насякомае", "пчала"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("пчела"),
            keywords: &["насекомо", "пчела"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মৌম\u{9be}ছি"),
            keywords: &["পোক\u{9be}", "মৌম\u{9be}ছি"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("gwenanenn"),
            keywords: &["amprevan", "gwenanenn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("pčela"),
            keywords: &["insekt", "pčela"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("abella"),
            keywords: &["abella", "insecte"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄟\u{1112a} 𑄛\u{1112a}𑄇\u{11134}"),
            keywords: &["𑄟\u{1112a} 𑄛\u{1112a}𑄇\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᏍᎪᏳ"),
            keywords: &["ᎦᏍᎪᏳ", "ᏥᏍᎪᏯ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("včela"),
            keywords: &["hmyz", "včela"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("gwenynen"),
            keywords: &["chwilen", "gwenynen"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("honningbi"),
            keywords: &["bi", "dyr", "honningbi"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Biene"),
            keywords: &["Biene", "Honigbiene", "Hummel", "Tier"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μέλισσα"),
            keywords: &["έντομο", "μέλισσα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("honeybee"),
            keywords: &["bee", "honeybee", "insect"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("abeja"),
            keywords: &["abeja", "flores", "insecto", "miel"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["abeja", "animal", "insecto"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("mesilane"),
            keywords: &["mesilane", "putukas"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("erlea"),
            keywords: &["erle", "erlea", "intsektu"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("زنبور عسل"),
            keywords: &["حشره", "زنبور عسل"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("mehiläinen"),
            keywords: &["hyönteinen", "mehiläinen"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("bubuyog"),
            keywords: &["bubuyog", "honeybee", "insekto"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("býfluga"),
            keywords: &["býfluga", "skordýr"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("abeille"),
            keywords: &["abeille", "animal", "insecte"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["abeille", "insecte"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("beach mheala"),
            keywords: &["beach", "beach mheala", "feithid"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("seillean"),
            keywords: &["biastag", "bèisteag", "fiolan", "meanbh-fhrìde", "seillean"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("abella"),
            keywords: &["abella", "avespa", "mel", "vespa"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("મધમાખી"),
            keywords: &["પ\u{acd}રાણી", "મધમાખી", "મધ\u{ac1}મક\u{acd}ષિકા"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("zuma"),
            keywords: &["zuma", "ƙwaro"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("דבורה"),
            keywords: &["דבורה", "דבש"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("मध\u{941}मक\u{94d}खी"),
            keywords: &["पश\u{941}", "मक\u{94d}खी", "मध\u{941}मक\u{94d}खी"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("pčela"),
            keywords: &["insekt", "pčela"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("méh"),
            keywords: &["méh", "méhecske", "rovar"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մեղու"),
            keywords: &["աշխատասեր", "մեղու", "մեղր", "միջատ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("lebah madu"),
            keywords: &["lebah", "lebah madu", "serangga"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("aṅụ\u{301} mmanụaṅụ"),
            keywords: &["ahụhụ", "aṅụ", "aṅụ\u{301} mmanụaṅụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hunangsfluga"),
            keywords: &["býfluga", "hunangsfluga"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("ape"),
            keywords: &["animale", "ape"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ミツバチ"),
            keywords: &["ハチ", "ミツバチ", "虫"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("lebah madu"),
            keywords: &["lebah", "lebah madu", "serangga"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ფუტკარი"),
            keywords: &["მწერი", "ფუტკარი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("tizizwit"),
            keywords: &["tizizwit"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("бал ара"),
            keywords: &["ара", "бал ара", "шыбын-шіркей"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("honningbi"),
            keywords: &["bi", "dyr", "honningbi"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ឃ\u{17d2}ម\u{17bb}\u{17c6}"),
            keywords: &[
                "ឃ\u{17d2}ម\u{17bb}\u{17c6}",
                "សត\u{17d2}វល\u{17d2}អ\u{17b7}ត",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಜೇನು ನೊಣ"),
            keywords: &["ಜೇನು ನೊಣ", "ಜೇನುನೊಣ", "ನೊಣ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("꿀벌"),
            keywords: &["꿀벌", "동물", "벌"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("म\u{94d}हो\u{902}वाम\u{942}स"),
            keywords: &["किटक", "म\u{942}स", "म\u{94d}हो\u{902}वाम\u{942}स"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("бал аары"),
            keywords: &["аары", "бал аары", "курт-кумурска"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Bei"),
            keywords: &["Bei", "Insekt"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເຜ\u{eb4}\u{ec9}ງ"),
            keywords: &["ສ\u{eb1}ດ", "ເຜ\u{eb4}\u{ec9}ງ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("bitė"),
            keywords: &["bitė", "vabzdys"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("bite"),
            keywords: &["bite", "kukainis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("hanipī"),
            keywords: &["hanipī", "ngārara", "pī"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("пчела"),
            keywords: &["инсект", "пчела"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("തേനീച\u{d4d}ച"),
            keywords: &["തേനീച\u{d4d}ച", "പ\u{d4d}ര\u{d3e}ണി", "മ\u{d43}ഗം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("зөгий"),
            keywords: &["зөгий", "шавьж"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("मधमाशी"),
            keywords: &["किडा", "मधमाशी", "माशी"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("lebah madu"),
            keywords: &["lebah", "lebah madu", "serangga"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("żunżana"),
            keywords: &["insett", "naħal", "żunżana"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပျား"),
            keywords: &["ပျား", "အင\u{103a}းဆက\u{103a}ပ\u{102d}\u{102f}း"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("honningbie"),
            keywords: &["bie", "dyr", "honningbie", "insekt"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("माह\u{941}री"),
            keywords: &["कमिला", "माह\u{941}री"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("honingbij"),
            keywords: &["bij", "honingbij", "insect"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("honningbie"),
            keywords: &["bie", "dyr", "honningbie", "insekt"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମହ\u{b41}ମ\u{b3e}ଛ\u{b3f}"),
            keywords: &[
                "ଜୀବ",
                "ମଧ\u{b41}ମକ\u{b4d}ଷ\u{b3f}କ\u{b3e}",
                "ମହ\u{b41}ମ\u{b3e}ଛ\u{b3f}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਮਧ\u{a42} ਮ\u{a71}ਖੀ"),
            keywords: &["ਜਾਨਵਰ", "ਮਧ\u{a42} ਮ\u{a71}ਖੀ", "ਮ\u{a71}ਖੀ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("شہد دی مکھی"),
            keywords: &["حشرات", "شہد دی مکھی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Họ\u{301}nibii"),
            keywords: &["Bii", "Họ\u{301}nibii", "Họ\u{301}níbii", "Ínsẹkt"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("pszczoła"),
            keywords: &["insekt", "owad", "pszczoła", "pszczółka"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د شاتو مچۍ"),
            keywords: &["د شاتو مچۍ", "مچۍ، د شاتو مچۍ، حشره"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("abelha"),
            keywords: &["abelha", "inseto"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("abelha"),
            keywords: &["abelha", "insecto", "inseto", "mel"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("wara"),
            keywords: &["ch’uspi", "t’uktu", "wara"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("albină"),
            keywords: &["albină", "aripi", "insectă", "miere"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-474"),
            keywords: &["E10-474"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("пчела"),
            keywords: &["желто-черная", "насекомое", "пчела"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("uruyuki"),
            keywords: &["agakoko", "uruyuki"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ماکي جي مک"),
            keywords: &["ماکي جي مک", "مک، جيت"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ම\u{dd3}මැස\u{dca}ස\u{dcf}"),
            keywords: &["කෘම\u{dd2}ය\u{dcf}", "ම\u{dd3}මැස\u{dca}ස\u{dcf}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("včela"),
            keywords: &["hmyz", "včela"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("čebela"),
            keywords: &["čebela", "žuželka"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("shinni malab"),
            keywords: &["cayayaan", "shinni", "shinni malab"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("bletë"),
            keywords: &["bletë", "insekt"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("пчела"),
            keywords: &["инсeкт", "медоносна пчела", "пчeлa", "пчела"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["пчела"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("pčela"),
            keywords: &["insekt", "medonosna pčela", "pčela"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["pčela"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("bi"),
            keywords: &["bi", "djur", "geting", "insekt"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("nyuki"),
            keywords: &["mdudu", "nyuki"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("தேன\u{bc0}"),
            keywords: &["தேன\u{bc0}", "பூச\u{bcd}சி", "விலங\u{bcd}கினம\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("త\u{c47}న\u{c46}ట\u{c40}గ"),
            keywords: &["జంతువు", "తుమ\u{c4d}మ\u{c46}ద", "త\u{c47}న\u{c46}ట\u{c40}గ"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("занбури асал"),
            keywords: &["занбур", "занбури асал", "ҳашарот"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ผ\u{e36}\u{e49}ง"),
            keywords: &["ผ\u{e36}\u{e49}ง", "แมลง"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("balary"),
            keywords: &["ary", "balary", "mör-möjek"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("hone"),
            keywords: &["hone"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("bal arısı"),
            keywords: &["arı", "bal arısı", "hayvan"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ھەسەل ھەرىسى"),
            keywords: &["ھاشارات", "ھەرە", "ھەسەل ھەرىسى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("бджола"),
            keywords: &["бджола", "комаха"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("شہد کی مکھی"),
            keywords: &["شہد", "شہد کی مکھی", "مکھی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("asalari"),
            keywords: &["ari", "asalari", "xasharot"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("ong mật"),
            keywords: &["con ong", "côn trùng", "ong mật"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("yamb"),
            keywords: &["gunóor bu sew", "yamb", "yàmb"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("inyosi yobusi"),
            keywords: &["inyosi", "inyosi yobusi", "isinambuzane"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Oyin"),
            keywords: &["Oyin", "kòkòrò", "kòkòrò oyin"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("蜜蜂"),
            keywords: &["昆蟲", "蜜蜂"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("蜜蜂"),
            keywords: &["昆虫", "蜜蜂"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("蜜蜂"),
            keywords: &["勤劳", "蜜蜂"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("蜜蜂"),
            keywords: &["蜂", "蜜蜂"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["大黃蜂", "蜜蜂", "黃蜂"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("inyosi yoju"),
            keywords: &["inyosi", "inyosi yoju", "isilokozane"],
        },
    ],
};
#[doc = "🪲"]
pub const BEETLE: crate::Emoji = crate::Emoji {
    glyph: "🪲",
    codepoint: "1FAB2",
    status: crate::Status::FullyQualified,
    introduction_version: 13f32,
    name: "beetle",
    group: "Animals & Nature",
    subgroup: "animal-bug",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("kewer"),
            keywords: &["gogga", "insek", "kewer"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ጥንዚዛ"),
            keywords: &["ጥንዚዛ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("خنفساء"),
            keywords: &["حشرة", "خنفساء"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("গ\u{9c1}বৰ\u{9c1}ৱ\u{9be}"),
            keywords: &["গ\u{9c1}বৰ\u{9c1}ৱ\u{9be}", "পতংগ", "পোক"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("tarakan"),
            keywords: &["böcək", "həşərat", "tarakan"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("жук"),
            keywords: &["жук", "кузурка", "насякомае"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("бръмбар"),
            keywords: &["бръмбар", "бубулечка", "насекомо"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("গ\u{9c1}বরে পোক\u{9be}"),
            keywords: &["কীট", "গ\u{9c1}বরে পোক\u{9be}", "পোক\u{9be}"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("cʼhwil"),
            keywords: &["amprevan", "cʼhwil"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("tvrdokrilac"),
            keywords: &["buba", "insekt", "tvrdokrilac"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("escarabat"),
            keywords: &["cuca", "escarabat", "insecte"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏧᎵᏍᎫᏩ"),
            keywords: &["ᏍᎪᏯ", "ᏥᏍᎪᏯ", "ᏧᎵᏍᎫᏩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("brouk"),
            keywords: &["brouk", "brouček", "hmyz"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("chwilen"),
            keywords: &["chwilen", "cleren", "pryfyn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("bille"),
            keywords: &["bille", "insekt"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Käfer"),
            keywords: &["Insekt", "Käfer"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σκαθάρι"),
            keywords: &["έντομο", "μαμούνι", "σκαθάρι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("beetle"),
            keywords: &["beetle", "bug", "insect"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("escarabajo"),
            keywords: &["bicho", "escarabajo", "insecto"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("escarabajo"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("escarabajo"),
            keywords: &["escarabajo"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("escarabajo"),
            keywords: &["escarabajo"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("mardikas"),
            keywords: &["mardikas", "putukas"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("kakalardo"),
            keywords: &[
                "intsektua",
                "kakalardo",
                "kakalardoa",
                "mamorroa",
                "zomorroa",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("سوسک"),
            keywords: &["حشره", "سوسک"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kuoriainen"),
            keywords: &["hyönteinen", "koppakuoriainen", "kuoriainen", "ötökkä"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("salaginto"),
            keywords: &["insekto", "salaginto"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("klukka"),
            keywords: &["klukka", "skordýr"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("scarabée"),
            keywords: &["insecte", "scarabée"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("scarabée"),
            keywords: &["insecte", "scarabée"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("ciaróg"),
            keywords: &["ciaróg", "feithid", "míol"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("daolag"),
            keywords: &["biastag", "bèisteag", "daolag", "fiolan", "meanbh-fhrìde"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("escaravello"),
            keywords: &["becho", "bicho", "escarabeidos", "escaravello", "insecto"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ભમરો"),
            keywords: &[
                "જ\u{a82}ત\u{ac1}",
                "નાન\u{ac1}\u{a82} જીવડ\u{ac1}\u{a82}",
                "ભમરો",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("חיפושית"),
            keywords: &["חיפושית", "חרק"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("बीटल"),
            keywords: &["कीट", "कीड\u{93c}ा", "बीटल"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("buba"),
            keywords: &["buba", "insekt", "kukac"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("bogár"),
            keywords: &["bogár", "rovar"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բզեզ"),
            keywords: &["բզեզ", "միջատ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kumbang"),
            keywords: &["hama", "kumbang", "serangga"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("bjölludýr"),
            keywords: &["bjalla", "bjölludýr", "padda", "skordýr"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("coleottero"),
            keywords: &["cimice", "coleottero", "insetto"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("カブトムシ"),
            keywords: &["つの", "カブトムシ", "昆虫", "虫"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kumbang"),
            keywords: &["ama", "kumbang", "serangga"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ხოჭო"),
            keywords: &["ბაღლინჯო", "ინსექტი", "ხოჭო"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қоңыз"),
            keywords: &["жәндік", "шыбын-шіркей", "қоңыз"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("កញ\u{17d2}ចែ"),
            keywords: &["កញ\u{17d2}ចែ", "សត\u{17d2}វល\u{17d2}អ\u{17b7}ត"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬೀಟಲ\u{ccd}"),
            keywords: &["ಬಗ\u{ccd}", "ಬೀಟಲ\u{ccd}", "ಹುಳು"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("딱정벌레"),
            keywords: &["곤충", "딱정벌레", "벌레"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("बीटल"),
            keywords: &["किटक", "बीटल", "भिक\u{942}ण"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("коңуз"),
            keywords: &["коңуз"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ແມງ\u{200b}ປ\u{eb5}ກ\u{200b}ແຂງ"),
            keywords: &[
                "ແມງ\u{200b}ຄາມ",
                "ແມງ\u{200b}ປ\u{eb5}ກ\u{200b}ແຂງ",
                "ແມງ\u{200b}ໄມ\u{ec9}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("vabaliukas"),
            keywords: &["vabalas", "vabaliukas", "vabzdys"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("vabole"),
            keywords: &["insekts", "kukainis", "vabole"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("бумбар"),
            keywords: &["бубачка", "бумбар", "инсект"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ചീവിട\u{d4d}"),
            keywords: &["കീടം", "ചീവിട\u{d4d}", "പ\u{d4d}ര\u{d3e}ണി"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хорхой шавж"),
            keywords: &["нисдэг шавж", "хорхой шавж"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("कीडा"),
            keywords: &["कीटक", "कीडा", "ढ\u{947}क\u{942}ण"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kumbang"),
            keywords: &["kumbang", "pepijat", "serangga"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပ\u{102d}\u{102f}းကောင\u{103a}"),
            keywords: &[
                "ပ\u{102d}\u{102f}း",
                "ပ\u{102d}\u{102f}းကောင\u{103a}",
                "အင\u{103a}းဆက\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("bille"),
            keywords: &["bille", "dyr", "insekt"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("बिटल"),
            keywords: &["किरा", "किरो", "बिटल"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("kever"),
            keywords: &["beestje", "insect", "kever"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("bille"),
            keywords: &["bille", "dyr", "insekt"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଗୋବରପୋକ"),
            keywords: &["କୀଟପତଙ\u{b4d}ଗ", "ଗୋବରପୋକ", "ଛ\u{b3e}ରପୋକ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬੀ\u{a02}ਡਾ"),
            keywords: &["ਕੀਟ", "ਕੀੜਾ", "ਖਟਮਲ", "ਬੀ\u{a02}ਡਾ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Bítul"),
            keywords: &["Bítul", "Smọ\u{301}l Ínsẹkt", "Ínsẹkt"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("chrząszcz"),
            keywords: &["chrząszcz", "owad", "żuk"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("خزدکه"),
            keywords: &["حشره", "خزدکه", "سپږۍ", "پالپونکه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("besouro"),
            keywords: &["besouro", "bicho", "inseto"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("aka tanqa"),
            keywords: &["aka tanqa", "chʼuspi", "khuru"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("cărăbuș"),
            keywords: &["cărăbuș", "gândac", "insectă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E13-033"),
            keywords: &["E13-033"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("жук"),
            keywords: &["букашка", "жук", "жучок", "насекомое"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("بيٽل"),
            keywords: &["بيٽل", "بگ", "جيت"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ක\u{dd4}ර\u{dd4}ම\u{dd2}ණ\u{dd2}ය\u{dcf}"),
            keywords: &[
                "ක\u{dd4}ර\u{dd4}ම\u{dd2}ණ\u{dd2}ය\u{dcf}",
                "කෘම\u{dd3}න\u{dca}",
                "මක\u{dd4}ණ\u{dcf}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("chrobák"),
            keywords: &["chrobák", "hmyz"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("hrošč"),
            keywords: &["hrošč", "insekt", "žuželka"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("faraanfar"),
            keywords: &["cayayaan", "faraanfar", "kutaan"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("brumbull"),
            keywords: &["brumbull", "buburrec", "insekt"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("буба"),
            keywords: &["буба", "инсект"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("buba"),
            keywords: &["buba", "insekt"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("skalbagge"),
            keywords: &["insekt", "skalbagge", "småkryp"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mende"),
            keywords: &["kijidudu", "mdudu", "mende"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வண\u{bcd}டு"),
            keywords: &["பூச\u{bcd}சி", "வண\u{bcd}டு"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("కుమ\u{c4d}మర\u{c3f} పురుగు"),
            keywords: &[
                "క\u{c40}టకం",
                "కుమ\u{c4d}మర\u{c3f} పురుగు",
                "కుమ\u{c4d}మర\u{c3f}పురుగు",
                "పురుగు",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ด\u{e49}วง"),
            keywords: &["ด\u{e49}วง", "แมลง"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("tomzak"),
            keywords: &["möjek", "mör-möjek", "tomzak"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mongomonga iiki"),
            keywords: &["mongomonga", "mongomonga iiki"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("böcek"),
            keywords: &["böcek", "haşere"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("жук"),
            keywords: &["жук", "комаха", "кузка"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بھونرا"),
            keywords: &["بھونرا", "کھٹمل", "کیڑا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("qoʻngʻiz"),
            keywords: &["hasharot", "qoʻngʻiz", "qumursqa"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bọ cánh cứng"),
            keywords: &["bọ", "bọ cánh cứng", "côn trùng"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("甲殼蟲"),
            keywords: &["昆蟲", "甲殼蟲", "甲蟲"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("甲壳虫"),
            keywords: &["昆虫", "甲壳虫", "甲虫"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("甲虫"),
            keywords: &["昆虫", "甲虫"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("甲蟲"),
            keywords: &["昆蟲", "甲蟲", "蟲"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ibhungane"),
            keywords: &["i-bug", "ibhungane", "isinambuzane"],
        },
    ],
};
#[doc = "🐞"]
pub const LADY_BEETLE: crate::Emoji = crate::Emoji {
    glyph: "🐞",
    codepoint: "1F41E",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "lady beetle",
    group: "Animals & Nature",
    subgroup: "animal-bug",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("liewenheersbesie"),
            keywords: &["besie", "insek", "kewer", "liewenheersbesie"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሴት ጢንዚዛ"),
            keywords: &["ሌዲበርድ", "ሌዲባግ", "ሴት ጢንዚዛ", "ነፍሳት", "ጢንዚዛ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("دعسوقة"),
            keywords: &["حشرة", "خنفساء", "دعسوقة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ভোমোৰ\u{9be}"),
            keywords: &[
                "গ\u{9c1}বৰ\u{9c1}ৱ\u{9be}",
                "পতঙ\u{9cd}গ",
                "ভোমোৰ\u{9be}",
                "সোণ পোক",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("parabüzən"),
            keywords: &["böcək", "həşərat", "parabizən", "parabüzən"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("божая кароўка"),
            keywords: &["божая кароўка", "жук", "насякомае"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("калинка"),
            keywords: &["бръмбар", "калинка", "насекомо"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("লেডি ব\u{9cd}য\u{9be}টেল"),
            keywords: &[
                "গ\u{9c1}বরে পোক\u{9be}",
                "পোক\u{9be}",
                "লেডি ব\u{9cd}য\u{9be}টেল",
                "লেডিব\u{9be}গ",
                "লেডিব\u{9be}র\u{9cd}ড",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("buocʼhan"),
            keywords: &["amprevan", "buocʼhan"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("bubamara"),
            keywords: &["buba", "bubamara", "insekt"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("marieta"),
            keywords: &["escarabat", "insecte", "marieta"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄛\u{1112a}𑄇\u{11134}"),
            keywords: &["𑄛\u{1112a}𑄇\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎨᏯ ᏧᎵᏍᎫᏩ"),
            keywords: &["ᎠᎨᏯ ᏥᏍᎪᏯ", "ᎠᎨᏯ ᏥᏍᏆ", "ᎠᎨᏯ ᏧᎵᏍᎫᏩ", "ᏥᏍᎪᏯ", "ᏧᎵᏍᎫᏩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("beruška"),
            keywords: &["beruška", "brouk", "hmyz", "sedmitečné", "slunéčko"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("chwilen y wraig"),
            keywords: &["chwilen", "chwilen y wraig"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("mariehøne"),
            keywords: &["dyr", "mariehøne"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Marienkäfer"),
            keywords: &["Glückskäfer", "Käfer", "Marienkäfer", "Tier"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πασχαλίτσα"),
            keywords: &["έντομο", "πασχαλίτσα", "σκαθάρι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("lady beetle"),
            keywords: &["beetle", "insect", "lady beetle", "ladybird", "ladybug"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("ladybird"),
            keywords: &["beetle", "insect", "ladybeetle", "ladybird", "ladybug"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("ladybug"),
            keywords: &["beetle", "insect", "lady beetle", "ladybird", "ladybug"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("mariquita"),
            keywords: &["cochinilla", "mariquita"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["animal", "escarabajo", "insecto", "mariquita"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["catarina", "escarabajo", "insecto", "mariquita"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("lepatriinu"),
            keywords: &["lepatriinu", "putukas", "põrnikas"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("amona mantangorri"),
            keywords: &["amona", "intsektu", "mantangorri"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کفشدوزک"),
            keywords: &["حشره", "سوسک", "کفشدوزک"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("leppäkerttu"),
            keywords: &["hyönteinen", "leppäkerttu"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("ladybug"),
            keywords: &[
                "insekto",
                "lady beetle",
                "ladybird",
                "ladybug",
                "salagubang",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("mariubjalla"),
            keywords: &["klukka", "mariubjalla", "mariuhøna", "skordýr"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("coccinelle"),
            keywords: &["animal", "coccinelle", "insecte"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "bête à bon dieu",
                "catherine",
                "coccinelle",
                "coléoptère",
                "insecte",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("bóín"),
            keywords: &["bóín", "bóín dé", "ciaróg", "feithid"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("daolag-bhreac"),
            keywords: &[
                "biastag",
                "bèisteag",
                "daolag",
                "daolag-bhreac",
                "fiolan",
                "meanbh-fhrìde",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("xoaniña"),
            keywords: &["barrosiña", "maruxiña", "reirrei", "voaniña", "xoaniña"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("માદા ભમરી"),
            keywords: &[
                "પ\u{acd}રાણી",
                "ભમરો",
                "માદા",
                "માદા ભમરી",
                "માદા મા\u{a82}કડ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("buzuzun turawa"),
            keywords: &[
                "buzuzu",
                "buzuzun turawa",
                "ƙwaro",
                "ƙwaron ladybird",
                "ƙwaron ladybug",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פרת משה רבנו"),
            keywords: &["חיפושית", "משה רבנו", "פרת משה רבנו"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ल\u{947}डीबग"),
            keywords: &[
                "इ\u{902}द\u{94d}रगोप",
                "पश\u{941}",
                "भ\u{943}\u{902}ग",
                "ल\u{947}डीबग",
                "स\u{94d}त\u{94d}री",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("bubamara"),
            keywords: &["buba", "bubamara", "insekt"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("katica"),
            keywords: &["bogár", "katica", "katicabogár", "rovar"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("զատիկ"),
            keywords: &["բզեզ", "զատիկ", "միջատ", "պուտեր"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kumbang betina"),
            keywords: &["kumbang", "kumbang betina", "serangga"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ebe nwanyi"),
            keywords: &["ahụhụ", "ebe", "ebe nwanyi", "nnechịnchị", "nneebe"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("maríuhæna"),
            keywords: &["bjalla", "maríubjalla", "maríuhæna", "skordýr"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("coccinella"),
            keywords: &["animale", "coccinella"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("テントウムシ"),
            keywords: &["テントウムシ", "虫"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kepik"),
            keywords: &["kepik", "kepik pereng", "kumbang", "serangga"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ჭიამაია"),
            keywords: &["მწერი", "ჭიამაია", "ხოჭო"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("takumda"),
            keywords: &["takumda"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ханқызы"),
            keywords: &["ханқызы", "шыбын-шіркей", "қызыл қоңыз"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("mariehøne"),
            keywords: &["dyr", "mariehøne"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("អណ\u{17d2}តើកមាសញ\u{17b8}"),
            keywords: &[
                "សត\u{17d2}វល\u{17d2}អ\u{17b7}ត",
                "អណ\u{17d2}ដើកមាស",
                "អណ\u{17d2}តើកមាសញ\u{17b8}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಲೇಡ\u{cbf} ಬೀಟಲ\u{ccd}"),
            keywords: &[
                "ಬೀಟಲ\u{ccd}",
                "ಲೇಡ\u{cbf} ಬೀಟಲ\u{ccd}",
                "ಲೇಡ\u{cbf}ಬಗ\u{ccd}",
                "ಲೇಡ\u{cbf}ಬರ\u{ccd}ಡ\u{ccd}",
                "ಹುಳು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("무당벌레"),
            keywords: &["동물", "무당벌레", "벌레"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("बायल बीटल"),
            keywords: &[
                "किटक",
                "बायल बीटल",
                "बीटल",
                "ल\u{947}डीबग",
                "ल\u{947}डीबर\u{94d}ड",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("эл кайда көчөт"),
            keywords: &["коңуз", "курт-кумурска", "эл кайда көчөт"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Himmelsdéierchen"),
            keywords: &["Himmelsdéierchen", "Insekt", "Kiewerlek"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ແມງເຕ\u{ebb}\u{ec8}າທອງ"),
            keywords: &["ສ\u{eb1}ດ", "ແມງເຕ\u{ebb}\u{ec8}າທອງ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("boružė"),
            keywords: &["boružė", "vabalas", "vabzdys"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("mārīte"),
            keywords: &["bizbizmārīte", "kukainis", "mārīte"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pāpapa kōpure"),
            keywords: &["pāpapa", "pāpapa kōpure", "pēpeke"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("бубамара"),
            keywords: &["бубамара", "бубачка", "инсект"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വണ\u{d4d}ട\u{d4d}"),
            keywords: &["പ\u{d4d}ര\u{d3e}ണി", "മ\u{d43}ഗം", "വണ\u{d4d}ട\u{d4d}"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("цох хорхой"),
            keywords: &["цох хорхой", "цох шавьж"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("नर किडा"),
            keywords: &[
                "किडा",
                "नर किडा",
                "बीटल",
                "ल\u{947}डी बीटल",
                "ल\u{947}डीबग",
                "ल\u{947}डीबर\u{94d}ड",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kumbang kura-kura"),
            keywords: &["kumbang", "kumbang kura-kura", "serangga"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ħanfusa"),
            keywords: &["insett", "nanna kola", "ħanfusa"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပ\u{102d}\u{102f}းတောင\u{103a}မာ"),
            keywords: &[
                "ပ\u{102d}\u{102f}းတောင\u{103a}မာ",
                "လေဒ\u{102e}ဘတ\u{103a}",
                "အင\u{103a}းဆက\u{103a}ပ\u{102d}\u{102f}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("marihøne"),
            keywords: &["bille", "dyr", "insekt", "marihøne"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ल\u{947}डी बिटल"),
            keywords: &["कमिला", "ल\u{947}डी बिटल"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("lieveheersbeestje"),
            keywords: &["insect", "kever", "lieveheersbeest", "lieveheersbeestje"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("marihøne"),
            keywords: &["bille", "dyr", "insekt", "marihøne"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମ\u{b3e}ଇ ଗୋବର ପୋକ"),
            keywords: &[
                "ଗୋବରପୋକ",
                "ଜୀବ",
                "ମ\u{b3e}ଇ",
                "ମ\u{b3e}ଇ ଓଡ\u{b3c}ଶ",
                "ମ\u{b3e}ଇ ଗୋବର ପୋକ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਭ\u{a42}\u{a70}ਡੀ"),
            keywords: &["ਜਾਨਵਰ", "ਭ\u{a42}\u{a70}ਡੀ", "ਮਾਦਾ", "ਮਾਦਾ ਖਟਮਲ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("پنبہ دوز"),
            keywords: &["حشرات", "لیڈی برڈ", "لیڈی بگ", "پنبہ دوز", "ہتھوڑا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Ledi Bítul"),
            keywords: &[
                "Bítul",
                "Ledi Bítul",
                "Ledi Bẹd Wé De Flai",
                "Ledi Smọ\u{301}l Ínsẹkt",
                "Ínsẹkt",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("biedronka"),
            keywords: &["biedronka", "chrabąszcz", "kropki", "owad", "żuk"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("پالپونکه"),
            keywords: &["پالپونکه", "پالپونکه، حشره، ګنګوټۍ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("joaninha"),
            keywords: &["inseto", "joaninha"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["bicho", "inseto", "joaninha", "voa voa"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("mariquita"),
            keywords: &["aka tanqa", "ch’uspi", "mariquita"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("buburuză"),
            keywords: &["buburuză", "buline", "insectă", "roșu"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-475"),
            keywords: &["E10-475"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("божья коровка"),
            keywords: &[
                "божья",
                "жук",
                "коровка",
                "красная",
                "насекомое",
                "солнышко",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("akanyenyeri"),
            keywords: &["agakoko", "akanyenyeri", "ikivumvuri"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ليڊي بيٽل"),
            keywords: &["بيٽل، جيت، ليڊي برڊ، ليڊي بگ", "ليڊي بيٽل"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ලේඩ\u{dd2} බ\u{dd3}ටල\u{dca}"),
            keywords: &[
                "ක\u{dd4}ර\u{dd4}ම\u{dd2}ණ\u{dd2}ය\u{dcf}",
                "කෘම\u{dd2}ය\u{dcf}",
                "ලේඩ\u{dd2} බ\u{dd3}ටල\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("lienka"),
            keywords: &["chrobák", "hmyz", "lienka"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("pikapolonica"),
            keywords: &["hrošč", "pikapolonica", "žuželka"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("duqsiyada dheddiga"),
            keywords: &[
                "cayayaan",
                "duqsiyada dheddiga",
                "duqsiyo",
                "kutaan dheddig",
                "shimbir bay ah",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("mollëkuqe"),
            keywords: &["brumbull", "insekt", "mollëkuqe"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("бубамара"),
            keywords: &["бубa", "бубaмaрa", "бубамара", "инсeкт"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("bubamara"),
            keywords: &["buba", "bubamara", "insekt"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("nyckelpiga"),
            keywords: &["djur", "insekt", "nyckelpiga", "skalbagge"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kombamwiko mwenye madoa"),
            keywords: &["bimbirisa kimba", "kombamwiko mwenye madoa", "mdudu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பெண\u{bcd} வண\u{bcd}டு"),
            keywords: &[
                "குளவி",
                "பூச\u{bcd}சி",
                "பெண\u{bcd} வண\u{bcd}டு",
                "வண\u{bcd}டு",
                "விலங\u{bcd}கினம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ప\u{c47}డపురుగు"),
            keywords: &["జంతువు", "ప\u{c47}డపురుగు"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ҳасанак"),
            keywords: &["какана", "нонхӯрак", "халилихӯак", "ҳасанак", "ҳашарот"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เต\u{e48}าทอง"),
            keywords: &["เต\u{e48}าทอง", "แมลง", "แมลงเต\u{e48}าทอง"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("kekene"),
            keywords: &["kekene", "möjek", "mör-möjek", "tomzak"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mongomonga-fineʻeiki"),
            keywords: &["mongomonga", "mongomonga-fineʻeiki"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("uğur böceği"),
            keywords: &["böcek", "hanım", "hanımböceği", "hayvan", "uğur böceği"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("خانقىز"),
            keywords: &["خانقىز", "قىز قۇرت", "قىز قۇش", "قۇرت", "پىت"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("сонечко"),
            keywords: &["жучок", "комаха", "корівка", "сонечко"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کھٹمل"),
            keywords: &["کھٹمل", "کیڑا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("xonqizi"),
            keywords: &["xasharot", "xonqizi"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bọ rùa"),
            keywords: &["bọ cánh cứng", "bọ rùa", "con bọ rùa", "côn trùng"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("gunóor am tupp yu weex"),
            keywords: &[
                "gunóor am tupp yu weex",
                "gunóor bu sew",
                "koksineel",
                "koksinel",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("uqongqothwane"),
            keywords: &["i-ladybird", "i-ladybug", "isinambuzane", "uqongqothwane"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Yigbẹ-yigbẹ"),
            keywords: &["Yigbẹ-yigbẹ", "kòkòrò", "obounboùn", "obounboùn kékeré"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("甲蟲"),
            keywords: &["昆蟲", "甲蟲"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("甲虫"),
            keywords: &["昆虫", "甲虫"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("瓢虫"),
            keywords: &["昆虫", "母", "瓢虫"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("瓢蟲"),
            keywords: &["昆蟲", "瓢蟲"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["昆蟲", "瓢蟲", "甲蟲"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ibhungezi"),
            keywords: &["ibhungezi", "ibhunguzi", "isilokozane"],
        },
    ],
};
#[doc = "🦗"]
pub const CRICKET: crate::Emoji = crate::Emoji {
    glyph: "🦗",
    codepoint: "1F997",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "cricket",
    group: "Animals & Nature",
    subgroup: "animal-bug",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("kriek"),
            keywords: &["kriek", "sprinkaan"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ክሪኬት"),
            keywords: &["ክሪኬት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("جدجد"),
            keywords: &["جدجد"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("উইচিৰিঙ\u{9be}"),
            keywords: &["উইচিৰিঙ\u{9be}", "ফৰিং"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("cırcırama"),
            keywords: &["cırcırama", "çəyirtkə"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("цвыркун"),
            keywords: &["конік", "цвыркун"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("щурец"),
            keywords: &["скакалец", "щурец"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ঝি\u{981}ঝি পোক\u{9be}"),
            keywords: &["ঝি\u{981}ঝি পোক\u{9be}", "ফড\u{9bc}িং"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("krank-raden"),
            keywords: &["amprevan", "krank-raden"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("cvrčak"),
            keywords: &["cvrčak", "skakavac"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("grill"),
            keywords: &["grill", "llagosta"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄉\u{1112a}𑄟\u{1112a}𑄢\u{1112f}"),
            keywords: &["𑄉\u{1112a}𑄟\u{1112a}𑄢\u{1112f}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏔᎳᏚ"),
            keywords: &["ᏔᎳᏚ", "ᏙᎳᏧᎦ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("cvrček"),
            keywords: &["cvrček", "kobylka", "koník", "luční"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("criciedyn"),
            keywords: &["ceiliog rhedyn", "criciedyn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("fårekylling"),
            keywords: &["fårekylling", "græshoppe"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Grille"),
            keywords: &["Grille", "Heuschrecke"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("τριζόνι"),
            keywords: &["ακρίδα", "τριζόνι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("cricket"),
            keywords: &["cricket", "grasshopper"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("cricket"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("grillo"),
            keywords: &["grillo", "saltamontes"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["animal", "grillo", "insecto", "saltamontes"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kilk"),
            keywords: &["kilk", "rohutirts"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("kilker"),
            keywords: &["kilker", "matxinsalto"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("جیرجیرک"),
            keywords: &["جیرجیرک", "زنجره", "ملخ"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("sirkka"),
            keywords: &["heinäsirkka", "sirkka"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("kuliglig"),
            keywords: &["kuliglig", "tipaklong"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("veggjasmiður"),
            keywords: &["grashoppa", "veggjasmiður"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("criquet"),
            keywords: &["animal", "criquet", "insecte", "sauterelle"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("criogar"),
            keywords: &["criogar", "dreoilín teaspaigh"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("greollan"),
            keywords: &[
                "brobhadan",
                "fionnan-feòir",
                "greollan",
                "leumadair-uaine",
                "srannan",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("grilo"),
            keywords: &["grilo", "saltón"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ક\u{a82}સારી"),
            keywords: &["ક\u{a82}સારી"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("gyare"),
            keywords: &["fara", "gyare"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("צרצר"),
            keywords: &["חגב", "צרצר"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("टिड\u{94d}डा, झी\u{902}ग\u{941}र"),
            keywords: &["टिड\u{94d}डा, झी\u{902}ग\u{941}र"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("cvrčak"),
            keywords: &["cvrčak", "skakavac"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("tücsök"),
            keywords: &["szöcske", "tücsök"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ծղրիդ"),
            keywords: &["ծղրիդ", "մորեխ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("jangkrik"),
            keywords: &["belalang", "jangkrik"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("Egwuregwu Kriket"),
            keywords: &["Egwuregwu Kriket", "ụ\u{300}kpàlà"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("krybba"),
            keywords: &["engispretta", "krybba"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("grillo"),
            keywords: &["cavalletta", "grillo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("バッタ"),
            keywords: &["コオロギ", "バッタ", "虫"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("jangkrik"),
            keywords: &["jangkrik", "walang"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("კრიკეტი"),
            keywords: &["კალია", "კრიკეტი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("ajṛad"),
            keywords: &["ajṛad"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("шегіртке"),
            keywords: &["шегіртке"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ចង\u{17d2}រ\u{17b7}ត"),
            keywords: &["កណ\u{17d2}ដ\u{17bc}ប", "ចង\u{17d2}រ\u{17b7}ត"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕ\u{ccd}ರ\u{cbf}ಕ\u{cc6}ಟ\u{ccd}"),
            keywords: &["ಕ\u{ccd}ರ\u{cbf}ಕ\u{cc6}ಟ\u{ccd}", "ಮ\u{cbf}ಡತ\u{cc6}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("귀뚜라미"),
            keywords: &["귀뚜라미"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("नाकतोडो"),
            keywords: &["तोळ", "नाकतोडो"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кара чегиртке"),
            keywords: &["кара чегиртке", "чегиртке"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Cricket"),
            keywords: &["Cricket", "Heesprénger"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຈ\u{eb4}\u{ec9}ງຫລ\u{eb5}ດ"),
            keywords: &["ຈ\u{eb4}\u{ec9}ງຫລ\u{eb5}ດ", "ຕ\u{eb1}ກກະແຕນ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("svirplys"),
            keywords: &["svirplys", "žiogas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("circenis"),
            keywords: &["circenis", "sienāzis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kirikiti"),
            keywords: &["kirikiti", "māwhitiwhiti"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("штурец"),
            keywords: &["скакулец", "штурец"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ചീവീട\u{d4d}"),
            keywords: &["ചീവീട\u{d4d}", "പ\u{d41}ൽച\u{d4d}ച\u{d3e}ടി"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хүрэлзгэнэ"),
            keywords: &["хүрэлзгэнэ", "царцаа"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("नाकतोडा"),
            keywords: &["नाकतोडा"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("cengkerik"),
            keywords: &["belalang", "cengkerik"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("cricket"),
            keywords: &["cricket", "ġurat"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပ\u{102f}ရစ\u{103a}ကောင\u{103a}"),
            keywords: &[
                "န\u{103e}\u{1036}ကောင\u{103a}",
                "ပ\u{102f}ရစ\u{103a}ကောင\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("gresshoppe"),
            keywords: &["dyr", "gresshoppe", "insekt"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("फट\u{94d}याङ\u{94d}ग\u{94d}रा"),
            keywords: &["फट\u{94d}याङ\u{94d}ग\u{94d}रा"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("krekel"),
            keywords: &["krekel", "sprinkhaan"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("grashoppe"),
            keywords: &["dyr", "grashoppe", "insekt"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଝ\u{b3f}ଣ\u{b4d}ଟ\u{b3f}କ\u{b3e}"),
            keywords: &[
                "ଝ\u{b3f}ଙ\u{b4d}କ\u{b3e}ର\u{b3f}",
                "ଝ\u{b3f}ଣ\u{b4d}ଟ\u{b3f}କ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਟਿ\u{a71}ਡਾ"),
            keywords: &["ਘਾਹ ਦਾ ਟਿ\u{a71}ਡਾ", "ਟਿ\u{a71}ਡਾ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کرکٹ"),
            keywords: &["ٹڈا", "کرکٹ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Kríkẹt"),
            keywords: &["Gráshọ\u{301}pa", "Kríkẹt"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("świerszcz"),
            keywords: &["świerszcz"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("حشره"),
            keywords: &["حشره", "حشره، ملخ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("grilo"),
            keywords: &["grilo", "inseto"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["gafanhoto", "grilo"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("cricket"),
            keywords: &["cricket", "tʼintikuna"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("greier"),
            keywords: &["greier", "lăcustă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1119"),
            keywords: &["E10-1119"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("сверчок"),
            keywords: &["кузнечик", "насекомое", "сверчок"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("kiriketi"),
            keywords: &["isanane", "kiriketi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("تڏ"),
            keywords: &["تڏ", "مڪڙ", "ڪرڪيٽ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("පළගැට\u{dd2}ය\u{dcf}"),
            keywords: &["තණකොළ පෙත\u{dca}ත\u{dcf}", "පළගැට\u{dd2}ය\u{dcf}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("svrček"),
            keywords: &["saranča", "svrček"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("muren"),
            keywords: &["muren"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("jiiq-jiiqle"),
            keywords: &["jiiq-jiiqle", "jirriqaa"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("karkalec"),
            keywords: &["bulkth", "karkalec", "karkalec bari"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("зрикавац"),
            keywords: &["зрикавац", "скакавац"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("zrikavac"),
            keywords: &["skakavac", "zrikavac"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("syrsa"),
            keywords: &["gräshoppa", "syrsa"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("nyenje"),
            keywords: &["nyenje", "panzi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("இர\u{bbe}க\u{bcd}கோழி"),
            keywords: &[
                "இர\u{bbe}க\u{bcd}கோழி",
                "பூச\u{bcd}சி",
                "வெட\u{bcd}டுக\u{bcd}கிளி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("చ\u{c3f}మ\u{c4d}మట"),
            keywords: &["చ\u{c3f}మ\u{c4d}మట", "మ\u{c3f}డత"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("крикет"),
            keywords: &["крикет", "малах"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("จ\u{e34}\u{e49}งหร\u{e35}ด"),
            keywords: &["จ\u{e34}\u{e49}งหร\u{e35}ด", "ต\u{e31}\u{e4a}กแตน"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("çybyn"),
            keywords: &["çekirtge", "çybyn"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kālihi"),
            keywords: &["kālihi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("cırcır böceği"),
            keywords: &["cırcır böceği", "çekirge"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("پالاقتوپ"),
            keywords: &["ياچىۋەك", "پالاقتوپ"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("цвіркун"),
            keywords: &["коник", "цвіркун"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("گرگٹ"),
            keywords: &["ٹڈا", "گرگٹ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("qora chigirtka"),
            keywords: &["chigirtka", "qora chigirtka"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("dế"),
            keywords: &["châu chấu", "dế"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kriket"),
            keywords: &["kriket", "soccet"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iqakamba"),
            keywords: &["intothoviyane", "iqakamba"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("tata gígùn"),
            keywords: &["tata", "tata gígùn"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("草蜢"),
            keywords: &["草蜢"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("草蜢"),
            keywords: &["草蜢"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("蟋蟀"),
            keywords: &["蛐蛐", "蟋蟀"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("蟋蟀"),
            keywords: &["蟋蟀"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ikhilikithi"),
            keywords: &["ikhilikithi", "iqhwagi"],
        },
    ],
};
#[doc = "🪳"]
pub const COCKROACH: crate::Emoji = crate::Emoji {
    glyph: "🪳",
    codepoint: "1FAB3",
    status: crate::Status::FullyQualified,
    introduction_version: 13f32,
    name: "cockroach",
    group: "Animals & Nature",
    subgroup: "animal-bug",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("kakkerlak"),
            keywords: &["gogga", "insek", "kakkerlak", "kokkerot", "pes"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("በረሮ"),
            keywords: &["በረሮ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("صرصور"),
            keywords: &["جدجد", "حشرة", "صرصور"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("প\u{981}ইত\u{9be}চোৰ\u{9be}"),
            keywords: &["কীট", "প\u{981}ইত\u{9be}চোৰ\u{9be}", "পতঙ\u{9cd}গ", "ৰোচ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("mətbəxqurdu"),
            keywords: &["həşərat", "mətbəxqurdu", "parazit", "tarakan"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("таракан"),
            keywords: &["насякомае", "паразіт", "прусак", "таракан"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("хлебарка"),
            keywords: &["вредител", "напаст", "насекомо", "хлебарка"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("আরসোল\u{9be}"),
            keywords: &["আরসোল\u{9be}", "কীট", "কীটপতঙ\u{9cd}গ", "পোক\u{9be}"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("cʼhwil-du"),
            keywords: &["amprevan", "cʼhwil-du"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("žohar"),
            keywords: &["bubašvaba", "insekt", "štetočina", "žohar"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("panerola"),
            keywords: &[
                "ballarola",
                "cuca molla",
                "cuca panissera",
                "escarabat de cuina",
                "insecte",
                "panderola",
                "panerola",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏂᎾᏌ"),
            keywords: &["ᎤᏂᎾᏌ", "ᎾᏌ", "ᏥᏍᎪᏯ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("šváb"),
            keywords: &["hmyz", "škůdce", "šváb"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("chwilen ddu"),
            keywords: &["chwilen ddu", "cochiad", "pla", "pryfyn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kakerlak"),
            keywords: &["insekt", "kakerlak", "skadedyr"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Kakerlake"),
            keywords: &["Insekt", "Kakerlake", "Schabe"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κατσαρίδα"),
            keywords: &["έντομο", "κατσαρίδα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("cockroach"),
            keywords: &["cockroach", "insect", "pest", "roach"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cucaracha"),
            keywords: &["alimaña", "bicho", "cucaracha", "insecto", "plaga"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("cucaracha"),
            keywords: &["cucaracha"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("cucaracha"),
            keywords: &["cucaracha"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("prussakas"),
            keywords: &["prussakas", "putukas", "tarakan"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("labezomorro"),
            keywords: &["intsektua", "labezomorro", "labezomorroa", "mokotarroa"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("سوسک حمام"),
            keywords: &["حشره", "سوسک", "سوسک حمام"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("torakka"),
            keywords: &["hyönteinen", "russakka", "torakka", "tuholainen"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("ipis"),
            keywords: &["insekto", "ipis"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("kakkulakkur"),
            keywords: &[
                "farsótt",
                "kakkulakkur",
                "pest",
                "skaðadýr",
                "skaðakykt",
                "skordýr",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("cafard"),
            keywords: &["blatte", "cafard", "insecte", "nuisible"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("coquerelle"),
            keywords: &["cafard", "coquerelle", "insecte", "nuisible"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("blatóg choiteann"),
            keywords: &["blatóg choiteann", "ciaróg dhubh", "feithid", "lotnaid"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("càrnan-gallda"),
            keywords: &[
                "biastag",
                "bèisteag",
                "càrnan-gallda",
                "daolag",
                "fiolan",
                "meanbh-fhrìde",
                "plàigh",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cascuda"),
            keywords: &["becho", "bicho", "cascuda", "cucaracha", "insecto"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("વા\u{a82}દો"),
            keywords: &[
                "ઉપદ\u{acd}રવી જીવાત",
                "જ\u{a82}ત\u{ac1}",
                "રોચ",
                "વા\u{a82}દો",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("תיקן"),
            keywords: &["ג׳וק", "חרק", "תיקן"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("तिलचट\u{94d}टा"),
            keywords: &["कीट", "कीड\u{93c}ा", "कॉकरोच", "तिलचट\u{94d}टा"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("žohar"),
            keywords: &["insekt", "kukac", "nametnik", "žohar"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("csótány"),
            keywords: &["csótány", "kártevő", "rovar", "svábbogár"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ուտիճ"),
            keywords: &["խավարասեր", "միջատ", "ուտիճ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kecoak"),
            keywords: &["coro", "hama", "kecoak", "serangga"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kakkalakki"),
            keywords: &["kakkalakki", "plága", "skordýr"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("scarafaggio"),
            keywords: &["blatta", "infestante", "insetto", "scarafaggio"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ゴキブリ"),
            keywords: &["ゴキブリ", "害虫", "虫"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("coro"),
            keywords: &["ama", "coro", "kecoak", "serangga"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ტარაკანი"),
            keywords: &["აბანოს ჭია", "ინსექტი", "ტარაკანი", "ხოჭო"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("тарақан"),
            keywords: &["жәндік", "зиянкес", "тарақан"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("កន\u{17d2}លាត"),
            keywords: &[
                "កន\u{17d2}លាត",
                "សត\u{17d2}វចង\u{17d2}រៃ",
                "សត\u{17d2}វល\u{17d2}អ\u{17b7}ត",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಜ\u{cbf}ರಳ\u{cc6}"),
            keywords: &["ಕೀಟ", "ಜ\u{cbf}ರಳ\u{cc6}", "ರೋಚ\u{ccd}", "ಹುಳು"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("바퀴벌레"),
            keywords: &["곤충", "바퀴벌레", "벌레", "해충"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("जल\u{94d}लो"),
            keywords: &[
                "किटक",
                "किटाण\u{942}",
                "किडो",
                "ज\u{902}त\u{942}",
                "जल\u{94d}लो",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("таракан"),
            keywords: &["таракан"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ແມງ\u{200b}ສາບ"),
            keywords: &["ແມງ\u{200b}ສາບ", "ແມງ\u{200b}ໄມ\u{ec9}"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("tarakonas"),
            keywords: &["tarakonas", "vabzdys"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("tarakāns"),
            keywords: &["insekts", "kaitēklis", "prusaks", "tarakāns"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("лебарка"),
            keywords: &["инсект", "лебарка", "штетник"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ക\u{d42}റ"),
            keywords: &["കീടം", "ക\u{d42}റ", "ക\u{d43}മി കീടം", "പ\u{d3e}റ\u{d4d}റ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("жоом"),
            keywords: &["жоом", "нисдэг шавж", "хортон шавж"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("झ\u{941}रळ"),
            keywords: &["कीटक", "कीडा", "गोडया पाण\u{94d}यातील मासा", "झ\u{941}रळ"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("lipas"),
            keywords: &["lipas", "perosak", "serangga"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပ\u{102d}\u{102f}းဟပ\u{103a}"),
            keywords: &[
                "ပ\u{102d}\u{102f}းမ\u{103d}\u{103e}ား",
                "ပ\u{102d}\u{102f}းဟပ\u{103a}",
                "အင\u{103a}းဆက\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kakerlakk"),
            keywords: &["dyr", "insekt", "kakerlakk", "utøy"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("साङ\u{94d}लो"),
            keywords: &["किरा", "प\u{947}स\u{94d}\u{200d}ट", "रोच", "साङ\u{94d}लो"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("kakkerlak"),
            keywords: &["bakkerstor", "insect", "kakkerlak", "ongedierte"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kakerlakk"),
            keywords: &["dyr", "insekt", "kakerlakk", "utøy"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଅସରପ\u{b3e}"),
            keywords: &[
                "ଅନ\u{b3f}ଷ\u{b4d}ଟକ\u{b3e}ରୀ କୀଟ",
                "ଅସରପ\u{b3e}",
                "କୀଟପତଙ\u{b4d}ଗ",
                "ରୋଚ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕਾਕਰ\u{a4b}ਚ"),
            keywords: &["ਕਾਕਰ\u{a4b}ਚ", "ਕੀੜਾ", "ਭ\u{a42}\u{a70}ਡ", "ਮਕ\u{a4b}ੜਾ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Kókroch"),
            keywords: &["Kókroch", "Pẹst", "Roch", "Ínsẹkt"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("karaluch"),
            keywords: &["karaczan", "karaluch", "owad"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ګړندى"),
            keywords: &["حشره", "روچ", "مضره حشره", "ګړندى"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("barata"),
            keywords: &["barata", "baratas", "inseto", "praga"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("cucaracha"),
            keywords: &["chʼuspi", "cucaracha", "parasito"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("gândac de bucătărie"),
            keywords: &["gândac de bucătărie", "insectă", "parazit"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E13-034"),
            keywords: &["E13-034"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("таракан"),
            keywords: &["вредитель", "насекомое", "прусак", "таракан"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪاڪروچ"),
            keywords: &["جيت", "روچ", "پيسٽ", "ڪاڪروچ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කැරපොත\u{dca}ත\u{dcf}"),
            keywords: &[
                "කැරපොත\u{dca}ත",
                "කැරපොත\u{dca}ත\u{dcf}",
                "කෘම\u{dd3}න\u{dca}",
                "පළ\u{dd2}බෝධ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("šváb"),
            keywords: &["hmyz", "škodca", "šváb"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("ščurek"),
            keywords: &["ščurek", "žuželka"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("baranbaro"),
            keywords: &["baranbaro", "baranbarooyin", "cayayaan"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kacabu"),
            keywords: &["buburrec", "insekt", "insekt i dëmshëm", "kacabu"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("бубашваба"),
            keywords: &["буба", "бубашваба", "инсект", "напаст"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("bubašvaba"),
            keywords: &["buba", "bubašvaba", "insekt", "napast"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("kackerlacka"),
            keywords: &["insekt", "kackerlacka", "skadedjur"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kombamwiko"),
            keywords: &["kijidudu", "kombamwiko", "mdudu", "mende"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கரப\u{bcd}ப\u{bbe}ன\u{bcd} பூச\u{bcd}சி"),
            keywords: &["கரப\u{bcd}ப\u{bbe}ன\u{bcd} பூச\u{bcd}சி", "பூச\u{bcd}சி"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("బ\u{c4a}ద\u{c4d}ద\u{c3f}ంక"),
            keywords: &["క\u{c40}టకం", "బ\u{c4a}ద\u{c4d}ద\u{c3f}ంక"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("แมลงสาบ"),
            keywords: &["ศ\u{e31}ตร\u{e39}พ\u{e37}ช", "แมลง", "แมลงสาบ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("saçakçy"),
            keywords: &["mör-möjek", "saçakçy", "tarakan"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mongomonga"),
            keywords: &["mongomonga"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("hamam böceği"),
            keywords: &["böcek", "hamam böceği", "haşere", "karafatma"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("тарган"),
            keywords: &["комаха", "прусак", "тарган", "шкідник"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("لال بیگ"),
            keywords: &["تل چٹا", "حشرات", "لال بیگ", "کیڑا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("suvarak"),
            keywords: &["chuqurcha", "hasharot", "suvarak"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("con gián"),
            keywords: &["con gián", "côn trùng"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("曱甴"),
            keywords: &["昆蟲", "曱甴"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("曱甴"),
            keywords: &["昆虫", "曱甴"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("蟑螂"),
            keywords: &["害虫", "昆虫", "蟑螂"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("蟑螂"),
            keywords: &["小強", "蟑螂"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("蟑螂"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ikokoroshe"),
            keywords: &["ikokoroshe", "iphela", "isinambuzane"],
        },
    ],
};
#[doc = "🕷\u{fe0f}"]
pub const SPIDER: crate::Emoji = crate::Emoji {
    glyph: "🕷\u{fe0f}",
    codepoint: "1F577 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "spider",
    group: "Animals & Nature",
    subgroup: "animal-bug",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🕷",
        codepoint: "1F577",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "spider",
        group: "Animals & Nature",
        subgroup: "animal-bug",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("spinnekop"),
            keywords: &["gogga", "insek", "spinnekop"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("እንሸረሪት"),
            keywords: &["ነፍሳት", "እንሸረሪት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("عنكبوت"),
            keywords: &["حشرة", "عنكبوت"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("মকৰ\u{9be}"),
            keywords: &["পতঙ\u{9cd}গ", "মকৰ\u{9be}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("hörümçək"),
            keywords: &["hörümçək", "həşərat"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("павук"),
            keywords: &["насякомае", "павук"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("паяк"),
            keywords: &["паяк"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ম\u{9be}কড\u{9bc}স\u{9be}"),
            keywords: &["পোক\u{9be}", "ম\u{9be}কড\u{9bc}স\u{9be}"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kevnidenn"),
            keywords: &["kevnidenn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("pauk"),
            keywords: &["insekt", "pauk"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("aranya"),
            keywords: &["aranya", "insecte"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄟𑄉\u{11127}𑄢\u{11127}𑄇\u{11134}"),
            keywords: &["𑄟𑄉\u{11127}𑄢\u{11127}𑄇\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎧᎿᏁᏍᎩ"),
            keywords: &["ᎧᎿᏁᏍᎩ", "ᏥᏍᎪᏯ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("pavouk"),
            keywords: &["hmyz", "pavouk"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("pry copyn"),
            keywords: &["chwilen", "pry copyn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("edderkop"),
            keywords: &["edderkop", "insekt"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Spinne"),
            keywords: &["Insekt", "Spinne", "Tier"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("αράχνη"),
            keywords: &["έντομο", "αράχνη"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("spider"),
            keywords: &["insect", "spider"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["arachnid", "spider"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("araña"),
            keywords: &["animal", "araña", "insecto"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("ämblik"),
            keywords: &["ämblik"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("armiarma"),
            keywords: &["armiarma", "intsektu"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("عنکبوت"),
            keywords: &["حشره", "عنکبوت"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("hämähäkki"),
            keywords: &["hyönteinen", "hämähäkki"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("gagamba"),
            keywords: &["gagamba", "insekto"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("eiturkoppur"),
            keywords: &["eiturkoppur", "skordýr"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("araignée"),
            keywords: &["animal", "araignée", "insecte"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["araignée"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("damhán alla"),
            keywords: &["damhán alla", "feithid"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("damhan-allaidh"),
            keywords: &[
                "biastag",
                "bèisteag",
                "damhan-allaidh",
                "fiolan",
                "meanbh-fhrìde",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("araña"),
            keywords: &["araña"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("કરોળિયો"),
            keywords: &["કરોળિયો", "જ\u{a82}ત\u{ac1}"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("gizo"),
            keywords: &["gizo", "ƙwaro"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("עכביש"),
            keywords: &["חרק", "עכביש"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("मकड\u{93c}ी"),
            keywords: &["कीट", "मकड\u{93c}ी"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("pauk"),
            keywords: &["insekt", "pauk"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("pók"),
            keywords: &["pók", "rovar"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("սարդ"),
            keywords: &["միջատ", "սարդ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("laba-laba"),
            keywords: &["laba-laba", "serangga"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ududo"),
            keywords: &["ahụhụ", "ududo"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("könguló"),
            keywords: &["könguló", "skordýr"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("ragno"),
            keywords: &["animale", "insetto", "ragno"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("クモ"),
            keywords: &["クモ", "スパイダー", "虫"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("angga-angga"),
            keywords: &["angga-angga", "serangga"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ობობა"),
            keywords: &["მწერი", "ობობა"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("tissist"),
            keywords: &["tissist"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("өрмекші"),
            keywords: &["шыбын-шіркей", "өрмекші"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("edderkop"),
            keywords: &["edderkop", "insekt"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ព\u{17b8}ងពាង"),
            keywords: &["ព\u{17b8}ងពាង", "សត\u{17d2}វល\u{17d2}អ\u{17b7}ត"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಜೇಡ"),
            keywords: &["ಕೀಟ", "ಜೇಡ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("거미"),
            keywords: &["거미", "곤충", "벌레", "스파이더"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("मावली"),
            keywords: &["किटक", "कोळी", "मावली"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жөргөмүш"),
            keywords: &["жөргөмүш", "курт-кумурска"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Spann"),
            keywords: &["Insekt", "Spann"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ແມງມ\u{eb8}ມ"),
            keywords: &["ສ\u{eb1}ດ", "ແມງມ\u{eb8}ມ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("voras"),
            keywords: &["vabzdys", "voras"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("zirneklis"),
            keywords: &["kukainis", "zirneklis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("ngārara"),
            keywords: &["ngārara", "pēpeke"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("пајак"),
            keywords: &["инсект", "пајак"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ചിലന\u{d4d}തി"),
            keywords: &[
                "ചിലന\u{d4d}തി",
                "പ\u{d4d}ര\u{d3e}ണം",
                "ഷഡ\u{d4d}\u{200c}പദം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("аалз"),
            keywords: &["аалз", "шавж"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("कोळी"),
            keywords: &["किडा", "कोळी"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("labah-labah"),
            keywords: &["labah-labah", "serangga"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("brimba"),
            keywords: &["brimba", "insett"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပင\u{1037}\u{103a}က\u{1030}"),
            keywords: &[
                "ပင\u{1037}\u{103a}က\u{1030}",
                "ပ\u{102d}\u{102f}းမ\u{103d}\u{103e}ား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("edderkopp"),
            keywords: &["dyr", "edderkopp", "insekt"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("माक\u{941}रा"),
            keywords: &["कमिला", "माक\u{941}रा"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("spin"),
            keywords: &["insect", "spin"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("edderkopp"),
            keywords: &["dyr", "edderkopp", "insekt"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବ\u{b41}ଢ\u{b3f}ଆଣୀ"),
            keywords: &["କୀଟ", "ବ\u{b41}ଢ\u{b3f}ଆଣୀ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਮ\u{a71}ਕੜੀ"),
            keywords: &["ਕਿਰਮ", "ਕੀੜਾ", "ਮ\u{a71}ਕੜੀ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("مکڑی"),
            keywords: &["حشرات", "مکڑی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Spaída"),
            keywords: &["Spaída", "Ínsẹkt"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("pająk"),
            keywords: &["pajączek", "pająk", "pajęczak"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("غڼې"),
            keywords: &["حشره، غڼې", "غڼې"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("aranha"),
            keywords: &["aranha", "inseto"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["aranha", "insecto", "inseto"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("kusi kusi"),
            keywords: &["ch’uspi", "kusi kusi"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("păianjen"),
            keywords: &["arahnidă", "insectă", "pânză", "păianjen"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-798"),
            keywords: &["E10-798"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("паук"),
            keywords: &["насекомое", "паук"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("igitagangurirwa"),
            keywords: &["agakoko", "igitagangurirwa"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪوريئڙو"),
            keywords: &["جيت", "ڪوريئڙو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("මක\u{dd4}ළ\u{dd4}ව\u{dcf}"),
            keywords: &["කෘම\u{dd2}ය\u{dcf}", "මක\u{dd4}ළ\u{dd4}ව\u{dcf}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("pavúk"),
            keywords: &["hmyz", "pavúk"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("pajek"),
            keywords: &["pajek", "žuželka"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("caaro"),
            keywords: &["caaro", "cayayaan"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("merimangë"),
            keywords: &["insekt", "merimangë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("паук"),
            keywords: &["инсeкт", "паук"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("pauk"),
            keywords: &["insekt", "pauk"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("spindel"),
            keywords: &["djur", "insekt", "spindel"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("buibui"),
            keywords: &["buibui", "mdudu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சிலந\u{bcd}தி"),
            keywords: &["சிலந\u{bcd}தி", "பூச\u{bcd}சி"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("స\u{c3e}ల\u{c40}డు"),
            keywords: &["క\u{c40}టకం", "స\u{c3e}ల\u{c40}డు"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тортанак"),
            keywords: &["тортанак", "ҳашарот"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("แมงม\u{e38}ม"),
            keywords: &["แมงม\u{e38}ม", "แมลง"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("möý"),
            keywords: &["mör-möjekler", "möý"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("hina"),
            keywords: &["hina"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("örümcek"),
            keywords: &["böcek", "örümcek"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئۆمۈچۈك"),
            keywords: &["ئۆمۈچۈك", "ھاشارات"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("павук"),
            keywords: &["комаха", "павук"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("مکڑی"),
            keywords: &["مکڑی", "کیڑا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("o‘rgimchak"),
            keywords: &["o‘rgimchak", "xasharot"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nhện"),
            keywords: &["côn trùng", "nhện"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("jargoñ"),
            keywords: &["gunóor bu sew", "jargoñ"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isigcawu"),
            keywords: &["isigcawu", "isinambuzane"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("aláõtakùn"),
            keywords: &["aláõtakùn", "kòkòrò"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("蜘蛛"),
            keywords: &["昆蟲", "蜘蛛"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("蜘蛛"),
            keywords: &["昆虫", "蜘蛛"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("蜘蛛"),
            keywords: &["蜘蛛"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("蜘蛛"),
            keywords: &["蜘蛛"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["昆蟲", "蜘蛛"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isicabucabu"),
            keywords: &["isicabucabu", "isilokozane"],
        },
    ],
};
#[doc = "🕸\u{fe0f}"]
pub const SPIDER_WEB: crate::Emoji = crate::Emoji {
    glyph: "🕸\u{fe0f}",
    codepoint: "1F578 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "spider web",
    group: "Animals & Nature",
    subgroup: "animal-bug",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🕸",
        codepoint: "1F578",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "spider web",
        group: "Animals & Nature",
        subgroup: "animal-bug",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("spinnerak"),
            keywords: &["spinnekop", "spinnerak", "web"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የእንሸረሪት ድር"),
            keywords: &["እንሸረሪት", "የእንሸረሪት ድር", "ድር"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("شبكة عنكبوت"),
            keywords: &["شبكة", "عنكبوت"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("মকৰ\u{9be} জ\u{9be}ল"),
            keywords: &["জ\u{9be}ল", "মকৰ\u{9be}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("hörümçək toru"),
            keywords: &["hörümçək", "hörümçək toru", "tor"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("павуцінне"),
            keywords: &["павук", "павуцінне"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("паяжина"),
            keywords: &["паяжина", "паяк"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ম\u{9be}কড\u{9bc}স\u{9be}র জ\u{9be}ল"),
            keywords: &[
                "জ\u{9be}ল",
                "ম\u{9be}কড\u{9bc}স\u{9be}",
                "ম\u{9be}কড\u{9bc}স\u{9be}র জ\u{9be}ল",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("gwiad-kevnid"),
            keywords: &["gwiad", "gwiad-kevnid", "kevnid"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("paukova mreža"),
            keywords: &["mreža", "pauk", "paukova mreža"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("teranyina"),
            keywords: &["aranya", "teranyina"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄟𑄉\u{11127}𑄢\u{11127}𑄇\u{11134} 𑄎𑄣\u{11134}"),
            keywords: &["𑄟𑄉\u{11127}𑄢\u{11127}𑄇\u{11134} 𑄎𑄣\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎧᎿᏁᏍᎩ ᎤᏏᎳᏛᎢ"),
            keywords: &["ᎤᏏᎳᏛᎢ", "ᎧᎿᏁᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("pavučina"),
            keywords: &["pavouk", "pavoučí", "pavučina", "síť"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("gwe pry cop"),
            keywords: &["gwe", "gwe pry cop", "pry copyn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("edderkoppespind"),
            keywords: &["edderkop", "edderkoppespind", "spind"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Spinnennetz"),
            keywords: &["Netz", "Spinne", "Spinnennetz"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ιστός αράχνης"),
            keywords: &["αράχνη", "ιστός", "ιστός αράχνης"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("spider web"),
            keywords: &["spider", "web"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("spider’s web"),
            keywords: &["spider", "spider’s web", "web"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("spider web"),
            keywords: &["spider", "web"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("tela de araña"),
            keywords: &["araña", "tela", "tela de araña", "telaraña"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("telaraña"),
            keywords: &["araña", "tela", "telaraña"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["araña", "telaraña"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("ämblikuvõrk"),
            keywords: &["võrk", "ämblik", "ämblikuvõrk"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("armiarma-sarea"),
            keywords: &["armiarma", "armiarma-sarea", "sarea"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("تار عنکبوت"),
            keywords: &["تار", "عنکبوت"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("hämähäkin seitti"),
            keywords: &["hämähäkin seitti", "hämähäkki", "seitti", "verkko"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("sapot"),
            keywords: &["gagamba", "insekto", "sapot"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("eiturkoppanót"),
            keywords: &["eiturkoppanót", "eiturkoppur", "nót", "vev"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("toile d’araignée"),
            keywords: &["araignée", "toile", "toile d’araignée"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["araignée", "toile", "toile d’araignée"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("líon damháin alla"),
            keywords: &["damhán alla", "líon damháin alla", "líontán"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("lìon damhain-allaidh"),
            keywords: &[
                "damhan-allaidh",
                "eige",
                "lìon",
                "lìon damhain-allaidh",
                "oige",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("tea de araña"),
            keywords: &["araña", "arañeira", "tea de araña"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("કરોળિયાન\u{ac1}\u{a82} જાળ\u{ac1}\u{a82}"),
            keywords: &[
                "કરોળિયાન\u{ac1}\u{a82} જાળ\u{ac1}\u{a82}",
                "કરોળિયો",
                "જાળ\u{ac1}\u{a82}",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("yanar gizo"),
            keywords: &["gizo", "yanar gizo"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("קורי עכביש"),
            keywords: &["עכביש", "קורי עכביש", "קורים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("मकड\u{93c}ी का जाला"),
            keywords: &["जाला", "मकड\u{93c}ी का जाला"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("paukova mreža"),
            keywords: &["mreža", "pauk", "paukova mreža"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("pókháló"),
            keywords: &["háló", "pók", "pókháló"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("սարդոստայն"),
            keywords: &["ոստայն", "սարդ", "սարդոստայն", "ցանց"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("jaring laba-laba"),
            keywords: &["jaring laba-laba", "laba-laba", "sarang"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ọnyà ududo"),
            keywords: &["udodo", "ọnyà ududo"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("köngulóarvefur"),
            keywords: &["könguló", "köngulóarvefur", "vefur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("ragnatela"),
            keywords: &["ragnatela", "ragno"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("クモの巣"),
            keywords: &["クモ", "クモの巣"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("jaring angga-angga"),
            keywords: &["angga-angga", "jaring"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ობობის ქსელი"),
            keywords: &["ობობა", "ობობის ქსელი", "ქსელი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("azeṭṭa n tissit"),
            keywords: &["azeṭṭa n tissit"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("өрмекші торы"),
            keywords: &["тор", "өрмекші", "өрмекші торы"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("edderkoppespind"),
            keywords: &["edderkop", "edderkoppespind", "spind"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ស\u{17c6}ណាញ\u{17cb}ព\u{17b8}ងពាង"),
            keywords: &["ព\u{17b8}ងពាង", "ស\u{17c6}ណាញ\u{17cb}ព\u{17b8}ងពាង"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಜೇಡರ ಬಲ\u{cc6}"),
            keywords: &["ಜೇಡ", "ಜೇಡರ ಬಲ\u{cc6}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("거미줄"),
            keywords: &["거미", "거미줄"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: None,
            keywords: &["जाळ\u{947}\u{902}", "मावली"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жөргөмүш желеси"),
            keywords: &["желе", "жөргөмүш", "жөргөмүш желеси"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Spannennetz"),
            keywords: &["Netz", "Spann", "Spannennetz"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໃຍແມງມ\u{eb8}ມ"),
            keywords: &["ແມງມ\u{eb8}ມ", "ໃຍ", "ໃຍແມງມ\u{eb8}ມ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("voratinklis"),
            keywords: &["tinklas", "voras", "voratinklis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("zirnekļa tīkls"),
            keywords: &["tīkls", "zirneklis", "zirnekļa tīkls"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tukutuku ngārara"),
            keywords: &["ngārara", "tukutuku"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("пајакова мрежа"),
            keywords: &["мрежа", "пајак", "пајакова мрежа"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ചിലന\u{d4d}തി വല"),
            keywords: &["ചിലന\u{d4d}തി", "ചിലന\u{d4d}തി വല", "ചിലന\u{d4d}തിവല"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("аалзны тор"),
            keywords: &["аалз", "аалзны тор", "тор"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("कोळ\u{94d}\u{200d}याच\u{947} जाळ\u{947}"),
            keywords: &[
                "कोळी",
                "कोळ\u{94d}\u{200d}याच\u{947} जाळ\u{947}",
                "जाळ\u{947}",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("sarang labah-labah"),
            keywords: &["labah-labah", "sarang"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("għanqbuta"),
            keywords: &["brimba", "għanqbuta"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပင\u{1037}\u{103a}က\u{1030}မျ\u{103e}င\u{103a}"),
            keywords: &[
                "ပင\u{1037}\u{103a}က\u{1030}",
                "ပင\u{1037}\u{103a}က\u{1030}မျ\u{103e}င\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("spindelvev"),
            keywords: &["edderkopp", "nett", "spindelvev"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("माक\u{941}राको जालो"),
            keywords: &["जालो", "माक\u{941}रा", "माक\u{941}राको जालो"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("spinnenweb"),
            keywords: &["spin", "spinnenweb", "web"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("spindelvev"),
            keywords: &["edderkopp", "nett", "spindelvev"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବ\u{b41}ଢ\u{b3f}ଆଣୀ ଜ\u{b3e}ଲ"),
            keywords: &[
                "ଜ\u{b3e}ଲ",
                "ବ\u{b41}ଢ\u{b3f}ଆଣ\u{b3f}",
                "ବ\u{b41}ଢ\u{b3f}ଆଣୀ ଜ\u{b3e}ଲ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਮ\u{a71}ਕੜੀ ਦਾ ਜਾਲਾ"),
            keywords: &["ਜਾਲਾ", "ਮ\u{a71}ਕੜੀ", "ਮ\u{a71}ਕੜੀ ਦਾ ਜਾਲਾ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("مکڑی دا جالا"),
            keywords: &["مکڑی", "مکڑی دا جالا", "ویب"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Spaídá Wẹb"),
            keywords: &["Spaída", "Spaídá Wẹb", "Wẹb"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("pajęczyna"),
            keywords: &["pajęczyna", "sieć pająka"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د غڼې ويب"),
            keywords: &["د غڼې ويب"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("teia de aranha"),
            keywords: &["aranha", "inseto", "teia", "teia de aranha"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["aranha", "teia", "teia de aranha"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("llika"),
            keywords: &["kusi kusi", "llika"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("pânză de păianjen"),
            keywords: &["capcană", "pânză", "pânză de păianjen", "păianjen"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-799"),
            keywords: &["E10-799"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("паутина"),
            keywords: &["паук", "паутина", "сеть"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umugozi w’igitagangurirwa"),
            keywords: &["igitagangurirwa", "umugozi", "umugozi w’igitagangurirwa"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪوريئڙي جي ڄار"),
            keywords: &["ڪوريئڙو، ڄار", "ڪوريئڙي جي ڄار"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("මක\u{dd4}ළ\u{dd4} දැල"),
            keywords: &["මක\u{dd4}ළ\u{dd4} දැල", "මක\u{dd4}ළ\u{dd4}ව\u{dcf}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("pavučina"),
            keywords: &["pavučina", "pavúk", "sieť"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("pajkova mreža"),
            keywords: &["mreža", "pajek", "pajkova mreža"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("xuub caaro"),
            keywords: &["xuub caaro"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("rrjetë merimange"),
            keywords: &["merimangë", "rrjetë", "rrjetë merimange"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("паукова мрежа"),
            keywords: &["мрeжa", "пaук", "паукова мрежа"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["паукова мрежа"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("paukova mreža"),
            keywords: &["mreža", "pauk", "paukova mreža"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["paukova mreža"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("spindelnät"),
            keywords: &["nät", "spindel", "spindelnät"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("tandabui"),
            keywords: &["buibui", "tandabui"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சிலந\u{bcd}தி வலை"),
            keywords: &[
                "சிலந\u{bcd}தி",
                "சிலந\u{bcd}தி வலை",
                "சிலந\u{bcd}தி வ\u{bc0}டு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("స\u{c3e}ల\u{c40}డు గూడు"),
            keywords: &["గూడు", "స\u{c3e}ల\u{c40}డు"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тори тортанак"),
            keywords: &["тори тортанак", "тортанак"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ใยแมงม\u{e38}ม"),
            keywords: &["แมงม\u{e38}ม", "ใย", "ใยแมงม\u{e38}ม"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("möýüň kerebi"),
            keywords: &["kerep", "möý", "möýüň kerebi"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("matamatakupenga"),
            keywords: &["matamatakupenga"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("örümcek ağı"),
            keywords: &["örümcek", "örümcek ağı"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئۆمۈچۈك تورى"),
            keywords: &["ئۆمۈچۈك", "ئۆمۈچۈك تورى", "تور"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("павутиння"),
            keywords: &["павук", "павутина", "павутиння"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("مکڑی کا جالا"),
            keywords: &["مکڑی", "مکڑی کا جالا", "کیڑا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("o‘rgimchak turi"),
            keywords: &["oʻrgimchak", "o‘rgimchak turi", "toʻr"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mạng nhện"),
            keywords: &["mạng nhện", "nhện"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("lëndu jargoñ"),
            keywords: &["jargoñ", "lënd", "lëndu jargoñ"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("indlu yesigcawu"),
            keywords: &["indlu yesigcawu", "isigcawu"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ìtakùnaláõtakùn"),
            keywords: &["ìtakùn", "ìtakùnaláõtakùn"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("蜘蛛網"),
            keywords: &["網", "蜘蛛", "蜘蛛網"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("蜘蛛网"),
            keywords: &["网", "蜘蛛", "蜘蛛网"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("蜘蛛网"),
            keywords: &["蛛网", "蜘蛛网"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("蜘蛛網"),
            keywords: &["蛛網", "蜘蛛網"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["網", "蜘蛛網"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ulwembu lwesicabucabu"),
            keywords: &["isicabucabu", "ulwembu", "ulwembu lwesicabucabu"],
        },
    ],
};
#[doc = "🦂"]
pub const SCORPION: crate::Emoji = crate::Emoji {
    glyph: "🦂",
    codepoint: "1F982",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "scorpion",
    group: "Animals & Nature",
    subgroup: "animal-bug",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("skerpioen"),
            keywords: &["Scorpius", "diereriem", "skerpioen"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ጊንጥ"),
            keywords: &["ስኮርፒየስ", "ስኮርፒዮ", "ዞዲያክ", "ጊንጥ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("عقرب"),
            keywords: &["برج", "عقرب"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ব\u{9c3}শ\u{9cd}চিক"),
            keywords: &[
                "ব\u{9c3}শ\u{9cd}চিক",
                "ব\u{9c3}শ\u{9cd}চিকৰ\u{9be}শি",
                "ৰ\u{9be}শি",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("əqrəb"),
            keywords: &["zodiak", "əqrəb"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("скарпіён"),
            keywords: &["задыяк", "скарпіён"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("скорпион"),
            keywords: &["зодиак", "зодиакален знак", "зодия", "скорпион"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ব\u{9c3}শ\u{9cd}চিক র\u{9be}শি"),
            keywords: &[
                "ব\u{9c3}শ\u{9cd}চিক র\u{9be}শি",
                "ব\u{9c3}শ\u{9cd}চিকর\u{9be}শি",
                "র\u{9be}শিচক\u{9cd}র",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("krug"),
            keywords: &["krug", "loen"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("škorpion"),
            keywords: &["horoskopski znak", "škorpija", "škorpion"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("escorpí"),
            keywords: &["Escorpió", "animal", "escorpí", "zodíac"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄝\u{11128}𑄎\u{11133}𑄠"),
            keywords: &["𑄝\u{11128}𑄎\u{11133}𑄠"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏥᏍᏛᎾ ᎠᏓᏨᏍᎩ"),
            keywords: &["ᏃᏈᏏ ᏓᏟᎶᏍᏗᎲᎢ", "ᏥᏍᏛᎾ ᎠᏓᏨᏍᎩ", "ᏧᏁᎵᏁ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("škorpion"),
            keywords: &["zvěrokruh", "škorpion", "štír"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("sgorpion"),
            keywords: &["Sidydd", "sgorpio", "sgorpion", "y Sgorpion"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("skorpion"),
            keywords: &["skorpion", "skorpionen", "stjernetegn"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Skorpion"),
            keywords: &["Skorpion", "Sternzeichen", "Tierkreis"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σκορπιός"),
            keywords: &["ζώδιο", "σκορπιός"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("scorpion"),
            keywords: &["Scorpio", "scorpio", "scorpion", "zodiac"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("escorpión"),
            keywords: &["escorpio", "escorpión", "zodiaco"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["animal", "escorpión", "insecto", "venenoso"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("suur skorpion"),
            keywords: &["skorpion", "sodiaak", "suur skorpion"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("eskorpioia"),
            keywords: &["eskorpioi", "eskorpioia", "scorpius", "zodiako"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("عقرب"),
            keywords: &["برج عقرب", "برج فلکی", "زودیاک", "عقرب", "کژدم"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("skorpioni"),
            keywords: &["horoskooppi", "horoskooppimerkki", "skorpioni"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("alakdan"),
            keywords: &[
                "alakdan", "insekto", "scorpio", "scorpion", "scorpius", "zodiac",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("skorpión"),
            keywords: &["skorpión", "sporðdreki", "stjørnumerki"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("scorpion"),
            keywords: &["animal", "scorpion"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["scorpion", "zodiaque"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("scairp"),
            keywords: &["An Scairp", "scairp", "stoidiaca"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("sgairp"),
            keywords: &["grian-chriosach", "scorpio", "sgairp"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("alacrán"),
            keywords: &["Escorpión", "alacrán", "zodíaco"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("વી\u{a82}છી"),
            keywords: &["રાશિ", "વી\u{a82}છી", "સ\u{acd}કોર\u{acd}પિયો"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kunama"),
            keywords: &["Scorpius", "kunama", "scorpio", "zodiac"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("עקרב"),
            keywords: &["ארסי", "מזל עקרב", "עקרב", "צהוב", "שחור"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("बिच\u{94d}छ\u{942}, व\u{943}श\u{94d}चिक राशि"),
            keywords: &[
                "पश\u{942}",
                "बिच\u{94d}छ\u{942}",
                "बिच\u{94d}छ\u{942}, व\u{943}श\u{94d}चिक राशि",
                "व\u{943}श\u{94d}चिक राशि",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("škorpion"),
            keywords: &["zodijak", "škorpion"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("skorpió"),
            keywords: &["csillagjegy", "skorpió", "állatöv"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("շագանակագույն կարիճ"),
            keywords: &["թունավոր", "կարիճ", "կենդանակերպ", "շագանակագույն կարիճ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kalajengking"),
            keywords: &["kalajengking", "scorpio", "zodiak"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("akpị"),
            keywords: &["Nkwụkakpị", "akpị", "zodịak"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("sporðdreki"),
            keywords: &["sporðdreki", "stjörnumerki"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("scorpione"),
            keywords: &["animale", "scorpione", "segno zodiacale"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("サソリ"),
            keywords: &["サソリ", "星座", "虫"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kalajengking"),
            keywords: &["Scorpio", "kalajengking", "scorpio", "zodiakk"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მორიელი"),
            keywords: &["ზოდიაქო", "მორიელი", "ღრიანკალი", "ჰოროსკოპი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("tiɣiṛdemt"),
            keywords: &["tiɣiṛdemt"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("шаян"),
            keywords: &["зодиак", "сарышаян", "шаян"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("skorpion"),
            keywords: &["skorpion", "skorpionen", "stjernetegn"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ខ\u{17d2}យាដ\u{17c6}រ\u{17b8}"),
            keywords: &[
                "ខ\u{17d2}យាដ\u{17c6}រ\u{17b8}",
                "សត\u{17d2}វល\u{17d2}អ\u{17b7}ត",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಚೇಳು"),
            keywords: &["ಚೇಳು", "ರಾಶ\u{cbf}ಚಕ\u{ccd}ರ", "ವೃಶ\u{ccd}ಚ\u{cbf}ಕ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("전갈"),
            keywords: &["스콜피온", "전갈"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("विच\u{942}"),
            keywords: &[
                "रास",
                "वि\u{902}च\u{941}",
                "विच\u{942}",
                "व\u{943}श\u{94d}चीकरास",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("чаян"),
            keywords: &["зодиак", "чаян"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Skorpioun"),
            keywords: &["Skorpioun", "Stärzeechen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ແມງເງ\u{ebb}າ"),
            keywords: &["ພ\u{eb4}ຈ\u{eb4}ກ", "ລາສ\u{eb5}", "ແມງເງ\u{ebb}າ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("skorpionas (gyvūnas)"),
            keywords: &["skorpionas", "skorpionas (gyvūnas)", "zodiakas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("skorpions"),
            keywords: &["skorpions", "zodiaks"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kopiona"),
            keywords: &["Scorpius", "kopiona", "poutiriao", "scorpio"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("скорпија"),
            keywords: &["скорпија", "хороскоп"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("തേൾ"),
            keywords: &[
                "തേൾ",
                "ര\u{d3e}ശി ചക\u{d4d}രം",
                "സ\u{d4d}\u{200c}കോർപ\u{d4d}പിയോ ര\u{d3e}ശി",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хилэнц"),
            keywords: &["орд", "хилэнц"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("वि\u{902}च\u{942}"),
            keywords: &["राशीचक\u{94d}र", "वि\u{902}च\u{942}", "व\u{943}श\u{94d}चिक"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kala jengking"),
            keywords: &["kala jengking", "scorpio", "scorpius", "zodiak"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("skorpjun"),
            keywords: &["Scorpius", "scorpio", "skorpjun", "żodjaku"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ကင\u{103a}းမြ\u{102e}းကောက\u{103a}"),
            keywords: &[
                "ကင\u{103a}းမြ\u{102e}းကောက\u{103a}",
                "ဆယ\u{1037}\u{103a}န\u{103e}စ\u{103a}ရာသ\u{102e}ခ\u{103d}င\u{103a}",
                "ဗြ\u{102d}စ\u{1039}ဆာရာသ\u{102e}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("skorpion"),
            keywords: &[
                "dyr",
                "skorpion",
                "skorpionen",
                "stjernebilde",
                "stjernetegn",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("बिच\u{94d}छी"),
            keywords: &["बिच\u{94d}छी", "राशि"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("schorpioen"),
            keywords: &["Scorpio", "schorpioen", "sterrenbeeld"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("skorpion"),
            keywords: &[
                "dyr",
                "skorpion",
                "skorpionen",
                "stjernebilete",
                "stjerneteikn",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କଙ\u{b4d}କଡ\u{b3e}ବ\u{b3f}ଛ\u{b3e}"),
            keywords: &[
                "କଙ\u{b4d}କଡ\u{b3e}ବ\u{b3f}ଛ\u{b3e}",
                "ବ\u{b3f}ଛ\u{b3e} । ବ\u{b43}ଶ\u{b4d}ଚ\u{b3f}କ । ର\u{b3e}ଶ\u{b3f}ଚକ\u{b4d}ର",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬਿ\u{a71}ਛ\u{a42}"),
            keywords: &[
                "ਬਿ\u{a71}ਛ\u{a42}",
                "ਰਾਸ\u{a3c}ੀ ਚ\u{a71}ਕਰ",
                "ਸਕਾਰਪੀਅਸ",
                "ਸਕਾਰਪੀਓ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("بچھو"),
            keywords: &["ب\u{64f}رج", "بچھو", "عقرب"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Skọ\u{301}piọn"),
            keywords: &["Skọ\u{301}pio", "Skọ\u{301}piọn", "Zódiak"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("brązowy skorpion"),
            keywords: &["brązowy skorpion", "skorpion", "zodiak"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("شوبلکه"),
            keywords: &["شوبلکه", "شوبلکه، لړم، مرغومی"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("escorpião"),
            keywords: &["Escorpião", "escorpião", "inseto", "zodíaco"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("escorpião (animal)"),
            keywords: &["escorpião", "escorpião (animal)", "signo"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("escorpión"),
            keywords: &["Escorpio", "escorpio", "escorpión", "zodiaco"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("scorpion"),
            keywords: &["insectă", "scorpion", "venin", "zodiac"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1098"),
            keywords: &["E10-1098"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("скорпион"),
            keywords: &["знак зодиака", "зодиак", "скорпион"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("sikorupiyo"),
            keywords: &["ikorupiyusi", "sikorupiyo", "zodiyake"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("وڇون"),
            keywords: &["وڇون", "وڇون، عقرب، برج"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ගොන\u{dd4}ස\u{dca}ස\u{dcf}"),
            keywords: &[
                "ගොන\u{dd4}ස\u{dca}ස\u{dcf}",
                "ර\u{dcf}ශ\u{dd2} චක\u{dca}\u{200d}රය",
                "වෘශ\u{dca}ච\u{dd2}ක ර\u{dcf}ශ\u{dd2}ය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("škorpión"),
            keywords: &["škorpión"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("škorpijon"),
            keywords: &["zodiak", "škorpijon"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("dib qallooc"),
            keywords: &["dib qallooc", "mactab meecaad", "qoyska dib qallooc"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("akrep"),
            keywords: &["akrep", "akrepi", "zodiak"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("шкорпион"),
            keywords: &["зoдиjaк", "шкoрпиoн", "шкорпион", "шкорпија"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["шкорпион"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("škorpion"),
            keywords: &["zodijak", "škorpija", "škorpion"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["škorpion"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("skorpion"),
            keywords: &["skorpion", "skorpionen", "stjärntecken"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("ng’e"),
            keywords: &["ng’e", "zodiaki"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("தேள\u{bcd}"),
            keywords: &[
                "தேள\u{bcd}",
                "விருச\u{bcd}சிக ர\u{bbe}சி",
                "விருச\u{bcd}சிகம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("త\u{c47}లు"),
            keywords: &[
                "త\u{c47}లు",
                "ర\u{c3e}శ\u{c3f}",
                "వృశ\u{c4d}చ\u{c3f}కర\u{c3e}శ\u{c3f}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("каждум"),
            keywords: &["Ақраб", "бурҷи дувоздаҳгона", "каждум"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("แมงป\u{e48}อง"),
            keywords: &["พ\u{e34}จ\u{e34}ก", "ราศ\u{e35}", "แมงป\u{e48}อง"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("içýan"),
            keywords: &["Akrap", "içýan", "täleýnama"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("sikipio"),
            keywords: &["sikipio"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("akrep"),
            keywords: &["akrep", "burç"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("چايان"),
            keywords: &["ئېشەك", "مۆچەل", "چايان"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("скорпіон"),
            keywords: &["зодіак", "скорпіон"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بچھو"),
            keywords: &["بچھو", "جانور"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("chayon"),
            keywords: &["burj", "chayon"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bọ cạp"),
            keywords: &["bọ cạp", "cung bọ cạp", "cung hoàng đạo"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("jiit"),
            keywords: &["jiit", "sojak"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("unomadudwane"),
            keywords: &["i-Scorpius", "i-scorpio", "i-zodiac", "unomadudwane"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Àkekè"),
            keywords: &["Scorpius", "scorpio", "Àkekè", "àmi oṣù ìbí"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("蠍子"),
            keywords: &["天蠍座", "星座", "蠍子"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("蝎子"),
            keywords: &["天蝎座", "星座", "蝎子"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("蝎子"),
            keywords: &["天蝎宫", "天蝎座", "蝎子", "黄道十二宫"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("蠍子"),
            keywords: &["蠍", "蠍子"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ufezela"),
            keywords: &["inkanyezi", "ufezela"],
        },
    ],
};
#[doc = "🦟"]
pub const MOSQUITO: crate::Emoji = crate::Emoji {
    glyph: "🦟",
    codepoint: "1F99F",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "mosquito",
    group: "Animals & Nature",
    subgroup: "animal-bug",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("muskiet"),
            keywords: &["insek", "koors", "malaria", "muskiet", "siekte", "virus"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ወባ"),
            keywords: &["በሽታ", "ቫይረስ", "ትኩሳት", "ነፍሳት", "ወባ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("بعوضة"),
            keywords: &["بعوضة", "حشرة", "فيروس", "مرض", "ملاريا", "ناموسة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("মহ"),
            keywords: &[
                "জ\u{9cd}বৰ",
                "পতংগ",
                "ভ\u{9be}ইৰ\u{9be}ছ",
                "মহ",
                "মেলেৰিয\u{9bc}\u{9be}",
                "ৰোগ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("ağcaqanad"),
            keywords: &[
                "ağcaqanad",
                "həşərat",
                "malariya",
                "qızdırma",
                "virus",
                "xəstəlik",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("камар"),
            keywords: &[
                "вірус",
                "камар",
                "ліхаманка",
                "малярыя",
                "насякомае",
                "хвароба",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("комар"),
            keywords: &[
                "вирус",
                "комар",
                "малария",
                "насекомо",
                "треска",
                "ухапване",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মশ\u{9be}"),
            keywords: &[
                "জ\u{9cd}বর",
                "পোক\u{9be}",
                "ভ\u{9be}ইর\u{9be}স",
                "মশ\u{9be}",
                "ম\u{9cd}য\u{9be}লেরিয\u{9bc}\u{9be}",
                "রোগ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("moustik"),
            keywords: &["amprevan", "moustik"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("komarac"),
            keywords: &["bolest", "groznica", "komarac", "malarija", "virus"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("mosquit"),
            keywords: &[
                "febre", "insecte", "malaltia", "malària", "mosquit", "virus",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏙᏌ"),
            keywords: &["ᎤᏗᎴᎲᏍᎩ", "ᎥᏳᎩ", "ᎥᏳᎩ ᎠᏱᎵᏙ", "ᏓᎶᏂᎨ ᎤᏗᏞᎲᏍᎬ", "ᏙᏌ", "ᏨᏍᎪᏱ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("komár"),
            keywords: &[
                "dengue",
                "hmyz",
                "komár",
                "malárie",
                "moskyt",
                "virus",
                "štípnutí",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("mosgito"),
            keywords: &["clefyd", "feirws", "malaria", "mosgito", "pryfyn", "twymyn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("myg"),
            keywords: &["feber", "insekt", "malaria", "myg", "sygdom", "virus"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Mücke"),
            keywords: &["Fieber", "Insekt", "Malaria", "Moskito", "Mücke"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κουνούπι"),
            keywords: &[
                "έντομο",
                "αρρώστια",
                "ελονοσία",
                "ιός",
                "κουνούπι",
                "πυρετός",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("mosquito"),
            keywords: &["disease", "fever", "malaria", "mosquito", "pest", "virus"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &[
                "dengue", "fever", "insect", "malaria", "mosquito", "mozzie", "virus",
            ],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("mosquito"),
            keywords: &["fiebre", "insecto", "malaria", "mosquito", "virus"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("mosquito"),
            keywords: &[
                "enfermedad",
                "fiebre",
                "insecto",
                "malaria",
                "mosquito",
                "virus",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("mosquito"),
            keywords: &["mosquito"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("sääsk"),
            keywords: &[
                "haigus", "malaaria", "palavik", "putukas", "sääsk", "viirus",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("eltxo"),
            keywords: &[
                "birus",
                "eltxo",
                "gaixotasun",
                "intsektu",
                "malaria",
                "sukar",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پشه"),
            keywords: &["بیماری", "تب", "حشره", "مالاریا", "ویروس", "پشه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("hyttynen"),
            keywords: &[
                "hyttynen",
                "hyönteinen",
                "kuume",
                "malaria",
                "sairaus",
                "sääski",
                "tauti",
                "virus",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("lamok"),
            keywords: &["dengue", "lagnat", "lamok", "malaria", "sakit"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("mýggjabiti"),
            keywords: &[
                "farsótt",
                "fepur",
                "malaria",
                "moskito",
                "mýggjabiti",
                "pest",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("moustique"),
            keywords: &[
                "fièvre",
                "insecte",
                "maladie",
                "malaria",
                "moustique",
                "virus",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("muiscít"),
            keywords: &[
                "feithid", "fiabhras", "galar", "maláire", "muiscít", "víreas",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("mosgaid"),
            keywords: &[
                "bhìoras",
                "biastag",
                "fiabhras",
                "galar",
                "mailèiria",
                "mosgaid",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("mosquito"),
            keywords: &["malaria", "mosquito", "picada", "picadela", "picadura"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("મચ\u{acd}છર"),
            keywords: &[
                "જ\u{a82}ત\u{ac1}",
                "તાવ",
                "મચ\u{acd}છર",
                "મલ\u{ac7}રિયા",
                "રોગ",
                "વાયરસ",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("יתוש"),
            keywords: &["וירוס", "חרק", "יתוש", "מחלות", "מלריה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("मच\u{94d}छर"),
            keywords: &[
                "कीड\u{93c}ा",
                "बीमारी",
                "ब\u{941}खार",
                "मच\u{94d}छर",
                "मल\u{947}रिया",
                "विषाण\u{941}",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("komarac"),
            keywords: &[
                "bolest", "groznica", "insekt", "komarac", "malarija", "virus",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("szúnyog"),
            keywords: &["betegség", "láz", "malária", "rovar", "szúnyog", "vírus"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մոծակ"),
            keywords: &[
                "հիվանդություն",
                "մալարիա",
                "միջատ",
                "մոծակ",
                "վարակ",
                "տենդ",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("nyamuk"),
            keywords: &[
                "demam", "malaria", "nyamuk", "penyakit", "serangga", "virus",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("moskító"),
            keywords: &["hiti", "malaría", "moskító", "skordýr", "veiki", "veira"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("zanzara"),
            keywords: &["febbre", "insetto", "malaria", "zanzara"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("蚊"),
            keywords: &["ウイルス", "マラリア", "熱", "病気", "虫", "蚊"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("lemut"),
            keywords: &["demam", "lemut", "malaria", "penyakit", "serangga", "virus"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("კოღო"),
            keywords: &["დაავადება", "ვირუსი", "კოღო", "მალარია", "მწერი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("маса"),
            keywords: &["ауру", "безгек", "вирус", "жәндік", "малярия", "маса"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bc}ស"),
            keywords: &[
                "គ\u{17d2}រ\u{17bb}នក\u{17d2}ដៅ",
                "គ\u{17d2}រ\u{17bb}នចាញ\u{17cb}",
                "ជ\u{17c6}ង\u{17ba}",
                "ម\u{17bc}ស",
                "មេរោគ",
                "សត\u{17d2}វល\u{17d2}អ\u{17b7}ត",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸೊಳ\u{ccd}ಳ\u{cc6}"),
            keywords: &[
                "ಕಾಯ\u{cbf}ಲ\u{cc6}",
                "ಜ\u{ccd}ವರ",
                "ಮಲೇರ\u{cbf}ಯಾ",
                "ವೈರಸ\u{ccd}",
                "ಸೊಳ\u{ccd}ಳ\u{cc6}",
                "ಹುಳು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("모기"),
            keywords: &["말라리아", "모기", "바이러스", "벌레", "병균", "열"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("जळार"),
            keywords: &["किड\u{947}", "जळार", "जोर", "मल\u{947}रिया", "रोग", "वायरस"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("чиркей"),
            keywords: &[
                "безгек",
                "вирус",
                "курт-кумурска",
                "малярия",
                "оору",
                "чиркей",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຍ\u{eb8}ງ"),
            keywords: &[
                "ຍ\u{eb8}ງ",
                "ພະຍາດ",
                "ມາລາເລຍ",
                "ແມງໄມ\u{ec9}",
                "ໄຂ\u{ec9}",
                "ໄວລ\u{eb1}ດ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("uodas"),
            keywords: &[
                "karštinė",
                "maliarija",
                "negalavimas",
                "uodas",
                "vabzdys",
                "virusas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("ods"),
            keywords: &["drudzis", "insekts", "malārija", "ods", "slimība", "vīruss"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("комарец"),
            keywords: &["болест", "вирус", "инсект", "комарец", "маларија", "треска"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കൊത\u{d41}ക\u{d4d}"),
            keywords: &[
                "അസ\u{d41}ഖം",
                "കൊത\u{d41}ക\u{d4d}",
                "പനി",
                "പ\u{d4d}ര\u{d3e}ണി",
                "മലേറിയ",
                "വൈറസ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("шумуул"),
            keywords: &["вирус", "малариа", "халуурах", "шавьж", "шумуул", "өвчин"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("डास"),
            keywords: &[
                "किडा",
                "डास",
                "ताप",
                "मल\u{947}रिया",
                "रोग",
                "व\u{94d}हायरस",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("nyamuk"),
            keywords: &["demam", "malaria", "nyamuk", "penyakit", "perosak", "virus"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ခြင\u{103a}"),
            keywords: &[
                "ခြင\u{103a}",
                "င\u{103e}က\u{103a}ဖျား",
                "ပ\u{102d}\u{102f}းကောင\u{103a}",
                "ဖျားနာခြင\u{103a}း",
                "ဗ\u{102d}\u{102f}င\u{103a}းရပ\u{103a}စ\u{103a}",
                "ရောဂါ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("mygg"),
            keywords: &["feber", "insekt", "malaria", "mygg", "sykdom", "virus"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("मच\u{94d}छ\u{947}ट"),
            keywords: &[
                "औलो",
                "किरा",
                "ज\u{94d}वरो",
                "भाइरस",
                "मच\u{94d}छ\u{947}ट",
                "रोग",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("mug"),
            keywords: &["insect", "koorts", "malaria", "mug", "virus", "ziekte"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("mygg"),
            keywords: &["feber", "insekt", "malaria", "mygg", "sjukdom", "virus"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମଶ\u{b3e}"),
            keywords: &[
                "କୀଟ",
                "ଜ\u{b4d}ୱର",
                "ଭ\u{b3e}ଇରସ\u{b4d}\u{200c}",
                "ମଶ\u{b3e}",
                "ମ\u{b4d}ୟ\u{b3e}ଲେର\u{b3f}ଆ",
                "ରୋଗ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਮ\u{a71}ਛਰ"),
            keywords: &[
                "ਕੀੜ\u{a47}",
                "ਬਿਮਾਰੀ",
                "ਬ\u{a41}ਖਾਰ",
                "ਮਲ\u{a47}ਰੀਆ",
                "ਮ\u{a71}ਛਰ",
                "ਵਾਇਰਸ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Mọskíto"),
            keywords: &["Diziz", "Fíva", "Maléria", "Mọskíto", "Pẹst", "Vaírọs"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("komar"),
            keywords: &["choroba", "gorączka", "komar", "malaria", "owad", "wirus"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("غوماشه"),
            keywords: &["غوماشه", "ناروغي، تبه، حشره، مليريا، غوماشه، ويروس"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("mosquito"),
            keywords: &["doença", "febre", "inseto", "malária", "mosquito", "vírus"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("melga"),
            keywords: &[
                "doença", "febre", "insecto", "inseto", "malária", "melga", "vírus",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("mosquito"),
            keywords: &[
                "malaria", "mosquito", "parasito", "rupha", "unqusqa", "virus",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("țânțar"),
            keywords: &[
                "boală",
                "febră",
                "insectă",
                "malarie",
                "înțepătură",
                "țânțar",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E11-029"),
            keywords: &["E11-029"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("комар"),
            keywords: &["вирус", "комар", "лихорадка", "малярия", "москит"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مڇر"),
            keywords: &["بخار", "بيماري", "جيت", "مليريا", "مڇر", "وائرس"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("මද\u{dd4}ර\u{dd4}වෝ"),
            keywords: &[
                "උණ",
                "කෘම\u{dd2}ය\u{dcf}",
                "මද\u{dd4}ර\u{dd4}වෝ",
                "මැලේර\u{dd2}ය\u{dcf}ව",
                "රෝගය",
                "වෛරසය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("komár"),
            keywords: &["hmyz", "horúčka", "komár", "vírus"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("komar"),
            keywords: &["bolezen", "insekt", "komar", "malarija", "mrzlica", "virus"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("kaneeco"),
            keywords: &[
                "cayayaan", "cudur", "duumada", "fayruus", "kaneeco", "qandho",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("mushkonjë"),
            keywords: &["ethe", "insekt", "mushkonjë", "sëmundje", "virus"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("комарац"),
            keywords: &[
                "болест",
                "вирус",
                "грозница",
                "инсект",
                "комарац",
                "маларија",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["комарац"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("komarac"),
            keywords: &[
                "bolest", "groznica", "insekt", "komarac", "malarija", "virus",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["komarac"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("mygga"),
            keywords: &["insekt", "malaria", "mygga", "sjukdom", "virus"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mbu"),
            keywords: &["homa", "malaria", "mbu", "mdudu", "ugonjwa", "virusi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கொசு"),
            keywords: &[
                "க\u{bbe}ய\u{bcd}ச\u{bcd}சல\u{bcd}",
                "கொசு",
                "நோய\u{bcd}",
                "பூச\u{bcd}சி",
                "மலேரிய\u{bbe}",
                "வைரஸ\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ద\u{c4b}మ"),
            keywords: &[
                "క\u{c40}టకం",
                "జ\u{c4d}వరం",
                "ద\u{c4b}మ",
                "మల\u{c47}ర\u{c3f}య\u{c3e}",
                "వ\u{c48}రస\u{c4d}",
                "వ\u{c4d}య\u{c3e}ధ\u{c3f}",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ย\u{e38}ง"),
            keywords: &[
                "มาลาเร\u{e35}ย",
                "ย\u{e38}ง",
                "แมลง",
                "โรค",
                "ไข\u{e49}",
                "ไวร\u{e31}ส",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("moskito"),
            keywords: &[
                "gyzgynlyk",
                "kesel",
                "moskito",
                "mör-möjek",
                "sytma",
                "wirus",
                "çybyn",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("namu"),
            keywords: &["namu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("sivrisinek"),
            keywords: &["ateş", "böcek", "hastalık", "sivrisinek", "sıtma", "virüs"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("комар"),
            keywords: &["вірус", "гарячка", "комар", "комаха", "малярія", "хвороба"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("مچھر"),
            keywords: &["بخار", "بیماری", "ملیریا", "مچھر", "وائرس", "کیڑا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("chivin"),
            keywords: &["bezgak", "chivin", "malyariya", "qon so‘rish", "virus"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("con muỗi"),
            keywords: &[
                "bệnh",
                "con muỗi",
                "côn trùng",
                "muỗi",
                "sốt",
                "sốt rét",
                "vi rút",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("蚊"),
            keywords: &["昆蟲", "病", "病毒", "瘧疾", "發燒", "蚊"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("蚊"),
            keywords: &["发烧", "昆虫", "疟疾", "病", "病毒", "蚊"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("蚊子"),
            keywords: &["发热", "昆虫", "疟疾", "疾病", "病毒", "蚊子"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("蚊子"),
            keywords: &["疾病", "病毒", "瘧疾", "發燒", "蚊子", "蟲"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("mosquito"),
            keywords: &["disease", "fever", "insect", "malaria", "mosquito", "virus"],
        },
    ],
};
#[doc = "🪰"]
pub const FLY: crate::Emoji = crate::Emoji {
    glyph: "🪰",
    codepoint: "1FAB0",
    status: crate::Status::FullyQualified,
    introduction_version: 13f32,
    name: "fly",
    group: "Animals & Nature",
    subgroup: "animal-bug",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("vlieg"),
            keywords: &["huisvlieg", "lastig", "maaier", "vlieg", "vuil"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ዝንብ"),
            keywords: &["ዝንብ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ذبابة"),
            keywords: &["حشرة", "ذبابة", "عفن", "مرض", "نفايات", "يرقة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ম\u{9be}খি"),
            keywords: &[
                "অপক\u{9be}ৰী কীট",
                "পচ\u{9be} বস\u{9cd}ত\u{9c1}ত হোৱ\u{9be} পোক",
                "পচিবলৈ ধৰ\u{9be}",
                "ম\u{9be}খি",
                "ৰোগ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("milçək"),
            keywords: &["milçək", "sürfə", "xəstəlik", "ziyanverici", "çürümə"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("муха"),
            keywords: &["гніенне", "лічынка", "муха", "хвароба", "шкоднік"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("муха"),
            keywords: &["болест", "гниене", "ларва", "муха", "напаст"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ম\u{9be}ছি"),
            keywords: &[
                "কীটপতঙ\u{9cd}গ",
                "পচ\u{9be}",
                "ম\u{9be}ছি",
                "রোগ",
                "শ\u{9c2}ককীট",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kelienenn"),
            keywords: &["kelienenn", "kleñved"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("muha"),
            keywords: &["bolest", "larva", "muha", "truljenje", "štetočina"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("mosca"),
            keywords: &["epidèmia", "larva", "malaltia", "mosca", "podrit"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏛᎦ"),
            keywords: &["ᎤᎪᏏᏛ", "ᎤᏥᏯᏳᏍᏗ", "ᎥᏳᎩ ᎠᏳᎵᏙ", "ᏓᎹᎦ", "ᏛᎦ", "ᏥᏥ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("moucha"),
            keywords: &["hmyz", "hnijící", "larva", "moucha", "nemoc", "otravný"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("pry"),
            keywords: &["clefyd", "cynrhonyn", "pla", "pry", "wedi pydru"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("flue"),
            keywords: &[
                "flue",
                "hestebremse",
                "klæg",
                "maddike",
                "rådden",
                "stueflue",
                "sygdom",
                "tsetse",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Fliege"),
            keywords: &["Fliege", "Krankheit", "Made", "Plage", "verwesen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μύγα"),
            keywords: &[
                "αλογόμυγα",
                "αποσύνθεση",
                "ασθένεια",
                "μύγα",
                "μύγα τσε-τσε",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("fly"),
            keywords: &["disease", "fly", "maggot", "pest", "rotting"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("mosca"),
            keywords: &["basura", "bicho", "mal olor", "mosca", "podrido"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("mosca"),
            keywords: &["mosca"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("mosca"),
            keywords: &["mosca"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kärbes"),
            keywords: &[
                "haigus",
                "kärbes",
                "parm",
                "roiskumine",
                "toakärbes",
                "tsetsekärbes",
                "tõuk",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("euli"),
            keywords: &[
                "beltzuntza",
                "euli",
                "eulia",
                "ezpara",
                "gaixotasuna",
                "mandeulia",
                "tse-tse",
                "usteldu",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("مگس"),
            keywords: &[
                "بیماری",
                "تسه تسه",
                "خرمگس",
                "مگس",
                "مگس خانگی",
                "پوسیدن",
                "کرم حشره",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kärpänen"),
            keywords: &["kärpänen", "mätänevä", "sairaus", "tauti", "toukka"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("langaw"),
            keywords: &["itlog ng langaw", "langaw", "nabubulok", "peste", "sakit"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("fluga"),
            keywords: &["fluga", "pest", "rot", "sjúka", "spilt"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("mouche"),
            keywords: &["asticot", "maladie", "mouche", "nuisible", "putréfaction"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("mouche"),
            keywords: &["maladie", "mouche", "pourrissement", "puanteur", "ver"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cuileog"),
            keywords: &["cuileog"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cuileag"),
            keywords: &[
                "biastag",
                "cnuimheag",
                "cuileag",
                "galar",
                "grod",
                "grodadh",
                "plàigh",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("mosca"),
            keywords: &["enfermidade", "insecto", "mosca", "tabán", "tse-tse"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("માખી"),
            keywords: &[
                "ઈયળ",
                "ઉપદ\u{acd}રવી જીવાત",
                "માખી",
                "રોગ",
                "સડવ\u{ac1}\u{a82}",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("זבוב"),
            keywords: &[
                "זבוב",
                "זבוב הבית",
                "זבוב הסוס",
                "טסה טסה",
                "מחלות",
                "צה-צה",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("मक\u{94d}खी"),
            keywords: &["कीट", "कीड\u{93c}ा", "बिमारी", "मक\u{94d}खी", "सड\u{93c}ना"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("muha"),
            keywords: &["bolest", "crv", "muha", "nametnik", "trulež"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("légy"),
            keywords: &["betegség", "féreg", "kártevő", "légy", "rohadás"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ճանճ"),
            keywords: &["թրթուր", "հիվանդություն", "ճանճ", "վնասատու", "փտում"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("lalat"),
            keywords: &["belatung", "hama", "lalat", "membusuk", "penyakit"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("fluga"),
            keywords: &["fluga", "maðkar", "plága", "rotnun", "sjúkdómur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("mosca"),
            keywords: &["decomposizione", "infestante", "larva", "malattia", "mosca"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ハエ"),
            keywords: &["ハエ", "不潔", "害虫", "病原菌", "虫"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("laler"),
            keywords: &["ama", "bosokan", "laler", "penyakit", "set"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ბუზი"),
            keywords: &["ბუზი", "დაავადება", "დალპობა", "მავნებელი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ұшу"),
            keywords: &["ауру", "дернәсіл", "зиянкес", "шіру", "ұшу"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("រ\u{17bb}យ"),
            keywords: &[
                "ជ\u{17c6}ង\u{17ba}",
                "ដង\u{17d2}ក\u{17bc}វ",
                "រល\u{17bd}យ",
                "រ\u{17bb}យ",
                "សត\u{17d2}វចង\u{17d2}រៃ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ನೊಣ"),
            keywords: &[
                "ಕೀಟ",
                "ಕೊಳ\u{cc6}ಯುತ\u{ccd}ತ\u{cbf}ರುವ",
                "ನೊಣ",
                "ಮ\u{ccd}ಯಾಗ\u{ccd}ಗೊಟ\u{ccd}",
                "ರೋಗ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("파리"),
            keywords: &["구더기", "부패", "질병", "파리", "해충"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("म\u{942}स"),
            keywords: &["किड\u{947}", "क\u{941}सप", "म\u{942}स", "रोग", "वाळटी"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("чымын"),
            keywords: &["чымын"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ແມງວ\u{eb1}ນ"),
            keywords: &[
                "ພະ\u{200b}ຍາດ",
                "ແມງວ\u{eb1}ນ",
                "ແມງ\u{200b}ໄມ\u{ec9}",
                "ໜອນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("musė"),
            keywords: &[
                "cėcė",
                "gyvulinė musė",
                "kambarinė musė",
                "musė",
                "mėšlinė musė",
                "negalavimas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("muša"),
            keywords: &["kaitēklis", "kāpurs", "muša", "pūšana", "slimība"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("мува"),
            keywords: &["болест", "ларва", "мува", "трулеж", "штетник"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഈച\u{d4d}ച"),
            keywords: &[
                "അഴ\u{d41}കൽ",
                "ഈച\u{d4d}ച",
                "ക\u{d43}മി കീടം",
                "പ\u{d41}ഴ\u{d41}",
                "രോഗം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("ялаа"),
            keywords: &["хортон шавж", "ялаа", "ялзрах", "өвчин", "өт"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("माशी"),
            keywords: &["अळी", "कीटक", "माशी", "रोग", "सडण\u{947}"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("lalat"),
            keywords: &["berengga", "lalat", "mereput", "penyakit", "perosak"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ယင\u{103a}ကောင\u{103a}"),
            keywords: &[
                "ညစ\u{103a}ပတ\u{103a}",
                "ပ\u{102d}\u{102f}းမ\u{103d}\u{103e}ား",
                "ယင\u{103a}",
                "ယင\u{103a}ကောင\u{103a}",
                "ရောဂါ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("flue"),
            keywords: &[
                "dyr",
                "flue",
                "forråtnelse",
                "insekt",
                "larver",
                "råtne",
                "sykdom",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("झि\u{901}गा"),
            keywords: &[
                "किरा-फट\u{94d}याङ\u{94d}ग\u{94d}रा",
                "क\u{941}हिन\u{947}",
                "झि\u{901}गा",
                "म\u{94d}याग\u{94d}गट",
                "रोग",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("vlieg"),
            keywords: &[
                "daas",
                "huisvlieg",
                "made",
                "rottend",
                "tseetseevlieg",
                "vlieg",
                "ziekte",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("floge"),
            keywords: &[
                "dyr",
                "floge",
                "forrotning",
                "insekt",
                "larvar",
                "rotne",
                "sjukdom",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମ\u{b3e}ଛ\u{b3f}"),
            keywords: &["କୀଟ", "ମ\u{b3e}ଛ\u{b3f}", "ରୋଗ", "ସଢ\u{b3f}ବ\u{b3e}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਮ\u{a71}ਖੀ"),
            keywords: &["ਕੀੜਾ", "ਬਿਮਾਰੀ", "ਮ\u{a71}ਖੀ", "ਸੜਣਾ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Flai"),
            keywords: &["Diziz", "Flai", "Mágọt", "Pẹst", "Rọ\u{301}tin"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("mucha"),
            keywords: &["choroby", "giez", "gnicie", "mucha", "owad", "tse-tse"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("مچ"),
            keywords: &["حشره", "سخا کېدل", "مضره حشره", "مچ", "ناروغي"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("mosca"),
            keywords: &["apodrecendo", "doença", "larva", "mosca", "praga"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["decomposição", "doença", "larva", "mosca", "praga"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("phaway"),
            keywords: &["ismusqa", "khuru", "parasito", "phaway", "unqusqa"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("muscă"),
            keywords: &["boală", "descompunere", "dăunător", "muscă", "putrezire"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E13-035"),
            keywords: &["E13-035"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("муха"),
            keywords: &["вредитель", "зараза", "личинка", "муха", "насекомое"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مک"),
            keywords: &["بيماري", "روٽنگ", "مک", "مگوٽ", "پيسٽ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("මැස\u{dca}ස\u{dcf}"),
            keywords: &[
                "ක\u{dd4}ණ\u{dd4}ව\u{dd3}ම",
                "පළ\u{dd2}බෝධ",
                "මැස\u{dca}ස\u{dcf}",
                "මැස\u{dd2} ප\u{dd2}ළව\u{dcf}",
                "රෝග",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("mucha"),
            keywords: &["choroba", "mucha", "zhnité", "červ", "škodca"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("muha"),
            keywords: &[
                "bolezen",
                "domača muha",
                "gnitje",
                "ličinka",
                "muha",
                "muha cece",
                "obad",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("duqsi"),
            keywords: &["cayayaan", "cudur", "dixri", "duqsi", "qudhmay"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("mizë"),
            keywords: &["insekt i dëmshëm", "kalbje", "kërmë", "mizë", "sëmundje"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("мува"),
            keywords: &["болест", "ларва", "мува", "напаст", "труло"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["мува"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("muva"),
            keywords: &["bolest", "larva", "muva", "napast", "trulo"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["muva"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("fluga"),
            keywords: &["asätande insekt", "fluga", "sjukdom"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("nzi"),
            keywords: &["funza", "kuoza", "mdudu", "nzi", "ugonjwa"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஈ"),
            keywords: &["அழுகுதல\u{bcd}", "ஈ", "நோய\u{bcd}", "புழு", "பூச\u{bcd}சி"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఈగ"),
            keywords: &[
                "ఈగ",
                "క\u{c4d}ర\u{c3f}మ\u{c3f}",
                "జబ\u{c4d}బు",
                "వ\u{c4d}య\u{c3e}ధ\u{c3f}",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("แมลงว\u{e31}น"),
            keywords: &[
                "ศ\u{e31}ตร\u{e39}พ\u{e37}ช",
                "หนอนแมลงว\u{e31}น",
                "เน\u{e48}าเส\u{e35}ย",
                "แมลงว\u{e31}น",
                "โรค",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("siňek"),
            keywords: &["bökelek", "kesel", "liçinka", "siňek", "tsetse", "çüýremek"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("lango"),
            keywords: &["lango"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("karasinek"),
            keywords: &["böcek", "hastalık", "karasinek", "larva", "sinek", "çürüme"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("муха"),
            keywords: &["гниль", "личинка", "муха", "хвороба", "шкідник"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("مکھی"),
            keywords: &["بیماری", "حشرات", "خراب ہونا", "مکھی", "کیڑا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("pashsha"),
            keywords: &[
                "chirish",
                "irish",
                "kasallik",
                "pashsha",
                "qurt",
                "setse",
                "uy pashshasi",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("con ruồi"),
            keywords: &["bệnh", "con ruồi", "côn trùng", "giòi", "thối rữa"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("烏蠅"),
            keywords: &["烏蠅", "疾病", "腐爛", "蛆"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("乌蝇"),
            keywords: &["乌蝇", "疾病", "腐烂", "蛆"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("苍蝇"),
            keywords: &["害虫", "疾病", "腐烂", "苍蝇", "蛆"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("蒼蠅"),
            keywords: &["腐爛", "舌蠅", "蒼蠅", "馬蠅"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("impukane"),
            keywords: &["impethu", "impukane", "isifo", "isinambuzane", "ukubola"],
        },
    ],
};
#[doc = "🪱"]
pub const WORM: crate::Emoji = crate::Emoji {
    glyph: "🪱",
    codepoint: "1FAB1",
    status: crate::Status::FullyQualified,
    introduction_version: 13f32,
    name: "worm",
    group: "Animals & Nature",
    subgroup: "animal-bug",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("wurm"),
            keywords: &["annelied", "erdwurm", "parasiet", "wurm"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ትል"),
            keywords: &["ትል"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("دودة"),
            keywords: &["بريمة", "دودة", "دودة أرض", "دودة علقية", "طفيليات"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("কে\u{981}চ\u{9c1}"),
            keywords: &[
                "ক\u{9c3}মিৰ দৰে কোমলদেহী প\u{9cd}ৰ\u{9be}ণী",
                "কে\u{981}চ\u{9c1}",
                "পৰজীৱী",
                "হ\u{9be}ব\u{9c1}ৰ\u{9c1}ক\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("soxulcan"),
            keywords: &["həlqəvi qurd", "soxulcan", "torpaq qurdu"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("чарвяк"),
            keywords: &["дажджавы чарвяк", "кольчаты чарвяк", "паразіт", "чарвяк"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("червей"),
            keywords: &["земен червей", "паразит", "червей"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("পোক\u{9be}"),
            keywords: &[
                "অঙ\u{9cd}গ\u{9c1}রীম\u{9be}ল",
                "কে\u{981}চো",
                "পরজীবী",
                "পোক\u{9be}",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("buzhugenn"),
            keywords: &["buzhugenn", "loen"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("crv"),
            keywords: &[
                "crv",
                "glista",
                "kišna glista",
                "kišni crv",
                "parazit",
                "prstenasta glista",
                "prstenasti crv",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cuc"),
            keywords: &["annèl·lid", "cuc", "cuc de terra", "paràsit"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏥᏯ"),
            keywords: &["ᎡᎶᎯ ᎤᏥᏯ", "ᎡᏁᎵᏓ", "ᎤᏥᏯ", "ᏜᏄᏩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("červ"),
            keywords: &["dešťovka", "kroužkovec", "parazit", "červ", "žížala"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("mwydyn"),
            keywords: &["anelid", "arfilyn", "mwydyn", "pryf genwair"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("orm"),
            keywords: &["ledorm", "orm", "parasit", "regnorm"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Wurm"),
            keywords: &["Parasit", "Regenwurm", "Ringelwurm", "Wurm"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σκουλήκι"),
            keywords: &["γαιοσκώληκας", "δακτυλιοσκώληκας", "παράσιτο", "σκουλήκι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("worm"),
            keywords: &["annelid", "earthworm", "parasite", "worm"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("gusano"),
            keywords: &["gusano", "lombriz", "oruga", "parásito"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("gusano"),
            keywords: &["gusano"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("gusano"),
            keywords: &["gusano"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("uss"),
            keywords: &["parasiit", "rõnguss", "uss", "vihmauss"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("zizare"),
            keywords: &[
                "anelidoa",
                "bizioa",
                "harra",
                "parasitoa",
                "zizare",
                "zizarea",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کرم"),
            keywords: &["انگل", "کرم", "کرم حلقوی", "کرم خاکی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("mato"),
            keywords: &["kastemato", "loinen", "mato"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("uod"),
            keywords: &["annelid", "earthworm", "parasite", "uod"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("maðkur"),
            keywords: &[
                "maðkur",
                "ormur",
                "reyðmaðkur",
                "skriðkykt",
                "snultidýr",
                "sníkur",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("lombric"),
            keywords: &["annélide", "lombric", "parasite", "ver", "ver de terre"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("ver"),
            keywords: &["annélide", "parasite", "ver", "ver de terre"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("péist"),
            keywords: &["cuiteog", "péist", "seadán"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cnuimh"),
            keywords: &[
                "biathag",
                "cnuimh",
                "cnuimh-talmhainn",
                "daolag",
                "dealt-dhaolag",
                "faoighiche",
                "frithlisg",
                "lobach",
                "parasait",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("verme"),
            keywords: &["becho", "bicho", "lombriga", "miñoca", "parásito", "verme"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ક\u{ac3}મિ"),
            keywords: &[
                "અળસિય\u{ac1}\u{a82}",
                "ક\u{ac3}મિ",
                "જળો",
                "પરોપજીવી",
                "વલયી ક\u{ac3}મિ",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("תולעת"),
            keywords: &["טפיל", "שלשול", "תולעים", "תולעת", "תולעת פרקים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("क\u{943}मि"),
            keywords: &[
                "क\u{943}मि",
                "क\u{947}\u{902}च\u{941}आ",
                "धारीदार कीड\u{93c}ा",
                "परजीवी",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("crv"),
            keywords: &["crv", "glista", "kolutićavac", "parazit"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("kukac"),
            keywords: &[
                "féreg",
                "földigiliszta",
                "gyűrűs féreg",
                "kukac",
                "parazita",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("որդ"),
            keywords: &["անձրևորդ", "ճիճու", "մակաբույծ", "որդ", "օղակավոր որդ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("cacing"),
            keywords: &["annelida", "cacing", "cacing tanah", "parasit"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("ormur"),
            keywords: &["liðormur", "ormur", "sníkjudýr", "ánamaðkur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("verme"),
            keywords: &["anellide", "lombrico", "parassita", "verme"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ミミズ"),
            keywords: &["ミミズ", "寄生虫", "虫"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("cacing"),
            keywords: &["anelid", "cacing", "cacing lemah", "parasit"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მატლი"),
            keywords: &["მატლი", "პარაზიტი", "ჭია", "ჭიაყელა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("құрт"),
            keywords: &["жауынқұрт", "паразит", "сақина тәрізді құрт", "құрт"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ដង\u{17d2}ក\u{17bc}វ"),
            keywords: &["ជន\u{17d2}លេន", "ដង\u{17d2}ក\u{17bc}វ", "បរាស\u{17b7}ត"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕ\u{ccd}ರ\u{cbf}ಮ\u{cbf}"),
            keywords: &[
                "ಅನ\u{cc6}ಲ\u{cbf}ಡ\u{ccd}",
                "ಎರ\u{cc6}ಹುಳು",
                "ಕ\u{ccd}ರ\u{cbf}ಮ\u{cbf}",
                "ಪರಾವಲಂಬ\u{cbf}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("지렁이"),
            keywords: &["기생충", "지렁이", "환형동물"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("किडो"),
            keywords: &[
                "अन\u{947}लिड",
                "किडो",
                "गायडो\u{902}ळ",
                "प\u{945}र\u{948}सायट",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("мите"),
            keywords: &["мите"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜອນ"),
            keywords: &[
                "ຂ\u{eb5}\u{ec9}\u{200b}ກະ\u{200b}ເດ\u{eb7}ອນ",
                "ແມ\u{ec8}\u{200b}ທ\u{ec9}ອງ",
                "ໜອນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("kirmėlė"),
            keywords: &["kirmėlė", "kirmėlės", "parazitai", "sliekai"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("tārps"),
            keywords: &["parazīts", "posmtārps", "slieka", "tārps"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("црв"),
            keywords: &["дождовен црв", "паразит", "прстенест црв", "црв"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ക\u{d43}മി"),
            keywords: &[
                "ക\u{d43}മി",
                "നീണ\u{d4d}ട\u{d41}ര\u{d41}ണ\u{d4d}ട ക\u{d43}മി",
                "പര\u{d3e}ദം",
                "മണ\u{d4d}ണിര",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("өт хорхой"),
            keywords: &["чийгийн өт", "шимэгч", "өргөст хорхой", "өт", "өт хорхой"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("क\u{943}मी"),
            keywords: &["अळी", "क\u{943}मी", "गा\u{902}ड\u{941}ळ", "प\u{945}रासाइट"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("cacing"),
            keywords: &["anelid", "cacing", "cacing tanah", "parasit"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("တ\u{102e}ကောင\u{103a}"),
            keywords: &[
                "ကပ\u{103a}ပါး",
                "တ\u{102e}",
                "တ\u{102e}ကောင\u{103a}",
                "မြေတ\u{102e}ကောင\u{103a}",
                "အဆစ\u{103a}တ\u{102e}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("mark"),
            keywords: &[
                "dyr",
                "leddorm",
                "makk",
                "mark",
                "meitemakk",
                "meitemark",
                "parasitt",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ग\u{901}ड\u{94d}यौला"),
            keywords: &[
                "एन\u{94d}न\u{947}लिड",
                "ग\u{901}ड\u{94d}यौला",
                "परजीवि",
                "भ\u{941}\u{901}ई ग\u{901}ड\u{94d}यौला",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("worm"),
            keywords: &["parasiet", "regenworm", "ringworm", "worm"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("mark"),
            keywords: &[
                "dyr",
                "leddorm",
                "makk",
                "mark",
                "meitemakk",
                "meitemark",
                "parasitt",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କ\u{b43}ମ\u{b3f}"),
            keywords: &[
                "ଏନେଲ\u{b3f}ଡ\u{b3c}",
                "କ\u{b43}ମ\u{b3f}",
                "ଜ\u{b3f}ଆ",
                "ପରଜୀବୀ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸ\u{a41}\u{a70}ਡ"),
            keywords: &[
                "ਕਿਰਮ",
                "ਕ\u{a41}\u{a70}ਡਲਦਾਰ ਕੀੜਾ",
                "ਗ\u{a70}ਡ\u{a4b}ਆ",
                "ਪਰਜੀਵੀ",
                "ਸ\u{a41}\u{a70}ਡ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Wọm"),
            keywords: &[
                "Párásait",
                "Wọm",
                "Wọm Wé Im Nem Na Anẹ\u{301}lid",
                "Ẹ\u{301}twọm",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("robak"),
            keywords: &["dżdżownica", "glista", "pasożyt", "pierścienice", "robak"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("چينجی"),
            keywords: &["د زمکې چينجی", "طفيله", "چينجی"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("minhoca"),
            keywords: &["anelídeo", "minhoca", "parasita"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("sillwi khuru"),
            keywords: &[
                "anelida",
                "jallpʼamanta pacha",
                "khuru",
                "parasito",
                "sillwi khuru",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("vierme"),
            keywords: &["anelid", "parazit", "râmă", "vierme"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E13-036"),
            keywords: &["E13-036"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("червяк"),
            keywords: &[
                "земляной червь",
                "круглый червь",
                "паразит",
                "червь",
                "червяк",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪيڙو"),
            keywords: &["انيلڊ", "زميني ڪيڙو", "پيراسائيٽ", "ڪيڙو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("පණ\u{dd4}ව\u{dcf}"),
            keywords: &[
                "පණ\u{dd4}ව\u{dcf}",
                "පරපෝෂ\u{dd2}තය\u{dcf}",
                "පස\u{dca} පණ\u{dd4}ව\u{dcf}",
                "ව\u{dcf}ලස\u{dd2}ක",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("dážďovka"),
            keywords: &["dážďovka", "červ", "červík"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("črv"),
            keywords: &["deževnik", "kolobarnik", "zajedavec", "črv"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("dirxi"),
            keywords: &["dirxi", "dirxiga dhulka", "dulle", "hooryaan"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("krimb"),
            keywords: &["krimb", "krimb toke", "parasit"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("црв"),
            keywords: &["глиста", "паразит", "црв"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("crv"),
            keywords: &["crv", "glista", "parazit"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("mask"),
            keywords: &["daggmask", "mask", "parasit", "ringmask"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mnyoo"),
            keywords: &["anelidi", "mdudu", "mnyoo", "nyungunyungu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("புழு"),
            keywords: &["ஒட\u{bcd}டுண\u{bcd}ணி", "புழு", "மண\u{bcd}புழு"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("క\u{c4d}ర\u{c3f}మ\u{c3f}"),
            keywords: &[
                "క\u{c4d}ర\u{c3f}మ\u{c3f}",
                "పర\u{c3e}న\u{c4d}నజ\u{c40}వ\u{c3f}",
                "య\u{c46}ర\u{c4d}రలు",
                "వ\u{c3e}నప\u{c3e}ము",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หนอน"),
            keywords: &[
                "ปรส\u{e34}ต",
                "หนอน",
                "หนอนปล\u{e49}อง",
                "ไส\u{e49}เด\u{e37}อน",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gurçuk"),
            keywords: &["gurçuk", "halkaly gurçuk", "parazit", "ýagyş gurçugy"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kelemutu"),
            keywords: &["kelemutu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("solucan"),
            keywords: &["kurt", "kurtçuk", "parazit", "solucan"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("хробак"),
            keywords: &["дощовий хробак", "кільчастий черв", "паразит", "хробак"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کیچوا"),
            keywords: &["زمینی کیڑا", "طفیلیہ", "کیچوا", "کیڑا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("qurt"),
            keywords: &["boʻgʻimli qurt", "chuvalchang", "parazit", "qurt"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("giun"),
            keywords: &["giun", "giun đất", "giun đốt", "ký sinh trùng", "sâu"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("蟲"),
            keywords: &["寄生蟲", "環蟲", "蚯蚓", "蟲"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("虫"),
            keywords: &["寄生虫", "环虫", "虫", "蚯蚓"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("蠕虫"),
            keywords: &["寄生虫", "环节动物", "蚯蚓", "蠕虫"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("蠕蟲"),
            keywords: &["寄生蟲", "環節動物", "蚯蚓", "蠕蟲"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isibungu"),
            keywords: &["i-annelid", "imbungulu", "isibungu", "isiqubuqubu"],
        },
    ],
};
#[doc = "🦠"]
pub const MICROBE: crate::Emoji = crate::Emoji {
    glyph: "🦠",
    codepoint: "1F9A0",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "microbe",
    group: "Animals & Nature",
    subgroup: "animal-bug",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("mikrobe"),
            keywords: &["amoeba", "bakterieë", "mikrobe", "virus"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ተህዋሳት"),
            keywords: &["ባክቴሪያ", "ቫይረስ", "ተህዋሳት", "አሜባ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("جرثومة"),
            keywords: &["أميبا", "بكتيريا", "جرثوم", "جرثومة", "فيروس", "ميكروب"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("জীব\u{9be}ণ\u{9c1}"),
            keywords: &[
                "এমিব\u{9be}",
                "জীব\u{9be}ণ\u{9c1}",
                "বেক\u{9cd}টেৰিয\u{9bc}\u{9be}",
                "ভ\u{9be}ইৰ\u{9be}ছ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("mikrob"),
            keywords: &["amöb", "bakteriya", "mikrob", "virus"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("мікроб"),
            keywords: &["амёба", "бактэрыя", "вірус", "мікроб"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("микроб"),
            keywords: &["амеба", "бактерия", "вирус", "микроб"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("জীব\u{9be}ণ\u{9c1}"),
            keywords: &[
                "অ\u{9cd}য\u{9be}মিব\u{9be}",
                "জীব\u{9be}ণ\u{9c1}",
                "ব\u{9cd}য\u{9be}কটেরিয\u{9bc}\u{9be}",
                "ভ\u{9be}ইর\u{9be}স",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("mikrob"),
            keywords: &["bakterienn", "mikrob"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("mikrob"),
            keywords: &["ameba", "bakterija", "mikrob", "virus"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("microbi"),
            keywords: &["ameba", "bacteri", "microbi", "virus"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎥᏳᎩ ᎠᏓᏠᎩ"),
            keywords: &["ᎤᏅᏥᏓ ᎠᎩᏍᎩ", "ᎥᏳᎩ ᎠᏓᏠᎩ", "ᎥᏳᎩ ᎠᏱᎵᏙ", "ᏬᏍᏗᎬ ᎬᏃᏗ ᎥᏳᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("mikrob"),
            keywords: &[
                "améba",
                "bacil",
                "bakterie",
                "mikrob",
                "mikroorganismus",
                "virus",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("microb"),
            keywords: &["ameba", "bacteria", "feirws", "microb"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("mikrobe"),
            keywords: &["amøbe", "bakterie", "mikrobe", "virus"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Mikrobe"),
            keywords: &["Amöbe", "Bakterie", "Einzeller", "Mikrobe"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μικρόβιο"),
            keywords: &["αμοιβάδα", "βακτήρια", "ιός", "μικρόβιο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("microbe"),
            keywords: &["amoeba", "bacteria", "microbe", "virus"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("microbio"),
            keywords: &["ameba", "bacteria", "germen", "microbio", "virus"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("microbio"),
            keywords: &["ameba", "amiba", "bacteria", "microbio", "virus"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("microbio"),
            keywords: &["microbio"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("mikroob"),
            keywords: &["amööb", "bakter", "mikroob", "viirus"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("mikrobio"),
            keywords: &["ameba", "bakterio", "birus", "mikrobio"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("میکروب"),
            keywords: &["آمیب", "باکتری", "میکروب", "ویروس"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("mikrobi"),
            keywords: &["ameba", "bakteeri", "mikrobi", "virus"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("mikrobyo"),
            keywords: &["amoeba", "bacteria", "germs", "mikrobyo", "virus"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("smávera"),
            keywords: &["amøba", "bakteria", "skaploysingur", "smávera", "virus"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("microbe"),
            keywords: &["amibe", "bactérie", "microbe", "virus"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("miocrób"),
            keywords: &["aiméibe", "baictéir", "miocrób", "víreas"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("bitheag"),
            keywords: &[
                "amoeba",
                "bacterium",
                "baictear",
                "bhìoras",
                "bitheag",
                "lobhag",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("microbio"),
            keywords: &["ameba", "bacteria", "microbio", "virus"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("જીવાણ\u{ac1}"),
            keywords: &[
                "અમીબા",
                "જીવાણ\u{ac1}",
                "બ\u{ac7}ક\u{acd}ટ\u{ac7}રિયા",
                "વાયરસ",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מיקרוב"),
            keywords: &["אמבה", "וירוס", "חיידק", "מיקרואורגניזם", "מיקרוב"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("रोगाण\u{941}"),
            keywords: &[
                "अमीबा",
                "ब\u{948}क\u{94d}टीरिया",
                "रोगाण\u{941}",
                "विषाण\u{941}",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("mikrob"),
            keywords: &["ameba", "bakterija", "mikrob", "virus"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("mikróba"),
            keywords: &["amőba", "baktérium", "mikróba", "vírus"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մանրէ"),
            keywords: &["ամեոբա", "բակտերիա", "մանրէ", "վիրուս"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("mikroba"),
            keywords: &["amuba", "bakteri", "mikroba", "virus"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("örvera"),
            keywords: &["amaba", "baktería", "veira", "vírus", "örvera"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("microbo"),
            keywords: &["ameba", "batteri", "microbo", "virus"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("微生物"),
            keywords: &["アメーバ", "ウイルス", "バクテリア", "微生物", "細菌"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("mikroba"),
            keywords: &["amuba", "bakteri", "mikroba", "virus"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მიკრობი"),
            keywords: &["ამება", "ბაქტერია", "ვირუსი", "მიკრობი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("микроб"),
            keywords: &["амеба", "бактерия", "вирус", "микроб"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17b8}ក\u{17d2}រ\u{17bb}ប"),
            keywords: &[
                "បាក\u{17cb}តេរ\u{17b8}",
                "ម\u{17b8}ក\u{17d2}រ\u{17bb}ប",
                "មេរោគ",
                "អាម\u{17b8}ប",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸ\u{cc2}ಕ\u{ccd}ಷ\u{ccd}ಮಜೀವ\u{cbf}"),
            keywords: &[
                "ಅಮೀಬಾ",
                "ಬ\u{ccd}ಯಾಕ\u{ccd}ಟೀರ\u{cbf}ಯಾ",
                "ವೈರಸ\u{ccd}",
                "ಸ\u{cc2}ಕ\u{ccd}ಷ\u{ccd}ಮಜೀವ\u{cbf}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("미생물"),
            keywords: &["미생물", "바이러스", "박테리아", "아메바"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("मायक\u{94d}रोब"),
            keywords: &[
                "अमिबा",
                "ब\u{945}क\u{94d}ट\u{947}रिया",
                "मायक\u{94d}रोब",
                "वायरस",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("микроб"),
            keywords: &["амеба", "бактерия", "вирус", "микроб"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຈ\u{eb8}ລະພ\u{eb7}ກ"),
            keywords: &[
                "ຈ\u{eb8}ລະພ\u{eb7}ກ",
                "ແບກເທ\u{eb5}ເລຍ",
                "ແອເມບາ",
                "ໄວລ\u{eb1}ດ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("mikrobas"),
            keywords: &["ameba", "bakterija", "mikrobas", "virusas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("mikrobs"),
            keywords: &["amēba", "baktērija", "mikrobs", "vīruss"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("микроба"),
            keywords: &["амеба", "бактерија", "вирус", "микроба"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("രോഗ\u{d3e}ണ\u{d41}"),
            keywords: &[
                "അമീബ",
                "ബ\u{d3e}ക\u{d4d}\u{200c}ടീരിയ",
                "രോഗ\u{d3e}ണ\u{d41}",
                "വൈറസ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("микроб"),
            keywords: &["амёб", "бактер", "вирус", "микроб"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("मायक\u{94d}रोब"),
            keywords: &[
                "अमीबा",
                "ब\u{945}क\u{94d}ट\u{947}रिया",
                "मायक\u{94d}रोब",
                "व\u{94d}हायरस",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("mikrob"),
            keywords: &["ameba", "bakteria", "mikrob", "virus"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အဏ\u{102f}ဇ\u{102e}ဝရ\u{102f}ပ\u{103a}"),
            keywords: &[
                "ဗက\u{103a}တ\u{102e}းရ\u{102e}းယား",
                "ဗ\u{102d}\u{102f}င\u{103a}းရပ\u{103a}စ\u{103a}",
                "အဏ\u{102f}ဇ\u{102e}ဝရ\u{102f}ပ\u{103a}",
                "အမ\u{102e}းဗား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("mikrobe"),
            keywords: &["amøbe", "bakterie", "mikrobe", "virus"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("अत\u{94d}यन\u{94d}त साना किटाण\u{941}"),
            keywords: &[
                "अत\u{94d}यन\u{94d}त साना किटाण\u{941}",
                "ऐमोइबा",
                "ब\u{94d}याक\u{94d}ट\u{947}रिया",
                "भाइरस",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("microbe"),
            keywords: &["amoeba", "bacterie", "microbe", "virus"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("mikrobe"),
            keywords: &["amøbe", "bakterie", "mikrobe", "virus"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କୀଟ\u{b3e}ଣ\u{b41}"),
            keywords: &[
                "ଏମ\u{b3f}ବ\u{b3e}",
                "କୀଟ\u{b3e}ଣ\u{b41}",
                "ବ\u{b4d}ୟ\u{b3e}କ\u{b4d}ଟେର\u{b3f}ଆ",
                "ଭ\u{b3e}ଇରସ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਜੀਵਾਣ\u{a42}"),
            keywords: &["ਅਮੀਬਾ", "ਜੀਵਾਣ\u{a42}", "ਬ\u{a48}ਕਟੀਰੀਆ", "ਵਾਇਰਸ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Maíkrob"),
            keywords: &["Baktẹ\u{301}ria", "Maíkrob", "Vaírọs", "Ámoẹ\u{301}ba"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("zarazek"),
            keywords: &[
                "ameba",
                "bakteria",
                "drobnoustrój",
                "mikrob",
                "wirus",
                "zarazek",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("مايکروب"),
            keywords: &["اميبا، بيکتيريا، ميکروب، ويروس", "مايکروب"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("micróbio"),
            keywords: &["ameba", "bactéria", "micróbio", "vírus"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("microbio"),
            keywords: &["ameba", "bacteria", "microbio", "virus"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("microb"),
            keywords: &["amibă", "bacterie", "microb", "virus"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E11-030"),
            keywords: &["E11-030"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("микроб"),
            keywords: &["амеба", "бактерия", "вирус", "микроб"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مائڪروب"),
            keywords: &["اموبا", "بيڪٽيريا", "مائڪروب", "وائرس"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ක\u{dca}ෂ\u{dd4}ද\u{dca}\u{200d}ර ජ\u{dd3}ව\u{dd2}ය\u{dcf}"),
            keywords: &[
                "ඇම\u{dd3}බ\u{dcf}",
                "ක\u{dca}ෂ\u{dd4}ද\u{dca}\u{200d}ර ජ\u{dd3}ව\u{dd2}ය\u{dcf}",
                "බැක\u{dca}ට\u{dd3}ර\u{dd2}ය\u{dcf}",
                "වෛරස",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("mikrób"),
            keywords: &["améba", "baktéria", "mikrób", "vírus"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("mikrob"),
            keywords: &["ameba", "bakterija", "mikrob", "virus"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("mikrobe"),
            keywords: &["amiiba", "bakteeriya", "mikrobe"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("mikrob"),
            keywords: &["amebë", "bakter", "mikrob", "virus"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("микроб"),
            keywords: &["амеба", "бактерија", "вирус", "микроб"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("mikrob"),
            keywords: &["ameba", "bakterija", "mikrob", "virus"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("mikrob"),
            keywords: &["amöba", "bakterie", "mikrob", "virus"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("bakteria"),
            keywords: &["amoeba", "bakteria", "virusi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("நுண\u{bcd}ணுயிரி"),
            keywords: &[
                "அம\u{bc0}ப\u{bbe}",
                "நுண\u{bcd}ணுயிரி",
                "ப\u{bbe}க\u{bcd}ட\u{bc0}ரிய\u{bbe}",
                "வைரஸ\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("సూక\u{c4d}ష\u{c4d}మక\u{c4d}ర\u{c3f}మ\u{c3f}"),
            keywords: &[
                "అమ\u{c40}బ\u{c3e}",
                "బ\u{c4d}య\u{c3e}క\u{c4d}ట\u{c40}ర\u{c3f}య\u{c3e}",
                "వ\u{c48}రస\u{c4d}",
                "సూక\u{c4d}ష\u{c4d}మక\u{c4d}ర\u{c3f}మ\u{c3f}",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("จ\u{e38}ล\u{e34}นทร\u{e35}ย\u{e4c}"),
            keywords: &[
                "จ\u{e38}ล\u{e34}นทร\u{e35}ย\u{e4c}",
                "อะม\u{e35}บา",
                "แบคท\u{e35}เร\u{e35}ย",
                "ไวร\u{e31}ส",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("mikrop"),
            keywords: &["amýoba", "bakteriýa", "mikrop", "wirus"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("siemu"),
            keywords: &["siemu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("mikrop"),
            keywords: &["amip", "bakteri", "mikrop", "virüs"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("мікроб"),
            keywords: &[
                "амеба",
                "бактерія",
                "вірус",
                "мікроб",
                "мікроорганізм",
                "хвороба",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("جرثومہ"),
            keywords: &["امیبا", "بیکٹیریا", "جرثومہ", "وائرس"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("mikrob"),
            keywords: &["amyoba", "bakteriya", "mikrob", "virus"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("vi trùng"),
            keywords: &["Amip", "vi khuẩn", "vi rút", "vi trùng"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("微生物"),
            keywords: &["微生物", "病毒", "細菌", "阿米巴"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("微生物"),
            keywords: &["微生物", "病毒", "细菌", "阿米巴"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("细菌"),
            keywords: &["变形虫", "病毒", "细菌"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("微生物"),
            keywords: &["微生物", "病毒", "細菌", "阿米巴"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("microbe"),
            keywords: &["amoeba", "bacteria", "microbe", "virus"],
        },
    ],
};
