#[doc = "🦃"]
pub const TURKEY: crate::Emoji = crate::Emoji {
    glyph: "🦃",
    codepoint: "1F983",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "turkey",
    group: "Animals & Nature",
    subgroup: "animal-bird",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("kalkoen"),
            keywords: &["kalkoen", "voël"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ቆቅ"),
            keywords: &["ቆቅ", "ወፍ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ديك رومي"),
            keywords: &["حبش", "ديك رومي", "رومي"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ট\u{9be}ৰ\u{9cd}কি"),
            keywords: &["ট\u{9be}ৰ\u{9cd}কি", "পক\u{9cd}ষী"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("hinduşka"),
            keywords: &["hinduşka", "quş"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("індычка"),
            keywords: &["птушка", "індычка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("пуйка"),
            keywords: &["пуйка"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ট\u{9be}র\u{9cd}কি ,ট\u{9be}র\u{9cd}কি মোরগ"),
            keywords: &[
                "ট\u{9be}র\u{9cd}কি ,ট\u{9be}র\u{9cd}কি মোরগ",
                "ট\u{9be}র\u{9cd}কি ম\u{9c1}রগী",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kog-Spagn"),
            keywords: &["evn", "kog-Spagn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("ćurka"),
            keywords: &["ptica", "ćurka"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("gall dindi"),
            keywords: &["au", "gall dindi", "indiot"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄑𑄢\u{11134}𑄇\u{11128} 𑄛\u{1112a}𑄢\u{1112f}"),
            keywords: &["𑄑𑄢\u{11134}𑄇\u{11128} 𑄛\u{1112a}𑄢\u{1112f}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎬᏂ"),
            keywords: &["ᎬᏂ", "ᏥᏍᏆ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("krocan"),
            keywords: &["krocan", "pták"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("twrci"),
            keywords: &["aderyn", "twrci"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kalkun"),
            keywords: &["fugl", "kalkun"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Truthahn"),
            keywords: &["Geflügel", "Truthahn"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("γαλοπούλα"),
            keywords: &["γαλοπούλα", "πτηνό"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("turkey"),
            keywords: &["bird", "turkey"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["bird", "poultry", "turkey"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("pavo"),
            keywords: &["animal", "ave", "pavo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kalkun"),
            keywords: &["kalkun"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("indioilarra"),
            keywords: &["indioilar", "indioilarra"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("بوقلمون"),
            keywords: &["بوقلمون", "گوشت بوقلمون"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kalkkuna"),
            keywords: &["kalkkuna", "lintu"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pabo"),
            keywords: &["hayop", "pabo", "turkey"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("kalkun"),
            keywords: &["dýr", "fuglur", "kalkun"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("dindon"),
            keywords: &["animal", "dindon", "oiseau"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("dinde"),
            keywords: &["dinde", "oiseau"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("turcaí"),
            keywords: &["turcaí", "éan"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("eun-Frangach"),
            keywords: &[
                "cearc",
                "cearc-Fhrangach",
                "coileach-Frangach",
                "coileach-Turcach",
                "eun",
                "eun-Frangach",
                "eun-frangach",
                "eunlaith",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("pavo"),
            keywords: &["pavo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ટર\u{acd}કી"),
            keywords: &["ટર\u{acd}કી"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("talo-talo"),
            keywords: &["talo-talo", "tsuntsu"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("תרנגול הודו"),
            keywords: &["תרנגול הודו"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("टर\u{94d}की"),
            keywords: &["टर\u{94d}की"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("puran"),
            keywords: &["puran", "purica"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("pulyka"),
            keywords: &["madár", "pulyka"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("հնդկահավ"),
            keywords: &["թռչուն", "հնդկահավ", "հնդուհավ", "փքված"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kalkun"),
            keywords: &["burung", "kalkun"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("torotoro"),
            keywords: &["nnụnụ", "torotoro"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kalkúnn"),
            keywords: &["fugl", "kalkúnn"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("tacchino"),
            keywords: &["animale", "tacchino"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("七面鳥"),
            keywords: &["ターキー", "七面鳥", "動物", "鳥"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kalkun"),
            keywords: &["kalkun", "unggas"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ინდაური"),
            keywords: &["ინდაური", "ფრინველი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("күркетауық"),
            keywords: &["күркетауық", "құс"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("kalkun"),
            keywords: &["kalkun"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("មាន\u{17cb}ត\u{17bd}កគ\u{17b8}"),
            keywords: &["មាន\u{17cb}", "មាន\u{17cb}ត\u{17bd}កគ\u{17b8}"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಟ\u{cbf}ರ\u{ccd}ಕ\u{cbf} ಕೋಳ\u{cbf}"),
            keywords: &["ಟರ\u{ccd}ಕ\u{cbf}", "ಟ\u{cbf}ರ\u{ccd}ಕ\u{cbf} ಕೋಳ\u{cbf}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("칠면조"),
            keywords: &["새", "칠면조", "터키"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("टर\u{94d}की"),
            keywords: &["टर\u{94d}की", "स\u{941}कण\u{947}\u{902}"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("үндүк"),
            keywords: &["индюк", "куш", "үндүк"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Schnuddelhong"),
            keywords: &["Schnuddelhong", "Vugel"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໄກ\u{ec8}ງວງ"),
            keywords: &["ສ\u{eb1}ດ", "ໄກ\u{ec8}ງວງ", "ໄກ\u{ec8}ງ\u{ec9}ວງ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("kalakutas"),
            keywords: &["kalakutas", "paukštis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("tītars"),
            keywords: &["putns", "tītars"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("korukoru"),
            keywords: &["korukoru", "manu"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("мисирка"),
            keywords: &["живина", "мисирка"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ടർക\u{d4d}കി കോഴി"),
            keywords: &["ടർക\u{d4d}കി കോഴി"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("цацагт хяруул"),
            keywords: &["цацагт хяруул", "шувуу"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("टर\u{94d}की"),
            keywords: &["टर\u{94d}की", "पक\u{94d}षी"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("ayam belanda"),
            keywords: &["ayam belanda"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("dundjan"),
            keywords: &["dundjan", "għasfur"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ကြက\u{103a}ဆင\u{103a}"),
            keywords: &["ကြက\u{103a}ဆင\u{103a}"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kalkun"),
            keywords: &["fugl", "kalkun"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("टर\u{94d}की"),
            keywords: &["टर\u{94d}की"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("kalkoen"),
            keywords: &["gevogelte", "kalkoen"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kalkun"),
            keywords: &["fugl", "kalkun"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଟର\u{b4d}କୀ"),
            keywords: &["ଟର\u{b4d}କୀ", "ଟର\u{b4d}କୀ । ପକ\u{b4d}ଷୀ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਟਰਕੀ"),
            keywords: &["ਜਾਨਵਰ", "ਟਰਕੀ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ترکی"),
            keywords: &["ترکی", "پنچھی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Tọkí"),
            keywords: &["Bẹd", "Tọkí"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("indyk"),
            keywords: &["indyk"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("پيل مرغ"),
            keywords: &["مرغ، پيل مرغ", "پيل مرغ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("peru"),
            keywords: &["ave", "peru"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["ave", "peru"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("pavo"),
            keywords: &["pavo", "p’isqu"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("curcan"),
            keywords: &["curcan", "pasăre"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1099"),
            keywords: &["E10-1099"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("индейка"),
            keywords: &["индейка", "индюк", "крылья", "птица"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("turukiya"),
            keywords: &["inyoni", "turikiya", "turukiya"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ٽرڪي"),
            keywords: &["ترڪي", "ترڪي، پکي", "ٽرڪي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කළ\u{dd4}ක\u{dd4}ම\u{dcf}"),
            keywords: &[
                "කළ\u{dd4}ක\u{dd4}ම\u{dcf}",
                "ක\u{dd4}ර\u{dd4}ල\u{dca}ල\u{dcf}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("moriak"),
            keywords: &["moriak", "morka"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("puran"),
            keywords: &["puran"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("diikh rumiin"),
            keywords: &["diikh rumiin", "shimbir"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("gjel deti"),
            keywords: &["gjel deti", "shpend"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("ћурка"),
            keywords: &["птица", "ћурка"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("ćurka"),
            keywords: &["ptica", "ćurka"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("kalkon"),
            keywords: &["fågel", "kalkon"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("bata mzinga"),
            keywords: &["bata mzinga", "ndege"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வ\u{bbe}ன\u{bcd}கோழி"),
            keywords: &["பறவை", "வ\u{bbe}ன\u{bcd}கோழி"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("టర\u{c4d}క\u{c40} క\u{c4b}డ\u{c3f}"),
            keywords: &[
                "టర\u{c4d}క\u{c40}",
                "టర\u{c4d}క\u{c40} క\u{c4b}డ\u{c3f}",
                "పక\u{c4d}ష\u{c3f}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("мурғи марҷон"),
            keywords: &["мурғи марҷон", "парранда"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ไก\u{e48}งวง"),
            keywords: &["ส\u{e31}ตว\u{e4c}ป\u{e35}ก", "ไก\u{e48}งวง"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("hindi towugy"),
            keywords: &["guş", "hindi towugy", "indýuk"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("pīpī"),
            keywords: &["pīpī"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("hindi"),
            keywords: &["hindi"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ياۋا توخۇ"),
            keywords: &["قۇش", "ياۋا توخۇ"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("індик"),
            keywords: &["птах", "індик", "індичка"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ٹرکی"),
            keywords: &["جانور", "ٹرکی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kurka"),
            keywords: &["kurka", "parranda"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("gà tây"),
            keywords: &["chim", "gà tây"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("koppin"),
            keywords: &["koppin", "picc"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-turkey"),
            keywords: &["i-turkey", "intaka"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Tólòtólò"),
            keywords: &["Tólòtólò", "tòlótòló", "ẹyẹ"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("火雞"),
            keywords: &["火雞", "雀"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("火鸡"),
            keywords: &["火鸡", "雀"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("火鸡"),
            keywords: &["火鸡"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("火雞"),
            keywords: &["火雞"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ithekhi"),
            keywords: &["ithekhi"],
        },
    ],
};
#[doc = "🐔"]
pub const CHICKEN: crate::Emoji = crate::Emoji {
    glyph: "🐔",
    codepoint: "1F414",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "chicken",
    group: "Animals & Nature",
    subgroup: "animal-bird",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("hoender"),
            keywords: &["hoender", "voël"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ዶሮ"),
            keywords: &["ሴት ዶሮ", "ዶሮ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("دجاجة"),
            keywords: &["دجاج", "دجاجة", "طائر", "فرخة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ম\u{9c2}ৰ\u{9cd}গী"),
            keywords: &[
                "পক\u{9cd}ষী",
                "ম\u{9be}ইকী ম\u{9c2}ৰ\u{9cd}গী",
                "ম\u{9c2}ৰ\u{9cd}গী",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("toyuq"),
            keywords: &["quş", "toyuq"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("курыца"),
            keywords: &["курыца", "птушка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("кокошка"),
            keywords: &["кокошка"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("চিকেন"),
            keywords: &["চিকেন", "ম\u{9c1}রগি"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("yar"),
            keywords: &["evn", "yar"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("kokoš"),
            keywords: &["kokoš", "ptica"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("pollastre"),
            keywords: &["au", "pollastre"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄛\u{1112a}𑄢\u{1112f} 𑄌\u{11127}"),
            keywords: &["𑄛\u{1112a}𑄢\u{1112f} 𑄌\u{11127}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏣᏔᎦ"),
            keywords: &["ᏣᏔᎦ", "ᏥᏍᏆ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("slepice"),
            keywords: &["pták", "slepice"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("iâr"),
            keywords: &["aderyn", "iâr"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("høne"),
            keywords: &["dyr", "høne"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Huhn"),
            keywords: &["Geflügel", "Henne", "Huhn", "Tier"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κότα"),
            keywords: &["κοτόπουλο", "κότα", "πτηνό"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("chicken"),
            keywords: &["bird", "chicken"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["bird", "chicken", "poultry"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("gallina"),
            keywords: &["ave", "gallina", "gallinácea", "pollo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("gallina"),
            keywords: &["gallina"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kana"),
            keywords: &["kana"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("oiloa"),
            keywords: &["oilo", "oiloa"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("مرغ"),
            keywords: &["جوجه", "مرغ"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kana"),
            keywords: &["kana", "lintu"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("manok"),
            keywords: &["hayop", "manok", "poultry"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("hønuandlit"),
            keywords: &["andlit", "høna", "hønuandlit", "høsnarungi"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("poule"),
            keywords: &["animal", "oiseau", "poule"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["oiseau", "poule"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("sicín"),
            keywords: &["sicín", "éan"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cearc"),
            keywords: &["cearc", "eun", "eunlaith"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("polo"),
            keywords: &["polo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ચિકન"),
            keywords: &[
                "ચિકન",
                "પ\u{acd}રાણી",
                "મરઘીન\u{ac1}\u{a82} બચ\u{acd}ચ\u{ac1}\u{a82}",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kaza"),
            keywords: &["kaza", "tsuntsu"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("תרנגולת"),
            keywords: &["עוף", "ציפור", "תרנגול", "תרנגולת"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("म\u{941}र\u{94d}गी"),
            keywords: &["पश\u{941}", "म\u{941}र\u{94d}गी"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("kokoš"),
            keywords: &["koka", "kokoš"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("tyúk"),
            keywords: &["madár", "tyúk"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("հավ"),
            keywords: &["ընտանի", "թռչուն", "հավ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("ayam"),
            keywords: &["ayam", "burung"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ọkụkọ"),
            keywords: &["nnụnụ", "ọkụkọ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kjúklingur"),
            keywords: &["fugl", "hæna", "kjúklingur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("gallina"),
            keywords: &["animale", "gallina"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("にわとり"),
            keywords: &["にわとり", "動物", "顔", "鳥"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("pitik"),
            keywords: &["pitik", "unggas"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ქათამი"),
            keywords: &["ფრინველი", "ქათამი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("тауық"),
            keywords: &["тауық", "құс"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("høne"),
            keywords: &["dyr", "høne"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("មាន\u{17cb}"),
            keywords: &["បក\u{17d2}ស\u{17b8}", "មាន\u{17cb}"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಚ\u{cbf}ಕನ\u{ccd}"),
            keywords: &["ಕೋಳ\u{cbf}", "ಚ\u{cbf}ಕನ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("닭"),
            keywords: &["닭", "동물", "암탉", "치킨"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("कोमी"),
            keywords: &["कोमी", "स\u{941}कण\u{947}\u{902}"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("тоок"),
            keywords: &["куш", "тоок"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Hong"),
            keywords: &["Hong", "Vugel"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໄກ\u{ec8}"),
            keywords: &["ນ\u{ebb}ກ", "ໄກ\u{ec8}"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("višta"),
            keywords: &["paukštis", "višta"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("vista"),
            keywords: &["putns", "vista"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("heihei"),
            keywords: &["heihei", "manu"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("кокошка"),
            keywords: &["живина", "кокошка"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കോഴി"),
            keywords: &["കോഴി", "ചിക\u{d4d}കൻ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("тахиа"),
            keywords: &["тахиа", "шувуу"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("को\u{902}बडी"),
            keywords: &["को\u{902}बडी", "पक\u{94d}षी"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("ayam"),
            keywords: &["ayam"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("tiġieġa"),
            keywords: &["għasfur", "tiġieġ", "tiġieġa"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ကြက\u{103a}"),
            keywords: &["ကြက\u{103a}"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("høne"),
            keywords: &["dyr", "fugl", "høne"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("क\u{941}ख\u{941}रा"),
            keywords: &["क\u{941}ख\u{941}रा"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("kip"),
            keywords: &["gevogelte", "kip"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("høne"),
            keywords: &["dyr", "fugl", "høne"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କ\u{b41}କ\u{b41}ଡ\u{b3c}\u{b3e}"),
            keywords: &["କ\u{b41}କ\u{b41}ଡ\u{b3c}\u{b3e}", "ପଶ\u{b41}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਚ\u{a42}ਚਾ"),
            keywords: &["ਚ\u{a42}ਚਾ", "ਜਾਨਵਰ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("پالت\u{64f}و ک\u{64f}کڑ"),
            keywords: &["پالت\u{64f}و ک\u{64f}کڑ", "پنچھی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Chíkin"),
            keywords: &["Bẹd", "Chíkin"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kura"),
            keywords: &["kura", "kurczak"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("چرګ"),
            keywords: &["مرغۍ، چرګ", "چرګ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("galinha"),
            keywords: &["ave", "galinha"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["ave", "galinha"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("pollo"),
            keywords: &["pollo", "p’isqu"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("găină"),
            keywords: &["găină", "pasăre"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-465"),
            keywords: &["E10-465"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("курица"),
            keywords: &["голова", "курица", "птица", "цыпленок"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("inkoko"),
            keywords: &["inkoko", "inyoni"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مرغي"),
            keywords: &["مرغ، پکي", "مرغي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ක\u{dd2}ක\u{dd2}ළ\u{dd2}"),
            keywords: &[
                "ක\u{dd2}ක\u{dd2}ළ\u{dd2}",
                "ක\u{dd4}ක\u{dd4}ල\u{dca} මස\u{dca}",
                "ක\u{dd4}ර\u{dd4}ල\u{dca}ල\u{dcf}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("sliepka"),
            keywords: &["kura", "sliepka"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("kokoš"),
            keywords: &["kokoš", "kokoška", "kura"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("diggaag"),
            keywords: &["diggaag", "shimbir"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("pulë"),
            keywords: &["pulë", "shpend"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("кокошка"),
            keywords: &["кокошка", "птица"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("kokoška"),
            keywords: &["kokoška", "ptica"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("höna"),
            keywords: &["fågel", "höna"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kuku"),
            keywords: &["kuku", "ndege"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கோழிக\u{bcd}குஞ\u{bcd}சு"),
            keywords: &["கோழிக\u{bcd}குஞ\u{bcd}சு", "பறவை"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("క\u{c4b}డ\u{c3f}ప\u{c46}ట\u{c4d}ట"),
            keywords: &[
                "క\u{c4b}డ\u{c3f}ప\u{c3f}ల\u{c4d}ల",
                "క\u{c4b}డ\u{c3f}ప\u{c46}ట\u{c4d}ట",
                "జంతువు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("чӯҷа"),
            keywords: &["парранда", "чӯҷа"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ไก\u{e48}"),
            keywords: &["ส\u{e31}ตว\u{e4c}ป\u{e35}ก", "ไก\u{e48}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("towuk"),
            keywords: &["guş", "towuk"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("moa"),
            keywords: &["moa"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("tavuk"),
            keywords: &["kuş", "tavuk"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("توخۇ"),
            keywords: &["توخۇ", "قۇش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("курка"),
            keywords: &["квочка", "курка", "птах"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("چکن"),
            keywords: &["جانور", "چکن"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("tovuq"),
            keywords: &["jo‘ja", "tovuq"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("gà"),
            keywords: &["chim", "gà"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("ginaar"),
            keywords: &["ginaar", "picc"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("inkuku"),
            keywords: &["inkuku", "intaka"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Adìyẹ"),
            keywords: &["Adìyẹ", "adìye", "ẹyẹ"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("雞"),
            keywords: &["雀", "雞"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("鸡"),
            keywords: &["雀", "鸡"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("鸡"),
            keywords: &["鸡"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("雞"),
            keywords: &["雞"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("inkukhu"),
            keywords: &["inkukhu"],
        },
    ],
};
#[doc = "🐓"]
pub const ROOSTER: crate::Emoji = crate::Emoji {
    glyph: "🐓",
    codepoint: "1F413",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "rooster",
    group: "Animals & Nature",
    subgroup: "animal-bird",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("haan"),
            keywords: &["haan", "voël"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("አውራ ዶሮ"),
            keywords: &["አውራ ዶሮ", "ወፍ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ديك"),
            keywords: &["ديك", "طائر"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("মত\u{9be} ম\u{9c2}ৰ\u{9cd}গী"),
            keywords: &["চৰ\u{9be}ই", "মত\u{9be} ম\u{9c2}ৰ\u{9cd}গী"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("xoruz"),
            keywords: &["quş", "xoruz"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("певень"),
            keywords: &["певень", "птушка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("петел"),
            keywords: &["петел"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মোরগ"),
            keywords: &["মোরগ"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kilhog"),
            keywords: &["evn", "kilhog"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("pijetao"),
            keywords: &["pijetao", "ptica"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("gall"),
            keywords: &["au", "gall"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏣᏔᎦ ᎠᏨᏯ"),
            keywords: &["ᏣᏔᎦ ᎠᏨᏯ", "ᏥᏍᏆ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("kohout"),
            keywords: &["kohout", "pták"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("ceiliog"),
            keywords: &["aderyn", "ceiliog"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("hane"),
            keywords: &["dyr", "hane"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Hahn"),
            keywords: &["Hahn", "Tier"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κόκορας"),
            keywords: &["κόκορας", "πτηνό"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("rooster"),
            keywords: &["bird", "rooster"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("cockerel"),
            keywords: &["bird", "cockerel", "rooster"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("gallo"),
            keywords: &["ave", "gallina", "gallinácea", "gallo", "pollo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["animal", "ave", "gallo"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["ave", "gallo"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kukk"),
            keywords: &["kukk"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("oilarra"),
            keywords: &["oilar", "oilarra"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("خروس"),
            keywords: &["خروس"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kukko"),
            keywords: &["kukko", "lintu"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("tandang"),
            keywords: &["hayop", "lalaki", "manok", "sabong", "tandang"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("hani"),
            keywords: &["dýr", "fuglur", "hani"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("coq"),
            keywords: &["animal", "coq", "oiseau"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["coq", "oiseau"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("coileach"),
            keywords: &["coileach", "éan"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("coileach"),
            keywords: &["coileach", "eun", "eunlaith"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("galo"),
            keywords: &["galo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ક\u{ac2}કડો"),
            keywords: &["ક\u{ac2}કડો", "પ\u{acd}રાણી"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("zakara"),
            keywords: &["tsuntsu", "zakara"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("תרנגול"),
            keywords: &["עוף", "ציפור", "תרנגול"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("म\u{941}र\u{94d}गा"),
            keywords: &["पश\u{941}", "म\u{941}र\u{94d}गा"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("pijetao"),
            keywords: &["kokot", "pijetao"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("kakas"),
            keywords: &["kakas", "madár"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("աքաղաղ"),
            keywords: &["աքաղաղ", "ընտանի", "թռչուն", "ծուղրուղու", "հպարտ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("ayam jago"),
            keywords: &["ayam jago", "burung"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("àkwamakwa"),
            keywords: &["akwa", "nnụnụ", "àkwamakwa"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hani"),
            keywords: &["fugl", "hani"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("gallo"),
            keywords: &["animale", "gallo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("おんどり"),
            keywords: &["おんどり", "動物", "鳥"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("pitik jago"),
            keywords: &["pitik jago", "unggas"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მამალი"),
            keywords: &["მამალი", "ფრინველი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("әтеш"),
            keywords: &["әтеш"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("hane"),
            keywords: &["dyr", "hane"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("មាន\u{17cb}គក"),
            keywords: &["មាន\u{17cb}", "មាន\u{17cb}គក"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಹುಂಜ"),
            keywords: &["ಪಕ\u{ccd}ಷ\u{cbf}", "ಹುಂಜ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("수탉"),
            keywords: &["동물", "수탉"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("कोमो"),
            keywords: &["कोमो", "स\u{941}कण\u{947}\u{902}"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("короз"),
            keywords: &["короз", "корооз", "куш"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Hunn"),
            keywords: &["Hunn", "Vugel"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໄກ\u{ec8}ຜ\u{eb9}\u{ec9}"),
            keywords: &["ສ\u{eb1}ດ", "ໄກ\u{ec8}", "ໄກ\u{ec8}ຜ\u{eb9}\u{ec9}"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("gaidys"),
            keywords: &["gaidys", "paukštis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("gailis"),
            keywords: &["gailis", "putns"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tameheihei"),
            keywords: &["manu", "tameheihei"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("петел"),
            keywords: &["живина", "петел"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പ\u{d42}വൻ കോഴി"),
            keywords: &["പ\u{d42}വൻ കോഴി"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("азарган тахиа"),
            keywords: &["азарган тахиа", "шувуу"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("को\u{902}बडा"),
            keywords: &["को\u{902}बडा", "पक\u{94d}षी"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("ayam jantan"),
            keywords: &["ayam jantan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("serduk"),
            keywords: &["għasfur", "serduk"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("က\u{103d}ကျဖ"),
            keywords: &["က\u{103d}ကျဖ"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("hane"),
            keywords: &["dyr", "fugl", "hane"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("भाल\u{947}"),
            keywords: &["भाल\u{947}"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("haan"),
            keywords: &["gevogelte", "haan"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("hane"),
            keywords: &["dyr", "fugl", "hane"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଗ\u{b43}ହପ\u{b3e}ଳ\u{b3f}ତ ଗଞ\u{b4d}ଜ\u{b3e}"),
            keywords: &[
                "ଗ\u{b43}ହପ\u{b3e}ଳ\u{b3f}ତ ଗଞ\u{b4d}ଜ\u{b3e}",
                "ପକ\u{b4d}ଷୀ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕ\u{a41}\u{a71}ਕੜ"),
            keywords: &["ਕ\u{a41}\u{a71}ਕੜ", "ਜਾਨਵਰ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ک\u{64f}کڑ"),
            keywords: &["پنچھی", "ک\u{64f}کڑ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Machọ\u{301} Mán Chíkin"),
            keywords: &["Bẹd", "Machọ\u{301} Mán Chíkin"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kogut"),
            keywords: &["kogut"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("بانګي"),
            keywords: &["بانګي", "مرغۍ، بانګي"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("galo"),
            keywords: &["ave", "galo"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["ave", "galo"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("kʼanka"),
            keywords: &["kʼanka", "k’anka", "p’isqu"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("cocoș"),
            keywords: &["cocoș", "pasăre"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-464"),
            keywords: &["E10-464"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("петух"),
            keywords: &["гребешок", "петух", "петушок", "птица"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("isake"),
            keywords: &["inyoni", "isake"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مرغو"),
            keywords: &["مرغو", "مرغو، پکي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ක\u{dd4}ක\u{dd4}ළ\u{dcf}"),
            keywords: &[
                "ක\u{dd4}ක\u{dd4}ළ\u{dcf}",
                "ක\u{dd4}ර\u{dd4}ල\u{dca}ල\u{dcf}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("kohút"),
            keywords: &["kohút"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("petelin"),
            keywords: &["petelin"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("diiq"),
            keywords: &["diiq", "shimbir"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("gjel"),
            keywords: &["gjel", "shpend"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("певац"),
            keywords: &["певац", "птица"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("пијевац"),
            keywords: &["пијевац"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("pevac"),
            keywords: &["pevac", "ptica"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("pijevac"),
            keywords: &["pijevac"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("tupp"),
            keywords: &["fågel", "tupp"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("jogoo"),
            keywords: &["jimbi", "jogoo"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சேவல\u{bcd}"),
            keywords: &[
                "சேவல\u{bcd}",
                "பறவை",
                "வ\u{bc0}ட\u{bcd}டுச\u{bcd} சேவல\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("క\u{c4b}డ\u{c3f}పుంజు"),
            keywords: &["క\u{c4b}డ\u{c3f}పుంజు", "జంతువు"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("хурӯс"),
            keywords: &["парранда", "хурӯс"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ไก\u{e48}ต\u{e31}วผ\u{e39}\u{e49}"),
            keywords: &[
                "ส\u{e31}ตว\u{e4c}ป\u{e35}ก",
                "ไก\u{e48}",
                "ไก\u{e48}ต\u{e31}วผ\u{e39}\u{e49}",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("horaz"),
            keywords: &["guş", "horaz"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("moataʻane"),
            keywords: &["moataʻane"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("horoz"),
            keywords: &["horoz", "kuş"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("خوراز"),
            keywords: &["خوراز", "قۇش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("півень"),
            keywords: &["когут", "птах", "півень"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("مرغی"),
            keywords: &["جانور", "مرغ", "مرغی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("xo‘roz"),
            keywords: &["parranda", "xoʻroz", "xo‘roz"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("gà trống"),
            keywords: &["chim", "gà trống"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("séq"),
            keywords: &["picc", "séq"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("inkunzi yenkuku"),
            keywords: &["inkunzi yenkuku", "intaka"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Akukọ"),
            keywords: &["Akukọ", "àkùkọ", "ẹyẹ"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("公雞"),
            keywords: &["公雞", "雀"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("公鸡"),
            keywords: &["公鸡", "雀"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("公鸡"),
            keywords: &["公鸡", "鸡"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("公雞"),
            keywords: &["公雞", "雞"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("iqhude"),
            keywords: &["iqhude"],
        },
    ],
};
#[doc = "🐣"]
pub const HATCHING_CHICK: crate::Emoji = crate::Emoji {
    glyph: "🐣",
    codepoint: "1F423",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "hatching chick",
    group: "Animals & Nature",
    subgroup: "animal-bird",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("kuiken wat uitbroei"),
            keywords: &["baba", "kuiken", "kuiken wat uitbroei", "uitbroei", "voël"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ከእንቁላል ተፈልፍላ የምትወጣ ጫጩት"),
            keywords: &["ሕፃን", "መፈልፈል", "ከእንቁላል ተፈልፍላ የምትወጣ ጫጩት", "ጫጩት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("كتكوت خارج البيضة"),
            keywords: &["حيوان", "فقس", "كتكوت", "كتكوت خارج البيضة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("কণী ফ\u{9c1}টি ওলোৱ\u{9be} চৰ\u{9be}ই পোৱ\u{9be}লী"),
            keywords: &[
                "কণী ফ\u{9c1}টি ওলোৱ\u{9be} চৰ\u{9be}ই পোৱ\u{9be}লী",
                "চৰ\u{9be}ই",
                "পোৱ\u{9be}লী",
                "ম\u{9c2}ৰ\u{9cd}গীৰ পোৱ\u{9be}লী",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("yumurtadan çıxan cücə"),
            keywords: &[
                "cücə",
                "körpə",
                "yumurtadan çıxan cücə",
                "yumurtadan çıxmaq",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("кураня вылупліваецца"),
            keywords: &["вылупліванне", "дзіцяня", "кураня", "кураня вылупліваецца"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Излюпващо се пиленце"),
            keywords: &["Излюпващо се пиленце", "излюпващо се", "пиленце"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("হ\u{9cd}য\u{9be}চিং চিক"),
            keywords: &[
                "ব\u{9be}চ\u{9cd}চ\u{9be}",
                "ব\u{9be}চ\u{9cd}চ\u{9be} ম\u{9c1}রগি",
                "হ\u{9cd}য\u{9be}চিং",
                "হ\u{9cd}য\u{9be}চিং চিক",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("izleglo pile"),
            keywords: &["beba", "izleglo", "pile", "ptica"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("pollet que surt de l’ou"),
            keywords: &["au", "ou", "pollet", "pollet que surt de l’ou"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏣᏔᎩ ᎠᏣᎢ"),
            keywords: &["ᎠᏣᎢ", "ᎤᏍᏗ", "ᏣᏔᎦ ᎤᏍᏗ", "ᏣᏔᎩ ᎠᏣᎢ", "ᏥᏍᏆ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("líhnoucí se kuře"),
            keywords: &[
                "klubající",
                "klubání",
                "kuře",
                "kuřátko",
                "líhnoucí se kuře",
                "líhnutí",
                "pták",
                "vajíčko",
                "vejce",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("deoriad cywion"),
            keywords: &["babi", "cyw", "deor", "deoriad cywion"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("nyudklækket kylling"),
            keywords: &["dyr", "kylling", "nyudklækket kylling"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("schlüpfendes Küken"),
            keywords: &["Küken", "Tier", "schlüpfen", "schlüpfendes Küken"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("εκκολαπτόμενο κοτοπουλάκι"),
            keywords: &[
                "εκκολαπτόμενο",
                "εκκολαπτόμενο κοτοπουλάκι",
                "μωρό",
                "πουλάκι",
                "πτηνό",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("hatching chick"),
            keywords: &["baby", "bird", "chick", "hatching"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("pollito rompiendo el cascarón"),
            keywords: &[
                "ave",
                "huevo",
                "pollito",
                "pollito rompiendo el cascarón",
                "pollo",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &[
                "animal",
                "cascarón",
                "nacer",
                "pollito",
                "pollito rompiendo el cascarón",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kooruv tibu"),
            keywords: &["koorumine", "kooruv tibu", "tibu"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("arrautzetik irten berri den txita"),
            keywords: &[
                "arrautzatik irtetea",
                "arrautzetik irten berri den txita",
                "kumea",
                "txita",
                "txoria",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("جوجه ازتخم\u{200c}بیرون\u{200c}آمده"),
            keywords: &[
                "از تخم بیرون آمدن",
                "تولد",
                "جوجه",
                "جوجه ازتخم\u{200c}بیرون\u{200c}آمده",
                "نوزاد",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kuoriutuva tipu"),
            keywords: &["kananpoika", "kuoriutuva", "lintu", "tipu"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("bagong-pisang sisiw"),
            keywords: &[
                "bagong pisang sisiw",
                "bagong-pisang sisiw",
                "hayop",
                "manok",
                "sisiw",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("høsnarungi í eggjaskali"),
            keywords: &[
                "eggjaskal",
                "høsnarungi",
                "høsnarungi í eggjaskali",
                "klakt",
                "kleking",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("poussin qui éclôt"),
            keywords: &["animal", "oiseau", "poussin", "poussin qui éclôt"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["oiseau", "poussin", "poussin qui éclôt", "éclosion"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("éan ag teacht as an ubh"),
            keywords: &[
                "ag teacht as an ubh",
                "naíonán",
                "éan",
                "éan ag teacht as an ubh",
                "éinín",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("isean ga ghur"),
            keywords: &["eun", "eunlaith", "gur", "isean", "isean ga ghur"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("pitiño saíndo da casca"),
            keywords: &["casca", "ovo", "pitiño", "pitiño saíndo da casca", "pito"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{ac7}વાઈ રહ\u{ac7}લ\u{ac1}\u{a82} બચ\u{acd}ચ\u{ac1}\u{a82}"),
            keywords: &[
                "પક\u{acd}ષીન\u{ac1}\u{a82} બચ\u{acd}ચ\u{ac1}\u{a82}",
                "પ\u{acd}રાણી",
                "બચ\u{acd}ચ\u{ac1}\u{a82}",
                "મરઘીન\u{ac1}\u{a82} બચ\u{acd}ચ\u{ac1}\u{a82}",
                "સ\u{ac7}વવ\u{ac1}\u{a82}",
                "સ\u{ac7}વાઈ રહ\u{ac7}લ\u{ac1}\u{a82} બચ\u{acd}ચ\u{ac1}\u{a82}",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("ɗan tsako mai ƙyanƙyashe"),
            keywords: &[
                "tsako",
                "tsuntsu",
                "ƙyanƙyashe",
                "ɗan",
                "ɗan tsako mai ƙyanƙyashe",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("אפרוח בוקע"),
            keywords: &["אפרוח", "בוקע", "ביצה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("अ\u{902}ड\u{947} स\u{947} बाहर आता च\u{942}जा"),
            keywords: &[
                "अ\u{902}डा फ\u{942}टना",
                "अ\u{902}ड\u{947} स\u{947} बाहर आता च\u{942}जा",
                "चिकन",
                "च\u{942}जा",
                "छोटा च\u{942}जा",
                "पश\u{941}",
                "बच\u{94d}चा",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("pile izleglo iz jajeta"),
            keywords: &["beba", "izlijeganje", "pile", "pile izleglo iz jajeta"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("kikelő kiscsibe"),
            keywords: &["kikelés", "kikelő kiscsibe", "kiscsirke", "madár"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ձվից դուրս եկող ճուտիկ"),
            keywords: &["դեղնակտուց", "ձվից դուրս եկող ճուտիկ", "ճուտ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("itik menetas"),
            keywords: &["ayam", "bayi", "itik menetas", "menetas"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nwa ọkụkụ na-apụta n’àkwa"),
            keywords: &[
                "na-apụta n’àkwa",
                "nnụnụ",
                "nwa",
                "nwa ọkụkụ na-apụta n’àkwa",
                "nwaọkụkọ",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hænuungi í eggi"),
            keywords: &["fuglsungi", "hænuungi í eggi", "kjúklingur", "ungi"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("pulcino che nasce"),
            keywords: &[
                "gallina",
                "pulcino",
                "pulcino che nasce",
                "uovo che si schiude",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("卵からかえったひよこ"),
            keywords: &["ひな", "ひよこ", "動物", "卵からかえったひよこ", "顔", "鳥"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kuthuk netes"),
            keywords: &["bayi", "kuthuk", "netes", "unggas"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("გამოჩეკილი წიწილა"),
            keywords: &[
                "გამოჩეკა",
                "გამოჩეკილი წიწილა",
                "პატარა",
                "ფრინველი",
                "წიწილა",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жұмыртқаны жарып шыққан балапан"),
            keywords: &[
                "балапан",
                "жарып шығу",
                "жұмыртқаны жарып шыққан балапан",
                "шөже",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("ny udklækket kylling"),
            keywords: &["dyr", "kylling", "ny udklækket kylling"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ក\u{17bc}នមាន\u{17cb}ញាស\u{17cb}"),
            keywords: &[
                "ក\u{17bc}ន",
                "ក\u{17bc}នមាន\u{17cb}",
                "ក\u{17bc}នមាន\u{17cb}ញាស\u{17cb}",
                "ញាស\u{17cb}",
                "បក\u{17d2}ស\u{17b8}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮೊಟ\u{ccd}ಟ\u{cc6}ಯ\u{cbf}ಂದ ಹೊರಬರುತ\u{ccd}ತ\u{cbf}ರುವ ಕೋಳ\u{cbf}"),
            keywords: &[
                "ಕೋಳ\u{cbf}ಮರ\u{cbf}",
                "ಮರ\u{cbf}ಮಾಡುವ ಕೋಳ\u{cbf} ಮರ\u{cbf}",
                "ಮೊಟ\u{ccd}ಟ\u{cc6}ಯ\u{cbf}ಂದ ಹೊರಬರುತ\u{ccd}ತ\u{cbf}ರುವ ಕೋಳ\u{cbf}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("알에서 깬 병아리"),
            keywords: &["갓 태어난 병아리", "동물", "알에서 깬 병아리"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ल\u{94d}हान कोमय\u{947}पिला\u{902}"),
            keywords: &[
                "उबोवप",
                "कोमय\u{947}पिल",
                "ल\u{94d}हान कोमय\u{947}पिला\u{902}",
                "शिश\u{942}",
                "स\u{941}कण\u{947}\u{902}",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жумурткадан чыгып жаткан жөжө"),
            keywords: &["бала", "жумурткадан чыгып жаткан жөжө", "жөжө"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Jippelchen am Ee"),
            keywords: &[
                "Bëbee",
                "Hong",
                "Jippelchen",
                "Jippelchen am Ee",
                "Vugel",
                "am Ee",
                "kleng",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລ\u{eb9}ກໄກ\u{ec8}ຈາກໄຂ\u{ec8}"),
            keywords: &[
                "ລ\u{eb9}ກໄກ\u{ec8}",
                "ລ\u{eb9}ກໄກ\u{ec8}ຈາກໄຂ\u{ec8}",
                "ສ\u{eb1}ດ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("išsiritęs viščiukas"),
            keywords: &[
                "išsiridenti",
                "išsiritęs viščiukas",
                "mažas",
                "paukštis",
                "viščiukas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("cālis šķiļas"),
            keywords: &["cālis", "cālis šķiļas", "ola", "putns", "šķilties"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pīpī timotimo"),
            keywords: &["manu", "pī", "pīpī", "pīpī timotimo", "timotimo ana"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("испилено пиле"),
            keywords: &["живина", "испилено", "пиле"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "വിരിഞ\u{d4d}ഞ\u{d41}വര\u{d41}ന\u{d4d}ന കോഴിക\u{d4d}ക\u{d41}ഞ\u{d4d}ഞ\u{d4d}",
            ),
            keywords: &[
                "ക\u{d41}ഞ\u{d4d}ഞ\u{d4d}",
                "കോഴിക\u{d4d}ക\u{d41}ഞ\u{d4d}ഞ\u{d4d}",
                "വിരിഞ\u{d4d}ഞ\u{d41} വര\u{d41}ന\u{d4d}ന മ\u{d41}ട\u{d4d}ട",
                "വിരിഞ\u{d4d}ഞ\u{d41}വര\u{d41}ന\u{d4d}ന കോഴിക\u{d4d}ക\u{d41}ഞ\u{d4d}ഞ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("дэгдээхэй"),
            keywords: &["дэгдээхэй", "хагарах", "өндөг"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("अ\u{902}ड\u{94d}यात\u{942}न बाह\u{947}र पडणार\u{947} पिल\u{94d}ल\u{942}"),
            keywords: &[
                "अ\u{902}ड\u{94d}यात\u{942}न बाह\u{947}र पडणार\u{947} पिल\u{94d}ल\u{942}",
                "अ\u{902}ड\u{94d}यात\u{942}न बाह\u{947}र पडण\u{947}",
                "पक\u{94d}षी",
                "पिल\u{94d}ल\u{942}",
                "बाळ",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("anak ayam menetas"),
            keywords: &["anak ayam", "anak ayam menetas", "bayi", "menetas"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("fellus qed ifaqqas"),
            keywords: &[
                "fellus",
                "fellus qed ifaqqas",
                "għasfur",
                "tfaqqis",
                "żgħir",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပေါက\u{103a}ခါစ ကြက\u{103a}ကလေး"),
            keywords: &[
                "ကြက\u{103a}ပေါက\u{103a}စ",
                "ပေါက\u{103a}ခါစ ကြက\u{103a}ကလေး",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("nyklekket kylling"),
            keywords: &["dyr", "fugl", "klekking", "kylling", "nyklekket kylling"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("कोरलिद\u{948} गर\u{947}को चल\u{94d}ला"),
            keywords: &[
                "कोरलिद\u{948} गर\u{947}को",
                "कोरलिद\u{948} गर\u{947}को चल\u{94d}ला",
                "चल\u{94d}ला",
                "बच\u{94d}चा",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("kuiken uit ei"),
            keywords: &[
                "baby",
                "gevogelte",
                "kuiken",
                "kuiken uit ei",
                "uit ei komen",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("nyklekt kylling"),
            keywords: &["dyr", "fugl", "klekking", "kylling", "nyklekt kylling"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ଅଣ\u{b4d}ଡ\u{b3e} ଫ\u{b41}ଟ\u{b3e}ଉଥ\u{b3f}ବ\u{b3e} କ\u{b41}କ\u{b41}ଡ\u{b3c}\u{b3e} ଛ\u{b41}ଆ",
            ),
            keywords: &[
                "ଅଣ\u{b4d}ଡ\u{b3e} ଫ\u{b41}ଟ\u{b3e}ଉଥ\u{b3f}ବ\u{b3e} କ\u{b41}କ\u{b41}ଡ\u{b3c}\u{b3e} ଛ\u{b41}ଆ",
                "ଅଣ\u{b4d}ଡ\u{b3e}ର\u{b41} ଉଦ\u{b4d}\u{200c}\u{200d}ଗତ ହେବ\u{b3e}",
                "କ\u{b41}କ\u{b41}ଡ\u{b3e} ଛ\u{b41}ଆ",
                "ଛ\u{b41}ଆ",
                "ପକ\u{b4d}ଷୀ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਅ\u{a70}ਡ\u{a47} ਵਿ\u{a71}ਚ\u{a4b}\u{a02} ਨਿਕਲਦਾ ਚ\u{a42}ਚਾ"),
            keywords: &[
                "ਅਾ\u{a02}ਡ\u{a47} ਵਿ\u{a71}ਚ\u{a4b}\u{a02} ਨਿਕਲਦਾ ਚ\u{a42}ਚਾ",
                "ਅਾ\u{a02}ਡ\u{a47} ਵਿ\u{a71}ਚ\u{a4b}\u{a02} ਨਿਕਲਨਾ",
                "ਅ\u{a70}ਡ\u{a47} ਵਿ\u{a71}ਚ\u{a4b}\u{a02} ਨਿਕਲਦਾ ਚ\u{a42}ਚਾ",
                "ਚ\u{a42}ਚਾ",
                "ਜਾਨਵਰ",
                "ਬ\u{a71}ਚਾ",
                "ਮੀਟ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("انڈے چ\u{64f}وں نکلدا چوچا"),
            keywords: &[
                "انڈے چ\u{64f}وں نکلدا چوچا",
                "انڈے چ\u{64f}وں نکلنا",
                "بال",
                "پنچھی",
                "چوچا",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Chíkin Pikin Wé De Kọmọ\u{301}t Frọm Ínsaíd Ẹg"),
            keywords: &[
                "Bébi",
                "Bẹd",
                "Chíkin Pikin",
                "Chíkin Pikin Wé De Kọmọ\u{301}t Frọm Ínsaíd Ẹg",
                "Ẹg Wé Wán Hach",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("wykluwające się kurczątko"),
            keywords: &[
                "kurczaczek",
                "kurczątko",
                "pisklak",
                "wykluwające się kurczątko",
                "wykluwać się",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("چرګوړی راوتل"),
            keywords: &["چرګوړی راوتل", "کوچنی، مرغۍ، چرګوړی، راوتل"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("pintinho chocando"),
            keywords: &["ave", "chocando", "filhote", "galinha", "pintinho", "pinto"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("pintainho a sair do ovo"),
            keywords: &["bebé", "ovo", "pintainho", "pintainho a sair do ovo"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("pollo pʼakisqa runtuwan"),
            keywords: &[
                "huchuy",
                "pollo",
                "pollo pʼakisqa runtuwan",
                "p’akisqa",
                "p’isqu",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("pui în găoace"),
            keywords: &["eclozare", "ou", "pui", "pui în găoace", "puișor"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-480"),
            keywords: &["E10-480"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("цыпленок в яйце"),
            keywords: &["вылупился", "желтый", "цыпленок", "цыпленок в яйце", "яйцо"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umushwi uri guturagwa"),
            keywords: &[
                "inyoni",
                "kurarira",
                "umushwi",
                "umushwi uri guturagwa",
                "umwana",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("بيضي مان نڪرندڙ چوزو"),
            keywords: &["بيضي مان نڪرندڙ چوزو", "ننڍو، مرغي جو ٻچو، نڪرڻ، پکي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some(
                "බ\u{dd2}ත\u{dca}තරයෙන\u{dca} එළ\u{dd2}යට එන ක\u{dd4}ක\u{dd4}ළ\u{dd4} පැට\u{dd2}ය\u{dcf}",
            ),
            keywords: &[
                "ක\u{dd4}ක\u{dd4}ළ\u{dd4} පැට\u{dd2}ය\u{dcf}",
                "පැට\u{dd2}ය\u{dcf}",
                "බ\u{dd2}ත\u{dca}තරයෙන\u{dca} එළ\u{dd2}යට එන ක\u{dd4}ක\u{dd4}ළ\u{dd4} පැට\u{dd2}ය\u{dcf}",
                "බ\u{dd2}ත\u{dca}තරයෙන\u{dca} එළ\u{dd2}යට ඒම",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("liahnuce sa kurča"),
            keywords: &["kuriatko", "liahnuce sa kurča", "liahnuť sa"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("pišče, ki se izvali"),
            keywords: &["mladič", "piščanček", "pišče, ki se izvali", "valjenje"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("jiiw dhalanay"),
            keywords: &[
                "cunug",
                "jiiw",
                "jiiw dhalanay",
                "jiiw dhalanaya",
                "shimbir",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("zog në çelje"),
            keywords: &["pulë", "zog", "zog në çelje", "çel", "çelje"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("пиле у јајету"),
            keywords: &["беба", "излегање", "пиле", "пиле у јајету", "птица"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("pile u jajetu"),
            keywords: &["beba", "izleganje", "pile", "pile u jajetu", "ptica"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("nykläckt kyckling"),
            keywords: &["fågel", "kläckt", "kyckling", "nykläckt kyckling"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kifaranga kinachoanguliwa"),
            keywords: &[
                "kifaranga",
                "kifaranga kinachoanguliwa",
                "kuanguliwa",
                "mtoto",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("முட\u{bcd}டையிலிருந\u{bcd}து வெளிவரும\u{bcd} குஞ\u{bcd}சு"),
            keywords: &[
                "குஞ\u{bcd}சு",
                "குஞ\u{bcd}சு பொறித\u{bcd}தல\u{bcd}",
                "கோழிக\u{bcd}குஞ\u{bcd}சு",
                "பறவை",
                "முட\u{bcd}டையிலிருந\u{bcd}து வெளிவரும\u{bcd} குஞ\u{bcd}சு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "గుడ\u{c4d}డు నుండ\u{c3f} ప\u{c4a}దగబడ\u{c3f}న క\u{c4b}డ\u{c3f}ప\u{c3f}ల\u{c4d}ల",
            ),
            keywords: &[
                "క\u{c4b}డ\u{c3f}ప\u{c3f}ల\u{c4d}ల",
                "గుడ\u{c4d}డు",
                "గుడ\u{c4d}డు నుండ\u{c3f} ప\u{c4a}దగబడ\u{c3f}న క\u{c4b}డ\u{c3f}ప\u{c3f}ల\u{c4d}ల",
                "ప\u{c4a}దగడం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("чӯҷаи аз тухм баромада истода"),
            keywords: &[
                "аз тухм баромадан",
                "кӯдак",
                "парранда",
                "чӯҷа",
                "чӯҷаи аз тухм баромада истода",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ล\u{e39}กเจ\u{e35}\u{e4a}ยบออกจากไข\u{e48}"),
            keywords: &[
                "ล\u{e39}กเจ\u{e35}\u{e4a}ยบ",
                "ล\u{e39}กเจ\u{e35}\u{e4a}ยบออกจากไข\u{e48}",
                "ส\u{e31}ตว\u{e4c}",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýumurtgadan çykýan jüýje"),
            keywords: &[
                "bäbek",
                "guş",
                "jüýje",
                "ýumurtgadan çykmak",
                "ýumurtgadan çykýan jüýje",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fōfoaʻimoa"),
            keywords: &["fōfoaʻimoa"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yumurtadan çıkan civciv"),
            keywords: &[
                "civciv",
                "hayvan",
                "kuluçka",
                "piliç",
                "tavuk",
                "yavru",
                "yumurtadan çıkan civciv",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("تۇخۇمدىن چىققان چۆجە"),
            keywords: &[
                "بالا",
                "توخۇ",
                "تۇخۇمدىن چىققان چۆجە",
                "تۇخۇمدىن چىقىش",
                "قۇش",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("курча, що вилуплюється"),
            keywords: &[
                "вилуплюватися",
                "курча",
                "курча, що вилуплюється",
                "прокльовуватися",
                "птах",
                "пташка",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("انڈے سے نکلتا چوزہ"),
            keywords: &["انڈے سے نکلتا چوزہ", "بچہ", "جانور", "چوزہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("tuxumdan chiqayotgan jo‘ja"),
            keywords: &[
                "chaqaloq",
                "joʻja",
                "parranda",
                "tuxumdan chiqayotgan jo‘ja",
                "tuxumdan yorib chiqish",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("gà mới nở"),
            keywords: &["gà", "gà con", "gà mới nở", "ấp"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("cuuj bu génn ci nen"),
            keywords: &[
                "cuuj",
                "cuuj bu génn ci nen",
                "génn ci nenn",
                "liir",
                "picc",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("intshontsho eliqanduselayo"),
            keywords: &["eliqanduselayo", "intaka", "intshontsho"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ọmọ Adiyẹ Pipa"),
            keywords: &["pípa", "ìkókó", "ẹyẹ", "Ọmọ Adiyẹ Pipa", "ọmọ adìyẹ"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("孵出小雞"),
            keywords: &["嬰兒", "孵出小雞", "孵化", "小雞", "雀"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("孵出小鸡"),
            keywords: &["婴儿", "孵出小鸡", "孵化", "小鸡", "雀"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("小鸡破壳"),
            keywords: &["小鸡", "小鸡破壳", "破壳"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("小雞破蛋"),
            keywords: &["孵化", "小雞破蛋"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("孵化雞仔"),
            keywords: &["孵化", "孵化雞仔"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ichwane eliphuma eqandeni"),
            keywords: &[
                "ichwane",
                "ichwane eliphuma eqandeni",
                "ingane",
                "ukuqhekeka kweqanda",
            ],
        },
    ],
};
#[doc = "🐤"]
pub const BABY_CHICK: crate::Emoji = crate::Emoji {
    glyph: "🐤",
    codepoint: "1F424",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "baby chick",
    group: "Animals & Nature",
    subgroup: "animal-bird",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("babakuiken"),
            keywords: &["baba", "babakuiken", "kuiken", "voël"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሚጢጢ ጫጩት"),
            keywords: &["ሕፃን", "ሚጢጢ ጫጩት", "ጫጩት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("كتكوت صغير"),
            keywords: &["طائر", "كتكوت", "كتكوت صغير"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ম\u{9c2}ৰ\u{9cd}গী পোৱ\u{9be}লী"),
            keywords: &[
                "পক\u{9cd}ষী",
                "পোৱ\u{9be}লী",
                "পোৱ\u{9be}লী ম\u{9c2}ৰ\u{9cd}গী",
                "ম\u{9c2}ৰ\u{9cd}গী পোৱ\u{9be}লী",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("körpə cücə"),
            keywords: &["cücə", "körpə", "quş"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("кураня"),
            keywords: &["дзіцяня", "кураня"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("пиленце"),
            keywords: &["малко пиленце", "пиленце"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("বেবি চিক"),
            keywords: &[
                "ব\u{9be}চ\u{9cd}চ\u{9be}",
                "ব\u{9be}চ\u{9cd}চ\u{9be} ম\u{9c1}রগি",
                "বেবি চিক",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("poñsin"),
            keywords: &["evn", "poñsin"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("pile"),
            keywords: &["beba", "pile", "ptica"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("pollet de perfil"),
            keywords: &["au", "bebè", "petit", "pollet", "pollet de perfil"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄌\u{11128}𑄉\u{1112e}𑄚\u{11134} 𑄛\u{1112a}𑄢\u{1112f} 𑄌\u{11127}"),
            keywords: &["𑄌\u{11128}𑄉\u{1112e}𑄚\u{11134} 𑄛\u{1112a}𑄢\u{1112f} 𑄌\u{11127}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏍᏗ ᏣᏔᎩ"),
            keywords: &["ᎤᏍᏗ", "ᎤᏍᏗ ᏣᏔᎦ", "ᎤᏍᏗ ᏣᏔᎩ", "ᏥᏍᏆ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("kuřátko"),
            keywords: &["kuře", "kuřátko", "pták", "ptáček"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cyw bach"),
            keywords: &["babi", "cyw", "cyw bach"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kylling"),
            keywords: &["dyr", "kylling"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Küken"),
            keywords: &["Küken", "Tier"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κοτοπουλάκι"),
            keywords: &["κοτοπουλάκι", "μωρό", "πτηνό"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("baby chick"),
            keywords: &["baby", "bird", "chick"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("pollito"),
            keywords: &["animal", "ave", "pollito", "pollo", "polluelo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("cara de pollito"),
            keywords: &[
                "animal",
                "ave",
                "cara de pollito",
                "pollito",
                "pollo",
                "polluelo",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("pollito"),
            keywords: &["ave", "bebé", "pollito"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("väike tibu"),
            keywords: &["tibu", "väike tibu"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("txita"),
            keywords: &["kumea", "txita", "txoria"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("جوجه"),
            keywords: &["جوجه", "نوزاد"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("tipu"),
            keywords: &["kananpoika", "lintu", "tipu"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("sisiw"),
            keywords: &["hayop", "manok", "sisiw"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("høsnarungaandlit"),
            keywords: &["andlit", "høsnarungaandlit", "høsnarungi"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("poussin"),
            keywords: &["animal", "oiseau", "poussin"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["oiseau", "poussin"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("gearrshicín"),
            keywords: &["gearrshicín", "sicín", "éan", "éinín"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("isean beag"),
            keywords: &["eun", "eunlaith", "isean", "isean beag"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("pitiño"),
            keywords: &["pitiño", "pito"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("મરઘીન\u{ac1}\u{a82} બચ\u{acd}ચ\u{ac1}\u{a82}"),
            keywords: &[
                "પક\u{acd}ષીન\u{ac1}\u{a82} બચ\u{acd}ચ\u{ac1}\u{a82}",
                "પ\u{acd}રાણી",
                "બચ\u{acd}ચ\u{ac1}\u{a82}",
                "મરઘીન\u{ac1}\u{a82} બચ\u{acd}ચ\u{ac1}\u{a82}",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("ƙaramin ɗan tsako"),
            keywords: &["tsako", "tsuntsu", "ƙaramin ɗan tsako", "ɗan"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("אפרוח"),
            keywords: &["אפרוח", "גוזל", "ציפור"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("म\u{941}र\u{94d}गी का बच\u{94d}चा"),
            keywords: &[
                "चिकन",
                "च\u{942}जा",
                "पश\u{941}",
                "म\u{941}र\u{94d}गी का बच\u{94d}चा",
                "शिश\u{941}",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("pile"),
            keywords: &["beba", "pile"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("naposcsibe"),
            keywords: &["kiscsibe", "madár", "naposcsibe"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ճուտիկ"),
            keywords: &["ձագ", "ճուտ", "ճուտիկ", "փոքր"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("itik bayi"),
            keywords: &["ayam", "bayi", "itik bayi"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nwa ọkụkọ"),
            keywords: &["nnụnụ", "nwa", "nwa ọkụkọ", "nwaọkụkọ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hænuungi"),
            keywords: &["fuglsungi", "hænuungi", "kjúklingur", "ungi"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("pulcino"),
            keywords: &["animale", "cucciolo", "gallina", "pulcino"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ひよこ"),
            keywords: &["ひな", "ひよこ", "動物", "横を向いているひよこ", "顔", "鳥"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kuthuk"),
            keywords: &["bayi", "kuthuk", "unggas"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("პატარა წიწილა"),
            keywords: &["პატარა", "წიწილა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("балапан"),
            keywords: &["балапан", "шөже"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("kylling"),
            keywords: &["dyr", "kylling"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ក\u{17bc}នមាន\u{17cb}ត\u{17bc}ច"),
            keywords: &[
                "ក\u{17bc}ន",
                "ក\u{17bc}នមាន\u{17cb}",
                "ក\u{17bc}នមាន\u{17cb}ត\u{17bc}ច",
                "បក\u{17d2}ស\u{17b8}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕೋಳ\u{cbf} ಮರ\u{cbf}"),
            keywords: &[
                "ಕೋಳ\u{cbf} ಮರ\u{cbf}",
                "ಕೋಳ\u{cbf}ಮರ\u{cbf}",
                "ಚ\u{cbf}ಕ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("병아리"),
            keywords: &["동물", "병아리", "아기 병아리"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("कोमय\u{947} पिल"),
            keywords: &["कोमय\u{947} पिल", "शिश\u{942}", "स\u{941}कण\u{947}\u{902}"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жөжө"),
            keywords: &["бала", "жөжө"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Jippelchen"),
            keywords: &["Bëbee", "Hong", "Jippelchen", "Vugel"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໄກ\u{ec8}ນ\u{ec9}ອຍ"),
            keywords: &["ລ\u{eb9}ກໄກ\u{ec8}", "ສ\u{eb1}ດ", "ໄກ\u{ec8}ນ\u{ec9}ອຍ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("viščiukas"),
            keywords: &["mažas", "viščiukas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("cālis"),
            keywords: &["cālis", "galva", "putns"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pīpī manu"),
            keywords: &["manu", "pī", "pīpī"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("пиле"),
            keywords: &["живина", "пиле"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കോഴിക\u{d4d}ക\u{d41}ഞ\u{d4d}ഞ\u{d4d}"),
            keywords: &[
                "ക\u{d41}ഞ\u{d4d}ഞ\u{d4d}",
                "കോഴിക\u{d4d}ക\u{d41}ഞ\u{d4d}ഞ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("ангаахай"),
            keywords: &["ангаахай", "шувуу"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("को\u{902}बडीच\u{947} पिल\u{94d}ल\u{942}"),
            keywords: &[
                "को\u{902}बडीच\u{947} पिल\u{94d}ल\u{942}",
                "पक\u{94d}षी",
                "पिल\u{94d}ल\u{942}",
                "बाळ",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("anak ayam"),
            keywords: &["anak ayam", "bayi"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("fellus żgħir"),
            keywords: &["fellus", "għasfur", "żgħir"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ကြက\u{103a}ပေါက\u{103a}စကလေး"),
            keywords: &[
                "ကြက\u{103a}ကလေး",
                "ကြက\u{103a}ပေါက\u{103a}စ",
                "ကြက\u{103a}ပေါက\u{103a}စကလေး",
                "ပေါက\u{103a}စ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kylling"),
            keywords: &["baby", "dyr", "fugl", "kylling"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("क\u{941}ख\u{941}राको चल\u{94d}ला"),
            keywords: &[
                "क\u{941}ख\u{941}राको चल\u{94d}ला",
                "चल\u{94d}ला",
                "बच\u{94d}चा",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("kuikentje"),
            keywords: &["baby", "gevogelte", "kuiken", "kuikentje"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kylling"),
            keywords: &["baby", "dyr", "fugl", "kylling"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଛୋଟ ଶ\u{b3f}ଶ\u{b41} କ\u{b41}କ\u{b41}ଡ\u{b3c}\u{b3e}"),
            keywords: &[
                "ଛୋଟ କ\u{b41}କ\u{b41}ଡ\u{b3c}\u{b3e} ଛ\u{b41}ଆ",
                "ଛୋଟ ଶ\u{b3f}ଶ\u{b41} କ\u{b41}କ\u{b41}ଡ\u{b3c}\u{b3e}",
                "ପକ\u{b4d}ଷୀ",
                "ଶ\u{b3f}ଶ\u{b41}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕ\u{a41}\u{a71}ਕੜੀ ਦਾ ਬ\u{a71}ਚਾ"),
            keywords: &[
                "ਕ\u{a41}\u{a71}ਕੜੀ ਦਾ ਬ\u{a71}ਚਾ",
                "ਚ\u{a42}ਚਾ",
                "ਜਾਨਵਰ",
                "ਬ\u{a71}ਚਾ",
                "ਮੀਟ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("چھوٹا چوچا"),
            keywords: &["بال", "پنچھی", "چوچا", "چھوٹا چوچا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Chíkin Pikin"),
            keywords: &["Bẹd", "Chíkin Pikin", "Smọ\u{301}l Pikin"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kurczątko"),
            keywords: &["kurczaczek", "kurczątko", "pisklak"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("چرګوری"),
            keywords: &["چرګوری", "کوچنی، مرغۍ، چرګوړی"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("pintinho de perfil"),
            keywords: &[
                "ave",
                "filhote",
                "galinha",
                "pintinho",
                "pintinho de perfil",
                "pinto",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("pintainho"),
            keywords: &["bebé", "pintainho"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("huchuy pollo"),
            keywords: &["huchuy", "pollo", "p’isqu"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("pui de găină"),
            keywords: &["pasăre", "pui", "pui de găină"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-481"),
            keywords: &["E10-481"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("цыпленок боком"),
            keywords: &["голова", "маленький", "цыпленок", "цыпленок боком"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umushwi"),
            keywords: &["agashwi", "inyoni", "umushwi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ننڍو مرغي جو ٻچو"),
            keywords: &["ننڍو", "ننڍو مرغي جو ٻچو", "پکي", "چوزو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ළදර\u{dd4} ක\u{dd4}ක\u{dd4}ළ\u{dd4} පැට\u{dd2}ය\u{dcf}"),
            keywords: &[
                "ක\u{dd4}ර\u{dd4}ල\u{dca}ල\u{dcf}",
                "පැට\u{dd2}ය\u{dcf}",
                "බබ\u{dcf}",
                "ළදර\u{dd4} ක\u{dd4}ක\u{dd4}ළ\u{dd4} පැට\u{dd2}ය\u{dcf}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("kurča"),
            keywords: &["kuriatko", "kurča"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("piščanček"),
            keywords: &["mladič", "piščanček", "valjenje"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("cunug diggaag"),
            keywords: &["cunug", "cunug diggaag", "jiiw", "shimbir"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("zog pule"),
            keywords: &["bebe", "zog", "zog pule"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("пиле"),
            keywords: &["бeбa", "пилe", "пиле", "птица"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("pile"),
            keywords: &["beba", "pile", "ptica"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("kyckling"),
            keywords: &["djur", "kyckling"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kifaranga"),
            keywords: &["kifaranga", "mtoto"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கோழி குஞ\u{bcd}சு"),
            keywords: &[
                "கோழி குஞ\u{bcd}சு",
                "கோழிக\u{bcd}குஞ\u{bcd}சு",
                "சிக\u{bcd}கன\u{bcd}",
                "விலங\u{bcd}கினம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("క\u{c4b}డ\u{c3f}ప\u{c3f}ల\u{c4d}ల"),
            keywords: &[
                "క\u{c4b}డ\u{c3f} ప\u{c3f}ల\u{c4d}ల",
                "క\u{c4b}డ\u{c3f}ప\u{c3f}ల\u{c4d}ల",
                "జంతువు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("чӯҷаи хурд"),
            keywords: &["кӯдак", "парранда", "чӯҷа", "чӯҷаи хурд"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ล\u{e39}กเจ\u{e35}\u{e4a}ยบ"),
            keywords: &["ล\u{e39}กเจ\u{e35}\u{e4a}ยบ", "ส\u{e31}ตว\u{e4c}ป\u{e35}ก"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("jüýjejik"),
            keywords: &["bäbek", "guş", "jüýje", "jüýjejik"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ʻuhikiʻimoa"),
            keywords: &["ʻuhikiʻimoa"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("civciv"),
            keywords: &["civciv", "hayvan", "piliç", "tavuk", "yavru"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("چۆجە"),
            keywords: &["بوۋاق", "توخۇ", "قۇش", "چۆجە"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("мале курча"),
            keywords: &["курка", "курча", "курчатко", "мале курча"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بیبی چوزہ"),
            keywords: &["بیبی", "پرندہ", "چوزہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("jo‘ja"),
            keywords: &["chaqaloq", "joʻja", "jo‘ja", "parranda"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("gà con"),
            keywords: &["chim", "gà", "gà con"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("cuuj"),
            keywords: &["cuuj", "liir", "picc"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("intshontsho"),
            keywords: &["intaka", "intshontsho", "usana"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ọmọ Adiyẹ"),
            keywords: &["ìkókó", "ẹyẹ", "Ọmọ Adiyẹ", "ọmọ adìyẹ"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("雞仔"),
            keywords: &["嬰兒", "小雞", "雀", "雞仔"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("鸡仔"),
            keywords: &["婴儿", "小鸡", "雀", "鸡仔"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("小鸡"),
            keywords: &["小鸡", "鸡"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("小雞的臉"),
            keywords: &["小雞", "小雞的臉"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("小雞樣"),
            keywords: &["小雞", "小雞樣"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ichwane elincane"),
            keywords: &["ichwane", "ichwane elincane", "ingane"],
        },
    ],
};
#[doc = "🐥"]
pub const FRONT_FACING_BABY_CHICK: crate::Emoji = crate::Emoji {
    glyph: "🐥",
    codepoint: "1F425",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "front-facing baby chick",
    group: "Animals & Nature",
    subgroup: "animal-bird",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("kuiken wat vorentoe kyk"),
            keywords: &["baba", "kuiken", "kuiken wat vorentoe kyk", "voël"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ፊት ለፊት የምትታይ ሚጢጢ ጫጩት"),
            keywords: &["ሕፃን", "ጫጩት", "ፊት ለፊት የምትታይ ሚጢጢ ጫጩት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}كتكوت صغير بوجه للأمام"),
            keywords: &["طائر", "\u{202b}كتكوت صغير بوجه للأمام"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some(
                "সন\u{9cd}ম\u{9c1}খৰ ফ\u{9be}লে ম\u{9c1}খ কৰি থক\u{9be} ম\u{9c2}ৰ\u{9cd}গী পোৱ\u{9be}লী",
            ),
            keywords: &[
                "পক\u{9cd}ষী",
                "পোৱ\u{9be}লী",
                "ম\u{9c2}ৰ\u{9cd}গী",
                "সন\u{9cd}ম\u{9c1}খৰ ফ\u{9be}লে ম\u{9c1}খ কৰি থক\u{9be} ম\u{9c2}ৰ\u{9cd}গী পোৱ\u{9be}লী",
                "সন\u{9cd}ম\u{9c1}খৰ ফ\u{9be}লে ম\u{9c1}খ কৰি থল\u{9be} ম\u{9c2}ৰ\u{9cd}গীৰ পোৱ\u{9be}লী",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qabağa baxan balaca cücə"),
            keywords: &["cücə", "körpə", "qabağa baxan balaca cücə", "quş"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("кураня спераду"),
            keywords: &["дзіцяня", "кураня", "кураня спераду"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Пиленце, гледано отпред"),
            keywords: &["Пиленце, гледано отпред", "пиленце"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("স\u{9be}মনের দিকে ম\u{9c1}খ কর\u{9be} বেবি চিক"),
            keywords: &[
                "ব\u{9be}চ\u{9cd}চ\u{9be}",
                "ব\u{9be}চ\u{9cd}চ\u{9be} ম\u{9c1}রগি",
                "স\u{9be}মনের দিকে ম\u{9c1}খ কর\u{9be} বেবি চিক",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("portet pileta"),
            keywords: &["beba", "pile", "portet pileta"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("pollet de cara"),
            keywords: &["au", "bebè", "petit", "pollet", "pollet de cara"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some(
                "𑄟\u{1112a}𑄎\u{1112a}\u{11101}𑄠𑄬 𑄟\u{11131} 𑄌\u{11128}𑄉\u{1112e}𑄚\u{11134} 𑄛\u{1112a}𑄢\u{1112f} 𑄌\u{11127}",
            ),
            keywords: &[
                "𑄟\u{1112a}𑄎\u{1112a}\u{11101}𑄠𑄬 𑄟\u{11131} 𑄌\u{11128}𑄉\u{1112e}𑄚\u{11134} 𑄛\u{1112a}𑄢\u{1112f} 𑄌\u{11127}",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎢᎬᏱ-ᏗᏜ ᎤᏍᏗ ᏥᏔᎦ"),
            keywords: &["ᎢᎬᏱ-ᏗᏜ ᎤᏍᏗ ᏥᏔᎦ", "ᎤᏍᏗ", "ᎤᏍᏗ ᏣᏔᎦ", "ᏥᏍᏆ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("kuřátko zepředu"),
            keywords: &["kuře", "kuřátko", "kuřátko zepředu", "pták", "ptáček"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cyw iâr yn blaen-wynebu"),
            keywords: &["babi", "cyw", "cyw iâr yn blaen-wynebu"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kylling forfra"),
            keywords: &["dyr", "kylling forfra", "kylling set forfra"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Küken von vorne"),
            keywords: &["Geflügel", "Küken", "Küken von vorne", "Tier"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κοτοπουλάκι που κοιτά μπροστά"),
            keywords: &["κοτοπουλάκι που κοιτά μπροστά", "μωρό", "πουλάκι", "πτηνό"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("front-facing baby chick"),
            keywords: &["baby", "bird", "chick", "front-facing baby chick"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("pollito de frente"),
            keywords: &["animal", "ave", "pollito", "pollito de frente", "pollo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("väike tibu eestvaates"),
            keywords: &["tibu", "väike tibu eestvaates"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("aurrera begira dagoen txita"),
            keywords: &["aurrera begira dagoen txita", "kume", "txita"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("جوجه از روبرو"),
            keywords: &["جوجه", "جوجه از روبرو", "نوزاد"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("tipu edestäpäin"),
            keywords: &["kananpoika", "lintu", "tipu", "tipu edestäpäin"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("nakaharap na sisiw"),
            keywords: &["hayop", "manok", "nakaharap na sisiw", "sisiw"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("høsnarungi"),
            keywords: &["dýr", "fuglur", "høsnarungi"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("poussin de face"),
            keywords: &["animal", "oiseau", "poussin de face"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["oiseau", "poussin de face"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("gearrshicín éadain"),
            keywords: &["gearrshicín éadain", "sicín", "éan", "éinín"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("isean le aghaidh riut"),
            keywords: &["eun", "eunlaith", "isean", "isean le aghaidh riut"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("pitiño de fronte"),
            keywords: &["pitiño", "pitiño de fronte", "pito"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some(
                "સામ\u{ac7} જોત\u{ac1}\u{a82} પક\u{acd}ષીન\u{ac1}\u{a82} બચ\u{acd}ચ\u{ac1}\u{a82}",
            ),
            keywords: &[
                "આગળ તરફ જોત\u{ac1}\u{a82} પક\u{acd}ષીન\u{ac1}\u{a82} બચ\u{acd}ચ\u{ac1}\u{a82}",
                "પક\u{acd}ષીન\u{ac1}\u{a82} બચ\u{acd}ચ\u{ac1}\u{a82}",
                "પ\u{acd}રાણી",
                "બચ\u{acd}ચ\u{ac1}\u{a82}",
                "મરઘીન\u{ac1}\u{a82} બચ\u{acd}ચ\u{ac1}\u{a82}",
                "સામ\u{ac7} જોત\u{ac1}\u{a82} પક\u{acd}ષીન\u{ac1}\u{a82} બચ\u{acd}ચ\u{ac1}\u{a82}",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("ƙaramin ɗan tsako mai dubawa-gaba"),
            keywords: &[
                "tsako",
                "tsuntsu",
                "ƙaramin ɗan tsako mai dubawa-gaba",
                "ɗan",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("אפרוח מלפנים"),
            keywords: &["אפרוח", "אפרוח מלפנים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("आग\u{947} म\u{941}\u{901}ह वाला च\u{942}जा"),
            keywords: &[
                "आग\u{947} म\u{941}\u{901}ह वाला च\u{942}जा",
                "चिड\u{93c}िया",
                "च\u{942}ज\u{93c}ा",
                "च\u{942}जा",
                "पक\u{94d}षी",
                "म\u{941}र\u{94d}गी का बच\u{94d}चा",
                "शिश\u{941}",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("pile sprijeda"),
            keywords: &["beba", "pile", "pile sprijeda"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("előre néző kiscsibe"),
            keywords: &["előre néző kiscsibe", "kiscsibe", "madár"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("դեմքով շրջված ճուտիկ"),
            keywords: &["դեմքով շրջված ճուտիկ", "ծիտիկ", "ձագուկ", "ճուտ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("itik bayi menghadap ke depan"),
            keywords: &["ayam", "bayi", "itik bayi menghadap ke depan"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("chewe ihu na nwa ọkụkọ"),
            keywords: &["chewe ihu na nwa ọkụkọ", "nnụnụ", "nwa", "nwaọkụkọ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("framhlið hænuunga"),
            keywords: &["framhlið hænuunga", "fuglsungi", "kjúklingur", "ungi"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("pulcino visto di fronte"),
            keywords: &[
                "animale",
                "cucciolo",
                "gallina",
                "pulcino",
                "pulcino visto di fronte",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("前を向いているひよこ"),
            keywords: &["ひな", "ひよこ", "前を向いているひよこ", "動物", "鳥"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kuthuk madhep ngarep"),
            keywords: &["bayi", "kuthuk", "kuthuk madhep ngarep", "unggas"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("პატარა წიწილა წინიდან"),
            keywords: &["პატარა", "პატარა წიწილა წინიდან", "წიწილა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("алға қарап тұрған балапан"),
            keywords: &["алға қарап тұрған балапан", "балапан", "шөже"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("kylling forfra"),
            keywords: &["dyr", "kylling forfra", "kylling set forfra"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ក\u{17bc}នមាន\u{17cb}"),
            keywords: &[
                "ក\u{17bc}ន",
                "ក\u{17bc}នមាន\u{17cb}",
                "ក\u{17bc}នមាន\u{17cb}ត\u{17bc}ច",
                "បក\u{17d2}ស\u{17b8}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಎದುರುಮುಖವಾಗ\u{cbf}ರುವ ಮರ\u{cbf} ಕೋಳ\u{cbf}"),
            keywords: &[
                "ಎದುರುಮುಖವಾಗ\u{cbf}ರುವ ಮರ\u{cbf} ಕೋಳ\u{cbf}",
                "ಕೋಳ\u{cbf}ಮರ\u{cbf}",
                "ಚ\u{cbf}ಕನ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("정면을 향해 날개를 편 병아리"),
            keywords: &["동물", "아기 병아리", "정면을 향해 날개를 편 병아리"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("म\u{941}खार पळोवपी कोमय\u{947} पिल"),
            keywords: &[
                "कोमय\u{947}पिल",
                "म\u{941}खार पळोवपी कोमय\u{947} पिल",
                "शिश\u{942}",
                "स\u{941}कण\u{947}\u{902}",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("бери карап турган жөжө"),
            keywords: &["бала", "бери карап турган жөжө", "жөжө"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Jippelche vu vir"),
            keywords: &["Bëbee", "Hong", "Jippelche vu vir", "Jippelchen", "Vugel"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໄກ\u{ec8}ນ\u{ec9}ອຍຢ\u{eb7}ນ"),
            keywords: &[
                "ລ\u{eb9}ກໄກ\u{ec8}",
                "ສ\u{eb1}ດ",
                "ໄກ\u{ec8}ນ\u{ec9}ອຍຢ\u{eb7}ນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("atsisukęs snapu viščiukas"),
            keywords: &[
                "atsisukęs snapu viščiukas",
                "mažas",
                "paukštis",
                "viščiukas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("cālis no priekšpuses"),
            keywords: &["cālis", "cālis no priekšpuses", "putns"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pīpī manu anga mua"),
            keywords: &["manu", "pī", "pīpī", "pīpī manu anga mua"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("пиле свртено нанапред"),
            keywords: &["живина", "пиле", "пиле свртено нанапред"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കോഴിക\u{d4d}ക\u{d41}ഞ\u{d4d}ഞിന\u{d4d}റെ മ\u{d41}ഖം"),
            keywords: &[
                "ക\u{d41}ഞ\u{d4d}ഞ\u{d4d}",
                "കോഴിക\u{d4d}ക\u{d41}ഞ\u{d4d}ഞിന\u{d4d}റെ മ\u{d41}ഖം",
                "കോഴിക\u{d4d}ക\u{d41}ഞ\u{d4d}ഞ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("дэгдээхэй урд талаасаа"),
            keywords: &[
                "дэгдээхэй",
                "дэгдээхэй урд талаасаа",
                "тал",
                "урд",
                "өхөөрдөм",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some(
                "च\u{947}हरा समोर असल\u{947}ल\u{947} को\u{902}बडीच\u{947} पिल\u{94d}ल\u{942}",
            ),
            keywords: &[
                "च\u{947}हरा समोर असल\u{947}ल\u{947} को\u{902}बडीच\u{947} पिल\u{94d}ल\u{942}",
                "पक\u{94d}षी",
                "पिल\u{94d}ल\u{942}",
                "बाळ",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("anak ayam menghadap depan"),
            keywords: &["anak ayam", "anak ayam menghadap depan", "bayi"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("fellus żgħir iħares ’il quddiem"),
            keywords: &[
                "fellus",
                "fellus żgħir iħares ’il quddiem",
                "għasfur",
                "żgħir",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "ရ\u{103e}ေ\u{1037}သ\u{102d}\u{102f}\u{1037}မျက\u{103a}န\u{103e}ာမ\u{1030}ထားသည\u{1037}\u{103a} ကြက\u{103a}ပေါက\u{103a}စ",
            ),
            keywords: &[
                "ကြက\u{103a}ကလေး",
                "ကြက\u{103a}ပေါက\u{103a}စ",
                "ရ\u{103e}ေ\u{1037}သ\u{102d}\u{102f}\u{1037}မျက\u{103a}န\u{103e}ာမ\u{1030}ထားသည\u{1037}\u{103a} ကြက\u{103a}ပေါက\u{103a}စ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kylling forfra"),
            keywords: &["baby", "dyr", "fugl", "kylling", "kylling forfra"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("अगाडि-अन\u{941}हार द\u{947}खिएको क\u{941}ख\u{941}राको चल\u{94d}ला"),
            keywords: &[
                "अगाडि-अन\u{941}हार द\u{947}खिएको क\u{941}ख\u{941}राको चल\u{94d}ला",
                "चल\u{94d}ला",
                "बच\u{94d}चा",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("naar voren kijkend kuikentje"),
            keywords: &[
                "baby",
                "gevogelte",
                "kuiken",
                "naar voren kijkend kuikentje",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kylling framanfrå"),
            keywords: &["baby", "dyr", "fugl", "kylling", "kylling framanfrå"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ଆଗକ\u{b41}-ମ\u{b41}ହ\u{b01} କର\u{b3f}ଥ\u{b3f}ବ\u{b3e} କ\u{b41}କ\u{b41}ଡ\u{b3c}\u{b3e} ଛ\u{b41}ଆ",
            ),
            keywords: &[
                "ଆଗକ\u{b41}-ମ\u{b41}ହ\u{b01} କର\u{b3f}ଥ\u{b3f}ବ\u{b3e} କ\u{b41}କ\u{b41}ଡ\u{b3c}\u{b3e} ଛ\u{b41}ଆ",
                "କ\u{b41}କ\u{b41}ଡ\u{b3c}\u{b3e}",
                "କ\u{b41}କ\u{b41}ଡ\u{b3c}\u{b3e} ଛ\u{b41}ଆ",
                "ଛୋଟ କ\u{b41}କ\u{b41}ଡ\u{b3c}\u{b3e} ଛ\u{b41}ଆ",
                "ଜୀବ",
                "ମ\u{b41}ହ\u{b01} ବ\u{b3e}ହ\u{b3e}ରକ\u{b41} ବ\u{b3e}ହର କର\u{b3f}ଥ\u{b3f}ବ\u{b3e} ଛୋଟ କ\u{b41}କ\u{b41}ଡ\u{b3c}\u{b3e} ଛ\u{b41}ଆ",
                "ଶ\u{b3f}ଶ\u{b41}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਤ\u{a41}ਹਾਡ\u{a47} ਵ\u{a71}ਲ ਵ\u{a47}ਖਦਾ ਚ\u{a42}ਚਾ"),
            keywords: &[
                "ਚ\u{a42}ਚਾ",
                "ਜਾਨਵਰ",
                "ਤ\u{a41}ਹਾਡ\u{a47} ਵ\u{a71}ਲ ਦ\u{a47}ਖਦਾ ਚ\u{a42}ਚਾ",
                "ਤ\u{a41}ਹਾਡ\u{a47} ਵ\u{a71}ਲ ਵ\u{a47}ਖਦਾ ਚ\u{a42}ਚਾ",
                "ਬ\u{a71}ਚਾ",
                "ਮੀਟ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("اگیوں سامنا کردا نیکا چوچا"),
            keywords: &["اگیوں سامنا کردا نیکا چوچا", "بال", "پنچھی", "چوچا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Chíkin Pikin Wé De Fés Frọnt"),
            keywords: &[
                "Bébi",
                "Bẹd",
                "Chíkin Pikin",
                "Chíkin Pikin Wé De Fés Frọnt",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kurczątko od przodu"),
            keywords: &["kurczątko od przodu", "pisklak", "pisklę"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("مخامخ چرګوری"),
            keywords: &["مخامخ چرګوری", "کوچنۍ، مرغه، چرګوړی، مخامخ چرګوړی،"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("pintinho de frente"),
            keywords: &[
                "ave",
                "fihote",
                "galinha",
                "pintinho",
                "pintinho de frente",
                "pinto",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("pintainho a olhar para a frente"),
            keywords: &["bebé", "pintainho", "pintainho a olhar para a frente"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("huchuy pollo chimpa rikuchkan"),
            keywords: &["huchuy", "huchuy pollo chimpa rikuchkan", "pollo", "p’isqu"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("pui de găină din față"),
            keywords: &["pasăre", "pui", "pui de găină din față"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-482"),
            keywords: &["E10-482"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("цыпленок"),
            keywords: &["крылья", "курица", "маленький", "цыпленок"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umushwi ukureba"),
            keywords: &["agashwi", "inyoni", "umushwi", "umushwi ukureba"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("اڳيان کان ننڍو مرغي جو ٻچو"),
            keywords: &["اڳيان کان ننڍو مرغي جو ٻچو", "ننڍو، مرغي جو ٻچو، پکي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some(
                "ඉද\u{dd2}ර\u{dd2}යට ම\u{dd4}හ\u{dd4}ණ ප\u{dcf} ස\u{dd2}ට\u{dd2}න ළදර\u{dd4} ක\u{dd4}ක\u{dd4}ළ\u{dd4} පැට\u{dd2}ය\u{dcf}",
            ),
            keywords: &[
                "ඉද\u{dd2}ර\u{dd2}යට ම\u{dd4}හ\u{dd4}ණ ප\u{dcf} ස\u{dd2}ට\u{dd2}න ළදර\u{dd4} ක\u{dd4}ක\u{dd4}ළ\u{dd4} පැට\u{dd2}ය\u{dcf}",
                "ක\u{dd4}ක\u{dd4}ළ\u{dd4} පැට\u{dd2}ය\u{dcf}",
                "පැට\u{dd2}ය\u{dcf}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("kurča spredu"),
            keywords: &["kuriatko", "kurča spredu"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("piščanček, gleda naprej"),
            keywords: &["mladič", "piščanček", "piščanček, gleda naprej"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("cunugga diggaaga hor soo eegaya"),
            keywords: &[
                "cunug",
                "cunug diggaag hor soo eegaya",
                "cunugga diggaaga hor soo eegaya",
                "jiiw",
                "shimbir",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("zog pule përballë"),
            keywords: &["pulë", "zog", "zog pule përballë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("пиле спреда"),
            keywords: &["бeбa", "пилe", "пиле спреда", "птица"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("пиле сприједа"),
            keywords: &["пиле сприједа"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("pile spreda"),
            keywords: &["beba", "pile", "pile spreda", "ptica"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("pile sprijeda"),
            keywords: &["pile sprijeda"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("kyckling framifrån"),
            keywords: &["fågel", "kyckling", "kyckling framifrån"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kifaranga kinachotazama mbele"),
            keywords: &["kifaranga", "kifaranga kinachotazama mbele", "mtoto"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some(
                "நேருக\u{bcd}கு நேர\u{bcd} ப\u{bbe}ர\u{bcd}க\u{bcd}கும\u{bcd} கோழி குஞ\u{bcd}சு",
            ),
            keywords: &[
                "கோழிக\u{bcd}குஞ\u{bcd}சு",
                "நேருக\u{bcd}கு நேர\u{bcd} ப\u{bbe}ர\u{bcd}க\u{bcd}கும\u{bcd} கோழி குஞ\u{bcd}சு",
                "முன\u{bcd}நின\u{bcd}று ப\u{bbe}ர\u{bcd}க\u{bcd}கும\u{bcd} கோழிக\u{bcd}குஞ\u{bcd}சு",
                "விலங\u{bcd}கினம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ముఖం కన\u{c3f}ప\u{c3f}ంచ\u{c47} క\u{c4b}డ\u{c3f}ప\u{c3f}ల\u{c4d}ల"),
            keywords: &[
                "క\u{c4b}డ\u{c3f}ప\u{c3f}ల\u{c4d}ల",
                "ముఖం",
                "ముఖం కన\u{c3f}ప\u{c3f}ంచ\u{c47} క\u{c4b}డ\u{c3f}ప\u{c3f}ల\u{c4d}ల",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("чӯҷаи хурди ба тарафи пеш нигоҳ карда истода"),
            keywords: &[
                "кӯдак",
                "парранда",
                "чӯҷа",
                "чӯҷаи хурди ба тарафи пеш нигоҳ карда истода",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ล\u{e39}กเจ\u{e35}\u{e4a}ยบย\u{e37}นห\u{e31}นหน\u{e49}า"),
            keywords: &[
                "ล\u{e39}กเจ\u{e35}\u{e4a}ยบ",
                "ล\u{e39}กเจ\u{e35}\u{e4a}ยบย\u{e37}นห\u{e31}นหน\u{e49}า",
                "ส\u{e31}ตว\u{e4c}ป\u{e35}ก",
                "ไก\u{e48}",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("bäri garaýan jüýjejik"),
            keywords: &["bäbek", "bäri garaýan jüýjejik", "guş", "jüýje"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ʻuhikiʻimoa hanga mai"),
            keywords: &["ʻuhikiʻimoa hanga mai"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("önden civciv"),
            keywords: &[
                "hayvan",
                "piliç",
                "tavuk",
                "yavru",
                "yüzü dönük civciv",
                "önden civciv",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئالدىچە چۆجە"),
            keywords: &["ئالدىچە چۆجە", "بوۋاق", "توخۇ", "قۇش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("курча, що стоїть"),
            keywords: &[
                "курка",
                "курча",
                "курча, що стоїть",
                "курчатко",
                "мале курча",
                "пташка",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سامنے دیکھتا بیبی چوزہ"),
            keywords: &["بچہ", "جانور", "سامنے دیکھتا بیبی چوزہ", "چوزہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("oldiga qarab turgan jo‘ja"),
            keywords: &["chaqaloq", "jo‘ja", "oldiga qarab turgan jo‘ja"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt trước gà con"),
            keywords: &["chim", "gà", "gà con", "mặt trước gà con"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kanam jàkkarloo ak lexu xale"),
            keywords: &["cuuj", "kanam jàkkarloo ak lexu xale", "liir", "picc"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("intshontsho elijonge ngaphambili"),
            keywords: &[
                "intaka",
                "intshontsho",
                "intshontsho elijonge ngaphambili",
                "usana",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ọmọ Adiyẹ ti now Iwaju"),
            keywords: &["ìkókó", "ẹyẹ", "Ọmọ Adiyẹ ti now Iwaju", "ọmọ adìyẹ"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("正面雞仔"),
            keywords: &["嬰兒", "小雞", "正面雞仔", "雀"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("正面鸡仔"),
            keywords: &["婴儿", "小鸡", "正面鸡仔", "雀"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("正面朝向的小鸡"),
            keywords: &["小鸡", "正面朝向的小鸡"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("小雞"),
            keywords: &["小雞"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["小雞", "小雞仔", "雞仔"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ichwane elincane elibheke phambili"),
            keywords: &["ichwane", "ichwane elincane elibheke phambili", "ingane"],
        },
    ],
};
#[doc = "🐦"]
pub const BIRD: crate::Emoji = crate::Emoji {
    glyph: "🐦",
    codepoint: "1F426",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "bird",
    group: "Animals & Nature",
    subgroup: "animal-bird",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("voël"),
            keywords: &["voël"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ወፍ"),
            keywords: &["ወፍ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("طائر"),
            keywords: &["طائر", "عصفور"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("চৰ\u{9be}ই"),
            keywords: &["চৰ\u{9be}ই"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("quş"),
            keywords: &["quş"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("птушка"),
            keywords: &["птушка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("птица"),
            keywords: &["птица"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("প\u{9be}খি"),
            keywords: &["প\u{9be}খি"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("evn"),
            keywords: &["evn", "loen"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("ptica"),
            keywords: &["ptica"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("ocell"),
            keywords: &["au", "ocell"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄛\u{11133}𑄆𑄬𑄇\u{11134}"),
            keywords: &["𑄛\u{11133}𑄆𑄬𑄇\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏥᏍᏆ"),
            keywords: &["ᏥᏍᏆ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("pták"),
            keywords: &["pták", "ptáček"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("aderyn"),
            keywords: &["aderyn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("fugl"),
            keywords: &["dyr", "fugl"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Vogel"),
            keywords: &["Papagei", "Taube", "Vogel"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πουλί"),
            keywords: &["πουλί"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("bird"),
            keywords: &["bird"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("pájaro"),
            keywords: &["ave", "pajarillo", "pájaro"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "animal",
                "ave",
                "periquito",
                "periquito australiano",
                "pájaro",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("lind"),
            keywords: &["lind"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("txoria"),
            keywords: &["txori", "txoria"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پرنده"),
            keywords: &["پرنده"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("lintu"),
            keywords: &["lintu", "pikkulintu", "turkoosi"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("ibon"),
            keywords: &["hayop", "ibon"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("fuglaandlit"),
            keywords: &["andlit", "fuglaandlit", "fuglur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("oiseau"),
            keywords: &["animal", "oiseau"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["oiseau"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("éan"),
            keywords: &["éan"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("eun"),
            keywords: &["eun"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("paxaro"),
            keywords: &["paxaro"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પક\u{acd}ષી"),
            keywords: &["પક\u{acd}ષી", "પ\u{acd}રાણી"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("tsuntsu"),
            keywords: &["tsuntsu"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("ציפור"),
            keywords: &["ציפור"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("चिड\u{93c}िया"),
            keywords: &["चिड\u{93c}िया", "पश\u{941}"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("ptica"),
            keywords: &["ptica"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("madár"),
            keywords: &["madár"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("թռչուն"),
            keywords: &["թռչուն", "ծիտ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("burung"),
            keywords: &["burung"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nnụnụ"),
            keywords: &["nnụnụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("fugl"),
            keywords: &["fugl"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("uccello"),
            keywords: &["animale", "uccello"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("鳥"),
            keywords: &["動物", "顔", "鳥"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("manuk"),
            keywords: &["manuk"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ჩიტი"),
            keywords: &["ფრინველი", "ჩიტი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("құс"),
            keywords: &["құс"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("fugl"),
            keywords: &["dyr", "fugl"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("បក\u{17d2}ស\u{17b8}"),
            keywords: &["បក\u{17d2}ស\u{17b8}"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಹಕ\u{ccd}ಕ\u{cbf}"),
            keywords: &["ಪಕ\u{ccd}ಷ\u{cbf}", "ಹಕ\u{ccd}ಕ\u{cbf}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("새"),
            keywords: &["동물", "새"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("स\u{941}कण\u{947}\u{902}"),
            keywords: &["स\u{941}कण\u{947}\u{902}"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("чымчык"),
            keywords: &["куш", "чымчык"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Vugel"),
            keywords: &["Vugel"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ນ\u{ebb}ກ"),
            keywords: &["ນ\u{ebb}ກ", "ສ\u{eb1}ດ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("paukštis"),
            keywords: &["paukštis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("putns"),
            keywords: &["putns"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("manu"),
            keywords: &["manu"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("птица"),
            keywords: &["птица"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പക\u{d4d}ഷി"),
            keywords: &["പക\u{d4d}ഷി", "പറവ", "മ\u{d43}ഗം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("шувуу"),
            keywords: &["шувуу"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("पक\u{94d}षी"),
            keywords: &["पक\u{94d}षी"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("burung"),
            keywords: &["burung"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("għasfur"),
            keywords: &["għasfur"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("င\u{103e}က\u{103a}"),
            keywords: &["င\u{103e}က\u{103a}"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("fugl"),
            keywords: &["dyr", "fugl"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("प\u{902}क\u{94d}षी"),
            keywords: &["प\u{902}क\u{94d}षी"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("vogel"),
            keywords: &["vogel"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("fugl"),
            keywords: &["dyr", "fugl"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପକ\u{b4d}ଷୀ"),
            keywords: &["ପକ\u{b4d}ଷୀ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪ\u{a70}ਛੀ"),
            keywords: &["ਜਾਨਵਰ", "ਪ\u{a70}ਛੀ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("پنچھی"),
            keywords: &["پنچھی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Bẹd"),
            keywords: &["Bẹd"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("ptak"),
            keywords: &["ptak", "ptaszek"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("مرغه"),
            keywords: &["مرغه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("pássaro"),
            keywords: &["animal", "pássaro"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["ave", "pássaro"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("p’isqu"),
            keywords: &["p’isqu"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("pasăre"),
            keywords: &["pasăre"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-483"),
            keywords: &["E10-483"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("птица"),
            keywords: &["голова", "птица"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("inyoni"),
            keywords: &["inyoni"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("پکي"),
            keywords: &["پکي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ක\u{dd4}ර\u{dd4}ල\u{dca}ල\u{dcf}"),
            keywords: &["ක\u{dd4}ර\u{dd4}ල\u{dca}ල\u{dcf}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("vták"),
            keywords: &["vták"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("ptica"),
            keywords: &["ptica", "ptič", "ptiček"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("shimbir"),
            keywords: &["shimbir"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("zog"),
            keywords: &["shpend", "zog"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("птица"),
            keywords: &["птица"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("ptica"),
            keywords: &["ptica"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("fågel"),
            keywords: &["djur", "fågel"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("ndege"),
            keywords: &["ndege"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பறவை"),
            keywords: &["பறவை", "விலங\u{bcd}கினம\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("పక\u{c4d}ష\u{c3f}"),
            keywords: &["జంతువు", "పక\u{c4d}ష\u{c3f}"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("парранда"),
            keywords: &["парранда"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("นก"),
            keywords: &["นก", "ส\u{e31}ตว\u{e4c}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("guş"),
            keywords: &["guş"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("manupuna"),
            keywords: &["manupuna"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kuş"),
            keywords: &["hayvan", "kuş"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قۇش"),
            keywords: &["قۇش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("птах"),
            keywords: &["птах", "пташка"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("پرنده"),
            keywords: &["آسمان", "پرنده", "پرندہ", "چڑیا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("qush"),
            keywords: &["qush"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("chim"),
            keywords: &["chim"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("picc"),
            keywords: &["picc"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("intaka"),
            keywords: &["intaka"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ẹyẹ"),
            keywords: &["Ẹyẹ"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("雀仔"),
            keywords: &["雀仔"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("雀仔"),
            keywords: &["雀仔"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("鸟"),
            keywords: &["鸟"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("鳥"),
            keywords: &["鳥"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("雀仔"),
            keywords: &["雀仔"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("inyoni"),
            keywords: &["inyoni"],
        },
    ],
};
#[doc = "🐧"]
pub const PENGUIN: crate::Emoji = crate::Emoji {
    glyph: "🐧",
    codepoint: "1F427",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "penguin",
    group: "Animals & Nature",
    subgroup: "animal-bird",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("pikkewyn"),
            keywords: &["pikkewyn", "voël"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ፔንግዊን"),
            keywords: &["ፔንግዊን"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("بطريق"),
            keywords: &["بطريق", "طائر"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("পেংগ\u{9c1}ইন"),
            keywords: &["চৰ\u{9be}ই", "পেংগ\u{9c1}ইন"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("pinqvin"),
            keywords: &["pinqvin", "quş"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("пінгвін"),
            keywords: &["птушка", "пінгвін"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("пингвин"),
            keywords: &["пингвин"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("পেঙ\u{9cd}গ\u{9c1}ইন"),
            keywords: &["পেংগ\u{9c1}ইন", "পেঙ\u{9cd}গ\u{9c1}ইন"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("god"),
            keywords: &["evn", "god"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("pingvin"),
            keywords: &["pingvin", "ptica"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("pingüí"),
            keywords: &["au", "pingüí"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄛𑄬\u{11101}𑄉\u{1112a}𑄄𑄚\u{11134}"),
            keywords: &["𑄛𑄬\u{11101}𑄉\u{1112a}𑄄𑄚\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏧᏴᏝ ᎡᎯ ᏥᏍᏆ"),
            keywords: &["ᏥᏍᏆ", "ᏧᏴᏝ ᎡᎯ ᏥᏍᏆ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("tučňák"),
            keywords: &["pták", "tučňák"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("pengwin"),
            keywords: &["aderyn", "pengwin"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("pingvin"),
            keywords: &["dyr", "pingvin"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Pinguin"),
            keywords: &["Pinguin", "Tier"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πιγκουίνος"),
            keywords: &["πιγκουίνος", "πτηνό"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("penguin"),
            keywords: &["bird", "penguin"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("pingüino"),
            keywords: &["ave", "pingüino"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["animal", "ave", "pingüino"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("pingviin"),
            keywords: &["pingviin"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("pinguinoa"),
            keywords: &["pinguino", "pinguinoa"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پنگوئن"),
            keywords: &["پنگوئن"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("pingviini"),
            keywords: &["lintu", "pingviini"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("penguin"),
            keywords: &["antartica", "hayop", "ibon", "penguin"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("pingvinandlit"),
            keywords: &["andlit", "pingvin", "pingvinandlit"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("pingouin"),
            keywords: &["animal", "oiseau", "pingouin"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["oiseau", "pingouin"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("piongain"),
            keywords: &["piongain", "éan"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("ceann-fionn"),
            keywords: &["ceann-fionn", "eun"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("pingüín"),
            keywords: &["pingüín"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પ\u{ac7}\u{a82}ગ\u{acd}વિન"),
            keywords: &["પ\u{ac7}\u{a82}ગ\u{acd}વિન", "પ\u{acd}રાણી"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("tsuntsun Penguin"),
            keywords: &["tsuntsu", "tsuntsun Penguin", "tsuntsun penguin"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פינגווין"),
            keywords: &["פינגווין", "ציפור"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("प\u{947}\u{902}ग\u{94d}विन"),
            keywords: &["पश\u{941}", "प\u{947}\u{902}ग\u{94d}विन"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("pingvin"),
            keywords: &["pingvin", "ptica"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("pingvin"),
            keywords: &["madár", "pingvin"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("պինգվին"),
            keywords: &["անտարկտիդա", "թռչուն", "պինգվին"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("pinguin"),
            keywords: &["burung", "pinguin"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nnụnụ sno"),
            keywords: &["nnụnụ", "nnụnụ sno"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("mörgæs"),
            keywords: &["fugl", "mörgæs"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("pinguino"),
            keywords: &["animale", "pinguino"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ペンギン"),
            keywords: &["ペンギン", "動物", "鳥"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("penguin"),
            keywords: &["manuk", "penguin"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("პინგვინი"),
            keywords: &["პინგვინი", "ფრინველი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("пингвин"),
            keywords: &["пингвин"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("pingvin"),
            keywords: &["dyr", "pingvin"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ផេនឃ\u{17d2}វ\u{17b8}ន"),
            keywords: &["បក\u{17d2}ស\u{17b8}", "ផេនឃ\u{17d2}វ\u{17b8}ន"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪ\u{cc6}ಂಗ\u{ccd}ವ\u{cbf}ನ\u{ccd}"),
            keywords: &["ಪಕ\u{ccd}ಷ\u{cbf}", "ಪ\u{cc6}ಂಗ\u{ccd}ವ\u{cbf}ನ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("펭귄"),
            keywords: &["동물", "펭귄"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("प\u{947}\u{902}ग\u{94d}वीन"),
            keywords: &["प\u{947}\u{902}ग\u{94d}वीन", "स\u{941}कण\u{947}\u{902}"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("пингвин"),
            keywords: &["куш", "пингвин"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Pinguin"),
            keywords: &["Pinguin", "Vugel"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ນ\u{ebb}ກເພນກ\u{eb4}ນ"),
            keywords: &[
                "ນ\u{eb1}ກແພນກ\u{eb4}ນ",
                "ນ\u{ebb}ກເພນກ\u{eb4}ນ",
                "ສ\u{eb1}ດ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("pingvinas"),
            keywords: &["paukštis", "pingvinas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("pingvīns"),
            keywords: &["pingvīns", "putns"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kororā"),
            keywords: &["kororā", "manu"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("пингвин"),
            keywords: &["пингвин", "птица"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പെൻഗ\u{d4d}വിൻ"),
            keywords: &["പക\u{d4d}ഷി", "പെൻഗ\u{d4d}വിൻ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("оцон шувуу"),
            keywords: &["оцон шувуу"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("प\u{947}\u{902}ग\u{94d}विन"),
            keywords: &["पक\u{94d}षी", "प\u{947}\u{902}ग\u{94d}विन"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("penguin"),
            keywords: &["penguin"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("pingwin"),
            keywords: &["għasfur", "pingwin"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပင\u{103a}ဂ\u{103d}င\u{103a}းင\u{103e}က\u{103a}"),
            keywords: &["ပင\u{103a}ဂ\u{103d}င\u{103a}းင\u{103e}က\u{103a}"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("pingvin"),
            keywords: &["dyr", "fugl", "pingvin"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("प\u{947}न\u{94d}ग\u{941}इन"),
            keywords: &["प\u{947}न\u{94d}ग\u{941}इन"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("pinguïn"),
            keywords: &["pinguïn", "vogel"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("pingvin"),
            keywords: &["dyr", "fugl", "pingvin"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପେଙ\u{b4d}ଗ\u{b41}ଇନ\u{b4d}\u{200d}"),
            keywords: &["ଜୀବ", "ପେଙ\u{b4d}ଗ\u{b41}ଇନ\u{b4d}\u{200d}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪ\u{a48}\u{a02}ਗ\u{a42}ਇਨ"),
            keywords: &["ਪ\u{a48}\u{a02}ਗ\u{a42}ਇਨ", "ਪ\u{a70}ਛੀ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("پینگوئن"),
            keywords: &["پنچھی", "پینگوئن"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Pẹ\u{301}ngwin"),
            keywords: &["Bẹd", "Pẹ\u{301}ngwin"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("pingwin"),
            keywords: &["pingwin"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("پینگوین"),
            keywords: &["مرغه، پينګوين", "پینگوین"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("pinguim"),
            keywords: &["animal", "pinguim"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["pinguim"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("pinguino"),
            keywords: &["pinguino", "p’isqu"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("pinguin"),
            keywords: &["frig", "gheață", "pasăre", "pinguin"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-484"),
            keywords: &["E10-484"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("пингвин"),
            keywords: &["голова", "пингвин"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("pingwini"),
            keywords: &["inyoni", "pengwini", "pingwini"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("پينگوئن"),
            keywords: &["پينگوئن", "پينگوئن، پکي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("පෙන\u{dca}ග\u{dd4}ව\u{dd2}න\u{dca}"),
            keywords: &[
                "ක\u{dd4}ර\u{dd4}ල\u{dca}ල\u{dcf}",
                "පෙන\u{dca}ග\u{dd4}ය\u{dd2}න\u{dca}",
                "පෙන\u{dca}ග\u{dd4}ව\u{dd2}න\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("tučniak"),
            keywords: &["tučniak"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("pingvin"),
            keywords: &["pingvin"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("shimbir baraf"),
            keywords: &["shimbir", "shimbir baraf"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("pinguin"),
            keywords: &["pinguin", "shpend"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("пингвин"),
            keywords: &["пингвин", "птица"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["пингвин"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("pingvin"),
            keywords: &["pingvin", "ptica"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["pingvin"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("pingvin"),
            keywords: &["fågel", "pingvin"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("pengwini"),
            keywords: &["pengwini"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பென\u{bcd}குயின\u{bcd}"),
            keywords: &["பறவை", "பென\u{bcd}குயின\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ప\u{c46}ంగ\u{c4d}వ\u{c3f}న\u{c4d}"),
            keywords: &["జంతువు", "ప\u{c46}ంగ\u{c4d}వ\u{c3f}న\u{c4d}"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("пингвин"),
            keywords: &["парранда", "пингвин"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เพนกว\u{e34}น"),
            keywords: &["ส\u{e31}ตว\u{e4c}", "เพนกว\u{e34}น"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("pingwin"),
            keywords: &["guş", "pingwin"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("penikuini"),
            keywords: &["penikuini"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("penguen"),
            keywords: &["hayvan", "penguen"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("پىنگۋىن"),
            keywords: &["قۇش", "پىنگۋىن"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("пінгвін"),
            keywords: &["птах", "пінгвін"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("پنگوئن"),
            keywords: &["پنگوئن"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("pingvin"),
            keywords: &["parranda", "pingvin"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("chim cánh cụt"),
            keywords: &["chim", "chim cánh cụt"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("penguweŋ"),
            keywords: &["penguweŋ", "picc"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iphengwini"),
            keywords: &["intaka", "iphengwini"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ẹyẹ Oko"),
            keywords: &["Ẹyẹ Oko", "ẹyẹ", "ẹyẹ oko"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("企鵝"),
            keywords: &["企鵝", "雀仔"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("企鹅"),
            keywords: &["企鹅", "雀仔"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("企鹅"),
            keywords: &["企鹅"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("企鵝"),
            keywords: &["企鵝"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["企鵝", "鳥"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("iphengwini"),
            keywords: &["iphengwini"],
        },
    ],
};
#[doc = "🕊\u{fe0f}"]
pub const DOVE: crate::Emoji = crate::Emoji {
    glyph: "🕊\u{fe0f}",
    codepoint: "1F54A FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "dove",
    group: "Animals & Nature",
    subgroup: "animal-bird",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🕊",
        codepoint: "1F54A",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "dove",
        group: "Animals & Nature",
        subgroup: "animal-bird",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("duif"),
            keywords: &["duif", "vlieg", "voël", "vrede"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("እርግብ"),
            keywords: &["ሰላም", "ብረር", "እርግብ", "ወፍ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("حمامة"),
            keywords: &["حمامة", "سلام", "طائر"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("প\u{9be}ৰ"),
            keywords: &["উৰ\u{9be}", "চৰ\u{9be}ই", "প\u{9be}ৰ", "শ\u{9be}ন\u{9cd}তি"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("göyərçin"),
            keywords: &["göyərçin", "quş", "sülh", "uçmaq"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("голуб"),
            keywords: &["голуб", "мір", "палёт", "птушка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("гълъб"),
            keywords: &["гълъб", "мир", "полет", "птица"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("প\u{9be}য\u{9bc}র\u{9be}"),
            keywords: &[
                "ওড\u{9bc}\u{9be}",
                "প\u{9be}খি",
                "প\u{9be}য\u{9bc}র\u{9be}",
                "শ\u{9be}ন\u{9cd}তি",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("koulm"),
            keywords: &["evn", "koulm", "peocʼh"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("golubica"),
            keywords: &["golubica", "let", "mir", "ptica"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("colom"),
            keywords: &["au", "colom", "pau", "volar"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄇\u{11127}"),
            keywords: &["𑄇\u{11127}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎫᎴ ᏗᏍᎪᏂ"),
            keywords: &["ᎦᏃᎯᎵ", "ᎫᎴ ᏗᏍᎪᏂ", "ᏅᏩᏙᎯᏯᏛ", "ᏥᏍᏆ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("holubice"),
            keywords: &["holubice", "let", "letící", "létat", "mír", "pták"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("colomen"),
            keywords: &["aderyn", "colomen", "heddwch", "hedfan"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("due"),
            keywords: &["due", "flyve", "fred", "fugl"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Taube"),
            keywords: &["Friede", "Frieden", "Taube", "Vogel", "fliegen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("περιστέρι"),
            keywords: &["ειρήνη", "περιστέρι", "πετώ", "πουλί"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("dove"),
            keywords: &["bird", "dove", "fly", "peace"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("paloma"),
            keywords: &["animal", "paloma", "paz", "pájaro"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["animal", "ave", "paloma", "paz"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("tuvi"),
            keywords: &["lind", "rahu", "tuvi"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("uxoa"),
            keywords: &["bake", "hegan", "txori", "uxoa"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کبوتر"),
            keywords: &["صلح", "پرنده", "پریدن", "کبوتر"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kyyhky"),
            keywords: &["kyyhky", "lentää", "lintu", "rauha"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("kalapati"),
            keywords: &["hayop", "ibon", "kalapati", "kapayapaan", "lumilipad"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("dúgva við oljugrein"),
            keywords: &[
                "dúgva",
                "dúgva við oljugrein",
                "dýr",
                "friður",
                "fuglur",
                "oljugrein",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("colombe"),
            keywords: &["animal", "colombe", "oiseau"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("colm"),
            keywords: &["colm", "eitilt", "síocháin", "éan"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("calman"),
            keywords: &["calman", "eun", "itealadh", "sgiathadh", "sìth"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("pomba"),
            keywords: &["ave", "paz", "pomba", "voar"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("કબ\u{ac2}તર"),
            keywords: &["કબ\u{ac2}તર", "પક\u{acd}ષી", "શા\u{a82}તિ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kurciya"),
            keywords: &["kurciya", "tashi", "tsuntsu", "zaman lafiya"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("יונה"),
            keywords: &["יונה", "עלה זית", "שלום"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("कब\u{942}तर"),
            keywords: &["कब\u{942}तर", "पक\u{94d}षी"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("golubica"),
            keywords: &["golubica", "letenje", "mir", "ptica"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("galamb"),
            keywords: &["békegalamb", "galamb", "madár", "olajág"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("աղավնի"),
            keywords: &["աղավնի", "թռչել", "թռչուն", "խաղաղություն"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("merpati"),
            keywords: &["burung", "damai", "merpati", "terbang"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nduri"),
            keywords: &["fepụ", "nduri", "nnụnụ", "udo"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("dúfa"),
            keywords: &["dúfa", "friður", "fugl"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("colomba"),
            keywords: &["Pasqua", "colomba", "pace", "uccello", "ulivo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ハト"),
            keywords: &["ハト", "動物", "平和", "鳥"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("dara"),
            keywords: &["damai", "dara", "mabur", "manuk"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მტრედი"),
            keywords: &["მტრედი", "მშვიდობა", "ფრენა", "ფრინველი", "ჩიტი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("көгершін"),
            keywords: &["көгершін", "тыныштық", "құс", "ұшу"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("due"),
            keywords: &["due", "flyve", "fred", "fugl"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ព\u{17d2}រាប"),
            keywords: &[
                "បក\u{17d2}ស\u{17b8}",
                "ព\u{17d2}រាប",
                "សន\u{17d2}ត\u{17b7}ភាព",
                "ហើរ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪಾರ\u{cbf}ವಾಳ"),
            keywords: &["ಪಕ\u{ccd}ಷ\u{cbf}", "ಪಾರ\u{cbf}ವಾಳ", "ಶಾಂತ\u{cbf}ಯ ಸಂಕೇತ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("비둘기"),
            keywords: &["비둘기", "새", "평화"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("पारवो"),
            keywords: &["उडप", "पारवो", "शा\u{902}ती", "स\u{941}कण\u{947}\u{902}"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("көгүчкөн"),
            keywords: &["көгүчкөн", "тынчтык", "учуу", "чымчык"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Dauf"),
            keywords: &["Dauf", "Fridden", "Vugel", "fléien"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ນ\u{ebb}ກເຂ\u{ebb}າ"),
            keywords: &["ນ\u{ebb}ກເຂ\u{ebb}າ", "ສ\u{eb1}ດ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("balandis"),
            keywords: &["balandis", "paukštis", "skristi", "taika"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("dūja"),
            keywords: &["balodis", "dūja", "lidot", "miers", "putns"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kupupa"),
            keywords: &["kupupa", "manu", "rere", "rongomau"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("гулабица"),
            keywords: &["гулабица", "лет", "мир", "птица"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പ\u{d4d}ര\u{d3e}വ\u{d4d}"),
            keywords: &[
                "പക\u{d4d}ഷി",
                "പറവ",
                "പ\u{d4d}ര\u{d3e}വ\u{d4d}",
                "സമ\u{d3e}ധ\u{d3e}നം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("тагтаа"),
            keywords: &["нисэх", "тагтаа", "шувуу", "энх тайван"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("कब\u{941}तर"),
            keywords: &["उडण\u{947}", "कब\u{941}तर", "पक\u{94d}षी", "शा\u{902}तता"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("burung merpati"),
            keywords: &["burung", "burung merpati", "keamanan", "terbang"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ħamiema"),
            keywords: &["għasfur", "itir", "paċi", "ħamiema"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ချ\u{102d}\u{102f}းင\u{103e}က\u{103a}"),
            keywords: &[
                "ချ\u{102d}\u{102f}းင\u{103e}က\u{103a}",
                "ငြ\u{102d}မ\u{103a}းချမ\u{103a}းရေး",
                "င\u{103e}က\u{103a}",
                "ပျ\u{1036}သန\u{103a}းခြင\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("fredsdue"),
            keywords: &["due", "dyr", "fly", "fred", "fredsdue", "fugl"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ढ\u{941}क\u{94d}क\u{941}र"),
            keywords: &["उड\u{94d}न\u{947}", "चरा", "ढ\u{941}क\u{94d}क\u{941}र"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("duif"),
            keywords: &["duif", "vliegen", "vogel", "vrede"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("fredsdue"),
            keywords: &["due", "dyr", "fly", "fred", "fredsdue", "fugl"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କପୋତ"),
            keywords: &[
                "କପୋତ",
                "ପକ\u{b4d}ଷୀ । ଉଡ\u{b3f}ବ\u{b3e} । ଶ\u{b3e}ନ\u{b4d}ତ\u{b3f}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਅਮਨ ਦਾ ਪ\u{a70}ਛੀ, ਘ\u{a41}\u{a71}ਗੀ"),
            keywords: &[
                "ਅਮਨ",
                "ਅਮਨ ਦਾ ਪ\u{a70}ਛੀ, ਘ\u{a41}\u{a71}ਗੀ",
                "ਉ\u{a71}ਡਣਾ",
                "ਪ\u{a70}ਛੀ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("فاختہ"),
            keywords: &["امن", "فاختہ", "مکھی", "پنچھی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Dov"),
            keywords: &["Bẹd", "Dov", "Flai", "Piis"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("gołąb"),
            keywords: &["gołąb", "gołąbek"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("کوتره"),
            keywords: &["مرغۍ، کوتره، الوتل، امن", "کوتره"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("pomba branca"),
            keywords: &[
                "animal",
                "ave branca",
                "paz",
                "pomba",
                "pomba branca",
                "pássaro",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("pomba"),
            keywords: &["paz", "pomba", "pássaro", "voar"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("urpi"),
            keywords: &["phaway", "p’isqu", "qhasi kay", "urpi"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("porumbiță"),
            keywords: &["pace", "pasăre", "porumbel", "porumbiță", "zbor"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-763"),
            keywords: &["E10-763"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("голубь"),
            keywords: &["белый", "голубь", "мир", "полет"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("inuma"),
            keywords: &["amahoro", "inuma", "inyoni"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪبوتر"),
            keywords: &["پکي، اڏامڻ، امن", "ڪبوتر"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("පරෙව\u{dd2}ය\u{dcf}"),
            keywords: &[
                "ඉග\u{dd2}ල\u{dd3}ම",
                "ක\u{dd4}ර\u{dd4}ල\u{dca}ල\u{dcf}",
                "පරෙව\u{dd2}ය\u{dcf}",
                "ස\u{dcf}මය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("holubica"),
            keywords: &["holubica", "lietať", "mier", "vták"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("golobica"),
            keywords: &["golobica", "leteti", "mir", "ptič"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("qoolleey"),
            keywords: &["buubid", "nabad", "qoolleey", "shimbir"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("pëllumb"),
            keywords: &["fluturoj", "paqe", "pëllumb", "zog"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("голубица"),
            keywords: &["голубица", "лeтeњe", "мир", "птицa"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("golubica"),
            keywords: &["golubica", "letenje", "mir", "ptica"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("duva"),
            keywords: &["duva", "fred", "fågel"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("njiwa"),
            keywords: &["amani", "ndege", "njiwa", "paa"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மணிப\u{bcd}புற\u{bbe}"),
            keywords: &[
                "சம\u{bbe}த\u{bbe}னம\u{bcd}",
                "தூது",
                "பறவை",
                "புற\u{bbe}",
                "மணிப\u{bcd}புற\u{bbe}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ప\u{c3e}వురం"),
            keywords: &[
                "ఎగరడం",
                "పక\u{c4d}ష\u{c3f}",
                "ప\u{c3e}వురం",
                "శ\u{c3e}ంత\u{c3f}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("кафтар"),
            keywords: &["кафтар", "паридан", "парранда", "сулҳ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("นกพ\u{e34}ราบขาว"),
            keywords: &[
                "นก",
                "นกพ\u{e34}ราบขาว",
                "บ\u{e34}น",
                "ส\u{e31}นต\u{e34}ภาพ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("kepderi"),
            keywords: &["guş", "kepderi", "parahatçylyk", "uçmak"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("lupe"),
            keywords: &["lupe"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("güvercin"),
            keywords: &["barış", "güvercin", "kuş", "uçma"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("كەپتەر"),
            keywords: &["ئۇچۇش", "تىنچلىق", "قۇش", "كەپتەر"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("голуб"),
            keywords: &["голуб", "літати", "мир", "птах"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("فاختہ"),
            keywords: &["امن", "فاختہ", "پرندہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kabutar"),
            keywords: &["kabutar", "qush", "tinchlik", "uchish"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bồ câu"),
            keywords: &["bay", "bồ câu", "chim", "hòa bình"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kolomb"),
            keywords: &["jàmm", "kolomb", "naaw", "picc"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ihobe"),
            keywords: &["bhabha", "ihobe", "intaka", "uxolo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("àdàbà"),
            keywords: &["fò", "àdàbà", "àláfíà", "ẹyẹ"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("鴿"),
            keywords: &["和平", "雀", "飛", "鴿"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("鸽"),
            keywords: &["和平", "雀", "飞", "鸽"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("鸽"),
            keywords: &["和平象征", "飞翔", "鸟", "鸽", "鸽子"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("飛鳥"),
            keywords: &["飛鳥", "鳥"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("白鴿"),
            keywords: &["和平鴿", "白鴿", "鴿"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ijuba"),
            keywords: &["ijuba", "inyoni", "ndiza", "ukuthula"],
        },
    ],
};
#[doc = "🦅"]
pub const EAGLE: crate::Emoji = crate::Emoji {
    glyph: "🦅",
    codepoint: "1F985",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "eagle",
    group: "Animals & Nature",
    subgroup: "animal-bird",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("arend"),
            keywords: &["arend", "voël"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ንስር አሞራ"),
            keywords: &["ንስር አሞራ", "ወፍ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("نسر"),
            keywords: &["طائر", "نسر"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ঈগল"),
            keywords: &["ঈগল", "চৰ\u{9be}ই"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qartal"),
            keywords: &["qartal", "quş"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("арол"),
            keywords: &["арол", "птушка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("орел"),
            keywords: &["орел", "птица"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ঈগল"),
            keywords: &["ঈগল", "প\u{9be}খি"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("erer"),
            keywords: &["erer", "evn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("orao"),
            keywords: &["orao", "ptica"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("àliga"),
            keywords: &["animal", "au", "ocell", "àguila", "àliga"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄄𑄉\u{11127}𑄣\u{11134}"),
            keywords: &["𑄄𑄉\u{11127}𑄣\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏬᎭᎵ"),
            keywords: &["ᏥᏍᏆ", "ᏬᎭᎵ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("orel"),
            keywords: &["orel", "pták"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("eryr"),
            keywords: &["aderyn", "eryr"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("ørn"),
            keywords: &["dyr", "fugl", "ørn"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Adler"),
            keywords: &["Adler", "Vogel"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("αετός"),
            keywords: &["αετός", "πτηνό"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("eagle"),
            keywords: &["bird", "eagle"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["bird of prey", "eagle"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("águila"),
            keywords: &["ave", "águila"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["animal", "ave", "águila"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kotkas"),
            keywords: &["kotkas", "lind"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("arranoa"),
            keywords: &["arrano", "arranoa", "hegazti"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("عقاب"),
            keywords: &["عقاب", "پرنده"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kotka"),
            keywords: &["kotka", "lintu"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("agila"),
            keywords: &["agila", "ibon"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("ørn"),
            keywords: &["dýr", "fuglur", "ørn"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("aigle"),
            keywords: &["aigle", "animal", "oiseau", "rapace"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("iolar"),
            keywords: &["iolar", "éan"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("iolaire"),
            keywords: &["eun", "iolaire"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("aguia"),
            keywords: &["aguia", "aiga", "animal", "paxaro", "rapina"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ગર\u{ac1}ડ"),
            keywords: &["ગર\u{ac1}ડ", "પક\u{acd}ષી"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mikiya"),
            keywords: &["mikiya", "tsuntsu"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("נשר"),
            keywords: &["נשר", "ציפור"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("बाज"),
            keywords: &["पक\u{94d}षी", "बाज"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("orao"),
            keywords: &["orao", "ptica"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("sas"),
            keywords: &["madár", "sas"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("արծիվ"),
            keywords: &["արծիվ", "թռչուն"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("elang"),
            keywords: &["burung", "elang"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ugo"),
            keywords: &["nnụnụ", "ugo"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("örn"),
            keywords: &["fugl", "örn"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("aquila"),
            keywords: &["animale", "aquila", "uccello"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ワシ"),
            keywords: &["ワシ", "動物", "鳥"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("elang"),
            keywords: &["elang", "manuk"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("არწივი"),
            keywords: &["არწივი", "ფრინველი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("бүркіт"),
            keywords: &["бүркіт", "құс"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("ørn"),
            keywords: &["dyr", "fugl", "ørn"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ឥន\u{17d2}ទ\u{17d2}រ\u{17b8}"),
            keywords: &["បក\u{17d2}ស\u{17b8}", "ឥន\u{17d2}ទ\u{17d2}រ\u{17b8}"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಹದ\u{ccd}ದು"),
            keywords: &["ಪಕ\u{ccd}ಷ\u{cbf}", "ಹದ\u{ccd}ದು"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("독수리"),
            keywords: &["독수리", "새", "조류"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("गर\u{941}ड"),
            keywords: &["गर\u{941}ड", "स\u{941}कण\u{947}\u{902}"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("бүркүт"),
            keywords: &["бүркүт", "канаттуу"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Adler"),
            keywords: &["Adler", "Vugel"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ອ\u{eb4}ນຊ\u{eb5}"),
            keywords: &["ນ\u{ebb}ກ", "ອ\u{eb4}ນຊ\u{eb5}"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("erelis"),
            keywords: &["erelis", "paukštis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("ērglis"),
            keywords: &["putns", "ērglis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("ekara"),
            keywords: &["ekara", "manu"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("орел"),
            keywords: &["орел", "птица"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കഴ\u{d41}കൻ"),
            keywords: &["കഴ\u{d41}കൻ", "പക\u{d4d}ഷി"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("бүргэд"),
            keywords: &["бүргэд", "шувуу"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("गर\u{942}ड"),
            keywords: &["गर\u{942}ड", "पक\u{94d}षी"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("helang"),
            keywords: &["burung", "helang"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ajkla"),
            keywords: &["ajkla", "għasfur"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လင\u{103a}းယ\u{102f}န\u{103a}"),
            keywords: &["င\u{103e}က\u{103a}", "လင\u{103a}းယ\u{102f}န\u{103a}"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("ørn"),
            keywords: &["dyr", "fugl", "ørn"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("चिल"),
            keywords: &["चरा", "चिल"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("adelaar"),
            keywords: &["adelaar", "arend", "vogel"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("ørn"),
            keywords: &["dyr", "fugl", "ørn"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଚ\u{b3f}ଲ"),
            keywords: &["ଇଗଲ\u{b4d}\u{200d} । ପକ\u{b4d}ଷୀ", "ଚ\u{b3f}ଲ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬਾਜ"),
            keywords: &["ਪ\u{a70}ਛੀ", "ਬਾਜ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("عقاب"),
            keywords: &["عقاب", "پنچھی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Ígul"),
            keywords: &["Bẹd", "Ígul"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("orzeł"),
            keywords: &["orzeł", "ptak"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("عقاب"),
            keywords: &["عقاب", "مرغۍ، عقاب"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("águia"),
            keywords: &["pássaro", "águia"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["ave", "pássaro", "águia"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("anka"),
            keywords: &["anka", "p’isqu"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("vultur"),
            keywords: &["pasăre", "vultur"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1101"),
            keywords: &["E10-1101"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("орел"),
            keywords: &["орел", "птица"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("kagoma"),
            keywords: &["igisiga", "inyoni", "kagoma"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("باز"),
            keywords: &["باز", "باز، پکي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("උක\u{dd4}ස\u{dca}ස\u{dcf}"),
            keywords: &[
                "උක\u{dd4}ස\u{dca}ස\u{dcf}",
                "ක\u{dd4}ර\u{dd4}ල\u{dca}ල\u{dcf}",
                "ර\u{dcf}ජ\u{dcf}ල\u{dd2}ය\u{dcf}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("orol"),
            keywords: &["orol", "vták"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("orel"),
            keywords: &["orel", "ptica"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("gorgor"),
            keywords: &["gorgor", "shimbir"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("shqiponjë"),
            keywords: &["shpend", "shqiponjë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("орао"),
            keywords: &["орао", "птица"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("orao"),
            keywords: &["orao", "ptica"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("örn"),
            keywords: &["fågel", "örn"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("tai (ndege)"),
            keywords: &["ndege", "tai", "tai (ndege)"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கழுகு"),
            keywords: &["கழுகு", "பறவை"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("గద\u{c4d}ద"),
            keywords: &["గద\u{c4d}ద", "పక\u{c4d}ష\u{c3f}"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("уқоб"),
            keywords: &["парранда", "уқоб"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("อ\u{e34}นทร\u{e35}"),
            keywords: &["นก", "อ\u{e34}นทร\u{e35}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("bürgüt"),
            keywords: &["bürgüt", "guş"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ʻikale"),
            keywords: &["ʻikale"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kartal"),
            keywords: &["kartal", "kuş"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("بۈركۈت"),
            keywords: &["بۈركۈت", "قۇش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("орел"),
            keywords: &["орел", "птах"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("عقاب"),
            keywords: &["عقاب", "پرندہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("burgut"),
            keywords: &["burgut", "qush"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("đại bàng"),
            keywords: &["chim", "đại bàng"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("céeli"),
            keywords: &["céeli", "picc"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ukhozi"),
            keywords: &["intaka", "ukhozi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Àṣá"),
            keywords: &["Àṣá", "àṣá", "ẹyẹ"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("鷹"),
            keywords: &["雀", "鷹"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("鹰"),
            keywords: &["雀", "鹰"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("鹰"),
            keywords: &["老鹰", "鸟", "鹰"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("老鷹"),
            keywords: &["老鷹", "鳥"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("老鷹"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ukhozi"),
            keywords: &["inyoni", "ukhozi"],
        },
    ],
};
#[doc = "🦆"]
pub const DUCK: crate::Emoji = crate::Emoji {
    glyph: "🦆",
    codepoint: "1F986",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "duck",
    group: "Animals & Nature",
    subgroup: "animal-bird",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("eend"),
            keywords: &["eend", "voël"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ዳክዬ"),
            keywords: &["ወፍ", "ዳክዬ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("بطة"),
            keywords: &["بطة", "طائر"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("হ\u{9be}\u{981}হ"),
            keywords: &["চৰ\u{9be}ই", "হ\u{9be}\u{981}হ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("ördək"),
            keywords: &["quş", "ördək"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("качка"),
            keywords: &["качка", "птушка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("патица"),
            keywords: &["патица", "птица"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("হ\u{9be}\u{981}স"),
            keywords: &["প\u{9be}খি", "হ\u{9be}\u{981}স"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("houad"),
            keywords: &["evn", "houad"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("patka"),
            keywords: &["patka", "ptica"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("ànec"),
            keywords: &["animal", "au", "ocell", "ànec"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄃𑄏 𑄦𑄌\u{11134}"),
            keywords: &["𑄃𑄏 𑄦𑄌\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎧᏬᏄ"),
            keywords: &["ᎧᏬᏄ", "ᏥᏍᏆ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("kachna"),
            keywords: &["kachna", "kachnička", "pták"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("hwyaden"),
            keywords: &["aderyn", "hwyaden"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("and"),
            keywords: &["and", "andrik", "dyr", "fugl", "svømmefugl"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Ente"),
            keywords: &["Ente", "Vogel"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πάπια"),
            keywords: &["πάπια", "πτηνό"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("duck"),
            keywords: &["bird", "duck"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("pato"),
            keywords: &["ave", "pato"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["animal", "ave", "pato"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("part"),
            keywords: &["lind", "part"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ahatea"),
            keywords: &["ahate", "ahatea", "hegazti"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("مرغابی"),
            keywords: &["مرغابی", "پرنده"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("sorsa"),
            keywords: &["lintu", "sorsa"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("bibi"),
            keywords: &["bibi", "ibon"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("dunna"),
            keywords: &["dunna", "dýr", "fuglur", "steggi"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("canard"),
            keywords: &["animal", "canard", "oiseau"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["canard", "oiseau"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("lacha"),
            keywords: &["lacha", "éan"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("tunnag"),
            keywords: &["eun", "eunlaith", "tunnag"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("pato"),
            keywords: &["animal", "parrulo", "pato", "paxaro"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("બતક"),
            keywords: &["પક\u{acd}ષી", "બતક"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("agwagwa"),
            keywords: &["agwagwa", "tsuntsu"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("ברווז"),
            keywords: &["ברווז", "עוף"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("बतख"),
            keywords: &["पक\u{94d}षी", "बतख"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("patka"),
            keywords: &["patka", "ptica"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("kacsa"),
            keywords: &["kacsa", "madár"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բադ"),
            keywords: &["բադ", "թռչուն"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("bebek"),
            keywords: &["bebek", "unggas"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("udele igbo"),
            keywords: &["nnụnụ", "udele igbo"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("önd"),
            keywords: &["fugl", "önd"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("anatra"),
            keywords: &["anatra", "animale", "uccello"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("カモ"),
            keywords: &["カモ", "動物", "鳥"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("bebek"),
            keywords: &["bebek", "unggas"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("იხვი"),
            keywords: &["იხვი", "ფრინველი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("үйрек"),
            keywords: &["құс", "үйрек"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("and"),
            keywords: &["and", "andrik", "dyr", "fugl", "svømmefugl"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ទា"),
            keywords: &["ទា", "បក\u{17d2}ស\u{17b8}"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬಾತುಕೋಳ\u{cbf}"),
            keywords: &["ಪಕ\u{ccd}ಷ\u{cbf}", "ಬಾತುಕೋಳ\u{cbf}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("오리"),
            keywords: &["새", "오리", "조류"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("बदक"),
            keywords: &["बदक", "स\u{941}कण\u{947}\u{902}"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("өрдөк"),
            keywords: &["канаттуу", "өрдөк"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Int"),
            keywords: &["Int", "Vugel"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເປ\u{eb1}ດ"),
            keywords: &["ນ\u{ebb}ກ", "ເປ\u{eb1}ດ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("antis"),
            keywords: &["antis", "paukštis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("pīle"),
            keywords: &["putns", "pīle"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("parera"),
            keywords: &["manu", "parera"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("патка"),
            keywords: &["патка", "птица"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ത\u{d3e}റ\u{d3e}വ\u{d4d}"),
            keywords: &["ത\u{d3e}റ\u{d3e}വ\u{d4d}", "പക\u{d4d}ഷി"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("нугас"),
            keywords: &["нугас", "шувуу"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("बदक"),
            keywords: &["पक\u{94d}षी", "बदक"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("itik"),
            keywords: &["burung", "itik"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("papra"),
            keywords: &["għasfur", "papra"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဘ\u{1032}"),
            keywords: &["င\u{103e}က\u{103a}", "ဘ\u{1032}"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("and"),
            keywords: &["and", "dyr", "fugl"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("हा\u{901}स"),
            keywords: &["चरा", "हा\u{901}स"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("eend"),
            keywords: &["eend", "vogel"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("and"),
            keywords: &["and", "dyr", "fugl"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବତକ"),
            keywords: &["ବତକ", "ବତକ । ପକ\u{b4d}ଷୀ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬ\u{a71}ਤਖ"),
            keywords: &["ਪ\u{a70}ਛੀ", "ਬ\u{a71}ਤਖ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("بطخ"),
            keywords: &["بطخ", "پنچھی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Dọk"),
            keywords: &["Bẹd", "Dọk"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kaczka"),
            keywords: &["kaczka", "ptak"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("هيلۍ"),
            keywords: &["مرغه، هيلۍ", "هيلۍ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("pato"),
            keywords: &["pato", "pássaro"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["ave", "pato"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("pili"),
            keywords: &["pili", "p’isqu"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("rață"),
            keywords: &["pasăre", "rață"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1102"),
            keywords: &["E10-1102"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("утка"),
            keywords: &["птица", "селезень", "утка"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("igishuhe"),
            keywords: &["igishuhe", "imbata", "inyoni"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("بدڪ"),
            keywords: &["بدڪ", "بدڪ، پکي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ත\u{dcf}ර\u{dcf}ව"),
            keywords: &["ක\u{dd4}ර\u{dd4}ල\u{dca}ල\u{dcf}", "ත\u{dcf}ර\u{dcf}ව"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("kačka"),
            keywords: &["kačica", "kačka", "vták"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("raca"),
            keywords: &["ptica", "raca"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("muwaata"),
            keywords: &["muwaata", "shimbir"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("rosak"),
            keywords: &["rosak", "zog"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("патка"),
            keywords: &["патка", "птица"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("patka"),
            keywords: &["patka", "ptica"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("and"),
            keywords: &["and", "fågel"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("bata"),
            keywords: &["bata", "ndege"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வ\u{bbe}த\u{bcd}து"),
            keywords: &["பறவை", "வ\u{bbe}த\u{bcd}து"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("బ\u{c3e}తు"),
            keywords: &["పక\u{c4d}ష\u{c3f}", "బ\u{c3e}తు"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("мурғобӣ"),
            keywords: &["мурғобӣ", "парранда"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เป\u{e47}ด"),
            keywords: &["นก", "เป\u{e47}ด"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ördek"),
            keywords: &["guş", "ördek"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("pato"),
            keywords: &["pato"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("ördek"),
            keywords: &["kuş", "ördek"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئۆردەك"),
            keywords: &["ئۆردەك", "قۇش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("качка"),
            keywords: &["качка", "птах"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بطخ"),
            keywords: &["بطخ", "پرندہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("o‘rdak"),
            keywords: &["oʻrdak", "o‘rdak", "parranda"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("vịt"),
            keywords: &["chim", "vịt"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kanaara"),
            keywords: &["kanaara", "picc"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("idada"),
            keywords: &["idada", "intaka"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Pẹ\u{301}pẹ\u{301}yẹ"),
            keywords: &["Pẹ\u{301}pẹ\u{301}yẹ", "pẹ\u{301}pẹ\u{301}yẹ", "ẹyẹ"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("鴨"),
            keywords: &["雀", "鴨"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("鸭"),
            keywords: &["雀", "鸭"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("鸭子"),
            keywords: &["鸟", "鸭", "鸭子"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("鴨子"),
            keywords: &["鳥", "鴨", "鴨子"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("idada"),
            keywords: &["idada", "inyoni"],
        },
    ],
};
#[doc = "🦢"]
pub const SWAN: crate::Emoji = crate::Emoji {
    glyph: "🦢",
    codepoint: "1F9A2",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "swan",
    group: "Animals & Nature",
    subgroup: "animal-bird",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("swaan"),
            keywords: &["lelike eendjie", "swaan", "swaankuiken", "voël"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የውሀ ዶሮ"),
            keywords: &["ትንሽ ዝዬ", "አስቀያሚ ዳክዬ", "ወፍ", "የውሀ ዶሮ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("إوزة"),
            keywords: &["إوز", "إوز عراقي", "إوزة", "بجعة", "تم", "طائر", "فرخ"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ৰ\u{9be}জহ\u{9be}\u{981}হ"),
            keywords: &[
                "ক\u{9c1}ৰ\u{9c2}প\u{9be} হ\u{9be}\u{981}হ",
                "চিগনেট",
                "চৰ\u{9be}ই",
                "ৰ\u{9be}জহ\u{9be}\u{981}হ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qu"),
            keywords: &["qu", "qu balası", "quş", "suya girmə"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("лебедзь"),
            keywords: &["агіднае качаня", "лебедзь", "птушка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("лебед"),
            keywords: &["грозното патенце", "лебед", "лебедова шия", "птица"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("র\u{9be}জহ\u{9be}\u{981}স"),
            keywords: &[
                "অর\u{9c1}প হংসশ\u{9be}বক",
                "প\u{9be}খি",
                "মর\u{9be}লশ\u{9be}বক",
                "র\u{9be}জহ\u{9be}\u{981}স",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("alarcʼh"),
            keywords: &["alarcʼh", "evn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("labud"),
            keywords: &["labud", "mladi labud", "ptica", "ružno pače"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cigne"),
            keywords: &["aneguet lleig", "cigne", "ocell"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏍᎨᏆ"),
            keywords: &["ᎠᏓᎨ ᎠᏓ", "ᎤᏁᎩᎸᏗ ᎧᏬᏄ ᎠᏓ", "ᏍᎨᏆ", "ᏥᏍᏆ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("labuť"),
            keywords: &["bílý", "labuť", "ošklivé káčátko", "pták", "vznešený"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("alarch"),
            keywords: &["aderyn", "alarch", "cyw alarch", "hwyaden fach hyll"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("svane"),
            keywords: &["fugl", "grim ælling", "svane", "svaneunge"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Schwan"),
            keywords: &["Schwan", "Vogel", "hässliches Entlein"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κύκνος"),
            keywords: &["ασχημόπαπο", "κύκνος", "μωρό κύκνου", "πτηνό"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("swan"),
            keywords: &["bird", "cygnet", "swan", "ugly duckling"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cisne"),
            keywords: &["ave", "cisne", "patito feo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("cisne"),
            keywords: &["animal", "ave", "cisne", "patito feo"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("cisne"),
            keywords: &["cisne"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("luik"),
            keywords: &["inetu pardipoeg", "lind", "luigepoeg", "luik"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("zisne"),
            keywords: &["ahatetxo itsusi", "txori", "zisne", "zisne txiki"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("قو"),
            keywords: &[
                "بچه قو",
                "جوجه اردک زشت",
                "جوجه\u{654} قو",
                "قو",
                "قوبچه",
                "پرنده",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("joutsen"),
            keywords: &["joutsen", "lintu", "ruma ankanpoikanen"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("swan"),
            keywords: &["ibon", "ibong mahaba ang leeg", "swan", "ugly duckling"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("svanur"),
            keywords: &["fuglur", "okn", "svanur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("cygne"),
            keywords: &[
                "animal",
                "cygne",
                "jeune cygne",
                "oiseau",
                "vilain petit canard",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["cygne", "jeune cygne", "oiseau", "vilain petit canard"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("eala"),
            keywords: &["eala", "lachín ghránna", "éan"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("eala"),
            keywords: &["eala", "ealag", "eun", "isean grannda"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cisne"),
            keywords: &["ave", "cisne", "parruliño feo", "parrulo feo", "patiño feo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("હ\u{a82}સ"),
            keywords: &[
                "નાની બતક",
                "પક\u{acd}ષી",
                "હ\u{a82}સ",
                "હ\u{a82}સન\u{ac1}\u{a82} બચ\u{acd}ચ\u{ac1}\u{a82}",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("ברבור"),
            keywords: &["ברבור", "הברווזון המכוער", "עופות מים", "ציפור"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ह\u{902}स"),
            keywords: &[
                "छिपा र\u{941}स\u{94d}तम",
                "पक\u{94d}षी",
                "ह\u{902}स",
                "ह\u{902}सशावक",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("labud"),
            keywords: &["labud", "ptica", "ružno pače"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("hattyú"),
            keywords: &["fiatal hattyú", "hattyú", "madár", "rút kiskacsa"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կարապ"),
            keywords: &["անճոռնի ճուտիկ", "թռչուն", "կարապ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("angsa"),
            keywords: &["angsa", "angsa muda", "burung", "itik buruk rupa"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("svanur"),
            keywords: &["fugl", "ljóti andarunginn", "svanur", "álft", "álftarungi"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("cigno"),
            keywords: &["brutto anatroccolo", "cigno", "uccello", "volatile"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("白鳥"),
            keywords: &["ひな", "みにくいアヒルの子", "白鳥", "鳥"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("banyak"),
            keywords: &["angsa", "banyak", "bebek ala", "unggas"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("გედი"),
            keywords: &["გედი", "მყივანი", "სისინა", "ფრინველი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("аққу"),
            keywords: &["аққу", "жас аққу", "сұмпайы үйрек балапаны", "құс"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ហង\u{17d2}ស"),
            keywords: &[
                "ក\u{17bc}នទារ\u{17bc}បអាក\u{17d2}រក\u{17cb}",
                "ក\u{17bc}នហង\u{17d2}ស",
                "បក\u{17d2}ស\u{17b8}",
                "ហង\u{17d2}ស",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಹಂಸ"),
            keywords: &[
                "ಅಗ\u{ccd}ಲ\u{cbf} ಡಕ\u{ccd}ಲ\u{cbf}ಂಗ\u{ccd}",
                "ಪಕ\u{ccd}ಷ\u{cbf}",
                "ಸೈಗ\u{ccd}ನ\u{cc6}ಟ\u{ccd}",
                "ಹಂಸ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("백조"),
            keywords: &["못난 아기 오리", "백조", "새끼 백조", "조류"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ह\u{902}स"),
            keywords: &[
                "क\u{941}र\u{941}प बदक",
                "स\u{941}कण\u{947}\u{902}",
                "ह\u{902}स",
                "ह\u{902}सापिल",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("ак куу"),
            keywords: &["ак куу", "ак куунун балапаны", "ырайы суу балапан"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຫ\u{ec8}ານ"),
            keywords: &[
                "ນ\u{ebb}ກ",
                "ລ\u{eb9}ກເປ\u{eb1}ດ",
                "ຫ\u{ec8}ານ",
                "ເປ\u{eb1}ດນ\u{ec9}ອຍຂ\u{eb5}ລ\u{ec9}າຍ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("gulbė"),
            keywords: &["bjaurusis ančiukas", "gulbė", "paukštis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("gulbis"),
            keywords: &["gulbis", "jauns gulbis", "neglītais pīlēns", "putns"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("лебед"),
            keywords: &["грдо пајче", "лебед", "млад лебед", "птица"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("അരയന\u{d4d}നം"),
            keywords: &[
                "അരയന\u{d4d}നം",
                "അരയന\u{d4d}നക\u{d4d}ക\u{d41}ഞ\u{d4d}ഞ\u{d4d}",
                "പക\u{d4d}ഷി",
                "വ\u{d43}ത\u{d4d}തിയില\u{d4d}ല\u{d3e}ത\u{d4d}ത ക\u{d41}ട\u{d4d}ടിത\u{d4d}ത\u{d3e}റ\u{d3e}വ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хун"),
            keywords: &["залуу хун", "нугасны муухай дэгдээхэй", "хун", "шувуу"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ह\u{902}स"),
            keywords: &[
                "अग\u{94d}ली डक\u{94d}लि\u{902}ग",
                "पक\u{94d}षी",
                "सिग\u{94d}न\u{947}ट",
                "ह\u{902}स",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("angsa"),
            keywords: &["anak angsa", "anak itik hodoh", "angsa", "burung"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ငန\u{103a}း"),
            keywords: &[
                "ငန\u{103a}း",
                "ငန\u{103a}းပေါက\u{103a}စ",
                "င\u{103e}က\u{103a}",
                "ဒေါင\u{103a}းမျ\u{102d}\u{102f}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("svane"),
            keywords: &["den stygge andungen", "fugl", "svane"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("रजहा\u{901}स"),
            keywords: &[
                "घिनलाग\u{94d}दो टिउ\u{901}रो",
                "चरा",
                "बच\u{94d}चा रजहा\u{901}स",
                "रजहा\u{901}स",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("zwaan"),
            keywords: &["lelijk eendje", "vogel", "zwaan", "zwanenjong"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("svane"),
            keywords: &["den stygge andungen", "fugl", "svane"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ହଂସ"),
            keywords: &[
                "ଅସ\u{b41}ନ\u{b4d}ଦର ବତକ ଛ\u{b41}ଆ",
                "ପକ\u{b4d}ଷୀ",
                "ଶ\u{b3e}ଇଗନେଟ\u{b4d}\u{200c}",
                "ହଂସ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਹ\u{a70}ਸ"),
            keywords: &[
                "ਪ\u{a70}ਛੀ",
                "ਬ\u{a71}ਤਖ ਦਾ ਬਦਸ\u{a42}ਰਤ ਬ\u{a71}ਚਾ",
                "ਸਾਈਗਨ\u{a48}\u{a71}ਟ",
                "ਹ\u{a70}ਸ",
                "ਹ\u{a70}ਸ ਦਾ ਬ\u{a71}ਚਾ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Bẹd Wé Im Nem Na Swan"),
            keywords: &[
                "Bẹd",
                "Bẹd Wé Im Nem Na Swan",
                "Swan Pikin",
                "Wọ\u{301}n Bẹd Wé Im Nem Na Swan",
                "Ọ\u{301}glí Yọ\u{301}ng Dọk",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("łabędź"),
            keywords: &["brzydkie kaczątko", "ptak", "łabędź"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("قو"),
            keywords: &["قو", "مرغه، سيګنت، قو، بدشکله د هيلۍ بچی"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("cisne"),
            keywords: &["cisne", "patinho feio", "pássaro"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["cisne", "patinho feio", "pinto de cisne"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("cisne"),
            keywords: &[
                "cisne",
                "huchuy pili",
                "millana",
                "pisqʼu",
                "pollo cisnemanta",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("lebădă"),
            keywords: &["lebădă", "pasăre", "rățușca cea urâtă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E11-032"),
            keywords: &["E11-032"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("лебедь"),
            keywords: &[
                "белый лебедь",
                "водоплавающее",
                "гадкий утенок",
                "лебедь",
                "птица",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("سوان"),
            keywords: &["بدصورت بدڪ", "سائيگنيٽ", "سوان", "پکي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("හංසය\u{dcf}"),
            keywords: &[
                "කැත ත\u{dcf}ර\u{dcf}ව\u{dcf}",
                "ක\u{dd4}ර\u{dd4}ල\u{dca}ල\u{dcf}",
                "හංසය පැට\u{dd2}ය\u{dcf}",
                "හංසය\u{dcf}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("labuť"),
            keywords: &["labuť", "vták", "škaredé káčatko"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("labod"),
            keywords: &["grdi raček", "labod", "mlad labod", "ptica"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("booloboolo"),
            keywords: &["booloboolo", "cunug booloboolo", "cunug muwaata", "shimbir"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("mjellmë"),
            keywords: &["mjellmë", "shpend shtegtues"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("лабуд"),
            keywords: &["лабуд", "птица", "ружно паче"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("labud"),
            keywords: &["labud", "ptica", "ružno pače"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("svan"),
            keywords: &["den fula ankungen", "fågel", "svan"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("bata maji"),
            keywords: &["bata", "bata maji", "mtoto wa bata", "ndege"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("அன\u{bcd}னம\u{bcd}"),
            keywords: &[
                "அன\u{bcd}னக\u{bcd} குஞ\u{bcd}சு",
                "அன\u{bcd}னப\u{bcd}பறவைக\u{bcd} குஞ\u{bcd}சு",
                "அன\u{bcd}னம\u{bcd}",
                "பறவை",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("హంస"),
            keywords: &[
                "అగ\u{c4d}ల\u{c40} డక\u{c4d}ల\u{c3f}ంగ\u{c4d}",
                "పక\u{c4d}ష\u{c3f}",
                "స\u{c3f}గ\u{c4d}న\u{c46}ట\u{c4d}",
                "హంస",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หงส\u{e4c}"),
            keywords: &[
                "นก",
                "ล\u{e39}กเป\u{e47}ดข\u{e35}\u{e49}เหร\u{e48}",
                "หงส\u{e4c}",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("guw"),
            keywords: &["guw", "guş", "myrtar ördejik", "ýaş guw"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("patolahi"),
            keywords: &["patolahi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kuğu"),
            keywords: &["kuğu", "kuğu yavrusu", "kuş", "çirkin ördek yavrusu"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("лебідь"),
            keywords: &["гидке каченя", "лебідь", "озеро", "птах"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("راج ہنس"),
            keywords: &["بدصورت بط بچہ", "جوان ہنس", "راج ہنس", "پرندہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("oqqush"),
            keywords: &[
                "irkit o‘rdakcha",
                "oqqush",
                "parranda",
                "qush",
                "suvda suzuvchi",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("thiên nga"),
            keywords: &["chim", "thiên nga", "thiên nga non", "vịt con xấu xí"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("天鵝"),
            keywords: &["天鵝", "小天鵝", "醜小鴨", "雀"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("天鹅"),
            keywords: &["丑小鸭", "天鹅", "小天鹅", "雀"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("天鹅"),
            keywords: &["丑小鸭", "天鹅", "小天鹅", "鸟"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("天鵝"),
            keywords: &["天鵝", "小天鵝", "醜小鴨", "鳥"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("cygnet"),
            keywords: &["cygnet", "idada", "idada elibi", "inyoni"],
        },
    ],
};
#[doc = "🦉"]
pub const OWL: crate::Emoji = crate::Emoji {
    glyph: "🦉",
    codepoint: "1F989",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "owl",
    group: "Animals & Nature",
    subgroup: "animal-bird",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("uil"),
            keywords: &["oud", "uil", "voël", "wys"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ጉጉት"),
            keywords: &["አዋቂ", "ወፍ", "ጉጉት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("بومة"),
            keywords: &["بومة", "طائر"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ফে\u{981}চ\u{9be}"),
            keywords: &["চৰ\u{9be}ই", "জ\u{9cd}ঞ\u{9be}নী", "ফে\u{981}চ\u{9be}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("bayquş"),
            keywords: &["bayquş", "müdrik", "quş"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("сава"),
            keywords: &["мудрасць", "птушка", "сава"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("бухал"),
            keywords: &["бухал", "мъдрост", "птица"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("পে\u{981}চ\u{9be}"),
            keywords: &["প\u{9be}খি", "পে\u{981}চ\u{9be}", "বিজ\u{9cd}ঞ"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kaouenn"),
            keywords: &["evn", "kaouenn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("sova"),
            keywords: &["mudrost", "ptica", "sova"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("mussol"),
            keywords: &["animal", "au", "mussol", "ocell"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄛𑄬𑄎"),
            keywords: &["𑄛𑄬𑄎"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᎫᎫ"),
            keywords: &["ᎠᏓᏪ", "ᎤᎫᎫ", "ᏥᏍᏆ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("sova"),
            keywords: &["moudrost", "pták", "sova"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("tylluan"),
            keywords: &["aderyn", "doeth", "tylluan"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("ugle"),
            keywords: &["dyr", "fugl", "klog", "klogskab", "ugle", "vis", "visdom"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Eule"),
            keywords: &["Eule", "Vogel", "weise"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κουκουβάγια"),
            keywords: &["κουκουβάγια", "πτηνό", "σοφός"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("owl"),
            keywords: &["bird", "owl", "wise"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["bird of prey", "owl", "wise"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("búho"),
            keywords: &["ave", "búho", "lechuza", "pájaro"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["animal", "ave", "búho", "lechuza"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["ave", "búho", "inteligente", "lechuza", "sabio"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("öökull"),
            keywords: &["lind", "öökull"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("hontza"),
            keywords: &["hontz", "hontza", "jakitun"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("جغد"),
            keywords: &["بیدار", "جغد", "خردمند", "شب زنده دار", "پرنده"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("pöllö"),
            keywords: &["lintu", "pöllö", "viisas"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("kuwago"),
            keywords: &["ibon", "kuwago", "matalino"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("ugla"),
            keywords: &["dýr", "fuglur", "gløgg", "klók", "ugla"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("chouette"),
            keywords: &["animal", "chouette", "oiseau"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("ulchabhán"),
            keywords: &["críonna", "ulchabhán", "éan"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cailleach-oidhche"),
            keywords: &["cailleach-oidhche", "eun", "glic"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("moucho"),
            keywords: &["animal", "curuxa", "moucho", "paxaro", "sabio"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ઘ\u{ac1}વડ"),
            keywords: &["ઘ\u{ac1}વડ", "પક\u{acd}ષી", "બ\u{ac1}દ\u{acd}ધિમાન"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mujiya"),
            keywords: &["mai hikima", "mujiya", "tsuntsu"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("ינשוף"),
            keywords: &["חוכמה", "ינשוף", "ציפור"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("उल\u{94d}ल\u{942}"),
            keywords: &["उल\u{94d}ल\u{942}", "पक\u{94d}षी", "ब\u{941}द\u{94d}धिमान"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("sova"),
            keywords: &["mudrost", "ptica", "sova"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("bagoly"),
            keywords: &["bagoly", "bölcs", "madár"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բու"),
            keywords: &["բու", "թռչուն", "իմաստուն"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("burung hantu"),
            keywords: &["bijaksana", "burung", "burung hantu"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ikwikwi"),
            keywords: &["ikwikwi", "nnụnụ", "nwere uche"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("ugla"),
            keywords: &["fugl", "ugla"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("gufo"),
            keywords: &["animale", "fortuna", "gufo", "saggezza", "uccello"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("フクロウ"),
            keywords: &["フクロウ", "動物", "鳥"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("guwek"),
            keywords: &["guwek", "manuk", "wicaksana"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ბუ"),
            keywords: &["ბრძენი", "ბუ", "ჩიტი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жапалақ"),
            keywords: &["жапалақ", "құс"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("ugle"),
            keywords: &["dyr", "fugl", "klog", "klogskab", "ugle", "vis", "visdom"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ទ\u{17b8}ទ\u{17bb}យ"),
            keywords: &[
                "ឆ\u{17d2}លាតវៃ",
                "ទ\u{17b8}ទ\u{17bb}យ",
                "បក\u{17d2}ស\u{17b8}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಗ\u{cc2}ಬ\u{cc6}"),
            keywords: &["ಅಪಶಕುನ", "ಗ\u{cc2}ಬ\u{cc6}", "ಪಕ\u{ccd}ಷ\u{cbf}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("부엉이"),
            keywords: &["부엉이", "새", "올빼미", "조류"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("घ\u{941}बड"),
            keywords: &["घ\u{941}बड", "स\u{941}कण\u{947}\u{902}", "ह\u{941}शार"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("үкү"),
            keywords: &["акылмандуулук", "канаттуу", "үкү"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Eil"),
            keywords: &["Eil", "Vugel", "klug"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ນ\u{ebb}ກເຄ\u{ebb}\u{ec9}າ"),
            keywords: &["ນ\u{ebb}ກ", "ນ\u{ebb}ກເຄ\u{ebb}\u{ec9}າ", "ສະຫ\u{ebc}າດ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("pelėda"),
            keywords: &["išmintis", "paukštis", "pelėda"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("pūce"),
            keywords: &["gudrs", "putns", "pūce", "vieds"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("ruru"),
            keywords: &["manu", "mōhio", "ruru"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("був"),
            keywords: &["був", "мудрост"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മ\u{d42}ങ\u{d4d}ങ"),
            keywords: &["പക\u{d4d}ഷി", "മ\u{d42}ങ\u{d4d}ങ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("шар шувуу"),
            keywords: &["цэцэн", "шар шувуу", "шувуу"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("घ\u{941}बड"),
            keywords: &["घ\u{941}बड", "पक\u{94d}षी", "समज\u{942}तदार"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("burung hantu"),
            keywords: &["bijak", "burung", "burung hantu"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("kokka"),
            keywords: &["għaqli", "għasfur", "kokka"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဇ\u{102e}းက\u{103d}က\u{103a}"),
            keywords: &[
                "င\u{103e}က\u{103a}",
                "ဇ\u{102e}းက\u{103d}က\u{103a}",
                "ပညာရ\u{103e}\u{102d}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("ugle"),
            keywords: &["dyr", "fugl", "ugle", "vis"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("उल\u{94d}ल\u{941}"),
            keywords: &["उल\u{94d}ल\u{941}", "चरा", "ब\u{941}द\u{94d}दिमान"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("uil"),
            keywords: &["uil", "vogel", "wijs", "wijsheid"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("ugle"),
            keywords: &["dyr", "fugl", "ugle", "vis"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପେଚ\u{b3e}"),
            keywords: &[
                "ପେଚ\u{b3e}",
                "ପେଚ\u{b3e} । ଜ\u{b4d}ଞ\u{b3e}ନୀ । ପକ\u{b4d}ଷୀ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਉ\u{a71}ਲ\u{a42}"),
            keywords: &["ਉ\u{a71}ਲ\u{a42}", "ਪ\u{a70}ਛੀ", "ਬ\u{a41}\u{a71}ਧੀਮਾਨ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("الو"),
            keywords: &["الو", "عقلمند", "پنچھی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Aul"),
            keywords: &["Aul", "Bẹd", "Waiz"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("sowa"),
            keywords: &["mądrość", "ptak", "sowa"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("کونګ"),
            keywords: &["مرغه، کونګ، اوښيار", "کونګ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("coruja"),
            keywords: &["coruja", "pássaro", "sabedoria"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("mocho"),
            keywords: &["coruja", "mocho", "pássaro", "sensato"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("búho"),
            keywords: &["amawta", "búho", "p’isqu"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("bufniță"),
            keywords: &["bufniță", "de noapte", "pasăre", "înțelept"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1105"),
            keywords: &["E10-1105"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("сова"),
            keywords: &["мудрость", "птица", "сова", "филин"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("igihunyira"),
            keywords: &["igihunyira", "igihunyira gikerebutse", "inyoni"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("چٻرو"),
            keywords: &["چٻرو", "چٻرو، سياڻو، پکي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("බකම\u{dd4}හ\u{dd4}ණ\u{dcf}"),
            keywords: &[
                "ක\u{dd4}ර\u{dd4}ල\u{dca}ල\u{dcf}",
                "පණ\u{dca}ඩ\u{dd2}තය\u{dcf}",
                "බකම\u{dd4}හ\u{dd4}ණ\u{dcf}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("sova"),
            keywords: &["múdrosť", "sova", "vták"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("sova"),
            keywords: &["pamet", "ptica", "sova"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("guumays"),
            keywords: &["caqli", "guumays", "shimbir"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("buf"),
            keywords: &["buf", "urtësi", "zog"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("сова"),
            keywords: &["мудрост", "птица", "сова"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["сова"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("sova"),
            keywords: &["mudrost", "ptica", "sova"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["sova"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("uggla"),
            keywords: &["fågel", "uggla", "vis"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("bundi"),
            keywords: &["bundi", "ndege"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஆந\u{bcd}தை"),
            keywords: &["ஆந\u{bcd}தை", "பறவை"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("గుడ\u{c4d}లగూబ"),
            keywords: &[
                "గుడ\u{c4d}లగూబ",
                "త\u{c46}ల\u{c3f}వ\u{c48}న",
                "పక\u{c4d}ష\u{c3f}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("бум"),
            keywords: &["бум", "парранда", "хирадманд"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("นกฮ\u{e39}ก"),
            keywords: &[
                "ตาโต",
                "นก",
                "นกฮ\u{e39}ก",
                "นอนไม\u{e48}หล\u{e31}บ",
                "เค\u{e49}าแมว",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("baýguş"),
            keywords: &["akyldar", "baýguş", "guş"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("lulu"),
            keywords: &["lulu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("baykuş"),
            keywords: &["baykuş", "bilge", "kuş"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("مۈشۈكياپىلاق"),
            keywords: &["ئەقىللىق", "قۇش", "مۈشۈكياپىلاق"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("сова"),
            keywords: &["мудрість", "птах", "сова"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("الو"),
            keywords: &["الو", "عقلمند", "پرندہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("boyqush"),
            keywords: &["boyqush", "donolik", "qush"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("cú"),
            keywords: &["chim", "cú", "khôn ngoan"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("looy"),
            keywords: &["looy", "picc", "xelu"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isikhova"),
            keywords: &["intaka", "isikhova", "lumkileyo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Owiwi"),
            keywords: &["Owiwi", "òwìwí", "ẹyẹ", "ọlọ\u{301}ngbọ\u{301}n"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("貓頭鷹"),
            keywords: &["智慧", "貓頭鷹", "雀"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("猫头鹰"),
            keywords: &["智慧", "猫头鹰", "雀"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("猫头鹰"),
            keywords: &["猫头鹰", "睿智", "鸟"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("貓頭鷹"),
            keywords: &["智慧", "貓頭應", "貓頭鷹", "鳥"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["智慧", "貓頭鷹", "鳥"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isikhova"),
            keywords: &["hlakanipha", "inyoni", "isikhova"],
        },
    ],
};
#[doc = "🦤"]
pub const DODO: crate::Emoji = crate::Emoji {
    glyph: "🦤",
    codepoint: "1F9A4",
    status: crate::Status::FullyQualified,
    introduction_version: 13f32,
    name: "dodo",
    group: "Animals & Nature",
    subgroup: "animal-bird",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("dodo"),
            keywords: &["Mauritius", "dodo", "groot", "uitgestorwe"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ትልቅ ወፍ"),
            keywords: &["ትልቅ ወፍ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("طائر الدودو"),
            keywords: &[
                "حيوان منقرض",
                "ضخم",
                "طائر",
                "طائر الدودو",
                "منقرض",
                "موريشيوس",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ড’ড’"),
            keywords: &["ড\u{9be}ঙৰ", "ড’ড’", "বিল\u{9c1}প\u{9cd}ত", "মৰিচ\u{9be}চ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("dodo"),
            keywords: &["Mavriki", "böyük", "dodo", "yox olma"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("дадо"),
            keywords: &["вялікі", "дадо", "маўрыкійскі дронт", "чырвоная кніга"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Додо"),
            keywords: &["Додо", "Мавриций", "голям", "изчезване"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ডোডো"),
            keywords: &["ডোডো", "বড\u{9bc}", "বিলোপ", "মরিশ\u{9be}স"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("dodo"),
            keywords: &["Moris", "dodo"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("dodo"),
            keywords: &["Mauricijus", "dodo", "izumiranje", "veliki dodo"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("dodo"),
            keywords: &["Maurici", "au", "dodo", "extinció", "gran"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏙᏙ"),
            keywords: &["ᎡᏆ", "ᎤᏲᎱᏒ", "ᎹᎵᏏᎥᏍ", "ᏙᏙ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("dodo"),
            keywords: &[
                "Mauricius",
                "blboun",
                "dodo",
                "dronte",
                "nejapný",
                "pták",
                "velký",
                "vyhynulý",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("dodo"),
            keywords: &["Mawrisiws", "diflanedig", "dodo", "mawr"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("dronte"),
            keywords: &["Mauritius", "dronte", "kæmpefugl", "uddød", "udryddet"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Dodo"),
            keywords: &["Aussterben", "Dodo", "Mauritius", "groß"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: None,
            keywords: &["Dodo"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ντόντο"),
            keywords: &["Μαυρίκιος", "εξαφάνιση", "μεγάλο", "ντόντο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("dodo"),
            keywords: &["Mauritius", "dodo", "extinction", "large"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("dodo"),
            keywords: &["Mauricio", "ave", "dodo", "dronte", "extinguido", "pájaro"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("dodo"),
            keywords: &["dodo"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("dodo"),
            keywords: &["dodo"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("dodo"),
            keywords: &["Mauritius", "dodo", "lind", "suur", "väljasurev"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("dodoa"),
            keywords: &["Maurizio", "desagerpena", "dodo", "dodoa", "handia"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دودو"),
            keywords: &["انقراض", "انهدام", "بزرگ", "جزیره موریس", "دودو"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("dodo"),
            keywords: &["Mauritius", "dodo", "lentokyvytön", "sukupuutto"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("dodo"),
            keywords: &["Mauritius", "dodo", "malaki", "pagkaubos", "pagkawala"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("dronta"),
            keywords: &["Mauritius", "dronta", "fuglur", "útdeyður"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("dodo"),
            keywords: &["Maurice", "dodo", "extinction", "grand"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("dodo"),
            keywords: &["Maurice", "dodo", "extinction", "gros oiseau"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("dódó"),
            keywords: &["Oileán Mhuirís", "dódó", "mór", "éag"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("dòdo"),
            keywords: &[
                "Mhoiriseas",
                "Moiriseas",
                "dìtheachd",
                "dòdo",
                "marbh",
                "mòr",
                "à bith",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("dodo"),
            keywords: &["Mauricio", "ave", "dodo", "extinta"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ડોડો"),
            keywords: &["ડોડો", "નાશ પામવ\u{ac1}\u{a82}", "મોરિશિયસ", "વિશાળ"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("ציפור דודו"),
            keywords: &["זן נכחד", "מאוריציוס", "ציפור גדולה", "ציפור דודו"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("डोडो"),
            keywords: &["डोडो", "बड\u{93c}ा", "मॉरिशस", "विल\u{941}प\u{94d}त"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("dodo"),
            keywords: &["Mauricijus", "dodo", "izumrlo", "veliko"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("dodó"),
            keywords: &["Mauritius", "dodó", "kihalt", "madár", "nagy"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("դոդո"),
            keywords: &["Մավրիկիոս", "անհետացում", "դոդո", "մեծ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("dodo"),
            keywords: &["Mauritius", "besar", "dodo", "punah"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("dúdúfugl"),
            keywords: &["Márítíus", "dúdúfugl", "stór", "útdauði"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("dodo"),
            keywords: &["Mauritius", "dodo", "estinzione", "grande"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ドードー"),
            keywords: &["ドードー", "モーリシャス島", "絶滅", "飛べない鳥", "鳥"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("manuk dodo"),
            keywords: &["Mauritus", "gedhe", "manuk dodo", "punah"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("დოდო"),
            keywords: &["გადაშენება", "დოდო", "მავრიკი", "მავრიკული დრონტი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("дронт"),
            keywords: &["Маврикий", "дронт", "жойылу", "ірі"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ដ\u{17bc}ដ\u{17bc}"),
            keywords: &[
                "ការផ\u{17bb}តព\u{17bc}ជ",
                "ដ\u{17bc}ដ\u{17bc}",
                "ធ\u{17c6}",
                "ម\u{17c9}\u{17bc}រ\u{17b8}ទ\u{17bb}ស",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಡೊಡೊ"),
            keywords: &["ಅಳ\u{cbf}ವು", "ಡೊಡೊ", "ದೊಡ\u{ccd}ಡದು", "ಮಾರೀಷಸ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("도도새"),
            keywords: &["도도새", "멸종", "모리셔스", "큰 새"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("डोडो"),
            keywords: &["डोडो", "नश\u{94d}ट जावप", "मॉरिशस", "व\u{94d}हड"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("додо"),
            keywords: &["додо"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ນ\u{ebb}ກ\u{200b}ໂດ\u{200b}ໂດ"),
            keywords: &[
                "ນ\u{ebb}ກ",
                "ນ\u{ebb}ກ\u{200b}ໂດ\u{200b}ໂດ",
                "ມ\u{ebb}ວຣ\u{eb4}ຊຽສ",
                "ສ\u{eb9}ນ\u{200b}ພ\u{eb1}ນ",
                "ໃຫຍ\u{ec8}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("drontas"),
            keywords: &["Mauricijus", "didelis", "drontas", "išnykimas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("dodo"),
            keywords: &["Maurīcija", "dodo", "izmiršana", "liels"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("додо"),
            keywords: &["Маврициус", "големи", "додо", "истребени"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഡോഡോ പക\u{d4d}ഷി"),
            keywords: &[
                "ഡോഡോ പക\u{d4d}ഷി",
                "മ\u{d57}റീഷ\u{d4d}യസ\u{d4d}",
                "വംശന\u{d3e}ശം",
                "വലിയ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("додо шувуу"),
            keywords: &["Маврики", "додо шувуу", "мөхсөн", "том"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("डोडो"),
            keywords: &["डोडो", "मॉरिशस", "मोठा", "विल\u{941}प\u{94d}त होण\u{947}"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("dodo"),
            keywords: &["Mauritius", "besar", "dodo", "kepupusan"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဒ\u{102d}\u{102f}ဒ\u{102d}\u{102f}"),
            keywords: &[
                "ကြ\u{102e}းမား",
                "ဒ\u{102d}\u{102f}ဒ\u{102d}\u{102f}",
                "မော\u{103a}ရေးရ\u{103e}ပ\u{103a}",
                "မျ\u{102d}\u{102f}းသ\u{102f}ဉ\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("dronte"),
            keywords: &["Mauritius", "dodo", "dronte", "stor", "utdødd"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("डोडो"),
            keywords: &["ठ\u{942}लो", "डोडो", "मरिसियस", "विलोप"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("dodo"),
            keywords: &["Mauritius", "dodo", "groot", "uitsterven"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("dronte"),
            keywords: &["Mauritius", "dodo", "dronte", "stor", "utdøydd"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଡ\u{b3c}ୋଡ\u{b3c}ୋ"),
            keywords: &[
                "ଡ\u{b3c}ୋଡ\u{b3c}ୋ",
                "ବଡ\u{b3c}",
                "ବ\u{b3f}ଲ\u{b41}ପ\u{b4d}ତ\u{b3f}",
                "ମର\u{b3f}ସସ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਡ\u{a4b}ਡ\u{a4b}"),
            keywords: &[
                "ਅਲ\u{a4b}ਪ",
                "ਡ\u{a4b}ਡ\u{a4b}",
                "ਮਾਰੀਸ\u{a3c}ਸ",
                "ਵਿਲ\u{a41}ਪਤ",
                "ਵ\u{a71}ਡਾ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Dódo"),
            keywords: &[
                "Big",
                "Dódo",
                "Mọríshius",
                "Nọ\u{301} Dé Agen",
                "Wọ\u{301}n Bẹd Wé Im Nem Na Dódo",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("dodo"),
            keywords: &["Mauritius", "dodo", "duży", "wymarły"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ډوډو"),
            keywords: &["ختمديل", "لوی", "ماريشس", "ډوډو"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("dodô"),
            keywords: &["Maurício", "dodô", "extinto", "grande"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("dodó"),
            keywords: &["Maurícias", "dodó", "extinto", "grande"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("dodo"),
            keywords: &["Mauricio", "dodo", "extinsion", "hatun"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("dodo"),
            keywords: &["Mauritius", "dispariție", "dodo", "extincție", "mare"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E13-031"),
            keywords: &["E13-031"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("дронт"),
            keywords: &["большой", "вымерший", "додо", "дронт", "маврикий"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڊوڊو"),
            keywords: &["موريشيس", "ناياب", "وڏو", "ڊوڊو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ඩෝඩෝ"),
            keywords: &[
                "ඩෝඩෝ",
                "මොර\u{dd2}ෂස\u{dca}",
                "වඳව\u{dd3}ම",
                "ව\u{dd2}ශ\u{dcf}ල",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("dront"),
            keywords: &["dodo", "dront", "maurícijský", "vyhynutý", "vymretý"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("dodo"),
            keywords: &["Mavricij", "dodo", "izumrtje", "velik"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("shimbir boolo"),
            keywords: &[
                "Mawritaaniya",
                "baabiin",
                "ballaaran",
                "boolo boolo",
                "shimbir boolo",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("zog i rëndë"),
            keywords: &["Mauritius", "i madh", "zhukje", "zog i rëndë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("додо"),
            keywords: &["Маурицијус", "велико", "додо", "истребљено"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["додо"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("dodo"),
            keywords: &["Mauricijus", "dodo", "istrebljeno", "veliko"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["dodo"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("dront"),
            keywords: &["Dront", "Mauritius", "dront", "stor", "utrotad"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("dodo"),
            keywords: &["Morisi", "dodo", "kubwa", "kutoweka"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("டோடோ"),
            keywords: &["அழிவு", "டோடோ", "பெரிய", "மொரிஷியஸ\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("డుడు"),
            keywords: &[
                "డుడు",
                "ప\u{c46}ద\u{c4d}దద\u{c3f}",
                "మ\u{c3e}ర\u{c3f}షస\u{c4d}",
                "వ\u{c3f}న\u{c3e}శనం",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("นกโดโด"),
            keywords: &[
                "การส\u{e39}ญพ\u{e31}นธ\u{e38}\u{e4c}",
                "นกโดโด",
                "มอร\u{e34}เช\u{e35}ยส",
                "ใหญ\u{e48}",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("dront"),
            keywords: &["Mawrikiý", "dront", "uly", "ýitip ýok bolmak"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("toto"),
            keywords: &["manupuna", "toto", "ʻauhamālie"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("dodo kuşu"),
            keywords: &[
                "Mauritius",
                "büyük",
                "dodo kuşu",
                "nesli tükenmiş",
                "soyu tükenmiş",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("дронт"),
            keywords: &["великий", "вимирання", "дронт", "маврикійський"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ڈوڈو"),
            keywords: &["بڑا", "خاتمہ", "موریشس", "ڈوڈو"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("Mavrikiya dronti"),
            keywords: &["Mavrikiy", "Mavrikiya dronti", "qirilish", "yirik"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("chim cưu"),
            keywords: &["Mauritius", "chim cưu", "lớn", "tuyệt chủng"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("嘟嘟鳥"),
            keywords: &["嘟嘟鳥", "大", "毛里求斯", "絕種"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("嘟嘟鸟"),
            keywords: &["嘟嘟鸟", "大", "毛里求斯", "绝种"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("渡渡鸟"),
            keywords: &["毛里求斯", "渡渡鸟", "灭绝"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("渡渡鳥"),
            keywords: &["巨鳥", "模里西斯", "渡渡鳥", "絕種"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("dodo"),
            keywords: &["Mauritius", "dodo", "extinction", "large"],
        },
    ],
};
#[doc = "🪶"]
pub const FEATHER: crate::Emoji = crate::Emoji {
    glyph: "🪶",
    codepoint: "1FAB6",
    status: crate::Status::FullyQualified,
    introduction_version: 13f32,
    name: "feather",
    group: "Animals & Nature",
    subgroup: "animal-bird",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("veer"),
            keywords: &["lig", "veer", "vere", "vlug", "voël"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ላባ"),
            keywords: &["ላባ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ريشة"),
            keywords: &["تحليق", "خفيف", "ريشة", "طائر"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("প\u{9be}খি"),
            keywords: &["প\u{9be}খি", "ফ\u{9cd}ল\u{9be}ইট", "ল\u{9be}ইট"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("lələk"),
            keywords: &["lələk", "quş", "tük", "uçuş", "yüngül"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("пяро"),
            keywords: &["лёгкі", "палёт", "пер’е", "птушка", "пяро"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("перо"),
            keywords: &["леко", "перо", "перушина", "полет", "птица"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("প\u{9be}লক"),
            keywords: &[
                "উড\u{9cd}ডয\u{9bc}ন",
                "প\u{9be}খির প\u{9be}লক",
                "প\u{9be}লক",
                "হ\u{9be}লক\u{9be}",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("pluenn"),
            keywords: &["evn", "pluenn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("pero"),
            keywords: &["lagano", "let", "perje", "pero", "ptica"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("ploma"),
            keywords: &["au", "lleuger", "ploma", "plomatge", "volar"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᎩᏓᏟ"),
            keywords: &["ᎤᎩᏓᏟ", "ᎤᏘᏍᏓ", "ᎦᏃᎭᎵᏙᎯ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("pírko"),
            keywords: &["lehké", "let", "opeření", "peří", "pták", "péro", "pírko"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("pluen"),
            keywords: &["aderyn", "hediad", "plu", "pluen", "ysgafn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("fjer"),
            keywords: &["fjer", "fjerdragt", "flyve", "let"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Feder"),
            keywords: &["Feder", "Federn", "fliegen", "leicht"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("φτερό"),
            keywords: &["ελαφρύ", "πετάω", "πτηνό", "φτέρωμα", "φτερό"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("feather"),
            keywords: &["bird", "feather", "flight", "light", "plumage"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("pluma"),
            keywords: &["ave", "ligero", "pluma", "plumaje", "pájaro"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("pluma"),
            keywords: &["pluma"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("pluma"),
            keywords: &["pluma"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("sulg"),
            keywords: &["kerge", "lendama", "suled", "sulg"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("luma"),
            keywords: &["arina", "hegaldia", "luma", "lumajea"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پ\u{64e}ر"),
            keywords: &[
                "بال و پ\u{64e}ر",
                "س\u{64e}ب\u{64f}ک",
                "پرنده",
                "پرواز",
                "پ\u{64e}ر",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("höyhen"),
            keywords: &["höyhen", "keveä", "lento", "lintu", "sulka"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("balahibo"),
            keywords: &["balahibo", "ibon", "lumilipad", "magaan"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("fjøður"),
            keywords: &[
                "fjaðurhamur",
                "fjøður",
                "fjøðurhamur",
                "flúgva",
                "fuglur",
                "lætt",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("plume"),
            keywords: &["léger", "oiseau", "plumage", "plume", "voler"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("plume"),
            keywords: &["léger", "oiseau", "plume", "vol"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cleite"),
            keywords: &["cleite", "clúmh", "eitilt", "éadrom", "éan"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("ite"),
            keywords: &["aotrom", "eun", "ite", "itealadh", "sgiathadh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("pluma"),
            keywords: &["lixeiro", "pluma", "plumaxe"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પી\u{a82}છાળ\u{ac1}\u{a82}"),
            keywords: &[
                "ઉડાણ",
                "પક\u{acd}ષી",
                "પી\u{a82}છાળ\u{ac1}\u{a82}",
                "હલક\u{ac1}\u{a82}",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("נוצה"),
            keywords: &["לעוף", "נוצה", "נוצות", "ציפורים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("प\u{902}ख"),
            keywords: &["उड\u{93c}ान", "चिड\u{93c}िया", "प\u{902}ख", "हल\u{94d}का"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("pero"),
            keywords: &["lagano", "letjeti", "perje", "pero", "ptica"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("madártoll"),
            keywords: &["madár", "madártoll", "repülés", "toll", "tollazat"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("փետուր"),
            keywords: &["թեթև", "թռիչք", "թռչուն", "փետուր", "փետուրներ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("bulu"),
            keywords: &["bulu", "burung", "penerbangan", "ringan"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("fjöður"),
            keywords: &["fjaðraskraut", "fjöður", "flug", "fugl", "létt"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("piuma"),
            keywords: &["leggero", "piuma", "piumaggio", "uccello", "volo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("羽"),
            keywords: &["羽", "羽毛", "軽い", "飛ぶ", "鳥"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("wulu"),
            keywords: &["enteng", "mabur", "manuk", "wulu"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ბუმბული"),
            keywords: &["ბუმბული", "მსუბუქი", "ფაფუკი", "ფრინველი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қауырсын"),
            keywords: &["жеңіл", "қауырсын", "құс", "ұшу"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ស\u{17d2}លាប"),
            keywords: &[
                "ការហើរ",
                "បក\u{17d2}ស\u{17b8}",
                "ស\u{17d2}រាល",
                "ស\u{17d2}លាប",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಗರ\u{cbf}"),
            keywords: &[
                "ಗರ\u{cbf}",
                "ಪಕ\u{ccd}ಷ\u{cbf}",
                "ಪ\u{ccd}ಲಮೇಜ\u{ccd}",
                "ಫ\u{ccd}ಲೈಟ\u{ccd}",
                "ಲೈಟ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("깃털"),
            keywords: &["가벼운", "깃털", "비행", "새"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("पाखा\u{902}"),
            keywords: &[
                "उडप",
                "उड\u{94d}डाण",
                "पा\u{902}खाटो",
                "पाखा\u{902}",
                "पिसारो",
                "ल\u{94d}हव",
                "स\u{941}कण\u{947}\u{902}",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("бир тал канат"),
            keywords: &["бир тал канат"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຂ\u{ebb}ນ\u{200b}ນ\u{ebb}ກ"),
            keywords: &[
                "ຂ\u{ebb}ນ\u{200b}ນ\u{ebb}ກ",
                "ນ\u{ebb}ກ",
                "ບ\u{eb4}ນ",
                "ປ\u{eb4}ວ",
                "ເບ\u{ebb}າ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("plunksna"),
            keywords: &["lengvumas", "plunksna", "skrydis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("spalva"),
            keywords: &["apspalvojums", "putns", "spalva", "viegls"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("пердув"),
            keywords: &["лет", "пердув", "пердуви", "перолесно"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ത\u{d42}വൽ"),
            keywords: &[
                "ത\u{d42}വൽ",
                "പക\u{d4d}ഷി",
                "പക\u{d4d}ഷിത\u{d4d}ത\u{d42}വല\u{d41}കൾ",
                "ഫ\u{d4d}ലൈറ\u{d4d}റ\u{d4d}",
                "ലൈറ\u{d4d}റ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("өд"),
            keywords: &["нислэг", "хөнгөн", "шувуу", "өд", "өд сөд"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("प\u{902}ख"),
            keywords: &[
                "उडणारा",
                "प\u{902}ख",
                "पक\u{94d}षी",
                "पिस\u{947}",
                "हलक\u{947}",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bulu pelepah"),
            keywords: &["bulu pelepah", "buluan", "ringan", "terbang"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အတောင\u{103a}"),
            keywords: &[
                "င\u{103e}က\u{103a}",
                "တောင\u{103a}ပ\u{1036}",
                "ပေါ\u{1037}",
                "ပျ\u{1036}",
                "အတောင\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("fjær"),
            keywords: &["fjær", "fjærdrakt", "fugl", "lett"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("प\u{94d}वाख"),
            keywords: &["उडान", "चरो", "ठोक\u{94d}कर", "प\u{94d}वाख", "हल\u{94d}का"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("veer"),
            keywords: &["licht", "pluimage", "veer", "vliegen"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("fjør"),
            keywords: &["fjør", "fjørdrakt", "fugl", "lett"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପକ\u{b4d}ଷୀର ପର"),
            keywords: &[
                "ଆଲୋକ",
                "ଉଡ\u{b3c}\u{b3e}ଣ",
                "ପକ\u{b4d}ଷୀ",
                "ପକ\u{b4d}ଷୀର ପର",
                "ପକ\u{b4d}ଷୀର ପରସମ\u{b42}ହ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਖ\u{a70}ਭ"),
            keywords: &["ਉਡਾਣ", "ਖ\u{a70}ਭ", "ਪਰਿ\u{a70}ਦਾ", "ਪ\u{a70}ਛੀ", "ਹਲਕਾ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fẹ\u{301}da"),
            keywords: &[
                "Bẹd",
                "Flai",
                "Fẹ\u{301}da",
                "Fẹ\u{301}da-dẹm Wé Kọ\u{301}vá Bẹd Bọdí",
                "Nọ\u{301} Hẹ\u{301}vi",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("pióro"),
            keywords: &[
                "latanie",
                "lekkość",
                "pierze",
                "pióra",
                "pióro",
                "upierzenie",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("وزرې"),
            keywords: &["الوتل", "بڼې", "سپک", "مرغۍ", "وزرې"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("pena"),
            keywords: &["leve", "pena", "plumagem", "pássaro", "voo"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["leve", "pena", "plumagem", "pássaro", "voo"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("phuru"),
            keywords: &["chhalla", "phaway", "phuru", "phurukuna", "pʼisqu"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("pană"),
            keywords: &["pană", "pasăre", "penaj", "ușor", "zbor"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E13-030"),
            keywords: &["E13-030"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("перо"),
            keywords: &["лёгкий", "оперение", "перо", "полёт", "птица"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("کنڀ"),
            keywords: &["اڏام", "هلڪو", "پلوميج", "پکي", "کنڀ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ප\u{dd2}හ\u{dcf}ට\u{dd4}"),
            keywords: &["ප\u{dd2}හ\u{dcf}ට\u{dd4}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("pierko"),
            keywords: &["lietanie", "perie", "pero", "pierko", "vták"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("pero"),
            keywords: &["lahek", "letenje", "perje", "pero", "ptica"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("baalal"),
            keywords: &["baalal", "duulimaad", "gooynta", "shimbir"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("pendë"),
            keywords: &["dritë", "fluturim", "pendë", "pupla", "pupël", "zog"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("перо"),
            keywords: &["лако", "лет", "перо", "птица"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("pero"),
            keywords: &["lako", "let", "pero", "ptica"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("fågelfjäder"),
            keywords: &["fjäder", "fjäderdräkt", "fågel", "fågelfjäder", "lätt"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("unyoya"),
            keywords: &["kuruka", "manyoya", "ndege", "nyepesi", "unyoya"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("இறகு"),
            keywords: &["இறகு", "தோகை", "பறத\u{bcd}தல\u{bcd}", "பறவை", "லேச\u{bbe}ன"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఈక"),
            keywords: &[
                "ఈక",
                "క\u{c3e}ంత\u{c3f}",
                "పక\u{c4d}ష\u{c3f}",
                "పక\u{c4d}ష\u{c3f} ర\u{c46}క\u{c4d}కలు",
                "వ\u{c3f}మ\u{c3e}నం",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ขนนก"),
            keywords: &["การบ\u{e34}น", "ขนนก", "นก", "เบา"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýelek"),
            keywords: &["uçuş", "ýelek", "ýeňil"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fulufulu"),
            keywords: &["fulufulu", "manupuna"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kuş tüyü"),
            keywords: &["hafif", "kuş", "kuş tüyü", "tüylü", "uçma"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("пір’їна"),
            keywords: &["невагома", "оперення", "політ", "птах", "пір’їна"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("پر"),
            keywords: &["پر", "پرندہ", "پرواز", "پنکھ", "ہلکا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("pat"),
            keywords: &["par", "parvoz", "pat", "yengil"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("lông chim"),
            keywords: &["bộ lông", "chim", "chuyến bay", "lông chim", "nhẹ"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("羽毛"),
            keywords: &["光", "羽毛", "航班"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("羽毛"),
            keywords: &["光", "羽毛", "航班"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("羽毛"),
            keywords: &["羽毛", "轻", "飞", "鸟"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("羽毛"),
            keywords: &["羽毛", "輕", "飄", "飛"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("uphaphe"),
            keywords: &["uphaphe"],
        },
    ],
};
#[doc = "🦩"]
pub const FLAMINGO: crate::Emoji = crate::Emoji {
    glyph: "🦩",
    codepoint: "1F9A9",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "flamingo",
    group: "Animals & Nature",
    subgroup: "animal-bird",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("flamink"),
            keywords: &["flambojant", "flamink", "tropies"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ፍላሚንጎ"),
            keywords: &["ብልጭልጭ", "ትሮፒካል", "ፍላሚንጎ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("فلامينغو"),
            keywords: &["استوائي", "فلامينغو", "مبهج", "مبهرج"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ফ\u{9cd}লেমিংগ’"),
            keywords: &[
                "গ\u{9cd}ৰীষ\u{9cd}মপ\u{9cd}ৰধ\u{9be}ন",
                "ফ\u{9cd}লেমব’য\u{9bc}েণ\u{9cd}ট",
                "ফ\u{9cd}লেমিংগ’",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("flaminqo"),
            keywords: &["flaminqo", "rəngli", "tropik"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("фламінга"),
            keywords: &["трапічны", "фламінга", "яркі", "яскравы"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("фламинго"),
            keywords: &["тропическа птица", "фламинго", "ярък цвят"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মর\u{9be}ল"),
            keywords: &[
                "গ\u{9cd}রীষ\u{9cd}মপ\u{9cd}রধ\u{9be}ন",
                "জ\u{9be}\u{981}ক\u{9be}লো",
                "মর\u{9be}ল",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("flammeg"),
            keywords: &["evn", "flammeg", "loen", "trovanel"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("flamingo"),
            keywords: &["flamingo", "kitnjast", "tropska ptica", "tropski"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("flamenc"),
            keywords: &["cridaner", "flamenc", "tropical"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏚᎯᏅᏍᏗ ᏥᏍᏆ"),
            keywords: &["ᎠᏚᎯᏅᏍᏗ ᏥᏍᏆ", "ᎤᏗᏞᎦ", "ᎤᏥᏍᏔᎷᎩᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("plameňák"),
            keywords: &["okázalý", "plameňák", "tropický", "tropy"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("fflamingo"),
            keywords: &["cyhydeddol", "fflamingo", "llachar"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("flamingo"),
            keywords: &["flamboyant", "flamingo", "tropisk"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Flamingo"),
            keywords: &["Flamingo", "Tropen", "bunt", "farbenfroh", "tropisch"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("φλαμίνγκο"),
            keywords: &["επιδεικτικός", "τροπικός", "φλαμίνγκο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("flamingo"),
            keywords: &["flamboyant", "flamingo", "tropical"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("flamenco"),
            keywords: &["extravangante", "flamenco", "ostentoso", "tropical"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["extravagante", "flamenco", "flamingo", "tropical"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("flamingo"),
            keywords: &["flamingo", "lind", "troopiline"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("flamenkoa"),
            keywords: &["flamenkoa", "ikusgarria", "tropikala"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("فلامینگو"),
            keywords: &["براق", "فلامینگو", "گرمسیر"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("flamingo"),
            keywords: &["flamingo", "pramea", "trooppinen"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("flamingo"),
            keywords: &["flamingo", "magarbo", "tropikal"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("flamingo"),
            keywords: &["flamingo", "fuglur", "litfagur", "tropiskur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("flamant"),
            keywords: &["animal", "flamant", "oiseau", "rose", "tropical"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["flamant", "rose", "tropical"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("lasairéan"),
            keywords: &["lasairéan", "péacach", "trópaiceach"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("flamingo"),
            keywords: &["flamingo", "spaideil", "tropaigeach"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("flamengo"),
            keywords: &["ave", "flamengo", "rosa"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{ac1}રખાબ"),
            keywords: &["આકર\u{acd}ષક", "ઉષ\u{acd}ણકટિબ\u{a82}ધીય", "સ\u{ac1}રખાબ"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פלמינגו"),
            keywords: &["ורוד", "טרופי", "פלמינגו"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("लाल ह\u{902}स"),
            keywords: &["ग\u{941}ल-मोहर", "ट\u{94d}रॉपिकल", "लाल ह\u{902}स"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("plamenac"),
            keywords: &["flamingo", "plamenac", "tropski"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("flamingó"),
            keywords: &["flamingó", "színpompás", "trópusi"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ֆլամինգո"),
            keywords: &["արևադարձային", "ցայտուն", "ֆլամինգո"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("flamingo"),
            keywords: &["flamboyan", "flamingo", "tropikal", "tropis"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("flamingói"),
            keywords: &["flamingói", "hitabeltis", "litríkur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("fenicottero"),
            keywords: &["fenicottero", "fenicottero rosa", "tropicale"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("フラミンゴ"),
            keywords: &["ピンク色", "フラミンゴ", "動物", "熱帯", "鳥"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("flamingo"),
            keywords: &["flamboyan", "flamingo", "tropis"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ფლამინგო"),
            keywords: &["ტროპიკული", "ფლამინგო", "ჩიტი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("фламинго"),
            keywords: &["алаулы", "тропикалық", "фламинго"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ក\u{17bb}កពណ\u{17cc}ស\u{17ca}\u{17b8}ក\u{17bc}លាប"),
            keywords: &[
                "ក\u{17bb}កពណ\u{17cc}ស\u{17ca}\u{17b8}ក\u{17bc}លាប",
                "ត\u{17d2}រ\u{17bc}ព\u{17b7}ច",
                "ពណ\u{17cc}ភ\u{17d2}ល\u{17ba}ច\u{17d2}រាល",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಫ\u{ccd}ಲಮ\u{cbf}ಂಗೊ"),
            keywords: &[
                "ಟ\u{ccd}ರಾಪ\u{cbf}ಕಲ\u{ccd}",
                "ಫ\u{ccd}ಲಮ\u{cbf}ಂಗೊ",
                "ಫ\u{ccd}ಲ\u{cc6}ಂಬಯೊಂಟ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("홍학"),
            keywords: &["열대", "플라밍고", "홍학"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("फ\u{94d}ल\u{947}मि\u{902}गो"),
            keywords: &[
                "उष\u{94d}णकटिब\u{902}धीय",
                "फ\u{94d}ल\u{947}मि\u{902}गो",
                "मनभ\u{941}लयण\u{947}\u{902}",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("фламинго"),
            keywords: &["кооз", "тропикалык", "фламинго"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ນ\u{ebb}ກ\u{200b}ຟ\u{200b}ລາ\u{200b}ມ\u{eb4}ງ\u{200b}ໂກ"),
            keywords: &[
                "ນ\u{ebb}ກ",
                "ນ\u{ebb}ກ\u{200b}ຟ\u{200b}ລາ\u{200b}ມ\u{eb4}ງ\u{200b}ໂກ",
                "ສ\u{eb5}\u{200b}ສ\u{eb1}ນ\u{200b}ສ\u{ebb}ດ\u{200b}ໃສ",
                "ເຂດ\u{200b}ຮ\u{ec9}ອນ\u{200b}ຊ\u{eb8}\u{ec8}ມ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("flamingas"),
            keywords: &["flamingas", "spalvingas", "tropinis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("flamingo"),
            keywords: &["flamingo", "spilgts", "tropisks"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("фламинго"),
            keywords: &["екстравагантно", "тропско", "фламинго"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഹംസം"),
            keywords: &[
                "ഉഷ\u{d4d}\u{200c}ണമേഖലയില\u{d41}ള\u{d4d}ളത\u{d4d}",
                "വർണ\u{d4d}ണപ\u{d4d}പകിട\u{d4d}ട\u{d41}ള\u{d4d}ള",
                "ഹംസം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("ягаан наль"),
            keywords: &["халуун орон", "ягаан", "ягаан наль"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("फ\u{94d}ल\u{947}मि\u{902}गो"),
            keywords: &[
                "उष\u{94d}ण कटिब\u{902}धीय",
                "फ\u{94d}ल\u{947}मि\u{902}गो",
                "शोभिव\u{902}त",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("flamingo"),
            keywords: &["flamingo", "ranggi", "tropikal"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ကြ\u{102d}\u{102f}းကြာန\u{102e}"),
            keywords: &[
                "ကြ\u{102d}\u{102f}းကြာန\u{102e}",
                "ဟ\u{102d}တ\u{103a}ဟန\u{103a}များသော",
                "အပ\u{1030}ပ\u{102d}\u{102f}င\u{103a}းဒေသ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("flamingo"),
            keywords: &["flamingo", "prangende", "tropisk"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("फ\u{94d}ल\u{947}मिङ\u{94d}गो"),
            keywords: &[
                "ट\u{94d}रपिकल",
                "फ\u{94d}ल\u{947}मिङ\u{94d}गो",
                "फ\u{94d}ल\u{947}म\u{94d}बोयान\u{94d}ट",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("flamingo"),
            keywords: &["flamboyant", "flamingo", "tropisch"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("flamingo"),
            keywords: &["flamingo", "prangande", "tropisk"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଫ\u{b4d}ଲ\u{b3e}ମ\u{b3f}ଙ\u{b4d}ଗୋ"),
            keywords: &[
                "ଆଡ\u{b3c}ମ\u{b4d}ୱରପ\u{b4d}ର\u{b3f}ୟ",
                "ଉଷ\u{b4d}ମ ମଣ\u{b4d}ଡଳୀୟ",
                "ଫ\u{b4d}ଲ\u{b3e}ମ\u{b3f}ଙ\u{b4d}ଗୋ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਲਮਢੀ\u{a02}ਗ"),
            keywords: &["ਤਪਤ ਖ\u{a70}ਡੀ", "ਲਮਢੀ\u{a02}ਗ", "ਸ\u{a3c}\u{a4b}ਖ\u{a3c}"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Flamíngo"),
            keywords: &[
                "Faín Kọ\u{301}lọ",
                "Flamíngo",
                "Họt Ríjọn",
                "Wọ\u{301}n Bẹd Wé Im Nem Na Flamíngo",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("flaming"),
            keywords: &["ekstrawagancja", "flaming", "tropikalny"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("غزى، ډينګ"),
            keywords: &["حاره", "غزى، ډينګ", "ځلند"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("flamingo"),
            keywords: &["extravagante", "flamingo", "tropical"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("flamenco"),
            keywords: &["flamenco", "rikurichisqa", "tropical"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("flamingo"),
            keywords: &["flamboaiant", "flamingo", "tropical"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E12–032"),
            keywords: &["E12–032"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("фламинго"),
            keywords: &[
                "птица",
                "розовый",
                "тропики",
                "тропическая",
                "тропический",
                "фламинго",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("فليمنگو"),
            keywords: &["فليمبوينٽ", "فليمنگو", "ٽروپيڪل"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("රණහංසය\u{dcf}"),
            keywords: &[
                "ච\u{dd2}ත\u{dca}ත\u{dcf}කර\u{dca}ෂණ\u{dd3}ය",
                "න\u{dd2}වර\u{dca}තන",
                "රණහංසය\u{dcf}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("plameniak"),
            keywords: &["nápadný", "okázalý", "plameniak", "tropický"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("flamingo"),
            keywords: &["flamingo", "nastopaški", "tropski", "vpadljiv"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("qudunquuto"),
            keywords: &["dhaldhalaalaya", "kulaylaha", "qudunquuto"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("flamingo"),
            keywords: &["flakërues", "flamingo", "shpend", "tropikal"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("фламинго"),
            keywords: &["тропски", "упадљив", "фламинго"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("flamingo"),
            keywords: &["flamingo", "tropski", "upadljiv"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("flamingo"),
            keywords: &["flambojant", "flamingo", "tropisk"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("Flamingo"),
            keywords: &["Flamingo", "kwenye joto", "madaha"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பூந\u{bbe}ரை"),
            keywords: &[
                "நளினம\u{bcd}",
                "பூந\u{bbe}ரை",
                "வெப\u{bcd}பமண\u{bcd}டலம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఫ\u{c4d}ల\u{c46}మ\u{c3f}ంగ\u{c4b}"),
            keywords: &[
                "ట\u{c4d}ర\u{c3e}ప\u{c3f}కల\u{c4d}",
                "ఫ\u{c4d}ల\u{c3e}మ\u{c4d}\u{200c}బ\u{c4b}యంట\u{c4d}",
                "ఫ\u{c4d}ల\u{c46}మ\u{c3f}ంగ\u{c4b}",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("นกฟลาม\u{e34}งโก"),
            keywords: &[
                "ทรอป\u{e34}คอล",
                "นกฟลาม\u{e34}งโก",
                "ส\u{e35}ส\u{e31}นสะด\u{e38}ดตา",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gyzylinjik"),
            keywords: &["gyzylinjik", "owadan", "tropik"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("falamingo"),
            keywords: &["falamingo", "manupuna"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("flamingo"),
            keywords: &["flamingo", "gösterişli", "tropikal"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("фламінго"),
            keywords: &["птах", "рожевий", "тропіки", "тропічний", "фламінго"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("لم ٹنگو"),
            keywords: &["بھڑکیلا", "حاری", "لم ٹنگو"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("flamingo"),
            keywords: &["ajoyib", "flamingo", "tropik"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("hồng hạc"),
            keywords: &["hồng hạc", "nhiệt đới", "rực rỡ"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("紅鶴"),
            keywords: &["熱帶", "紅鶴", "靚"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("红鹤"),
            keywords: &["热带", "红鹤", "靓"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("火烈鸟"),
            keywords: &["火烈鸟", "热带", "艳丽"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("紅鶴"),
            keywords: &["熱帶", "紅鶴", "鮮豔"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("i-flamingo"),
            keywords: &["i-flamboyanti", "i-flamingo", "i-tropical"],
        },
    ],
};
#[doc = "🦚"]
pub const PEACOCK: crate::Emoji = crate::Emoji {
    glyph: "🦚",
    codepoint: "1F99A",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "peacock",
    group: "Animals & Nature",
    subgroup: "animal-bird",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("pou"),
            keywords: &["pou", "pouhen", "pronkerig", "trots", "voël"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ፒኮክ"),
            keywords: &["ኩራት", "ወፍ", "የሚመካ", "ፒኮክ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("طاووس"),
            keywords: &["طائر", "طاووس", "طاووسة", "فتباهي", "متفاخر"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ময\u{9bc}\u{9c1}ৰ পখী"),
            keywords: &[
                "আড\u{9bc}ম\u{9cd}বৰপ\u{9c2}ৰ\u{9cd}ণ",
                "গৰ\u{9cd}ব",
                "চৰ\u{9be}ই",
                "ময\u{9bc}\u{9c1}ৰ পখী",
                "ময\u{9bc}\u{9c2}ৰী",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("tovuz"),
            keywords: &["farmazon", "quş", "qürrəli", "tovuz"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("паўлін"),
            keywords: &["ганарлівы", "пава", "пафасны", "паўлін", "птушка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("паун"),
            keywords: &["ветрило", "красива опашка", "наперен", "паун", "птица"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ময\u{9bc}\u{9c2}র"),
            keywords: &[
                "গর\u{9cd}বিত",
                "জ\u{9be}\u{981}ক\u{9be}লো",
                "প\u{9be}খি",
                "ময\u{9bc}\u{9c2}র",
                "ময\u{9bc}\u{9c2}রী",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("paun"),
            keywords: &["evn", "loen", "paun"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("paun"),
            keywords: &["hvalisav", "paun", "ponosan", "ptica", "šepurenje"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("paó"),
            keywords: &["cua", "ocell", "orgull", "ostentós", "paó"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎬᎾ ᏧᏆᏔᎵ ᏧᎷᎩ ᎠᏨᏯᎢ"),
            keywords: &[
                "ᎤᎾᏢᏉᏗ",
                "ᎦᎾᏄᎪᏫᏍᎦ",
                "ᎬᎾ ᏧᏆᏔᎵ ᏧᎷᎩ ᎠᎩᏏ",
                "ᎬᎾ ᏧᏆᏔᎵ ᏧᎷᎩ ᎠᏨᏯᎢ",
                "ᏥᏍᏆ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("páv"),
            keywords: &["pompézní", "pták", "pyšný", "páv", "pávice"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("paun"),
            keywords: &["aderyn", "balch", "paun", "peunes", "trawiadol"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("påfugl"),
            keywords: &["fugl", "prangende", "påfugl", "påfuglehøne", "stolt"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Pfau"),
            keywords: &["Pfau", "Vogel", "stolz", "stolzieren"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("παγώνι"),
            keywords: &[
                "επιδειξιομανής",
                "θηλυκό παγώνι",
                "παγώνι",
                "περήφανος",
                "πουλί",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("peacock"),
            keywords: &["bird", "ostentatious", "peacock", "peahen", "proud"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("pavo real"),
            keywords: &["ave", "orgulloso", "pavo", "pavo real", "plumas"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("pavo real"),
            keywords: &["ave", "orgullo", "ostentación", "pavo", "pavo real"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("pavo real"),
            keywords: &["pavo real"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("paabulind"),
            keywords: &["eneseimetlus", "hooplemine", "lind", "paabulind", "uhkus"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("hegazterren"),
            keywords: &["arranditsu", "harro", "hegazterren", "txori"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("طاووس"),
            keywords: &[
                "تظاهر",
                "خودنمایی",
                "طاووس",
                "طاووس ماده",
                "فخرفروشی",
                "مغرور",
                "پرنده",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("riikinkukko"),
            keywords: &[
                "komeileva",
                "lintu",
                "mahtaileva",
                "pramea",
                "riikinkukko",
                "ylpeä",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("peacock"),
            keywords: &["ibon", "makulay", "pabo", "peacock"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("páfuglur"),
            keywords: &[
                "erpin",
                "fuglur",
                "p´´afuglahøna",
                "páfuglahani",
                "páfuglur",
                "reyp",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("paon"),
            keywords: &["animal", "fier", "oiseau", "paon", "paonne", "prétentieux"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("péacóg"),
            keywords: &["bródúil", "cearc phéacóige", "péacóg", "thar fóir", "éan"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("peucag"),
            keywords: &[
                "eucag",
                "eun",
                "feucag",
                "moiteil",
                "peucag",
                "pròiseil",
                "stàirneil",
                "àrdan",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("pavón"),
            keywords: &["ave", "pavo real", "pavón"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("મોર"),
            keywords: &["ઢ\u{ac7}લ", "પક\u{acd}ષી", "ભવ\u{acd}ય", "મોર", "શાનદાર"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("טווס"),
            keywords: &["גאוותן", "טווס", "ציפור", "ראוותני"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("मोर"),
            keywords: &["ख\u{941}श", "पक\u{94d}षी", "मोर", "मोरनी", "शानदार"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("paun"),
            keywords: &[
                "paun",
                "paunica",
                "ponos",
                "ptica",
                "razmetljivost",
                "ukras",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("páva"),
            keywords: &["büszke", "hivalkodó", "madár", "páva", "pávatyúk"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("սիրամարգ"),
            keywords: &["թռչուն", "հպարտ", "սիրամարգ", "սնապարծ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("merak"),
            keywords: &["angkuh", "burung", "merak", "merak betina", "mewah"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("páfugl"),
            keywords: &["fugl", "páfugl", "páhæna", "stoltur", "sýndarmennska"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("pavone"),
            keywords: &["pavone", "pavoneggiarsi", "uccello", "volatile"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("クジャク"),
            keywords: &["クジャク", "ピーコック", "孔雀", "派手", "鳥"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("merak"),
            keywords: &["manuk", "merak", "merak wadon", "seneng pamer", "umuk"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ფარშევანგი"),
            keywords: &["ლურჯფრთიანი", "ფარშევანგი", "ჩიტი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("тауыс"),
            keywords: &["даңғой", "менмен", "тауыс", "құс"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ក\u{17d2}ងោក"),
            keywords: &[
                "ក\u{17d2}ងោក",
                "ក\u{17d2}ងោកញ\u{17b8}",
                "ដែលមានមោទនភាព",
                "បក\u{17d2}ស\u{17b8}",
                "ស\u{17c6}ញ\u{17c9}ែង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ನವ\u{cbf}ಲು"),
            keywords: &[
                "ಆಸ\u{ccd}ಟ\u{cc6}ಂಟ\u{cc6}ಟ\u{cbf}ಯಸ\u{ccd}",
                "ನವ\u{cbf}ಲು",
                "ಪಕ\u{ccd}ಷ\u{cbf}",
                "ಪೀಹ\u{cc6}ನ\u{ccd}",
                "ಹ\u{cc6}ಮ\u{ccd}ಮ\u{cc6}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("공작"),
            keywords: &["공작", "뽐내는", "수컷 공작", "조류", "화려한"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("मोर"),
            keywords: &[
                "अद\u{94d}भ\u{942}त",
                "गर\u{94d}व",
                "मोर",
                "मोरीण",
                "स\u{941}कण\u{947}\u{902}",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("тоос"),
            keywords: &[
                "куш",
                "мактанчаак",
                "мурдун көтөргөн",
                "тоос",
                "ургаачы тоос",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ນ\u{ebb}ກຍ\u{eb8}ງ"),
            keywords: &["ນ\u{ebb}ກ", "ນ\u{ebb}ກຍ\u{eb8}ງ", "ພ\u{eb9}ມໃຈ", "ໂອອວດ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("povas"),
            keywords: &[
                "išdidus",
                "mėgstantis pasirodyti",
                "paukštis",
                "povas",
                "povė",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("pāvs"),
            keywords: &["iedomīgs", "putns", "pāvs", "pāvu mātīte", "ārišķīgs"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("паун"),
            keywords: &["горделив", "наметлив", "паун", "птица"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ആൺമയിൽ"),
            keywords: &[
                "അഭിമ\u{d3e}നം",
                "ആൺമയിൽ",
                "പക\u{d4d}ഷി",
                "പെൺമയിൽ",
                "പ\u{d4d}രകടിപ\u{d4d}പിക\u{d4d}ക\u{d41}ന\u{d4d}നത\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("тогос"),
            keywords: &["бардамнал", "гайхуулсан", "тогос", "шувуу", "эм тогос"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("मोर"),
            keywords: &[
                "ऑस\u{94d}ट\u{947}न\u{94d}ट\u{947}शियस",
                "पक\u{94d}षी",
                "पीह\u{947}न",
                "प\u{94d}राउड",
                "मोर",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("merak"),
            keywords: &["berlagak", "burung", "merak", "merak betina", "sombong"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဒေါင\u{103a}း"),
            keywords: &[
                "င\u{103e}က\u{103a}",
                "ဒေါင\u{103a}း",
                "ဒေါင\u{103a}းမ",
                "မော\u{103a}ကြ\u{103d}ားသော",
                "ဝင\u{1037}\u{103a}ကြ\u{103d}ားသော",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("påfugl"),
            keywords: &["fugl", "prangende", "påfugl", "stolt"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("मय\u{941}र"),
            keywords: &[
                "घमण\u{94d}डी",
                "चरा",
                "द\u{947}खावटी राम\u{94d}रो",
                "पोथी मय\u{941}र",
                "मय\u{941}र",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("pauw"),
            keywords: &["opzichtig", "pauw", "pauwhen", "trots", "vogel"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("påfugl"),
            keywords: &["fugl", "prangande", "påfugl", "stolt"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମୟ\u{b42}ର"),
            keywords: &[
                "ଆଡମ\u{b4d}ବରପ\u{b4d}ର\u{b3f}ୟ",
                "ଗର\u{b4d}ବ",
                "ପକ\u{b4d}ଷୀ",
                "ମୟ\u{b42}ର",
                "ମୟ\u{b42}ରୀ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਮ\u{a4b}ਰ"),
            keywords: &[
                "ਪ\u{a70}ਛੀ",
                "ਮਾਣ",
                "ਮ\u{a4b}ਰ",
                "ਮ\u{a4b}ਰਨੀ",
                "ਵਿਖਾਵ\u{a47} ਵਾਲਾ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Píkọk"),
            keywords: &[
                "Bẹd",
                "Praud",
                "Píkọk",
                "To Kárí Bọdí Ọp",
                "To Mék Gai",
                "To Mék Gai An Shó Pípul Sé Yu Gẹ\u{301}t Mọní",
                "Wọ\u{301}n Bẹd Wé Im Nem Na Píhẹn",
                "Wọ\u{301}n Bẹd Wé Im Nem Na Píkọk",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("paw"),
            keywords: &["dumny", "paw", "ptak"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("طاوس"),
            keywords: &["،مرغه، رنګارنګ، طاوس، طاوسه،", "طاوس"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("pavão"),
            keywords: &["ave", "orgulhoso", "pavoa", "pavão", "pomposo"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("pavo real"),
            keywords: &[
                "apuskachay",
                "pava real",
                "pavo real",
                "pʼisqu",
                "rikurichisqa",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("păun"),
            keywords: &["mândrie", "orgoliu", "ostentație", "pasăre", "păun"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E11-024"),
            keywords: &["E11-024"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("павлин"),
            keywords: &["веер", "павлин", "перья", "птица", "хвост"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مور"),
            keywords: &["اڀرندڙ", "فخر", "مور", "مورڻي", "پکي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("මොනර\u{dcf}"),
            keywords: &[
                "ආඩම\u{dca}බර",
                "ඕස\u{dca}ටන\u{dca}ටෙය\u{dd2}සස\u{dca}",
                "ක\u{dd4}ර\u{dd4}ල\u{dca}ල\u{dcf}",
                "මොනර\u{dcf}",
                "සෙබඩ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("páv"),
            keywords: &["nadutý", "nafúkaný", "pyšný", "páv"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("pav"),
            keywords: &["bahava", "pav", "pavica", "ponosna", "ptica"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("daa’uus"),
            keywords: &["birbirqaya", "daa’uus", "dheddig dagiiran", "shimbir"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("pallua"),
            keywords: &["mburravec", "pallua", "shpend"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("паун"),
            keywords: &["паун", "поносан", "птица", "разметљив"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("paun"),
            keywords: &["paun", "ponosan", "ptica", "razmetljiv"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("påfågel"),
            keywords: &["fågel", "praktfull", "påfågel", "stolt"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("tausi"),
            keywords: &["kiburi", "majivuno", "ndege", "tausi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மயில\u{bcd}"),
            keywords: &[
                "பறவை",
                "பெண\u{bcd} மயில\u{bcd}",
                "பெருமை",
                "மயில\u{bcd}",
                "வியக\u{bcd}கத\u{bcd}தக\u{bcd}க",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("న\u{c46}మల\u{c3f}"),
            keywords: &[
                "గర\u{c4d}వం",
                "డ\u{c3e}బుసర\u{c3f}",
                "న\u{c46}మల\u{c3f}",
                "పక\u{c4d}ష\u{c3f}",
                "ప\u{c40}హ\u{c46}న\u{c4d}",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("นกย\u{e39}ง"),
            keywords: &[
                "ทะนงต\u{e31}ว",
                "นก",
                "นกย\u{e39}ง",
                "นกย\u{e39}งต\u{e31}วเม\u{e35}ย",
                "โอ\u{e49}อวด",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("tawus"),
            keywords: &["buýsançly", "guş", "görnükli", "tawus", "tawus jüýje"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("pīkoka"),
            keywords: &["pīkoka"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("tavus kuşu"),
            keywords: &[
                "dişi tavus kuşu",
                "gururlu",
                "gösterişli",
                "kuş",
                "tavus kuşu",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("павич"),
            keywords: &["павич", "павлін", "птах", "фазан", "хвіст"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("مور"),
            keywords: &["مغرور", "مور", "مورنی", "نمائشی", "پرندہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("tovus"),
            keywords: &[
                "dum",
                "parranda",
                "pat",
                "qush",
                "tovus",
                "yelpig‘ich",
                "yoyish",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("con công"),
            keywords: &["chim", "con công", "công mái", "phô trương", "tự hào"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("孔雀"),
            keywords: &["孔雀", "開屏", "雀", "驕傲"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("孔雀"),
            keywords: &["孔雀", "开屏", "雀", "骄傲"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("孔雀"),
            keywords: &["孔雀", "招摇", "雌孔雀", "骄傲", "鸟"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("孔雀"),
            keywords: &["孔雀", "賣弄", "雌孔雀", "驕傲", "鳥"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("peacock"),
            keywords: &["bird", "ostentatious", "peacock", "peahen", "proud"],
        },
    ],
};
#[doc = "🦜"]
pub const PARROT: crate::Emoji = crate::Emoji {
    glyph: "🦜",
    codepoint: "1F99C",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "parrot",
    group: "Animals & Nature",
    subgroup: "animal-bird",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("papegaai"),
            keywords: &["papegaai", "praat", "seerower", "voël"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("በቀቀን"),
            keywords: &["ቀፍ", "በቀቀን", "ንግግር", "ጠላፊ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ببغاء"),
            keywords: &["أصوات", "ببغاء", "تقليد", "طائر", "قرصان", "كلام"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ভ\u{9be}টৌ"),
            keywords: &[
                "কথ\u{9be}ব\u{9be}ৰ\u{9cd}ত\u{9be}",
                "চৰ\u{9be}ই",
                "জলদস\u{9cd}য\u{9c1}",
                "ভ\u{9be}টৌ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("tutuquşu"),
            keywords: &["pirat", "quş", "söhbət", "tutuquşu"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("папугай"),
            keywords: &["гаворка", "папугай", "птушка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("папагал"),
            keywords: &["говор", "папагал", "пират", "птица"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("তোত\u{9be}প\u{9be}খি"),
            keywords: &[
                "কথ\u{9be}",
                "তোত\u{9be}প\u{9be}খি",
                "প\u{9be}ইরেট",
                "প\u{9be}খি",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("peroked"),
            keywords: &["evn", "loen", "peroked"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("papagaj"),
            keywords: &["papagaj", "papiga", "pričanje", "ptica"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("lloro"),
            keywords: &["lloro", "ocell", "parlar", "pirata"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏥᏍᏆ ᎦᏬᏂᏍᎩ"),
            keywords: &["ᎯᏬᏂᎯ", "ᏥᏍᏆ", "ᏥᏍᏆ ᎦᏬᏂᏍᎩ", "ᏥᏳᎡᏙᎯ ᎠᏓᏌᎲᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("papoušek"),
            keywords: &["mluvící", "papoušek", "pirát", "pták"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("parot"),
            keywords: &["aderyn", "môr-leidr", "parot", "siarad"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("papegøje"),
            keywords: &["fugl", "papegøje", "sørøver", "tale"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Papagei"),
            keywords: &["Papagei", "Pirat", "Vogel", "Wiederholen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("παπαγάλος"),
            keywords: &["μιλάω", "παπαγάλος", "πειρατής", "πουλί"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("parrot"),
            keywords: &["bird", "parrot", "pirate", "talk"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["bird", "parrot", "pirate", "talk"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("loro"),
            keywords: &["ave", "hablar", "loro", "papagayo", "pirata"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("loro"),
            keywords: &["animal", "ave", "cotorro", "hablar", "loro", "perico"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("loro"),
            keywords: &["loro"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("papagoi"),
            keywords: &["jutt", "lind", "papagoi", "piraat"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("loro"),
            keywords: &["hitz egin", "loro", "pirata", "txori"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("طوطی"),
            keywords: &[
                "حرف زدن",
                "دزدان دریایی",
                "طوطی",
                "پرنده",
                "یاوه\u{200c}گویی",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("papukaija"),
            keywords: &["lintu", "merirosvo", "papukaija", "puhe", "puhuva"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("loro"),
            keywords: &["ibon", "loro", "nagsasalitang ibon", "pirata"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("pappageykur"),
            keywords: &["fuglur", "pappageykur", "prát", "sjórænari"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("perroquet"),
            keywords: &["animal", "oiseau", "parle", "perroquet", "pirate"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("pearóid"),
            keywords: &["caint", "foghlaí", "pearóid", "éan"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("pearraid"),
            keywords: &["bruidhinn", "eun", "pearraid", "spùinneadair"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("loro"),
            keywords: &["ave", "charlatán", "falangueiro", "loro", "pirata"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પોપટ"),
            keywords: &["ચા\u{a82}ચિયો", "પક\u{acd}ષી", "પોપટ", "બોલતો પોપટ"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("תוכי"),
            keywords: &["ג׳ונגל", "ציפור", "ציפור מדברת", "תוכי"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("तोता"),
            keywords: &["तोता", "पक\u{94d}षी", "बात\u{942}नी"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("papiga"),
            keywords: &["govor", "gusar", "papiga", "ptica"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("papagáj"),
            keywords: &["beszél", "kalóz", "madár", "papagáj"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("թութակ"),
            keywords: &["թութակ", "թռչուն", "խոսոց", "ծովահեն"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("nuri"),
            keywords: &["bajak laut", "bicara", "burung", "nuri"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("páfagaukur"),
            keywords: &["fugl", "páfagaukur", "sjóræningi", "tal"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("pappagallo"),
            keywords: &["pappagallo", "pirati", "uccello parlante"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("オウム"),
            keywords: &["しゃべる", "オウム", "海賊", "鳥"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("beo"),
            keywords: &["beo", "manuk", "omong", "perompak"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("თუთიყუში"),
            keywords: &["თუთიყუში", "ყბედი", "ჩიტი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("тотықұс"),
            keywords: &["сөйлесу", "тотықұс", "қарақшы", "құс"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សេក"),
            keywords: &[
                "ចោរសម\u{17bb}ទ\u{17d2}រ",
                "ន\u{17b7}យាយ",
                "បក\u{17d2}ស\u{17b8}",
                "សេក",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪಂಚವರ\u{ccd}ಣ ಗ\u{cbf}ಣ\u{cbf}"),
            keywords: &[
                "ಪಂಚವರ\u{ccd}ಣ ಗ\u{cbf}ಣ\u{cbf}",
                "ಪಕ\u{ccd}ಷ\u{cbf}",
                "ಪೈರೇಟ\u{ccd}",
                "ಮಾತು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("앵무새"),
            keywords: &["말하는 새", "앵무새", "조류", "해적"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("पोपट"),
            keywords: &[
                "उलोवप",
                "चाच\u{94d}य\u{947}",
                "पोपट",
                "स\u{941}कण\u{947}\u{902}",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("тоту куш"),
            keywords: &["каракчы", "куш", "сүйлөө", "тоту куш"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ນ\u{ebb}ກແກ\u{ec9}ວ"),
            keywords: &[
                "ນ\u{ebb}ກ",
                "ນ\u{ebb}ກແກ\u{ec9}ວ",
                "ເວ\u{ebb}\u{ec9}າ",
                "ໂຈນສະລ\u{eb1}ກ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("papūga"),
            keywords: &["kalbantis", "papūga", "paukštis", "piratas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("papagailis"),
            keywords: &["papagailis", "pirāts", "putns", "runāt"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("папагал"),
            keywords: &["зборува", "папагал", "пират", "птица"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("തത\u{d4d}ത"),
            keywords: &[
                "തത\u{d4d}ത",
                "പക\u{d4d}ഷി",
                "പൈറേറ\u{d4d}റ\u{d4d}",
                "സംസ\u{d3e}രിക\u{d4d}ക\u{d41}ക",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("тоть"),
            keywords: &["далайн дээрэмчин", "тоть", "шувуу", "яриа"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("पोपट"),
            keywords: &["पक\u{94d}षी", "पायर\u{947}ट", "पोपट", "बोलण\u{947}"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kakak tua"),
            keywords: &["burung", "cakap", "kakak tua", "lanun"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ကြက\u{103a}တ\u{1030}ရ\u{103d}ေး"),
            keywords: &[
                "ကြက\u{103a}တ\u{1030}ရ\u{103d}ေး",
                "င\u{103e}က\u{103a}",
                "စကားပြော",
                "ပင\u{103a}လယ\u{103a}ဓားပြ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("papegøye"),
            keywords: &["fugl", "papegøye", "pirat", "snakkende", "snakker"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{941}\u{901}गा"),
            keywords: &["क\u{941}राकानी", "चरा", "डा\u{901}का", "स\u{941}\u{901}गा"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("papegaai"),
            keywords: &["papegaai", "piraat", "praten", "vogel"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("papegøye"),
            keywords: &["fugl", "papegøye", "pirat", "snakkande", "snakkar"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଶ\u{b41}ଆ"),
            keywords: &[
                "କହ\u{b3f}ବ\u{b3e}",
                "ଜଳଦସ\u{b4d}ୟ\u{b41}",
                "ପକ\u{b4d}ଷୀ",
                "ଶ\u{b41}ଆ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਤ\u{a4b}ਤਾ"),
            keywords: &["ਗ\u{a71}ਲਬਾਤ", "ਤ\u{a4b}ਤਾ", "ਪ\u{a70}ਛੀ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Párọt"),
            keywords: &[
                "Bẹd",
                "Párọt",
                "Tif Wé De Tíf Frọm Pípul Wé Dé Ínsaíd Ship",
                "Tọk",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("papuga"),
            keywords: &["gadająca", "papuga", "pirat", "ptak"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("طوطي"),
            keywords: &["طوطي", "مرغه، طوطي، ډاکو، خبرې کول"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("papagaio"),
            keywords: &["fala", "papagaio", "pirata", "pássaro"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["falar", "papagaio", "pirata", "pássaro"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("uritu"),
            keywords: &["parlay", "pirata", "pʼisqu", "uritu"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("papagal mare"),
            keywords: &["papagal mare", "pasăre", "pirat", "vorbit"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E11-026"),
            keywords: &["E11-026"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("попугай"),
            keywords: &["ара", "пират", "попугай", "птица-говорун"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("طوطو"),
            keywords: &["طوطو", "پائريٽ", "کي", "ڳالهايو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ග\u{dd2}රව\u{dcf}"),
            keywords: &[
                "කථ\u{dcf} කරන",
                "ක\u{dd4}ර\u{dd4}ල\u{dca}ල\u{dcf}",
                "ග\u{dd2}රව\u{dcf}",
                "ම\u{dd4}හ\u{dd4}ද\u{dd4} කොල\u{dca}ලක\u{dcf}රය\u{dcf}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("papagáj"),
            keywords: &["papagáj", "pirát", "rozprávať", "vták"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("papagaj"),
            keywords: &["govor", "papagaj", "pirat", "ptič"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("baqbaqaaq"),
            keywords: &["baqbaqaaq", "hadal", "shimbir", "tuug"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("papagall"),
            keywords: &["llafazan", "papagall", "shpend", "zog piratësh"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("папагај"),
            keywords: &["говори", "папагај", "пират", "птица"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("papagaj"),
            keywords: &["govori", "papagaj", "pirat", "ptica"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("papegoja"),
            keywords: &["fågel", "papegoja", "pirat", "prata"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kasuku"),
            keywords: &["kasuku", "kuzungumza", "maharamia", "ndege"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கிளி"),
            keywords: &["கிளி", "கொள\u{bcd}ளை", "பறவை", "பேச\u{bcd}சு"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("చ\u{c3f}లుక"),
            keywords: &[
                "చ\u{c3f}లుక",
                "పక\u{c4d}ష\u{c3f}",
                "ప\u{c48}ర\u{c47}ట\u{c4d}",
                "మ\u{c3e}టలు",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("นกแก\u{e49}ว"),
            keywords: &["นก", "นกแก\u{e49}ว", "พ\u{e39}ดค\u{e38}ย", "โจรสล\u{e31}ด"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("totyguş"),
            keywords: &["garakçy", "geplemek", "guş", "totyguş"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kakā"),
            keywords: &["kakā"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("papağan"),
            keywords: &["konuşma", "korsan", "kuş", "papağan"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("папуга"),
            keywords: &["ара", "папуга", "папужка", "птах", "пірат"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("طوطا"),
            keywords: &["طوطا", "قزاق", "پرندہ", "گفتگو"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("to‘ti"),
            keywords: &[
                "dengiz qaroqchisi",
                "gapiruvchi",
                "qaroqchi",
                "qush",
                "to‘ti",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("con vẹt"),
            keywords: &["chim", "con vẹt", "cướp biển", "nói chuyện", "vẹt"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("啄木鳥"),
            keywords: &["啄木鳥", "海盜", "講野", "雀"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("啄木鸟"),
            keywords: &["啄木鸟", "海盗", "讲野", "雀"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("鹦鹉"),
            keywords: &["剽窃", "模仿", "说话", "鸟", "鹦鹉"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("鸚鵡"),
            keywords: &["海盜", "說話", "鳥", "鸚鵡"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("parrot"),
            keywords: &["bird", "parrot", "pirate", "talk"],
        },
    ],
};
