#[doc = "🎯"]
pub const BULLSEYE: crate::Emoji = crate::Emoji {
    glyph: "🎯",
    codepoint: "1F3AF",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "bullseye",
    group: "Activities",
    subgroup: "game",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("kolskoot"),
            keywords: &[
                "bord", "kol", "kolskoot", "middel", "pyltjie", "speel", "teiken",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ቀጥታ የዳርት ውርወራ ውጤት"),
            keywords: &["ምት", "ቀጥታ የዳርት ውርወራ ውጤት", "ዒላማ", "የበሬ ዓይን", "ዳርት", "ጨዋታ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("نشان"),
            keywords: &["إصابة هدف", "لعبة", "مركز هدف", "نشان", "هدف"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("প\u{9cd}ৰত\u{9cd}যক\u{9cd}ষ লক\u{9cd}ষ\u{9cd}যভেদ"),
            keywords: &[
                "ক\u{9cd}ৰীড\u{9bc}\u{9be}",
                "প\u{9cd}ৰত\u{9cd}যক\u{9cd}ষ লক\u{9cd}ষ\u{9cd}যভেদ",
                "লক\u{9cd}ষ\u{9cd}য-বিন\u{9cd}দ\u{9c1}ত আঘ\u{9be}ত",
                "লক\u{9cd}ষ\u{9cd}যবিন\u{9cd}দ\u{9c1}",
                "লক\u{9cd}ষ\u{9cd}যভেদ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("birbaşa atış"),
            keywords: &["birbaşa atış", "göz", "hədəf", "nişan", "ox", "oyun", "vur"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("прамое пападанне"),
            keywords: &[
                "гульня",
                "дартс",
                "дроцік",
                "мішэнь",
                "прамое пападанне",
                "цэль",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("точен удар"),
            keywords: &["Точен удар", "игра", "стрела", "точен удар", "цел"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("সর\u{9be}সরি হিট কর\u{9be}"),
            keywords: &[
                "খেল\u{9be}",
                "ড\u{9be}র\u{9cd}ট",
                "ব\u{9c1}ল\u{9cd}সআই",
                "সর\u{9be}সরি হিট কর\u{9be}",
                "হিট",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("ober mil"),
            keywords: &["gwenn", "ober mil"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("pikado"),
            keywords: &["cilj", "igra", "pikado", "strelica", "tabla"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("dards"),
            keywords: &["dard", "dards", "diana", "joc", "punteria"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏥᏳᎪᏗ ᎬᏂᎸᎢ"),
            keywords: &["ᎬᏂᎩ", "ᏗᏁᎶᏗᎢ", "ᏗᏲᏍᏗ", "ᏥᏳᎪᏗ ᎬᏂᎸᎢ", "ᏧᎧᏅᏍᏕᎾ ᎠᎦᏘ", "ᏩᏲᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("přesný zásah do terče"),
            keywords: &[
                "cíl",
                "hra",
                "přesný zásah do terče",
                "střed",
                "středu",
                "terč",
                "trefa",
                "zásah",
                "šipka",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("ergyd uniongyrchol"),
            keywords: &["ergyd uniongyrchol", "gêm", "llygad", "targed", "tarw"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("pletskud"),
            keywords: &["plet", "pletskud"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Darts"),
            keywords: &["Dart", "Darts", "Spiel", "Volltreffer", "Zielscheibe"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("βελάκια"),
            keywords: &[
                "βελάκι",
                "βελάκια",
                "διάνα",
                "κέντρο",
                "παιχνίδι",
                "στόχος",
                "ταμπλό",
                "χτύπημα",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("bullseye"),
            keywords: &["bullseye", "dart", "direct hit", "game", "hit", "target"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("bullseye"),
            keywords: &["bull", "bullseye", "dart", "eye", "game", "hit", "target"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("diana"),
            keywords: &["blanco", "diana", "en el blanco", "juego"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("dardo en el centro"),
            keywords: &[
                "centro",
                "dardo",
                "dardo en el centro",
                "diana",
                "juego",
                "objetivo",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "dardo",
                "dardo en el centro",
                "dardo en la diana",
                "diana",
                "objetivo",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["dardo", "dardo en el centro", "diana", "juego", "objetivo"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("täistabamus"),
            keywords: &["noolemäng", "sihtmärk", "tabamus", "täistabamus"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("itua"),
            keywords: &["dardo", "diana", "helburu", "itu", "itua", "joko"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پیکان در قلب هدف"),
            keywords: &[
                "بازی",
                "برخورد",
                "دارت",
                "ضربه مستقیم",
                "هدف",
                "وسط هدف",
                "پیکان در قلب هدف",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("napakymppi"),
            keywords: &[
                "darts",
                "häränsilmä",
                "kymmenen",
                "napakymppi",
                "tikka",
                "tikkataulu",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("bullseye"),
            keywords: &["bullseye", "dart", "target"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("dart"),
            keywords: &["beinrakið", "bullseye", "dart", "kúgveyga"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("dans le mille"),
            keywords: &["cible", "dans le mille"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["cible", "dans le mille", "fléchette"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("buille díreach"),
            keywords: &[
                "buille díreach",
                "cluiche",
                "sprioc",
                "súil ghloine",
                "súil sprice",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("san teis-mheadhan"),
            keywords: &[
                "amas",
                "bullseye",
                "geama",
                "san teis-mheadhan",
                "sgiathag",
                "targaid",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("diana"),
            keywords: &["dardo", "diana"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સીધી જ હિટ"),
            keywords: &[
                "બળદની આ\u{a82}ખ",
                "રમત",
                "લક\u{acd}ષ\u{acd}ય",
                "લક\u{acd}ષ\u{acd}ય પર જ",
                "સીધી જ હિટ",
                "હિટ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("bugawa ta kai tsaye"),
            keywords: &[
                "abin bara",
                "buga",
                "bugawa ta kai tsaye",
                "ido",
                "kai tsaye",
                "kibiya",
                "wasa",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פגיעה בול"),
            keywords: &["בול", "חץ", "מטרה", "משחק", "פגיעה בול", "קליעה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("लक\u{94d}ष\u{94d}य पर निशाना"),
            keywords: &[
                "ग\u{947}म",
                "चा\u{902}दमारी",
                "निशाना",
                "लक\u{94d}ष\u{94d}य",
                "लक\u{94d}ष\u{94d}य पर निशाना",
                "सीधा निशाना",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("pogodak u sredinu"),
            keywords: &[
                "cilj",
                "igra",
                "meta",
                "pogodak",
                "pogodak u sredinu",
                "sredina",
                "strelica",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("telitalálat"),
            keywords: &["bullseye", "játék", "találat", "telitalálat"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("դիպուկ հարված"),
            keywords: &[
                "դարթ",
                "դիպուկ հարված",
                "թիրախ",
                "խաղ",
                "կենտրոն",
                "հարվածել",
                "նշանակետ",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("dart"),
            keywords: &[
                "anak panah",
                "dart",
                "lempar",
                "mata",
                "papan sasaran",
                "permainan",
                "target",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("gara ka atụ\u{300}rụ\u{300}"),
            keywords: &[
                "anya",
                "ebe achọrọ",
                "egwuregwu",
                "egwuregwu ngwa okirikiri",
                "gara ka atụ\u{300}rụ\u{300}",
                "ngwa ntụ ngwa okirikiri",
                "nnweta",
                "nnweta etiti ngwa okirikiri",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("skotmark"),
            keywords: &["beint í mark", "leikur", "skotfimi", "skotmark"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("bersaglio"),
            keywords: &["bersaglio", "colpire", "gioco", "target"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("的"),
            keywords: &["スポーツ", "ダーツ", "ブルズアイ", "当たり", "的"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kena sasaran"),
            keywords: &["dart", "kena", "kena sasaran", "target", "tepat sasaran"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("პირდაპირი მოხვედრა"),
            keywords: &[
                "თამაში",
                "მოხვედრა",
                "პირდაპირი მოხვედრა",
                "სამიზნე",
                "სროლა",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("дәл тию"),
            keywords: &["дартс", "дартс найзасы", "дәл тию", "нысана", "ойын", "тию"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("pletskud"),
            keywords: &["plet", "pletskud"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("គប\u{17cb}ព\u{17d2}រ\u{17bd}ញ"),
            keywords: &[
                "គប\u{17cb}ច\u{17c6}កណ\u{17d2}ដាល",
                "គប\u{17cb}ព\u{17d2}រ\u{17bd}ញ",
                "គោលដៅ",
                "ព\u{17d2}រ\u{17bd}ញ",
                "ល\u{17d2}បែង",
                "ហ\u{17d2}គេម",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ನೇರ ಹೊಡ\u{cc6}ತ"),
            keywords: &[
                "ಆಟ",
                "ಟಾರ\u{ccd}ಗ\u{cc6}ಟ\u{ccd}",
                "ನೇರ ಹೊಡ\u{cc6}ತ",
                "ಸರ\u{cbf}ಯಾದ ಗುರ\u{cbf}",
                "ಹೊಡ\u{cc6}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("과녁 명중"),
            keywords: &["과녁", "명중", "양궁", "화살"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("थ\u{947}ट टप\u{94d}पो"),
            keywords: &[
                "ग\u{947}म",
                "डार\u{94d}ट",
                "थ\u{947}ट टप\u{94d}पो",
                "ब\u{942}ल\u{94d}सआय",
                "लक\u{94d}ष\u{94d}य",
                "हीट",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("дротик"),
            keywords: &["бута", "дротик", "көз", "оюн"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("an d’Mëtt getraff"),
            keywords: &[
                "Dart",
                "Match",
                "Mëtt",
                "Spill",
                "Volltreffer",
                "Zilscheif",
                "an d’Mëtt getraff",
                "treffen",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ກາງເປ\u{ebb}\u{ec9}າ"),
            keywords: &[
                "ກາງ",
                "ກາງເປ\u{ebb}\u{ec9}າ",
                "ເຂ\u{ebb}\u{ec9}າເປ\u{ebb}\u{ec9}າ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("smūgis tiesiai į taikinį"),
            keywords: &[
                "akis",
                "dartas",
                "pataikyti",
                "smūgis tiesiai į taikinį",
                "taikinys",
                "žaidimas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("šautriņa mērķī"),
            keywords: &["mērķis", "šautriņa", "šautriņa mērķī"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pā hāngai"),
            keywords: &["karu", "kēmu", "pere", "pironga", "pā", "pā hāngai", "pūru"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("пикадо"),
            keywords: &["игра", "пикадо", "стрелка", "цел", "центар"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഡയറക\u{d4d}റ\u{d4d}റ\u{d4d} ഹിറ\u{d4d}റ\u{d4d}"),
            keywords: &[
                "ഉന\u{d4d}നം",
                "ഗെയിം",
                "ഡയറക\u{d4d}റ\u{d4d}റ\u{d4d} ഹിറ\u{d4d}റ\u{d4d}",
                "ബ\u{d41}ൾ",
                "ബ\u{d41}ൾസ\u{d4d}\u{200c} ഐ",
                "ലക\u{d4d}ഷ\u{d4d}യം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("дартс"),
            keywords: &["бай", "бухын нүд", "дартс", "онох", "тоглоом", "шууд онох"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("थ\u{947}ट न\u{947}म"),
            keywords: &[
                "ग\u{947}म",
                "डार\u{94d}ट",
                "थ\u{947}ट न\u{947}म",
                "निशाणा",
                "ब\u{941}ल\u{94d}सआय",
                "लक\u{94d}ष\u{94d}य",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("balingan tepat"),
            keywords: &[
                "baling damak",
                "balingan tepat",
                "kena",
                "kena tepat",
                "permainan",
                "pusat sasaran",
                "sasaran",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("tir dirett"),
            keywords: &[
                "-mira",
                "bull",
                "bullseye",
                "għajn",
                "logħba",
                "tir",
                "tir dirett",
                "vleġġa",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဗဟ\u{102d}\u{102f}ချက\u{103a}ထ\u{102d}မ\u{103e}န\u{103a}ခြင\u{103a}း"),
            keywords: &[
                "ဂ\u{102d}မ\u{103a}း",
                "စက\u{103a}က\u{103d}င\u{103a}းဗဟ\u{102d}\u{102f}",
                "ထ\u{102d}မ\u{103e}န\u{103a}",
                "ဗဟ\u{102d}\u{102f}ချက\u{103a}ထ\u{102d}မ\u{103e}န\u{103a}ခြင\u{103a}း",
                "လက\u{103a}ပစ\u{103a}မြား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("blink"),
            keywords: &[
                "blink",
                "dart",
                "midt i blinken",
                "mål",
                "pilspill",
                "treff",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("डाइर\u{947}क\u{94d}ट हिट"),
            keywords: &[
                "ख\u{947}ल",
                "डाइर\u{947}क\u{94d}ट हिट",
                "डार\u{94d}ट",
                "लक\u{94d}ष\u{94d}य",
                "सा\u{901}ढ\u{947}को आ\u{901}खा",
                "हिट",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("directe treffer"),
            keywords: &[
                "bull’s eye",
                "darts",
                "directe treffer",
                "doelwit",
                "spel",
                "treffer",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("blink"),
            keywords: &["blink", "dart", "midt i blinken", "mål", "pilspel", "treff"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସଠ\u{b3f}କ\u{b4d} ହ\u{b3f}ଟ\u{b4d}"),
            keywords: &[
                "ଆଘ\u{b3e}ତ କର\u{b3f}ବ\u{b3e}",
                "ଖେଳ",
                "ଡ\u{b3e}ର\u{b4d}ଟ",
                "ପ\u{b4d}ରତ\u{b4d}ୟକ\u{b4d}ଷ ଆଘ\u{b3e}ତ",
                "ବ\u{b41}ଲସ\u{b4d}\u{200c}ଆଇ",
                "ଲକ\u{b4d}ଷ\u{b4d}ୟ",
                "ସଠ\u{b3f}କ\u{b4d} ହ\u{b3f}ଟ\u{b4d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸਿ\u{a71}ਧਾ ਨਿਸ\u{a3c}ਾਨਾ"),
            keywords: &[
                "ਖ\u{a47}ਡ",
                "ਟੀਚਾ",
                "ਬਲਦ ਦੀ ਅ\u{a71}ਖ",
                "ਮਾਰਨਾ",
                "ਸਹੀ ਟੀਚ\u{a47} ਤ\u{a47}",
                "ਸਿ\u{a71}ਧਾ ਨਿਸ\u{a3c}ਾਨਾ",
                "ਸਿ\u{a71}ਧਾ ਮਾਰਨਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("براہ راست ضرب لونا"),
            keywords: &[
                "اکھ",
                "براہ راست ضرب لونا",
                "تیر",
                "مارنا",
                "نشانہ",
                "نقطہ الحدف",
                "ٹگا",
                "کھیڈ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Dairẹ\u{301}kt Hit"),
            keywords: &[
                "Búlsai",
                "Daat",
                "Dairẹ\u{301}kt Hit",
                "Gem",
                "Hit",
                "Tágẹt",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("strzał w 10"),
            keywords: &[
                "dziesiątka",
                "strzał",
                "strzał w 10",
                "trafienie",
                "w dziesiątkę",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("مستقیم ویشتنه"),
            keywords: &[
                "د غويي سترګه",
                "لوبه",
                "مستقيم ويشتنه",
                "مستقیم ویشتنه",
                "ويشتنه",
                "په نښه کول",
                "ډارټ",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("no alvo"),
            keywords: &[
                "jogo",
                "mira",
                "na mosca",
                "no alvo",
                "tiro",
                "tiro certeiro",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("em cheio no alvo"),
            keywords: &["alvo", "centro", "dardo", "em cheio no alvo", "jogo"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("diana"),
            keywords: &["diana"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("fix la țintă"),
            keywords: &["centru", "darts", "fix la țintă", "reușită", "țintă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-367"),
            keywords: &["E10-367"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("мишень"),
            keywords: &["дартс", "доска", "дротик", "мишень", "попадание"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("gukubita ako kanya"),
            keywords: &[
                "akambi",
                "gukubita",
                "gukubita ako kanya",
                "hagati mu gipimo aho barasa mu mukino",
                "igipimo",
                "ijisho",
                "ikimasa",
                "umukino",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("سڌو هڻڻ"),
            keywords: &["حدف", "سڌو هڻڻ", "ڊارٽ", "ڍڳي وانگي اک"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("සෘජ\u{dd4} පහර"),
            keywords: &[
                "ඉලක\u{dca}කය",
                "ක\u{dca}\u{200d}ර\u{dd3}ඩ\u{dcf}ව",
                "ඩ\u{dcf}ර\u{dca}ට\u{dca}",
                "බ\u{dd4}ල\u{dca}ස\u{dca}අය\u{dd2}",
                "සෘජ\u{dd4} පහර",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("presný zásah"),
            keywords: &[
                "cieľ",
                "hra",
                "oko",
                "presný stred",
                "presný zásah",
                "stred",
                "zásah",
                "šípka",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("zadetek v polno"),
            keywords: &["igra", "pikado", "središče", "zadetek", "zadetek v polno"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("kudhaca toosan"),
            keywords: &[
                "bartilmaameed",
                "ciyaar",
                "dar",
                "isha dibiga",
                "kudhac",
                "kudhaca toosan",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("goditje e drejtpërdrejtë"),
            keywords: &[
                "goditje e drejtpërdrejtë",
                "lojë",
                "objektiv",
                "qendër",
                "shigjetë",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("погодак у центар"),
            keywords: &[
                "игрa",
                "мeтa",
                "пoгoдaк",
                "погодак у центар",
                "стрeлицa",
                "центар",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["погодак у центар"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("pogodak u centar"),
            keywords: &[
                "centar",
                "igra",
                "meta",
                "pogodak",
                "pogodak u centar",
                "strelica",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["pogodak u centar"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("mitt i prick"),
            keywords: &["fullträff", "mitt i prick", "pilkastning", "rakt på mål"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kulenga shabaha"),
            keywords: &[
                "gonga",
                "kigumba",
                "kulenga shabaha",
                "lengo",
                "lengo kuu",
                "mchezo",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சரிய\u{bbe}ன குறி"),
            keywords: &[
                "குறிப\u{bbe}ர\u{bcd}த\u{bcd}தல\u{bcd}",
                "கேம\u{bcd}",
                "சரிய\u{bbe}ன குறி",
                "துல\u{bcd}லியம\u{bbe}ன குறி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("డ\u{c48}ర\u{c46}క\u{c4d}ట\u{c4d} హ\u{c3f}ట\u{c4d}"),
            keywords: &[
                "ఆట",
                "డ\u{c48}ర\u{c46}క\u{c4d}ట\u{c4d} హ\u{c3f}ట\u{c4d}",
                "బ\u{c3e}ణం",
                "సర\u{c3f}గ\u{c4d}గ\u{c3e} లక\u{c4d}ష\u{c4d}య\u{c3e}న\u{c4d}న\u{c3f} క\u{c4a}ట\u{c4d}టడం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("рост рафта расидан"),
            keywords: &[
                "бозӣ",
                "буққа",
                "дарт",
                "задан",
                "нишона",
                "рост рафта расидан",
                "чашм",
                "ҳадаф",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("กลางเป\u{e49}า"),
            keywords: &[
                "กลางเป\u{e49}า",
                "ตรงเป\u{e49}า",
                "ปาเป\u{e49}า",
                "ล\u{e39}กดอก",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("dürs urgy"),
            keywords: &[
                "dart",
                "dürs urgy",
                "nyşana",
                "nyşanaň ortarasy",
                "oýun",
                "urgy",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("lotomālie ʻoe tāketi"),
            keywords: &["lotomālie ʻoe tāketi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("tam isabet"),
            keywords: &["hedef", "hedefe isabet", "isabet", "oyun", "tam isabet"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("دەل تېگىش"),
            keywords: &[
                "ئوقتام",
                "ئويۇن",
                "ئېتىش",
                "بۇقا",
                "دەل تېگىش",
                "قارىغا",
                "كۆز",
                "نىشان",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("мішень із прямим влученням"),
            keywords: &[
                "в яблучко",
                "влучення",
                "дротик",
                "мішень із прямим влученням",
                "точно",
                "ціль",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("براہ راست نشانہ"),
            keywords: &["براہ راست نشانہ", "تیر اندازی", "نشانہ", "کھیل", "ہدف"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("mo‘ljalni urish"),
            keywords: &[
                "buqa",
                "dart",
                "ko‘z",
                "mo‘ljal",
                "mo‘ljalni urish",
                "o‘yin",
                "taget",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("trúng đích"),
            keywords: &["hồng tâm", "mục tiêu", "phi tiêu", "trò chơi", "trúng đích"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("dóor bu jub"),
            keywords: &[
                "bët",
                "bëtu nag",
                "ci digg bi",
                "dóor bu jub",
                "fett",
                "jam",
                "nag",
                "po",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ukuchana ngokuthe ngqo"),
            keywords: &[
                "chana",
                "i-bull",
                "i-bullseye",
                "i-dart",
                "iliso",
                "into ekujoliswe kuyo",
                "ukuchana ngokuthe ngqo",
                "umdlalo",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Igba Taara"),
            keywords: &[
                "Igba Taara",
                "akọ màlú",
                "eré",
                "gún",
                "pálí ayò",
                "àfojúsùn",
                "ọ\u{300}gángọ\u{301} ayò",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("箭靶"),
            keywords: &["中心", "目標", "箭靶", "靶心", "飛鏢"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("箭靶"),
            keywords: &["中心", "击中", "游戏", "目标", "箭靶", "靶", "靶心", "飞镖"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("正中靶心的飞镖"),
            keywords: &["命中", "正中靶心的飞镖", "靶心", "飞镖"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("命中"),
            keywords: &["命中", "正中紅心"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ukunemba"),
            keywords: &["idathi", "ihlo", "impokophelo", "ukunemba", "umdlalo"],
        },
    ],
};
#[doc = "🪀"]
pub const YO_YO: crate::Emoji = crate::Emoji {
    glyph: "🪀",
    codepoint: "1FA80",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "yo-yo",
    group: "Activities",
    subgroup: "game",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("jojo"),
            keywords: &["jojo", "op en af", "speelding"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("በከራ"),
            keywords: &["መጫወቻ", "በከራ", "ተለዋዋጭ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("يويو"),
            keywords: &["تأرجح", "كلات", "لعبة", "يويو"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ইয\u{9bc}’-ইয\u{9bc}’"),
            keywords: &[
                "ইয\u{9bc}’-ইয\u{9bc}’",
                "উঠ\u{9be} নম\u{9be} কৰ\u{9be}",
                "প\u{9c1}তল\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("yo-yo"),
            keywords: &["dalğalanma", "oyuncaq", "yo-yo"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("ё-ё"),
            keywords: &["матляцца", "цацка", "ё-ё"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("йо-йо"),
            keywords: &["въртене", "играчка", "йо-йо", "навиване"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("য\u{9bc}ো-য\u{9bc}ো"),
            keywords: &[
                "খেলন\u{9be}",
                "ফ\u{9cd}ল\u{9cd}য\u{9be}কচ\u{9c1}য\u{9bc}েট",
                "য\u{9bc}ো-য\u{9bc}ো",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("pun-dibun"),
            keywords: &["cʼhoariell", "pun-dibun"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("yo-yo"),
            keywords: &["gibanje", "igračka", "yo-yo"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("io-io"),
            keywords: &["fluctuar", "io-io", "joguina"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏲᏲ"),
            keywords: &["ᎦᏁᏟᏴᎭ", "ᏗᏁᏙᏗ", "ᏲᏲ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("jojo"),
            keywords: &["cívka", "hračka", "jo jo", "jo-jo", "jojo", "kolísání"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("io-io"),
            keywords: &["fyny ac i lawr", "io-io", "tegan"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("yoyo"),
            keywords: &["legetøj", "yoyo"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Jo-Jo"),
            keywords: &["Jo-Jo", "Spielzeug"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("γιογιό"),
            keywords: &["γιογιό", "κουνιέμαι", "παιχνίδι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("yo-yo"),
            keywords: &["fluctuate", "toy", "yo-yo"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("yoyó"),
            keywords: &["dieta", "efecto", "fluctuar", "juguete", "yoyó"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("yoyo"),
            keywords: &["yoyo"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("jojo"),
            keywords: &["edasi-tagasi", "jojo", "keerlemine", "ketas", "mänguasi"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("yoyoa"),
            keywords: &["gora eta behera", "jostailua", "yo-yoa", "yoyoa"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("یویو"),
            keywords: &["اسباب\u{200c}بازی", "نوسان", "یویو"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("jojo"),
            keywords: &["jojo", "jojoilla", "lelu"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("yoyo"),
            keywords: &["laruan", "pabalik-balik", "pataas-pababa", "yoyo"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("jojo"),
            keywords: &["jojo", "leika", "yo yo", "yo-yo", "yoyo"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("yoyo"),
            keywords: &["descendre", "jouet", "monter", "osciller", "yoyo"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("yó-yó"),
            keywords: &["athraigh", "bréagán", "yó-yó"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("yo-yo"),
            keywords: &[
                "atharrachadh",
                "atharraich",
                "dèideag",
                "luaisg",
                "luasgadh",
                "yo-yo",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("ioió"),
            keywords: &["ioió", "xoguete"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("યો-યો"),
            keywords: &["બદલાયા કરવ\u{ac1}\u{a82}", "યો-યો", "રમકડ\u{ac1}\u{a82}"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("יו-יו"),
            keywords: &["יו-יו", "עולה ויורד", "צעצוע"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("यो-यो"),
            keywords: &["खिलौना", "ख\u{947}ल", "यो यो", "यो-यो", "लट\u{94d}ट\u{942}"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("jo-jo"),
            keywords: &["igračka", "jo-jo"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("jojó"),
            keywords: &["jojó", "jojózik", "játék"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("յո-յո"),
            keywords: &["խաղալիք", "ճոճվող", "յո-յո"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("yo-yo"),
            keywords: &["mainan", "naik-turun", "yo-yo"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("jójó"),
            keywords: &["jójó", "leikfang"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("yo-yo"),
            keywords: &["giocattolo", "rocchetto", "yo-yo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ヨーヨー"),
            keywords: &["おもちゃ", "ヨーヨー", "回転", "玩具"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("yoyo"),
            keywords: &["dolanan", "yoyo"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("იო-იო"),
            keywords: &["იო-იო", "იოიო", "სათამაშო"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("йо-йо"),
            keywords: &["йо-йо", "ойыншық", "тербелу"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("យ\u{17c9}\u{17bc}យ\u{17c9}\u{17bc}"),
            keywords: &[
                "ច\u{17bb}ះឡើង",
                "យ\u{17c9}\u{17bc}យ\u{17c9}\u{17bc}",
                "របស\u{17cb}ក\u{17d2}មេងលេង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಯೋ-ಯೋ"),
            keywords: &["ಆಟ\u{cbf}ಕ\u{cc6}", "ಏರ\u{cbf}ಳ\u{cbf}ತ", "ಯೋ-ಯೋ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("요요"),
            keywords: &["오르락내리락", "요요", "장난감"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("यो यो"),
            keywords: &["उफ\u{947}वपी", "ख\u{947}ळण\u{947}\u{902}", "यो यो", "यो-यो"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жипке илинген шайтан"),
            keywords: &["жипке илинген шайтан", "оюнчук", "термелгич"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໂຢ\u{200b}ໂຢ\u{ec9}"),
            keywords: &[
                "ໂຢ\u{200b}ໂຢ\u{ec9}",
                "\u{200b}ຂອງຫ\u{ebc}\u{eb4}\u{ec9}ນ",
                "\u{200b}ຂ\u{eb6}\u{ec9}ນໆ\u{200b}ລ\u{ebb}ງໆ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("jo-jo"),
            keywords: &["jo-jo", "svyruojantis", "žaislas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("jojo"),
            keywords: &["jojo", "rotaļlieta", "svārstīgs"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("јојо"),
            keywords: &["играчка", "јојо"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("യോ-യോ"),
            keywords: &["ഇളക\u{d41}ക", "കളിപ\u{d4d}പ\u{d3e}ട\u{d4d}ടം", "യോ-യോ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("ёо-ёо"),
            keywords: &["тоглоом", "хэлбэлзэл", "ёо-ёо"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("यो-यो"),
            keywords: &["अस\u{94d}थिर", "ख\u{947}ळण\u{947}", "यो-यो"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("yo-yo"),
            keywords: &["mainan", "naik turun", "yo-yo"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ယ\u{102d}\u{102f}ယ\u{102d}\u{102f}"),
            keywords: &[
                "ကစားစရာ",
                "ကြ\u{102d}\u{102f}းတပ\u{103a}ဂျင\u{103a}",
                "ယ\u{102d}\u{102f}ယ\u{102d}\u{102f}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("jojo"),
            keywords: &["jojo", "leke", "opp og ned"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("यो\u{200d}-यो"),
            keywords: &[
                "ख\u{947}लौना",
                "फ\u{94d}लक\u{94d}ट\u{941}एट",
                "यो\u{200d}-यो",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("jojo"),
            keywords: &["fluctueren", "jojo", "speelgoed"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("jojo"),
            keywords: &["jojo", "leike", "opp og ned"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ୟୋ ୟୋ"),
            keywords: &["ଖେଳଣ\u{b3e}", "ଦୋଳ\u{b3e}ୟମ\u{b3e}ନ", "ୟୋ ୟୋ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਯ\u{a4b}-ਯ\u{a4b}"),
            keywords: &[
                "ਖਿਡ\u{a4c}ਣਾ",
                "ਝ\u{a42}ਮਦਾ ਖਿਡ\u{a4c}ਣਾ",
                "ਯ\u{a4b}-ਯ\u{a4b}",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Yó-Yo"),
            keywords: &["Tọi", "Yó-Yo", "Ọ\u{301}p An Daun"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("jojo"),
            keywords: &["gra", "jojo", "zabawka"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("يو يو"),
            keywords: &["يو يو", "پر يوه حال نه پاته کېدل، لوبتکه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("ioiô"),
            keywords: &["brinquedo", "flutua", "ioiô"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("ioió"),
            keywords: &["brinquedo", "ioió"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("yo-yo"),
            keywords: &["fluctua", "jucărie", "yo-yo"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E12–066"),
            keywords: &["E12–066"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("йо-йо"),
            keywords: &["игрушка", "йо-йо", "йойо"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("یو-یو"),
            keywords: &["رانديڪو", "فلڪچويٽ", "یو-یو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("යෝ-යෝ"),
            keywords: &[
                "උච\u{dca}ච\u{dcf}වචනය",
                "යෝ-යෝ",
                "සෙල\u{dca}ලම\u{dca} බඩ\u{dd4}ව",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("jojo"),
            keywords: &["cievka", "hračka", "jo-jo", "jojo", "kolísanie"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("jojo"),
            keywords: &["igrača", "jojo", "nihanje", "proč sem"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("qaanso"),
            keywords: &["alaabaha caruurta", "qaanso", "sabbayn"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("jo-jo"),
            keywords: &["jo-jo", "lodër", "lodër që kthehet", "luhatje"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("јојо"),
            keywords: &["играчка", "јојо", "њихање"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("jojo"),
            keywords: &["igračka", "jojo", "njihanje"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("jojo"),
            keywords: &["jojare", "jojo", "snöre", "trissa"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kigurudumu cha uzi"),
            keywords: &[
                "kidude cha kuchezea",
                "kigurudumu cha uzi",
                "kupanda na kushuka",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("யோ யோ"),
            keywords: &["ஏற\u{bcd}ற இறக\u{bcd}கம\u{bcd}", "பொம\u{bcd}மை", "யோ யோ"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("య\u{c4b}-య\u{c4b}"),
            keywords: &[
                "ఆటబ\u{c4a}మ\u{c4d}మ",
                "య\u{c4b}-య\u{c4b}",
                "హ\u{c46}చ\u{c4d}చుతగ\u{c4d}గులు",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("โยโย\u{e48}"),
            keywords: &[
                "ของเล\u{e48}น",
                "ข\u{e36}\u{e49}นๆ ลงๆ",
                "ล\u{e39}กด\u{e34}\u{e48}ง",
                "โยโย\u{e48}",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýo-ýo"),
            keywords: &["oýunjak", "üýtge", "ýo-ýo"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ioio"),
            keywords: &["ioio"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yoyo"),
            keywords: &["inip çıkma", "oyuncak", "yoyo"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("йо-йо"),
            keywords: &[
                "бовтатися",
                "йо-йо",
                "метлятися",
                "теліпатися",
                "хилитатися",
                "іграшка",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("یو یو"),
            keywords: &["جھولنا", "کھلونا", "یو یو"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("yo-yo"),
            keywords: &["oʻyinchoq", "pirildoq", "yo-yo"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("yo-yo"),
            keywords: &["dao động", "yo-yo", "đồ chơi"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("搖搖"),
            keywords: &["搖", "搖搖", "玩具"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("摇摇"),
            keywords: &["摇", "摇摇", "玩具"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("悠悠球"),
            keywords: &["上下起落", "悠悠球", "玩具"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("溜溜球"),
            keywords: &["溜溜球", "滾動", "玩具"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("搖搖"),
            keywords: &["搖搖", "滾動", "玩具"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("i-yo-yo"),
            keywords: &["i-yo-yo", "ithoyi", "ukungahlaliseki"],
        },
    ],
};
#[doc = "🪁"]
pub const KITE: crate::Emoji = crate::Emoji {
    glyph: "🪁",
    codepoint: "1FA81",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "kite",
    group: "Activities",
    subgroup: "game",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("vlieër"),
            keywords: &["sweef", "vlieg", "vlieër"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ካይት"),
            keywords: &["ሰማይ ወጣ", "አንዣበበ", "ካይት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("طائرة ورقية"),
            keywords: &["تحليق", "طائرة ورقية", "طيارة", "طيران"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("চিল\u{9be}"),
            keywords: &[
                "উৰ\u{9be}",
                "চিল\u{9be}",
                "মহ\u{9be}শ\u{9c2}ন\u{9cd}যত বহ\u{9c1} ওপৰলৈ উৰ\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("çərpələng"),
            keywords: &["havada üzmə", "uçuş", "çərpələng"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("паветраны змей"),
            keywords: &["лунаць", "лятаць", "лётаць", "паветраны змей"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("хвърчило"),
            keywords: &["летене", "полет", "реене", "хвърчило"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ঘ\u{9c1}ড\u{9bc}ি"),
            keywords: &[
                "ওড\u{9bc}\u{9be}",
                "ঘ\u{9c1}ড\u{9bc}ি",
                "ম\u{9be}ঝ আক\u{9be}শে",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("sarpant-nij"),
            keywords: &["nijal", "sarpant-nij"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("zmaj od papira"),
            keywords: &["lebdjenje", "letenje", "zmaj od papira"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("estel"),
            keywords: &["enlairar-se", "estel", "volar"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎳᏫᏅᏙᏗ"),
            keywords: &["ᎠᎳᏫᏅᏙᏗ", "ᎦᏃᎯᎵ", "ᎦᏃᎯᎵᏙᎯ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("papírový drak"),
            keywords: &[
                "let",
                "létání",
                "papírový drak",
                "pouštění",
                "stoupání",
                "vzlétnutí",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("barcud"),
            keywords: &["barcud", "esgyn", "hedfan"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("legetøjsdrage"),
            keywords: &["flyve", "legetøjsdrage", "svæve"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Drachen"),
            keywords: &["Drachen", "fliegen", "steigen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("χαρταετός"),
            keywords: &["αιωρούμαι", "πετάω", "χαρταετός"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("kite"),
            keywords: &["fly", "kite", "soar"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cometa"),
            keywords: &["cometa", "juguete", "planear", "viento", "volar"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "cometa", "juguete", "papalote", "planear", "viento", "volar",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["cometa", "papalote", "planear", "volar"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("tuulelohe"),
            keywords: &["lennutamine", "lohe", "tuul", "tuulelohe"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("haize-parpaila"),
            keywords: &["haize-parpaila", "hegaldarazi", "hegaldatu", "kometa"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("بادبادک"),
            keywords: &["اوج گرفتن", "بادبادک"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("leija"),
            keywords: &["leija", "leijailla", "lennättää"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("saranggola"),
            keywords: &["lumipad", "pumailanlang", "saranggola"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("flúgvandi dreki"),
            keywords: &["dreki", "flúgvandi dreki"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("cerf-volant"),
            keywords: &["cerf-volant", "planer", "voler"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("eitleog"),
            keywords: &["eitil", "eitleog", "in airde"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("itealag"),
            keywords: &[
                "itealach",
                "itealag",
                "itealaich",
                "sgait-adhair",
                "sgiathadh",
                "sgiathaich",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("papaventos"),
            keywords: &["papaventos", "voar", "xoguete"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પત\u{a82}ગ"),
            keywords: &[
                "ઊ\u{a82}ચ\u{ac7} ઊડવ\u{ac1}\u{a82}",
                "ઊડવ\u{ac1}\u{a82}",
                "પત\u{a82}ગ",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("עפיפון"),
            keywords: &["להעיף", "מתעופף", "מתרומם", "עפיפון"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("पत\u{902}ग"),
            keywords: &["उड\u{93c}ान", "पत\u{902}ग"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("papirnati zmaj"),
            keywords: &["igračka", "let", "papirnati zmaj"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("papírsárkány"),
            keywords: &["papírsárkány", "repül", "szárnyal"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("օդապարուկ"),
            keywords: &["թռչել", "սավառնել", "օդապարուկ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("layang-layang"),
            keywords: &["layang-layang", "melayang", "terbang"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("flugdreki"),
            keywords: &["fljúga", "flugdreki", "svífa"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("aquilone"),
            keywords: &["aquilone", "planare", "volare"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("たこ"),
            keywords: &["おもちゃ", "たこ", "カイト", "凧揚げ", "玩具"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("layangan"),
            keywords: &["layangan", "mabur", "nglayang"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ფრანი"),
            keywords: &["ნავარდი", "ფრანი", "ფრენა", "ქარი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қағаз батпырауық"),
            keywords: &["қалықтау", "қағаз батпырауық", "ұшу"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ខ\u{17d2}លែង"),
            keywords: &["ខ\u{17d2}លែង", "ស\u{17c6}កា\u{17c6}ង", "ហោះ"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಗಾಳ\u{cbf}ಪಟ"),
            keywords: &["ಎತ\u{ccd}ತರವಾಗ\u{cbf} ಹಾರು", "ಗಾಳ\u{cbf}ಪಟ", "ಹಾರು"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("연"),
            keywords: &["연", "연날리기", "활공"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("पत\u{902}ग"),
            keywords: &["उडप", "धागो", "पत\u{902}ग"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("Кагаз батперек"),
            keywords: &["Кагаз батперек", "бийик", "учуу"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ວ\u{ec8}າວ"),
            keywords: &[
                "ຂ\u{200b}ອງຫ\u{ebc}\u{eb4}\u{ec9}ນ",
                "ບ\u{eb4}ນ\u{200b}ໄດ\u{ec9}",
                "ລ\u{200b}ອຍ\u{200b}ກາງ\u{200b}ອາ\u{200b}ກາດ",
                "ວ\u{ec8}າວ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("aitvaras"),
            keywords: &["aitvaras", "pakilti", "skristi"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("gaisa pūķis"),
            keywords: &["gaisa pūķis", "lidot", "pacelties"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("летечки змеј"),
            keywords: &["вивнување", "летање", "летечки змеј"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പട\u{d4d}ടം"),
            keywords: &["ഉയര\u{d41}ക", "പട\u{d4d}ടം", "പറക\u{d4d}ക\u{d41}ക"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("цаасан шувуу"),
            keywords: &["нисэх", "цаасан шувуу", "элин халих"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("पत\u{902}ग"),
            keywords: &["उडण\u{947}", "उडवण\u{947}", "पत\u{902}ग"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("layang-layang"),
            keywords: &["layang-layang", "melayang", "terbang"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("စ\u{103d}န\u{103a}"),
            keywords: &[
                "စ\u{103d}န\u{103a}",
                "စ\u{103d}န\u{103a}လ\u{103d}\u{103e}တ\u{103a}",
                "ပျ\u{1036}ဝ\u{1032}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("papirdrage"),
            keywords: &["fly", "papirdrage", "sveve"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("चङ\u{94d}गा"),
            keywords: &["उडान", "चङ\u{94d}गा", "सोर"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("vlieger"),
            keywords: &["vliegen", "vlieger", "zweven"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("papirdrake"),
            keywords: &["fly", "papirdrake", "sveve"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଗ\u{b41}ଡ\u{b3f}"),
            keywords: &[
                "ଉଚ\u{b4d}ଚରେ ଉଡ\u{b3f}ବ\u{b3e}",
                "ଉଡ\u{b3f}ବ\u{b3e}",
                "ଗ\u{b41}ଡ\u{b3f}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪਤ\u{a70}ਗ"),
            keywords: &["ਉ\u{a71}ਡਦਾ ਪਤ\u{a70}ਗ", "ਪਤ\u{a70}ਗ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Kait"),
            keywords: &["Flai", "Kait", "Raíz Ọ\u{301}p Hai Kwík Kwik"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("latawiec"),
            keywords: &["latanie", "latawiec", "puszczanie"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("پتنګ"),
            keywords: &["الوتل", "پتنګ", "په پورته تلل"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("pipa"),
            keywords: &["pipa", "planar", "voar"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("papagaio de papel"),
            keywords: &["papagaio de papel", "planar", "voar"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("zmeu"),
            keywords: &["plana", "pluti", "zbura", "zmeu"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E12–067"),
            keywords: &["E12–067"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("воздушный змей"),
            keywords: &["ветер", "воздушный змей", "змей", "летать", "парить"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("لغڙ"),
            keywords: &["اڏام", "سور", "لغڙ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("සර\u{dd4}ංගලය"),
            keywords: &[
                "අහසට ප\u{dd2}ය\u{dcf}සර ක\u{dd2}ර\u{dd3}ම",
                "ප\u{dd2}යැඹ\u{dd3}ම",
                "සර\u{dd4}ංගලය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("papierový šarkan"),
            keywords: &[
                "let",
                "lietanie",
                "papierový šarkan",
                "púšťanie",
                "stúpanie",
                "vzlietnutie",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("zmaj (igrača)"),
            keywords: &["jadrati", "leteti", "zmaj (igrača)"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("abitey"),
            keywords: &["abitey", "buubid", "duulid"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("balonë"),
            keywords: &["balonë", "fluturoj", "ngre në qiell"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("змај на ветар"),
            keywords: &["змај на ветар", "летење", "једрење"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("змај на вјетар"),
            keywords: &["змај на вјетар"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("zmaj na vetar"),
            keywords: &["jedrenje", "letenje", "zmaj na vetar"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("zmaj na vjetar"),
            keywords: &["zmaj na vjetar"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("flygande drake"),
            keywords: &["flyga", "flygande drake", "sväva"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kishada"),
            keywords: &["kishada", "paa", "ruka"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பட\u{bcd}டம\u{bcd}"),
            keywords: &[
                "உயரப\u{bcd}பறத\u{bcd}தல\u{bcd}",
                "பட\u{bcd}டம\u{bcd}",
                "பறப\u{bcd}பது",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("గ\u{c3e}ల\u{c3f} పటం"),
            keywords: &[
                "ఎగర\u{c47}యడం",
                "గ\u{c3e}ల\u{c3f} పటం",
                "ప\u{c48}క\u{c46}గురు",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ว\u{e48}าว"),
            keywords: &["บ\u{e34}น", "ว\u{e48}าว", "เล\u{e48}นลม"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("batberek"),
            keywords: &["asmana göterilmek", "batberek", "uçmak"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("lofa"),
            keywords: &["lofa"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("uçurtma"),
            keywords: &["süzülme", "uçma", "uçurtma"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("повітряний змій"),
            keywords: &[
                "витати",
                "линути",
                "літати",
                "повітряний змій",
                "підніматися",
                "ширяти",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("پتنگ"),
            keywords: &["اڑنا", "پتنگ", "ہوا میں بلند ہونا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("varrak"),
            keywords: &["aylanish", "uchish", "varrak"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("diều"),
            keywords: &["bay", "bay lên", "bay lượn", "diều"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("風箏"),
            keywords: &["風箏", "飛", "高飛"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("风筝"),
            keywords: &["风筝", "飞", "高飞"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("风筝"),
            keywords: &["翱翔", "风筝", "飞翔"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("風箏"),
            keywords: &["上升", "風箏", "飛"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("i-kite"),
            keywords: &["i-kite", "i-soar", "ukuphaph"],
        },
    ],
};
#[doc = "🎱"]
pub const POOL_8_BALL: crate::Emoji = crate::Emoji {
    glyph: "🎱",
    codepoint: "1F3B1",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "pool 8 ball",
    group: "Activities",
    subgroup: "game",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("biljart"),
            keywords: &["8", "agt", "bal", "biljart", "snoeker", "speel"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የከረንቦላ ድንጋይ"),
            keywords: &["8", "ስምንት", "ከረንቦላ", "ኳስ", "የከረንቦላ ድንጋይ", "ጨዋታ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}بلياردو"),
            keywords: &["كرة رقم ثمانية", "لعبة", "\u{202b}بلياردو"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("প\u{9c1}ল খেলৰ ৮ নম\u{9cd}বৰ বল"),
            keywords: &[
                "আঠ",
                "প\u{9c1}ল খেলৰ ৮ নম\u{9cd}বৰ বল",
                "বল",
                "বিলিয\u{9bc}\u{9be}ৰ\u{9cd}ড",
                "৮",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("bilyard"),
            keywords: &["8", "bilyard", "oyun", "səkkiz", "top"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("більярд"),
            keywords: &["8", "більярд", "восем", "гульня", "кій", "шар"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("билярд"),
            keywords: &["8", "билярд", "игра", "осмица", "топка"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("8 বলের প\u{9c1}ল"),
            keywords: &[
                "8 প\u{9c1}ল বল",
                "8 বলের প\u{9c1}ল",
                "আট",
                "খেল\u{9be}",
                "বল",
                "বিলিয\u{9bc}\u{9be}র\u{9cd}ড",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("bilhard saoz"),
            keywords: &["8", "bilhard", "bilhard saoz", "boul"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("bilijar"),
            keywords: &["bilijar", "igra", "osmica"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("bola de billar"),
            keywords: &[
                "8",
                "billar",
                "bola",
                "bola de billar",
                "bola negra de billar",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("8 ᎪᏪᎳ ᎦᏓᏲᏍᏗ"),
            keywords: &["8", "8 ᎪᏪᎳ ᎦᏓᏲᏍᏗ", "ᎦᏓᏲᏍᏗ", "ᏗᏁᏟᏙᏗ", "ᏣᏁᎳ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("kulečníková koule 8"),
            keywords: &[
                "8",
                "biliár",
                "billiard",
                "hra",
                "koule",
                "kulečník",
                "kulečníková koule 8",
                "osm",
                "pool",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("biliards"),
            keywords: &["biliards", "gêm", "wyth"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("billard"),
            keywords: &["billard", "billardkugle", "pool"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Billardkugel"),
            keywords: &["8-Ball", "Billardkugel", "Kugel", "Spiel"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μπάλα 8 μπιλιάρδου"),
            keywords: &[
                "8",
                "μπάλα",
                "μπάλα 8 μπιλιάρδου",
                "μπάλα με το 8",
                "μπιλιάρδο",
                "οκτώ",
                "παιχνίδι",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("pool 8 ball"),
            keywords: &["8", "ball", "billiard", "eight", "game", "pool 8 ball"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("bola negra de billar"),
            keywords: &["8", "billar", "bola negra de billar", "bola ocho", "juego"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("bola ocho"),
            keywords: &["8", "billar", "bola", "ocho", "pool"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("piljardikuul"),
            keywords: &["8", "kuul", "mäng", "piljard", "piljardikuul"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("billarra"),
            keywords: &["8", "billar", "billarra", "bola", "joko", "zortzi"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("بیلیارد"),
            keywords: &["بازی", "بال", "بیلیارد", "هشت", "۸", "۸ توپ"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("biljardi"),
            keywords: &["biljardi", "biljardipallo", "kasipallo", "pallo", "peli"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("billiards"),
            keywords: &["8", "billiard", "billiards", "bola", "eight", "pool"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("pul"),
            keywords: &["billard", "kúla", "pool", "pul"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("boule de billard"),
            keywords: &["billard", "boule de billard", "jeu", "pool"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("liathróid 8 púil"),
            keywords: &["cluiche", "liathróid 8 púil", "snúcar"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("bàla a h-ochd"),
            keywords: &[
                "8",
                "ball",
                "billiard",
                "bàla",
                "bàla a h-ochd",
                "gèam",
                "ochd",
                "pool",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("billar"),
            keywords: &["billar", "bola"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("બિલિયર\u{acd}ડ"),
            keywords: &["આઠ બોલ", "બિલિયર\u{acd}ડ", "રમત"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("ƙwallon pool 8"),
            keywords: &[
                "8",
                "takwas",
                "wasa",
                "wasan billard",
                "ƙwallo",
                "ƙwallon 8",
                "ƙwallon pool 8",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("כדור ביליארד"),
            keywords: &["ביליארד", "כדור", "משחק", "סנוקר"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("बिलियर\u{94d}ड"),
            keywords: &["आठ ग\u{947}\u{902}द", "ग\u{947}म", "बिलियर\u{94d}ड"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("biljarske kugle"),
            keywords: &["8", "biljarske kugle", "igra", "kugla", "osam"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("biliárd"),
            keywords: &["8-as", "biliárd", "biliárdgolyó", "golyó"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բիլիարդ"),
            keywords: &["8", "բիլիարդ", "գնդակ", "խաղ", "ութ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("biliar 8 bola"),
            keywords: &["8", "biliar 8 bola", "bola", "delapan", "game"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("Poolu 8 bọọlụ"),
            keywords: &[
                "8",
                "Poolu 8 bọọlụ",
                "asatọ",
                "billiardị",
                "bọọlụ",
                "egwuregwu",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("billjard"),
            keywords: &["biljarður", "billjard", "leikur", "pool"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("palla da biliardo"),
            keywords: &["biliardo", "gioco", "palla da biliardo", "palla otto"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ビリヤード"),
            keywords: &["エイトボール", "スポーツ", "ビリヤード", "ボール"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("pool bal 8"),
            keywords: &["8", "bal", "bilyar", "game", "pool bal 8", "wolu"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ბილიარდი"),
            keywords: &["8", "ბილიარდი", "ბურთი", "თამაში", "რვა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("биллиярд"),
            keywords: &[
                "8",
                "8 шарлы пул",
                "биллиярд",
                "бильярд",
                "ойын",
                "сегіз",
                "шар",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("billard"),
            keywords: &["billard", "billardkugle"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("គ\u{17d2}រាប\u{17cb}ប\u{17ca}\u{17b8}យ\u{17c9}ាលេខ៨"),
            keywords: &[
                "គ\u{17d2}រាប\u{17cb}ប\u{17ca}\u{17b8}យ\u{17c9}ា",
                "គ\u{17d2}រាប\u{17cb}ប\u{17ca}\u{17b8}យ\u{17c9}ាលេខ ៨",
                "គ\u{17d2}រាប\u{17cb}ប\u{17ca}\u{17b8}យ\u{17c9}ាលេខ៨",
                "ប\u{17ca}\u{17b8}យ\u{17c9}ា",
                "ប\u{17d2}រា\u{17c6}ប\u{17b8}",
                "ល\u{17d2}បែង",
                "ហ\u{17d2}គេម",
                "៨",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬ\u{cbf}ಲ\u{cbf}ಯರ\u{ccd}ಡ\u{ccd}ಸ\u{ccd}"),
            keywords: &[
                "ಆಟ",
                "ಎಂಟು ಚ\u{cc6}ಂಡು",
                "ಬ\u{cbf}ಲ\u{cbf}ಯರ\u{ccd}ಡ\u{ccd}",
                "ಬ\u{cbf}ಲ\u{cbf}ಯರ\u{ccd}ಡ\u{ccd}ಸ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("당구"),
            keywords: &["당구", "당구 게임", "당구공"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("प\u{942}ल 8 बॉल"),
            keywords: &[
                "8",
                "आठ",
                "ग\u{947}म",
                "प\u{942}ल 8 बॉल",
                "बिलियार\u{94d}ड",
                "बॉल",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("бильярд"),
            keywords: &["8", "8 шар", "бильярд", "оюн", "сегиз"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Billardkugel"),
            keywords: &[
                "8",
                "8-Ball",
                "Billardkugel",
                "Billiard",
                "Kugel",
                "Spill",
                "aacht",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ສະນ\u{eb8}ກເກ\u{eb5}"),
            keywords: &["8", "ສະນ\u{eb8}ກເກ\u{eb5}", "ເກມ 8", "ແປດ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("biliardo kamuoliukas"),
            keywords: &[
                "8",
                "8 kamuoliukas",
                "biliardas",
                "biliardo kamuoliukas",
                "žaidimas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("biljarda bumbiņa"),
            keywords: &["8", "astoņi", "biljarda bumbiņa", "biljards", "spēle"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("piriota 8 pōro"),
            keywords: &["8", "kēmu", "piriota", "pōro", "waru"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("црна топка за билјард"),
            keywords: &[
                "билјард",
                "топка",
                "црна топка за билијар",
                "црна топка за билјард",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ബില\u{d4d}യ\u{d3e}ർഡ\u{d4d}\u{200c}സ\u{d4d}"),
            keywords: &[
                "ഗെയിം",
                "ബില\u{d4d}യ\u{d3e}ർഡ\u{d4d}",
                "ബില\u{d4d}യ\u{d3e}ർഡ\u{d4d}\u{200c}സ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("биллиард"),
            keywords: &[
                "8",
                "биллиард",
                "бөмбөг",
                "найм",
                "пүүл бөмбөг 8",
                "тоглоом",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("बिलियर\u{94d}ड\u{94d}\u{200d}स"),
            keywords: &[
                "8",
                "आठ",
                "ग\u{947}म",
                "प\u{941}ल 8 बॉल",
                "बिलियर\u{94d}ड",
                "बिलियर\u{94d}ड\u{94d}\u{200d}स",
                "बॉल",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("biliard"),
            keywords: &["8", "biliard", "bola", "lapan", "permainan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ballun ta’ pool 8"),
            keywords: &[
                "8",
                "ballun",
                "ballun ta’ pool 8",
                "billiard",
                "logħba",
                "tmien",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဘ\u{102d}လ\u{102d}ယက\u{103a} ဘောလ\u{102f}\u{1036}းန\u{1036}ပါတ\u{103a} ၈"),
            keywords: &[
                "ဂ\u{102d}မ\u{103a}း",
                "ဘ\u{102d}လ\u{102d}ယက\u{103a}",
                "ဘ\u{102d}လ\u{102d}ယက\u{103a} ဘောလ\u{102f}\u{1036}းန\u{1036}ပါတ\u{103a} ၈",
                "ဘောလ\u{102f}\u{1036}း",
                "၈",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("biljard"),
            keywords: &["8", "biljard", "spill", "åtte", "åtterkule"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("बिलियर\u{94d}ड\u{94d}स"),
            keywords: &["आठ", "ख\u{947}ल", "बल", "बिलियर\u{94d}ड\u{94d}स", "८"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("biljart"),
            keywords: &["8", "8 ball", "acht", "bal", "biljart", "spel"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("biljard"),
            keywords: &["8", "biljard", "spel", "åttarkule", "åtte"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଫ\u{b41}ଲ\u{b4d}\u{200d} 8 ବଲ\u{b4d}\u{200d}"),
            keywords: &[
                "8",
                "ଆଠ",
                "ଖେଳ",
                "ପ\u{b41}ଲ\u{b4d} 8 ବଲ\u{b4d}",
                "ଫ\u{b41}ଲ\u{b4d}\u{200d} 8 ବଲ\u{b4d}\u{200d}",
                "ବଲ\u{b4d}",
                "ବ\u{b3f}ଲ\u{b3f}ଆର\u{b4d}ଡ\u{b4d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬਿਲਿਅਰਡ"),
            keywords: &["ਅ\u{a71}ਠ ਗ\u{a47}\u{a02}ਦਾ\u{a02}", "ਖ\u{a47}ਡ", "ਬਿਲਿਅਰਡ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("پول 8 بال"),
            keywords: &["8", "8 بال", "آٹھ", "بیلیرڈ", "پول 8 بال", "کھیڈ", "گیند"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Pul 8 Bọl"),
            keywords: &["8", "Bíliad", "Bọl", "Gem", "Pul 8 Bọl", "Ẹt"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("bila 8"),
            keywords: &["8", "bila", "kula"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د پول ۸ توپ"),
            keywords: &["اته", "بليارډ", "توپ", "د پول ۸ توپ", "لوبه", "۸"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("bilhar"),
            keywords: &["bilhar", "bola oito", "jogo"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["bilhar", "bola", "bola 8", "jogo", "oito", "snooker"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("billar"),
            keywords: &["billar"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("biliard"),
            keywords: &["biliard", "bilă", "gaură", "joc", "opt"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-369"),
            keywords: &["E10-369"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("бильярд"),
            keywords: &["8", "бильярд", "восьмерка", "черный шар", "шар"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umupira wa biyari wa nomero 8"),
            keywords: &[
                "8",
                "biyari",
                "umukino",
                "umunani",
                "umupira",
                "umupira wa biyari wa nomero 8",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("پول 8 بال"),
            keywords: &["8، 8 بال، بال، بليارڊ، اٺ، راند", "پول 8 بال"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("බ\u{dd2}ල\u{dd2}යඩ\u{dca}"),
            keywords: &[
                "8",
                "ක\u{dca}\u{200d}ර\u{dd3}ඩ\u{dcf}ව",
                "බ\u{dd2}ල\u{dd2}යඩ\u{dca}",
                "බ\u{dd2}ල\u{dd2}යර\u{dca}ඩ\u{dca}",
                "බෝල",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("biliardová guľa č. 8"),
            keywords: &[
                "8",
                "biliard",
                "biliardová guľa č. 8",
                "guľa č. 8",
                "hra",
                "osem",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("biljard"),
            keywords: &["8", "biljard", "igra", "krogla", "osmica"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("kubada barkada 8"),
            keywords: &[
                "8",
                "biliyaardi",
                "ciyaar",
                "kubad",
                "kubada barkada 8",
                "siddeed",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("bilardo"),
            keywords: &["8", "bilardo", "gurë", "lojë", "tetë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("билијар"),
            keywords: &["8", "oсaм", "билијар", "игрa", "куглa", "осмица"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["билијар"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("bilijar"),
            keywords: &["8", "bilijar", "igra", "kugla", "osam", "osmica"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["bilijar"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("biljardboll"),
            keywords: &["biljard", "biljardboll", "åttan"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("biliadi"),
            keywords: &["8", "biliadi", "mchezo", "mpira", "nane"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பில\u{bcd}லியர\u{bcd}ட\u{bcd}ஸ\u{bcd}"),
            keywords: &[
                "உள\u{bcd}ளரங\u{bcd}க விளைய\u{bbe}ட\u{bcd}டு",
                "எட\u{bcd}டு பந\u{bcd}து",
                "பில\u{bcd}லியர\u{bcd}ட\u{bcd}ஸ\u{bcd}",
                "விளைய\u{bbe}ட\u{bcd}டு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("బ\u{c3f}ల\u{c3f}యర\u{c4d}డ\u{c4d}స\u{c4d}"),
            keywords: &[
                "ఎన\u{c3f}మ\u{c3f}ద\u{c3f} బంతులు",
                "గ\u{c47}మ\u{c4d}",
                "దంతపు గుండ\u{c4d}ల\u{c3e}ట",
                "బ\u{c3f}ల\u{c3f}యర\u{c4d}డ\u{c4d}స\u{c4d}",
                "రంగురంగుల బంతులు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("билярди 8 саққадор"),
            keywords: &["8", "билярд", "билярди 8 саққадор", "бозӣ", "саққа", "ҳашт"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("บ\u{e34}ลเล\u{e35}ยด"),
            keywords: &["บ\u{e34}ลเล\u{e35}ยด", "แปด"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("8 bilýard topy"),
            keywords: &["8", "8 bilýard topy", "bilýard", "oýun", "sekiz", "top"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("pulu fika 8"),
            keywords: &["pulu fika 8"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("bilardo"),
            keywords: &["bilardo", "oyun", "sekiz top"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("8 لىك بىليارت"),
            keywords: &["8", "8 لىك بىليارت", "ئويۇن", "بىليارت", "توپ", "سەككىز"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("більярдна куля 8"),
            keywords: &["8", "більярд", "більярдна куля 8", "вісім", "куля"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بلیئرڈز"),
            keywords: &["آٹھ", "بال", "بلیئرڈز", "کھیل"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("billiard"),
            keywords: &["8", "8 ta shar", "billiard", "o‘yin", "sakkiz", "shar"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bi-a 8 bóng"),
            keywords: &["8", "bi-a 8 bóng", "bida", "quả bóng", "trò chơi", "tám"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("biyaar 8 bal"),
            keywords: &["8", "bal", "biyaar", "juróom ñatt", "po"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-pool 8 ball"),
            keywords: &[
                "8",
                "i-billiard",
                "i-pool 8 ball",
                "ibhola",
                "iibhola ezisi-8",
                "isibhozo",
                "umdlalo",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Bọọlu Odo 8"),
            keywords: &[
                "8",
                "Bọọlu Odo 8",
                "bílíádì",
                "bọ\u{301}ọ\u{300}lù",
                "eré",
                "ẹ\u{301}ẹ\u{301}jọ",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("8 號桌球"),
            keywords: &["8", "8 號桌球", "八", "桌球", "球", "遊戲"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("8 号桌球"),
            keywords: &["8", "8 号桌球", "八", "桌球", "游戏", "球"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("台球"),
            keywords: &["8 球制桌球", "台球", "游戏", "霹雳八球"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("撞球"),
            keywords: &["撞球", "球"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("桌球"),
            keywords: &["桌球", "球"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("amabhiliyade"),
            keywords: &[
                "8",
                "amabhiliyade",
                "billiard",
                "billiards",
                "ibhola",
                "umdlalo",
            ],
        },
    ],
};
#[doc = "🔮"]
pub const CRYSTAL_BALL: crate::Emoji = crate::Emoji {
    glyph: "🔮",
    codepoint: "1F52E",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "crystal ball",
    group: "Activities",
    subgroup: "game",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("kristalbal"),
            keywords: &[
                "bal",
                "fortuinverteller",
                "kristal",
                "kristalbal",
                "okkulte",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ክሪስታል ኳስ"),
            keywords: &["ሀብት", "ምናባዊ", "ተረት ተረት", "ክሪስታል", "ኳስ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("كرة كريستال"),
            keywords: &["تنجيم", "كرة", "كريستال"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("স\u{9cd}ফটিক বল"),
            keywords: &[
                "পৰীৰ স\u{9be}ধ\u{9c1}",
                "বল",
                "ভ\u{9be}গ\u{9cd}য",
                "স\u{981}জ\u{9c1}লি",
                "স\u{9cd}ফটিক",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kristal kürə"),
            keywords: &[
                "alət",
                "fantastika",
                "kristal",
                "kristal kürə",
                "nağıl",
                "top",
                "var-dövlət",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("крыштальны шар"),
            keywords: &["казачны", "крыштальны", "магія", "прадказанне", "шар"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Кристално кълбо"),
            keywords: &[
                "Кристално кълбо",
                "гадателски инструмент",
                "кристално кълбо",
                "кълбо",
                "приказка",
                "съдба",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ক\u{9cd}রিস\u{9cd}ট\u{9be}ল বল"),
            keywords: &[
                "কল\u{9cd}পন\u{9be}",
                "ক\u{9cd}রিস\u{9cd}ট\u{9be}ল",
                "বল",
                "র\u{9c2}পকথ\u{9be}",
                "সৌভ\u{9be}গ\u{9cd}য",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("boulenn strink"),
            keywords: &["boulenn strink", "strink"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("kristalna kugla"),
            keywords: &["bajka", "fantazija", "gatanje", "kristalna", "kugla"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("bola de vidre"),
            keywords: &["bola", "bola de vidre", "fantasia", "fortuna", "sort"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᎸᏌᏗ ᏍᏆᏞᏍᏗ"),
            keywords: &[
                "ᎤᎸᏌᏗ",
                "ᎥᏓᏅᏖᏍᎬ ᎰᏩᏂᎨᏒᎾ",
                "ᎬᏔᏂᏓᏍᏗ",
                "ᎰᏩᏂᎨᏒᎾ",
                "ᏅᏩᏙᎯᏯᏓ",
                "ᏍᏆᏞᏍᏗ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("křišťálová koule"),
            keywords: &[
                "budoucnost",
                "fantasy",
                "koule",
                "křišťál",
                "křišťálová koule",
                "nástroj",
                "pohádka",
                "předpověď",
                "sklo",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("pêl grisial"),
            keywords: &["crisial", "ffantasi", "pêl", "pêl grisial", "tylwyth teg"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("krystalkugle"),
            keywords: &["krystalkugle", "spådom", "spådomskunst"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Kristallkugel"),
            keywords: &["Kristallkugel", "Wahrsager"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κρυστάλλινη σφαίρα"),
            keywords: &[
                "εργαλείο",
                "κρυστάλλινη",
                "παραμύθι",
                "σφαίρα",
                "τύχη",
                "φαντασία",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("crystal ball"),
            keywords: &[
                "ball",
                "crystal",
                "fairy tale",
                "fantasy",
                "fortune",
                "tool",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("bola de cristal"),
            keywords: &[
                "adivinación",
                "bola",
                "bola de cristal",
                "buena fortuna",
                "cristal",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &[
                "adivinar",
                "bola",
                "bola de cristal",
                "cristal",
                "fantasía",
                "futuro",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kristallkuul"),
            keywords: &["ennustamine", "kristallkuul", "muinasjutt", "tööriist"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("kristalezko bola"),
            keywords: &[
                "bola",
                "fantasia",
                "ipuin",
                "kristal",
                "kristalezko bola",
                "zorte",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("گوی"),
            keywords: &[
                "ابزار",
                "بخت و اقبال",
                "تخیلی",
                "جن و پری",
                "کریستال",
                "گوی",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kristallipallo"),
            keywords: &[
                "ennustaja",
                "ennustus",
                "kristalli",
                "kristallipallo",
                "povaus",
                "taika",
                "tulevaisuus",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("bolang kristal"),
            keywords: &[
                "bola",
                "bolang kristal",
                "hula",
                "kapalaran",
                "kristal",
                "manghuhula",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("krystalkúla"),
            keywords: &["krystal", "krystalkúla", "kúla", "lagna", "ævintýr"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("boule de cristal"),
            keywords: &["boule de cristal", "cristal"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["boule", "boule de cristal", "cristal"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cruinneog chriostail"),
            keywords: &["cinniúint", "cruinneog chriostail", "síscéal"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("ball criostail"),
            keywords: &[
                "acainn",
                "ball",
                "ball criostail",
                "bàla",
                "criostal",
                "fantastach",
                "faoinsgeul",
                "fortan",
                "inneal",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("bola de cristal"),
            keywords: &[
                "adiviñación",
                "bola",
                "bola de cristal",
                "cristal",
                "futuro",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{acd}ફટિકનો દડો"),
            keywords: &[
                "દડો",
                "ભાગ\u{acd}ય",
                "ભાગ\u{acd}ય કથન",
                "સ\u{acd}ફટિક",
                "સ\u{acd}ફટિકનો દડો",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("balon kallo"),
            keywords: &[
                "bal",
                "balon kallo",
                "dukiya",
                "kayan aiki",
                "krisal",
                "labarin aljana",
                "tatsuniya",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("כדור בדולח"),
            keywords: &["כדור בדולח", "מזל", "נבואה", "ניבוי", "עתידות"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("क\u{94d}रिस\u{94d}टल बॉल, भविष\u{94d}य द\u{947}खना"),
            keywords: &[
                "क\u{94d}रिस\u{94d}टल",
                "क\u{94d}रिस\u{94d}टल बॉल",
                "क\u{94d}रिस\u{94d}टल बॉल, भविष\u{94d}य द\u{947}खना",
                "ग\u{947}\u{902}द",
                "भविष\u{94d}य",
                "भविष\u{94d}य द\u{947}खना",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("kristalna kugla"),
            keywords: &["alat", "kristal", "kristalna kugla", "kugla", "sudbina"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("kristálygömb"),
            keywords: &["jövendő", "jövendőmondás", "kristálygömb", "mese"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բյուրեղյա գունդ"),
            keywords: &[
                "բախտ",
                "բյուրեղ",
                "բյուրեղյա գունդ",
                "գործիք",
                "գունդ",
                "հեքիաթ",
                "ֆանտազիա",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("bola kristal"),
            keywords: &["alat", "bola", "dongeng", "fantasi", "kristal", "ramalan"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("bọọlụ enyo"),
            keywords: &[
                "akọrọako",
                "arọrọarọ",
                "bọolụ",
                "bọọlụ enyo",
                "enyo",
                "ngwaọrụ",
                "uru",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kristalskúla"),
            keywords: &["kristall", "kristalskúla", "kúla", "spá", "spádómur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("sfera di cristallo"),
            keywords: &[
                "chiaroveggenza",
                "cristallo",
                "futuro",
                "sfera",
                "sfera di cristallo",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("水晶玉"),
            keywords: &["占い", "水晶", "水晶玉", "玉", "運命"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("bal kristal"),
            keywords: &[
                "bal",
                "dongeng",
                "fantasi",
                "kristal",
                "perkakas",
                "raja brana",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("კრისტალის ბურთი"),
            keywords: &[
                "ბურთი",
                "ზღაპარი",
                "კრისტალი",
                "კრისტალის ბურთი",
                "მომავალი",
                "ფანტაზია",
                "ფანტასტიკა",
                "ხელსაწყო",
            ],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("takurt n ukrisṭal"),
            keywords: &["takurt n ukrisṭal"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("сыйқырлы шар"),
            keywords: &[
                "байлық",
                "доп",
                "кристалл",
                "сиқырлы ертегі",
                "сыйқырлы шар",
                "қиял",
                "құрал",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("krystalkugle"),
            keywords: &["krystalkugle", "spådom", "spådomskunst"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("បាល\u{17cb}ចរណៃ"),
            keywords: &["កែវចរណៃ", "ជោគវាសនា", "បាល\u{17cb}", "បាល\u{17cb}ចរណៃ"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸ\u{ccd}ಫಟ\u{cbf}ಕ ಚ\u{cc6}ಂಡು"),
            keywords: &[
                "ಅದೃಷ\u{ccd}ಟ",
                "ಕಾಲ\u{ccd}ಪನ\u{cbf}ಕ ಕಥ\u{cc6}",
                "ಚ\u{cc6}ಂಡು",
                "ಫ\u{ccd}ಯಾಂಟಸ\u{cbf}",
                "ಸಾಧನ",
                "ಸ\u{ccd}ಫಟ\u{cbf}ಕ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("수정 구슬"),
            keywords: &["구슬", "수정", "예언", "운세"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("क\u{94d}रिस\u{94d}टल बॉल"),
            keywords: &[
                "क\u{94d}रिस\u{94d}टल",
                "नवल कथा",
                "परी कथा",
                "बॉल",
                "सभाग\u{94d}य",
                "साधन",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кристаллдуу топ"),
            keywords: &["жомок", "кристалл", "кристаллдуу топ", "топ", "фантастика"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Kristallkugel"),
            keywords: &[
                "Fantasie",
                "Kristall",
                "Kristallkugel",
                "Kugel",
                "Mäerchen",
                "Utensil",
                "Zukunft",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ແກ\u{ec9}ວຄຣ\u{eb4}ສໂຕ\u{ec9}"),
            keywords: &[
                "ຄຣ\u{eb4}ສໂຕ\u{ec9}",
                "ແກ\u{ec9}ວ",
                "ແກ\u{ec9}ວຄຣ\u{eb4}ສໂຕ\u{ec9}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("krištolinis rutulys"),
            keywords: &["fantazija", "fortūna", "krištolinis", "pasaka", "rutulys"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("kristāla lode"),
            keywords: &["kristāla lode", "kristāls", "lode", "pareģot", "zīlēt"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pōro atamaha"),
            keywords: &[
                "atamaha",
                "matakite",
                "moemoeā",
                "pakiwaitara",
                "pōro",
                "utauta",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("кристална топка"),
            keywords: &["иднина", "кристална", "претскажување", "сказна", "топка"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ക\u{d4d}രിസ\u{d4d}റ\u{d4d}റൽ ബോൾ"),
            keywords: &[
                "ക\u{d4d}രിസ\u{d4d}റ\u{d4d}റൽ",
                "ബോൾ",
                "ഭ\u{d3e}വി",
                "ഭ\u{d3e}വി പ\u{d4d}രവചനം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("кристал бөмбөлөг"),
            keywords: &["бөмбөлөг", "кристал", "төсөөлөл", "үлгэр"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("स\u{94d}फटिकाचा च\u{947}\u{902}ड\u{942}"),
            keywords: &[
                "कल\u{94d}पना",
                "क\u{94d}रिस\u{94d}टल",
                "परीकथा",
                "बॉल",
                "भविष\u{94d}य",
                "साधन",
                "स\u{94d}फटिकाचा च\u{947}\u{902}ड\u{942}",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bola kristal"),
            keywords: &[
                "alat",
                "bola",
                "cerita dongeng",
                "fantasi",
                "kristal",
                "nasib",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("boċċa tal-kristal"),
            keywords: &[
                "ballun",
                "boċċa tal-kristal",
                "fantasija",
                "fortuna",
                "għodda",
                "kristall",
                "ħrafa",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ကသ\u{102d}\u{102f}ဏ\u{103a}းဖန\u{103a}လ\u{102f}\u{1036}း"),
            keywords: &[
                "ကသ\u{102d}\u{102f}ဏ\u{103a}းဖန\u{103a}လ\u{102f}\u{1036}း",
                "စ\u{102d}တ\u{103a}က\u{1030}းယဉ\u{103a}",
                "နတ\u{103a}သမ\u{102e}းပ\u{102f}\u{1036}ပြင\u{103a}",
                "ဖန\u{103a}လ\u{102f}\u{1036}း",
                "ရ\u{103e}ေးဖြစ\u{103a}ဟောစာတမ\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("krystallkule"),
            keywords: &["krystallkule", "spådom", "spådommer"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("क\u{94d}रिस\u{94d}टल बल"),
            keywords: &[
                "उपकरण",
                "क\u{94d}रिस\u{94d}टल",
                "ख\u{947}स\u{94d}रा कल\u{94d}पना",
                "परीको कथा",
                "बल",
                "भाग\u{94d}य",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("kristallen bol"),
            keywords: &[
                "bol",
                "kristal",
                "kristallen bol",
                "waarzeggen",
                "waarzeggerij",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("krystallkule"),
            keywords: &["krystallkule", "spådom", "spådomar"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କ\u{b4d}ର\u{b3f}ଷ\u{b4d}ଟ\u{b3e}ଲ\u{b4d} ବଲ\u{b4d}"),
            keywords: &[
                "କ\u{b4d}ର\u{b3f}ଷ\u{b4d}ଟ\u{b3e}ଲ\u{b4d}",
                "ଫର\u{b4d}ଚ\u{b4d}ୟ\u{b41}ନ\u{b4d}",
                "ଫର\u{b4d}ଚ\u{b4d}ୟ\u{b41}ନ\u{b4d} ଟେଲ\u{b3f}ଂ",
                "ବଲ\u{b4d}",
                "ସ\u{b4d}ପଟ\u{b3f}କ ପେଣ\u{b4d}ଡ\u{b41}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕ\u{a4d}ਰਿਸਟਲ ਬਾਲ"),
            keywords: &[
                "ਔਜ\u{a3c}ਾਰ",
                "ਕਿਸਮਤ",
                "ਕਿਸਮਤ ਦ\u{a71}ਸਣਾ",
                "ਕ\u{a4d}ਰਿਸਟਲ ਬਾਲ",
                "ਗ\u{a47}\u{a02}ਦ",
                "ਸ\u{a3c}ੀਸ\u{a3c}ਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("قلمی گیند"),
            keywords: &[
                "اوزار",
                "تصور",
                "قسمت",
                "قلمی گیند",
                "ق\u{64e}لم",
                "پریاں دی کہانی",
                "گیند",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Krístál Bọl"),
            keywords: &[
                "Bọl",
                "Fẹ\u{301}rí Tel",
                "Fọ\u{301}tun",
                "Krístal",
                "Krístál Bọl",
                "Torí Abaut Spírit-dẹm Wé Rizẹ\u{301}mbúl Taíní Húmánbin",
                "Tul",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kryształowa kula"),
            keywords: &[
                "fortuna",
                "kryształowa",
                "kula",
                "przepowiadać",
                "wróżka",
                "wróżyć",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("کرسټال بال"),
            keywords: &[
                "اله",
                "بال",
                "تخيل",
                "د ښاپيرو کيسه",
                "نصيب",
                "کرسټال بال",
                "کرسټل",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("bola de cristal"),
            keywords: &[
                "adivinhação",
                "bola",
                "bola de cristal",
                "cristal",
                "destino",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &[
                "bola",
                "bola de cristal",
                "conto de fadas",
                "cristal",
                "fantasia",
                "instrumento",
                "sorte",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("muyu qhispillu"),
            keywords: &[
                "fantasia",
                "hadas willana",
                "llamkana",
                "muyu qhispillu",
                "p’ulu",
                "qhispillu",
                "qulli",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("glob de cristal"),
            keywords: &[
                "basm",
                "cristal",
                "fantezie",
                "glob",
                "glob de cristal",
                "noroc",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-746"),
            keywords: &["E10-746"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("хрустальный шар"),
            keywords: &[
                "волшебство",
                "гадание",
                "магия",
                "предсказание",
                "хрусталь",
                "хрустальный шар",
                "шар",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikibumbe cy’urubura"),
            keywords: &[
                "amahirwe",
                "igikoresho",
                "ikibumbe cy’urubura",
                "inkuru mpimbano",
                "inkuu itangaje",
                "kibengerana",
                "umupira",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("شيشي جو بال"),
            keywords: &[
                "اوزار",
                "بال",
                "تصور",
                "شيشو",
                "شيشي جو بال",
                "قسمت",
                "پري جي ڪهاڻي",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ව\u{dd3}ද\u{dd4}ර\u{dd4} බෝලය"),
            keywords: &[
                "බෝලය",
                "ම\u{dcf}ය\u{dcf}ව",
                "මෙවලම",
                "ව\u{dd3}ද\u{dd4}ර\u{dd4}",
                "ස\u{dd4}රංගන\u{dcf} කථ\u{dcf}ව",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("krištáľová guľa"),
            keywords: &[
                "fantasy",
                "krištáľ",
                "krištáľová guľa",
                "rozprávka",
                "veštenie",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("kristalna krogla"),
            keywords: &[
                "fantazija",
                "kristalna",
                "krogla",
                "orodje",
                "pravljica",
                "prerokba",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("kubada kareemka"),
            keywords: &[
                "cajiib",
                "kareem",
                "kubad",
                "kubada kareemka",
                "nasiib",
                "qalab",
                "sheeko xariir",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("top kristali"),
            keywords: &["fantazi", "fat", "kristal", "top", "top kristali"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("кристална кугла"),
            keywords: &[
                "алат",
                "бајка",
                "кристaл",
                "кристална кугла",
                "куглa",
                "судбина",
                "фантазија",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["кристална кугла"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("kristalna kugla"),
            keywords: &[
                "alat",
                "bajka",
                "fantazija",
                "kristal",
                "kristalna kugla",
                "kugla",
                "sudbina",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["kristalna kugla"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("kristallkula"),
            keywords: &["framtiden", "kristallkula", "spåkula"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("tufe la kioo"),
            keywords: &[
                "bahati",
                "kichimbakazi",
                "kioo",
                "mpira",
                "njozi",
                "tufe la kioo",
                "zana",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கண\u{bcd}ண\u{bbe}டி பந\u{bcd}து"),
            keywords: &[
                "கண\u{bcd}ண\u{bbe}டி பந\u{bcd}து",
                "கிறிஸ\u{bcd}டல\u{bcd} ப\u{bbe}ல\u{bcd}",
                "பந\u{bcd}து",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("స\u{c4d}ఫట\u{c3f}క బంత\u{c3f}"),
            keywords: &[
                "జ\u{c4d}య\u{c4b}త\u{c3f}ష\u{c4d}యుడు",
                "య\u{c4b}గ\u{c3f}",
                "స\u{c4d}ఫట\u{c3f}క బంత\u{c3f}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("кураи булӯрӣ"),
            keywords: &[
                "асбоб",
                "афсона",
                "булӯр",
                "кура",
                "кураи булӯрӣ",
                "тахайюлот",
                "тақдир",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ล\u{e39}กแก\u{e49}วว\u{e34}เศษ"),
            keywords: &["ด\u{e39}ดวง", "ล\u{e39}กแก\u{e49}วว\u{e34}เศษ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("hrustal şar"),
            keywords: &[
                "erteki",
                "gural",
                "hrustal",
                "hrustal şar",
                "hyýal",
                "pal",
                "top",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("pulu kalisitala"),
            keywords: &["pulu kalisitala"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kristal küre"),
            keywords: &["fal", "fal bakma", "kristal", "küre"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("كىرىستال توپ"),
            keywords: &["توپ", "خەزىنە", "فانتازىيە", "قورال", "كىرىستال", "چۆچەك"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("кришталева куля"),
            keywords: &["віщування", "кришталева куля", "фантазія", "фортуна"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کرسٹل بال"),
            keywords: &["بال", "فینٹسی", "قسمت", "کرسٹل"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kristall shar"),
            keywords: &["asbob", "ertak", "fantaziya", "kristall", "shar", "taqdir"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("quả cầu pha lê"),
            keywords: &[
                "dụng cụ",
                "giả tưởng",
                "pha lê",
                "quả bóng",
                "quả cầu pha lê",
                "truyện cổ tích",
                "vận may",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("bulu kristaal"),
            keywords: &[
                "bul",
                "bulu kristaal",
                "feem",
                "jumtukaay",
                "kristaal",
                "léebu fee",
                "wërsëg",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ibhola yekristale"),
            keywords: &[
                "ibhola",
                "ibhola yekristale",
                "ikristale",
                "intlantla",
                "intsomi",
                "isixhobo",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("bọọlu aworawọ"),
            keywords: &[
                "bọ\u{301}ó\u{329}lù",
                "bọọlu aworawọ",
                "pàápàá",
                "àló\u{329} ajẹmó\u{329}win",
                "àìbáyému",
                "òkúta aworàwò\u{329}",
                "ọrọ\u{300}",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("水晶球"),
            keywords: &["工具", "幸運", "幻想", "水晶", "水晶球", "球", "童話"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("水晶球"),
            keywords: &["工具", "幸运", "幻想", "水晶", "水晶球", "球", "童话"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("水晶球"),
            keywords: &["命运", "工具", "水晶", "水晶球", "球", "财富"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("水晶球"),
            keywords: &["占卜", "水晶球", "算命"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ibhola lekhristali"),
            keywords: &[
                "ibhola",
                "ibhola lekhristali",
                "ikhristali",
                "inhlanhla",
                "insumansumane",
                "ithuluzi",
            ],
        },
    ],
};
#[doc = "🪄"]
pub const MAGIC_WAND: crate::Emoji = crate::Emoji {
    glyph: "🪄",
    codepoint: "1FA84",
    status: crate::Status::FullyQualified,
    introduction_version: 13f32,
    name: "magic wand",
    group: "Activities",
    subgroup: "game",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("towerstaf"),
            keywords: &["heks", "towenaar", "towerkrag", "towerstaf"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ምትሃተኛ ዘንግ"),
            keywords: &["ምትሃተኛ ዘንግ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("عصا سحرية"),
            keywords: &["ساحر", "ساحرة", "سحر", "عصا", "عصا سحرية"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("য\u{9be}দ\u{9c1}ৰ ক\u{9be}ঠি"),
            keywords: &[
                "য\u{9be}দ\u{9c1}",
                "য\u{9be}দ\u{9c1}কৰ",
                "য\u{9be}দ\u{9c1}কৰী",
                "য\u{9be}দ\u{9c1}ৰ ক\u{9be}ঠি",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("sehrli çubuq"),
            keywords: &["cadugər", "falçı", "sehrli", "sehrli çubuq"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("чароўная палачка"),
            keywords: &["вядзьмак", "вядзьмарка", "магія", "чароўная палачка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("вълшебна пръчица"),
            keywords: &[
                "вещица",
                "вълшебна пръчица",
                "магия",
                "магьосник",
                "магьосница",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("জ\u{9be}দ\u{9c1}র ছড\u{9bc}ি"),
            keywords: &[
                "জ\u{9be}দ\u{9c1}",
                "জ\u{9be}দ\u{9c1}কর",
                "জ\u{9be}দ\u{9c1}র ছড\u{9bc}ি",
                "ড\u{9be}ইনি",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("gwialenn-hud"),
            keywords: &["gwialenn-hud", "hud", "sorser", "sorserez"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("čarobni štapić"),
            keywords: &["magija", "vještica", "čarobni štapić", "čarobnjak"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("vareta màgica"),
            keywords: &["bruixa", "bruixot", "màgia", "vareta màgica"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏍᏆᏂᎪᏗᏳ ᎦᏅᏍᏓ"),
            keywords: &["ᎠᏓᏪᎯ", "ᎠᏙᏂᏍᎩ", "ᎠᏣᏍᎩᎵ", "ᎤᏍᏆᏂᎪᏗᏳ ᎦᏅᏍᏓ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("kouzelná hůlka"),
            keywords: &[
                "iluzionista",
                "kouzelná hůlka",
                "kouzelník",
                "kouzlení",
                "kouzlo",
                "magie",
                "čaroděj",
                "čarodějka",
                "čarodějnice",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("ffon hud"),
            keywords: &["dewin", "dewines", "ffon hud", "hud"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("tryllestav"),
            keywords: &["heks", "magi", "troldmand", "tryllestav"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Zauberstab"),
            keywords: &["Hexe", "Zauberei", "Zauberer", "Zauberin", "Zauberstab"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μαγικό ραβδί"),
            keywords: &["μάγισσα", "μάγος", "μαγικά", "μαγικό ραβδί"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("magic wand"),
            keywords: &["magic", "magic wand", "witch", "wizard"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["magic", "wand", "witch", "wizard"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("varita mágica"),
            keywords: &[
                "bruja",
                "hechicero",
                "magia",
                "mago",
                "prestidigitación",
                "varita",
                "varita mágica",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("varita mágica"),
            keywords: &["varita mágica"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("varita mágica"),
            keywords: &["varita mágica"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("võlukepp"),
            keywords: &["maagia", "nõid", "võlukepp", "võlur"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("makiltxo magiko"),
            keywords: &["azti", "magia", "makiltxo magiko", "sorgin"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("عصای سحرآمیز"),
            keywords: &["جادو", "جادوگر", "سحرآمیز", "عصای سحرآمیز"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("taikasauva"),
            keywords: &["noita", "taika", "taikasauva", "velho"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("magic wand"),
            keywords: &["magic wand", "mahika", "mangkukulam", "salamangkero"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("gandastavur"),
            keywords: &[
                "gandakallur",
                "gandakelling",
                "gandastavur",
                "gandur",
                "rúnakelvi",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("baguette magique"),
            keywords: &[
                "baguette magique",
                "magicien",
                "magie",
                "sorcier",
                "sorcière",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("baguette magique"),
            keywords: &[
                "baguette magique",
                "magicien",
                "magicienne",
                "magie",
                "sorcier",
                "sorcière",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("slat draíochta"),
            keywords: &["cailleach feasa", "draoi", "slat draíochta"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("slatan-draoidheachd"),
            keywords: &[
                "bana-bhuidseach",
                "buidseach",
                "draoidh",
                "draoidheachd",
                "slatan-draoidheachd",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("variña máxica"),
            keywords: &["bruxa", "mago", "maxia", "variña máxica"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("જાદ\u{ac1}ઈ છડી"),
            keywords: &[
                "જાદ\u{ac1}",
                "જાદ\u{ac1} કરનારી સ\u{acd}ત\u{acd}રી",
                "જાદ\u{ac1}ઈ છડી",
                "જાદ\u{ac1}ગર",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("שרביט קסמים"),
            keywords: &["מכשף", "מכשפה", "קוסמים", "קסם", "קסמים", "שרביט"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("जाद\u{942} की छड\u{93c}ी"),
            keywords: &[
                "जाद\u{942}",
                "जाद\u{942} की छड\u{93c}ी",
                "जाद\u{942}गर",
                "जाद\u{942}गरनी",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("čarobni štapić"),
            keywords: &["magija", "vještica", "čarobni štapić", "čarobnjak"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("varázspálca"),
            keywords: &["boszorkány", "varázslat", "varázsló", "varázspálca"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կախարդական փայտիկ"),
            keywords: &["կախարդ", "կախարդական փայտիկ", "կախարդանք", "մոգ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tongkat ajaib"),
            keywords: &["penyihir pria", "penyihir wanita", "sihir", "tongkat ajaib"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("töfrasproti"),
            keywords: &["galdrakarl", "galdrar", "galdur", "norn", "töfrasproti"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("bacchetta magica"),
            keywords: &[
                "bacchetta magica",
                "maga",
                "magia",
                "mago",
                "strega",
                "stregone",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("魔法の杖"),
            keywords: &["つえ", "杖", "魔法の杖", "魔術"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tongkat sihir"),
            keywords: &["penyihir", "sihir", "tongkat sihir", "tuntunan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ჯადოსნური ჯოხი"),
            keywords: &["მაგია", "ჯადო", "ჯადოსნური ჯოხი", "ჯადოქარი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("сиқырлы таяқша"),
            keywords: &["сиқыр", "сиқырлы", "сиқырлы таяқша", "шебер"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ឈើវេទមន\u{17d2}ត"),
            keywords: &[
                "ឈើវេទមន\u{17d2}ត",
                "ធ\u{17d2}មប\u{17cb}ប\u{17d2}រ\u{17bb}ស",
                "ធ\u{17d2}មប\u{17cb}ស\u{17d2}រ\u{17b8}",
                "វេទមន\u{17d2}ត",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮಂತ\u{ccd}ರ ದಂಡ"),
            keywords: &[
                "ಮಂತ\u{ccd}ರ ದಂಡ",
                "ಮಾಂತ\u{ccd}ರ\u{cbf}ಕ",
                "ಮಾಟಗಾತ\u{cbf}",
                "ಮ\u{ccd}ಯಾಜ\u{cbf}ಕ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("마술 지팡이"),
            keywords: &["마녀", "마법사", "마술", "마술 지팡이"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("जाद\u{941}ची काडी"),
            keywords: &[
                "च\u{947}टकीण",
                "जाद\u{941}गार",
                "जाद\u{941}ची काडी",
                "जाद\u{942}",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("сыйкырдуу таяк"),
            keywords: &["керемет", "сыйкыр", "сыйкырдуу таяк", "сыйкырчы"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໄມ\u{ec9}\u{200b}ກາ\u{200b}ຍະ\u{200b}ສ\u{eb4}ດ"),
            keywords: &[
                "ຄາ\u{200b}ຖາ",
                "ວ\u{eb4}\u{200b}ເສດ",
                "ເວດ\u{200b}ມ\u{ebb}ນ",
                "ແມ\u{ec8}\u{200b}ມ\u{ebb}ດ",
                "ໄມ\u{ec9}\u{200b}ກາ\u{200b}ຍະ\u{200b}ສ\u{eb4}ດ",
                "\u{200b}ພ\u{ecd}\u{ec8}\u{200b}ມ\u{ebb}ດ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("stebuklinga lazdelė"),
            keywords: &[
                "burtininkas",
                "ragana",
                "stebuklinga lazdelė",
                "stebuklingas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("burvju nūjiņa"),
            keywords: &["burvis", "burvju", "burvju nūjiņa", "ragana"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("волшебно стапче"),
            keywords: &["вештерка", "волшебник", "волшебно стапче", "магија"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മ\u{d3e}ന\u{d4d}ത\u{d4d}രികവടി"),
            keywords: &[
                "ഇന\u{d4d}ദ\u{d4d}രജ\u{d3e}ലം",
                "മന\u{d4d}ത\u{d4d}രവ\u{d3e}ദിനി",
                "മ\u{d3e}ന\u{d4d}ത\u{d4d}രികവടി",
                "മ\u{d3e}യ\u{d3e}വി",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("шидэт дохиур"),
            keywords: &["ид шид", "шидтэн", "шидэт дохиур", "шулам"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("जाद\u{942}ची का\u{902}डी"),
            keywords: &[
                "च\u{947}टकीण",
                "जाद\u{941}गार",
                "जाद\u{942}",
                "जाद\u{942}ची का\u{902}डी",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("tongkat sakti"),
            keywords: &["ahli sihir", "bestari", "magik", "tongkat sakti"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ကြ\u{102d}မ\u{103a}စကြာ"),
            keywords: &[
                "ကြ\u{102d}မ\u{103a}စကြာ",
                "စ\u{102f}န\u{103a}းမ",
                "မျက\u{103a}လ\u{103e}ည\u{1037}\u{103a}",
                "မ\u{103e}ော\u{103a}ဆရာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("tryllestav"),
            keywords: &["heks", "magi", "trollmann", "trylle", "tryllestav"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("जाद\u{941}मयी नाडी व\u{94d}यान\u{94d}ड"),
            keywords: &[
                "जाद\u{941}मयी नाडी व\u{94d}यान\u{94d}ड",
                "जाद\u{942}",
                "बोक\u{94d}सा",
                "बोक\u{94d}सी",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("toverstok"),
            keywords: &["heks", "magie", "tovenaar", "toverstok"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("tryllestav"),
            keywords: &["heks", "magi", "trollmann", "trylle", "tryllestav"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଯ\u{b3e}ଦ\u{b41} ବ\u{b3e}ଡ\u{b3c}\u{b3f}"),
            keywords: &[
                "ଡ\u{b3e}ହ\u{b3e}ଣୀ",
                "ଯ\u{b3e}ଦ\u{b41} ବ\u{b3e}ଡ\u{b3c}\u{b3f}",
                "ଯ\u{b3e}ଦ\u{b41}କର",
                "ଯ\u{b3e}ଦ\u{b41}ବ\u{b3f}ଦ\u{b4d}ୟ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਜਾਦ\u{a42}ਈ ਛੜੀ"),
            keywords: &[
                "ਚ\u{a41}ੜ\u{a47}ਲ",
                "ਜਾਦ\u{a42}",
                "ਜਾਦ\u{a42}ਈ ਛੜੀ",
                "ਜਾਦ\u{a42}ਗਰ",
                "ਜਾਦ\u{a42}ਗਰਨੀ",
                "ਡ\u{a48}ਣ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Májík Stik"),
            keywords: &["Májik", "Májík Stik", "Wich", "Wízad"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("czarodziejska różdżka"),
            keywords: &[
                "czarodziej",
                "czarodziejka",
                "czarodziejska różdżka",
                "czary",
                "magia",
                "magik",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د جادو لښته"),
            keywords: &["جادو", "جادوګر", "د جادو لښته", "ساحره"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("varinha mágica"),
            keywords: &["bruxa", "magia", "mago", "varinha mágica"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("varinha mágica"),
            keywords: &["bruxa", "feiticeiro", "magia", "varinha mágica"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("baghetă magică"),
            keywords: &[
                "baghetă magică",
                "magie",
                "vrajă",
                "vrăjitoare",
                "vrăjitor",
                "vrăjitorie",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E13-051"),
            keywords: &["E13-051"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("волшебная палочка"),
            keywords: &["волшебная палочка", "волшебник", "волшебство", "колдунья"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("جادوئي لفظ"),
            keywords: &["جادو", "جادوئي لفظ", "جادوگرڻڳ", "ساحر"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("මැජ\u{dd2}ක\u{dca} යෂ\u{dca}ට\u{dd2}ය"),
            keywords: &[
                "ම\u{dcf}ය\u{dcf}ක\u{dcf}රය\u{dcf}",
                "මැජ\u{dd2}ක\u{dca}",
                "යෂ\u{dca}ට\u{dd2}ය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("kúzelná palička"),
            keywords: &["kúzelná palička", "kúzlo", "čarodejník", "čarodejníčka"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("čarobna palica"),
            keywords: &["čarobna palica", "čarovnica", "čarovnija", "čarovnik"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("ul mucjiso"),
            keywords: &["mucjiso", "saaxir", "saaxirad", "ul mucjiso"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("shkop magjik"),
            keywords: &["magji", "magjistar", "magjistare", "shkop magjik"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("чаробни штапић"),
            keywords: &["вештица", "магија", "чаробни штапић", "чаробњак"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["чаробни штапић"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("čarobni štapić"),
            keywords: &["magija", "veštica", "čarobni štapić", "čarobnjak"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["čarobni štapić"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("trollspö"),
            keywords: &["trollkarl", "trollkonst", "trollspö", "tro´llstav"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kifimbo cha mazingaombwe"),
            keywords: &[
                "kifimbo cha mazingaombwe",
                "mazingaombwe",
                "mlozi wa kike",
                "mlozi wa kiume",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("kifimbo cha miujiza"),
            keywords: &["kifimbo cha miujiza", "mchawi", "muujiza"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மந\u{bcd}திரக\u{bcd} கோல\u{bcd}"),
            keywords: &[
                "சூனியக\u{bcd}க\u{bbe}ரி",
                "மந\u{bcd}திரக\u{bcd} கோல\u{bcd}",
                "மந\u{bcd}திரம\u{bcd}",
                "மந\u{bcd}திரவ\u{bbe}தி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మంత\u{c4d}ర దండం"),
            keywords: &[
                "మంత\u{c4d}ర దండం",
                "మంత\u{c4d}రగత\u{c4d}త\u{c46}",
                "మ\u{c3e}ంత\u{c4d}ర\u{c3f}కుడు",
                "మ\u{c3e}య",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ไม\u{e49}กายส\u{e34}ทธ\u{e34}\u{e4c}"),
            keywords: &[
                "พ\u{e48}อมด",
                "เวทมนตร\u{e4c}",
                "แม\u{e48}มด",
                "ไม\u{e49}กายส\u{e34}ทธ\u{e34}\u{e4c}",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("jadyly taýajyk"),
            keywords: &["jadygöý", "jadyly", "jadyly taýajyk"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("vaʻakau fakamēsiki"),
            keywords: &["vaʻakau fakamēsiki"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("sihirli asa"),
            keywords: &["büyücü", "cadı", "sihir", "sihirli asa"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("чарівна паличка"),
            keywords: &["магія", "чаклун", "чаклунка", "чарівна", "чарівна паличка"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("جادوئی چھڑی"),
            keywords: &["جادو", "جادوئی چھڑی", "جادوگر", "جادوگرنی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("sehrli tayoqcha"),
            keywords: &["jodugar", "sehr", "sehrgar", "sehrli tayoqcha"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("gậy thần"),
            keywords: &["gậy thần", "ma thuật", "phù thủy", "thầy phù thủy"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("魔法棒"),
            keywords: &["女巫", "巫師", "魔法棒", "魔術"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("魔法棒"),
            keywords: &["女巫", "巫师", "魔术", "魔法棒"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("魔棒"),
            keywords: &["女巫", "巫师", "魔棒", "魔法"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("魔杖"),
            keywords: &["巫婆", "巫師", "魔杖", "魔法"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("神仙棒"),
            keywords: &["巫婆", "巫師", "神仙棒", "魔杖", "魔法"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("induku yomlingo"),
            keywords: &["induku yomlingo", "magic", "witch", "wizard"],
        },
    ],
};
#[doc = "🧿"]
pub const NAZAR_AMULET: crate::Emoji = crate::Emoji {
    glyph: "🧿",
    codepoint: "1F9FF",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "nazar amulet",
    group: "Activities",
    subgroup: "game",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("nazar-gelukbringer"),
            keywords: &[
                "bose oog",
                "gelukbringer",
                "nazar",
                "nazar-gelukbringer",
                "talisman",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ናዛር አምዩሌት"),
            keywords: &["ሰይጣን የሚያርቅ ድንጋይ", "ናዛር", "ናዛር አምዩሌት", "አስደሳች", "ዛጎል"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("الخرزة الزرقاء"),
            keywords: &["الخرزة الزرقاء", "حسد", "حظ", "خرزة", "عين"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("নজৰ আম\u{9c1}লেট"),
            keywords: &[
                "কবজ",
                "ক\u{9c1}দ\u{9c3}ষ\u{9cd}টি",
                "নজৰ",
                "নজৰ আম\u{9c1}লেট",
                "নিশ\u{9be}ন",
                "ম\u{9be}দ\u{9c1}লি",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("gözmüncuğu"),
            keywords: &["gözdəymə", "gözmuncuğu", "gözmüncuğu", "muncuq", "talisman"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("Назар"),
            keywords: &[
                "Назар",
                "бірулька",
                "вока Фатымы",
                "пацерка",
                "сурокі",
                "талісман",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("назар"),
            keywords: &["амулет", "мънисто", "назар", "синьо око", "талисман"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("নজর আম\u{9c1}লেট"),
            keywords: &[
                "অক\u{9cd}ষ",
                "ক\u{9c1}নজর",
                "জ\u{9be}দ\u{9c1}",
                "নজর",
                "নজর আম\u{9c1}লেট",
                "সৌন\u{9cd}দর\u{9cd}য",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("amuzetez nazar"),
            keywords: &["amuzetez", "drougaviz", "gwall lagad", "nazar", "tilsam"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("Fatimino oko"),
            keywords: &["Fatimino oko"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("nazar"),
            keywords: &["amulet", "nazar", "pedra del mal d’ull", "talismà"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎦᏙᎵ ᎢᏳᏍᏗ ᎠᎵᏍᏕᎸᏙᏗ"),
            keywords: &[
                "ᎠᎦᏙᎵ ᎢᏳᏍᏗ ᎠᎵᏍᏕᎸᏙᏗ",
                "ᎠᎦᏙᎵ ᎢᏳᏍᏗ ᎤᎦᏎᏍᏗ",
                "ᎠᏕᎳ",
                "ᎣᏍᏛ ᎠᏓᏅᏓᏓ",
                "ᎤᏐᏅᎢ-ᎠᎦᏙᎵ",
                "ᏅᏯ ᎠᏓᏪᎯ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("amulet nazar"),
            keywords: &[
                "amulet nazar",
                "boncuk",
                "korálek",
                "modré oko",
                "přívěsek",
                "talisman",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("amwled nazar"),
            keywords: &[
                "amwled nazar",
                "glain",
                "haid",
                "llygad drwg",
                "nazar",
                "talismon",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("nazaramulet"),
            keywords: &[
                "det onde øje",
                "lykkebringer",
                "nazar",
                "nazaramulet",
                "perle",
                "talisman",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Nazar-Amulett"),
            keywords: &["Glücksbringer", "Nazar", "Nazar-Amulett", "Talisman"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ματάκι"),
            keywords: &["γούρι", "κακό μάτι", "ματάκι", "φυλαχτό", "χάντρα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("nazar amulet"),
            keywords: &[
                "bead",
                "charm",
                "evil-eye",
                "nazar",
                "nazar amulet",
                "talisman",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("evil-eye amulet"),
            keywords: &["amulet", "charm", "evil-eye", "nazar", "talisman"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "bead",
                "charm",
                "evil eye",
                "nazar",
                "nazar amulet",
                "talisman",
            ],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("ojo turco"),
            keywords: &["amuleto", "mal de ojo", "nazar", "ojo turco", "talismán"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("nazar"),
            keywords: &["cuenta", "hechizo", "mal de ojo", "nazar", "talismán"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("Nazari amulett"),
            keywords: &[
                "Nazari amulett",
                "Nazari silm",
                "amulett",
                "helmes",
                "kuri silm",
                "talisman",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("nazar"),
            keywords: &["begizko", "bihi", "nazar", "sorginkeria", "talisman"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("نظرقربانی"),
            keywords: &["جادو", "سحر", "طلسم", "مهره", "نظرقربانی", "چشم\u{200c}زخم"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("nazar-amuletti"),
            keywords: &[
                "amuletti",
                "helmi",
                "nazar-amuletti",
                "paha silmä",
                "taikakalu",
                "talismaani",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("nazar amulet"),
            keywords: &[
                "agimat",
                "anting-anting",
                "charm",
                "nazar",
                "nazar amulet",
                "talisman",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("nasaramulett"),
            keywords: &[
                "amulett",
                "eydnulutur",
                "kúla",
                "nasar",
                "nasaramulett",
                "nazar",
                "verndargripur",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("mauvais œil"),
            keywords: &["amulette", "mauvais œil", "nazar", "perle", "talisman"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["amulette", "mauvais œil", "nazar", "talisman"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("briocht nazar"),
            keywords: &[
                "briocht nazar",
                "buachloch",
                "coirnín",
                "drochshúil",
                "mealltacht",
                "nazar",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("ortha-sùla"),
            keywords: &[
                "droch-shùil",
                "eòlas",
                "eòlas-sùla",
                "geasag",
                "grìogag",
                "nazar",
                "ortha-sùla",
                "seun",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("ollo turco"),
            keywords: &["mal de ollo", "nazar", "ollo turco", "talismán"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("તાવીજ"),
            keywords: &[
                "ખરાબ નઝર",
                "તાવીજ",
                "દોરાધાગા",
                "નઝરીય\u{ac1}\u{a82}",
                "મણકો",
                "માદળિય\u{ac1}\u{a82}",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("קמע"),
            keywords: &["אבן טובה", "מזל", "נגד עין הרע", "קמע"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("नज\u{93c}र तावीज\u{93c}"),
            keywords: &[
                "एविल-आई",
                "चार\u{94d}म",
                "ताबीज",
                "नज\u{93c}र",
                "नज\u{93c}र तावीज\u{93c}",
                "बीड",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("nazar perlica"),
            keywords: &[
                "nazar",
                "perlica",
                "plavo oko",
                "talisman",
                "tursko oko",
                "zlo oko",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("nazar amulett"),
            keywords: &[
                "bűbáj",
                "gonoszűző",
                "nazar",
                "nazar amulett",
                "szem",
                "talizmán",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("աչքի ուլունք"),
            keywords: &[
                "աչքաուլունք",
                "աչքի ուլունք",
                "թալիսման",
                "համայիլ",
                "ուլունք",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("jimat nazar"),
            keywords: &["jimat", "manik-manik", "mantra", "mata setan", "nazar"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("nazar verndargripur"),
            keywords: &[
                "heillagripur",
                "illt auga",
                "nazar",
                "perla",
                "verndargripur",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("occhio di Allah"),
            keywords: &["amuleto", "malocchio", "nazar", "occhio di Allah"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ナザール・ボンジュウ"),
            keywords: &[
                "お守り",
                "ナザール",
                "ナザール・ボンジュウ",
                "ビーズ",
                "邪視",
                "魔除け",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("jimat nazar"),
            keywords: &[
                "azimat",
                "jimat nazar",
                "manik-manik",
                "mantra",
                "mata setan",
                "nazar",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ფატიმას თვალი"),
            keywords: &[
                "ავგაროზი",
                "თილისმა",
                "თურქული თვალი",
                "ნაზარი",
                "ფატიმას თვალი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("бойтұмар"),
            keywords: &["бойтұмар", "таспиқ", "тұмар", "ғажайып", "өткір көз"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("បន\u{17d2}តោងមន\u{17d2}តអាគមណាហ\u{17d2}សា"),
            keywords: &[
                "ណាហ\u{17d2}សា",
                "បន\u{17d2}តោង",
                "បន\u{17d2}តោងគ\u{17d2}រឿងអលង\u{17d2}ការ",
                "បន\u{17d2}តោងមន\u{17d2}តអាគមណាហ\u{17d2}សា",
                "បន\u{17d2}តោងវេទមន\u{17d2}ត",
                "ភ\u{17d2}នែកប\u{17b7}សាច",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ನಜರ\u{ccd} ಅಮುಲ\u{cc6}ಟ\u{ccd}"),
            keywords: &[
                "ಕ\u{cc6}ಟ\u{ccd}ಟ ದೃಷ\u{ccd}ಟ\u{cbf}",
                "ತಲ\u{cbf}ಸ\u{ccd}ಮನ\u{ccd}",
                "ನಜರ\u{ccd}",
                "ನಜರ\u{ccd} ಅಮುಲ\u{cc6}ಟ\u{ccd}",
                "ಮಣ\u{cbf}",
                "ಮೋಡ\u{cbf}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("악마의 눈"),
            keywords: &["구슬", "나자르", "부적", "악마의 눈", "탈리스만"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("नजर ताईत"),
            keywords: &[
                "आकर\u{94d}शण",
                "जाद\u{941}गार नजर",
                "नजर ताईत",
                "मणी",
                "वायट-दोळो",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("көз мончок"),
            keywords: &[
                "коргоо",
                "көз мончок",
                "көз тийүү",
                "мончок",
                "назар түшүү",
                "тумар",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເຄ\u{eb7}\u{ec8}ອງລາງຂອງຂ\u{eb1}ງ"),
            keywords: &[
                "ລ\u{eb9}ກປ\u{eb1}ດ",
                "ສາຍປອງຮ\u{ec9}າຍ",
                "ເຄ\u{eb7}\u{ec8}ອງລາງ",
                "ເຄ\u{eb7}\u{ec8}ອງລາງຂອງຂ\u{eb1}ງ",
                "ໂອ\u{ec8}ງລ\u{ecd}\u{ec9}",
                "ໝ\u{ecd}ດ\u{eb9}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("amuletas akis"),
            keywords: &[
                "amuletas akis",
                "blogio akis",
                "karoliukas",
                "nazaras",
                "talismanas",
                "žavesys",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("amulets pret ļaunu aci"),
            keywords: &[
                "amulets pret ļaunu aci",
                "krelle",
                "nazars",
                "piekariņš",
                "talismans",
                "ļaunā acs",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("назар (амајлија)"),
            keywords: &[
                "амајлија",
                "бисер",
                "монистра",
                "назар",
                "назар (амајлија)",
                "талисман",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "കണ\u{d4d}ണ\u{d4d} തട\u{d4d}ട\u{d3e}തിരിക\u{d4d}ക\u{d3e}ന\u{d41}ള\u{d4d}ള മന\u{d4d}ത\u{d4d}രത\u{d4d}തകിട\u{d4d}",
            ),
            keywords: &[
                "ആകർഷണശക\u{d4d}തി",
                "കണ\u{d4d}ണ\u{d4d} തട\u{d4d}ട\u{d3e}തിരിക\u{d4d}ക\u{d3e}ന\u{d41}ള\u{d4d}ള മന\u{d4d}ത\u{d4d}രത\u{d4d}തകിട\u{d4d}",
                "തകിട\u{d4d}",
                "ദ\u{d43}ഷ\u{d4d}\u{200c}ടി ദോഷം",
                "മ\u{d41}ത\u{d4d}ത\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("цэнхэр нүд"),
            keywords: &[
                "зүүлт",
                "назар",
                "талисман",
                "увидас",
                "цэнхэр нүд",
                "чөтгөрийн нүд",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("नझर अ\u{200d}\u{945}म\u{94d}य\u{941}ल\u{947}ट"),
            keywords: &[
                "इव\u{94d}हिल-आय",
                "चार\u{94d}म",
                "ट\u{945}लिसम\u{945}न",
                "नझर",
                "नझर अ\u{200d}\u{945}म\u{94d}य\u{941}ल\u{947}ट",
                "बीड",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("azimat nazar"),
            keywords: &[
                "azimat nazar",
                "manik",
                "mantera",
                "mata syaitan",
                "nazar",
                "tangkal",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("နာဇာ အမ\u{103a}မြ\u{1030}လက\u{103a}"),
            keywords: &[
                "တာလ\u{102e}စ\u{103a}မန\u{103a}း",
                "နာဇာ",
                "နာဇာ အမ\u{103a}မြ\u{1030}လက\u{103a}",
                "ပ\u{102f}တ\u{102e}းစေ\u{1037}",
                "မန\u{1039}တန\u{103a}",
                "ယ\u{102f}တ\u{103a}မာသော အကြည\u{1037}\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("nazar"),
            keywords: &["amulett", "charm", "nazar", "ondt øye", "talisman"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ब\u{941}टी"),
            keywords: &[
                "आकर\u{94d}षण",
                "क\u{941}द\u{943}ष\u{94d}टि",
                "दाना",
                "नजर",
                "ब\u{941}टी",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("Nazar-amulet"),
            keywords: &[
                "Nazar",
                "Nazar-amulet",
                "amulet",
                "boze oog",
                "kraal",
                "talisman",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("nazar"),
            keywords: &["amulett", "charm", "nazar", "talisman", "vondt auge"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ନଜର\u{b4d}\u{200c} ଆମ\u{b41}ଲେଟ\u{b4d}\u{200c}"),
            keywords: &[
                "ଖର\u{b3e}ପ ଦ\u{b43}ଷ\u{b4d}ଟ\u{b3f}",
                "ଚ\u{b3e}ର\u{b4d}ମ",
                "ତ\u{b3e}ଲ\u{b3f}ସମ\u{b3e}ନ\u{b4d}\u{200c}",
                "ନଜର\u{b4d}\u{200c}",
                "ନଜର\u{b4d}\u{200c} ଆମ\u{b41}ଲେଟ\u{b4d}\u{200c}",
                "ବ\u{b3f}ଡ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਨਜ\u{a3c}ਰ ਤ\u{a4b}\u{a02} ਤਵੀਤ"),
            keywords: &[
                "ਤਵੀਤ",
                "ਨਜ\u{a3c}ਰ",
                "ਨਜ\u{a3c}ਰ ਤ\u{a4b}\u{a02} ਤਵੀਤ",
                "ਬ\u{a41}ਰੀ-ਨਜ\u{a3c}ਰ",
                "ਮ\u{a4b}ਤੀ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Ívúl-Aí Talisman"),
            keywords: &[
                "Bid",
                "Cham",
                "Nazar",
                "Talisman",
                "Ívúl-Ai",
                "Ívúl-Aí Talisman",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("amulet nazar"),
            keywords: &[
                "amulet nazar",
                "błękitne oko",
                "koralik",
                "nazar",
                "oko proroka",
                "talizman",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د نظر تعويذ"),
            keywords: &["بد نظر", "تسبيح", "جادو", "د نظر تعويذ", "نظر"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("olho grego"),
            keywords: &[
                "amuleto",
                "mau-olhado",
                "miçanga",
                "nazar",
                "olho grego",
                "talismã",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &[
                "amuleto",
                "mau-olhado",
                "missanga",
                "nazar",
                "olho grego",
                "olho turco",
                "talismã",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("amuletă nazar"),
            keywords: &[
                "amuletă",
                "amuletă nazar",
                "ochiul magic",
                "ochiul răului",
                "talisman",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E11-073"),
            keywords: &["E11-073"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("назар бонджук"),
            keywords: &[
                "амулет",
                "назар бонджук",
                "око",
                "сглаз",
                "синий",
                "талисман",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("نزر اميوليٽ"),
            keywords: &[
                "برائي واري نظر",
                "تسبيح",
                "تعويذ",
                "جادوئي تعويز",
                "نزر اميوليٽ",
                "نظر",
                "نظر جي تعويذ",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("න\u{dcf}ස\u{dcf}ර\u{dca} ස\u{dd4}වඳ"),
            keywords: &[
                "ආකර\u{dca}ෂණය",
                "ඇස\u{dca}වහ",
                "න\u{dcf}ස\u{dcf}ර\u{dca} ස\u{dd4}වඳ",
                "පබළ\u{dd4}",
                "ස\u{dd4}රය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("nazar"),
            keywords: &[
                "amulet",
                "korálka",
                "modré oko",
                "nazar",
                "prívesok",
                "talizman",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("amulet zlobno oko"),
            keywords: &[
                "amulet",
                "amulet zlobno oko",
                "koralda",
                "nazar",
                "talisman",
                "zlobno oko",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("balaayo xijaab"),
            keywords: &[
                "balaayo xijaab",
                "isha sheydaanka",
                "kahortage",
                "kuusha",
                "sixir",
                "xijaab",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("hajmali kundër syrit të keq"),
            keywords: &[
                "hajmali",
                "hajmali kundër syrit të keq",
                "mësysh",
                "rruazë",
                "syri i keq",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("назар"),
            keywords: &[
                "амајлија",
                "амулет назар",
                "назар",
                "перла",
                "талисман",
                "урок",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["назар"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("nazar"),
            keywords: &[
                "amajlija",
                "amulet nazar",
                "nazar",
                "perla",
                "talisman",
                "urok",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["nazar"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("onda ögat-sten"),
            keywords: &["amulett", "nazar", "onda ögat", "onda ögat-sten"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("hirizi"),
            keywords: &["hirizi", "kago", "pepo", "shanga", "talasimu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ந\u{bbe}ஜர\u{bcd} ஆமுலட\u{bcd}"),
            keywords: &[
                "அழகு",
                "தய\u{bbe}த\u{bcd}து",
                "த\u{bc0}ய கண\u{bcd}",
                "ந\u{bbe}சர\u{bcd}",
                "ந\u{bbe}ஜர\u{bcd} ஆமுலட\u{bcd}",
                "மணி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ద\u{c3f}ష\u{c4d}ట\u{c3f} రక\u{c4d}ష"),
            keywords: &[
                "చ\u{c46}డు దృష\u{c4d}ట\u{c3f}",
                "త\u{c3e}యత\u{c4d}తు",
                "ద\u{c3f}ష\u{c4d}ట\u{c3f}",
                "ద\u{c3f}ష\u{c4d}ట\u{c3f} రక\u{c4d}ష",
                "దృష\u{c4d}ట\u{c3f}",
                "పూస",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เคร\u{e37}\u{e48}องราง"),
            keywords: &[
                "น\u{e31}ยน\u{e4c}ตาป\u{e35}ศาจ",
                "ย\u{e31}นต\u{e4c}",
                "ล\u{e39}กป\u{e31}ด",
                "เคร\u{e37}\u{e48}องราง",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("göz monjuk"),
            keywords: &["göz", "monjuk", "tumar", "ýaman göz"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mana nasā"),
            keywords: &["mana nasā"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("nazarlık"),
            keywords: &[
                "boncuk",
                "kem göz",
                "mavi boncuk",
                "muska",
                "nazar",
                "nazarlık",
                "tılsım",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("Око Фатіми"),
            keywords: &[
                "Око Фатіми",
                "амулет",
                "наврочити",
                "назар",
                "пристріт",
                "талісман",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بری نظر کیلئے تعویز"),
            keywords: &[
                "بری نظر",
                "بری نظر کیلئے تعویز",
                "تعویز",
                "طلسمان",
                "موتی",
                "نظر",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("nazar tumori"),
            keywords: &["ko‘k", "ko‘z", "nazar", "nazar tumori", "talisman", "tumor"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bùa may mắn nazar"),
            keywords: &[
                "bùa",
                "bùa may mắn nazar",
                "hạt",
                "mê hoặc",
                "mắt ác",
                "nhìn",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("納扎爾護身符"),
            keywords: &["珠", "納扎爾", "納扎爾護身符", "護符", "邪眼", "魅力"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("纳扎尔护身符"),
            keywords: &["护符", "珠", "纳扎尔", "纳扎尔护身符", "邪眼", "魅力"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("纳扎尔护身符"),
            keywords: &[
                "小装饰品",
                "恶魔之眼",
                "护身符",
                "珠子",
                "纳扎尔",
                "纳扎尔护身符",
            ],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("邪眼"),
            keywords: &["珠子", "護身符", "避邪", "邪眼"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("E11:073"),
            keywords: &["E11:073", "bead", "charm", "evil-eye", "nazar", "talisman"],
        },
    ],
};
#[doc = "🎮"]
pub const VIDEO_GAME: crate::Emoji = crate::Emoji {
    glyph: "🎮",
    codepoint: "1F3AE",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "video game",
    group: "Activities",
    subgroup: "game",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("videospeletjie"),
            keywords: &["beheer", "kontrole", "speel", "video", "videospeletjie"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የቪዲዮ ጨዋታ"),
            keywords: &["መቆጣጠሪያ", "የቪዲዮ ጨዋታ", "ጨዋታ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("لعبة فيديو"),
            keywords: &["ألعاب", "جويستك", "لعبة فيديو"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ভিডিঅ’ গেম"),
            keywords: &[
                "ক\u{9cd}ৰীড\u{9bc}\u{9be}",
                "নিয\u{9bc}ন\u{9cd}ত\u{9cd}ৰক",
                "ভিডিঅ’ গেম",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("video oyun"),
            keywords: &["kontroller", "oyun", "video oyun"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("відэагульня"),
            keywords: &["відэагульня", "геймпад", "гульня", "кантролер"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("видеоигра"),
            keywords: &["видеоигра", "игра", "контролер"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ভিডিও গেম"),
            keywords: &["খেল\u{9be}", "নিয\u{9bc}ন\u{9cd}ত\u{9cd}রক", "ভিডিও গেম"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("cʼhoari video"),
            keywords: &["cʼhoari", "cʼhoari video"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("video igre"),
            keywords: &["igre", "upravljač", "video igre"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("videojoc"),
            keywords: &[
                "comandament de consola",
                "comandament de joc",
                "comandament de videoconsola",
                "joc",
                "videojoc",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏓᏴᎵᏛᏍᎩ ᏗᏁᎵᏙᏗ"),
            keywords: &["ᎠᏓᏴᎵᏛᏍᎩ ᏗᏁᎵᏙᏗ", "ᎨᏘᏴᏍᏗ", "ᏗᏁᏟᏙᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("videohra"),
            keywords: &["gamepad", "hra", "ovladač", "videohra"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("gêm fideo"),
            keywords: &["gêm", "gêm fideo", "rheolydd"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("videospil"),
            keywords: &["controller", "håndcontroller", "videospil"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Gamepad"),
            keywords: &["Gamepad", "Gaming", "Videospiel"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("βιντεοπαιχνίδι"),
            keywords: &["βιντεοπαιχνίδι", "παιχνίδι", "χειριστήριο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("video game"),
            keywords: &["controller", "game", "video game"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("mando de videoconsola"),
            keywords: &["juego", "mando", "mando de videoconsola", "videojuego"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("video juegos"),
            keywords: &[
                "control",
                "joystick",
                "juego",
                "mando",
                "video",
                "video juegos",
                "videojuego",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["control", "joystick", "juego", "mando", "video juegos"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["control", "joystick", "juego", "mando", "video juegos"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("videomäng"),
            keywords: &["mäng", "pult", "videomäng"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("bideo-jokoa"),
            keywords: &["bideo-jokoa", "joko", "kontroladore"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("بازی ویدیویی"),
            keywords: &["بازی", "بازی ویدیویی", "دسته", "کنترل\u{200c}کننده"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("videopeli"),
            keywords: &["ohjain", "peli", "videopeli"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("video game"),
            keywords: &["controller", "laro", "video game"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("kontrollari"),
            keywords: &["controller", "kontrollari", "telduspæl", "teldustýri"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("jeu vidéo"),
            keywords: &["jeu vidéo", "manette"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cluiche ríomhaire"),
            keywords: &[
                "cluiche",
                "cluiche ríomhaire",
                "rialaitheoir",
                "rialaitheoir cluichíochta",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("geama video"),
            keywords: &["geama", "geama video", "uidheam-smachd"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("videoxogo"),
            keywords: &["consola", "mando", "videoxogo", "xogo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("વિડિઓ ગ\u{ac7}મ"),
            keywords: &["ગ\u{ac7}મ", "નિય\u{a82}ત\u{acd}રક", "વિડિઓ ગ\u{ac7}મ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("wasan bidiyo"),
            keywords: &["masarrafa", "wasa", "wasan bidiyo"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("משחק וידאו"),
            keywords: &["וידאו", "מחשב", "משחק"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("वीडियो ग\u{947}म, क\u{902}ट\u{94d}रोलर"),
            keywords: &[
                "क\u{902}ट\u{94d}रोलर",
                "ग\u{947}म",
                "वीडियो ग\u{947}म",
                "वीडियो ग\u{947}म, क\u{902}ट\u{94d}रोलर",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("videoigrica"),
            keywords: &["igra", "kontroler", "videoigrica"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("videojáték"),
            keywords: &["játék", "kontroller", "videojáték"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("տեսախաղ"),
            keywords: &[
                "խաղ",
                "կոմպյուտերային խաղ",
                "համակարգչային խաղ",
                "վահանակ",
                "տեսախաղ",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("video game"),
            keywords: &["game", "pengontrol", "video game"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("egwuregwu vidio"),
            keywords: &["egwuregwu", "egwuregwu vidio", "onye njizi"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("tölvuleikur"),
            keywords: &["leikjatölva", "leikur", "stýripinni", "tölvuleikur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("gamepad"),
            keywords: &["console", "console videogioco", "gamepad", "gioco"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("テレビゲーム"),
            keywords: &["ゲーム", "コントローラ", "テレビゲーム", "ビデオゲーム"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("game video"),
            keywords: &["game", "game video", "pangontrol"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ვიდეო თამაში"),
            keywords: &["ვიდეო თამაში", "თამაში", "კონტროლერი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("бейне ойын"),
            keywords: &["басқару құралы", "бейне ойын", "ойын"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("videospil"),
            keywords: &["håndcontroller", "videospil"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ដៃហ\u{17d2}គេម"),
            keywords: &["ដៃហ\u{17d2}គេម", "បញ\u{17d2}ជា"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ವೀಡ\u{cbf}ಯೋ ಗೇಮ\u{ccd}"),
            keywords: &[
                "ಆಟ ನ\u{cbf}ಯಂತ\u{ccd}ರಕ",
                "ಆಟದ",
                "ನ\u{cbf}ಯಂತ\u{ccd}ರಕ",
                "ವೀಡ\u{cbf}ಯೋ ಗೇಮ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("비디오 게임"),
            keywords: &["게임 컨트롤러", "게임패드", "비디오 게임"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("व\u{94d}हिडियो ग\u{947}म"),
            keywords: &[
                "ग\u{947}म",
                "निय\u{902}त\u{94d}रक",
                "व\u{94d}हिडियो ग\u{947}म",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("видео оюну"),
            keywords: &["видео оюну", "көзөмөлдөгүч", "оюн"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Videospill"),
            keywords: &["Controller", "Manette", "Spill", "Videospill"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ວ\u{eb5}ດ\u{eb5}ໂອເກມ"),
            keywords: &[
                "ວ\u{eb4}ດ\u{eb5}ໂອ",
                "ວ\u{eb5}ດ\u{eb5}ໂອເກມ",
                "ເກມ",
                "ເກມວ\u{eb4}ດ\u{eb5}ໂອ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("vaizdo žaidimas"),
            keywords: &["vaizdo žaidimas", "valdiklis", "žaidimas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("videospēle"),
            keywords: &["konsole", "videospēle"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kēmu ataata"),
            keywords: &["kēmu", "kēmu ataata", "pūwhakahaere"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("видеоигра"),
            keywords: &["видеоигра", "игра", "контролер"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വീഡിയോ ഗെയിം"),
            keywords: &["കൺട\u{d4d}രോളർ", "ഗെയിംസ\u{d4d}", "വീഡിയോ ഗെയിം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("видео тоглоом"),
            keywords: &["видео", "тоглоом"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("व\u{94d}हिडिओ ग\u{947}म"),
            keywords: &[
                "ग\u{947}म",
                "निय\u{902}त\u{94d}रक",
                "व\u{94d}हिडिओ ग\u{947}म",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("permainan video"),
            keywords: &["alat kawalan", "permainan", "permainan video"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("video game"),
            keywords: &["kontrollur", "logħba", "video game"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဗ\u{102e}ဒ\u{102e}ယ\u{102d}\u{102f} ဂ\u{102d}မ\u{103a}း"),
            keywords: &[
                "ဂ\u{102d}မ\u{103a}း",
                "ထ\u{102d}န\u{103a}းချ\u{102f}ပ\u{103a}စက\u{103a}",
                "ဗ\u{102e}ဒ\u{102e}ယ\u{102d}\u{102f} ဂ\u{102d}မ\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("videospill"),
            keywords: &[
                "TV-spill",
                "konsoll",
                "kontroller",
                "spill",
                "spillkonsoll",
                "spillkontroller",
                "videospill",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("भिडियो ग\u{947}म"),
            keywords: &["ख\u{947}ल", "नियन\u{94d}त\u{94d}रक", "भिडियो ग\u{947}म"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("videogame"),
            keywords: &["controller", "game", "videogame"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("videospel"),
            keywords: &[
                "konsoll",
                "kontrollar",
                "spel",
                "spelkonsoll",
                "spelkontrollar",
                "videospel",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଭ\u{b3f}ଡ\u{b3f}ଓ ଗେମ\u{b4d}\u{200d}"),
            keywords: &[
                "ଖେଳ",
                "ନ\u{b3f}ୟନ\u{b4d}ତ\u{b4d}ରକ",
                "ଭ\u{b3f}ଡ\u{b3f}ଓ ଗେମ\u{b4d}\u{200d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਵੀਡੀਓ ਗ\u{a47}ਮ"),
            keywords: &[
                "ਕ\u{a70}ਟਰ\u{a4b}ਲਰ",
                "ਖ\u{a47}ਡ",
                "ਗ\u{a47}ਮ",
                "ਵੀਡੀਓ ਖ\u{a47}ਡ",
                "ਵੀਡੀਓ ਗ\u{a47}ਮ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("بصری کھیڈ"),
            keywords: &["بصری کھیڈ", "داروغہ", "کھیڈ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Vídió Gem"),
            keywords: &["Gem", "Kọntróla", "Vídió Gem"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("gra wideo"),
            keywords: &["gamepad", "gra wideo", "pad"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ویډیو لوبې"),
            keywords: &["قابو کوونکی", "لوبه", "ويډيو لوبې", "ویډیو لوبې"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("videogame"),
            keywords: &[
                "controle",
                "controle de videogame",
                "game",
                "jogo",
                "videogame",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("comando de consola"),
            keywords: &["comando", "comando de consola", "jogo"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("video pukllay"),
            keywords: &["patachaq", "pukllay", "video pukllay"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("joc video"),
            keywords: &["controller", "joc", "video"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-366"),
            keywords: &["E10-366"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("видеоигры"),
            keywords: &["playstation", "видеоигры", "игры", "компьютер", "приставка"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("videwo y’umukino"),
            keywords: &["mugenzuzi y’umukino", "videwo y’umukino"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ويڊيو راند"),
            keywords: &["ويڊيو راند", "ڪنٽرولر، راند"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ව\u{dd3}ඩ\u{dd2}යෝ ක\u{dca}\u{200d}ර\u{dd3}ඩ\u{dcf}ව"),
            keywords: &[
                "ක\u{dca}\u{200d}ර\u{dd3}ඩ\u{dcf}ව",
                "ප\u{dcf}ලකය",
                "ව\u{dd3}ඩ\u{dd2}යෝ ක\u{dca}\u{200d}ර\u{dd3}ඩ\u{dcf}ව",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("videohra"),
            keywords: &["hra", "ovládač", "videohra"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("videoigra"),
            keywords: &["igra", "krmilnik", "videoigra"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("cayaarta maqal-muuqal"),
            keywords: &[
                "cayaarta maqal-muuqal",
                "ciyaar",
                "ciyaarta maqal-muuqaalka",
                "xakameeye",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("videolojë"),
            keywords: &["kontrollues", "lojë", "videolojë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("видео игра"),
            keywords: &["видео игра", "игрa", "кoнтрoлeр"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("video igra"),
            keywords: &["igra", "kontroler", "video igra"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("tv-spel"),
            keywords: &["kontroll", "spel", "tv-spel", "tv-spelskontroll"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mchezo wa video"),
            keywords: &["kidhibiti", "mchezo", "mchezo wa video"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வ\u{bc0}டியோ கேம\u{bcd}"),
            keywords: &[
                "கன\u{bcd}ட\u{bcd}ரோலர\u{bcd}",
                "கேம\u{bcd}",
                "ச\u{bbe}தனம\u{bcd}",
                "வ\u{bc0}டியோ கேம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("వ\u{c40}డ\u{c3f}య\u{c4b} గ\u{c47}మ\u{c4d}"),
            keywords: &[
                "కంట\u{c4d}ర\u{c4b}లర\u{c4d}",
                "గ\u{c47}మ\u{c4d}",
                "ర\u{c3f}మ\u{c4b}ట\u{c4d}",
                "వ\u{c40}డ\u{c3f}య\u{c4b} గ\u{c47}మ\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("бозии видеоӣ"),
            keywords: &["бозии видеоӣ", "бозӣ", "танзимгар"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ว\u{e34}ด\u{e35}โอเกม"),
            keywords: &["จอยสต\u{e34}\u{e4a}ก", "ว\u{e34}ด\u{e35}โอเกม", "เกม"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("wideo oýun"),
            keywords: &["dolandyryjy", "oýun", "wideo oýun"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("vaʻinga vitiō"),
            keywords: &["vaʻinga vitiō"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("video oyunu"),
            keywords: &[
                "kontrol cihazı",
                "oyun",
                "oyun kontrol cihazı",
                "video oyunu",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئېلېكتىرونلۇق ئويۇن"),
            keywords: &["ئويۇن", "ئېلېكتىرونلۇق ئويۇن", "تىزگىن"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("ігровий контролер"),
            keywords: &["гра", "контролер", "ігровий контролер"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ویڈیو گیم"),
            keywords: &["ویڈیو", "ویڈیو گیم", "کھیل"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("video o‘yin"),
            keywords: &["kontroller", "o‘yin", "video o‘yin"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("trò chơi điện tử"),
            keywords: &["tay điều khiển", "trò chơi", "trò chơi điện tử"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("powum wideo"),
            keywords: &["manet", "po", "powum wideo"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umdlalo wevidiyo"),
            keywords: &["isilawuli", "umdlalo", "umdlalo wevidiyo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ere-idaraya Fidio"),
            keywords: &["Ere-idaraya Fidio", "eré", "olùdarí"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("電視遊戲"),
            keywords: &["控制器", "遊戲", "電視遊戲"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("电视游戏"),
            keywords: &["控制器", "游戏", "电视游戏"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("游戏手柄"),
            keywords: &["手柄", "游戏手柄", "电子游戏"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("電玩"),
            keywords: &["電動", "電玩"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("電子遊戲"),
            keywords: &["電子遊戲", "電玩"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umdlalo wevidiyo"),
            keywords: &["isilawuli", "umdlalo", "umdlalo wevidiyo"],
        },
    ],
};
#[doc = "🕹\u{fe0f}"]
pub const JOYSTICK: crate::Emoji = crate::Emoji {
    glyph: "🕹\u{fe0f}",
    codepoint: "1F579 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "joystick",
    group: "Activities",
    subgroup: "game",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🕹",
        codepoint: "1F579",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "joystick",
        group: "Activities",
        subgroup: "game",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("speelstok"),
            keywords: &["speel", "speelstok", "stang", "stok", "video"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ጆይስቲክ"),
            keywords: &["ቪዲዮ ጨዋታ", "ጆይስቲክ", "ጨዋታ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ذراع تحكم"),
            keywords: &["ذراع تحكم", "لعبة", "لعبة فيديو"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("জয\u{9bc}ষ\u{9cd}টিক"),
            keywords: &[
                "ক\u{9cd}ৰীড\u{9bc}\u{9be}",
                "জয\u{9bc}ষ\u{9cd}টিক",
                "ভিডিঅ’ গেম",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("coystik"),
            keywords: &["coystik", "oyun", "video oyun"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("джойстык"),
            keywords: &["відэагульня", "гульня", "джойстык", "кантролер"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("джойстик"),
            keywords: &["видеоигра", "джойстик", "игра"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("জয\u{9bc}স\u{9cd}টিক"),
            keywords: &["খেল\u{9be}", "জয\u{9bc}স\u{9cd}টিক", "ভিডিও গেম"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("lanker cʼhoari"),
            keywords: &["cʼhoari", "cʼhoari video", "lanker cʼhoari"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("džojstik"),
            keywords: &["džojstik", "igre", "video igre"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("palanca de control"),
            keywords: &[
                "control",
                "joystick",
                "palanca",
                "palanca de control",
                "videojoc",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎨᏘᏴᏍᏗ"),
            keywords: &["ᎨᏘᏴᏍᏗ", "ᏗᏁᏟᏙᏗ", "ᏗᏓᏴᎳᏛᏍᎩ ᏗᏁᏟᏙᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("joystick"),
            keywords: &["hra", "joystick", "ovladač", "videohra"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("ffon reoli"),
            keywords: &["ffon reoli", "fideo", "gêm"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("joystick"),
            keywords: &["joystick", "spil", "videospil"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Joystick"),
            keywords: &["Gaming", "Joystick", "Videospiel"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("joystick"),
            keywords: &["joystick", "βιντεοπαιχνίδι", "παιχνίδι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("joystick"),
            keywords: &["game", "joystick", "video game"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("joystick"),
            keywords: &["joystick", "juego", "mando", "palanca", "videojuego"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &[
                "control",
                "joystick",
                "juego",
                "mando",
                "video",
                "videojuego",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "control",
                "joystick",
                "juego",
                "juego de video",
                "video",
                "videojuego",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("juhtpult"),
            keywords: &["juhtpult", "mäng", "pult"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("joko-palanka"),
            keywords: &["bideo", "joko", "joko-palanka"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دسته بازی"),
            keywords: &["بازی", "بازی ویدیویی", "دسته بازی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("joystick"),
            keywords: &["joystick", "ohjain", "sauvaohjain", "videopeli"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("joystick"),
            keywords: &["controller", "joystick", "laro", "video game"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("stýripinnur"),
            keywords: &["joystick", "stýripinnur", "telduspæl"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("manette de jeu"),
            keywords: &["jeu", "jeu vidéo", "joystick", "manette de jeu"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("luamhán stiúrtha"),
            keywords: &["cluiche", "físchluiche", "luamhán stiúrtha"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("bioran-smachd"),
            keywords: &["bioran-smachd", "geama", "video"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("panca de control"),
            keywords: &[
                "consola",
                "joystick",
                "panca de control",
                "panca de mando",
                "videoxogo",
                "xogo",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("જોયસ\u{acd}ટિક"),
            keywords: &["જોયસ\u{acd}ટિક", "રમત", "વિડિઓ ગ\u{ac7}મ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("abin buga wasa"),
            keywords: &["abin buga wasa", "wasan", "wasan bidiyo"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("ג׳ויסטיק"),
            keywords: &["ג׳ויסטיק", "מחשב", "משחק"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("जॉयस\u{94d}टिक, ग\u{947}म, वीडियो ग\u{947}म"),
            keywords: &[
                "ग\u{947}म",
                "जॉयस\u{94d}टिक",
                "जॉयस\u{94d}टिक, ग\u{947}म, वीडियो ग\u{947}म",
                "वीडियो ग\u{947}म",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("igraća palica"),
            keywords: &["igra", "igraća palica", "videoigra"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("joystick"),
            keywords: &["joystick", "játék", "videojáték"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ջոյսթիք"),
            keywords: &["խաղ", "ջոյսթիք", "տեսախաղ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("joystick"),
            keywords: &["game", "game video", "joystick"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ngwa egwuregwu kọmputa"),
            keywords: &["egwuregwu", "egwuregwu vidio", "ngwa egwuregwu kọmputa"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("stýripinni"),
            keywords: &["leikur", "stýripinni", "tölvuleikur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("joystick"),
            keywords: &["giocare", "joystick", "leva del joystick", "videogioco"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ジョイスティック"),
            keywords: &[
                "ゲーム",
                "コントローラ",
                "ジョイスティック",
                "スティック",
                "テレビゲーム",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tuas kontrol"),
            keywords: &["game", "game video", "tuas kontrol"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ჯოისტიკი"),
            keywords: &["ვიდეო თამაში", "თამაში", "ჯოისტიკი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("джойстик"),
            keywords: &["бейне ойын", "джойстик", "ойын"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("joystick"),
            keywords: &["joystick", "spil", "videospil"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ដងបញ\u{17d2}ជាហ\u{17d2}គេម"),
            keywords: &["ដងបញ\u{17d2}ជាហ\u{17d2}គេម", "បញ\u{17d2}ជា"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಜಾಯ\u{ccd}\u{200c}ಸ\u{ccd}ಟ\u{cbf}ಕ\u{ccd}"),
            keywords: &[
                "ಆಟ",
                "ಗೇಮ\u{ccd}",
                "ಜಾಯ\u{ccd}\u{200c}ಸ\u{ccd}ಟ\u{cbf}ಕ\u{ccd}",
                "ವೀಡ\u{cbf}ಯೊ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("조이스틱"),
            keywords: &["게임", "비디오 게임", "조이스틱", "조종대"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("जॉयस\u{94d}टिक"),
            keywords: &["ग\u{947}म", "जॉयस\u{94d}टिक", "व\u{94d}हिडियो ग\u{947}म"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жойстик"),
            keywords: &["видео оюну", "жойстик", "оюн"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Joystick"),
            keywords: &["Joystick", "Spill", "Videospill"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຄ\u{eb1}ນບ\u{eb1}ງຄ\u{eb1}ບ"),
            keywords: &[
                "ຄ\u{eb1}ນບ\u{eb1}ງຄ\u{eb1}ບ",
                "ເກມ",
                "ເກມວ\u{eb4}ດ\u{eb5}ໂອ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("valdymo svirtis"),
            keywords: &["vaizdo žaidimas", "valdymo svirtis", "žaidimas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("kursorsvira"),
            keywords: &["kursorsvira", "spēle", "videospēle"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("rākau mana"),
            keywords: &["kēmu", "kēmu ataata", "rākau mana"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("џојстик"),
            keywords: &["видеоигра", "игра", "џојстик"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ജോയ\u{d4d}\u{200c}സ\u{d4d}റ\u{d4d}റിക\u{d4d}"),
            keywords: &[
                "ഗെയിം",
                "ജോയ\u{d4d}\u{200c}സ\u{d4d}റ\u{d4d}റിക\u{d4d}",
                "വീഡിയോ ഗെയിം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("удирдлага"),
            keywords: &["тоглоом", "удирдлага"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("जॉयस\u{94d}टिक"),
            keywords: &["ग\u{947}म", "जॉयस\u{94d}टिक", "व\u{94d}हिडिओ ग\u{947}म"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kayu bedik"),
            keywords: &["kayu bedik", "permainan", "permainan video"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("joystick"),
            keywords: &["joystick", "logħba", "video game"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပ\u{1032}\u{1037}ထ\u{102d}န\u{103a}းမဏ\u{1039}ဍ\u{102d}\u{102f}င\u{103a}"),
            keywords: &[
                "ဂ\u{102d}မ\u{103a}း",
                "ပ\u{1032}\u{1037}ထ\u{102d}န\u{103a}းမဏ\u{1039}ဍ\u{102d}\u{102f}င\u{103a}",
                "ဗ\u{102e}ဒ\u{102e}ယ\u{102d}\u{102f}ဂ\u{102d}မ\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("joystick"),
            keywords: &["joystick", "spill", "styrespak", "styrespake", "videospill"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("जोस\u{94d}टिक"),
            keywords: &["ख\u{947}ल", "जोस\u{94d}टिक", "भिडियो ग\u{947}म"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("joystick"),
            keywords: &["game", "joystick", "videogame"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("joystick"),
            keywords: &["joystick", "spel", "styrespak", "styrespake", "videospel"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଜଏଷ\u{b4d}ଟ\u{b3f}କ\u{b4d}\u{200d}"),
            keywords: &[
                "ଖେଳ । ଜଏଷ\u{b4d}ଟ\u{b3f}କ\u{b4d}\u{200d}",
                "ଜଏଷ\u{b4d}ଟ\u{b3f}କ\u{b4d}\u{200d}",
                "ଭ\u{b3f}ଡ\u{b3f}ଓ ଗେମ\u{b4d}\u{200d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਜ\u{a41}ਆਏਸਟਿ\u{a71}ਕ"),
            keywords: &["ਗ\u{a47}ਮ", "ਜ\u{a41}ਆਏਸਟਿ\u{a71}ਕ", "ਵੀਡੀਓ ਗ\u{a47}ਮ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("جوائے سٹک"),
            keywords: &["بصری کھیڈ", "جوائے سٹک", "کھیڈ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Jọístik"),
            keywords: &["Gem", "Jọístik", "Vídió Gem"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("dżojstik"),
            keywords: &["dżojstik", "gra", "gra komputerowa", "gra wideo"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("جوی سټیک"),
            keywords: &["جوی سټيک", "جوی سټیک", "لوبه", "ويډيو ګيم"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("joystick"),
            keywords: &["game", "jogo", "joystick", "videogame"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("joystick"),
            keywords: &["jogo", "joystick", "videojogo"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("palanca patachaqpaq"),
            keywords: &["palanca patachaqpaq", "pukllay", "video pukllay"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("joystick"),
            keywords: &["joc", "joystick", "manetă", "video"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-800"),
            keywords: &["E10-800"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("джойстик"),
            keywords: &[
                "видеоигра",
                "джойстик",
                "игровая приставка",
                "игры",
                "компьютер",
                "приставка",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("agakonimukino"),
            keywords: &["agakonimukino", "imikino ya videwo", "umukino"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("جوائي اسٽڪ"),
            keywords: &["جوائي اسٽڪ", "راند، ويڊيو راند"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ජෝය\u{dd2}ස\u{dca}ට\u{dd2}ක\u{dca}"),
            keywords: &[
                "ක\u{dca}\u{200d}ර\u{dd3}ඩ\u{dcf}ව",
                "ජෝය\u{dd2}ස\u{dca}ට\u{dd2}ක\u{dca}",
                "ව\u{dd2}\u{dd3}ඩ\u{dd2}යෝ ක\u{dca}\u{200d}ර\u{dd3}ඩ\u{dcf}ව",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("joystick"),
            keywords: &["hra", "joystick", "páka", "videohra"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("igralna palica"),
            keywords: &["igra", "igralna palica", "videoigra"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("usha farxada"),
            keywords: &["ciyaar", "ciyaarta maqal-muuqaalka", "usha farxada"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("levë"),
            keywords: &["levë", "lojë", "videolojë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("џојстик"),
            keywords: &["видeo игрa", "игрa", "џојстик"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("džojstik"),
            keywords: &["džojstik", "igra", "video igra"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("joystick"),
            keywords: &["joystick", "spak", "spel", "styrspak"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("usukani"),
            keywords: &["mchezo", "mchezo wa video", "usukani"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஜ\u{bbe}ய\u{bcd} ஸ\u{bcd}டிக\u{bcd}"),
            keywords: &[
                "கேம\u{bcd}",
                "ஜ\u{bbe}ய\u{bcd} ஸ\u{bcd}டிக\u{bcd}",
                "வ\u{bc0}டியோ கேம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("జ\u{c3e}య\u{c4d}\u{200c}స\u{c4d}ట\u{c3f}క\u{c4d}"),
            keywords: &[
                "గ\u{c47}మ\u{c4d}",
                "జ\u{c3e}య\u{c4d}\u{200c}స\u{c4d}ట\u{c3f}క\u{c4d}",
                "వ\u{c40}డ\u{c3f}య\u{c4b} గ\u{c47}మ\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ҷойстик"),
            keywords: &["бозии видеоӣ", "бозӣ", "ҷойстик"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("จอยสต\u{e34}\u{e4a}ก"),
            keywords: &["จอยสต\u{e34}\u{e4a}ก", "ว\u{e34}ด\u{e35}โอ", "เกม"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("joýstik"),
            keywords: &["joýstik", "oýun", "wideo oýun"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ʻakau vaʻinga"),
            keywords: &["ʻakau vaʻinga"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("oyun çubuğu"),
            keywords: &["oyun", "oyun çubuğu", "video oyunu"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئويۇن تىزگىنىكى"),
            keywords: &["ئويۇن", "ئويۇن تىزگىنىكى", "ئېلېكتىرونلۇق ئويۇن"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("джойстик"),
            keywords: &["відеогра", "гра", "джойстик"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("جوائے اسٹک"),
            keywords: &["جوائے اسٹک", "ویڈیو", "کنٹرول", "کھیل"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("joystik"),
            keywords: &["joystik", "o‘yin", "video o‘yin"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("cần điều khiển"),
            keywords: &["cần điều khiển", "trò chơi", "trò chơi điện tử"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("joystick"),
            keywords: &["joystick", "po", "powu wideo"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-joystick"),
            keywords: &["i-joystick", "umdlalo", "umdlalo wevidiyo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ìdarí eré"),
            keywords: &["Ere-idaraya", "Ere-idaraya Fidio", "ìdarí eré"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("遊戲桿"),
            keywords: &["遊戲", "遊戲桿", "電視遊戲"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("游戏杆"),
            keywords: &["游戏", "游戏杆", "电视游戏"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("游戏操控杆"),
            keywords: &["操控杆", "游戏操控杆", "电子游戏"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("搖桿"),
            keywords: &["搖桿", "操控桿"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("控制杆"),
            keywords: &["控制杆"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ijoystiki"),
            keywords: &["ijoystiki", "umdlalo", "umdlalo wevidiyo"],
        },
    ],
};
#[doc = "🎰"]
pub const SLOT_MACHINE: crate::Emoji = crate::Emoji {
    glyph: "🎰",
    codepoint: "1F3B0",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "slot machine",
    group: "Activities",
    subgroup: "game",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("muntoutomaat"),
            keywords: &["casino", "dobbel", "munt", "muntoutomaat"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("በሳንቲም የሚሠራ ማሽን"),
            keywords: &["ቀዳዳ", "በሳንቲም የሚሠራ ማሽን", "ጨዋታ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("جهاز قمار"),
            keywords: &["جهاز قمار", "قمار", "لعبة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("শ\u{9cd}লট মেচিন"),
            keywords: &["খেল", "শ\u{9cd}লট", "শ\u{9cd}লট মেচিন"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("avtomat maşın"),
            keywords: &["avtomat", "avtomat maşın", "oyun"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("гульнявы аўтамат"),
            keywords: &["аўтамат", "гульня", "гульнявы аўтамат", "жэтон"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("ротативка"),
            keywords: &["игра", "ротативка"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("স\u{9cd}লট মেশিন"),
            keywords: &["খেল\u{9be}", "স\u{9cd}লট", "স\u{9cd}লট মেশিন"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("automat za kockanje"),
            keywords: &["aparat", "automat za kockanje", "igra", "kocka"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("màquina escurabutxaques"),
            keywords: &["atzar", "escurabutxaques", "joc", "màquina escurabutxaques"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏕᎳ ᎦᏠᏗ ᎪᏢᏍᎩ"),
            keywords: &["ᎠᏕᎳ ᎦᏠᏗ ᎪᏢᏍᎩ", "ᎤᏟᏅᏛᎢ", "ᏗᏁᏟᏙᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("výherní automat"),
            keywords: &["automat", "hra", "výherní automat"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("peiriant slot"),
            keywords: &["gêm", "peiriant slot", "slot"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("spillemaskine"),
            keywords: &["spil", "spillemaskine"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Spielautomat"),
            keywords: &["Glücksspiel", "Spiel", "Spielautomat"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κουλοχέρης"),
            keywords: &["κουλοχέρης", "παιχνίδι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("slot machine"),
            keywords: &["game", "slot", "slot machine"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &[
                "fruit machine",
                "game",
                "one-armed bandit",
                "slot",
                "slot machine",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("pokie"),
            keywords: &["game", "pokie", "pokies"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("máquina tragaperras"),
            keywords: &["juego", "máquina", "máquina tragaperras"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("tragamonedas"),
            keywords: &[
                "apostar",
                "apuestas",
                "casino",
                "juego",
                "máquina",
                "tragamonedas",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["apuestas", "casino", "juego", "máquina", "tragamonedas"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("máquina tragamonedas"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("mänguautomaat"),
            keywords: &["automaat", "mäng", "mänguautomaat"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("txanpon-makina"),
            keywords: &["joko", "txanpon", "txanpon-makina"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ماشین پولی"),
            keywords: &["اسلات", "بازی", "قمار", "ماشین", "ماشین پولی", "کازینو"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("pelikone"),
            keywords: &["kolikko", "pelikone", "rahapeli"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("slot machine"),
            keywords: &["japanese", "laro", "pachinko", "slot machine", "sugal"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("spæliautomat"),
            keywords: &["kasino", "spæliautomat"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("machine à sous"),
            keywords: &["jeu", "machine à sous"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("meaisín sliotáin"),
            keywords: &["cluiche", "meaisín sliotáin"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("inneal shlotaichean"),
            keywords: &["geama", "inneal shlotaichean", "slot"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("máquina comecartos"),
            keywords: &["bar", "casino", "máquina comecartos", "xogo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{acd}લોટ મશીન"),
            keywords: &["રમત", "સ\u{acd}લોટ", "સ\u{acd}લોટ મશીન"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("na’urar kaya mai karɓin kuɗi"),
            keywords: &["na’urar kaya mai karɓin kuɗi", "rami", "wasa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מכונת מזל"),
            keywords: &["מזל", "מכונת מזל", "משחק", "קזינו"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("स\u{94d}लॉट मशीन"),
            keywords: &["ग\u{947}म", "स\u{94d}लॉट", "स\u{94d}लॉट मशीन"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("jednoruki jack"),
            keywords: &["automat", "igra", "jednoruki jack"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("nyerőgép"),
            keywords: &["játékgép", "nyerőgép", "pénzbedobós"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("խաղային ավտոմատ"),
            keywords: &["ավտոմատ", "խաղ", "խաղային ավտոմատ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("mesin slot"),
            keywords: &["game", "mesin slot", "slot"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("igwe ntinye ihe"),
            keywords: &["egwuregwu", "igwe ntinye ihe", "ntinye ihe"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("spilakassi"),
            keywords: &["leikur", "spilakassi"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("slot machine"),
            keywords: &["gioco", "slot", "slot machine"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("スロットマシン"),
            keywords: &["スリーセブン", "スロット", "スロットマシン"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("mesin slot"),
            keywords: &["game", "mesin slot", "slot"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სლოტ-ავტომატი"),
            keywords: &["თამაში", "სლოტ-ავტომატი", "სლოტები"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ойын автоматы"),
            keywords: &["автомат", "ойын", "ойын автоматы"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("spillemaskine"),
            keywords: &["spil", "spillemaskine"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17c9}ាស\u{17ca}\u{17b8}នហ\u{17d2}គេមបង\u{17d2}វ\u{17b7}ល"),
            keywords: &[
                "ទ\u{17bc}ហ\u{17d2}គេម",
                "ម\u{17c9}ាស\u{17ca}\u{17b8}នលេងហ\u{17d2}គេម",
                "ម\u{17c9}ាស\u{17ca}\u{17b8}នហ\u{17d2}គេមបង\u{17d2}វ\u{17b7}ល",
                "ម\u{17c9}ាស\u{17ca}\u{17b8}ហ\u{17d2}គេមបង\u{17d2}វ\u{17b7}ល",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸ\u{ccd}ಲಾಟ\u{ccd} ಯಂತ\u{ccd}ರ"),
            keywords: &["ಸ\u{ccd}ಲಾಟ\u{ccd}", "ಸ\u{ccd}ಲಾಟ\u{ccd} ಯಂತ\u{ccd}ರ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("슬롯 머신"),
            keywords: &["게임", "슬롯 머신", "파칭코"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("स\u{94d}लॉट मशीन"),
            keywords: &["ग\u{947}म", "स\u{94d}लॉट", "स\u{94d}लॉट मशीन"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("оюн автоматы"),
            keywords: &["автомат", "оюн", "оюн автоматы"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Spillautomat"),
            keywords: &["Automat", "Spill", "Spillautomat"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເຄ\u{eb7}\u{ec8}ອງຫ\u{ebc}\u{eb4}\u{ec9}ນເກມສະລອດ"),
            keywords: &["ເກມ", "ເຄ\u{eb7}\u{ec8}ອງຫ\u{ebc}\u{eb4}\u{ec9}ນເກມສະລອດ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("žaidimų automatas"),
            keywords: &["automatas", "žaidimas", "žaidimų automatas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("spēļu automāts"),
            keywords: &["automāts", "spēle", "spēļu automāts"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("mīhini kaimoni"),
            keywords: &["kāniwha", "kēmu", "mīhini kaimoni"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("автомат за игри"),
            keywords: &["автомат", "автомат за игри", "игра"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("സ\u{d4d}ലോട\u{d4d}ട\u{d4d} മെഷീൻ"),
            keywords: &["ഗെയിം", "സ\u{d4d}ലോട\u{d4d}ട\u{d4d} മെഷീൻ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хонжворт тоглоомын машин"),
            keywords: &["машин", "тоглоом", "хонжвор", "хонжворт тоглоомын машин"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("स\u{94d}लॉट मशीन"),
            keywords: &["ग\u{947}म", "स\u{94d}लॉट", "स\u{94d}लॉट मशीन"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("mesin judi"),
            keywords: &["mesin judi", "permainan", "slot"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("slot machine"),
            keywords: &["logħba", "slot", "slot machine"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လောင\u{103a}းကစားစက\u{103a}"),
            keywords: &[
                "ဂ\u{102d}မ\u{103a}း",
                "ဈေးရောင\u{103a}းစက\u{103a}",
                "လောင\u{103a}းကစားစက\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("spilleautomat"),
            keywords: &["spill", "spilleautomat"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{94d}ल\u{94d}ट यन\u{94d}त\u{94d}र"),
            keywords: &[
                "ख\u{947}ल",
                "स\u{94d}लट",
                "स\u{94d}ल\u{94d}ट यन\u{94d}त\u{94d}र",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("fruitautomaat"),
            keywords: &["fruitautomaat", "spel"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("speleautomat"),
            keywords: &["spel", "speleautomat"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସ\u{b4d}ଲଟ\u{b4d}\u{200c} ମେସ\u{b3f}ନ\u{b4d}\u{200c}"),
            keywords: &[
                "ଖେଳ",
                "ସ\u{b4d}ଲଟ\u{b4d}\u{200c}",
                "ସ\u{b4d}ଲଟ\u{b4d}\u{200c} ମେସ\u{b3f}ନ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸਲ\u{a4b}ਟ ਮਸ\u{a3c}ੀਨ"),
            keywords: &[
                "ਖ\u{a47}ਡ",
                "ਨ\u{a70}ਬਰ",
                "ਨ\u{a70}ਬਰ ਮਸ\u{a3c}ੀਨ",
                "ਸਲ\u{a4b}ਟ",
                "ਸਲ\u{a4b}ਟ ਮਸ\u{a3c}ੀਨ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("مغوری کرن آلی مشین"),
            keywords: &["سلاٹ", "مغوری کرن آلی مشین", "کھیڈ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Gámblín Máshin"),
            keywords: &[
                "Gem",
                "Gámblín Máshin",
                "Kalukalu",
                "Kalukalu Gámblín Mashin",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("automat do gier"),
            keywords: &[
                "automat do gier",
                "automat do gry",
                "jednoręki bandyta",
                "kasyno",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سلاټ ماشين"),
            keywords: &["سلاټ", "سلاټ ماشين", "لوبه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("caça-níquel"),
            keywords: &["caça-níquel", "jogo de azar", "máquina caça-níqueis"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("slot machine"),
            keywords: &["jogo", "slot", "slot machine"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("casinopaq maquina"),
            keywords: &["casinopaq maquina", "kampu", "pukllay"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("jocuri mecanice"),
            keywords: &["joc", "jocuri mecanice", "manetă", "noroc"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-368"),
            keywords: &["E10-368"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("игровой автомат"),
            keywords: &["автомат", "азарт", "деньги", "игровой автомат", "казино"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("akamashini gatanga amatike"),
            keywords: &["akamashini gatanga amatike", "igice", "umukino"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("خانن واري مشيني راند"),
            keywords: &["خانن واري مشيني راند", "خانو", "راند"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ව\u{dd2}ද\u{dd4}ම\u{dca} යන\u{dca}ත\u{dca}\u{200d}රය"),
            keywords: &[
                "ක\u{dca}\u{200d}ර\u{dd3}ඩ\u{dcf}ව",
                "ව\u{dd2}ද\u{dd4}ම",
                "ව\u{dd2}ද\u{dd4}ම\u{dca} යන\u{dca}ත\u{dca}\u{200d}රය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("výherný automat"),
            keywords: &["hazard", "hra", "výherný automat", "výhra"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("igralni avtomat"),
            keywords: &["avtomat", "igra", "igralni avtomat"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("mashiinka kabaha"),
            keywords: &["ciyaar", "kabaha", "mashiinka kabaha"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("lojë me monedha"),
            keywords: &["lojë", "lojë me monedha", "monedhë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("слот-машина"),
            keywords: &["aутoмaт", "игрa", "слот-машина"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("slot-mašina"),
            keywords: &["automat", "igra", "slot-mašina"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("enarmad bandit"),
            keywords: &["enarmad bandit", "spel", "spelautomat", "spelmaskin"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mashine ya kamari"),
            keywords: &["mashine ya kamari", "mchezo"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஸ\u{bcd}ல\u{bbe}ட\u{bcd} மிஷின\u{bcd}"),
            keywords: &[
                "விளைய\u{bbe}ட\u{bcd}டு",
                "ஸ\u{bcd}ல\u{bbe}ட\u{bcd}",
                "ஸ\u{bcd}ல\u{bbe}ட\u{bcd} இயந\u{bcd}திரம\u{bcd}",
                "ஸ\u{bcd}ல\u{bbe}ட\u{bcd} மிஷின\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("స\u{c4d}ల\u{c3e}ట\u{c4d} మ\u{c46}ష\u{c40}న\u{c4d}"),
            keywords: &["మ\u{c46}ష\u{c40}న\u{c4d}", "స\u{c4d}ల\u{c3e}ట\u{c4d}"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("мошинаи қиморбозӣ"),
            keywords: &["бозӣ", "ковокӣ", "мошинаи қиморбозӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("สล\u{e47}อตแมชช\u{e35}น"),
            keywords: &["สล\u{e47}อต", "สล\u{e47}อตแมชช\u{e35}น", "เกม"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("oýun awtomaty"),
            keywords: &["awtomat", "oýun", "oýun awtomaty"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mīsini tā paʻanga"),
            keywords: &["mīsini tā paʻanga"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kumar makinesi"),
            keywords: &["kumar", "kumar makinesi", "oyun"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("مال ساتقۇچ"),
            keywords: &["ئويۇن", "سېتىش", "مال ساتقۇچ"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("гральний автомат"),
            keywords: &["автомат", "гральний автомат", "ігровий"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سلاٹ مشین"),
            keywords: &["سلاٹ مشین", "گیم"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("o‘yin avtomati"),
            keywords: &["avtomat", "o‘yin", "o‘yin avtomati"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("máy giật xèng"),
            keywords: &["khe", "máy giật xèng", "trò chơi"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("masinu xaalis"),
            keywords: &["masin", "masinu xaalis", "xaalis"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umatshini wokuthengisa"),
            keywords: &["i-slot", "umatshini wokuthengisa", "umdlalo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ẹrọ Ifisi"),
            keywords: &["eré", "ìfisí", "Ẹrọ Ifisi"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("老虎機"),
            keywords: &["投幣口", "老虎機", "遊戲"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("老虎机"),
            keywords: &["投币口", "游戏", "老虎机"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("老虎机"),
            keywords: &["游戏", "老虎机", "角子机", "赌博"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("吃角子老虎"),
            keywords: &["吃角子老虎", "拉霸機"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("老虎機"),
            keywords: &["老虎機"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umshini onembotshana yokufaka imali"),
            keywords: &[
                "imbotshana yokufaka imali",
                "umdlalo",
                "umshini onembotshana yokufaka imali",
            ],
        },
    ],
};
#[doc = "🎲"]
pub const GAME_DIE: crate::Emoji = crate::Emoji {
    glyph: "🎲",
    codepoint: "1F3B2",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "game die",
    group: "Activities",
    subgroup: "game",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("dobbelsteen"),
            keywords: &["dobbelsteen", "speletjie"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የጨዋታ ዳይ"),
            keywords: &["የጨዋታ ዳይ", "ዳይ", "ዳዮች", "ጨዋታ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("زهر"),
            keywords: &["زهر", "لعبة", "نرد"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("খেলৰ প\u{9be}শতি"),
            keywords: &[
                "ক\u{9cd}ৰীড\u{9bc}\u{9be}",
                "খেলৰ প\u{9be}শতি",
                "প\u{9be}শতি",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("oyun zəri"),
            keywords: &["oyun", "oyun zəri", "zər"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("ігральная косць"),
            keywords: &["азарт", "гульня", "косць", "кубік", "ігральная косць"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("зар за игра"),
            keywords: &["Зар за игра", "зар", "зар за игра", "зарове", "игра"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("খেল\u{9be}র ছক\u{9cd}ক\u{9be}"),
            keywords: &[
                "খেল\u{9be}",
                "খেল\u{9be}র ছক\u{9cd}ক\u{9be}",
                "ড\u{9be}ই",
                "প\u{9be}শ\u{9be}",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("diñs"),
            keywords: &["cʼhoari diñsoù", "diñs"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("kockica za igru"),
            keywords: &["društvene igre", "igre", "kockica", "kockica za igru"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("daus"),
            keywords: &["dau", "daus", "joc"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏁᏟᏙᏗ ᎦᎵᏬᎩ"),
            keywords: &["ᎠᏁᏟᏙᏗ ᎦᎵᏬᎩ", "ᎦᎵᏬᎩ", "ᏗᏁᏟᏙᏗ", "ᏧᎪᎳ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("hrací kostka"),
            keywords: &["hra", "hrací kostka", "kostka", "kostky"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("dis"),
            keywords: &["dis", "gêm"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("terning"),
            keywords: &["terning", "terningspil"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Spielwürfel"),
            keywords: &["Spiel", "Spielwürfel", "Würfel"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ζάρι"),
            keywords: &["ζάρι", "παιχνίδι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("game die"),
            keywords: &["dice", "die", "game"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("game dice"),
            keywords: &[""],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("dado"),
            keywords: &["dado", "juego"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["dado", "juego de azar"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("täring"),
            keywords: &["mäng", "täring"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("dadoa"),
            keywords: &["dadoa", "jokoa"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("تاس بازی"),
            keywords: &["بازی", "تاس"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("noppa"),
            keywords: &["noppa", "noppakuutio", "peli"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("dice"),
            keywords: &["dice", "die", "laro", "sugal"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("terningur"),
            keywords: &["terningar", "terningur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("dés"),
            keywords: &["dés", "jeu"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("dé"),
            keywords: &["dé", "dés", "jeu"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("dísle"),
            keywords: &["cluiche", "dísle"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("dìsinn"),
            keywords: &["dìsinn", "dìsnean", "geama"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("dado"),
            keywords: &["dado", "dados", "xogo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("રમતનો પાસો"),
            keywords: &["પાસા", "પાસાની રમત", "પાસો", "રમત", "રમતનો પાસો"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("dayis na wasa"),
            keywords: &["dayi", "dayis", "dayis na wasa", "wasa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("קוביית משחק"),
            keywords: &["מזל", "משחק", "קובייה", "קוביית משחק"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("पास\u{947}, डाइस"),
            keywords: &["ग\u{947}म", "डाइस", "डाई", "पास\u{947}", "पास\u{947}, डाइस"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("igraća kocka"),
            keywords: &["igra", "igraća kocka", "kocka"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("dobókocka"),
            keywords: &["dobókocka", "játék", "kocka"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("զառ"),
            keywords: &["զառ", "խաղ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("dadu"),
            keywords: &["dadu", "permainan"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ọnwụ egwuregwu"),
            keywords: &["egwuregwu", "mkpụrụ egwuregwu", "ọnwụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("teningur"),
            keywords: &["leikur", "spilateningur", "teningur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("dado"),
            keywords: &["dadi", "dado", "gioco", "gioco dei dadi"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("サイコロ"),
            keywords: &["ゲーム", "サイコロ", "ダイス"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("dhadhu game"),
            keywords: &["dhadhu", "game"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("კამათელი"),
            keywords: &["თამაში", "კამათელი", "კამათლები"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ойын кубигі"),
            keywords: &["кубик", "ойын", "ойын кубигі"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("terning"),
            keywords: &["terning", "terningspil"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("គ\u{17d2}រាប\u{17cb}ឡ\u{17bb}កឡាក\u{17cb}"),
            keywords: &["គ\u{17d2}រាប\u{17cb}ឡ\u{17bb}កឡាក\u{17cb}", "ល\u{17d2}បែង"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಆಟದ ಡೈ"),
            keywords: &["ಆಟ", "ಆಟದ ಡೈ", "ಡೈ", "ಡೈಸ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("주사위"),
            keywords: &["게임", "주사위"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ख\u{947}ळा गडगडो"),
            keywords: &["ख\u{947}ळ", "ख\u{947}ळा गडगडो", "गडगड\u{947}", "गडगडो"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("сөөк оюну"),
            keywords: &["оюн", "оюн кубиги", "сөөк", "сөөк оюну"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Spillwierfel"),
            keywords: &["Spill", "Spillwierfel", "Wierfel", "wierfelen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເກມລ\u{eb9}ກເຕ\u{ebb}\u{ecb}າ"),
            keywords: &[
                "ທອຍ",
                "ລ\u{eb9}ກເຕ\u{ebb}\u{ecb}າ",
                "ເກມ",
                "ເກມລ\u{eb9}ກເຕ\u{ebb}\u{ecb}າ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("kauliukas"),
            keywords: &["kauliukas", "žaidimas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("metamais kauliņš"),
            keywords: &["galda spēle", "kauliņš", "metamais kauliņš"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tapaono kēmu"),
            keywords: &["kēmu", "tapaono"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("коцка"),
            keywords: &["зар", "коцка"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഗെയിം ഡൈ"),
            keywords: &["ഗെയിം", "ഡൈ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("тоглоомон шоо"),
            keywords: &["тоглоом", "тоглоомон шоо", "шоо"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("फासा"),
            keywords: &["ग\u{947}म", "फासा"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("dadu permainan"),
            keywords: &["dadu", "dadu-dadu", "permainan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("dadi tal-logħob"),
            keywords: &["dada", "dadi", "dadi tal-logħob", "logħba"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အန\u{103a}စာတ\u{102f}\u{1036}း"),
            keywords: &["ဂ\u{102d}မ\u{103a}း", "အန\u{103a}စာတ\u{102f}\u{1036}း"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("terning"),
            keywords: &["spill", "terning", "terningkast", "terningspill"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ग\u{947}म डाइ"),
            keywords: &["ख\u{947}ल", "ग\u{947}म डाइ", "डाइ", "पासाहर\u{942}"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("dobbelsteen"),
            keywords: &["dobbelsteen", "dobbelstenen", "spel"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("terning"),
            keywords: &["spel", "terning", "terningskast", "terningspel"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଗେମ\u{b4d}\u{200d} ଡ\u{b3e}ଇ"),
            keywords: &[
                "ଖେଳ",
                "ଗେମ\u{b4d} ଡ\u{b3e}ଏ",
                "ଗେମ\u{b4d}\u{200d} ଡ\u{b3e}ଇ",
                "ଡ\u{b3e}ଇସ\u{b4d}",
                "ଡ\u{b3e}ଏ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਗ\u{a47}ਮ ਡਾਈਸ"),
            keywords: &["ਗ\u{a47}ਮ", "ਡਾਈ", "ਡਾਈਸ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ڈائی کھیڈ"),
            keywords: &["مرنا", "پانسہ", "ڈائی کھیڈ", "کھیڈ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Gem Dais"),
            keywords: &["Dais", "Gem"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kostka do gry"),
            keywords: &["gra", "kostka", "kostka do gry", "w kości"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د کمسايي لوبه"),
            keywords: &["د کمسايي لوبه", "لوبه", "ډايي", "کمسايي"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("jogo de dado"),
            keywords: &["dado", "dados", "jogo", "jogo de dado"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("dado"),
            keywords: &["dado", "jogo", "valor"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("dado"),
            keywords: &["dado", "pukllay", "wañuy"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("zar"),
            keywords: &["joc", "noroc", "zar"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-370"),
            keywords: &["E10-370"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("игральная кость"),
            keywords: &["игра", "игральная кость", "кости", "кубик", "кубики"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("utwo bakinisha biyari"),
            keywords: &["gupfa", "kibe", "umukino", "utwo bakinisha biyari"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("راند جي داڻي"),
            keywords: &["داڻو، داڻي، راند", "راند جي داڻي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ක\u{dca}\u{200d}ර\u{dd3}ඩ\u{dcf} ද\u{dcf}ද\u{dd4} කැට\u{200d}ය"),
            keywords: &[
                "ක\u{dca}\u{200d}ර\u{dd3}ඩ\u{dcf} ද\u{dcf}ද\u{dd4} කැට\u{200d}ය",
                "ක\u{dca}\u{200d}ර\u{dd3}ඩ\u{dcf}ව",
                "ද\u{dcf}ද\u{dd4}",
                "ද\u{dcf}ද\u{dd4} කැටය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("hracia kocka"),
            keywords: &["hra", "hracia kocka", "kocka", "kocky"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("igralna kocka"),
            keywords: &["igra", "igralna kocka", "kocka"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("ciyaarta dhimashada"),
            keywords: &["ciyaar", "ciyaarta dhimashada", "dhimo", "laandhuu"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("zar loje"),
            keywords: &["lojë", "zar", "zar loje", "zarë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("коцкица за игру"),
            keywords: &["игрa", "кoцкица", "коцкица за игру", "коцкице"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["коцкица за игру"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("kockica za igru"),
            keywords: &["igra", "kockica", "kockica za igru", "kockice"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["kockica za igru"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("speltärning"),
            keywords: &["spel", "speltärning", "tärning"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("dadu"),
            keywords: &["dadu", "mchezo"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பகடை விளைய\u{bbe}ட\u{bcd}டு"),
            keywords: &[
                "த\u{bbe}யம\u{bcd}",
                "த\u{bbe}யம\u{bcd} உருட\u{bcd}டுதல\u{bcd}",
                "பகடை",
                "விளைய\u{bbe}ட\u{bcd}டு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ప\u{c3e}చ\u{c3f}కలు"),
            keywords: &["ఆట", "ప\u{c3e}చ\u{c3f}కలు"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("бозии зарикҳо"),
            keywords: &["бозии зарикҳо", "бозӣ", "зарик", "зарикҳо"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ล\u{e39}กเต\u{e4b}า"),
            keywords: &["ทอยล\u{e39}กเต\u{e4b}า", "ล\u{e39}กเต\u{e4b}า"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("oýun kubigi"),
            keywords: &["oýun", "oýun kubigi", "zarik"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("taisi"),
            keywords: &["taisi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("oyun zarı"),
            keywords: &["oyun", "oyun zarı", "zar"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("شىشىخال ئويۇنى"),
            keywords: &["ئوشۇق", "ئويۇن", "شىشىخال", "شىشىخال ئويۇنى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("гральна кість"),
            keywords: &["гра", "гральна кість", "кубик"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("گیم ڈائی"),
            keywords: &["ڈائس", "کھیل", "گیم ڈائی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("shoshqol toshi"),
            keywords: &["o‘yin", "shoshqol", "shoshqol toshi", "tosh"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("trò xúc xắc"),
            keywords: &["con xúc xắc", "trò chơi", "trò xúc xắc"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("deewu lido"),
            keywords: &["dee", "deewu lido", "faatu", "po"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("idayisi lomdlalo"),
            keywords: &["idayisi", "idayisi lomdlalo", "umdlalo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ere-idaraya Ludo"),
            keywords: &["Ere-idaraya Ludo", "ayò", "eré"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("遊戲骰子"),
            keywords: &["遊戲", "遊戲骰子", "骰子"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("游戏骰子"),
            keywords: &["游戏", "游戏骰子", "骰子"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("骰子"),
            keywords: &["色子", "骰子"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("骰子"),
            keywords: &["骰子"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umdlalo wamadayisi"),
            keywords: &["idayisi", "umdlalo", "umdlalo wamadayisi"],
        },
    ],
};
#[doc = "🧩"]
pub const PUZZLE_PIECE: crate::Emoji = crate::Emoji {
    glyph: "🧩",
    codepoint: "1F9E9",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "puzzle piece",
    group: "Activities",
    subgroup: "game",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("legkaartstuk"),
            keywords: &["deel", "legkaart", "legkaartstuk", "skakeling", "wenk"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("እንቆቅልሽ"),
            keywords: &["መስቀለኛ", "ምልክት", "ቁራጭ", "እንቆቅልሽ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("أحجية الصور المقطوعة"),
            keywords: &["أحجية", "أحجية الصور المقطوعة", "تركيب", "دليل", "قطع"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some(
                "ভিন\u{9cd}ন আক\u{9c3}তিত ক\u{9be}টি থোৱ\u{9be} চিত\u{9cd}ৰৰ ট\u{9c1}ক\u{9c1}ৰ\u{9be}",
            ),
            keywords: &[
                "ইণ\u{9cd}ট\u{9be}ৰলকিং",
                "জিগশ\u{9cd}ব’",
                "প\u{9be}জল",
                "ভিন\u{9cd}ন আক\u{9c3}তিত ক\u{9be}টি থোৱ\u{9be} চিত\u{9cd}ৰৰ ট\u{9c1}ক\u{9c1}ৰ\u{9be}",
                "ৰহস\u{9cd}যৰ স\u{9c2}ত\u{9cd}ৰ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("pazl"),
            keywords: &["başsındırma", "ipucu", "parça", "pazl"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("частка пазла"),
            keywords: &["ключ", "мазаіка", "пазл", "частка", "частка пазла"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("част от пъзел"),
            keywords: &["парче", "пъзел", "редя пъзел", "следа", "част от пъзел"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("প\u{9be}জেলের ট\u{9c1}করো"),
            keywords: &[
                "ইন\u{9cd}ট\u{9be}রলকিং",
                "জিগস",
                "ট\u{9c1}করো",
                "ধ\u{9be}\u{981}ধ\u{9be}",
                "প\u{9be}জেলের ট\u{9c1}করো",
                "স\u{9c2}ত\u{9cd}র",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("miltamm"),
            keywords: &["cʼhoari", "miltamm"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("slagalica"),
            keywords: &["dio", "međusobno povezano", "puzle", "slagalica", "trag"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("peces de trencaclosques"),
            keywords: &[
                "encaixar",
                "peces de trencaclosques",
                "peça",
                "pista",
                "puzle",
                "trencaclosques",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏥᎩᏌ"),
            keywords: &["ᎠᎬᎭᎸᏓ", "ᎠᏓᏎᎮ", "ᎤᏍᏆᏂᎪᏤᎢ", "ᏛᎵᎪᎲᏍᏗᏍᎬ", "ᏥᎩᏌ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("puzzle"),
            keywords: &["dílek", "dílky", "puzzle", "skládačka"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("jig-so"),
            keywords: &["cliw", "cydgloi", "darn", "jig-so", "pos"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("brik til puslespil"),
            keywords: &[
                "brik",
                "brik til puslespil",
                "puslespil",
                "sammenhængende",
                "spor",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Puzzleteil"),
            keywords: &["Puzzle", "Puzzlestück", "Puzzleteil"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κομμάτι παζλ"),
            keywords: &["ένδειξη", "κομμάτι", "παζλ", "σύνδεσμος"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("puzzle piece"),
            keywords: &["clue", "interlocking", "jigsaw", "piece", "puzzle"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["clue", "interlocking", "jigsaw", "piece", "puzzle"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("pieza de puzle"),
            keywords: &[
                "conectar",
                "pieza",
                "pieza de puzle",
                "pista",
                "puzle",
                "rompecabezas",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("pieza de rompecabezas"),
            keywords: &[
                "conectar",
                "pieza",
                "pieza de rompecabezas",
                "pista",
                "puzle",
                "rompecabezas",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("pusletükk"),
            keywords: &["pusle", "pusletükk", "tükk", "ühendamine"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("buru-hausgarri"),
            keywords: &["arrasto", "buru-hausgarri", "lotura", "pieza"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("قطعه پازل"),
            keywords: &["جورچین", "قطعه", "پازل", "چسب", "چفت کردن"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("palapeli"),
            keywords: &[
                "arvoitus",
                "pala",
                "palapeli",
                "vihje",
                "yhteenliittynyt",
                "yhteensopiva",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("jigsaw"),
            keywords: &["clue", "jigsaw", "puzzle"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("putlispælbrot"),
            keywords: &[
                "brot",
                "petti",
                "puntur",
                "putlispæl",
                "putlispælbrot",
                "spor",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("pièce de puzzle"),
            keywords: &["assemblage", "indice", "pièce de puzzle", "puzzle"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("casse-tête"),
            keywords: &["casse-tête", "pièce"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("mír mearaí"),
            keywords: &[
                "comhghlasáilte",
                "mír mearaí",
                "míreanna mearaí",
                "nod",
                "píosa",
                "tomhas",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("mìrean-measgaichte"),
            keywords: &[
                "aisneis",
                "co-cheangailte",
                "faisneis",
                "mìrean-measgaichte",
                "pìos",
                "tuairmse",
                "tòimhseachan",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("crebacabezas"),
            keywords: &["crebacabezas", "peza", "puzzle", "quebracabezas"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પઝલના પીસ"),
            keywords: &[
                "ઇન\u{acd}ટરલૉકિ\u{a82}ગ",
                "કડી",
                "જીગ\u{acd}સૉ",
                "ટ\u{ac1}કડો",
                "પઝલ",
                "પઝલના પીસ",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("חלק בפאזל"),
            keywords: &["התאמה", "חלק בפאזל", "חתיכה מהפאזל", "פאזל", "קשר", "רמז"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("पज\u{93c}ल ग\u{947}म"),
            keywords: &[
                "इ\u{902}टरलॉकि\u{902}ग",
                "जिग\u{94d}सॉ",
                "पज\u{93c}ल",
                "पज\u{93c}ल ग\u{947}म",
                "स\u{902}क\u{947}त",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("slagalica"),
            keywords: &["dio slagalice", "komadić", "slagalica", "trag"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("kirakó"),
            keywords: &["darab", "kirakó", "nyom", "puzzle", "összekapcsolódó"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("փազլի կտոր"),
            keywords: &["գլուխկոտրուկ", "կտոր", "փազլ", "փազլի կտոր"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("keping puzzle"),
            keywords: &[
                "keping puzzle",
                "kepingan",
                "petunjuk",
                "puzzle",
                "saling terkait",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("púsl"),
            keywords: &["krækja saman", "púsl", "púsluspil", "vísbending"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("pezzo di puzzle"),
            keywords: &["pezzo di puzzle", "puzzle", "tessera del puzzle"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ジグソーパズル"),
            keywords: &["ジグソーパズル", "パズル", "ピース", "組み合わせ", "鍵"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("cuwilan teka-teki"),
            keywords: &[
                "cuwilan teka-teki",
                "jigsaw",
                "kemunci",
                "pituduh",
                "potongan",
                "teka-teki",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("პაზლი"),
            keywords: &["იდეა", "ნაჭერი", "პაზლი", "ფაზლის ნაწილი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("джигсо"),
            keywords: &["дана", "джигсо", "кілт", "пазл", "өзара әрекет"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ល\u{17d2}បែងផ\u{17d2}គ\u{17bb}\u{17c6}រ\u{17bc}ប"),
            keywords: &[
                "ង\u{17c9}ា\u{17c6}",
                "តម\u{17d2}រ\u{17bb}យ",
                "ប\u{17c6}ណែក",
                "ល\u{17d2}បែងផ\u{17d2}គ\u{17bb}\u{17c6}រ\u{17bc}ប",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಒಗಟು ತುಣುಕು"),
            keywords: &[
                "ಒಗಟು",
                "ಒಗಟು ತುಣುಕು",
                "ಜ\u{cbf}ಗ\u{ccd}\u{200c}ಸಾ",
                "ತುಂಡು",
                "ಪರಸ\u{ccd}ಪರ ಬಂಧ\u{cbf}ಸುವುದು",
                "ಸುಳ\u{cbf}ವು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("퍼즐"),
            keywords: &["조각", "조각퍼즐", "직소퍼즐", "퍼즐"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("क\u{941}वाड\u{947}\u{902} क\u{941}डको"),
            keywords: &[
                "क\u{941}डको",
                "क\u{941}वाड\u{947}\u{902}",
                "घ\u{941}सपपी",
                "जिगसॉ",
                "स\u{902}क\u{947}त",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("баш катырма"),
            keywords: &["баш катырма", "бөлүк", "жандырмак", "кураштыруу"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຈ\u{eb4}ກຊ\u{ecd}"),
            keywords: &[
                "ຈ\u{eb4}ກຊ\u{ecd}",
                "ຊ\u{eb5}\u{ec9}ນສ\u{ec8}ວນ",
                "ປ\u{eb4}ດສະໜາ",
                "ລ\u{eb1}ອກກ\u{eb1}ນ",
                "ເງ\u{eb7}\u{ec8}ອນ\u{200b}ງຳ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("dėlionė"),
            keywords: &["dalis", "dėlionė", "galvosūkis", "raktas", "susijungiantis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("attēlu mīkla"),
            keywords: &[
                "attēlu mīkla",
                "gabaliņš",
                "līme",
                "puzle",
                "puzles gabaliņš",
                "savienošana",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("сложувалка"),
            keywords: &["вклопување", "делче", "клуч", "логичка игра", "сложувалка"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ജിഗ\u{d4d}\u{200c}സൊ"),
            keywords: &[
                "ഇന\u{d4d}റർലോക\u{d4d}കിംഗ\u{d4d}",
                "കഷണം",
                "ക\u{d4d}ല\u{d42}",
                "ജിഗ\u{d4d}\u{200c}സൊ",
                "പസിൽ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("эвлүүлдэг зураг"),
            keywords: &[
                "сэжим",
                "таавар",
                "харилцан хамаарал",
                "хэсэг",
                "эвлүүлдэг зураг",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("जिग\u{94d}सॉ"),
            keywords: &[
                "इ\u{902}टरलॉकि\u{902}ग",
                "क\u{94d}ल\u{942}",
                "जिग\u{94d}सॉ",
                "पझल",
                "पीस",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kepingan suai gambar"),
            keywords: &[
                "cantuman",
                "kepingan",
                "kepingan suai gambar",
                "petunjuk",
                "suai gambar",
                "susun",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဂျစ\u{103a}စော အပ\u{102d}\u{102f}င\u{103a}းအစ"),
            keywords: &[
                "ချ\u{102d}တ\u{103a}ဆက\u{103a}",
                "ဂျစ\u{103a}စော",
                "ပဟေဠ\u{102d}",
                "သ\u{1032}လ\u{103d}န\u{103a}စ",
                "အပ\u{102d}\u{102f}င\u{103a}းအစ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("puslespillbrikke"),
            keywords: &[
                "bit",
                "brikke",
                "del",
                "pekepinn",
                "puslespill",
                "puslespillbrikke",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("पज\u{94d}जलको भाग"),
            keywords: &[
                "उत\u{94d}तरको सङ\u{94d}क\u{947}त",
                "खप\u{94d}ट\u{947}को",
                "जिगसअ",
                "ट\u{941}क\u{94d}रा",
                "पज\u{94d}जल",
                "पज\u{94d}जलको भाग",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("puzzelstukje"),
            keywords: &[
                "aanwijzing",
                "gekoppeld",
                "legpuzzel",
                "puzzel",
                "puzzelstukje",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("puslespelbrikke"),
            keywords: &[
                "bit",
                "brikke",
                "del",
                "peikepinn",
                "puslespel",
                "puslespelbrikke",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପଜଲ\u{b4d}\u{200c} ଟ\u{b41}କ\u{b41}ଡ\u{b3e}"),
            keywords: &[
                "ଇଂଟରଲକ\u{b3f}ଙ\u{b4d}ଗ",
                "ଜ\u{b3f}ଗ\u{200c}ସୱ\u{b4d}\u{200c}",
                "ଟ\u{b41}କ\u{b41}ଡ\u{b3e}",
                "ପଜଲ\u{b4d}\u{200c}",
                "ସ\u{b41}ର\u{b3e}ଗ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਜਿਗਸਾਅ"),
            keywords: &[
                "ਇ\u{a70}ਟਰਲਾਕਿ\u{a70}ਗ",
                "ਜਿਗਸਾਅ",
                "ਟ\u{a41}ਕੜਾ",
                "ਬ\u{a41}ਝਾਰਤ",
                "ਸ\u{a41}ਰਾਗ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Pọ\u{301}zul Sid"),
            keywords: &["Jígsọ", "Pọ\u{301}zul", "Sid"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("element układanki"),
            keywords: &[
                "element",
                "element układanki",
                "puzzle",
                "łamigłówka",
                "łączenie",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د معما ټکړه"),
            keywords: &[
                "اشاره",
                "د معما ټکړه",
                "معما",
                "يوځای کول",
                "ټکړه",
                "ګرده اره",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("quebra-cabeça"),
            keywords: &["dica", "encaixe", "peça", "quebra-cabeça"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("peça de puzzle"),
            keywords: &["dica", "encaixe", "peça", "peça de puzzle", "quebra-cabeça"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("piesă de puzzle"),
            keywords: &[
                "indiciu",
                "joc de puzzle",
                "mozaic",
                "piesă",
                "piesă de puzzle",
                "puzzle",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E11-051"),
            keywords: &["E11-051"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("пазл"),
            keywords: &["головоломка", "кусочек", "кусочек пазла", "мозаика", "пазл"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("پزل پيس"),
            keywords: &["انٽرلاڪنگ", "جگسا", "پزل", "پيس", "ڪلو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ජ\u{dd2}ග\u{dca}සෝ"),
            keywords: &[
                "අග\u{dd4}ළ\u{dd4} දැම\u{dd3}ම",
                "ඉඟ\u{dd2}ය",
                "කෑල\u{dca}ලක\u{dca}",
                "ජ\u{dd2}ග\u{dca}සෝ",
                "ප\u{dca}\u{200d}රහේල\u{dd2}ක\u{dcf}ව",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("skladačka"),
            keywords: &["dielik", "dieliky", "puzzle", "skladačka"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("delček sestavljanke"),
            keywords: &[
                "delček",
                "delček sestavljanke",
                "namig",
                "prileganje",
                "sestavljanka",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("gabal xujo"),
            keywords: &["caqli", "gabal", "is-xerid", "sawiro", "xujo"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("lojë me bashkim pjesësh figure"),
            keywords: &[
                "e dhënë",
                "enigmë",
                "lojë me bashkim pjesësh figure",
                "pjesë figure",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("део слагалице"),
            keywords: &["део", "део слагалице", "слагалица", "уклапање"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("дио слагалице"),
            keywords: &["дио слагалице"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("deo slagalice"),
            keywords: &["deo", "deo slagalice", "slagalica", "uklapanje"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("dio slagalice"),
            keywords: &["dio slagalice"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("pusselbit"),
            keywords: &["bit", "ledtråd", "pussel", "pusselbit", "sammanfoga"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mchezofumbo"),
            keywords: &["dokezo", "fumbo", "fungamana", "kipande", "mchezofumbo"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("kipande cha mchezo wa mafumbo"),
            keywords: &[
                "dokezo",
                "fumbo",
                "fungamana",
                "kipande",
                "kipande cha mchezo wa mafumbo",
                "mchezofumbo",
            ],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஜிக\u{bcd}ஸ\u{bbe}"),
            keywords: &[
                "சேர\u{bcd}த\u{bcd}தல\u{bcd}",
                "ஜிக\u{bcd}ஸ\u{bbe}",
                "துண\u{bcd}டு",
                "துப\u{bcd}பு",
                "புதிர\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("పజ\u{c3f}ల\u{c4d} ముక\u{c4d}క"),
            keywords: &[
                "ఇంటర\u{c4d}\u{200c}ల\u{c3e}క\u{c3f}ంగ\u{c4d}",
                "క\u{c4d}లూ",
                "జ\u{c3f}గ\u{c4d}స\u{c3e}",
                "పజ\u{c3f}ల\u{c4d}",
                "ముక\u{c4d}క",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("จ\u{e34}\u{e4a}กซอว\u{e4c}"),
            keywords: &[
                "คำใบ\u{e49}",
                "จ\u{e34}\u{e4a}กซอว\u{e4c}",
                "ช\u{e34}\u{e49}นส\u{e48}วน",
                "ต\u{e31}วต\u{e48}อ",
                "ท\u{e31}บซ\u{e49}อน",
                "ปร\u{e34}ศนา",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("tapmaça bölegi"),
            keywords: &[
                "biri-birine birleşýän",
                "bölek",
                "düzülýän tapmaça",
                "tapmaça",
                "tapmaça bölegi",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("laʻilekileki"),
            keywords: &["laʻilekileki"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yapboz parçası"),
            keywords: &[
                "ipucu",
                "kenetleme",
                "parça",
                "puzzle",
                "yapboz",
                "yapboz parçası",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("елемент пазла"),
            keywords: &[
                "головоломка",
                "елемент пазла",
                "пазл",
                "підказка",
                "частина",
                "шматок",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ج\u{650}گسا"),
            keywords: &["اشارہ", "باہم مربوط", "ج\u{650}گسا", "ٹکڑا", "پزل"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("pazl qismi"),
            keywords: &[
                "boshqotirma",
                "mantiq",
                "mozaika",
                "pazl",
                "pazl qismi",
                "qism",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("ghép hình"),
            keywords: &[
                "ghép hình",
                "ghép vào nhau",
                "mảnh",
                "trò ghép hình",
                "đầu mối",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("砌圖"),
            keywords: &["塊", "砌圖", "線索", "聯鎖"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("砌图"),
            keywords: &["块", "砌图", "线索", "联锁"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("拼图"),
            keywords: &["图片", "拼图", "智力游戏", "线索", "联锁"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("拼圖"),
            keywords: &["拼", "拼圖", "片", "線索", "謎題"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("izingcezu zephazili"),
            keywords: &[
                "i-jigsaw",
                "icebo",
                "indida",
                "izingcezu",
                "izingcezu zephazili",
                "ucezu",
                "ukukhiya ngaphakathi",
            ],
        },
    ],
};
#[doc = "🧸"]
pub const TEDDY_BEAR: crate::Emoji = crate::Emoji {
    glyph: "🧸",
    codepoint: "1F9F8",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "teddy bear",
    group: "Activities",
    subgroup: "game",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("teddiebeer"),
            keywords: &[
                "opgestop",
                "sag",
                "sagte speelding",
                "speelding",
                "teddiebeer",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ቴዲ ቢር"),
            keywords: &["መጫወቻ", "ቴዲ ቢር", "አሻንጉሊት", "የተነፋ", "የተጠቀጠቀ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("لعبة محشوة بشكل دب"),
            keywords: &["دبدوب", "دمية", "لعبة", "لعبة محشوة بشكل دب", "محشوة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("টেডী বিয\u{9bc}েৰ"),
            keywords: &[
                "কোমল বস\u{9cd}ত\u{9cd}ৰ",
                "খেল\u{9be} বস\u{9cd}ত\u{9c1}",
                "টেডী বিয\u{9bc}েৰ",
                "প\u{9c1}তল\u{9be}",
                "ষ\u{9cd}ট\u{9be}ফ কৰ\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("plüş ayı"),
            keywords: &["oyuncaq", "plüş", "plüş ayı", "yumşaq"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("плюшавы мядзведзь"),
            keywords: &["забава", "мяккі", "плюш", "плюшавы мядзведзь", "цацка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("плюшено мече"),
            keywords: &["играчка", "плюшена играчка", "плюшено мече"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("টেডি বিয\u{9bc}\u{9be}র"),
            keywords: &[
                "খেলন\u{9be}",
                "খেল\u{9be}র জিনিস",
                "খেল\u{9be}র পণ\u{9cd}য",
                "টেডি বিয\u{9bc}\u{9be}র",
                "প\u{9cd}ল\u{9be}শ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("arzh-feur"),
            keywords: &["arzh-feur", "cʼhoari", "cʼhoariell"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("medo"),
            keywords: &["igračka", "medo", "plišana"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("os de peluix"),
            keywords: &["joc", "joguina", "os de peluix", "pelfa", "peluix"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏖᏗ ᏲᎾ"),
            keywords: &["ᎤᏪᎾᎢ", "ᎦᎸᏛᎢ", "ᏖᏗ ᏲᎾ", "ᏗᏂᏲᎵ ᏧᎾᏁᎸᏙᏗ", "ᏧᏓᎴᏅᏓ ᏗᏁᎸᏙᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("medvídek"),
            keywords: &["hračka", "medvídek", "plyšový", "plyšák"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("tedi bêr"),
            keywords: &["moethus", "tedi bêr", "tegan", "wedi’i stwffio"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("bamse"),
            keywords: &["bamse", "bjørn", "legetøj", "plys"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Teddybär"),
            keywords: &[
                "Kuscheltier",
                "Plüschteddy",
                "Plüschtier",
                "Spielzeug",
                "Teddybär",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("αρκουδάκι"),
            keywords: &["αρκουδάκι", "κουκλάκι", "λούτρινο", "παιχνίδι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("teddy bear"),
            keywords: &["plaything", "plush", "stuffed", "teddy bear", "toy"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("osito de peluche"),
            keywords: &["juguete", "osito de peluche", "oso", "peluche"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("oso de peluche"),
            keywords: &["felpa", "juguete", "oso", "oso de peluche", "relleno"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("oso de peluche"),
            keywords: &["oso de peluche"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("mängukaru"),
            keywords: &["lelu", "mänguasi", "mängukaru", "pehme", "plüüs"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("hartzatxo"),
            keywords: &["hartzatxo", "jostailu", "peluxe"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("تدی خرسه"),
            keywords: &["اسباب\u{200c}بازی", "بازیچه", "تدی خرسه", "مخملی", "نرم"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("nalle"),
            keywords: &["lelu", "nalle", "pehmolelu", "teddykarhu", "täytetty"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("teddy bear"),
            keywords: &["laruan", "malambot", "stuffed toy", "teddy bear"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("bamsa"),
            keywords: &["bamsa", "leikatoy", "spælitoy"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("ours en peluche"),
            keywords: &["jeu", "jouet", "ours en peluche", "peluche"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["jeu", "jouet", "ours en peluche", "peluche", "toutou"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("béirín"),
            keywords: &["bréagán", "béirín", "pluis", "rud imeartha", "stuáilte"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("teadaidh"),
            keywords: &["bog", "dèideag", "dèideag bhog", "teadaidh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("osiño"),
            keywords: &["bebé", "osiño", "oso", "peluche", "xoguete"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ટ\u{ac7}ડી બિઅર"),
            keywords: &[
                "ટ\u{ac7}ડી બિઅર",
                "ભર\u{ac7}લ\u{ac1}\u{a82}",
                "રમકડ\u{ac1}\u{a82}",
                "સ\u{ac1}\u{a82}વાળ\u{ac1}\u{a82}",
                "હાથ રમકડ\u{ac1}\u{a82}",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("דובי"),
            keywords: &["בובה", "דובי", "ילדים", "צעצוע"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ट\u{947}डी ब\u{947}अर"),
            keywords: &[
                "खिलौना",
                "ट\u{947}डी ब\u{947}अर",
                "ट\u{947}डीबियर",
                "टॉय",
                "भव\u{94d}य",
                "स\u{94d}टफ\u{93c}\u{94d}ड",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("medvjedić"),
            keywords: &["igračka", "medvjedić", "plišanac", "plišani medvjedić"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("plüssmaci"),
            keywords: &["játszótárs", "játék", "plüss", "plüssmaci", "tömött"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("փափուկ արջուկ"),
            keywords: &["խաղալիք", "փափուկ", "փափուկ արջուկ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("boneka beruang"),
            keywords: &["boneka", "boneka beruang", "mainan"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("bangsi"),
            keywords: &["bangsi", "dót", "leikfang", "tuskudýr"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("orsetto"),
            keywords: &["giocattolo", "orsetto", "peluche"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("テディベア"),
            keywords: &["おもちゃ", "くま", "ぬいぐるみ", "テディベア", "玩具"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("beruang teddy"),
            keywords: &[
                "alat dolanan",
                "beruang teddy",
                "dijejeli",
                "dolanan",
                "mewah",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("დათუნია"),
            keywords: &["დათუნია", "სათამაშო", "ხავერდის თოჯინა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қыжым қонжық"),
            keywords: &["ойыншық", "толтырылған", "қыжым", "қыжым қонжық"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ត\u{17bb}ក\u{17d2}កតាខ\u{17d2}លាឃ\u{17d2}ម\u{17bb}\u{17c6}"),
            keywords: &[
                "ញាត\u{17cb}ណែន",
                "ត\u{17bb}ក\u{17d2}កតាខ\u{17d2}លាឃ\u{17d2}ម\u{17bb}\u{17c6}",
                "ប\u{17d2}រដាប\u{17cb}ក\u{17d2}មេងលេង",
                "របស\u{17cb}លេង",
                "សរសៃទន\u{17cb}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಟ\u{cc6}ಡ\u{ccd}ಡ\u{cbf} ಬೇರ\u{ccd}"),
            keywords: &[
                "ಆಟದ ವಸ\u{ccd}ತು",
                "ಆಟ\u{cbf}ಕ\u{cc6}",
                "ಟ\u{cc6}ಡ\u{ccd}ಡ\u{cbf} ಬೇರ\u{ccd}",
                "ಬ\u{cc6}ಲ\u{cc6}ಬಾಳುವ",
                "ಸೇರ\u{ccd}ಪಡ\u{cc6}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("테디 베어"),
            keywords: &["곰인형", "솜인형", "장난감", "테디 베어"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ट\u{947}डी बियर"),
            keywords: &[
                "ख\u{947}ळणी\u{902}",
                "ख\u{947}ळण\u{947}\u{902}",
                "ट\u{947}डी बियर",
                "प\u{94d}लश",
                "भरिल\u{94d}ल\u{947}\u{902}",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("оюнчук мамалак"),
            keywords: &["жумшак", "оюн", "оюнчук", "оюнчук мамалак", "толтурулган"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໝ\u{eb5}ເທດດ\u{eb5}"),
            keywords: &[
                "ຕ\u{eb8}ກ\u{200b}ກະ\u{200b}ຕາ",
                "ເຄ\u{eb7}\u{ec8}ອງຕ\u{ec8}າງໆ",
                "ເຄ\u{eb7}\u{ec8}ອງຫ\u{ebc}\u{eb5}\u{ec9}ນ",
                "ໝ\u{eb5}ເທດດ\u{eb5}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("meškiukas"),
            keywords: &["kimštas", "meškiukas", "pliušas", "žaislas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("lāčuks"),
            keywords: &["lāčuks", "manta", "pildīts", "plīšs", "rotaļlieta"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("плишано мече"),
            keywords: &["играчка", "плиш", "плишано мече", "полнета"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ടെഡി ബെയർ"),
            keywords: &[
                "കളിക\u{d4d}ക\u{d3e}ന\u{d41}ള\u{d4d}ള വസ\u{d4d}ത\u{d41}",
                "കളിപ\u{d4d}പ\u{d3e}ട\u{d4d}ടം",
                "ടെഡി ബെയർ",
                "മ\u{d43}ദ\u{d41}വ\u{d3e}യത\u{d41}ണി",
                "സ\u{d4d}റ\u{d4d}റഫ\u{d4d} ചെയ\u{d4d}തത\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("тэдди бамбарууш"),
            keywords: &["зугаа", "тоглоом", "тэдди бамбарууш", "хилэн", "чихмэл"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ट\u{947}डी ब\u{947}अर"),
            keywords: &[
                "ख\u{947}ळण\u{947}",
                "ट\u{947}डी ब\u{947}अर",
                "प\u{94d}लश",
                "प\u{94d}ल\u{947}थि\u{902}ग",
                "स\u{94d}टफ",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("beruang teddy"),
            keywords: &[
                "barang mainan",
                "beruang teddy",
                "mainan",
                "plusy",
                "sumbat",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ကစားစရာ ဝက\u{103a}ဝ\u{1036}ရ\u{102f}ပ\u{103a}"),
            keywords: &[
                "ကစားစရာ",
                "ကစားစရာ ဝက\u{103a}ဝ\u{1036}ရ\u{102f}ပ\u{103a}",
                "ရ\u{102f}ပ\u{103a}လ\u{102f}\u{1036}းသ\u{103d}င\u{103a}း",
                "အမ\u{103d}ေးပ\u{103d}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("teddybjørn"),
            keywords: &["bamse", "leke", "teddybjørn"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("बच\u{94d}चाको भाल\u{941} ख\u{947}लौना"),
            keywords: &[
                "ख\u{947}लौना",
                "ख\u{947}ल\u{94d}न\u{947} क\u{941}रा",
                "बच\u{94d}चाको भाल\u{941} ख\u{947}लौना",
                "भित\u{94d}रबाट कपडा कोचिएको",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("teddybeer"),
            keywords: &["knuffel", "pluche", "speelgoed", "speeltje", "teddybeer"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("teddybjørn"),
            keywords: &["bamse", "leike", "teddybjørn"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଟେଡ\u{b3f} ବ\u{b3f}ୟର"),
            keywords: &[
                "ଖେଳଣ\u{b3e}",
                "ଟେଡ\u{b3f} ବ\u{b3f}ୟର",
                "ପ\u{b4d}ଲଶ",
                "ପ\u{b4d}ଲେଥ\u{b3f}ଙ\u{b4d}ଗ",
                "ଷ\u{b4d}ଟଫଡ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਖਿਡ\u{a4c}ਣਾ ਭਾਲ\u{a42}"),
            keywords: &[
                "ਖਿਡ\u{a4c}ਣਾ",
                "ਖਿਡ\u{a4c}ਣਾ ਭਾਲ\u{a42}",
                "ਖ\u{a47}ਡਣ ਵਾਲੀ ਚੀਜ\u{a3c}",
                "ਭਰਵਾ\u{a02}",
                "ਸ\u{a3c}ਾਨਦਾਰ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Tẹ\u{301}dí Bẹ\u{301}a"),
            keywords: &[
                "Bẹ\u{301}a",
                "Ful",
                "Pleplétin",
                "Sọft",
                "Tẹ\u{301}di",
                "Tẹ\u{301}dí Bẹ\u{301}a",
                "Tọi",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("miś pluszowy"),
            keywords: &["miś pluszowy", "pluszak", "pluszowa", "wypchana", "zabawka"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ايږ"),
            keywords: &["ايږ", "د لوبو څيز", "لوبتکه", "نانځکه", "ډک شوي"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("ursinho de pelúcia"),
            keywords: &["brinquedo", "enchimento", "pelúcia", "ursinho de pelúcia"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("ursinho de peluche"),
            keywords: &["brinquedo", "enchimento", "peluche", "ursinho de peluche"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("ursuleț de pluș"),
            keywords: &["jucărie", "pluș", "ursuleț", "ursuleț de pluș"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E11-066"),
            keywords: &["E11-066"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("плюшевый мишка"),
            keywords: &[
                "игрушка",
                "мишка",
                "мягкая игрушка",
                "плюшевая игрушка",
                "плюшевый мишка",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ٽيڊي بيئر"),
            keywords: &["رانديڪو", "سفرڊ", "ٽيڊي بيئر", "پلش", "پلي ٿنگ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("සෙල\u{dca}ලම\u{dca} වලස\u{dcf}"),
            keywords: &[
                "ක\u{dca}\u{200d}ර\u{dd3}ඩ\u{dcf} භ\u{dcf}ණ\u{dca}ඩය",
                "ප\u{dca}ලෑෂ\u{dca}",
                "ප\u{dd2}රව\u{dd6}",
                "සෙල\u{dca}ලම\u{dca} බඩ\u{dd4}",
                "සෙල\u{dca}ලම\u{dca} වලස\u{dcf}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("medvedík"),
            keywords: &["hračka", "medvedík", "plyšiak", "plyšový"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("medvedek"),
            keywords: &["igrača", "lutka", "medvedek", "plišasta", "polnjena"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("boombalo"),
            keywords: &["boombalo", "khudrad", "ku ciyaarid", "la habeeyay"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("arush pelushi"),
            keywords: &["arush", "arush pelushi", "lodër", "pelush"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("медведић"),
            keywords: &["играчка", "медведић", "плишана", "пуњена"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("медвједић"),
            keywords: &["медвједић"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("medvedić"),
            keywords: &["igračka", "medvedić", "plišana", "punjena"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("medvjedić"),
            keywords: &["medvjedić"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("nallebjörn"),
            keywords: &["gosedjur", "leksak", "mjukdjur", "nallebjörn"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mwanaserere wa dubu"),
            keywords: &[
                "dubu",
                "kidude cha kuchezea",
                "kikorokoro",
                "mwanaserere",
                "mwanaserere wa dubu",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("டெடிபியர\u{bcd}"),
            keywords: &[
                "டெடிபியர\u{bcd}",
                "பஞ\u{bcd}சு",
                "பட\u{bcd}டு",
                "பொம\u{bcd}மை",
                "விளைய\u{bbe}ட\u{bcd}டுப\u{bcd}பொருள\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ట\u{c46}డ\u{c4d}డ\u{c40} బ\u{c47}ర\u{c4d}"),
            keywords: &[
                "ఆటవస\u{c4d}తువు",
                "కూర\u{c4d}చ\u{c3f}నద\u{c3f}",
                "ట\u{c46}డ\u{c4d}డ\u{c40} బ\u{c47}ర\u{c4d}",
                "ప\u{c4d}లష\u{c4d}",
                "బ\u{c4a}మ\u{c4d}మ",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ต\u{e38}\u{e4a}กตาหม\u{e35}"),
            keywords: &[
                "ของเล\u{e48}น",
                "ต\u{e38}\u{e4a}กตาหม\u{e35}",
                "ผ\u{e49}ากำมะหย\u{e35}\u{e48}",
                "ย\u{e31}ดน\u{e38}\u{e48}น",
                "เคร\u{e37}\u{e48}องเล\u{e48}น",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("oýunjak aýy"),
            keywords: &["doldurylan", "mahmal", "oýunjak", "oýunjak aýy"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("pea tamapua"),
            keywords: &["pea tamapua"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("oyuncak ayı"),
            keywords: &["dolgu", "oyun", "oyuncak", "oyuncak ayı", "pelüş"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("ведмедик"),
            keywords: &["ведмедик", "м’яка іграшка", "плюшева іграшка", "іграшка"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کھلونا بھالو"),
            keywords: &[
                "روئی سے بھرا",
                "مخملی",
                "کھلونا",
                "کھلونا بھالو",
                "کھیلنے کی چیز",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("baxmal ayiqcha"),
            keywords: &[
                "ayiqcha",
                "baxmal ayiqcha",
                "baxmal o‘yinchoq",
                "duxoba",
                "o‘yinchoq",
                "yumshoq o‘yinchoq",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("gấu bông"),
            keywords: &["gấu bông", "nhồi bông", "vải lông", "đồ chơi"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("熊仔"),
            keywords: &["公仔", "毛絨", "熊仔", "玩具"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("熊仔"),
            keywords: &["公仔", "毛绒", "熊仔", "玩具"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("泰迪熊"),
            keywords: &["填充", "毛绒玩具", "泰迪熊", "玩偶", "玩具"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("泰迪熊"),
            keywords: &["填充", "娃娃", "毛茸茸", "泰迪熊", "玩具"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["填充", "毛公仔", "泰迪熊", "玩具"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("u-teddy bear"),
            keywords: &["u-teddy bear"],
        },
    ],
};
#[doc = "🪅"]
pub const PINATA: crate::Emoji = crate::Emoji {
    glyph: "🪅",
    codepoint: "1FA85",
    status: crate::Status::FullyQualified,
    introduction_version: 13f32,
    name: "piñata",
    group: "Activities",
    subgroup: "game",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("piñata"),
            keywords: &[
                "Meksiko",
                "partytjie",
                "piñata",
                "slaan",
                "verjaarsdag",
                "viering",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ፒናታ"),
            keywords: &["ፒናታ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("بنياتا"),
            keywords: &["احتفال", "بنياتا", "حفلة", "حلوى", "معل\u{651}قة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("পিন\u{9be}ত\u{9be}"),
            keywords: &["উদয\u{9be}পন", "প\u{9be}ৰ\u{9cd}টী", "পিন\u{9be}ত\u{9be}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("pinyata"),
            keywords: &["bayram", "pinyata", "şənlik"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("піньята"),
            keywords: &["вечарына", "гулянка", "піньята", "святкаванне"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("пинята"),
            keywords: &["парти", "пинята", "празнуване"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("পিয\u{9bc}\u{9be}\u{981}ত\u{9be}"),
            keywords: &[
                "অন\u{9c1}ষ\u{9cd}ঠ\u{9be}ন",
                "প\u{9be}র\u{9cd}টি",
                "পিয\u{9bc}\u{9be}\u{981}ত\u{9be}",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("piñata"),
            keywords: &["fest", "gouel", "piñata"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("pinjata"),
            keywords: &["party", "pinjata", "proslava", "slavlje"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("pinyata"),
            keywords: &["celebració", "festa", "pinyata"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏂᏍᏆᏂ ᏓᏂᏥᎳᏓᏗᏍᎬ"),
            keywords: &["ᎠᎵᏍᏆᎵᏍᎩ", "ᎠᎾᎵᎮᎵᏍᏗᏍᎬᎢ", "ᎠᏂᏍᏆᏂ ᏓᏂᏥᎳᏓᏗᏍᎬ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("piñata"),
            keywords: &["oslava", "party", "piñata", "piňata"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("piñata"),
            keywords: &["dathliad", "parti", "piñata"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("piñata"),
            keywords: &["fejring", "fest", "piñata"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Piñata"),
            keywords: &["Feier", "Party", "Piñata"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πινιάτα"),
            keywords: &["γιορτή", "πάρτι", "πινιάτα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("piñata"),
            keywords: &["celebration", "party", "piñata"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("piñata"),
            keywords: &["caballito", "celebración", "fiesta", "piñata"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("piñata"),
            keywords: &["peomäng", "pidu", "piñata"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("gozo-eltze"),
            keywords: &["festa", "gozo-eltze", "ospakizun"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پینیاتا"),
            keywords: &["جشن", "مهمانی", "پینیاتا"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("piñata"),
            keywords: &["juhlat", "juhlinta", "piñata"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("piñata"),
            keywords: &["pagdiriwang", "party", "piñata", "selebrasyon"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("pinata"),
            keywords: &["pinata", "piñata", "veitsla"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("piñata"),
            keywords: &["bonbons", "confiseries", "fête", "piñata"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("piñata"),
            keywords: &["fête", "piñata"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("piñata"),
            keywords: &["ceiliúradh", "cóisir", "piñata"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("piñata"),
            keywords: &["comharrachadh", "cèilidh", "piñata", "pàrtaidh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("piñata"),
            keywords: &["aniversario", "celebración", "festa", "piñata"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પિનાટા"),
            keywords: &["ઉજવણી", "પાર\u{acd}ટી", "પિનાટા"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פיניאטה"),
            keywords: &["חגיגה", "מסיבה", "פיניאטה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("पिन\u{94d}याटा"),
            keywords: &["उत\u{94d}सव", "पार\u{94d}टी", "पिन\u{94d}याटा"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("pinjata"),
            keywords: &["pinjata", "slavlje", "zabava"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("pinyáta"),
            keywords: &["buli", "pinyáta", "ünnepség"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("պինյատա"),
            keywords: &["խնջույք", "պինյատա", "տոնակատարություն", "քեֆ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("pinata"),
            keywords: &["perayaan", "pesta", "pinata"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("piñata"),
            keywords: &["fögnuður", "piñata", "slá köttinn úr tunnunni"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("pentolaccia"),
            keywords: &["divertimento", "festa", "pentolaccia"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ピニャータ"),
            keywords: &["お祝い", "パーティー", "ピニャータ", "人形", "誕生日"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("pinata"),
            keywords: &["pinata", "pista", "prayaan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("პინიატა"),
            keywords: &[
                "დაბადების დღე",
                "იუბილე",
                "პინიატა",
                "ფართი",
                "ქეიფი",
                "წვეულება",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("пиньята"),
            keywords: &["кеш", "пиньята", "тойлау"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ភ\u{17b8}ញ\u{17c9}ាតា"),
            keywords: &[
                "ការប\u{17d2}រារព\u{17d2}ធព\u{17b7}ធ\u{17b8}",
                "ព\u{17b7}ធ\u{17b8}ជប\u{17cb}លៀង",
                "ភ\u{17b8}ញ\u{17c9}ាតា",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪ\u{cbf}ನಾಟ"),
            keywords: &["ಪಾರ\u{ccd}ಟ\u{cbf}", "ಪ\u{cbf}ನಾಟ", "ಸಂಭ\u{ccd}ರಮ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("피냐타"),
            keywords: &["축하", "파티", "피냐타"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("पिनाटा"),
            keywords: &["पार\u{94d}टी", "पिनाटा", "स\u{941}वाळो"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("пиньята"),
            keywords: &["пиньята"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ພ\u{eb4}ນາຕາ"),
            keywords: &["ການສະຫ\u{ebc}ອງ", "ປາຕ\u{eb5}\u{ec9}", "ພ\u{eb4}ນາຕາ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("pinjata"),
            keywords: &["pinjata", "vakarėlis", "šventė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("pinjata"),
            keywords: &["ballīte", "pinjata", "svinības"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("пињата"),
            keywords: &["забава", "пињата", "прослава"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പിന\u{d3e}റ\u{d4d}റ"),
            keywords: &["ആഘോഷം", "പ\u{d3e}ർട\u{d4d}ടി", "പിന\u{d3e}റ\u{d4d}റ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("пината"),
            keywords: &["пината", "тэмдэглэх", "үдэшлэг"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("पिनाता"),
            keywords: &["उत\u{94d}सव", "पार\u{94d}टी", "पिनाता"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("pinata"),
            keywords: &["parti", "perayaan", "pinata"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပင\u{103a}ညာဒါ"),
            keywords: &[
                "ပင\u{103a}ညာဒါ",
                "ပါတ\u{102e}",
                "အောင\u{103a}ပ\u{103d}\u{1032}ခ\u{1036}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("piñata"),
            keywords: &["feiring", "fest", "piñata"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("पिन\u{94d}याडा"),
            keywords: &[
                "उत\u{94d}सव मनाउन\u{947} कार\u{94d}य",
                "पिन\u{94d}याडा",
                "भोज",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("piñata"),
            keywords: &["feest", "piñata", "viering"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("piñata"),
            keywords: &["feiring", "fest", "piñata"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପ\u{b3f}ନ\u{b3e}ଟ\u{b3e}"),
            keywords: &[
                "ଉତ\u{b4d}ସବ",
                "ପ\u{b3e}ର\u{b4d}ଟ\u{b3f}",
                "ପ\u{b3f}ନ\u{b3e}ଟ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪਿਨਯਾਟਾ"),
            keywords: &["ਜਸ\u{a3c}ਨ", "ਪਾਰਟੀ", "ਪਿਨਯਾਟਾ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Pinyáta"),
            keywords: &["Patí", "Pinyáta", "Sẹlibréshọn"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("piniata"),
            keywords: &["impreza", "piniata", "świętowanie"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("پناتا"),
            keywords: &["لمانځنه", "پارټي", "پناتا"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("pinhata"),
            keywords: &["comemoração", "festa", "pinhata"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("piñata"),
            keywords: &["petrecere", "piñata", "sărbătorire"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E13-052"),
            keywords: &["E13-052"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("пиньята"),
            keywords: &["вечеринка", "пиньята", "праздник"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("piñata"),
            keywords: &["piñata", "جشن", "پارٽي", "پناٽا"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ප\u{dd2}න\u{dcf}ට"),
            keywords: &["ප\u{dd2}න\u{dcf}ට", "ස\u{dcf}දය", "සැමර\u{dd4}ම"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("piñata"),
            keywords: &["oslava", "piñata", "párty", "večierok"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("pinjata"),
            keywords: &["pinjata", "praznovanje", "zabava"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("boombalaha isbaanishka"),
            keywords: &["boombalaha isbaanishka", "dabaabdag", "xaflada"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("pinjata"),
            keywords: &["festim", "festë", "pinjata"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("пињата"),
            keywords: &["журка", "пињата", "прослава"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("pinjata"),
            keywords: &["pinjata", "proslava", "žurka"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("piñata"),
            keywords: &["fest", "kalas", "piñata"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("pinata"),
            keywords: &["dhifa", "pinata", "sherehe"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பின\u{bbe}ட\u{bcd}ட\u{bbe}"),
            keywords: &[
                "கொண\u{bcd}ட\u{bbe}ட\u{bcd}டம\u{bcd}",
                "ப\u{bbe}ர\u{bcd}ட\u{bcd}டி",
                "பின\u{bbe}ட\u{bcd}ட\u{bbe}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("piñata"),
            keywords: &["piñata", "ప\u{c3e}ర\u{c4d}ట\u{c40}", "సంబరం"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ป\u{e34}ญญาตา"),
            keywords: &[
                "การเฉล\u{e34}มฉลอง",
                "ปาร\u{e4c}ต\u{e35}\u{e49}",
                "ป\u{e34}ญญาตา",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("pinýata"),
            keywords: &["bellemek", "pinýata", "şagalaň"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tamapua lole"),
            keywords: &["tamapua lole"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("pinyata"),
            keywords: &["kutlama", "parti", "pinyata"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("піньята"),
            keywords: &["вечірка", "піньята", "свято"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("پناٹا"),
            keywords: &["تقریب", "پارٹی", "پناٹا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("pinyata"),
            keywords: &["bazm", "kecha", "nishonlash", "pinyata"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("piñata"),
            keywords: &["buổi tiệc", "lễ kỷ niệm", "piñata"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("皮納塔"),
            keywords: &["慶祝", "派對", "皮納塔"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("皮纳塔"),
            keywords: &["庆祝", "派对", "皮纳塔"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("彩罐"),
            keywords: &["庆祝", "彩罐", "聚会"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("皮納塔"),
            keywords: &["慶祝", "派對", "皮納塔"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("i-piñata"),
            keywords: &["i-piñata"],
        },
    ],
};
#[doc = "🪆"]
pub const NESTING_DOLLS: crate::Emoji = crate::Emoji {
    glyph: "🪆",
    codepoint: "1FA86",
    status: crate::Status::FullyQualified,
    introduction_version: 13f32,
    name: "nesting dolls",
    group: "Activities",
    subgroup: "game",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("ineenpassende poppe"),
            keywords: &[
                "Rusland",
                "ineenpassende",
                "ineenpassende poppe",
                "pas ineen",
                "pop",
                "poppies",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የመረብ አሻንጉሊቶች"),
            keywords: &["የመረብ አሻንጉሊቶች"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("دمية روسية"),
            keywords: &["دمية", "دمية روسية", "روسيا", "ماتريوشكا"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("নেষ\u{9cd}টিং প\u{9c1}তল\u{9be}"),
            keywords: &[
                "নেষ\u{9cd}টিং",
                "প\u{9c1}তল\u{9be}",
                "ৰ\u{9be}ছিয\u{9bc}\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("matryoşkalar"),
            keywords: &["Rusiya", "gəlincik", "matryoşkalar", "yuva"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("матрошка"),
            keywords: &["Расія", "лялька", "матрошка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("матрьошки"),
            keywords: &["Русия", "една в друга", "кукла", "матрьошки"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("নেস\u{9cd}টিং ডল"),
            keywords: &["ডল", "নেস\u{9cd}টিং", "র\u{9be}শিয\u{9bc}\u{9be}"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("matriochka"),
            keywords: &["matriochka", "rusian"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("babuške"),
            keywords: &["babuška", "babuške", "lutka", "rusija"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("nines russes"),
            keywords: &["matrioixca", "nina", "nines russes", "russa"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏕᎧᏁᏍᏓᏝᎲᎢ ᏗᏁᏟᏗ"),
            keywords: &["ᎠᏁᏟᏗ", "ᎧᏁᏍᏓᏝᎲᎢ", "ᏕᎧᏁᏍᏓᏝᎲᎢ ᏗᏁᏟᏗ", "ᏲᏅᎯ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("matrjoška"),
            keywords: &["babuška", "matrjoška", "panenka", "rusko", "ruská"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("doliau sy’n nythu"),
            keywords: &["dol", "doliau sy’n nythu", "nythu", "rwsia"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("russiske dukker"),
            keywords: &[
                "babusjka",
                "dukke",
                "matrjosjka",
                "russisk",
                "russiske dukker",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Matroschka"),
            keywords: &["Matrioschka", "Matroschka", "Puppe", "Russland"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κούκλες μπάμπουσκα"),
            keywords: &["κούκλα", "κούκλες μπάμπουσκα", "μπάμπουσκα", "ρωσία"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("nesting dolls"),
            keywords: &["doll", "nesting", "nesting dolls", "russia"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("Russian dolls"),
            keywords: &[
                "Russian dolls",
                "babushka",
                "doll",
                "matryoshka",
                "nesting dolls",
                "russia",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("Russian dolls"),
            keywords: &[
                "Russian dolls",
                "babushka",
                "doll",
                "matryoshka",
                "nesting dolls",
                "russia",
            ],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("muñeca rusa"),
            keywords: &["babushka", "mamushka", "matrioska", "muñeca rusa", "rusia"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &[
                "babushka",
                "mamushka",
                "matrioshka",
                "matrioska",
                "muñeca rusa",
                "rusia",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("muñecas rusas"),
            keywords: &["muñecas rusas"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("muñecas rusas"),
            keywords: &["muñecas rusas"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("matrjoška"),
            keywords: &["matrjoška", "matrjoškad", "nukk", "vene"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("matrioxka"),
            keywords: &["errusia", "matrioxka", "panpina"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("عروسک تودرتو"),
            keywords: &["تودرتو", "روسیه", "عروسک"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("maatuskanuket"),
            keywords: &["maatuska", "maatuskanuket", "nukke", "venäläinen"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("manikang matryoshka"),
            keywords: &["manika", "manikang matryoshka", "russia"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("babusjka"),
            keywords: &["Russland", "babusjka", "matrjosjka", "russisk dukka"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("poupées russes"),
            keywords: &["emboîté", "matriochka", "poupées russes", "russe"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("poupées russes"),
            keywords: &["poupée russe", "poupées russes", "russie"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("bábóga Rúiseacha"),
            keywords: &["bábóga Rúiseacha"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("doileagan matryoshka"),
            keywords: &[
                "Ruiseanach",
                "am broinn a chèile",
                "doileag",
                "doileagan matryoshka",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("bonecas rusas"),
            keywords: &["Rusia", "bonecas rusas", "matrioska", "matruxa"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ન\u{ac7}સ\u{acd}ટિ\u{a82}ગ ડૉલ\u{acd}સ"),
            keywords: &[
                "ડૉલ",
                "ઢી\u{a82}ગલી",
                "ન\u{ac7}સ\u{acd}ટિ\u{a82}ગ",
                "ન\u{ac7}સ\u{acd}ટિ\u{a82}ગ ડૉલ\u{acd}સ",
                "રશિયા",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("בבושקה"),
            keywords: &["בבושקה", "בובה", "בובות בבושקה", "רוסית"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("न\u{947}स\u{94d}टि\u{902}ग ग\u{941}ड\u{93c}ियो\u{902} का सम\u{942}ह"),
            keywords: &[
                "ग\u{941}ड\u{93c}िया",
                "न\u{947}स\u{94d}टि\u{902}ग",
                "न\u{947}स\u{94d}टि\u{902}ग ग\u{941}ड\u{93c}ियो\u{902} का सम\u{942}ह",
                "र\u{942}स",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("babuška"),
            keywords: &["Rusija", "babuška", "lutka", "matrjoška"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("matrjoska"),
            keywords: &["baba", "egymásba rakható", "matrjoska", "orosz"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մատրյոշկա"),
            keywords: &["մատրյոշկա", "ռուսաստան", "տիկնիկ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("boneka bersarang"),
            keywords: &["bersarang", "boneka", "rusia"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("babúskur"),
            keywords: &["Rússland", "babúskur", "dúkkur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("matrioska"),
            keywords: &["bambola", "matrioska", "russia"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("マトリョーシカ"),
            keywords: &["マトリョーシカ", "ロシア", "人形", "入れ子"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("boneka rusia"),
            keywords: &["boneka", "nyusuh", "rusia"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მატრიოშკა"),
            keywords: &["ერთმანეთში მოთავსებული", "მატრიოშკა", "რუსეთი", "სათამაშო"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("матрешка"),
            keywords: &["матрешка", "ресей", "қуыршақ"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "ត\u{17bb}ក\u{17d2}កតាក\u{17bc}នក\u{17d2}រម\u{17bb}\u{17c6}ដាក\u{17cb}លើគ\u{17d2}នា",
            ),
            keywords: &[
                "ការដាក\u{17cb}លើគ\u{17d2}នា",
                "ត\u{17bb}ក\u{17d2}កតាក\u{17bc}នក\u{17d2}រម\u{17bb}\u{17c6}",
                "ត\u{17bb}ក\u{17d2}កតាក\u{17bc}នក\u{17d2}រម\u{17bb}\u{17c6}ដាក\u{17cb}លើគ\u{17d2}នា",
                "រ\u{17bb}ស\u{17d2}ស\u{17ca}\u{17b8}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಗ\u{cc2}ಡುಕಟ\u{ccd}ಟುವ ಗೊಂಬ\u{cc6}ಗಳು"),
            keywords: &[
                "ಗ\u{cc2}ಡುಕಟ\u{ccd}ಟುವ ಗೊಂಬ\u{cc6}ಗಳು",
                "ಗ\u{cc2}ಡುಕಟ\u{ccd}ಟುವ\u{cbf}ಕ\u{cc6}",
                "ಗೊಂಬ\u{cc6}",
                "ರಷ\u{ccd}ಯಾ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("네스팅 인형"),
            keywords: &["네스팅 인형", "러시아", "마트료시카", "인형"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("न\u{947}स\u{94d}टी\u{902}ग डॉल\u{94d}स"),
            keywords: &[
                "न\u{947}स\u{94d}टी\u{902}ग",
                "न\u{947}स\u{94d}टी\u{902}ग डॉल\u{94d}स",
                "बावली",
                "र\u{941}स",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("матрёшка"),
            keywords: &["матрёшка"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຕ\u{eb8}ກກະຕາເປ\u{eb1}ນຮ\u{eb1}ງ"),
            keywords: &[
                "ການເຮ\u{eb1}ດຮ\u{eb1}ງ",
                "ຕ\u{eb8}ກກະຕາ",
                "ຕ\u{eb8}ກກະຕາເປ\u{eb1}ນຮ\u{eb1}ງ",
                "ຣ\u{eb1}ດເຊຍ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("matrioškos"),
            keywords: &["Rusija", "lėlė", "matrioška", "matrioškos"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("matrjoškas"),
            keywords: &["krievu", "lelle", "matrjoška", "matrjoškas"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("руска кукла"),
            keywords: &["вгнездена", "кукла", "русија", "руска кукла"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("നെസ\u{d4d}റ\u{d4d}റിംഗ\u{d4d} പ\u{d3e}വകൾ"),
            keywords: &[
                "നെസ\u{d4d}റ\u{d4d}റിംഗ\u{d4d}",
                "നെസ\u{d4d}റ\u{d4d}റിംഗ\u{d4d} പ\u{d3e}വകൾ",
                "പ\u{d3e}വ",
                "റഷ\u{d4d}യ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("угсардаг хүүхэлдэй"),
            keywords: &["орос", "угсардаг", "хүүхэлдэй"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("न\u{947}स\u{94d}टि\u{902}ग डॉल\u{94d}स"),
            keywords: &[
                "घरट\u{947} बा\u{902}धण\u{947}",
                "न\u{947}स\u{94d}टि\u{902}ग डॉल\u{94d}स",
                "बाह\u{941}ली",
                "रशिया",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("anak potong sekelompok"),
            keywords: &[
                "anak patung",
                "anak potong sekelompok",
                "kelompok",
                "matryoshka",
                "rusia",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အရ\u{102f}ပ\u{103a}များ"),
            keywords: &[
                "ရ\u{102f}ရ\u{103e}ား",
                "အရ\u{102f}ပ\u{103a}",
                "အရ\u{102f}ပ\u{103a}များ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("matrjosjka"),
            keywords: &[
                "dukke",
                "hul",
                "matrjosjka",
                "matruska",
                "russisk",
                "russland",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("न\u{947}स\u{94d}टिङ ग\u{941}डियाहर\u{942}"),
            keywords: &[
                "ग\u{941}डिया",
                "न\u{947}स\u{94d}टिङ",
                "न\u{947}स\u{94d}टिङ ग\u{941}डियाहर\u{942}",
                "र\u{941}स",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("matroesjka"),
            keywords: &["matroesjka", "pop", "poppetjes", "rusland"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("matrjosjka"),
            keywords: &[
                "dokke",
                "hol",
                "matrjosjka",
                "matruska",
                "russisk",
                "russland",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ନେଷ\u{b4d}ଟ\u{b3f}ଙ\u{b4d}ଗ ଡ\u{b3c}ଲସ\u{b4d}\u{200c}"),
            keywords: &[
                "ଖେଳନ\u{b3e}",
                "ନେଷ\u{b4d}ଟ\u{b3f}ଙ\u{b4d}ଗ",
                "ନେଷ\u{b4d}ଟ\u{b3f}ଙ\u{b4d}ଗ ଡ\u{b3c}ଲସ\u{b4d}\u{200c}",
                "ର\u{b41}ଷ\u{b3f}ଆ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਨ\u{a48}ਸਟਿ\u{a70}ਗ ਡ\u{a4b}ਲ"),
            keywords: &["ਡ\u{a4b}ਲ", "ਨ\u{a48}ਸਟਿ\u{a70}ਗ", "ਰ\u{a42}ਸ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Dọlbebí Ínsaíd Anọ\u{301}dá Dọlbebí"),
            keywords: &[
                "Dọlbebí Ínsaíd Anọ\u{301}dá Dọlbebí",
                "Dọlbébí",
                "Nẹ\u{301}stin",
                "Pút Sọ\u{301}mtin Ínsaíd Anọ\u{301}dá Tin Wé Rizẹ\u{301}mbúl Am",
                "Rọ\u{301}shia",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("matrioszki"),
            keywords: &["laleczka", "lalka", "matrioszka", "matrioszki", "rosyjska"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ځاله کوونکې نانځکه"),
            keywords: &["روسي", "نانځکه", "ځاله کول", "ځاله کوونکې نانځکه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("boneca russa"),
            keywords: &["boneca", "matriosca", "russa"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("matrioșka"),
            keywords: &["Rusia", "lemn", "matrioșka", "păpușă", "rusească"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E13-053"),
            keywords: &["E13-053"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("матрешка"),
            keywords: &[
                "игрушка",
                "кукла",
                "матрешка",
                "матрешки",
                "россия",
                "русская",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("آکاري واريون گڏيون"),
            keywords: &["آکاري واريون گڏيون", "روس", "نيسٽنگ", "گڏي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ර\u{dd4}ස\u{dd2}ය\u{dcf}න\u{dd4} බෝන\u{dd2}ක\u{dca}කන\u{dca}"),
            keywords: &[
                "කැදැල\u{dca}ල",
                "බෝන\u{dd2}ක\u{dca}ක\u{dcf}",
                "ර\u{dd4}ස\u{dd2}ය\u{dcf}න\u{dd4} බෝන\u{dd2}ක\u{dca}කන\u{dca}",
                "ර\u{dd4}ස\u{dd2}ය\u{dcf}ව",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("matriošky"),
            keywords: &["bábika", "matrioška", "matriošky", "ruská"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("babuška"),
            keywords: &["babuška", "gnezdenje", "lutka", "rusija"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("buulka boombalaha"),
            keywords: &[
                "boombale",
                "buul galinta boombalaha",
                "buulka boombalaha",
                "buulleeyn",
                "ruushka",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("matrioshka"),
            keywords: &["brenda njëra-tjetrës", "kukull", "matrioshka", "rusi"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("лутка у лутки"),
            keywords: &["бабушка", "лутка", "лутка у лутки", "русија"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("lutka u lutki"),
            keywords: &["babuška", "lutka", "lutka u lutki", "rusija"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("ryska dockor"),
            keywords: &["babuschkadocka", "matrjosjka", "rysk docka", "ryska dockor"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mwanaserere wa kirusi"),
            keywords: &["kutunza", "mwanaserere", "mwanaserere wa kirusi", "urusi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("அம\u{bcd}ம\u{bbe} பொம\u{bcd}மைகள\u{bcd}"),
            keywords: &[
                "அம\u{bcd}ம\u{bbe}",
                "அம\u{bcd}ம\u{bbe} பொம\u{bcd}மைகள\u{bcd}",
                "பொம\u{bcd}மை",
                "ரஷிய\u{bbe}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "ఒకద\u{c3e}న\u{c3f}ల\u{c4b} ఒకట\u{c3f} ఇమ\u{c3f}డ\u{c47} బ\u{c4a}మ\u{c4d}మలు",
            ),
            keywords: &[
                "ఒకద\u{c3e}న\u{c3f}ల\u{c4b} ఒకట\u{c3f} ఇమ\u{c3f}డటం",
                "ఒకద\u{c3e}న\u{c3f}ల\u{c4b} ఒకట\u{c3f} ఇమ\u{c3f}డ\u{c47} బ\u{c4a}మ\u{c4d}మలు",
                "బ\u{c4a}మ\u{c4d}మ",
                "రష\u{c4d}య\u{c3e}",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ต\u{e38}\u{e4a}กตาแม\u{e48}ล\u{e39}กดก"),
            keywords: &[
                "ซ\u{e49}อนก\u{e31}น",
                "ต\u{e38}\u{e4a}กตา",
                "ต\u{e38}\u{e4a}กตาแม\u{e48}ล\u{e39}กดก",
                "ร\u{e31}สเซ\u{e35}ย",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("matrýoşkalar"),
            keywords: &["gurjak", "içi-içine girýän", "matrýoşkalar", "russiýa"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tamapua fakaʻotu"),
            keywords: &["tamapua fakaʻotu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("matruşka"),
            keywords: &["Rusya", "bebek", "iç içe", "matruşka"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("ляльки-матрьошки"),
            keywords: &["лялька", "ляльки-матрьошки", "матрьошка", "росія"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("جادوئی گڑیاں"),
            keywords: &["جادوئی گڑیاں", "روس", "نیسٹنگ", "نیسٹنگ گڑیاں", "گڑیا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("matryoshka"),
            keywords: &["ichma-ich", "matryoshka", "qoʻgʻirchoq", "rossiya"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("búp bê matryoshka"),
            keywords: &["búp bê", "búp bê matryoshka", "làm tổ", "nước Nga"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("俄羅斯木公仔"),
            keywords: &["俄羅斯", "俄羅斯木公仔", "公仔", "組裝"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("俄罗斯木公仔"),
            keywords: &["俄罗斯", "俄罗斯木公仔", "公仔", "组装"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("套娃"),
            keywords: &["俄罗斯套娃", "套娃", "娃娃"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("俄羅斯娃娃"),
            keywords: &["俄羅斯", "俄羅斯娃娃", "多層", "娃娃"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
    ],
};
#[doc = "♠\u{fe0f}"]
pub const SPADE_SUIT: crate::Emoji = crate::Emoji {
    glyph: "♠\u{fe0f}",
    codepoint: "2660 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "spade suit",
    group: "Activities",
    subgroup: "game",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "♠",
        codepoint: "2660",
        status: crate::Status::Unqualified,
        introduction_version: 0.6f32,
        name: "spade suit",
        group: "Activities",
        subgroup: "game",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("skoppens"),
            keywords: &["kaart", "skoppens", "speelkaarte", "speletjie"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የካርታ ጦር"),
            keywords: &["ካርታ", "የካርታ እሽግ", "የካርታ ጦር", "ጦር", "ጨዋታ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ورقة البستوني"),
            keywords: &["بطاقة", "كوتشينة", "لعبة", "ورقة", "ورقة البستوني"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ইস\u{9cd}ক\u{9be}পন"),
            keywords: &[
                "ইস\u{9cd}ক\u{9be}পন",
                "ক\u{9cd}ৰীড\u{9bc}\u{9be}",
                "ত\u{9be}\u{981}চখেল",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qaratoxmaq dəsti"),
            keywords: &["dəst", "kart", "oyun", "qaratoxmaq", "qaratoxmaq dəsti"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("віны"),
            keywords: &["азарт", "віны", "гульня", "карты", "масць", "пікі"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("пика"),
            keywords: &["игра", "карта", "пика"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("স\u{9cd}পেড স\u{9cd}য\u{9c1}ট"),
            keywords: &[
                "ক\u{9be}র\u{9cd}ড",
                "খেল\u{9be}",
                "স\u{9cd}পেড",
                "স\u{9cd}য\u{9c1}ট",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("pikez"),
            keywords: &["kartenn", "pikez", "pikezenn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("pik"),
            keywords: &["igra", "karte", "pik", "znak"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("pal de piques"),
            keywords: &["cartes", "pal", "pal de piques", "partida", "piques"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎪᏕᏍᏗ ᏧᏠᏱᎭ"),
            keywords: &["ᎠᏆᏂᏲᏍᏗ", "ᎪᏕᏍᏗ ᏧᏠᏱᎭ", "ᏗᏁᏟᏙᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("piky"),
            keywords: &["barva", "hra", "karta", "piky"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("siwt rhofiau"),
            keywords: &["cardiau", "gêm", "rhofiau", "siwt"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("spar"),
            keywords: &["kort", "spar", "spil"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Pik"),
            keywords: &["Kartenspiel", "Pik"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μπαστούνι"),
            keywords: &["μπαστούνι", "παιχνίδι", "χαρτιά", "χρώμα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("spade suit"),
            keywords: &["card", "game", "spade suit"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("palo de picas"),
            keywords: &["carta", "juego", "palo", "palo de picas", "picas"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("picas"),
            keywords: &["cartas", "juegos", "naipes", "palos", "picas"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("poti"),
            keywords: &["kaart", "mast", "mäng", "poti"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("pika"),
            keywords: &["joko", "karta", "palo", "pika"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("خال پیک"),
            keywords: &["بازی", "خال", "پیک", "کارت"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("pata"),
            keywords: &["kortti", "korttipeli", "maa", "pata"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("spade"),
            keywords: &["baraha", "spade", "sugal"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("spaðari"),
            keywords: &["kort", "spaðari"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("pique"),
            keywords: &["carte", "couleur", "jeu", "pique"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("dath spéireata"),
            keywords: &["cluiche", "cárta", "dath", "spéireata"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("dath speura"),
            keywords: &["cairt", "dath speura", "geama"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("picas"),
            keywords: &["baralla francesa", "cartas", "pica", "picas", "xogos"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("કાળીન\u{ac1}\u{a82} પત\u{acd}ત\u{ac1}\u{a82}"),
            keywords: &[
                "કાર\u{acd}ડ",
                "કાળી",
                "કાળીન\u{ac1}\u{a82} પત\u{acd}ત\u{ac1}\u{a82}",
                "પત\u{acd}ત\u{ac1}\u{a82}",
                "રમત",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("zubin suffa"),
            keywords: &["kati", "wasa", "zubin suffa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("קלף עלה"),
            keywords: &["משחק", "עלה", "קלף"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ह\u{941}क\u{941}म का पत\u{94d}ता"),
            keywords: &["कार\u{94d}ड", "ताश", "ह\u{941}क\u{941}म का पत\u{94d}ता"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("pik"),
            keywords: &["igra", "karta", "pik"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("pikk szín"),
            keywords: &["francia kártya", "játék", "pikk", "szín"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ղառ"),
            keywords: &["ագռավ", "թղթախաղ", "խաղ", "խաղաքարտ", "ղառ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("sekop"),
            keywords: &["kartu", "permainan", "sekop"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("egwuregwu joka"),
            keywords: &["egwuregwu", "egwuregwu joka", "kaadị"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("spaði"),
            keywords: &["leikur", "spaði", "spil", "spilalitur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("picche"),
            keywords: &["carte", "picche", "seme"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("スペード"),
            keywords: &["カード", "スペード", "トランプ"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kertu sekop"),
            keywords: &["game", "kertu", "kertu sekop"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ყვავები"),
            keywords: &["ბანქო", "თამაში", "კარტი", "ფერი", "ყვავები", "ყვავი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қарға"),
            keywords: &["карта", "ойын", "қарға"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("spar"),
            keywords: &["kort", "spar", "spil"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17ca}\u{17b7}ច (ល\u{17d2}បែងបៀ)"),
            keywords: &[
                "បៀ",
                "ប\u{17ca}\u{17b7}ច (ល\u{17d2}បែងបៀ)",
                "ភ\u{17b7}ច",
                "ល\u{17d2}បែង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸ\u{ccd}ಪೇಡ\u{ccd} ಸ\u{cc2}ಟ\u{ccd}"),
            keywords: &[
                "ಕಾರ\u{ccd}ಡು",
                "ಗೇಮ\u{ccd}",
                "ಸ\u{cc2}ಟ\u{ccd}",
                "ಸ\u{ccd}ಪೇಡ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("스페이드"),
            keywords: &["스페이드", "카드 게임"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("स\u{94d}प\u{947}ड स\u{942}ट"),
            keywords: &[
                "ख\u{947}ळ",
                "पत\u{94d}त\u{947}",
                "स\u{94d}प\u{947}ड स\u{942}ट",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("карга"),
            keywords: &["карга", "карта", "оюн"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Schëppen"),
            keywords: &["Kaart", "Schëppen", "Spill"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໂພດຳ"),
            keywords: &["ຫ\u{ebc}\u{eb5}\u{ec9}ນ", "ໂພດຳ", "ໄພ\u{ec9}"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("pikai"),
            keywords: &["kortos", "pikai", "žaidimas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("pīķis"),
            keywords: &["kārtis", "pīķis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("hūtu pēti"),
            keywords: &["hūtu pēti", "kāri", "kēmu"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("пик во карти"),
            keywords: &["игра", "карти", "лист", "пик", "пик во карти"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "സ\u{d4d}\u{200c}പെയ\u{d4d}\u{200c}ഡ\u{d4d} സ\u{d4d}യ\u{d42}ട\u{d4d}ട\u{d4d}",
            ),
            keywords: &[
                "ക\u{d3e}ർഡ\u{d4d}",
                "ഗെയിം",
                "സ\u{d4d}യ\u{d42}ട\u{d4d}ട\u{d4d}",
                "സ\u{d4d}\u{200c}പെയ\u{d4d}\u{200c}ഡ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хөзрийн гил"),
            keywords: &["гил", "тоглоом", "хөзрийн гил", "хөзөр"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("इस\u{94d}पिक"),
            keywords: &["इस\u{94d}पिक", "कार\u{94d}ड", "ग\u{947}म"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("daun sped"),
            keywords: &["daun", "kad", "permainan", "sped"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("taqsima tal-ispati"),
            keywords: &["karta", "logħba", "taqsima tal-ispati"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဖ\u{1030}းဖ\u{1032}ချပ\u{103a}အတ\u{103d}\u{1032}"),
            keywords: &[
                "ဂ\u{102d}မ\u{103a}း",
                "ဖ\u{1030}းဖ\u{1032}ချပ\u{103a}အတ\u{103d}\u{1032}",
                "ဖ\u{1032}ချပ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("spar"),
            keywords: &["farge", "kort", "spar", "spill"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{94d}प\u{947}ड स\u{941}इट"),
            keywords: &["कार\u{94d}ड", "ख\u{947}ल", "स\u{94d}प\u{947}ड स\u{941}इट"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("schoppen"),
            keywords: &["kaart", "schoppen", "spel"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("spar"),
            keywords: &["farge", "kort", "spar", "spel"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସ\u{b4d}ପେଡ\u{b4d}\u{200d} ସ\u{b41}ଟ\u{b4d}\u{200d}"),
            keywords: &[
                "କ\u{b3e}ର\u{b4d}ଡ\u{b4d} । ଖେଳ",
                "ସ\u{b4d}ପେଡ\u{b4d}\u{200d} ସ\u{b41}ଟ\u{b4d}\u{200d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਹ\u{a41}ਕਮ ਦ\u{a47} ਪ\u{a71}ਤ\u{a47}"),
            keywords: &[
                "ਤਾਸ\u{a3c}",
                "ਸਪ\u{a47}ਡ",
                "ਹ\u{a41}ਕਮ ਦ\u{a47} ਪ\u{a71}ਤ\u{a47}",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("پھاؤڑا لباس"),
            keywords: &["پھاؤڑا لباس", "کارڈ", "کھیڈ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Sped Pléyín Kad"),
            keywords: &["Gem", "Kad", "Sped Pléyín Kad"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("pik"),
            keywords: &["gra", "karta", "pik", "talia"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د قرې پته"),
            keywords: &["تاش", "د قرې پته", "لوبه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("naipe de espadas"),
            keywords: &[
                "baralho",
                "carta",
                "espadas",
                "jogo",
                "naipe",
                "naipe de espadas",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["carta", "espadas", "jogo", "naipe", "naipe de espadas"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("espada tarhita"),
            keywords: &["espada tarhita", "pukllay", "tarhita"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("pică"),
            keywords: &["cărți", "inimă neagră", "joc", "pică"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-076"),
            keywords: &["E10-076"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("пики"),
            keywords: &["игра", "карты", "масть", "пики"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikimenyeso cy’ipiki"),
            keywords: &["ikarita", "ikimenyeso cy’ipiki", "umukino"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("اسپيڊ سوٽ"),
            keywords: &["اسپيڊ سوٽ", "ڪارڊ، راند"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ඉස\u{dca}කෝප\u{dca}පය"),
            keywords: &[
                "ඉස\u{dca}කෝප\u{dca}පය",
                "ක\u{dca}\u{200d}ර\u{dd3}ඩ\u{dcf}ව",
                "ක\u{dcf}ඩ\u{dca}",
                "ස\u{dd6}ට\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("pika"),
            keywords: &["farba", "hra", "karta", "pika"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("pik"),
            keywords: &["barva", "igra", "karta", "pik"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("farshaxan"),
            keywords: &["ciyaar", "farshaxan", "farshaxanka", "kaadh"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("figurë maç"),
            keywords: &["figurë", "letër", "lojë", "maç"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("пик"),
            keywords: &["игрa", "кaртa", "пик"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("pik"),
            keywords: &["igra", "karta", "pik"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("spader"),
            keywords: &["färg", "kort", "spader"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("shupaza"),
            keywords: &["kadi", "karata", "mchezo", "shupaza"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஸ\u{bcd}பேட\u{bcd} க\u{bbe}ர\u{bcd}டு"),
            keywords: &[
                "ச\u{bc0}ட\u{bcd}டு விளைய\u{bbe}டுதல\u{bcd}",
                "ஸ\u{bcd}பேட\u{bcd} க\u{bbe}ர\u{bcd}டு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ప\u{c47}క\u{c3e}టల\u{c4b} స\u{c4d}ప\u{c47}డ\u{c4d}"),
            keywords: &[
                "ప\u{c47}క\u{c3e}ట",
                "ప\u{c47}క\u{c3e}టల\u{c4b} స\u{c4d}ప\u{c47}డ\u{c4d}",
                "సూట\u{c4d}",
                "స\u{c4d}ప\u{c47}డ\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("қарамашшоқ"),
            keywords: &["бозӣ", "корт", "қарамашшоқ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("โพดำ"),
            keywords: &["เกม", "โพดำ", "ไพ\u{e48}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gara kart"),
            keywords: &["gara kart", "garak kart", "kart", "oýun"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("sipeiti"),
            keywords: &["sipeiti"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("maça"),
            keywords: &["iskambil", "kart", "maça", "pik"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قاغا"),
            keywords: &["ئويۇن", "قارتا", "قاغا"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("піка"),
            keywords: &["гра", "карта", "масть", "піка"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("حکم کا پتہ"),
            keywords: &["تاش", "حکم", "حکم کا پتہ", "پتہ", "کھیل"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("qarg‘a kartasi"),
            keywords: &["karta", "o‘yin", "qarg‘a", "qarg‘a kartasi"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bộ bích"),
            keywords: &["bài", "bộ bài bích", "bộ bích", "trò chơi"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("pikk yépp"),
            keywords: &["kàrt", "pikk yépp", "po"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-spade suit"),
            keywords: &["i-spade suit", "ikhadi", "umdlalo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ìpín káàdì sípèdì"),
            keywords: &["eré", "káàdì", "ìpín káàdì sípèdì"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("葵扇"),
            keywords: &["紙牌", "葵扇", "遊戲"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("葵扇"),
            keywords: &["游戏", "纸牌", "葵扇"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("黑桃"),
            keywords: &["扑克", "牌", "葵扇", "黑桃"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("黑桃"),
            keywords: &["紙牌", "黑桃"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("葵扇"),
            keywords: &["啤牌", "葵扇"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("uspeyidi"),
            keywords: &["ikhadi", "ispeyidi", "umdlalo", "uspeyidi"],
        },
    ],
};
#[doc = "♥\u{fe0f}"]
pub const HEART_SUIT: crate::Emoji = crate::Emoji {
    glyph: "♥\u{fe0f}",
    codepoint: "2665 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "heart suit",
    group: "Activities",
    subgroup: "game",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "♥",
        codepoint: "2665",
        status: crate::Status::Unqualified,
        introduction_version: 0.6f32,
        name: "heart suit",
        group: "Activities",
        subgroup: "game",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("harte"),
            keywords: &["harte", "kaart", "speletjie"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የካርታ ልብ"),
            keywords: &["ልብ", "ካርታ", "የካርታ ልብ", "የካርታ እሽግ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ورقة قلب أحمر"),
            keywords: &["قلب", "قلوب", "كوتشينة", "لعبة", "ورقة", "ورقة قلب أحمر"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("হৰ\u{9cd}ত\u{9cd}তন"),
            keywords: &[
                "ক\u{9cd}ৰীড\u{9bc}\u{9be}",
                "ত\u{9be}\u{981}চখেল",
                "হৰ\u{9cd}ত\u{9cd}তন",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("ürək dəsti"),
            keywords: &["dəst", "kart", "oyun", "ürək", "ürək dəsti", "ürəklər"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("чырвы"),
            keywords: &["гульня", "карты", "чырвы"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("купа"),
            keywords: &["игра", "карта", "купа"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("হ\u{9be}র\u{9cd}ট স\u{9cd}য\u{9c1}ট"),
            keywords: &[
                "ক\u{9be}র\u{9cd}ড",
                "খেল\u{9be}",
                "স\u{9cd}য\u{9c1}ট",
                "হ\u{9be}র\u{9cd}ট",
                "হ\u{9be}র\u{9cd}টস",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("keur"),
            keywords: &["kartenn", "keur", "keurenn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("srce"),
            keywords: &["igra", "karte", "srce", "znak"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("pal de cors"),
            keywords: &["cartes", "cors", "pal", "pal de cors", "partida"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᎿᏫ ᏧᏠᏱᎭ"),
            keywords: &["ᎠᏆᏂᏲᏍᏗ", "ᎤᎿᏫ ᏧᏠᏱᎭ", "ᏗᏁᏟᏙᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("srdce"),
            keywords: &["barva", "hra", "karta", "srdce"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("siwt calonnau"),
            keywords: &["calonnau", "cardiau", "gêm", "siwt"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("hjerter"),
            keywords: &["hjerter", "kort", "spil"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Herz"),
            keywords: &["Herz", "Kartenspiel"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κούπα"),
            keywords: &["καρδιά", "καρδιές", "κούπα", "παιχνίδι", "χαρτιά", "χρώμα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("heart suit"),
            keywords: &["card", "game", "heart suit"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("palo de corazones"),
            keywords: &["carta", "corazones", "juego", "palo", "palo de corazones"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("corazones"),
            keywords: &["cartas", "corazones", "juegos", "naipes", "palos"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("ärtu"),
            keywords: &["kaart", "mast", "mäng", "ärtu"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("bihotza"),
            keywords: &["bihotz", "bihotza", "joko", "karta", "palo"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("خال دل"),
            keywords: &["بازی", "خال", "دل", "کارت"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("hertta"),
            keywords: &["hertta", "kortti", "korttipeli", "maa"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("heart"),
            keywords: &["baraha", "heart", "sugal"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("hjartari"),
            keywords: &["hjartari", "kort"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("cœur cartes"),
            keywords: &["couleur", "cœur", "cœur cartes", "jeu"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["carte", "couleur", "cœur", "cœur cartes", "jeu"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("dath hairt"),
            keywords: &["cluiche", "cárta", "dath", "dath hairt", "hart", "hartanna"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("dath cridhe"),
            keywords: &["cairt", "dath cridhe", "geama"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("corazóns"),
            keywords: &["baralla francesa", "cartas", "corazón", "corazóns", "xogos"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("લાલન\u{ac1}\u{a82} પત\u{acd}ત\u{ac1}\u{a82}"),
            keywords: &[
                "કાર\u{acd}ડ",
                "પત\u{acd}ત\u{ac1}\u{a82}",
                "રમત",
                "લાલ",
                "લાલન\u{ac1}\u{a82} પત\u{acd}ત\u{ac1}\u{a82}",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("zubin kubbi"),
            keywords: &["kati", "wasa", "zubin kubbi"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("קלף לב"),
            keywords: &["לב", "משחק", "קלף"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("पान का पत\u{94d}ता"),
            keywords: &["कार\u{94d}ड", "ताश", "पान का पत\u{94d}ता", "लाल दिल"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("herc"),
            keywords: &["herc", "igra", "karta"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("kőr szín"),
            keywords: &["francia kártya", "játék", "kőr", "szín"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("սիրտ"),
            keywords: &[
                "թղթախաղ",
                "խաղ",
                "խաղաքարտ",
                "սիրտ",
                "սրտեր",
                "փոսիկ",
                "քարտ",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("hati"),
            keywords: &["hati", "kartu", "permainan"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("egwuregwu joka ịhụnanya"),
            keywords: &["egwuregwu", "egwuregwu joka ịhụnanya", "kaadị"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hjarta"),
            keywords: &["hjarta", "leikur", "spil", "spilalitur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("cuori"),
            keywords: &["carte", "cuori", "seme"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ハート"),
            keywords: &["カード", "トランプ", "ハート"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kertu ati"),
            keywords: &["game", "kertu", "kertu ati"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("გულები"),
            keywords: &["ბანქო", "გულები", "გული", "თამაში", "კარტი", "ფერი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жүрек"),
            keywords: &["жүрек", "жүректер", "карта", "ойын", "түйе"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("hjerter"),
            keywords: &["hjerter", "kort", "spil"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ក\u{17ba} (ល\u{17d2}បែងបៀ)"),
            keywords: &[
                "ក\u{17ba}",
                "ក\u{17ba} (ល\u{17d2}បែងបៀ)",
                "បៀ",
                "ល\u{17d2}បែង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಹಾರ\u{ccd}ಟ\u{ccd} ಸ\u{cc2}ಟ\u{ccd}"),
            keywords: &["ಆಟ", "ಸ\u{cc2}ಟ\u{ccd}", "ಹಾರ\u{ccd}ಟ\u{ccd}", "ಹೃದಯ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("하트"),
            keywords: &["카드 게임", "하트"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("हार\u{94d}ट स\u{942}ट"),
            keywords: &["ख\u{947}ळ", "पत\u{94d}त\u{947}", "हार\u{94d}ट स\u{942}ट"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("ача"),
            keywords: &["ача", "карта", "оюн"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Häerzer"),
            keywords: &["Häerzer", "Kaart", "Spill"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເກ\u{eb5}"),
            keywords: &["ຫ\u{ebc}\u{eb5}\u{ec9}ນ", "ເກ\u{eb5}", "ໄພ\u{ec9}"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("širdys"),
            keywords: &["kortos", "širdys", "žaidimas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("ercens"),
            keywords: &["ercens", "kārtis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("hūtu hāte"),
            keywords: &["hūtu hāte", "kāri", "kēmu"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("срце во карти"),
            keywords: &["игра", "карти", "срце", "срце во карти"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഹ\u{d3e}ർട\u{d4d}ട\u{d4d} സ\u{d4d}യ\u{d42}ട\u{d4d}ട\u{d4d}"),
            keywords: &[
                "ക\u{d3e}ർഡ\u{d4d}",
                "ഗെയിം",
                "സ\u{d4d}യ\u{d42}ട\u{d4d}ട\u{d4d}",
                "ഹ\u{d3e}ർട\u{d4d}ട\u{d4d}",
                "ഹ\u{d3e}ർട\u{d4d}ട\u{d4d}സ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хөзрийн бунд"),
            keywords: &["бунд", "тоглоом", "хөзрийн бунд", "хөзөр"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("बदाम"),
            keywords: &["कार\u{94d}ड", "ग\u{947}म", "बदाम"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("daun lekuk"),
            keywords: &["daun", "hati", "kad", "lekuk", "permainan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("taqsima tal-kwori"),
            keywords: &["karta", "logħba", "taqsima tal-kwori"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဖ\u{1030}းန\u{102e}ဖ\u{1032}ချပ\u{103a}အတ\u{103d}\u{1032}"),
            keywords: &[
                "ဂ\u{102d}မ\u{103a}း",
                "ဖ\u{1030}းန\u{102e}ဖ\u{1032}ချပ\u{103a}အတ\u{103d}\u{1032}",
                "ဖ\u{1032}ချပ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("hjerter"),
            keywords: &["farge", "hjerter", "kort", "spill"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("हार\u{94d}ट स\u{941}इट"),
            keywords: &["कार\u{94d}ड", "ख\u{947}ल", "हार\u{94d}ट स\u{941}इट"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("harten"),
            keywords: &["harten", "kaart", "spel"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("hjarter"),
            keywords: &["farge", "hjarter", "kort", "spel"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ହ\u{b3e}ର\u{b4d}ଟ\u{b4d}\u{200d} ସ\u{b41}ଟ\u{b4d}\u{200d}"),
            keywords: &[
                "କ\u{b3e}ର\u{b4d}ଡ\u{b4d} । ଖେଳ",
                "ହ\u{b3e}ର\u{b4d}ଟ\u{b4d}\u{200d} ସ\u{b41}ଟ\u{b4d}\u{200d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪਾਨ ਦ\u{a47} ਪ\u{a71}ਤ\u{a47}"),
            keywords: &["ਤਾਸ\u{a3c}", "ਦਿਲ", "ਪਾਨ ਦ\u{a47} ਪ\u{a71}ਤ\u{a47}"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("دل دا لباس"),
            keywords: &["دل دا لباس", "کارڈ", "کھیڈ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Hat Pléyín Kad"),
            keywords: &["Gem", "Hat Pléyín Kad", "Kad"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kier"),
            keywords: &["gra", "karta", "kier", "talia"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د تپان پته"),
            keywords: &["تاش", "د تپان پته", "لوبه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("naipe de copas"),
            keywords: &[
                "baralho",
                "carta",
                "copas",
                "jogo",
                "naipe",
                "naipe de copas",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["carta", "copas", "jogo", "naipe", "naipe de copas"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("sunqu tarhita"),
            keywords: &["pukllay", "sunqu tarhita", "tarhita"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("cupă"),
            keywords: &["cupă", "cărți", "inimă roșie", "joc"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-078"),
            keywords: &["E10-078"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("червы"),
            keywords: &["игра", "карты", "масть", "червы"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikimenyetso cy’umutima"),
            keywords: &["ikarita", "ikimenyetso cy’umutima", "umukino"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("هرٽ سوٽ"),
            keywords: &["هرٽ سوٽ", "ڪارڊ، راند"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("හදවත"),
            keywords: &[
                "ක\u{dca}\u{200d}ර\u{dd3}ඩ\u{dcf}ව",
                "ක\u{dcf}ඩ\u{dca}",
                "ස\u{dd6}ට\u{dca}",
                "හදවත",
                "හදවත\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("srdce"),
            keywords: &["farba", "hra", "karta", "srdce", "srdcia"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("srce"),
            keywords: &["barva", "igra", "karta", "srca", "srce"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("lebiska qalbiga"),
            keywords: &["ciyaar", "kaadh", "lebiska qalbiga"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("figurë kupë"),
            keywords: &["figurë", "kupë", "letër", "lojë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("херц"),
            keywords: &["игрa", "кaртa", "хeрц", "херц"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("herc"),
            keywords: &["herc", "igra", "karta"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("hjärter"),
            keywords: &["färg", "hjärter", "kort"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kopa"),
            keywords: &["kadi", "karata", "kopa", "mchezo"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஹ\u{bbe}ர\u{bcd}ட\u{bcd} க\u{bbe}ர\u{bcd}டு"),
            keywords: &[
                "ச\u{bc0}ட\u{bcd}டு விளைய\u{bbe}டுதல\u{bcd}",
                "ஹ\u{bbe}ர\u{bcd}ட\u{bcd} க\u{bbe}ர\u{bcd}டு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("హ\u{c3e}ర\u{c4d}ట\u{c4d} సూట\u{c4d}"),
            keywords: &[
                "ప\u{c47}క\u{c3e}ట",
                "సూట\u{c4d}",
                "హ\u{c3e}ర\u{c4d}ట\u{c4d} సూట\u{c4d}",
                "హ\u{c3e}ర\u{c4d}ట\u{c4d}\u{200c}లు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("таппон"),
            keywords: &["бозӣ", "корт", "таппон"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("โพแดง"),
            keywords: &["เกม", "โพแดง", "ไพ\u{e48}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("alma kart"),
            keywords: &["alma kart", "kart", "oýun"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("haati"),
            keywords: &["haati"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kupa"),
            keywords: &["iskambil", "kart", "kupa", "kör"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("تاپان"),
            keywords: &["ئويۇن", "تاپان", "قارتا"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("чирва"),
            keywords: &["гра", "карта", "масть", "чирва", "чирви"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("پان کا پتہ"),
            keywords: &["تاش", "پان", "پان کا پتہ", "پتہ", "کھیل"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("tappon kartasi"),
            keywords: &["karta", "o‘yin", "tappon kartasi", "yurak", "yuraklar"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bộ cơ"),
            keywords: &["bài", "bộ bài cơ", "bộ cơ", "trò chơi"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kër yépp"),
            keywords: &["kàrt", "kër yépp", "po"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isuti yentliziyo"),
            keywords: &["ikhadi", "isuti yentliziyo", "umdlalo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ìpín káàdì ọkàn"),
            keywords: &["eré", "káàdì", "ìpín káàdì ọkàn"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("紅心"),
            keywords: &["紅心", "紙牌", "遊戲"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("红心"),
            keywords: &["游戏", "红心", "纸牌"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("红桃"),
            keywords: &["扑克", "牌", "红心", "红桃"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("紅心"),
            keywords: &["紅心", "紙牌"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["啤牌", "紅心"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("unhliziyo"),
            keywords: &["ikhadi", "inhliziyo", "izinhliziyo", "umdlalo", "unhliziyo"],
        },
    ],
};
#[doc = "♦\u{fe0f}"]
pub const DIAMOND_SUIT: crate::Emoji = crate::Emoji {
    glyph: "♦\u{fe0f}",
    codepoint: "2666 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "diamond suit",
    group: "Activities",
    subgroup: "game",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "♦",
        codepoint: "2666",
        status: crate::Status::Unqualified,
        introduction_version: 0.6f32,
        name: "diamond suit",
        group: "Activities",
        subgroup: "game",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("diamante"),
            keywords: &["diamante", "kaart", "speletjie"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የካርታ አልማዝ"),
            keywords: &["አልማዝ", "ካርታ", "የካርታ አልማዝ", "የካርታ እሽግ", "ጨዋታ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ورقة لعب بشكل ماسة"),
            keywords: &["بطاقة", "لعب", "ماسة", "ورق", "ورقة لعب بشكل ماسة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ৰহিতন"),
            keywords: &["ক\u{9cd}ৰীড\u{9bc}\u{9be}", "ত\u{9be}\u{981}চখেল", "ৰহিতন"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("romb dəsti"),
            keywords: &["dəst", "kart", "oyun", "romb", "romb dəsti", "romblar"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("звонкі"),
            keywords: &["гульня", "звонкі", "карты"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("каро"),
            keywords: &["игра", "каро", "карта"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ড\u{9be}য\u{9bc}মন\u{9cd}ড স\u{9cd}য\u{9c1}ট"),
            keywords: &[
                "ক\u{9be}র\u{9cd}ড",
                "খেল\u{9be}",
                "ড\u{9be}য\u{9bc}মন\u{9cd}ড",
                "ড\u{9be}য\u{9bc}মন\u{9cd}ডস",
                "স\u{9cd}য\u{9c1}ট",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("karo"),
            keywords: &["karo", "karoenn", "kartenn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("karo"),
            keywords: &["igra", "karo", "karte", "znak"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("pal de diamants"),
            keywords: &["cartes", "diamants", "pal", "pal de diamants", "partida"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᎸᏉᏗ ᏅᏯ ᏧᏠᏱᎭ"),
            keywords: &["ᎠᏆᏂᏲᏍᏗ", "ᎦᎸᏉᏗ ᏅᏯ ᏧᏠᏱᎭ", "ᏗᏁᏟᏙᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("káry"),
            keywords: &["barva", "hra", "karta", "kára", "káry"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("siwt diemwntau"),
            keywords: &["cardiau", "diemwntau", "gêm", "siwt"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("ruder"),
            keywords: &["kort", "ruder", "spil"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Karo"),
            keywords: &["Karo", "Kartenspiel"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("καρό"),
            keywords: &["καρό", "παιχνίδι", "χαρτιά", "χρώμα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("diamond suit"),
            keywords: &["card", "diamond suit", "game"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["card", "diamond suit", "diamonds", "game"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("palo de diamantes"),
            keywords: &["carta", "diamantes", "juego", "palo", "palo de diamantes"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("diamantes"),
            keywords: &["cartas", "diamantes", "juegos", "naipes", "palos"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("ruutu"),
            keywords: &["kaart", "mast", "mäng", "ruutu"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("diamanteak"),
            keywords: &["diamante", "diamanteak", "joko", "karta", "palo"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("خال خشت"),
            keywords: &["بازی", "خال", "خشت", "کارت"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("ruutu"),
            keywords: &["kortti", "korttipeli", "maa", "ruutu"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("diamond"),
            keywords: &["baraha", "diamond", "sugal"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("rútari"),
            keywords: &["kort", "rútari"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("carreau"),
            keywords: &["carreau", "carreaux", "carte", "couleur", "jeu"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("dath muileata"),
            keywords: &["cluiche", "cárta", "dath", "muileata", "muileataí"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("dath daoimein"),
            keywords: &["cairt", "dath daoimein", "geama"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("rombos"),
            keywords: &["baralla francesa", "cartas", "rombo", "rombos", "xogos"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ચોકટન\u{ac1}\u{a82} પત\u{acd}ત\u{ac1}\u{a82}"),
            keywords: &[
                "કાર\u{acd}ડ",
                "ચોકટ",
                "ચોકટન\u{ac1}\u{a82} પત\u{acd}ત\u{ac1}\u{a82}",
                "પત\u{acd}ત\u{ac1}\u{a82}",
                "રમત",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("zubin zi"),
            keywords: &["kati", "wasa", "zubin zi"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("קלף יהלום"),
            keywords: &["יהלום", "משחק", "קלף"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ई\u{902}ट का पत\u{94d}ता"),
            keywords: &["ई\u{902}ट का पत\u{94d}ता", "कार\u{94d}ड", "ताश"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("karo"),
            keywords: &["igra", "karo", "karta"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("káró szín"),
            keywords: &["francia kártya", "játék", "káró", "szín"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("քյափ"),
            keywords: &["ագուռ", "թղթախաղ", "խաղ", "քյարփինջ", "քյափ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajik"),
            keywords: &["kartu", "permainan", "wajik"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("egwuregwu joka dịamọn"),
            keywords: &["egwuregwu", "egwuregwu joka dịamọn", "kaadị"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("tígull"),
            keywords: &["leikur", "spil", "spilalitur", "tigull", "tígull"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("quadri"),
            keywords: &["carte", "quadri", "seme"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ダイヤ"),
            keywords: &["カード", "ダイア", "ダイヤ", "トランプ"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kertu berlian"),
            keywords: &["game", "kertu", "kertu berlian"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("აგურები"),
            keywords: &["აგურები", "აგური", "ბანქო", "თამაში", "კარტი", "ფერი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қиық"),
            keywords: &["алмаз", "алмаздар", "карта", "ойын", "қиық"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("ruder"),
            keywords: &["kort", "ruder", "spil"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ការ\u{17bc} (ល\u{17d2}បែងបៀ)"),
            keywords: &[
                "ការ\u{17bc}",
                "ការ\u{17bc} (ល\u{17d2}បែងបៀ)",
                "បៀ",
                "ល\u{17d2}បែង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಡೈಮಂಡ\u{ccd} ಸ\u{cc2}ಟ\u{ccd}"),
            keywords: &[
                "ಆಟ",
                "ಕಾರ\u{ccd}ಡ\u{ccd}",
                "ಡೈಮಂಡ\u{ccd} ಸ\u{cc2}ಟ\u{ccd}",
                "ವಜ\u{ccd}ರ",
                "ಸ\u{cc2}ಟ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("다이아몬드"),
            keywords: &["다이아몬드", "카드 게임"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("डायम\u{902}ड स\u{942}ट"),
            keywords: &["ग\u{947}म", "डायम\u{902}ड स\u{942}ट", "पत\u{94d}त\u{947}"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("момун"),
            keywords: &["карта", "момун", "оюн"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Rauten"),
            keywords: &["Kaart", "Rauten", "Spill"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໂລ"),
            keywords: &["ຫ\u{ebc}\u{eb5}\u{ec9}ນ", "ໂລ", "ໄພ\u{ec9}"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("būgnai"),
            keywords: &["būgnai", "būgnas", "kortos", "žaidimas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("kāravs"),
            keywords: &["kāravs", "kārtis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("hūtu taimana"),
            keywords: &["hūtu taimana", "kāri", "kēmu"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("каро во карти"),
            keywords: &["дијамант", "игра", "каро", "каро во карти", "карти"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഡയമണ\u{d4d}ട\u{d4d} സ\u{d4d}യ\u{d42}ട\u{d4d}ട\u{d4d}"),
            keywords: &[
                "ക\u{d3e}ർഡ\u{d4d}",
                "ഗെയിം",
                "ഡയമണ\u{d4d}ട\u{d4d}",
                "ഡയമണ\u{d4d}ട\u{d4d}സ\u{d4d}",
                "സ\u{d4d}യ\u{d42}ട\u{d4d}ട\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хөзрийн дөрвөлжин"),
            keywords: &["дөрвөлжин", "тоглоом", "хөзрийн дөрвөлжин", "хөзөр"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("चौकट"),
            keywords: &["कार\u{94d}ड", "ग\u{947}म", "चौकट"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("daun daiman"),
            keywords: &["berlian", "daiman", "daun", "kad", "permainan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("taqsima tad-denari"),
            keywords: &["karta", "logħba", "taqsima tad-denari"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ချ\u{103d}န\u{103a}းဖ\u{1032}ချပ\u{103a}အတ\u{103d}\u{1032}"),
            keywords: &[
                "ချ\u{103d}န\u{103a}းဖ\u{1032}ချပ\u{103a}အတ\u{103d}\u{1032}",
                "ဂ\u{102d}မ\u{103a}း",
                "ဖ\u{1032}ချပ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("ruter"),
            keywords: &["diamant", "farge", "kort", "ruter", "spill"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("डायमन\u{94d}ड स\u{941}इट"),
            keywords: &["कार\u{94d}ड", "ख\u{947}ल", "डायमन\u{94d}ड स\u{941}इट"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("ruiten"),
            keywords: &["kaart", "ruiten", "spel"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("ruter"),
            keywords: &["diamant", "farge", "kort", "ruter", "spel"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଡ\u{b3e}ଏମଣ\u{b4d}ଡ ସ\u{b41}ଟ\u{b4d}\u{200d}"),
            keywords: &[
                "କ\u{b3e}ର\u{b4d}ଡ\u{b4d}",
                "ଖେଳ",
                "ଡ\u{b3e}ଏମଣ\u{b4d}ଡ ସ\u{b41}ଟ\u{b4d}\u{200d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਇ\u{a71}ਟ ਦ\u{a47} ਪ\u{a71}ਤ\u{a47}"),
            keywords: &[
                "ਇ\u{a71}ਟ ਦ\u{a47} ਪ\u{a71}ਤ\u{a47}",
                "ਗ\u{a47}ਮ",
                "ਤਾਸ\u{a3c}",
                "ਹੀਰਾ",
                "ਹੀਰ\u{a47}",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ہیرے دا لباس"),
            keywords: &["کارڈ", "کھیڈ", "ہیرے دا لباس"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Dáyámọnd Pléyín Kad"),
            keywords: &["Dáyámọnd Pléyín Kad", "Gem", "Kad"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("karo"),
            keywords: &["gra", "karo", "karta", "talia"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د الماس پته"),
            keywords: &["تاش", "د الماس پته", "لوبه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("naipe de ouros"),
            keywords: &[
                "baralho",
                "carta",
                "jogo",
                "naipe",
                "naipe de ouros",
                "ouro",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["carta", "jogo", "naipe", "naipe de ouros", "ouros"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("diamante tarhita"),
            keywords: &["diamante tarhita", "pukllay", "tarhita"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("caro"),
            keywords: &["caro", "cărți", "joc", "romb"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-079"),
            keywords: &["E10-079"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("бубны"),
            keywords: &["бубны", "игра", "карты", "масть"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikimenyetso cya diyama"),
            keywords: &["ikarita", "ikimenyetso cya diyama", "umukino"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڊائيمند سوٽ"),
            keywords: &["ڊائيمند سوٽ", "ڪارڊ، راند"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ද\u{dd2}යමන\u{dca}ත\u{dd2}ය"),
            keywords: &[
                "ක\u{dca}\u{200d}ර\u{dd3}ඩ\u{dcf}ව",
                "ක\u{dcf}ඩ\u{dca}",
                "ද\u{dd2}යමන\u{dca}ත\u{dd2}",
                "ද\u{dd2}යමන\u{dca}ත\u{dd2}ය",
                "ස\u{dd6}ට\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("káro"),
            keywords: &["farba", "hra", "karta", "kára", "káro"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("karo"),
            keywords: &["barva", "kari igra", "karo", "karta"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("dheemanka lebiska"),
            keywords: &["ciyaar", "dheemanka lebiska", "kaadh"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("figurë karo"),
            keywords: &["figurë", "karo", "letër", "lojë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("каро"),
            keywords: &["игрa", "кaрo", "кaртa", "каро"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("karo"),
            keywords: &["igra", "karo", "karta"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("ruter"),
            keywords: &["färg", "kort", "ruter"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kisu"),
            keywords: &["kadi", "karata", "kisu", "mchezo", "visu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("டைமன\u{bcd}ட\u{bcd} க\u{bbe}ர\u{bcd}டு"),
            keywords: &[
                "ச\u{bc0}ட\u{bcd}டு விளைய\u{bbe}டுதல\u{bcd}",
                "டைமன\u{bcd}ட\u{bcd} க\u{bbe}ர\u{bcd}டு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ప\u{c47}క\u{c3e}టల\u{c4b} డ\u{c48}మండ\u{c4d}"),
            keywords: &[
                "డ\u{c48}మండ\u{c4d}\u{200c}లు",
                "ప\u{c47}క\u{c3e}ట",
                "ప\u{c47}క\u{c3e}టల\u{c4b} డ\u{c48}మండ\u{c4d}",
                "సూట\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("хиштхол"),
            keywords: &["бозӣ", "корт", "хиштхол"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ข\u{e49}าวหลามต\u{e31}ด"),
            keywords: &["ข\u{e49}าวหลามต\u{e31}ด", "เกม", "ไพ\u{e48}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("kerpiç kart"),
            keywords: &["kart", "kerpiç kart", "oýun"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("taimani"),
            keywords: &["taimani"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("karo"),
            keywords: &["iskambil", "karo", "kart"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("غىچ"),
            keywords: &["ئويۇن", "غىچ", "قارتا"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("бубна"),
            keywords: &["бубна", "бубни", "гра", "карта", "масть"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("اینٹ کا پتہ"),
            keywords: &["اینٹ", "اینٹ کا پتہ", "تاش", "پتہ", "کھیل"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("g‘ishtin kartasi"),
            keywords: &[
                "g‘ishtin kartasi",
                "karta",
                "o‘yin",
                "qarta",
                "q‘ishtin",
                "romb",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bộ rô"),
            keywords: &["bài", "bộ bài rô", "bộ rô", "trò chơi"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("karo yépp"),
            keywords: &["karo yépp", "kàrt", "po"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isuti yedayimani"),
            keywords: &["ikhadi", "isuti yedayimani", "umdlalo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ìpín káàdì díámọ\u{301}ndì"),
            keywords: &["eré", "káàdì", "ìpín káàdì díámọ\u{301}ndì"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("階磚"),
            keywords: &["紙牌", "遊戲", "階磚"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("阶砖"),
            keywords: &["游戏", "纸牌", "阶砖"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("方片"),
            keywords: &["扑克", "方块", "方片", "牌"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("方塊"),
            keywords: &["方塊", "紙牌"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("階磚"),
            keywords: &["啤牌", "階磚"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("okumise okwedayimane"),
            keywords: &[
                "amadayimane",
                "idayimane",
                "ikhadi",
                "okumise okwedayimane",
                "umdlalo",
            ],
        },
    ],
};
#[doc = "♣\u{fe0f}"]
pub const CLUB_SUIT: crate::Emoji = crate::Emoji {
    glyph: "♣\u{fe0f}",
    codepoint: "2663 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "club suit",
    group: "Activities",
    subgroup: "game",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "♣",
        codepoint: "2663",
        status: crate::Status::Unqualified,
        introduction_version: 0.6f32,
        name: "club suit",
        group: "Activities",
        subgroup: "game",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("klawers"),
            keywords: &["kaart", "klawers", "speletjie"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የካርታ አበባ"),
            keywords: &["አበቦች", "ካርታ", "የካርታ አበባ", "የካርታ እሽግ", "ጨዋታ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ورقة لعب بشكل شجرة"),
            keywords: &["سباتي", "شجرة", "كوتشينة", "ورق لعب", "ورقة لعب بشكل شجرة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("শ\u{9cd}বিৰ\u{9cd}ত\u{9cd}তন"),
            keywords: &[
                "ক\u{9cd}ৰীড\u{9bc}\u{9be}",
                "ত\u{9be}\u{981}চখেল",
                "শ\u{9cd}বিৰ\u{9cd}ত\u{9cd}তন",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("klub dəsti"),
            keywords: &["dəst", "kart", "klub", "klub dəsti", "klublar", "oyun"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("трэфы"),
            keywords: &["гульня", "карта", "трэфы", "хрэсці"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("спатия"),
            keywords: &["игра", "карта", "спатия"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ক\u{9cd}ল\u{9be}ব স\u{9cd}য\u{9c1}ট"),
            keywords: &[
                "ক\u{9be}র\u{9cd}ড",
                "ক\u{9cd}ল\u{9be}ব",
                "ক\u{9cd}ল\u{9be}বস",
                "গেম",
                "স\u{9cd}য\u{9c1}ট",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("treflez"),
            keywords: &["kartenn", "treflez", "treflezenn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("tref"),
            keywords: &["igra", "karte", "tref", "znak"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("pal de trèvols"),
            keywords: &["carta", "pal", "pal de trèvols", "partida", "trèvols"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᏓᏍᏆᎸᏂᏍᏗ ᏧᏠᏱᎭ"),
            keywords: &["ᎠᏆᏂᏲᏍᏗ", "ᏗᏁᏟᏙᏗ", "ᏗᏓᏍᏆᎸᏂᏍᏗ ᏧᏠᏱᎭ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("kříže"),
            keywords: &["barva", "hra", "karta", "kříž", "kříže"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("siwt clybiau"),
            keywords: &["cardiau", "clybiau", "gêm", "siwt"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("klør"),
            keywords: &["klør", "kort", "spil"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Kreuz"),
            keywords: &["Kartenspiel", "Kreuz"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σπαθί"),
            keywords: &["παιχνίδι", "σπαθί", "σπαθιά", "χαρτιά", "χρώμα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("club suit"),
            keywords: &["card", "club suit", "game"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["card", "club suit", "clubs", "game"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("palo de tréboles"),
            keywords: &["carta", "juego", "palo", "palo de tréboles", "tréboles"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("tréboles"),
            keywords: &["cartas", "juegos", "naipes", "palos", "tréboles"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("risti"),
            keywords: &["kaart", "mast", "mäng", "risti"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("hirustak"),
            keywords: &["hirusta", "hirustak", "joko", "karta", "klub", "palo"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("خال گشنیز"),
            keywords: &["بازی", "خال", "کارت", "گشنیز"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("risti"),
            keywords: &["kortti", "korttipeli", "maa", "risti"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("club"),
            keywords: &["baraha", "club", "sugal"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("kleyvari"),
            keywords: &["kleyvari", "kort"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("trèfle cartes"),
            keywords: &["couleur", "jeu", "trèfle", "trèfle cartes"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("trèfle"),
            keywords: &["carte", "couleur", "jeu", "trèfle"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("dath truif"),
            keywords: &[
                "cluiche",
                "cárta",
                "dath",
                "dath club",
                "dath truif",
                "triuf",
                "triufanna",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("dath club"),
            keywords: &["cairt", "dath club", "geama"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("trevos"),
            keywords: &["baralla francesa", "cartas", "trevo", "trevos", "xogos"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ફ\u{ac1}લ\u{ac7}વરન\u{ac1}\u{a82} પત\u{acd}ત\u{ac1}\u{a82}"),
            keywords: &[
                "કાર\u{acd}ડ",
                "ફ\u{ac1}લ\u{ac7}વર",
                "ફ\u{ac1}લ\u{ac7}વરન\u{ac1}\u{a82} પત\u{acd}ત\u{ac1}\u{a82}",
                "રમત",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("zubin kuri"),
            keywords: &["kati", "wasa", "zubin kuri"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("קלף תלתן"),
            keywords: &["משחק", "קלף", "תלתן"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("चिड\u{93c}िया का पत\u{94d}ता"),
            keywords: &["कार\u{94d}ड", "चिड\u{93c}िया का पत\u{94d}ता", "ताश"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("tref"),
            keywords: &["igra", "karta", "tref"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("treff szín"),
            keywords: &["francia kártya", "játék", "szín", "treff"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("խաչ"),
            keywords: &["թղթախաղ", "խաղ", "խաչ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("keriting"),
            keywords: &["kartu", "keriting", "klub", "permainan"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("egwuregwu joka klọb"),
            keywords: &["egwuregwu", "egwuregwu joka klọb", "kaadị"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("lauf"),
            keywords: &["lauf", "leikur", "spil", "spilalitur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("fiori"),
            keywords: &["carte", "fiori", "seme"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("クラブ"),
            keywords: &["カード", "クラブ", "クローバー", "トランプ"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kertu waru"),
            keywords: &["game", "kertu", "kertu waru"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ჯვრები"),
            keywords: &["ბანქო", "თამაში", "კარტი", "ფერი", "ჯვარი", "ჯვრები"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("шыбын"),
            keywords: &["карта", "ойын", "шыбын", "шыбындар"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("klør"),
            keywords: &["klør", "kort", "spil"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ជ\u{17bd}ង\u{200b} (ល\u{17d2}បែងបៀ)"),
            keywords: &[
                "ជ\u{17bd}ង",
                "ជ\u{17bd}ង\u{200b} (ល\u{17d2}បែងបៀ)",
                "បៀ",
                "ល\u{17d2}បែង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕ\u{ccd}ಲಬ\u{ccd} ಸ\u{cc2}ಟ\u{ccd}"),
            keywords: &[
                "ಕ\u{ccd}ಲಬ\u{ccd}",
                "ಕ\u{ccd}ಲಬ\u{ccd} ಸ\u{cc2}ಟ\u{ccd}",
                "ಕ\u{ccd}ಲಬ\u{ccd}\u{200c}ಗಳು",
                "ಗೇಮ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("클럽"),
            keywords: &["카드 게임", "클럽"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("क\u{94d}लब स\u{942}ट"),
            keywords: &["क\u{94d}लब स\u{942}ट", "ग\u{947}म", "पत\u{94d}त\u{947}"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("чырым"),
            keywords: &["карта", "оюн", "чырым"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Kräizer"),
            keywords: &["Kaart", "Kräizer", "Spill"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຈ\u{ec8}ວນ"),
            keywords: &["ຈ\u{ec8}ວນ", "ຫ\u{ebc}\u{eb5}\u{ec9}ນ", "ໄພ\u{ec9}"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("kryžiai"),
            keywords: &["kortos", "kryžiai", "žaidimas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("kreicis"),
            keywords: &["kreicis", "kārtis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("hūtu karapu"),
            keywords: &["hūtu karapu", "kāri", "kēmu"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("треф во карти"),
            keywords: &["детелина", "игра", "карти", "треф", "треф во карти"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ക\u{d4d}ലബ\u{d4d} സ\u{d4d}യ\u{d42}ട\u{d4d}ട\u{d4d}"),
            keywords: &[
                "ക\u{d3e}ർഡ\u{d4d}",
                "ക\u{d4d}ലബ\u{d4d}",
                "ക\u{d4d}ലബ\u{d4d}\u{200c}സ\u{d4d}",
                "ഗെയിം",
                "സ\u{d4d}യ\u{d42}ട\u{d4d}ട\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хөзрийн цэцэг"),
            keywords: &["тоглоом", "хөзрийн цэцэг", "хөзөр", "цэцэг"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("किलवर"),
            keywords: &["कार\u{94d}ड", "किलवर", "ग\u{947}म"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("daun kelawar"),
            keywords: &["daun", "kad", "kelab", "kelawar", "permainan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("taqsima tal-fjuri"),
            keywords: &["karta", "logħba", "taqsima tal-fjuri"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ည\u{103e}င\u{103a}းဖ\u{1032}ချပ\u{103a}အတ\u{103d}\u{1032}"),
            keywords: &[
                "ဂ\u{102d}မ\u{103a}း",
                "ည\u{103e}င\u{103a}းဖ\u{1032}ချပ\u{103a}အတ\u{103d}\u{1032}",
                "ဖ\u{1032}ချပ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kløver"),
            keywords: &["farge", "kløver", "kort", "spill"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("क\u{94d}लब स\u{941}इट"),
            keywords: &["कार\u{94d}ड", "क\u{94d}लब स\u{941}इट", "ख\u{947}ल"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("klaveren"),
            keywords: &["kaart", "klaveren", "spel"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kløver"),
            keywords: &["farge", "kløver", "kort", "spel"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କ\u{b4d}ଲବ\u{b4d}\u{200d} ସ\u{b41}ଟ\u{b4d}\u{200d}"),
            keywords: &[
                "କ\u{b3e}ର\u{b4d}ଡ\u{b4d} । ଖେଳ",
                "କ\u{b4d}ଲବ\u{b4d}\u{200d} ସ\u{b41}ଟ\u{b4d}\u{200d}",
                "ଖେଳ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਚਿੜੀਏ ਦ\u{a47} ਪ\u{a71}ਤ\u{a47}"),
            keywords: &[
                "ਕਾਰਡ",
                "ਗ\u{a47}ਮ",
                "ਚਿੜੀਏ ਦ\u{a47} ਪ\u{a71}ਤ\u{a47}",
                "ਤਾਸ\u{a3c}",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کلب دا لباس"),
            keywords: &["کارڈ", "کلب دا لباس", "کھیڈ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Klọb Pléyín Kad"),
            keywords: &["Gem", "Kad", "Klọb Pléyín Kad"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("trefl"),
            keywords: &["gra", "karta", "talia", "trefl"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د کلب پته"),
            keywords: &["تاش", "د کلب پته", "لوبه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("naipe de paus"),
            keywords: &["baralho", "carta", "jogo", "naipe", "naipe de paus", "paus"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["carta", "jogo", "naipe", "naipe de paus", "paus"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("trebol tarhita"),
            keywords: &["pukllay", "tarhita", "trebol tarhita"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("treflă"),
            keywords: &["cărți", "joc", "treflă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-077"),
            keywords: &["E10-077"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("трефы"),
            keywords: &["игра", "карты", "масть", "трефы"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikimenyetso cyo ku ikarita cy’umusaraba"),
            keywords: &[
                "ikarita",
                "ikimenyetso cyo ku ikarita cy’umusaraba",
                "umukino",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪلب سوٽ"),
            keywords: &["ڪارڊ، راند", "ڪلب سوٽ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කල\u{dcf}බර"),
            keywords: &[
                "කල\u{dcf}බර",
                "ක\u{dca}ලබ\u{dca} ස\u{dd6}ට\u{dca}",
                "ක\u{dca}\u{200d}ර\u{dd3}ඩ\u{dcf}ව",
                "ක\u{dcf}ඩ\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("kríž"),
            keywords: &["farba", "hra", "karta", "kríž", "trojlístky", "trojlístok"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("križ"),
            keywords: &["barva", "igra", "karta", "križ", "križi"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("lebiska naadiga"),
            keywords: &["ciyaar", "kaadh", "lebiska naadiga"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("figura spathi"),
            keywords: &["figura spathi", "figurë", "letër", "lojë", "spathi"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("треф"),
            keywords: &["игрa", "кaртa", "трeф", "треф"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("tref"),
            keywords: &["igra", "karta", "tref"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("klöver"),
            keywords: &["färg", "klöver", "kort"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("maua"),
            keywords: &["kadi", "karata", "maua", "mchezo"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கிளப\u{bcd} க\u{bbe}ர\u{bcd}டு"),
            keywords: &[
                "கிளப\u{bcd} க\u{bbe}ர\u{bcd}டு",
                "ச\u{bc0}ட\u{bcd}டு விளைய\u{bbe}டுதல\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ప\u{c47}క\u{c3e}టల\u{c4b} క\u{c4d}లబ\u{c4d}"),
            keywords: &[
                "క\u{c4d}లబ\u{c4d}\u{200c}లు",
                "ప\u{c47}క\u{c3e}ట",
                "ప\u{c47}క\u{c3e}టల\u{c4b} క\u{c4d}లబ\u{c4d}",
                "సూట\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("чилликхол"),
            keywords: &["бозӣ", "корт", "чилликхол"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ดอกจ\u{e34}ก"),
            keywords: &["ดอกจ\u{e34}ก", "เกม", "ไพ\u{e48}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("jydak kart"),
            keywords: &["jydak kart", "kart", "oýun"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kalapa"),
            keywords: &["kalapa"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("sinek"),
            keywords: &["iskambil", "kart", "sinek", "trefl"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("چىتتىر"),
            keywords: &["ئويۇن", "قارتا", "چىتتىر"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("трефа"),
            keywords: &["гра", "карта", "масть", "трефа", "трефи"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("چڑیا کا پتہ"),
            keywords: &["تاش", "پتہ", "چڑیا", "چڑیا کا پتہ", "کھیل"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("chillik kartasi"),
            keywords: &["chillik", "chillik kartasi", "karta", "o‘yin"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bộ nhép"),
            keywords: &["bài", "bộ bài nhép", "bộ nhép", "trò chơi"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("treefal yépp"),
            keywords: &["kàrt", "po", "treefal yépp"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isuti yeklabhu"),
            keywords: &["ikhadi", "isuti yeklabhu", "umdlalo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ìpín káàdì ewé"),
            keywords: &["eré", "káàdì", "ìpín káàdì ewé"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("梅花"),
            keywords: &["梅花", "紙牌", "遊戲"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("梅花"),
            keywords: &["梅花", "游戏", "纸牌"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("梅花"),
            keywords: &["扑克", "梅花", "牌", "草花"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("梅花"),
            keywords: &["梅花", "紙牌"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["啤牌", "梅花"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umpukane"),
            keywords: &["ikhadi", "izimpukane", "umdlalo", "umpukane"],
        },
    ],
};
#[doc = "♟\u{fe0f}"]
pub const CHESS_PAWN: crate::Emoji = crate::Emoji {
    glyph: "♟\u{fe0f}",
    codepoint: "265F FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "chess pawn",
    group: "Activities",
    subgroup: "game",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "♟",
        codepoint: "265F",
        status: crate::Status::Unqualified,
        introduction_version: 11f32,
        name: "chess pawn",
        group: "Activities",
        subgroup: "game",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("skaakpion"),
            keywords: &["mislei", "opofferbaar", "skaak", "skaakpion"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የቼዝ መጫወቻ"),
            keywords: &["ሞኝ", "ቼዝ", "አላቂ", "የቼዝ መጫወቻ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("بيدق"),
            keywords: &["بيدق", "جندي", "شطرنج", "ضعيف"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("দব\u{9be} গ\u{9c1}টি"),
            keywords: &[
                "দব\u{9be} খেল",
                "দব\u{9be} গ\u{9c1}টি",
                "প\u{9cd}ৰত\u{9be}ৰণ\u{9be}",
                "ব\u{9cd}যয\u{9bc}বহ\u{9c1}ল",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("şahmat piyadası"),
            keywords: &["genişlənən", "şahmat", "şahmat piyadası", "əfəl"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("пешка"),
            keywords: &["дробязь", "пешка", "шахматы"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("пешка"),
            keywords: &[
                "маловажна фигура",
                "незначителен човек",
                "пешка",
                "фигура за шах",
                "шах",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("দ\u{9be}ব\u{9be} গ\u{9c1}টি"),
            keywords: &[
                "ছলন\u{9be}",
                "দ\u{9be}ব\u{9be}",
                "দ\u{9be}ব\u{9be} গ\u{9c1}টি",
                "বর\u{9cd}ধনশীল",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("pezh echedoù"),
            keywords: &["echedoù", "pezh"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("pješak"),
            keywords: &["pijun", "pješak", "potrošni", "šah"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("peó d’escacs"),
            keywords: &["escacs", "peó d’escacs", "prescindible", "sacrificable"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏤᎡᏍ ᎠᎦᏘᏗᏍᏙᏗ"),
            keywords: &["ᎦᎶᎾᏍᏗ", "ᏤᎡᏍ", "ᏤᎡᏍ ᎠᎦᏘᏗᏍᏙᏗ", "ᏫᏓᏲᎯᏍᏗᏭ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("pěšec"),
            keywords: &["figurka", "pión", "pěšec", "pěšák", "šachy"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("gwerinwr gwyddbwyll"),
            keywords: &["gwariadwy", "gwerinwr gwyddbwyll", "gwyddbwyll", "twyllo"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("skakbrik"),
            keywords: &["bonde", "skak", "skakbrik", "undværlig"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Bauer Schach"),
            keywords: &["Bauer Schach", "Schach"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πιόνι σκακιού"),
            keywords: &["αναλώσιμος", "εξαπατώ", "πιόνι σκακιού", "σκάκι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("chess pawn"),
            keywords: &["chess", "chess pawn", "dupe", "expendable"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("peón de ajedrez"),
            keywords: &["ajedrez", "peón", "peón de ajedrez"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("peón (ajedrez)"),
            keywords: &["ajedrez", "peón (ajedrez)"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("ettur"),
            keywords: &["ettur", "kõrvalejäetav", "male", "tüssamine"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("peoi"),
            keywords: &["ez nahitaezko", "peoi", "trikimailu", "xake"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پیاده شطرنج"),
            keywords: &["شطرنج", "فداکردنی", "فریب\u{200c}خورده", "پیاده شطرنج"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("šakkipelin sotilas"),
            keywords: &[
                "nappula",
                "pelinappula",
                "punapaita",
                "sotilas",
                "uhrattavissa",
                "šakki",
                "šakkipelin sotilas",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("chess pawn"),
            keywords: &["chess", "pawn"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("finna"),
            keywords: &["finna", "talv"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("pion d’échec"),
            keywords: &["duper", "pion d’échec", "sacrifiable", "échec"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("pion"),
            keywords: &["duper", "pion", "sacrifiable", "échec"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("fichillín"),
            keywords: &["ficheall", "fichillín", "glasóg", "indiúscartha"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("pàn tàileisg"),
            keywords: &[
                "blath-laoghan",
                "blath-raoghan",
                "culaidh-mheallaidh",
                "meall",
                "neo-chudromach",
                "pàn tàileisg",
                "tàileasg",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("peón de xadrez"),
            keywords: &["incauto", "peón de xadrez", "prescindible", "xadrez"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ચ\u{ac7}સન\u{ac1}\u{a82} પ\u{acd}યાદ\u{ac1}"),
            keywords: &[
                "ચ\u{ac7}સ",
                "ચ\u{ac7}સન\u{ac1}\u{a82} પ\u{acd}યાદ\u{ac1}",
                "ડ\u{acd}ય\u{ac2}પ",
                "પ\u{acd}રાયોજ\u{acd}ય",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פיון בשחמט"),
            keywords: &["פיון", "פיון בשחמט", "רגלי", "שח", "שחמט"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("शतर\u{902}ज का प\u{94d}यादा"),
            keywords: &["प\u{94d}यादा", "शतर\u{902}ज का प\u{94d}यादा"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("šahovski pješak"),
            keywords: &["pijun", "potrošno", "šah", "šahovski pješak"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("gyalog"),
            keywords: &["feláldozható", "gyalog", "paraszt", "sakk"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("շախմատի զինվոր"),
            keywords: &["զինվոր", "շախմատ", "շախմատի զինվոր", "ֆիգուր"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("pion catur"),
            keywords: &["anak buah", "catur", "pion"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("taflpeð"),
            keywords: &["fórn", "peð", "skák", "tafl", "taflpeð"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("pedina degli scacchi"),
            keywords: &[
                "pedina",
                "pedina degli scacchi",
                "sacrificabile",
                "scacchi",
                "scacco matto",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("チェスの駒"),
            keywords: &["チェス", "チェスの駒", "捨て駒", "駒"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("pion"),
            keywords: &["bisa dibuwang", "catur", "dupe", "pion"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("პაიკი"),
            keywords: &["გაწირვადი", "პაიკი", "ჭადრაკი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("пешка"),
            keywords: &["алдау", "бір реттік", "пешка", "шахмат"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ត\u{17d2}រ\u{17b8}ក\u{17d2}ន\u{17bb}ងល\u{17d2}បែងអ\u{17bb}ក"),
            keywords: &[
                "ក\u{17bc}នអ\u{17bb}ក",
                "ត\u{17d2}រ\u{17b8}ក\u{17d2}ន\u{17bb}ងល\u{17d2}បែងអ\u{17bb}ក",
                "ល\u{17d2}បែងអ\u{17bb}ក",
                "អាចបោះបង\u{17cb}ចោលបាន",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಚ\u{cc6}ಸ\u{ccd} ಪಾನ\u{ccd}"),
            keywords: &[
                "ಖರ\u{ccd}ಚು ಮಾಡುವಂತಹ",
                "ಚ\u{cc6}ಸ\u{ccd}",
                "ಚ\u{cc6}ಸ\u{ccd} ಪಾನ\u{ccd}",
                "ಡ\u{ccd}ಯ\u{cc2}ಪ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("체스 폰"),
            keywords: &["소모품", "체스 말", "체스 폰", "폰"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ब\u{941}ध\u{94d}दीबळाचो पट"),
            keywords: &[
                "ड\u{941}प",
                "ब\u{941}ध\u{94d}दीबळ",
                "ब\u{941}ध\u{94d}दीबळाचो पट",
                "विस\u{94d}तारीत",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("пешка"),
            keywords: &["алдоо", "бир жолу колдонулуучу", "пешка", "шахмат"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໝາກລ\u{eb8}ກ"),
            keywords: &[
                "ລ\u{ecd}\u{ec9}",
                "ເສ\u{eb7}\u{ec9}ອແດງ",
                "ໃຊ\u{ec9}ໄດ\u{ec9}",
                "ໝາກລ\u{eb8}ກ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("šachmatų pėstininkas"),
            keywords: &[
                "naivuolis",
                "paaukotinas",
                "šachmatai",
                "šachmatų pėstininkas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("bandinieks"),
            keywords: &["bandinieks", "kopija", "lietojams", "šahs"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("шаховски пион"),
            keywords: &["жртва", "измама", "шах", "шаховски пион"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ചത\u{d41}രംഗത\u{d4d}തിലെ ക\u{d3e}ല\u{d3e}ൾ"),
            keywords: &[
                "എക\u{d4d}\u{200c}സ\u{d4d}\u{200c}പെൻഡബിൾ",
                "ചത\u{d41}രംഗം",
                "ചത\u{d41}രംഗത\u{d4d}തിലെ ക\u{d3e}ല\u{d3e}ൾ",
                "ഡ\u{d4d}യ\u{d42}പ\u{d4d}പ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("шатрын хүү"),
            keywords: &["хууртсан", "хэрэгцээгүй болсон", "шатар", "шатрын хүү"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("च\u{947}सपॉन"),
            keywords: &[
                "एक\u{94d}सप\u{947}\u{902}ड\u{947}बल",
                "च\u{947}स",
                "च\u{947}सपॉन",
                "ड\u{94d}य\u{942}प",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bidak catur"),
            keywords: &["bidak catur", "boleh kembang", "catur", "memperdaya"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("နယ\u{103a}စား"),
            keywords: &[
                "စစ\u{103a}တ\u{102f}ရင\u{103a}",
                "နယ\u{103a}စား",
                "လ\u{103e}ည\u{1037}\u{103a}စားခြင\u{103a}း",
                "အကျယ\u{103a}ချ\u{1032}\u{1037}န\u{102d}\u{102f}င\u{103a}ခြင\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("bonde"),
            keywords: &["bonde", "brikke", "sjakk"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("च\u{947}स ख\u{947}लको सिपाही गोटी"),
            keywords: &[
                "गौ\u{901}ण",
                "च\u{947}स ख\u{947}ल",
                "च\u{947}स ख\u{947}लको सिपाही गोटी",
                "सजिल\u{948} छलिन\u{947} व\u{94d}यक\u{94d}ति",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("pion"),
            keywords: &["pion", "schaken", "slachtoffer", "waardeloos"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("bonde"),
            keywords: &["bonde", "brikke", "sjakk"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସତରଞ\u{b4d}ଜ ପ\u{b4d}ୟ\u{b3e}ଦ\u{b3e}"),
            keywords: &[
                "ଧୋଖ\u{b3e}",
                "ବ\u{b3f}ସ\u{b4d}ତ\u{b3e}ର\u{b3f}ତ",
                "ସତରଞ\u{b4d}ଜ",
                "ସତରଞ\u{b4d}ଜ ପ\u{b4d}ୟ\u{b3e}ଦ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸ\u{a3c}ਤਰ\u{a70}ਜ ਦਾ ਪਿਆਦਾ"),
            keywords: &[
                "ਖਰਚਣਯ\u{a4b}ਗ",
                "ਧ\u{a4b}ਖਾ",
                "ਸ\u{a3c}ਤਰ\u{a70}ਜ",
                "ਸ\u{a3c}ਤਰ\u{a70}ਜ ਦਾ ਪਿਆਦਾ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Chẹ\u{301}s Pọn"),
            keywords: &[
                "Chẹs",
                "Chẹ\u{301}s Pọn",
                "Diup",
                "Nọ\u{301} Dé Impọ\u{301}tant",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("pionek"),
            keywords: &["pionek", "szachy"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د سترنج ګوټک"),
            keywords: &["تېرايستل", "د سترنج ګوټک", "سترنج", "غځېدونکی"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("peão de xadrez"),
            keywords: &["peão", "peão de xadrez", "truque", "xadrez"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["dispensável", "peão", "peão de xadrez", "xadrez"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("pion de șah"),
            keywords: &["consumabil", "de sacrificiu", "pion de șah", "șah"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E11-001"),
            keywords: &["E11-001"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("пешка"),
            keywords: &["игра", "пешка", "фигура", "шахматная фигура", "шахматы"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("چيس جو پيادو"),
            keywords: &["وڌائڻ لائق", "وڌائڻ لائقچيس", "چيس", "چيس جو پيادو", "ڊيوپ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("චෙස\u{dca} ඉත\u{dca}ත\u{dcf}"),
            keywords: &[
                "ඉත\u{dca}ත\u{dcf}",
                "චෙස\u{dca}",
                "ව\u{dd2}යදම\u{dca} කළ හැක\u{dd2}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("pešiak"),
            keywords: &["figúrka", "pešiak", "šach"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("kmet pri šahu"),
            keywords: &["kmet pri šahu", "pogrešljiv", "tepček", "šah"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("jarta fiyooraha"),
            keywords: &["jar", "jarta fiyooraha", "qiyaano", "saanqaade"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("gur shahu"),
            keywords: &["gur shahu", "shah"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("шаховски пешак"),
            keywords: &["пион", "потрошан", "шах", "шаховски пешак"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("шаховски пјешак"),
            keywords: &["шаховски пјешак"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("šahovski pešak"),
            keywords: &["pion", "potrošan", "šah", "šahovski pešak"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("šahovski pješak"),
            keywords: &["šahovski pješak"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("schackbonde"),
            keywords: &["schack", "schackbonde", "utbytbar"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kipande cha saratanji"),
            keywords: &[
                "danganya",
                "kipande cha saratanji",
                "saratanji",
                "toa mhanga",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சதுரங\u{bcd}கச\u{bcd} சிப\u{bcd}ப\u{bbe}ய\u{bcd}"),
            keywords: &[
                "சதுரங\u{bcd}கச\u{bcd} சிப\u{bcd}ப\u{bbe}ய\u{bcd}",
                "சதுரங\u{bcd}கம\u{bcd}",
                "செஸ\u{bcd}",
                "திய\u{bbe}கம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("చదరంగంల\u{c4b} బంటు"),
            keywords: &[
                "చదరంగం",
                "చదరంగంల\u{c4b} బంటు",
                "నక\u{c3f}ల\u{c40}",
                "మ\u{c3f}గ\u{c3f}ల\u{c3f}నద\u{c3f}",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หมากร\u{e38}ก"),
            keywords: &["หมากร\u{e38}ก", "เกม", "เบ\u{e35}\u{e49}ย"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("küşt pyýadasy"),
            keywords: &["aldaw", "küşt", "küşt pyýadasy", "ulanylyp bilinýän"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("pate veimau"),
            keywords: &["pate veimau"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("piyon"),
            keywords: &["harcanabilir", "kullanılma", "piyon", "satranç"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("пішак"),
            keywords: &["пішак", "пішка", "фігура", "шахи", "шахмати"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("شطرنج کا پیادہ"),
            keywords: &["شطرنج", "شطرنج کا پیادہ", "قابل مصرف", "مہرہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("piyoda"),
            keywords: &[
                "dona",
                "piyoda",
                "shaxmat",
                "shaxmat donasi",
                "shaxmat toshlari",
                "toshlar",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("quân tốt"),
            keywords: &["bịp", "cờ", "quân tốt", "thí tốt", "tốt"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("國際象棋棋子"),
            keywords: &["國際象棋", "國際象棋棋子", "消閒"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("国际象棋棋子"),
            keywords: &["国际象棋", "国际象棋棋子", "消闲"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("兵"),
            keywords: &["兵", "受骗者", "国际象棋", "牺牲品"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("卒"),
            keywords: &["卒", "戰略", "棋子", "鬥智"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("兵"),
            keywords: &["兵", "戰略", "棋子", "鬥智"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("E11:001"),
            keywords: &["E11:001"],
        },
    ],
};
#[doc = "🃏"]
pub const JOKER: crate::Emoji = crate::Emoji {
    glyph: "🃏",
    codepoint: "1F0CF",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "joker",
    group: "Activities",
    subgroup: "game",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("joker"),
            keywords: &["joker", "kaart", "speel"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የካርታ ጆከር"),
            keywords: &["በመጫወት ላይ", "ካርታ", "የካርታ ጆከር", "ጨዋታ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("جوكر"),
            keywords: &["أوراق", "جوكر", "لعبة", "ورقة", "يلعب"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("জ’ক\u{9be}ৰ"),
            keywords: &[
                "ক\u{9cd}ৰীড\u{9bc}\u{9be}",
                "জ’ক\u{9be}ৰ",
                "ত\u{9be}\u{981}চখেল",
                "ৱ\u{9be}ইল\u{9cd}ড ক\u{9be}ৰ\u{9cd}ড",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("joker"),
            keywords: &["joker", "kart", "oynamaq", "oyun"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("джокер"),
            keywords: &["азарт", "гульня", "джокер", "карта"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("жокер"),
            keywords: &["жокер", "игра", "карта"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("জোক\u{9be}র"),
            keywords: &[
                "ক\u{9be}র\u{9cd}ড",
                "খেল\u{9be}",
                "জোক\u{9be}র",
                "ত\u{9be}স",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("joker"),
            keywords: &["joker", "kartenn joker"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("džoker"),
            keywords: &["džoker", "igra", "karte"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("comodí"),
            keywords: &["carta", "comodí", "partida"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᏪᏟᏍᎩ"),
            keywords: &["ᎠᏆᏂᏲᏍᏗ", "ᎦᏪᏟᏍᎩ", "ᎨᏯᏔᎯ ᏆᏂᏲᏍᏗ", "ᏗᏁᏟᏙᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("žolík"),
            keywords: &["divoká", "hra", "karta", "karty", "žolík"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cellweiriwr"),
            keywords: &["cardiau", "cellweiriwr", "chwarae", "gêm"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("joker"),
            keywords: &["joker", "kort", "spillekort"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Jokerkarte"),
            keywords: &["Joker", "Jokerkarte", "Spielkarte"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("τζόκερ"),
            keywords: &["παίζω", "παιχνίδι", "τζόκερ", "χαρτιά"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("joker"),
            keywords: &["card", "game", "joker", "wildcard"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("comodín"),
            keywords: &["comodín", "joker"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("carta comodín"),
            keywords: &["carta", "comodín", "naipes"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("jokker"),
            keywords: &["jokker", "kaart", "mäng"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("komodina"),
            keywords: &["joko", "jolastu", "karta", "komodina"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("جوکر"),
            keywords: &["بازی", "جوکر", "شیطان", "کارت"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("jokeri"),
            keywords: &["jokeri", "kortti", "korttipeli"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("joker"),
            keywords: &["baraha", "joker", "sugal"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("jokari"),
            keywords: &["jokari", "kort"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("carte Joker"),
            keywords: &["Joker", "carte Joker", "jeu"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("joker"),
            keywords: &["carte", "jeu", "joker"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("fear na gcrúb"),
            keywords: &[
                "Fear na gcrúb",
                "an buachaill mór",
                "cárta",
                "cárta imeartha",
                "fear na gcrúb",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("amadan"),
            keywords: &["amadan", "cairt", "geama", "saorag"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("comodín"),
            keywords: &["baralla francesa", "cartas", "comodín", "xogos"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("જોકર"),
            keywords: &[
                "ગ\u{a82}જીફાન\u{ac1}\u{a82} પત\u{acd}ત\u{ac1}\u{a82}",
                "ગ\u{a82}જીફો",
                "જોકર",
                "જોકરન\u{ac1}\u{a82} પત\u{acd}ત\u{ac1}\u{a82}",
                "પત\u{acd}તા\u{a82}",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("joka"),
            keywords: &["joka", "kati", "wasa", "wildcard"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("ג׳וקר"),
            keywords: &["ג׳וקר", "משחק", "קלף"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("जोकर कार\u{94d}ड"),
            keywords: &["कार\u{94d}ड", "जोकर", "ताश का पत\u{94d}ता"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("džoker"),
            keywords: &["džoker", "igra", "kartanje", "karte"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("dzsóker"),
            keywords: &["dzsóker", "francia kártya", "játék"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ջոկեր"),
            keywords: &["թղթախաղ", "խաղ", "խաղալ", "ջոկեր"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("joker"),
            keywords: &["joker", "kartu", "permainan"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("kaadi joka"),
            keywords: &["egwuregwu", "kaadi joka", "kaadị", "kaadịmmeri"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("jókerspil"),
            keywords: &["jóker", "jókerspil", "spil"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("jolly"),
            keywords: &["carta", "carta da gioco", "jolly"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ジョーカー"),
            keywords: &["カード", "ジジ", "ジョーカー", "トランプ", "ババ"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kertu joker"),
            keywords: &["game", "joker", "kertu", "kertu liar"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ჯოკერი"),
            keywords: &["ბანქო", "თამაში", "კარტი", "ჯოკერი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("джокер"),
            keywords: &["джокер", "карта", "ойнау", "ойын"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("joker"),
            keywords: &["joker", "kort", "spillekort"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("បៀរខ\u{17d2}មោច"),
            keywords: &["បៀរ", "បៀរខ\u{17d2}មោច", "ល\u{17d2}បែង"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಜೋಕರ\u{ccd}"),
            keywords: &[
                "ಕಾರ\u{ccd}ಡ\u{ccd}",
                "ಜೋಕರ\u{ccd}",
                "ಪ\u{ccd}ಲೇಯ\u{cbf}ಂಗ\u{ccd} ಕಾರ\u{ccd}ಡ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("조커"),
            keywords: &["조커", "카드"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("जोकर"),
            keywords: &[
                "ग\u{947}म",
                "जोकर",
                "पत\u{94d}तो",
                "वायल\u{94d}डकार\u{94d}ड",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жокер"),
            keywords: &["жокер", "карта", "ойноо", "оюн"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Joker"),
            keywords: &["Jocker", "Joker", "Kaart", "Spill"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໂຈກເກ\u{eb5}"),
            keywords: &[
                "ສ\u{eb1}ນຍາລ\u{eb1}ກແທນ",
                "ຫ\u{ebc}\u{eb5}\u{ec9}ນ",
                "ໂຈກເກ\u{eb5}",
                "ໄພ\u{ec9}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("juokdarys"),
            keywords: &["juokdarys", "kortos", "žaidimas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("džokers"),
            keywords: &["džokers", "kārtis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tioka"),
            keywords: &["kāri", "kārimohowao", "kēmu", "tioka"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("џокер"),
            keywords: &["игра", "карти", "џокер"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ജോക\u{d4d}കർ"),
            keywords: &[
                "ചിഹ\u{d4d}നം",
                "ചീട\u{d4d}ട\u{d41}കെട\u{d4d}ട\u{d4d}",
                "ചീട\u{d4d}ട\u{d4d}",
                "ജോക\u{d4d}കർ",
                "ജോക\u{d4d}കർ ക\u{d3e}ർഡ\u{d4d}",
                "സിംബൽ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хөзрийн хүн"),
            keywords: &["тоглоом", "хүн", "хөзрийн хүн", "хөзөр"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("विद\u{942}षक"),
            keywords: &[
                "कार\u{94d}ड",
                "ग\u{947}म",
                "जोकर",
                "वाइल\u{94d}ड कार\u{94d}ड",
                "विद\u{942}षक",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("joker"),
            keywords: &["bermain", "joker", "kad", "permainan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("joker"),
            keywords: &["joker", "karta", "tal-logħob", "wildcards"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဂျ\u{102d}\u{102f}ကာဖ\u{1032}ချပ\u{103a}"),
            keywords: &[
                "ဂ\u{102d}မ\u{103a}း",
                "ဂျ\u{102d}\u{102f}ကာဖ\u{1032}ချပ\u{103a}",
                "ဖ\u{1032}ချပ\u{103a}",
                "လ\u{102d}\u{102f}ရာသ\u{102f}\u{1036}းဖ\u{1032}ချပ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("joker"),
            keywords: &["joker", "jokerkort", "kort", "spillkort"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("जोकर"),
            keywords: &[
                "कार\u{94d}ड",
                "ख\u{947}ल",
                "जोकर",
                "वाइल\u{94d}ड कार\u{94d}ड",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("Jokerkaart"),
            keywords: &["Jokerkaart", "joker", "jokerkaart", "kaart", "spel"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("joker"),
            keywords: &["joker", "jokerkort", "kort", "spelkort"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଜୋକର\u{b4d}\u{200d}"),
            keywords: &[
                "କ\u{b3e}ର\u{b4d}ଡ\u{b4d}",
                "ଖେଳ",
                "ଜୋକର\u{b4d}\u{200d}",
                "ୱ\u{b3e}ଇଲଡକ\u{b3e}ର\u{b4d}ଡ\u{b4d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਜ\u{a4b}ਕਰ"),
            keywords: &["ਕਾਰਡ", "ਜ\u{a4b}ਕਰ", "ਤਾਸ\u{a3c} ਖ\u{a47}ਡਣਾ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("مسخرہ"),
            keywords: &["مسخرہ", "ناقابل\u{650} پیشگوئی", "کارڈ", "کھیڈ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Jóka"),
            keywords: &["Gem", "Jóka", "Kad", "Waíldkad"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("dżoker"),
            keywords: &["Joker", "dżoker", "karta", "karta do gry"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("جوکر"),
            keywords: &["تاش", "جوکر", "لوبه", "ويل کارډ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("curinga"),
            keywords: &["baralho", "carta", "curinga", "joker"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("jóquer"),
            keywords: &["carta", "jogar", "jogo", "jóquer"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("joker"),
            keywords: &["joker", "pukllay", "tarhita"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("joker"),
            keywords: &["cărți", "joc", "joker", "păcălici"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-168"),
            keywords: &["E10-168"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("джокер"),
            keywords: &["джокер", "игра", "карты"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("jokeri"),
            keywords: &["ibimenyetso bitandukanye", "ikarita", "jokeri", "umukino"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("جوڪر"),
            keywords: &["جوڪر", "ڪارڊ، راند، وائلڊ ڪارڊ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ජෝකර\u{dca}"),
            keywords: &[
                "ක\u{dca}\u{200d}ර\u{dd3}ඩ\u{dcf} ක\u{dd2}ර\u{dd3}ම",
                "ක\u{dca}\u{200d}ර\u{dd3}ඩ\u{dcf}ව",
                "ක\u{dcf}ඩ\u{dca}",
                "ජෝකර\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("žolík"),
            keywords: &["hra", "hracie", "karta", "žolík"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("joker"),
            keywords: &["igra", "igranje", "joker", "karta"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("jookar"),
            keywords: &["ciyaar", "jookar", "kaadh", "kaadhka xayawaanaha"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("xholi"),
            keywords: &["letër", "lojë", "luaj", "xholi"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("џокер"),
            keywords: &["игрa", "кaртaњe", "кaртe", "џокер"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("džoker"),
            keywords: &["džoker", "igra", "kartanje", "karte"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("joker"),
            keywords: &["Joker", "Joker-kort", "joker", "spelkort"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("jokari"),
            keywords: &["jokari", "kadi", "kucheza", "mchezo"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஜோக\u{bcd}கர\u{bcd}"),
            keywords: &[
                "கருப\u{bcd}பு ஜோக\u{bcd}கர\u{bcd}",
                "ச\u{bc0}ட\u{bcd}டு அட\u{bcd}டையில\u{bcd} கருப\u{bcd}பு ஜோக\u{bcd}கர\u{bcd}",
                "ச\u{bc0}ட\u{bcd}டுக\u{bcd}கட\u{bcd}டு",
                "ஜோக\u{bcd}கர\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("జ\u{c4b}కర\u{c4d}"),
            keywords: &[
                "జ\u{c4b}కర\u{c4d}",
                "జ\u{c4b}కర\u{c4d} క\u{c3e}ర\u{c4d}డ\u{c4d}",
                "ప\u{c47}కముక\u{c4d}క",
                "ప\u{c47}కముక\u{c4d}కప\u{c48} నలుపురంగు జ\u{c4b}కర\u{c4d} బ\u{c4a}మ\u{c4d}మ",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ҳазлбоз"),
            keywords: &["аломатҳои ивазкунӣ", "бозӣ", "корт", "ҳазлбоз"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ไพ\u{e48}โจ\u{e4a}กเกอร\u{e4c}"),
            keywords: &[
                "เล\u{e48}นไพ\u{e48}",
                "โจ\u{e4a}กเกอร\u{e4c}",
                "ไพ\u{e48}โจ\u{e4a}กเกอร\u{e4c}",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("joker"),
            keywords: &["joker", "kart", "oýun", "žoker"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("sioka"),
            keywords: &["sioka"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("joker"),
            keywords: &["iskambil kartı", "joker", "kart"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("جوكېر"),
            keywords: &["ئويۇن", "جوكېر", "سىرتقى قارتا", "قارتا"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("джокер"),
            keywords: &["гра", "грати", "джокер", "карта"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("جوکر"),
            keywords: &["تاش", "جوکر", "پتہ", "کھیل"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("o‘yin kartasidagi joker"),
            keywords: &["karta", "o‘yin", "o‘yin kartasidagi joker", "o‘ynash"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("quân phăng teo"),
            keywords: &["lá bài", "quân phăng teo", "trò chơi"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("jokeer"),
            keywords: &["jokeer", "kàrt", "po"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umhlekisi"),
            keywords: &["i-wildcard", "ikhadi", "umdlalo", "umhlekisi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Joka"),
            keywords: &["Joka", "eré", "káàdì", "káàdí ọlọ\u{301}pọ\u{300} ìlò"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("小丑"),
            keywords: &["小丑", "百撘卡", "紙牌", "遊戲"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("小丑"),
            keywords: &["小丑", "游戏", "百撘卡", "纸牌"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("大小王"),
            keywords: &["大小王", "大王", "小王", "扑克", "牌", "鬼牌"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("鬼牌"),
            keywords: &["鬼牌"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ujokha"),
            keywords: &["ikhadi", "ujokha", "ukudlala", "umdlalo"],
        },
    ],
};
#[doc = "🀄"]
pub const MAHJONG_RED_DRAGON: crate::Emoji = crate::Emoji {
    glyph: "🀄",
    codepoint: "1F004",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "mahjong red dragon",
    group: "Activities",
    subgroup: "game",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("mahjong rooi draak"),
            keywords: &["mahjong", "mahjong rooi draak", "rooi", "speel"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ማህጆንግ ቀይ ድራጎን"),
            keywords: &["ማህጆንግ", "ማህጆንግ ቀይ ድራጎን", "ቀይ", "ጨዋታ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("لعبة ورق يابانية"),
            keywords: &["تنين", "تنين أحمر", "لعبة ورق يابانية"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ম\u{9be}হজং ৰেড ড\u{9cd}ৰেগন"),
            keywords: &[
                "ক\u{9cd}ৰীড\u{9bc}\u{9be}",
                "ম\u{9be}হজং",
                "ম\u{9be}হজং ৰেড ড\u{9cd}ৰেগন",
                "ৰেড",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("maconq qırmızı əjdaha"),
            keywords: &["maconq", "maconq qırmızı əjdaha", "oyun", "qırmızı"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("чырвоны дракон у маджонгу"),
            keywords: &[
                "гульня",
                "маджонг",
                "цмок",
                "чырвоны",
                "чырвоны дракон у маджонгу",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("„червен дракон“ в маджонг"),
            keywords: &["игра", "маджонг", "червен", "„червен дракон“ в маджонг"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ম\u{9be}হজঙ\u{9cd}গ ল\u{9be}ল ড\u{9cd}র\u{9be}গন"),
            keywords: &[
                "খেল\u{9be}",
                "ম\u{9be}হজঙ\u{9cd}গ",
                "ম\u{9be}হজঙ\u{9cd}গ ল\u{9be}ল ড\u{9cd}র\u{9be}গন",
                "ল\u{9be}ল",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("mahjong crveni zmaj"),
            keywords: &["igra", "mahjong", "mahjong crveni zmaj"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("drac vermell de mahjong"),
            keywords: &["drac vermell", "drac vermell de mahjong", "joc", "mahjong"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎹᏦᏂᎩ ᎩᎦᎨ ᎡᏆ ᏔᏲᎭᎵ"),
            keywords: &["ᎩᎦᎨ", "ᎹᏦᎦ", "ᎹᏦᏂᎩ ᎩᎦᎨ ᎡᏆ ᏔᏲᎭᎵ", "ᏗᏁᏟᏙᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("červený drak v mahjongu"),
            keywords: &[
                "hra",
                "madžong",
                "mah-jong",
                "mahjong",
                "červená",
                "červený drak v mahjongu",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("draig goch mahjong"),
            keywords: &["coch", "draig goch mahjong", "gêm", "mahjong"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("mahjong-brik"),
            keywords: &["drage", "mahjong", "mahjong-brik", "rød drage"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Mahjong-Stein"),
            keywords: &["Mahjong", "Mahjong-Stein", "roter Drache"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πλακίδιο mahjong κόκκινος δράκος"),
            keywords: &[
                "δράκος mahjong",
                "κόκκινος",
                "παιχνίδι",
                "πλακίδιο mahjong κόκκινος δράκος",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("mahjong red dragon"),
            keywords: &["game", "mahjong", "mahjong red dragon", "red"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("Mahjong red dragon"),
            keywords: &["Mahjong", "Mahjong red dragon", "game", "red"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("dragón rojo de mahjong"),
            keywords: &["dragón rojo", "dragón rojo de mahjong", "juego", "mahjong"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &[
                "dragón",
                "dragón rojo de mahjong",
                "mahjong",
                "mosaico",
                "rojo",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("mahjongi punane draakon"),
            keywords: &["mahjong", "mahjongi punane draakon", "mäng", "punane"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("mahjong dragoi gorria"),
            keywords: &["gorri", "joko", "mahjong", "mahjong dragoi gorria"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ماژونگ اژدهای قرمز"),
            keywords: &["بازی", "قرمز", "ماژونگ", "ماژونگ اژدهای قرمز"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("mahjong"),
            keywords: &["keskusta", "lohikäärme", "mahjong", "peli", "punainen"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("mahjong red dragon"),
            keywords: &["mahjong", "mahjong red dragon", "pula", "sugal"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("mah-jong"),
            keywords: &["mah-jong", "mahjong", "spæl"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("dragon rouge mahjong"),
            keywords: &["dragon rouge mahjong", "jeu", "mahjong", "rouge"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["dragon", "mahjong", "rouge"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("Dragan rua mah-jongg"),
            keywords: &[
                "Dragan",
                "Dragan rua",
                "Dragan rua mah-jongg",
                "Tíl mah-jongg",
                "mah-jongg",
                "tíl",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("leacag Mahjong le dràgon dearg"),
            keywords: &[
                "dearg",
                "geama",
                "leacag Mahjong le dràgon dearg",
                "mahjong",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("ficha de mahjong"),
            keywords: &["dragón", "ficha de mahjong", "mahjong", "vermello", "xogo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("માહજો\u{a82}ગ લાલ ડ\u{acd}ર\u{ac7}ગન"),
            keywords: &[
                "ટાઇલ",
                "ડ\u{acd}ર\u{ac7}ગન",
                "માહજો\u{a82}ગ",
                "માહજો\u{a82}ગ લાલ ડ\u{acd}ર\u{ac7}ગન",
                "લાલ ડ\u{acd}ર\u{ac7}ગન",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("jan daragon na mahjong"),
            keywords: &["ja", "jan daragon na mahjong", "mahjong", "wasa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("דרקון אדום \u{200e}מה-ג׳ונג"),
            keywords: &["אדום", "דרקון", "דרקון אדום במה-ג׳ונג", "מה-ג׳ונג", "משחק"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("माहजो\u{902}ग लाल द\u{948}त\u{94d}य"),
            keywords: &[
                "टाइल",
                "द\u{948}त\u{94d}य",
                "माहजो\u{902}ग",
                "माहजो\u{902}ग लाल द\u{948}त\u{94d}य",
                "लाल द\u{948}त\u{94d}य",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("mahjong crveni zmaj"),
            keywords: &["crveno", "igra", "mahjong", "mahjong crveni zmaj"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("madzsong vörös sárkány"),
            keywords: &["játék", "madzsong", "madzsong vörös sárkány", "vörös"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մաջոնգի կարմիր վիշապ"),
            keywords: &["խաղ", "կարմիր", "մաջոնգ", "մաջոնգի կարմիր վիշապ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("naga merah mahyong"),
            keywords: &["game", "mahyong", "merah", "naga merah mahyong"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("dragọn ọbara mahjong"),
            keywords: &["dragọn ọbara mahjong", "egwuregwu", "mahjong", "ọbara"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("Mahjong-tafla"),
            keywords: &["Mahjong-tafla", "dreki", "mahjong", "rauður dreki"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("tessera Mahjong"),
            keywords: &["Mahjong", "drago", "drago rosso", "tessera"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("麻雀"),
            keywords: &["ゲーム", "牌", "麻雀", "麻雀牌"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("naga abang mahyong"),
            keywords: &["abang", "game", "mahyong", "naga abang mahyong"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მაჯონგის წითელი დრაკონი"),
            keywords: &["თამაში", "მაჯონგი", "მაჯონგის წითელი დრაკონი", "წითელი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: None,
            keywords: &["azeggaɣ", "mahjong", "urar"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("маджонг қызыл айдаһар"),
            keywords: &["маджонг", "маджонг қызыл айдаһар", "ойын", "қызыл"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("mahjong-brik"),
            keywords: &["drage", "mahjong", "mahjong-brik", "rød drage"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("បៀច\u{17b7}ន"),
            keywords: &["បៀ", "បៀច\u{17b7}ន", "ល\u{17d2}បែង"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮಹ\u{ccd}ಜಾಂಗ\u{ccd} ರ\u{cc6}ಡ\u{ccd} ಡ\u{ccd}ರಾಗನ\u{ccd}"),
            keywords: &[
                "ಆಟ",
                "ಕ\u{cc6}ಂಪು",
                "ಮಹ\u{ccd}ಜಾಂಗ\u{ccd}",
                "ಮಹ\u{ccd}ಜಾಂಗ\u{ccd} ಕ\u{cc6}ಂಪು ಡ\u{ccd}ರ\u{ccd}ಯಾಗನ\u{ccd}",
                "ಮಹ\u{ccd}ಜಾಂಗ\u{ccd} ರ\u{cc6}ಡ\u{ccd} ಡ\u{ccd}ರಾಗನ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("마작"),
            keywords: &["마작", "마작 기호"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("महजो\u{902}ग ता\u{902}बडो ड\u{94d}र\u{947}गॉन"),
            keywords: &[
                "ग\u{947}म",
                "ता\u{902}बडो",
                "महजो\u{902}ग",
                "महजो\u{902}ग ता\u{902}बडो ड\u{94d}र\u{947}गॉन",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("маджонг кызыл ажыдаар"),
            keywords: &["кызыл", "маджонг", "маджонг кызыл ажыдаар", "оюн"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Rouden Draach (Mahjong)"),
            keywords: &["Mahjong", "Rouden Draach (Mahjong)", "Spill", "rout"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໄພ\u{ec9}ນ\u{ebb}ກກະຈອກ"),
            keywords: &[
                "ນ\u{ebb}ກກະຈອກ",
                "ຫ\u{ebc}\u{eb4}\u{ec9}ນໄພ\u{ec8}",
                "ໄພ\u{ec9}",
                "ໄພ\u{ec9}ນ\u{ebb}ກກະຈອກ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("madžongo raudonas drakonas"),
            keywords: &[
                "madžongas",
                "madžongo raudonas drakonas",
                "raudonas",
                "žaidimas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("Mahjong kauliņš, sarkanais pūķis"),
            keywords: &[
                "Mahjong kauliņš, sarkanais pūķis",
                "mahjong",
                "sarkans",
                "spēle",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tarakona whero mahjong"),
            keywords: &["kēmu", "mahjong", "tarakona whero mahjong", "whero"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("плочка со црвен змеј"),
            keywords: &["домино", "игра", "плочка со црвен змеј", "плочки"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മ\u{d3e}ഹ\u{d4d}\u{200c}ജോംഗ\u{d4d} റെഡ\u{d4d} ഡ\u{d4d}ര\u{d3e}ഗൺ"),
            keywords: &[
                "ടൈൽ",
                "ഡ\u{d4d}ര\u{d3e}ഗൻ",
                "മഹ\u{d4d}\u{200c}ജോംഗ\u{d4d}",
                "മഹ\u{d4d}\u{200c}ജോംഗ\u{d4d} ചിഹ\u{d4d}നം",
                "മ\u{d3e}ഹ\u{d4d}\u{200c}ജോംഗ\u{d4d} റെഡ\u{d4d} ഡ\u{d4d}ര\u{d3e}ഗൺ",
                "റെഡ\u{d4d} ഡ\u{d4d}ര\u{d3e}ഗൻ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("мажонг улаан луу"),
            keywords: &["луу", "мажонг", "улаан"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("माहजॉन\u{94d}ग लाल ड\u{94d}र\u{945}गन"),
            keywords: &[
                "ग\u{947}म",
                "माहजॉन\u{94d}ग",
                "माहजॉन\u{94d}ग लाल ड\u{94d}र\u{945}गन",
                "लाल",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("naga merah mahjung"),
            keywords: &["mahjung", "merah", "naga merah mahjung", "permainan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("mahjong red dragon"),
            keywords: &["logħba", "mahjong", "mahjong red dragon", "red"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("မာဂျောက\u{103a} နဂါးန\u{102e}"),
            keywords: &[
                "ဂ\u{102d}မ\u{103a}း",
                "မာဂျောက\u{103a}",
                "မာဂျောက\u{103a} နဂါးန\u{102e}",
                "အန\u{102e}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("mahjongbrikke med rød drage"),
            keywords: &["mahjong", "mahjongbrikke med rød drage", "rød", "spill"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("महजङ\u{94d}ग रातो ड\u{94d}रागन"),
            keywords: &[
                "ख\u{947}ल",
                "महजङ\u{94d}ग",
                "महजङ\u{94d}ग रातो ड\u{94d}रागन",
                "रातो",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("mahjong rode draak"),
            keywords: &["mahjong", "mahjong rode draak", "rood", "spel"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("mahjongbrikke med raud drake"),
            keywords: &["mahjong", "mahjongbrikke med raud drake", "raud", "spel"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମହଜୋଙ\u{b4d}ଗ ଲ\u{b3e}ଲ ଡ\u{b4d}ର\u{b3e}ଗନ\u{b4d}\u{200d}"),
            keywords: &[
                "ଖେଳ",
                "ମହଜୋଙ\u{b4d}ଗ",
                "ମହଜୋଙ\u{b4d}ଗ ଲ\u{b3e}ଲ ଡ\u{b4d}ର\u{b3e}ଗନ\u{b4d}\u{200d}",
                "ଲ\u{b3e}ଲ\u{b4d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਮਹਿਜ\u{a4c}\u{a02}ਗ ਲਾਲ ਡਰ\u{a48}ਗਨ"),
            keywords: &[
                "ਗ\u{a47}ਮ",
                "ਮਹਿਜ\u{a4c}\u{a02}ਗ",
                "ਮਹਿਜ\u{a4c}\u{a02}ਗ ਲਾਲ ਡਰ\u{a48}ਗਨ",
                "ਲਾਲ ਡਰ\u{a48}ਗਨ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("مہجونگ ریڈ ڈریگن"),
            keywords: &["لال", "مہجونگ", "مہجونگ ریڈ ڈریگن", "کھیڈ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Máhjọng Rẹ\u{301}d Drágọn"),
            keywords: &["Gem", "Máhjọng", "Máhjọng Rẹ\u{301}d Drágọn", "Rẹd"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("madżong: czerwony smok"),
            keywords: &[
                "Czerwony smok",
                "Smok",
                "kafelek",
                "madżong: czerwony smok",
                "mahjong",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د ماهجونګ سور خامار"),
            keywords: &["د ماهجونګ سور خامار", "سور", "لوبه", "ماهجونګ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("dragão vermelho de mahjong"),
            keywords: &[
                "dragão vermelho",
                "dragão vermelho de mahjong",
                "mahjong",
                "peça",
                "peça de mahjong",
                "vermelho",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("dragão vermelho de mahjong"),
            keywords: &["dragão vermelho de mahjong", "jogo", "mahjong", "vermelho"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("mahjong puka dragon"),
            keywords: &["mahjong", "mahjong puka dragon", "puka", "pukllay"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("dragon roșu la mahjong"),
            keywords: &["dragon roșu la mahjong", "joc", "mahjong", "roșu"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-167"),
            keywords: &["E10-167"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("маджонг"),
            keywords: &["Китай", "игра", "игральные", "кости", "кубики", "маджонг"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikaro itukura y’umukino wa mahjong"),
            keywords: &[
                "Mahjong",
                "ikaro itukura y’umukino wa mahjong",
                "umukino",
                "umutuku",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مهيجونگ ريڊ ڊريگون"),
            keywords: &["رند، مهيجونگ، ريڊ", "مهيجونگ ريڊ ڊريگون"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("මහජොන\u{dca}ග\u{dca} රත\u{dd4} මකර\u{dcf}"),
            keywords: &[
                "ක\u{dca}\u{200d}ර\u{dd3}ඩ\u{dcf}ව",
                "මහජොන\u{dca}ග\u{dca}",
                "මහජොන\u{dca}ග\u{dca} රත\u{dd4} මකර\u{dcf}",
                "රත\u{dd4}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("madžongový červený drak"),
            keywords: &["hra", "madžong", "madžongový červený drak", "červený"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("rdeči zmaj v mahjongu"),
            keywords: &["igra", "mahjong", "rdeče", "rdeči zmaj v mahjongu"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("mahjong masduulaagii gaduudnaa"),
            keywords: &[
                "ciyaar",
                "gaduud",
                "mahjong",
                "mahjong masduulaagii gaduudnaa",
                "mhjong masduulaagii gaduudnaa",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("dragua i kuq mahjong"),
            keywords: &["dragua i kuq mahjong", "i kuq", "lojë", "mahjong"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("црвени змај из маџонга"),
            keywords: &["игрa", "мaџoнг", "црвeнo", "црвени змај из маџонга"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("crveni zmaj iz madžonga"),
            keywords: &["crveni zmaj iz madžonga", "crveno", "igra", "madžong"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("mahjong-bricka"),
            keywords: &[
                "Mahjong-bricka",
                "drake",
                "mahjong-bricka",
                "röd drake",
                "spelbricka",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("dragoni jekundu la mahjong"),
            keywords: &[
                "dragoni jekundu la mahjong",
                "mahjong",
                "mchezo",
                "nyekundu",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மஹ\u{bcd}ஜோங\u{bcd} டைலில\u{bcd} ரெட\u{bcd} டிர\u{bbe}கன\u{bcd}"),
            keywords: &[
                "டிர\u{bbe}கன\u{bcd}",
                "மஹ\u{bcd}ஜோங\u{bcd} டைலில\u{bcd} ரெட\u{bcd} டிர\u{bbe}கன\u{bcd}",
                "ரெட\u{bcd} டிர\u{bbe}கன\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "మ\u{c3e}హ\u{c4d}\u{200c}జ\u{c3e}ంగ\u{c4d} ఆటల\u{c4b} ఎరుపురంగు డ\u{c4d}ర\u{c3e}గన\u{c4d}",
            ),
            keywords: &[
                "ఎరుపు డ\u{c4d}ర\u{c3e}గన\u{c4d}",
                "డ\u{c4d}ర\u{c3e}గన\u{c4d}",
                "ప\u{c47}కముక\u{c4d}కప\u{c48} ఎరుపురంగు డ\u{c4d}ర\u{c3e}గన\u{c4d} బ\u{c4a}మ\u{c4d}మ",
                "మ\u{c3e}హ\u{c4d}\u{200c}జ\u{c3e}ంగ\u{c4d} ఆటల\u{c4b} ఎరుపురంగు డ\u{c4d}ర\u{c3e}గన\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("аждаҳори сурхи маҳҷонг"),
            keywords: &["аждаҳори сурхи маҳҷонг", "бозӣ", "маҳҷонг", "сурх"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ไพ\u{e48}นกกระจอกม\u{e31}งกรแดง"),
            keywords: &[
                "นกกระจอก",
                "เกม",
                "เล\u{e48}น",
                "ไพ\u{e48}",
                "ไพ\u{e48}นกกระจอกม\u{e31}งกรแดง",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("mahjong gyzyl aždarha"),
            keywords: &["gyzyl", "mahjong", "mahjong gyzyl aždarha", "oýun"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("talakoni kulokula"),
            keywords: &["talakoni kulokula"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kızıl ejder mahjong taşı"),
            keywords: &[
                "Ejderha",
                "Kızıl Ejder",
                "kızıl ejder mahjong taşı",
                "mahjong",
                "taş",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ماجاڭ قىزىل ئەجدىھا"),
            keywords: &["ئويۇن", "قىزىل", "ماجاڭ", "ماجاڭ قىزىل ئەجدىھا"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("фішка маджонгу «червоний дракон»"),
            keywords: &[
                "гра",
                "маджонг",
                "фішка маджонг червоний дракон",
                "фішка маджонгу «червоний дракон»",
                "червоний",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ماہجونگ ریڈ ڈریگن"),
            keywords: &["سرخ", "ماہجونگ", "ماہجونگ ریڈ ڈریگن", "کھیل"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("majong toshidagi qizil ajdar"),
            keywords: &["majong", "majong toshidagi qizil ajdar", "o‘yin", "qizil"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mạt chược rồng đỏ"),
            keywords: &["mạt chược", "mạt chược rồng đỏ", "trò chơi", "đỏ"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("dragon mahjong bu xonk"),
            keywords: &["dragon mahjong bu xonk", "mahjong", "po", "xonk"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-mahjong red dragon"),
            keywords: &["bomvu", "i-mahjong", "i-mahjong red dragon", "umdlalo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Dragoni Pupa Mahjong"),
            keywords: &["Dragoni Pupa Mahjong", "eré", "mahjong", "pupa"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("紅中麻雀"),
            keywords: &["紅中麻雀", "紅色", "遊戲", "麻雀"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("红中麻雀"),
            keywords: &["游戏", "红中麻雀", "红色", "麻雀"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("红中"),
            keywords: &["红中", "麻将"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("紅中"),
            keywords: &["紅中", "麻將"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["紅中", "麻將", "麻雀"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umajongi oyidragoni ebomvu"),
            keywords: &[
                "imajongi",
                "okubomvu",
                "umajongi oyidragoni ebomvu",
                "umdlalo",
            ],
        },
    ],
};
#[doc = "🎴"]
pub const FLOWER_PLAYING_CARDS: crate::Emoji = crate::Emoji {
    glyph: "🎴",
    codepoint: "1F3B4",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "flower playing cards",
    group: "Activities",
    subgroup: "game",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("blomspeelkaarte"),
            keywords: &[
                "Japannees",
                "blom",
                "blomspeelkaarte",
                "kaart",
                "speel",
                "speletjie",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ጀርባው አበባ መጫወቻ ካርታ"),
            keywords: &["በመጫወት ላይ", "አበባ", "ካርታ", "የጃፓን", "ጀርባው አበባ መጫወቻ ካርታ", "ጨዋታ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("بطاقات لعب"),
            keywords: &["بطاقات لعب", "كرت زهور", "لعبة كرت"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ফ\u{9c1}ল\u{9be}ম খেল\u{9be} ক\u{9be}ৰ\u{9cd}ড"),
            keywords: &[
                "খেল",
                "জ\u{9be}প\u{9be}নী",
                "ত\u{9be}\u{981}চখেল",
                "ফ\u{9c1}ল",
                "ফ\u{9c1}ল\u{9be}ম খেল\u{9be} ক\u{9be}ৰ\u{9cd}ড",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("gül oyun kartları"),
            keywords: &[
                "gül",
                "gül oyun kartları",
                "kart",
                "oynamaq",
                "oyun",
                "yapon",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("ігральныя карты ханафуда"),
            keywords: &[
                "гульня",
                "кветка",
                "ханафуда",
                "японская",
                "ігральныя карты ханафуда",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("карти за игра ханафуда"),
            keywords: &[
                "Карти за игра ханафуда",
                "игра",
                "карта",
                "карти за игра ханафуда",
                "цвете",
                "японски",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ফ\u{9c1}ল ব\u{9be}জ\u{9be}নোর ক\u{9be}র\u{9cd}ড"),
            keywords: &[
                "ক\u{9be}র\u{9cd}ড",
                "খেল\u{9be}",
                "জ\u{9be}প\u{9be}নি",
                "ত\u{9be}স",
                "ফ\u{9c1}ল",
                "ফ\u{9c1}ল ব\u{9be}জ\u{9be}নোর ক\u{9be}র\u{9cd}ড",
                "ফ\u{9c1}ল সজ\u{9cd}জিত ত\u{9be}স",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("japanske karte za igranje"),
            keywords: &[
                "igra",
                "igranje",
                "japanske",
                "japanske karte za igranje",
                "karte",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cartes de les flors"),
            keywords: &[
                "cartes",
                "cartes de flors",
                "cartes de les flors",
                "flors",
                "hanafuda",
                "japonès",
                "joc",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏥᎸᏍᎩ ᏓᏆᎾᏲᎯᎭ"),
            keywords: &["ᎤᏥᎸᏍᎩ", "ᎤᏥᎸᏍᎩ ᏓᏆᎾᏲᎯᎭ", "ᏆᏂᏲᏍᏗ", "ᏓᏁᎶᎲᏍᎩ", "ᏗᏁᏟᏙᏗ", "ᏣᏱᏂᏏ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("hrací karty s květinami"),
            keywords: &[
                "hra",
                "hrací karty s květinami",
                "hraní",
                "japonský",
                "karta",
                "květina",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cardiau chwarae blodau"),
            keywords: &["Japaneaidd", "blodyn", "cardiau", "cardiau chwarae blodau"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("spillekort med blomster"),
            keywords: &["japansk", "kortspil", "spillekort med blomster"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("japanische Blumenkarte"),
            keywords: &[
                "Blume",
                "Blumenkarte",
                "Hanafuda",
                "Japan",
                "Karte",
                "japanische Blumenkarte",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("τραπουλόχαρτα χαναφούντα"),
            keywords: &[
                "ιαπωνικό",
                "κάρτα",
                "λουλούδι",
                "παίζω",
                "παιχνίδι",
                "τραπουλόχαρτα χαναφούντα",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("flower playing cards"),
            keywords: &[
                "Japanese",
                "card",
                "flower",
                "flower playing cards",
                "game",
                "playing",
            ],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &[
                "Japanese",
                "card",
                "flower",
                "flower playing cards",
                "game",
                "hanafuda",
                "playing",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cartas de flores"),
            keywords: &[
                "carta",
                "cartas de flores",
                "flor",
                "hanafuda",
                "naipe japonés",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("carta"),
            keywords: &["Hanafuda", "carta", "flor", "japonés", "juego"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("mängukaardid"),
            keywords: &["kaart", "lill", "mäng", "mängukaardid"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("loreak dituzten kartak"),
            keywords: &["japonia", "joko", "karta", "lore", "loreak dituzten kartak"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کارت بازی گل\u{200c}دار"),
            keywords: &[
                "بازی",
                "بازی کردن",
                "ژاپنی",
                "کارت",
                "کارت بازی گل\u{200c}دار",
                "گل",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kukkapelikortit"),
            keywords: &[
                "Japani",
                "hanafuda",
                "kortti",
                "korttipeli",
                "kukat",
                "kukkapelikortit",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("flower playing card"),
            keywords: &[
                "baraha",
                "card",
                "flower",
                "flower playing card",
                "hanafuda",
                "laro",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("hanafuda"),
            keywords: &["hanafuda", "japanskt", "kort", "spæl"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("jeu des fleurs"),
            keywords: &["carte", "fleur", "japonais", "jeu", "jeu des fleurs"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("jeu des fleurs"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cártaí imeartha bláthanna"),
            keywords: &[
                "cluiche",
                "cárta",
                "cárta imeartha",
                "cártaí",
                "cártaí imeartha bláthanna",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cairtean nam flùraichean"),
            keywords: &[
                "cairt",
                "cairtean nam flùraichean",
                "cluich",
                "flùr",
                "geama",
                "iapanach",
                "seapanach",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("carta do xogo das flores"),
            keywords: &[
                "carta do xogo das flores",
                "cartas",
                "flores",
                "xaponés",
                "xogo",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ફ\u{ac2}લવાળ\u{ac1}\u{a82} પત\u{acd}ત\u{ac1}\u{a82}"),
            keywords: &[
                "પત\u{acd}તાની રમત",
                "પત\u{acd}ત\u{ac1}\u{a82}",
                "ફ\u{ac2}લ",
                "ફ\u{ac2}લવાળ\u{ac1}\u{a82} પત\u{acd}ત\u{ac1}\u{a82}",
                "રમત",
                "હનાફ\u{ac2}ડા",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("katunan wasa mai fure"),
            keywords: &[
                "Na Japan",
                "bugawa",
                "fure",
                "kati",
                "katunan wasa mai fure",
                "wasa",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("קלפי פרחים"),
            keywords: &["יפני", "משחק", "קלף", "קלפי פרחים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("फ\u{942}ल वाला पत\u{94d}ता"),
            keywords: &[
                "कार\u{94d}ड",
                "ग\u{947}म",
                "ताश का पत\u{94d}ता",
                "फ\u{942}ल",
                "फ\u{942}ल वाला पत\u{94d}ता",
                "हानाफ\u{942}डा",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("igraće karte s cvijećem"),
            keywords: &[
                "cvijeće",
                "igra",
                "igraće karte s cvijećem",
                "japan",
                "kartanje",
                "karte",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("virágos kártyajáték"),
            keywords: &["japán", "játék", "kártya", "virág", "virágos kártyajáték"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ծաղկի խաղաթղթեր"),
            keywords: &[
                "թղթախաղ",
                "խաղ",
                "խաղալ",
                "ծաղիկ",
                "ծաղկի խաղաթղթեր",
                "ճապոնական",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kartu bunga"),
            keywords: &["bunga", "game", "jepang", "kartu", "permainan"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("kaadị okooko eji egwu egwu"),
            keywords: &[
                "Ndị Japan",
                "egwuregwu",
                "kaadị",
                "kaadị okooko eji egwu egwu",
                "na-egwu egwu",
                "okooko",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("blómaspil"),
            keywords: &["blóm", "blómaspil", "japanskur", "leikur", "spil"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("carta da gioco Hanafuda"),
            keywords: &[
                "Hanafuda",
                "carta",
                "carta da gioco",
                "carta da gioco Hanafuda",
                "carta dei fiori",
                "gioco",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("花札"),
            keywords: &["カード", "ゲーム", "花札"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kertu gambar kembang"),
            keywords: &[
                "Jepang",
                "dolanan",
                "game",
                "kembang",
                "kertu",
                "kertu gambar kembang",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ყვავილებიანი სათამაშო ბანქო"),
            keywords: &[
                "ბანქო",
                "თამაში",
                "იაპონური",
                "კარტი",
                "ყვავილებიანი სათამაშო ბანქო",
                "ყვავილი",
            ],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: None,
            keywords: &["takarḍa", "urar"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("гүлді ойын карталары"),
            keywords: &[
                "гүл",
                "гүлді ойын карталары",
                "жапон",
                "карта",
                "ойнау",
                "ойын",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("spillekort"),
            keywords: &["spillekort", "spillekort med blomster"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("បៀរ\u{17bc}ប"),
            keywords: &["បៀ", "បៀរ\u{17bc}ប", "ល\u{17d2}បែង"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some(
                "ಫ\u{ccd}ಲವರ\u{ccd} ಪ\u{ccd}ಲೇಯ\u{cbf}ಂಗ\u{ccd} ಕಾರ\u{ccd}ಡ\u{ccd}\u{200c}ಗಳು",
            ),
            keywords: &[
                "ಕಾರ\u{ccd}ಡ\u{ccd}",
                "ಗೇಮ\u{ccd}",
                "ಜಪಾನೀ\u{200c}ಸ\u{ccd}\u{200c}",
                "ಫ\u{ccd}ಲವರ\u{ccd}",
                "ಫ\u{ccd}ಲವರ\u{ccd} ಪ\u{ccd}ಲೇಯ\u{cbf}ಂಗ\u{ccd} ಕಾರ\u{ccd}ಡ\u{ccd}\u{200c}ಗಳು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("화투"),
            keywords: &["고스톱", "도박", "화투", "화투패"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("फ\u{942}ल ख\u{947}ळपा पत\u{94d}त\u{947}"),
            keywords: &[
                "ख\u{947}ळ",
                "ख\u{947}ळटा",
                "जपानी",
                "पत\u{94d}त\u{947}",
                "फ\u{941}ल ख\u{947}ळपा पत\u{94d}त\u{947}",
                "फ\u{942}ल",
                "फ\u{942}ल ख\u{947}ळपा पत\u{94d}त\u{947}",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("гүл ойноткон карталар"),
            keywords: &["гүл", "гүл ойноткон карталар", "жапончо", "карта", "оюн"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Spillkaarte mat Blummen"),
            keywords: &[
                "Blumm",
                "Kaart",
                "Spill",
                "Spillkaarte mat Blummen",
                "japanesch",
                "spillen",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໄພ\u{ec9}ດອກໄມ\u{ec9}"),
            keywords: &[
                "ຍ\u{eb5}\u{ec8}ປ\u{eb8}\u{ec8}ນ",
                "ດອກໄມ\u{ec9}",
                "ຫ\u{ebc}\u{eb4}\u{ec9}ນໄພ\u{ec9}",
                "ໄພ\u{ec9}",
                "ໄພ\u{ec9}ດອກໄມ\u{ec9}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("kortos su gėlėmis"),
            keywords: &["gėlė", "japonų", "kortos", "kortos su gėlėmis", "žaidimas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("ziedu kārtis"),
            keywords: &["japāņu", "kārtis", "spēle", "ziedu kārtis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kāri purei putiputi"),
            keywords: &["Hapanīhi", "kāri", "kēmu", "purei", "putiputi"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("цветни карти"),
            keywords: &["игра", "карти", "цветни карти", "цвеќе", "јапонска"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഫ\u{d4d}ലവർ പ\u{d4d}ലേയിംഗ\u{d4d} ക\u{d3e}ർഡ\u{d4d}"),
            keywords: &[
                "ഗെയിം",
                "പ\u{d4d}ലേയിംഗ\u{d4d} ക\u{d3e}ർഡ\u{d4d}",
                "ഫ\u{d4d}ലവർ ക\u{d3e}ർഡ\u{d4d}",
                "ഫ\u{d4d}ലവർ പ\u{d4d}ലേയിംഗ\u{d4d} ക\u{d3e}ർഡ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хөзөр"),
            keywords: &["тоглоом", "хөзөр", "цэцэг", "япон"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some(
                "फ\u{941}ला\u{902}च\u{947} ख\u{947}ळण\u{94d}\u{200d}याच\u{947} पत\u{94d}त\u{947}",
            ),
            keywords: &[
                "कार\u{94d}ड",
                "ख\u{947}ळण\u{947}",
                "ग\u{947}म",
                "जपानी",
                "फ\u{941}ला\u{902}च\u{947} ख\u{947}ळण\u{94d}\u{200d}याच\u{947} पत\u{94d}त\u{947}",
                "फ\u{942}ल",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("terup bunga"),
            keywords: &[
                "Jepun",
                "bermain",
                "bunga",
                "kad",
                "permainan",
                "terup bunga",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("fjuri tal-karti tal-logħob"),
            keywords: &[
                "fjuri",
                "fjuri tal-karti tal-logħob",
                "jilgħab",
                "karta",
                "logħba",
                "Ġappuniż",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပန\u{103a}း ဖ\u{1032}ချပ\u{103a}များ"),
            keywords: &[
                "ဂျပန\u{103a}",
                "ပန\u{103a}း",
                "ပန\u{103a}း ဖ\u{1032}ချပ\u{103a}များ",
                "ဖ\u{1032}ကစားခြင\u{103a}း",
                "ဖ\u{1032}ချပ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("spillkort"),
            keywords: &["kort", "kortspill", "spillkort"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("फ\u{94d}लावर प\u{94d}ल\u{947}यिङ कार\u{94d}ड"),
            keywords: &[
                "कार\u{94d}ड",
                "ख\u{947}ल",
                "जापानी",
                "प\u{94d}ल\u{947}यिङ",
                "फ\u{94d}लावर",
                "फ\u{94d}लावर प\u{94d}ल\u{947}यिङ कार\u{94d}डहर\u{942}",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("speelkaarten"),
            keywords: &[
                "bloem",
                "bloemspeelkaarten",
                "japans",
                "kaart",
                "speelkaarten",
                "spel",
                "spelen",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("spelkort"),
            keywords: &["kort", "kortspel", "spelkort"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଫ\u{b41}ଲ ତ\u{b3e}ସ"),
            keywords: &[
                "କ\u{b3e}ର\u{b4d}ଡ\u{b4d}",
                "ଖେଳ",
                "ତ\u{b3e}ସ",
                "ଫ\u{b41}ଲ",
                "ଫ\u{b4d}ଲ\u{b3e}ୱ\u{b3e}ର\u{b4d}\u{200c} କ\u{b3e}ର\u{b4d}ଡ\u{b4d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਫ\u{a41}\u{a71}ਲਹਿਰੀ ਤਾਸ\u{a3c}"),
            keywords: &[
                "ਕਾਰਡ",
                "ਖ\u{a47}ਡ",
                "ਫ\u{a41}\u{a71}ਲ",
                "ਫ\u{a41}\u{a71}ਲਹਿਰੀ ਤਾਸ\u{a3c}",
                "ਹਾਨਾਫ\u{a70}ਡਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کارڈ کھیڈدے ہوئے پھول"),
            keywords: &[
                "جاپانی",
                "پھ\u{64f}ل",
                "کارڈ",
                "کارڈ کھیڈدے ہوئے پھول",
                "کھیڈ",
                "کھیڈنا",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fláwá Pléyín Kad"),
            keywords: &[
                "Fláwa",
                "Fláwá Pléyín Kad",
                "Fláwá Pléyín Kad-dẹm",
                "Gem",
                "Japan",
                "Kad",
                "Ple",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("gra karciana hanafuda"),
            keywords: &["gra", "gra karciana hanafuda", "japońska", "kwiat"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د ګل تاش"),
            keywords: &["تاش", "جاپاني", "د ګل تاش", "لوبه", "لوبول", "ګل"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("carta de flores"),
            keywords: &[
                "Hanafuda",
                "baralho",
                "carta de baralho",
                "carta de flores",
                "flores",
                "jogo de baralho",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("baralho de cartas com flores"),
            keywords: &[
                "baralho de cartas com flores",
                "carta",
                "flor",
                "japonês",
                "jogar",
                "jogo",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("tʼika naipes"),
            keywords: &[
                "Japones",
                "pukllachkan",
                "pukllay",
                "tarhita",
                "tʼika naipes",
                "t’ika",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("cărți de joc cu flori"),
            keywords: &["Japonia", "carte", "cărți de joc cu flori", "floare", "joc"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-372"),
            keywords: &["E10-372"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("цветочная карта"),
            keywords: &[
                "Ханафуда",
                "Япония",
                "игра",
                "карты",
                "цветочная карта",
                "цветы",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("amakarita yo gukina ashushanyijeho indabyo"),
            keywords: &[
                "Umuyapani",
                "amakarita yo gukina ashushanyijeho indabyo",
                "gukina",
                "ikarita",
                "umukino",
                "ururabo",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("فلاور پلئينگ ڪارڊ"),
            keywords: &["فلاور پلئينگ ڪارڊ", "ڪارڊ، فلاور، راند، جاپاني، پلئينگ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("මල\u{dca} ක\u{dca}\u{200d}ර\u{dd3}ඩ\u{dcf} කරන ක\u{dcf}ඩ\u{dca}පත\u{dca}"),
            keywords: &[
                "ක\u{dca}\u{200d}ර\u{dd3}ඩ\u{dcf} ක\u{dd2}ර\u{dd3}ම",
                "ක\u{dca}\u{200d}ර\u{dd3}ඩ\u{dcf}ව",
                "ක\u{dcf}ඩ\u{dca}",
                "ජපන\u{dca}",
                "මල\u{dca} ක\u{dca}\u{200d}ර\u{dd3}ඩ\u{dcf} කරන ක\u{dcf}ඩ\u{dca}පත\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("japonské karty"),
            keywords: &[
                "hra",
                "hracie",
                "japonská",
                "japonské karty",
                "karta",
                "kvetová",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("rožne igralne karte"),
            keywords: &[
                "igra",
                "igranje",
                "japonsko",
                "karta",
                "roža",
                "rožne igralne karte",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("ubaxa turubka"),
            keywords: &[
                "Japanese",
                "ciyaar",
                "ciyaarayaa",
                "kaadh",
                "ubax",
                "ubaxa turubka",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("letra me lule"),
            keywords: &["japoneze", "letra me lule", "letër", "lojë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("карте за играње са цветом"),
            keywords: &[
                "jaпaн",
                "игрa",
                "кaртaњe",
                "кaртe",
                "карте за играње са цветом",
                "цвeћe",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("карте за играње са цвијетом"),
            keywords: &["карте за играње са цвијетом"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("karte za igranje sa cvetom"),
            keywords: &[
                "cveće",
                "igra",
                "japan",
                "kartanje",
                "karte",
                "karte za igranje sa cvetom",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("karte za igranje sa cvijetom"),
            keywords: &["karte za igranje sa cvijetom"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("spelkort med blomma"),
            keywords: &[
                "blomma",
                "kort",
                "kortspel",
                "spelkort",
                "spelkort med blomma",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kadi za karata za maua"),
            keywords: &[
                "kadi",
                "kadi za karata za maua",
                "kijapani",
                "kucheza",
                "maua",
                "mchezo",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("விளைய\u{bbe}ட\u{bcd}டு ச\u{bc0}ட\u{bcd}டு"),
            keywords: &["ச\u{bc0}ட\u{bcd}டு", "பூ", "விளைய\u{bbe}ட\u{bcd}டு"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("జపన\u{c40}స\u{c4d} ప\u{c47}క\u{c3e}ట"),
            keywords: &[
                "జపన\u{c40}స\u{c4d} ప\u{c47}క ముక\u{c4d}క",
                "జపన\u{c40}స\u{c4d} ప\u{c47}క\u{c3e}ట",
                "పువ\u{c4d}వులు",
                "పువ\u{c4d}వులు ఉండ\u{c47} క\u{c3e}ర\u{c4d}డ\u{c4d}",
                "హన\u{c3e}ఫుడ\u{c3e}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("кортҳои бозии \"Гул\""),
            keywords: &[
                "бозикунӣ",
                "бозӣ",
                "гул",
                "корт",
                "кортҳои бозии \"Гул\"",
                "ҷопонӣ",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ไพ\u{e48}ดอกไม\u{e49}"),
            keywords: &[
                "ญ\u{e35}\u{e48}ป\u{e38}\u{e48}น",
                "เกม",
                "เล\u{e48}น",
                "ไพ\u{e48}",
                "ไพ\u{e48}ดอกไม\u{e49}",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gülli kart"),
            keywords: &["gül", "gülli kart", "kart", "oýnamak", "oýun", "ýapon"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("sioka matalaʻiʻakau"),
            keywords: &["sioka matalaʻiʻakau"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("çiçekli oyun kağıtları"),
            keywords: &[
                "hanafuda",
                "kart",
                "kağıt oyunu",
                "oyun",
                "çiçek",
                "çiçekli kart",
                "çiçekli oyun kağıtları",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("گۈللۈك قارتا"),
            keywords: &["ئويناش", "ئويۇن", "قارتا", "ياپونچە", "گۈل", "گۈللۈك قارتا"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("гральні карти з квітами (ханафуда)"),
            keywords: &[
                "гра",
                "гральні карти з квітами",
                "гральні карти з квітами (ханафуда)",
                "грати",
                "карта",
                "ханафуда",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("جاپانی تاش کا کھیل"),
            keywords: &["تاش", "جاپانی", "جاپانی تاش کا کھیل", "کھیل"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("gulli o‘yin kartalari"),
            keywords: &[
                "gul",
                "gulli o‘yin kartalari",
                "karta",
                "o‘yin",
                "o‘ynash",
                "yapon",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("quân bài hình hoa"),
            keywords: &[
                "hoa",
                "kiểu nhật bản",
                "quân bài hình hoa",
                "thiệp",
                "trò chơi",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kàrti fulër"),
            keywords: &["Sapone", "fowe", "fulër", "kàrt", "kàrti fulër", "po"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("amakhasi okudlala entatyambo"),
            keywords: &[
                "amakhasi okudlala entatyambo",
                "ikhadi",
                "intyatyambo",
                "ukudlala",
                "umdlalo",
                "yaseJapan",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Káàdì ìṣeré Olódòdó"),
            keywords: &[
                "Káàdì ìṣeré Olódòdó",
                "eré",
                "japanese",
                "káàdì",
                "òdòdó",
                "ń ṣeré",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("花紙牌"),
            keywords: &["日本", "玩", "紙牌", "花", "花紙牌", "遊戲"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("花纸牌"),
            keywords: &["日本", "游戏", "玩", "纸牌", "花", "花纸牌"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("花札"),
            keywords: &["卡牌", "日本", "游戏", "花札", "花牌"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("花牌"),
            keywords: &["花牌", "花鬥"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("花札紙牌"),
            keywords: &["花啤牌", "花札紙牌", "花牌"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("amakhadi okudlala ayimbali"),
            keywords: &[
                "amakhadi okudlala ayimbali",
                "ikhadi",
                "imbali",
                "japanese",
                "ukudlala",
                "umdlalo",
            ],
        },
    ],
};
