#[doc = "🎃"]
pub const JACK_O_LANTERN: crate::Emoji = crate::Emoji {
    glyph: "🎃",
    codepoint: "1F383",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "jack-o-lantern",
    group: "Activities",
    subgroup: "event",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("pampoenlantern"),
            keywords: &[
                "allerheiligeaand",
                "halloween",
                "pampoen",
                "pampoenlantern",
                "spook",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ጆክ-ኦ-ላንተርን"),
            keywords: &["ሃሎዊን", "ላንተርን", "ክብረ በዓል", "ጃክ", "ጆክ-ኦ-ላንተርን"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("هالوين"),
            keywords: &["قرع", "قرعة مضيئة", "هالوين", "هالويين"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("জেক-অ’-লেণ\u{9cd}ট\u{9be}ৰ\u{9cd}ণ"),
            keywords: &[
                "উদয\u{9be}পন",
                "জেক",
                "জেক-অ’-লেণ\u{9cd}ট\u{9be}ৰ\u{9cd}ণ",
                "লেণ\u{9cd}ট\u{9be}ৰ\u{9cd}ণ",
                "হেল’ৱিন",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("Hellouin balqabağı"),
            keywords: &["Hellouin balqabağı", "bayram", "cek", "fənər", "hellouin"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("гарбузны ліхтар"),
            keywords: &["Хэлоўін", "гарбуз", "гарбузны ліхтар", "ліхтар", "свята"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("тиквен фенер"),
            keywords: &["Тиквен фенер", "празнуване", "тиквен фенер", "хелоуин"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("জ\u{9cd}য\u{9be}কো লণ\u{9cd}ঠন"),
            keywords: &[
                "উদয\u{9be}পন",
                "জ\u{9cd}য\u{9be}ক",
                "জ\u{9cd}য\u{9be}কো লণ\u{9cd}ঠন",
                "লণ\u{9cd}ঠন",
                "হ\u{9cd}য\u{9be}লোইন",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("jack-oʼ-lantern"),
            keywords: &[
                "fest",
                "gouel",
                "halloween",
                "jack-oʼ-lantern",
                "letern",
                "lid",
                "sitrouilhez",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("bundevina glava"),
            keywords: &[
                "bundeva",
                "bundevina glava",
                "glava",
                "noć vještica",
                "praznik",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("carabassa de Halloween"),
            keywords: &[
                "Halloween",
                "carabassa",
                "carabassa de Halloween",
                "celebració",
                "llanterna",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏤᎩ-ᎠᏨᏍᏗ"),
            keywords: &["ᎠᎾᎵᎮᎵᎬᎢ", "ᎠᏨᏍᏗ", "ᏤᎩ", "ᏤᎩ-ᎠᏨᏍᏗ", "ᏧᎾᎵᎬᏚᎶᏗᎢ ᎤᏒ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("dýňová lucerna"),
            keywords: &["dýně", "dýňová lucerna", "halloween", "oslava", "svátek"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("jack-o-lantern"),
            keywords: &[
                "calan gaeaf",
                "dathliad",
                "jack-o-lantern",
                "llusern",
                "pwmpen",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("græskarmand"),
            keywords: &["græskar", "græskarlygte", "græskarmand", "halloween"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Halloweenkürbis"),
            keywords: &["Halloween", "Halloweenkürbis", "Kürbis"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("φανάρι από κολοκύθα"),
            keywords: &[
                "απόκριες",
                "γιορτή",
                "κολοκύθα",
                "φανάρι",
                "φανάρι από κολοκύθα",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("jack-o-lantern"),
            keywords: &[
                "celebration",
                "halloween",
                "jack",
                "jack-o-lantern",
                "lantern",
            ],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("jack-o’-lantern"),
            keywords: &[
                "celebration",
                "halloween",
                "jack",
                "jack-o’-lantern",
                "lantern",
                "pumpkin",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "Halloween",
                "celebration",
                "jack",
                "jack-o-lantern",
                "jack-o’-lantern",
                "lantern",
            ],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("calabaza de Halloween"),
            keywords: &[
                "Halloween",
                "calabaza",
                "calabaza de Halloween",
                "celebración",
                "linterna",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("calabaza"),
            keywords: &["Halloween", "calabaza", "linterna"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kõrvitsalatern"),
            keywords: &["halloween", "kõrvits", "kõrvitsalatern", "latern"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("halloweeneko kuia"),
            keywords: &["halloween", "halloweeneko kuia", "kuia", "ospakizun"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("فانوس کدو تنبل"),
            keywords: &["جشن", "فانوس", "فانوس کدو تنبل", "هالووین"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kurpitsalyhty"),
            keywords: &[
                "halloween",
                "juhla",
                "kaivertaa",
                "kurpitsa",
                "kurpitsalyhty",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("jack-o-lantern"),
            keywords: &[
                "dekorasyon",
                "halloween",
                "jack",
                "jack-o-lantern",
                "lantern",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("graskarhøvd"),
            keywords: &[
                "allahalgannaaftan",
                "graskar",
                "graskarhøvd",
                "halloween",
                "høvd",
                "lanterna",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("citrouille"),
            keywords: &["citrouille", "citrouille lanterne", "halloween"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("Seán na gealaí"),
            keywords: &[
                "Oíche Shamhna",
                "Seán na Gealaí",
                "Seán na gealaí",
                "cóisir",
                "puimcín",
                "tine ghealáin",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("lanntair peapaig"),
            keywords: &[
                "comharrachadh",
                "lanntair",
                "lanntair peapaig",
                "oidhche shamhna",
                "peapag",
                "samhainn",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cabaza de Samaín"),
            keywords: &[
                "Halloween",
                "Samaín",
                "cabaza",
                "cabaza de Samaín",
                "celebración",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("જ\u{ac7}ક-ઓ-લ\u{ac7}ન\u{acd}ટર\u{acd}ન"),
            keywords: &[
                "ઉજવણી",
                "કોળ\u{ac1}\u{a82}",
                "જ\u{ac7}ક",
                "જ\u{ac7}ક-ઓ-લ\u{ac7}ન\u{acd}ટર\u{acd}ન",
                "લ\u{ac7}ન\u{acd}ટર\u{acd}ન",
                "હ\u{ac7}લોવિન",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("jack-o-lantern"),
            keywords: &[
                "bikin halloween",
                "fitila",
                "jack",
                "jack-o-lantern",
                "shagali",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מנורת דלעת"),
            keywords: &["אור", "דלעת", "מנורה", "מנורת דלעת"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ज\u{948}क–ओ–ल\u{948}\u{902}टर\u{94d}न, क\u{902}दील"),
            keywords: &[
                "क\u{902}दील",
                "कद\u{94d}द\u{942}",
                "ज\u{948}क",
                "ज\u{948}क–ओ–ल\u{948}\u{902}टर\u{94d}न",
                "ज\u{948}क–ओ–ल\u{948}\u{902}टर\u{94d}न, क\u{902}दील",
                "लालट\u{947}न",
                "समारोह",
                "ह\u{948}लोवीन",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("izrezbarena bundeva"),
            keywords: &["bundeva", "izrezbarena bundeva", "noć vještica", "slavlje"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("töklámpás"),
            keywords: &[
                "halloween",
                "töklámpa",
                "töklámpás",
                "ünnep",
                "ünnepi hangulat",
                "ünneplés",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ջեքի լապտեր"),
            keywords: &["լապտեր", "հելոուին", "ջեք", "ջեքի լապտեր", "տոն"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("jack-o-lantern"),
            keywords: &["halloween", "jack", "jack-o-lantern", "lentera", "perayaan"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("Jack-o-lantern"),
            keywords: &[
                "Jack-o-lantern",
                "enwemụaṅụrị",
                "hallowinụ",
                "jacki",
                "mpanaaka",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hrekkjavökugrasker"),
            keywords: &["hrekkjavaka", "hrekkjavökugrasker", "hátíð"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("zucca di Halloween"),
            keywords: &["Halloween", "festa", "zucca", "zucca di Halloween"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ハロウィンかぼちゃ"),
            keywords: &[
                "かぼちゃ",
                "ハロウィン",
                "ハロウィンかぼちゃ",
                "ハロウィーン",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("lampion jack-o-lantern"),
            keywords: &[
                "halloween",
                "jack",
                "jack-o-lantern",
                "lampion jack-o-lantern",
                "lampion labu",
                "perayaan",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ჰელოუინის გოგრა"),
            keywords: &[
                "აღნიშვნა",
                "გოგრა",
                "ზეიმი",
                "ფარანი",
                "ჰელოუინი",
                "ჰელოუინის გოგრა",
            ],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("taxsayt"),
            keywords: &["taxsayt"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("асқабақтан жасалған шам"),
            keywords: &[
                "асқабақ",
                "асқабақтан жасалған шам",
                "саңылау",
                "тойлау",
                "хэллоуин",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("græskarlygte"),
            keywords: &["græskar", "græskarlygte"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bb}ខល\u{17d2}ពៅ"),
            keywords: &["ម\u{17bb}ខ", "ម\u{17bb}ខល\u{17d2}ពៅ", "ល\u{17d2}ពៅ"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕೊಳ\u{ccd}ಳ\u{cbf}ದ\u{cc6}ವ\u{ccd}ವ"),
            keywords: &[
                "ಆಚರಣ\u{cc6}",
                "ಕೊಳ\u{ccd}ಳ\u{cbf}ದ\u{cc6}ವ\u{ccd}ವ",
                "ಜ\u{ccd}ಯಾಕ\u{ccd}",
                "ಲಾಟೀನು",
                "ಹ\u{ccd}ಯಾಲೋವೀನ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("할로윈"),
            keywords: &["할로윈", "할로윈 장식", "할로윈 호박", "핼러윈"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ज\u{945}क-ओ-ल\u{945}न\u{94d}टर\u{94d}न"),
            keywords: &[
                "ज\u{945}क",
                "ज\u{945}क-ओ-ल\u{945}न\u{94d}टर\u{94d}न",
                "ल\u{945}न\u{94d}टर\u{94d}न",
                "स\u{941}वाळो",
                "ह\u{945}लोविन",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("ашкабактан лампа"),
            keywords: &["ашкабактан лампа", "майрам", "хэллоуин"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Halloweenkürbis"),
            keywords: &["Feier", "Halloween", "Halloweenkürbis", "Kürbis", "Lampion"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໂຄມໄຟໝາກອ\u{eb6}"),
            keywords: &[
                "ຕະກຽງ",
                "ວ\u{eb1}ນຮາໂລວ\u{eb5}ນ",
                "ໂຄມໄຟໝາກອ\u{eb6}",
                "ໝາກອ\u{eb6}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("žibintas iš moliūgo"),
            keywords: &["helovinas", "šventė", "žibintas", "žibintas iš moliūgo"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("izgrebts ķirbis"),
            keywords: &[
                "Helovīns",
                "izgrebts ķirbis",
                "svētki",
                "visu svēto dienas priekšvakars",
                "ķirbis",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("rama kanohi paukena"),
            keywords: &[
                "haki",
                "harowēne",
                "rama",
                "rama kanohi paukena",
                "whakanuinga",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("фенер од тиква"),
            keywords: &["вештерки", "ноќ", "прослава", "фенер", "фенер од тиква"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ജ\u{d3e}ക\u{d4d}ക\u{d4d} ഓ ല\u{d3e}ന\u{d4d}റേൺ"),
            keywords: &[
                "ആഘോഷം",
                "ജ\u{d3e}ക\u{d4d}ക\u{d4d} ഓ ല\u{d3e}ന\u{d4d}റേൺ",
                "മത\u{d4d}തങ\u{d4d}ങ",
                "റ\u{d3e}ന\u{d4d}തൽ",
                "വിളക\u{d4d}ക\u{d41}ക\u{d42}ട\u{d4d}",
                "ഹ\u{d3e}ളോവീൻ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хулуугаар хийсэн дэнлүү"),
            keywords: &[
                "аймшгийн баяр",
                "дэнлүү",
                "хулуу",
                "хулуугаар хийсэн дэнлүү",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("भोपळ\u{94d}\u{200d}यापास\u{942}न बनविल\u{947}ला क\u{902}दील"),
            keywords: &[
                "उत\u{94d}सव",
                "क\u{902}दील",
                "भोपळा",
                "भोपळ\u{94d}\u{200d}यापास\u{942}न बनविल\u{947}ला क\u{902}दील",
                "ह\u{945}लोविन",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("tanglung labu"),
            keywords: &["halloween", "jack", "perayaan", "tanglung", "tanglung labu"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("jack-o-lantern"),
            keywords: &[
                "halloween",
                "jack",
                "jack-o-lantern",
                "lantern",
                "ċelebrazzjoni",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဖရ\u{102f}\u{1036}သ\u{102e}း မ\u{102e}းအ\u{102d}မ\u{103a}"),
            keywords: &[
                "ပ\u{103d}\u{1032}တော\u{103a}",
                "ဖရ\u{102f}\u{1036}သ\u{102e}း မ\u{102e}းအ\u{102d}မ\u{103a}",
                "မ\u{102e}းအ\u{102d}မ\u{103a}",
                "ဟော\u{103a}လ\u{102d}\u{102f}ဝင\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("gresskarlykt"),
            keywords: &["Halloween", "gresskar", "gresskarlykt", "halloweenlykt"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ज\u{94d}याक-ओ-लालटिन"),
            keywords: &[
                "ज\u{94d}याक",
                "ज\u{94d}याक-ओ-लालटिन",
                "लालटिन",
                "समारोह",
                "हलोवन",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("halloweenlantaarn"),
            keywords: &[
                "feest",
                "halloween",
                "halloweenlantaarn",
                "lantaarn",
                "pompoen",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("graskarlykt"),
            keywords: &["Halloween", "graskar", "graskarlykt", "halloweenlykt"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଜ\u{b4d}ୟ\u{b3e}କ\u{b4d}-ଓ-ଲଣ\u{b4d}ଠନ"),
            keywords: &[
                "ଉତ\u{b4d}ସବ",
                "କଖ\u{b3e}ର\u{b41}",
                "ଜ\u{b4d}ୟ\u{b3e}କ\u{b4d}-ଓ-ଲଣ\u{b4d}ଠନ",
                "ଲଣ\u{b4d}ଠନ",
                "ହ\u{b3e}ଲ\u{b4d}ଲୋୱ\u{b3f}ନ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਜ\u{a48}ਕ-ਓ-ਲ\u{a48}\u{a02}ਟਰਨ"),
            keywords: &[
                "ਜਸ\u{a3c}ਨ",
                "ਜ\u{a48}ਕ",
                "ਜ\u{a48}ਕ-ਓ-ਲ\u{a48}\u{a02}ਟਰਨ",
                "ਲਾਲਟ\u{a48}ਣ",
                "ਹ\u{a48}ਲ\u{a4b}ਵੀਨ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("آت\u{64e}شیں س\u{64e}راب"),
            keywords: &[
                "آت\u{64e}شیں س\u{64e}راب",
                "جیک",
                "لالٹین",
                "منانا",
                "ہالوین",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Jak-O-Lántan"),
            keywords: &[
                "Hálowiin",
                "Jak",
                "Jak-O-Lántan",
                "Ják-O-Lamp",
                "Lamp",
                "Sẹlibréshọn",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("dynia na halloween"),
            keywords: &["dynia", "dynia na halloween", "halloween"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د کدو لالټين"),
            keywords: &["جيک", "د کدو لالټين", "لالټين", "لمانځنه", "هالووين"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("abóbora de halloween"),
            keywords: &[
                "abóbora",
                "abóbora de halloween",
                "comemoração",
                "halloween",
                "jack",
                "lanterna",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &[
                "abóbora",
                "abóbora de halloween",
                "celebração",
                "dia das bruxas",
                "halloween",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("mathi"),
            keywords: &["halloween", "jack", "linterna", "mathi", "raymi"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("dovleac cu felinar"),
            keywords: &[
                "Halloween",
                "dovleac cu felinar",
                "jack-o-lantern",
                "lumânare",
                "sărbătoare",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-328"),
            keywords: &["E10-328"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("тыква-фонарь"),
            keywords: &[
                "Хеллоуин",
                "праздник",
                "тыква",
                "тыква-фонарь",
                "фонарь из тыквы",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("itara rya jack-o"),
            keywords: &[
                "halowini",
                "ibirori",
                "imbonesha",
                "itara rya halowini",
                "itara rya jack-o",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("جيڪ او لالٽين"),
            keywords: &["جيڪ او لالٽين", "سيليبريشن، هالووين، جيڪ، لالٽين"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ජැකෝ ලැන\u{dca}ටර\u{dca}න\u{dca}"),
            keywords: &[
                "ජැක\u{dca}",
                "ජැකෝ ලැන\u{dca}ටර\u{dca}න\u{dca}",
                "ල\u{dcf}ම\u{dca}ප\u{dd4}ව",
                "සැමර\u{dd4}ම",
                "හැලොව\u{dd3}න\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("halloweenská tekvica"),
            keywords: &[
                "halloween",
                "halloweenska tekvica",
                "halloweenská tekvica",
                "oslava",
                "svietnik",
                "tekvica",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("izrezljana buča"),
            keywords: &[
                "buča",
                "izrezljana buča",
                "laterna",
                "noč čarovnic",
                "slavje",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("jack-o-cirifka"),
            keywords: &[
                "cirifka",
                "dabaaldag",
                "halloween",
                "jack",
                "jack-o-cirifka",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kungulli i Halloween"),
            keywords: &[
                "fener",
                "festë",
                "halloween",
                "kungull",
                "kungulli i Halloween",
                "kungulli i Halloween-it",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("светиљка од бундеве"),
            keywords: &[
                "нoћ вeштицa",
                "прослава",
                "светиљка",
                "светиљка од бундеве",
                "тиква",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("свјетиљка од бундеве"),
            keywords: &["свјетиљка од бундеве"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("svetiljka od bundeve"),
            keywords: &[
                "noć veštica",
                "proslava",
                "svetiljka",
                "svetiljka od bundeve",
                "tikva",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("svjetiljka od bundeve"),
            keywords: &["svjetiljka od bundeve"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("lyktgubbe"),
            keywords: &["Halloween", "fest", "lykta", "lyktgubbe", "pumpa"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("taa ya malenge yenye umbo la uso wa mtu"),
            keywords: &[
                "halloween",
                "jack",
                "kusherehekea",
                "taa",
                "taa ya malenge yenye umbo la uso wa mtu",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பூசணிக\u{bcd}க\u{bbe}ய\u{bcd} முகம\u{bcd}"),
            keywords: &[
                "கொண\u{bcd}ட\u{bbe}ட\u{bcd}டம\u{bcd}",
                "பூசணிக\u{bcd}க\u{bbe}ய\u{bcd}",
                "பூசணிக\u{bcd}க\u{bbe}ய\u{bcd} முகம\u{bcd}",
                "ஹேலோவின\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("జపన\u{c40}స\u{c4d} గుమ\u{c4d}మడ\u{c3f}క\u{c3e}య"),
            keywords: &[
                "గుమ\u{c4d}మడ\u{c3f}",
                "జపన\u{c40}స\u{c4d} గుమ\u{c4d}మడ\u{c3f}క\u{c3e}య",
                "జప\u{c3e}న\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("чароғак аз каду бо сӯрохиҳои даҳон, бинӣ ва чашмон"),
            keywords: &[
                "сурохӣ",
                "хеллоуин",
                "чароғ",
                "чароғак аз каду бо сӯрохиҳои даҳон, бинӣ ва чашмон",
                "ҷашн",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ฟ\u{e31}กทองฮาโลว\u{e35}น"),
            keywords: &["ฟ\u{e31}กทอง", "ฟ\u{e31}กทองฮาโลว\u{e35}น"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("otly kädi"),
            keywords: &["baýramçylyk", "el çyrasy", "hellouin", "kädi", "otly kädi"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("matahina"),
            keywords: &["matahina"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kabak fener"),
            keywords: &[
                "cadılar bayramı",
                "fener",
                "halloween",
                "jack",
                "kabak",
                "kutlama",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("كاۋا چىراق"),
            keywords: &[
                "تەبرىكلەش",
                "كاۋا چىراق",
                "پانۇس",
                "پەرىشتە بايرىمى",
                "چىراق",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("ліхтар-гарбуз"),
            keywords: &[
                "гарбуз",
                "ліхтар",
                "ліхтар-гарбуз",
                "святкування",
                "хелловін",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کدو کی لالٹین"),
            keywords: &["جیک", "خوشی منانا", "لالٹین", "کدو کی لالٹین", "ہالووین"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("shamchiroqli oshqovoq"),
            keywords: &[
                "bayram",
                "halloween",
                "nishonlash",
                "oshqovoq",
                "shamchiroqli oshqovoq",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("đèn lồng bí ngô"),
            keywords: &[
                "halloween",
                "lễ hội",
                "lồng",
                "lồng đèn bí ngô",
                "đèn lồng",
                "đèn lồng bí ngô",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("naajo alowiin"),
            keywords: &["alowiin", "jak", "làntern", "màggal", "naajo alowiin"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-Jack-o-lantern"),
            keywords: &[
                "i-Jack-o-lantern",
                "i-halloween",
                "i-jack",
                "isibane",
                "umbhiyozo",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Jack-o-Atupa"),
            keywords: &["Jack-o-Atupa", "alowínì", "ayẹyẹ", "jáàkì", "àtùpà"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("南瓜燈籠"),
            keywords: &["南瓜", "南瓜燈籠", "慶祝", "燈籠", "萬聖節"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("南瓜灯笼"),
            keywords: &["万圣节", "南瓜", "南瓜灯笼", "庆祝", "灯笼"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("南瓜灯"),
            keywords: &["万圣节", "南瓜灯", "庆祝", "灯笼"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("南瓜燈"),
            keywords: &["南瓜", "南瓜燈"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("i-jack-o-lantern"),
            keywords: &[
                "i-halloween",
                "i-jack-o-lantern",
                "ijack",
                "ilambu",
                "umbungazo",
            ],
        },
    ],
};
#[doc = "🎄"]
pub const CHRISTMAS_TREE: crate::Emoji = crate::Emoji {
    glyph: "🎄",
    codepoint: "1F384",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "Christmas tree",
    group: "Activities",
    subgroup: "event",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("kersboom"),
            keywords: &["Kersfees", "boom", "kersboom", "viering"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የገና ዛፍ"),
            keywords: &["ክብረ በዓል", "ዛፍ", "የገና ዛፍ", "ገና"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("شجرة عيد الميلاد"),
            keywords: &["شجرة", "شجرة عيد الميلاد"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("বৰদিনৰ গছ"),
            keywords: &["উদয\u{9be}পন", "গছ", "বৰদিন", "বৰদিনৰ গছ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("milad ağacı"),
            keywords: &["ağac", "bayram", "milad", "milad ağacı"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("навагодняя ёлка"),
            keywords: &["Каляды", "навагодняя ёлка", "ялінка", "ёлка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("коледна елха"),
            keywords: &[
                "Коледна елха",
                "елха",
                "коледа",
                "коледна елха",
                "празнуване",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ক\u{9cd}রিসম\u{9be}স ট\u{9cd}রী"),
            keywords: &[
                "উদয\u{9be}পন",
                "ক\u{9cd}রিসম\u{9be}স",
                "ক\u{9cd}রিসম\u{9be}স ট\u{9cd}রী",
                "গ\u{9be}ছ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("gwezenn Nedeleg"),
            keywords: &["Nedeleg", "fest", "gouel", "gwezenn", "lid"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("božićno drvce"),
            keywords: &["božić", "božićno drvce", "drvo", "praznik"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("arbre de Nadal"),
            keywords: &["Nadal", "arbre", "arbre de Nadal", "celebració"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏓᏂᏍᏓᏲᎯᎲᎢ ᎢᏡᎬᎢ"),
            keywords: &["ᎠᎾᎵᎮᎵᎬᎢ", "ᎢᏡᎬᎢ", "ᏓᏂᏍᏓᏲᎯᎲᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("vánoční stromeček"),
            keywords: &[
                "oslava",
                "strom",
                "svátek",
                "svátky",
                "vánoce",
                "vánoční stromeček",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("coeden nadolig"),
            keywords: &["coeden", "dathliad", "nadolig"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("juletræ"),
            keywords: &["jul", "juletræ", "træ"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Weihnachtsbaum"),
            keywords: &["Baum", "Tanne", "Weihnachten", "Weihnachtsbaum"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("χριστουγεννιάτικο δέντρο"),
            keywords: &[
                "γιορτή",
                "δέντρο",
                "χριστουγεννιάτικο δέντρο",
                "χριστούγεννα",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("Christmas tree"),
            keywords: &["Christmas", "celebration", "tree"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("árbol de Navidad"),
            keywords: &[
                "Navidad",
                "abeto de Navidad",
                "celebración",
                "árbol",
                "árbol de Navidad",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["celebración", "navidad", "árbol", "árbol de Navidad"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["Navidad", "celebración", "árbol", "árbol de Navidad"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("jõulupuu"),
            keywords: &["jõulud", "jõulupuu", "kuusk", "pühad"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("gabonetako zuhaitza"),
            keywords: &["gabonak", "gabonetako zuhaitza", "ospakizun", "zuhaitz"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("درخت کریسمس"),
            keywords: &["جشن", "درخت", "کریسمس"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("joulukuusi"),
            keywords: &["joulu", "joulukuusi", "joulupuu", "juhla", "kuusi"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("christmas tree"),
            keywords: &["christmas", "christmas tree", "holiday", "pasko"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("jólatræ"),
            keywords: &["jól", "jólatræ", "træ"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("sapin de Noël"),
            keywords: &["Noël", "arbre", "fête", "sapin de Noël"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["célébration", "noël", "sapin de Noël"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("crann Nollag"),
            keywords: &["Nollaig", "ceiliúradh", "crann", "crann Nollag"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("craobh Nollaig"),
            keywords: &["comharrachadh", "craobh", "craobh Nollaig", "nollaig"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("árbore de Nadal"),
            keywords: &["Nadal", "celebración", "árbore", "árbore de Nadal"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("નાતાલ વ\u{ac3}ક\u{acd}ષ"),
            keywords: &["ઉજવણી", "નાતાલ વ\u{ac3}ક\u{acd}ષ", "વ\u{ac3}ક\u{acd}ષ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("bishiyar kirsimati"),
            keywords: &["Kirsmati", "bishiya", "bishiyar kirsimati", "shagali"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("עץ אשוח מקושט"),
            keywords: &["אשוח", "חג המולד", "כריסמס", "מקושט", "עץ אשוח מקושט"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("क\u{94d}रिसमस ट\u{94d}री"),
            keywords: &[
                "उत\u{94d}सव",
                "क\u{94d}रिसमस ट\u{94d}री",
                "प\u{947}ड\u{93c}",
                "समारोह",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("božićno drvce"),
            keywords: &["božić", "božićno drvce", "drvo", "slavlje"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("karácsonyfa"),
            keywords: &["fa", "fenyőfa", "karácsony", "karácsonyfa", "ünnep"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("տոնածառ"),
            keywords: &["ծառ", "սուրբ ծնունդ", "տոն", "տոնածառ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("pohon Natal"),
            keywords: &["natal", "perayaan", "pohon", "pohon Natal"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("osisi Ekeresìmesì"),
            keywords: &["Ekeresìmesì", "enwemụaṅụrị", "osisi"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("jólatré"),
            keywords: &["hátíð", "jól", "jólatré", "tré"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("albero di Natale"),
            keywords: &["Natale", "albero", "albero di Natale", "festa"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("クリスマスツリー"),
            keywords: &["クリスマス", "クリスマスイブ", "クリスマスツリー", "ツリー"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("Uwit Natal"),
            keywords: &["Natal", "Uwit Natal", "perayaan", "uwit"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("საახალწლო ნაძვის ხე"),
            keywords: &[
                "აღნიშვნა",
                "ახალი წელი",
                "ზეიმი",
                "საახალწლო ნაძვის ხე",
                "შობა",
                "ხე",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("Рождество шыршасы"),
            keywords: &["Рождество шыршасы", "рождество", "тойлау", "шырша"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("juletræ"),
            keywords: &["jul", "juletræ", "træ"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ដើមគ\u{17d2}រ\u{17b8}ស\u{17d2}តម\u{17c9}ាស"),
            keywords: &[
                "ការប\u{17d2}រារព\u{17d2}ធព\u{17b7}ធ\u{17b8}",
                "ដើមគ\u{17d2}រ\u{17b8}ស\u{17d2}តម\u{17c9}ាស",
                "ដើមគ\u{17d2}រ\u{17b8}ស\u{17d2}ទម\u{17c9}ាស",
                "ណ\u{17bc}អែល",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕ\u{ccd}ರ\u{cbf}ಸ\u{ccd}ಮಸ\u{ccd} ಮರ"),
            keywords: &["ಆಚರಣ\u{cc6}", "ಕ\u{ccd}ರ\u{cbf}ಸ\u{ccd}ಮಸ\u{ccd}", "ಮರ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("크리스마스 트리"),
            keywords: &["크리스마스", "크리스마스 트리"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("नाताळाच\u{947}\u{902} झाड"),
            keywords: &["झाड", "नाताळ", "नाताळाच\u{947}\u{902} झाड", "स\u{941}वाळो"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("Рождество балатысы"),
            keywords: &["Рождество балатысы", "балаты", "майрам", "рождество"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Chrëschtbeemchen"),
            keywords: &["Bam", "Chrëschtbeemchen", "Chrëschtdag", "Feier"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຕ\u{ebb}\u{ec9}ນຄຣ\u{eb4}ດມາສ"),
            keywords: &["ຄຣ\u{eb4}ດມາສ", "ຕ\u{ebb}\u{ec9}ນຄຣ\u{eb4}ດມາສ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("Kalėdų eglutė"),
            keywords: &["Kalėdos", "Kalėdų eglutė", "eglutė", "šventė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("Ziemassvētku eglīte"),
            keywords: &["Ziemassvētki", "Ziemassvētku eglīte", "koks", "svētki"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("rākau Kirihimete"),
            keywords: &["Kirihimete", "rākau", "whakanuinga"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("новогодишна елка"),
            keywords: &["година", "дрво", "нова", "новогодишна елка", "прослава"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ക\u{d4d}രിസ\u{d4d}മസ\u{d4d} ട\u{d4d}രീ"),
            keywords: &[
                "ആഘോഷം",
                "ക\u{d4d}രിസ\u{d4d}മസ\u{d4d}",
                "ക\u{d4d}രിസ\u{d4d}മസ\u{d4d} മരം",
                "ട\u{d4d}രീ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("зул сарын гацуур"),
            keywords: &["Зул сар", "зул сарын гацуур", "мод", "тэмдэглэх"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ख\u{94d}रिसमस ट\u{94d}री"),
            keywords: &[
                "उत\u{94d}सव",
                "ख\u{94d}रिसमस",
                "ख\u{94d}रिसमस ट\u{94d}री",
                "झाड",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("pokok krismas"),
            keywords: &["krismas", "perayaan", "pokok"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("siġra tal-Milied"),
            keywords: &["Milied", "siġra", "siġra tal-Milied", "ċelebrazzjoni"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ခရစ\u{1039}စမတ\u{103a} အပင\u{103a}"),
            keywords: &[
                "ခရစ\u{1039}စမတ\u{103a}",
                "ပ\u{103d}\u{1032}တော\u{103a}",
                "အပင\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("juletre"),
            keywords: &["høytid", "jul", "julefeiring", "juletre", "tre"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("क\u{94d}रिस\u{94d}मसको र\u{942}ख"),
            keywords: &[
                "क\u{94d}रिस\u{94d}मस",
                "क\u{94d}रिस\u{94d}मसको र\u{942}ख",
                "र\u{942}ख",
                "समारोह",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("kerstboom"),
            keywords: &["Kerstmis", "boom", "kerstboom", "viering"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("juletre"),
            keywords: &["høgtid", "jul", "julefeiring", "juletre", "tre"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଖ\u{b4d}ରୀଷ\u{b4d}ଟମ\u{b3e}ସ ବ\u{b43}କ\u{b4d}ଷ"),
            keywords: &[
                "ଉତ\u{b4d}ସବ",
                "ଖ\u{b4d}ରୀଷ\u{b4d}ଟମ\u{b3e}ସ ବ\u{b43}କ\u{b4d}ଷ",
                "ବ\u{b43}କ\u{b4d}ଷ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕ\u{a4d}ਰਿਸਮਸ ਟ\u{a4d}ਰੀ"),
            keywords: &[
                "ਕ\u{a4d}ਰਿਸਮਸ ਟ\u{a4d}ਰੀ",
                "ਕ\u{a4d}ਰਿਸਮਸ ਰ\u{a41}\u{a71}ਖ",
                "ਜਸ\u{a3c}ਨ",
                "ਰ\u{a41}\u{a71}ਖ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کرسمس ٹری"),
            keywords: &["درخت", "منانا", "کرسمس", "کرسمس ٹری"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Krísmás Tri"),
            keywords: &["Fẹ\u{301}stíval", "Krísmás", "Tri"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("choinka bożonarodzeniowa"),
            keywords: &[
                "boże narodzenie",
                "choinka bożonarodzeniowa",
                "drzewko",
                "święta",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د کريسمس ونه"),
            keywords: &["د کريسمس ونه", "لمانځنه", "ونه", "کريسمس"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("árvore de natal"),
            keywords: &["comemoração", "árvore", "árvore de natal"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["celebração", "natal", "árvore", "árvore de natal"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("Navidad sachʼa"),
            keywords: &["Navidad", "Navidad sachʼa", "raymi", "sach’a"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("brad de Crăciun"),
            keywords: &["Crăciun", "brad", "brad de Crăciun", "sărbătoare"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-329"),
            keywords: &["E10-329"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("новогодняя елка"),
            keywords: &[
                "Новый год",
                "Рождество",
                "елка",
                "новогодняя елка",
                "праздник",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("igiti cya Noheli"),
            keywords: &["Noheli", "ibirori", "igiti", "igiti cya Noheli"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪرشمس وڻ"),
            keywords: &["جشن، ڪرشمس، وڻ", "ڪرشمس وڻ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("නත\u{dca}තල\u{dca} ගස"),
            keywords: &["ගස", "නත\u{dca}තල\u{dca}", "සැමර\u{dd4}ම"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("vianočný stromček"),
            keywords: &["oslava", "stromček", "vianoce", "vianočný stromček"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("jelka"),
            keywords: &["božič", "drevešček", "jelka", "slavje"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("geedka Ciid Masiixigga"),
            keywords: &[
                "dabbaaldeg",
                "geed",
                "geed Ciid Masiixi",
                "geedka Ciid Masiixigga",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("pemë krishtlindjeje"),
            keywords: &[
                "festim",
                "festë",
                "krishtlindje",
                "pemë",
                "pemë krishtlindjeje",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("божићна јелка"),
            keywords: &["бoжић", "божићна јелкa", "божићна јелка", "прославa"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["божићна јелка"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("božićna jelka"),
            keywords: &["božić", "božićna jelka", "proslava"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["božićna jelka"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("julgran"),
            keywords: &["gran", "högtid", "jul", "julgran"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mti wa krismasi"),
            keywords: &["krismasi", "mti", "mti wa krismasi", "sherehe"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கிறிஸ\u{bcd}துமஸ\u{bcd} மரம\u{bcd}"),
            keywords: &[
                "கிறிஸ\u{bcd}துமஸ\u{bcd} க\u{bbe}லம\u{bcd}",
                "கிறிஸ\u{bcd}துமஸ\u{bcd} மரம\u{bcd}",
                "பசுமை",
                "மரம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("క\u{c4d}ర\u{c3f}స\u{c4d}మస\u{c4d} చ\u{c46}ట\u{c4d}టు"),
            keywords: &[
                "ఉత\u{c4d}సవం",
                "క\u{c4d}ర\u{c3f}స\u{c4d}మస\u{c4d}",
                "చ\u{c46}ట\u{c4d}టు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("дарахти Мавлуди Исо"),
            keywords: &["дарахт", "дарахти Мавлуди Исо", "мавлуди Исо", "ҷашн"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ต\u{e49}นคร\u{e34}สต\u{e4c}มาส"),
            keywords: &["คร\u{e34}สต\u{e4c}มาส", "ต\u{e49}นคร\u{e34}สต\u{e4c}มาส"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("täze ýyl agajy"),
            keywords: &["Roždestwo", "agaç", "baýramçylyk", "täze ýyl agajy"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ʻakau kilisimasi"),
            keywords: &["ʻakau kilisimasi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("Noel ağacı"),
            keywords: &["Noel ağacı", "ağaç", "kutlama"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("مىلاد دەرىخى"),
            keywords: &["تەبرىكلەش", "دەرەخ", "مىلاد", "مىلاد دەرىخى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("різдвяна ялинка"),
            keywords: &[
                "дерево",
                "різдво",
                "різдвяна ялинка",
                "святкування",
                "ялинка",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کرسمس کا درخت"),
            keywords: &["جشن", "درخت", "کرسمس", "کرسمس کا درخت"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("yangi yil archasi"),
            keywords: &["Rojdestvo", "daraxt", "nishonlash", "yangi yil archasi"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("cây thông noel"),
            keywords: &["cây", "cây thông noel", "giáng sinh", "lễ kỷ niệm"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("garabu nowel"),
            keywords: &["garab", "garabu nowel", "màggal", "nowel"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umthi wekrismesi"),
            keywords: &["iKrismesi", "umbhiyozo", "umthi", "umthi wekrismesi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Igi Keresimesi"),
            keywords: &["Igi Keresimesi", "ayẹyẹ", "igi", "kérésìmesì"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("聖誕樹"),
            keywords: &["慶祝", "樹", "聖誕樹", "聖誕節"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("圣诞树"),
            keywords: &["圣诞树", "圣诞节", "庆祝", "树"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("圣诞树"),
            keywords: &["圣诞", "圣诞树", "庆祝", "树"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("聖誕樹"),
            keywords: &["聖誕樹"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isihlahla sikaKhisimusi"),
            keywords: &[
                "isihlahla",
                "isihlahla sikaKhisimusi",
                "uKhisimusi",
                "umbungazo",
            ],
        },
    ],
};
#[doc = "🎆"]
pub const FIREWORKS: crate::Emoji = crate::Emoji {
    glyph: "🎆",
    codepoint: "1F386",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "fireworks",
    group: "Activities",
    subgroup: "event",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("vuurwerke"),
            keywords: &["liggies", "skiet", "viering", "vuurwerke"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ርችት"),
            keywords: &["ርችት", "ክብረ በዓል"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ألعاب نارية"),
            keywords: &["ألعاب نارية", "حفلة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("আতচব\u{9be}জী"),
            keywords: &["আতচব\u{9be}জী", "উদয\u{9be}পন"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("fişənglər"),
            keywords: &["bayram", "fişənglər"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("феерверк"),
            keywords: &["святкаванне", "феерверк"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("фойерверки"),
            keywords: &["празнуване", "фойерверки"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("আতস ব\u{9be}জি"),
            keywords: &["আতস ব\u{9be}জি", "উদয\u{9be}পন"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("tan-arvest"),
            keywords: &["fest", "gouel", "lid", "tan", "tan-arvest"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("vatromet"),
            keywords: &["proslava", "vatromet", "zabava"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("focs d’artifici"),
            keywords: &["celebració", "focs artificials", "focs d’artifici"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᏔᏍᎩᏍᎩ"),
            keywords: &["ᎠᎾᎵᎮᎵᎬᎢ", "ᏗᏔᏍᎩᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("ohňostroj"),
            keywords: &["ohňostroj", "oslava"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("tân gwyllt"),
            keywords: &["dathliad", "tân gwyllt"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("fyrværkeri"),
            keywords: &["fest", "fyrværkeri", "nytår"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Feuerwerk"),
            keywords: &["Feuerwerk", "Silvester"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("βεγγαλικά"),
            keywords: &["βεγγαλικά", "γιορτή"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("fireworks"),
            keywords: &["celebration", "fireworks"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("fuegos artificiales"),
            keywords: &["celebración", "fuegos artificiales"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["artificiales", "celebración", "festejo", "fiesta", "fuegos"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("ilutulestik"),
            keywords: &["ilutulestik", "tähistamine"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("su artifizialak"),
            keywords: &["ospakizun", "su artifizialak"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("آتش\u{200c}بازی"),
            keywords: &["آتش\u{200c}بازی", "بزرگداشت", "جشن", "عید"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("ilotulitus"),
            keywords: &["ilotulitus", "juhla"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("fireworks"),
            keywords: &["bagong taon", "fireworks", "paputok", "selebrasyon"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("fýrverk"),
            keywords: &["eldverk", "fýrverk", "skreyteldur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("feu d’artifice"),
            keywords: &["artifice", "feu d’artifice"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["artifice", "célébration", "feu", "feu d’artifice"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("tine ealaíne"),
            keywords: &["ceiliúradh", "tine ealaíne"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cleasan-teine"),
            keywords: &["cleasan-teine", "comharrachadh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("fogos artificiais"),
            keywords: &["celebración", "festas", "fogos artificiais"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ફટાકડા ફોડવા"),
            keywords: &["ઉજવણી", "ફટાકડા", "ફટાકડા ફોડવા"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("wasan wuta"),
            keywords: &["shagali", "wasan wuta"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("זיקוקים"),
            keywords: &["זיקוקים", "חגיגה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("आतिशबाजी, समारोह"),
            keywords: &["आतिशबाजी", "आतिशबाजी, समारोह", "समारोह"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("vatromet"),
            keywords: &["slavlje", "vatromet"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("tűzijáték"),
            keywords: &["tűzijáték", "ünnep", "ünnepi hangulat", "ünneplés"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("հրավառություն"),
            keywords: &["հրավառություն", "տոնակատարություն"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kembang api"),
            keywords: &["kembang api", "perayaan"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ọrụọkụ"),
            keywords: &["enwemụaṅụrị", "ọrụọkụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("flugeldar"),
            keywords: &["flugeldar", "hátíð", "áramót"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("fuochi d’artificio"),
            keywords: &["festa", "fuochi d’artificio", "fuoco d’artificio"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("打ち上げ花火"),
            keywords: &["お祭り", "打ち上げ花火", "花火", "花火大会"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kembang api"),
            keywords: &["kembang api", "perayaan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ფოიერვერკი"),
            keywords: &["აღნიშვნა", "ზეიმი", "ფოიერვერკი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: None,
            keywords: &["asfugel"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("фейерверк"),
            keywords: &["толау", "фейерверк"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("fyrværkeri"),
            keywords: &["fest", "fyrværkeri", "nytår"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("កា\u{17c6}ជ\u{17d2}រ\u{17bd}ច"),
            keywords: &["កា\u{17c6}ជ\u{17d2}រ\u{17bd}ច", "អបអរ"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಫೈರ\u{ccd}\u{200c}ವರ\u{ccd}ಕ\u{ccd}ಸ\u{ccd}"),
            keywords: &[
                "ಆಚರಣ\u{cc6}",
                "ಫೈರ\u{ccd}\u{200c}ವರ\u{ccd}ಕ\u{ccd}",
                "ಫೈರ\u{ccd}\u{200c}ವರ\u{ccd}ಕ\u{ccd}ಸ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("불꽃놀이"),
            keywords: &["불꽃 축제", "불꽃놀이", "축하"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("फोग मारप"),
            keywords: &["फोग", "फोग मारप", "स\u{941}वाळो"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("фейерверк"),
            keywords: &["майрам", "фейерверк"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Freedefeier"),
            keywords: &["Feier", "Freedefeier"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ດອກໄມ\u{ec9}ໄຟ"),
            keywords: &["ດອກໄມ\u{ec9}ໄຟ", "ສະເຫ\u{ebc}\u{eb5}ມສະຫ\u{ebc}ອງ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("fejerverkai"),
            keywords: &["fejerverkai", "šventė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("salūts"),
            keywords: &["raķete", "salūts", "svētki"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pahūahi"),
            keywords: &["pahūahi", "whakanuinga"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("огномет"),
            keywords: &["небо", "огномет", "прослава"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വെടിമര\u{d41}ന\u{d4d}ന\u{d4d}"),
            keywords: &[
                "ആഘോഷം",
                "കരിമര\u{d41}ന\u{d4d}ന\u{d4d}",
                "പടക\u{d4d}കം",
                "ഫയർ വർക\u{d4d}ക\u{d4d}സ\u{d4d}",
                "വെടിമര\u{d41}ന\u{d4d}ന\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("галын наадам"),
            keywords: &["баяр ёслол", "галын наадам", "шинэ жил"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("फटाक\u{947}"),
            keywords: &["उत\u{94d}सव", "फटाक\u{947}"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bunga api"),
            keywords: &["bunga api", "perayaan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("logħob tan-nar"),
            keywords: &["logħob tan-nar", "ċelebrazzjoni"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("မ\u{102e}းရ\u{103e}\u{1030}းမ\u{102e}းပန\u{103a}းများ"),
            keywords: &[
                "ပ\u{103d}\u{1032}တော\u{103a}",
                "မ\u{102e}းရ\u{103e}\u{1030}းမ\u{102e}းပန\u{103a}းများ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("fyrverkeri"),
            keywords: &["feiring", "fyrverkeri", "nyttår"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("आतिशबाजी"),
            keywords: &["आतिशबाजी", "समारोह"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("vuurwerk"),
            keywords: &["feest", "vuurwerk"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("fyrverkeri"),
            keywords: &["feiring", "fyrverkeri", "nyttår"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଆତ\u{b3f}ସବ\u{b3e}ଜୀ"),
            keywords: &["ଆତ\u{b3f}ସବ\u{b3e}ଜୀ", "ଉତ\u{b4d}ସବ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਆਤਿਸਬਾਜ\u{a3c}ੀ"),
            keywords: &["ਅ\u{a71}ਗ ਦਾ ਕ\u{a70}ਮ", "ਆਤਿਸਬਾਜ\u{a3c}ੀ", "ਜਸ\u{a3c}ਨ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("آتشبازی"),
            keywords: &["آتشبازی", "منانا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fáyáwọks"),
            keywords: &["Fáyáwọks", "Sẹlibréshọn"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("fajerwerki"),
            keywords: &["fajerwerki", "nowy rok", "obchody", "święta"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("اورلوبې"),
            keywords: &["اورلوبې", "لمانځنه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("fogos de artifício"),
            keywords: &["comemoração", "fogos de artifício"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("fogo de artifício"),
            keywords: &["celebração", "fogo de artifício"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("fuegos artificiales"),
            keywords: &["fuegos artificiales", "raymi"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("artificii"),
            keywords: &["artificii", "sărbătoare"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-331"),
            keywords: &["E10-331"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("фейерверк"),
            keywords: &[
                "пиротехника",
                "праздник",
                "салют",
                "свет",
                "фейерверк",
                "шум",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("imiriro y’ibyishimo"),
            keywords: &["ibirori", "imiriro y’ibyishimo"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("آتشبازي"),
            keywords: &["آتشبازي", "جشن"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ග\u{dd2}න\u{dd2}කෙළ\u{dd2}"),
            keywords: &["ග\u{dd2}න\u{dd2}කෙළ\u{dd2}", "සැමර\u{dd4}ම"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("ohňostroj"),
            keywords: &["ohňostroj", "oslava"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("ognjemet"),
            keywords: &["ognjemet", "slavje"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("shaqooyinka dabka"),
            keywords: &["dabaaldag", "shaqooyinka dabka"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fishekzjarrë"),
            keywords: &["festim", "festë", "fishekzjarrë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("ватромет"),
            keywords: &["ватромет", "прослава"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("vatromet"),
            keywords: &["proslava", "vatromet"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("fyrverkerier"),
            keywords: &["firande", "fyrverkerier", "högtid"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("fataki"),
            keywords: &["fataki", "sherehe"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பட\u{bcd}ட\u{bbe}சு"),
            keywords: &[
                "ஒளி",
                "கொண\u{bcd}ட\u{bbe}ட\u{bcd}டம\u{bcd}",
                "சத\u{bcd}தம\u{bcd}",
                "பட\u{bcd}ட\u{bbe}சு",
                "பண\u{bcd}டிகை",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("టప\u{c3e}సులు"),
            keywords: &["టప\u{c3e}సులు", "వ\u{c47}డుక"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("оташфаввора"),
            keywords: &["оташфаввора", "ҷашн"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("พล\u{e38}"),
            keywords: &["พล\u{e38}", "เฉล\u{e34}มฉลอง"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("feýerwerk"),
            keywords: &["baýramçylyk", "feýerwerk"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fanaʻone"),
            keywords: &["fanaʻone"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("havai fişek"),
            keywords: &["havai fişek", "kutlama"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ساليۇت"),
            keywords: &["تەبرىكلەش", "ساليۇت"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("феєрверки"),
            keywords: &["святкування", "феєрверки"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("آتشبازی"),
            keywords: &["آتشبازی", "تفریح", "جشن", "خوشی", "مزہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("mushakbozlik"),
            keywords: &["bayram", "mushakbozlik", "nishonlash"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("pháo hoa"),
            keywords: &["lễ kỷ niệm", "pháo hoa"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("petaaru artifis"),
            keywords: &["màggal", "petaaru artifis"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iziqhushumbi"),
            keywords: &["iziqhushumbi", "umbhiyozo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Iṣẹ\u{301}iná"),
            keywords: &["Iṣẹ\u{301}iná", "ayẹyẹ"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("煙花"),
            keywords: &["慶祝", "煙花"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("烟花"),
            keywords: &["庆祝", "烟花"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("焰火"),
            keywords: &["庆祝", "烟花", "焰火"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("爆竹"),
            keywords: &["焰火", "煙花", "爆竹"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("煙花"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("amakhrikhethi"),
            keywords: &["amakhrikhethi", "umbungazo"],
        },
    ],
};
#[doc = "🎇"]
pub const SPARKLER: crate::Emoji = crate::Emoji {
    glyph: "🎇",
    codepoint: "1F387",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "sparkler",
    group: "Activities",
    subgroup: "event",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("vonkstok"),
            keywords: &["skitterstokkie", "viering", "vonk", "vonkstok", "vuurwerk"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የእሳት ፍንጣሪ መሥሪያ"),
            keywords: &["ርችት", "ክብረ በዓል", "የእሳት ፍንጣሪ", "የእሳት ፍንጣሪ መሥሪያ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ماسة نارية"),
            keywords: &["ماسة ألعاب نارية", "ماسة نارية"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ফ\u{9c1}লজ\u{9be}ৰি"),
            keywords: &[
                "আতচব\u{9be}জী",
                "উদয\u{9be}পন",
                "তিৰবিৰ\u{9be}",
                "ফ\u{9c1}লজ\u{9be}ৰি",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qığılclm"),
            keywords: &["bayram", "fişəng", "qığılclm", "qığılcım"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("бенгальскі агонь"),
            keywords: &["бенгальскі агонь", "свята", "феерверк", "іскра"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("фойерверк"),
            keywords: &["празнуване", "фойерверк"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ফ\u{9c1}লঝ\u{9c1}ড\u{9bc}ি"),
            keywords: &[
                "উদয\u{9be}পন",
                "দ\u{9cd}য\u{9c1}তি",
                "ফ\u{9c1}লঝ\u{9c1}ড\u{9bc}ি",
                "ব\u{9be}জি",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("piled-hud"),
            keywords: &["fest", "gouel", "lid", "piled-hud", "tan-arvest"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("prskalica"),
            keywords: &["proslava", "prskalica", "vatromet", "zabava"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("bengala"),
            keywords: &["bengala", "celebració", "espurna", "foc", "pirotècnia"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏥᏍᏓᎷᎩᏍᎩ"),
            keywords: &["ᎠᎾᎵᎮᎵᎬᎢ", "ᎠᏥᏍᏓᎷᎩᏍᎩ", "ᎤᏥᏍᏓᎷᎩᏍᎩ", "ᏗᏔᏍᎩᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("prskavka"),
            keywords: &["jiskra", "ohňostroj", "oslava", "prskavka"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("ffon wreichion"),
            keywords: &["dathliad", "ffon wreichion", "gwreichion", "tân gwyllt"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("stjernekaster"),
            keywords: &["fyrværkeri", "nytår", "stjernekaster"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Wunderkerze"),
            keywords: &["Feuerwerk", "Wunderkerze"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("αστράκι"),
            keywords: &["αστράκι", "γιορτή", "λάμψη", "πυροτεχνήματα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("sparkler"),
            keywords: &["celebration", "fireworks", "sparkle", "sparkler"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("bengala"),
            keywords: &["bengala", "celebración", "fuegos artificiales"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &[
                "artificiales",
                "bengala",
                "celebración",
                "festejo",
                "fiesta",
                "fuegos",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("säraküünal"),
            keywords: &["ilutulestik", "säraküünal"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("bengala"),
            keywords: &["bengala", "ospakizun", "su artifizialak"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("فشفشه"),
            keywords: &["آتش\u{200c}بازی", "بزرگداشت", "جشن", "عید", "فشفشه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("tähtisadetikku"),
            keywords: &["ilotulite", "juhla", "tähtisade", "tähtisadetikku"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("sparkler"),
            keywords: &["bagong taon", "kuwitis", "paputok", "sparkler"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("stjørnukastari"),
            keywords: &["stjørnukastari", "stjørnuljós"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("cierge magique"),
            keywords: &["cierge magique", "feu d’artifice", "fête", "étincelle"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("feu de Bengale"),
            keywords: &[
                "artifice",
                "bengale",
                "célébration",
                "feu",
                "feu de Bengale",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("spréachaire"),
            keywords: &[
                "ceiliúradh",
                "spréachaire",
                "spréachaire tine ealaíne",
                "tine ealaíne",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("lainnireag"),
            keywords: &[
                "cleasan-teine",
                "comharrachadh",
                "lainnir",
                "lainnireag",
                "sradag",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("bengala"),
            keywords: &["bengala", "celebración", "festa"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ફ\u{ac2}લઝર"),
            keywords: &[
                "આતશબાજી",
                "ઉજવણી",
                "ફટાકડા",
                "ફ\u{ac2}લઝર",
                "સ\u{acd}પાર\u{acd}કલર",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("na’urar sa wuta a gas"),
            keywords: &[
                "na’urar sa wuta a gas",
                "shagali",
                "wasan wuta",
                "ƙyalƙyali",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("זיקוק על מקל"),
            keywords: &["זיקוק על מקל", "זיקוקי דינור", "זיקוקים", "חגיגה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("फ\u{941}लझड\u{93c}ी, आतिशबाजी"),
            keywords: &[
                "आतिशबाजी",
                "फ\u{941}लझड\u{93c}ी",
                "फ\u{941}लझड\u{93c}ी पटाखा",
                "फ\u{941}लझड\u{93c}ी, आतिशबाजी",
                "समारोह",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("prskalica"),
            keywords: &["iskra", "prskalica", "slavlje", "vatromet"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("csillagszóró"),
            keywords: &[
                "csillagszóró",
                "tűzijáték",
                "ünnep",
                "ünnepi hangulat",
                "ünneplés",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բենգալյան կրակ"),
            keywords: &[
                "բենգալյան կրակ",
                "կայծ",
                "հրավառություն",
                "տոնակատարություն",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kembang api batang"),
            keywords: &[
                "api",
                "berkilau",
                "kembang",
                "kembang api batang",
                "perayaan",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihe icheku ọkụ"),
            keywords: &["enwemụaṅụrị", "icheku ọkụ", "ihe icheku ọkụ", "ọrụọkụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("stjörnuljós"),
            keywords: &["blys", "hátíð", "stjörnuljós", "áramót"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("stellina scintillante"),
            keywords: &[
                "festa",
                "fuoco d’artificio",
                "stellina scintillante",
                "stelline scintillanti",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("線香花火"),
            keywords: &["お祭り", "線香花火", "花火"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("bang api"),
            keywords: &["bang api", "kembang api", "mbang api", "mletik", "perayaan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ბრწყინვალება"),
            keywords: &[
                "აღნიშვნა",
                "ბრწყინვა",
                "ბრწყინვალება",
                "ზეიმი",
                "ფოიერვერკი",
            ],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("ifṭiwej"),
            keywords: &["ifṭiwej"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("бенгал оты"),
            keywords: &["бенгал оты", "жылтырау", "тойлау", "фейерверк"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("stjernekaster"),
            keywords: &["fyrværkeri", "nytår", "stjernekaster"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("បញ\u{17d2}ចេញពន\u{17d2}ល\u{17ba}"),
            keywords: &[
                "ការប\u{17d2}រារព\u{17d2}ធ",
                "កា\u{17c6}ជ\u{17d2}រ\u{17bd}ច",
                "បញ\u{17d2}ចេញពន\u{17d2}ល\u{17ba}",
                "ពន\u{17d2}ល\u{17ba}ផ\u{17d2}លេក",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸ\u{ccd}ಪಾರ\u{ccd}ಕ\u{ccd}ಲರ\u{ccd}"),
            keywords: &[
                "ಆಚರಣ\u{cc6}",
                "ಪಟಾಕ\u{cbf}",
                "ಸ\u{ccd}ಪಾರ\u{ccd}ಕ\u{ccd}ಲರ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("불꽃"),
            keywords: &["불꽃", "불꽃 축제", "축하", "폭죽"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ठिणग\u{94d}यो"),
            keywords: &["ठिणगी", "ठिणग\u{94d}यो", "फोग", "माराण", "स\u{941}वाळो"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("бенгал шамы"),
            keywords: &["бенгал шамы", "майрам", "фейерверк"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Späizmännchen"),
            keywords: &["Feier", "Fonken", "Freedefeier", "Späizmännchen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ດອກໄມ\u{ec9}ໄຟນ\u{ec9}ອຍ"),
            keywords: &[
                "ດອກໄມ\u{ec9}ໄຟ",
                "ດອກໄມ\u{ec9}ໄຟນ\u{ec9}ອຍ",
                "ປະກາຍໄຟ",
                "ສະເຫ\u{ebc}\u{eb5}ມສະຫ\u{ebc}ອງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("šaltoji ugnelė"),
            keywords: &["fejerverkai", "kibirkštis", "šaltoji ugnelė", "šventė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("brīnumsvecīte"),
            keywords: &["brīnumsvecīte", "mirdzēt", "salūts"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("whakakorakora"),
            keywords: &["korakora", "pahūahi", "whakakorakora", "whakanuinga"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("прскалка"),
            keywords: &["прослава", "прскалка", "светка"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പ\u{d42}ത\u{d4d}തിരി"),
            keywords: &[
                "ആഘോഷം",
                "കരിമര\u{d41}ന\u{d4d}ന\u{d4d}",
                "പടക\u{d4d}കം",
                "പ\u{d42}ത\u{d4d}തിരി",
                "ഫയർ വർക\u{d4d}ക\u{d4d}സ\u{d4d}",
                "വെടിമര\u{d41}ന\u{d4d}ന\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("бенгалын гал"),
            keywords: &["баяр ёслол", "бенгал", "бенгалын гал", "гал", "гялалзах"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("फ\u{941}लबाजीसारखी चमकणारी आतषबाजी"),
            keywords: &[
                "उत\u{94d}सव",
                "चमकणार\u{947}",
                "फटाक\u{947}",
                "फ\u{941}लबाजीसारखी चमकणारी आतषबाजी",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("mercun"),
            keywords: &["berkilau", "bunga api", "mercun", "perayaan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("sparkler"),
            keywords: &["logħob tan-nar", "sparkler", "tlellex", "ċelebrazzjoni"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("မ\u{102e}းပန\u{103a}း"),
            keywords: &[
                "ပ\u{103d}\u{1032}တော\u{103a}",
                "မ\u{102e}းပန\u{103a}း",
                "မ\u{102e}းရ\u{103e}\u{1030}းမ\u{102e}းပန\u{103a}း",
                "၀င\u{103a}းလက\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("stjerneskudd på pinne"),
            keywords: &["feiring", "fyrverkeri", "nyttår", "stjerneskudd på pinne"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("हिरा"),
            keywords: &["आतिशबाजी", "चमक", "समारोह", "हिरा"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("sterretje"),
            keywords: &["feest", "sterretje", "vuurwerk", "vuurwerksterretje"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("stjerneskot på pinne"),
            keywords: &["feiring", "fyrverkeri", "nyttår", "stjerneskot på pinne"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଝ\u{b41}ର\u{b4d}\u{200c}\u{200c}ଝ\u{b41}ରୀ ବ\u{b3e}ଣ"),
            keywords: &[
                "ଆତ\u{b3f}ସବ\u{b3e}ଜୀ",
                "ଆତ\u{b3f}ସବ\u{b3e}ଜୀ ଚମକ",
                "ଉତ\u{b4d}ସବ",
                "ଝ\u{b41}ର\u{b4d}\u{200c}\u{200c}ଝ\u{b41}ରୀ ବ\u{b3e}ଣ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਫ\u{a41}\u{a71}ਲਝੜੀ"),
            keywords: &[
                "ਅ\u{a71}ਗ ਦਾ ਕ\u{a70}ਮ",
                "ਚਮਕ",
                "ਚਮਕੀਲਾ ਅ\u{a71}ਗ ਦਾ ਕ\u{a70}ਮ",
                "ਜਸ\u{a3c}ਨ",
                "ਫ\u{a41}\u{a71}ਲਝੜੀ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("چمک کرنا آلا"),
            keywords: &["آتشبازی", "جگ مگ کرنا", "منانا", "چمک کرنا آلا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Spákla"),
            keywords: &["Fáyáwọks", "Spákla", "Spákul", "Sẹlibréshọn"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("zimne ognie"),
            keywords: &["ognie", "petardy", "sztuczne", "zimne"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("الماس"),
            keywords: &["الماس", "اورلوبې", "لمانځنه", "پړقا"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("vela estrela"),
            keywords: &[
                "comemoração",
                "fogo de artifício",
                "fogo de artifício vela estrela",
                "vela estrela",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("vela com faísca"),
            keywords: &["celebração", "faísca", "vela", "vela com faísca"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("pinchi"),
            keywords: &["fuegos artificiales", "k’anchay", "pinchi", "raymi"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("foc bengal"),
            keywords: &["artificii", "foc bengal", "scântei", "sărbătoare"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-332"),
            keywords: &["E10-332"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("бенгальский огонь"),
            keywords: &["бенгальский огонь", "искры", "огонь", "праздник"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("igishashagizo"),
            keywords: &[
                "gushashagirana",
                "ibirori",
                "igishashagizo",
                "imiriro y’ibyishimo",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڦلجڙي"),
            keywords: &["جشن، آتشبازي، ڦلجڙي", "ڦلجڙي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ද\u{dd2}ල\u{dd2}ස\u{dd3}ම"),
            keywords: &[
                "ග\u{dd2}න\u{dd2}කෙළ\u{dd2}",
                "ද\u{dd2}ල\u{dd2}ස\u{dd3}ම",
                "ද\u{dd2}ළ\u{dd2}ස\u{dd3}ම",
                "සැමර\u{dd4}ම",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("prskavka"),
            keywords: &["iskra", "ohňostroj", "oslava", "prskavka"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("sibirska lučka"),
            keywords: &["iskrenje", "ognjemet", "sibirska lučka", "slavje"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("dhalaaliye"),
            keywords: &["dabaaldag", "dhalaali", "dhalaaliye", "shaqooyinka dabka"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("xixëllimë"),
            keywords: &["festim", "festë", "fishekzjarrë", "xixëllimë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("прскалица"),
            keywords: &["вaтрoмeт", "искрa", "прослава", "прскалица"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("prskalica"),
            keywords: &["iskra", "proslava", "prskalica", "vatromet"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("glittrande fyrverkeri"),
            keywords: &["fyrverkerier", "glittrande fyrverkeri", "högtid"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kimetameta"),
            keywords: &["fataki", "kimetameta", "kusherehekea", "metameta"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மத\u{bcd}த\u{bbe}ப\u{bcd}பு"),
            keywords: &[
                "ஒளி",
                "கொண\u{bcd}ட\u{bbe}ட\u{bcd}டம\u{bcd}",
                "பண\u{bcd}டிகை",
                "மத\u{bcd}த\u{bbe}ப\u{bcd}பு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మ\u{c46}రుపులు వచ\u{c4d}చ\u{c47} టప\u{c3e}సులు"),
            keywords: &[
                "టప\u{c3e}సులు",
                "మ\u{c46}రుపు",
                "మ\u{c46}రుపులు వచ\u{c4d}చ\u{c47} టప\u{c3e}సులు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("мушаки маҳтобӣ"),
            keywords: &["мушаки маҳтобӣ", "оташфаввора", "ялаққос задан", "ҷашн"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ดอกไม\u{e49}ไฟ"),
            keywords: &["ดอกไม\u{e49}ไฟ", "พล\u{e38}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("uçgun çykaryjy"),
            keywords: &["baýramçylyk", "feýerwerk", "uçgun", "uçgun çykaryjy"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fanaʻone fetapatapaki"),
            keywords: &["fanaʻone fetapatapaki"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("fişek"),
            keywords: &["fişek", "havai fişek", "kutlama"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("پارسىلداق"),
            keywords: &["ئۇچقۇن", "تەبرىكلەش", "ساليۇت", "پارسىلداق"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("бенгальський вогонь"),
            keywords: &["бенгальський вогонь", "святкування", "феєрверки", "іскра"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("پھلجری"),
            keywords: &["آتش بازی", "جشن", "پھلجری"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("bengal olovi"),
            keywords: &["bayram", "bengal olovi", "charaqlash", "mushakbozlik"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("pháo bông"),
            keywords: &["chói sáng", "lễ kỷ niệm", "pháo bông", "pháo hoa"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("potu sondeel"),
            keywords: &["ferñeent", "màggal", "petaaru artifis", "potu sondeel"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isikhazimli"),
            keywords: &["isikhazimli", "izikhazimli", "iziqhushumbi", "umbhiyozo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Olutan"),
            keywords: &["Olutan", "ayẹyẹ", "dán", "iṣẹ\u{301}iná"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("火花"),
            keywords: &["慶祝", "火花", "煙花"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("火花"),
            keywords: &["庆祝", "火花", "烟花"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("烟花"),
            keywords: &["庆祝", "火花", "烟火", "烟花", "焰火"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("煙花"),
            keywords: &["焰火", "煙花"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("燦爛煙花"),
            keywords: &["焰火", "煙花", "燦爛煙花"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("okuqhumayo"),
            keywords: &["amakhrikhethi", "okuqhumayo", "umbungazo"],
        },
    ],
};
#[doc = "🧨"]
pub const FIRECRACKER: crate::Emoji = crate::Emoji {
    glyph: "🧨",
    codepoint: "1F9E8",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "firecracker",
    group: "Activities",
    subgroup: "event",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("klapper"),
            keywords: &["dinamiet", "klapper", "klappers", "plofstof", "vuurwerke"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ርችቶች"),
            keywords: &["ርችቶች", "የሚፈነዳ", "ደማሚት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مفرقعات"),
            keywords: &["ألعاب نارية", "ديناميت", "مفرقعات", "مفرقعات نارية"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ফটক\u{9be}"),
            keywords: &["ডিন\u{9be}ম\u{9be}ইট", "ফটক\u{9be}", "বিস\u{9cd}ফোৰক"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("feyerverk"),
            keywords: &["dinamit", "feyerverk", "partlama"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("петарда"),
            keywords: &["выбуховы", "дынаміт", "петарда", "узрыўчатка", "феерверк"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("пиратка"),
            keywords: &["динамит", "експлозив", "пиратка", "фойерверки"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ব\u{9be}জি"),
            keywords: &[
                "আতশব\u{9be}জি",
                "ড\u{9be}ইন\u{9be}ম\u{9be}ইট",
                "ব\u{9be}জি",
                "বিস\u{9cd}ফোরক",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("strakerez"),
            keywords: &["dinamit", "strakerez", "tarzhañ"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("petarda"),
            keywords: &["dinamit", "eksploziv", "petarda", "vatromet"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("petard"),
            keywords: &["dinamita", "explosiu", "focs d’artifici", "petard"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏔᏍᎩᏍᏙᏗ"),
            keywords: &["ᎠᏔᏍᎩᏍᏗ", "ᎠᏔᏍᎩᏍᏙᏗ", "ᏗᏔᏍᎩᏍᎩ", "ᏗᏔᏍᎩᏍᏙᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("petarda"),
            keywords: &["dynamit", "ohňostroj", "petarda", "výbušnina"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("gwialen tân"),
            keywords: &["dynameit", "ffrwydrol", "gwialen tân", "tân gwyllt"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kanonslag"),
            keywords: &["dynamit", "eksplosiv", "fyrværkeri", "kanonslag"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Feuerwerkskörper"),
            keywords: &[
                "Dynamit",
                "Feuerwerk",
                "Feuerwerkskörper",
                "Knaller",
                "explosiv",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κροτίδα"),
            keywords: &["δυναμίτης", "εκρηκτικός", "κροτίδα", "πυροτεχνήματα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("firecracker"),
            keywords: &["dynamite", "explosive", "firecracker", "fireworks"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("petardo"),
            keywords: &["dinamita", "explosivo", "fuegos artificiales", "petardo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("petardo"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("petardo"),
            keywords: &["petardo"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("ilutulestikurakett"),
            keywords: &["dünamiit", "ilutulestik", "ilutulestikurakett", "lõhkeaine"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("petardo"),
            keywords: &["dinamita", "lehergai", "petardo", "su artifizial"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ترقه"),
            keywords: &["آتش\u{200c}بازی", "ترقه", "دینامیت", "مواد منفجره"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("sähikäinen"),
            keywords: &[
                "dynamiitti",
                "ilotulitus",
                "raketti",
                "räjähde",
                "sähikäinen",
                "tykinlaukaus",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("paputok"),
            keywords: &["dinamita", "pampasabog", "paputok"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("kinesari"),
            keywords: &[
                "dynamitt",
                "eldverk",
                "kinesari",
                "skreyteldur",
                "spreingievni",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("pétard"),
            keywords: &["dynamite", "explosif", "feu d’artifice", "pétard"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("pléascóg thine"),
            keywords: &["dinimít", "pléascóg", "pléascóg thine", "tinte ealaíne"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("dìorrasan-fùdair"),
            keywords: &[
                "cleasan-teine",
                "dineamait",
                "dìorrasan-fùdair",
                "spreadhach",
                "spreadhadh",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("petardo"),
            keywords: &[
                "dinamita",
                "explosivo",
                "fogos artificiais",
                "foguete",
                "petardo",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ફટાકડા"),
            keywords: &["ડાયનામાઇટ", "ફટાકડા", "વિસ\u{acd}ફોટક"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("זיקוקין די נור"),
            keywords: &["דינמיט", "זיקוקים", "זיקוקין די נור", "חזיז"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("पटाख\u{947}"),
            keywords: &["आतिशबाजी", "पटाख\u{947}", "बार\u{942}द", "विस\u{94d}फोटक"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("petarda"),
            keywords: &["dinamit", "eksploziv", "petarda", "vatromet"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("petárda"),
            keywords: &["dinamit", "petárda", "robbanószer", "tüzijáték"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ճայթռուկ"),
            keywords: &["դինամիտ", "հրավարություն", "ճայթռուկ", "պայտուցիկ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("petasan"),
            keywords: &["bahan peledak", "dinamit", "kembang api", "petasan"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("púðurkerling"),
            keywords: &["dínamít", "flugeldar", "púðurkerling", "sprengiefni"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("petardo"),
            keywords: &["dinamite", "esplosivo", "fuochi artificiali", "petardo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("爆竹"),
            keywords: &["ダイナマイト", "火薬", "爆発", "爆竹", "爆薬"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("petasan"),
            keywords: &["bahan peledak", "dinamit", "kembang api", "petasan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("შუშხუნა"),
            keywords: &["ასაფეთქებელი", "დინამიტი", "ფეიერვერკი", "შუშხუნა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("отшашу"),
            keywords: &["динамит", "жарылғыш", "отшашу", "фейерверк"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ផាវ"),
            keywords: &[
                "គ\u{17d2}រឿងផ\u{17d2}ទ\u{17bb}ះ",
                "ឌ\u{17b8}ណាម\u{17b7}ក",
                "ផាវ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪಟಾಕ\u{cbf}"),
            keywords: &[
                "ಡೈನಮೈಟ\u{ccd}",
                "ಪಟಾಕ\u{cbf}",
                "ಪಟಾಕ\u{cbf}ಗಳು",
                "ಸ\u{ccd}ಫೋಟಕ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("폭죽"),
            keywords: &["다이너마이트", "불꽃놀이", "폭약", "폭죽"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("फोग\u{947}ट"),
            keywords: &[
                "डायनामायट",
                "फोगाच\u{947}\u{902}",
                "फोग\u{947}ट",
                "माराण",
                "स\u{94d}फोटक",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("петарда"),
            keywords: &["динамит", "жарылуучу", "петарда", "фейерверк"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໝາກກະໂພກ"),
            keywords: &[
                "ດ\u{eb4}ນລະເບ\u{eb5}ດ",
                "ເບ\u{eb7}ອໝາກຟ\u{ec8}າ",
                "ໝາກກະໂບກ",
                "ໝາກກະໂພກ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("fejerverkas"),
            keywords: &["dinamitas", "fejerverkai", "fejerverkas", "sprogus"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("petarde"),
            keywords: &["dinamīts", "petarde", "spridzeklis", "uguņošana"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("петарда"),
            keywords: &["динамит", "експлозив", "огномет", "петарда"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പടക\u{d4d}കം"),
            keywords: &[
                "ഡൈന\u{d3e}മിറ\u{d4d}റ\u{d4d}",
                "പടക\u{d4d}കം",
                "വെടിക\u{d4d}കെട\u{d4d}ട\u{d4d}",
                "സ\u{d4d}\u{200c}ഫോടകവസ\u{d4d}ത\u{d41}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("салют"),
            keywords: &["галын наадам", "динамит", "салют", "тэсрэх бодис"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("फायरक\u{94d}र\u{945}कर"),
            keywords: &[
                "एक\u{94d}सप\u{94d}लोझिव\u{94d}ह",
                "डायनामाईट",
                "फायरक\u{94d}र\u{945}कर",
                "फायरवर\u{94d}क\u{94d}स",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("petasan"),
            keywords: &["bahan letupan", "bunga api", "dinamit", "petasan"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဗြောက\u{103a}အ\u{102d}\u{102f}း"),
            keywords: &[
                "ဒ\u{102d}\u{102f}င\u{103a}းနမ\u{102d}\u{102f}က\u{103a}",
                "ပေါက\u{103a}က\u{103d}\u{1032}တတ\u{103a}သော",
                "ဗြောက\u{103a}အ\u{102d}\u{102f}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kinaputt"),
            keywords: &["dynamitt", "eksplosiver", "fyrverkeri", "kinaputt"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("पटाका"),
            keywords: &["डायनामाइट", "पटका", "पटाका", "विस\u{94d}फोटक सामग\u{94d}री"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("rotje"),
            keywords: &["dynamiet", "explosief", "rotje", "vuurwerk"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kinaputt"),
            keywords: &["dynamitt", "eksplosiv", "fyrverkeri", "kinaputt"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବ\u{b3e}ଣ"),
            keywords: &[
                "ଡ\u{b3e}ୟ\u{b3f}ନ\u{b3e}ମ\u{b3f}ଟ\u{b4d}\u{200d}",
                "ବ\u{b3e}ଣ",
                "ବ\u{b3f}ସ\u{b4d}ଫୋଟକ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪਟਾਖ\u{a47}"),
            keywords: &[
                "ਆਤਸ\u{a3c}ਬਾਜੀ",
                "ਡਾਇਨਾਮਾਈਟ",
                "ਪਟਾਖ\u{a47}",
                "ਵਿਸਫ\u{a4b}ਟਕ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fáyákráka"),
            keywords: &["Daínámait", "Fáyákráka", "Fáyáwọks", "Ẹksplósiv"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("petarda"),
            keywords: &["dynamit", "fajerwerki", "materiał wybuchowy", "petarda"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("پټاکۍ"),
            keywords: &["اورلوبې", "نميټ", "پټاکۍ", "چاودونکي"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("bombinha"),
            keywords: &["bombinha", "dinamite", "explosivo", "fogos de artifício"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("petardo"),
            keywords: &["dinamite", "explosivo", "fogo de artifício", "petardo"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("petardă"),
            keywords: &["artificii", "dinamită", "explozibil", "petardă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E11-050"),
            keywords: &["E11-050"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("динамитная шашка"),
            keywords: &["взрыв", "динамит", "динамитная шашка", "фейерверк", "шашка"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("فائر ڪريڪر"),
            keywords: &["فائر ورڪس", "فائر ڪريڪر", "ڊائنامائيٽ", "ڌماڪيدار"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("රත\u{dd2}ඤ\u{dca}ඤ\u{dcf}"),
            keywords: &[
                "ඩය\u{dd2}නමය\u{dd2}ට\u{dca}",
                "ප\u{dd4}ප\u{dd4}රන ස\u{dd4}ළ\u{dd4}ය\u{dd2}",
                "මල\u{dca}වෙඩ\u{dd2}",
                "රත\u{dd2}ඤ\u{dca}ඤ\u{dcf}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("petarda"),
            keywords: &["dynamit", "ohňostroj", "petarda", "výbušnina"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("petarda"),
            keywords: &["dinamit", "eksploziv", "ognjemet", "petarda"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("dab-demiyeyaasha"),
            keywords: &[
                "dab-demiyeyaasha",
                "qarxaha",
                "shaqooyinka dabka",
                "walxaha qarxo",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fishekzjarr"),
            keywords: &["dinamit", "eksploziv", "fishekzjarr"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("петарда"),
            keywords: &["ватромет", "динамит", "експлозив", "петарда"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("petarda"),
            keywords: &["dinamit", "eksploziv", "petarda", "vatromet"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("smällare"),
            keywords: &["dynamit", "fyrverkeri", "smällare", "sprängämne"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("fataki ya kuchezea"),
            keywords: &["baruti", "fataki", "fataki ya kuchezea", "kilipuzi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வெடி"),
            keywords: &["டைனமைட\u{bcd}", "வ\u{bbe}னவேடிக\u{bcd}கை", "வெடி"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("టప\u{c3e}క\u{c3e}యలు"),
            keywords: &[
                "టప\u{c3e}క\u{c3e}యలు",
                "టప\u{c3e}సులు",
                "డ\u{c48}నమ\u{c48}ట\u{c4d}",
                "ప\u{c47}లుడుపద\u{c3e}ర\u{c4d}థ\u{c3e}లు",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ประท\u{e31}ด"),
            keywords: &[
                "ดอกไม\u{e49}ไฟ",
                "ประท\u{e31}ด",
                "ระเบ\u{e34}ด",
                "ไดนาไมต\u{e4c}",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("salýut"),
            keywords: &["dinamit", "feýerwerk", "partlaýjy", "salýut"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ʻone"),
            keywords: &["ʻone"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("maytap"),
            keywords: &["dinamit", "havai fişek", "maytap", "patlayıcı"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("петарда"),
            keywords: &["бомба", "вибухівка", "динаміт", "петарда", "феєрверк"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("پٹاخہ"),
            keywords: &["آتش بازی", "دھماکا خیز", "پٹاخہ", "ڈائنامیٹ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("bang‘illoq"),
            keywords: &[
                "bang‘illoq",
                "bombacha",
                "feyerverk",
                "portlash",
                "portlatgich",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("pháo"),
            keywords: &["nổ", "pháo", "pháo hoa", "thuốc nổ"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("炮丈"),
            keywords: &["炮丈", "炸藥", "煙花", "爆炸"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("炮丈"),
            keywords: &["炮丈", "炸药", "烟花", "爆炸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("爆竹"),
            keywords: &["炸药", "烟花", "爆炸", "爆竹"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("鞭炮"),
            keywords: &["火藥", "煙火", "爆炸", "鞭炮"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("炮仗"),
            keywords: &["火藥", "炮仗", "煙火", "爆炸"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("E11:050"),
            keywords: &["E11:050"],
        },
    ],
};
#[doc = "✨"]
pub const SPARKLES: crate::Emoji = crate::Emoji {
    glyph: "✨",
    codepoint: "2728",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "sparkles",
    group: "Activities",
    subgroup: "event",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("vonke"),
            keywords: &["ster", "vonk", "vonke"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የእሳት ፍንጣሪዎች"),
            keywords: &["ብልጭታ", "ኮከብ", "የእሳት ፍንጣሪዎች"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ومضات"),
            keywords: &["نجوم", "نجوم ساطعة", "ومضات", "ومضة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("চিকমিকনি"),
            keywords: &["*", "চিকমিকনি", "তিৰবিৰীয\u{9bc}\u{9be}", "তৰ\u{9be}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qığılcımlar"),
            keywords: &["qığılcım", "qığılcımlar", "ulduz"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("іскры"),
            keywords: &["*", "зорка", "іскра", "іскры"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("звездички"),
            keywords: &["звезда", "звездичка", "звездички"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("দ\u{9cd}য\u{9c1}তি"),
            keywords: &["*", "ঝিকিমিকি", "ত\u{9be}র\u{9be}", "দ\u{9cd}য\u{9c1}তি"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("fulennoù"),
            keywords: &["*", "fulennoù", "steredenn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("iskrice"),
            keywords: &["*", "iskre", "iskrice", "zvjezdice"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("espurnes"),
            keywords: &["*", "espurna", "espurnes", "estrella"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᏥᏍᏓᎷᎩᏍᎩ"),
            keywords: &["*", "ᎤᏥᏍᏓᎷᎩᏍᎩ", "ᏃᏈᏏ", "ᏗᏥᏍᏓᎷᎩᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("jiskry"),
            keywords: &["*", "hvězda", "jiskra", "jiskry"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("gwreichion"),
            keywords: &["gwreichion", "seren"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("stjerner"),
            keywords: &["skinne", "stjerne", "stjerner"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("funkelnde Sterne"),
            keywords: &["*", "Sterne", "funkelnde Sterne"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("αστράκια"),
            keywords: &["*", "αστέρι", "αστράκια", "λάμψη"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("sparkles"),
            keywords: &["*", "sparkle", "sparkles", "star"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("chispas"),
            keywords: &["*", "bengala", "chispas", "estrellas"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["brillo", "chispas", "estrella", "estrellas"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "*",
                "bengala",
                "chispas",
                "estrellas",
                "estrellas centelleantes",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("sädemed"),
            keywords: &["*", "säde", "sädemed", "sära", "täht"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("distira"),
            keywords: &["distira", "izar"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("درخشش"),
            keywords: &["جرقه", "درخشش", "ستاره"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("säihke"),
            keywords: &["loiste", "säihke", "tähti"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("kumikinang"),
            keywords: &["bituin", "kislap", "kumikinang", "kumikislap"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("neistafok"),
            keywords: &[
                "glampi",
                "glansur",
                "glitran",
                "glógvan",
                "ljómi",
                "neistafok",
                "skyggjan",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("étincelles"),
            keywords: &["*", "scintiller", "étincelles", "étoile"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("étincelles"),
            keywords: &["étincelles", "étoile"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("drithlí"),
            keywords: &["*", "drithlí", "gealán", "réaltaí"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("lainnirean"),
            keywords: &["lainnir", "lainnirean", "reul", "rionnag"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("chispas"),
            keywords: &["brillar", "chispas", "escintilar", "estrelas"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ચમકતા તારા"),
            keywords: &["*", "ચમકતા તારા", "ચળકાટ", "તારા", "સ\u{acd}ટાર"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("ƙyalƙyalai"),
            keywords: &["tauraro", "ƙyalƙyalai", "ƙyalƙyali"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("נצנוץ"),
            keywords: &["כוכב", "כוכבים", "נצנוץ", "נצנוצים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("चमकदार तार\u{947}"),
            keywords: &["चमक", "चमकदार तार\u{947}", "चमचम", "तार\u{947}"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("iskre"),
            keywords: &["iskra", "iskre", "zvijezda"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("szikrák"),
            keywords: &["csillag", "szikra", "szikrák"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կայծեր"),
            keywords: &["աստղ", "կայծ", "կայծեր"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("berkilau"),
            keywords: &["*", "berkilau", "bintang", "kilauan"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("icheku ọkụ gasị"),
            keywords: &["icheku ọkụ", "icheku ọkụ gasị", "kpakpando"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("stjörnur"),
            keywords: &["glit", "neistar", "stjörnur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("stelline"),
            keywords: &["scintille", "stelle", "stelline"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("きらきら"),
            keywords: &["きらきら", "ぴかぴか", "スター", "星"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("mbang api"),
            keywords: &["*", "bang api", "lintang", "mbang api"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ნაპერწკლები"),
            keywords: &["ბრწყინვა", "ვარსკვლავი", "ნაპერწკლები"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("itran"),
            keywords: &["itran"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ұшқындар"),
            keywords: &["жылтырау", "жұлдыз", "ұшқындар"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("stjerner"),
            keywords: &["skinne", "stjerne", "stjerner"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ចែងចា\u{17c6}ង"),
            keywords: &[
                "*",
                "ចា\u{17c6}ងផ\u{17d2}លេកៗ",
                "ចែងចា\u{17c6}ង",
                "តារា",
                "ផ\u{17d2}កាយ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಹೊಳ\u{cc6}ಯುವ"),
            keywords: &[
                "*",
                "ನಕ\u{ccd}ಷತ\u{ccd}ರಗಳು",
                "ಹೊಳ\u{cc6}ಯತ\u{ccd}ತ\u{cbf}ರುವ",
                "ಹೊಳ\u{cc6}ಯುವ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("블링블링"),
            keywords: &["반짝거림", "반짝반짝", "블링블링"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ठिणगी काडपी"),
            keywords: &["*", "ठिणगी", "ठिणगी काडपी", "नख\u{947}त\u{94d}र"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("учкундар"),
            keywords: &["жылдыз", "учкун", "учкундар"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("fonkelend Stären"),
            keywords: &["Fonken", "Stär", "fonkelend Stären"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ປະກາຍໄຟ"),
            keywords: &["ດາວຍ\u{eb4}ບຍ\u{eb1}ບ", "ປະກາຍໄຟ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("kibirkštėlės"),
            keywords: &["kibirkštis", "kibirkštėlės", "žvaigždė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("zibšņi"),
            keywords: &["*", "zibsnis", "zibšņi", "zvaigzne"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("he korakora"),
            keywords: &["he korakora", "korakora", "whetū"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("светки"),
            keywords: &["*", "светка", "светки", "ѕвезда"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("തിളങ\u{d4d}ങ\u{d41}ന\u{d4d}നവ"),
            keywords: &[
                "തിളക\u{d4d}കം",
                "തിളങ\u{d4d}ങ\u{d41}ന\u{d4d}ന നക\u{d4d}ഷത\u{d4d}രങ\u{d4d}ങൾ",
                "തിളങ\u{d4d}ങ\u{d41}ന\u{d4d}നവ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("гэрэлтэх"),
            keywords: &["гэрэлтэх", "од"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("चमकणार\u{947}"),
            keywords: &["*", "चमकणारा", "चमकणार\u{947}", "तार\u{947}"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("berkilauan"),
            keywords: &["berkilau", "berkilauan", "bintang"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("tlellix"),
            keywords: &["sparkle", "stilla", "tlellix"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("မ\u{102e}းပ\u{103d}င\u{1037}\u{103a}များ"),
            keywords: &[
                "ကြယ\u{103a}",
                "မ\u{102e}းပ\u{103d}င\u{1037}\u{103a}များ",
                "ဝင\u{103a}းလက\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("stjerner"),
            keywords: &["*", "glitrende", "skinnende", "stjerner"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("चमक"),
            keywords: &["*", "चमक", "तारा"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("sterretjes"),
            keywords: &["*", "glinsteren", "ster", "sterretjes"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("stjerner"),
            keywords: &["glitrande", "skinande", "stjerner"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଚମକ\u{b3f}ଲ\u{b3e}"),
            keywords: &[
                "*",
                "ଚକ\u{b4d}\u{200c}ଚକ\u{b4d}\u{200c}",
                "ଚକ\u{b4d}\u{200c}ଚକ\u{b4d}\u{200c} କର\u{b3f}ବ\u{b3e}",
                "ଚମକ\u{b3f}ଲ\u{b3e}",
                "ତ\u{b3e}ର\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਫ\u{a41}\u{a71}ਲਝੜੀਆ\u{a02}"),
            keywords: &[
                "ਚਮਕਣਾ",
                "ਚਮਕਦ\u{a47} ਤਾਰ\u{a47}",
                "ਤਾਰ\u{a47}",
                "ਫ\u{a41}\u{a71}ਲਝੜੀ",
                "ਫ\u{a41}\u{a71}ਲਝੜੀਆ\u{a02}",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("چمکیلا"),
            keywords: &["تارہ", "جگ مگ کرنا", "چمکیلا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Spákuls"),
            keywords: &["*", "Spákul", "Spákuls", "Sta"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("gwiazdki"),
            keywords: &["* gwiazdki", "gwiazda", "gwiazdki", "gwiazdy"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("پړقېدونکي"),
            keywords: &["*", "ستوری", "پړقېده", "پړقېدونکي"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("brilhos"),
            keywords: &["*", "brilhos", "estrelas", "estrelas brilhantes"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cintilação"),
            keywords: &["*", "centelha", "cintilação", "estrelas", "faíscas"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("pinchikuna"),
            keywords: &["*", "k’anchay", "pinchikuna", "quyllur"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("steluțe"),
            keywords: &["*", "luminițe", "stea", "steluțe", "steluță"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-135"),
            keywords: &["E10-135"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("блестки"),
            keywords: &[
                "блестка",
                "блестки",
                "звезда",
                "звезды",
                "искры",
                "мерцание",
                "свет",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ibishashi"),
            keywords: &["gushashagirana", "ibishashi", "inyenyeri"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڦلجڙيون"),
            keywords: &["*", "تارو", "فلجڙيون", "ڦلجڙي", "ڦلجڙيون"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ද\u{dd2}යමන\u{dca}ත\u{dd2}"),
            keywords: &[
                "තර\u{dd4}ව",
                "ද\u{dd2}යමන\u{dca}ත\u{dd2}",
                "ද\u{dd2}ළ\u{dd2}ස\u{dd3}ම",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("iskry"),
            keywords: &["*", "hviezda", "iskra", "iskry"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("iskrice"),
            keywords: &["*", "iskrenje", "iskrice", "zvezda"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("dhalaali"),
            keywords: &["*", "dhalaali", "dhalaalin", "xiddig"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("xixëllima"),
            keywords: &["xixëllima", "xixëllimë", "yll"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("искре"),
            keywords: &["звeздa", "искрa", "искре"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["искре"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("iskre"),
            keywords: &["iskra", "iskre", "zvezda"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["iskre"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("gnistrande stjärnor"),
            keywords: &["gnistrande stjärnor", "gnistrar", "stjärnor"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("nyota"),
            keywords: &["kumetameta", "metameta", "nyota"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஒளிரும\u{bcd} நட\u{bcd}சத\u{bcd}திரம\u{bcd}"),
            keywords: &[
                "ஒளிரும\u{bcd} நட\u{bcd}சத\u{bcd}திரம\u{bcd}",
                "கொண\u{bcd}ட\u{bbe}ட\u{bcd}டம\u{bcd}",
                "நட\u{bcd}சத\u{bcd}திரம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("చ\u{c3f}న\u{c4d}న చ\u{c3f}న\u{c4d}న మ\u{c46}రుపులు"),
            keywords: &[
                "చ\u{c3f}న\u{c4d}న",
                "చ\u{c3f}న\u{c4d}న చ\u{c3f}న\u{c4d}న మ\u{c46}రుపులు",
                "మ\u{c46}రుపు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("шарора"),
            keywords: &["ситора", "шарора", "ялаққос задан"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ประกายว\u{e34}บว\u{e31}บ"),
            keywords: &[
                "*",
                "ดาว",
                "ดาวว\u{e34}บว\u{e31}บ",
                "ประกายว\u{e34}บว\u{e31}บ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("uçgunlar"),
            keywords: &["*", "uçgun", "uçgunlar", "ýyldyz"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fetapatapaki"),
            keywords: &["fetapatapaki"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("parıltılar"),
            keywords: &["*", "parıltı", "parıltılar", "pırıltı", "yıldız"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ۋالدۇر-ۋۇلدۇر"),
            keywords: &["ئۇچقۇن", "يۇلتۇز", "ۋالدۇر-ۋۇلدۇر"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("блискітки"),
            keywords: &["блискітки", "зірка", "іскра", "іскри"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("چمکتے ستارے"),
            keywords: &["ستارہ", "چمک", "چمکتے ستارے"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("uchqunlar"),
            keywords: &["*", "uchqun", "uchqunlar", "yulduz"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("ánh lấp lánh"),
            keywords: &["lấp lánh", "ngôi sao", "ánh lấp lánh"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("ferñeent"),
            keywords: &["biddeew", "ferñeent"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("izikhazimli"),
            keywords: &["inkwenkwezi", "isikhazimli", "izikhazimli"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Awọn Titan"),
            keywords: &["Awọn Titan", "dán", "ìràwọ\u{300}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("閃"),
            keywords: &["星", "閃"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("闪"),
            keywords: &["星", "闪"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("闪亮"),
            keywords: &["星星", "火花", "闪亮", "闪光", "闪耀"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("閃爍"),
            keywords: &["閃亮", "閃爍"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("閃光"),
            keywords: &["閃亮", "閃光"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("okukhazimulayo"),
            keywords: &["inkanyezi", "okukhazimulayo", "ukukhazimula"],
        },
    ],
};
#[doc = "🎈"]
pub const BALLOON: crate::Emoji = crate::Emoji {
    glyph: "🎈",
    codepoint: "1F388",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "balloon",
    group: "Activities",
    subgroup: "event",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("ballon"),
            keywords: &["ballon", "viering"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("አፉፋ"),
            keywords: &["አፉፋ", "ክብረ በዓል"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}بالون"),
            keywords: &["احتفال", "\u{202b}بالون"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("বেল\u{9c1}ন"),
            keywords: &["উদয\u{9be}পন", "বেল\u{9c1}ন"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("şar"),
            keywords: &["bayram", "şar"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("паветраны шарык"),
            keywords: &["паветраны шарык", "святкаванне"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("балон"),
            keywords: &["балон", "празнуване"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("বেল\u{9c1}ন"),
            keywords: &["উদয\u{9be}পন", "বেল\u{9c1}ন"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("cʼhwezigell"),
            keywords: &["cʼhwezigell", "fest", "gouel"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("balon"),
            keywords: &["balon", "proslava", "zabava"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("globus"),
            keywords: &["celebració", "globus"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏃᎸᎠᏲᏙᏗ"),
            keywords: &["ᎠᎾᎵᎮᎵᎬᎢ", "ᎤᏃᎸᎠᏲᏙᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("balónek"),
            keywords: &["balónek", "oslava"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("balŵn"),
            keywords: &["balŵn", "dathliad"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("ballon"),
            keywords: &["ballon", "fest", "fødselsdag"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Luftballon"),
            keywords: &["Geburtstag", "Luftballon"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μπαλόνι"),
            keywords: &["γιορτή", "μπαλόνι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("balloon"),
            keywords: &["balloon", "celebration"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("globo"),
            keywords: &["celebración", "globo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["celebración", "fiesta", "globo"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["celebración", "fiesta", "globo"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("õhupall"),
            keywords: &["tähistamine", "õhupall"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("puxika"),
            keywords: &["ospakizun", "puxika"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("بادکنک"),
            keywords: &["بادکنک", "بزرگداشت", "جشن", "عید"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("ilmapallo"),
            keywords: &["ilmapallo", "juhla"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("lobo"),
            keywords: &["kaarawan", "lobo", "pagdiriwang"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("ballón"),
            keywords: &["ballón", "reyð"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("ballon gonflable"),
            keywords: &["ballon gonflable", "fête"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("ballon de fête"),
            keywords: &["ballon", "ballon de fête", "fête"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("balún"),
            keywords: &["balún", "ceiliúradh"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("bailiùn"),
            keywords: &["bailiùn", "comharrachadh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("globo"),
            keywords: &["aniversario", "festa", "globo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ફ\u{ac1}ગ\u{acd}ગો"),
            keywords: &["ઉજવણી", "ફ\u{ac1}ગ\u{acd}ગો"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("balan-balan"),
            keywords: &["balan-balan", "shagali"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("בלון"),
            keywords: &["בלון", "מסיבה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ग\u{941}ब\u{94d}बारा"),
            keywords: &["ग\u{941}ब\u{94d}बारा", "समारोह"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("balon"),
            keywords: &["balon", "slavlje"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("léggömb"),
            keywords: &["léggömb", "ünnep", "ünnepi hangulat", "ünneplés"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("փուչիկ"),
            keywords: &["տոն", "փուչիկ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("balon"),
            keywords: &["balon", "perayaan"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("Blonblo"),
            keywords: &["Blonblo", "enwemụaṅụrị"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("blaðra"),
            keywords: &["blaðra", "veisla"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("palloncino"),
            keywords: &["festa", "palloncino"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("風船"),
            keywords: &["バルーン", "風船"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("balon"),
            keywords: &["balon", "perayaan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ბუშტი"),
            keywords: &["აღნიშვნა", "ბუშტი", "ზეიმი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: None,
            keywords: &["asfugel"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("шар"),
            keywords: &["тойлау", "шар"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("ballon"),
            keywords: &["ballon", "fest", "fødselsdag"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17c9}ោងប\u{17c9}ោង"),
            keywords: &["ប\u{17c9}េងប\u{17c9}ោង", "ប\u{17c9}ោងប\u{17c9}ោង", "អបអរ"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬಲ\u{cc2}ನ\u{ccd}"),
            keywords: &["ಆಚರಣ\u{cc6}", "ಬಲ\u{cc2}ನ\u{ccd}", "ಸಂಭ\u{ccd}ರಮ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("풍선"),
            keywords: &["축하", "파티", "풍선"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("बोमाडो"),
            keywords: &["बोमाडो", "स\u{941}वाळो"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("шар"),
            keywords: &["майрам", "шар"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Ballon"),
            keywords: &["Ballon", "Feier"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໝາກປ\u{eb9}ມເປ\u{ebb}\u{ec9}າ"),
            keywords: &[
                "ສະເຫ\u{ebc}\u{eb5}ມສະຫ\u{ebc}ອງ",
                "ໝາກປ\u{eb9}ມເປ\u{ebb}\u{ec9}າ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("balionas"),
            keywords: &["balionas", "šventė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("balons"),
            keywords: &["balons", "svētki"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pūangi"),
            keywords: &["pūangi", "whakanuinga"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("балон"),
            keywords: &["балон", "прослава"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ബല\u{d42}ൺ"),
            keywords: &["ആഘോഷം", "ബല\u{d42}ൺ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("шаар"),
            keywords: &["баяр ёслол", "шаар"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("फ\u{941}गा"),
            keywords: &["उत\u{94d}सव", "फ\u{941}गा"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("belon"),
            keywords: &["belon", "perayaan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("bużżieqa"),
            keywords: &["bużżieqa", "ċelebrazzjoni"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လေပ\u{1030}ဖောင\u{103a}း"),
            keywords: &["ပ\u{103d}\u{1032}တော\u{103a}", "လေပ\u{1030}ဖောင\u{103a}း"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("ballong"),
            keywords: &["ballong", "feiring"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ब\u{947}ल\u{941}न"),
            keywords: &["ब\u{947}ल\u{941}न", "समारोह"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("ballon"),
            keywords: &["ballon", "feest"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("ballong"),
            keywords: &["ballong", "feiring"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବେଲ\u{b41}ନ\u{b4d}\u{200d}"),
            keywords: &["ଉତ\u{b4d}ସବ", "ବେଲ\u{b41}ନ\u{b4d}\u{200d}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਗ\u{a41}ਬਾਰਾ"),
            keywords: &["ਗ\u{a41}ਬਾਰਾ", "ਜਸ\u{a3c}ਨ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("پکانہ"),
            keywords: &["منانا", "پکانہ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Balun"),
            keywords: &["Balun", "Sẹlibréshọn"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("balon"),
            keywords: &["balon", "impreza", "uroczystość"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("پوکاڼۍ"),
            keywords: &["لمانځنه", "پوکاڼۍ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("balão"),
            keywords: &["balão", "comemoração"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["balão", "celebração", "festa"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("glubu"),
            keywords: &["glubu", "raymi"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("balon"),
            keywords: &["balon", "sărbătoare"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-333"),
            keywords: &["E10-333"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("воздушный шарик"),
            keywords: &["веревочка", "воздух", "воздушный", "праздник", "шарик"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("akabaruni"),
            keywords: &["akabaruni", "ibirori"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڦوڪڻو"),
            keywords: &["جشن", "ڦوڪڻو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("බැල\u{dd6}නය"),
            keywords: &["බැල\u{dd6}නය", "සැමර\u{dd4}ම"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("balónik"),
            keywords: &["balónik", "oslava"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("balon"),
            keywords: &["balon", "slavje"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("baaluun"),
            keywords: &["baaluun", "dabaaldag"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("tullumbace"),
            keywords: &["festim", "festë", "tullumbace"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("балон"),
            keywords: &["балон", "прослава"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("balon"),
            keywords: &["balon", "proslava"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("ballong"),
            keywords: &["ballong", "fest"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("puto"),
            keywords: &["puto", "sherehe"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பலூன\u{bcd}"),
            keywords: &[
                "குழந\u{bcd}தைகள\u{bcd}",
                "கொண\u{bcd}ட\u{bbe}ட\u{bcd}டம\u{bcd}",
                "திருவிழ\u{bbe}",
                "பலூன\u{bcd}",
                "ஹ\u{bc0}லியம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("గ\u{c3e}ల\u{c3f} బుడగ"),
            keywords: &["గ\u{c3e}ల\u{c3f}", "బుడగ"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ҳубоб"),
            keywords: &["ҳубоб", "ҷашн"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ล\u{e39}กโป\u{e48}ง"),
            keywords: &["ล\u{e39}กโป\u{e48}ง", "เฉล\u{e34}มฉลอง"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("şar"),
            keywords: &["baýramçylyk", "şar"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("foʻi pula"),
            keywords: &["foʻi pula"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("balon"),
            keywords: &["balon", "kutlama"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("شار"),
            keywords: &["تەبرىكلەش", "شار"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("повітряна кулька"),
            keywords: &["повітряна кулька", "святкування"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("غبارہ"),
            keywords: &["بلون", "جشن", "خوشی", "غبارہ", "مزہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("shar"),
            keywords: &["bayram", "shar"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bóng bay"),
            keywords: &["bóng bay", "lễ kỷ niệm"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("baloŋ"),
            keywords: &["baloŋ", "màggal"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ibhaloni"),
            keywords: &["ibhaloni", "umbhiyozo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Bàlúùnù"),
            keywords: &["Bàlúùnù", "ayẹyẹ"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("汽球"),
            keywords: &["慶祝", "汽球"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("汽球"),
            keywords: &["庆祝", "汽球"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("气球"),
            keywords: &["庆祝", "气球"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("氣球"),
            keywords: &["氣球"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ibhaluni"),
            keywords: &["ibhaluni", "umbungazo"],
        },
    ],
};
#[doc = "🎉"]
pub const PARTY_POPPER: crate::Emoji = crate::Emoji {
    glyph: "🎉",
    codepoint: "1F389",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "party popper",
    group: "Activities",
    subgroup: "event",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("partytjieklapper"),
            keywords: &["klapper", "partytjie", "partytjieklapper", "viering"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የድግስ ኮፍያ"),
            keywords: &["ታዳ", "ክብረ በዓል", "የድግስ ኮፍያ", "ግብዣ", "ፖፐር"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("فرقعة حفلة"),
            keywords: &["بارتي بوبر", "فرقعة حفلة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("প\u{9be}ৰ\u{9cd}টি পপ\u{9be}ৰ"),
            keywords: &[
                "উদয\u{9be}পন",
                "ট\u{9be}ড\u{9be}",
                "পপ\u{9be}ৰ",
                "প\u{9be}ৰ\u{9cd}টি",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qonaqlıq stimullaşdırıcısı"),
            keywords: &[
                "bayram",
                "qonaqlıq",
                "qonaqlıq stimullaşdırıcısı",
                "stimullaşdırıcı",
                "tada",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("хлапушка"),
            keywords: &["вечарына", "віншую", "свята", "хлапушка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("конфети"),
            keywords: &["конфети", "купон", "празнуване"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("প\u{9be}র\u{9cd}টি পপ\u{9be}র"),
            keywords: &[
                "উদয\u{9be}পন",
                "ট\u{9be}ড\u{9be}",
                "পপ\u{9be}র",
                "প\u{9be}র\u{9cd}টি",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kotilhon"),
            keywords: &["fest", "gouel", "kotilhon", "lid"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("pucanje i konfete"),
            keywords: &["proslava", "pucanje i konfete", "zabava"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("tub de confeti"),
            keywords: &["celebració", "confeti", "festa", "tub", "tub de confeti"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎵᏍᏆᎵᏍᎩ ᎠᏲᏍᏗᏍᎩ"),
            keywords: &["ᎠᎵᏍᏆᎵᏍᎩ ᎠᏲᏍᏗᏍᎩ", "ᎠᎾᎵᎮᎵᎬᎢ", "ᎠᎾᎵᎮᎵᏍᏗᏍᎬᎢ", "ᎠᏔᏍᎩᏍᏙᏗ", "ᏔᏓ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("vystřelovací konfety"),
            keywords: &[
                "konfetovač",
                "oslava",
                "párty",
                "tadá",
                "trubka",
                "vystřelovací konfety",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("popiwr parti"),
            keywords: &["dathliad", "parti", "popiwr", "tada"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("bordbombe"),
            keywords: &["bordbombe", "fest", "nytår"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Konfettibombe"),
            keywords: &["Feier", "Konfetti", "Konfettibombe", "Party"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("χαρτοπόλεμος"),
            keywords: &["γιορτή", "κομφετί", "κονφετί", "πάρτι", "χαρτοπόλεμος"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("party popper"),
            keywords: &["celebration", "party", "popper", "tada"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["celebration", "party", "popper", "ta-da"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cañón de confeti"),
            keywords: &["cañón de confeti", "celebración", "confeti", "fiesta"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("lanzador de serpentina"),
            keywords: &[
                "celebración",
                "fiesta",
                "lanzador de serpentina",
                "serpentina",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("pidupäev"),
            keywords: &["pidu", "pidupäev", "sünnipäev", "üllatus"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("aire-serpentina"),
            keywords: &["aire-serpentina", "festa", "ospakizuna", "serpentina"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("بمب کاغذ رنگی"),
            keywords: &[
                "بزرگداشت",
                "بمب کاغذ رنگی",
                "جشن",
                "عید",
                "مهمانی",
                "کاغذ رنگی",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("paukkuserpentiini"),
            keywords: &["juhla", "paukkuserpentiini", "yllätys"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("party popper"),
            keywords: &["confetti", "pagdiriwang", "party", "party popper"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("borðbumba"),
            keywords: &["borðbumba", "veitsla"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("cotillons"),
            keywords: &["cotillons", "fête"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("cornet à confettis"),
            keywords: &[
                "confettis",
                "cornet",
                "cornet à confettis",
                "célébration",
                "fête",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("pléiscín cóisire"),
            keywords: &["ceiliúradh", "cóisir", "pléiscín", "pléiscín cóisire"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("bragadair pàrtaidh"),
            keywords: &["bragadair", "comharrachadh", "cèilidh", "pàrtaidh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("lanzador de confeti"),
            keywords: &["confeti", "festa", "lanzador de confeti"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પાર\u{acd}ટી પોપર"),
            keywords: &["ઉજવણી", "પાર\u{acd}ટી", "પોપર"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mai bashewa na biki"),
            keywords: &[
                "biki",
                "mai bashewa",
                "mai bashewa na biki",
                "shagali",
                "tada",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פצצת קונפטי"),
            keywords: &["חגיגה", "מסיבה", "פצצת קונפטי", "קונפטי"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("पार\u{94d}टी पॉपर"),
            keywords: &["पार\u{94d}टी", "पॉपर", "समारोह"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("ispaljivač konfeta"),
            keywords: &[
                "ispaljivač",
                "ispaljivač konfeta",
                "konfeti",
                "slavlje",
                "zabava",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("partikellékek"),
            keywords: &[
                "buli",
                "partikellékek",
                "ünnep",
                "ünnepi hangulat",
                "ünneplés",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ճայթուկ"),
            keywords: &["երեկույթ", "ճայթուկ", "տոն"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("party popper"),
            keywords: &["jreng", "party popper", "perayaan", "popper"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihe mmapụta erimeri"),
            keywords: &["enwemụaṅụrị", "ihe mmapụta erimeri", "mmemme", "tada"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("knall"),
            keywords: &["hátíð", "knall", "veisla"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("spara coriandoli"),
            keywords: &["coriandoli", "festa", "party", "spara coriandoli"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("クラッカー"),
            keywords: &["お祝い", "クラッカー", "パーティー", "パーティークラッカー"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("hiasan pesta"),
            keywords: &["hiasan", "perayaan", "pesta", "riasan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ტკაცუნა"),
            keywords: &["აღნიშვნა", "ზეიმი", "ტკაცუნა", "წვეულება"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("шартылдақ"),
            keywords: &["дайын", "сауық кеші", "тойлау", "шартылдақ"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("bordbombe"),
            keywords: &["bordbombe", "fest", "nytår"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ជប\u{17cb}លៀង"),
            keywords: &[
                "ការប\u{17d2}រារព\u{17d2}ធព\u{17b7}ធ\u{17b8}",
                "ជប\u{17cb}លៀង",
                "ប\u{17d2}រដាប\u{17cb}បាញ\u{17cb}ចេញក\u{17d2}រដាសអបអរសាទរ",
                "ព\u{17b7}ធ\u{17b8}ជប\u{17cb}លៀង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪಾರ\u{ccd}ಟ\u{cbf} ಪೇಪರ\u{ccd}"),
            keywords: &[
                "ಆಚರಣ\u{cc6}",
                "ಪಾಪರ\u{ccd}",
                "ಪಾರ\u{ccd}ಟ\u{cbf}",
                "ಪಾರ\u{ccd}ಟ\u{cbf} ಪೇಪರ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("파티"),
            keywords: &["축하 파티", "파티"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("पार\u{94d}टी पोपर"),
            keywords: &["टाडा", "पार\u{94d}टी", "पोपर", "स\u{941}वाळो"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кече уюштургуч"),
            keywords: &["кече", "кече уюштургуч", "майрам", "отуруш"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Pochette-surprise"),
            keywords: &[
                "Feier",
                "Iwwerraschung",
                "Party",
                "Pochette",
                "Pochette-surprise",
                "Surprise",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ພາຕ\u{eb5}\u{ec9}ປ\u{eb1}ອບເປ\u{eb5}"),
            keywords: &[
                "ພາຕ\u{eb5}\u{ec9}ປ\u{eb1}ອບເປ\u{eb5}",
                "ສະເຫ\u{ebc}\u{eb5}ມສະຫ\u{ebc}ອງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("konfeti šaudyklė"),
            keywords: &["bum", "konfeti šaudyklė", "vakarėlis", "šauti", "šventė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("konfeti plaukšķene"),
            keywords: &["ballīte", "konfeti", "plaukšķene", "svētki"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pahū whakangahau"),
            keywords: &["pahū", "tarā", "whakangahau", "whakanuinga"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("прскалка со конфети"),
            keywords: &["конфети", "прослава", "прскалка со конфети"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പ\u{d3e}ർട\u{d4d}ടി പോപ\u{d4d}പർ"),
            keywords: &["ആഘോഷം", "പ\u{d3e}ർട\u{d4d}ടി", "പോപ\u{d4d}പർ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("үдэшлэгийн чимэглэл"),
            keywords: &["тэмдэглэх", "үдэшлэг", "үдэшлэгийн чимэглэл"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("पार\u{94d}टी पॉपर"),
            keywords: &["उत\u{94d}सव", "टाडा", "पार\u{94d}टी", "पॉपर"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("pencetus bunyi parti"),
            keywords: &[
                "parti",
                "pencetus bunyi",
                "pencetus bunyi parti",
                "perayaan",
                "tada",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("party popper"),
            keywords: &["party", "popper", "tada", "ċelebrazzjoni"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပါတ\u{102e}ဗြောက\u{103a}အ\u{102d}\u{102f}း"),
            keywords: &[
                "တာဒါ",
                "ပါတ\u{102e}",
                "ပါတ\u{102e}ဗြောက\u{103a}အ\u{102d}\u{102f}း",
                "ပ\u{103d}\u{1032}တော\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("smell-bon-bon"),
            keywords: &["feiring", "fest", "serpentin", "smell-bon-bon"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("पार\u{94d}टी पपर"),
            keywords: &["टाडा", "पपर", "पार\u{94d}टी", "समारोह"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("feestknaller"),
            keywords: &["feest", "feestknaller", "hoera", "knaller", "viering"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("smell-bon-bon"),
            keywords: &["feiring", "fest", "serpentin", "smell-bon-bon"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପ\u{b3e}ର\u{b4d}ଟ\u{b3f} ପପର\u{b4d}\u{200d}"),
            keywords: &[
                "ଉତ\u{b4d}ସବ",
                "ପପର\u{b4d}\u{200c}",
                "ପ\u{b3e}ର\u{b4d}ଟ\u{b3f}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪਾਰਟੀ ਪ\u{a4b}ਪਰ"),
            keywords: &["ਜਸ\u{a3c}ਨ", "ਪਾਰਟੀ", "ਪ\u{a4b}ਪਰ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("پارٹی وچ پٹاکیاں دی واج"),
            keywords: &[
                "دعوت",
                "زور دار آواز پیدا کرن آلی شے",
                "منانا",
                "ٹاڈا",
                "پارٹی وچ پٹاکیاں دی واج",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Pátí Pọ\u{301}pa"),
            keywords: &[
                "Páti",
                "Pátí Pọ\u{301}pa",
                "Pọ\u{301}pa",
                "Sẹlibréshọn",
                "Táda",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("tuba z konfetti"),
            keywords: &[
                "bal",
                "impreza",
                "konfetti",
                "tuba z konfetti",
                "uroczystość",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ګوند پاپر"),
            keywords: &["لمانځنه", "ټاډا", "پارټي", "پاپر", "ګوند پاپر"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("cone de festa"),
            keywords: &["alegria", "comemoração", "cone de festa", "festa"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("lança-confetes"),
            keywords: &["celebração", "confetti", "lança-confetes", "surpresa"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("confeti chʼamqaq"),
            keywords: &["ch’amqaq", "confeti", "confeti chʼamqaq", "raymi"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("tun cu confetti"),
            keywords: &["con", "confeti", "petrecere", "tun cu confetti"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-334"),
            keywords: &["E10-334"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("хлопушка"),
            keywords: &["бабах", "вечеринка", "праздник", "хлопушка"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("igikoresho gituritsa mu birori"),
            keywords: &[
                "agaturitsampapuro",
                "ibirori",
                "igikoresho gituritsa mu birori",
                "ikirori",
                "yeee",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("پارٽي پوپر"),
            keywords: &["جشن، پارٽي، پوپر، ٽاڊا", "پارٽي پوپر"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ප\u{dcf}ට\u{dd2} පොපර\u{dca}"),
            keywords: &[
                "උත\u{dca}සවය",
                "ට\u{dcf}ඩ\u{dcf}",
                "ප\u{dcf}ට\u{dd2} පොපර\u{dca}",
                "පොපර\u{dca}",
                "සැමර\u{dd4}ම",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("konfety"),
            keywords: &["konfety", "oslava", "párty", "salónka"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("pokalica za zabave"),
            keywords: &["pokalica", "pokalica za zabave", "slavje", "zabava"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("dhawaaqa xafladda"),
            keywords: &[
                "dabaaldag",
                "dhawaaq",
                "dhawaaqa xafladda",
                "tada",
                "xaflad",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fishek feste"),
            keywords: &["festim", "festë", "fishek", "fishek feste"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("конфете у туби"),
            keywords: &["зaбaвa", "кoнфeте", "конфете у туби", "прослава"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["конфете у туби"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("konfete u tubi"),
            keywords: &["konfete", "konfete u tubi", "proslava", "zabava"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["konfete u tubi"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("konfettismällare"),
            keywords: &["fest", "konfettismällare", "partypopper", "serpentiner"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mapambo ya sherehe"),
            keywords: &[
                "kusherehekea",
                "mapambo ya sherehe",
                "puto",
                "sherehe",
                "tada",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வண\u{bcd}ண வேடிக\u{bcd}கை"),
            keywords: &[
                "கொண\u{bcd}ட\u{bbe}ட\u{bcd}டம\u{bcd}",
                "வண\u{bcd}ண வேடிக\u{bcd}கை",
                "விருந\u{bcd}து",
                "வெற\u{bcd}றி அறிவிப\u{bcd}பு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ప\u{c3e}ర\u{c4d}ట\u{c40} ప\u{c3e}పర\u{c4d}"),
            keywords: &[
                "ప\u{c3e}పర\u{c4d}",
                "ప\u{c3e}ర\u{c4d}ట\u{c40}",
                "ప\u{c3e}ర\u{c4d}ట\u{c40}ల\u{c4d}ల\u{c4b} ధర\u{c3f}ంచ\u{c47} శంకం ఆక\u{c3e}ర ట\u{c4b}ప\u{c40}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("маводи тарфгарӣ (хлопушка)"),
            keywords: &[
                "маводи тарфгарӣ (хлопушка)",
                "тада",
                "хлопушка",
                "шабнишинӣ",
                "ҷашн",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ปาร\u{e4c}ต\u{e35}\u{e49}"),
            keywords: &["ปาร\u{e4c}ต\u{e35}\u{e49}", "เฉล\u{e34}มฉลอง"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("şüweleň parkyldawajy"),
            keywords: &[
                "baýramçylyk",
                "parkyldawaç",
                "tada",
                "şüweleň",
                "şüweleň parkyldawajy",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("paatipuna"),
            keywords: &["paatipuna"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("parti konfetisi"),
            keywords: &["konfeti", "kutlama", "parti", "parti konfetisi"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("سورۇن پارسىلدىقى"),
            keywords: &[
                "تەبرىكلەش",
                "سورۇن",
                "سورۇن پارسىلدىقى",
                "يورۇق",
                "پارسىلداق",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("хлопавка"),
            keywords: &["вечірка", "святкування", "сюрприз", "хлопавка"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("پارٹی کے پٹاخے"),
            keywords: &["جشن", "پارٹی", "پارٹی کے پٹاخے", "پٹاخے"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("paqildoq"),
            keywords: &["bayram", "nishonlash", "paqildoq", "syurpriz"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("pháo giấy buổi tiệc"),
            keywords: &[
                "buổi tiệc",
                "lễ kỷ niệm",
                "pháo bông sinh nhật",
                "pháo giấy buổi tiệc",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("bombu taabal"),
            keywords: &["bombu taabal", "màggal", "përëm", "swaare", "tada"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isidubuli setheko"),
            keywords: &[
                "ipati",
                "isidubuli",
                "isidubuli setheko",
                "tada",
                "umbhiyozo",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ariwo Ayẹye"),
            keywords: &["Ariwo Ayẹye", "aláríyá", "ayẹyẹ", "tádà", "àríyá"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("派對槍"),
            keywords: &["慶祝", "槍", "派對", "派對槍"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("派对枪"),
            keywords: &["庆祝", "枪", "派对", "派对枪"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("拉炮彩带"),
            keywords: &["庆祝", "彩带", "拉炮彩带", "派对", "派对礼宾花"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("拉炮"),
            keywords: &["拉炮"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("okuqhuma ephathini"),
            keywords: &[
                "iphathi",
                "itada",
                "okuqhuma ephathini",
                "ukuqhuma",
                "umbungazo",
            ],
        },
    ],
};
#[doc = "🎊"]
pub const CONFETTI_BALL: crate::Emoji = crate::Emoji {
    glyph: "🎊",
    codepoint: "1F38A",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "confetti ball",
    group: "Activities",
    subgroup: "event",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("konfettibal"),
            keywords: &["bal", "konfetti", "konfettibal", "viering"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የከረሜላ ኳስ"),
            keywords: &["ክብረ በዓል", "ኮንፌቲ ከረሜላ", "ኳስ", "የከረሜላ ኳስ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("كرة أوراق ملونة"),
            keywords: &["كرة أوراق ملونة", "كرة كونفتي", "كونفتي"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("কনফেটি বল"),
            keywords: &["উদয\u{9be}পন", "কনফেটি", "বল"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("konfetti topu"),
            keywords: &["bayram", "konfetti", "konfetti topu", "top"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("шарык з канфеці"),
            keywords: &["канфеці", "свята", "шар", "шарык з канфеці"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("топка с конфети"),
            keywords: &[
                "Топка с конфети",
                "конфети",
                "празнуване",
                "топка",
                "топка с конфети",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("কনফেট\u{9cd}টি বল"),
            keywords: &["উদয\u{9be}পন", "কনফেট\u{9cd}টি", "বল"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("koñfeti"),
            keywords: &["fest", "gouel", "koñfeti", "lid"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("konfete"),
            keywords: &["konfete", "proslava", "zabava"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("bola de confeti"),
            keywords: &["bola", "bola de confeti", "celebració", "confeti", "festa"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎵᎪᏛᏍᎩ ᎪᏪᎵ ᏍᏆᏞᏍᏗ"),
            keywords: &["ᎠᎵᎪᏛᏍᎩ ᎪᏪᎵ ᏍᏆᏞᏍᏗ", "ᎠᎾᎵᎮᎵᏍᏗᏍᎬᎢ", "ᎤᎵᎪᏛᏅᎢ ᎪᏪᎵ", "ᏍᏆᏞᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("konfetová koule"),
            keywords: &["konfetová koule", "konfety", "míč", "oslava"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("pelen gonffeti"),
            keywords: &["conffeti", "dathliad", "pelen gonffeti", "pêl"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("konfetti"),
            keywords: &["fest", "konfetti", "konfettidåse", "konfettiregn"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Konfettiball"),
            keywords: &["Feier", "Konfetti", "Konfettiball"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κομφετί"),
            keywords: &["γιορτή", "κομφετί", "κονφετί", "μπάλα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("confetti ball"),
            keywords: &["ball", "celebration", "confetti"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("bola de confeti"),
            keywords: &["bola de confeti", "celebración", "confeti"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("confeti"),
            keywords: &["celebración", "confeti", "festejo", "piñata"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("konfetid"),
            keywords: &["konfetid", "pall", "pidu"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("konfetiz betetako bola"),
            keywords: &["bola", "konfeti", "konfetiz betetako bola", "ospakizun"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("توپ پولکی"),
            keywords: &["توپ", "توپ پولکی", "جشن", "پولک"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("konfettipallo"),
            keywords: &["juhla", "konfetti", "konfettipallo", "koristepaperi"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("confetti ball"),
            keywords: &["confetti", "confetti ball", "pagdiriwang", "party"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("konfetti"),
            keywords: &["konfetti"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("confettis"),
            keywords: &["confettis", "fête"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("boule de confetti"),
            keywords: &[
                "boule",
                "boule de confetti",
                "confettis",
                "célébration",
                "fête",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("meall coinfití"),
            keywords: &["bainis", "coinfití", "meall coinfití", "pósadh"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("ball confetti"),
            keywords: &["ball", "bàla", "comharrachadh", "confetti", "cèilidh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("bola de confeti"),
            keywords: &["bola de confeti", "confeti", "festa"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("કાગળનો દડો"),
            keywords: &["ઉજવણી", "કાગળના\u{a82} ટ\u{ac1}કડા", "કાગળનો દડો", "દડો"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("ƙwallon confetti"),
            keywords: &["confetti", "shagali", "ƙwallo", "ƙwallon confetti"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("כדור קונפטי"),
            keywords: &["חגיגה", "כדור קונפטי", "מסיבה", "קונפטי"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("कॉनफ\u{93c}\u{947}टी बॉल"),
            keywords: &[
                "कॉनफ\u{93c}\u{947}टी",
                "कॉनफ\u{93c}\u{947}टी बॉल",
                "ग\u{947}\u{902}द",
                "समारोह",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("kugla s konfetima"),
            keywords: &["konfeti", "kugla", "kugla s konfetima", "slavlje"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("konfetti"),
            keywords: &["konfetti", "ünnep", "ünnepi hangulat", "ünneplés"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կոնֆետի"),
            keywords: &["գունդ", "կոնֆետի", "տոն"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("bola konfeti"),
            keywords: &["bola", "bola konfeti", "confetti", "perayaan"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("bọọlụ kọnfeti"),
            keywords: &["bọolụ", "bọọlụ kọnfeti", "enwemụaṅụrị", "kọnfeti"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("veisluskraut"),
            keywords: &["confetti", "pappírssnifsi", "veisla", "veisluskraut"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("coriandoli"),
            keywords: &["coriandoli", "festa", "palla", "palla di coriandoli"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("くす玉"),
            keywords: &["お祝い", "くす玉", "パーティー"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("balon konfeti"),
            keywords: &["balon", "konfeti", "perayaan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("კონფეტი"),
            keywords: &["აღნიშვნა", "ბურთი", "ზეიმი", "კონფეტი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("кәмпиттерге толы шар"),
            keywords: &["кәмпит", "кәмпиттерге толы шар", "тойлау", "шар"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("konfetti"),
            keywords: &["fest", "konfetti", "konfettidåse", "konfettiregn"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ដ\u{17bb}\u{17c6}បាល\u{17cb}ក\u{17d2}រដាសអបអរសាទរ"),
            keywords: &[
                "ដ\u{17bb}\u{17c6}បាល\u{17cb}ក\u{17d2}រដាសអបអរសាទរ",
                "ប\u{17d2}រអប\u{17cb}",
                "ប\u{17d2}រអប\u{17cb}ដាក\u{17cb}ផ\u{17d2}កាក\u{17d2}រដាសដើម\u{17d2}ប\u{17b8}បាចពេលអបអរសាទរ",
                "ផ\u{17d2}កាក\u{17d2}រដាស",
                "អបអរសាទរ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕಾನ\u{ccd}ಫ\u{cc6}ಟ\u{ccd}ಟ\u{cbf} ಬಾಲ\u{ccd}"),
            keywords: &[
                "ಆಚರಣ\u{cc6}",
                "ಕಾನ\u{ccd}ಫ\u{cc6}ಟ\u{ccd}ಟ\u{cbf} ಬಾಲ\u{ccd}",
                "ಬಾಲ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("박 터트리기"),
            keywords: &["기념", "박 터트리기", "축하"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("कॉन\u{94d}फ\u{947}टी बॉल"),
            keywords: &["कॉन\u{94d}फ\u{947}टी", "बॉल", "स\u{941}वाळो"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("конфетти тобу"),
            keywords: &["конфетти", "конфетти тобу", "майрам", "топ"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Konfettiball"),
            keywords: &["Ball", "Feier", "Konfetti", "Konfettiball"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລ\u{eb9}ກບານຄອນເຟຕ\u{eb5}"),
            keywords: &[
                "ລ\u{eb9}ກບານຄອນເຟຕ\u{eb5}",
                "ສະເຫ\u{ebc}\u{eb5}ມສະຫ\u{ebc}ອງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("konfeti kamuolys"),
            keywords: &["kamuolys", "konfeti", "šventė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("konfeti bumbiņa"),
            keywords: &[
                "ballīte",
                "konfeti",
                "konfeti bumbiņa",
                "plaukšķene",
                "svētki",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pōro wāhi pepa"),
            keywords: &["pōro", "pōro wāhi pepa", "whakanuinga", "wāhi-pepa ririki"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("топка со конфети"),
            keywords: &["конфети", "прослава", "топка со конфети"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കോൺഫെറ\u{d4d}റി ബോൾ"),
            keywords: &["ആഘോഷം", "കോൺഫെറ\u{d4d}റി", "ബോൾ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("жингэнэгч хонх"),
            keywords: &["баяр ёслол", "жингэнэгч хонх", "жингэнэх", "хонх"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("कॉनफ\u{947}टी बॉल\u{94d}स"),
            keywords: &[
                "उत\u{94d}सव",
                "कॉनफ\u{947}टी",
                "कॉनफ\u{947}टी बॉल\u{94d}स",
                "बॉल",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bebola konfeti"),
            keywords: &["bebola konfeti", "bola", "konfeti", "perayaan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ballun konfetti"),
            keywords: &["ballun", "konfetti", "ċelebrazzjoni"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "ရောင\u{103a}စ\u{102f}\u{1036}စက\u{1039}က\u{1030} ဗြောက\u{103a}အ\u{102d}\u{102f}း",
            ),
            keywords: &[
                "ပ\u{103d}\u{1032}တော\u{103a}",
                "ဘောလ\u{102f}\u{1036}း",
                "ရောင\u{103a}စ\u{102f}\u{1036}စက\u{1039}က\u{1030}",
                "ရောင\u{103a}စ\u{102f}\u{1036}စက\u{1039}က\u{1030} ဗြောက\u{103a}အ\u{102d}\u{102f}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("konfettiball"),
            keywords: &["feiring", "fest", "konfettiball", "konfettikule"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("कन\u{94d}फ\u{947}टी बल"),
            keywords: &["कन\u{94d}फ\u{947}टी", "बल", "समारोह"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("confettibal"),
            keywords: &["bal", "confetti", "confettibal", "viering"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("konfettiball"),
            keywords: &["feiring", "fest", "konfettiball", "konfettikule"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କନେଫେଟ\u{b3f} ବଲ\u{b4d}\u{200d}"),
            keywords: &[
                "ଉତ\u{b4d}ସବ",
                "କନଫେଟ\u{b3f}",
                "କନେଫେଟ\u{b3f} ବଲ\u{b4d}\u{200d}",
                "ବଲ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕ\u{a4b}ਨਫ\u{a48}ਟੀ ਬਾਲ"),
            keywords: &[
                "ਕ\u{a4b}ਨਫ\u{a47}ਟੀ",
                "ਕ\u{a4b}ਨਫ\u{a48}ਟੀ ਬਾਲ",
                "ਗ\u{a47}\u{a02}ਦ",
                "ਜਸ\u{a3c}ਨ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("شیرنی دی گیند"),
            keywords: &["شیرنی", "شیرنی دی گیند", "منانا", "گیند"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Kọnfẹ\u{301}ti Bọl"),
            keywords: &["Bọl", "Kọnfẹ\u{301}ti", "Sẹlibréshọn"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kula z konfetti"),
            keywords: &[
                "bal",
                "impreza",
                "konfetti",
                "kula z konfetti",
                "uroczystość",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("کنفټی بال"),
            keywords: &["بال", "لمانځنه", "کنفټی"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("confete"),
            keywords: &["bola", "bola de confetes", "comemoração", "confete"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("bola de confete"),
            keywords: &["bola", "bola de confete", "celebração", "confetti"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("muyu confetiwan"),
            keywords: &["confeti", "muyu", "muyu confetiwan", "raymi"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("minge cu confetti"),
            keywords: &["confeti", "minge cu confetti", "petrecere", "sărbătoare"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-335"),
            keywords: &["E10-335"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("конфетти"),
            keywords: &["вечеринка", "конфетти", "праздник"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("udupapuro tw’amabara"),
            keywords: &["confetti", "ibirori", "udupapuro tw’amabara", "umupira"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪانفيتي بال"),
            keywords: &["بال، جشن، ڪانفيتي", "ڪانفيتي بال"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කොන\u{dca}ෆෙට\u{dd2} බෝල\u{dca}"),
            keywords: &["කොන\u{dca}ෆෙට\u{dd2}", "බෝල\u{dca}", "සැමර\u{dd4}ම"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("konfetová guľa"),
            keywords: &["guľa", "konfetová guľa", "konfety", "oslava"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("konfeti"),
            keywords: &["konfeti", "krogla", "slavje"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("kubada qarsoon"),
            keywords: &["dabaaldag", "kubad", "kubada qarsoon", "qarsoodi ah"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("top me konfetë"),
            keywords: &["festim", "festë", "konfeti", "top", "top me konfetë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("конфете у лопти"),
            keywords: &["кoнфeте", "конфете у лопти", "куглa", "прослава"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["конфете у лопти"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("konfete u lopti"),
            keywords: &["konfete", "konfete u lopti", "kugla", "proslava"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["konfete u lopti"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("konfettiboll"),
            keywords: &["boll", "fest", "konfetti", "konfettiboll"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mpira wa mapambo"),
            keywords: &["kusherehekea", "mapambo", "mpira", "mpira wa mapambo"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வண\u{bcd}ணக\u{bcd} க\u{bbe}கிதங\u{bcd}களைத\u{bcd} தூவும\u{bcd} பந\u{bcd}து"),
            keywords: &[
                "கொண\u{bcd}ட\u{bbe}ட\u{bcd}டம\u{bcd}",
                "திருமணம\u{bcd}",
                "பிறந\u{bcd}தந\u{bbe}ள\u{bcd}",
                "வண\u{bcd}ணக\u{bcd} க\u{bbe}கிதங\u{bcd}களைத\u{bcd} தூவும\u{bcd} பந\u{bcd}து",
                "வ\u{bbe}ழ\u{bcd}த\u{bcd}துகள\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("రంగు క\u{c3e}గ\u{c3f}త\u{c3e}లు న\u{c3f}ంప\u{c3f}న బంత\u{c3f}"),
            keywords: &[
                "బ\u{c3e}ల\u{c4d}",
                "రంగు క\u{c3e}గ\u{c3f}త\u{c3e}లు",
                "రంగు క\u{c3e}గ\u{c3f}త\u{c3e}లు న\u{c3f}ంప\u{c3f}న బంత\u{c3f}",
                "వ\u{c47}డుకలు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("кӯраи конфетти"),
            keywords: &["конфетти", "кӯраи конфетти", "тӯб", "ҷашн"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ล\u{e39}กบอลใส\u{e48}เศษกระดาษงานปาร\u{e4c}ต\u{e35}\u{e49}"),
            keywords: &[
                "ล\u{e39}กบอลใส\u{e48}เศษกระดาษงานปาร\u{e4c}ต\u{e35}\u{e49}",
                "เฉล\u{e34}มฉลอง",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("konfetti topy"),
            keywords: &["baýramçylyk", "konfetti", "konfetti topy", "top"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("pulu konifeti"),
            keywords: &["pulu konifeti"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("konfeti"),
            keywords: &["konfeti", "konfeti topu", "kutlama", "top"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قەغەز ئۇۋاق"),
            keywords: &["ئۇۋاق", "توپ", "تەبرىكلەش", "قەغەز ئۇۋاق"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("кулька з конфеті"),
            keywords: &["конфеті", "кулька з конфеті", "святкування"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("رنگین کاغذ کے بالز"),
            keywords: &["بالز", "رنگین کاغذ", "رنگین کاغذ کے بالز"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("konfetti"),
            keywords: &["konfet", "konfetti", "nishonlash", "shar"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bóng hoa giấy"),
            keywords: &["bóng hoa giấy", "lễ kỷ niệm", "quả bóng"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("mànqu konfeti"),
            keywords: &["konfeti", "màggal", "mànq", "mànqu konfeti"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ibhola enamaphepha amahle"),
            keywords: &[
                "amaphepha amahle",
                "ibhola",
                "ibhola enamaphepha amahle",
                "umbhiyozo",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Bọọlu Kọnfẹti"),
            keywords: &["Bọọlu Kọnfẹti", "ayẹyẹ", "bọ\u{301}ọ\u{300}lù", "kọnfetí"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("紙屑球"),
            keywords: &["慶祝", "球", "紙屑", "紙屑球"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("纸屑球"),
            keywords: &["庆祝", "球", "纸屑", "纸屑球"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("五彩纸屑球"),
            keywords: &["五彩纸屑球", "庆祝", "球"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("五彩紙屑"),
            keywords: &["五彩紙屑", "彩球"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("恭賀彩球"),
            keywords: &["五彩紙屑", "恭賀彩球"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ibhola eliqhumayo"),
            keywords: &["ibhala", "ibhola eliqhumayo", "ukuqhuma", "umbungazo"],
        },
    ],
};
#[doc = "🎋"]
pub const TANABATA_TREE: crate::Emoji = crate::Emoji {
    glyph: "🎋",
    codepoint: "1F38B",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "tanabata tree",
    group: "Activities",
    subgroup: "event",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("tanabataboom"),
            keywords: &[
                "banier",
                "boom",
                "japannees",
                "tanabataboom",
                "vaandel",
                "viering",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ታንባታ ዛፍ"),
            keywords: &["ሰንደቅ", "ታንባታ ዛፍ", "ክብረ በዓል", "ዛፍ", "የጃፓን"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("شجرة احتفال"),
            keywords: &["شجرة", "شجرة احتفال", "شجرة وشرائط ورقية"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ট\u{9be}ন\u{9be}ব\u{9be}ন\u{9be}ট\u{9be} গছ"),
            keywords: &[
                "উদয\u{9be}পন",
                "গছ",
                "জ\u{9be}প\u{9be}নী",
                "ট\u{9be}ন\u{9be}ব\u{9be}ন\u{9be}ট\u{9be} গছ",
                "বেন\u{9be}ৰ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("tanabata ağacı"),
            keywords: &["ağac", "banner", "bayram", "tanabata ağacı", "yapon"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("дрэва танабата"),
            keywords: &["дрэва", "дрэва танабата", "свята", "тандзаку", "японскае"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("дърво за танабата"),
            keywords: &[
                "Дърво за танабата",
                "дърво",
                "дърво за танабата",
                "знаме",
                "празнуване",
                "японски",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ত\u{9be}ন\u{9be}ব\u{9be}ত\u{9be} ট\u{9cd}রী"),
            keywords: &[
                "উদয\u{9be}পন",
                "গ\u{9be}ছ",
                "জ\u{9be}প\u{9be}নি",
                "ত\u{9be}ন\u{9be}ব\u{9be}ত\u{9be} ট\u{9cd}রী",
                "ব\u{9cd}য\u{9be}ন\u{9be}র",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("gwez-hetoù"),
            keywords: &["fest", "gouel", "gwez-hetoù", "lid"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("tanabata stablo"),
            keywords: &["japan", "proslava", "stablo", "tanabata stablo", "zabava"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("arbre dels desitjos de Tanabata"),
            keywords: &[
                "Tanabata",
                "arbre",
                "arbre dels desitjos de Tanabata",
                "celebració",
                "desitjos",
                "japonès",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎵᎮᎵᏍᏙᏗ ᎢᏡᎬ"),
            keywords: &["ᎠᎵᎮᎵᏍᏙᏗ ᎢᏡᎬ", "ᎠᎾᎵᎮᎵᏍᏗᏍᎬᎢ", "ᎢᏡᎬᎢ", "ᎦᏓᏗ", "ᏣᏩᏂᏏ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("strom přání"),
            keywords: &[
                "japonský",
                "lístek",
                "oslava",
                "strom",
                "strom přání",
                "tanabata",
                "zástava",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("coeden tanabata"),
            keywords: &[
                "Japaneaidd",
                "baner",
                "coeden",
                "coeden tanabata",
                "dathliad",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("træ med papirpynt"),
            keywords: &["festival", "japansk", "tanabata", "træ med papirpynt"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Tanabata-Baum"),
            keywords: &[
                "Baum",
                "Fest",
                "Japan",
                "Sternenfest",
                "Tanabata-Baum",
                "Zettel",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("δέντρο ταναμπάτα"),
            keywords: &["γιορτή", "δέντρο", "δέντρο ταναμπάτα", "ιαπωνικό", "μπάνερ"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("tanabata tree"),
            keywords: &["Japanese", "banner", "celebration", "tanabata tree", "tree"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &[
                "Japanese",
                "banner",
                "celebration",
                "star festival",
                "tanabata",
                "tree",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("Tanabata tree"),
            keywords: &["Japanese", "Tanabata tree", "banner", "celebration", "tree"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("árbol de tanabata"),
            keywords: &[
                "celebración",
                "festividad",
                "tanabata",
                "árbol",
                "árbol de tanabata",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &[
                "estrellas",
                "festividad",
                "fiesta",
                "japonesa",
                "papel",
                "árbol de tanabata",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("tanabata soovipuu"),
            keywords: &["pidu", "puu", "tanabata soovipuu"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("tanabata zuhaitza"),
            keywords: &[
                "japonia",
                "ospakizun",
                "paper",
                "tanabata zuhaitza",
                "zuhaitz",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("درخت تاناباتا"),
            keywords: &["بنر", "جشن", "جشنواره", "درخت", "درخت تاناباتا", "ژاپنی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("tanabatapuu"),
            keywords: &["Japani", "bambu", "juhla", "puu", "tanabata", "tanabatapuu"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("tanabata tree"),
            keywords: &["banner", "japanese", "pagdiriwang", "puno", "tanabata tree"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("tanabata træ"),
            keywords: &["japanskt", "tanabata", "træ"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("arbre à vœux"),
            keywords: &["arbre", "arbre à vœux", "vœux"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("arbre à prières"),
            keywords: &["arbre", "arbre à prières", "japonais", "tanabata"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("crann tanabata"),
            keywords: &[
                "crann tanabata",
                "céiliúradh",
                "maisiúchán",
                "stiallacha páipéir",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("craobh tanabata"),
            keywords: &[
                "bratach",
                "comharrachadh",
                "craobh",
                "craobh tanabata",
                "iapanach",
                "seapanach",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("árbore dos desexos de Tanabata"),
            keywords: &[
                "celebración",
                "tiras de papel",
                "xaponés",
                "árbore",
                "árbore dos desexos de Tanabata",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ઝાડ અન\u{ac7} કાગળની પટ\u{acd}ટીઓ"),
            keywords: &[
                "ઉજવણી",
                "કાગળ સ\u{acd}ટ\u{acd}રીપ\u{acd}સ",
                "ઝાડ",
                "ઝાડ અન\u{ac7} કાગળ સ\u{acd}ટ\u{acd}રીપ\u{acd}સ",
                "ઝાડ અન\u{ac7} કાગળની પટ\u{acd}ટીઓ",
                "તારા ઉત\u{acd}સવ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("bishiyar tanabata"),
            keywords: &[
                "Na japan",
                "bishiya",
                "bishiyar tanabata",
                "shagali",
                "tuta",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("קישוט חג יפני"),
            keywords: &["חג", "חגיגה", "יפני", "קישוט"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("टानाबाटा का प\u{947}ड\u{93c}"),
            keywords: &[
                "कागज की पट\u{94d}टिया\u{902}",
                "टानाबाटा का प\u{947}ड\u{93c}",
                "प\u{947}ड\u{93c}",
                "प\u{947}ड\u{93c} और कागज की पट\u{94d}टिया\u{902}",
                "समारोह",
                "स\u{94d}टार त\u{94d}योहार",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("drvo tanabata"),
            keywords: &["Japan", "drvo", "drvo tanabata", "slavlje", "zastava"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("tanabata ünnepi fa"),
            keywords: &[
                "fa",
                "japán",
                "tanabata ünnepi fa",
                "ünnep",
                "ünnepi hangulat",
                "ünneplés",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("տանաբատա"),
            keywords: &["դրոշակ", "ծառ", "ճապոնական", "տանաբատա", "տոն"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("pohon tanabata"),
            keywords: &["jepang", "perayaan", "pohon", "pohon tanabata", "spanduk"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("osisi tanabata"),
            keywords: &[
                "Ndị Japan",
                "banna",
                "enwemụaṅụrị",
                "osisi",
                "osisi tanabata",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("Tanabata-tré"),
            keywords: &[
                "Tanabata-tré",
                "borði",
                "fagnaður",
                "japanskt",
                "tanabata-tré",
                "tré",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("albero di Tanabata"),
            keywords: &[
                "Festa delle stelle",
                "albero",
                "albero di Tanabata",
                "decorazioni di carta",
                "festa",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("七夕"),
            keywords: &["七夕", "和", "日本", "短冊"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("wit tanabata"),
            keywords: &["Jepang", "perayaan", "spanduk", "wit", "wit tanabata"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ტანაბატას ხე"),
            keywords: &["აღნიშვნა", "ზეიმი", "იაპონური", "ტანაბატას ხე", "ხე"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("Танабата ағашы"),
            keywords: &["Танабата ағашы", "ағаш", "баннер", "жапон", "тойлау"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("træ med papirpynt"),
            keywords: &["festival", "træ med papirpynt"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ដើមឈើលម\u{17d2}អក\u{17d2}ន\u{17bb}ងព\u{17b7}ធ\u{17b8}"),
            keywords: &[
                "ដើមឈើ",
                "ដើមឈើលម\u{17d2}អក\u{17d2}ន\u{17bb}ងព\u{17b7}ធ\u{17b8}",
                "ដើមឈើល\u{17c6}អក\u{17d2}ន\u{17bb}ងព\u{17b7}ធ\u{17b8}",
                "ព\u{17b7}ធ\u{17b8}",
                "លម\u{17d2}អ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ತಾನಾಬಾಟ ಮರ"),
            keywords: &[
                "ಆಚರಣ\u{cc6}",
                "ಕಾಗದ ಪಟ\u{ccd}ಟ\u{cbf}ಗಳು",
                "ತಾನಾಬಾಟ ಮರ",
                "ಮರ",
                "ಸ\u{ccd}ಟಾರ\u{ccd} ಫ\u{cc6}ಸ\u{ccd}ಟ\u{cbf}ವಲ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("소원을 건 나무"),
            keywords: &[
                "기원 쪽지",
                "소원 빌기",
                "소원 쪽지",
                "소원 쪽지 매달기",
                "소원을 건 나무",
            ],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("तानाबाटा झाड"),
            keywords: &["जपानी", "झाड", "तानाबाटा झाड", "पताका", "स\u{941}वाळो"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("танабата дарагы"),
            keywords: &["дарак", "жапончо", "көрнөк", "майрам", "танабата дарагы"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Tanabata-Bam"),
            keywords: &["Bam", "Banner", "Feier", "Tanabata-Bam", "japanesch"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຕ\u{ebb}\u{ec9}ນໄມ\u{ec9}ປະດ\u{eb1}ບຄຳອວຍພອນ"),
            keywords: &[
                "ຄຳອວຍພອນ",
                "ຍ\u{eb5}\u{ec8}ປ\u{eb8}\u{ec8}ນ",
                "ຕ\u{ebb}\u{ec9}ນໄມ\u{ec9}",
                "ຕ\u{ebb}\u{ec9}ນໄມ\u{ec9}ປະດ\u{eb1}ບຄຳອວຍພອນ",
                "ສະເຫ\u{ebc}\u{eb5}ມສະຫ\u{ebc}ອງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("tanabata medis"),
            keywords: &["japonų", "medis", "tanabata medis", "šventė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("vēlmju koks"),
            keywords: &["japāņu", "koks", "vēlmju koks", "vēlēšanās"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("rākau tanapata"),
            keywords: &["Hapanīhi", "kara", "rākau", "rākau tanapata", "whakanuinga"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("јапонско дрво на желбите"),
            keywords: &["дрво", "прослава", "јапонска", "јапонско дрво на желбите"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("തനബത\u{d4d}ത മരം"),
            keywords: &[
                "ആഘോഷം",
                "തനബത\u{d4d}ത ട\u{d4d}രീ",
                "തനബത\u{d4d}ത മരം",
                "സ\u{d4d}റ\u{d4d}റ\u{d3e}ർ ഫെസ\u{d4d}റ\u{d4d}റിവൽ നക\u{d4d}ഷത\u{d4d}ര ആഘോഷം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("танабата мод"),
            keywords: &["мод", "танабата", "япон"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("तानबाताच\u{947} झाड"),
            keywords: &[
                "उत\u{94d}सव",
                "जपानी",
                "झाड",
                "तानबाताच\u{947} झाड",
                "ब\u{945}नर",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("pokok tanabata"),
            keywords: &["jepun", "perayaan", "pokok", "pokok tanabata", "sepanduk"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("siġra tat-tanabata"),
            keywords: &[
                "siġra",
                "siġra tat-tanabata",
                "strixxun",
                "ċelebrazzjoni",
                "Ġappuniż",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("တာနဘတ အပင\u{103a}"),
            keywords: &[
                "ဂျပန\u{103a}",
                "တာနဘတ အပင\u{103a}",
                "တ\u{1036}ခ\u{103d}န\u{103a}",
                "ပ\u{103d}\u{1032}တော\u{103a}",
                "အပင\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("tanabatatre"),
            keywords: &[
                "feiring",
                "papirremser",
                "stjernefestival",
                "tanabata",
                "tanabatatre",
                "tre",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("तनाबटा र\u{942}ख"),
            keywords: &[
                "जापानी",
                "तनाबटा र\u{942}ख",
                "ब\u{94d}यानर",
                "र\u{942}ख",
                "समारोह",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("tanabataboom"),
            keywords: &["boom", "feest", "japans", "papierlinten", "tanabataboom"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("tanabatatre"),
            keywords: &[
                "feiring",
                "papirremser",
                "stjernefestival",
                "tanabata",
                "tanabatatre",
                "tre",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଟ\u{b3e}ନ\u{b3e}ବ\u{b3e}ଟ\u{b3e} ଗଛ"),
            keywords: &[
                "ଉତ\u{b4d}ସବ",
                "ଗଛ",
                "ଜ\u{b3e}ପ\u{b3e}ନୀ",
                "ଟ\u{b3e}ନ\u{b3e}ବ\u{b3e}ଟ\u{b3e} ଗଛ",
                "ବ\u{b4d}ୟ\u{b3e}ନର\u{b4d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਟਾਨਾਬਾਟਾ ਟ\u{a4d}ਰੀ"),
            keywords: &[
                "ਕਾਗਜ\u{a3c} ਟ\u{a41}ਕੜ\u{a47}",
                "ਜਸ\u{a3c}ਨ",
                "ਟਾਨਾਬਾਟਾ ਟ\u{a4d}ਰੀ",
                "ਤਾਰਾ ਤਿਉਹਾਰ",
                "ਬ\u{a48}ਨਰ",
                "ਰ\u{a41}\u{a71}ਖ",
                "ਰ\u{a41}\u{a71}ਖ ਅਤ\u{a47} ਕਾਗਜ\u{a3c} ਟ\u{a41}ਕੜ\u{a47}",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("تانابتا ٹری"),
            keywords: &["بینر", "تانابتا ٹری", "جاپانی", "درخت", "منانا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Tanábátá Tri"),
            keywords: &["Bána", "Japan", "Sẹlibréshọn", "Tanábátá Tri", "Tri"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("drzewko na Tanabata"),
            keywords: &[
                "drzewko na Tanabata",
                "drzewo",
                "japońskie",
                "tanabata",
                "życzenia",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د تناباتا ونې"),
            keywords: &[
                "بينر",
                "جاپاني",
                "د تناباتا ونې",
                "د تناباتي ونه",
                "لمانځنه",
                "ونه",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("árvore de tanabata"),
            keywords: &[
                "comemoração",
                "árvore",
                "árvore de tanabata",
                "árvore japanesa",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("árvore do Tanabata"),
            keywords: &[
                "celebração",
                "faixa",
                "japonês",
                "árvore",
                "árvore do Tanabata",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("tanabata sachʼa"),
            keywords: &["Japones", "baner", "raymi", "sach’a", "tanabata sachʼa"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("copac tanabata"),
            keywords: &["Japonia", "copac", "copac tanabata", "sărbătoare"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-336"),
            keywords: &["E10-336"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("бамбук с бумажными лентами"),
            keywords: &[
                "бамбук",
                "бамбук с бумажными лентами",
                "бумага",
                "дерево",
                "танабата",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("igiti cya tanabata"),
            keywords: &[
                "Umuyapani",
                "akabendera",
                "ibirori",
                "igiti",
                "igiti cya tanabata",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("تاناباتا وڻ"),
            keywords: &["بينر، جشن، جاپاني، وڻ", "تاناباتا وڻ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("තනබත\u{dcf} ගස"),
            keywords: &[
                "ගස",
                "ජපන\u{dca}",
                "තනබත\u{dcf} ගස",
                "බැනරය",
                "සැමර\u{dd4}ම",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("stromček tanabata"),
            keywords: &["japonský", "oslava", "stromček", "tanabata", "zástava"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("drevo za tanabato"),
            keywords: &["drevo", "drevo za tanabato", "japonsko", "pasica", "slavje"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("geedka axdiga"),
            keywords: &[
                "Japenese",
                "dabaaldag",
                "geed",
                "geedka axdiga",
                "naqshadeyn",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("pemë tanabata"),
            keywords: &["banderolë", "festim", "festë", "japoneze", "pemë tanabata"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("дрво танабата"),
            keywords: &["jaпaн", "дрвo", "дрво танабата", "зaстaвa", "прослава"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("drvo tanabata"),
            keywords: &["drvo", "drvo tanabata", "japan", "proslava", "zastava"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("tanabataträd"),
            keywords: &[
                "fest",
                "japansk festival",
                "pappersremsor",
                "tanabataträd",
                "träd",
                "träd med pappersremsor",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mti wa tanabata"),
            keywords: &[
                "bango",
                "kijapani",
                "kusherehekea",
                "mti",
                "mti wa tanabata",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("தனபத\u{bbe} மரம\u{bcd}"),
            keywords: &[
                "கொண\u{bcd}ட\u{bbe}ட\u{bcd}டம\u{bcd}",
                "ஜப\u{bcd}ப\u{bbe}ன\u{bcd}",
                "தனபத\u{bbe} மரம\u{bcd}",
                "த\u{bbe}ன\u{bbe}ப\u{bbe}த\u{bbe} மரம\u{bcd}",
                "தோரணம\u{bcd}",
                "மரம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ట\u{c3e}న\u{c3e}బ\u{c47}ట\u{c3e} చ\u{c46}ట\u{c4d}టు"),
            keywords: &[
                "క\u{c3e}గ\u{c3f}తపు ప\u{c47}ల\u{c3f}కలు",
                "క\u{c3e}గ\u{c3f}త\u{c3e}లు వ\u{c47}ల\u{c3e}డద\u{c40}స\u{c3f}న చ\u{c46}ట\u{c4d}టు",
                "ట\u{c3e}న\u{c3e}బ\u{c47}ట\u{c3e} చ\u{c46}ట\u{c4d}టు",
                "నక\u{c4d}షత\u{c4d}ర\u{c3e}ల పండుగ",
                "వృక\u{c4d}షం",
                "వ\u{c47}డుక",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("дарахти Танабата"),
            keywords: &["баннер", "дарахт", "дарахти Танабата", "ҷашн", "ҷопонӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ต\u{e49}นไม\u{e49}ประด\u{e31}บคำอวยพร"),
            keywords: &[
                "คำอวยพร",
                "ญ\u{e35}\u{e48}ป\u{e38}\u{e48}น",
                "ต\u{e49}นไม\u{e49}",
                "ต\u{e49}นไม\u{e49}ประด\u{e31}บคำอวยพร",
                "เฉล\u{e34}มฉลอง",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("tanabata agajy"),
            keywords: &["agaç", "banner", "baýramçylyk", "tanabata agajy", "ýapon"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ʻakau kātoanga-fetuʻu"),
            keywords: &["ʻakau kātoanga-fetuʻu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("tanabata ağacı"),
            keywords: &[
                "Star Festivali",
                "ağaç",
                "kağıt şeritler",
                "kutlama",
                "tanabata ağacı",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("تاناباتا دەرىخى"),
            keywords: &[
                "تاناباتا دەرىخى",
                "تەبرىكلەش",
                "دەرەخ",
                "ياپونچە",
                "پىلاكات",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("танабата, гілка тандзаку"),
            keywords: &[
                "банер",
                "дерево",
                "святкування",
                "танабата, гілка тандзаку",
                "японський",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("تنابتا درخت"),
            keywords: &["تنابتا درخت", "جاپانی", "جشن", "درخت"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("tanabata daraxti"),
            keywords: &["banner", "bayram", "daraxt", "tanabata daraxti", "yapon"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("cây tanabata"),
            keywords: &[
                "biểu ngữ",
                "cây",
                "cây tanabata",
                "kiểu nhật bản",
                "lễ kỷ niệm",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("garabu tanabata"),
            keywords: &["Sapone", "garab", "garabu tanabata", "màggal", "raaya"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umthi we-tanabata"),
            keywords: &[
                "ibhena",
                "umbhiyozo",
                "umthi",
                "umthi we-tanabata",
                "yaseJapan",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Igi Tanabata"),
            keywords: &["Igi Tanabata", "ayẹyẹ", "igi", "japanese", "ánà"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("丹參樹"),
            keywords: &["丹參樹", "慶祝", "日本", "樹", "橫額"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("丹参树"),
            keywords: &["丹参树", "庆祝", "日本", "树", "横额"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("七夕树"),
            keywords: &["七夕", "七夕树", "庆祝", "日本", "树"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("七夕"),
            keywords: &["七夕", "七夕樹"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isihlahla setanabata"),
            keywords: &["isihlahla", "isihlahla setanabata", "japanese", "umbungazo"],
        },
    ],
};
#[doc = "🎍"]
pub const PINE_DECORATION: crate::Emoji = crate::Emoji {
    glyph: "🎍",
    codepoint: "1F38D",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "pine decoration",
    group: "Activities",
    subgroup: "event",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("denneversiering"),
            keywords: &[
                "bamboes",
                "den",
                "denneversiering",
                "japannees",
                "plant",
                "viering",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የጽድ ጌጥ"),
            keywords: &["ቀርቅሃ", "ተክል", "ክብረ በዓል", "የጃፓን", "የጽድ ጌጥ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ديكور صنوبر"),
            keywords: &["احتفال", "ديكور صنوبر", "صنوبر", "عام جديد"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("প\u{9be}ইন সজ\u{9cd}জ\u{9be}"),
            keywords: &[
                "উদয\u{9be}পন",
                "জ\u{9be}প\u{9be}নী",
                "প\u{9be}ইন",
                "প\u{9be}ইন সজ\u{9cd}জ\u{9be}",
                "ব\u{9be}\u{981}হ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("şam ağacı bəzəyi"),
            keywords: &[
                "bambuk",
                "bayram",
                "bitki",
                "yapon",
                "şam",
                "şam ağacı bəzəyi",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("кадамацу"),
            keywords: &["бамбук", "кадамацу", "свята", "хвоя", "японскае"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("украса кадомацу"),
            keywords: &[
                "Украса кадомацу",
                "бамбук",
                "празнуване",
                "растение",
                "украса кадомацу",
                "японски",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("প\u{9be}ইনের সজ\u{9cd}জ\u{9be}"),
            keywords: &[
                "উদয\u{9be}পন",
                "জ\u{9be}প\u{9be}নি",
                "প\u{9be}ইন",
                "প\u{9be}ইনের সজ\u{9cd}জ\u{9be}",
                "ব\u{9be}\u{981}শ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kadomatsu"),
            keywords: &["bambouz", "kadomatsu"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("ukras od borovine"),
            keywords: &["bambus", "japan", "proslava", "stablo", "ukras od borovine"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("decoració de pi"),
            keywords: &[
                "bambú",
                "celebració",
                "decoració",
                "decoració de pi",
                "japonès",
                "pi",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏃᏣ ᎠᏬᏚᏍᏓᏅ"),
            keywords: &["ᎠᎾᎵᎮᎵᏍᏗᏍᎬᎢ", "ᎢᎯᏱ ᎤᏔᎾ", "ᏃᏣ ᎠᏬᏚᏍᏓᏅ", "ᏃᏥ", "ᏣᏩᏂᏏ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("bambusové dekorace"),
            keywords: &[
                "bambus",
                "bambusové dekorace",
                "japonský",
                "kadomacu",
                "kadomatsu",
                "oslava",
                "ozdoba",
                "pinie",
                "rostlina",
                "výzdoba",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("addurn pinwydden"),
            keywords: &[
                "addurn pinwydden",
                "bambŵ",
                "dathliad",
                "pinwydden",
                "planhigyn",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("fyrretræsdekoration"),
            keywords: &["fyrretræsdekoration", "japansk nytår"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Piniendekoration"),
            keywords: &["Japan", "Neujahrsfest", "Piniendekoration"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("διακοσμητικό πεύκο"),
            keywords: &[
                "γιορτή",
                "διακοσμητικό πεύκο",
                "ιαπωνικό",
                "μπαμπού",
                "πεύκο",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("pine decoration"),
            keywords: &[
                "Japanese",
                "bamboo",
                "celebration",
                "pine",
                "pine decoration",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("bamboo decoration"),
            keywords: &["Japanese", "bamboo", "celebration", "decoration"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("decoración de pino"),
            keywords: &[
                "año nuevo japonés",
                "bambú",
                "celebración",
                "decoración",
                "decoración de pino",
                "kadomatsu",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("adorno para pinos"),
            keywords: &["adorno para pinos", "año", "japonés", "nuevo", "pino"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("adorno para pino"),
            keywords: &[
                "adorno para pino",
                "bambú",
                "celebración",
                "japonés",
                "pino",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("väravamänd"),
            keywords: &["bambus", "mänd", "puu", "taim", "väravamänd"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("pinurako dekorazioa"),
            keywords: &[
                "banbu",
                "japonia",
                "ospakizun",
                "pinu",
                "pinurako dekorazioa",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("تزئین کاج"),
            keywords: &[
                "بامبو",
                "تزئین کاج",
                "جشن",
                "جشنواره",
                "ژاپنی",
                "کاج",
                "گیاه",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("puukoriste"),
            keywords: &["Japani", "bambu", "havu", "juhla", "puukoriste"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pine decoration"),
            keywords: &["dekorasyon", "kawayan", "pine", "pine decoration"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("kadomatsu"),
            keywords: &["furutræ", "japanskt", "kadomatsu"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("bambou décoratif"),
            keywords: &["bambou", "bambou décoratif", "fête", "japonais", "plante"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("composition florale japonaise"),
            keywords: &[
                "bambou",
                "composition florale",
                "composition florale japonaise",
                "célébration",
                "japonais",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("maisiúchán péine"),
            keywords: &["Athbhliain", "Seapánach", "maisiúchán", "péine"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("sgeadas giuthais"),
            keywords: &[
                "bambù",
                "comharrachadh",
                "giuthais",
                "iapanach",
                "seapanach",
                "sgeadas giuthais",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("decoración con bambú"),
            keywords: &["Aninovo", "bambú", "celebración", "decoración con bambú"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પાઇન શણગાર"),
            keywords: &[
                "ઉજવણી",
                "જાપાની",
                "ન\u{ac2}તન વર\u{acd}ષ",
                "પાઇન",
                "પાઇન શણગાર",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("adon bishiyar pine"),
            keywords: &[
                "Na Japan",
                "adon bishiyar pine",
                "bishiyar pine",
                "gora",
                "shagali",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("קישוט אצטרובלים"),
            keywords: &["אצטרובלים", "יפני", "קישוט"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("पाइन सजावट, नववर\u{94d}ष"),
            keywords: &[
                "जापानी",
                "द\u{947}वदार",
                "नववर\u{94d}ष",
                "पाइन सजावट",
                "पाइन सजावट, नववर\u{94d}ष",
                "समारोह",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("ukras od češera"),
            keywords: &["bambus", "bor", "japanski", "slavlje", "ukras od češera"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("fenyődekoráció"),
            keywords: &["bambusz", "fenyő", "fenyődekoráció", "japán", "ünnep"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բամբուկից դեկորացիա"),
            keywords: &[
                "բամբուկ",
                "բամբուկից դեկորացիա",
                "բույս",
                "դեկորացիա",
                "ճապոնական",
                "տոն",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("dekorasi pinus"),
            keywords: &[
                "bambu",
                "dekorasi pinus",
                "jepang",
                "perayaan",
                "pinus",
                "tanaman",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ọchọ mma ukwu osisi"),
            keywords: &[
                "achara",
                "enwemụaṅụrị",
                "ndị Japan",
                "ukwu osisi",
                "ọchọ mma ukwu osisi",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("blómaskreyting með furu"),
            keywords: &[
                "blómaskreyting með furu",
                "fura",
                "hátíð",
                "japanskt",
                "áramót",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("bambù decorato"),
            keywords: &[
                "bambù",
                "bambù decorato",
                "decorazione kadomatsu",
                "giapponese",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("門松"),
            keywords: &["お祝い", "和", "日本", "正月", "竹", "門松"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("dekorasi pinus"),
            keywords: &["Jepang", "bambu", "dekorasi pinus", "perayaan", "pinus"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ფიჭვის დეკორაცია"),
            keywords: &[
                "აღნიშვნა",
                "ბამბუკი",
                "ზეიმი",
                "იაპონური",
                "მცენარე",
                "ფიჭვი",
                "ფიჭვის დეკორაცია",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қарағай декорациясы"),
            keywords: &[
                "бамбук",
                "жапон",
                "тойлау",
                "қарағай",
                "қарағай декорациясы",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("fyrtræsdekoration"),
            keywords: &["fyrtræsdekoration", "japansk nytår"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "ដើមឫស\u{17d2}ស\u{17b8}ប\u{17b8}កង\u{17cb}ដាក\u{17cb}ផ\u{17d2}គ\u{17bb}\u{17c6}គ\u{17d2}នាដើម\u{17d2}ប\u{17b8}ទទ\u{17bd}លទេវតាឆ\u{17d2}នា\u{17c6}ថ\u{17d2}ម\u{17b8}នៅប\u{17d2}រទេសជប\u{17c9}\u{17bb}ន",
            ),
            keywords: &[
                "ដើមរាស\u{17b8}",
                "ដើមឫស\u{17d2}ស\u{17b8}ប\u{17b8}កង\u{17cb}ដាក\u{17cb}ផ\u{17d2}គ\u{17bb}\u{17c6}គ\u{17d2}នាដើម\u{17d2}ប\u{17b8}ទទ\u{17bd}លទេវតាឆ\u{17d2}នា\u{17c6}ថ\u{17d2}ម\u{17b8}នៅប\u{17d2}រទេសជប\u{17c9}\u{17bb}ន",
                "ស\u{17c6}ណាងល\u{17d2}អ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪೈನ\u{ccd} ಅಲಂಕಾರ"),
            keywords: &[
                "ಆಚರಣ\u{cc6}",
                "ಜಪಾನೀಸ\u{ccd}",
                "ಪೈನ\u{ccd}",
                "ಪೈನ\u{ccd} ಅಲಂಕಾರ",
                "ಹೊಸ ವರ\u{ccd}ಷದ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("일본 장식"),
            keywords: &["일본 장식", "장식", "축하"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("द\u{947}वदार सजावट"),
            keywords: &[
                "जपानी",
                "द\u{947}वदार",
                "द\u{947}वदार सजावट",
                "बा\u{902}ब\u{942}\u{942}",
                "स\u{941}वाळो",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("соснаны кооздоо"),
            keywords: &["бамбук", "жапончо", "майрам", "сосна", "соснаны кооздоо"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Dännendekoratioun"),
            keywords: &["Bambus", "Dänn", "Dännendekoratioun", "Feier", "japanesch"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ການຕ\u{ebb}ບແຕ\u{ec8}ງຕ\u{ebb}\u{ec9}ນແປກ"),
            keywords: &[
                "ການຕ\u{ebb}ບແຕ\u{ec8}ງຕ\u{ebb}\u{ec9}ນແປກ",
                "ປ\u{eb5}ໃໝ\u{ec8}",
                "ສະເຫ\u{ebc}\u{eb5}ມສະຫ\u{ebc}ອງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("dekoracija iš pušies"),
            keywords: &[
                "bambukas",
                "dekoracija iš pušies",
                "japonų",
                "pušis",
                "šventė",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("priedes dekorācija"),
            keywords: &[
                "bambuss",
                "japāņu",
                "priede",
                "priedes dekorācija",
                "svētki",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("whakarei rākau paina"),
            keywords: &[
                "Hapanīhi",
                "inanga",
                "paina",
                "whakanuinga",
                "whakarei rākau paina",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("украс од бор"),
            keywords: &["бамбус", "бор", "прослава", "украс од бор", "јапонска"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("അലങ\u{d4d}കരിച\u{d4d}ച പൈൻ മരം"),
            keywords: &[
                "അലങ\u{d4d}കരിച\u{d4d}ച പൈൻ മരം",
                "ആഘോഷം",
                "ജപ\u{d4d}പനീസ\u{d4d} പ\u{d41}ത\u{d41}വർഷം",
                "പൈൻ അലങ\u{d4d}ക\u{d3e}രം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("нарсан чимэглэл"),
            keywords: &["Японы", "баяр тэмдэглэх", "нарс", "нарсан чимэглэл", "хулс"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("पाइनन\u{947} क\u{947}ल\u{947}ली सजावट"),
            keywords: &[
                "उत\u{94d}सव",
                "जपानी",
                "पाइन",
                "पाइन सजावट",
                "पाइनन\u{947} क\u{947}ल\u{947}ली सजावट",
                "बा\u{902}ब\u{942}",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("hiasan pain"),
            keywords: &["Jepun", "buluh", "hiasan pain", "pain", "perayaan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("dekorazzjoni tal-arżnu"),
            keywords: &[
                "arżnu",
                "bambù",
                "dekorazzjoni tal-arżnu",
                "ċelebrazzjoni",
                "Ġappuniż",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အလ\u{103e} ထင\u{103a}းရ\u{103e}\u{1030}းပင\u{103a}"),
            keywords: &[
                "ဂျပန\u{103a}",
                "ပ\u{103d}\u{1032}တော\u{103a}",
                "ဝါး",
                "အပင\u{103a}",
                "အလ\u{103e} ထင\u{103a}းရ\u{103e}\u{1030}းပင\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("furudekorasjon"),
            keywords: &["feiring", "furudekorasjon", "japansk høytid", "nyttår"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("पाइन सजावट"),
            keywords: &["जापानी", "पाइन", "पाइन सजावट", "बा\u{901}स", "समारोह"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("dennenboomversiering"),
            keywords: &["bamboe", "den", "dennenboomversiering", "feest", "japans"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("furudekorasjon"),
            keywords: &["feiring", "furudekorasjon", "japansk høgtid", "nyttår"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପ\u{b3e}ଇନ\u{b4d}\u{200d} ସ\u{b3e}ଜସଜ\u{b4d}ଜ\u{b3e}"),
            keywords: &[
                "ଉତ\u{b4d}ସବ",
                "ଜ\u{b3e}ପ\u{b3e}ନୀ",
                "ପ\u{b3e}ଇନ\u{b4d}\u{200c}",
                "ପ\u{b3e}ଇନ\u{b4d}\u{200d} ସ\u{b3e}ଜସଜ\u{b4d}ଜ\u{b3e}",
                "ବ\u{b3e}ଊ\u{b01}ସ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪਾਈਨ ਸਜਾਵਟ"),
            keywords: &[
                "ਜਸ\u{a3c}ਨ",
                "ਜਾਪਾਨੀ",
                "ਨਵਾ\u{a02} ਸਾਲ",
                "ਪਾਈਨ ਸਜਾਵਟ",
                "ਪਿਨ",
                "ਪਿਨ ਸਜਾਵਟ",
                "ਬ\u{a48}ਮਬ\u{a4b}",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("صنوبر دی آرائش"),
            keywords: &["جاپانی", "صنوبر", "صنوبر دی آرائش", "منانا", "وانس"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Paín Dẹkọréshọn"),
            keywords: &["Bambú", "Japan", "Pain", "Paín Dẹkọréshọn", "Sẹlibréshọn"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("japońska dekoracja kadomatsu"),
            keywords: &["bambus", "japońska dekoracja kadomatsu", "roślina", "sosna"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("پائن سجاې"),
            keywords: &["بانس", "جاپاني", "لمانځنه", "پائن سجاې", "پاين"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("decoração de pinhos"),
            keywords: &[
                "bambu",
                "comemoração",
                "decoração de pinhas",
                "decoração de pinhos",
                "japonês",
                "pinha",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("decoração com bambu"),
            keywords: &[
                "bambu",
                "celebração",
                "decoração com bambu",
                "japonês",
                "planta",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("pino achhachala"),
            keywords: &["Japones", "bambu", "pino", "pino achhachala", "raymi"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("decorațiune japoneză de pin"),
            keywords: &["decor", "decorațiune japoneză de pin", "pin", "sărbătoare"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-338"),
            keywords: &["E10-338"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("украшенный бамбук"),
            keywords: &[
                "Новый год",
                "Рождество",
                "Япония",
                "бамбук",
                "растение",
                "сосна",
                "украшенный бамбук",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umuteguro w’igiti cya pine"),
            keywords: &[
                "Umuyapani",
                "ibirori",
                "pinusi",
                "umugano",
                "umuteguro w’igiti cya pine",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("پائن سينگار"),
            keywords: &["بمبو، جشن، جاپاني، پائن", "پائن سينگار"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("පය\u{dd2}න\u{dca} සැරස\u{dd2}ල\u{dca}ල"),
            keywords: &[
                "උණ\u{dd4} බට",
                "ජපන\u{dca}",
                "පය\u{dd2}න\u{dca}",
                "පය\u{dd2}න\u{dca} සැරස\u{dd2}ල\u{dca}ල",
                "සැමර\u{dd4}ම",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("borovicová dekorácia"),
            keywords: &[
                "bambus",
                "borovicová dekorácia",
                "ihličie",
                "japonské",
                "oslava",
                "rastlina",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("okrasitev bora"),
            keywords: &[
                "bambus",
                "bor",
                "japonsko",
                "okrasitev bora",
                "rastlina",
                "slavje",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("geed qurxin"),
            keywords: &["Japanese", "dabaaldag", "garas", "geed qurxin", "geedka"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("dekorim pishe"),
            keywords: &["bambu", "bimë", "dekorim pishe", "pishë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("декорација боровима"),
            keywords: &["jaпaн", "бaмбус", "бoр", "декорација боровима", "прослава"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["декорација боровима"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("dekoracija borovima"),
            keywords: &["bambus", "bor", "dekoracija borovima", "japan", "proslava"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["dekoracija borovima"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("pinjedekoration"),
            keywords: &["bambu", "japanskt", "nyår", "pinjedekoration"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mapambo ya msonobari"),
            keywords: &[
                "kijapani",
                "kusherehekea",
                "mapambo ya msonobari",
                "mmea",
                "msonobari",
                "mwanzi",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பைன\u{bcd} அலங\u{bcd}க\u{bbe}ரம\u{bcd}"),
            keywords: &[
                "கொண\u{bcd}ட\u{bbe}ட\u{bcd}டம\u{bcd}",
                "ஜப\u{bcd}ப\u{bbe}ன\u{bcd}",
                "புத\u{bcd}த\u{bbe}ண\u{bcd}டு",
                "பைன\u{bcd}",
                "பைன\u{bcd} அலங\u{bcd}க\u{bbe}ரம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ద\u{c47}వద\u{c3e}రు వృక\u{c4d}షం అలంకరణ"),
            keywords: &[
                "జపన\u{c40}స\u{c4d}",
                "ద\u{c47}వద\u{c3e}రు చ\u{c46}ట\u{c4d}టు",
                "ద\u{c47}వద\u{c3e}రు వృక\u{c4d}షం అలంకరణ",
                "నూతన సంవత\u{c4d}సరం",
                "వ\u{c47}డుకలు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ороиши дарахти санавбар"),
            keywords: &[
                "бамбук",
                "дарахти санавбаар",
                "ороиши дарахти санавбар",
                "ҷашн",
                "ҷопонӣ",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ต\u{e49}นสนประด\u{e31}บ"),
            keywords: &["ต\u{e49}นสนประด\u{e31}บ", "ป\u{e35}ใหม\u{e48}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("sosna bezegi"),
            keywords: &["bambuk", "baýramçylyk", "sosna", "sosna bezegi", "ýapon"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ongo matapā-paini"),
            keywords: &["ongo matapā-paini"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("çam süsleme"),
            keywords: &["Japon", "Yeni Yıl", "kutlama", "çam", "çam süsleme"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قارىغاي بېزەك"),
            keywords: &["بامبۇك", "تەبرىكلەش", "قارىغاي", "قارىغاي بېزەك", "ياپونچە"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("прикраси на ялинку"),
            keywords: &[
                "бамбук",
                "прикраси на ялинку",
                "рослина",
                "святкування",
                "сосна",
                "японський",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("پائن سے سجاوٹ"),
            keywords: &["جاپانی", "جشن", "پائن", "پائن سے سجاوٹ", "پودا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("qarag‘ay bezagi"),
            keywords: &[
                "bambuk",
                "bayram",
                "o‘simlik",
                "qarag‘ay",
                "qarag‘ay bezagi",
                "yapon",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("trang trí cây thông"),
            keywords: &[
                "cây thông",
                "cây tre",
                "kiểu nhật bản",
                "lễ kỷ niệm",
                "trang trí cây thông",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("taaralukaayu sapeŋ"),
            keywords: &["Sapone", "bàmbu", "màggal", "pain", "taaralukaayu sapeŋ"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umhombiso wompayini"),
            keywords: &[
                "i-bamboo",
                "ipayini",
                "umbhiyozo",
                "umhombiso wompayini",
                "yaseJapan",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ẹṣọ Ọpẹ oyinbo"),
            keywords: &[
                "ayẹyẹ",
                "eso ọ\u{300}pẹ òyìnbó",
                "igi bambú",
                "japanese",
                "Ẹṣọ Ọpẹ oyinbo",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("松樹裝飾"),
            keywords: &["慶祝", "日本", "松樹", "松樹裝飾", "竹"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("松树装饰"),
            keywords: &["庆祝", "日本", "松树", "松树装饰", "竹"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("门松"),
            keywords: &["庆祝", "日本", "松树", "盆栽", "竹", "门松"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("盆栽"),
            keywords: &["盆栽", "開運竹"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("imihlobiso yesundu"),
            keywords: &[
                "imihlobiso yesundu",
                "isitshalo",
                "japanese",
                "umbungazo",
                "uqalo",
                "usundu",
            ],
        },
    ],
};
#[doc = "🎎"]
pub const JAPANESE_DOLLS: crate::Emoji = crate::Emoji {
    glyph: "🎎",
    codepoint: "1F38E",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "Japanese dolls",
    group: "Activities",
    subgroup: "event",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("japanse poppe"),
            keywords: &["fees", "japannees", "japanse poppe", "pop", "viering"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የጃፓን አሻንጉሊቶች"),
            keywords: &["አሻንጉሊት", "ክብረ በዓል", "የጃፓን", "የጃፓን አሻንጉሊቶች", "ፌስቲቫል"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("دميتان يابانيتان"),
            keywords: &["احتفال", "دميتان يابانيتان", "مهرجان"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("জ\u{9be}প\u{9be}নী প\u{9c1}তল\u{9be}"),
            keywords: &[
                "উদয\u{9be}পন",
                "উৎসৱ",
                "জ\u{9be}প\u{9be}নী",
                "প\u{9c1}তল\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("yapon gəlincikləri"),
            keywords: &[
                "bayram",
                "festival",
                "gəlincik",
                "yapon",
                "yapon gəlincikləri",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("японскія лялькі"),
            keywords: &["лялька", "свята", "фестываль", "японскі", "японскія лялькі"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("японски кукли"),
            keywords: &[
                "Японски кукли",
                "кукла",
                "празник",
                "празнуване",
                "японски",
                "японски кукли",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("জ\u{9be}প\u{9be}নি প\u{9c1}ত\u{9c1}ল"),
            keywords: &[
                "উদয\u{9be}পন",
                "উৎসব",
                "জ\u{9be}প\u{9be}নি",
                "প\u{9c1}ত\u{9c1}ল",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("poupinelloù japanat"),
            keywords: &["fest", "gouel", "lid", "poupinell", "poupinelloù japanat"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("japanske lutke"),
            keywords: &["festival", "japan", "japanske lutke", "proslava"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("nines japoneses"),
            keywords: &["celebració", "festival", "nines", "nines japoneses"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏣᏩᏂᏏ ᏗᏁᏟᏙᏗ"),
            keywords: &["ᎠᎾᎵᎮᎵᏍᏗᏍᎬᎢ", "ᎠᏁᏟᏗ", "ᎠᏍᏆᎵᏍᎬ", "ᏣᏩᏂᏏ", "ᏣᏩᏂᏏ ᏗᏁᏟᏙᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("japonské panenky"),
            keywords: &[
                "festival",
                "japonské panenky",
                "japonský",
                "oslava",
                "panenka",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("doliau Japaneaidd"),
            keywords: &["Japaneaidd", "dathliad", "doli", "doliau Japaneaidd"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("japanske dukker"),
            keywords: &["fejring", "festival", "japansk", "japanske dukker"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("japanische Puppen"),
            keywords: &["Puppenfest Japan", "japanische Puppen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ιαπωνικές κούκλες"),
            keywords: &[
                "γιορτή",
                "ιαπωνικές κούκλες",
                "ιαπωνικό",
                "κούκλα",
                "φεστιβάλ",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("Japanese dolls"),
            keywords: &[
                "Japanese",
                "Japanese dolls",
                "celebration",
                "doll",
                "festival",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("muñecas japonesas"),
            keywords: &[
                "celebración",
                "festival",
                "hinamatsuri",
                "muñecas",
                "muñecas japonesas",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &[
                "Japón",
                "festival",
                "festividad",
                "muñeca",
                "muñecas japonesas",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("Jaapani nukud"),
            keywords: &["Jaapani nukud", "festival", "nukk"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("panpin japoniarrak"),
            keywords: &["ospakizun", "pan", "panpin japoniarrak"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("عروسک\u{200c}های ژاپنی"),
            keywords: &[
                "جشن",
                "جشنواره",
                "عروسک",
                "عروسک\u{200c}های ژاپنی",
                "فستیوال",
                "ژاپنی",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("japanilaiset nuket"),
            keywords: &["Japani", "japanilaiset nuket", "juhlinta", "nukke"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("japanese na manika"),
            keywords: &[
                "festival",
                "japanese",
                "japanese na manika",
                "manika",
                "pagdiriwang",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("japanskar dukkur"),
            keywords: &["dukkur", "japanskar"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("poupées japonaises"),
            keywords: &["poupées", "poupées japonaises"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["festival", "japonais", "japonaises", "poupées"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("babóga Seapánacha"),
            keywords: &["babóga", "babóga Seapánacha", "ceiliúradh", "féile"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("doileagan Seapanach"),
            keywords: &[
                "comharrachadh",
                "doileag",
                "doileagan Seapanach",
                "iapanach",
                "seapanach",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("bonecas xaponesas"),
            keywords: &[
                "bonecas",
                "bonecas xaponesas",
                "celebración",
                "festival xaponés",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("જાપાની ઢી\u{a82}ગલીઓ"),
            keywords: &[
                "ઉત\u{acd}સવ",
                "જાપાની",
                "ઢી\u{a82}ગલી ઉત\u{acd}સવ",
                "ઢી\u{a82}ગલીઓ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("yar tsana Na Japan"),
            keywords: &[
                "Na Japan",
                "biki",
                "shagali",
                "yar tsana",
                "yar tsana Na Japan",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("בובות יפניות"),
            keywords: &["בובות", "בובות יפניות", "חג", "יפני", "פסטיבל"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("जापानी ग\u{941}ड\u{93c}िया"),
            keywords: &["ग\u{941}ड\u{93c}िया", "जापानी", "त\u{94d}योहार", "समारोह"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("japanske lutke"),
            keywords: &["festival", "japanske lutke", "japanski", "lutka", "slavlje"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("japán babák"),
            keywords: &[
                "baba",
                "japán",
                "japán babák",
                "ünnep",
                "ünnepi hangulat",
                "ünneplés",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ճապոնական տիկնիկներ"),
            keywords: &[
                "ճապոնական",
                "ճապոնական տիկնիկներ",
                "տիկնիկ",
                "տոն",
                "փառատոն",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("boneka Jepang"),
            keywords: &["boneka", "boneka Jepang", "festival", "jepang", "perayaan"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("dọlụ ndị Japan"),
            keywords: &[
                "dọlụ",
                "dọlụ ndị Japan",
                "emume",
                "enwemụaṅụrị",
                "ndị Japan",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("japanskar brúður"),
            keywords: &["brúðuhátíð", "hátíð", "japanskar brúður", "japanskt"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("bambole giapponesi"),
            keywords: &["Festa delle bambole", "bambole", "festa", "giapponesi"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ひな祭り"),
            keywords: &[
                "おだいり様",
                "おひな様",
                "お祝い",
                "ひな祭り",
                "人形",
                "和",
                "日本",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("boneka Jepang"),
            keywords: &["Jepang", "boneka", "festival", "perayaan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("იაპონური თოჯინები"),
            keywords: &[
                "აღნიშვნა",
                "ზეიმი",
                "თოჯინა",
                "იაპონური",
                "იაპონური თოჯინები",
                "ფესტივალი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жапон қуыршақтары"),
            keywords: &[
                "жапон",
                "жапон қуыршақтары",
                "тойлау",
                "фестиваль",
                "қуыршақ",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("dukker"),
            keywords: &["dukker", "japanske dukker"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ត\u{17bb}ក\u{17d2}កតាជប\u{17c9}\u{17bb}ន"),
            keywords: &[
                "ត\u{17bb}ក\u{17d2}កតា",
                "ត\u{17bb}ក\u{17d2}កតាជប\u{17c9}\u{17bb}ន",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಜಪಾನೀಸ\u{ccd} ಗೊಂಬ\u{cc6}ಗಳು"),
            keywords: &[
                "ಆಚರಣ\u{cc6}",
                "ಗೊಂಬ\u{cc6}ಗಳ ಉತ\u{ccd}ಸವ",
                "ಜಪಾನೀಸ\u{ccd}",
                "ಜಪಾನೀಸ\u{ccd} ಗೊಂಬ\u{cc6}ಗಳು",
                "ಹಬ\u{ccd}ಬ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("일본 인형"),
            keywords: &["남녀 인형", "인형", "일본 인형"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("जपानी बावल\u{94d}यो"),
            keywords: &[
                "उत\u{94d}सव",
                "जपानी",
                "जपानी बावल\u{94d}यो",
                "बावली",
                "स\u{941}वाळो",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жапон куурчактары"),
            keywords: &["жапон куурчактары", "куурчак", "майрам", "фестиваль"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Japanesch Poppen"),
            keywords: &["Feier", "Festival", "Japanesch Poppen", "Popp", "japanesch"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຕ\u{eb8}ກກະຕາຍ\u{eb5}\u{ec8}ປ\u{eb8}\u{ec8}ນ"),
            keywords: &[
                "ຍ\u{eb5}\u{ec8}ປ\u{eb8}\u{ec8}ນ",
                "ຕ\u{eb8}ກກະຕາ",
                "ຕ\u{eb8}ກກະຕາຍ\u{eb5}\u{ec8}ປ\u{eb8}\u{ec8}ນ",
                "ສະເຫ\u{ebc}\u{eb5}ມສະຫ\u{ebc}ອງ",
                "ເທດສະການ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("japoniškos lėlės"),
            keywords: &["festivalis", "japoniškos lėlės", "japonų", "lėlė", "šventė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("japāņu lelles"),
            keywords: &["japāņu", "japāņu lelles", "lelle", "svētki"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("karetao Hapanīhi"),
            keywords: &["Hapanīhi", "karetao", "taurima", "whakanuinga"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("јапонски кукли"),
            keywords: &["кукла", "прослава", "јапонска", "јапонски кукли"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ജപ\u{d4d}പ\u{d3e}നീസ\u{d4d} പ\u{d3e}വകൾ"),
            keywords: &[
                "ആഘോഷം",
                "ജപ\u{d4d}പ\u{d3e}നീസ\u{d4d}",
                "ജപ\u{d4d}പ\u{d3e}നീസ\u{d4d} പ\u{d3e}വകൾ",
                "ജപ\u{d4d}പ\u{d3e}ൻ പ\u{d3e}വകൾ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("япон хүүхэлдэй"),
            keywords: &["хүүхэлдэй", "япон"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("जपानी बाह\u{941}ल\u{94d}या"),
            keywords: &[
                "उत\u{94d}सव",
                "जपानी",
                "जपानी बाह\u{941}ल\u{94d}या",
                "बाह\u{941}ली",
                "सण",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("anak patung Jepun"),
            keywords: &[
                "anak patung",
                "anak patung Jepun",
                "jepun",
                "perayaan",
                "pesta",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("pupi Ġappuniżi"),
            keywords: &[
                "festival",
                "pupa",
                "pupi Ġappuniżi",
                "ċelebrazzjoni",
                "Ġappuniż",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဂျပန\u{103a} အရ\u{102f}ပ\u{103a}များ"),
            keywords: &[
                "ကျင\u{103a}းပ",
                "ဂျပန\u{103a}",
                "ဂျပန\u{103a} အရ\u{102f}ပ\u{103a}များ",
                "ပ\u{103d}\u{1032}တော\u{103a}",
                "အရ\u{102f}ပ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("japanske dukker"),
            keywords: &["festival", "japansk høytid", "japanske dukker"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("जापानी प\u{941}तली"),
            keywords: &[
                "जापानी",
                "जापानी प\u{941}तलीहर\u{942}",
                "पर\u{94d}व",
                "प\u{941}तली",
                "समारोह",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("Japanse poppen"),
            keywords: &["Japanse poppen", "feest", "festival", "japans", "pop"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("japanske dokker"),
            keywords: &["festival", "japansk høgtid", "japanske dokker"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଜ\u{b3e}ପ\u{b3e}ନୀ କଣ\u{b4d}ଢେଇଗ\u{b41}ଡ\u{b3c}\u{b3f}କ"),
            keywords: &[
                "ଉତ\u{b4d}ସବ",
                "କଣ\u{b4d}ଢେଇ",
                "କଣ\u{b4d}ଢେଇଗ\u{b41}ଡ\u{b3c}\u{b3f}କ",
                "ଜ\u{b3e}ପ\u{b3e}ନୀ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਜਪਾਨੀ ਗ\u{a41}\u{a71}ਡੀਆ\u{a02}"),
            keywords: &[
                "ਗ\u{a41}\u{a71}ਡੀਆ\u{a02}",
                "ਜਪਾਨੀ ਗ\u{a41}\u{a71}ਡੀਆ\u{a02}",
                "ਜਸ\u{a3c}ਨ",
                "ਜਾਪਾਨੀ",
                "ਤਿਉਹਾਰ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("جاپانی گ\u{64f}ڈیاں"),
            keywords: &[
                "تہوار",
                "جاپانی",
                "جاپانی گ\u{64f}ڈیاں",
                "منانا",
                "گ\u{64f}ڈی",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Japán Dọlbebí-dẹm"),
            keywords: &[
                "Dọlbebí",
                "Fẹ\u{301}stíval",
                "Japan",
                "Japán Dọlbebí-dẹm",
                "Sẹlibréshọn",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("japońskie lalki"),
            keywords: &["japońskie lalki", "lalki"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("جاپاني ګوډاګی"),
            keywords: &["جاپاني", "فستيوال", "لمانځنه", "ګوډاګی"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("bonecas japonesas"),
            keywords: &[
                "bonecas",
                "bonecas japanesas",
                "bonecas japonesas",
                "comemoração",
                "festival",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("bonecas japonesas"),
            keywords: &[
                "bonecas",
                "bonecas japonesas",
                "celebração",
                "festival",
                "japonês",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("Japonesa urpukuna"),
            keywords: &["Japonesa urpukuna"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("păpuși japoneze"),
            keywords: &[
                "Japonia",
                "festival",
                "păpuși japoneze",
                "păpușă",
                "sărbătoare",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-339"),
            keywords: &["E10-339"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("японские куклы"),
            keywords: &["две", "кукла", "праздник", "фестиваль", "японские куклы"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ibipupe byo mu buyapani"),
            keywords: &[
                "Ikiyapani",
                "ibipupe byo mu buyapani",
                "ibirori",
                "igikinisho",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("جاپاني گڏيون"),
            keywords: &["جاپاني گڏيون", "جشن، گڏي، فيسٽيول، جاپاني"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ජපන\u{dca} බෝන\u{dd2}ක\u{dca}කන\u{dca}"),
            keywords: &[
                "ජපන\u{dca}",
                "ජපන\u{dca} බෝන\u{dd2}ක\u{dca}කන\u{dca}",
                "බොන\u{dd2}ක\u{dca}ක\u{dcf}",
                "සැණකෙල\u{dd2}ය",
                "සැමර\u{dd4}ම",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("japonské bábiky"),
            keywords: &["bábka", "festival", "japonské bábiky", "japonský", "oslava"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("japonski lutki"),
            keywords: &["festival", "japonski lutki", "japonsko", "lutka", "slavje"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("boombalaha Japanese ka"),
            keywords: &[
                "Japanese",
                "boombalaha Japanese ka",
                "boombalo",
                "dabaaldag",
                "feesto",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kukulla japoneze"),
            keywords: &[
                "festival",
                "festë",
                "japoneze",
                "kukull",
                "kukulla japoneze",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("јапанске лутке"),
            keywords: &["jaпaн", "луткa", "прослава", "фeстивaл", "јапанске лутке"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("japanske lutke"),
            keywords: &["festival", "japan", "japanske lutke", "lutka", "proslava"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("japanska dockor"),
            keywords: &["dockor", "festival", "japanska dockor"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("wanaserere wa kijapani"),
            keywords: &[
                "kijapani",
                "kusherehekea",
                "mwanaserere",
                "sherehe",
                "wanaserere wa kijapani",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஜப\u{bcd}ப\u{bbe}ன\u{bcd} பொம\u{bcd}மைகள\u{bcd}"),
            keywords: &[
                "கொண\u{bcd}ட\u{bbe}ட\u{bcd}டம\u{bcd}",
                "ஜப\u{bcd}ப\u{bbe}னிய பொம\u{bcd}மைகள\u{bcd}",
                "ஜப\u{bcd}ப\u{bbe}ன\u{bcd}",
                "திருவிழ\u{bbe}",
                "பொம\u{bcd}மைகள\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మగ మర\u{c3f}యు ఆడ జపన\u{c40}స\u{c4d} బ\u{c4a}మ\u{c4d}మలు"),
            keywords: &[
                "జపన\u{c40}స\u{c4d}",
                "పండుగ",
                "బ\u{c4a}మ\u{c4d}మల ద\u{c3f}న\u{c4b}త\u{c4d}సవం",
                "బ\u{c4a}మ\u{c4d}మలు",
                "మగ మర\u{c3f}యు ఆడ జపన\u{c40}స\u{c4d} బ\u{c4a}మ\u{c4d}మలు",
                "మగ మర\u{c3f}యు ఆడ బ\u{c4a}మ\u{c4d}మలు",
                "వ\u{c47}డుకలు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("лухтакҳои ҷопонӣ"),
            keywords: &["лухтак", "лухтакҳои ҷопонӣ", "фестивал", "ҷашн", "ҷопонӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ต\u{e38}\u{e4a}กตาญ\u{e35}\u{e48}ป\u{e38}\u{e48}น"),
            keywords: &[
                "ญ\u{e35}\u{e48}ป\u{e38}\u{e48}น",
                "ต\u{e38}\u{e4a}กตา",
                "ต\u{e38}\u{e4a}กตาญ\u{e35}\u{e48}ป\u{e38}\u{e48}น",
                "เฉล\u{e34}มฉลอง",
                "เทศกาล",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýapon gurjaklary"),
            keywords: &[
                "baýramçylyk",
                "gurjak",
                "ýapon",
                "ýapon gurjaklary",
                "şüweleň",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tamapua fakasiapani"),
            keywords: &["tamapua fakasiapani"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("Japon oyuncak bebekleri"),
            keywords: &[
                "Bebek Festivali",
                "Japon",
                "Japon oyuncak bebekleri",
                "festival",
                "kutlama",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ياپونچە قونچاق"),
            keywords: &[
                "ئويۇنچۇق",
                "بايرام",
                "تەبرىكلەش",
                "ياپونچە",
                "ياپونچە قونچاق",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("японські ляльки"),
            keywords: &[
                "лялька",
                "святкування",
                "фестиваль",
                "японський",
                "японські ляльки",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("جاپانی گڑیاں"),
            keywords: &["تہوار", "جاپان", "جاپانی گڑیاں", "جشن", "گڑیا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("yapon qo‘g‘irchoqlari"),
            keywords: &[
                "bayram",
                "festival",
                "qo‘g‘irchoq",
                "yapon",
                "yapon qo‘g‘irchoqlari",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("búp bê Nhật Bản"),
            keywords: &[
                "búp bê",
                "búp bê Nhật Bản",
                "kiểu nhật bản",
                "lễ hội",
                "lễ kỷ niệm",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("pupe sapone"),
            keywords: &["Sapone", "fanaal", "màggal", "pupe", "pupe sapone"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("oonodoli baseJapan"),
            keywords: &[
                "oonodoli baseJapan",
                "umbhiyozo",
                "umsitho",
                "unodoli",
                "waseJapan",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Awọn Ere Japanisi"),
            keywords: &[
                "Awọn Ere Japanisi",
                "Japanese",
                "ayẹyẹ",
                "omolankidi",
                "àjọyọ\u{300}",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("日本娃娃"),
            keywords: &["娃娃", "慶祝", "日本", "日本娃娃", "節日"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("日本娃娃"),
            keywords: &["娃娃", "庆祝", "日本", "日本娃娃", "节日"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("日本人形"),
            keywords: &["人偶", "庆祝", "日本人形", "节日"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("女兒節"),
            keywords: &["女兒節", "日本娃娃"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["女兒節", "日本公仔"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("onodoli bejapanese"),
            keywords: &[
                "japanese",
                "onodoli",
                "onodoli bejapanese",
                "umbungazo",
                "umcimbi",
            ],
        },
    ],
};
#[doc = "🎏"]
pub const CARP_STREAMER: crate::Emoji = crate::Emoji {
    glyph: "🎏",
    codepoint: "1F38F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "carp streamer",
    group: "Activities",
    subgroup: "event",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("karpbanier"),
            keywords: &["banier", "karp", "karpbanier", "viering"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ካርፕ ተወርዋሪ ዓሣዎች"),
            keywords: &["ስትሪመር", "ካርፕ", "ካርፕ ተወርዋሪ ዓሣዎች", "ክብረ በዓል"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("قصاصات ملونة"),
            keywords: &["أوراق ملونة", "احتفال", "قصاصات ملونة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ক\u{9be}ৰ\u{9cd}প ষ\u{9cd}ট\u{9cd}ৰিম\u{9be}ৰ"),
            keywords: &[
                "উদয\u{9be}পন",
                "ক\u{9be}ৰ\u{9cd}প",
                "ষ\u{9cd}ট\u{9cd}ৰিম\u{9be}ৰ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("karp-uçurtma"),
            keywords: &["bayram", "karp", "karp-uçurtma", "uçurtma"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("каінаборы"),
            keywords: &["карп", "каінаборы", "свята"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("коинобори"),
            keywords: &["знаме", "коинобори", "празнуване", "шаран"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ক\u{9be}র\u{9cd}প স\u{9cd}ট\u{9cd}রিম\u{9be}র"),
            keywords: &[
                "আলোকরশ\u{9cd}মি",
                "উদয\u{9be}পন",
                "ক\u{9be}র\u{9cd}প",
                "ক\u{9be}র\u{9cd}প স\u{9cd}ট\u{9cd}রিম\u{9be}র",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("koinobori"),
            keywords: &["fest", "gouel", "karpenn", "koinobori"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("koinobori"),
            keywords: &["koinobori", "proslava", "zabava", "zastavica", "šaran"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("banderins de carpes"),
            keywords: &["banderins", "banderins de carpes", "carpes", "celebració"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏣᏗ ᏗᏟᎶᏍᏔᏅ ᎦᏓᏘ ᎠᏇᏡᏍᏗ"),
            keywords: &["ᎠᎾᎵᎮᎵᏍᏗᏍᎬᎢ", "ᎠᏣᏗ", "ᎠᏣᏗ ᏗᏟᎶᏍᏔᏅ ᎦᏓᏘ ᎠᏇᏡᏍᏗ", "ᏗᏟᎶᏍᏔᏅ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("koinobori"),
            keywords: &[
                "kapr",
                "kapří",
                "koinobori",
                "oslava",
                "ryba",
                "rybí",
                "vlajka",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("baner y carp"),
            keywords: &["baner", "baner y carp", "carp", "dathliad"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("karpevimpel"),
            keywords: &["banner med fisk", "banner med karper", "karpevimpel"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("traditionelle japanische Windsäcke"),
            keywords: &[
                "Feier",
                "Karpfen",
                "Windsäcke",
                "traditionelle japanische Windsäcke",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("διακοσμητικοί κυπρίνοι"),
            keywords: &[
                "γιορτή",
                "διακοσμητικοί κυπρίνοι",
                "διακοσμητικός",
                "κυπρίνος",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("carp streamer"),
            keywords: &["carp", "celebration", "streamer"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &[
                "Japanese wind socks",
                "carp",
                "carp wind sock",
                "celebration",
                "koinobori",
                "streamer",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &[
                "Japanese wind socks",
                "carp",
                "carp wind sock",
                "celebration",
                "koinobori",
                "streamer",
            ],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("banderín de carpas"),
            keywords: &[
                "banderín",
                "banderín de carpas",
                "carpa",
                "celebración",
                "koinobori",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("banderín con forma de carpa"),
            keywords: &[
                "bandera",
                "banderín",
                "banderín con forma de carpa",
                "celebración",
                "festejo",
                "japonés",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("koinobori"),
            keywords: &["koinobori"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("banderín en forma de pescado"),
            keywords: &[
                "banderín",
                "banderín en forma de pescado",
                "carpa",
                "celebración",
                "pescado",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kalakujuline vimpel"),
            keywords: &["kala", "kalakujuline vimpel", "lipp", "vimpel"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("karpa-itxurako banderatxoak"),
            keywords: &[
                "banderatxo",
                "haizea neurtzeko karpa itxurako banderatxoak",
                "karpa",
                "karpa-itxurako banderatxoak",
                "ospakizun",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پرچم\u{200c}های ماهی در باد"),
            keywords: &[
                "بادنمای ماهی\u{200c}شکل",
                "جشن",
                "ماهی",
                "پرچم",
                "پرچم\u{200c}های ماهی در باد",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("karppiviiri"),
            keywords: &["juhla", "karppi", "karppiviiri", "koinobori", "viiri"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("carp streamer"),
            keywords: &["carp", "japanese", "pagdiriwang", "streamer"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("Koinobori"),
            keywords: &["Koinobori", "japanskt"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("koinobori"),
            keywords: &["carpe", "fête", "koinobori"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("sraoilleán éisc"),
            keywords: &["maisiúchán", "sraoilleán", "sraoilleán éisc"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("bratach carbhain"),
            keywords: &[
                "bratach",
                "bratach carbhain",
                "carbhan",
                "comharrachadh",
                "cèilidh",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("bandeirolas con forma de carpa"),
            keywords: &[
                "bandeirolas",
                "bandeirolas con forma de carpa",
                "carpas",
                "festa",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("કાર\u{acd}પ સ\u{acd}ટ\u{acd}રીમર"),
            keywords: &[
                "ઉજવણી",
                "કાર\u{acd}પ સ\u{acd}ટ\u{acd}રીમર",
                "સ\u{acd}ટ\u{acd}રીમર",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("tutar safa"),
            keywords: &["safa", "shagali", "tuta", "tutar safa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("דגלים בצורת דגי קוי"),
            keywords: &["דגל", "דגלים בצורת דגי קוי", "חג", "חגיגה", "יפני", "קוי"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("कार\u{94d}प स\u{94d}ट\u{94d}रीमर"),
            keywords: &[
                "कार\u{94d}प स\u{94d}ट\u{94d}रीमर",
                "समारोह",
                "स\u{94d}ट\u{94d}रीमर",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("cjevasti zmaj u obliku ribe"),
            keywords: &["cjevasti zmaj u obliku ribe", "riba", "slavlje", "zmaj"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("rizspapír pontyok"),
            keywords: &[
                "ponty",
                "rizspapír",
                "rizspapír pontyok",
                "ünnep",
                "ünnepi hangulat",
                "ünneplés",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կարպերի տեսքով նավադրոշ"),
            keywords: &["կարպ", "կարպերի տեսքով նավադրոշ", "նավադրոշ", "տոն"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("bendera ikan koi"),
            keywords: &["bendera ikan koi", "koi", "panji", "perayaan"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ọkọlọtọ azụ iyi"),
            keywords: &["azụ iyi", "enwemụaṅụrị", "ọkọlọtọ", "ọkọlọtọ azụ iyi"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("fiskveifur"),
            keywords: &["fiskveifur", "hátíð", "veifur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("aquilone a forma di carpa"),
            keywords: &["aquilone", "aquilone a forma di carpa", "carpa", "festa"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("こいのぼり"),
            keywords: &["お祝い", "こいのぼり", "子供の日"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("gendera koinobori"),
            keywords: &["gendera", "koinobori", "perayaan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("კობრებიანი ალამი"),
            keywords: &["ალამი", "აღნიშვნა", "ზეიმი", "თევზი", "კობრებიანი ალამი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("тұқы таспа"),
            keywords: &["таспа", "тойлау", "тұқы"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("banner"),
            keywords: &["banner", "banner med fisk", "banner med karper"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("រ\u{17c6}យោលរ\u{17bc}បត\u{17d2}រ\u{17b8}សម\u{17d2}រាប\u{17cb}ត\u{17bb}បតែង"),
            keywords: &[
                "ត\u{17bb}បតែង",
                "រ\u{17c6}យោល",
                "រ\u{17c6}យោលរ\u{17bc}បត\u{17d2}រ\u{17b8}សម\u{17d2}រាប\u{17cb}ត\u{17bb}បតែង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕಾರ\u{ccd}ಪ\u{ccd} ಪತಾಕ\u{cc6}"),
            keywords: &[
                "ಆಚರಣ\u{cc6}",
                "ಕಾರ\u{ccd}ಪ\u{ccd} ಪತಾಕ\u{cc6}",
                "ಪತಾಕ\u{cc6}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("물고기 깃발"),
            keywords: &["물고기 깃발", "물고기 모양 깃발", "물고기 장식"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("कार\u{94d}प स\u{94d}ट\u{94d}रिम\u{947}र"),
            keywords: &["कार\u{94d}प", "स\u{941}वाळो", "स\u{94d}ट\u{94d}रिम\u{947}र"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("карп лентасы"),
            keywords: &["карп", "карп лентасы", "лента", "майрам"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Koi-Kaarpe-Fändelen"),
            keywords: &["Feier", "Fändel", "Kaarp", "Koi-Kaarpe-Fändelen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ທ\u{eb8}ງປາຄາບ"),
            keywords: &[
                "ທ\u{eb8}ງ",
                "ທ\u{eb8}ງປາຄາບ",
                "ປາຄາບ",
                "ສະເຫ\u{ebc}\u{eb5}ມສະຫ\u{ebc}ອງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("karpio vėtrungė"),
            keywords: &["karpio vėtrungė", "karpis", "vėtrungė", "šventė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("zivju veida karodziņi"),
            keywords: &["karpa", "svētki", "zivju veida karodziņi", "zivs"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("haki ika"),
            keywords: &["haki", "ika", "whakanuinga"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("летало со крапови"),
            keywords: &["дрво", "летало со крапови", "прослава", "јапонска"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ക\u{d3e}ർപ\u{d4d}പ\u{d4d} സ\u{d4d}ട\u{d4d}രീമർ"),
            keywords: &[
                "ആഘോഷം",
                "ക\u{d3e}ർപ\u{d4d}പ\u{d4d} സ\u{d4d}ട\u{d4d}രീമർ",
                "സ\u{d4d}ട\u{d4d}രീമർ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("мөрөг загасан дарцаг"),
            keywords: &["баяр", "дарцаг", "мөрөг загас", "мөрөг загасан дарцаг"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("कार\u{94d}प स\u{94d}ट\u{94d}रीमर"),
            keywords: &["उत\u{94d}सव", "कार\u{94d}प", "स\u{94d}ट\u{94d}रीमर"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("panji-panji kap"),
            keywords: &["kap", "panji-panji", "perayaan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("streamer ta’ karpjun"),
            keywords: &[
                "karpjun",
                "streamer",
                "streamer ta’ karpjun",
                "ċelebrazzjoni",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ငါးကြင\u{103a}း တ\u{1036}ခ\u{103d}န\u{103a}"),
            keywords: &[
                "ငါးကြင\u{103a}း",
                "တ\u{1036}ခ\u{103d}န\u{103a}",
                "ပ\u{103d}\u{1032}တော\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("koinobori"),
            keywords: &[
                "feiring",
                "japansk høytid",
                "karpe",
                "koinobori",
                "papirfisk",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("कार\u{94d}प प\u{94d}रकाशको किरण"),
            keywords: &[
                "कार\u{94d}प",
                "कार\u{94d}प प\u{94d}रकाशको किरण",
                "समारोह",
                "स\u{94d}ट\u{94d}रिमर",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("karperslinger"),
            keywords: &["feest", "karper", "karperslinger", "slinger"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("koinobori"),
            keywords: &[
                "feiring",
                "japansk høgtid",
                "karpe",
                "koinobori",
                "papirfisk",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କ\u{b3e}ର\u{b4d}ପ\u{b4d} ଷ\u{b4d}ଟ\u{b4d}ର\u{b3f}ମର\u{b4d}\u{200d}"),
            keywords: &[
                "ଉତ\u{b4d}ସବ",
                "କ\u{b3e}ର\u{b4d}ପ\u{b4d}",
                "ଷ\u{b4d}ଟ\u{b4d}ର\u{b3f}ମର\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕਾਰਪ ਸਟ\u{a4d}ਰੀਮਰ"),
            keywords: &[
                "ਕਾਰਪ ਝ\u{a70}ਡੀ",
                "ਕਾਰਪ ਸਟ\u{a4d}ਰੀਮਰ",
                "ਜਸ\u{a3c}ਨ",
                "ਝ\u{a70}ਡੀ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("بہندی ہوئی میٹھے پانی دی مچھی"),
            keywords: &[
                "بھاپ دین آلا",
                "بہندی ہوئی میٹھے پانی دی مچھی",
                "عیب جوئی",
                "منانا",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Kárp Físh Stríma"),
            keywords: &["Kárp Fish", "Kárp Físh Stríma", "Stríma", "Sẹlibréshọn"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("flaga w kształcie karpia"),
            keywords: &["flaga", "flaga w kształcie karpia", "ryby"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("کارپ سټریمر"),
            keywords: &["سټريمر", "لمانځنه", "کارپ", "کارپ سټریمر"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("bandeira de carpas"),
            keywords: &[
                "bandeira de carpas",
                "comemoração",
                "koinobori",
                "subida de carpas",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("bandeirola de carpas"),
            keywords: &["bandeirola", "bandeirola de carpas", "carpas", "celebração"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("carpas wiphala"),
            keywords: &["carpa", "carpas wiphala", "raymi", "wiphala"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("crap decorativ în vânt"),
            keywords: &["crap", "crap decorativ în vânt", "sărbătoare", "vânt"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-340"),
            keywords: &["E10-340"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("вымпелы в виде карпов"),
            keywords: &[
                "вымпелы",
                "вымпелы в виде карпов",
                "карпы",
                "палочка",
                "рыбки",
                "рыбы",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("igitambaro ndanga"),
            keywords: &["agatako", "ibirori", "igitambaro ndanga", "ubwoko bw’ifi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪارپ اسٽيمر"),
            keywords: &["ڪارپ اسٽيمر", "ڪارپ، جشن، اسٽيمر"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ක\u{dcf}ප\u{dca} ස\u{dca}ට\u{dca}\u{200d}ර\u{dd3}මර\u{dca}"),
            keywords: &[
                "ක\u{dcf}ප\u{dca}",
                "ස\u{dca}ට\u{dca}\u{200d}ර\u{dd3}මර\u{dca}",
                "සැමර\u{dd4}ම",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("koinobori"),
            keywords: &["kapor", "koinobori", "oslava", "vlajka"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("zastavni trak z ribama"),
            keywords: &["barvno", "riba", "slavje", "trak", "zastavni trak z ribama"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("socodka xargaha"),
            keywords: &["dabaaldag", "socodka", "socodka xargaha", "xargo"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("koinobori"),
            keywords: &["festim", "flamur", "koinobori", "krap"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("ветроказ у облику шарана"),
            keywords: &["ветроказ у облику шарана", "прослава", "рибa"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("вјетроказ у облику шарана"),
            keywords: &["вјетроказ у облику шарана"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("vetrokaz u obliku šarana"),
            keywords: &["proslava", "riba", "vetrokaz u obliku šarana"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("vjetrokaz u obliku šarana"),
            keywords: &["vjetrokaz u obliku šarana"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("karpvindstrut"),
            keywords: &["fest", "japan", "karp", "karpvindstrut", "vindstrut"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("bendera ya kambare mamba"),
            keywords: &[
                "bendera",
                "bendera ya kambare mamba",
                "kambare",
                "kusherehekea",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கெண\u{bcd}டை ம\u{bc0}ன\u{bcd} பறக\u{bcd}கும\u{bcd} கொடி"),
            keywords: &[
                "கெண\u{bcd}டை ம\u{bc0}ன\u{bcd}",
                "கெண\u{bcd}டை ம\u{bc0}ன\u{bcd} பறக\u{bcd}கும\u{bcd} கொடி",
                "கொண\u{bcd}ட\u{bbe}ட\u{bcd}டம\u{bcd}",
                "ஜப\u{bcd}ப\u{bbe}ன\u{bcd} ந\u{bbe}ட\u{bcd}டின\u{bcd} குழந\u{bcd}தைகள\u{bcd} தினம\u{bcd}",
                "விடுமுறை",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("క\u{c3e}ర\u{c4d}ప\u{c4d} స\u{c4d}ట\u{c4d}ర\u{c40}మర\u{c4d}"),
            keywords: &[
                "క\u{c3e}య\u{c3f}న\u{c4b}బ\u{c4b}ర\u{c40}",
                "క\u{c3e}ర\u{c4d}ప\u{c4d} స\u{c4d}ట\u{c4d}ర\u{c40}మర\u{c4d}",
                "గ\u{c3e}ల\u{c4d}ల\u{c4b} గుండు చ\u{c47}ప ఆక\u{c3e}ర\u{c3e}ల\u{c4d}ల\u{c4b} స\u{c3e}క\u{c4d}సులు ఎగర\u{c47}యడం",
                "వ\u{c47}డుకలు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("летнаи ҳиллиросзанандаи ба шакли зағорамоҳӣ"),
            keywords: &[
                "зағорамоҳӣ",
                "лентаи борик",
                "летнаи ҳиллиросзанандаи ба шакли зағорамоҳӣ",
                "ҷашн",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ธงปลาคาร\u{e4c}พ"),
            keywords: &[
                "ธง",
                "ธงปลาคาร\u{e4c}พ",
                "ปลาคาร\u{e4c}พ",
                "เฉล\u{e34}มฉลอง",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("balyk lenta"),
            keywords: &["balyk", "baýramçylyk", "lenta"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ika fakamanumanu"),
            keywords: &["ika fakamanumanu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("sazan şekilli flama"),
            keywords: &["flama", "kutlama", "sazan şekilli flama"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("بېلىق لەپ-لەپ"),
            keywords: &["بېلىق لەپ-لەپ", "تەبرىكلەش", "قاسقان", "لەپ-لەپ"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("вітровказ у формі коропів"),
            keywords: &[
                "вітровказ у формі коропів",
                "карп",
                "святкування",
                "транспарант",
                "транспарант із карпами",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ہوائی جرابیں"),
            keywords: &["جاپان", "جشن", "ہوا", "ہوائی جرابیں"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("zog‘orabaliq shaklidagi vimpel"),
            keywords: &[
                "nishonlash",
                "vimpel",
                "zog‘orabaliq",
                "zog‘orabaliq shaklidagi vimpel",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("cờ cá chép"),
            keywords: &["cá chép", "cờ cá chép", "cờ dải", "lễ kỷ niệm"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("bàndarolu waas"),
            keywords: &["bàndarol", "bàndarolu waas", "màggal", "waas"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-carp streamer"),
            keywords: &["i-carp", "i-carp streamer", "i-streamer", "umbhiyozo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Olugekere Capu"),
            keywords: &["Olugekere Capu", "ayẹyẹ", "káàpù", "ìbọsẹ\u{300} tí ń fò"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("鯉魚旗"),
            keywords: &["慶祝", "旗", "鯉魚", "鯉魚旗"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("鲤鱼旗"),
            keywords: &["庆祝", "旗", "鲤鱼", "鲤鱼旗"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("鲤鱼旗"),
            keywords: &["庆祝", "日本", "男孩节", "长旗", "鲤鱼旗"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("鯉魚旗"),
            keywords: &["鯉魚旗"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("i-carp streamer"),
            keywords: &["carp", "i-carp streamer", "istreamer", "umbungazo"],
        },
    ],
};
#[doc = "🎐"]
pub const WIND_CHIME: crate::Emoji = crate::Emoji {
    glyph: "🎐",
    codepoint: "1F390",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "wind chime",
    group: "Activities",
    subgroup: "event",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("windklokkie"),
            keywords: &["klok", "viering", "wind", "windklokkie"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የነፋስ ቺም"),
            keywords: &["ቺም", "ነፋስ", "ክብረ በዓል", "የነፋስ ቺም", "ደወል"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("جرس الريح"),
            keywords: &["جرس", "جرس الريح"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("স\u{9c1}ৰধ\u{9cd}বনি ঘণ\u{9cd}ট\u{9be}"),
            keywords: &[
                "উদয\u{9be}পন",
                "ঘণ\u{9cd}ট\u{9be}",
                "বত\u{9be}হ",
                "স\u{9c1}ৰধ\u{9cd}বনি ঘণ\u{9cd}ট\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("külək zəngi"),
            keywords: &["bayram", "külək", "külək zəngi", "zəng", "zəng səsi"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("музычная падвеска"),
            keywords: &["вецер", "званок", "музычная падвеска", "свята"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("вятърни камбанки"),
            keywords: &[
                "Вятърни камбанки",
                "вятър",
                "вятърни камбанки",
                "звънец",
                "камбанки",
                "празнуване",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("উইন\u{9cd}ড চ\u{9be}ইম"),
            keywords: &[
                "উইন\u{9cd}ড চ\u{9be}ইম",
                "উদয\u{9be}পন",
                "ঘণ\u{9cd}ট\u{9be}",
                "হ\u{9be}ওয\u{9bc}\u{9be}",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("karilhon-avel"),
            keywords: &["fest", "gouel", "karilhon-avel", "klocʼh", "lid", "son"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("vjetreno zvono"),
            keywords: &["proslava", "vjetar", "vjetreno zvono", "zvono"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("campaneta de vent"),
            keywords: &["campaneta", "campaneta de vent", "celebració", "vent"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᏃᎸᏍᎬ ᏧᏃᏟᏍᏗ"),
            keywords: &["ᎠᎾᎵᎮᎵᏍᏗᏍᎬᎢ", "ᎤᎭᎸᏩᏂ", "ᎤᏃᎴ", "ᎤᏃᏴᎩ", "ᎦᏃᎸᏍᎬ ᏧᏃᏟᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("větrný zvonek"),
            keywords: &[
                "furin",
                "japonský",
                "oslava",
                "vítr",
                "větrný zvonek",
                "zvon",
                "zvoneček",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("clychsain wynt"),
            keywords: &["cloch", "clychsain", "clychsain wynt", "dathliad", "gwynt"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("vindspil"),
            keywords: &["vindpiber", "vindspil"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("japanisches Windspiel"),
            keywords: &["Feier", "Glocke", "Wind", "japanisches Windspiel"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μελωδός"),
            keywords: &["άνεμος", "γιορτή", "κουδούνι", "μελωδός"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("wind chime"),
            keywords: &["bell", "celebration", "chime", "wind"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("campanilla de viento"),
            keywords: &["campanilla", "campanilla de viento", "furin", "viento"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["campanilla", "campanilla de viento", "viento"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["campanilla", "campanilla de viento", "fuurin", "viento"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("tuulekell"),
            keywords: &["kell", "tuul", "tuulekell"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("haize-kanpaia"),
            keywords: &["haize", "haize-kanpaia", "kanpai", "ospakizun"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("باد س\u{650}نج"),
            keywords: &["باد", "باد س\u{650}نج", "بادزنگ", "توپ", "جشن", "جشنواره"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("tuulikello"),
            keywords: &["juhla", "kello", "tuuli", "tuulikello"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("wind chime"),
            keywords: &["bell", "chime", "hangin", "wind chime"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("vindharpa"),
            keywords: &["vindharpa"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("carillon éolien"),
            keywords: &["carillon", "carillon éolien", "clochette", "fête", "vent"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("carillon à vent"),
            keywords: &["carillon", "carillon à vent", "clochette", "fête", "vent"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("clingíní gaoithe"),
            keywords: &["ceiliúradh", "clingíní", "clingíní gaoithe"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("clagan-gaoithe"),
            keywords: &["clag", "clagan", "clagan-gaoithe", "comharrachadh", "gaoth"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("campaíña de vento"),
            keywords: &["campaíña", "campaíña de vento", "vento"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("વિ\u{a82}ડ ચાઇમ"),
            keywords: &["ચાઇમ", "વિ\u{a82}ડ ચાઇમ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("ƙararrawar ƙarfe ta iska"),
            keywords: &[
                "iska",
                "shagali",
                "ƙararrawa",
                "ƙararrawar ƙarfe",
                "ƙararrawar ƙarfe ta iska",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פעמון רוח"),
            keywords: &["חג", "חגיגה", "יפני", "פעמון", "רוח"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("वि\u{902}ड चाइम, घ\u{902}टी"),
            keywords: &[
                "घ\u{902}टी",
                "वि\u{902}ड चाइम",
                "वि\u{902}ड चाइम, घ\u{902}टी",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("vjetreno zvono"),
            keywords: &["slavlje", "vjetar", "vjetreno zvono", "zvonjenje", "zvono"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("szélharang"),
            keywords: &[
                "harang",
                "szélharang",
                "ünnep",
                "ünnepi hangulat",
                "ünneplés",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("քամու զանգակ"),
            keywords: &["զանգ", "տոն", "քամի", "քամու զանգակ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("lonceng angin"),
            keywords: &["angin", "gemerincing", "lonceng", "perayaan"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ìkùkù ndakọrịta ụda"),
            keywords: &[
                "enwemụaṅụrị",
                "mgbịrịgba",
                "ndakọrịta ụda",
                "ìkùkù",
                "ìkùkù ndakọrịta ụda",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("órói"),
            keywords: &["vindharpa", "órói"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("campana al vento"),
            keywords: &["campana", "campana al vento", "festa", "vento"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("風鈴"),
            keywords: &["夏", "鈴", "風", "風鈴"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("klinthingan angin"),
            keywords: &["angin", "klinthingan", "lonceng", "perayaan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ჩინური ზანზალაკი"),
            keywords: &[
                "აღნიშვნა",
                "ზანზილაკი",
                "ზეიმი",
                "კობრი",
                "ქარი",
                "ჩინური ზანზალაკი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қытай қоңырау"),
            keywords: &["жел", "тойлау", "қоңырау", "қытай қоңырау"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("vindspil"),
            keywords: &["vindpiber", "vindspil"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("កណ\u{17d2}ត\u{17b9}ងខ\u{17d2}យល\u{17cb}"),
            keywords: &[
                "កណ\u{17d2}ដ\u{17b9}ង",
                "កណ\u{17d2}ត\u{17b9}ងខ\u{17d2}យល\u{17cb}",
                "ការប\u{17d2}រារព\u{17d2}ធព\u{17b7}ធ\u{17b8}",
                "ខ\u{17d2}យល\u{17cb}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ವ\u{cbf}ಂಡ\u{ccd} ಸಾಲುಗಂಟ\u{cc6}"),
            keywords: &["ಘಂಟಾಮೇಳ", "ವ\u{cbf}ಂಡ\u{ccd} ಸಾಲುಗಂಟ\u{cc6}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("풍경"),
            keywords: &["종", "풍경"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("वि\u{902}ड चायम"),
            keywords: &["घा\u{902}ट", "चायम", "वि\u{902}ड", "स\u{941}वाळो"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кытай жылаажындары"),
            keywords: &[
                "коңгуроо",
                "кытай жылаажындары",
                "майрам",
                "шамал",
                "шамал коңгуроосу",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Wandspill"),
            keywords: &["Feier", "Klack", "Klackespill", "Wand", "Wandspill"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລ\u{ebb}ມພ\u{eb1}ດລະຄ\u{eb1}ງ"),
            keywords: &[
                "ກະດ\u{eb4}\u{ec8}ງ",
                "ລະຄ\u{eb1}ງ",
                "ລ\u{ebb}ມ",
                "ລ\u{ebb}ມພ\u{eb1}ດລະຄ\u{eb1}ງ",
                "ສະເຫ\u{ebc}\u{eb5}ມສະຫ\u{ebc}ອງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("vėjo varpeliai"),
            keywords: &["skambėti", "varpelis", "vėjas", "vėjo varpeliai", "šventė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("vēja zvans"),
            keywords: &["svētki", "vēja zvans", "vējš", "zvans"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pere hau"),
            keywords: &["hau", "pere", "whakanuinga"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("ветерно ѕвонче"),
            keywords: &["ветер", "ветерно ѕвонче", "прослава", "ѕвонче", "јапонска"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ക\u{d3e}റ\u{d4d}റ\u{d41}മണി"),
            keywords: &["ക\u{d3e}റ\u{d4d}റ\u{d41}മണി", "മണി"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("салхин хонх"),
            keywords: &["баяр ёслол", "салхи", "салхин хонх", "хонх"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("वि\u{902}ड चाइम"),
            keywords: &[
                "उत\u{94d}सव",
                "चाइम",
                "ब\u{947}ल",
                "वारा",
                "वि\u{902}ड चाइम",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("peranggu loceng angin"),
            keywords: &["angin", "loceng", "peranggu", "perayaan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("qniepen tar-riħ"),
            keywords: &["qanpiena", "qniepen tar-riħ", "riħ", "ċelebrazzjoni"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("သ\u{1036}စ\u{102f}\u{1036}ခေါင\u{103a}းလောင\u{103a}း"),
            keywords: &[
                "ခေါင\u{103a}းလောင\u{103a}း",
                "ပ\u{103d}\u{1032}တော\u{103a}",
                "လေ",
                "သ\u{1036}စ\u{102f}\u{1036}ခေါင\u{103a}းလောင\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("vindspill"),
            keywords: &["bjelle", "drømmefanger", "feiring", "vind", "vindspill"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("विन\u{94d}ड चाइम"),
            keywords: &["घण\u{94d}टी", "चाइम", "विन\u{94d}ड", "समारोह"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("windorgel"),
            keywords: &["bel", "feest", "klokkenspel", "wind", "windorgel"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("vindspel"),
            keywords: &["bjølle", "draumefangar", "feiring", "vind", "vindspel"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପବନ ଘଣ\u{b4d}ଟ\u{b3f}"),
            keywords: &[
                "ଉତ\u{b4d}ସବ",
                "ଝଙ\u{b4d}କ\u{b3e}ର",
                "ପବନ ଘଣ\u{b4d}ଟ\u{b3f}",
                "ପବନ ଝଙ\u{b4d}କ\u{b3e}ର",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਵਿ\u{a70}ਡ ਚਾਈਮ, ਘ\u{a70}ਟੀ"),
            keywords: &[
                "ਘ\u{a70}ਟੀ",
                "ਚਾਈਮ",
                "ਜਸ\u{a3c}ਨ",
                "ਵਿ\u{a70}ਡ ਚਾਈਮ, ਘ\u{a70}ਟੀ",
                "ਹਵਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ہوا دی جھنکار"),
            keywords: &["منانا", "چھیم", "گھنٹی", "ہوا", "ہوا دی جھنکار"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Wínd Chaim"),
            keywords: &["Bẹl", "Chaim", "Sẹlibréshọn", "Wind", "Wínd Chaim"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("dzwonek wietrzny"),
            keywords: &["dzwonek", "dzwonki", "wietrzny"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د باد زنګ"),
            keywords: &["باد", "د باد زنګ", "زنګ", "لمانځنه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("carrilhão de vento"),
            keywords: &["carrilhão de vento", "sino", "som", "vento"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("espanta-espíritos"),
            keywords: &["celebração", "espanta-espíritos", "sino", "vento"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("chhullupi wayrapaq"),
            keywords: &[
                "chhullupi wayrapaq",
                "chhulluqi",
                "chuullu",
                "raymi",
                "wayra",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("clopoței de vânt"),
            keywords: &["clopoței de vânt", "clopoțel", "vânt"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-341"),
            keywords: &["E10-341"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("музыка ветра"),
            keywords: &["бубенчик", "ветер", "звон", "музыка ветра"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("inzogera muyaga"),
            keywords: &["iibirori", "inzogera muyaga", "ukwezi", "umuhango"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("هوا جي گهنٽي"),
            keywords: &["هوا جي گهنٽي", "گهنٽي، جشن، چائيم، هوا"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ද\u{dd4}ම\u{dca} නලය"),
            keywords: &[
                "ඝ\u{dcf}ණ\u{dca}ට\u{dcf}ව",
                "ද\u{dd4}ම\u{dca} නලය",
                "න\u{dcf}දය",
                "සැමර\u{dd4}ම",
                "ස\u{dd4}ළඟ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("veterná zvonkohra"),
            keywords: &[
                "oslava",
                "veterná zvonkohra",
                "vietor",
                "zvonec",
                "zvonkohra",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("vetrni zvončki"),
            keywords: &["slavje", "veter", "vetrni zvončki", "zvonec", "zvonček"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("dabeesha musqusha"),
            keywords: &[
                "dabaaldag",
                "dabeel",
                "dabeesha musqusha",
                "gambaleel",
                "musqul",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("zile ere"),
            keywords: &["erë", "festim", "festë", "zile", "zile ere"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("еолска звона"),
            keywords: &["вeтaр", "еолска звона", "звoнo", "звoњeњe", "прослава"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["еолска звона"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("eolska zvona"),
            keywords: &["eolska zvona", "proslava", "vetar", "zvonjenje", "zvono"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["eolska zvona"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("vindspel"),
            keywords: &["fest", "japan", "vindspel"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kengele ya upepo"),
            keywords: &[
                "kengele",
                "kengele ya upepo",
                "kulia",
                "kusherehekea",
                "upepo",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("க\u{bbe}ற\u{bcd}றில\u{bcd} பறக\u{bcd}கும\u{bcd} மணி"),
            keywords: &[
                "ஓசை",
                "க\u{bbe}ற\u{bcd}றில\u{bcd} பறக\u{bcd}கும\u{bcd} மணி",
                "மணியோசை",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("గ\u{c3e}ల\u{c3f}క\u{c3f} మ\u{c4d}ర\u{c4b}గ\u{c47} గంటలు"),
            keywords: &[
                "గంటలు",
                "గ\u{c3e}ల\u{c3f}క\u{c3f} మ\u{c4d}ర\u{c4b}గ\u{c47} గంటలు",
                "వ\u{c3f}ండ\u{c4d} చ\u{c40}మ\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("мусиқии шамол"),
            keywords: &["зангула", "мусиқии шамол", "мусиқӣ", "шамол", "ҷашн"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("โมบายล\u{e4c}กระด\u{e34}\u{e48}ง"),
            keywords: &["โมบายล\u{e4c}", "โมบายล\u{e4c}กระด\u{e34}\u{e48}ง"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("hytaý jaňjagazy"),
            keywords: &["baýramçylyk", "hytaý jaňjagazy", "jaň", "jaňjagaz", "ýel"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fafangu-matangi"),
            keywords: &["fafangu-matangi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("rüzgar çanı"),
            keywords: &["rüzgar çanı", "çan"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("شامال كاناي"),
            keywords: &["تەبرىكلەش", "شامال", "قوڭغۇراق", "كاناي"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("китайські дзвіночки"),
            keywords: &[
                "вітер",
                "дзвоник",
                "дзвіночки",
                "китайські дзвіночки",
                "святкування",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ہوائی جھنکار"),
            keywords: &["جھنکار", "گھنٹی", "ہوا", "ہوائی جھنکار"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("shamol qo‘ng‘irog‘i"),
            keywords: &["bayram", "qo‘ng‘iroqcha", "shamol", "shamol qo‘ng‘irog‘i"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("chuông gió"),
            keywords: &["chuông", "gió", "kêu vang", "lễ kỷ niệm"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("gittaxu keseŋ-keseŋ"),
            keywords: &[
                "gittaxu keseŋ-keseŋ",
                "joolooli",
                "keseŋ-keseŋ",
                "màggal",
                "ngelaw",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iintsimbi zomoya"),
            keywords: &["iintsimbi zomoya", "intsimbi", "umbhiyozo", "umoya"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Idun Iji"),
            keywords: &["Idun Iji", "agogo", "atẹ\u{301}gùn", "ayẹyẹ", "ìdún agogo"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("風鈴"),
            keywords: &["慶祝", "鈴", "鐘", "風", "風鈴"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("风铃"),
            keywords: &["庆祝", "钟", "铃", "风", "风铃"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("风铃"),
            keywords: &["庆祝", "铃铛", "风铃"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("風鈴"),
            keywords: &["風鈴"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ichime yomoya"),
            keywords: &["ichime", "ichime yomoya", "insimbi", "umbungazo", "umoya"],
        },
    ],
};
#[doc = "🎑"]
pub const MOON_VIEWING_CEREMONY: crate::Emoji = crate::Emoji {
    glyph: "🎑",
    codepoint: "1F391",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "moon viewing ceremony",
    group: "Activities",
    subgroup: "event",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("maankykseremonie"),
            keywords: &["maan", "maankykseremonie", "seremonie", "viering"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የጨረቃ በዓል"),
            keywords: &["ክብረ በዓል", "የበዓል ሥነ ሥርዓት", "የጨረቃ በዓል", "ጨረቃ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("احتفال برؤية القمر"),
            keywords: &["احتفال برؤية القمر", "استطلاع", "استطلاع القمر"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("চন\u{9cd}দ\u{9cd}ৰ দৰ\u{9cd}শন উৎসৱ"),
            keywords: &[
                "অন\u{9c1}ষ\u{9cd}ঠ\u{9be}ন",
                "উদয\u{9be}পন",
                "চন\u{9cd}দ\u{9cd}ৰ",
                "চন\u{9cd}দ\u{9cd}ৰ দৰ\u{9cd}শন উৎসৱ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("ay mərasimi"),
            keywords: &["ay", "ay mərasimi", "bayram", "mərasim"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("цукімі"),
            keywords: &["любаванне месяцам", "месяц", "свята", "цукімі", "цырымонія"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("церемония цукими"),
            keywords: &[
                "Церемония цукими",
                "луна",
                "празнуване",
                "церемония",
                "церемония цукими",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("চ\u{9be}\u{981}দ দেখ\u{9be}র উৎসব"),
            keywords: &[
                "অন\u{9c1}ষ\u{9cd}ঠ\u{9be}ন",
                "উদয\u{9be}পন",
                "চ\u{9be}\u{981}দ",
                "চ\u{9be}\u{981}দ দেখ\u{9be}র উৎসব",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("lid al loar"),
            keywords: &["fest", "gouel", "lid", "lid al loar", "loar"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("ceremonija punog mjeseca"),
            keywords: &[
                "ceremonija",
                "ceremonija punog mjeseca",
                "mjesec",
                "obred",
                "proslava",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cerimònia de la lluna"),
            keywords: &["cerimònia", "cerimònia de la lluna", "lluna"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏅᏓ ᎠᎪᏩᏛᏗ ᏓᏂᎳᏫᎬᎢ"),
            keywords: &[
                "ᎠᎾᎵᎮᎵᏍᏗᏍᎬᎢ",
                "ᏅᏓ ᎠᎪᏩᏛᏗ ᏓᏂᎳᏫᎬᎢ",
                "ᏅᏓ ᎤᏒ ᎡᎯ",
                "ᏅᏓ ᎤᏒ ᎡᎯ ᎠᎪᏩᏛᏗ ᏓᏂᎳᏫᎬᎢ",
                "ᏓᏂᎳᏫᎬᎢ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("slavnosti měsíce"),
            keywords: &[
                "cukimi",
                "japonský",
                "měsíc",
                "obřad",
                "oslava",
                "slavnosti měsíce",
                "svátek",
                "tsukimi",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("seremoni’r lleuad"),
            keywords: &["dathliad", "lleuad", "seremoni", "seremoni’r lleuad"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("måneceremoni"),
            keywords: &["ceremoni", "fejring", "måne", "måneceremoni"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("traditionelles Mondfest"),
            keywords: &["Japan", "Mond", "Mondfest", "traditionelles Mondfest"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("τελετή θέασης της σελήνης"),
            keywords: &["γιορτή", "τελετή", "τελετή θέασης της σελήνης", "φεγγάρι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("moon viewing ceremony"),
            keywords: &["celebration", "ceremony", "moon", "moon viewing ceremony"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &[
                "celebration",
                "ceremony",
                "jugoya",
                "moon",
                "moon-viewing ceremony",
                "otsukimi",
                "tsukimi",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("moon-viewing ceremony"),
            keywords: &[
                "celebration",
                "ceremony",
                "moon",
                "moon viewing ceremony",
                "moon-viewing ceremony",
            ],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("ceremonia de contemplación de la luna"),
            keywords: &[
                "celebración",
                "ceremonia de contemplación de la luna",
                "contemplación",
                "luna",
                "tsukimi",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("ceremonia japonesa"),
            keywords: &[
                "Otsukimi",
                "celebración",
                "ceremonia",
                "ceremonia japonesa",
                "luna",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("ceremonia de contemplación de la luna"),
            keywords: &["ceremonia de contemplación de la luna"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kuutseremoonia"),
            keywords: &["festival", "kuu", "kuutseremoonia", "tseremoonia"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ilargiaren ospakizuna"),
            keywords: &["ilargi", "ilargiaren ospakizuna", "ospakizun", "zeremonia"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("آئین مشاهده\u{654} ماه کامل"),
            keywords: &[
                "آئین مشاهده\u{654} ماه کامل",
                "جشن",
                "ماه",
                "مراسم",
                "مراسم رؤیت ماه",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kuuseremonia"),
            keywords: &["juhla", "juhlamenot", "kuu", "kuuseremonia"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("moon viewing ceremony"),
            keywords: &[
                "buwan",
                "moon ceremony",
                "moon viewing ceremony",
                "pagdiriwang",
                "seremonya",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("tsukimi"),
            keywords: &["japanskt", "jugoya", "otsukimi", "tsukimi"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("cérémonie de la lune"),
            keywords: &["cérémonie", "cérémonie de la lune", "lune"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("cérémonie d’observation de la lune"),
            keywords: &["cérémonie", "cérémonie d’observation de la lune", "lune"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("deasghnáth amhairc ar an ngealach"),
            keywords: &[
                "amharc ar an ngealach",
                "deasghnáth amhairc ar an ngealach",
                "féile na gealaí",
                "gealach",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("latha coimhead na gealaich"),
            keywords: &[
                "comharrachadh",
                "deas-ghnàth",
                "gealach",
                "latha coimhead na gealaich",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cerimonia da lúa"),
            keywords: &["cerimonia", "cerimonia da lúa", "lúa", "xaponesa"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ચ\u{a82}દ\u{acd}ર દર\u{acd}શન સમાર\u{a82}ભ"),
            keywords: &[
                "ઉજવણી",
                "ચ\u{a82}દ\u{acd}ર",
                "ચ\u{a82}દ\u{acd}ર દર\u{acd}શન સમાર\u{a82}ભ",
                "દર\u{acd}શન",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("bikin kallon wata"),
            keywords: &["biki", "bikin kallon wata", "shagali", "wata"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("טקס ירח"),
            keywords: &["חג", "חגיגה", "טקס", "יפני", "ירח"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("चा\u{901}द द\u{947}खन\u{947} का उत\u{94d}सव"),
            keywords: &[
                "चा\u{901}द द\u{947}खन\u{947} का उत\u{94d}सव",
                "चा\u{902}द",
                "चा\u{902}द द\u{947}खन\u{947} का उत\u{94d}सव",
                "द\u{947}खना",
                "समारोह",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("mjesečeva svečanost"),
            keywords: &["mjesec", "mjesečeva svečanost", "slavlje", "svečanost"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("holdünnep"),
            keywords: &["hold", "holdünnep", "ünnep", "ünnepi hangulat", "ünneplés"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("լուսնի ծես"),
            keywords: &["լուսին", "լուսնի ծես", "ծես", "տոն"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("perayaan bulan"),
            keywords: &["bulan", "perayaan", "upacara"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("emume nlele ọnwa"),
            keywords: &["emume", "emume nlele ọnwa", "enwemụaṅụrị", "ọnwa"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("tunglskoðun"),
            keywords: &["hátíð", "tungl", "tunglskoðun", "tunglskoðunarhátíð"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("contemplazione della luna"),
            keywords: &[
                "contemplazione della luna",
                "contemplazione festa",
                "festa della contemplazione della luna",
                "luna",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("月見"),
            keywords: &["ススキ", "十五夜", "月", "月見"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("upacara nyawang mbulan"),
            keywords: &["mbulan", "perayaan", "upacara", "upacara nyawang mbulan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მთვარის ცერემონია"),
            keywords: &[
                "აღნიშვნა",
                "ზეიმი",
                "მთვარე",
                "მთვარის ცერემონია",
                "ცერემონია",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ай рәсімі"),
            keywords: &["ай", "ай рәсімі", "салтанат", "тойлау"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("måneceremoni"),
            keywords: &["ceremoni", "fejring", "måne", "måneceremoni"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17bb}ណ\u{17d2}យសែនព\u{17d2}រះខែ"),
            keywords: &["ប\u{17bb}ណ\u{17d2}យសែនព\u{17d2}រះខែ", "សែន"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಚಂದ\u{ccd}ರನ ವೀಕ\u{ccd}ಷಣ\u{cc6}"),
            keywords: &[
                "ಆಚರಣ\u{cc6}",
                "ಚಂದ\u{ccd}ರ",
                "ಚಂದ\u{ccd}ರನ ನೋಡುವ ಸಮಾರಂಭ",
                "ಚಂದ\u{ccd}ರನ ವೀಕ\u{ccd}ಷಣ\u{cc6}",
                "ವೀಕ\u{ccd}ಷ\u{cbf}ಸುವ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("달맞이"),
            keywords: &["달", "달맞이", "달맞이 행사", "벼이삭"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("च\u{902}द\u{94d}र पळोवपाचो स\u{941}वाळो"),
            keywords: &[
                "च\u{902}द\u{94d}र",
                "च\u{902}द\u{94d}र पळोवपाचो स\u{941}वाळो",
                "दबाजो",
                "स\u{941}वाळो",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("айга көз салуу жөрөлгөсү"),
            keywords: &["ай", "айга көз салуу жөрөлгөсү", "жөрөлгө", "майрам"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Moundbetruechtungszeremonie"),
            keywords: &["Feier", "Mound", "Moundbetruechtungszeremonie", "Zeremonie"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ພ\u{eb4}ທ\u{eb5}ໄຫວ\u{ec9}ພະຈ\u{eb1}ນ"),
            keywords: &[
                "ພະຈ\u{eb1}ນ",
                "ພ\u{eb4}ທ\u{eb5}",
                "ພ\u{eb4}ທ\u{eb5}ໄຫວ\u{ec9}ພະຈ\u{eb1}ນ",
                "ສະເຫ\u{ebc}\u{eb5}ມສະຫ\u{ebc}ອງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("mėnesienos ceremonija"),
            keywords: &["ceremonija", "mėnesienos ceremonija", "mėnulis", "šventė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("mēness vērošanas ceremonija"),
            keywords: &["japāņu", "mēness", "mēness vērošanas ceremonija", "svētki"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("taurima tiro marama"),
            keywords: &["marama", "taurima", "taurima tiro marama", "whakanuinga"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("прослава на месечината"),
            keywords: &["месечина", "прослава", "прослава на месечината", "јапонска"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ചന\u{d4d}ദ\u{d4d}രനെ ക\u{d3e}ണൽ ആഘോഷം"),
            keywords: &[
                "ആഘോഷം",
                "ചന\u{d4d}ദ\u{d4d}രനെ ക\u{d3e}ണൽ ആഘോഷം",
                "ചന\u{d4d}ദ\u{d4d}രൻ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("сар харах баяр"),
            keywords: &["баяр", "сар", "сар харах баяр", "тэмдэглэх"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("पौर\u{94d}णिम\u{947}ला साजरा क\u{947}ला जाणारा महिला\u{902}चा उत\u{94d}सव"),
            keywords: &[
                "उत\u{94d}सव",
                "च\u{902}द\u{94d}र",
                "च\u{902}द\u{94d}र दर\u{94d}शन समार\u{902}भ",
                "पौर\u{94d}णिम\u{947}ला साजरा क\u{947}ला जाणारा महिला\u{902}चा उत\u{94d}सव",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("upacara bulan"),
            keywords: &["bulan", "perayaan", "upacara"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ċerimonja biex tara l-qamar"),
            keywords: &[
                "qamar",
                "ċelebrazzjoni",
                "ċerimonja",
                "ċerimonja biex tara l-qamar",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လ အခမ\u{103a}းအနား"),
            keywords: &[
                "ပ\u{103d}\u{1032}တော\u{103a}",
                "လ",
                "လကြည\u{1037}\u{103a}ပ\u{103d}\u{1032} အခမ\u{103a}းအနား",
                "အခမ\u{103a}းအနား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("månebeskuelsesseremoni"),
            keywords: &[
                "feiring",
                "høytid",
                "måne",
                "månebeskuelsesseremoni",
                "månefeiring",
                "måneseremoni",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("चन\u{94d}द\u{94d}रमा ह\u{947}र\u{94d}न\u{947} समारोह"),
            keywords: &[
                "कार\u{94d}यक\u{94d}रम",
                "चन\u{94d}द\u{94d}रमा",
                "चन\u{94d}द\u{94d}रमा ह\u{947}र\u{94d}न\u{947} समारोह",
                "समारोह",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("maanobservatieceremonie"),
            keywords: &["ceremonie", "feest", "maan", "maanobservatieceremonie"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("månekikkingsseremoni"),
            keywords: &[
                "feiring",
                "høgtid",
                "måne",
                "månefeiring",
                "månekikkingsseremoni",
                "måneseremoni",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଚ\u{b3e}ନ\u{b4d}ଦ ଦେଖ\u{b3f}ବ\u{b3e} ପର\u{b4d}ବ"),
            keywords: &[
                "ଉତ\u{b4d}ସବ",
                "ଚନ\u{b4d}ଦ\u{b4d}ର",
                "ଚ\u{b3e}ନ\u{b4d}ଦ ଦେଖ\u{b3f}ବ\u{b3e} ପର\u{b4d}ବ",
                "ଦର\u{b4d}ଶନ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਚ\u{a70}ਦ ਵ\u{a47}ਖਣ ਦਾ ਜਸ\u{a3c}ਨ"),
            keywords: &[
                "ਚ\u{a70}ਦ ਵ\u{a47}ਖਣ ਦਾ ਜਸ\u{a3c}ਨ",
                "ਚ\u{a70}ਨ",
                "ਚ\u{a70}ਨ ਵ\u{a47}ਖਣ ਦੀ ਰਸਮ",
                "ਜਸ\u{a3c}ਨ",
                "ਵ\u{a47}ਖਣ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("چاند ویکھن دی تقریب"),
            keywords: &["تقریب", "منانا", "چاند", "چاند ویکھن دی تقریب"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fẹ\u{301}stival Wé Japán Pípol De Ték Ọ\u{301}nọ\u{301} Mun"),
            keywords: &[
                "Fẹ\u{301}stival Wé Japán Pípol De Ték Ọ\u{301}nọ\u{301} Mun",
                "Mun",
                "Sẹlibréshọn",
                "Sẹ\u{301}rẹ\u{301}mọ\u{301}ni",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("ceremonia oglądania księżyca"),
            keywords: &[
                "ceremonia oglądania księżyca",
                "księżyc",
                "podziwiać",
                "tsukimi",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د سپوږمۍ لیدنې مراسم"),
            keywords: &["د سپوږمۍ لیدنې مراسم", "رسم", "سپوږمۍ", "لمانځنه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("contemplação da lua"),
            keywords: &[
                "cerimônia de contemplação da lua",
                "comemoração",
                "contemplação",
                "contemplação da lua",
                "lua",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cerimónia da lua"),
            keywords: &["celebração", "cerimónia", "cerimónia da lua", "lua"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("killa itu qawaypaq"),
            keywords: &["killa itu qawaypaq"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("ceremonia lunii"),
            keywords: &["ceremonia lunii", "ceremonie", "lună", "sărbătoare"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-342"),
            keywords: &["E10-342"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("праздник Луны"),
            keywords: &["луна", "праздник", "праздник Луны", "церемония"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ibirori byo kureba ukwezi"),
            keywords: &["ibirori", "ibirori byo kureba ukwezi", "ukwezi", "umuhango"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("چنڊ ڏسڻ جي رسم"),
            keywords: &["جشن، رسم، چنڊ", "چنڊ ڏسڻ جي رسم"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("සඳ උත\u{dca}සවය"),
            keywords: &["උත\u{dca}සවය", "සඳ", "සැමර\u{dd4}ම"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("slávnosti mesiaca"),
            keywords: &["mesiac", "obrad", "oslava", "slávnosti mesiaca"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("lunino slavje"),
            keywords: &["luna", "lunino slavje", "obred", "slavje"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("Munaasabada daawashada dayaxa"),
            keywords: &[
                "Munaasabada daawashada dayaxa",
                "dabaaldag",
                "dayax",
                "munaasabad",
                "munaasabada daawashada dayaxa",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("ceremoni për hënën"),
            keywords: &["ceremoni", "ceremoni për hënën", "festim", "festë", "hënë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("церемонија у част месеца"),
            keywords: &["месец", "прослава", "свeчaнoст", "церемонија у част месеца"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("церемонија у част мјесеца"),
            keywords: &["церемонија у част мјесеца"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("ceremonija u čast meseca"),
            keywords: &["ceremonija u čast meseca", "mesec", "proslava", "svečanost"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("ceremonija u čast mjeseca"),
            keywords: &["ceremonija u čast mjeseca"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("månskådning"),
            keywords: &["japan", "månfest", "månskådning"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("sherehe ya mwezi"),
            keywords: &["kusherehekea", "mwezi", "sherehe", "sherehe ya mwezi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("அறுவடை உணவுகளை நிலவிற\u{bcd}குப\u{bcd} படைத\u{bcd}தல\u{bcd}"),
            keywords: &[
                "அறுவடை உணவுகளை நிலவிற\u{bcd}குப\u{bcd} படைத\u{bcd}தல\u{bcd}",
                "கொண\u{bcd}ட\u{bbe}ட\u{bcd}டம\u{bcd}",
                "நிலவிற\u{bcd}குப\u{bcd} படைத\u{bcd}தல\u{bcd}",
                "நிலவு",
                "படைத\u{bcd}தல\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("చంద\u{c4d}ర వ\u{c40}క\u{c4d}షణ ఉత\u{c4d}సవం"),
            keywords: &[
                "చంద\u{c4d}ర వ\u{c40}క\u{c4d}షణ ఉత\u{c4d}సవం",
                "చంద\u{c4d}రుడ\u{c3f}న\u{c3f} చూడటం",
                "చంద\u{c4d}రుడు",
                "వ\u{c47}డుకలు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("маросими тамошои моҳтоб"),
            keywords: &["маросим", "маросими тамошои моҳтоб", "моҳ", "ҷашн"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ไหว\u{e49}พระจ\u{e31}นทร\u{e4c}"),
            keywords: &[
                "พระจ\u{e31}นทร\u{e4c}",
                "เฉล\u{e34}มฉลอง",
                "ไหว\u{e49}พระจ\u{e31}นทร\u{e4c}",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("aý synlaýyş dabarasy"),
            keywords: &["aý", "aý synlaýyş dabarasy", "baýramçylyk", "dabara"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("vakai-māhina"),
            keywords: &["vakai-māhina"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("ay izleme"),
            keywords: &["ay", "ay izleme töreni", "izleme", "kutlama"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئاي كۆرۈش مۇراسىمى"),
            keywords: &["ئاي", "ئاي كۆرۈش مۇراسىمى", "تەبرىكلەش", "مۇراسىم"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("церемонія вшанування місяця"),
            keywords: &[
                "місяць",
                "святкування",
                "церемонія",
                "церемонія вшанування місяця",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("چاند کی رسم"),
            keywords: &["جشن", "رسم", "چاند", "چاند کی رسم"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("oy marosimi"),
            keywords: &["bayram", "marosim", "oy", "oy marosimi", "tadbir"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("lễ ngắm trăng"),
            keywords: &["kỷ niệm", "lễ kỷ niệm", "lễ ngắm trăng", "mặt trăng"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("séentu weer"),
            keywords: &["màggal", "séentu weer", "weer"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umsitho wokubukela inyanga"),
            keywords: &[
                "inyanga",
                "umbhiyozo",
                "umsitho",
                "umsitho wokubukela inyanga",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Wiwo Ayẹyẹ Oṣupa"),
            keywords: &["Wiwo Ayẹyẹ Oṣupa", "ayẹyẹ", "òṣùpá"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("賞月"),
            keywords: &["儀式", "慶祝", "月亮", "賞月"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("赏月"),
            keywords: &["仪式", "庆祝", "月亮", "赏月"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("赏月"),
            keywords: &["中秋", "庆祝", "月亮", "赏月"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("賞月"),
            keywords: &["賞月"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umcimbi wenyanga"),
            keywords: &["inyanga", "umbungazo", "umcimbi", "umcimbi wenyanga"],
        },
    ],
};
#[doc = "🧧"]
pub const RED_ENVELOPE: crate::Emoji = crate::Emoji {
    glyph: "🧧",
    codepoint: "1F9E7",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "red envelope",
    group: "Activities",
    subgroup: "event",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("rooi koevert"),
            keywords: &["geld", "geskenk", "goeie geluk", "lai see", "rooi koevert"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ቀይ ፖስታ"),
            keywords: &["መልካም ዕድል", "ስጦታ", "ቀይ ፖስታ", "የቻይና ፖስታ", "ገንዘብ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ظرف أحمر بكتابة صينية"),
            keywords: &["أموال", "أنغ بو", "صين", "ظرف أحمر بكتابة صينية", "هدية"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ৰঙ\u{9be} লেফ\u{9be}ফ\u{9be}"),
            keywords: &[
                "উপহ\u{9be}ৰ",
                "ধন",
                "ল\u{9be}ই চি",
                "সৌভ\u{9be}গ\u{9cd}য",
                "হংব\u{9be}ও",
                "ৰঙ\u{9be} লেফ\u{9be}ফ\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qırmızı zərf"),
            keywords: &["bəxt", "honbao", "hədiyyə", "pul", "qırmızı zərf"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("чырвоны канверт"),
            keywords: &[
                "грошы",
                "падарунак",
                "прэзент",
                "удача",
                "хунбаа",
                "чаявыя",
                "чырвоны канверт",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("червен плик"),
            keywords: &["китайски плик", "късмет", "пари", "подарък", "червен плик"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ল\u{9be}ল খ\u{9be}ম"),
            keywords: &[
                "অর\u{9cd}থ",
                "উপহ\u{9be}র",
                "ল\u{9be}ই সি",
                "ল\u{9be}ল খ\u{9be}ম",
                "সৌভ\u{9be}গ\u{9cd}য",
                "হং ব\u{9be}ও",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("golo ruz"),
            keywords: &["arcʼhant", "chañs vat", "golo ruz"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("crvena koverta"),
            keywords: &[
                "crvena koverta",
                "hongbao",
                "lai see",
                "novac",
                "poklon",
                "za sreću",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("sobre vermell"),
            keywords: &[
                "bona sort",
                "diners",
                "hóngbāo",
                "lai see",
                "regal",
                "sobre vermell",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎩᎦᎨ ᎪᏪᎵ ᎠᏍᏚᏙᏗ"),
            keywords: &["ᎠᏓᏁᏗ", "ᎠᏕᎳ", "ᎣᏍᏓ ᎤᏓᏝᏥᏗ", "ᎩᎦᎨ ᎪᏪᎵ ᎠᏍᏚᏙᏗ", "ᎰᏂᎩᏇᎣ", "ᎳᏱᏏ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("červená obálka"),
            keywords: &[
                "dárek",
                "hongbao",
                "lai see",
                "peníze",
                "červená obálka",
                "štěstí",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("amlen goch"),
            keywords: &[
                "amlen goch",
                "anrheg",
                "arian",
                "hóngbāo",
                "lai see",
                "pob lwc",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("pengegave"),
            keywords: &[
                "gave",
                "held og lykke",
                "hóngbāo",
                "lai see",
                "penge",
                "pengegave",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("roter Umschlag"),
            keywords: &["Geld", "Geschenk", "Glück", "Hongbao", "roter Umschlag"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κόκκινος φάκελος"),
            keywords: &["δώρο", "καλή τύχη", "κόκκινος φάκελος", "λεφτά"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("red envelope"),
            keywords: &[
                "gift",
                "good luck",
                "hóngbāo",
                "lai see",
                "money",
                "red envelope",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("sobre rojo"),
            keywords: &["buena suerte", "hóngbāo", "lai see", "regalo", "sobre rojo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("sobre rojo"),
            keywords: &["buena suerte", "dinero", "regalo", "sobre rojo"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("sobre rojo"),
            keywords: &["sobre rojo"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("punane ümbrik"),
            keywords: &["edu", "hóngbāo", "kingitus", "punane ümbrik", "raha", "õnn"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("gutun-azal gorri"),
            keywords: &[
                "diru",
                "gutun-azal gorri",
                "hóngbāo",
                "lai see",
                "opari",
                "zorte on",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پاکت سرخ"),
            keywords: &["لای\u{200c}سی", "هدیه", "هونگ بائو", "پاکت سرخ", "پول"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("punainen kirjekuori"),
            keywords: &[
                "hóngbāo",
                "lahja",
                "lai see",
                "onni",
                "punainen kirjekuori",
                "raha",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("ampao"),
            keywords: &[
                "ampao",
                "ampaw",
                "ang pao",
                "pera",
                "pula envelope",
                "regalo",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("reyður brævbjálvi"),
            keywords: &[
                "brævbjálvi",
                "gáva",
                "hóngbāo",
                "lai see",
                "reyður brævbjálvi",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("enveloppe rouge"),
            keywords: &[
                "argent",
                "bonne chance",
                "cadeau",
                "enveloppe rouge",
                "hóngbāo",
                "lai see",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("clúdach litreach dearg"),
            keywords: &[
                "airgead",
                "bronntanas",
                "clúdach litreach dearg",
                "hóngbāo",
                "lai see",
                "ádh mór",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cèiseag dhearg"),
            keywords: &[
                "airgead",
                "cèiseag dhearg",
                "fortan",
                "hóngbāo",
                "lai see",
                "prèasant",
                "sonas",
                "tìodhlac",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("sobre vermello"),
            keywords: &[
                "agasallo",
                "boa sorte",
                "diñeiro",
                "hongbao",
                "lai see",
                "sobre vermello",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("લાલ પરબિડીય\u{ac1}\u{a82}"),
            keywords: &[
                "નાણા\u{a82}",
                "ભ\u{ac7}ટ",
                "લાઇ સી",
                "લાલ પરબિડીય\u{ac1}\u{a82}",
                "સદ\u{acd}\u{200c}નસીબ",
                "હૉ\u{a82}ગબૌઓ",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מעטפה אדומה"),
            keywords: &["כסף", "מזל טוב", "מעטפה אדומה", "מתנה", "סין"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("लाल लिफ\u{93c}ाफ\u{93c}ा"),
            keywords: &[
                "उपहार",
                "धन",
                "लाई सी",
                "लाल लिफ\u{93c}ाफ\u{93c}ा",
                "श\u{941}भ\u{947}च\u{94d}छा",
                "हो\u{902}गबाओ",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("crvena omotnica"),
            keywords: &["crvena omotnica", "dar", "novac", "poklon", "sreća"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("piros boríték"),
            keywords: &[
                "ajándék",
                "hóngbāo",
                "lai see",
                "piros boríték",
                "pénz",
                "szerencsehozó",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կարմիր ծրար"),
            keywords: &["կարմիր ծրար", "հաջողություն", "հոնգբաո", "նվեր", "փող"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("amplop merah"),
            keywords: &[
                "amplop merah",
                "hadiah",
                "hóngbāo",
                "lai see",
                "semoga beruntung",
                "uang",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("rautt umslag"),
            keywords: &["gjöf", "lai see", "lukka", "peningar", "rautt umslag"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("busta hongbao"),
            keywords: &[
                "buono auspicio",
                "busta hongbao",
                "busta rossa",
                "hongbao",
                "lai see",
                "regalo",
                "soldi",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("赤い封筒"),
            keywords: &["お年玉", "お金", "ご祝儀", "幸運", "紅包", "赤い封筒"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("ang pao"),
            keywords: &[
                "andum pandonga",
                "ang pao",
                "dhuwit",
                "hongbao",
                "kado",
                "lai see",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("წითელი კონვერტი"),
            keywords: &["ბარაქა", "იღბალი", "საჩუქარი", "წითელი კონვერტი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қызыл конверт"),
            keywords: &[
                "ақша",
                "лайси",
                "сыйлық",
                "сәттілік",
                "хонбао",
                "қызыл конверт",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("អា\u{17c6}ងប\u{17c9}ាវ"),
            keywords: &[
                "កាដ\u{17bc}",
                "ល\u{17bb}យ",
                "ស\u{17c6}ណាងល\u{17d2}អ",
                "អា\u{17c6}ងប\u{17c9}ាវ",
                "អ\u{17c6}ណោយ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕ\u{cc6}ಂಪು ಎನ\u{ccd}ವಲಪ\u{ccd}"),
            keywords: &[
                "ಉಡುಗೊರ\u{cc6}",
                "ಕ\u{cc6}ಂಪು ಎನ\u{ccd}ವಲಪ\u{ccd}",
                "ಲಾಯ\u{ccd}ಸೀ",
                "ಶುಭವಾಗಲ\u{cbf}",
                "ಹಣ",
                "ಹಾಂಗ\u{ccd}ಬೋ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("세뱃돈"),
            keywords: &["돈 봉투", "선물", "세뱃돈", "행운", "현금"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ता\u{902}बड\u{947}\u{902} एन\u{94d}वालॉप"),
            keywords: &[
                "ता\u{902}बड\u{947}\u{902} एन\u{94d}वालॉप",
                "पयश\u{947}",
                "भ\u{947}ट",
                "लाय सी",
                "श\u{942}भ लाभ",
                "हो\u{902}गबाव",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кызыл конверт"),
            keywords: &[
                "акча",
                "белек",
                "ийгилик",
                "кызыл конверт",
                "лай цзы",
                "хонгбао",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຊອງຈ\u{ebb}ດໝາຍສ\u{eb5}ແດງ"),
            keywords: &[
                "ຂອງຂ\u{eb1}ວນ",
                "ຊອງຈ\u{ebb}ດໝາຍສ\u{eb5}ແດງ",
                "ຫ\u{ebb}ງບາກ",
                "ເງ\u{eb4}ນ",
                "ໂຊກດ\u{eb5}",
                "ໄລຊ\u{eb5}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("raudonas vokas"),
            keywords: &["dovana", "pinigai", "raudonas vokas", "sėkmės"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("sarkana aploksne"),
            keywords: &["aploksne", "dāvana", "nauda", "sarkana aploksne", "veiksme"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("црвен плик"),
            keywords: &["пари", "подарок", "среќа", "црвен плик"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ച\u{d41}വന\u{d4d}ന എൻവെലപ\u{d4d}പ\u{d4d}"),
            keywords: &[
                "ഗ\u{d41}ഡ\u{d4d} ലക\u{d4d}ക\u{d4d}",
                "ച\u{d41}വന\u{d4d}ന എൻവലപ\u{d4d}പ\u{d4d}",
                "ച\u{d41}വന\u{d4d}ന എൻവെലപ\u{d4d}പ\u{d4d}",
                "പണം",
                "ല\u{d3e}യ\u{d4d} സീ",
                "സമ\u{d4d}മ\u{d3e}നം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("бэлэгний улаан дугтуй"),
            keywords: &[
                "hóngbāo",
                "lai see",
                "амжилт хүсье",
                "бэлэг",
                "бэлэгний улаан дугтуй",
                "мөнгө",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("लाल पाकिट"),
            keywords: &[
                "प\u{948}स\u{947}",
                "भ\u{947}ट",
                "लाय सी",
                "लाल पाकिट",
                "श\u{941}भ\u{947}च\u{94d}छा",
                "हा\u{901}गबाओ",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("angpau"),
            keywords: &["angpau", "hadiah", "paket merah", "tuah", "wang"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("စာအ\u{102d}တ\u{103a}န\u{102e}"),
            keywords: &[
                "က\u{1036}ကောင\u{103a}းခြင\u{103a}း",
                "င\u{103d}ေ",
                "စာအ\u{102d}တ\u{103a}န\u{102e}",
                "တရ\u{102f}တ\u{103a}စက\u{1039}က\u{1030}",
                "လက\u{103a}ဆောင\u{103a}",
                "လ\u{102d}\u{102f}င\u{103a}စ\u{102e}းစက\u{1039}က\u{1030}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("rød konvolutt"),
            keywords: &[
                "flaks",
                "gave",
                "hell og lykke",
                "hong bao",
                "lai see",
                "penger",
                "rød konvolutt",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("निमन\u{94d}त\u{94d}रणा"),
            keywords: &[
                "उपहार",
                "निमन\u{94d}त\u{94d}रणा",
                "प\u{948}सा",
                "राम\u{94d}रो भाग\u{94d}य",
                "लाई सी",
                "श\u{941}भकामना पत\u{94d}र",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("rode envelop"),
            keywords: &[
                "cadeau",
                "geld",
                "hóngbāo",
                "lai see",
                "rode envelop",
                "voorspoed",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("raud konvolutt"),
            keywords: &[
                "flaks",
                "gåve",
                "hell og lykke",
                "hong bao",
                "lai see",
                "pengar",
                "raud konvolutt",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ନ\u{b3e}ଲ\u{b3f} ଲ\u{b3f}ଫ\u{b3e}ଫ\u{b3e}"),
            keywords: &[
                "ଉପହ\u{b3e}ର",
                "ଟଙ\u{b4d}କ\u{b3e}",
                "ନ\u{b3e}ଲ\u{b3f} ଲ\u{b3f}ଫ\u{b3e}ଫ\u{b3e}",
                "ଲ\u{b3e}ଇ ସ\u{b3f}",
                "ଶ\u{b41}ଭ ଭ\u{b3e}ଗ\u{b4d}ୟ",
                "ହଙ\u{b4d}ଗବ\u{b3e}ଓ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਲਾਲ ਲਿਫ\u{a3c}ਾਫਾ"),
            keywords: &[
                "ਤ\u{a4b}ਹਫ\u{a3c}ਾ",
                "ਪ\u{a48}ਸਾ",
                "ਲਾਲ ਲਿਫ\u{a3c}ਾਫਾ",
                "ਸ\u{a3c}\u{a41}ਭ ਕਾਮਨਾਵਾ\u{a02}",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Rẹ\u{301}d Ẹnvẹ\u{301}lop"),
            keywords: &[
                "Gift",
                "Gúd Lọk",
                "Họ\u{301}ngbao",
                "Lai Sii",
                "Mọ\u{301}ni",
                "Rẹ\u{301}d Ẹnvẹ\u{301}lop",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("czerwona koperta"),
            keywords: &[
                "czerwona koperta",
                "hóngbāo",
                "lai see",
                "pieniądze",
                "prezent",
                "szczęście",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سره لفافه"),
            keywords: &["سره لفافه", "لاي سي", "هينګبو", "پېسې", "ډالۍ", "ښه نصيب"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("envelope vermelho"),
            keywords: &[
                "boa sorte",
                "dinheiro",
                "envelope vermelho",
                "hóngbāo",
                "lai see",
                "presente",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("plic roșu"),
            keywords: &["bani", "cadou", "noroc", "plic roșu"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E11-049"),
            keywords: &["E11-049"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("красный конверт"),
            keywords: &["деньги", "конверт", "красный", "подарок", "удача"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڳاڙهو لفافو"),
            keywords: &["hóngbāo", "تحفو", "لائي سي", "پئسو", "گڊ لڪ", "ڳاڙهو لفافو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("රත\u{dd4} ල\u{dd2}ය\u{dd4}ම\u{dca} කවරය"),
            keywords: &[
                "තෑග\u{dca}ග",
                "ම\u{dd4}දල",
                "රත\u{dd4} ල\u{dd2}ය\u{dd4}ම\u{dca} කවරය",
                "ලය\u{dd2} ස\u{dd2}",
                "හොඳ ව\u{dcf}සන\u{dcf}ව",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("červená obálka"),
            keywords: &[
                "chung-pao",
                "darček",
                "peniaze",
                "červená obálka",
                "šťastie",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("rdeča ovojnica"),
            keywords: &[
                "darilo",
                "denar",
                "hóngbāo",
                "lai see",
                "rdeča ovojnica",
                "sreča",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("baqshad gaduudan"),
            keywords: &[
                "arag",
                "baqshad gaduudan",
                "baqshad guduudan",
                "hadiyad",
                "hadiyad lacageed",
                "lacag",
                "nasiib wacan",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("zarf i kuq"),
            keywords: &["dhuratë", "fatsjellëse", "para", "zarf i kuq"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("црвена коверта"),
            keywords: &["новац", "поклон", "срећа", "црвена коверта"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("crvena koverta"),
            keywords: &["crvena koverta", "novac", "poklon", "sreća"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("rött kuvert"),
            keywords: &[
                "hóngbāo",
                "lai see",
                "pengar",
                "present",
                "rött kuvert",
                "tur",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("bahasha nyekundu"),
            keywords: &[
                "bahasha nyekundu",
                "hongbao",
                "kila la heri",
                "lai see",
                "pesa",
                "zawadi",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சிவப\u{bcd}பு உறை"),
            keywords: &[
                "சன\u{bcd}ம\u{bbe}னம\u{bcd}",
                "சிவப\u{bcd}பு உறை",
                "பணம\u{bcd}",
                "பரிசு",
                "பரிசு கவர\u{bcd}",
                "வ\u{bbe}ழ\u{bcd}த\u{bcd}து",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ర\u{c46}డ\u{c4d} ఎన\u{c4d}వలప\u{c4d}"),
            keywords: &[
                "డబ\u{c4d}బు",
                "బహుమత\u{c3f}",
                "ర\u{c46}డ\u{c4d} ఎన\u{c4d}వలప\u{c4d}",
                "శుభం",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("อ\u{e31}\u{e48}งเปา"),
            keywords: &[
                "ของขว\u{e31}ญ",
                "อ\u{e31}\u{e48}งเปา",
                "เง\u{e34}น",
                "แต\u{e4a}ะเอ\u{e35}ย",
                "โชคลาภ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gyzyl bukja"),
            keywords: &[
                "gyzyl bukja",
                "hoňbao",
                "laý si",
                "pul",
                "sowgat",
                "şowlulyk",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("sila kulokula"),
            keywords: &["sila kulokula"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kırmızı zarf"),
            keywords: &[
                "hediye",
                "hóngbāo",
                "iyi şanslar",
                "kırmızı zarf",
                "lai see",
                "para",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("червоний конверт"),
            keywords: &[
                "гроші",
                "конверт",
                "лист",
                "на щастя",
                "подарунок",
                "червоний конверт",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سرخ لفافہ"),
            keywords: &[
                "تحفہ",
                "خوش قسمتی",
                "رقم",
                "سرخ لفافہ",
                "لائی سی",
                "ہونگ باؤ",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("qizil xatjild"),
            keywords: &["konvert", "omad", "pul", "qizil", "sovg‘a", "xatjild"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bao lì xì"),
            keywords: &[
                "bao lì xì",
                "chúc may mắn",
                "hồng bao",
                "lì xì",
                "quà tặng",
                "tiền",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("利是封"),
            keywords: &["利是", "利是封", "好運", "禮物", "紅包", "錢"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("利是封"),
            keywords: &["利是", "利是封", "好运", "礼物", "红包", "钱"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("红包"),
            keywords: &["利是", "礼物", "红包", "运气", "钱"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("紅包"),
            keywords: &["吉利", "壓歲錢", "禮物", "紅包", "紅包袋"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("利是"),
            keywords: &["利是", "利是封", "吉利", "壓歲錢", "禮物"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("E11:049"),
            keywords: &["E11:049"],
        },
    ],
};
#[doc = "🎀"]
pub const RIBBON: crate::Emoji = crate::Emoji {
    glyph: "🎀",
    codepoint: "1F380",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "ribbon",
    group: "Activities",
    subgroup: "event",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("lint"),
            keywords: &["lint", "strik", "viering"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሪባን"),
            keywords: &["ሪባን", "ክብረ በዓል"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("شريط"),
            keywords: &["حفلة", "شريط"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ফিট\u{9be}"),
            keywords: &["উদয\u{9be}পন", "ফিট\u{9be}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("lent"),
            keywords: &["bayram", "lent"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("стужка"),
            keywords: &["свята", "святкаванне", "стужка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("панделка"),
            keywords: &["панделка", "празнуване"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("রিবন"),
            keywords: &["উদয\u{9be}পন", "রিবন"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("seizenn"),
            keywords: &["fest", "gouel", "seizenn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("mašnica"),
            keywords: &["mašnica", "proslava"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("llaç"),
            keywords: &["celebració", "cinta", "llaç"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏇᎷᏍᏗ"),
            keywords: &["ᎠᎾᎵᎮᎵᏍᏗᏍᎬᎢ", "ᎠᏇᎷᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("mašle"),
            keywords: &["mašle", "oslava"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("rhuban"),
            keywords: &["dathliad", "rhuban"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("sløjfe"),
            keywords: &["fejring", "sløjfe"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("pinke Schleife"),
            keywords: &["Feier", "Schleife", "pinke Schleife"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κορδέλα"),
            keywords: &["γιορτή", "κορδέλα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("ribbon"),
            keywords: &["celebration", "ribbon"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("lazo"),
            keywords: &["celebración", "lazo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("moño"),
            keywords: &["celebración", "cinta", "festejo", "moño", "regalo"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("lint"),
            keywords: &["lint", "lips"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("begizta"),
            keywords: &["begizta", "ospakizun"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("روبان"),
            keywords: &["بزرگداشت", "جشن", "روبان", "عید"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("rusetti"),
            keywords: &["juhla", "lahjanaru", "rusetti", "ruusuke"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("ribbon"),
            keywords: &["laso", "pagdiriwang", "ribbon"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("band"),
            keywords: &["band", "prýðisrósa"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("ruban"),
            keywords: &["fête", "ruban"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("ribín"),
            keywords: &["ceiliúradh", "ribín"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("ribean"),
            keywords: &["comharrachadh", "ribean"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("lazo"),
            keywords: &["celebración", "cinta", "lazo", "regalo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("રિબન"),
            keywords: &["ઉજવણી", "રિબન"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("ribon"),
            keywords: &["ribon", "shagali"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סרט מתנה"),
            keywords: &["חגיגה", "מסיבה", "מתנה", "סרט"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("फ\u{93c}ीता"),
            keywords: &["उत\u{94d}सव", "फ\u{93c}ीता", "रिबन", "समारोह"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("mašna"),
            keywords: &["mašna", "slavlje"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("szalag"),
            keywords: &["masni", "szalag", "ünnep", "ünnepi hangulat", "ünneplés"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ժապավեն"),
            keywords: &["ժապավեն", "տոն", "տոնակատարություն"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("pita"),
            keywords: &["perayaan", "pita"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ribọn"),
            keywords: &["enwemụaṅụrị", "ribọn"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("borði"),
            keywords: &["borði", "slaufa", "veisla"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("fiocco"),
            keywords: &["festa", "fiocco"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("リボン"),
            keywords: &["お祝い", "リボン"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("pita"),
            keywords: &["perayaan", "pita"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ლენტი"),
            keywords: &["აღნიშვნა", "ზეიმი", "ლენტი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: None,
            keywords: &["asfugel"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("таспа"),
            keywords: &["таспа", "тойлау"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("sløjfe"),
            keywords: &["fejring", "sløjfe"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17bc}"),
            keywords: &["ក\u{17d2}រវ\u{17c9}ាត\u{17cb}ក", "ណ\u{17ba}", "ប\u{17bc}"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ರ\u{cbf}ಬ\u{ccd}ಬನ\u{ccd}"),
            keywords: &["ಆಚರಣ\u{cc6}", "ರ\u{cbf}ಬ\u{ccd}ಬನ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("리본"),
            keywords: &["리본", "축하"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("रिबीन"),
            keywords: &["रिबीन", "स\u{941}वाळो"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("лента"),
            keywords: &["лента", "майрам"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Band"),
            keywords: &["Band", "Feier"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໂບ"),
            keywords: &["ສະເຫ\u{ebc}\u{eb5}ມສະຫ\u{ebc}ອງ", "ໂບ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("kaspinas"),
            keywords: &["kaspinas", "šventė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("pušķītis"),
            keywords: &["lente", "pušķis", "pušķītis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("rīpene"),
            keywords: &["rīpene", "whakanuinga"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("панделка"),
            keywords: &["панделка", "подарок", "прослава"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("റിബൺ"),
            keywords: &["ആഘോഷം", "ഉത\u{d4d}സവം", "റിബൺ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("тууз"),
            keywords: &["баяр ёслол", "тууз"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("फित"),
            keywords: &["उत\u{94d}सव", "फित"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("reben"),
            keywords: &["perayaan", "reben"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("żigarella"),
            keywords: &["ċelebrazzjoni", "żigarella"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဖ\u{1032}ကြ\u{102d}\u{102f}း"),
            keywords: &[
                "ပ\u{103d}\u{1032}တော\u{103a}",
                "ဖ\u{1032}ကြ\u{102d}\u{102f}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("sløyfe"),
            keywords: &["bånd", "gavebånd", "sløyfe"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("रिबन"),
            keywords: &["रिबन", "समारोह"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("strik"),
            keywords: &["feest", "strik"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("sløyfe"),
            keywords: &["band", "gåveband", "sløyfe"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ର\u{b3f}ବନ\u{b4d}\u{200d}"),
            keywords: &[
                "ଉତ\u{b4d}ସବ",
                "ର\u{b3f}ବନ\u{b4d}\u{200d}",
                "ରେଶମ ଫ\u{b3f}ତ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਰਿਬਨ"),
            keywords: &["ਜਸ\u{a3c}ਨ", "ਰਿਬਨ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("فیتہ"),
            keywords: &["فیتہ", "منانا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Ríbọn"),
            keywords: &["Ríbọn", "Sẹlibréshọn"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("wstążka"),
            keywords: &[
                "kokarda",
                "kokardka",
                "ozdoba",
                "podarunek",
                "prezent",
                "wstążka",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("پټۍ"),
            keywords: &["لمانځنه", "پټۍ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("laço de fita"),
            keywords: &["comemoração", "laço de fita"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["celebração", "festa", "fita", "laço de fita"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("cinta"),
            keywords: &["cinta", "raymi"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("fundă"),
            keywords: &["festiv", "fundă", "panglică", "sărbătoare"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-325"),
            keywords: &["E10-325"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("бантик"),
            keywords: &["бант", "бантик", "волосы", "одежда", "праздник"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("riba"),
            keywords: &["ibirori", "riba"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڏوري"),
            keywords: &["جشن", "ڏوري"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ප\u{dd3}ත\u{dca}ත පට\u{dd2}ය"),
            keywords: &["ප\u{dd3}ත\u{dca}ත පට\u{dd2}ය", "සැමර\u{dd4}ම"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("stuha"),
            keywords: &["oslava", "stuha"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("pentlja"),
            keywords: &["pentlja", "slavje"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("xabo"),
            keywords: &["dabaaldag", "xabo"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fjongo"),
            keywords: &["festim", "festë", "fjongo"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("машница"),
            keywords: &["машница", "прослава"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("mašnica"),
            keywords: &["mašnica", "proslava"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("rosett"),
            keywords: &["fest", "rosett"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("utepe"),
            keywords: &["kusherehekea", "utepe"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ரிப\u{bcd}பன\u{bcd}"),
            keywords: &[
                "கொண\u{bcd}ட\u{bbe}ட\u{bcd}டம\u{bcd}",
                "திறப\u{bcd}பு விழ\u{bbe}",
                "ரிப\u{bcd}பன\u{bcd}",
                "விருந\u{bcd}து",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ర\u{c3f}బ\u{c4d}బన\u{c4d}"),
            keywords: &["ర\u{c3f}బ\u{c4d}బన\u{c4d}", "వ\u{c47}డుక"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("лента"),
            keywords: &["лента", "ҷашн"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ร\u{e34}บบ\u{e34}\u{e49}น"),
            keywords: &["การเฉล\u{e34}มฉลอง", "ร\u{e34}บบ\u{e34}\u{e49}น"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("lenta"),
            keywords: &["baýramçylyk", "lenta"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("lipine"),
            keywords: &["lipine"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kurdele"),
            keywords: &["kurdele", "kutlama"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("لېنتا"),
            keywords: &["تەبرىكلەش", "لېنتا"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("бант зі стрічки"),
            keywords: &["бант зі стрічки", "святкування"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ربن"),
            keywords: &["تحفہ", "جشن", "ربن"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("lenta"),
            keywords: &["bayram", "lenta"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("ruy băng"),
            keywords: &["lễ kỷ niệm", "ruy băng"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("ribaŋ"),
            keywords: &["màggal", "ribaŋ"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iribhoni"),
            keywords: &["iribhoni", "umbhiyozo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ríbìnnì"),
            keywords: &["Ríbìnnì", "ayẹyẹ"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("蝴蝶結"),
            keywords: &["慶祝", "蝴蝶結"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("蝴蝶结"),
            keywords: &["庆祝", "蝴蝶结"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("蝴蝶结"),
            keywords: &["丝带", "庆祝", "缎带", "蝴蝶结"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("蝴蝶結"),
            keywords: &["蝴蝶結"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("iribhini"),
            keywords: &["iribhini", "umbungazo"],
        },
    ],
};
#[doc = "🎁"]
pub const WRAPPED_GIFT: crate::Emoji = crate::Emoji {
    glyph: "🎁",
    codepoint: "1F381",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "wrapped gift",
    group: "Activities",
    subgroup: "event",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("toegedraaide geskenk"),
            keywords: &[
                "boks",
                "geskenk",
                "lint",
                "present",
                "toegedraaide geskenk",
                "viering",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የተጠቀለለ ስጦታ"),
            keywords: &[
                "ሣጥን",
                "ስጦታ",
                "ተጠቅልሏል",
                "አስቀድሞ ተልኳል",
                "ክብረ በዓል",
                "የተጠቀለለ ስጦታ",
            ],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("هدية ملفوفة"),
            keywords: &["مناسبة", "هدية", "هدية ملفوفة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("আচ\u{9cd}ছ\u{9be}দিত উপহ\u{9be}ৰ"),
            keywords: &[
                "আচ\u{9cd}ছ\u{9be}দিত উপহ\u{9be}ৰ",
                "উদয\u{9be}পন",
                "উপহ\u{9be}ৰ",
                "ন\u{9c1}ৰিওৱ\u{9be}",
                "ব\u{9be}কছ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("bükülmüş hədiyyə"),
            keywords: &["bayram", "bükülmüş", "hədiyyə", "hədiyyə etmək", "qutu"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("запакаваны падарунак"),
            keywords: &[
                "загорнуты",
                "запакаваны падарунак",
                "каробка",
                "падарунак",
                "свята",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("опакован подарък"),
            keywords: &[
                "Опакован подарък",
                "кутия",
                "опакован",
                "подарък",
                "празнуване",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মোড\u{9bc}কে থ\u{9be}ক\u{9be} উপহ\u{9be}র"),
            keywords: &[
                "উদয\u{9be}পন",
                "উপহ\u{9be}র",
                "জড\u{9bc}\u{9be}ন",
                "ব\u{9be}ক\u{9cd}স",
                "মোড\u{9bc}কে থ\u{9be}ক\u{9be} উপহ\u{9be}র",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("prof"),
            keywords: &["fest", "gouel", "prof", "seizenn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("zapakovan poklon"),
            keywords: &["kutija", "mašna", "poklon", "proslava", "zapakovan poklon"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("regal embolicat"),
            keywords: &["celebració", "embolicat", "regal"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᏇᏂᏓᏅ ᎠᏓᏁᏗ"),
            keywords: &["ᎠᎾᎵᎮᎵᏍᏗᏍᎬᎢ", "ᎠᏓᏁᏗ", "ᎠᏓᏁᏗᎢ", "ᎦᏇᏂᏓᏅ ᎠᏓᏁᏗ", "ᎦᏇᏅᏅᎢ", "ᎧᏁᏌᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("zabalený dárek"),
            keywords: &["balíček", "dar", "dárek", "krabice", "oslava", "zabalený"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("anrheg wedi’i lapio"),
            keywords: &["anrheg", "anrheg wedi’i lapio", "bocs", "dathliad"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("gave"),
            keywords: &["fødselsdag", "gave", "overraskelse", "pakke"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Geschenk"),
            keywords: &["Feier", "Geschenk", "verpackt"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("τυλιγμένο δώρο"),
            keywords: &["γιορτή", "δώρο", "κουτί", "τυλιγμένο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("wrapped gift"),
            keywords: &["box", "celebration", "gift", "present", "wrapped"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("gift"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("regalo"),
            keywords: &[
                "celebración",
                "envoltorio",
                "presente",
                "regalo",
                "regalo envuelto",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["celebración", "moño", "presente", "regalo"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["celebración", "moño", "obsequio", "presente", "regalo"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kingipakk"),
            keywords: &["karp", "kingipakk", "kink", "pakitud"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("paperez inguratutako oparia"),
            keywords: &[
                "inguratuta",
                "kaxa",
                "opari",
                "ospakizun",
                "paperez inguratutako oparia",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("هدیه\u{654} کادوشده"),
            keywords: &["جشن", "جعبه", "هدیه", "هدیه\u{654} کادوشده", "کادو"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("lahjapaketti"),
            keywords: &["juhla", "käärepaperi", "lahja", "lahjapaketti", "paketti"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("nakabalot na regalo"),
            keywords: &[
                "kahon",
                "nakabalot na regalo",
                "regalo",
                "ribbon",
                "selebrasyon",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("gáva"),
            keywords: &["gáva"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("cadeau"),
            keywords: &["anniversaire", "cadeau", "fête"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["anniversaire", "cadeau", "célébration", "fête", "présent"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("bronntanas"),
            keywords: &["beart", "breithlá", "bronntanas", "cóisir"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("prèasant paisgte"),
            keywords: &["bogsa", "comharrachadh", "paisgte", "prèasant", "tìodhlac"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("regalo"),
            keywords: &["aniversario", "festa", "lazo", "regalo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("વી\u{a82}ટ\u{ac7}લી સોગાદ"),
            keywords: &["ઉજવણી", "ભ\u{ac7}ટ", "વી\u{a82}ટ\u{ac7}લી", "સોગાદ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("naɗaɗɗiyar tsaraba"),
            keywords: &[
                "akwati",
                "kyauta",
                "naɗaɗɗe",
                "naɗaɗɗiyar tsaraba",
                "shagali",
                "tsaraba",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("קופסת מתנה"),
            keywords: &[
                "אריזה",
                "מסיבה",
                "מתנה",
                "עטוף",
                "קופסה",
                "קופסת מתנה",
                "שי",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("उपहार, प\u{948}क किया ह\u{941}आ उपहार"),
            keywords: &[
                "उपहार",
                "उपहार, प\u{948}क किया ह\u{941}आ उपहार",
                "गिफ\u{93c}\u{94d}ट",
                "प\u{948}क किया ह\u{941}आ उपहार",
                "लप\u{947}टा ह\u{941}आ",
                "समारोह",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("umotani poklon"),
            keywords: &[
                "dar",
                "kutija",
                "poklon",
                "slavlje",
                "umotani poklon",
                "umotano",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("becsomagolt ajándék"),
            keywords: &[
                "ajándék",
                "becsomagolt",
                "doboz",
                "ünnep",
                "ünnepi hangulat",
                "ünneplés",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("փաթեթավորված նվեր"),
            keywords: &["արկղ", "նվեր", "տոն", "փաթեթավորված"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kado"),
            keywords: &["bungkusan", "hadiah", "kado", "kotak", "perayaan"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("onyinye ekere èke"),
            keywords: &[
                "ekere èke",
                "enwemụaṅụrị",
                "igbe",
                "onyinye",
                "onyinye ekere èke",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("gjöf"),
            keywords: &["gjöf", "innpökkuð gjöf", "veisla"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("regalo"),
            keywords: &["dono", "festa", "pacchetto", "regalo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("プレゼント"),
            keywords: &["お祝い", "ギフト", "プレゼント", "箱"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kado dibungkus"),
            keywords: &["bingkisan", "dibungkus", "kado", "kothak", "perayaan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("შეფუთული საჩუქარი"),
            keywords: &[
                "აღნიშვნა",
                "ზეიმი",
                "საჩუქარი",
                "ყუთი",
                "შეფუთვა",
                "შეფუთული საჩუქარი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("оралған сыйлық"),
            keywords: &["жәшік", "оралған", "сыйлық", "тойлау"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("gave"),
            keywords: &["fødselsdag", "gave", "overraskelse", "pakke"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("កាដ\u{17bc}"),
            keywords: &[
                "កញ\u{17d2}ចប\u{17cb}",
                "កាដ\u{17bc}",
                "ការប\u{17d2}រារព\u{17d2}ធព\u{17b7}ធ\u{17b8}",
                "ប\u{17d2}រអប\u{17cb}",
                "អ\u{17c6}ណោយ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸುತ\u{ccd}ತಲ\u{ccd}ಪಟ\u{ccd}ಟ ಕಾಣ\u{cbf}ಕ\u{cc6}"),
            keywords: &[
                "ಆಚರಣ\u{cc6}",
                "ಕಾಣ\u{cbf}ಕ\u{cc6}",
                "ಸುತ\u{ccd}ತಲ\u{ccd}ಪಟ\u{ccd}ಟ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("선물"),
            keywords: &["선물", "선물 포장", "축하"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ग\u{941}ठलायिल\u{94d}ली भ\u{947}ट"),
            keywords: &[
                "ग\u{941}ठलायिल\u{94d}ली भ\u{947}ट",
                "ग\u{941}ठलायिल\u{94d}ल\u{947}\u{902}",
                "बॉक\u{94d}स",
                "भ\u{947}ट",
                "भ\u{947}टवस\u{94d}त\u{942}",
                "स\u{941}वाळो",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("оролгон белек"),
            keywords: &["белек", "куту", "майрам", "оролгон"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Kaddo"),
            keywords: &["Feier", "Geschenk", "Kaddo", "Këscht", "agepak"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ກ\u{ec8}ອງຂອງຂວ\u{eb1}ນ"),
            keywords: &["ກ\u{ec8}ອງ", "ກ\u{ec8}ອງຂອງຂວ\u{eb1}ນ", "ຂອງຂວ\u{eb1}ນ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("supakuota dovana"),
            keywords: &[
                "dovana",
                "dėžutė",
                "supakuota dovana",
                "suvyniota",
                "šventė",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("iesaiņota dāvana"),
            keywords: &["dāvana", "iesaiņot", "iesaiņota dāvana", "lente"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("perehana takai"),
            keywords: &["koha", "perehana", "pouaka", "takai", "whakanuinga"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("завиткан подарок"),
            keywords: &["завиткан", "кутија", "подарок", "прослава"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("സമ\u{d4d}മ\u{d3e}നപ\u{d4d}പൊതി"),
            keywords: &[
                "ആഘോഷം",
                "ഗിഫ\u{d4d}റ\u{d4d}റ\u{d4d}",
                "സമ\u{d4d}മ\u{d3e}നം",
                "സമ\u{d4d}മ\u{d3e}നപ\u{d4d}പൊതി",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("боолттой бэлэг"),
            keywords: &["баяр тэмдэглэх", "боолттой", "бэлэг", "хайрцаг"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("फितीन\u{947} ग\u{941}\u{902}डाळल\u{947}ली भ\u{947}टवस\u{94d}त\u{942}"),
            keywords: &[
                "उत\u{94d}सव",
                "ग\u{941}\u{902}डाळल\u{947}ल\u{947}",
                "फितीन\u{947} ग\u{941}\u{902}डाळल\u{947}ली भ\u{947}ट",
                "फितीन\u{947} ग\u{941}\u{902}डाळल\u{947}ली भ\u{947}टवस\u{94d}त\u{942}",
                "बॉक\u{94d}स",
                "भ\u{947}ट",
                "भ\u{947}टवस\u{94d}त\u{942}",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bungkusan hadiah"),
            keywords: &[
                "berbalut",
                "bungkusan hadiah",
                "hadiah",
                "kotak",
                "perayaan",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("rigal imgeżwer"),
            keywords: &[
                "kaxxa",
                "mgeżwra",
                "rigal",
                "rigal imgeżwer",
                "ċelebrazzjoni",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "ထ\u{102f}ပ\u{103a}ပ\u{102d}\u{102f}းထားသည\u{1037}\u{103a} လက\u{103a}ဆောင\u{103a}",
            ),
            keywords: &[
                "ထ\u{102f}ပ\u{103a}ပ\u{102d}\u{102f}း",
                "ထ\u{102f}ပ\u{103a}ပ\u{102d}\u{102f}းထားသည\u{1037}\u{103a} လက\u{103a}ဆောင\u{103a}",
                "ပ\u{103d}\u{1032}တော\u{103a}",
                "ဘ\u{1030}း",
                "လက\u{103a}ဆောင\u{103a}",
                "လက\u{103a}ဆောင\u{103a}ပေး",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("gave"),
            keywords: &[
                "bursdag",
                "feiring",
                "gave",
                "innpakket",
                "julegave",
                "presang",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("र\u{94d}\u{200d}यापरमा ब\u{947}रिएको उपहार"),
            keywords: &[
                "उपहार",
                "बक\u{94d}स",
                "र\u{94d}\u{200d}याप गरिएको",
                "र\u{94d}\u{200d}यापरमा ब\u{947}रिएको उपहार",
                "समारोह",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("ingepakt cadeau"),
            keywords: &["cadeau", "cadeautje", "feest", "ingepakt", "verpakking"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("gåve"),
            keywords: &[
                "bursdag",
                "feiring",
                "gåve",
                "innpakka",
                "julegåve",
                "presang",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଗ\u{b41}ଡ\u{b3e} ଯ\u{b3e}ଇଥ\u{b3f}ବ\u{b3e} ଉପହ\u{b3e}ର"),
            keywords: &[
                "ଉତ\u{b4d}ସବ",
                "ଉପହ\u{b3e}ର",
                "ଗ\u{b41}ଡ\u{b3e} ଯ\u{b3e}ଇଥ\u{b3f}ବ\u{b3e} ଉପହ\u{b3e}ର",
                "ବକ\u{b4d}ସ",
                "ବ\u{b3e}ହ\u{b4d}ୟ ଆବରଣ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪ\u{a48}ਕ ਕੀਤਾ ਤ\u{a4b}ਹਫ\u{a3c}ਾ"),
            keywords: &[
                "ਜਸ\u{a3c}ਨ",
                "ਤ\u{a4b}ਹਫ\u{a3c}ਾ",
                "ਪ\u{a48}ਕ ਕੀਤਾ ਤ\u{a4b}ਹਫ\u{a3c}ਾ",
                "ਲਪ\u{a47}ਟਿਆ",
                "ਲਪ\u{a47}ਟਿਆ ਉਪਹਾਰ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("لویٹیا تحفہ"),
            keywords: &[
                "تحفہ",
                "لویٹیا تحفہ",
                "لپیٹے ہوئے",
                "منانا",
                "موجودہ",
                "ڈبہ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Gift Wé Dẹm Ráp Wit Sọ\u{301}mtin"),
            keywords: &[
                "Bọks",
                "Gift",
                "Gift Wé Dẹm Ráp Wit Sọ\u{301}mtin",
                "Prẹ\u{301}sẹnt",
                "Rap",
                "Sẹlibréshọn",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("zapakowany prezent"),
            keywords: &[
                "kokarda",
                "kokardka",
                "paczka",
                "podarunek",
                "zapakowany prezent",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("بسته بندي شوې ډالۍ"),
            keywords: &["بسته بندي شوې ډالۍ", "بوکسه", "لمانځنه", "نغښتې", "ډالۍ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("presente"),
            keywords: &["comemoração", "embrulhado", "mimo", "presente"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("presente embrulhado"),
            keywords: &["caixa", "celebração", "embrulhado", "presente"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("pʼintusqa suña"),
            keywords: &["pʼintusqa suña", "p’intusqa", "raymi", "suña", "tawak’uchu"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("cadou împachetat"),
            keywords: &["cadou", "cadou împachetat", "cutie", "fundă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-326"),
            keywords: &["E10-326"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("подарок"),
            keywords: &["бантик", "дарить", "коробка", "подарок", "праздник"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("impano ifunitse"),
            keywords: &["akazu", "gifunitse", "ibirori", "impano", "impano ifunitse"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ويڙهيل تحفو"),
            keywords: &["ويڙهيل تحفو", "پيتي، جشن، تحفو، انعام، ويڙهيل"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ඔතන ලද තෑග\u{dca}ග"),
            keywords: &[
                "ඔතන ලද",
                "ඔතන ලද තෑග\u{dca}ග",
                "ත\u{dca}\u{200d}ය\u{dcf}ගය",
                "තෑග\u{dca}ග",
                "පෙට\u{dca}ට\u{dd2}ය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("zabalený darček"),
            keywords: &["balík", "dar", "darček", "oslava", "zabalený"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("zavito darilo"),
            keywords: &["dar", "darilo", "slavje", "zavito", "škatla"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("hadiyada duuban"),
            keywords: &[
                "dabaaldag",
                "duuban",
                "hadiyad",
                "hadiyada duuban",
                "imminka",
                "sanduuq",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("dhuratë e mbështjellë"),
            keywords: &["dhuratë", "dhuratë e mbështjellë", "festë", "kuti"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("упакован поклон"),
            keywords: &[
                "дар",
                "кутија",
                "поклон",
                "прослава",
                "умотано",
                "упакован поклон",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["упакован поклон"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("upakovan poklon"),
            keywords: &[
                "dar",
                "kutija",
                "poklon",
                "proslava",
                "umotano",
                "upakovan poklon",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["upakovan poklon"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("inslagen present"),
            keywords: &["fest", "gåva", "inslagen", "present"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("zawadi iliyofungwa"),
            keywords: &["iliyofungwa", "kusherehekea", "sanduku", "zawadi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மூடப\u{bcd}பட\u{bcd}ட பரிசு"),
            keywords: &[
                "கொண\u{bcd}ட\u{bbe}ட\u{bcd}டம\u{bcd}",
                "பரிசு",
                "மூடப\u{bcd}பட\u{bcd}ட பரிசு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("అలంక\u{c3e}ర క\u{c3e}గ\u{c3f}తంత\u{c4b} చుట\u{c4d}ట\u{c3f}న బహుమత\u{c3f}"),
            keywords: &[
                "అలంక\u{c3e}ర క\u{c3e}గ\u{c3f}తం చుట\u{c4d}ట\u{c3f}నద\u{c3f}",
                "అలంక\u{c3e}ర క\u{c3e}గ\u{c3f}తంత\u{c4b} చుట\u{c4d}ట\u{c3f}న బహుమత\u{c3f}",
                "బహుమత\u{c3f}",
                "వ\u{c47}డుక",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("туҳфаи печондашуда"),
            keywords: &[
                "печондашуда",
                "туҳфа",
                "туҳфаи печондашуда",
                "қуттӣ",
                "ҷашн",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ของขว\u{e31}ญ"),
            keywords: &["ของขว\u{e31}ญ", "ของขว\u{e31}ญในกล\u{e48}อง"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("dolanylgy sowgat"),
            keywords: &[
                "baýramçylyk",
                "dolanan",
                "dolanylgy sowgat",
                "guty",
                "sowgat",
                "ýadygärlik",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("lipine puha"),
            keywords: &["lipine puha"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("paketlenmiş hediye"),
            keywords: &["kutlama", "paketlenmiş hediye", "paketli", "paketli hediye"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئوراق سوۋغات"),
            keywords: &[
                "ئوراق سوۋغات",
                "بولاق",
                "تەبرىكلەش",
                "سوۋغات",
                "قاپ",
                "قۇتا",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("подарунок"),
            keywords: &[
                "дарунок",
                "запакований",
                "коробка",
                "подарунок",
                "святкування",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کاغذ میں لپٹا تحفہ"),
            keywords: &[
                "تحفہ",
                "جشن",
                "لپٹا ہوا",
                "کاغذ میں لپٹا تحفہ",
                "کاغذ میں لیٹا تحفہ",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("o‘ralgan sovg‘a"),
            keywords: &["bayram", "o‘ralgan", "quri", "sovg‘a"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("gói quà"),
            keywords: &["gói quà", "hộp", "lễ kỷ niệm", "quà", "quà tặng"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kado buñ ëmb"),
            keywords: &["boyet", "kado", "kado buñ ëmb", "màggal", "neexal", "ëmb"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isipho esibotshiweyo"),
            keywords: &[
                "ebotshiweyo",
                "ibhokisi",
                "isipho",
                "isipho esibotshiweyo",
                "umbhiyozo",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ẹbun Didi"),
            keywords: &["ayẹyẹ", "wépọ\u{300}", "àpótí", "Ẹbun Didi", "ẹ\u{300}bùn"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("禮物"),
            keywords: &["包裝", "慶祝", "盒", "禮物", "送禮"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("礼物"),
            keywords: &["包装", "庆祝", "盒", "礼物", "送礼"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("礼物"),
            keywords: &["包装", "庆祝", "盒子", "礼品", "礼物"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("禮物"),
            keywords: &["慶祝", "禮物", "禮盒"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isipho esigoqiwe"),
            keywords: &[
                "ibhokisi",
                "iprezenti",
                "isipho",
                "isipho esigoqiwe",
                "okugoqiwe",
                "umbungazo",
            ],
        },
    ],
};
#[doc = "🎗\u{fe0f}"]
pub const REMINDER_RIBBON: crate::Emoji = crate::Emoji {
    glyph: "🎗\u{fe0f}",
    codepoint: "1F397 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "reminder ribbon",
    group: "Activities",
    subgroup: "event",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🎗",
        codepoint: "1F397",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "reminder ribbon",
        group: "Activities",
        subgroup: "event",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("herinneringslint"),
            keywords: &["herinner", "herinneringslint", "lint", "viering"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የመታሰቢያ ሪባን"),
            keywords: &["ሪባን", "አስታዋሽ", "ክብረ በዓል", "የመታሰቢያ ሪባን"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("شريطة تذكير"),
            keywords: &["احتفال", "تذكير", "شريطة تذكير"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("স\u{9cd}ম\u{9be}ৰক ফিট\u{9be}"),
            keywords: &["উদয\u{9be}পন", "ফিট\u{9be}", "স\u{9cd}ম\u{9be}ৰক"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("xatırlatma lenti"),
            keywords: &["bayram", "lent", "xatırlatma", "xatırlatma lenti"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("памятная стужка"),
            keywords: &["напамін", "памятная стужка", "свята", "стужка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("лента за напомняне"),
            keywords: &[
                "Лента за напомняне",
                "лента",
                "лента за напомняне",
                "напомняне",
                "празнуване",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("অন\u{9c1}স\u{9cd}ম\u{9be}রক রিবন"),
            keywords: &[
                "অন\u{9c1}স\u{9cd}ম\u{9be}রক",
                "অন\u{9c1}স\u{9cd}ম\u{9be}রক রিবন",
                "উদয\u{9be}পন",
                "ফিত\u{9be}",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("seizenn-goun"),
            keywords: &["fest", "gouel", "seizenn-goun"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("simbolična traka"),
            keywords: &["počast", "proslava", "simbolična traka"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("llaç commemoratiu"),
            keywords: &["celebració", "cinta", "commemorar", "llaç commemoratiu"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏅᏓᏗᏍᏙᏗ ᎠᏇᏡᏍᏗ"),
            keywords: &["ᎠᎾᎵᎮᎵᏍᏗᏍᎬᎢ", "ᎠᏅᏓᏗᏍᏙᏗ", "ᎠᏇᏡᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("symbolická stužka"),
            keywords: &[
                "angažovanost",
                "kauza",
                "mašle",
                "oslava",
                "památka",
                "podpora",
                "připomínka",
                "symbol",
                "symbolická stužka",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("rhuban atgoffa"),
            keywords: &["atgoffa", "dathliad", "rhuban"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("mindebånd"),
            keywords: &["bånd", "fejring", "minde", "mindebånd"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Gedenkschleife"),
            keywords: &["Gedenkschleife", "Schleife"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κορδέλα τιμής"),
            keywords: &["γιορτή", "κορδέλα", "κορδέλα τιμής", "υπενθύμιση"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("reminder ribbon"),
            keywords: &["celebration", "reminder", "ribbon"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["awareness ribbon", "celebration", "reminder", "ribbon"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("lazo conmemorativo"),
            keywords: &["conmemorativo", "lazo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("cinta conmemorativa"),
            keywords: &["cinta", "cinta conmemorativa", "conmemoración"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kollane lint"),
            keywords: &["kollane", "lint"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("xingola"),
            keywords: &["gogorarazle", "ospakizun", "xingola"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("روبان یادآوری"),
            keywords: &["جشن", "روبان", "یادآوری"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("tietoisuusnauha"),
            keywords: &[
                "merkkipäivä",
                "muistutus",
                "nauha",
                "tietoisuus",
                "tietoisuusnauha",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("nagpapaalalang ribbon"),
            keywords: &[
                "laso",
                "nagpapaalalang ribbon",
                "paalala",
                "reminder ribbon",
                "ribbon",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("eftirtektarband"),
            keywords: &["band", "eftirtekt", "eftirtektarband"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("ruban de mémoire"),
            keywords: &["ruban", "ruban de mémoire"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("ruban commémoratif"),
            keywords: &["commémoratif", "ruban", "souvenir"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("ribín cuimhneacháin"),
            keywords: &["ceiliúradh", "cuimhneachán", "ribín", "ribín cuimhneacháin"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("ribean cuimhneachaidh"),
            keywords: &[
                "comharrachadh",
                "cuimhneachan",
                "ribean",
                "ribean cuimhneachaidh",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("lazo conmemorativo"),
            keywords: &["conmemoración", "lazo", "lazo conmemorativo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("રિમાઇન\u{acd}ડર રિબન"),
            keywords: &["ઉજવણી", "રિબન", "રિમાઇન\u{acd}ડર"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("ribon na tunatarwa"),
            keywords: &["ribon", "ribon na tunatarwa", "shagali", "tunatarwa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סרט הזדהות"),
            keywords: &["זיכרון", "סרט הזדהות"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("रिमाइ\u{902}डर रिबन"),
            keywords: &["उत\u{94d}सव", "रिमाइ\u{902}डर रिबन"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("spomen-traka"),
            keywords: &["podsjetnik", "slavlje", "spomen", "spomen-traka", "traka"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("emlékező szalag"),
            keywords: &["emlékezés", "emlékező szalag", "megemlékezés", "szalag"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("հուշաժապավեն"),
            keywords: &["ժապավեն", "հուշ", "հուշաժապավեն", "տոն"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("pita pengingat"),
            keywords: &["pengingat", "perayaan", "pita"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihe ncheta ribọn"),
            keywords: &["enwemụaṅụrị", "ihe ncheta", "ihe ncheta ribọn", "ribọn"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("minnisvarðaborði"),
            keywords: &["borði", "fagnaður", "minnisvarðaborði", "minnisvarði"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("nastro"),
            keywords: &["festa", "festeggiamenti", "fiocco", "nastro", "nodo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("リマインダーリボン"),
            keywords: &["お祝い", "リボン", "リマインダー", "リマインダーリボン"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("pita pangeling"),
            keywords: &["pangeling", "perayaan", "pita"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("შემხსენებელი ლენტი"),
            keywords: &[
                "აღნიშვნა",
                "ზეიმი",
                "ლენტი",
                "შემხსენებელი ლენტი",
                "შეხსენება",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("еске салғыш таспасы"),
            keywords: &["еске салғыш", "еске салғыш таспасы", "таспа", "тойлау"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("mindebånd"),
            keywords: &["bånd", "fejring", "minde", "mindebånd"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17bc}រ\u{17c6}ល\u{17b9}កទ\u{17b7}វាអ\u{17d2}វ\u{17b8}ម\u{17bd}យ"),
            keywords: &[
                "ទ\u{17b7}វា",
                "ប\u{17bc}",
                "ប\u{17bc}រ\u{17c6}ល\u{17b9}កទ\u{17b7}វាអ\u{17d2}វ\u{17b8}ម\u{17bd}យ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಜ\u{ccd}ಞಾಪನ\u{cc6}ಯ ರ\u{cbf}ಬ\u{ccd}ಬನ\u{ccd}"),
            keywords: &[
                "ಜ\u{ccd}ಞಾಪನ\u{cc6}ಯ ರ\u{cbf}ಬ\u{ccd}ಬನ\u{ccd}",
                "ಪದಕ",
                "ಮ\u{cc6}ಡಲ\u{ccd}",
                "ರ\u{cbf}ಬ\u{ccd}ಬನ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("추모 리본"),
            keywords: &["기념", "리본", "추모"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("स\u{94d}मरण रिबीन"),
            keywords: &["रिबीन", "स\u{941}वाळो", "स\u{94d}मरण"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("эскерүү лентасы"),
            keywords: &[
                "лента",
                "майрам",
                "эскерүү лентасы",
                "эстеткич",
                "эстетүүчү лента",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Commemoratiounsband"),
            keywords: &[
                "Band",
                "Commemoratioun",
                "Commemoratiounsband",
                "Erënnerung",
                "Feier",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໂບລະນ\u{eb6}ກ"),
            keywords: &["ລະນ\u{eb6}ກ", "ໂບ", "ໂບລະນ\u{eb6}ກ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("atminimo kaspinas"),
            keywords: &["atminimo kaspinas", "kaspinas", "priminimas", "šventė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("atceres lentīte"),
            keywords: &["atcere", "atceres lentīte", "lente", "piemiņa", "svētki"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("rīpene whakamahara"),
            keywords: &["rīpene", "whakamahara", "whakanuinga"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("панделка за сеќавање"),
            keywords: &["панделка", "панделка за сеќавање", "прослава", "сеќавање"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("റിമൈൻഡർ റിബൺ"),
            keywords: &["ആഘോഷം", "റിബ\u{d4d}ബൺ", "റിമൈൻഡർ", "റിമൈൻഡർ റിബൺ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("дурсгалын тууз"),
            keywords: &["баяр тэмдэглэх", "дурсгал", "дурсгалын тууз", "тууз"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("स\u{94d}मरण कर\u{942}न द\u{947}णारी फित"),
            keywords: &[
                "उत\u{94d}सव",
                "फित",
                "स\u{94d}मरण कर\u{942}न द\u{947}णारी फित",
                "स\u{94d}मरणपत\u{94d}र",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("reben peringatan"),
            keywords: &["perayaan", "peringatan", "reben"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("żigarella ta’ tfakkira"),
            keywords: &[
                "tfakkira",
                "ċelebrazzjoni",
                "żigarella",
                "żigarella ta’ tfakkira",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အောက\u{103a}မေ\u{1037}ဖ\u{103d}ယ\u{103a} ဖ\u{1032}ကြ\u{102d}\u{102f}း"),
            keywords: &[
                "ပ\u{103d}\u{1032}တော\u{103a}",
                "ဖ\u{1032}ကြ\u{102d}\u{102f}း",
                "သတ\u{102d}ပေး",
                "အောက\u{103a}မေ\u{1037}ဖ\u{103d}ယ\u{103a} ဖ\u{1032}ကြ\u{102d}\u{102f}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("minnesløyfe"),
            keywords: &["bånd", "feiring", "minne", "minnesløyfe", "påminnelse"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("रिमाइन\u{94d}डर रिबन"),
            keywords: &["रिबन", "रिमाइन\u{94d}डर", "समारोह"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("bewustzijnslintje"),
            keywords: &["bewustzijnslintje", "herinnering", "lintje", "viering"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("minnesløyfe"),
            keywords: &["band", "feiring", "minne", "minnesløyfe", "påminning"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସ\u{b4d}ମ\u{b3e}ରକ ର\u{b3f}ବନ\u{b4d}\u{200d}"),
            keywords: &[
                "ଉତ\u{b4d}ସବ",
                "ର\u{b3f}ବନ\u{b4d}\u{200c}",
                "ସ\u{b4d}ମ\u{b3e}ରକ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਯਾਦ-ਦਹਾਨੀ ਰਿਬਨ"),
            keywords: &["ਜਸ\u{a3c}ਨ", "ਯਾਦ-ਦਹਾਨੀ", "ਰਿਬਨ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("یاد دہانی دا فیتہ"),
            keywords: &["فیتہ", "منانا", "یاد دہانی", "یاد دہانی دا فیتہ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Ríbọn To Ték Shó Sọpọt Fọ Sọ\u{301}mtin Ọ Grup"),
            keywords: &[
                "Rimaínda",
                "Ríbọn",
                "Ríbọn To Ték Shó Sọpọt Fọ Sọ\u{301}mtin Ọ Grup",
                "Sẹlibréshọn",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("wstążka pamięci"),
            keywords: &["upamiętnić", "uroczystość", "wstążka", "wstążka pamięci"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د یادونې پټۍ"),
            keywords: &["د یادونې پټۍ", "رايادونه", "لمانځنه", "پټۍ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("fita de lembrete"),
            keywords: &[
                "celebração",
                "comemoração",
                "fita de lembrete",
                "laço",
                "lembrete",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("laço de solidariedade"),
            keywords: &[
                "celebração",
                "laço",
                "laço de solidariedade",
                "solidariedade",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("yuyarinapaq cinta"),
            keywords: &["cinta", "raymi", "yuyarinapaq"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("panglică „in memoriam”"),
            keywords: &[
                "comemorare",
                "panglică",
                "panglică „in memoriam”",
                "susținere",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-346"),
            keywords: &["E10-346"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("памятная лента"),
            keywords: &["лента", "памятная лента", "память"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("riba y’inyibutsa"),
            keywords: &["ibirori", "inyibutsa", "riba", "riba y’inyibutsa"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ياد ڏياريندڙ ڏوري"),
            keywords: &["جشن، ياد ڏياريندڙ، ڏوري", "ياد ڏياريندڙ ڏوري"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("මතක\u{dca} ක\u{dd2}ර\u{dd3}මේ ප\u{dd3}ත\u{dca}ත පට\u{dd2}ය"),
            keywords: &[
                "උත\u{dca}සවය",
                "ප\u{dd3}ත\u{dca}ත පට\u{dd2}ය",
                "මතක\u{dca} ක\u{dd2}ර\u{dd3}මේ",
                "මතක\u{dca} ක\u{dd2}ර\u{dd3}මේ ප\u{dd3}ත\u{dca}ත පට\u{dd2}ය",
                "ස\u{dd2}හ\u{dd2}කැඳව\u{dd3}ම",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("stužka"),
            keywords: &["oslava", "pripomienka", "stužka"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("simbolna pentlja"),
            keywords: &["pentlja", "simbol", "simbolna pentlja", "slavje"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("xabo xasuusin"),
            keywords: &["celeberation", "xabo", "xasuusin"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fjongo kujtese"),
            keywords: &["festim", "festë", "fjongo", "fjongo kujtese", "kujtesë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("спомен-трака"),
            keywords: &["пoдсeтник", "прослава", "спомен-трака", "трaкa"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["спомен-трака"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("spomen-traka"),
            keywords: &["podsetnik", "proslava", "spomen-traka", "traka"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["spomen-traka"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("påminnelseband"),
            keywords: &["band", "firande", "påminnelseband"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("utepe wa ukumbusho"),
            keywords: &["kikumbusho", "kusherehekea", "utepe", "utepe wa ukumbusho"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ரிமைன\u{bcd}டர\u{bcd} ரிப\u{bcd}பன\u{bcd}"),
            keywords: &[
                "சிறப\u{bcd}பித\u{bcd}தல\u{bcd}",
                "ரிப\u{bcd}பன\u{bcd}",
                "ரிமைன\u{bcd}டர\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ర\u{c3f}మ\u{c48}ండర\u{c4d} ర\u{c3f}బ\u{c4d}బన\u{c4d}"),
            keywords: &[
                "ర\u{c3f}బ\u{c4d}బన\u{c4d}",
                "ర\u{c3f}మ\u{c48}ండర\u{c4d}",
                "వ\u{c47}డుక",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("лентаи ёдрасон"),
            keywords: &["лента", "лентаи ёдрасон", "ёдрасон", "ҷашн"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ร\u{e34}บบ\u{e34}\u{e49}นรำล\u{e36}ก"),
            keywords: &[
                "รณรงค\u{e4c}",
                "รำล\u{e36}ก",
                "ร\u{e34}บบ\u{e34}\u{e49}น",
                "ร\u{e34}บบ\u{e34}\u{e49}นรำล\u{e36}ก",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("hatyra lenta"),
            keywords: &["baýramçylyk", "hatyra", "lenta"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("lipine fakamanatu"),
            keywords: &["lipine fakamanatu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("anma kurdelesi"),
            keywords: &["anma", "anma kurdelesi", "kurdele", "kutlama"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئەسلەش لېنتىسى"),
            keywords: &["ئاگاھلاندۇرۇش", "ئەسلەش لېنتىسى", "تەبرىكلەش", "لېنتا"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("стрічка на згадку"),
            keywords: &["пам’ятний", "святкування", "стрічка", "стрічка на згадку"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("یاددہانی کا ربن"),
            keywords: &["جشن", "ربن", "یاددہانی", "یاددہانی کا ربن"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("eslatma lentasi"),
            keywords: &["bayram", "eslatma", "eslatma lentasi", "lenta"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("ruy băng nhắc nhở"),
            keywords: &["lễ kỷ niệm", "lời nhắc", "ruy băng", "ruy băng nhắc nhở"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("ribaŋu fàttalikaay"),
            keywords: &["fàttalikaay", "màggal", "ribaŋ", "ribaŋu fàttalikaay"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iribhoni yesikhumbuzi"),
            keywords: &[
                "iribhoni",
                "iribhoni yesikhumbuzi",
                "isikhumbizi",
                "umbhiyozo",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ríbínì ìránilétí"),
            keywords: &["ayẹyẹ", "ríbínì", "ìránilétí"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("紀念絲帶"),
            keywords: &["慶祝", "紀念", "紀念絲帶", "絲帶"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("纪念丝带"),
            keywords: &["丝带", "庆祝", "纪念", "纪念丝带"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("提示丝带"),
            keywords: &["丝带", "庆祝", "提示丝带", "暗示"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("黃絲帶"),
            keywords: &["絲帶", "黃絲帶"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["意識絲帶", "提醒絲帶", "支持絲帶", "絲帶", "黃絲帶"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("iribhini yesikhumbuzo"),
            keywords: &[
                "iribhini",
                "iribhini yesikhumbuzo",
                "isikhumbuzo",
                "umbungazo",
            ],
        },
    ],
};
#[doc = "🎟\u{fe0f}"]
pub const ADMISSION_TICKETS: crate::Emoji = crate::Emoji {
    glyph: "🎟\u{fe0f}",
    codepoint: "1F39F FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "admission tickets",
    group: "Activities",
    subgroup: "event",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🎟",
        codepoint: "1F39F",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "admission tickets",
        group: "Activities",
        subgroup: "event",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("toegangskaartjie"),
            keywords: &["kaartjie", "toegang", "toegangskaartjie"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የመግቢያ ትኬቶች"),
            keywords: &["መግቢያ ፈቃድ", "ትኬት", "የመግቢያ ትኬቶች"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("تذكرتا دخول"),
            keywords: &["تذكرة", "تذكرتا دخول", "دخول", "قبول"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("প\u{9cd}ৰবেশ টিকট"),
            keywords: &["টিকট", "প\u{9cd}ৰবেশ", "প\u{9cd}ৰবেশ টিকটবোৰ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("giriş biletləri"),
            keywords: &["bilet", "giriş biletləri", "giriş haqqı"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("уваходныя білеты"),
            keywords: &["білет", "уваход", "уваходныя білеты"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("билети за вход"),
            keywords: &["Билети за вход", "билет", "билети за вход", "вход"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("প\u{9cd}রবেশের টিকিট"),
            keywords: &["টিকেট", "প\u{9cd}রবেশ", "প\u{9cd}রবেশের টিকিট"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("bilhed mont e-barzh"),
            keywords: &["bilhed", "bilhed mont e-barzh"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("ulaznica"),
            keywords: &["karta", "ulaznica"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("bitllet d’entrada"),
            keywords: &[
                "accés",
                "admissió",
                "bitllet",
                "bitllet d’entrada",
                "entrada",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏈᏴᏙᏗ ᎪᏪᎵ"),
            keywords: &["ᎠᏈᏴᏙᏗ", "ᎪᏪᎵ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("vstupenky"),
            keywords: &["lístek", "vstupenka", "vstupenky"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("tocynnau mynediad"),
            keywords: &["mynediad", "tocyn", "tocynnau mynediad"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("adgangsbillet"),
            keywords: &["adgang", "adgangsbillet", "billet", "entré", "entrébillet"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Eintrittskarten"),
            keywords: &["Eintrittskarten", "Ticket"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κάρτες εισόδου"),
            keywords: &["είσοδος", "εισιτήριο", "κάρτες εισόδου"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("admission tickets"),
            keywords: &["admission", "admission tickets", "ticket"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["admission", "admission tickets", "entry", "ticket"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("entradas"),
            keywords: &["acceso", "admisión", "entrada", "entradas", "evento"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["entradas", "evento"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("boleto de entrada"),
            keywords: &["boleto de entrada"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("piletid"),
            keywords: &["pilet", "piletid", "sissepääs"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("sarrera-txartelak"),
            keywords: &["sarbide", "sarrera", "sarrera-txartelak", "txartel"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("بلیت ورود"),
            keywords: &["بلیت", "بلیط", "ورود", "ورودی", "ورودیه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("pääsylippu"),
            keywords: &["lippu", "pääsylippu", "sisäänpääsylippu"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("mga admission ticket"),
            keywords: &["mga admission ticket", "ticket"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("atgongumerki"),
            keywords: &["atgongd", "atgongukort", "atgongumerki", "kort", "merki"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("billet d’entrée"),
            keywords: &["billet d’entrée", "spectacle"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("billets d’entrée"),
            keywords: &["billet", "billets d’entrée", "entrée", "spectacle"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("ticéid cead isteach"),
            keywords: &["cead isteach", "ticéad", "ticéid cead isteach"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("ticeadan inntrigidh"),
            keywords: &[
                "bileag",
                "cairt-fharaidh",
                "cead a-steach",
                "inntrigeadh",
                "ticead",
                "ticeadan inntrigidh",
                "ticeard",
                "ticeid",
                "tiocaid",
                "tiogaid",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("entradas"),
            keywords: &["entrada", "entradas", "espectáculo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પ\u{acd}રવ\u{ac7}શ ટિકિટ"),
            keywords: &["ટિકિટ", "પ\u{acd}રવ\u{ac7}શ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("shigarwa"),
            keywords: &["shigarwa", "tikiti"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("כרטיס כניסה"),
            keywords: &["כניסה", "כרטיס"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("प\u{94d}रव\u{947}श टिकट, टिकट"),
            keywords: &[
                "टिकट",
                "प\u{94d}रव\u{947}श टिकट",
                "प\u{94d}रव\u{947}श टिकट, टिकट",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("ulaznice"),
            keywords: &["ulaz", "ulaznica", "ulaznice"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("belépőjegyek"),
            keywords: &["belépő", "belépőjegyek", "jegy"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մուտքի տոմս"),
            keywords: &["մուտք", "մուտքի տոմս", "տոմս"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tiket masuk"),
            keywords: &["masuk", "tiket"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("tiketi nnabata gasị"),
            keywords: &["nnabata", "tiketi", "tiketi nnabata gasị"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("aðgöngumiðar"),
            keywords: &["aðgangseyrir", "aðgöngumiðar", "miði"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("biglietto d’ingresso"),
            keywords: &[
                "biglietto",
                "biglietto d’ingresso",
                "cinema",
                "ingresso",
                "spettacolo",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("入場券"),
            keywords: &["チケット", "入場パス", "入場券", "半券"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tiket mlebu"),
            keywords: &["mlebu", "tiket"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ბილეთები"),
            keywords: &["ბილეთები", "ბილეთი", "შესვლა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қабылдау билеттері"),
            keywords: &["билет", "қабылдау", "қабылдау билеттері"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("adgangsbillet"),
            keywords: &["adgang", "adgangsbillet", "billet"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ស\u{17c6}ប\u{17bb}ត\u{17d2}រច\u{17bc}លរ\u{17bd}ម"),
            keywords: &[
                "ស\u{17c6}ប\u{17bb}ត\u{17d2}រ",
                "ស\u{17c6}ប\u{17bb}ត\u{17d2}រច\u{17bc}លរ\u{17bd}ម",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪ\u{ccd}ರವೇಶ ಟ\u{cbf}ಕ\u{cc6}ಟ\u{ccd}\u{200c}ಗಳು"),
            keywords: &[
                "ಪ\u{ccd}ರವೇಶ",
                "ಪ\u{ccd}ರವೇಶ ಟ\u{cbf}ಕ\u{cc6}ಟ\u{ccd}\u{200c}ಗಳು",
                "ಪ\u{ccd}ರವೇಶ ಟ\u{cbf}ಕೇಟು\u{200c}ಗಳು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("입장 티켓"),
            keywords: &["입장", "티켓"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("प\u{94d}रव\u{947}श तिक\u{947}टी"),
            keywords: &[
                "तिक\u{947}ट",
                "प\u{94d}रव\u{947}श",
                "प\u{94d}रव\u{947}श तिक\u{947}टी",
                "प\u{94d}रव\u{947}शाच\u{94d}यो तिक\u{947}टी",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кирүү билети"),
            keywords: &["билет", "кирүү", "кирүү билети"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Entréesticket"),
            keywords: &["Billjee", "Entrée", "Entréesticket", "Ticket"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ປ\u{eb5}\u{ec9}ເຂ\u{ebb}\u{ec9}າຊ\u{ebb}ມ"),
            keywords: &[
                "ປ\u{eb5}\u{ec9}ເຂ\u{ebb}\u{ec9}າຊ\u{ebb}ມ",
                "ຮ\u{eb9}ບເງ\u{ebb}າ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("įėjimo bilietai"),
            keywords: &["bilietas", "įėjimas", "įėjimo bilietai"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("ieejas biļetes"),
            keywords: &["biļete", "ieeja", "ieejas biļetes"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tīkiti tomonga"),
            keywords: &["tīkiti", "tīkiti tomonga", "whakatomo"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("влезни билети"),
            keywords: &["билет", "влез", "влезни билети"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("അഡ\u{d4d}\u{200c}മിഷൻ ടിക\u{d4d}കറ\u{d4d}റ\u{d41}കൾ"),
            keywords: &[
                "അഡ\u{d4d}\u{200c}മിഷൻ",
                "അഡ\u{d4d}\u{200c}മിഷൻ ടിക\u{d4d}കറ\u{d4d}റ\u{d41}കൾ",
                "ടിക\u{d4d}കറ\u{d4d}റ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("орох тасалбар"),
            keywords: &["орох", "тасалбар"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("प\u{94d}रव\u{947}शाची तिकिट\u{947}"),
            keywords: &[
                "तिकिट",
                "प\u{94d}रव\u{947}श",
                "प\u{94d}रव\u{947}शाची तिकिट\u{947}",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("tiket masuk"),
            keywords: &["masuk", "tiket"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("biljetti tad-dħul"),
            keywords: &["biljett", "biljetti tad-dħul", "dħul"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဝင\u{103a}ခ\u{103d}င\u{1037}\u{103a} လက\u{103a}မ\u{103e}တ\u{103a}များ"),
            keywords: &[
                "လက\u{103a}မ\u{103e}တ\u{103a}",
                "ဝင\u{103a}ခ\u{103d}င\u{1037}\u{103a}",
                "ဝင\u{103a}ခ\u{103d}င\u{1037}\u{103a} လက\u{103a}မ\u{103e}တ\u{103a}များ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("inngangsbilletter"),
            keywords: &["adgang", "billett", "inngang", "inngangsbilletter"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("प\u{94d}रव\u{947}श टिकटहर\u{942}"),
            keywords: &[
                "टिकट",
                "प\u{94d}रव\u{947}श",
                "प\u{94d}रव\u{947}श टिकटहर\u{942}",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("entreekaartjes"),
            keywords: &["entree", "entreekaartjes", "kaartje"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("inngangsbillettar"),
            keywords: &["billett", "inngang", "inngangsbillettar", "tilgang"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଆଡମ\u{b3f}ସନ\u{b4d} ଟ\u{b3f}କେଟ\u{b4d}\u{200d}ଗ\u{b41}ଡ\u{b3c}\u{b3f}କ"),
            keywords: &[
                "ଆଡମ\u{b3f}ସନ\u{b4d} । ଟ\u{b3f}କେଟ\u{b4d}\u{200d}",
                "ଆଡମ\u{b3f}ସନ\u{b4d} । ଟ\u{b3f}କେଟ\u{b4d}\u{200d}ଗ\u{b41}ଡ\u{b3c}\u{b3f}କ",
                "ଆଡମ\u{b3f}ସନ\u{b4d} ଟ\u{b3f}କେଟ\u{b4d}\u{200d}ଗ\u{b41}ଡ\u{b3c}\u{b3f}କ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਦਾਖਲਾ ਟਿਕਟਾ\u{a02}"),
            keywords: &["ਟਿਕਟ", "ਦਾਖਲ ਹ\u{a4b}ਣਾ", "ਦਾਖਲਾ", "ਦਾਖਲਾ ਟਿਕਟਾ\u{a02}"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("داخلے دیاں ٹکٹاں"),
            keywords: &["داخلہ", "داخلے دیاں ٹکٹاں", "ٹکٹ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Tíkẹt-dẹm To Gẹ\u{301}t Rait To Ẹ\u{301}ntá Sọm Ples"),
            keywords: &[
                "Admíshọ\u{301}n Tíkẹt-dẹm",
                "Tíkẹt",
                "Tíkẹt-dẹm To Gẹ\u{301}t Rait To Ẹ\u{301}ntá Sọm Ples",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("bilety wstępu"),
            keywords: &["bilet", "bilety wstępu", "wstęp"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د داخلې ټکټونه"),
            keywords: &["د داخلې ټکټونه", "داخله", "ټکټ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("ingresso de cinema"),
            keywords: &["entrada", "ingresso", "ingresso de cinema"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("bilhetes"),
            keywords: &["bilhete", "bilhetes", "entrada"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("uyakuynin boletokunapaq"),
            keywords: &["boleto", "uyakuynin", "uyakuynin boletokunapaq"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("bilete de intrare"),
            keywords: &["acces", "bilet", "bilete de intrare", "intrare"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-351"),
            keywords: &["E10-351"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("билеты"),
            keywords: &["билет", "билеты", "вход", "концерт", "театр"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("amatike yo kwemererwa"),
            keywords: &["amatike yo kwemererwa", "itike", "kwemererwa"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("داخلا ٽڪيٽ"),
            keywords: &["داخل، ٽڪيٽ", "داخلا ٽڪيٽ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ඇත\u{dd4}ළත\u{dca} ව\u{dd3}මේ ට\u{dd2}කට\u{dca} පත\u{dca}"),
            keywords: &[
                "අැත\u{dd4}ළත\u{dca} ව\u{dd3}ම",
                "ඇත\u{dd4}ළත\u{dca} ව\u{dd3}මේ ට\u{dd2}කට\u{dca} පත\u{dca}",
                "ට\u{dd2}කට\u{dca} පත",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("vstupenky"),
            keywords: &["lístok", "vstupenka", "vstupenky"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("vstopnice"),
            keywords: &["vstopnica", "vstopnice", "vstopnina"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("tikidka diiwaangelinta"),
            keywords: &[
                "diiwaan gelin",
                "tikid",
                "tikidka diiwaan gelinta",
                "tikidka diiwaangelinta",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("biletat e hyrjes"),
            keywords: &["biletat e hyrjes", "biletë", "hyrje"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("улазнице"),
            keywords: &["улaз", "улaзницa", "улазнице"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("ulaznice"),
            keywords: &["ulaz", "ulaznica", "ulaznice"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("inträdesbiljetter"),
            keywords: &["biljett", "inträde", "inträdesbiljetter"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("tiketi za kuingia"),
            keywords: &["kuingia", "tiketi", "tiketi za kuingia"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("அட\u{bcd}மிஷன\u{bcd} டிக\u{bcd}கெட\u{bcd}டுகள\u{bcd}"),
            keywords: &[
                "அட\u{bcd}மிஷன\u{bcd} டிக\u{bcd}கெட\u{bcd}டுகள\u{bcd}",
                "நுழைவு டிக\u{bcd}கெட\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ప\u{c4d}రవ\u{c47}శ ట\u{c3f}క\u{c4d}క\u{c46}ట\u{c4d}\u{200c}లు"),
            keywords: &[
                "ట\u{c3f}క\u{c4d}క\u{c46}ట\u{c4d}",
                "ప\u{c4d}రవ\u{c47}శ ట\u{c3f}క\u{c4d}క\u{c46}ట\u{c4d}\u{200c}లు",
                "ప\u{c4d}రవ\u{c47}శం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("чиптаҳои қабул"),
            keywords: &["чипта", "чиптаҳои қабул", "қабул"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ต\u{e31}\u{e4b}วเข\u{e49}าชม"),
            keywords: &[
                "ต\u{e31}\u{e4b}ว",
                "ต\u{e31}\u{e4b}วเข\u{e49}าชม",
                "เข\u{e49}าชมงาน",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("giriş petekleri"),
            keywords: &["giriş", "giriş petekleri", "petek"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tikite fakahū"),
            keywords: &["tikite fakahū"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("giriş bileti"),
            keywords: &["bilet", "giriş", "giriş bileti"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قوبۇللاش بېلىتى"),
            keywords: &["بېلەت", "قوبۇل", "قوبۇللاش بېلىتى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("вхідні квитки"),
            keywords: &["вхідний", "вхідні квитки", "квиток"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("داخلہ ٹکٹ"),
            keywords: &["داخلہ", "ٹکٹ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kirish chiptalari"),
            keywords: &["chipta", "kirish", "kirish chiptalari"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("vé vào cửa"),
            keywords: &["vào cửa", "vé", "vé vào cửa"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("biye dugg"),
            keywords: &["biye", "dugg"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("itikiti lamangeno"),
            keywords: &["itikiti", "itikiti lamangeno", "ungeno"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("àwọn ìwọlé ìgbaniwọlé"),
            keywords: &["àwọn ìwọlé ìgbaniwọlé", "ìgbaniwọlé", "ìwọlé"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("入場券"),
            keywords: &["入場", "入場券", "券"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("入场券"),
            keywords: &["入场", "入场券", "券"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("入场券"),
            keywords: &["入场券", "票", "门票"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("入場券"),
            keywords: &["入場券", "票券"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("amathikithi okungena"),
            keywords: &["amathikithi", "amathikithi okungena", "ukungena"],
        },
    ],
};
#[doc = "🎫"]
pub const TICKET: crate::Emoji = crate::Emoji {
    glyph: "🎫",
    codepoint: "1F3AB",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "ticket",
    group: "Activities",
    subgroup: "event",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("kaartjie"),
            keywords: &["kaartjie", "toegang"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ትኬት"),
            keywords: &["መግቢያ ፈቃድ", "ትኬት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("تذكرة"),
            keywords: &["تذكرة", "ترفيه"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("টিকট"),
            keywords: &["টিকট", "প\u{9cd}ৰবেশ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("bilet"),
            keywords: &["bilet", "giriş haqqı"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("білет"),
            keywords: &["білет", "уваход"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("билет"),
            keywords: &["билет", "вход"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("টিকিট"),
            keywords: &["টিকিট", "প\u{9cd}রবেশ"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("bilhed"),
            keywords: &["arvest", "bilhed"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("karta"),
            keywords: &["karta", "ulaznica"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("tiquet"),
            keywords: &["admissió", "entrada", "tiquet"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎪᏪᎳ ᎠᏴᏍᏙᏗ"),
            keywords: &["ᎠᏈᏴᏙᏗ", "ᎪᏪᎳ ᎠᏴᏍᏙᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("lístek"),
            keywords: &["lístek", "vstup", "vstupenka"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("tocyn"),
            keywords: &["mynediad", "tocyn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("billet"),
            keywords: &["billet", "entré", "forlystelse", "underholdning"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Ticket"),
            keywords: &["Konzert", "Ticket", "Unterhaltung"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("εισιτήριο"),
            keywords: &["είσοδος", "εισιτήριο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("ticket"),
            keywords: &["admission", "ticket"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("tique"),
            keywords: &["acceso", "admisión", "tique"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("boleto"),
            keywords: &["boleto", "entrada", "entretenimiento"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "boleto",
                "entretenimiento",
                "evento",
                "ticket",
                "ticket de admisión",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("pilet"),
            keywords: &["pilet", "pääse"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("txartela"),
            keywords: &["sarrera", "txartela"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("بلیت"),
            keywords: &["بلیت", "جواز", "حواله", "رسید"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("lippu"),
            keywords: &["lippu", "sisäänpääsylippu"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("tiket"),
            keywords: &["admission", "ticket", "tiket"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("farseðil"),
            keywords: &["atgongd", "atgongumerki", "farseðil"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("billet"),
            keywords: &["billet", "spectacle"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("ticéad"),
            keywords: &["cead isteach", "ticéad"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("ticead"),
            keywords: &[
                "bileag",
                "cairt-fharaidh",
                "cead a-steach",
                "inntrigeadh",
                "ticead",
                "ticeard",
                "ticeid",
                "tiocaid",
                "tiogaid",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("tícket"),
            keywords: &["billete", "entrada", "tícket"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ટિકિટ"),
            keywords: &["ટિકિટ", "મનોર\u{a82}જન"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("tikiti"),
            keywords: &["shigarwa", "tikiti"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("כרטיס"),
            keywords: &["כניסה", "כרטיס"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("टिकट"),
            keywords: &["टिकट", "मनोर\u{902}जन"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("ulaznica"),
            keywords: &["ulaz", "ulaznica"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("jegy"),
            keywords: &["belépő", "jegy"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("տոմս"),
            keywords: &["մուտք", "տոմս"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tiket"),
            keywords: &["masuk", "tiket"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("tiketi"),
            keywords: &["nnabata", "tiketi"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("miði"),
            keywords: &["aðgöngumiði", "miði", "skemmtun"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("biglietto"),
            keywords: &["biglietto", "ingresso"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("チケット"),
            keywords: &["チケット", "切符"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tiket"),
            keywords: &["mlebu", "tiket"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ბილეთი"),
            keywords: &["ბილეთი", "შესვლა"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("atiki"),
            keywords: &["atiki"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("билет"),
            keywords: &["билет", "қабылдау"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("billet"),
            keywords: &["billet", "forlystelse", "underholdning"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ស\u{17c6}ប\u{17bb}ត\u{17d2}រ"),
            keywords: &["ស\u{17c6}ប\u{17bb}ត\u{17d2}រ", "អន\u{17bb}ញ\u{17d2}ញាត"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಟ\u{cbf}ಕ\u{cc6}ಟ\u{ccd}"),
            keywords: &["ಟ\u{cbf}ಕ\u{cc6}ಟ\u{ccd}", "ಮನರಂಜನ\u{cc6}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("티켓"),
            keywords: &["공연", "엔터테인먼트", "티켓", "표"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("तिक\u{947}ट"),
            keywords: &["तिक\u{947}ट", "प\u{94d}रव\u{947}श"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("билет"),
            keywords: &["билет", "кирүү"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Billjee"),
            keywords: &["Billjee", "Entrée"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ປ\u{eb5}\u{ec9}"),
            keywords: &["ການເຂ\u{ebb}\u{ec9}າຊ\u{ebb}ມ", "ປ\u{eb5}\u{ec9}"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("bilietas"),
            keywords: &["bilietas", "įėjimas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("biļete"),
            keywords: &["biļete", "ieeja"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tīkiti"),
            keywords: &["tomonga", "tīkiti"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("билет"),
            keywords: &["билет", "влез"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ടിക\u{d4d}കറ\u{d4d}റ\u{d4d}"),
            keywords: &["ടിക\u{d4d}കറ\u{d4d}റ\u{d4d}", "ന\u{d3e}ടകം", "സിനിമ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("тасалбар"),
            keywords: &["тасалбар", "элсэлт"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("तिकिट"),
            keywords: &["तिकिट", "प\u{94d}रव\u{947}श"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("tiket"),
            keywords: &["masuk", "tiket"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("biljett"),
            keywords: &["biljett", "dħul"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လက\u{103a}မ\u{103e}တ\u{103a}"),
            keywords: &[
                "လက\u{103a}မ\u{103e}တ\u{103a}",
                "ဝင\u{103a}ခ\u{103d}င\u{1037}\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("billett"),
            keywords: &["adgang", "billett", "inngang", "underholdning"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("टिकट"),
            keywords: &["टिकट", "प\u{94d}रव\u{947}श"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("ticket"),
            keywords: &["entree", "ticket"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("billett"),
            keywords: &["billett", "inngang", "tilgang", "underhaldning"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଟ\u{b3f}କେଟ\u{b4d}\u{200d}"),
            keywords: &["ଆଡମ\u{b3f}ସନ\u{b4d}", "ଟ\u{b3f}କେଟ\u{b4d}\u{200d}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਟਿਕਟ"),
            keywords: &["ਟਿਕਟ", "ਦਾਖਲ ਹ\u{a4b}ਣਾ", "ਮਨ\u{a4b}ਰ\u{a70}ਜਨ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ٹکٹ"),
            keywords: &["داخلہ", "ٹکٹ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Tíkẹt"),
            keywords: &["Gẹ\u{301}t Rait", "Tíkẹt"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("bilet"),
            keywords: &["bilet", "wstęp"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ټکټ"),
            keywords: &["داخله", "ټکټ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("ingresso"),
            keywords: &["entretenimento", "ingresso"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("bilhete"),
            keywords: &["bilhete", "entrada"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("boleto"),
            keywords: &["boleto", "uyakuynin"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("bilet"),
            keywords: &["bilet", "intrare"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-363"),
            keywords: &["E10-363"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("билет"),
            keywords: &["билет", "билетик", "пропуск", "самолет", "транспорт"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("itike"),
            keywords: &["itike", "kwemera"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ٽڪيٽ"),
            keywords: &["داخلا", "ٽڪيٽ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ට\u{dd2}කට\u{dca} පත"),
            keywords: &["ඇත\u{dd4}ළත\u{dca} ව\u{dd3}ම", "ට\u{dd2}කට\u{dca} පත"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("lístok"),
            keywords: &["lístok", "vstupenka"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("vstopnica"),
            keywords: &["vstopnica", "vstopnina"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("tikid"),
            keywords: &["diiwaan gelin", "tikid"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("biletë"),
            keywords: &["biletë", "hyrje"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("карта"),
            keywords: &["карта", "улaз"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("karta"),
            keywords: &["karta", "ulaz"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("biljett"),
            keywords: &["biljett", "inträde"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("tiketi"),
            keywords: &["kuingia", "tiketi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("டிக\u{bcd}கெட\u{bcd}"),
            keywords: &[
                "டிக\u{bcd}கெட\u{bcd}",
                "நுழைவுச\u{bcd}ச\u{bc0}ட\u{bcd}டு",
                "பொழுதுபோக\u{bcd}கு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ట\u{c3f}క\u{c4d}క\u{c46}ట\u{c4d}"),
            keywords: &[
                "ట\u{c3f}క\u{c4d}క\u{c46}ట\u{c4d}",
                "ప\u{c4d}రవ\u{c47}శ చ\u{c40}ట\u{c40}",
                "వ\u{c3f}న\u{c4b}దం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("чипта"),
            keywords: &["чипта", "қабул"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ต\u{e31}\u{e4b}ว"),
            keywords: &["ต\u{e31}\u{e4b}ว", "เข\u{e49}าชมงาน"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("petek"),
            keywords: &["giriş", "petek"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tikite"),
            keywords: &["tikite"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("bilet"),
            keywords: &["bilet", "giriş"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("بېلەت"),
            keywords: &["بېلەت", "قوبۇل"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("квиток"),
            keywords: &["вхідний", "квиток"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ٹکٹ"),
            keywords: &["تقریب", "داخلہ", "ٹکٹ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("chipta"),
            keywords: &["chipta", "kirish"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("vé"),
            keywords: &["vào cửa", "vé"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("biye"),
            keywords: &["biye", "dugg"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("itikiti"),
            keywords: &["itikiti", "ungeno"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Iwe Iwọle"),
            keywords: &["Iwe Iwọle", "ìgbaniwọlé"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("門券"),
            keywords: &["入場", "門券"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("门券"),
            keywords: &["入场", "门券"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("票"),
            keywords: &["入场券", "电影票", "票", "车票", "门票"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("門票"),
            keywords: &["票券", "門票"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("票"),
            keywords: &["入場卷", "票", "門票"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ithikithi"),
            keywords: &["ithikithi", "ukungena"],
        },
    ],
};
