#[doc = "🎭"]
pub const PERFORMING_ARTS: crate::Emoji = crate::Emoji {
    glyph: "🎭",
    codepoint: "1F3AD",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "performing arts",
    group: "Activities",
    subgroup: "arts & crafts",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("uitvoerende kunste"),
            keywords: &["drama", "kuns", "masker", "teater", "uitvoerende kunste"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሙዚቃና ትያትር"),
            keywords: &["ሙዚቃና ትያትር", "ሥነ ጥበብ", "ቲያትር", "ትወና", "ጭንብል"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("قناع وجه"),
            keywords: &["ترفيه", "فن", "فن استعراضي", "قناع وجه", "قناعا وجه"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("কল\u{9be} প\u{9cd}ৰদৰ\u{9cd}শন"),
            keywords: &[
                "কল\u{9be}",
                "কল\u{9be} প\u{9cd}ৰদৰ\u{9cd}শন",
                "থিয\u{9bc}েট\u{9be}ৰ",
                "প\u{9cd}ৰদৰ\u{9cd}শন কৰ\u{9be}",
                "ম\u{9c1}খ\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("teatr incəsənəti"),
            keywords: &[
                "icra etmək",
                "incəsənət",
                "maska",
                "teatr",
                "teatr incəsənəti",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("выканальніцкія віды мастацтва"),
            keywords: &[
                "выканальніцкія віды мастацтва",
                "маска",
                "мастацтва",
                "тэатр",
                "ігра",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("сценични изкуства"),
            keywords: &[
                "Сценични изкуства",
                "изкуство",
                "маска",
                "сцена",
                "сценични изкуства",
                "театър",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("কল\u{9be} সম\u{9cd}প\u{9be}দন"),
            keywords: &[
                "কল\u{9be}",
                "কল\u{9be} সম\u{9cd}প\u{9be}দন",
                "থিয\u{9bc}েট\u{9be}র",
                "প\u{9be}রফর\u{9cd}ম কর\u{9be}",
                "ম\u{9c1}খোশ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("arvestoù bev"),
            keywords: &["arvestoù bev", "arz", "maskl"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("scenske umjetnosti"),
            keywords: &[
                "izvedba",
                "maska",
                "pozorište",
                "scenske umjetnosti",
                "umjetnina",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("arts interpretatives"),
            keywords: &[
                "arts",
                "arts interpretatives",
                "interpretació",
                "màscara",
                "teatre",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎾᎾᏛᏁᎵᏍᎬᎢ"),
            keywords: &[
                "ᎠᎵᎬᏚᎶᎢ",
                "ᎠᏛᏁᎸᏍᎬ",
                "ᎠᏛᏁᎸᏍᎬᎢ",
                "ᎤᎾᏛᏁᏟᏗᎢ",
                "ᎾᎾᏛᏁᎵᏍᎬᎢ",
                "ᏗᏟᎶᏍᏔᏅᎢ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("múzická umění"),
            keywords: &[
                "divadlo",
                "herec",
                "herectví",
                "hra",
                "komedie",
                "maska",
                "múzická umění",
                "tragédie",
                "umění",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("celfyddydau perfformiadol"),
            keywords: &[
                "celf",
                "celfyddydau perfformiadol",
                "mwgwd",
                "perfformiadol",
                "theatr",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("masker"),
            keywords: &["masker", "teater"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Masken"),
            keywords: &["Kunst", "Masken", "Theater", "Unterhaltung"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("θέατρο"),
            keywords: &["ηθοποιία", "θέατρο", "μάσκα", "τέχνη"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("performing arts"),
            keywords: &[
                "art",
                "mask",
                "performing",
                "performing arts",
                "theater",
                "theatre",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("máscaras de teatro"),
            keywords: &[
                "actuación",
                "arte",
                "artes escénicas",
                "entretenimiento",
                "máscaras de teatro",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &[
                "actuación",
                "artes",
                "máscaras",
                "máscaras de teatro",
                "teatro",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("artes escénicas"),
            keywords: &["actuación", "arte", "artes escénicas", "máscara", "teatro"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("lavakunst"),
            keywords: &["kunst", "lava", "lavakunst", "mask", "teater"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("arte eszenikoak"),
            keywords: &[
                "antzoki",
                "areto",
                "arte",
                "arte eszenikoak",
                "eszeniko",
                "maskara",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("هنرهای نمایشی"),
            keywords: &[
                "تئاتر",
                "سالن تئاتر",
                "ماسک نقاب",
                "نمایش",
                "هنر",
                "هنرهای نمایشی",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("näyttämötaiteet"),
            keywords: &[
                "naamio",
                "näytelmä",
                "näyttämö",
                "näyttämötaiteet",
                "taide",
                "teatteri",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("sining pantanghalan"),
            keywords: &["maskara", "pantanghalan", "sining", "teatro"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("útinnandi leiklistir"),
            keywords: &[
                "ballett",
                "leikhús",
                "list",
                "sjónleikur",
                "útinnandi leiklistir",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("spectacle vivant"),
            keywords: &["art", "masque", "spectacle", "spectacle vivant", "théâtre"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("arts du spectacle"),
            keywords: &["art", "arts du spectacle", "masque", "spectacle", "théâtre"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("na taibhealaíona"),
            keywords: &[
                "aghaidhmhasc",
                "ealaín",
                "na taibhealaíona",
                "siamsaíocht",
                "taibh-ealaín",
                "taibhiúchán",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("ealain-chluiche"),
            keywords: &[
                "aghaidh-choimheach",
                "cleasachd",
                "ealain-chluiche",
                "ealan",
                "taigh-cluich",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("máscaras"),
            keywords: &[
                "actuación",
                "arte",
                "artes interpretativas",
                "máscaras",
                "teatro",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ચહ\u{ac7}રાન\u{ac1}\u{a82} મહોર\u{ac1}\u{a82}"),
            keywords: &[
                "કળા",
                "ચહ\u{ac7}રાન\u{ac1}\u{a82} મહોર\u{ac1}\u{a82}",
                "નાટ\u{acd}યગ\u{ac3}હ",
                "પ\u{acd}રદર\u{acd}શન કલા",
                "મનોર\u{a82}જન",
                "લલિત",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("wasan kwaikwayo"),
            keywords: &[
                "abin rufen ido",
                "fasaha",
                "kwaikwayo",
                "wasan kwaikwayo",
                "wurin wasan kwaikwayo",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("אמנויות הבמה"),
            keywords: &["אמנויות הבמה", "במה", "דרמה", "מסיכות", "משחק", "תיאטרון"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("प\u{94d}रदर\u{94d}शन कला, म\u{941}खौट\u{947}"),
            keywords: &[
                "कला",
                "नकाब",
                "प\u{94d}रदर\u{94d}शन",
                "प\u{94d}रदर\u{94d}शन कला, म\u{941}खौट\u{947}",
                "मनोर\u{902}जन",
                "मास\u{94d}क",
                "म\u{941}खौटा",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("izvedbene umjetnosti"),
            keywords: &[
                "izvedba",
                "izvedbene umjetnosti",
                "kazalište",
                "maska",
                "umjetnost",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("előadóművészetek"),
            keywords: &["előadás", "előadóművészetek", "maszkok", "színház"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կատարողական արվեստ"),
            keywords: &[
                "արվեստ",
                "դիմակ",
                "թատրոն",
                "կատարողական արվեստ",
                "ներկայացում",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("seni drama"),
            keywords: &["seni", "seni drama", "tampil", "teater", "topeng"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("na-egosipụta ihe ǹkà"),
            keywords: &[
                "ihe ǹkà",
                "mkpuchi ihu",
                "na-egosipụta",
                "na-egosipụta ihe ǹkà",
                "ụlọ ǹkà",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("leikhúsgrímur"),
            keywords: &[
                "leikhúsgrímur",
                "leiklist",
                "list",
                "skemmtun",
                "sviðslistir",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("maschere"),
            keywords: &[
                "arte",
                "arti performative",
                "intrattenimento",
                "maschere",
                "performance",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("舞台芸術"),
            keywords: &["仮面", "劇場", "演劇", "演芸", "舞台芸術", "芸術"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("seni pagelaran"),
            keywords: &["pagelaran", "seni", "teater", "topeng"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("თეატრალური ხელოვნება"),
            keywords: &[
                "თეატრალური ხელოვნება",
                "თეატრი",
                "ნიღაბი",
                "შესრულება",
                "ხელოვნება",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("театр өнері"),
            keywords: &["маска", "орындау", "театр", "театр өнері", "өнер"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("masker"),
            keywords: &["masker", "teater"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "ស\u{17d2}រោមម\u{17bb}ខសម\u{17d2}រាប\u{17cb}សម\u{17d2}តែងស\u{17b7}ល\u{17d2}បៈ",
            ),
            keywords: &[
                "ស\u{17d2}រោមម\u{17bb}ខ",
                "ស\u{17d2}រោមម\u{17bb}ខសម\u{17d2}រាប\u{17cb}សម\u{17d2}តែងស\u{17b7}ល\u{17d2}បៈ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪ\u{ccd}ರದರ\u{ccd}ಶನ ಕಲ\u{cc6}ಗಳು"),
            keywords: &[
                "ಕಲ\u{cc6} ಪ\u{ccd}ರದರ\u{ccd}ಶನ",
                "ಪ\u{ccd}ರದರ\u{ccd}ಶನ ಕಲ\u{cc6}ಗಳು",
                "ಮುಖವಾಡ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("가면"),
            keywords: &["가면", "공연", "마스크", "영화관", "예술"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("सादरीकरण कला"),
            keywords: &["कला", "थिय\u{947}टर", "मास\u{94d}क", "सादरीकरण"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("аткаруу өнөрү"),
            keywords: &["аткаруу", "аткаруу өнөрү", "беткап", "театр", "өнөр"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("duerstellend Konscht"),
            keywords: &["Konscht", "Mask", "Theater", "duerstellend"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ສ\u{eb4}ລະປະການສະແດງ"),
            keywords: &[
                "ການສະແດງ",
                "ສ\u{eb4}ລະປະ",
                "ສ\u{eb4}ລະປະການສະແດງ",
                "ໂຮງລະຄອນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("scenos menas"),
            keywords: &["kaukė", "menas", "pasirodymas", "scenos menas", "teatras"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("skatuves māksla"),
            keywords: &["maska", "māksla", "skatuves māksla", "teātris"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("ngā toi whakaaturanga"),
            keywords: &[
                "ngā toi whakaaturanga",
                "toi",
                "whakaaturanga",
                "whare tapere",
                "ārai",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("сценски уметности"),
            keywords: &["маска", "сцена", "сценски уметности", "театар", "уметност"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ന\u{d3e}ട\u{d4d}യകല"),
            keywords: &[
                "അന\u{d41}ഷ\u{d4d}ഠ\u{d3e}ന കല",
                "ന\u{d3e}ടകം",
                "ന\u{d3e}ട\u{d4d}യകല",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("жүжиг"),
            keywords: &["баг", "жүжиг", "театр", "урлаг"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("कला सादर करण\u{947}"),
            keywords: &[
                "कला",
                "कला सादर करण\u{947}",
                "चित\u{94d}रपटग\u{943}ह",
                "मास\u{94d}क",
                "सादर करण\u{947}",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("seni persembahan"),
            keywords: &["panggung", "persembahan", "seni", "teater", "topeng"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("arti, żfin u mużika"),
            keywords: &[
                "arti",
                "arti, żfin u mużika",
                "maskra",
                "performattivi",
                "teatru",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဖြေဖျော\u{103a}ရေး အန\u{102f}ပညာများ"),
            keywords: &[
                "ပြဇာတ\u{103a}ရ\u{102f}\u{1036}",
                "ဖြေဖျော\u{103a}မ\u{103e}\u{102f}",
                "ဖြေဖျော\u{103a}ရေး အန\u{102f}ပညာများ",
                "မျက\u{103a}န\u{103e}ာဖ\u{102f}\u{1036}း",
                "အန\u{102f}ပညာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("teatermasker"),
            keywords: &[
                "kunst",
                "scenekunst",
                "teater",
                "teatermasker",
                "underholdning",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("कला प\u{94d}रदर\u{94d}शन गर\u{94d}द\u{948}"),
            keywords: &[
                "कला",
                "कला प\u{94d}रदर\u{94d}शन गर\u{94d}द\u{948}",
                "नाचघर",
                "नाटक प\u{94d}रहसन घर",
                "प\u{94d}रदर\u{94d}शन गर\u{94d}द\u{948}",
                "मास\u{94d}क",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("toneelkunsten"),
            keywords: &[
                "kunst",
                "masker",
                "optreden",
                "theater",
                "toneel",
                "toneelkunsten",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("teatermasker"),
            keywords: &[
                "kunst",
                "scenekunst",
                "teater",
                "teatermasker",
                "underhaldning",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପ\u{b4d}ରଦର\u{b4d}ଶନକ\u{b3e}ରୀ କଳ\u{b3e}"),
            keywords: &[
                "କଳ\u{b3e}",
                "ପ\u{b4d}ରଦର\u{b4d}ଶନ କର\u{b3f}ବ\u{b3e}",
                "ପ\u{b4d}ରଦର\u{b4d}ଶନ କଳ\u{b3e}",
                "ପ\u{b4d}ରଦର\u{b4d}ଶନକ\u{b3e}ରୀ କଳ\u{b3e}",
                "ମନୋରଞ\u{b4d}ଜନ",
                "ମ\u{b41}ହ\u{b01} ଆବରଣ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕਲਾ ਵਿਖਾਉਣਾ"),
            keywords: &[
                "ਅਭਿਨ\u{a48}",
                "ਕਲਾ",
                "ਕਲਾ ਵਿਖਾਉਣਾ",
                "ਚਿਹਰਾ ਮਾਸਕ",
                "ਮਨ\u{a4b}ਰ\u{a70}ਜਨ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("فن انجام دیندیاں ہوئیاں"),
            keywords: &[
                "اداکاری کرنا",
                "تھیٹر",
                "فن",
                "فن انجام دیندیاں ہوئیاں",
                "ماسک",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Átists Dẹm Mask"),
            keywords: &[
                "Dú Sọ\u{301}mtin",
                "Mask",
                "Sọ\u{301}mtin Wé Átist De Du",
                "Tins Wé Átist-dẹm De Du",
                "Tíéta",
                "Átists Dẹm Mask",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("maski teatralne"),
            keywords: &["maski teatralne", "teatr", "występować"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("عملي فنون"),
            keywords: &["تهيټر", "عملي", "عملي فنون", "فن", "ماسکه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("máscara"),
            keywords: &[
                "arte",
                "arte dramática",
                "entretenimento",
                "espetáculo",
                "máscara",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("artes performativas"),
            keywords: &["artes", "máscaras", "performativas", "teatro"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("artes escenicas"),
            keywords: &["artes escenicas"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("arte interpretative"),
            keywords: &[
                "arte interpretative",
                "artă",
                "măști",
                "spectacol",
                "teatru",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-365"),
            keywords: &["E10-365"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("маски"),
            keywords: &["искусство", "маски", "театр"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("imyiyereko"),
            keywords: &[
                "imyiyereko",
                "inzu iberamo imyiyereko",
                "kwiyerekana",
                "masike",
                "ubugeni",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("فن ڏيکاريندي"),
            keywords: &["اداڪرڻ", "فن ڏيکاريندي", "نقاب", "ٿيٽر", "ڪلا"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("අභ\u{dd2}ව\u{dcf}හ\u{dca}\u{200d}ය කල\u{dcf}"),
            keywords: &[
                "අභ\u{dd2}ව\u{dcf}හ\u{dca}\u{200d}ය කල\u{dcf}",
                "කල\u{dcf}ව",
                "ප\u{dca}\u{200d}රසංගය",
                "රඟහල",
                "වෙස\u{dca} ම\u{dd4}හ\u{dd4}ණ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("divadlo"),
            keywords: &["divadelné", "divadlo", "maska", "umenie"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("scenske umetnosti"),
            keywords: &[
                "gledališče",
                "maska",
                "nastopanje",
                "scenske umetnosti",
                "umetnost",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("fulinta farshaxanka"),
            keywords: &[
                "farshaxan",
                "fulinta",
                "fulinta farshaxanka",
                "goobta",
                "masgaraato",
                "masraxa",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("arte interpretimi"),
            keywords: &["art", "arte interpretimi", "interpretim", "maskë", "teatër"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("сценска уметност"),
            keywords: &[
                "мaскa",
                "позориште",
                "сцена",
                "сценска уметност",
                "умeтнoст",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("сценска умјетност"),
            keywords: &["сценска умјетност"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("scenska umetnost"),
            keywords: &[
                "maska",
                "pozorište",
                "scena",
                "scenska umetnost",
                "umetnost",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("scenska umjetnost"),
            keywords: &["scenska umjetnost"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("dans och teater"),
            keywords: &["ansiktsmasker", "dans och teater", "masker", "teater"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("sanaa"),
            keywords: &["barakoa", "kuigiza", "sanaa", "ukumbi wa maigizo"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("முக முடி"),
            keywords: &[
                "கலை",
                "நடிப\u{bcd}பு",
                "ந\u{bbe}டகம\u{bcd}",
                "நிகழ\u{bcd}த\u{bcd}துகலை",
                "முக முடி",
                "முகமூடி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ముఖ\u{c3e}న\u{c3f}క\u{c3f} వ\u{c47}సుకున\u{c47} త\u{c4a}డుగులు"),
            keywords: &[
                "త\u{c4a}డుగు",
                "ముఖం",
                "ముఖ\u{c3e}న\u{c3f}క\u{c3f} వ\u{c47}సుకున\u{c47} త\u{c4a}డుగులు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("намдуҳои санъати иҷро"),
            keywords: &[
                "иҷро кардан",
                "намдуҳои санъати иҷро",
                "ниқоб",
                "санъат",
                "театр",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หน\u{e49}ากาก"),
            keywords: &["ศาสตร\u{e4c}การแสดง", "หน\u{e49}ากาก"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýerine ýetiriş sungaty"),
            keywords: &[
                "drama teatr",
                "maska",
                "sungat",
                "teatr",
                "ýerine ýetiriş sungaty",
                "ýerine ýetirmek",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("faiva aati"),
            keywords: &["faiva aati"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("sahne sanatları"),
            keywords: &[
                "eğlence",
                "performans",
                "performans sanatı",
                "sahne sanatları",
                "sanat",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئويۇن كۆرسىتىش"),
            keywords: &[
                "ئويۇن كۆرسىتىش",
                "تىياتىرخانا",
                "سەنئەت",
                "كىنوخانا",
                "كۆرسىتىش",
                "ماسكا",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("театральне мистецтво"),
            keywords: &[
                "вистава",
                "маска",
                "мистецтво",
                "театр",
                "театральне мистецтво",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("فنون\u{650} لطیفہ"),
            keywords: &[
                "تھیٹر",
                "فنون لطیفہ",
                "فنون\u{650} لطیفہ",
                "ماسک",
                "پرفارمنگ آرٹس",
                "کارکردگی کا مظاہرہ",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("teatr niqoblari"),
            keywords: &["niqob", "san’at", "teatr", "teatr niqoblari"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nghệ thuật biểu diễn"),
            keywords: &[
                "biểu diễn",
                "mặt nạ",
                "nghệ thuật",
                "nghệ thuật biểu diễn",
                "nhà hát",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("yëngu ci aar"),
            keywords: &["art", "def", "mask", "teyaatar", "yëngu ci aar"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ukudlala ubugcisa"),
            keywords: &[
                "isigqubuthelo",
                "ithiyatha",
                "ithiyathiya",
                "ubugcisa",
                "ukudlala ubugcisa",
                "ukwenza",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ere Awokọṣe"),
            keywords: &[
                "Ere Awokọṣe",
                "iṣẹ\u{301} ọná",
                "tíátà",
                "àwòkọ\u{301}ṣe",
                "ìbòjú",
                "ìtàgé",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("表演藝術"),
            keywords: &["劇場", "藝術", "表演", "表演藝術", "面具"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("表演艺术"),
            keywords: &["剧场", "艺术", "表演", "表演艺术", "面具"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("表演艺术"),
            keywords: &["剧院", "戏剧", "艺术", "表演", "表演艺术", "面具"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("戲劇"),
            keywords: &["戲劇", "面具"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("表演藝術"),
            keywords: &["表演藝術", "面具"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ezobuciko bemibukiso"),
            keywords: &["ezobuciko bemibukiso", "imaskhi", "ubuciko", "umbukiso"],
        },
    ],
};
#[doc = "🖼\u{fe0f}"]
pub const FRAMED_PICTURE: crate::Emoji = crate::Emoji {
    glyph: "🖼\u{fe0f}",
    codepoint: "1F5BC FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "framed picture",
    group: "Activities",
    subgroup: "arts & crafts",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🖼",
        codepoint: "1F5BC",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "framed picture",
        group: "Activities",
        subgroup: "arts & crafts",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("raam met prent"),
            keywords: &[
                "kuns",
                "museum",
                "prent",
                "raam",
                "raam met prent",
                "skildery",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ባለክፈፍ ሥዕል"),
            keywords: &["ምስል", "ሥነ ጥበብ", "ሥዕል", "ባለክፈፍ", "ቤተ መዘክር"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("إطار وصورة"),
            keywords: &["إطار", "إطار صورة", "إطار وصورة", "رسم", "فن", "متحف"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ফ\u{9cd}ৰেম কৰি থোৱ\u{9be} চিত\u{9cd}ৰ"),
            keywords: &[
                "কল\u{9be}",
                "চিত\u{9cd}ৰ",
                "পেইণ\u{9cd}টিং",
                "ফ\u{9cd}ৰেম",
                "ফ\u{9cd}ৰেম কৰি থোৱ\u{9be} চিত\u{9cd}ৰ",
                "মিউজিয\u{9bc}\u{9be}ম",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("şəkilli çərçivə"),
            keywords: &[
                "incəsənət",
                "muzey",
                "çəkmək",
                "çərçivə",
                "şəkil",
                "şəkilli çərçivə",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("карціна ў рамцы"),
            keywords: &["карціна", "карціна ў рамцы", "мастацтва", "музей", "рамка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("картина в рамка"),
            keywords: &[
                "Картина в рамка",
                "изкуство",
                "картина",
                "картина в рамка",
                "музей",
                "рамка",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ফ\u{9cd}রেমের স\u{9be}থে ছবি"),
            keywords: &[
                "কল\u{9be}",
                "ছবি",
                "পেন\u{9cd}টিং",
                "ফ\u{9cd}রেমের স\u{9be}থে ছবি",
                "মিউজিয\u{9bc}\u{9be}ম",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("skeudenn sterniet"),
            keywords: &["arz", "skeudenn", "skeudenn sterniet", "stern"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("uramljena slika"),
            keywords: &[
                "izvedba",
                "maska",
                "pozorište",
                "umjetnost",
                "uramljena slika",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("marc amb quadre"),
            keywords: &[
                "art",
                "marc",
                "marc amb quadre",
                "museu",
                "pintura",
                "quadre",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᏟᎶᏍᏔᏅᎢ ᎦᏘᏅᏔᏅᎢ"),
            keywords: &["ᎤᏪᏘ ᎠᏍᏆ.ᎪᏛᎢ", "ᎦᏘᏅᏔᏅᎢ", "ᎦᏘᏅᏗᎢ", "ᏓᏑᏫᏍᎬᎢ", "ᏗᏟᎶᏍᏔᏅᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("obraz v rámu"),
            keywords: &[
                "malování",
                "malířství",
                "muzeum",
                "obraz",
                "obraz v rámu",
                "rám",
                "umění",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("ffrâm gyda llun"),
            keywords: &["amgueddfa", "celf", "ffrâm", "ffrâm gyda llun"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("ramme med billede"),
            keywords: &[
                "billede",
                "kunst",
                "maleri",
                "museum",
                "ramme",
                "ramme med billede",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("gerahmtes Bild"),
            keywords: &[
                "Bild",
                "Gemälde",
                "Kunst",
                "Rahmen",
                "Zeichnung",
                "gerahmtes Bild",
                "malen",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("εικόνα σε κορνίζα"),
            keywords: &[
                "εικόνα",
                "εικόνα σε κορνίζα",
                "κάδρο",
                "μουσείο",
                "πίνακας",
                "τέχνη",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("framed picture"),
            keywords: &[
                "art",
                "frame",
                "framed picture",
                "museum",
                "painting",
                "picture",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cuadro enmarcado"),
            keywords: &["cuadro enmarcado", "marco", "museo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["arte", "cuadro enmarcado", "marco", "museo", "pintura"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("raamitud pilt"),
            keywords: &["kunst", "maal", "muuseum", "pilt", "raamitud pilt"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("koadroa markoarekin"),
            keywords: &[
                "arte",
                "koadro",
                "koadroa markoarekin",
                "margolan",
                "marko",
                "museo",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("عکس در قاب"),
            keywords: &["تصویر", "عکس در قاب", "قاب عکس", "موزه", "نقاشی", "هنر"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kuva kehyksissä"),
            keywords: &["kehys", "kuva kehyksissä", "maalaus", "museo", "taide"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("frame na may larawan"),
            keywords: &[
                "frame",
                "frame na may larawan",
                "larawan",
                "litrato",
                "museo",
                "sining",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("innrammað mynd"),
            keywords: &["innrammað", "list", "mynd", "málningur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("cadre avec image"),
            keywords: &["art", "cadre avec image", "image", "musée", "peinture"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("pictiúr i bhfráma"),
            keywords: &[
                "ealaíon",
                "fráma",
                "fráma le phictiúr",
                "músaem",
                "pictiúr",
                "pictiúr i bhfráma",
                "péintéireacht",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("dealbh le frèam"),
            keywords: &[
                "dealbh",
                "dealbh le frèam",
                "ealan",
                "frèam",
                "taigh-tasgaidh",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cadro"),
            keywords: &["cadro", "exposición", "marco", "museo", "pintura"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ચિત\u{acd}ર સાથ\u{ac7}ની ફ\u{acd}ર\u{ac7}મ"),
            keywords: &[
                "કલા",
                "કલાક\u{ac3}તિ",
                "ચિત\u{acd}ર",
                "ચિત\u{acd}ર સાથ\u{ac7}ની ફ\u{acd}ર\u{ac7}મ",
                "ફ\u{acd}ર\u{ac7}મ",
                "સ\u{a82}ગ\u{acd}રહાલય",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("hoto mai firem"),
            keywords: &[
                "fasaha",
                "fenti",
                "firem",
                "hoto",
                "hoto mai firem",
                "ma’adanar kayayyakin tarihi",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מסגרת עם תמונה"),
            keywords: &[
                "אמנות",
                "מוזיאון",
                "מסגרת",
                "מסגרת עם תמונה",
                "ציור",
                "תמונה",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("फ\u{93c}\u{94d}र\u{947}म वाला चित\u{94d}र"),
            keywords: &[
                "चित\u{94d}र",
                "प\u{947}\u{902}टि\u{902}ग",
                "फ\u{93c}\u{94d}र\u{947}म वाला चित\u{94d}र",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("uokvirena slika"),
            keywords: &[
                "muzej",
                "okvir",
                "slika",
                "slikarstvo",
                "umjetnost",
                "uokvirena slika",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("kép kerettel"),
            keywords: &[
                "bekeretezett kép",
                "galéria",
                "kép kerettel",
                "múzeum",
                "művészet",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("շրջանակ նկարով"),
            keywords: &[
                "արվեստ",
                "թանգարան",
                "նկար",
                "նկարչություն",
                "շրջանակ",
                "շրջանակ նկարով",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("bingkai bergambar"),
            keywords: &[
                "bingkai",
                "bingkai bergambar",
                "gambar",
                "lukisan",
                "museum",
                "seni",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("fòto nwere fremụ"),
            keywords: &[
                "fremụ",
                "fòto",
                "fòto nwere fremụ",
                "ihe ǹkà",
                "ite àgbà",
                "ụlọ nchekwa ǹkà",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("rammi með mynd"),
            keywords: &["list", "mynd", "málverk", "rammi", "rammi með mynd", "safn"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("quadro incorniciato"),
            keywords: &[
                "cornice",
                "museo",
                "opera d’arte",
                "quadro",
                "quadro incorniciato",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("絵画"),
            keywords: &["絵", "絵画", "美術館", "芸術"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("gambar nganggo pigura"),
            keywords: &[
                "gambar",
                "gambar nganggo pigura",
                "lukisan",
                "museum",
                "pigura",
                "seni",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ჩარჩო ნახატით"),
            keywords: &[
                "მუზეუმი",
                "ნახატი",
                "სურათი",
                "ჩარჩო",
                "ჩარჩო ნახატით",
                "ხატვა",
                "ხელოვნება",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жақтаулы сурет"),
            keywords: &[
                "жақтаулы сурет",
                "кадр",
                "мұражай",
                "сурет",
                "сурет салу",
                "өнер",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("ramme med billede"),
            keywords: &[
                "billede",
                "kunst",
                "maleri",
                "museum",
                "ramme",
                "ramme med billede",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ស\u{17ca}\u{17bb}មរ\u{17bc}បថត"),
            keywords: &[
                "គ\u{17c6}ន\u{17bc}រ",
                "រ\u{17bc}បថត",
                "រ\u{17bc}បភាព",
                "ស\u{17ca}\u{17bb}មរ\u{17bc}បថត",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಚ\u{cbf}ತ\u{ccd}ರದೊಂದ\u{cbf}ಗ\u{cc6} ಫ\u{ccd}ರೇಮ\u{ccd}"),
            keywords: &[
                "ಕಲ\u{cc6}",
                "ಚ\u{cbf}ತ\u{ccd}ರದೊಂದ\u{cbf}ಗ\u{cc6} ಫ\u{ccd}ರೇಮ\u{ccd}",
                "ಫ\u{ccd}ರೇಮ\u{ccd}",
                "ಮ\u{ccd}ಯ\u{cc2}ಸ\u{cbf}ಯಂ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("그림 액자"),
            keywords: &["그림", "박물관", "액자", "작품"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("चौकटीतल\u{947}\u{902} चित\u{94d}र"),
            keywords: &[
                "कला",
                "चित\u{94d}र",
                "चित\u{94d}रकला",
                "चौकट",
                "चौकटीतल\u{947}\u{902} चित\u{94d}र",
                "म\u{94d}य\u{941}जियम",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("алкак ичиндеги сүрөт"),
            keywords: &["алкак", "алкак ичиндеги сүрөт", "музей", "сүрөт", "өнөр"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("agerummt Bild"),
            keywords: &[
                "Bild",
                "Konscht",
                "Musée",
                "Rumm",
                "Tableau",
                "agerummt Bild",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຂອບຮ\u{eb9}ບ"),
            keywords: &[
                "ການແຕ\u{ec9}ມ",
                "ຂອບ",
                "ຂອບຮ\u{eb9}ບ",
                "ພ\u{eb4}ພ\u{eb4}ດຕະພ\u{eb1}ນ",
                "ສ\u{eb4}ນລະປະ",
                "ຮ\u{eb9}ບ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("rėmas su paveikslu"),
            keywords: &[
                "menas",
                "muziejus",
                "paveikslas",
                "piešinys",
                "rėmas",
                "rėmas su paveikslu",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("ierāmēta glezna"),
            keywords: &["glezna", "ierāmēta glezna", "muzejs", "māksla", "rāmis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pikitia whai anga"),
            keywords: &[
                "anga",
                "papa tongarewa",
                "pikitia",
                "pikitia whai anga",
                "toi",
                "toi peita",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("рамка со слика"),
            keywords: &["музеј", "рамка", "рамка со слика", "слика", "уметност"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ചിത\u{d4d}രം"),
            keywords: &[
                "കല",
                "ചിത\u{d4d}രം",
                "പെയിന\u{d4d}റിംഗ\u{d4d}",
                "മ\u{d4d}യ\u{d42}സിയം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("жаазтай зураг"),
            keywords: &["жааз", "жаазтай зураг", "зураг", "уран зураг"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("चित\u{94d}र असल\u{947}ली फ\u{94d}र\u{947}म"),
            keywords: &[
                "कला",
                "चित\u{94d}र",
                "चित\u{94d}र असल\u{947}ली फ\u{94d}र\u{947}म",
                "फ\u{94d}र\u{947}म",
                "फ\u{94d}र\u{947}म क\u{947}ल\u{947}ल\u{947} चित\u{94d}र",
                "र\u{902}गविण\u{947}",
                "स\u{902}ग\u{94d}रहालय",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bingkai dengan gambar"),
            keywords: &[
                "bingkai",
                "bingkai dengan gambar",
                "gambar",
                "gambar berbingkai",
                "lukisan",
                "muzium",
                "seni",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("stampa fi frejm"),
            keywords: &[
                "arti",
                "frejm",
                "mużew",
                "pittura",
                "stampa",
                "stampa fi frejm",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဘောင\u{103a}ပါသည\u{1037}\u{103a} ပ\u{102f}\u{1036}"),
            keywords: &[
                "ပန\u{103a}းချ\u{102e}",
                "ပြတ\u{102d}\u{102f}က\u{103a}",
                "ဘောင\u{103a}",
                "ဘောင\u{103a}ပါသည\u{1037}\u{103a} ပ\u{102f}\u{1036}",
                "ဘောင\u{103a}ပါသည\u{1037}\u{103a}ပ\u{102f}\u{1036}",
                "အန\u{102f}ပညာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("innrammet bilde"),
            keywords: &[
                "bilde",
                "innrammet bilde",
                "kunst",
                "maleri",
                "museum",
                "ramme",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("फ\u{94d}र\u{947}मका साथ चित\u{94d}र"),
            keywords: &[
                "कला",
                "चित\u{94d}र",
                "छाउनी",
                "तस\u{94d}बिर",
                "फ\u{94d}र\u{947}म",
                "फ\u{94d}र\u{947}मका साथ चित\u{94d}र",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("lijst met afbeelding"),
            keywords: &[
                "afbeelding",
                "kunst",
                "lijst",
                "lijst met afbeelding",
                "museum",
                "schilderij",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("innramma bilete"),
            keywords: &[
                "bilete",
                "innramma bilete",
                "kunst",
                "museum",
                "måleri",
                "ramme",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଫ\u{b4d}ରେମ\u{b4d}\u{200c}ଯ\u{b41}କ\u{b4d}ତ ଚ\u{b3f}ତ\u{b4d}ର"),
            keywords: &[
                "କଳ\u{b3e}",
                "ଚ\u{b3f}ତ\u{b4d}ର",
                "ଚ\u{b3f}ତ\u{b4d}ରକଳ\u{b3e}",
                "ଫ\u{b4d}ରେମ\u{b4d}\u{200c}",
                "ଫ\u{b4d}ରେମ\u{b4d}\u{200c}ଯ\u{b41}କ\u{b4d}ତ ଚ\u{b3f}ତ\u{b4d}ର",
                "ସଂଗ\u{b4d}ରହ\u{b3e}ଳୟ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਫਰ\u{a47}ਮ ਵਾਲੀ ਤਸਵੀਰ"),
            keywords: &[
                "ਕਲਾ",
                "ਤਸਵੀਰ",
                "ਪ\u{a47}ਟਿ\u{a70}ਗ",
                "ਫਰ\u{a47}ਮ",
                "ਫਰ\u{a47}ਮ ਵਾਲੀ ਤਸਵੀਰ",
                "ਮਿਊਜ\u{a3c}ੀਅਮ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("فریم آلی تص\u{651}ویر"),
            keywords: &[
                "تصویر",
                "عجائب گھر",
                "فریم آلی تص\u{651}ویر",
                "فن",
                "پینٹینگ",
                "چوکھٹا",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Píkchọ Wé Dẹm Pút Fọ Frem"),
            keywords: &[
                "Drọ\u{301}ying",
                "Frem",
                "Miuziọm",
                "Pent",
                "Píkchọ",
                "Píkchọ Wé Dẹm Pút Fọ Frem",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("obrazek w ramce"),
            keywords: &[
                "malarstwo",
                "muzeum",
                "obraz",
                "obrazek w ramce",
                "ramka",
                "sztuka",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("چوکاټ شوی انځور"),
            keywords: &["انځور", "رنګول", "فن", "موزيم", "چوکاټ", "چوکاټ شوی انځور"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("quadro emoldurado"),
            keywords: &["arte", "moldura", "pintura", "quadro", "quadro emoldurado"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("quadro com moldura"),
            keywords: &[
                "arte",
                "imagem",
                "moldura",
                "moldura com imagem",
                "museu",
                "pintura",
                "quadro com moldura",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("kanchapi rikchay"),
            keywords: &[
                "kancha",
                "kanchapi rikchay",
                "llimpi",
                "museo",
                "rikchay",
                "t’iktu",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("tablou înrămat"),
            keywords: &["artă", "muzeu", "pictură", "ramă", "tablou", "înrămat"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-815"),
            keywords: &["E10-815"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("картина"),
            keywords: &[
                "картина",
                "картина в раме",
                "картина в рамке",
                "пейзаж",
                "рама",
                "рамка",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ifoto iri mu ikadiri"),
            keywords: &[
                "gusiga irangi",
                "ifoto",
                "ifoto iri mu ikadiri",
                "ikadiri",
                "inzu ndangamurage",
                "ubugeni",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("فريم ٿيل تصوير"),
            keywords: &[
                "تصوير",
                "عجائب گھر",
                "فريم",
                "فريم ٿيل تصوير",
                "فن",
                "نقاشي",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ප\u{dd2}න\u{dca}ත\u{dd6}රය සහ\u{dd2}ත ර\u{dcf}ම\u{dd4}ව"),
            keywords: &[
                "කල\u{dcf}ව",
                "කෞත\u{dd4}ක\u{dcf}ග\u{dcf}රය",
                "ප\u{dd2}න\u{dca}ත\u{dd6}රය",
                "ප\u{dd2}න\u{dca}ත\u{dd6}රය සහ\u{dd2}ත ර\u{dcf}ම\u{dd4}ව",
                "ර\u{dcf}ම\u{dd4}ව",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("zarámovaný obraz"),
            keywords: &[
                "maľba",
                "múzeum",
                "obraz",
                "rám",
                "umenie",
                "zarámovaný obraz",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("uokvirjena slika"),
            keywords: &[
                "muzej",
                "okvir",
                "risba",
                "slika",
                "umetnost",
                "uokvirjena slika",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("sawirka la wareegay"),
            keywords: &[
                "farshaxan",
                "la wareegay",
                "matxafka",
                "rinjiyeen",
                "sawir",
                "sawir la wareegay",
                "sawirka la wareegay",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kornizë me pikturë"),
            keywords: &["art", "kornizë me pikturë", "muze", "pikturë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("рам са сликом"),
            keywords: &[
                "музej",
                "рам",
                "рам са сликом",
                "сликa",
                "сликaрствo",
                "умeтнoст",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["рам са сликом"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("ram sa slikom"),
            keywords: &[
                "muzej",
                "ram",
                "ram sa slikom",
                "slika",
                "slikarstvo",
                "umetnost",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["ram sa slikom"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("tavla"),
            keywords: &["bild i ram", "konst", "museum", "tavla"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("fremu yenye picha"),
            keywords: &[
                "fremu",
                "fremu yenye picha",
                "kuchora",
                "makumbusho",
                "picha",
                "sanaa",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஃபிரேமுடன\u{bcd} படம\u{bcd}"),
            keywords: &[
                "ஃபிரேமுடன\u{bcd} படம\u{bcd}",
                "பட ஃபிரேம\u{bcd}",
                "படம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("చ\u{c3f}త\u{c4d}రం ఉన\u{c4d}న ఫ\u{c4d}ర\u{c47}మ\u{c4d}"),
            keywords: &[
                "చ\u{c3f}త\u{c4d}రం",
                "చ\u{c3f}త\u{c4d}రం ఉన\u{c4d}న ఫ\u{c4d}ర\u{c47}మ\u{c4d}",
                "ఫ\u{c4d}ర\u{c47}మ\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("сурати чорчӯбадор"),
            keywords: &[
                "осорхона",
                "расм",
                "санъат",
                "сурат",
                "сурати чорчӯбадор",
                "чорчӯба",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ร\u{e39}ปใส\u{e48}กรอบ"),
            keywords: &[
                "กรอบร\u{e39}ป",
                "พ\u{e34}พ\u{e34}ธภ\u{e31}ณฑ\u{e4c}",
                "ภาพวาด",
                "ร\u{e39}ปภาพ",
                "ร\u{e39}ปใส\u{e48}กรอบ",
                "ศ\u{e34}ลปะ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("çarçuwaly surat"),
            keywords: &[
                "muzeý",
                "sungat",
                "surat",
                "surat çekmek",
                "çarçuwa",
                "çarçuwaly surat",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ʻesiaʻi tā"),
            keywords: &["ʻesiaʻi tā"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("resimli çerçeve"),
            keywords: &[
                "müze",
                "resim",
                "resimli çerçeve",
                "sanat",
                "yağlı boya",
                "çerçeve",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("رامكىلىق رەسىم"),
            keywords: &[
                "رامكا",
                "رامكىلىق رەسىم",
                "رەسىم",
                "رەسىم سىزىش",
                "سەنئەت",
                "مۇزېي",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("картина в рамці"),
            keywords: &["картина", "картина в рамці", "мистецтво", "музей", "рама"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("فریم میں جڑی تصویر"),
            keywords: &[
                "تصویر",
                "عجائب گھر",
                "فریم",
                "فریم شدہ تصویر",
                "فریم میں جڑی تصویر",
                "فن",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ramkali surat"),
            keywords: &[
                "hoshiya",
                "muzey",
                "ramka",
                "ramkali surat",
                "rasm",
                "rassomlik",
                "san’at",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("tranh trong khung"),
            keywords: &[
                "bảo tàng",
                "khung",
                "nghệ thuật",
                "tranh",
                "tranh trong khung",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("nataal buñ kaadare"),
            keywords: &[
                "art",
                "kaadar",
                "muse",
                "nataal",
                "nataal buñ kaadare",
                "pentiir",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umfanekiso onasekhelo"),
            keywords: &[
                "imuziyam",
                "isakhelo",
                "ubugcisa",
                "umfanekiso",
                "umfanekiso onasekhelo",
                "umzobo",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("àwọrán inú férémù"),
            keywords: &[
                "férémù",
                "ilé ọnà",
                "iṣẹ\u{301} ọná",
                "kíkùn",
                "àwòrán",
                "àwọrán inú férémù",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("框畫"),
            keywords: &["博物館", "圖片", "框架", "框畫", "繪畫", "藝術"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("框画"),
            keywords: &["博物馆", "图片", "框架", "框画", "绘画", "艺术"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("带框的画"),
            keywords: &["博物馆", "带框的画", "框", "画", "艺术"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("裱框畫"),
            keywords: &["畫", "裱框畫"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("相片連相框"),
            keywords: &["畫", "相片連相框"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ifulemu enesithombe"),
            keywords: &[
                "ifulemu",
                "ifulemu enesithombe",
                "imyuziyemu",
                "isithombe",
                "ubuciko",
            ],
        },
    ],
};
#[doc = "🎨"]
pub const ARTIST_PALETTE: crate::Emoji = crate::Emoji {
    glyph: "🎨",
    codepoint: "1F3A8",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "artist palette",
    group: "Activities",
    subgroup: "arts & crafts",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("kunstenaarpalet"),
            keywords: &[
                "kuns",
                "kunstenaarpalet",
                "museum",
                "palet",
                "skilder",
                "verf",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የሠዓሊ ሳሕን"),
            keywords: &["ሥነ ጥበብ", "ቤተ መዘክር", "የሠዓሊ ሳሕን", "የሥዕል ቅብ ሥራ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("لوحة ألوان الرسام"),
            keywords: &["رسم", "لوحة", "لوحة ألوان الرسام"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("চিত\u{9cd}ৰশিল\u{9cd}পীৰ পেলেট"),
            keywords: &[
                "কল\u{9be}",
                "চিত\u{9cd}ৰশিল\u{9cd}পীৰ পেলেট",
                "পেইণ\u{9cd}টিং",
                "পেলেট",
                "মিউজিয\u{9bc}\u{9be}ম",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("rəssam palitrası"),
            keywords: &[
                "incəsənət",
                "muzey",
                "palitra",
                "rəssam palitrası",
                "çəkmək",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("палітра мастака"),
            keywords: &[
                "карціна",
                "мастацтва",
                "музей",
                "палітра",
                "палітра мастака",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("палитра на художник"),
            keywords: &[
                "Палитра на художник",
                "изкуство",
                "картина",
                "музей",
                "палитра",
                "палитра на художник",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("শিল\u{9cd}পী প\u{9cd}য\u{9be}লেট"),
            keywords: &[
                "কল\u{9be}",
                "পেন\u{9cd}টিং",
                "প\u{9cd}য\u{9be}লেট",
                "মিউজিয\u{9bc}\u{9be}ম",
                "শিল\u{9cd}পী প\u{9cd}য\u{9be}লেট",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("pladennad livioù"),
            keywords: &["arz", "pladenn", "pladennad livioù"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("slikarska paleta"),
            keywords: &["muzej", "paleta", "slika", "slikarska paleta", "umjetnost"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("paleta d’artista"),
            keywords: &["artista", "museu", "paleta", "paleta d’artista", "pintura"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᏑᏫᏗᎩ ᏯᏖᎾ"),
            keywords: &["ᎤᏪᏘ ᎠᏍᏆᏂᎪᏛᎢ", "ᏓᏑᏫᏍᎬᎢ", "ᏗᏑᏫᏗᎩ ᏯᏖᎾ", "ᏗᏟᎶᏍᏔᏅᎢ", "ᏯᏖᎾ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("malířská paleta"),
            keywords: &[
                "malování",
                "malíř",
                "malířská paleta",
                "malířství",
                "muzeum",
                "paleta",
                "umění",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("palet arlunydd"),
            keywords: &["amgueddfa", "celf", "paentiad", "palet arlunydd"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("palet"),
            keywords: &["farver", "kunstner", "maler", "palet"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Mischpalette"),
            keywords: &["Farben", "Kunst", "Künstler", "Mischpalette", "Palette"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("παλέτα ζωγράφου"),
            keywords: &["μουσείο", "πίνακας", "παλέτα", "παλέτα ζωγράφου", "τέχνη"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("artist palette"),
            keywords: &["art", "artist palette", "museum", "painting", "palette"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("paleta de pintor"),
            keywords: &["arte", "artista", "paleta", "paleta de pintor", "pintura"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("paleta de pinturas"),
            keywords: &[
                "arte",
                "artista",
                "paleta",
                "paleta de pinturas",
                "pintor",
                "pintura",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["arte", "artista", "paleta", "paleta de pinturas", "pintor"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["arte", "artista", "paleta", "paleta de pinturas", "pintor"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kunstniku palett"),
            keywords: &["kunst", "kunstniku palett", "maal", "muuseum", "palett"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("margolari-paleta"),
            keywords: &["arte", "margo", "margolari-paleta", "museo", "paleta"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پالت نقاشی"),
            keywords: &["شستی نقاشی", "موزه", "نقاشی", "هنر", "پالت"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("taiteilijan paletti"),
            keywords: &["maalari", "maali", "taide", "taiteilijan paletti"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("paleta ng pintor"),
            keywords: &["art", "painting", "paleta", "paleta ng pintor", "pintor"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("litafjøl"),
            keywords: &["list", "litaborð", "litafjøl", "mála", "palett"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("palette de peinture"),
            keywords: &[
                "art",
                "musée de peinture",
                "palette de peinture",
                "peinture",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["art", "musée", "palette", "palette de peinture", "peinture"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("pailéad dathanna"),
            keywords: &[
                "ealaín",
                "ealaíontóir",
                "pailéad dathanna",
                "pictiúr",
                "péint",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("paileat neach-ealain"),
            keywords: &[
                "dealbh",
                "ealan",
                "paidhleat",
                "paileat neach-ealain",
                "taigh-tasgaidh",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("paleta de artista"),
            keywords: &["arte", "museo", "paleta", "paleta de artista", "pintura"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("આર\u{acd}ટિસ\u{acd}ટ પ\u{ac7}લ\u{ac7}ટ"),
            keywords: &[
                "આર\u{acd}ટિસ\u{acd}ટ",
                "કળા",
                "પ\u{ac7}ઇન\u{acd}ટ પ\u{ac7}લ\u{ac7}ટ",
                "પ\u{ac7}ઈન\u{acd}ટ",
                "પ\u{ac7}લ\u{ac7}ટ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("allon mai zane"),
            keywords: &[
                "allon fenti",
                "allon mai zane",
                "fasaha",
                "fenti",
                "ma’adanar kayayyakin tarihi",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פלטת צבעים"),
            keywords: &["אמן", "אמנות", "מוזיאון", "פלטת צבעים", "צבעים", "ציור"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("र\u{902}ग पट\u{94d}टिका, कलाकार प\u{948}ल\u{947}ट"),
            keywords: &[
                "कला",
                "कलाकार",
                "प\u{947}\u{902}ट",
                "प\u{948}ल\u{947}ट",
                "र\u{902}ग पट\u{94d}टिका",
                "र\u{902}ग पट\u{94d}टिका, कलाकार प\u{948}ल\u{947}ट",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("slikarska paleta"),
            keywords: &[
                "muzej",
                "paleta",
                "slikarska paleta",
                "slikarstvo",
                "umjetnost",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("festőpaletta"),
            keywords: &["festőpaletta", "galéria", "múzeum", "művészet", "paletta"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ներկապնակ"),
            keywords: &["արվեստ", "թանգարան", "ներկապնակ", "նկարչություն"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("palet pelukis"),
            keywords: &["lukisan", "museum", "palet", "palet pelukis", "seni"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("obosara osisi onye ǹkà"),
            keywords: &[
                "fremụ",
                "ihe ǹkà",
                "ite àgbà",
                "obosara osisi onye ǹkà",
                "osisi onye ǹkà",
                "ụlọ nchekwa ǹkà",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("litapalletta"),
            keywords: &["list", "litapalletta", "litaspjald", "málning", "palletta"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("tavolozza"),
            keywords: &[
                "arte",
                "colori",
                "pittura",
                "tavolozza",
                "tavolozza dei colori",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("絵の具パレット"),
            keywords: &["パレット", "絵", "絵の具パレット", "美術館"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("palet pelukis"),
            keywords: &["lukisan", "museum", "palet", "palet pelukis", "seni"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მხატვრის პალიტრა"),
            keywords: &[
                "მუზეუმი",
                "მხატვრის პალიტრა",
                "ნახატი",
                "პალიტრა",
                "ხატვა",
                "ხელოვნება",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("палитра"),
            keywords: &["мұражай", "палитра", "сурет салу", "өнер"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("palet"),
            keywords: &["farver", "kunstner", "maler", "palet"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "ក\u{17d2}តារថ\u{17d2}នា\u{17c6}ពណ\u{17cc}សម\u{17d2}រាប\u{17cb}ជាងគ\u{17c6}ន\u{17bc}",
            ),
            keywords: &[
                "ក\u{17bc}ល\u{17d0}រ",
                "ក\u{17d2}តារថ\u{17d2}នា\u{17c6}ពណ\u{17cc}សម\u{17d2}រាប\u{17cb}ជាងគ\u{17c6}ន\u{17bc}",
                "ពណ\u{17cc}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕಲಾವ\u{cbf}ದರ ವರ\u{ccd}ಣಫಲಕ"),
            keywords: &[
                "ಕಲಾವ\u{cbf}ದನ ವರ\u{ccd}ಣ ಸಾಧನ",
                "ಕಲಾವ\u{cbf}ದರ ವರ\u{ccd}ಣಫಲಕ",
                "ವರ\u{ccd}ಣ ಸಾಧನ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("팔레트"),
            keywords: &["그림", "그림 그리기", "미술", "팔레트"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("कला फळो"),
            keywords: &["कला", "चित\u{94d}रकला", "फळो", "म\u{94d}य\u{941}जियम"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("сүрөтчүнүн боёктору"),
            keywords: &["боёк", "музей", "сүрөт", "сүрөтчүнүн боёктору", "өнөр"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Faarfpalett"),
            keywords: &[
                "Bild",
                "Faarfpalett",
                "Konscht",
                "Musée",
                "Palett",
                "Tableau",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຈານປະສ\u{ebb}ມສ\u{eb5}"),
            keywords: &[
                "ການແຕ\u{ec9}ມ",
                "ຈານ",
                "ຈານປະສ\u{ebb}ມສ\u{eb5}",
                "ພ\u{eb4}ພ\u{eb4}ດຕະພ\u{eb1}ນ",
                "ສ\u{eb4}ນລະປະ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("dailininko paletė"),
            keywords: &[
                "dailininko paletė",
                "menas",
                "muziejus",
                "paletė",
                "piešinys",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("gleznotāja palete"),
            keywords: &["glezna", "gleznotāja palete", "māksla", "palete"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("papapeita tohunga toi"),
            keywords: &[
                "papa tongarewa",
                "papapeita",
                "papapeita tohunga toi",
                "toi",
                "toi peita",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("сликарска палета"),
            keywords: &["палета", "сликарска палета", "сликање", "уметност"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ച\u{d3e}യപ\u{d4d}പലക"),
            keywords: &[
                "ച\u{d3e}യപ\u{d4d}പലക",
                "ചിത\u{d4d}രം",
                "പെയിന\u{d4d}റിംഗ\u{d4d}",
                "പെയിന\u{d4d}റ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("уран зургийн паллет"),
            keywords: &["паллет", "уран зураг", "уран зургийн паллет"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("र\u{902}गफळी"),
            keywords: &[
                "कला",
                "कलाकार र\u{902}गफळी",
                "र\u{902}गफळी",
                "र\u{902}गविण\u{947}",
                "स\u{902}ग\u{94d}रहालय",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("palet artis"),
            keywords: &["lukisan", "muzium", "palet", "palet artis", "seni"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("tavlozza"),
            keywords: &["arti", "mużew", "pittura", "tavlozza"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဆေးစပ\u{103a}ရာ အပြား"),
            keywords: &[
                "ဆေးစပ\u{103a}ရာ အပြား",
                "ပန\u{103a}းချ\u{102e}ဆ\u{103d}\u{1032}ခြင\u{103a}း",
                "ပြတ\u{102d}\u{102f}က\u{103a}",
                "အန\u{102f}ပညာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("malerpalett"),
            keywords: &["kunst", "malerpalett", "maling"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("कलाकारको प\u{94d}याल\u{947}ट"),
            keywords: &[
                "कला",
                "कलाकारको प\u{94d}याल\u{947}ट",
                "चित\u{94d}र",
                "छाउनी",
                "प\u{94d}याल\u{947}ट",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("schilderspalet"),
            keywords: &["kunst", "museum", "palet", "schilderij", "schilderspalet"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("målarpalett"),
            keywords: &["kunst", "målarpalett", "måling"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଶ\u{b3f}ଳ\u{b4d}ପୀଙ\u{b4d}କ ଆଧ\u{b3e}ର"),
            keywords: &[
                "ଅସ\u{b4d}ଥ\u{b3e}ୟୀ ଶଯ\u{b4d}ୟ\u{b3e}",
                "କଳ\u{b3e}",
                "କଳ\u{b3e}କ\u{b3e}ର",
                "କଳ\u{b3e}କ\u{b3e}ର ଶଯ\u{b4d}ୟ\u{b3e}",
                "ରଙ\u{b4d}ଗ",
                "ରଙ\u{b4d}ଗ ଶଯ\u{b4d}ୟ\u{b3e}",
                "ଶ\u{b3f}ଳ\u{b4d}ପୀଙ\u{b4d}କ ଆଧ\u{b3e}ର",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕਲਾਕਾਰ ਪ\u{a48}ਲਅਟ"),
            keywords: &[
                "ਕਲਾ",
                "ਕਲਾਕਾਰ",
                "ਪ\u{a48}ਲਅਟ",
                "ਮਿਊਜ\u{a3c}ੀਅਮ",
                "ਰ\u{a70}ਗ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("مصور دی تختی"),
            keywords: &[
                "عجائب گھر",
                "فن",
                "مصور دی تختی",
                "مص\u{651}ور دی تختی",
                "پینٹینگ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Plet Wé Átist De Ték Míks Pent"),
            keywords: &[
                "Drọ\u{301}ying",
                "Miuziọm",
                "Plet",
                "Plet Wé Átist De Ték Míks Pent",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("paleta malarska"),
            keywords: &[
                "farby",
                "kolory",
                "malarz",
                "muzeum",
                "paleta malarska",
                "sztuka",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("فنکار تخته"),
            keywords: &["تخته", "رنګول", "فن", "فنکار تخته", "موزيم"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("paleta de tintas"),
            keywords: &[
                "arte",
                "artista",
                "paleta",
                "paleta artística",
                "paleta de tintas",
                "pintura",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("paleta de artista"),
            keywords: &["arte", "museu", "paleta", "paleta de artista", "pintura"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("paleta llimpiq"),
            keywords: &["llimpi", "museo", "paleta", "paleta llimpiq", "t’iktu"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("paletă de pictor"),
            keywords: &[
                "artist",
                "artă",
                "muzeu",
                "paletă",
                "paletă de pictor",
                "pictură",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-360"),
            keywords: &["E10-360"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("палитра с красками"),
            keywords: &["краски", "палитра", "палитра с красками"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("akadirishya nderembyi k’abahanzi"),
            keywords: &[
                "akadirishya nderembyi k’abahanzi",
                "amabara",
                "gusiga irangi",
                "inzu ndangamurange",
                "ubugeni",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("پينٽر جي رنگ جي تختي"),
            keywords: &[
                "رنگن جي تختي",
                "عجائب گھر",
                "نقاشي",
                "پينٽر جي رنگ جي تختي",
                "ڪلا",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කල\u{dcf} ප\u{dd4}වර\u{dd4}ව"),
            keywords: &[
                "කල\u{dcf} ප\u{dd4}වර\u{dd4}ව",
                "කල\u{dcf}ව",
                "කෞත\u{dd4}ක\u{dcf}ග\u{dcf}රය",
                "ප\u{dd2}න\u{dca}ත\u{dcf}ර\u{dd4} ක\u{dd2}ර\u{dd3}ම",
                "ප\u{dd4}වර\u{dd4}ව",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("maliarska paleta"),
            keywords: &["maliarska paleta", "maľba", "múzeum", "paleta", "umenie"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("slikarska paleta"),
            keywords: &["muzej", "paleta", "slika", "slikarska paleta", "umetnost"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("farshaxan saxan"),
            keywords: &[
                "farshaxan saxan",
                "farshaxanka",
                "matxafka",
                "rinjiyeen",
                "saxan",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("paleta e artistit"),
            keywords: &["art", "muze", "paleta e artistit", "paletë", "pikturë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("сликарска палета"),
            keywords: &[
                "музej",
                "пaлeтa",
                "сликaрствo",
                "сликарска палета",
                "умeтнoст",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["сликарска палета"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("slikarska paleta"),
            keywords: &[
                "muzej",
                "paleta",
                "slikarska paleta",
                "slikarstvo",
                "umetnost",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["slikarska paleta"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("färgpalett"),
            keywords: &["färger", "färgpalett", "konst", "palett"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("paleti ya msanii"),
            keywords: &[
                "kuchora",
                "makumbusho",
                "paleti",
                "paleti ya msanii",
                "sanaa",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வண\u{bcd}ணத\u{bcd} தட\u{bcd}டு"),
            keywords: &[
                "ஓவியம\u{bcd}",
                "கலை",
                "வண\u{bcd}ணங\u{bcd}கள\u{bcd}",
                "வண\u{bcd}ணத\u{bcd} தட\u{bcd}டு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("రంగుల ఫలకం"),
            keywords: &["ఫలకం", "రంగు", "రంగుల ఫలకం"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("лавҳачаи рассомии рассом"),
            keywords: &[
                "лавҳачаи рассомии рассом",
                "лавҳачаи рассомӣ",
                "осорхона",
                "расм",
                "санъат",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("จานส\u{e35}วาดร\u{e39}ป"),
            keywords: &[
                "จานส\u{e35}",
                "จานส\u{e35}วาดร\u{e39}ป",
                "พ\u{e34}พ\u{e34}ธภ\u{e31}ณฑ\u{e4c}",
                "ภาพวาด",
                "ศ\u{e34}ลปะ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("suratkeş palitrasy"),
            keywords: &[
                "muzeý",
                "palitra",
                "sungat",
                "surat çekmek",
                "suratkeş palitrasy",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tāvalivali"),
            keywords: &["tāvalivali"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("boya paleti"),
            keywords: &[
                "boya",
                "boya paleti",
                "palet",
                "sanat",
                "sanatçı",
                "sanatçı paleti",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("بوياق تاختىسى"),
            keywords: &["بوياق تاختىسى", "سىزىش", "سەنئەت", "مۇزېي"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("палітра художника"),
            keywords: &[
                "картина",
                "мистецтво",
                "музей",
                "палітра",
                "палітра художника",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("آرٹسٹ پیلٹ"),
            keywords: &["آرٹسٹ پیلٹ", "عجائب گھر", "فن", "پینٹنگ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("palitra"),
            keywords: &["muzey", "paletra", "palitra", "rassomlik", "san’at"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bảng màu"),
            keywords: &["bảng màu", "bảo tàng", "nghệ thuật", "vẽ"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("boolu pentiirukaay"),
            keywords: &["art", "boolu pentiirukaay", "muse", "palette", "pentiir"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iplanga lepeyinti legcisa"),
            keywords: &[
                "imuziyam",
                "iplanga lepeyinti legcisa",
                "ubugcisa",
                "umfanekiso",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Pẹpẹ Oṣere"),
            keywords: &[
                "Pẹpẹ Oṣere",
                "ilé ọnà",
                "iṣẹ\u{301} ọná",
                "kíkùn",
                "pálẹ\u{301}tì",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("調色板"),
            keywords: &["博物館", "繪畫", "藝術", "調色板"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("调色板"),
            keywords: &["博物馆", "绘画", "艺术", "调色板"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("调色盘"),
            keywords: &["博物馆", "画画", "艺术", "调色板", "调色盘"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("調色板"),
            keywords: &["調色板", "調色盤"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ibhodi lengcweti yokupenda"),
            keywords: &[
                "ibhodi lengcweti yokupenda",
                "imyuziyemu",
                "isithombe esipendiwe",
                "ubuciko",
            ],
        },
    ],
};
#[doc = "🧵"]
pub const THREAD: crate::Emoji = crate::Emoji {
    glyph: "🧵",
    codepoint: "1F9F5",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "thread",
    group: "Activities",
    subgroup: "arts & crafts",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("garing"),
            keywords: &["gare", "garing", "naald", "naaldwerk", "tol"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ክር"),
            keywords: &["መርፌ", "መስፋት", "ክር", "ገመድ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("بكرة خيط"),
            keywords: &["إبرة", "بكرة", "بكرة خيط", "حياكة", "خياطة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("স\u{9c1}ত\u{9be}"),
            keywords: &[
                "গ\u{9c1}ণ\u{9be}",
                "চিল\u{9be}ই",
                "বেজি",
                "স\u{9c1}ত\u{9be}",
                "স\u{9cd}প\u{9c1}ল",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("sap"),
            keywords: &["iynə", "kələfçə", "sap", "tikiş"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("нітка"),
            keywords: &["нітка", "шпулька", "шыццё", "іголка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("конец"),
            keywords: &["игла", "конец", "макара", "нишка", "шиене"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("স\u{9c1}ত\u{9be}"),
            keywords: &[
                "দড\u{9bc}ি",
                "ন\u{9be}ট\u{9be}ই",
                "স\u{9c1}ত\u{9be}",
                "স\u{9c2}\u{981}চ",
                "সেল\u{9be}ই",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kanellad neud"),
            keywords: &["kanell", "kanellad neud", "nadoz", "neud"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("konac"),
            keywords: &["igla", "konac", "šivanje", "šivenje", "šplulna"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("fil"),
            keywords: &["bobina", "cosir", "fil", "rodet"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏍᏘ"),
            keywords: &["ᎠᏍᏘ", "ᎠᏍᏘ ᎠᏍᏆᏂᎪᏗᏍᎩ", "ᎦᏰᏫᏍᎩ", "ᏴᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("cívka nití"),
            keywords: &["cívka nití", "jehla", "nit", "vlákno", "šití", "špulka"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("edafedd"),
            keywords: &["edafedd", "gwnïo", "llinyn", "nodwydd", "rîl"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("tråd"),
            keywords: &["nål", "sy", "trisse", "tråd"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Faden"),
            keywords: &["Faden", "Nadel", "Nähen", "Zwirn"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κλωστή"),
            keywords: &["βελόνα", "καρούλι", "κλωστή", "ράψιμο", "σπάγγος"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("thread"),
            keywords: &["needle", "sewing", "spool", "string", "thread"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("hilo"),
            keywords: &["aguja", "carrete", "coser", "costura", "hilo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("hilo"),
            keywords: &["aguja", "bobina", "carrete", "cordel", "coser", "hilo"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("hilo"),
            keywords: &["hilo"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("niit"),
            keywords: &["niidirull", "niit", "nõel", "õmblemine"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("hari"),
            keywords: &["hari", "haril", "joste", "lokarri", "orratz"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("نخ"),
            keywords: &["خیاطی", "سوزن", "قرقره", "ماسوره", "نخ"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("lankarulla"),
            keywords: &[
                "lanka",
                "lankarulla",
                "neula",
                "ompelu",
                "rulla",
                "rullalanka",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("sinulid"),
            keywords: &["karayom", "pananahi", "sinulid", "spool", "tali"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("tráður"),
            keywords: &["nál", "seyma", "spoli", "tráður"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("bobine de fil"),
            keywords: &["aiguille", "bobine", "bobine de fil", "couture", "ficelle"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("snáth"),
            keywords: &["biorán", "fuáil", "snáth", "spól", "téad"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("snàithlean"),
            keywords: &[
                "fuaigh",
                "fuaigheil",
                "snàithlean",
                "snàthad",
                "snìomh",
                "snìomhan",
                "spàl",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("fío"),
            keywords: &["agulla", "bobina", "carrete", "coser", "fío"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("દોરો"),
            keywords: &["કોકડી", "દોરી પરોવવી", "દોરો", "સીવણ", "સોય"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("חוט"),
            keywords: &["חוט", "מחט", "סליל", "תפירה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("धागा"),
            keywords: &["डोर", "धागा", "रील", "सिलना", "स\u{941}ई"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("konac"),
            keywords: &["konac", "uzica", "šivanje", "šivaća igla"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("cérna"),
            keywords: &["cérna", "madzag", "orsó", "tű", "varrás"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("թել"),
            keywords: &["ասեղ", "թել", "կար", "կոճ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("benang"),
            keywords: &["benang", "gulungan", "jahit", "jarum"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("tvinni"),
            keywords: &["kefli", "nál", "sauma", "tvinni", "þráður"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("filo"),
            keywords: &["ago", "filo", "rocchetto"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("糸"),
            keywords: &["ひも", "糸", "糸巻き", "縫い針", "裁縫"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("benang"),
            keywords: &["benang", "dom", "njait", "senar", "sepul"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ძაფის კოჭა"),
            keywords: &["კერვა", "მკედი", "ნემსი", "ძაფი", "ძაფის კოჭა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жіп"),
            keywords: &["жіп", "ине", "катушка", "талшық", "тоқу"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សរសៃអ\u{17c6}បោះ"),
            keywords: &[
                "ការដេរ",
                "ខ\u{17d2}នារ",
                "ខ\u{17d2}សែ",
                "ម\u{17d2}ជ\u{17bb}ល",
                "សរសៃអ\u{17c6}បោះ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ದಾರ"),
            keywords: &[
                "ದಾರ",
                "ಸ\u{cc2}ಜ\u{cbf}",
                "ಸ\u{ccd}ಟ\u{ccd}ರ\u{cbf}ಂಗ\u{ccd}",
                "ಸ\u{ccd}ಪ\u{cc2}ಲ\u{ccd}",
                "ಹೊಲ\u{cbf}ಗ\u{cc6}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("실타래"),
            keywords: &["뜨개질", "바느질", "바늘", "실", "실타래"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("धागो"),
            keywords: &[
                "धाग\u{947}",
                "धागो",
                "शि\u{902}वप",
                "स\u{941}त",
                "स\u{941}य",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жип"),
            keywords: &["жип", "ийне", "тигүү", "түрмөк"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເສ\u{eb1}\u{ec9}ນດ\u{ec9}າຍ"),
            keywords: &[
                "ກ\u{ecd}\u{ec9}າແລນ",
                "ຍ\u{eb4}ບແຊ\u{ec8}ວ",
                "ເຂ\u{eb1}ມ",
                "ເສ\u{eb1}\u{ec9}ນດ\u{ec9}າຍ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("siūlas"),
            keywords: &["adata", "gija", "ritė", "siuvimas", "siūlas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("pavediens"),
            keywords: &["adata", "pavediens", "spolīte", "šūšana"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("конец"),
            keywords: &["игла", "конец", "макара", "шиење"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ന\u{d42}ൽ"),
            keywords: &[
                "ചരട\u{d4d}",
                "ത\u{d41}ന\u{d4d}നൽ",
                "ന\u{d42}ൽ",
                "ന\u{d42}ൽ ച\u{d41}റ\u{d4d}റ\u{d41}ന\u{d4d}ന ക\u{d41}ഴൽ",
                "സ\u{d42}ചി",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("утас"),
            keywords: &["зүү", "оёх", "утас", "утасны дамар"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("धागा"),
            keywords: &[
                "धागा",
                "शिवण",
                "स\u{941}ई",
                "स\u{94d}ट\u{94d}रि\u{902}ग",
                "स\u{94d}प\u{942}ल",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("benang"),
            keywords: &["benang", "gelendong", "jarum", "menjahit", "tali"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အပ\u{103a}ချည\u{103a}"),
            keywords: &[
                "ကြ\u{102d}\u{102f}းစ",
                "ရစ\u{103a}လ\u{102f}\u{1036}း",
                "အချ\u{102f}ပ\u{103a}အလ\u{102f}ပ\u{103a}",
                "အပ\u{103a}",
                "အပ\u{103a}ချည\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("tråd"),
            keywords: &["nål", "snelle", "sy", "tråd", "trådsnelle"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("धागो"),
            keywords: &[
                "डोरी",
                "धागो",
                "धागो ब\u{947}र\u{94d}न\u{947} चक\u{94d}का",
                "सियो",
                "सिलाउन\u{947} कार\u{94d}य",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("garen"),
            keywords: &["draad", "garen", "klos", "naaien", "naald"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("tråd"),
            keywords: &["nål", "snelle", "sy", "tråd", "trådsnelle"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସ\u{b41}ତ\u{b3e}"),
            keywords: &[
                "ଛ\u{b41}ଞ\u{b4d}ଚ\u{b3f}",
                "ସ\u{b3f}ଲ\u{b3e}ଇ",
                "ସ\u{b41}ତ\u{b3e}",
                "ସ\u{b4d}ପ\u{b41}ଲ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਧਾਗਾ"),
            keywords: &["ਡ\u{a4b}ਰੀ", "ਧਾਗਾ", "ਫਿਰਕੀ", "ਸਿਲਾਈ", "ਸ\u{a42}ਈ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Trẹd"),
            keywords: &["Nídul", "String", "Sóyin", "Trẹd"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("nić"),
            keywords: &["igła", "nawlekać", "nić", "szpulka", "szycie"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("تار"),
            keywords: &["تار", "رسۍ", "ستن", "ګنډل", "ګوټ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("carretel"),
            keywords: &["agulha", "barbante", "carretel", "costura"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("fio"),
            keywords: &["agulha", "barbante", "carretel", "costura", "fio"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("ață"),
            keywords: &["ac", "ață", "croitorie", "cusut", "mosor"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E11-063"),
            keywords: &["E11-063"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("катушка ниток"),
            keywords: &["катушка", "катушка ниток", "нитки", "шитье"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڌاڳو"),
            keywords: &["اسٽرنگ", "اسپول", "سلائي", "نيڊل", "ڌاڳو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("න\u{dd6}ල\u{dca}"),
            keywords: &[
                "ඉඳ\u{dd2}කට\u{dd4}ව",
                "න\u{dd4}ල",
                "න\u{dd4}ල\u{dca} බෝලය",
                "න\u{dd6}ල\u{dca}",
                "මැහ\u{dd2}ම",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("cievka nite"),
            keywords: &["cievka", "cievka nite", "ihla", "niť", "vlákno", "šitie"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("sukanec"),
            keywords: &["navitek", "nit", "sukanec", "šivanje", "šivanka"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("dun"),
            keywords: &["dun", "irbadda dharka", "tolmada", "xarig"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fije"),
            keywords: &["fije", "gjilpërë", "qep", "rrotë peri", "spango"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("конац"),
            keywords: &["игла", "калем", "конац", "нит", "шивење"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["конац"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("konac"),
            keywords: &["igla", "kalem", "konac", "nit", "šivenje"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["konac"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("tråd"),
            keywords: &["nål", "spole", "tråd", "trådrulle"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uzi"),
            keywords: &["kigurudumu cha uzi", "kushona", "sindano", "uzi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("நூல\u{bcd}"),
            keywords: &[
                "ஊசி",
                "சரம\u{bcd}",
                "தையல\u{bcd}",
                "நூல\u{bcd}",
                "ஸ\u{bcd}பூல\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ద\u{c3e}రం"),
            keywords: &[
                "కుట\u{c4d}టడం",
                "ద\u{c3e}రం",
                "సూద\u{c3f}",
                "స\u{c4d}ట\u{c4d}ర\u{c3f}ంగ\u{c4d}",
                "స\u{c4d}పూల\u{c4d}",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ด\u{e49}าย"),
            keywords: &[
                "ด\u{e49}าย",
                "ต\u{e31}ดเย\u{e47}บ",
                "หลอดด\u{e49}าย",
                "เข\u{e47}ม",
                "เย\u{e47}บผ\u{e49}า",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýüp"),
            keywords: &["iňňe", "sapak", "tegek", "tikin", "ýüp"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("filo"),
            keywords: &["filo"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("iplik"),
            keywords: &["dikiş", "iplik", "iğne", "makara"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("нитка"),
            keywords: &["голка", "нитка", "пряжа", "шиття"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("دھاگہ"),
            keywords: &["دھاگہ", "سلائی", "سوئی", "چرخی", "ڈوری"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("g‘altak"),
            keywords: &["g‘altak", "ip", "ip g‘altagi", "tikish"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("sợi chỉ"),
            keywords: &["kim", "may", "sợi chỉ", "xâu", "ổng chỉ"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("繩"),
            keywords: &["卷", "線", "縫紉", "繩", "針"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("绳"),
            keywords: &["卷", "线", "绳", "缝纫", "针"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("线"),
            keywords: &["线", "线轴", "绳子", "缝纫", "针"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("線"),
            keywords: &["線", "線軸", "縫紉", "針"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("E11:063"),
            keywords: &["E11:063"],
        },
    ],
};
#[doc = "🪡"]
pub const SEWING_NEEDLE: crate::Emoji = crate::Emoji {
    glyph: "🪡",
    codepoint: "1FAA1",
    status: crate::Status::FullyQualified,
    introduction_version: 13f32,
    name: "sewing needle",
    group: "Activities",
    subgroup: "arts & crafts",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("naaldwerknaald"),
            keywords: &["borduur", "naald", "naaldwerk", "naaldwerknaald", "steke"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የመስፊያ መርፌ"),
            keywords: &["የመስፊያ መርፌ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("إبرة خياطة"),
            keywords: &["إبرة", "تطريز", "خياطة", "غرز"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("চিল\u{9be}ই কৰ\u{9be} বেজি"),
            keywords: &[
                "এম\u{9cd}ব\u{9cd}ৰইড\u{9be}ৰী",
                "চিল\u{9be}ই",
                "চিল\u{9be}ই কৰ\u{9be}",
                "চিল\u{9be}ই কৰ\u{9be} বেজি",
                "দৰ\u{9cd}জি",
                "বেজি",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("tikiş maşınının iynəsi"),
            keywords: &[
                "dərzilik",
                "ilgəklər",
                "iynə",
                "naxış",
                "tikiş",
                "tikiş maşınının iynəsi",
                "tikiş yolları",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("швейная іголка"),
            keywords: &[
                "вышыўка",
                "пашыў",
                "швейная іголка",
                "швы",
                "шыццё",
                "шыўкі",
                "іголка",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("шивашка игла"),
            keywords: &[
                "бодове",
                "бродиране",
                "игла",
                "шевове",
                "шивач",
                "шивашка игла",
                "шиене",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("স\u{9c2}চ"),
            keywords: &[
                "এম\u{9cd}ব\u{9cd}রয\u{9bc}ড\u{9be}রি",
                "জোড\u{9bc}",
                "দরজি",
                "স\u{9c2}চ",
                "স\u{9c2}চের ফো\u{981}ড\u{9bc}",
                "সেল\u{9be}ই",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("nadoz da wriat"),
            keywords: &["broderezh", "gwriat", "nadoz", "nadoz da wriat"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("igla za šivenje"),
            keywords: &[
                "igla",
                "igla za šivenje",
                "krojenje",
                "šav",
                "šavovi",
                "šivanje",
                "šivenje",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("agulla de cosir"),
            keywords: &[
                "agulla",
                "agulla de cosir",
                "brodat",
                "costura",
                "modista",
                "puntada",
                "sutura",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏴᎩ"),
            keywords: &["ᎠᏂᏰᏩᏒᏍᎬ", "ᎤᏔᎾ ᎦᏰᏫᏒ", "ᎦᏰᏫᏍᎦ", "ᎦᏰᏫᏒ", "ᏗᏄᏬ ᏗᎦᏰᏩᏍᎩ", "ᏴᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("šicí jehla"),
            keywords: &[
                "jehla",
                "krejčovina",
                "stehy",
                "vyšívání",
                "výšivka",
                "šicí jehla",
                "šití",
                "švy",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("nodwydd wnïo"),
            keywords: &[
                "brodwaith",
                "edeifion",
                "gwnïo",
                "nodwydd",
                "nodwydd wnïo",
                "pwythau",
                "teilwra",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("synål"),
            keywords: &[
                "broderi",
                "nål",
                "skræddersyning",
                "sting",
                "sutur",
                "syning",
                "synål",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Nähnadel"),
            keywords: &[
                "Nadel",
                "Nähnadel",
                "Nähte",
                "Stiche",
                "nähen",
                "schneidern",
                "sticken",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("βελόνα ραψίματος"),
            keywords: &[
                "βελόνα",
                "βελόνα ραψίματος",
                "κέντημα",
                "μεταποίηση",
                "ράβω",
                "ράμματα",
                "ράψιμο",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("sewing needle"),
            keywords: &[
                "embroidery",
                "needle",
                "sewing",
                "stitches",
                "sutures",
                "tailoring",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("needle and thread"),
            keywords: &[
                "embroidery",
                "needle",
                "needle and thread",
                "sewing",
                "stitches",
                "sutures",
                "tailoring",
            ],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("aguja de coser"),
            keywords: &[
                "aguja",
                "aguja de coser",
                "bordado",
                "coser",
                "hilar",
                "punto",
                "tejer",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("aguja de coser"),
            keywords: &["aguja de coser"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("aguja de coser"),
            keywords: &["aguja de coser"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("õmblusnõel"),
            keywords: &[
                "nõel",
                "rätsep",
                "tikkimine",
                "õmblemine",
                "õmblused",
                "õmblusnõel",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("jostorratz"),
            keywords: &[
                "brodatua",
                "josi",
                "joskintza",
                "jostorratz",
                "jostura",
                "orratza",
                "puntada",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("سوزن خیاطی"),
            keywords: &["بخیه", "خیاطی", "دوختن", "سوزن", "کوک", "گل\u{200c}دوزی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("ompeluneula"),
            keywords: &[
                "kirjonta",
                "käsinompelu",
                "neula",
                "ompelu",
                "ompeluneula",
                "parsiminen",
                "silmäneula",
                "tikit",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("karayom"),
            keywords: &["burda", "karayom", "pananahi", "sinulid", "tahi"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("nál"),
            keywords: &[
                "baldýring",
                "lappa",
                "nál",
                "seyminál",
                "stingur",
                "íseyming",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("aiguille à coudre"),
            keywords: &[
                "aiguille à coudre",
                "broderie",
                "couture",
                "points",
                "suture",
                "tailleur",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("aiguille à coudre"),
            keywords: &[
                "aiguille",
                "aiguille à coudre",
                "broderie",
                "coudre",
                "couture",
                "coutures",
                "points",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("snáthaid fuála"),
            keywords: &[
                "bróidnéireacht",
                "fuáil",
                "greim",
                "snáthaid fuála",
                "táilliúireacht",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("snàthad"),
            keywords: &["druine", "fuaigheal", "greus", "grèis", "snàthad"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("agulla de coser"),
            keywords: &[
                "agulla de coser",
                "bordado",
                "coser",
                "modista",
                "puntada",
                "sutura",
                "xastre",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સીવવાની સોય"),
            keywords: &[
                "કપડા\u{a82} સીવવા",
                "ટા\u{a82}કા",
                "ટા\u{a82}કા મારી સીવવ\u{ac1}\u{a82}",
                "ભરતકામ",
                "સીવવાની સોય",
                "સીવવ\u{ac1}\u{a82}",
                "સોય",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מחט"),
            keywords: &["לרקום", "לתפור", "מחט", "רקמה", "תפירה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("स\u{942}ई"),
            keywords: &["कसीदाकारी", "टा\u{902}क\u{947}", "सिलाई", "स\u{942}ई"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("šivaća igla"),
            keywords: &[
                "igla",
                "krojenje",
                "vezenje",
                "šavovi",
                "šivanje",
                "šivaća igla",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("varrótű"),
            keywords: &[
                "hímzés",
                "szabászat",
                "tű",
                "varrat",
                "varrás",
                "varrótű",
                "öltés",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ասեղ"),
            keywords: &["ասեղ", "ասեղնագործ", "դերձակ", "թել"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("jarum jahit"),
            keywords: &[
                "jahit", "jahitan", "jarum", "menjahit", "penjahit", "sulaman",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("saumnál"),
            keywords: &[
                "nál",
                "sauma",
                "saumaspor",
                "saumnál",
                "sníða",
                "spor",
                "útsaumur",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("ago da cucito"),
            keywords: &[
                "ago",
                "ago da cucito",
                "cucito",
                "punti",
                "ricamo",
                "sartoria",
                "suture",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("縫い針"),
            keywords: &["ステッチ", "刺繍", "縫い針", "縫う", "裁縫", "針"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("jarum jait"),
            keywords: &["babakan jait", "jait", "jaitan", "jarum", "sulaman"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ნემსი"),
            keywords: &["კერვა", "ნაკერი", "ნემსი", "ქარგვა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("тігін ине"),
            keywords: &["жіп", "ине", "тігу", "тігін", "тігістер"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17d2}ជ\u{17bb}លដេរ"),
            keywords: &[
                "ការកាត\u{17cb}ដេរ",
                "ការដេរ",
                "ថ\u{17d2}នេរ",
                "ថ\u{17d2}នេររប\u{17bd}ស",
                "ម\u{17d2}ជ\u{17bb}ល",
                "ម\u{17d2}ជ\u{17bb}លដេរ",
                "រ\u{17bc}បប\u{17c9}ាក\u{17cb}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸ\u{cc2}ಜ\u{cbf}"),
            keywords: &[
                "ಸ\u{cc2}ಜ\u{cbf}",
                "ಹ\u{cc6}ಣ\u{cbf}ಗ\u{cc6}",
                "ಹೊಲ\u{cbf}ಗ\u{cc6}ಗಳು",
                "ಹೊಲ\u{cbf}ಯುವ\u{cbf}ಕ\u{cc6}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("바늘"),
            keywords: &["바느질", "바늘", "봉합", "자수", "재단"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("शि\u{902}वपाची स\u{941}य"),
            keywords: &[
                "धाग\u{947}",
                "धागो",
                "भरतकाम",
                "शि\u{902}वप",
                "शि\u{902}वपाची स\u{941}य",
                "शिवणकाम",
                "स\u{941}य",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("тигүүчү ийне"),
            keywords: &[
                "ийне",
                "сайма",
                "тигиш",
                "тигүү",
                "тигүүчү ийне",
                "тикмечи",
                "тордоо",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເຂ\u{eb1}ມຍ\u{eb4}ບ"),
            keywords: &[
                "ການຕ\u{eb1}ດຍ\u{eb4}ບເຄ\u{eb7}\u{ec8}ອງ",
                "ຍ\u{eb4}ບ",
                "ຍ\u{eb4}ບປ\u{eb1}ກ",
                "ດ\u{ec9}າຍຍ\u{eb4}ບ",
                "ເຂ\u{eb1}ມ",
                "ເຂ\u{eb1}ມຍ\u{eb4}ບ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("siuvimo adata"),
            keywords: &[
                "adata",
                "siuvimas",
                "siuvimo adata",
                "siuvinėjimas",
                "siūlai",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("šujamadata"),
            keywords: &[
                "adata",
                "izšūšana",
                "piegrieztne",
                "šujamadata",
                "šuves",
                "šūšana",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("игла за шиење"),
            keywords: &[
                "везење",
                "игла",
                "игла за шиење",
                "кроење",
                "медицински шевови",
                "шевови",
                "шиење",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("തയ\u{d4d}യൽ സ\u{d42}ചി"),
            keywords: &[
                "ചിത\u{d4d}രത\u{d4d}തയ\u{d4d}യൽ",
                "തയ\u{d4d}യൽ",
                "ത\u{d41}ന\u{d4d}നല\u{d41}കൾ",
                "ത\u{d41}ന\u{d4d}നൽപ\u{d4d}പണി",
                "ശസ\u{d4d}ത\u{d4d}രക\u{d4d}രിയ\u{d3e} ത\u{d41}ന\u{d4d}നല\u{d41}കൾ",
                "സ\u{d42}ചി",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("оёдлын зүү"),
            keywords: &["зүү", "оёдлын зүү", "оёдол", "оёх", "хатгамал", "эсгүүр"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("शिवणकाम"),
            keywords: &[
                "टाका घालण\u{947}",
                "टाक\u{947}",
                "नक\u{94d}षीकाम",
                "शिवणकाम",
                "शिवण\u{947}",
                "स\u{941}ई",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("jarum menjahit"),
            keywords: &[
                "jahit menjahit",
                "jahitan",
                "jarum",
                "menjahit",
                "sulaman",
                "sutur",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ချ\u{102f}ပ\u{103a}စက\u{103a} အပ\u{103a}"),
            keywords: &[
                "ချ\u{102f}ပ\u{103a}စက\u{103a} အပ\u{103a}",
                "ချ\u{102f}ပ\u{103a}ရ\u{102d}\u{102f}း",
                "ပန\u{103a}းထ\u{102d}\u{102f}းထည\u{103a}",
                "အချ\u{102f}ပ\u{103a}အလ\u{102f}ပ\u{103a}",
                "အပ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("synål"),
            keywords: &[
                "broderi", "nål", "skredder", "sting", "sutur", "sy", "synål",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("सिउन\u{947} सियो"),
            keywords: &[
                "ब\u{941}नाइ",
                "सिउन\u{947} सियो",
                "सियो",
                "सिलाइ",
                "सिलाइब\u{941}नाइ",
                "स\u{94d}टिच",
                "स\u{94d}य\u{941}चर",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("naald"),
            keywords: &[
                "borduren",
                "hechten",
                "hechtingen",
                "kleermaken",
                "naaien",
                "naald",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("synål"),
            keywords: &["broderi", "skreddar", "sting", "sutur", "sy", "synål"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସ\u{b3f}ଲ\u{b3e}ଇ ଛ\u{b41}ଞ\u{b4d}ଚ\u{b3f}"),
            keywords: &[
                "ଏମ\u{b4d}ୱ\u{b4d}ରୋଡେରୀ",
                "କଟ\u{b3e}ସ\u{b4d}ଥ\u{b3e}ନ",
                "ଛ\u{b41}ଞ\u{b4d}ଚ\u{b3f}",
                "ଷ\u{b4d}ଟ\u{b3f}ଚେସ",
                "ସ\u{b3f}ଲ\u{b3e}ଇ କର\u{b3f}ବ\u{b3e}",
                "ସ\u{b3f}ଲ\u{b3e}ଇ ଛ\u{b41}ଞ\u{b4d}ଚ\u{b3f}",
                "ସ\u{b3f}ଲ\u{b3e}ଇକ\u{b3e}ମ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸ\u{a42}ਈ"),
            keywords: &[
                "ਕਢਾਈ",
                "ਕਸੀਦਾਕਾਰੀ",
                "ਟਾ\u{a02}ਕ\u{a47}",
                "ਤ\u{a4b}ਪ\u{a47}",
                "ਸਵਾਈ",
                "ਸਿਲਾਈ",
                "ਸ\u{a42}ਈ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Nídul Fọ Sóyín Klọt"),
            keywords: &[
                "Nídul",
                "Nídul Fọ Sóyín Klọt",
                "Stich",
                "Stíchis",
                "Sóyin",
                "To Só Pẹ\u{301}sin Wund",
                "Télọ Wọk",
                "Ẹ\u{301}mbroídiri",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("igła krawiecka"),
            keywords: &[
                "haft",
                "igła",
                "igła krawiecka",
                "igła z nitką",
                "krawiectwo",
                "szwy",
                "szycie",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د ګنډلو ستن"),
            keywords: &["بخۍ", "د ګنډلو ستن", "ستن", "ګل کاري", "ګنده", "ګنډل"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("agulha de costura"),
            keywords: &[
                "agulha",
                "agulha de costura",
                "alfaiataria",
                "bordados",
                "costura",
                "pontos",
                "suturas",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("ac de cusut"),
            keywords: &["ac", "ac de cusut", "broderie", "croitorie", "cusut"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E13-054"),
            keywords: &["E13-054"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("швейная игла"),
            keywords: &[
                "вышивка",
                "игла",
                "иголка",
                "стежки",
                "швейная игла",
                "швы",
                "шитье",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("سلائي جو نيڊل"),
            keywords: &[
                "ايمبرائيڊري",
                "سئي",
                "سلائي جو نيڊل",
                "سيئڻ",
                "سيوچرز",
                "ٽانڪا",
                "ٽيلرنگ",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("මහන ඉඳ\u{dd2}කට\u{dd4}ව"),
            keywords: &[
                "ඉඳ\u{dd2}කට\u{dd4}ව",
                "එම\u{dca}බ\u{dca}\u{200d}රොය\u{dd2}ඩර\u{dd2}",
                "මහන ඉඳ\u{dd2}කට\u{dd4}ව",
                "මැහ\u{dd4}ම\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("ihla"),
            keywords: &["ihla", "krajčír", "stehy", "vyšívanie", "šitie"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("šivanka"),
            keywords: &[
                "igla", "krojenje", "spoji", "vezenje", "šivanje", "šivanka", "šivi",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("irbada dharka"),
            keywords: &[
                "dhar tolid",
                "dun",
                "dun weeyn",
                "irbad",
                "irbada dharka",
                "tolid",
                "xijaab",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("gjilpërë qepjeje"),
            keywords: &["gjilpërë", "gjilpërë qepjeje", "qëndisje", "rrobaqepësi"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("игла за шивење"),
            keywords: &["вез", "игла", "игла за шивење", "шивење", "штеп"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("igla za šivenje"),
            keywords: &["igla", "igla za šivenje", "vez", "šivenje", "štep"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("synål"),
            keywords: &["broderi", "nål", "skräddarsy", "stygn", "synål"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("sindano ya kushona"),
            keywords: &[
                "kushona",
                "mishono",
                "mshono",
                "sindano",
                "sindano ya kushona",
                "taraza",
                "ushonaji",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("தையல\u{bcd} ஊசி"),
            keywords: &[
                "ஊசி",
                "எம\u{bcd}பிர\u{bbe}ய\u{bcd}டரி",
                "டெய\u{bcd}லரிங\u{bcd}",
                "தைத\u{bcd}தல\u{bcd}",
                "தையல\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("కుట\u{c4d}టు సూద\u{c3f}"),
            keywords: &[
                "ఎంబ\u{c4d}ర\u{c3e}య\u{c3f}డర\u{c40}",
                "కుట\u{c4d}టు సూద\u{c3f}",
                "కుట\u{c4d}టుపన\u{c3f}",
                "కుట\u{c4d}లు",
                "దర\u{c4d}జ\u{c40}పన\u{c3f}",
                "సూదన\u{c3e}లు",
                "సూద\u{c3f}",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เข\u{e47}มเย\u{e47}บผ\u{e49}า"),
            keywords: &[
                "การต\u{e31}ดเย\u{e47}บ",
                "การเย\u{e47}บ",
                "การเย\u{e47}บป\u{e31}กถ\u{e31}กร\u{e49}อย",
                "การเย\u{e47}บแผล",
                "เข\u{e47}ม",
                "เข\u{e47}มเย\u{e47}บผ\u{e49}า",
                "เย\u{e47}บ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("tikin iňňesi"),
            keywords: &[
                "biçmek",
                "iňňe",
                "keşde",
                "tikin iňňesi",
                "tikinler",
                "tikmek",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("huituitui"),
            keywords: &["huituitui"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("dikiş iğnesi"),
            keywords: &[
                "dikiş",
                "dikiş iğnesi",
                "dikme",
                "iğne",
                "nakış",
                "sökük",
                "terzi",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("швацька голка"),
            keywords: &[
                "вишивання",
                "голка",
                "кравецтво",
                "стібки",
                "швацька голка",
                "шви",
                "шиття",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سلائی کی سوئی"),
            keywords: &[
                "سلائی",
                "سلائی کی سوئی",
                "سوئی",
                "سینا",
                "ٹانکے",
                "کشیدہ کاری",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("tikuv ignasi"),
            keywords: &[
                "chok",
                "igna",
                "kashta",
                "tikish",
                "tikuv ignasi",
                "tikuvchilik",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("kim may"),
            keywords: &["chỉ khâu", "khâu", "kim", "may", "may đo", "thêu"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("縫紉針"),
            keywords: &["刺繡", "縫紉針", "縫線", "縫補", "縫針", "裁剪", "針"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("缝纫针"),
            keywords: &["刺绣", "缝纫针", "缝线", "缝补", "缝针", "裁剪", "针"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("缝合针"),
            keywords: &["绣花针", "缝合", "缝合针", "缝纫", "缝线", "裁剪"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("裁縫針"),
            keywords: &["刺繡", "縫", "縫紉", "裁縫針", "針"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: None,
            keywords: &[
                "inaliti",
                "izihlungo",
                "izitishi",
                "ukufeketha",
                "ukuthunga",
            ],
        },
    ],
};
#[doc = "🧶"]
pub const YARN: crate::Emoji = crate::Emoji {
    glyph: "🧶",
    codepoint: "1F9F6",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "yarn",
    group: "Activities",
    subgroup: "arts & crafts",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("wol"),
            keywords: &["bol wol", "brei", "hekel", "wol"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የስፌት ክር"),
            keywords: &["ስፌት", "ኳስ", "የስፌት ክር", "ደንቴል"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("خيط حياكة"),
            keywords: &["حباكة", "حياكة", "خيط حياكة", "صنارة", "صوف", "كرة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ৰচি"),
            keywords: &["ক\u{9cd}ৰোচিট", "বল", "ব\u{9c1}ন\u{9be}", "ৰচি"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("iplik"),
            keywords: &["iplik", "top", "toxuma"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("пража"),
            keywords: &["вязанне", "клубок", "кручок", "пража"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("прежда"),
            keywords: &["кълбо", "плетене", "плетиво", "прежда"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("স\u{9c1}তো"),
            keywords: &["ক\u{9cd}রোশেই", "বল", "ব\u{9c1}ন\u{9be}", "স\u{9c1}তো"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("pellenn neud"),
            keywords: &["nadoz", "neud", "pellenn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("predivo"),
            keywords: &["hekleraj", "klupko", "pletivo", "predivo"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("llana"),
            keywords: &["bola", "cabdell", "ganxet", "llana", "mitja"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏩᏂ ᎠᏍᏘ"),
            keywords: &["ᎠᏍᏆᏞᏍᏗ", "ᎤᏩᏂ ᎠᏍᏘ", "ᎪᏢᏅᏙᏗ ᎤᏩᏂ ᎠᏍᏘ ᎬᏔᏅᎢ", "ᎬᏗᏱ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("klubíčko"),
            keywords: &["háčkování", "klubko", "klubíčko", "pletení"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("edau"),
            keywords: &["crosio", "edau", "gwau", "pêl"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("garn"),
            keywords: &["garn", "garnnøgle", "hækle", "strikke"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Wollknäuel"),
            keywords: &["Häkeln", "Stricken", "Wolle", "Wollknäuel"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κουβάρι"),
            keywords: &["βελονάκι", "κουβάρι", "μπάλα", "πλέκω"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("yarn"),
            keywords: &["ball", "crochet", "knit", "yarn"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("ovillo"),
            keywords: &["bola", "croché", "ovillo", "punto", "tejer"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("ovillo"),
            keywords: &["croché", "ovillo", "pelota", "tejer"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("ovillo"),
            keywords: &["ovillo"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("lõng"),
            keywords: &["heegeldamine", "kera", "kudumine", "lõng", "lõngakera"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("harilko"),
            keywords: &["bola", "harilko", "kakorratz", "puntu"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("نخ بافندگی"),
            keywords: &[
                "بافتنی",
                "بافندگی",
                "توپ",
                "ریسمان",
                "قلاب\u{200c}بافی",
                "نخ بافندگی",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("lankakerä"),
            keywords: &[
                "kerä",
                "kutominen",
                "lanka",
                "lankakerä",
                "neulominen",
                "virkkaus",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("yarn"),
            keywords: &["paggantsilyo", "pagtatahi", "yarn"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("tógv"),
            keywords: &["garn", "noða", "tógv"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("fil"),
            keywords: &["boule", "crochet", "fil", "pelote", "tricot"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("abhras"),
            keywords: &["abhras", "cniotáil", "cróiseáil", "liathróid"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("snàth"),
            keywords: &[
                "cearta", "ceirle", "ceirsle", "cnocan", "croisidh", "figh", "fighe", "snàth",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("nobelo"),
            keywords: &["gancho", "nobelo", "tecer"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{ac2}તર"),
            keywords: &[
                "ઊનનો દડો",
                "ગ\u{ac2}\u{a82}થવ\u{ac1}\u{a82}",
                "ભરતગ\u{ac2}\u{a82}થણ",
                "સ\u{ac2}તર",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("צמר"),
            keywords: &["כדור צמר", "סריגה", "צמר", "קרושה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("स\u{942}त"),
            keywords: &[
                "क\u{94d}रोशिया",
                "ग\u{947}\u{902}द",
                "ब\u{941}नाई",
                "स\u{942}त",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("klupko vune"),
            keywords: &["klupko vune", "loptica", "pletivo", "vuna"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("fonál"),
            keywords: &["fonál", "gombolyag", "horgolás", "kötés"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բրդաթել"),
            keywords: &["բրդաթել", "թել", "կծիկ", "հելուն", "մանվածք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("gulungan benang"),
            keywords: &["bola", "gulungan benang", "rajut", "sulam"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("garn"),
            keywords: &["garn", "hekl", "hespa", "hnykill"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("gomitolo"),
            keywords: &["fare a maglia", "gomitolo", "palla", "uncinetto"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("毛糸"),
            keywords: &["かぎ針", "ニット", "毛糸", "毛糸玉", "編み物"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("bolah"),
            keywords: &["bal", "bolah", "rajut", "renda"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ძაფის გორგალი"),
            keywords: &["გორგალი", "ქსოვა", "ყაისნაღი", "ძაფის გორგალი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("иірімжіп"),
            keywords: &["домалақ", "иірімжіп", "тоқу", "ілмекпен тоқу"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ដ\u{17bb}\u{17c6}សរសៃអ\u{17c6}បោះ"),
            keywords: &[
                "ចាក\u{17cb}",
                "ដ\u{17bb}\u{17c6}សរសៃអ\u{17c6}បោះ",
                "បាល\u{17cb}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ನ\u{cc2}ಲು"),
            keywords: &[
                "ಕ\u{ccd}ರೋಶ",
                "ಚ\u{cc6}ಂಡು",
                "ನ\u{cc2}ಲು",
                "ಹ\u{cc6}ಣ\u{cbf}ಗ\u{cc6}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("실뭉치"),
            keywords: &["니트", "실뭉치", "코바늘"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("दोर"),
            keywords: &["दोर", "बॉल", "विणकाम", "विणप"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("ийрилген жип"),
            keywords: &["ийрилген жип", "тоголок", "токуу", "түйүү", "шиш"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ກ\u{ecd}\u{ec9}ດ\u{ec9}າຍ"),
            keywords: &[
                "ກ\u{ecd}\u{ec9}ດ\u{ec9}າຍ",
                "ຖ\u{eb1}ກແຊ\u{ec8}ວ",
                "ຖ\u{eb1}ກແລນ",
                "ບານ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("siūlų kamuolys"),
            keywords: &["kamuolys", "megzti", "nerti", "siūlų kamuolys"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("dzija"),
            keywords: &["adīt", "dzija", "kamoliņš", "tambrorējums"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("предиво"),
            keywords: &["волна", "плетење", "предиво", "топка"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ചണം"),
            keywords: &[
                "ചണം",
                "ത\u{d41}ന\u{d4d}നൽപ\u{d4d}പണി",
                "നെയ\u{d4d}യ\u{d41}ക",
                "ബോൾ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("нэхмэлийн утас"),
            keywords: &[
                "бөөрөнхий",
                "дэгээ зүүгээр нэхэх",
                "нэхмэлийн утас",
                "сүлжмэл",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("यार\u{94d}न"),
            keywords: &["क\u{94d}रोश\u{947}", "निट", "बॉल", "यार\u{94d}न"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("yarn"),
            keywords: &["bebola", "benang bulu", "kait", "krusye", "yarn"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ချည\u{103a}ခင\u{103a}"),
            keywords: &[
                "ချည\u{103a}ခင\u{103a}",
                "ဇာထ\u{102d}\u{102f}းသည\u{103a}",
                "တစ\u{103a}ချောင\u{103a}းထ\u{102d}\u{102f}း",
                "ဘောလ\u{102f}\u{1036}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("garn"),
            keywords: &["ball", "garn", "nøste"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("कात\u{947}को धागो"),
            keywords: &[
                "कात\u{947}को धागो",
                "बल",
                "ब\u{941}न\u{947}को",
                "हात\u{948}ल\u{947} ब\u{941}न\u{947}को",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("wol"),
            keywords: &["bal", "breien", "haken", "wol"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("garn"),
            keywords: &["ball", "garn", "nøste"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କ\u{b4d}ରକେଟ\u{b4d}\u{200c}"),
            keywords: &[
                "କ\u{b4d}ରକେଟ\u{b4d}\u{200c}",
                "ବଲ\u{b4d}\u{200c}",
                "ବ\u{b41}ଣ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਊਨੀ ਧਾਗਾ"),
            keywords: &[
                "ਊਨੀ ਧਾਗਾ",
                "ਕਰ\u{a4b}ਸ\u{a3c}ੀਆ",
                "ਗ\u{a47}\u{a02}ਦ",
                "ਬ\u{a41}ਣਨਾ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Tred Wé Dẹm De Ték Mék Klọt"),
            keywords: &[
                "Bọl",
                "To Nit Klọt",
                "To Wív Klọt",
                "Tred Wé Dẹm De Ték Mék Klọt",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("włóczka"),
            keywords: &["kłębek", "robienie na drutach", "szydełkowanie", "włóczka"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("مزی"),
            keywords: &["بال", "بڼل", "خامک ګنډل", "مزی"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("novelo"),
            keywords: &["bola", "crochê", "novelo", "tricô"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("fir textil"),
            keywords: &["croșeta", "fir textil", "ghem", "tricota"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E11-064"),
            keywords: &["E11-064"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("клубок"),
            keywords: &["вязание", "клубок", "клубок ниток", "нитки", "пряжа"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("يارن"),
            keywords: &["بال", "نٽ", "يارن", "ڪروچيٽ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කැට\u{dd2}න\u{dd6}ල\u{dca}"),
            keywords: &[
                "කැට\u{dd2}න\u{dd6}ල\u{dca}",
                "ගෙත\u{dd4}ම",
                "ගොතනව\u{dcf}",
                "බෝලය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("klbko"),
            keywords: &["háčkovanie", "klbko", "pletenie"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("preja"),
            keywords: &["klobčič", "kvačkanje", "pletenje", "preja"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("tidcidda"),
            keywords: &["Tidcidda", "kubbad", "tidcidda", "tolliinka"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fill"),
            keywords: &["fill", "grep", "lëmsh", "thur me shtiza", "top"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("предиво"),
            keywords: &["клупко", "плетење", "предиво", "штрикање"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("predivo"),
            keywords: &["klupko", "pletenje", "predivo", "štrikanje"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("garn"),
            keywords: &["garn", "garnnystan", "sticka", "virka"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uzi uliosokotwa"),
            keywords: &["kroshia", "shona", "uzi", "uzi uliosokotwa"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("நூல\u{bcd}கண\u{bcd}டு"),
            keywords: &[
                "கொக\u{bcd}கிப\u{bcd}பின\u{bcd}னல\u{bcd}",
                "நூல\u{bcd}கண\u{bcd}டு",
                "பந\u{bcd}து",
                "பின\u{bcd}னல\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("నూలు"),
            keywords: &[
                "అల\u{c4d}ల\u{c3f}క",
                "క\u{c4d}ర\u{c4b}చ\u{c46}ట\u{c4d}",
                "నూలు",
                "బంత\u{c3f}",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ไหมพรม"),
            keywords: &[
                "กล\u{e38}\u{e48}มไหม",
                "ก\u{e49}อนไหมพรม",
                "ถ\u{e31}ก",
                "โครเชต\u{e4c}",
                "ไหมพรม",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýumak"),
            keywords: &["kroşe", "pökgi", "örmek", "ýumak"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("filo lalanga"),
            keywords: &["filo lalanga"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("iplik yumağı"),
            keywords: &["iplik yumağı", "kroşe", "top", "yumak"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("пряжа"),
            keywords: &["клубок", "моток", "мотузка", "нитка", "прядиво", "пряжа"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("اونی دھاگہ"),
            keywords: &["اونی دھاگہ", "ب\u{64f}ننا", "کروشیا", "گولہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("o‘ram"),
            keywords: &[
                "koptok",
                "koptok iplar",
                "o‘ram",
                "o‘ram ip",
                "to‘qish",
                "yigirilgan ip",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("sợi"),
            keywords: &["cuộn", "sợi", "đan", "đan bằng kim móc"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("冷球"),
            keywords: &["冷球", "球", "針織", "鉤針"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("冷球"),
            keywords: &["冷球", "球", "针织", "钩针"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("毛线"),
            keywords: &["毛线", "毛线球", "编织", "钩针编织物"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("毛線球"),
            keywords: &["毛線球", "球", "織", "鉤針"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("毛冷"),
            keywords: &["毛冷", "球", "織", "針織"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("E11:064"),
            keywords: &["E11:064"],
        },
    ],
};
#[doc = "🪢"]
pub const KNOT: crate::Emoji = crate::Emoji {
    glyph: "🪢",
    codepoint: "1FAA2",
    status: crate::Status::FullyQualified,
    introduction_version: 13f32,
    name: "knot",
    group: "Activities",
    subgroup: "arts & crafts",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("knoop"),
            keywords: &["kinkel", "knoop", "tou"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ቋጠሮ"),
            keywords: &["ቋጠሮ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ع\u{64f}قدة"),
            keywords: &["حبل", "عقدة", "ع\u{64f}قدة", "متشابك", "مجدول"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("গ\u{9be}ঠি"),
            keywords: &[
                "গ\u{9be}ঠি",
                "জট লগ\u{9be}",
                "ট\u{9c1}ইন",
                "পকোৱ\u{9be}",
                "ৰচী",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("düyün"),
            keywords: &["düyün", "ip", "kəndir", "qarışıq-dolaşıq", "sapma"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("вузел"),
            keywords: &["вузел", "вяроўка", "завязаны", "закручаны", "шнурок"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("възел"),
            keywords: &["връв", "въже", "възел", "усукване"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("গ\u{9be}\u{981}ট"),
            keywords: &[
                "গ\u{9be}\u{981}ট",
                "ট\u{9be}ই",
                "দড\u{9bc}ি",
                "প\u{9be}ক\u{9be}নো",
                "ব\u{9be}\u{981}ক\u{9be}নো",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("skoulm"),
            keywords: &["kordenn", "skoulm"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("čvor"),
            keywords: &[
                "kanap", "konopac", "uvrnuti", "zamrsiti", "zavezati", "čvor",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("nus"),
            keywords: &["bramant", "corda", "nus"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏓᎧᏁᎲ"),
            keywords: &["ᎠᏍᏗ", "ᎤᎫᏧᏍᏘ", "ᏍᏕᏱᏓ", "ᏓᎧᏁᎭ", "ᏓᎧᏁᎲ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("uzel"),
            keywords: &["lano", "provaz", "uvázat", "uzel", "zamotaný", "zapletený"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cwlwm"),
            keywords: &["clymog", "clymu", "cwlwm", "plethu", "rhaff", "troi"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("knude"),
            keywords: &["binde", "knob", "knude", "reb", "snor"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Knoten"),
            keywords: &["Knoten", "Schnur", "Seil", "binden", "zusammendrehen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κόμπος"),
            keywords: &["δένω", "κόμπος", "σπάγκος", "στρίβω", "τυλίγω"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("knot"),
            keywords: &["knot", "rope", "tangled", "tie", "twine", "twist"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("nudo"),
            keywords: &["anudar", "atar", "enredar", "nudo", "trenzar"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("nudo"),
            keywords: &["nudo"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("nudo"),
            keywords: &["nudo"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("sõlm"),
            keywords: &["keerd", "köis", "nöör", "siduma", "sõlm"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("korapilo"),
            keywords: &["korapilatu", "korapilo", "lotu", "soka", "tolestu"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("گره"),
            keywords: &["دوقلو", "طناب", "پیچاندن", "گره"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("solmu"),
            keywords: &["kiinnittää", "köysi", "naru", "solmu", "solmulla"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("buhol"),
            keywords: &["buhol", "nakapalupot", "tali"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("knútur"),
            keywords: &["binda", "knútur", "knýta", "reip", "tog"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("nœud"),
            keywords: &["attacher", "corde", "entrelacer", "noué", "nœud", "tordre"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("nœud"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("snaidhm"),
            keywords: &["achrann", "casadh", "snaidhm", "sreang", "téad"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("snaidhm"),
            keywords: &[
                "fiar", "naisg", "nasgadh", "ròpa", "snaidhm", "snìomh", "suain", "toinn",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("nó"),
            keywords: &["anoar", "atar", "corda", "lazada", "nó"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ગા\u{a82}ઠ"),
            keywords: &[
                "આમળવ\u{ac1}\u{a82}",
                "ગા\u{a82}ઠ",
                "ગ\u{ac2}\u{a82}ચવાય\u{ac7}લી દોરી",
                "દોરડાની સ\u{ac7}ર",
                "દોરડ\u{ac1}\u{a82}",
                "મડાગા\u{a82}ઠ",
                "વળ આપ\u{ac7}લી દોરી",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("קשר"),
            keywords: &["חבל", "לקשור", "עניבה", "קשירה", "קשר"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("गा\u{902}ठ"),
            keywords: &["ऐ\u{902}ठन", "गा\u{902}ठ", "डोर", "रस\u{94d}सी"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("čvor"),
            keywords: &[
                "ispreplesti",
                "užad",
                "uže",
                "zapetljano",
                "zapetljati",
                "čvor",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("csomó"),
            keywords: &["csomó", "hurok", "kötél", "madzag"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("հանգույց"),
            keywords: &["կապ", "հանգույց", "պարան", "քարկապ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("simpul"),
            keywords: &["belitan", "ikatan", "kusut", "puntiran", "simpul", "tali"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hnútur"),
            keywords: &["binda", "flækja", "hnútur", "reipi", "snúa", "tvinni"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("nodo"),
            keywords: &["annodato", "corda", "legare", "nodo", "spago"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("結び目"),
            keywords: &["ねじれ", "ひも", "ノット", "ロープ", "結び目", "綱"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("simpul"),
            keywords: &["benang", "dasi", "ditaleni", "kusut", "simpul", "tali"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("კვანძი"),
            keywords: &["ბმა", "გაკვანძვა", "თოკი", "კვანძი", "შეკვრა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("түйін"),
            keywords: &["арқан", "байлау", "бау", "түйін", "шатасқан", "шиыру"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ច\u{17c6}ណង"),
            keywords: &[
                "ខ\u{17d2}សែ",
                "ចង",
                "ច\u{17c6}ណង",
                "ជ\u{17c6}ពាក\u{17cb}",
                "ម\u{17bd}ល",
                "រ\u{17bb}\u{17c6}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಗಂಟು"),
            keywords: &[
                "ಕಟ\u{ccd}ಟು",
                "ಗಂಟು",
                "ತ\u{cbf}ರುಗ\u{cbf}ಸು",
                "ಸ\u{cbf}ಕ\u{ccd}ಕು",
                "ಹಗ\u{ccd}ಗ",
                "ಹ\u{cc6}ಣ\u{cc6}ಯುವುದು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("매듭"),
            keywords: &["꼬인", "노끈", "매듭", "밧줄", "엉킨"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("गाठ"),
            keywords: &[
                "गाठ",
                "गाठायल\u{94d}ल\u{947}\u{902}",
                "टाय",
                "ट\u{94d}वायन",
                "दोर",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("түйүн"),
            keywords: &["байлам", "байлоо", "жип", "түйүн", "эшүү", "өрүү"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("\u{200b}ຂອດ"),
            keywords: &[
                "ກ\u{ec9}ຽວ",
                "ພ\u{eb1}ນ",
                "ມ\u{eb1}ດ",
                "ເຊ\u{eb7}ອກ",
                "\u{200b}ຂອດ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("mazgas"),
            keywords: &["kaklaraištis", "mazgas", "surišti", "virvė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("mezgls"),
            keywords: &["mezgls", "mudžeklis", "striķis", "virve"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("јазол"),
            keywords: &["виткање", "врзување", "конец", "јаже", "јазол"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കെട\u{d4d}ട\u{d4d}"),
            keywords: &[
                "ക\u{d41}ട\u{d41}ക\u{d4d}ക\u{d4d}",
                "കെട\u{d4d}ട\u{d41}പിണഞ\u{d4d}ഞ",
                "കെട\u{d4d}ട\u{d4d}",
                "ചരട\u{d4d}",
                "ന\u{d42}ൽ",
                "പിണച\u{d4d}ചിൽ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("зангилаа"),
            keywords: &[
                "зангилаа",
                "олс",
                "ороох",
                "орооцолдох",
                "орооцолдсон",
                "уяа",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("गाठ"),
            keywords: &[
                "गाठ",
                "गाठ बा\u{902}धण\u{947}",
                "ग\u{941}\u{902}डाळण\u{947}",
                "ग\u{941}\u{902}तल\u{947}ला",
                "ग\u{941}\u{902}फण\u{947}",
                "दोरी",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("simpul"),
            keywords: &["ikat", "lilit", "pintal", "simpul", "tali"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ကြ\u{102d}\u{102f}းထ\u{102f}\u{1036}း"),
            keywords: &[
                "ကြ\u{102d}\u{102f}း",
                "ကြ\u{102d}\u{102f}းထ\u{102f}\u{1036}း",
                "ချည\u{103a}ရန\u{103a}",
                "ရစ\u{103a}ပတ\u{103a}သည\u{103a}",
                "ရ\u{103e}\u{102f}ပ\u{103a}ထ\u{103d}ေးနေသော",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("knute"),
            keywords: &[
                "knop",
                "knute",
                "knyte",
                "rep",
                "sammenflettet",
                "tau",
                "tvinne",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("नट"),
            keywords: &[
                "घ\u{941}म\u{947}को",
                "टाइ",
                "डोरी",
                "नट",
                "बटारिएको",
                "लप\u{947}टिएको",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("knoop"),
            keywords: &["geknoopt", "knoop", "knopen", "kronkel", "streng", "touw"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("knute"),
            keywords: &[
                "knop",
                "knute",
                "knyte",
                "reip",
                "samanfletta",
                "tau",
                "tvinne",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଗଣ\u{b4d}ଠ\u{b3f}"),
            keywords: &[
                "ଗଣ\u{b4d}ଠ\u{b3f}",
                "ଛନ\u{b4d}ଦ\u{b3f} ହୋଇଯ\u{b3f}ବ\u{b3e}",
                "ଟ\u{b3e}ଏ",
                "ଦଉଡ\u{b3f}",
                "ମୋଡ\u{b3f}ବ\u{b3e}",
                "ସର\u{b41} ଦଉଡ\u{b3f}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਗ\u{a70}ਢ"),
            keywords: &[
                "ਗ\u{a70}ਢ",
                "ਬ\u{a70}ਨ\u{a4d}ਹਣਾ",
                "ਮਰ\u{a4b}ੜ",
                "ਰ\u{a71}ਸੀ",
                "ਵ\u{a71}ਟ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Taí Nọt"),
            keywords: &[
                "Nọt",
                "Rop",
                "Tai",
                "Taí Nọt",
                "Twain",
                "Twist",
                "Twist Twíst Togẹ\u{301}da Fọ Jagajágá Wè",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("węzeł"),
            keywords: &["lina", "sznur", "sznurek", "wiązać", "węzeł"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("غوټه"),
            keywords: &["تاو", "تړل", "جاخ", "غبرګ", "غوټه", "پړی"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("nó"),
            keywords: &["amarrar", "corda", "cordel", "emaranhado", "fio", "nó"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("nod"),
            keywords: &["frânghie", "lega", "nod", "sfoară", "încurcătură"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E13-055"),
            keywords: &["E13-055"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("узел"),
            keywords: &["веревка", "канат", "узел", "шнур", "шнурок"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڳنڍ"),
            keywords: &["رسو", "ٽوائن", "ٽوسٽ", "ٽينگلڊ", "ڳنڍ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ගැටය"),
            keywords: &[
                "කඹය",
                "ගැටය",
                "ටය\u{dd2}",
                "ට\u{dca}වය\u{dd2}න\u{dca}",
                "පටලැව\u{dd2}ල\u{dca}ල",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("uzol"),
            keywords: &["lano", "povraz", "uzol", "zamotané", "zaviazať", "šnúra"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("vozel"),
            keywords: &["sukanec", "vozel", "vrv", "vrvica", "zanka"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("siriq"),
            keywords: &[
                "gunti",
                "isku xirid",
                "iskushaandeeyn",
                "mara adag",
                "siriq",
                "xarig",
                "xirid",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("nyjë"),
            keywords: &["lidh", "litar", "ngatërruar", "nyjë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("чвор"),
            keywords: &["везати", "запетљано", "канап", "конопац", "уврнути", "чвор"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["чвор"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("čvor"),
            keywords: &[
                "kanap",
                "konopac",
                "uvrnuti",
                "vezati",
                "zapetljano",
                "čvor",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["čvor"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("knut"),
            keywords: &["knop", "knut", "rep", "tågvirke"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("fundo"),
            keywords: &["fundo", "funga", "kamba", "msokotano", "sokota", "songa"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("முடிச\u{bcd}சு"),
            keywords: &[
                "கட\u{bcd}டு",
                "கயிறு",
                "சிக\u{bcd}கல\u{bcd}",
                "நூல\u{bcd}",
                "முடிச\u{bcd}சு",
                "முறுக\u{bcd}கு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ముడ\u{c3f}"),
            keywords: &[
                "కట\u{c4d}టడం",
                "త\u{c3e}డు",
                "మడత",
                "ముడ\u{c3f}",
                "మ\u{c46}ల\u{c3f}",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เง\u{e37}\u{e48}อน"),
            keywords: &[
                "บ\u{e34}ดเป\u{e47}นเกล\u{e35}ยว",
                "ผ\u{e39}ก",
                "พ\u{e31}น",
                "พ\u{e31}นก\u{e31}น",
                "เง\u{e37}\u{e48}อน",
                "เช\u{e37}อก",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("düwün"),
            keywords: &["daňmak", "daňy", "düwün", "towlamak", "ýüp"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fakapona"),
            keywords: &["fakapona"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("denizci düğümü"),
            keywords: &[
                "bağlı",
                "denizci düğümü",
                "dolaşık",
                "düğüm",
                "halat",
                "sicim",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("вузол"),
            keywords: &["вузол", "мотузка", "петля", "плетення", "плетиво", "шнурок"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("گانٹھ"),
            keywords: &["الجھن", "باندھنا", "دوہرا", "رسی", "موڑ", "گانٹھ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("tugun"),
            keywords: &["arqon", "bogʻlash", "chilvir", "eshish", "tugun"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nút thắt"),
            keywords: &["buộc", "bện", "dây thừng", "nút thắt", "rối", "xoắn"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("結"),
            keywords: &["扭", "結", "繩", "繩球", "領呔"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("结"),
            keywords: &["扭", "结", "绳", "绳球", "领呔"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("结"),
            keywords: &["打结", "结", "绳子", "缠结", "麻线"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("繩結"),
            keywords: &["交織", "細繩", "結", "繩結"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ifindo"),
            keywords: &[
                "bopha",
                "hlanganisa",
                "ifindo",
                "intambo",
                "ithandelwe",
                "sonta",
            ],
        },
    ],
};
