# EMerge LOg Parser

Emlop parses emerge logs (as generated by [portage](https://wiki.gentoo.org/wiki/Project:Portage),
the [Gentoo](https://www.gentoo.org/) package manager) to yield useful info like merge history and
merge time prediction.

It draws inspiration from [genlop](https://github.com/gentoo-perl/genlop) and
[qlop](https://github.com/gentoo/portage-utils) but aims to be faster, more accurate, and more
ergonomic, see [COMPARISON](COMPARISON.md).


## Installation

### Using portage

Not available in main portage tree yet, see [gentoo bug 649904](https://bugs.gentoo.org/649904). In
the meantime, get it from the [guru](https://wiki.gentoo.org/wiki/Project:GURU)
[moltonel](https://github.com/vincentdephily/moltonel-ebuilds) overlay: install
[eselect-repository](https://wiki.gentoo.org/wiki/Eselect/Repository) and run `eselect repository
enable moltonel` before running `emerge emlop` as ususal.

### Using cargo

Install [Rust](https://www.rust-lang.org/) using `emerge rust` (if you simply want to install Emlop)
or [rustup](https://www.rust-lang.org/en-US/install.html) (if you want the latest Rust or plan to
develop in Rust). Emlop releases should always work with portage's oldest rust version.

Cargo installs binaries into `~/.cargo/bin/`, which should be in your `$PATH`. If you wish to
install them system-wide, edit the system `$PATH` or copy/symlink `~/.cargo/bin/*` somewhere in
`$PATH`.

#### From crates.io

    cargo install -f emlop

#### From git

    git clone https://github.com/vincentdephily/emlop
    cd emlop
    cargo test
    cargo install -f --path .

## Usage

Emlop is split into `log`, `predict` and `stats` subcommands, which can be abbreviated by their
first letter. This file doesn't show everything, see `emlop --help` and `emlop <sucommand> --help`
for complete and up to date usage info.

Shell autocompletion is available. If you have installed emlop manually, generate the completion
script for bash/zsh/fish with the `complete` subcommand.

### Subcommands and arguments

Show log of sucessful merges and syncs:

    emlop log [OPTIONS] [package]
        <package>                 Display only packages matching <package>.
        -s, --show <m,u,s,a>      Show (m)erges, (u)nmerges, (s)yncs, and/or (a)ll. [default: m]
        -e, --exact               Match package with a string instead of a regex.

Predict merge time for current or pretended merges:

    emlop predict [OPTIONS]
        --limit <limit>   Use the last N merge times to predict next merge time. [default: 10]

Show statistics about sucessful merges and syncs:

    emlop stats [OPTIONS] [package]
        <package>                  Show only packages matching <package>.
        -s, --show <p,t,s,a>       Show (p)ackages, (t)otals, (s)yncs, and/or (a)ll. [default: p]
        -g, --groupby <y,m,w,d>    Group by (y)ear, (m)onth, (w)eek, or (d)ay.
        -e, --exact                Match package with a string instead of a regex.
            --limit <limit>        Use the last N merge times to predict next merge time. [default: 10]

Options common to all subcommands:

    -f, --from <date>         Only parse log entries after <date>.
    -t, --to <date>           Only parse log entries before <date>.
        --duration <hms,s>    Format durations in hours:minutes:seconds or in seconds. [default: hms]
    -F, --logfile <file>      Location of emerge log file. [default: /var/log/emerge.log]
    -v                        Show warnings (-v), info (-vv) and debug (-vvv) messages (errors are always displayed).
        --color <when>        Enable color (auto/always/never/y/n). [default: auto]
    -h, --help                Show short (-h) or detailed (--help) help.

### Examples

Show merge log with date, time, and package name:

    $ emlop log | tail
    2018-01-29 10:20:52 +00:00        13 >>> net-wireless/iw-4.9
    2018-01-29 10:21:21 +00:00        29 >>> dev-libs/librdkafka-0.11.3
    2018-01-29 10:22:27 +00:00      1:06 >>> net-misc/curl-7.58.0
    2018-01-29 11:09:20 +00:00      1:23 >>> media-libs/openexr-2.2.0-r2
    2018-01-29 11:12:18 +00:00      2:58 >>> media-gfx/imagemagick-7.0.7.19
    2018-01-29 11:12:42 +00:00        24 >>> kde-frameworks/kimageformats-5.42.0
    2018-01-29 11:25:32 +00:00     12:50 >>> media-gfx/inkscape-0.92.2
    2018-01-29 12:36:52 +00:00   1:11:20 >>> dev-lang/rust-1.23.0-r1
    2018-01-29 12:37:08 +00:00        16 >>> virtual/rust-1.23.0
    2018-01-29 12:41:54 +00:00      4:46 >>> dev-util/cargo-0.24.0

Show same merge and unmerge log, filtering packages by regexp:

    $ emlop l -smu gcc | tail
    2020-04-19 19:48:54 +01:00         2 <<< sys-devel/gcc-9.3.0
    2020-04-19 19:48:58 +01:00   1:35:55 >>> sys-devel/gcc-9.3.0
    2020-06-29 21:23:04 +01:00         2 <<< sys-devel/gcc-config-2.2.1
    2020-06-29 21:23:05 +01:00         8 >>> sys-devel/gcc-config-2.3
    2020-07-09 19:15:31 +01:00         2 <<< sys-devel/gcc-9.3.0
    2020-07-09 19:15:36 +01:00   1:36:22 >>> sys-devel/gcc-9.3.0-r1
    2020-07-25 23:08:53 +01:00         3 <<< sys-devel/gcc-config-2.3
    2020-07-25 23:08:57 +01:00        24 >>> sys-devel/gcc-config-2.3.1
    2020-08-29 10:36:11 +01:00         1 <<< sys-devel/gcc-9.3.0-r1
    2020-08-29 10:36:19 +01:00   1:44:56 >>> sys-devel/gcc-9.3.0-r1

Show syncs of the last 7 days:

    $ emlop l --from '1 week ago' -ss
    2018-11-28 21:53:42 +00:00        13 Sync
    2018-11-30 09:18:43 +00:00         7 Sync
    2018-12-01 17:48:37 +00:00         3 Sync
    2018-12-03 09:30:02 +00:00        11 Sync
    2018-12-04 09:52:12 +00:00         8 Sync
    2018-12-04 17:01:06 +00:00         8 Sync
    2018-12-05 09:43:17 +00:00         4 Sync

Show currently emerging packages, how long they have been running, and predict how long is left:

    $ emlop p
    Pid 27455: ...n-exec/python3.5/emerge -O chromium         33
    Pid 27848: ...on-exec/python3.5/emerge -O firefox         29
    www-client/firefox-58.0.1                              53:37 - 24
    www-client/chromium-65.0.3325.146                    6:01:02 - 28
    Estimate for 2 ebuilds (0 unknown, 52 elapsed)       6:53:47 @ 2019-10-09 11:17:42 +01:00

Predict merge time from an `emerge --pretend` output, taking currently elapsed time into account:

    $ emerge -rOp | emlop p
    Pid 8799: .../emerge -O chromium firefox konqueror   1:14:11
    www-client/chromium-65.0.3325.146                    5:49:38 - 1:10:55
    www-client/firefox-58.0.1                              53:37
    kde-apps/konqueror-17.12.3                              3:46
    Estimate for 3 ebuilds (0 unknown, 1:10:55 elapsed)  5:36:06 @ 2019-10-09 11:17:42 +01:00

Show merge and unmerge count, total time, and predicted time:

    $ emlop s gtk
    dev-cpp/gtkmm                       2        2:20      1:10      1         1         1
    dev-python/pygtk                    1          51        51      1         1         1
    dev-util/gtk-doc-am                 3          38        12      3         3         1
    dev-util/gtk-update-icon-cache      9        1:36        10      8        10         1
    media-libs/clutter-gtk              1          16        16      1         2         2
    net-libs/gtk-vnc                    1          32        32      1        10        10
    net-libs/webkit-gtk                 1       30:07     30:07      1         2         2
    x11-libs/colord-gtk                 1          15        15      1         2         2
    x11-libs/gtk+                      15       35:19      2:18     13        17         1
    x11-libs/gtksourceview              1          22        22      1         2         2
    x11-libs/wxGTK                      3        8:35      2:51      1         1         1
    x11-misc/xdg-user-dirs-gtk          1          11        11      1         2         2
    x11-themes/gtk-engines-adwaita      1          11        11      0         0         ?

Show monthly stats (merge and unmerge count, total time, predicted time) for this year:

    $ emlop s -gm -st --from '1 year ago'
    2019-09 Total    136     6:33:24      2:53    140      3:32         1
    2019-10 Total    497    12:58:47      1:34    559     12:37         1
    2019-11 Total   1202    23:27:11      1:10   1193     25:55         1
    2019-12 Total   1032    27:46:22      1:36   1021     24:02         1
    2020-01 Total    436    18:18:36      2:31    427     11:32         1
    2020-02 Total    540    16:46:42      1:51    512     14:50         1
    2020-03 Total    665    33:25:03      3:00    653     19:52         1
    2020-04 Total    635    33:32:31      3:10    618     21:58         2
    2020-05 Total    479    21:19:04      2:40    451     11:59         1
    2020-06 Total    701    14:26:32      1:14    659     33:08         3
    2020-07 Total    451    15:24:06      2:02    433     14:13         1
    2020-08 Total    425    11:58:29      1:41    427     20:08         2
    2020-09 Total    462    11:51:32      1:32    424     11:44         1

Show yearly evolution of a package's average merge time:

    $ emlop s -gy chromium
    2010 www-client/chromium     11     6:49:32     37:24     10         8         1
    2011 www-client/chromium     28    25:24:48     58:40     23      1:15         4
    2012 www-client/chromium     10    12:35:13   1:15:31     11        53         4
    2016 www-client/chromium      8    16:05:00   2:00:37      7        11         1
    2017 www-client/chromium     22    58:04:19   3:09:17     22        41         1
    2018 www-client/chromium     14    83:54:26   6:00:59     14        27         1
    2019 www-client/chromium      5    10:03:15   2:00:39      6        15         2

Show number of syncs per week:

    $ emlop s -gw -ss | tail
    2018-40 Sync        1:35      8        11
    2018-41 Sync        1:22     10         8
    2018-42 Sync        1:26     11         7
    2018-43 Sync        1:02      9         6
    2018-44 Sync        1:23     13         6
    2018-45 Sync        1:06      9         7
    2018-46 Sync        1:27     11         7
    2018-47 Sync        1:14      8         9
    2018-48 Sync          31      4         7
    2018-49 Sync          31      4         7

## Contributing

Thanks in advance. See [CONTRIBUTING](CONTRIBUTING.md) for pointers. Emlop is licensed as GPLv3.
