/// Id's of the functions defined in the interface.
#[repr(i32)]
#[derive(Debug, Ord, PartialOrd, Eq, PartialEq, Copy, Clone)]
pub enum FnId {
    SysShutdown = 1,
    SysPanic = 2,
    SysHasFunction = 3,
    SysGetFunction = 4,
    SysLock = 5,
    SysTryLock = 6,
    SysUnlock = 7,
    SysGetSyncHandler = 8,
    SysSetSyncHandler = 9,

    VersionNewShort = 101,
    VersionNewLong = 102,
    VersionNewFull = 103,
    VersionFromString = 104,
    VersionStringLengthShort = 105,
    VersionStringLengthLong = 106,
    VersionStringLengthFull = 107,
    VersionAsStringShort = 108,
    VersionAsStringLong = 109,
    VersionAsStringFull = 110,
    VersionStringIsValid = 111,
    VersionCompare = 112,
    VersionCompareWeak = 113,
    VersionCompareStrong = 114,
    VersionIsCompatible = 115,

    LibraryRegisterLoader = 201,
    LibraryUnregisterLoader = 202,
    LibraryGetLoaderInterface = 203,
    LibraryGetLoaderHandleFromType = 204,
    LibraryGetLoaderHandleFromLibrary = 205,
    LibraryGetNumLoaders = 206,
    LibraryLibraryExists = 207,
    LibraryTypeExists = 208,
    LibraryGetLibraryTypes = 209,
    LibraryCreateLibraryHandle = 210,
    LibraryRemoveLibraryHandle = 211,
    LibraryLinkLibrary = 212,
    LibraryGetInternalLibraryHandle = 213,
    LibraryLoad = 214,
    LibraryUnload = 215,
    LibraryGetDataSymbol = 216,
    LibraryGetFunctionSymbol = 217,

    ModuleRegisterLoader = 301,
    ModuleUnregisterLoader = 302,
    ModuleGetLoaderInterface = 303,
    ModuleGetLoaderHandleFromType = 304,
    ModuleGetLoaderHandleFromModule = 305,
    ModuleGetNumModules = 306,
    ModuleGetNumLoaders = 307,
    ModuleGetNumExportedInterfaces = 308,
    ModuleModuleExists = 309,
    ModuleTypeExists = 310,
    ModuleExportedInterfaceExists = 311,
    ModuleGetModules = 312,
    ModuleGetModuleTypes = 313,
    ModuleGetExportedInterfaces = 314,
    ModuleGetExportedInterfaceHandle = 315,
    ModuleCreateModuleHandle = 316,
    ModuleRemoveModuleHandle = 317,
    ModuleLinkModule = 318,
    ModuleGetInternalModuleHandle = 319,
    ModuleAddModule = 320,
    ModuleRemoveModule = 321,
    ModuleLoad = 322,
    ModuleUnload = 323,
    ModuleInitialize = 324,
    ModuleTerminate = 325,
    ModuleAddDependency = 326,
    ModuleRemoveDependency = 327,
    ModuleExportInterface = 328,
    ModuleGetLoadDependencies = 329,
    ModuleGetRuntimeDependencies = 330,
    ModuleGetExportableInterfaces = 331,
    ModuleFetchStatus = 332,
    ModuleGetModulePath = 333,
    ModuleGetModuleInfo = 334,
    ModuleGetInterface = 335,

    #[cfg(feature = "unwind_internal")]
    ExtGetUnwindInternalInterface = 51,
}
