// GENERATED CODE DO NOT MODIFY!
// Any manual changes to this file will be overwritten!
//! ASCII glyph subset.
//!
//! | Type | Screenshot | | Type | Screenshot |
//! |------|------------|-|------|------------|
//! | `FONT_4X6` | ![FONT_4X6](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEAAAAAkCAAAAAAcZ2NOAAABjElEQVR4nJVVAbaDMAgL9z80X22BBLrv5uaz1hZCINRwX27Xf/3WeM3FYA3jA19uamDN7uV7Q78/GcD25WiL9/gyfjt4JuN5z4tJf9wTZDJwQnC/HhBsCGHB6bUhKwPdbJvgqf5ZiHriDBSOfOouAnZ9siCuIo9RBjUy4uH4zgK/FNvLcW2qUJ1HvhFw0cRdSBr9gmAPIsfLUdVCONfaKA5GHbxdflidLKdXUNU5ZeUUVnAwf8pGiWp/Q+1LD54l4ZmFqoniJg1sI5L9iYAlriEkgoqzcfA45cosRGHo5yycLvEc9X8kNrOCqguMxdreBivOVb8sWLFton3JwD+tbWqQyQJmo4U2V4UNlaukESUKEifsc5V/oY1rv8Ft6rx1HjkfWuYzh5FGOBMHgStVubf2xiUZqHHrEyymowEQgqbGXiebgB4CVMLcD8j7qxYk/g9L7au+Be3E2R6ecwEc65uYtNzXuUBMO2yIiRczuXk6p5iMIXavB1GpFkjn2ZZM+3BXZiKwdy1UBubqP4CdG0Pu1AKEAAAAAElFTkSuQmCC) | | `FONT_7X13_ITALIC` | ![FONT_7X13_ITALIC](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAHAAAABOCAAAAADd+81KAAADqklEQVR4nO1Zi5LjIAyz//+jfdMSQJINSZ93N7s7O02TUISNLT9w+/Lf3wQMb5+RF3F7BI/71/s1Hllz+Aqw486bO6g5APLlPYDRlNDxHIUiOeXdEi+r9Pje1D312ycrFNsRSfoVnnmJhxI6zlmOb8puKySziMJKfCcgKDjb03MCriRsc8eAHf8bWz3bwvbKVy/JSO/34htbIw2eGX662sPKC2+zJMT6Z8F4zQA/yDS6Crj/UVz6PcC+w0BmMVcDbt3MxuZNcvV63wZtmBsypDlbnjwVcplvS0uN0i1u5I2uZomc0f2EzAQwcbnAJ0Alq0COQU+i9+bjw4BvpxKZjN0KwDBU5QiDd1TQ4KRrTxJmHY8hrniTI4TMwihCFYFx7fgwWgHJtkAlEDcuAE6DJ534EWThnuxTIjmlHmmNYz+KMIU3PvfMwMkCJJuJhqHpDDek2Dx2ZBXH3sY0cRp/f8n7c4CBHB6JmSeVs0V1o51kMp2MLXn4022kM4V150Cf49+naYjxMF1uIgSvInkZQ6wBwQcFEN35ADQVAvnwVUCOb3f5jtKEwpIoWpiYHB84xUyDjFY7B+BIM48vAfZxRUCKEDsBIaXubwT+qkbXNpMZmS/KxdeMNFTC8MpIS8Daq0o3nKwNOwLpldEs2R16EvXLpf82YC6BXQFLOxGr8ZREkfHFTNVTHNZMyWvjzUZfArLfSYZVuPIJYJXzuuXwUmSkqSgYD14CXOVxWhWUe1g6MmeD4O2epam6RRWg0lBVsUi5M/DCFSnhpDRuAs5ItQQcmUhAAh1F++0SILZGKiMtAGVItXdLQOZwy4WSSzEoayI33AJui553Es2xpp+RCPu3JQzfbmPgNuyHar18QaU7wEWrPXP3zgAfBTwx6UcAuyMGJb3NU1Pte6Sz3MgyDAyQ3NGc2r/hOoCIB7e8847SzDEBxME5UkJxDu5GvGPae4iqB8Ul/igrLAPuOhXCUpSCJpuJLKAkwkb5dNZoWWWuAUkPG0CxhBObEZo3jTLLh89k3mVrPS4z1hO0VrZk4+pU/3+0CA6B/vFU34vr6CScG83DoasCDIcU8zuA0vMOOCKYjAxdzLKaEG6ScF7nUK3nPcklsrMW/X0g05Sbars0igNLpGs5gs3dAWCsGY+KI4xSwKPnnQSEHEEPEY2aLKO6MV+VFrkT7bSF6yZKGNQWpNyDbt1OATnzFo3asB04qcSjYO2pcea9lfClzDudPZwQzcuA69O1xd8fN7wEhWumEb8AAAAASUVORK5CYII=) |
//! | `FONT_5X7` | ![FONT_5X7](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAFAAAAAqCAAAAAABw4PWAAACBElEQVR4nK1WC5KFMAiD+x+afdoCIaCub9cZndpPyiekVVmP6fGa/+6e0l5T5OFpgOvzGTjbGyGxcuMR25QBbW3jJpmScfE7An76lB0MC3kZWHjsGO5Z+nkM8jZ74mHqss+0AeInsNyCGwvR5xJIiGEOOtJj1m6fIY641Wl29K1W9p022L0FZ1K2j0mS/E0TgFEV2rQw9aANsiqwItMRTNgTAA192jxsIV5k1LRLxBKr+MzVlC4LvIiQ5UIBubAwms5VzYmwLilHfRRDrJR/IIxbGJuu+ETrNBi4gzHMpItQ+oEO/ZO5wvRswAjq2th7ToHZCKgI/pt9lR0Y2wlQRAYvkq/SLMQaMzCL4/ALl02rywSYER+T4pKnkBRcIVyTf1ObiTZkl7NoTn+cEliEVitlXFdLjwAFC9RZHkI8LIkpk2iVwuf6S5chKZC6AOQi13rEEOAu/GQC6VXmG0WnGNcBWT2r2nBwx6R4zeijfLyljZhOkK23xN/AsYtT7wow6EAezL1S4kDELmJdRiWvFHi7Eii9LgkWMqSzHkoek4XNDmhdvqTcYCaBnQoAQnXpMi4VQfGyL9WGTuNbium7M40n9RvZ94Bd0dfdxiMn3CKxv9YKpPc6U+ps0BSrCaipnm7bxucyXm67RCtcny6v7+ioZkLhSOjyJVKkEfC2hS/U5nnWDyvme0nQVxlwAAAAAElFTkSuQmCC) | | `FONT_7X14` | ![FONT_7X14](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAHAAAABUCAAAAAB/tuy3AAAD6klEQVR4nO1aWZacMAyU7n9oZaYxkkqLbWjSk5dk8kEDhrK1VEkmTB/+S4DCspyEjvj6IZemLMzxNQPwxD1O6HixjPmdIGPkg4DyssFrHcK2HgHcC4hfQ6eAA+n78D1wDrgDXwGO3y//6tIOXwePeU+eE5sDft9rAE+TMsxbiJvQoXNSbwK6tbnYKQEV1r1TQh5MAHWoBo/Fzu0Vvm5xe1NceBKrjd/wYQTMJtUo9cjpgeqAA33CLoJG85A4+XCaCPgyIi4A5yzW3qxHSFrhuPIeebdcWlx9BPAJtfgAIGjACBObjLgz8fdEr23O+hhpGiAaSQITYFQjJKJJ7tlFz0SsT7jEhgEWF0gyCTCgpvyJgImqTKwGzwVWcwKp7If+Mcc4GxWAjhrhpV//gC/VBxIIvjCyGa0DJEA7ANHJwrqy5EPhliMyoLOsp2vnrv6R8H6I9Q7Qn48nYnzAkPg4cUNtmodYqVQ/w7tjENd6WAnZEODh82MxmNUu3NyBXR4rUOGRUjifprZlzfhPkPcPqIWR0hksEgUhBZTGLNkj2Jak6Da1MFIRjomQyLtl7fD4UJqYxmclj1eLwy6g+MQ5AIkR0Arcck0lYMFv5N9j9CsLQMxtvJjyPmkPasUJCAh6arS5XqF0KhNXaBI+M2kdZnd86JuTh4PGWaY0kAMsyX+VFkI9YJeHCngEA8ZHnfhsnQKmM7FvHzodPRP/P3n/4YASvA3FqmkAQ1OBZ+SbfYv9cKbSw6lGx6ZumoBYpc0A/ctjPYNzuA3oweqqr65xptyyA4jbgJPabQpobvaFb1iTSsNFQPIVg+0dOaWZA853GJsV6l6TD6hU2ruAkbpi748Z0EQLAgt6CdEEeQQwFzwzwGJIZcsWsCj+cI+QCcMkAELiTwGv9AWXegvhJeATiNB2wZbKMMKPlPr8YcByW7m2s9OZst+0n63urbi23A9aA/Zm4345JeA8wK4AnnkoUNaPjxeEm/ujgA9yLsRRq0jLeqZQtSl5c/oaxEjsJ/tlfU8bc4OTsJlBi0w7SmCyco/OvCiJBCOgJHWMde0OINEu4EYz431I3Qork04BJz5EeuwAY6+yNOkySseQ2FtwbCPKi3d6i3rTWXY58gaP1tvqsvmuv6CZcRvS1X407wr4RcmH6n+UXDtB8wwg7GL8fkDsaXzmOQ2A5i03FbkZiWpeF22v7xbGLWlfrPpqUAMuS34965qZ9J8fPKCrvMuPAl3l3QGGXsaLhP++LFFA6O4Ki8UVgK67oU3Ag67Rh5waJ7ecQgOU35m2V4hRGvhSiCnsHsbeYj9KzaT3S/2kHWuTvgeYtSNzKfz9AihPy5G0fdhCAAAAAElFTkSuQmCC) |
//! | `FONT_5X8` | ![FONT_5X8](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAFAAAAAwCAAAAACjjqIrAAACMUlEQVR4nLVXUZbEIAgL9z80u62CCdjpdmemH33VakQIQQ3lcXM73tnEs4cnnljjdfzIrgkrC108bhXQxzLZtIJ1LnmN3QHJQoXhL9iFM377qq98+CGsmxauEWM1mKe/fDnuGLIPyrAQe0C20Nmis6dFs0XZ1SsQH66f0/F4yorms/r5HuCeh4sYsHBx+J76Tnd5tcCteDh5IvyaTR6fjLIICoSMwTuTKCR0Zgsg9hfA0Q+KugDO/Yx0sWUX5Yer15nccxwBxh4ZQTItB8iWnSKxPn2S34i1KwqLwxSZRfQSlPcp2GjzUTKGrzKi+ZUaYBLg+Ts8DBQ+kZx6ewF1Su+IhW32DIkagACHevFwzYNGmgHDakuZ3uwi5zteWDjVcwFud/tiy5KGHZCG7YIyRVmDQjNQk/wLtPm0HpaNRnLh0q9Rxsghksu7eUUcCmApK8KKDljqeZVVwUxEzuvgr0WUWcUCsMpQFRsFVOp2RV0EYlkU4zpg13fWvroStDioitudvj2RyAPvC3V5f7ZsvRJQJ09dFPorwORXccm+lw5imTOsDlyfnMuFxshYWEyorhrlSNFVxQaTlhTa8gS7BeRTIBpgXVoBb7YMyr883kZzAdKWbwlmf6rJ7+lhrFJWs0fHgjaELh15WPonoF6GPG82ySDkJYfJkhcBimNUdvSrQCmjMK7gDMiRFEEsV6pjy2yhCPoOEHK62Mkhw3C+x5mRLoFFwOnAWSy0J3p4X8N/ADGXk08kG0+9AAAAAElFTkSuQmCC) | | `FONT_7X14_BOLD` | ![FONT_7X14_BOLD](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAHAAAABUCAAAAAB/tuy3AAADj0lEQVR4nO1aWa7bMAwk739oFkm0cBnSki0YKNr3k8SWNeI+pB/Ty38eUIiFLk4xFny+XK52T7LbpgFKO4u5+LnKClDmL/ksEH4M+Pv4XuufPAA17iHAto0CygCdSgpbcLQM/R6njsVKlWrR/IpOsQmoVNqkaLvB9dHohbPVgEM2plrCoXzt+eLioAAcS5sriPadAnBLQndPOU0TzYWosyHSEwrfUqVTUQDQhaO9aKytA/baaWz8IWGgUPEU7cpqFstv4iWCkuYC4PVxVvGOAJ6oFi8A+sJAOjV+Y15FJc1fYeW1AT4rudtBeqDP/M3OTDM0wkdlRZVlP9ViPHgJOO/NQ86VLkhi/DhAV8dV1WlK5JCtK0ArtL6XP2ECvyshWBurdK5wxIFynZBNZlEY5TQeMDkBBtSarQCdcWvEQkJj4F74kbkSG2qepYvcjMO4jfHN1D+szy546aiHQiqcXVRbhpSlCCaqipZ1/9Op7ZIX/wvJ+31Am1TI/ZrubR3KRo4N1e6pP4apysOXCHffBiFnq0HI4TEHxwdCXWlguOi4A68AUozmSfoaYG8ixjboiCGkM0A2XLGZogLUlchftPd83roJ6GVCEgrtqVQ/MAG901QqlUeAJ5wmdesI6AvSvbCIRCcNixbkjkbgwGfd6NjAd6QP1dEe+P+T9+Eiyae39tbW9GHWgKJaLISM8R1Hg0M3UG4DCVraW0gC6Gx4FzAwbzweWgT0Y60cMPC7bUByCT8FtGyRIDvFgDZxWF4LASmk6D3AQdFDY1gCQtF2AEHRcH2LiZUaMB/ilJm9AoQ9yQag83LYRvRfg/ZoQNQlQ8CdvmAna4IA+eLZzucAoA5L0x0jwHfKk7xbE/lqvgpHpDDS9HQzl+IquYfJNB8ALB1V0rF4Ne9aAEQF2JfsOTOSkOZJtSaeO+o93TRroarXVJ8ljE0CL1UycsVkIeeFVH8JMMwmiQgWpEOAC92Tn/s9U+kSURL7XggCxoyeqjSSRuilliKAOJRkHHe3t0gnpGs58kYexWN1Wdzr729mhAyF7F42Su2Td0/FA+aF9NcbF53mCCDrHvsVQFKsy0QebN622rWUEI9fh9u1EtBM9Xe6J5N+fPosqH4GGGyBqX74Pw0muiehrQwLvUXxris6XTnV8y9hQA2Y7/iJViW0Xso2X4plOqC3mBx73Wke9BbJy/0LlT5pZuKbmZBLzd8fr396kcNAoRUAAAAASUVORK5CYII=) |
//! | `FONT_6X9` | ![FONT_6X9](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGAAAAA2CAAAAAAdJMMOAAACg0lEQVR4nNVYAXLDMAiD/z+apbHBEsZx0y67W3rXNouLDAiEp7K8TP3tm0uTuddHf389fH09bqyt62g3kE2XAG5a/TaMDpi2+AqsBLDTs4YVhkqAvqE1wPGAAfxrhMiBRVNuGnDbCoTaprAX2L6IQzRtZfIAd2HikVt6EDk4XqL8eJEDuwSgyEGIeiw0IxRxL1Oxq4MbV73+2zq6hpSTRSYpUSaDQP07/r2v3+/tzJKTPFCMuUnUh6LwFCOYDbIqFBqwIdgn3DAo4QGcAMJJ9jIDxIep1KUcpjlGOcVuMwEMP0ZNGq8J5L0HwgmMNNqwHA0jEyFFv87BolV8wkfd68FD9p8tNMGIG1ZYkRVhgkZuRGua+RoNggym5GoCillFa9fBtrWz97pgHYVm/eXU1GQOCs25AjfIVZfE1uQFAGTIJNN88sBk5wEreQOY1r0dohxVzkEHiDyNEBVJVtIpCJ1iMEWLJD9P0/8PYFPcZfAKE4tE8FiDhSAxjwRa0GZuzgBAJZm7d5qXVgD4CwJIhEddKeclDFGrPFQCAvBpNUsTjUhJv8GDVKWFfnmDEaVxcR4JlgCVlCf94q7QexsqIHTZkqam/6wOGtH/opLnybwc6YvjAdF0MUtq9ePKKlOlWraZro3aBvbreTRWHkeBuC5kAqNjPdWCbmC3qTVZSLTY1BZAyraxOqmtAS5ClFoljS2okUMZsWC/OyaZbqtT75WO3j7H/fbwS4ibEL3fm6YGTme0RwCGHuUx1pQZVUkmTT6iZfOwfEYL1q+5H4oGyjHrjiUBqAZF7ACoaAVAFZzl2DLkk5QZTwb5lIlH9kIww4MPFM20PLiWg9dHAO/8K+G8fgBUTrlVFaG1eQAAAABJRU5ErkJggg==) | | `FONT_8X13` | ![FONT_8X13](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAIAAAABOCAAAAADNt0HTAAADvElEQVR4nO1a0RLiMAiE//9o7q7ahIWFpI56PtRxpram6YbALiRV+c+fnwJgeh4McM3r+Mc8OX6dp+n+5mPaABjHB07T2PM4cQiP475ddwAcD4broh0AG5Zd2+FvC25S39EAIGiYxhKipD/+/AaAnwK9AuC0XHAxSz5/NF9bYE5CGGBpgWJAbPxbFjgBDJ/ws8KccA/A819tW5ymHDgmiA0A05Sk+dlYNxDPCRg+YU2XGYASQAzAZz4ZF1y5teAnAATmOrnfATQ4N/zf5uVyPG7aJ2sc7TVxfFS28x9KN0m4dO2IPmj/idHswBIAT0Sm9PkEgOkOQyYAxE7I7YoBDHcN0tJJPCbCVRISCQ7AFBljdq4DCPQMBBUsQKbFtaCmE4107Iw5HcIqn1lRkW9NAEQn8+FK5noNYCZWIVF55gNO9SK8lA56AOjNyXW8CFktOTP+TITHtx8CHNXHc3Y+L0JW/vwEE5puJWS3FvwOgJlzoaZY1pojbMN9IzrE3ygaUmhgVZfrYViZZz5MRFOo1xoguR8CgIgROYrwc8oXCQBQhDzp3ECBHwDMMyId8UsAkJZ0ZNWPzhwAuJB5Jl4nPBRrwSFeEirO8xsBmHOuCxYwqiWVBeb3MRV+CvRVH+idkMoEd0IpvH4RBSZcHS9FAYvnlgdcUqnBd7wowXXRmgduKr4BeOcRv7RiTnumt8OaBTlGsQqFUEpVFlqQk88lAEwiUx0jYX1lLUYx+7WQx5KYr5LsmM++B0CyAk2vy6R9+gAjFNEOQKxIq4qoqhEDs8UiNdrS2Q8wwFJqP/IVABzXLoDob2y8zTKa4iI3EaMSwEgxSLvK/zsAUZSiDzCfwKoulOF+xcSLXMuE9jVmPAnu1gL9qt0rC9hyxRhb4D5Au8Isqx0c7Z8lRUjRej9XRhue/SIAuWCBbQBzdyxUIM+UklQk6lfNpqlNNCny0Zr0n3kg1G4p/fbi5ZfvqroAZMxIbYjU0BQm4mVTSsqWSaS54qB1gaRmbWUEUyDr6vgSAFI+5wqIqW6zPrANgDjV0glZIpNKO69576yMquV5sqv2IS2oNijsUq+3Gn4UgA9U2L+wkgllpYSX3TRliWcimcPwawCAOjDuGQ+w+DYtl1zI3lBTFhwAHPN5GWPMxwBAbQDkm1/1INqn5U4IWegLAHDDkZQGKws894yYBTyEvG2DpZlrZtLUivwNh+wDaS8om9lXRviuibEt1s3iNBG5X68j+4I5H8hOSHkgW+AdIbd4i6JjwncBaHfP688fAiUTiyfckfsAAAAASUVORK5CYII=) |
//! | `FONT_6X10` | ![FONT_6X10](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGAAAAA8CAAAAAC8v+BoAAACu0lEQVR4nN1YgXbCMAiE//9oNpsS7oC0Vlf3nk5rV9NcAgcHVbn5NQFMt8Pjaxz9yv6eY8aXPbcy0zWAPdAfp+MvAOKInwsAtu1sbsNUCMBny3vt508m8tO5gzSpMMC+FDC1FbM3AD4oFh9GurSD7bK2PxQf8AZ7H5jwmHF1bSIfNMDUurvrgqcRNAO8/SLI+OdzgXYjAHJ8s50DW5xbXLf9ghx4wb0uKjo5w4zwSTXfCaHOixNpePAbyX4D0js4/nsQpZXFT3k3O7chPrdI7ri8T+qz6ICJOYK4TQpJe2AANMWkQOyiNQxPSTsYqYLDShiOLM7jYEWwvy4OApl4wgYBuk1acUKsLOJk90b4HorPN0RyYrFCPGvjG3e4TCeAMCRSbJE8GVJPpGpxjuEoCuqYiGSTZtIeoAg9LmkQdrwRwBOFKQrFfquAuZQFNZQZcwP+OQBkypMdmOjJDiBTQbJDebziA3TA0gfIjSWLlJXWFOM57hVtWPQNknkzQLU7KnN1Gh1ThNf8ejAFftZjWCdySXkAwDGbZKcmn1wUQ+mnEaVM08R2KIFL+qjtCfmAAqSuvgCk/qcI2gogqujqg4h+0aazYaXsAdpcn1S3oQBrONzbxoH9cUwM+M8Vv3emitJ+dX1b16JBO8Qd1CoXLQGgSav7Xf+CAN7ySSpvU00nOsfMdTOvoiYvemAk1ih7HO2cCqIHjWAl0QdOdRWOhN63ZcsYk7IBSyamwHYHkkwk5zuoAMm+vQ8k6y0XCWDG1zS56b/5EcDbktl0lnY6wT+K/pUMMuujqCPPfXABIHfLTW06OIMsouA6riqKvGElGdynsrt05En0qdfkJtPSE6+mngDur0Tfq/a8mPr0jXegTPB4ZFBE37Na64OkyeiDGdSTGvDIgI1DPkgsyiZ6gZdPK+GLAP3zou71A5utPmr8CClmAAAAAElFTkSuQmCC) | | `FONT_8X13_BOLD` | ![FONT_8X13_BOLD](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAIAAAABOCAAAAADNt0HTAAAD/klEQVR4nO1Z7ZLjIAyz3/+hdXv5tGUZSNu5zs1sf+ymKSQCbMkCty9/IgBs337+It027Ld/bkK0Py+o09oH3gO4/2844egAHP9fQPDTZQrg7z/fruvM0IsvQPT9NQA4lmgDkH+3ZuSPAfxtINfUjvfsAKwsNTX0eHn2Oy588v4eAMdAmKAhgCNcrQAogPbW0xm4J/2a8bZXAtB2yP28n58bwBWNdsWHd9kY0vjOEhG854/TJbizYE9FTOhgC0HQC6l9pJTlGLhGjq5fG/T8w/5Yt2mUJiacpdP6+3sq/roWfAsApQ0ij9yri9i+EE7ki2Ud2Nr7nTa4sx0MySvhmtKNBgH1iXHjgV8LgEj+JH0SQCBLKRJEFwQgtkPmXoTs48FUAMgE2qThpYYKAI88cIAjh0blia5OKB0PNRxNXWDD8P26gbRknfqhvberYQWQ1SVmA0+1mwzaRLkKQXxRBdBF7DoAFiGQPCdEzuqVnoXIA05LUAGAg09NDIWacwFRCMZCcIsCJd13VazqWVUV0Yc/a1Xyrxg5Fy6wvNawLE4cI5UB9yclhgzBmnnDhZqF+i/QoENFmNaAqhGifdCCy4BYeeGbAJBE7Cxq8/MvGe1eOARglZMCAOKVawkLANAMWNH/k5JppYp/8EzhJDCIL0sAtoI7MONnZkBI4zkzJgE8XwLYMAYktXM/tQRvBSFZ+xUApERvpqFMtzDDJQ1vEXJLFU9LRJ6q2kJEdJ/TvBLRrxZ8G0C35lkjrA0iEbxZrDw7ITa78wePolsAyIZBFUPZP70NoICYAaCN0DEAI7YdAeCiUJTqyPVsB6C4XTIg+/ZGyv+8GSV9VlclevJ8QfWEj0wjrgCKFXNZh1cAiqt9BUDYPXNlS5zr40cAuiAM+wgSQLePsAIAkrNbAFTKvQugiAu0Db+IpMRCMFDlbAE9gBfMzKM9oO77CfRXjLw1z+3SgKZytjGG4TC9Pn4CgHar5aWg8uESYDaiQYOPAKA0BNcDjuQhoyPxq73AzAwJ8fyShrBcFUvrZla27+JaI5gf5odizSgxF1xtMlBTZxQf4bIsV8WCBJAZ7gsA+HTQTO3YsTWbFTR85vcgBowVqNthXQMQIudBFlRn1G1ef9wZdedET0/SX9eC7oTk4cnJf6CGr9cIeZOkHvkuxsDLAGpxdhMmRBb8IwBcS6a0a9LQW6JCZ2x0eXr4migaLggni0U1LlMvaahHQ3Iu05nRgHKHM9BVx3mcsjbKRzbVlMLKSVJud0US+wY9BH18N3LF9ThmYM1ybTDIAmFOq+iY2raLZ4c1mrkKWQBwzQBnAVEqsiiFpSl+fyEL9BJ8wBlBVfhcc4qnfwzA4+P74/MHexF+i35prjUAAAAASUVORK5CYII=) |
//! | `FONT_6X12` | ![FONT_6X12](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGAAAABICAAAAAAsDK+/AAACw0lEQVR4nO1Zi3KDMAyz//+jvQKJLb9CYdfe1mt3owxChB1ZUTKmF3/eDCAsDH/ExuPK9iV8FWB/AgFkuynbL2PP1bH/CFcA+3E7PH5onlVdzzstzOMG54TIHpkGM8BS5vaejxRcBJhxwMPYAwJMFE21pLT3ADNTRJCkSxHsl4tblqIDgtiGeTEGAn2J4Z6kSAaRCOlVsygBHPd4RbHFjXRTmq4+TSr+KQBwaugPKb0F2oxzGRfO321vM7VMiQUsp6ByXqwKIkVhO8RuVFFWAB4RMPZPDmAET/BSI2I2LfIAWpQo0jIHy+RhIAOAD0jfMwBYHCZblhBJaUz15yLIAJCfIiEeQIwfxNUYeBYhf6RKiGeaT05HKCfX9z+y7OQrFX8BAHgiFM/H9AkttYZpUsqoTLHONy3yl7g4j7MwhcoXKPttbvV97uaKik5rgFjN7pXUf0y7NgFYUhL0UYJ0MTofaAVSZF7jXgQafh+ByrABQOAXxwAHILfR+cC40bKIwW8ji2CaspaBRd9K/ggAtDDJ0BfMwdkt084dySrQrR9gOdE+jL99G/Il4KzNEsCrThDELJ8BwI2B6YwvtBYgL0C8/UsAqILF29tbzyUVS1gc+nfvALyq9ADZgD0FcKhfmK2Y4mI2wlOyrhngNXXwlko+4vsI28KvjqB03dGPU7VVYauH3gMnnSoBYLOi3QdrUsFILycVgr6PcxuoH6yMUZLaj9sIWsgyN87ObfqUxgtIW7lMGKYWABdEICcOYKX7dAaQI8gAI4LTMaCgV9EFOUG844sk7rOeltEVgGJ/Qk47+PqiONOkIbmzKdi0LPYh1yz6LcBcgJCx3jSE+IKzK43M/A4P8JPGy++5RF+E7qMUhs54rXeO4mKsB/DGS8Nyxstt263+ZRHGQCVnlinofeuLWgCN4CprqN2hK+rgHsDzbX8ADm83dvcBKZEAAAAASUVORK5CYII=) | | `FONT_8X13_ITALIC` | ![FONT_8X13_ITALIC](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAIAAAABOCAAAAADNt0HTAAADzUlEQVR4nO1a0ZbqIAxM/v+jc10rkEkmQHvU60Pds2orhWkIM0moyn9+/RYA09e7Ia5+Hn8YB6PB2ZdNAHQg9gRq6k7ggO3LBQQ7AJ4jA6DRQAgQ3249vpZwrE1RA9B/HyeKqRDdNMijhZbmgCmAOzKpYD/d5AXcgotZdrm/Q10aoN/xsAOa4KoBjt915hBgcj/zxRQE39Ud99NZg6PD5gkOCJ+DakRjq701nvhAvmCYuFg9FQDNeBiAD70SMDhxa8FPAOhO4qnfE4FjGB1e1JlynBbdcIOxav/aKzCexkXSmMD7reH3oBsbbmjq+gF2sQggMlHsrZ9GAEk7qnWNAEqBP3p/oIAFHDp6zZJ67RDxN+Om1CHkyCXIfu/c1E31cJk+LrEAmxVnGs3jO+JqJnZsH6eJRwZzfvVTkwGkOUbTnQbgDSXZQAqqV5iP+hq5KHwI12U8VDfjI47wy7sPEpb7cBgB13M+qFMaaBb4lPpsRqi3FvwCgO5thppiWWuYl45lIeCmdLl4IjmaYUNPPECxmtf6RANSHwxA0gL6mULdGggBkAn28WaiCYB5k9E7vgQgS2r7CwDgRCaaeJ4QUaS8oYxEU32e+wBwHPxZRrrvbBoADLc2gIss3HXa8oxLLjD3wRhUMB8UZR3uLgIjFmALaQogLuclDfiQEtRx0AMo9uvCggZuKr4B+FKKz4icpoj3PlKwioUzKlYCKofZ8VQL8iJbAojZU6rmYIFnLUYMgKtWaFTSWaicwvwLAEInkNPhkKY8DC18gMYVmjOwgNHLTpkSmk4AZCqmyR+LW/o3nhZoisRZoKy++ud6nQFAA3DSJ863BDBkGvusAPToInplmY1MAdAYE0OqcBw1N+SAUDCBrHrChPY9YmwEd2uBftfwhQVsWTGOlfztErPTid0pWAKI9XrGtNjG3g9gZ+WcBtCJwEIG8mILkpGoK99BSUSSYh3NRWP/mlCH3C3H6TIYy5fvyBRYULMX3JAbAjNoChqISiL3lYXOWIJWp3UEwG5mBDMwHT9V39j4kjDTGSjrDXMAOZSZAEg+teGDtEBS+MzbM6NpHfgEt15n4XJ/wk71eqvhJwFY2lgISQ1hQlkp4Vk3lRQn9kCy7Rl9H0DYMxqbQZwIgIJJZpQoNAc6ZV5wEJGNxyS8iqW9+gJAlRuEnR8WmZg6Lqv3DLP98BtW2WT/GZe2ZUMM4AHHjDtmRq4ZXLBODfueEbhA2gvK/5AZ+QcdlNXz5rlpeBYBOhDcf2QIyQM9zgc5DUQLTKK994jTignfBWC2eT57/QP5MxCJsRa4IwAAAABJRU5ErkJggg==) |
//! | `FONT_6X13` | ![FONT_6X13](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGAAAABOCAAAAAD6VUyiAAADMklEQVR4nO1Zi3brIAyz//+juTcJYMkPWNJ1Z9vZurZpQhD4IQui8ua/JwBNr/c9gPOOpnBjPwN9XUfxczWWDKB/HvDtfI1+fNf96jOAfisezzmZoS4TlCD/L7jpn0cyxj4uRMvZ+aVDcgAzkfpRO4A5jenLFvxazmBaJ/W9H1EZbYsZgPmP/9nyKQBdOHs8LjYXR6sAbaJJqmg9it7oMrPm2RAGPK2sHuDlTKYz9uNbctG3A0AaOJ0zgNs8xvNXArZsbC6CzzY681bRe8ykeB7YUEs3W5arIivO2/p01IfkiFpunQSuXXdNCeRKZNEaAM01bEwEGwEa3NAZ4gBB4hudsv+8wYYl0ski0XmDxLYpFUxLJ7bvnc4gNoOoLACIuq0FlK4w4WBxhVJJd4gmUUR50KsYRjr5A4eFZ7hkZt8vZnLTnbT4I7sPAICjRvYMatPE+ZTD55fFlSR5biEYD1hwpQHKoTzbGIeq+kjPBFeEcQDGu8d0A0CTFwGYzu3VAYCsQQ30WwX8oSzLZitIthpARh/LGTTR3QyMhg0AYmNnosLJrvY5ABZZd6LIus7CtAOMhYZYYYl5oKzXoJaphaZQTsw8+OOirwBAERYEWeJY1HExKuhTLAOb5jWovBnfdRuu1cKRugJg1nGEGAM/rD7t51sAEh/ERHP5GlbFcWnOX+SDuDEQCMEAQEelY18DkET9XAAzQKZEbYZRo5YRKmsiQy1Ngh4AIA9KANmt1x9n8gX/i1aZ75xB08ILuMWjpadmmOjWRCUAbLf4tbBWHHEXQHYz2ACEemBVn9c2l8yZqyZRXlyJLX5D0V8XFiVhG4UXZTtqU8iKTIi7mpUKL1FxAKSLJBNMrjCtAeIMUoC2KJ+me0vpuAG4ut84WbxqQ+mIdPlQ2cUdCd6NfJ2L4iZU29//Q9i02d61vgMg0xl7J99g8fzBBYfpJwNY+ELsiyJJEf+sxe/iqY5biCNJRXpgjQTWFq0Kj+3ZMfPwo4+mtSpaP5eCPTunuWkTL9Omc0NS9gDkA+8m29l00rGJU7LVViE9eECVN9aoxp/O+h9w8jTRfWXniG+Vyc8A8t337O8fK/IRi1FtHH4AAAAASUVORK5CYII=) | | `FONT_9X15` | ![FONT_9X15](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAJAAAABaCAAAAAByXoC2AAAEWElEQVR4nO2b63rbMAiG4f4vmq2NJXH4QNhJ83hr+qPLHB1eI05CKtPNfiyQPMl39H9mGAz0918/qJ7r65esrrNp8aH9RjXQBJMDXvh4pJGzD482Z5j+tu0BzaFLIDX1IPpu3xdVCjT+S1Mwasms7HDv0XrqRAvoq1Gt1GvJ2MtDiGkHdFJC322aQPFd5ZBcAbQWOhiQpCZVgovqNd5V65DwZslOmdujCe/aOD13ir0DOuHhjha9JVsGrICChCp5rK+CDI4nLSC7eKz8ItKh1gJlQKNL22u17XbXdjPQ+4Pr3YB2kr55+nETIOCFD5sy0GKfSGgzxpH6TRP3fvQ6bHckGWyShypWxGHFjsVNJTKW+ZUPrf4qOkTv//gy8TSGowbKfCYAshlF4BnMykOGWBokNN2gUO6izKxMSCqKh8hMRjOSCAHVs448AqlhiWKy9J2gSaE3PqCpJ9rf61Uf6o6XrH76SNAKvVHTGx8hqFfxShsiMysEwoZpJXQRSG8aiEAXo4h4UA2ETCl+TzHRFeLa7IFjnNQLX9xCqScC3lA5Rs+BtnEwq3tb6Ohuz34tUHv/+kk/GkDKlMSlD+KbFJao3LUakJbXjuUA4z5m+mE8itpVBK+Doz0M8s6Ws+7C8QO7QAS8H+VPMi8KgGw4fCRXxDpaKyCxMWT7QheAQgw4ChEzzdJAvs/SmAgUHLVNQb3znurBlAGZVGwCyVMSkixrcKmo6aW353HJWOcYF3Roq9QxbCvBaHHwXvNfAuSVemtllBv5ZbO3vdpmHz1byzGubCJ3jGIUv9AK4xg/sewD9E8AiZ9KsrlZ1X5t0SM+gdZRfVjvjPZXcBPYnCP+bvYisFVyQK6Y+zqgnQtMgHzBuwGEswtQ61AxNGwYwTZRGIUaNkc+eu1tba0CSpYJSyYreXkJUXbqZgs7J4GAYC4CoaOmEDXdqYNaqWBU6BikAaRzl1AL2wLlRQtoXS0JOfn3gFYyWmfWp4E2OyxbMbbrkogzOMZkQYvQIT8USrahQwZPcnj1ifb3BpI7UaFjgOapgDi1ZKSI/oRkuyZVHbgG8mFaeuc/Vw7wbgOkrsCQLynQUXeK1eDxlellK8XQZ7LAudBhUajZxB04ZReK8q20zxrGLYxQHwJAjQqcLcfg0KGAhJIkB22lnfuugXDevgMikMzsgU5VP5wO0U9IaCnKToeKbPm0Du2WLNhLy8pw0gJWM1ZaXl79KI585Upc+v+AqmsDcmGC35sPibGFPOq//bwsvcFx0spedG03v56axrL3A+kk7jhacN7vEbNgCSspYQO37m/7+O1hdsfBB4p5boQP5wugumYfj+3Rhsve/fA3ONLI5e/CuGIDKpn1gNzdD1DRCpGrBMok2l0yf/cDl9iSJSvKMbAy1rmMPoCADnGIU75SE6sfVo/8hq99Ox5ZGVoybXccrtKEHIO9lZ2R0Gv/cCEbph86Xg4kT23Pf0JCV7KO+fMHF+jGl0dagSAAAAAASUVORK5CYII=) |
//! | `FONT_6X13_BOLD` | ![FONT_6X13_BOLD](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGAAAABOCAAAAAD6VUyiAAADDElEQVR4nO1YC3KrMAyU7n9ovb4CRvsxUBo6baeZNiEEe219VmtlPPy6A1Bvo+rqyKRRPBBuLVf9/cpaFKAW4O0yHgLA9xyPb2PGwwf2evshFavQfu8TkS33FUXHvAgAa+/zCECJM9Wk0x2s06rBr+/g/fbZDlaUtq7rPkAA+IGiKCB8Z1FUGvThd6BpULNgnYbkWNPrMhnu7F++JRd9O4DmNAzK2q9rvw9p6N0wmCX+Z/IY0GO6BkCCz5igJp6tPcyzc+YYsm2HE5nYMEtsQIFmsrGBbGZJCzD23Bm30O4GoC0wlyVulJaB01HqmUq1sGmp7TEVY9+Ff9ZSwbA0AoAztzU2i2cQgNo9WoVa6BqoLdEL7NLEX/extKWGS6zZIh38AcsaYR1iWP18RSYf1v8/srsAwAUyMYfZ+UUkAZOEEgkOwAsIJxqMKSkAOE+4ScMCRJQDqJ0WMdb3OT8FgEmC9s/iL1kAwJyKE8ZgvVOAGFs92EGF9UEQzQRaBWLjxEQTJ1cvTQKQIN4/EkVMVp6+qifELA8SikRB6UeylDz446KvACio/zRnKsF1fReTM2HI2aHggNLU9fxY6QLRVVAD0PYxAUB1psFHgZ/+aPUYgPGBZFySvoyutIlhUSErQIa2DUjHdYACGalrPwZIkKgvBRAmMf9BMl9PDzkDCFvQM9QfIZB5DHBRoN3I5PpFwisf3oGV9XJsNM2WRgyBvZCZiaYArTU4BZiY4jLAPNauAXT1ocICsnF7Zr2VeLjieRLDmeQCqI2BmJjFInxRm/bZrU7uNcueqyvwiB1SlIxgosI0TOR4yC7JAGgzpQIArLou4wMHANL6yMmJBN6M5oZ/TNlpR8I00z/FRdqEqvMJfgabdqbiGV/YSqBmnGbyhGJuAGCH6QmA5a/FugnkOlSuISrDl/zWleNMTuo6Yfpg00r4pM2fykLrMwYgrGaK6Q7Wnl3fQVLSzrRp420XRQhAeouPtAc2DKN6OTayVDP1Vl9X+7U2U6ltkKc7uKHsiqvVPJPvAfjuu3v9A2XEKWiScRK7AAAAAElFTkSuQmCC) | | `FONT_9X15_BOLD` | ![FONT_9X15_BOLD](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAJAAAABaCAAAAAByXoC2AAAEXElEQVR4nO2ai27DMAhF4f8/mqlpYvO4YJKmUzd1mtJXbB8DBozD9GF/9wLJ1p+80ivH/rbX0KnwuG6/yWg7b1XtL0+oBlJvNnh5XtgwS052QcA9oMcrbx8uAvUIU6D5mQ7J8FDZFBnninIC7gFtN5VASkLl8JQATUPrAD3v6QEdNmSGekiOK6BDwBIWkORLqqeyqSN5YsjTwonvk9B+S1NCD+sRGiDD1BOdTctp29BxB6/uMqvMAAmtgMBPoRE5ZO4tzuGHePeOQhS9Z8MxglmQkXbbgUnXkSz0s3JRvx5cV9bEH8ZD/zz9uAlIYlgg55/3H0U3IuWNTXyRcqKSeNN9MNcRz6FnWJ/rVRye/zRaVA6kcBVbPqQ60gJzYhMyQNMhpQkUN41aO8YHkCCI4OTkcM7PlAjJ3UgJzwpzqu8KIBsdddQgQxYSAJo3RqvSRjrt02AnQMBYzFfGosRA04y+QUJYkaYfLiU8h9c+QlCrooeFX7Tz0nrHmtZfQsv1V1kbtSCnE/0H5LJzRmtbrLNAM4SbJpyzsDVKmt7veMcUlz+BaYCf9D1JrhTW0XtDx4Wd2m/Fsk8D6m9lv+lHA8ivF5mkotedciDssg4Twlx7Dp6coD/bMWxAnIHTXNw3cfkIVTERNR/bKR+XWVz05Fgo4GyKKEtJgAQH1yHC8TuPTXEowKDBrgLFGHD8I6Dxr0MpEwZyVqWDAwpPtggAgPzoEOishIQWNnQSaNjYoVdrQw2VLY0aphMjDSUPlHTdN2oMJJwbtdWGBorr9rZlD/tKgOayj56t5xiVUlLHKH4bI9gqrGP8xrIv0F8AkjCUZINzWtBgkPZnvgrv7XVHnOb3fhu0jPbw2gIyfipmsuGMojlpGMyhPGA5ZgEUajcXgVBIgAWreo9+HMAxsiHnqbUN1UCSlRaQncQCSzTqGCaJCtmcAUpCXxto9h7ahetMwOMZVnG0t9zMWgnN1ESgFSAgrfJYfkhMpwPUWfZxVLV/gDe/ArTLh5MdlitxpI6AXDkllCTrI5pPCR1D9d9o/xeB5KOoQB20eSog3io5fW9OWDrnZWkdsgDyYboHdOkA73WgouUpoLnDErsvI31WDzylflSFXA0YRhVhf5qD9mVzDxqKTP7ghfypkj39ACpDe9YwVng6JkvQUO6ml2h6KkW+/BGBfM/Re9dAMG9/D1CRwqKk1toQLYBylS2ArDVgGzJ5+6qk55KaFAjZ0JGdLVcZqF/C6gc6P1ILmd9S/aiOfOVKYPp3QDqrbORl33yoEiRXn38bKN3UamdCBELHOl7fCuS2ptJO8t8IRGKclk8b9JlIdrJxrmDFpcoCd0gAVJAwbpSreJcUaKh6hiN5UCbrGjcuqx8So+y5cox79iMCmZr8Gqj1KMjy4csSKASATjkmKrpvQ0SEbSjo3wqlLseEfk5LyK0ypDL9nBzDAo0VHl9YZUZltzmcrJ9+6LgdSF7bnr9BQleSjvn3A5wVopcQTY4EAAAAAElFTkSuQmCC) |
//! | `FONT_6X13_ITALIC` | ![FONT_6X13_ITALIC](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGAAAABOCAAAAAD6VUyiAAADQklEQVR4nO1ZgVbDMAiE//9odEsDd0DabHM+9anPuXVpLkA4jlTlzT9PAZiOv8cAxh2mcef93eeLpUFz5O5aKsBAsRu+6fFB89r3YOrixhSOglfIgMM2gu/m1wbLZK4dVu1f4xs7vLwC+LyujS3holh1M9DHGMTSclx1ZcAML/hpacGJAa0F6P3jBSD2Q3C/rO0XNu22uY2qjyjgwm6E3dbGgAYNVxcf9ePDy5oBXk5kuhIffiYX/TgAiJonzvxi7nS4PhLQusWlrXwbo5G3iuFjJsXrwRwl0JWIfRtCxhjxQ9qTML4sJ7FNAmjyZ2YyckEGQHdNH6PfK0BEQjyDbyCiwG+SqLDNjGORra2x/OAAS3+LGUvta1x/zO+bmB1+DuBM7OYpFqtkb3G4UvmBO0SbTeR5EMi00aGiYBT5CgW0/f9iJhfO/qNc9G4AiBQmkUkQHFEe5vD9H+qakudxg9Y3dFu/Q3kv+xjhedpJewCRFiB492ZuBjAw/DkApvP4FZAl4Fm6VSAemnSZyy+VK4CQaKcGmOiVAcHC472GA3c8tIhxKn34SsF/dBPh4pYAs88Qd3iTBsp6DUqZxs4USok55p+LvgcARVgWZNoQHOq4ui3oFTocbuL8k8rqZvxbj+Fi3TSNKwBmnUSIdeeX3so/fgUAdea5QiORQaZpAQj+arl1DZBJSrN2BdoAHc4i9qR52wWIphVdfLZ9MgAS+BnAmYTsNPCayFBok54HAJxhBbBSx6/n8YD/S13mOy2oh021bbw61eAxKxctAUzLKuopXuuKfQC5tOAcoNSDKPvc3Awl6IQhyt2VRPM7O31YyFlhURK2VXkJtPSkTSErpPJ8rlmt8hI+nuyOG2o5oNJwPn81gISXZN3Z1php5VI6XgCM6S9iLFm1sa7N5fFhZVe50vSaBR5hiXoGZdf3/xI2NTi71ndIx/JE4Qj/RcHZpvECYHr5ZOFVAN6/Ag9UcouzLX57XZQa8dKhL6UjSCOPa1N3TP10XTL11JNJ8GsnvRrpGGd2zXOadLZaZNfd2nSC2ZQm5RBImVTcbS4dvbB0qnel7MhD86QmHk1UZbcT42GBPiPs0vPBdSI/C7BDc+PnA8fkEX1g7/qxAAAAAElFTkSuQmCC) | | `FONT_9X18` | ![FONT_9X18](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAJAAAABsCAAAAACgfWQGAAAEfUlEQVR4nO2bi3LjMAhF4f8/mm0TW+JxQTivSXfU2em6jmwfCwRXSGH6sp8NdA1IePwvfdTZ9DgSfheQAtPP+v0lxAGoOGi/WxNIDnjh45Tuw+zg3uYK00/bHtC4dQmkHn0S3dr3uyoFOv4aZp2PB8ZEV5+th0+0gH4bVUDaZOz7Q+IAfbaHbm2aQPFd5e5SFdA0dBhAkg6pClz0SDzfVfuQ8MJkl4bbvQmv2jg/d469AspPZNGsZ7I5gBVQ6KGqP+ZHoQ/kNMEFIBWHhoNEH2oZKAM6L2lHrfa4XbVd3OjjyXX1Ylt+bKAN9AmgKBJkfKCg7zpRX0XhjM/ElwLC7aoj3J7xeAa2KJQJnVV/iY7kVazmNLrfBNpI4jqhx4R9/zBJDuqd2F2+jIwmuv9q6kz/2jTgEzx4TWFHpjOX5NLRPtS+EBKhbEwy/IWVozgRpyYlAWg2nd5p/CADskfCwdrao4Sd3X4ehU1Wn71ragjkbOcUp6CrijssiMx7YSBzWTz5BJDWV0TgEuOIXs8ASzHFsS0gWPi5iRDXowwExkE98UXHclHhsAqn+ioAtJiqfCx1dGfU/GU8O9tvoA30ESAf4oR09COT5GPwHHFVZXpSIZLYSyWC4ulo6zSMTQ2hrodSFZRBHJQSulw4HhwFpZNEOLYuzlAiFAGQy4t0SJhRadBAo/Lme6gPRKseClrgeOhQxggIyMIAZJzJvTRQFKRf1N4w/otARLYI1O0hoVp5ni6R3HCU5NIe+oAPmauEglMT557/MFCq6OpRFqX6q4a965g6DimgEf2C51aBUQm9NDCK8XE9WSgD485lG2gDbaA3/Ih/lGTP9mHQZPKZbvOAVh0oVQkWQWBlgxhkG5co4O/OgdeMRLhEZ4gat4b6C8X+WrkkQL5C+igQyqlKh4WyDCjG2LwLTIayvfKvHCgxE+6ZrLAMnBpl+9SHekCJWlkArfZHJK49ZwSzU9FGEWipNhBace4ChSJfskot3ATqDHs0qxwTGkz/BNBZX0aT4lBIDIgAKATGxKB16pB3ZJNl6hi7KHa230CvAJJvomL6MqLnNx5+wIfqlSUTRvGneqXFLR0vvfZxIK+smuvQ8peB1HZO8oU7OpZRJYyE8yNzFRsTSdD5t6wJn4UWrUNlNNa5KNscC/O8JFUogVVYANSpL5kgltepk32qodYJgcQIEnyXEE57QH7JtQV0qcbofKiWZkKcmmwFBKvrSx8iWpksqtumycJ4aY0yU6K0sxaBH72xxljthVns23mP/Pg6ID+trNLdVowb6L8Ccuse6ZM/vhkF7jCSqVr46g1fDBSKJ18ApHX3scSpy8Ki1hhdWZh7Vdi57Ke8ovk9phuQXfclhZzl9kYV1u1jQxu+8Hdn6leM+yyrGqNeDfdVqVYPuX2MoG4cxEav6Gm+29QH8vsYcSE7MVlZ9AQ7dK8AAR8KW0qNVj8Vpa0xmqInpUXG1c5LNMqQyfS4Y1gGjZuE7Q7cdaQ2JntZwFndZD1zfTnQxe8lvh8IBZg/LD/+AZ+gyal3w6AiAAAAAElFTkSuQmCC) |
//! | `FONT_7X13` | ![FONT_7X13](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAHAAAABOCAAAAADd+81KAAADnElEQVR4nO2Z23riMAyEpfd/aC0E25rRwSSFsrtfywW0kPi3bGksKSoffv1NoOnj3dIk7t9YunJ82pU5m3bAyX2wbu8FkD/eA7RjEQbPRFvgmtIWf/uxWCgZoIMEgwYz/Z8xtRP29kCwUM8AbTiEkV9Y4SV7Cyd4rBb79GULj5/2Fj62cNhmGlz46h5GYPjReC3R1NJZ+XYeGeKns7AKw/so1oyTgJrwCfjGV5wE/P+jtPRjQIog8/hdIW9+pXCMe+Ts9nF683HlEsoHF/1ufWuatj4oru79xi+6ibeHrTHQR8zxtiapOFYfnDB0voMnNOYiomGNAGhruf1jbg9osXRAV+0pMzIORZRy2EPNG6H1Ct9Piwh0jWAxu+OUjNuJWx35x2kR7mbHgMiB7ToBnFIosMLzeCKdz+uS/YN8SuK7FMcU/r3i8HEChiCDqdJhJbyHQMIdKQ/O9ynNyRTuV7y/ATj9Y+oF+IcJSjk71PLZ5foeY+zreCUEvqmnEhQBfL+0IgojLD8+VIpv0CLIPDdrgZVW8KwBKBqAKIevAlmADvvGieNAuhA2yIFd3JNuLZnPwJVlTqCBR5yx0LIG1xbiCYZLqpf3sHearMiV03C+/txLLVoI7hlShATksNrGoXoezZv+uAbSALghxeGvlv7jQE6LqyS5dhM84+Pm11oIYVyc9lg9bUdLKWgHpPQ4AbFw3gCrnJdJ+TRKVYFp6CtdADIlAXMyXWaQatIHfgMcOsN9CxOtQAUwyFBa/g4Y+hbRO7oc2YFT7HNN43/MNNZiAt2559ZCaI2UXsrA4pJU0u2ARWqUCiWqWQOQ43AH3NU8b1WaMaef0cXQT1uYdlqajcWWXd1iWyHVLl3fFMtfkSaW5Z/pU/+7CpRzFp4Azji0cB6qR6WnwAo9DW+9C3aPdX3DY4Y45DqAM0LAei8lLWnW5lBbUFw29RbJSKl+a76ikoAhL5UuaU3HNSypNMDSwhaYSquQZJtuqyd+AvAMGFzhidPkCjiUCN2XX8m86/aInZWsL8ha3ZK1k2P9/6eFsZjodwNjroEJ2AmnuX5yVUCKjs8AQZow8lIcYvxxQZ1S9Xi4NlniHejaYlLV+A0wJP6YSJKF8Smblu1ebrgkIDbz948R8tOEykJHhtR6imUAmmgilLXFaLIbyWZhEwwKwPXoW7BA2AIp85awpPjcIzyb8GMIelwhBdxZ+FLmnaT8qdK8COyfrjWvPxMcD4sO7XO4AAAAAElFTkSuQmCC) | | `FONT_9X18_BOLD` | ![FONT_9X18_BOLD](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAJAAAABsCAAAAACgfWQGAAAETUlEQVR4nO2bCZKrMAxErfsfWpNJwGhpyWIJxUw5/09lAcPDlq2mbag97DWBdgHx8vX1znXUbdflE5+5zBxoI+tvr3d+/1kM9GHv61WwBsQL/Pt7/0BXA/2WKwF93tb/EZDAcD/VEEOg7funZlTLLVXmo8wCsShYAnrvlAKpJiMTuO4UroZ4i9IK0GefGpAgstGdAK2l2HcgDrsU5cy9GPf3LariyzlSQ8suNNpJBw+LkPIRdyaG1j1KTcYCounuBounH/w5FHI9qPWQCGKo1MkjoF6kOoLV++1g39GB7k6uwwub8mMCTaA7gLh5+SKSkdzosxvD4xy50E8p0ikdaGqlN9gLV5O72kiSRxJhKUX9YJvEYHlqqyQo4VmPQ8kAGKXktRT5zIzSgFCKEZDeh4NG5EzXaSC/TafiLYZ6eDlRLegxkNgVaCXTZFCmm5aAv5ha1LSFTKaOEwAZNK04GZZKmjQn0teFgUAwGdqDQLKPtIZOSuD2VL1HLQVLcXRvwi0itd9JDDGt68J1k5Sp/vYjGE7xPngA82F7V+oo313Tw3hmtp9AE+gOIJEKWYzrzlBRGtILRaWrxICoJRcc9qWQICBfvN7yusspvUw1oOKLRHHbhbuBrjXXINEZsTFjskyvaXJA/PvvFJDJ9h7IarHPWYW/A4Gs+QKBrGL0Fw2BKK5XHWcaSHDsqSFuoyYDNSQjdFhDN8SQLWWCGgb8WSB4wiHQYGw40+3xsYZAKHQqA6NolWhg5AY34YrrA+PMZRNoAk2gL7y8HcLRuUkJxmbmuViKSmyTuQ8sHCUjG4DL5e4hCfgHg/RUBrIyCboqtqpoeA5TPNxZXY9xmmIgNxN4FChzFJFn4s2YwEqkKCdrSzEF4u4UISkAf2ih/0BGjNr7mNAmKwFh920IBHUutRxIqA4GxntwJzA2/TQQm35XAhJ9m337Rr2rAFTp9tr7JXjLdx3QGk5JUCv7crv95kDCuvspWH956uBvZJNx6uiW68z2E+gCIH4UVXk91q1N9iSi+jSbX5wzWGDl5VAsXC8AclPPFaCDq2NOAyUldwE5SW9dD4qtPNK7kGpXIR8YSQSZrdGkdUHJg1nHioOmZ9SdncfAjqk4aG7VwRjIzHCyXupnDCuTcQdAdjj9ItAuj9F35aNNthuoEEOttdrUQgKEYsj1l3ovo+imheEmtgs4KOxlB8QgZSPX7qz0/4DilSft0FKrqRgn0B8BsjNmcbTfZXpGj8mwHCf3DIznZHcIJFYHBvLjfiC5ZHOZwGty2r9PzNZsYZCV4MRZ/GSTATe28DaLXLSFWUmPQAxATR08O1OTFrHHqB/esAsaE+uKAycoBSq4sGrNKnuXjVoZyK1jBEA6+hrwGNMawlPGFSAomKwIhHpKPIgE7EdqO4Ca1IfkxZ+RFm5ipq/tQSLfP6w0HqlVk1003owPUrhzvRyI6cxBvlFD1z1W+oTXD4yYi6lUFGaBAAAAAElFTkSuQmCC) |
//! | `FONT_7X13_BOLD` | ![FONT_7X13_BOLD](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAHAAAABOCAAAAADd+81KAAADWUlEQVR4nO1Z4ZrjIAiE939ork2MDjCoafv1vrvd/thuk+gIwjgQlS9//iKgHf8//h7/mJpeF+352OOntcetjWo3b6z58fAc0OTEMj2v92ckfb0JaIf1J47a8a9MAe3wwQL+eTMC9h8dsN8MgP15torbgM6lY06/JgC0MyBsGojHiKmFp4cVvH2G0iZggD8HaLUY2ENp23hMmFZYfOWZI2Dt0mZa30MGGIKGeL/dmQO2R1sKtmil81BrwF2aAT/5CavAnz+JS78H6KOtbXBfjI3s8vfsGi2LsBlsJQfTtIC2Dh4XoHDBYBUKX9OwGdz3JG/rieYBweBMkwRwdoTg1GmES6/rUMJEAlsB0Dt4rFYc0TNAg4F+UsN9FYSIFmYfj4M8Ajoz6K55D/EjKV6Buck0COiDdQPQwIcW8uAKb6TdnYB0Qcd3hEXpOA9xNSHJ4LSLEZEuCtMB6eD8HNPEEPjRXPptQLfrI43hFw0oZAMXz9LF5Rn8gYyadNFIKvFLYspQSswD0mQ1YJS/QnEToEvhyzPqAPuJ8AnAmKkUUMde+IPBs/a4Z6h5A6AS5wuY9JqF9R5KJsi+wrGHdINfAwwnTAH4fpSu1gt7SNKqzEPFusPnIahrC7sW8vCXS/99QBomXmTz0HXMTGJHiAyoZ1vEPFXeUURHQbkCTJo5RnkvEXynI8kYXw3cAGwQXGsLE/xyDWtnY6TrlPhTQN4fQkVIRZVmZk8lhrcpKkneFypFuYKAxX4aA/R6mgnoW4BI6YWqJyFUAZY6VX3OQJskVokymiijq5LMZopdBM5/ndQ8n/0QwP9XCOuXLbSy4VZUmzQBRFxKlVaE2J0CunbiFHDiNq3tYYCLkL4DyM5DVFG+qjZk3VRbDDawNGfIw/nRJyXTeF0ay3gvEzEvK2GJ8byhvHcAN5S37yZsAVIhXAHO+iWLcm0HsLt0K2hmFXCql95V3rRhaduU9QKt0Zas7c71K/Vf8Hd6O2b9fecyaG4fXUwmhhr/C4AontVlXlkB6w7PyqrX7nreK265VcwUytv1vCvaLAEjpcr6hbTreccqJjbeK6kfyqOt2sLvoYYqi9iEQefHrVyq4l56WtTh+BYDDPZFlISgKd9SU8DPUPmUad4E3Gft9vkDRiLlfAo+mw4AAAAASUVORK5CYII=) | | `FONT_10X20` | ![FONT_10X20](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAKAAAAB4CAAAAABQyaazAAAFBUlEQVR4nO2ciXLqMAxF5f//aL0WSKLlXlvZCo8x0xlCIPGJbG2W3SYf/pqAFwPq68Tvuyb6fObn1HrOfvs81guevwD48/441PWCB9XrXFspDI69zZnXz/V1wOebPyKACqV6KaBo+/3LgOuJRZY1wPDAdT7WxW6QPbvWsKgsx2pGifLBeCegoN7sjzIAaJ+kDPj4YR3QKImVTAlw7QZzBDrpJKD4YRi+u16Cz9+NAN3TIUAAedEYrAFGPdVNeTdbyO9yQotfP2uF3xkoq7xGe2QEuMf0+efYIUHrSdryt5lEZu8rMODcculYSaifWdwf99oj+R0A/NOXVpqf8eAEnIBfAQgs/2Z+vSHW5v2zmvd4Ll4LTU1jH1/XphtG3+nTp+jbQnK1fo2u7Zl+7CRfAau9oROpb2l7gChwBbz52gpfdJLPnERzikYaeT0AjQWMfEuAnXDcAAaExoOSHL6cA7TBrIhE2e0ADG0u0aA9Cg8fUJ3jVQFt0XHYAfQDz7QZYtWUd7qhvOEEwIpkm3BAG2pYNqIQAqPnLT8tjsCsJwxQQ96V8zEGGEfeWFLk7JqToHwBDL94zwioYJBLSYu15zQwINDfoZ4CQD1uB52ryzkr9RWIDYkse5KsxX1P4tLOJGrsWZPFzs6H+3EM2PHFOC/+g5fua3TGgxNwAn4DIDLUzoCFCda+vbQ22rmwxyHNI4BnWnISH33EG/jojgesLAps/XA2ArpGUjxIYbo5VEcKBDA95sKmkrKutnZGK0mrD5jCi/2A0gCgSogM7wXM0YUd0xiw5U7Ecd09gA2V2/qAItIBFKDZ2/PD8HPLZ1BkWgXcRH2si2tK0pWgm1W2Y7Cose8BTKH71YBIgem1CgAr8fzbAOmUFLU6HU/SyZVxL9GHM7Nbq2YhPR354jCfp434YgXzZv4u3BfPcGsCTsAJeC9g3+ahSsg+jxMsogK5+OZaAux5DT45twcwJSUZJU1L7ZZHFZAXcgqAufRTDwxOA6aqRL43KFycA8TJJq7V4blRgR92SJCt0gGAmlec9QHpMVMSGG7RCWIOOFyotxfQJ0gx3Mo3R92JJQjKA6xfR12cBz/t27cC2qRPwdx5BxDMXKCOhdZvhwSVjksM6GqFOq67nAKERoPJo+BdCoCs9kYAQXbCRhTXbCJf4ouV+WcezehHRDg648EJOAG/CbC0cYR9k2L08loolfISUa2vtUUlcua9htdrFbBbmT8FmD4cBBQ5I8GqjD4R8KouBsGC2rwiriMCCf7zZ9rstWE9hsRIcwkl/A4kn8/g1WtxLtd/EWuN5lJ/LeliRbVVkdwu2JEj9Vl+sJynX+3MmzvcrhSSVzYQ44wBsw2tA6JVOEXA/XWSY4CHJXgGcGt52MVgDB4AHCoJXFImJUCQzyRArCTIVFAzkxYcbiZKKisO3XxjBry6TjJYUEv2Fv1huDUBLyDs3k6PNjZD/gl4wyuue40rXd9dL+5MEPvN6STcKkbDdwG6PSt5j/ubAYFd/Q8AQ2CwLVEKaQeuBhTLaGpUsv7vDpb1gzHIsGtX+qv1+6UwvIYeL5Snm4BH9SUaPRdKYWQnRVWCeT8JLIBp7ptqpYmEtBcDikhvxwgq5PTKFR8BiLoYFiIqu2KokoAdOW7AqfBCQ+d+xySYzAweg9aJpsomU5eWzEzPF/MuvtwcX3W/OwEv+bc9t0pwvDv2zYDFaeju6x9avM7D1EdUsgAAAABJRU5ErkJggg==) |

/// 4x6 pixel monospace font.
pub const FONT_4X6: crate::mono_font::MonoFont = crate::mono_font::MonoFont {
    image: crate::image::ImageRaw::new_binary(
        include_bytes!("../../../fonts/raw/ascii/font_4x6.raw"),
        64,
    ),
    glyph_mapping: &crate::mono_font::mapping::ASCII,
    character_size: crate::geometry::Size::new(4, 6),
    character_spacing: 0,
    baseline: 4,
    underline: crate::mono_font::DecorationDimensions::new(4 + 2, 1),
    strikethrough: crate::mono_font::DecorationDimensions::new(6 / 2, 1),
};

/// 5x7 pixel monospace font.
pub const FONT_5X7: crate::mono_font::MonoFont = crate::mono_font::MonoFont {
    image: crate::image::ImageRaw::new_binary(
        include_bytes!("../../../fonts/raw/ascii/font_5x7.raw"),
        80,
    ),
    glyph_mapping: &crate::mono_font::mapping::ASCII,
    character_size: crate::geometry::Size::new(5, 7),
    character_spacing: 0,
    baseline: 5,
    underline: crate::mono_font::DecorationDimensions::new(5 + 2, 1),
    strikethrough: crate::mono_font::DecorationDimensions::new(7 / 2, 1),
};

/// 5x8 pixel monospace font.
pub const FONT_5X8: crate::mono_font::MonoFont = crate::mono_font::MonoFont {
    image: crate::image::ImageRaw::new_binary(
        include_bytes!("../../../fonts/raw/ascii/font_5x8.raw"),
        80,
    ),
    glyph_mapping: &crate::mono_font::mapping::ASCII,
    character_size: crate::geometry::Size::new(5, 8),
    character_spacing: 0,
    baseline: 6,
    underline: crate::mono_font::DecorationDimensions::new(6 + 2, 1),
    strikethrough: crate::mono_font::DecorationDimensions::new(8 / 2, 1),
};

/// 6x9 pixel monospace font.
pub const FONT_6X9: crate::mono_font::MonoFont = crate::mono_font::MonoFont {
    image: crate::image::ImageRaw::new_binary(
        include_bytes!("../../../fonts/raw/ascii/font_6x9.raw"),
        96,
    ),
    glyph_mapping: &crate::mono_font::mapping::ASCII,
    character_size: crate::geometry::Size::new(6, 9),
    character_spacing: 0,
    baseline: 6,
    underline: crate::mono_font::DecorationDimensions::new(6 + 2, 1),
    strikethrough: crate::mono_font::DecorationDimensions::new(9 / 2, 1),
};

/// 6x10 pixel monospace font.
pub const FONT_6X10: crate::mono_font::MonoFont = crate::mono_font::MonoFont {
    image: crate::image::ImageRaw::new_binary(
        include_bytes!("../../../fonts/raw/ascii/font_6x10.raw"),
        96,
    ),
    glyph_mapping: &crate::mono_font::mapping::ASCII,
    character_size: crate::geometry::Size::new(6, 10),
    character_spacing: 0,
    baseline: 7,
    underline: crate::mono_font::DecorationDimensions::new(7 + 2, 1),
    strikethrough: crate::mono_font::DecorationDimensions::new(10 / 2, 1),
};

/// 6x12 pixel monospace font.
pub const FONT_6X12: crate::mono_font::MonoFont = crate::mono_font::MonoFont {
    image: crate::image::ImageRaw::new_binary(
        include_bytes!("../../../fonts/raw/ascii/font_6x12.raw"),
        96,
    ),
    glyph_mapping: &crate::mono_font::mapping::ASCII,
    character_size: crate::geometry::Size::new(6, 12),
    character_spacing: 0,
    baseline: 9,
    underline: crate::mono_font::DecorationDimensions::new(9 + 2, 1),
    strikethrough: crate::mono_font::DecorationDimensions::new(12 / 2, 1),
};

/// 6x13 pixel monospace font.
pub const FONT_6X13: crate::mono_font::MonoFont = crate::mono_font::MonoFont {
    image: crate::image::ImageRaw::new_binary(
        include_bytes!("../../../fonts/raw/ascii/font_6x13.raw"),
        96,
    ),
    glyph_mapping: &crate::mono_font::mapping::ASCII,
    character_size: crate::geometry::Size::new(6, 13),
    character_spacing: 0,
    baseline: 10,
    underline: crate::mono_font::DecorationDimensions::new(10 + 2, 1),
    strikethrough: crate::mono_font::DecorationDimensions::new(13 / 2, 1),
};

/// 6x13 pixel monospace font.
pub const FONT_6X13_BOLD: crate::mono_font::MonoFont = crate::mono_font::MonoFont {
    image: crate::image::ImageRaw::new_binary(
        include_bytes!("../../../fonts/raw/ascii/font_6x13_bold.raw"),
        96,
    ),
    glyph_mapping: &crate::mono_font::mapping::ASCII,
    character_size: crate::geometry::Size::new(6, 13),
    character_spacing: 0,
    baseline: 10,
    underline: crate::mono_font::DecorationDimensions::new(10 + 2, 1),
    strikethrough: crate::mono_font::DecorationDimensions::new(13 / 2, 1),
};

/// 6x13 pixel monospace font.
pub const FONT_6X13_ITALIC: crate::mono_font::MonoFont = crate::mono_font::MonoFont {
    image: crate::image::ImageRaw::new_binary(
        include_bytes!("../../../fonts/raw/ascii/font_6x13_italic.raw"),
        96,
    ),
    glyph_mapping: &crate::mono_font::mapping::ASCII,
    character_size: crate::geometry::Size::new(6, 13),
    character_spacing: 0,
    baseline: 10,
    underline: crate::mono_font::DecorationDimensions::new(10 + 2, 1),
    strikethrough: crate::mono_font::DecorationDimensions::new(13 / 2, 1),
};

/// 7x13 pixel monospace font.
pub const FONT_7X13: crate::mono_font::MonoFont = crate::mono_font::MonoFont {
    image: crate::image::ImageRaw::new_binary(
        include_bytes!("../../../fonts/raw/ascii/font_7x13.raw"),
        112,
    ),
    glyph_mapping: &crate::mono_font::mapping::ASCII,
    character_size: crate::geometry::Size::new(7, 13),
    character_spacing: 0,
    baseline: 10,
    underline: crate::mono_font::DecorationDimensions::new(10 + 2, 1),
    strikethrough: crate::mono_font::DecorationDimensions::new(13 / 2, 1),
};

/// 7x13 pixel monospace font.
pub const FONT_7X13_BOLD: crate::mono_font::MonoFont = crate::mono_font::MonoFont {
    image: crate::image::ImageRaw::new_binary(
        include_bytes!("../../../fonts/raw/ascii/font_7x13_bold.raw"),
        112,
    ),
    glyph_mapping: &crate::mono_font::mapping::ASCII,
    character_size: crate::geometry::Size::new(7, 13),
    character_spacing: 0,
    baseline: 10,
    underline: crate::mono_font::DecorationDimensions::new(10 + 2, 1),
    strikethrough: crate::mono_font::DecorationDimensions::new(13 / 2, 1),
};

/// 7x13 pixel monospace font.
pub const FONT_7X13_ITALIC: crate::mono_font::MonoFont = crate::mono_font::MonoFont {
    image: crate::image::ImageRaw::new_binary(
        include_bytes!("../../../fonts/raw/ascii/font_7x13_italic.raw"),
        112,
    ),
    glyph_mapping: &crate::mono_font::mapping::ASCII,
    character_size: crate::geometry::Size::new(7, 13),
    character_spacing: 0,
    baseline: 10,
    underline: crate::mono_font::DecorationDimensions::new(10 + 2, 1),
    strikethrough: crate::mono_font::DecorationDimensions::new(13 / 2, 1),
};

/// 7x14 pixel monospace font.
pub const FONT_7X14: crate::mono_font::MonoFont = crate::mono_font::MonoFont {
    image: crate::image::ImageRaw::new_binary(
        include_bytes!("../../../fonts/raw/ascii/font_7x14.raw"),
        112,
    ),
    glyph_mapping: &crate::mono_font::mapping::ASCII,
    character_size: crate::geometry::Size::new(7, 14),
    character_spacing: 0,
    baseline: 11,
    underline: crate::mono_font::DecorationDimensions::new(11 + 2, 1),
    strikethrough: crate::mono_font::DecorationDimensions::new(14 / 2, 1),
};

/// 7x14 pixel monospace font.
pub const FONT_7X14_BOLD: crate::mono_font::MonoFont = crate::mono_font::MonoFont {
    image: crate::image::ImageRaw::new_binary(
        include_bytes!("../../../fonts/raw/ascii/font_7x14_bold.raw"),
        112,
    ),
    glyph_mapping: &crate::mono_font::mapping::ASCII,
    character_size: crate::geometry::Size::new(7, 14),
    character_spacing: 0,
    baseline: 11,
    underline: crate::mono_font::DecorationDimensions::new(11 + 2, 1),
    strikethrough: crate::mono_font::DecorationDimensions::new(14 / 2, 1),
};

/// 8x13 pixel monospace font.
pub const FONT_8X13: crate::mono_font::MonoFont = crate::mono_font::MonoFont {
    image: crate::image::ImageRaw::new_binary(
        include_bytes!("../../../fonts/raw/ascii/font_8x13.raw"),
        128,
    ),
    glyph_mapping: &crate::mono_font::mapping::ASCII,
    character_size: crate::geometry::Size::new(8, 13),
    character_spacing: 0,
    baseline: 10,
    underline: crate::mono_font::DecorationDimensions::new(10 + 2, 1),
    strikethrough: crate::mono_font::DecorationDimensions::new(13 / 2, 1),
};

/// 8x13 pixel monospace font.
pub const FONT_8X13_BOLD: crate::mono_font::MonoFont = crate::mono_font::MonoFont {
    image: crate::image::ImageRaw::new_binary(
        include_bytes!("../../../fonts/raw/ascii/font_8x13_bold.raw"),
        128,
    ),
    glyph_mapping: &crate::mono_font::mapping::ASCII,
    character_size: crate::geometry::Size::new(8, 13),
    character_spacing: 0,
    baseline: 10,
    underline: crate::mono_font::DecorationDimensions::new(10 + 2, 1),
    strikethrough: crate::mono_font::DecorationDimensions::new(13 / 2, 1),
};

/// 8x13 pixel monospace font.
pub const FONT_8X13_ITALIC: crate::mono_font::MonoFont = crate::mono_font::MonoFont {
    image: crate::image::ImageRaw::new_binary(
        include_bytes!("../../../fonts/raw/ascii/font_8x13_italic.raw"),
        128,
    ),
    glyph_mapping: &crate::mono_font::mapping::ASCII,
    character_size: crate::geometry::Size::new(8, 13),
    character_spacing: 0,
    baseline: 10,
    underline: crate::mono_font::DecorationDimensions::new(10 + 2, 1),
    strikethrough: crate::mono_font::DecorationDimensions::new(13 / 2, 1),
};

/// 9x15 pixel monospace font.
pub const FONT_9X15: crate::mono_font::MonoFont = crate::mono_font::MonoFont {
    image: crate::image::ImageRaw::new_binary(
        include_bytes!("../../../fonts/raw/ascii/font_9x15.raw"),
        144,
    ),
    glyph_mapping: &crate::mono_font::mapping::ASCII,
    character_size: crate::geometry::Size::new(9, 15),
    character_spacing: 0,
    baseline: 11,
    underline: crate::mono_font::DecorationDimensions::new(11 + 2, 1),
    strikethrough: crate::mono_font::DecorationDimensions::new(15 / 2, 1),
};

/// 9x15 pixel monospace font.
pub const FONT_9X15_BOLD: crate::mono_font::MonoFont = crate::mono_font::MonoFont {
    image: crate::image::ImageRaw::new_binary(
        include_bytes!("../../../fonts/raw/ascii/font_9x15_bold.raw"),
        144,
    ),
    glyph_mapping: &crate::mono_font::mapping::ASCII,
    character_size: crate::geometry::Size::new(9, 15),
    character_spacing: 0,
    baseline: 11,
    underline: crate::mono_font::DecorationDimensions::new(11 + 2, 1),
    strikethrough: crate::mono_font::DecorationDimensions::new(15 / 2, 1),
};

/// 9x18 pixel monospace font.
pub const FONT_9X18: crate::mono_font::MonoFont = crate::mono_font::MonoFont {
    image: crate::image::ImageRaw::new_binary(
        include_bytes!("../../../fonts/raw/ascii/font_9x18.raw"),
        144,
    ),
    glyph_mapping: &crate::mono_font::mapping::ASCII,
    character_size: crate::geometry::Size::new(9, 18),
    character_spacing: 0,
    baseline: 13,
    underline: crate::mono_font::DecorationDimensions::new(13 + 2, 1),
    strikethrough: crate::mono_font::DecorationDimensions::new(18 / 2, 1),
};

/// 9x18 pixel monospace font.
pub const FONT_9X18_BOLD: crate::mono_font::MonoFont = crate::mono_font::MonoFont {
    image: crate::image::ImageRaw::new_binary(
        include_bytes!("../../../fonts/raw/ascii/font_9x18_bold.raw"),
        144,
    ),
    glyph_mapping: &crate::mono_font::mapping::ASCII,
    character_size: crate::geometry::Size::new(9, 18),
    character_spacing: 0,
    baseline: 13,
    underline: crate::mono_font::DecorationDimensions::new(13 + 2, 1),
    strikethrough: crate::mono_font::DecorationDimensions::new(18 / 2, 1),
};

/// 10x20 pixel monospace font.
pub const FONT_10X20: crate::mono_font::MonoFont = crate::mono_font::MonoFont {
    image: crate::image::ImageRaw::new_binary(
        include_bytes!("../../../fonts/raw/ascii/font_10x20.raw"),
        160,
    ),
    glyph_mapping: &crate::mono_font::mapping::ASCII,
    character_size: crate::geometry::Size::new(10, 20),
    character_spacing: 0,
    baseline: 15,
    underline: crate::mono_font::DecorationDimensions::new(15 + 2, 1),
    strikethrough: crate::mono_font::DecorationDimensions::new(20 / 2, 1),
};
