//! `Canvas`es implemented with const generics
use embedded_graphics_core::prelude::{PixelColor, Point};

pub struct Canvas<C: PixelColor, const W: usize, const H: usize> {
    pub pixels: [[Option<C>; W]; H],
}
pub struct CanvasAt<C: PixelColor, const W: usize, const H: usize> {
    pub top_left: Point,
    pub pixels: [[Option<C>; W]; H],
}
