use crate::types::heap::BoxedBytes;

use super::{ErrorApiImpl, Handle};

pub trait EndpointArgumentApi {
    type EndpointArgumentApiImpl: EndpointArgumentApiImpl;

    fn argument_api_impl() -> Self::EndpointArgumentApiImpl;
}

/// Interface to only be used by code generated by the macros.
/// The smart contract code doesn't have access to these methods directly.
pub trait EndpointArgumentApiImpl: ErrorApiImpl {
    fn get_num_arguments(&self) -> i32;

    fn get_argument_len(&self, arg_index: i32) -> usize;

    fn copy_argument_to_slice(&self, arg_index: i32, slice: &mut [u8]);

    fn get_argument_boxed_bytes(&self, arg_index: i32) -> BoxedBytes;

    fn load_argument_big_int_signed(&self, arg_index: i32, dest: Handle);

    fn load_argument_big_int_unsigned(&self, arg_index: i32, dest: Handle);

    fn load_argument_managed_buffer(&self, arg_index: i32, dest: Handle);

    fn get_argument_u64(&self, arg_index: i32) -> u64;

    fn get_argument_i64(&self, arg_index: i32) -> i64;
}
