const RESERVED: &[&str] = &[
    "getSCAddress",
    "getOwnerAddress",
    "getShardOfAddress",
    "isSmartContract",
    "getExternalBalance",
    "getBlockHash",
    "getBlockNonce",
    "getBlockRound",
    "getBlockEpoch",
    "getBlockRandomSeed",
    "getStateRootHash",
    "getPrevBlockTimestamp",
    "getPrevBlockNonce",
    "getPrevBlockRound",
    "getPrevBlockEpoch",
    "getPrevBlockRandomSeed",
    "getOriginalTxHash",
    "transferValue",
    "getArgument",
    "getFunction",
    "getNumArguments",
    "getArgumentLength",
    "storageLoadLength",
    "storageStore",
    "storageLoad",
    "getCaller",
    "getCallValue",
    "writeLog",
    "finish",
    "signalError",
    "getGasLeft",
    "getBlockTimestamp",
    "executeOnSameContext",
    "executeOnDestContext",
    "executeOnDestContextByCaller",
    "asyncCall",
    "delegateExecution",
    "createContract",
    "deployFromSourceContract",
    "executeReadOnly",
    "getNumReturnData",
    "getReturnDataSize",
    "getReturnData",
    "int64getArgument",
    "int64storageStore",
    "int64storageLoad",
    "int64finish",
    "bigIntNew",
    "bigIntUnsignedByteLength",
    "bigIntSignedByteLength",
    "bigIntGetUnsignedBytes",
    "bigIntGetSignedBytes",
    "bigIntSetUnsignedBytes",
    "bigIntSetSignedBytes",
    "bigIntIsInt64",
    "bigIntGetInt64",
    "bigIntSetInt64",
    "bigIntAdd",
    "bigIntSub",
    "bigIntMul",
    "bigIntTDiv",
    "bigIntTMod",
    "bigIntEDiv",
    "bigIntEMod",
    "bigIntAbs",
    "bigIntNeg",
    "bigIntSign",
    "bigIntCmp",
    "bigIntNot",
    "bigIntAnd",
    "bigIntOr",
    "bigIntXor",
    "bigIntShr",
    "bigIntShl",
    "bigIntFinishUnsigned",
    "bigIntFinishSigned",
    "bigIntStorageStoreUnsigned",
    "bigIntStorageLoadUnsigned",
    "bigIntGetUnsignedArgument",
    "bigIntGetSignedArgument",
    "bigIntGetCallValue",
    "bigIntGetExternalBalance",
    "sha256",
    "keccak256",
    "verifyBLS",
    "verifyEd25519",
    "verifySecp256k1",
];

pub fn is_reserved(fn_name: &str) -> bool {
    let result = RESERVED.iter().find(|r| **r == fn_name);
    result.is_some()
}
