use crate::TxContext;
use elrond_wasm::api::EndpointFinishApi;
use num_bigint::{BigInt, BigUint};

/// Interface to only be used by code generated by the macros.
/// The smart contract code doesn't have access to these methods directly.
impl EndpointFinishApi for TxContext {
	fn finish_slice_u8(&self, slice: &[u8]) {
		let mut v = vec![0u8; slice.len()];
		v.copy_from_slice(slice);
		let mut tx_output = self.tx_output_cell.borrow_mut();
		tx_output.result.result_values.push(v)
	}

	fn finish_big_int_raw(&self, _handle: i32) {
		panic!("cannot call finish_big_int_raw in debug mode");
	}

	fn finish_big_uint_raw(&self, _handle: i32) {
		panic!("cannot call finish_big_uint_raw in debug mode");
	}

	fn finish_i64(&self, value: i64) {
		if value == 0 {
			self.finish_slice_u8(&[]);
		} else {
			self.finish_slice_u8(BigInt::from(value).to_signed_bytes_be().as_slice());
		}
	}

	fn finish_u64(&self, value: u64) {
		if value == 0 {
			self.finish_slice_u8(&[]);
		} else {
			self.finish_slice_u8(BigUint::from(value).to_bytes_be().as_slice());
		}
	}
}
