use anyhow::Result;
use derive_builder::Builder;
pub use ipnet::Ipv4Net;
use jacklog::debug;
use std::{
    process::{Command, Stdio},
    str,
};
use uuid::Uuid;

#[derive(Builder, Debug, PartialEq, PartialOrd)]
pub struct Connection {
    interface: String,
    peer_ipv4: Ipv4Net,
    ipv4: Ipv4Net,
}

impl Connection {
    pub fn setup(&self) -> Result<()> {
        let key = self.peer_public_key()?;
        debug!(?key);

        Ok(())
    }

    fn peer_public_key(&self) -> Result<String> {
        let command = Command::new("ssh")
            .args(&[
                "-t",
                &self.peer_ipv4.addr().to_string(),
                "sudo",
                "bash",
                "-c",
                "wg show | grep interface",
            ])
            .stdout(Stdio::piped())
            .spawn()?;
        eprint!("[sudo] password: ");
        let out = command.wait_with_output()?;

        Ok(str::from_utf8(&out.stdout)?.trim().into())
    }
}

const TEMPLATE: &str = "[connection]
id=wg0
uuid=c78d8828-d3f6-4046-9ba9-0c5dbb7b7bf7
type=wireguard
autoconnect=false
interface-name=wg0
permissions=
timestamp=1627106428

[wireguard]
private-key=+OEAcAzYbhLWkyxtngAXPqSIYXlpQa++5L0lRVaLcXE=

[wireguard-peer.iB0ue9GNQHNCr+Pma/gdP0Vs6JLBeQX//NgYU1mCQEw=]
endpoint=173.255.252.199:51820
preshared-key=vUhxnqLZPiv/CrgPA0vu3fMft+lkMDlnMaTplzEsfIo=
preshared-key-flags=0
persistent-keepalive=25
allowed-ips=10.0.0.0/24;

[ipv4]
address1=10.0.0.3/24
dns-priority=-50
dns-search=
method=manual

[ipv6]
addr-gen-mode=stable-privacy
dns-priority=-50
dns-search=
method=disabled";
