from elbus import ELBus, Message

import threading
import time
import random

iters = 100_000
workers = 1

cnt = 0


def on_message(message):
    global cnt
    cnt += 1


def test(w, iters):
    name = f'test{random.randint(0,1000_000)}-{w}'
    path = '/tmp/elbus.sock'
    # path = 'localhost:9924'
    bus = ELBus(path, name)
    bus.on_message = on_message
    bus.connect()
    print(f'Connected to {path}')
    for _ in range(iters):
        frame = bus.send_message(name, Message('abc123'))
        # frame.wait_completed()
        # print(hex(frame.result))


started = time.perf_counter()
for w in range(workers):
    threading.Thread(target=test, args=(w, int(iters / workers))).start()
while cnt < iters:
    time.sleep(0.01)
elapsed = time.perf_counter() - started
speed = round(iters / elapsed)
print(f'{speed} iters/s ({round(1_000_000/speed)} ms per iter)')
