import elbus
import time
from argparse import ArgumentParser

ap = ArgumentParser()
ap.add_argument('NAME')
ap.add_argument('TARGET')
ap.add_argument('MESSAGE')

a = ap.parse_args()

# def on_message(message):
# print(message.type, message.sender, message.topic, message.payload)

name = a.NAME
target = a.TARGET
bus = elbus.ElbusClient('/tmp/elbus.sock', name)
# bus.on_message = on_message
bus.connect()
payload = a.MESSAGE
if payload.startswith(":"):
    request_id = 1
    if ':' in payload[1:]:
        method, params = payload[1:].split(':', maxsplit=1)
    else:
        method = payload[1:]
        params = ''
    payload = b'\x01' + request_id.to_bytes(
        4, 'little') + method.encode() + b'\x00' + params.encode()
elif payload.startswith('.'):
    payload = b'\x00' + payload[1:].encode()
m = elbus.Message(payload)
if target.startswith('='):
    target = target[1:]
    m.type = elbus.OP_PUBLISH
elif '*' in target or '?' in target:
    m.type = elbus.OP_BROADCAST
print(hex(bus.send_message(target, m).wait_completed()))
bus.disconnect()
