use crate::{EgaColor, EgaPalette};

#[test]
fn test_rgba() {
    for index in 0..64 {
        let ega = EgaColor::new(index);
        match index {
            0 => assert_eq!(ega.rgba, [0x00, 0x00, 0x00, 0xff]),
            1 => assert_eq!(ega.rgba, [0x00, 0x00, 0xaa, 0xff]),
            2 => assert_eq!(ega.rgba, [0x00, 0xaa, 0x00, 0xff]),
            3 => assert_eq!(ega.rgba, [0x00, 0xaa, 0xaa, 0xff]),
            4 => assert_eq!(ega.rgba, [0xaa, 0x00, 0x00, 0xff]),
            5 => assert_eq!(ega.rgba, [0xaa, 0x00, 0xaa, 0xff]),
            6 => assert_eq!(ega.rgba, [0xaa, 0xaa, 0x00, 0xff]),
            7 => assert_eq!(ega.rgba, [0xaa, 0xaa, 0xaa, 0xff]),
            8 => assert_eq!(ega.rgba, [0x00, 0x00, 0x55, 0xff]),
            9 => assert_eq!(ega.rgba, [0x00, 0x00, 0xff, 0xff]),
            10 => assert_eq!(ega.rgba, [0x00, 0xaa, 0x55, 0xff]),
            11 => assert_eq!(ega.rgba, [0x00, 0xaa, 0xff, 0xff]),
            12 => assert_eq!(ega.rgba, [0xaa, 0x00, 0x55, 0xff]),
            13 => assert_eq!(ega.rgba, [0xaa, 0x00, 0xff, 0xff]),
            14 => assert_eq!(ega.rgba, [0xaa, 0xaa, 0x55, 0xff]),
            15 => assert_eq!(ega.rgba, [0xaa, 0xaa, 0xff, 0xff]),
            16 => assert_eq!(ega.rgba, [0x00, 0x55, 0x00, 0xff]),
            17 => assert_eq!(ega.rgba, [0x00, 0x55, 0xaa, 0xff]),
            18 => assert_eq!(ega.rgba, [0x00, 0xff, 0x00, 0xff]),
            19 => assert_eq!(ega.rgba, [0x00, 0xff, 0xaa, 0xff]),
            20 => assert_eq!(ega.rgba, [0xaa, 0x55, 0x00, 0xff]),
            21 => assert_eq!(ega.rgba, [0xaa, 0x55, 0xaa, 0xff]),
            22 => assert_eq!(ega.rgba, [0xaa, 0xff, 0x00, 0xff]),
            23 => assert_eq!(ega.rgba, [0xaa, 0xff, 0xaa, 0xff]),
            24 => assert_eq!(ega.rgba, [0x00, 0x55, 0x55, 0xff]),
            25 => assert_eq!(ega.rgba, [0x00, 0x55, 0xff, 0xff]),
            26 => assert_eq!(ega.rgba, [0x00, 0xff, 0x55, 0xff]),
            27 => assert_eq!(ega.rgba, [0x00, 0xff, 0xff, 0xff]),
            28 => assert_eq!(ega.rgba, [0xaa, 0x55, 0x55, 0xff]),
            29 => assert_eq!(ega.rgba, [0xaa, 0x55, 0xff, 0xff]),
            30 => assert_eq!(ega.rgba, [0xaa, 0xff, 0x55, 0xff]),
            31 => assert_eq!(ega.rgba, [0xaa, 0xff, 0xff, 0xff]),
            32 => assert_eq!(ega.rgba, [0x55, 0x00, 0x00, 0xff]),
            33 => assert_eq!(ega.rgba, [0x55, 0x00, 0xaa, 0xff]),
            34 => assert_eq!(ega.rgba, [0x55, 0xaa, 0x00, 0xff]),
            35 => assert_eq!(ega.rgba, [0x55, 0xaa, 0xaa, 0xff]),
            36 => assert_eq!(ega.rgba, [0xff, 0x00, 0x00, 0xff]),
            37 => assert_eq!(ega.rgba, [0xff, 0x00, 0xaa, 0xff]),
            38 => assert_eq!(ega.rgba, [0xff, 0xaa, 0x00, 0xff]),
            39 => assert_eq!(ega.rgba, [0xff, 0xaa, 0xaa, 0xff]),
            40 => assert_eq!(ega.rgba, [0x55, 0x00, 0x55, 0xff]),
            41 => assert_eq!(ega.rgba, [0x55, 0x00, 0xff, 0xff]),
            42 => assert_eq!(ega.rgba, [0x55, 0xaa, 0x55, 0xff]),
            43 => assert_eq!(ega.rgba, [0x55, 0xaa, 0xff, 0xff]),
            44 => assert_eq!(ega.rgba, [0xff, 0x00, 0x55, 0xff]),
            45 => assert_eq!(ega.rgba, [0xff, 0x00, 0xff, 0xff]),
            46 => assert_eq!(ega.rgba, [0xff, 0xaa, 0x55, 0xff]),
            47 => assert_eq!(ega.rgba, [0xff, 0xaa, 0xff, 0xff]),
            48 => assert_eq!(ega.rgba, [0x55, 0x55, 0x00, 0xff]),
            49 => assert_eq!(ega.rgba, [0x55, 0x55, 0xaa, 0xff]),
            50 => assert_eq!(ega.rgba, [0x55, 0xff, 0x00, 0xff]),
            51 => assert_eq!(ega.rgba, [0x55, 0xff, 0xaa, 0xff]),
            52 => assert_eq!(ega.rgba, [0xff, 0x55, 0x00, 0xff]),
            53 => assert_eq!(ega.rgba, [0xff, 0x55, 0xaa, 0xff]),
            54 => assert_eq!(ega.rgba, [0xff, 0xff, 0x00, 0xff]),
            55 => assert_eq!(ega.rgba, [0xff, 0xff, 0xaa, 0xff]),
            56 => assert_eq!(ega.rgba, [0x55, 0x55, 0x55, 0xff]),
            57 => assert_eq!(ega.rgba, [0x55, 0x55, 0xff, 0xff]),
            58 => assert_eq!(ega.rgba, [0x55, 0xff, 0x55, 0xff]),
            59 => assert_eq!(ega.rgba, [0x55, 0xff, 0xff, 0xff]),
            60 => assert_eq!(ega.rgba, [0xff, 0x55, 0x55, 0xff]),
            61 => assert_eq!(ega.rgba, [0xff, 0x55, 0xff, 0xff]),
            62 => assert_eq!(ega.rgba, [0xff, 0xff, 0x55, 0xff]),
            63 => assert_eq!(ega.rgba, [0xff, 0xff, 0xff, 0xff]),
            _ => unreachable!(),
        }
    }
}

#[test]
fn test_rgb() {
    for index in 0..64 {
        let ega = EgaColor::new(index);
        match index {
            0 => assert_eq!(ega.rgb, [0x00, 0x00, 0x00]),
            1 => assert_eq!(ega.rgb, [0x00, 0x00, 0xaa]),
            2 => assert_eq!(ega.rgb, [0x00, 0xaa, 0x00]),
            3 => assert_eq!(ega.rgb, [0x00, 0xaa, 0xaa]),
            4 => assert_eq!(ega.rgb, [0xaa, 0x00, 0x00]),
            5 => assert_eq!(ega.rgb, [0xaa, 0x00, 0xaa]),
            6 => assert_eq!(ega.rgb, [0xaa, 0xaa, 0x00]),
            7 => assert_eq!(ega.rgb, [0xaa, 0xaa, 0xaa]),
            8 => assert_eq!(ega.rgb, [0x00, 0x00, 0x55]),
            9 => assert_eq!(ega.rgb, [0x00, 0x00, 0xff]),
            10 => assert_eq!(ega.rgb, [0x00, 0xaa, 0x55]),
            11 => assert_eq!(ega.rgb, [0x00, 0xaa, 0xff]),
            12 => assert_eq!(ega.rgb, [0xaa, 0x00, 0x55]),
            13 => assert_eq!(ega.rgb, [0xaa, 0x00, 0xff]),
            14 => assert_eq!(ega.rgb, [0xaa, 0xaa, 0x55]),
            15 => assert_eq!(ega.rgb, [0xaa, 0xaa, 0xff]),
            16 => assert_eq!(ega.rgb, [0x00, 0x55, 0x00]),
            17 => assert_eq!(ega.rgb, [0x00, 0x55, 0xaa]),
            18 => assert_eq!(ega.rgb, [0x00, 0xff, 0x00]),
            19 => assert_eq!(ega.rgb, [0x00, 0xff, 0xaa]),
            20 => assert_eq!(ega.rgb, [0xaa, 0x55, 0x00]),
            21 => assert_eq!(ega.rgb, [0xaa, 0x55, 0xaa]),
            22 => assert_eq!(ega.rgb, [0xaa, 0xff, 0x00]),
            23 => assert_eq!(ega.rgb, [0xaa, 0xff, 0xaa]),
            24 => assert_eq!(ega.rgb, [0x00, 0x55, 0x55]),
            25 => assert_eq!(ega.rgb, [0x00, 0x55, 0xff]),
            26 => assert_eq!(ega.rgb, [0x00, 0xff, 0x55]),
            27 => assert_eq!(ega.rgb, [0x00, 0xff, 0xff]),
            28 => assert_eq!(ega.rgb, [0xaa, 0x55, 0x55]),
            29 => assert_eq!(ega.rgb, [0xaa, 0x55, 0xff]),
            30 => assert_eq!(ega.rgb, [0xaa, 0xff, 0x55]),
            31 => assert_eq!(ega.rgb, [0xaa, 0xff, 0xff]),
            32 => assert_eq!(ega.rgb, [0x55, 0x00, 0x00]),
            33 => assert_eq!(ega.rgb, [0x55, 0x00, 0xaa]),
            34 => assert_eq!(ega.rgb, [0x55, 0xaa, 0x00]),
            35 => assert_eq!(ega.rgb, [0x55, 0xaa, 0xaa]),
            36 => assert_eq!(ega.rgb, [0xff, 0x00, 0x00]),
            37 => assert_eq!(ega.rgb, [0xff, 0x00, 0xaa]),
            38 => assert_eq!(ega.rgb, [0xff, 0xaa, 0x00]),
            39 => assert_eq!(ega.rgb, [0xff, 0xaa, 0xaa]),
            40 => assert_eq!(ega.rgb, [0x55, 0x00, 0x55]),
            41 => assert_eq!(ega.rgb, [0x55, 0x00, 0xff]),
            42 => assert_eq!(ega.rgb, [0x55, 0xaa, 0x55]),
            43 => assert_eq!(ega.rgb, [0x55, 0xaa, 0xff]),
            44 => assert_eq!(ega.rgb, [0xff, 0x00, 0x55]),
            45 => assert_eq!(ega.rgb, [0xff, 0x00, 0xff]),
            46 => assert_eq!(ega.rgb, [0xff, 0xaa, 0x55]),
            47 => assert_eq!(ega.rgb, [0xff, 0xaa, 0xff]),
            48 => assert_eq!(ega.rgb, [0x55, 0x55, 0x00]),
            49 => assert_eq!(ega.rgb, [0x55, 0x55, 0xaa]),
            50 => assert_eq!(ega.rgb, [0x55, 0xff, 0x00]),
            51 => assert_eq!(ega.rgb, [0x55, 0xff, 0xaa]),
            52 => assert_eq!(ega.rgb, [0xff, 0x55, 0x00]),
            53 => assert_eq!(ega.rgb, [0xff, 0x55, 0xaa]),
            54 => assert_eq!(ega.rgb, [0xff, 0xff, 0x00]),
            55 => assert_eq!(ega.rgb, [0xff, 0xff, 0xaa]),
            56 => assert_eq!(ega.rgb, [0x55, 0x55, 0x55]),
            57 => assert_eq!(ega.rgb, [0x55, 0x55, 0xff]),
            58 => assert_eq!(ega.rgb, [0x55, 0xff, 0x55]),
            59 => assert_eq!(ega.rgb, [0x55, 0xff, 0xff]),
            60 => assert_eq!(ega.rgb, [0xff, 0x55, 0x55]),
            61 => assert_eq!(ega.rgb, [0xff, 0x55, 0xff]),
            62 => assert_eq!(ega.rgb, [0xff, 0xff, 0x55]),
            63 => assert_eq!(ega.rgb, [0xff, 0xff, 0xff]),
            _ => unreachable!(),
        }
    }
}

#[test]
fn palette() {
    let pal = EgaPalette::new(&[]);
    assert_eq!(pal.len(), 0);
    assert!(pal.is_empty());
    let pal = EgaPalette::new(&[1, 2, 3, 4]);
    assert_eq!(pal.len(), 4);
    assert!(!pal.is_empty());
}

#[test]
fn test_default_palette() {
    let pal = EgaPalette::default();
    assert!(!pal.is_empty());
    assert_eq!(pal.len(), 16);
    for index in 0..pal.len() {
        let col = &pal[index];
        match index {
            0 => {
                assert_eq!(col.rgb, [0x00, 0x00, 0x00]);
                assert_eq!(col.rgba, [0x00, 0x00, 0x00, 0xff]);
            }
            1 => {
                assert_eq!(col.rgb, [0x00, 0x00, 0xaa]);
                assert_eq!(col.rgba, [0x00, 0x00, 0xaa, 0xff]);
            }
            2 => {
                assert_eq!(col.rgb, [0x00, 0xaa, 0x00]);
                assert_eq!(col.rgba, [0x00, 0xaa, 0x00, 0xff]);
            }
            3 => {
                assert_eq!(col.rgb, [0x00, 0xaa, 0xaa]);
                assert_eq!(col.rgba, [0x00, 0xaa, 0xaa, 0xff]);
            }
            4 => {
                assert_eq!(col.rgb, [0xaa, 0x00, 0x00]);
                assert_eq!(col.rgba, [0xaa, 0x00, 0x00, 0xff]);
            }
            5 => {
                assert_eq!(col.rgb, [0xaa, 0x00, 0xaa]);
                assert_eq!(col.rgba, [0xaa, 0x00, 0xaa, 0xff]);
            }
            6 => {
                assert_eq!(col.rgb, [0xaa, 0x55, 0x00]);
                assert_eq!(col.rgba, [0xaa, 0x55, 0x00, 0xff]);
            }
            7 => {
                assert_eq!(col.rgb, [0xaa, 0xaa, 0xaa]);
                assert_eq!(col.rgba, [0xaa, 0xaa, 0xaa, 0xff]);
            }
            8 => {
                assert_eq!(col.rgb, [0x55, 0x55, 0x55]);
                assert_eq!(col.rgba, [0x55, 0x55, 0x55, 0xff]);
            }
            9 => {
                assert_eq!(col.rgb, [0x55, 0x55, 0xff]);
                assert_eq!(col.rgba, [0x55, 0x55, 0xff, 0xff]);
            }
            10 => {
                assert_eq!(col.rgb, [0x55, 0xff, 0x55]);
                assert_eq!(col.rgba, [0x55, 0xff, 0x55, 0xff]);
            }
            11 => {
                assert_eq!(col.rgb, [0x55, 0xff, 0xff]);
                assert_eq!(col.rgba, [0x55, 0xff, 0xff, 0xff]);
            }
            12 => {
                assert_eq!(col.rgb, [0xff, 0x55, 0x55]);
                assert_eq!(col.rgba, [0xff, 0x55, 0x55, 0xff]);
            }
            13 => {
                assert_eq!(col.rgb, [0xff, 0x55, 0xff]);
                assert_eq!(col.rgba, [0xff, 0x55, 0xff, 0xff]);
            }
            14 => {
                assert_eq!(col.rgb, [0xff, 0xff, 0x55]);
                assert_eq!(col.rgba, [0xff, 0xff, 0x55, 0xff]);
            }
            15 => {
                assert_eq!(col.rgb, [0xff, 0xff, 0xff]);
                assert_eq!(col.rgba, [0xff, 0xff, 0xff, 0xff]);
            }
            _ => unreachable!(),
        }
    }
}

#[test]
fn test_complete_palette() {
    let pal = EgaPalette::all();
    assert_eq!(pal.len(), 64);
    assert_eq!(pal[0].rgba, [0x00, 0x00, 0x00, 0xff]);
    assert_eq!(pal[1].rgba, [0x00, 0x00, 0xaa, 0xff]);
    assert_eq!(pal[2].rgba, [0x00, 0xaa, 0x00, 0xff]);
    assert_eq!(pal[3].rgba, [0x00, 0xaa, 0xaa, 0xff]);
    assert_eq!(pal[4].rgba, [0xaa, 0x00, 0x00, 0xff]);
    assert_eq!(pal[5].rgba, [0xaa, 0x00, 0xaa, 0xff]);
    assert_eq!(pal[6].rgba, [0xaa, 0xaa, 0x00, 0xff]);
    assert_eq!(pal[7].rgba, [0xaa, 0xaa, 0xaa, 0xff]);
    assert_eq!(pal[8].rgba, [0x00, 0x00, 0x55, 0xff]);
    assert_eq!(pal[9].rgba, [0x00, 0x00, 0xff, 0xff]);
    assert_eq!(pal[10].rgba, [0x00, 0xaa, 0x55, 0xff]);
    assert_eq!(pal[11].rgba, [0x00, 0xaa, 0xff, 0xff]);
    assert_eq!(pal[12].rgba, [0xaa, 0x00, 0x55, 0xff]);
    assert_eq!(pal[13].rgba, [0xaa, 0x00, 0xff, 0xff]);
    assert_eq!(pal[14].rgba, [0xaa, 0xaa, 0x55, 0xff]);
    assert_eq!(pal[15].rgba, [0xaa, 0xaa, 0xff, 0xff]);
    assert_eq!(pal[16].rgba, [0x00, 0x55, 0x00, 0xff]);
    assert_eq!(pal[17].rgba, [0x00, 0x55, 0xaa, 0xff]);
    assert_eq!(pal[18].rgba, [0x00, 0xff, 0x00, 0xff]);
    assert_eq!(pal[19].rgba, [0x00, 0xff, 0xaa, 0xff]);
    assert_eq!(pal[20].rgba, [0xaa, 0x55, 0x00, 0xff]);
    assert_eq!(pal[21].rgba, [0xaa, 0x55, 0xaa, 0xff]);
    assert_eq!(pal[22].rgba, [0xaa, 0xff, 0x00, 0xff]);
    assert_eq!(pal[23].rgba, [0xaa, 0xff, 0xaa, 0xff]);
    assert_eq!(pal[24].rgba, [0x00, 0x55, 0x55, 0xff]);
    assert_eq!(pal[25].rgba, [0x00, 0x55, 0xff, 0xff]);
    assert_eq!(pal[26].rgba, [0x00, 0xff, 0x55, 0xff]);
    assert_eq!(pal[27].rgba, [0x00, 0xff, 0xff, 0xff]);
    assert_eq!(pal[28].rgba, [0xaa, 0x55, 0x55, 0xff]);
    assert_eq!(pal[29].rgba, [0xaa, 0x55, 0xff, 0xff]);
    assert_eq!(pal[30].rgba, [0xaa, 0xff, 0x55, 0xff]);
    assert_eq!(pal[31].rgba, [0xaa, 0xff, 0xff, 0xff]);
    assert_eq!(pal[32].rgba, [0x55, 0x00, 0x00, 0xff]);
    assert_eq!(pal[33].rgba, [0x55, 0x00, 0xaa, 0xff]);
    assert_eq!(pal[34].rgba, [0x55, 0xaa, 0x00, 0xff]);
    assert_eq!(pal[35].rgba, [0x55, 0xaa, 0xaa, 0xff]);
    assert_eq!(pal[36].rgba, [0xff, 0x00, 0x00, 0xff]);
    assert_eq!(pal[37].rgba, [0xff, 0x00, 0xaa, 0xff]);
    assert_eq!(pal[38].rgba, [0xff, 0xaa, 0x00, 0xff]);
    assert_eq!(pal[39].rgba, [0xff, 0xaa, 0xaa, 0xff]);
    assert_eq!(pal[40].rgba, [0x55, 0x00, 0x55, 0xff]);
    assert_eq!(pal[41].rgba, [0x55, 0x00, 0xff, 0xff]);
    assert_eq!(pal[42].rgba, [0x55, 0xaa, 0x55, 0xff]);
    assert_eq!(pal[43].rgba, [0x55, 0xaa, 0xff, 0xff]);
    assert_eq!(pal[44].rgba, [0xff, 0x00, 0x55, 0xff]);
    assert_eq!(pal[45].rgba, [0xff, 0x00, 0xff, 0xff]);
    assert_eq!(pal[46].rgba, [0xff, 0xaa, 0x55, 0xff]);
    assert_eq!(pal[47].rgba, [0xff, 0xaa, 0xff, 0xff]);
    assert_eq!(pal[48].rgba, [0x55, 0x55, 0x00, 0xff]);
    assert_eq!(pal[49].rgba, [0x55, 0x55, 0xaa, 0xff]);
    assert_eq!(pal[50].rgba, [0x55, 0xff, 0x00, 0xff]);
    assert_eq!(pal[51].rgba, [0x55, 0xff, 0xaa, 0xff]);
    assert_eq!(pal[52].rgba, [0xff, 0x55, 0x00, 0xff]);
    assert_eq!(pal[53].rgba, [0xff, 0x55, 0xaa, 0xff]);
    assert_eq!(pal[54].rgba, [0xff, 0xff, 0x00, 0xff]);
    assert_eq!(pal[55].rgba, [0xff, 0xff, 0xaa, 0xff]);
    assert_eq!(pal[56].rgba, [0x55, 0x55, 0x55, 0xff]);
    assert_eq!(pal[57].rgba, [0x55, 0x55, 0xff, 0xff]);
    assert_eq!(pal[58].rgba, [0x55, 0xff, 0x55, 0xff]);
    assert_eq!(pal[59].rgba, [0x55, 0xff, 0xff, 0xff]);
    assert_eq!(pal[60].rgba, [0xff, 0x55, 0x55, 0xff]);
    assert_eq!(pal[61].rgba, [0xff, 0x55, 0xff, 0xff]);
    assert_eq!(pal[62].rgba, [0xff, 0xff, 0x55, 0xff]);
    assert_eq!(pal[63].rgba, [0xff, 0xff, 0xff, 0xff]);
    assert_eq!(pal[0].rgb, [0x00, 0x00, 0x00]);
    assert_eq!(pal[1].rgb, [0x00, 0x00, 0xaa]);
    assert_eq!(pal[2].rgb, [0x00, 0xaa, 0x00]);
    assert_eq!(pal[3].rgb, [0x00, 0xaa, 0xaa]);
    assert_eq!(pal[4].rgb, [0xaa, 0x00, 0x00]);
    assert_eq!(pal[5].rgb, [0xaa, 0x00, 0xaa]);
    assert_eq!(pal[6].rgb, [0xaa, 0xaa, 0x00]);
    assert_eq!(pal[7].rgb, [0xaa, 0xaa, 0xaa]);
    assert_eq!(pal[8].rgb, [0x00, 0x00, 0x55]);
    assert_eq!(pal[9].rgb, [0x00, 0x00, 0xff]);
    assert_eq!(pal[10].rgb, [0x00, 0xaa, 0x55]);
    assert_eq!(pal[11].rgb, [0x00, 0xaa, 0xff]);
    assert_eq!(pal[12].rgb, [0xaa, 0x00, 0x55]);
    assert_eq!(pal[13].rgb, [0xaa, 0x00, 0xff]);
    assert_eq!(pal[14].rgb, [0xaa, 0xaa, 0x55]);
    assert_eq!(pal[15].rgb, [0xaa, 0xaa, 0xff]);
    assert_eq!(pal[16].rgb, [0x00, 0x55, 0x00]);
    assert_eq!(pal[17].rgb, [0x00, 0x55, 0xaa]);
    assert_eq!(pal[18].rgb, [0x00, 0xff, 0x00]);
    assert_eq!(pal[19].rgb, [0x00, 0xff, 0xaa]);
    assert_eq!(pal[20].rgb, [0xaa, 0x55, 0x00]);
    assert_eq!(pal[21].rgb, [0xaa, 0x55, 0xaa]);
    assert_eq!(pal[22].rgb, [0xaa, 0xff, 0x00]);
    assert_eq!(pal[23].rgb, [0xaa, 0xff, 0xaa]);
    assert_eq!(pal[24].rgb, [0x00, 0x55, 0x55]);
    assert_eq!(pal[25].rgb, [0x00, 0x55, 0xff]);
    assert_eq!(pal[26].rgb, [0x00, 0xff, 0x55]);
    assert_eq!(pal[27].rgb, [0x00, 0xff, 0xff]);
    assert_eq!(pal[28].rgb, [0xaa, 0x55, 0x55]);
    assert_eq!(pal[29].rgb, [0xaa, 0x55, 0xff]);
    assert_eq!(pal[30].rgb, [0xaa, 0xff, 0x55]);
    assert_eq!(pal[31].rgb, [0xaa, 0xff, 0xff]);
    assert_eq!(pal[32].rgb, [0x55, 0x00, 0x00]);
    assert_eq!(pal[33].rgb, [0x55, 0x00, 0xaa]);
    assert_eq!(pal[34].rgb, [0x55, 0xaa, 0x00]);
    assert_eq!(pal[35].rgb, [0x55, 0xaa, 0xaa]);
    assert_eq!(pal[36].rgb, [0xff, 0x00, 0x00]);
    assert_eq!(pal[37].rgb, [0xff, 0x00, 0xaa]);
    assert_eq!(pal[38].rgb, [0xff, 0xaa, 0x00]);
    assert_eq!(pal[39].rgb, [0xff, 0xaa, 0xaa]);
    assert_eq!(pal[40].rgb, [0x55, 0x00, 0x55]);
    assert_eq!(pal[41].rgb, [0x55, 0x00, 0xff]);
    assert_eq!(pal[42].rgb, [0x55, 0xaa, 0x55]);
    assert_eq!(pal[43].rgb, [0x55, 0xaa, 0xff]);
    assert_eq!(pal[44].rgb, [0xff, 0x00, 0x55]);
    assert_eq!(pal[45].rgb, [0xff, 0x00, 0xff]);
    assert_eq!(pal[46].rgb, [0xff, 0xaa, 0x55]);
    assert_eq!(pal[47].rgb, [0xff, 0xaa, 0xff]);
    assert_eq!(pal[48].rgb, [0x55, 0x55, 0x00]);
    assert_eq!(pal[49].rgb, [0x55, 0x55, 0xaa]);
    assert_eq!(pal[50].rgb, [0x55, 0xff, 0x00]);
    assert_eq!(pal[51].rgb, [0x55, 0xff, 0xaa]);
    assert_eq!(pal[52].rgb, [0xff, 0x55, 0x00]);
    assert_eq!(pal[53].rgb, [0xff, 0x55, 0xaa]);
    assert_eq!(pal[54].rgb, [0xff, 0xff, 0x00]);
    assert_eq!(pal[55].rgb, [0xff, 0xff, 0xaa]);
    assert_eq!(pal[56].rgb, [0x55, 0x55, 0x55]);
    assert_eq!(pal[57].rgb, [0x55, 0x55, 0xff]);
    assert_eq!(pal[58].rgb, [0x55, 0xff, 0x55]);
    assert_eq!(pal[59].rgb, [0x55, 0xff, 0xff]);
    assert_eq!(pal[60].rgb, [0xff, 0x55, 0x55]);
    assert_eq!(pal[61].rgb, [0xff, 0x55, 0xff]);
    assert_eq!(pal[62].rgb, [0xff, 0xff, 0x55]);
    assert_eq!(pal[63].rgb, [0xff, 0xff, 0xff]);
}

#[test]
fn test_get() {
    let pal = EgaPalette::default();
    assert!(pal.get(0).is_some());
    assert!(pal.get(15).is_some());
    assert!(pal.get(16).is_none());
}
