#[repr(u8)]
#[derive(Debug)]
pub enum OsAbi {
    SystemV,
    HPUX,
    NetBSD,
    Linux,
    GNUHurd,
    Solaris,
    AIX,
    IRIX,
    FreeBSD,
    Tru64,
    NovellModesto,
    OpenBSD,
    OpenVMS,
    NonStopKernel,
    AROS,
    FenixOS,
    CloudABI,
    StratusTechnologiesOpenVOS,
    Other(u8),
}

impl From<u8> for OsAbi {
    fn from(value: u8) -> Self {
        use OsAbi::*;

        match value {
            0 => SystemV,
            1 => HPUX,
            2 => NetBSD,
            3 => Linux,
            4 => GNUHurd,
            6 => Solaris,
            7 => AIX,
            8 => IRIX,
            9 => FreeBSD,
            10 => Tru64,
            11 => NovellModesto,
            12 => OpenBSD,
            13 => OpenVMS,
            14 => NonStopKernel,
            15 => AROS,
            16 => FenixOS,
            17 => CloudABI,
            18 => StratusTechnologiesOpenVOS,
            _ => Other(value),
        }
    }
}
