#[derive(Debug)]
pub enum Data {
    LittleEndian,
    BigEndian,
    Other(u8),
}

impl From<u8> for Data {
    fn from(value: u8) -> Self {
        use Data::*;

        match value {
            1 => LittleEndian,
            2 => BigEndian,
            x => Other(x),
        }
    }
}
