Formatting Rules
================

General
-------

### Don't change the order of visible tokens

That is, `efmt` only removes or inserts whitespace characters.

TODO

### Max columns hint

TODO

### Comments are preserved as much as possible as before

TODO: About max columns and comments

### Emacs indentation friendly

TODO

### Accepts invalid Erlang expressions/patterns/types/etc if ...

### Don't accept broken codes

Lists/Tuples/Bitstrings
-----------------------

### Packed elements

Packed:
```erlang
[1, 2, 3, 4, 5,
 6, 7, 8, 9, 10]
```

Cannot be packed:
```erlang
[1,
 2,
 case Foo of
     Bar ->
         Baz
 end,
 3,
 4]
```


Body
----

### Newline before body

```erlang
foo() ->
    Body.
```


Forms
-----

### Records

Record fields are treated like a tuple.

```erlang
-record(name, {}).

-record(name, {foo, bar}).  % packed

-record(name,
        {field0 = value0 :: type0,
         ...
         fieldN = valueN :: typeN}).
```

### Macro defines

```erlang
-define(name, ).

-define(name, foo).

-define(name,
        begin
            io:format("hello"),
            world
        end).

-define(name(V0, V1), {V0, V1}).

-define(name(V0, V1),
        case V0 of
            foo ->
                V1
        end).
```

Note that if the replacement part of a macro is not a valid expression,
`efmt` outputs the original text as is. Otherwise, TODO

### Type declaration

```erlang
-type foo() :: bar.

%% If ...
-type foo(A, B) :: A |
                   B.

%% If ...
-opaque foo(A, B) ::
          A | B.

%% If ...
-type foo(A, B) ::
        A |
        B.
```

Note that type parameters are treated as the same rules with ...


### `-spec` | `-callback`

```erlang
-spec foo() -> bar.

-spec foo() -> bar;
         () -> baz.

%% If ...
-spec foo({atom(),
           integer(),
           list()}) -> bar;
         (term()) ->
          aaa | bbb | ccc.

-spec foo(...) ->
          bar  %% 4 spaces from the beginning of the function name.
              when A :: baz.  %% 8 spaces from the ...
```

### function declaration

```erlang
foo() ->
   bar. %% 4 spaces.

foo(A,
    B,
    C) ->
    bar.

foo(A) when is_atom(A) ->
    bar.

foo(A)
  when is_atom(A) or  % 2 spaces
       is_integer(A) ->
    bar.
```

Types
-----

### Lists

```erlang
[]
[atom()]
[atom(), ...]

%% If newlines are needed.
[atom(),
 ...]
```

### Tuples

The almost same rules as the tuple expression (TODO: link).

```erlang
{}

{foo, bar}

%% If newlines are needed (never packed).
{foo(),
 [atom()],
 bar:qux()}
```

### Maps

The same rules as the map expression (TODO: link).

### `module:type(args)`

The same rules as the function call expression (TODO: link).

### Records

```erlang
#foo{}

#foo{bar :: integer()}

#foo{bar :: b,
     baz :: 2}
```

### Bitstrings

TODO

### Functions


```erlang
fun ()

fun ((...) -> foo())

fun ((foo(), bar()) ->
             baz()).  % 8 spaces
```

### Binary op

### Union

### Annotated

Macros
------

```erlang
?FOO

?FOO(10,
     begin
         1,
         2,
         3
     end)

%% A valid macro (but cannot format the args)
?FOO(10 20 30, 30)
```
