#[doc = r" Value read from the register"]
pub struct R {
    bits: u32,
}
#[doc = r" Value to write to the register"]
pub struct W {
    bits: u32,
}
impl super::CAL {
    #[doc = r" Modifies the contents of the register"]
    #[inline]
    pub fn modify<F>(&self, f: F)
    where
        for<'w> F: FnOnce(&R, &'w mut W) -> &'w mut W,
    {
        let bits = self.register.get();
        let r = R { bits: bits };
        let mut w = W { bits: bits };
        f(&r, &mut w);
        self.register.set(w.bits);
    }
    #[doc = r" Reads the contents of the register"]
    #[inline]
    pub fn read(&self) -> R {
        R {
            bits: self.register.get(),
        }
    }
    #[doc = r" Writes to the register"]
    #[inline]
    pub fn write<F>(&self, f: F)
    where
        F: FnOnce(&mut W) -> &mut W,
    {
        let mut w = W::reset_value();
        f(&mut w);
        self.register.set(w.bits);
    }
    #[doc = r" Writes the reset value to the register"]
    #[inline]
    pub fn reset(&self) {
        self.write(|w| w)
    }
}
#[doc = r" Value of the field"]
pub struct SINGLEOFFSETR {
    bits: u8,
}
impl SINGLEOFFSETR {
    #[doc = r" Value of the field as raw bits"]
    #[inline]
    pub fn bits(&self) -> u8 {
        self.bits
    }
}
#[doc = r" Value of the field"]
pub struct SINGLEGAINR {
    bits: u8,
}
impl SINGLEGAINR {
    #[doc = r" Value of the field as raw bits"]
    #[inline]
    pub fn bits(&self) -> u8 {
        self.bits
    }
}
#[doc = r" Value of the field"]
pub struct SCANOFFSETR {
    bits: u8,
}
impl SCANOFFSETR {
    #[doc = r" Value of the field as raw bits"]
    #[inline]
    pub fn bits(&self) -> u8 {
        self.bits
    }
}
#[doc = r" Value of the field"]
pub struct SCANGAINR {
    bits: u8,
}
impl SCANGAINR {
    #[doc = r" Value of the field as raw bits"]
    #[inline]
    pub fn bits(&self) -> u8 {
        self.bits
    }
}
#[doc = r" Proxy"]
pub struct _SINGLEOFFSETW<'a> {
    w: &'a mut W,
}
impl<'a> _SINGLEOFFSETW<'a> {
    #[doc = r" Writes raw bits to the field"]
    #[inline]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        const MASK: u8 = 0x7f;
        const OFFSET: u8 = 0;
        self.w.bits &= !((MASK as u32) << OFFSET);
        self.w.bits |= ((value & MASK) as u32) << OFFSET;
        self.w
    }
}
#[doc = r" Proxy"]
pub struct _SINGLEGAINW<'a> {
    w: &'a mut W,
}
impl<'a> _SINGLEGAINW<'a> {
    #[doc = r" Writes raw bits to the field"]
    #[inline]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        const MASK: u8 = 0x7f;
        const OFFSET: u8 = 8;
        self.w.bits &= !((MASK as u32) << OFFSET);
        self.w.bits |= ((value & MASK) as u32) << OFFSET;
        self.w
    }
}
#[doc = r" Proxy"]
pub struct _SCANOFFSETW<'a> {
    w: &'a mut W,
}
impl<'a> _SCANOFFSETW<'a> {
    #[doc = r" Writes raw bits to the field"]
    #[inline]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        const MASK: u8 = 0x7f;
        const OFFSET: u8 = 16;
        self.w.bits &= !((MASK as u32) << OFFSET);
        self.w.bits |= ((value & MASK) as u32) << OFFSET;
        self.w
    }
}
#[doc = r" Proxy"]
pub struct _SCANGAINW<'a> {
    w: &'a mut W,
}
impl<'a> _SCANGAINW<'a> {
    #[doc = r" Writes raw bits to the field"]
    #[inline]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        const MASK: u8 = 0x7f;
        const OFFSET: u8 = 24;
        self.w.bits &= !((MASK as u32) << OFFSET);
        self.w.bits |= ((value & MASK) as u32) << OFFSET;
        self.w
    }
}
impl R {
    #[doc = r" Value of the register as raw bits"]
    #[inline]
    pub fn bits(&self) -> u32 {
        self.bits
    }
    #[doc = "Bits 0:6 - Single Mode Offset Calibration Value"]
    #[inline]
    pub fn singleoffset(&self) -> SINGLEOFFSETR {
        let bits = {
            const MASK: u8 = 0x7f;
            const OFFSET: u8 = 0;
            ((self.bits >> OFFSET) & MASK as u32) as u8
        };
        SINGLEOFFSETR { bits }
    }
    #[doc = "Bits 8:14 - Single Mode Gain Calibration Value"]
    #[inline]
    pub fn singlegain(&self) -> SINGLEGAINR {
        let bits = {
            const MASK: u8 = 0x7f;
            const OFFSET: u8 = 8;
            ((self.bits >> OFFSET) & MASK as u32) as u8
        };
        SINGLEGAINR { bits }
    }
    #[doc = "Bits 16:22 - Scan Mode Offset Calibration Value"]
    #[inline]
    pub fn scanoffset(&self) -> SCANOFFSETR {
        let bits = {
            const MASK: u8 = 0x7f;
            const OFFSET: u8 = 16;
            ((self.bits >> OFFSET) & MASK as u32) as u8
        };
        SCANOFFSETR { bits }
    }
    #[doc = "Bits 24:30 - Scan Mode Gain Calibration Value"]
    #[inline]
    pub fn scangain(&self) -> SCANGAINR {
        let bits = {
            const MASK: u8 = 0x7f;
            const OFFSET: u8 = 24;
            ((self.bits >> OFFSET) & MASK as u32) as u8
        };
        SCANGAINR { bits }
    }
}
impl W {
    #[doc = r" Reset value of the register"]
    #[inline]
    pub fn reset_value() -> W {
        W { bits: 0x3f00_3f00 }
    }
    #[doc = r" Writes raw bits to the register"]
    #[inline]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.bits = bits;
        self
    }
    #[doc = "Bits 0:6 - Single Mode Offset Calibration Value"]
    #[inline]
    pub fn singleoffset(&mut self) -> _SINGLEOFFSETW {
        _SINGLEOFFSETW { w: self }
    }
    #[doc = "Bits 8:14 - Single Mode Gain Calibration Value"]
    #[inline]
    pub fn singlegain(&mut self) -> _SINGLEGAINW {
        _SINGLEGAINW { w: self }
    }
    #[doc = "Bits 16:22 - Scan Mode Offset Calibration Value"]
    #[inline]
    pub fn scanoffset(&mut self) -> _SCANOFFSETW {
        _SCANOFFSETW { w: self }
    }
    #[doc = "Bits 24:30 - Scan Mode Gain Calibration Value"]
    #[inline]
    pub fn scangain(&mut self) -> _SCANGAINW {
        _SCANGAINW { w: self }
    }
}
