#[doc = "Reader of register PRSSEL"]
pub type R = crate::R<u32, super::PRSSEL>;
#[doc = "Writer for register PRSSEL"]
pub type W = crate::W<u32, super::PRSSEL>;
#[doc = "Register PRSSEL `reset()`'s with value 0"]
impl crate::ResetValue for super::PRSSEL {
    type Type = u32;
    #[inline(always)]
    fn reset_value() -> Self::Type { 0 }
}
#[doc = "PRS Start Select\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum PRSSTARTSEL_A {
    #[doc = "0: PRS Channel 0 selected as input"]
    PRSCH0 = 0,
    #[doc = "1: PRS Channel 1 selected as input"]
    PRSCH1 = 1,
    #[doc = "2: PRS Channel 2 selected as input"]
    PRSCH2 = 2,
    #[doc = "3: PRS Channel 3 selected as input"]
    PRSCH3 = 3,
    #[doc = "4: PRS Channel 4 selected as input"]
    PRSCH4 = 4,
    #[doc = "5: PRS Channel 5 selected as input"]
    PRSCH5 = 5,
    #[doc = "6: PRS Channel 6 selected as input"]
    PRSCH6 = 6,
    #[doc = "7: PRS Channel 7 selected as input"]
    PRSCH7 = 7,
    #[doc = "8: PRS Channel 8 selected as input"]
    PRSCH8 = 8,
    #[doc = "9: PRS Channel 9 selected as input"]
    PRSCH9 = 9,
    #[doc = "10: PRS Channel 10 selected as input"]
    PRSCH10 = 10,
    #[doc = "11: PRS Channel 11 selected as input"]
    PRSCH11 = 11,
    #[doc = "12: PRS Channel 12 selected as input"]
    PRSCH12 = 12,
    #[doc = "13: PRS Channel 13 selected as input"]
    PRSCH13 = 13,
    #[doc = "14: PRS Channel 14 selected as input"]
    PRSCH14 = 14,
    #[doc = "15: PRS Channel 15 selected as input"]
    PRSCH15 = 15,
    #[doc = "16: PRS Channel 16 selected as input"]
    PRSCH16 = 16,
    #[doc = "17: PRS Channel 17 selected as input"]
    PRSCH17 = 17,
    #[doc = "18: PRS Channel 18 selected as input"]
    PRSCH18 = 18,
    #[doc = "19: PRS Channel 19 selected as input"]
    PRSCH19 = 19,
    #[doc = "20: PRS Channel 20 selected as input"]
    PRSCH20 = 20,
    #[doc = "21: PRS Channel 21 selected as input"]
    PRSCH21 = 21,
    #[doc = "22: PRS Channel 22 selected as input"]
    PRSCH22 = 22,
    #[doc = "23: PRS Channel 23 selected as input"]
    PRSCH23 = 23,
}
impl From<PRSSTARTSEL_A> for u8 {
    #[inline(always)]
    fn from(variant: PRSSTARTSEL_A) -> Self { variant as _ }
}
#[doc = "Reader of field `PRSSTARTSEL`"]
pub type PRSSTARTSEL_R = crate::R<u8, PRSSTARTSEL_A>;
impl PRSSTARTSEL_R {
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> crate::Variant<u8, PRSSTARTSEL_A> {
        use crate::Variant::*;
        match self.bits {
            0 => Val(PRSSTARTSEL_A::PRSCH0),
            1 => Val(PRSSTARTSEL_A::PRSCH1),
            2 => Val(PRSSTARTSEL_A::PRSCH2),
            3 => Val(PRSSTARTSEL_A::PRSCH3),
            4 => Val(PRSSTARTSEL_A::PRSCH4),
            5 => Val(PRSSTARTSEL_A::PRSCH5),
            6 => Val(PRSSTARTSEL_A::PRSCH6),
            7 => Val(PRSSTARTSEL_A::PRSCH7),
            8 => Val(PRSSTARTSEL_A::PRSCH8),
            9 => Val(PRSSTARTSEL_A::PRSCH9),
            10 => Val(PRSSTARTSEL_A::PRSCH10),
            11 => Val(PRSSTARTSEL_A::PRSCH11),
            12 => Val(PRSSTARTSEL_A::PRSCH12),
            13 => Val(PRSSTARTSEL_A::PRSCH13),
            14 => Val(PRSSTARTSEL_A::PRSCH14),
            15 => Val(PRSSTARTSEL_A::PRSCH15),
            16 => Val(PRSSTARTSEL_A::PRSCH16),
            17 => Val(PRSSTARTSEL_A::PRSCH17),
            18 => Val(PRSSTARTSEL_A::PRSCH18),
            19 => Val(PRSSTARTSEL_A::PRSCH19),
            20 => Val(PRSSTARTSEL_A::PRSCH20),
            21 => Val(PRSSTARTSEL_A::PRSCH21),
            22 => Val(PRSSTARTSEL_A::PRSCH22),
            23 => Val(PRSSTARTSEL_A::PRSCH23),
            i => Res(i),
        }
    }
    #[doc = "Checks if the value of the field is `PRSCH0`"]
    #[inline(always)]
    pub fn is_prsch0(&self) -> bool { *self == PRSSTARTSEL_A::PRSCH0 }
    #[doc = "Checks if the value of the field is `PRSCH1`"]
    #[inline(always)]
    pub fn is_prsch1(&self) -> bool { *self == PRSSTARTSEL_A::PRSCH1 }
    #[doc = "Checks if the value of the field is `PRSCH2`"]
    #[inline(always)]
    pub fn is_prsch2(&self) -> bool { *self == PRSSTARTSEL_A::PRSCH2 }
    #[doc = "Checks if the value of the field is `PRSCH3`"]
    #[inline(always)]
    pub fn is_prsch3(&self) -> bool { *self == PRSSTARTSEL_A::PRSCH3 }
    #[doc = "Checks if the value of the field is `PRSCH4`"]
    #[inline(always)]
    pub fn is_prsch4(&self) -> bool { *self == PRSSTARTSEL_A::PRSCH4 }
    #[doc = "Checks if the value of the field is `PRSCH5`"]
    #[inline(always)]
    pub fn is_prsch5(&self) -> bool { *self == PRSSTARTSEL_A::PRSCH5 }
    #[doc = "Checks if the value of the field is `PRSCH6`"]
    #[inline(always)]
    pub fn is_prsch6(&self) -> bool { *self == PRSSTARTSEL_A::PRSCH6 }
    #[doc = "Checks if the value of the field is `PRSCH7`"]
    #[inline(always)]
    pub fn is_prsch7(&self) -> bool { *self == PRSSTARTSEL_A::PRSCH7 }
    #[doc = "Checks if the value of the field is `PRSCH8`"]
    #[inline(always)]
    pub fn is_prsch8(&self) -> bool { *self == PRSSTARTSEL_A::PRSCH8 }
    #[doc = "Checks if the value of the field is `PRSCH9`"]
    #[inline(always)]
    pub fn is_prsch9(&self) -> bool { *self == PRSSTARTSEL_A::PRSCH9 }
    #[doc = "Checks if the value of the field is `PRSCH10`"]
    #[inline(always)]
    pub fn is_prsch10(&self) -> bool { *self == PRSSTARTSEL_A::PRSCH10 }
    #[doc = "Checks if the value of the field is `PRSCH11`"]
    #[inline(always)]
    pub fn is_prsch11(&self) -> bool { *self == PRSSTARTSEL_A::PRSCH11 }
    #[doc = "Checks if the value of the field is `PRSCH12`"]
    #[inline(always)]
    pub fn is_prsch12(&self) -> bool { *self == PRSSTARTSEL_A::PRSCH12 }
    #[doc = "Checks if the value of the field is `PRSCH13`"]
    #[inline(always)]
    pub fn is_prsch13(&self) -> bool { *self == PRSSTARTSEL_A::PRSCH13 }
    #[doc = "Checks if the value of the field is `PRSCH14`"]
    #[inline(always)]
    pub fn is_prsch14(&self) -> bool { *self == PRSSTARTSEL_A::PRSCH14 }
    #[doc = "Checks if the value of the field is `PRSCH15`"]
    #[inline(always)]
    pub fn is_prsch15(&self) -> bool { *self == PRSSTARTSEL_A::PRSCH15 }
    #[doc = "Checks if the value of the field is `PRSCH16`"]
    #[inline(always)]
    pub fn is_prsch16(&self) -> bool { *self == PRSSTARTSEL_A::PRSCH16 }
    #[doc = "Checks if the value of the field is `PRSCH17`"]
    #[inline(always)]
    pub fn is_prsch17(&self) -> bool { *self == PRSSTARTSEL_A::PRSCH17 }
    #[doc = "Checks if the value of the field is `PRSCH18`"]
    #[inline(always)]
    pub fn is_prsch18(&self) -> bool { *self == PRSSTARTSEL_A::PRSCH18 }
    #[doc = "Checks if the value of the field is `PRSCH19`"]
    #[inline(always)]
    pub fn is_prsch19(&self) -> bool { *self == PRSSTARTSEL_A::PRSCH19 }
    #[doc = "Checks if the value of the field is `PRSCH20`"]
    #[inline(always)]
    pub fn is_prsch20(&self) -> bool { *self == PRSSTARTSEL_A::PRSCH20 }
    #[doc = "Checks if the value of the field is `PRSCH21`"]
    #[inline(always)]
    pub fn is_prsch21(&self) -> bool { *self == PRSSTARTSEL_A::PRSCH21 }
    #[doc = "Checks if the value of the field is `PRSCH22`"]
    #[inline(always)]
    pub fn is_prsch22(&self) -> bool { *self == PRSSTARTSEL_A::PRSCH22 }
    #[doc = "Checks if the value of the field is `PRSCH23`"]
    #[inline(always)]
    pub fn is_prsch23(&self) -> bool { *self == PRSSTARTSEL_A::PRSCH23 }
}
#[doc = "Write proxy for field `PRSSTARTSEL`"]
pub struct PRSSTARTSEL_W<'a> {
    w: &'a mut W,
}
impl<'a> PRSSTARTSEL_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: PRSSTARTSEL_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "PRS Channel 0 selected as input"]
    #[inline(always)]
    pub fn prsch0(self) -> &'a mut W { self.variant(PRSSTARTSEL_A::PRSCH0) }
    #[doc = "PRS Channel 1 selected as input"]
    #[inline(always)]
    pub fn prsch1(self) -> &'a mut W { self.variant(PRSSTARTSEL_A::PRSCH1) }
    #[doc = "PRS Channel 2 selected as input"]
    #[inline(always)]
    pub fn prsch2(self) -> &'a mut W { self.variant(PRSSTARTSEL_A::PRSCH2) }
    #[doc = "PRS Channel 3 selected as input"]
    #[inline(always)]
    pub fn prsch3(self) -> &'a mut W { self.variant(PRSSTARTSEL_A::PRSCH3) }
    #[doc = "PRS Channel 4 selected as input"]
    #[inline(always)]
    pub fn prsch4(self) -> &'a mut W { self.variant(PRSSTARTSEL_A::PRSCH4) }
    #[doc = "PRS Channel 5 selected as input"]
    #[inline(always)]
    pub fn prsch5(self) -> &'a mut W { self.variant(PRSSTARTSEL_A::PRSCH5) }
    #[doc = "PRS Channel 6 selected as input"]
    #[inline(always)]
    pub fn prsch6(self) -> &'a mut W { self.variant(PRSSTARTSEL_A::PRSCH6) }
    #[doc = "PRS Channel 7 selected as input"]
    #[inline(always)]
    pub fn prsch7(self) -> &'a mut W { self.variant(PRSSTARTSEL_A::PRSCH7) }
    #[doc = "PRS Channel 8 selected as input"]
    #[inline(always)]
    pub fn prsch8(self) -> &'a mut W { self.variant(PRSSTARTSEL_A::PRSCH8) }
    #[doc = "PRS Channel 9 selected as input"]
    #[inline(always)]
    pub fn prsch9(self) -> &'a mut W { self.variant(PRSSTARTSEL_A::PRSCH9) }
    #[doc = "PRS Channel 10 selected as input"]
    #[inline(always)]
    pub fn prsch10(self) -> &'a mut W { self.variant(PRSSTARTSEL_A::PRSCH10) }
    #[doc = "PRS Channel 11 selected as input"]
    #[inline(always)]
    pub fn prsch11(self) -> &'a mut W { self.variant(PRSSTARTSEL_A::PRSCH11) }
    #[doc = "PRS Channel 12 selected as input"]
    #[inline(always)]
    pub fn prsch12(self) -> &'a mut W { self.variant(PRSSTARTSEL_A::PRSCH12) }
    #[doc = "PRS Channel 13 selected as input"]
    #[inline(always)]
    pub fn prsch13(self) -> &'a mut W { self.variant(PRSSTARTSEL_A::PRSCH13) }
    #[doc = "PRS Channel 14 selected as input"]
    #[inline(always)]
    pub fn prsch14(self) -> &'a mut W { self.variant(PRSSTARTSEL_A::PRSCH14) }
    #[doc = "PRS Channel 15 selected as input"]
    #[inline(always)]
    pub fn prsch15(self) -> &'a mut W { self.variant(PRSSTARTSEL_A::PRSCH15) }
    #[doc = "PRS Channel 16 selected as input"]
    #[inline(always)]
    pub fn prsch16(self) -> &'a mut W { self.variant(PRSSTARTSEL_A::PRSCH16) }
    #[doc = "PRS Channel 17 selected as input"]
    #[inline(always)]
    pub fn prsch17(self) -> &'a mut W { self.variant(PRSSTARTSEL_A::PRSCH17) }
    #[doc = "PRS Channel 18 selected as input"]
    #[inline(always)]
    pub fn prsch18(self) -> &'a mut W { self.variant(PRSSTARTSEL_A::PRSCH18) }
    #[doc = "PRS Channel 19 selected as input"]
    #[inline(always)]
    pub fn prsch19(self) -> &'a mut W { self.variant(PRSSTARTSEL_A::PRSCH19) }
    #[doc = "PRS Channel 20 selected as input"]
    #[inline(always)]
    pub fn prsch20(self) -> &'a mut W { self.variant(PRSSTARTSEL_A::PRSCH20) }
    #[doc = "PRS Channel 21 selected as input"]
    #[inline(always)]
    pub fn prsch21(self) -> &'a mut W { self.variant(PRSSTARTSEL_A::PRSCH21) }
    #[doc = "PRS Channel 22 selected as input"]
    #[inline(always)]
    pub fn prsch22(self) -> &'a mut W { self.variant(PRSSTARTSEL_A::PRSCH22) }
    #[doc = "PRS Channel 23 selected as input"]
    #[inline(always)]
    pub fn prsch23(self) -> &'a mut W { self.variant(PRSSTARTSEL_A::PRSCH23) }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x1f) | ((value as u32) & 0x1f);
        self.w
    }
}
#[doc = "PRS Stop Select\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum PRSSTOPSEL_A {
    #[doc = "0: PRS Channel 0 selected as input"]
    PRSCH0 = 0,
    #[doc = "1: PRS Channel 1 selected as input"]
    PRSCH1 = 1,
    #[doc = "2: PRS Channel 2 selected as input"]
    PRSCH2 = 2,
    #[doc = "3: PRS Channel 3 selected as input"]
    PRSCH3 = 3,
    #[doc = "4: PRS Channel 4 selected as input"]
    PRSCH4 = 4,
    #[doc = "5: PRS Channel 5 selected as input"]
    PRSCH5 = 5,
    #[doc = "6: PRS Channel 6 selected as input"]
    PRSCH6 = 6,
    #[doc = "7: PRS Channel 7 selected as input"]
    PRSCH7 = 7,
    #[doc = "8: PRS Channel 8 selected as input"]
    PRSCH8 = 8,
    #[doc = "9: PRS Channel 9 selected as input"]
    PRSCH9 = 9,
    #[doc = "10: PRS Channel 10 selected as input"]
    PRSCH10 = 10,
    #[doc = "11: PRS Channel 11 selected as input"]
    PRSCH11 = 11,
    #[doc = "12: PRS Channel 12 selected as input"]
    PRSCH12 = 12,
    #[doc = "13: PRS Channel 13 selected as input"]
    PRSCH13 = 13,
    #[doc = "14: PRS Channel 14 selected as input"]
    PRSCH14 = 14,
    #[doc = "15: PRS Channel 15 selected as input"]
    PRSCH15 = 15,
    #[doc = "16: PRS Channel 16 selected as input"]
    PRSCH16 = 16,
    #[doc = "17: PRS Channel 17 selected as input"]
    PRSCH17 = 17,
    #[doc = "18: PRS Channel 18 selected as input"]
    PRSCH18 = 18,
    #[doc = "19: PRS Channel 19 selected as input"]
    PRSCH19 = 19,
    #[doc = "20: PRS Channel 20 selected as input"]
    PRSCH20 = 20,
    #[doc = "21: PRS Channel 21 selected as input"]
    PRSCH21 = 21,
    #[doc = "22: PRS Channel 22 selected as input"]
    PRSCH22 = 22,
    #[doc = "23: PRS Channel 23 selected as input"]
    PRSCH23 = 23,
}
impl From<PRSSTOPSEL_A> for u8 {
    #[inline(always)]
    fn from(variant: PRSSTOPSEL_A) -> Self { variant as _ }
}
#[doc = "Reader of field `PRSSTOPSEL`"]
pub type PRSSTOPSEL_R = crate::R<u8, PRSSTOPSEL_A>;
impl PRSSTOPSEL_R {
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> crate::Variant<u8, PRSSTOPSEL_A> {
        use crate::Variant::*;
        match self.bits {
            0 => Val(PRSSTOPSEL_A::PRSCH0),
            1 => Val(PRSSTOPSEL_A::PRSCH1),
            2 => Val(PRSSTOPSEL_A::PRSCH2),
            3 => Val(PRSSTOPSEL_A::PRSCH3),
            4 => Val(PRSSTOPSEL_A::PRSCH4),
            5 => Val(PRSSTOPSEL_A::PRSCH5),
            6 => Val(PRSSTOPSEL_A::PRSCH6),
            7 => Val(PRSSTOPSEL_A::PRSCH7),
            8 => Val(PRSSTOPSEL_A::PRSCH8),
            9 => Val(PRSSTOPSEL_A::PRSCH9),
            10 => Val(PRSSTOPSEL_A::PRSCH10),
            11 => Val(PRSSTOPSEL_A::PRSCH11),
            12 => Val(PRSSTOPSEL_A::PRSCH12),
            13 => Val(PRSSTOPSEL_A::PRSCH13),
            14 => Val(PRSSTOPSEL_A::PRSCH14),
            15 => Val(PRSSTOPSEL_A::PRSCH15),
            16 => Val(PRSSTOPSEL_A::PRSCH16),
            17 => Val(PRSSTOPSEL_A::PRSCH17),
            18 => Val(PRSSTOPSEL_A::PRSCH18),
            19 => Val(PRSSTOPSEL_A::PRSCH19),
            20 => Val(PRSSTOPSEL_A::PRSCH20),
            21 => Val(PRSSTOPSEL_A::PRSCH21),
            22 => Val(PRSSTOPSEL_A::PRSCH22),
            23 => Val(PRSSTOPSEL_A::PRSCH23),
            i => Res(i),
        }
    }
    #[doc = "Checks if the value of the field is `PRSCH0`"]
    #[inline(always)]
    pub fn is_prsch0(&self) -> bool { *self == PRSSTOPSEL_A::PRSCH0 }
    #[doc = "Checks if the value of the field is `PRSCH1`"]
    #[inline(always)]
    pub fn is_prsch1(&self) -> bool { *self == PRSSTOPSEL_A::PRSCH1 }
    #[doc = "Checks if the value of the field is `PRSCH2`"]
    #[inline(always)]
    pub fn is_prsch2(&self) -> bool { *self == PRSSTOPSEL_A::PRSCH2 }
    #[doc = "Checks if the value of the field is `PRSCH3`"]
    #[inline(always)]
    pub fn is_prsch3(&self) -> bool { *self == PRSSTOPSEL_A::PRSCH3 }
    #[doc = "Checks if the value of the field is `PRSCH4`"]
    #[inline(always)]
    pub fn is_prsch4(&self) -> bool { *self == PRSSTOPSEL_A::PRSCH4 }
    #[doc = "Checks if the value of the field is `PRSCH5`"]
    #[inline(always)]
    pub fn is_prsch5(&self) -> bool { *self == PRSSTOPSEL_A::PRSCH5 }
    #[doc = "Checks if the value of the field is `PRSCH6`"]
    #[inline(always)]
    pub fn is_prsch6(&self) -> bool { *self == PRSSTOPSEL_A::PRSCH6 }
    #[doc = "Checks if the value of the field is `PRSCH7`"]
    #[inline(always)]
    pub fn is_prsch7(&self) -> bool { *self == PRSSTOPSEL_A::PRSCH7 }
    #[doc = "Checks if the value of the field is `PRSCH8`"]
    #[inline(always)]
    pub fn is_prsch8(&self) -> bool { *self == PRSSTOPSEL_A::PRSCH8 }
    #[doc = "Checks if the value of the field is `PRSCH9`"]
    #[inline(always)]
    pub fn is_prsch9(&self) -> bool { *self == PRSSTOPSEL_A::PRSCH9 }
    #[doc = "Checks if the value of the field is `PRSCH10`"]
    #[inline(always)]
    pub fn is_prsch10(&self) -> bool { *self == PRSSTOPSEL_A::PRSCH10 }
    #[doc = "Checks if the value of the field is `PRSCH11`"]
    #[inline(always)]
    pub fn is_prsch11(&self) -> bool { *self == PRSSTOPSEL_A::PRSCH11 }
    #[doc = "Checks if the value of the field is `PRSCH12`"]
    #[inline(always)]
    pub fn is_prsch12(&self) -> bool { *self == PRSSTOPSEL_A::PRSCH12 }
    #[doc = "Checks if the value of the field is `PRSCH13`"]
    #[inline(always)]
    pub fn is_prsch13(&self) -> bool { *self == PRSSTOPSEL_A::PRSCH13 }
    #[doc = "Checks if the value of the field is `PRSCH14`"]
    #[inline(always)]
    pub fn is_prsch14(&self) -> bool { *self == PRSSTOPSEL_A::PRSCH14 }
    #[doc = "Checks if the value of the field is `PRSCH15`"]
    #[inline(always)]
    pub fn is_prsch15(&self) -> bool { *self == PRSSTOPSEL_A::PRSCH15 }
    #[doc = "Checks if the value of the field is `PRSCH16`"]
    #[inline(always)]
    pub fn is_prsch16(&self) -> bool { *self == PRSSTOPSEL_A::PRSCH16 }
    #[doc = "Checks if the value of the field is `PRSCH17`"]
    #[inline(always)]
    pub fn is_prsch17(&self) -> bool { *self == PRSSTOPSEL_A::PRSCH17 }
    #[doc = "Checks if the value of the field is `PRSCH18`"]
    #[inline(always)]
    pub fn is_prsch18(&self) -> bool { *self == PRSSTOPSEL_A::PRSCH18 }
    #[doc = "Checks if the value of the field is `PRSCH19`"]
    #[inline(always)]
    pub fn is_prsch19(&self) -> bool { *self == PRSSTOPSEL_A::PRSCH19 }
    #[doc = "Checks if the value of the field is `PRSCH20`"]
    #[inline(always)]
    pub fn is_prsch20(&self) -> bool { *self == PRSSTOPSEL_A::PRSCH20 }
    #[doc = "Checks if the value of the field is `PRSCH21`"]
    #[inline(always)]
    pub fn is_prsch21(&self) -> bool { *self == PRSSTOPSEL_A::PRSCH21 }
    #[doc = "Checks if the value of the field is `PRSCH22`"]
    #[inline(always)]
    pub fn is_prsch22(&self) -> bool { *self == PRSSTOPSEL_A::PRSCH22 }
    #[doc = "Checks if the value of the field is `PRSCH23`"]
    #[inline(always)]
    pub fn is_prsch23(&self) -> bool { *self == PRSSTOPSEL_A::PRSCH23 }
}
#[doc = "Write proxy for field `PRSSTOPSEL`"]
pub struct PRSSTOPSEL_W<'a> {
    w: &'a mut W,
}
impl<'a> PRSSTOPSEL_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: PRSSTOPSEL_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "PRS Channel 0 selected as input"]
    #[inline(always)]
    pub fn prsch0(self) -> &'a mut W { self.variant(PRSSTOPSEL_A::PRSCH0) }
    #[doc = "PRS Channel 1 selected as input"]
    #[inline(always)]
    pub fn prsch1(self) -> &'a mut W { self.variant(PRSSTOPSEL_A::PRSCH1) }
    #[doc = "PRS Channel 2 selected as input"]
    #[inline(always)]
    pub fn prsch2(self) -> &'a mut W { self.variant(PRSSTOPSEL_A::PRSCH2) }
    #[doc = "PRS Channel 3 selected as input"]
    #[inline(always)]
    pub fn prsch3(self) -> &'a mut W { self.variant(PRSSTOPSEL_A::PRSCH3) }
    #[doc = "PRS Channel 4 selected as input"]
    #[inline(always)]
    pub fn prsch4(self) -> &'a mut W { self.variant(PRSSTOPSEL_A::PRSCH4) }
    #[doc = "PRS Channel 5 selected as input"]
    #[inline(always)]
    pub fn prsch5(self) -> &'a mut W { self.variant(PRSSTOPSEL_A::PRSCH5) }
    #[doc = "PRS Channel 6 selected as input"]
    #[inline(always)]
    pub fn prsch6(self) -> &'a mut W { self.variant(PRSSTOPSEL_A::PRSCH6) }
    #[doc = "PRS Channel 7 selected as input"]
    #[inline(always)]
    pub fn prsch7(self) -> &'a mut W { self.variant(PRSSTOPSEL_A::PRSCH7) }
    #[doc = "PRS Channel 8 selected as input"]
    #[inline(always)]
    pub fn prsch8(self) -> &'a mut W { self.variant(PRSSTOPSEL_A::PRSCH8) }
    #[doc = "PRS Channel 9 selected as input"]
    #[inline(always)]
    pub fn prsch9(self) -> &'a mut W { self.variant(PRSSTOPSEL_A::PRSCH9) }
    #[doc = "PRS Channel 10 selected as input"]
    #[inline(always)]
    pub fn prsch10(self) -> &'a mut W { self.variant(PRSSTOPSEL_A::PRSCH10) }
    #[doc = "PRS Channel 11 selected as input"]
    #[inline(always)]
    pub fn prsch11(self) -> &'a mut W { self.variant(PRSSTOPSEL_A::PRSCH11) }
    #[doc = "PRS Channel 12 selected as input"]
    #[inline(always)]
    pub fn prsch12(self) -> &'a mut W { self.variant(PRSSTOPSEL_A::PRSCH12) }
    #[doc = "PRS Channel 13 selected as input"]
    #[inline(always)]
    pub fn prsch13(self) -> &'a mut W { self.variant(PRSSTOPSEL_A::PRSCH13) }
    #[doc = "PRS Channel 14 selected as input"]
    #[inline(always)]
    pub fn prsch14(self) -> &'a mut W { self.variant(PRSSTOPSEL_A::PRSCH14) }
    #[doc = "PRS Channel 15 selected as input"]
    #[inline(always)]
    pub fn prsch15(self) -> &'a mut W { self.variant(PRSSTOPSEL_A::PRSCH15) }
    #[doc = "PRS Channel 16 selected as input"]
    #[inline(always)]
    pub fn prsch16(self) -> &'a mut W { self.variant(PRSSTOPSEL_A::PRSCH16) }
    #[doc = "PRS Channel 17 selected as input"]
    #[inline(always)]
    pub fn prsch17(self) -> &'a mut W { self.variant(PRSSTOPSEL_A::PRSCH17) }
    #[doc = "PRS Channel 18 selected as input"]
    #[inline(always)]
    pub fn prsch18(self) -> &'a mut W { self.variant(PRSSTOPSEL_A::PRSCH18) }
    #[doc = "PRS Channel 19 selected as input"]
    #[inline(always)]
    pub fn prsch19(self) -> &'a mut W { self.variant(PRSSTOPSEL_A::PRSCH19) }
    #[doc = "PRS Channel 20 selected as input"]
    #[inline(always)]
    pub fn prsch20(self) -> &'a mut W { self.variant(PRSSTOPSEL_A::PRSCH20) }
    #[doc = "PRS Channel 21 selected as input"]
    #[inline(always)]
    pub fn prsch21(self) -> &'a mut W { self.variant(PRSSTOPSEL_A::PRSCH21) }
    #[doc = "PRS Channel 22 selected as input"]
    #[inline(always)]
    pub fn prsch22(self) -> &'a mut W { self.variant(PRSSTOPSEL_A::PRSCH22) }
    #[doc = "PRS Channel 23 selected as input"]
    #[inline(always)]
    pub fn prsch23(self) -> &'a mut W { self.variant(PRSSTOPSEL_A::PRSCH23) }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x1f << 6)) | (((value as u32) & 0x1f) << 6);
        self.w
    }
}
#[doc = "PRS Clear Select\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum PRSCLEARSEL_A {
    #[doc = "0: PRS Channel 0 selected as input"]
    PRSCH0 = 0,
    #[doc = "1: PRS Channel 1 selected as input"]
    PRSCH1 = 1,
    #[doc = "2: PRS Channel 2 selected as input"]
    PRSCH2 = 2,
    #[doc = "3: PRS Channel 3 selected as input"]
    PRSCH3 = 3,
    #[doc = "4: PRS Channel 4 selected as input"]
    PRSCH4 = 4,
    #[doc = "5: PRS Channel 5 selected as input"]
    PRSCH5 = 5,
    #[doc = "6: PRS Channel 6 selected as input"]
    PRSCH6 = 6,
    #[doc = "7: PRS Channel 7 selected as input"]
    PRSCH7 = 7,
    #[doc = "8: PRS Channel 8 selected as input"]
    PRSCH8 = 8,
    #[doc = "9: PRS Channel 9 selected as input"]
    PRSCH9 = 9,
    #[doc = "10: PRS Channel 10 selected as input"]
    PRSCH10 = 10,
    #[doc = "11: PRS Channel 11 selected as input"]
    PRSCH11 = 11,
    #[doc = "12: PRS Channel 12 selected as input"]
    PRSCH12 = 12,
    #[doc = "13: PRS Channel 13 selected as input"]
    PRSCH13 = 13,
    #[doc = "14: PRS Channel 14 selected as input"]
    PRSCH14 = 14,
    #[doc = "15: PRS Channel 15 selected as input"]
    PRSCH15 = 15,
    #[doc = "16: PRS Channel 16 selected as input"]
    PRSCH16 = 16,
    #[doc = "17: PRS Channel 17 selected as input"]
    PRSCH17 = 17,
    #[doc = "18: PRS Channel 18 selected as input"]
    PRSCH18 = 18,
    #[doc = "19: PRS Channel 19 selected as input"]
    PRSCH19 = 19,
    #[doc = "20: PRS Channel 20 selected as input"]
    PRSCH20 = 20,
    #[doc = "21: PRS Channel 21 selected as input"]
    PRSCH21 = 21,
    #[doc = "22: PRS Channel 22 selected as input"]
    PRSCH22 = 22,
    #[doc = "23: PRS Channel 23 selected as input"]
    PRSCH23 = 23,
}
impl From<PRSCLEARSEL_A> for u8 {
    #[inline(always)]
    fn from(variant: PRSCLEARSEL_A) -> Self { variant as _ }
}
#[doc = "Reader of field `PRSCLEARSEL`"]
pub type PRSCLEARSEL_R = crate::R<u8, PRSCLEARSEL_A>;
impl PRSCLEARSEL_R {
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> crate::Variant<u8, PRSCLEARSEL_A> {
        use crate::Variant::*;
        match self.bits {
            0 => Val(PRSCLEARSEL_A::PRSCH0),
            1 => Val(PRSCLEARSEL_A::PRSCH1),
            2 => Val(PRSCLEARSEL_A::PRSCH2),
            3 => Val(PRSCLEARSEL_A::PRSCH3),
            4 => Val(PRSCLEARSEL_A::PRSCH4),
            5 => Val(PRSCLEARSEL_A::PRSCH5),
            6 => Val(PRSCLEARSEL_A::PRSCH6),
            7 => Val(PRSCLEARSEL_A::PRSCH7),
            8 => Val(PRSCLEARSEL_A::PRSCH8),
            9 => Val(PRSCLEARSEL_A::PRSCH9),
            10 => Val(PRSCLEARSEL_A::PRSCH10),
            11 => Val(PRSCLEARSEL_A::PRSCH11),
            12 => Val(PRSCLEARSEL_A::PRSCH12),
            13 => Val(PRSCLEARSEL_A::PRSCH13),
            14 => Val(PRSCLEARSEL_A::PRSCH14),
            15 => Val(PRSCLEARSEL_A::PRSCH15),
            16 => Val(PRSCLEARSEL_A::PRSCH16),
            17 => Val(PRSCLEARSEL_A::PRSCH17),
            18 => Val(PRSCLEARSEL_A::PRSCH18),
            19 => Val(PRSCLEARSEL_A::PRSCH19),
            20 => Val(PRSCLEARSEL_A::PRSCH20),
            21 => Val(PRSCLEARSEL_A::PRSCH21),
            22 => Val(PRSCLEARSEL_A::PRSCH22),
            23 => Val(PRSCLEARSEL_A::PRSCH23),
            i => Res(i),
        }
    }
    #[doc = "Checks if the value of the field is `PRSCH0`"]
    #[inline(always)]
    pub fn is_prsch0(&self) -> bool { *self == PRSCLEARSEL_A::PRSCH0 }
    #[doc = "Checks if the value of the field is `PRSCH1`"]
    #[inline(always)]
    pub fn is_prsch1(&self) -> bool { *self == PRSCLEARSEL_A::PRSCH1 }
    #[doc = "Checks if the value of the field is `PRSCH2`"]
    #[inline(always)]
    pub fn is_prsch2(&self) -> bool { *self == PRSCLEARSEL_A::PRSCH2 }
    #[doc = "Checks if the value of the field is `PRSCH3`"]
    #[inline(always)]
    pub fn is_prsch3(&self) -> bool { *self == PRSCLEARSEL_A::PRSCH3 }
    #[doc = "Checks if the value of the field is `PRSCH4`"]
    #[inline(always)]
    pub fn is_prsch4(&self) -> bool { *self == PRSCLEARSEL_A::PRSCH4 }
    #[doc = "Checks if the value of the field is `PRSCH5`"]
    #[inline(always)]
    pub fn is_prsch5(&self) -> bool { *self == PRSCLEARSEL_A::PRSCH5 }
    #[doc = "Checks if the value of the field is `PRSCH6`"]
    #[inline(always)]
    pub fn is_prsch6(&self) -> bool { *self == PRSCLEARSEL_A::PRSCH6 }
    #[doc = "Checks if the value of the field is `PRSCH7`"]
    #[inline(always)]
    pub fn is_prsch7(&self) -> bool { *self == PRSCLEARSEL_A::PRSCH7 }
    #[doc = "Checks if the value of the field is `PRSCH8`"]
    #[inline(always)]
    pub fn is_prsch8(&self) -> bool { *self == PRSCLEARSEL_A::PRSCH8 }
    #[doc = "Checks if the value of the field is `PRSCH9`"]
    #[inline(always)]
    pub fn is_prsch9(&self) -> bool { *self == PRSCLEARSEL_A::PRSCH9 }
    #[doc = "Checks if the value of the field is `PRSCH10`"]
    #[inline(always)]
    pub fn is_prsch10(&self) -> bool { *self == PRSCLEARSEL_A::PRSCH10 }
    #[doc = "Checks if the value of the field is `PRSCH11`"]
    #[inline(always)]
    pub fn is_prsch11(&self) -> bool { *self == PRSCLEARSEL_A::PRSCH11 }
    #[doc = "Checks if the value of the field is `PRSCH12`"]
    #[inline(always)]
    pub fn is_prsch12(&self) -> bool { *self == PRSCLEARSEL_A::PRSCH12 }
    #[doc = "Checks if the value of the field is `PRSCH13`"]
    #[inline(always)]
    pub fn is_prsch13(&self) -> bool { *self == PRSCLEARSEL_A::PRSCH13 }
    #[doc = "Checks if the value of the field is `PRSCH14`"]
    #[inline(always)]
    pub fn is_prsch14(&self) -> bool { *self == PRSCLEARSEL_A::PRSCH14 }
    #[doc = "Checks if the value of the field is `PRSCH15`"]
    #[inline(always)]
    pub fn is_prsch15(&self) -> bool { *self == PRSCLEARSEL_A::PRSCH15 }
    #[doc = "Checks if the value of the field is `PRSCH16`"]
    #[inline(always)]
    pub fn is_prsch16(&self) -> bool { *self == PRSCLEARSEL_A::PRSCH16 }
    #[doc = "Checks if the value of the field is `PRSCH17`"]
    #[inline(always)]
    pub fn is_prsch17(&self) -> bool { *self == PRSCLEARSEL_A::PRSCH17 }
    #[doc = "Checks if the value of the field is `PRSCH18`"]
    #[inline(always)]
    pub fn is_prsch18(&self) -> bool { *self == PRSCLEARSEL_A::PRSCH18 }
    #[doc = "Checks if the value of the field is `PRSCH19`"]
    #[inline(always)]
    pub fn is_prsch19(&self) -> bool { *self == PRSCLEARSEL_A::PRSCH19 }
    #[doc = "Checks if the value of the field is `PRSCH20`"]
    #[inline(always)]
    pub fn is_prsch20(&self) -> bool { *self == PRSCLEARSEL_A::PRSCH20 }
    #[doc = "Checks if the value of the field is `PRSCH21`"]
    #[inline(always)]
    pub fn is_prsch21(&self) -> bool { *self == PRSCLEARSEL_A::PRSCH21 }
    #[doc = "Checks if the value of the field is `PRSCH22`"]
    #[inline(always)]
    pub fn is_prsch22(&self) -> bool { *self == PRSCLEARSEL_A::PRSCH22 }
    #[doc = "Checks if the value of the field is `PRSCH23`"]
    #[inline(always)]
    pub fn is_prsch23(&self) -> bool { *self == PRSCLEARSEL_A::PRSCH23 }
}
#[doc = "Write proxy for field `PRSCLEARSEL`"]
pub struct PRSCLEARSEL_W<'a> {
    w: &'a mut W,
}
impl<'a> PRSCLEARSEL_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: PRSCLEARSEL_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "PRS Channel 0 selected as input"]
    #[inline(always)]
    pub fn prsch0(self) -> &'a mut W { self.variant(PRSCLEARSEL_A::PRSCH0) }
    #[doc = "PRS Channel 1 selected as input"]
    #[inline(always)]
    pub fn prsch1(self) -> &'a mut W { self.variant(PRSCLEARSEL_A::PRSCH1) }
    #[doc = "PRS Channel 2 selected as input"]
    #[inline(always)]
    pub fn prsch2(self) -> &'a mut W { self.variant(PRSCLEARSEL_A::PRSCH2) }
    #[doc = "PRS Channel 3 selected as input"]
    #[inline(always)]
    pub fn prsch3(self) -> &'a mut W { self.variant(PRSCLEARSEL_A::PRSCH3) }
    #[doc = "PRS Channel 4 selected as input"]
    #[inline(always)]
    pub fn prsch4(self) -> &'a mut W { self.variant(PRSCLEARSEL_A::PRSCH4) }
    #[doc = "PRS Channel 5 selected as input"]
    #[inline(always)]
    pub fn prsch5(self) -> &'a mut W { self.variant(PRSCLEARSEL_A::PRSCH5) }
    #[doc = "PRS Channel 6 selected as input"]
    #[inline(always)]
    pub fn prsch6(self) -> &'a mut W { self.variant(PRSCLEARSEL_A::PRSCH6) }
    #[doc = "PRS Channel 7 selected as input"]
    #[inline(always)]
    pub fn prsch7(self) -> &'a mut W { self.variant(PRSCLEARSEL_A::PRSCH7) }
    #[doc = "PRS Channel 8 selected as input"]
    #[inline(always)]
    pub fn prsch8(self) -> &'a mut W { self.variant(PRSCLEARSEL_A::PRSCH8) }
    #[doc = "PRS Channel 9 selected as input"]
    #[inline(always)]
    pub fn prsch9(self) -> &'a mut W { self.variant(PRSCLEARSEL_A::PRSCH9) }
    #[doc = "PRS Channel 10 selected as input"]
    #[inline(always)]
    pub fn prsch10(self) -> &'a mut W { self.variant(PRSCLEARSEL_A::PRSCH10) }
    #[doc = "PRS Channel 11 selected as input"]
    #[inline(always)]
    pub fn prsch11(self) -> &'a mut W { self.variant(PRSCLEARSEL_A::PRSCH11) }
    #[doc = "PRS Channel 12 selected as input"]
    #[inline(always)]
    pub fn prsch12(self) -> &'a mut W { self.variant(PRSCLEARSEL_A::PRSCH12) }
    #[doc = "PRS Channel 13 selected as input"]
    #[inline(always)]
    pub fn prsch13(self) -> &'a mut W { self.variant(PRSCLEARSEL_A::PRSCH13) }
    #[doc = "PRS Channel 14 selected as input"]
    #[inline(always)]
    pub fn prsch14(self) -> &'a mut W { self.variant(PRSCLEARSEL_A::PRSCH14) }
    #[doc = "PRS Channel 15 selected as input"]
    #[inline(always)]
    pub fn prsch15(self) -> &'a mut W { self.variant(PRSCLEARSEL_A::PRSCH15) }
    #[doc = "PRS Channel 16 selected as input"]
    #[inline(always)]
    pub fn prsch16(self) -> &'a mut W { self.variant(PRSCLEARSEL_A::PRSCH16) }
    #[doc = "PRS Channel 17 selected as input"]
    #[inline(always)]
    pub fn prsch17(self) -> &'a mut W { self.variant(PRSCLEARSEL_A::PRSCH17) }
    #[doc = "PRS Channel 18 selected as input"]
    #[inline(always)]
    pub fn prsch18(self) -> &'a mut W { self.variant(PRSCLEARSEL_A::PRSCH18) }
    #[doc = "PRS Channel 19 selected as input"]
    #[inline(always)]
    pub fn prsch19(self) -> &'a mut W { self.variant(PRSCLEARSEL_A::PRSCH19) }
    #[doc = "PRS Channel 20 selected as input"]
    #[inline(always)]
    pub fn prsch20(self) -> &'a mut W { self.variant(PRSCLEARSEL_A::PRSCH20) }
    #[doc = "PRS Channel 21 selected as input"]
    #[inline(always)]
    pub fn prsch21(self) -> &'a mut W { self.variant(PRSCLEARSEL_A::PRSCH21) }
    #[doc = "PRS Channel 22 selected as input"]
    #[inline(always)]
    pub fn prsch22(self) -> &'a mut W { self.variant(PRSCLEARSEL_A::PRSCH22) }
    #[doc = "PRS Channel 23 selected as input"]
    #[inline(always)]
    pub fn prsch23(self) -> &'a mut W { self.variant(PRSCLEARSEL_A::PRSCH23) }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x1f << 12)) | (((value as u32) & 0x1f) << 12);
        self.w
    }
}
#[doc = "PRS Start Mode\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum PRSSTARTMODE_A {
    #[doc = "0: PRS cannot start the LETIMER"]
    NONE = 0,
    #[doc = "1: Rising edge of selected PRS input can start the LETIMER"]
    RISING = 1,
    #[doc = "2: Falling edge of selected PRS input can start the LETIMER"]
    FALLING = 2,
    #[doc = "3: Both the rising or falling edge of the selected PRS input can start the LETIMER"]
    BOTH = 3,
}
impl From<PRSSTARTMODE_A> for u8 {
    #[inline(always)]
    fn from(variant: PRSSTARTMODE_A) -> Self { variant as _ }
}
#[doc = "Reader of field `PRSSTARTMODE`"]
pub type PRSSTARTMODE_R = crate::R<u8, PRSSTARTMODE_A>;
impl PRSSTARTMODE_R {
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> PRSSTARTMODE_A {
        match self.bits {
            0 => PRSSTARTMODE_A::NONE,
            1 => PRSSTARTMODE_A::RISING,
            2 => PRSSTARTMODE_A::FALLING,
            3 => PRSSTARTMODE_A::BOTH,
            _ => unreachable!(),
        }
    }
    #[doc = "Checks if the value of the field is `NONE`"]
    #[inline(always)]
    pub fn is_none(&self) -> bool { *self == PRSSTARTMODE_A::NONE }
    #[doc = "Checks if the value of the field is `RISING`"]
    #[inline(always)]
    pub fn is_rising(&self) -> bool { *self == PRSSTARTMODE_A::RISING }
    #[doc = "Checks if the value of the field is `FALLING`"]
    #[inline(always)]
    pub fn is_falling(&self) -> bool { *self == PRSSTARTMODE_A::FALLING }
    #[doc = "Checks if the value of the field is `BOTH`"]
    #[inline(always)]
    pub fn is_both(&self) -> bool { *self == PRSSTARTMODE_A::BOTH }
}
#[doc = "Write proxy for field `PRSSTARTMODE`"]
pub struct PRSSTARTMODE_W<'a> {
    w: &'a mut W,
}
impl<'a> PRSSTARTMODE_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: PRSSTARTMODE_A) -> &'a mut W {
        {
            self.bits(variant.into())
        }
    }
    #[doc = "PRS cannot start the LETIMER"]
    #[inline(always)]
    pub fn none(self) -> &'a mut W { self.variant(PRSSTARTMODE_A::NONE) }
    #[doc = "Rising edge of selected PRS input can start the LETIMER"]
    #[inline(always)]
    pub fn rising(self) -> &'a mut W { self.variant(PRSSTARTMODE_A::RISING) }
    #[doc = "Falling edge of selected PRS input can start the LETIMER"]
    #[inline(always)]
    pub fn falling(self) -> &'a mut W { self.variant(PRSSTARTMODE_A::FALLING) }
    #[doc = "Both the rising or falling edge of the selected PRS input can start the LETIMER"]
    #[inline(always)]
    pub fn both(self) -> &'a mut W { self.variant(PRSSTARTMODE_A::BOTH) }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 18)) | (((value as u32) & 0x03) << 18);
        self.w
    }
}
#[doc = "PRS Stop Mode\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum PRSSTOPMODE_A {
    #[doc = "0: PRS cannot stop the LETIMER"]
    NONE = 0,
    #[doc = "1: Rising edge of selected PRS input can stop the LETIMER"]
    RISING = 1,
    #[doc = "2: Falling edge of selected PRS input can stop the LETIMER"]
    FALLING = 2,
    #[doc = "3: Both the rising or falling edge of the selected PRS input can stop the LETIMER"]
    BOTH = 3,
}
impl From<PRSSTOPMODE_A> for u8 {
    #[inline(always)]
    fn from(variant: PRSSTOPMODE_A) -> Self { variant as _ }
}
#[doc = "Reader of field `PRSSTOPMODE`"]
pub type PRSSTOPMODE_R = crate::R<u8, PRSSTOPMODE_A>;
impl PRSSTOPMODE_R {
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> PRSSTOPMODE_A {
        match self.bits {
            0 => PRSSTOPMODE_A::NONE,
            1 => PRSSTOPMODE_A::RISING,
            2 => PRSSTOPMODE_A::FALLING,
            3 => PRSSTOPMODE_A::BOTH,
            _ => unreachable!(),
        }
    }
    #[doc = "Checks if the value of the field is `NONE`"]
    #[inline(always)]
    pub fn is_none(&self) -> bool { *self == PRSSTOPMODE_A::NONE }
    #[doc = "Checks if the value of the field is `RISING`"]
    #[inline(always)]
    pub fn is_rising(&self) -> bool { *self == PRSSTOPMODE_A::RISING }
    #[doc = "Checks if the value of the field is `FALLING`"]
    #[inline(always)]
    pub fn is_falling(&self) -> bool { *self == PRSSTOPMODE_A::FALLING }
    #[doc = "Checks if the value of the field is `BOTH`"]
    #[inline(always)]
    pub fn is_both(&self) -> bool { *self == PRSSTOPMODE_A::BOTH }
}
#[doc = "Write proxy for field `PRSSTOPMODE`"]
pub struct PRSSTOPMODE_W<'a> {
    w: &'a mut W,
}
impl<'a> PRSSTOPMODE_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: PRSSTOPMODE_A) -> &'a mut W {
        {
            self.bits(variant.into())
        }
    }
    #[doc = "PRS cannot stop the LETIMER"]
    #[inline(always)]
    pub fn none(self) -> &'a mut W { self.variant(PRSSTOPMODE_A::NONE) }
    #[doc = "Rising edge of selected PRS input can stop the LETIMER"]
    #[inline(always)]
    pub fn rising(self) -> &'a mut W { self.variant(PRSSTOPMODE_A::RISING) }
    #[doc = "Falling edge of selected PRS input can stop the LETIMER"]
    #[inline(always)]
    pub fn falling(self) -> &'a mut W { self.variant(PRSSTOPMODE_A::FALLING) }
    #[doc = "Both the rising or falling edge of the selected PRS input can stop the LETIMER"]
    #[inline(always)]
    pub fn both(self) -> &'a mut W { self.variant(PRSSTOPMODE_A::BOTH) }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 22)) | (((value as u32) & 0x03) << 22);
        self.w
    }
}
#[doc = "PRS Clear Mode\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum PRSCLEARMODE_A {
    #[doc = "0: PRS cannot clear the LETIMER"]
    NONE = 0,
    #[doc = "1: Rising edge of selected PRS input can clear the LETIMER"]
    RISING = 1,
    #[doc = "2: Falling edge of selected PRS input can clear the LETIMER"]
    FALLING = 2,
    #[doc = "3: Both the rising or falling edge of the selected PRS input can clear the LETIMER"]
    BOTH = 3,
}
impl From<PRSCLEARMODE_A> for u8 {
    #[inline(always)]
    fn from(variant: PRSCLEARMODE_A) -> Self { variant as _ }
}
#[doc = "Reader of field `PRSCLEARMODE`"]
pub type PRSCLEARMODE_R = crate::R<u8, PRSCLEARMODE_A>;
impl PRSCLEARMODE_R {
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> PRSCLEARMODE_A {
        match self.bits {
            0 => PRSCLEARMODE_A::NONE,
            1 => PRSCLEARMODE_A::RISING,
            2 => PRSCLEARMODE_A::FALLING,
            3 => PRSCLEARMODE_A::BOTH,
            _ => unreachable!(),
        }
    }
    #[doc = "Checks if the value of the field is `NONE`"]
    #[inline(always)]
    pub fn is_none(&self) -> bool { *self == PRSCLEARMODE_A::NONE }
    #[doc = "Checks if the value of the field is `RISING`"]
    #[inline(always)]
    pub fn is_rising(&self) -> bool { *self == PRSCLEARMODE_A::RISING }
    #[doc = "Checks if the value of the field is `FALLING`"]
    #[inline(always)]
    pub fn is_falling(&self) -> bool { *self == PRSCLEARMODE_A::FALLING }
    #[doc = "Checks if the value of the field is `BOTH`"]
    #[inline(always)]
    pub fn is_both(&self) -> bool { *self == PRSCLEARMODE_A::BOTH }
}
#[doc = "Write proxy for field `PRSCLEARMODE`"]
pub struct PRSCLEARMODE_W<'a> {
    w: &'a mut W,
}
impl<'a> PRSCLEARMODE_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: PRSCLEARMODE_A) -> &'a mut W {
        {
            self.bits(variant.into())
        }
    }
    #[doc = "PRS cannot clear the LETIMER"]
    #[inline(always)]
    pub fn none(self) -> &'a mut W { self.variant(PRSCLEARMODE_A::NONE) }
    #[doc = "Rising edge of selected PRS input can clear the LETIMER"]
    #[inline(always)]
    pub fn rising(self) -> &'a mut W { self.variant(PRSCLEARMODE_A::RISING) }
    #[doc = "Falling edge of selected PRS input can clear the LETIMER"]
    #[inline(always)]
    pub fn falling(self) -> &'a mut W { self.variant(PRSCLEARMODE_A::FALLING) }
    #[doc = "Both the rising or falling edge of the selected PRS input can clear the LETIMER"]
    #[inline(always)]
    pub fn both(self) -> &'a mut W { self.variant(PRSCLEARMODE_A::BOTH) }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 26)) | (((value as u32) & 0x03) << 26);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:4 - PRS Start Select"]
    #[inline(always)]
    pub fn prsstartsel(&self) -> PRSSTARTSEL_R { PRSSTARTSEL_R::new((self.bits & 0x1f) as u8) }
    #[doc = "Bits 6:10 - PRS Stop Select"]
    #[inline(always)]
    pub fn prsstopsel(&self) -> PRSSTOPSEL_R { PRSSTOPSEL_R::new(((self.bits >> 6) & 0x1f) as u8) }
    #[doc = "Bits 12:16 - PRS Clear Select"]
    #[inline(always)]
    pub fn prsclearsel(&self) -> PRSCLEARSEL_R {
        PRSCLEARSEL_R::new(((self.bits >> 12) & 0x1f) as u8)
    }
    #[doc = "Bits 18:19 - PRS Start Mode"]
    #[inline(always)]
    pub fn prsstartmode(&self) -> PRSSTARTMODE_R {
        PRSSTARTMODE_R::new(((self.bits >> 18) & 0x03) as u8)
    }
    #[doc = "Bits 22:23 - PRS Stop Mode"]
    #[inline(always)]
    pub fn prsstopmode(&self) -> PRSSTOPMODE_R {
        PRSSTOPMODE_R::new(((self.bits >> 22) & 0x03) as u8)
    }
    #[doc = "Bits 26:27 - PRS Clear Mode"]
    #[inline(always)]
    pub fn prsclearmode(&self) -> PRSCLEARMODE_R {
        PRSCLEARMODE_R::new(((self.bits >> 26) & 0x03) as u8)
    }
}
impl W {
    #[doc = "Bits 0:4 - PRS Start Select"]
    #[inline(always)]
    pub fn prsstartsel(&mut self) -> PRSSTARTSEL_W { PRSSTARTSEL_W { w: self } }
    #[doc = "Bits 6:10 - PRS Stop Select"]
    #[inline(always)]
    pub fn prsstopsel(&mut self) -> PRSSTOPSEL_W { PRSSTOPSEL_W { w: self } }
    #[doc = "Bits 12:16 - PRS Clear Select"]
    #[inline(always)]
    pub fn prsclearsel(&mut self) -> PRSCLEARSEL_W { PRSCLEARSEL_W { w: self } }
    #[doc = "Bits 18:19 - PRS Start Mode"]
    #[inline(always)]
    pub fn prsstartmode(&mut self) -> PRSSTARTMODE_W { PRSSTARTMODE_W { w: self } }
    #[doc = "Bits 22:23 - PRS Stop Mode"]
    #[inline(always)]
    pub fn prsstopmode(&mut self) -> PRSSTOPMODE_W { PRSSTOPMODE_W { w: self } }
    #[doc = "Bits 26:27 - PRS Clear Mode"]
    #[inline(always)]
    pub fn prsclearmode(&mut self) -> PRSCLEARMODE_W { PRSCLEARMODE_W { w: self } }
}
