#![doc(hidden)]

#[test]
fn efd() {
    use super::*;
    use ndarray::Zip;

    let mut efd = Efd::from_curve(PATH, Some(6));
    let efd_backup = efd.clone();
    // Test normalization
    let geo = efd.normalize();
    let norm = efd.generate(NORM.len());
    let err = Zip::from(&norm)
        .and(NORM)
        .map_collect(|a, b| (a[0] - b[0]) + (a[1] - b[1]))
        .sum();
    assert!(err < 1e-20, "{}", err);
    // Test reconstruction
    assert!((geo.semi_major_axis_angle - 0.871056726153095).abs() < 1e-20);
    assert!((geo.locus.0 - -2.41571330022796).abs() < 1e-20);
    assert!((geo.locus.1 - 53.43791856115811).abs() < 1e-20);
    let target = efd_backup.generate(TARGET.len());
    let err = Zip::from(&target)
        .and(TARGET)
        .map_collect(|a, b| (a[0] - b[0]) + (a[1] - b[1]))
        .sum();
    assert!(err < 1e-12, "{}", err);
}

pub const PATH: &[[f64; 2]] = &[
    [14.928108089437242, 90.01002059789568],
    [-3.25371009238094, 85.46456605244113],
    [-16.763462931659024, 76.52439024390245],
    [-39.6173464560173, 57.055475143350215],
    [-49.46583130450215, 35.085778173653246],
    [-27.739072687756586, 14.939024390243903],
    [-2.117346456017304, 19.17668726456234],
    [17.958411119740273, 37.7372933251684],
    [26.291744453073605, 57.81305090092597],
    [43.71598687731603, 68.41911150698658],
    [47.12507778640693, 80.5403236281987],
    [38.41295657428572, 90.38880847668355],
    [27.80689596822512, 91.1463842342593],
];
pub const TARGET: &[[f64; 2]] = &[
    [39.35863965131904, 83.29742588206082],
    [28.06426978660421, 90.17530230145958],
    [14.322369428735222, 89.31456476623697],
    [1.644141648731889, 84.80316243236997],
    [-10.594878257867837, 78.05523268450065],
    [-21.481011313772758, 69.6418738549989],
    [-31.51422384342044, 60.88040361398968],
    [-40.927190098600846, 50.42944632397454],
    [-45.28855318333383, 38.500182501760776],
    [-41.441192886353605, 27.955187648838773],
    [-32.07610003945156, 19.668006412715144],
    [-20.786321365878784, 15.481233369294323],
    [-9.16297124779308, 17.901961900785633],
    [1.8680500961438629, 24.16562879325819],
    [11.095844581723647, 32.082393132610164],
    [17.236398712404707, 43.47293538379268],
    [22.444136258469218, 55.055717188525996],
    [31.20682510176712, 62.82443436686037],
    [40.133214266242625, 71.61536010397093],
    [39.35863965131904, 83.29742588206082],
];
pub const NORM: &[[f64; 2]] = &[
    [0.08891215505140294, 1.1208152251011967],
    [-0.1855649309215952, 1.0286145311944075],
    [-0.36492834737357743, 0.7862898221269873],
    [-0.4681410431045089, 0.5103025675423078],
    [-0.5276967567396588, 0.21013397905678757],
    [-0.5402775646117156, -0.09085779994486003],
    [-0.5349997894400988, -0.38247142088966807],
    [-0.49267545082256675, -0.6875197585804631],
    [-0.35435319958301403, -0.9287963377149041],
    [-0.12346316682247069, -1.0130504456766292],
    [0.1474151197119542, -0.9730398840198349],
    [0.3767494863787692, -0.8429675016362812],
    [0.5001071608622976, -0.6141318666159403],
    [0.5507400445730783, -0.3410269822859081],
    [0.5482541169143308, -0.07481633098000073],
    [0.4440451139607308, 0.18866623494616858],
    [0.3234618428721972, 0.4392342975968699],
    [0.31689712768901207, 0.6955663975385559],
    [0.2955180814054329, 0.9690552732412064],
    [0.08891215505140315, 1.1208152251011965],
];
