#![doc(hidden)]

#[test]
fn efd() {
    use crate::{math::*, *};

    let efd = Efd::from_curve(PATH, None);
    // Test geometry information
    assert!(abs(efd.geo.center[0] - -2.41571330022796) < 1e-20);
    assert!(abs(efd.geo.center[1] - 53.43791856115811) < 1e-20);
    assert!(abs(efd.geo.rot - -0.871056726153095) < 1e-20);
    assert!(abs(efd.geo.scale - 45.67021236733221) < 1e-20);
    assert_eq!(efd.harmonic(), 6);
    // Test normalized
    let norm = efd.generate(NORM.len());
    assert!(curve_diff(&norm, NORM) < 1e-12);
    // Test reconstruction
    let target = efd.geo.transform(&norm);
    assert!(curve_diff(&target, TARGET) < 1e-12);
}

pub const PATH: &[[f64; 2]] = &[
    [14.928108089437242, 90.01002059789568],
    [-3.25371009238094, 85.46456605244113],
    [-16.763462931659024, 76.52439024390245],
    [-39.6173464560173, 57.055475143350215],
    [-49.46583130450215, 35.085778173653246],
    [-27.739072687756586, 14.939024390243903],
    [-2.117346456017304, 19.17668726456234],
    [17.958411119740273, 37.7372933251684],
    [26.291744453073605, 57.81305090092597],
    [43.71598687731603, 68.41911150698658],
    [47.12507778640693, 80.5403236281987],
    [38.41295657428572, 90.38880847668355],
    [27.80689596822512, 91.1463842342593],
];
pub const TARGET: &[[f64; 2]] = &[
    [39.35863965131904, 83.29742588206082],
    [28.064269786604218, 90.1753023014596],
    [14.322369428735211, 89.31456476623694],
    [1.6441416487318925, 84.80316243236996],
    [-10.594878257867837, 78.05523268450064],
    [-21.481011313772765, 69.64187385499889],
    [-31.514223843420446, 60.880403613989664],
    [-40.927190098600846, 50.429446323974524],
    [-45.288553183333846, 38.50018250176077],
    [-41.44119288635361, 27.955187648838766],
    [-32.076100039451575, 19.66800641271513],
    [-20.78632136587879, 15.481233369294316],
    [-9.162971247793088, 17.90196190078562],
    [1.868050096143861, 24.165628793258193],
    [11.095844581723618, 32.082393132610136],
    [17.236398712404686, 43.472935383792645],
    [22.444136258469175, 55.05571718852593],
    [31.206825101767087, 62.82443436686036],
    [40.13321426624258, 71.61536010397083],
    [39.35863965131909, 83.29742588206074],
];
pub const NORM: &[[f64; 2]] = &[
    [0.08891215505140294, 1.1208152251011967],
    [-0.1855649309215952, 1.0286145311944075],
    [-0.36492834737357743, 0.7862898221269873],
    [-0.4681410431045089, 0.5103025675423078],
    [-0.5276967567396588, 0.21013397905678757],
    [-0.5402775646117156, -0.09085779994486003],
    [-0.5349997894400988, -0.38247142088966807],
    [-0.49267545082256675, -0.6875197585804631],
    [-0.35435319958301403, -0.9287963377149041],
    [-0.12346316682247069, -1.0130504456766292],
    [0.1474151197119542, -0.9730398840198349],
    [0.3767494863787692, -0.8429675016362812],
    [0.5001071608622976, -0.6141318666159403],
    [0.5507400445730783, -0.3410269822859081],
    [0.5482541169143308, -0.07481633098000161],
    [0.4440451139607313, 0.1886662349461679],
    [0.3234618428721975, 0.43923429759686866],
    [0.31689712768901196, 0.6955663975385552],
    [0.29551808140543373, 0.9690552732412046],
    [0.08891215505140529, 1.1208152251011962],
];
