// MIT License
//
// Copyright (c) 2021 Ferhat Geçdoğan All Rights Reserved.
// Distributed under the terms of the MIT License.
//
//

#[cfg(test)]
mod tests {
    use crate::{E};

    #[test]
    fn e() {
        let init = E::default();

        println!("e104 is: {}", init.get("e104"));
    }
}

pub struct E {
    everything:  std::collections::HashMap<&'static str, &'static str>
}

impl E {
    pub fn get(self, e_code: &str) -> &str {
        let get_additive = self.everything.get(&*e_code.to_uppercase());

        return if get_additive.is_none() {
            Default::default()
        } else { get_additive.unwrap() }
    }
}

impl Default for E {
    fn default() -> Self {
        let init: std::collections::HashMap<&'static str, &'static str> = [
            ("E100", "Curcumin"),
            ("E101", "(i) Riboflavin | (ii) Riboflavin-5\" - phosphate"),
            ("E102", "Tartrazine"),
            ("E104", "Quinoline yellow"),
            ("E110", "Sunset Yellow FCF; Orange Yellow S"),
            ("E120", "Cochineal; Carminic acid; Carmines"),
            ("E122", "Azorubine; Carmoisine"),
            ("E123", "Amaranth"),
            ("E124", "Ponceau 4R; Cochineal Red A"),
            ("E127", "Erythrosine"),
            ("E129", "Allura Red AC"),
            ("E131", "Patent Blue V"),
            ("E132", "lndigotine; Indigo Carmine"),
            ("E133", "Brilliant Blue FCF"),
            ("E140", "Chlorophylls and chlorophyllins"),
            ("E141", "Copper complexes of chlorophyll and chlorophyllins"),
            ("E142", "Green S"),
            ("E150A", "Plain caramel"),
            ("E150B", "Caustic sulphite caramel"),
            ("E150C", "Ammonia caramel"),
            ("E150D", "Sulphite ammonia caramel"),
            ("E151", "Brilliant Black BN; Black PN"),
            ("E153", "Vegetable carbon"),
            ("E155", "Brown HT"),
            ("E160A", "Carotenes"),
            ("E160B", "(i)\"Annatto, bixin | (ii) Annatto, norbixin"),
            ("E160C", "Paprika extract; Capsanthian; Capsorubin"),
            ("E160D", "Lycopene"),
            ("E160E", "Beta-apo-8\" - carotenal(C30)"),
            ("E161B", "Lutein"),
            ("E161G", "Canthaxanthin"),
            ("E162", "Beetroot Red; Betanin"),
            ("E163", "Anthocyanins"),
            ("E170", "Calcium carbonate"),
            ("E171", "Titanium dioxide"),
            ("E172", "Iron oxides and hydroxides"),
            ("E173", "Aluminium"),
            ("E174", "Silver"),
            ("E175", "Gold"),
            ("E180", "Litholrubine BK"),
            ("E200", "Sorbic acid"),
            ("E202", "Potassium sorbate"),
            ("E210", "Benzoic acid"),
            ("E211", "Sodium benzoate"),
            ("E212", "Potassium benzoate"),
            ("E213", "Calcium benzoate"),
            ("E214", "Ethyl p-hydroxybenzoate"),
            ("E215", "Sodium ethyl p-hydroxybenzoate"),
            ("E218", "Methyl p-hydroxybenzoate"),
            ("E219", "Sodium methyl p-hydroxybenzoate"),
            ("E220", "Sulphur dioxide"),
            ("E221", "Sodium sulphite"),
            ("E222", "Sodium hydrogen sulphite"),
            ("E223", "Sodium metabisulphite"),
            ("E224", "Potassium metabisulphite"),
            ("E226", "Calcium sulphite"),
            ("E227", "Calcium hydrogen sulphite"),
            ("E228", "Potassium hydrogen sulphite"),
            ("E234", "Nisin"),
            ("E235", "Natamycin"),
            ("E239", "Hexamethylene tetramine"),
            ("E242", "Dimethyl dicarbonate"),
            ("E243", "Ethyl lauroyl arginate"),
            ("E249", "Potassium nitrite"),
            ("E250", "Sodium nitrite"),
            ("E251", "Sodium nitrate"),
            ("E252", "Potassium nitrate"),
            ("E280", "Propionic acid"),
            ("E281", "Sodium propionate"),
            ("E282", "Calcium propionate"),
            ("E283", "Potassium propionate"),
            ("E284", "Boric acid"),
            ("E285", "Sodium tetraborate; borax"),
            ("E1105", "Lysozyme"),
            ("E300", "Ascorbic acid"),
            ("E301", "Sodium ascorbate"),
            ("E302", "Calcium ascorbate"),
            ("E304", "Fatty acid esters of ascorbic acid"),
            ("E306", "Tocopherols"),
            ("E307", "Alpha-tocopherol"),
            ("E308", "Gamma-tocopherol"),
            ("E309", "Delta-tocopherol"),
            ("E310", "Propyl gallate"),
            ("E315", "Erythorbic acid"),
            ("E316", "Sodium erythorbate"),
            ("E319", "Tertiary-butyl hydroquinone (TBHQ)"),
            ("E320", "Butylated hydroxyanisole (BHA)"),
            ("E321", "Butylated hydroxytoluene (BHT)"),
            ("E392", "Extracts of rosemary"),
            ("E586", "4-Hexylresorcinol"),
            ("E420", "(i) Sorbitol | (ii) Sorbitol syrup"),
            ("E421", "Mannitol"),
            ("E950", "Acesulfame K"),
            ("E951", "Aspartame"),
            ("E952", "Cyclamic acid and its Na and Ca salts"),
            ("E953", "lsomalt"),
            ("E954", "Saccharin and its Na, K and Ca salts"),
            ("E955", "Sucralose"),
            ("E957", "Thaumatin"),
            ("E959", "Neohesperidine DC"),
            ("E960", "Steviol glycoside"),
            ("E961", "Neotame"),
            ("E962", "Salt of aspartame-acesulfame"),
            ("E964", "Polyglycitol syrup"),
            ("E965", "(i) Maltitol | (ii) Maltitol syrup"),
            ("E966", "Lactitol"),
            ("E967", "Xylitol"),
            ("E968", "Erythritol"),
             ("E969", "Advantame"),
             ("E322", "Lecithins"),
             ("E400", "Alginic acid"),
             ("E401", "Sodium alginate"),
             ("E402", "Potassium alginate"),
             ("E403", "Ammonium alginate"),
             ("E404", "Calcium alginate"),
             ("E405", "Propane-1,2-diol alginate"),
             ("E406", "Agar"),
             ("E407", "Carrageenan"),
             ("E407A", "Processed eucheuma seaweed"),
             ("E410", "Locust bean gum; carob gum"),
             ("E412", "Guar gum"),
             ("E413", "Tragacanth"),
             ("E414", "Acacia gum; gum arabic"),
             ("E415", "Xanthan gum"),
             ("E416", "Karaya gum"),
             ("E417", "Tara gum"),
             ("E418", "Gellan gum"),
             ("E425", "Konjac"),
             ("E426", "Soybean hemicellulose"),
             ("E427", "Cassia gum"),
             ("E432", "Polyoxyethylene sorbitan monolaurate; Polysorbate 20"),
             ("E433", "Polyoxyethylene sorbitan mono-oleate; Polysorbate 80"),
             ("E434", "Polyoxyethylene sorbitan monopalmitate; Polysorbate 40"),
             ("E435", "Polyoxyethylene sorbitan monostearate; Polysorbate 60"),
             ("E436", "Polyoxyethylene sorbitan tristearate; Polysorbate 65"),
             ("E440", "Pectins"),
             ("E442", "Ammonium phosphatides"),
             ("E444", "Sucrose acetate isobutyrate"),
             ("E445", "Glycerol esters of wood rosins"),
             ("E460", "Cellulose"),
             ("E461", "Methyl cellulose"),
             ("E462", "Ethyl cellulose"),
             ("E463", "Hydroxypropyl cellulose"),
             ("E464", "Hydroxypropyl methyl cellulose"),
             ("E465", "Ethyl methyl cellulose"),
             ("E466", "Carboxy methyl cellulose"),
             ("E468", "Crosslinked sodium carboxy methyl cellulose"),
             ("E469", "Enzymatically hydrolysed carboxy methyl cellulose"),
             ("E470A", "Sodium, potassium and calcium salts of fatty acids"),
             ("E470B", "Magnesium salts of fatty acids"),
             ("E471", "Mono- and diglycerides of fatty acids"),
             ("E472A", "Acetic acid esters of mono- and diglycerides of fatty acids"),
             ("E472B", "Lactic acid esters of mono- and diglycerides of fatty acids"),
             ("E472C", "Citric acid esters of mono- and diglycerides of fatty acids"),
             ("E472D", "Tartaric acid esters of mono- and diglycerides of fatty acids"),
             ("E472E", "Mono- and diacetyltartaric acid esters of mono- and diglycerides of fatty acids"),
             ("E472F", "Mixed acetic and tartaric acid esters of mono- and diglycerides of fatty acids"),
             ("E473", "Sucrose esters of fatty acids"),
             ("E474", "Sucroglycerides"),
             ("E475", "Polyglycerol esters of fatty acids"),
             ("E476", "Polyglycerol polyricinoleate"),
             ("E477", "Propane-1,2-diol esters of fatty acids"),
             ("E479B", "Thermally oxidised soya bean oil interacted with mono­ and diglycerides of fatty acids"),
             ("E481", "Sodium stearoyl-2-lactylate"),
             ("E482", "Calcium stearoyl-2-lactylate"),
             ("E483", "Stearyl tartrate"),
             ("E491", "Sorbitan monostearate"),
             ("E492", "Sorbitan tristearate"),
             ("E493", "Sorbitan monolaurate"),
             ("E494", "Sorbitan monooleate"),
             ("E495", "Sorbitan monopalmitate"),
             ("E1103", "Invertase"),
             ("E260", "Acetic acid"),
             ("E261", "Potassium acetate"),
             ("E262", "Sodium acetate"),
             ("E263", "Calcium acetate"),
             ("E270", "Lactic acid"),
             ("E290", "Carbon dioxide"),
             ("E296", "Malic acid"),
             ("E297", "Fumaric acid"),
             ("E325", "Sodium lactate"),
             ("E326", "Potassium lactate"),
             ("E327", "Calcium lactate"),
             ("E330", "Citric acid"),
             ("E331", "Sodium citrates"),
             ("E332", "Potassium citrates"),
             ("E333", "Calcium citrates"),
             ("E334", "Tartaric acid (L-(+))"),
             ("E335", "Sodium tartrates"),
             ("E336", "Potassium tartrates"),
             ("E337", "Sodium potassium tartrate"),
             ("E338", "Phosphoric acid"),
             ("E339", "Sodium phosphates"),
             ("E340", "Potassium phosphates"),
             ("E341", "Calcium phosphates"),
             ("E343", "Magnesium phosphates"),
             ("E350", "Sodium malates"),
             ("E351", "Potassium malate"),
             ("E352", "Calcium malates"),
             ("E353", "Metatartaric acid"),
             ("E354", "Calcium tartrate"),
             ("E355", "Adipic acid"),
             ("E356", "Sodium adipate"),
             ("E357", "Potassium adipate"),
             ("E363", "Succinic acid"),
             ("E380", "Triammonium citrate"),
             ("E385", "Calcium disodium ethylene diamine tetra-acetate; calcium disodium EDTA"),
             ("E422", "Glycerol"),
             ("E423", "Octenyl succinic acid modified gum Arabic"),
             ("E450", "Diphosphates"),
             ("E451", "Triphosphates"),
             ("E452", "Polyphosphates"),
             ("E459", "Beta-cyclodextrin"),
             ("E499", "Stigmasterol-rich plant sterols"),
             ("E500", "Sodium carbonates"),
             ("E501", "Potassium carbonates"),
             ("E503", "Ammonium carbonates"),
             ("E504", "Magnesium carbonates"),
             ("E507", "Hydrochloric acid"),
             ("E508", "Potassium chloride"),
             ("E509", "Calcium chloride"),
             ("E511", "Magnesium chloride"),
             ("E512", "Stannous chloride"),
             ("E513", "Sulphuric acid"),
             ("E514", "Sodium sulphates"),
             ("E515", "Potassium sulphates"),
             ("E516", "Calcium sulphate"),
             ("E517", "Ammonium sulphate"),
             ("E520", "Aluminium sulphate"),
             ("E521", "Aluminium sodium sulphate"),
             ("E522", "Aluminium potassium sulphate"),
             ("E523", "Aluminium ammonium sulphate"),
             ("E524", "Sodium hydroxide"),
             ("E525", "Potassium hydroxide"),
             ("E526", "Calcium hydroxide"),
             ("E527", "Ammonium hydroxide"),
             ("E528", "Magnesium hydroxide"),
             ("E529", "Calcium oxide"),
             ("E530", "Magnesium oxide"),
             ("E535", "Sodium ferrocyanide"),
             ("E536", "Potassium ferrocyanide"),
             ("E538", "Calcium ferrocyanide"),
             ("E541", "Sodium aluminium phosphate"),
             ("E551", "Silicon dioxide"),
             ("E552", "Calcium silicate"),
             ("E553A", "(i) Magnesium silicate | (ii) Magnesium trisilicate"),
             ("E553B", "Talc"),
             ("E554", "Sodium aluminium silicate"),
             ("E555", "Potassium aluminium silicate"),
             ("E570", "Fatty acids"),
             ("E574", "Gluconic acid"),
             ("E575", "Glucono delta-lactone"),
             ("E576", "Sodium gluconate"),
             ("E577", "Potassium gluconate"),
             ("E578", "Calcium gluconate"),
             ("E579", "Ferrous gluconate"),
             ("E585", "Ferrous lactate"),
             ("E620", "Glutamic acid"),
             ("E621", "Monosodium glutamate"),
             ("E622", "Monopotassium glutamate"),
             ("E623", "Calcium diglutamate"),
             ("E624", "Monoammonium glutamate"),
             ("E625", "Magnesium diglutamate"),
             ("E626", "Guanylic acid"),
             ("E627", "Disodium guanylate"),
             ("E628", "Dipotassium guanylate"),
             ("E629", "Calcium guanylate"),
             ("E630", "lnosinic acid"),
             ("E631", "Disodium inosinate"),
             ("E632", "Dipotassium inosinate"),
             ("E633", "Calcium inosinate"),
             ("E634", "Calcium 5\" - ribonucleotides"),
             ("E635", "Disodium 5\" - ribonucleotides"),
             ("E640", "Glycine and its sodium salt"),
             ("E641", "L-leucine"),
             ("E650", "Zinc acetate"),
             ("E900", "Dimethylpolysiloxane"),
             ("E901", "Beeswax, white and yellow"),
             ("E902", "Candelilla wax"),
             ("E903", "Carnauba wax"),
             ("E904", "Shellac"),
             ("E905", "Microcrystalline wax"),
             ("E907", "Hydrogenated Poly-1-Decene"),
             ("E914", "Oxidised Polyethylene wax"),
             ("E920", "L-Cysteine"),
             ("E927B", "Carbamide"),
             ("E938", "Argon"),
             ("E939", "Helium"),
             ("E941", "Nitrogen"),
             ("E942", "Nitrous oxide"),
             ("E943A", "Butane"),
             ("E943B", "Iso-butane"),
             ("E944", "Propane"),
             ("E948", "Oxygen"),
             ("E949", "Hydrogen"),
             ("E999", "Quillaia extract"),
             ("E1200", "Polydextrose"),
             ("E1201", "Polyvinylpyrrolidone"),
             ("E1202", "Polyvinylpolypyrrolidone"),
             ("E1203", "Polyvinyl alcohol"),
             ("E1204", "Pullulan"),
             ("E1205", "Basic methacrylate copolymer"),
             ("E1206", "Neutral methacrylate copolymer"),
             ("E1207", "Anionic methacrylate copolymer"),
             ("E1208", "Polyvinylpyrrolidone-vinylacetate copolymer"),
             ("E1209", "Polyvinyl alcohol-polyethylene glycol-graft- co-polymer"),
             ("E1404", "Oxidised starch"),
             ("E1410", "Monostarch phosphate"),
             ("E1412", "Distarch phosphate"),
             ("E1413", "Phosphated distarch phosphate"),
             ("E1414", "Acetylated distarch phosphate"),
             ("E1420", "Acetylated starch"),
             ("E1422", "Acetylated distarch adipate"),
             ("E1440", "Hydroxyl propyl starch"),
             ("E1442", "Hydroxy propyl distarch phosphate"),
             ("E1450", "Starch sodium octenyl succinate"),
             ("E1451", "Acetylated oxidised starch"),
             ("E1452", "Starch aluminium Octenyl succinate"),
             ("E1505", "Triethyl citrate"),
             ("E1517", "Glyceryl diacetate (diacetin)"),
             ("E1518", "Glyceryl triacetate; triacetin"),
             ("E1519", "Benzyl alcohol"),
             ("E1520", "Propan-1,2-diol; propylene glycol"),
             ("E1521", "Polyethylene glycol")
        ].iter().cloned().collect();

        E {
            everything: init
        }
    }
}