#[link(wasm_import_module = "result")]
extern "C" {
    fn host_get_result(result_ptr: *mut u8) -> i32;
}

pub fn get_result_bytes(result_len: i32) -> Option<Vec<u8>> {
    let mut dest_bytes = Vec::with_capacity(result_len as usize);
    let dest_pointer = dest_bytes.as_mut_ptr();

    let response_value = unsafe { host_get_result(dest_pointer) };

    if response_value >= 0 {
        unsafe {
            dest_bytes.set_len(response_value as usize);
        };
        Some(dest_bytes)
    } else {
        None
    }
}
