//! Log related interface and utilities.

#[macro_use]
mod macros;

#[link(wasm_import_module = "log")]
extern "C" {
    fn host_log_msg(log_msg_address: *const u8, log_str_size: u32, log_level: u32) -> i32;
}

use std::fmt;

/// An enum representing the available verbosity levels of the logger.
pub enum LogLevel {
    /// The "info" level.
    ///
    /// Designates useful information.
    INFO = 0,
    /// The "error" level.
    ///
    /// Designates very serious errors.
    ERROR,
    /// The "warn" level.
    ///
    /// Designates hazardous situations.
    WARN,
    /// The "debug" level.
    ///
    /// Designates lower priority information.
    DEBUG,
    /// The "trace" level.
    ///
    /// Designates very low priority, often extremely verbose, information.
    TRACE,
    /// The "fatal" level.
    ///
    /// Designates fatal situations.
    FATAL,
}

#[doc(hidden)]
pub fn call_host_logger(args: fmt::Arguments, level: LogLevel) {
    let log_str = &args.to_string();
    unsafe { host_log_msg(log_str.as_ptr(), log_str.len() as u32, level as u32) };
}
