use http::Version;
use http::{header::HeaderValue, HeaderMap};
use std::collections::HashMap;

pub fn to_version_string(ver: &Version) -> String {
    match *ver {
        Version::HTTP_09 => "HTTP/0.9".to_string(),
        Version::HTTP_10 => "HTTP/1.0".to_string(),
        Version::HTTP_11 => "HTTP/1.1".to_string(),
        Version::HTTP_2 => "HTTP/2.0".to_string(),
        Version::HTTP_3 => "HTTP/3.0".to_string(),
        __non_exhaustive => unreachable!(),
    }
}

pub fn convert_to_hashmap(headers: &HeaderMap<HeaderValue>) -> HashMap<String, Vec<String>> {
    let mut header_hashmap = HashMap::new();
    for (k, v) in headers {
        let k = k.as_str().to_owned();
        let val_res = String::from_utf8(v.as_bytes().to_vec());
        if val_res.is_ok() {
            let val = val_res.ok().unwrap();
            header_hashmap.entry(k).or_insert_with(Vec::new).push(val)
        }
    }
    header_hashmap
}
