use crate::web::{self, WEB_HANDLER};

#[allow(dead_code)]
#[allow(unused_parens)]
// wit_bindgen_rust::export!("../wit/edgedb_http_server_v1.wit");
mod edgedb_http_server_v1 {
  #[derive(Clone)]
  pub struct Request {
    pub method: String,
    pub uri: String,
    pub headers: Vec<(Vec<u8>,Vec<u8>,)>,
    pub body: Vec<u8>,
  }
  impl std::fmt::Debug for Request {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
      f.debug_struct("Request").field("method", &self.method).field("uri", &self.uri).field("headers", &self.headers).field("body", &self.body).finish()}
  }
  #[derive(Clone)]
  pub struct Response {
    pub status_code: u16,
    pub headers: Vec<(Vec<u8>,Vec<u8>,)>,
    pub body: Vec<u8>,
  }
  impl std::fmt::Debug for Response {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
      f.debug_struct("Response").field("status-code", &self.status_code).field("headers", &self.headers).field("body", &self.body).finish()}
  }
  #[export_name = "handle-request"]
  unsafe extern "C" fn __wit_bindgen_handle_request(arg0: i32, arg1: i32, arg2: i32, arg3: i32, arg4: i32, arg5: i32, arg6: i32, arg7: i32, ) -> i32{
    let len0 = arg1 as usize;
    let len1 = arg3 as usize;
    let base4 = arg4;
    let len4 = arg5;
    let mut result4 = Vec::with_capacity(len4 as usize);
    for i in 0..len4 {
      let base = base4 + i *16;
      result4.push({
        let len2 = *((base + 4) as *const i32) as usize;
        let len3 = *((base + 12) as *const i32) as usize;
        
        (Vec::from_raw_parts(*((base + 0) as *const i32) as *mut _, len2, len2), Vec::from_raw_parts(*((base + 8) as *const i32) as *mut _, len3, len3))
      });
    }
    std::alloc::dealloc(
    base4 as *mut _,
    std::alloc::Layout::from_size_align_unchecked(
    (len4 as usize) * 16,
    4,
    ),
    );
    let len5 = arg7 as usize;
    let result = <super::EdgedbHttpServerV1 as EdgedbHttpServerV1>::handle_request(Request{method:String::from_utf8(Vec::from_raw_parts(arg0 as *mut _, len0, len0)).unwrap(), uri:String::from_utf8(Vec::from_raw_parts(arg2 as *mut _, len1, len1)).unwrap(), headers:result4, body:Vec::from_raw_parts(arg6 as *mut _, len5, len5), });
    let Response{ status_code:status_code6, headers:headers6, body:body6, } = result;
    let vec10 = headers6;
    let len10 = vec10.len() as i32;
    let layout10 = core::alloc::Layout::from_size_align_unchecked(vec10.len() * 16, 4);
    let result10 = std::alloc::alloc(layout10);
    if result10.is_null() { std::alloc::handle_alloc_error(layout10); }
    for (i, e) in vec10.into_iter().enumerate() {
      let base = result10 as i32 + (i as i32) * 16;
      {
        let (t7_0, t7_1, ) = e;
        let vec8 = (t7_0).into_boxed_slice();
        let ptr8 = vec8.as_ptr() as i32;
        let len8 = vec8.len() as i32;
        core::mem::forget(vec8);
        *((base + 4) as *mut i32) = len8;
        *((base + 0) as *mut i32) = ptr8;
        let vec9 = (t7_1).into_boxed_slice();
        let ptr9 = vec9.as_ptr() as i32;
        let len9 = vec9.len() as i32;
        core::mem::forget(vec9);
        *((base + 12) as *mut i32) = len9;
        *((base + 8) as *mut i32) = ptr9;
        
      }}
      let vec11 = (body6).into_boxed_slice();
      let ptr11 = vec11.as_ptr() as i32;
      let len11 = vec11.len() as i32;
      core::mem::forget(vec11);
      let ptr12 = RET_AREA.as_mut_ptr() as i32;
      *((ptr12 + 32) as *mut i32) = len11;
      *((ptr12 + 24) as *mut i32) = ptr11;
      *((ptr12 + 16) as *mut i32) = len10;
      *((ptr12 + 8) as *mut i32) = result10 as i32;
      *((ptr12 + 0) as *mut i32) = crate::bindgen::as_i32(status_code6);
      ptr12
    }
    pub trait EdgedbHttpServerV1 {
      fn handle_request(request: Request,) -> Response;
    }
    static mut RET_AREA: [i64; 5] = [0; 5];
  }
  
use edgedb_http_server_v1 as v1;

struct EdgedbHttpServerV1 {
}

impl v1::EdgedbHttpServerV1 for EdgedbHttpServerV1 {
    fn handle_request(req: v1::Request) -> v1::Response {
        if let Some(handler) = WEB_HANDLER.get() {
            let mut bld = http::Request::builder();
            bld = bld.method(&req.method[..]);
            bld = bld.uri(&req.uri);
            for (k, v) in req.headers {
                bld = bld.header(k, v);
            }
            let inner = bld.body(req.body).expect("can build request");

            let resp = handler(web::Request {
                inner,
            });

            v1::Response {
                status_code: resp.status().as_u16(),
                headers: resp.headers().iter().map(|(key, val)| {
                    (key.as_str().as_bytes().to_vec(), val.as_bytes().to_vec())
                }).collect(),
                body: resp.into_body(),
            }
        } else {
            v1::Response {
                status_code: 404,
                // TODO(tailhook) only in debug mode
                headers: vec![],
                body: b"Page Not Found (Web handler is not set)".to_vec(),
            }
        }
    }
}
