#[test]
fn test_keys() {
    use ed25519_axolotl::crypto::keys::KeyPair;

    let response = [
        [
            [1; 32],
            [
                0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 65,
            ],
            [
                164, 224, 146, 146, 182, 81, 194, 120, 185, 119, 44, 86, 159, 95, 169, 187, 19,
                217, 6, 180, 106, 182, 140, 157, 249, 220, 43, 68, 9, 248, 162, 9,
            ],
        ],
        [
            [2; 32],
            [
                0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
                2, 2, 2, 66,
            ],
            [
                206, 141, 58, 209, 204, 182, 51, 236, 123, 112, 193, 120, 20, 165, 199, 110, 205,
                2, 150, 133, 5, 13, 52, 71, 69, 186, 5, 135, 14, 88, 125, 89,
            ],
        ],
        [
            [3; 32],
            [
                0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
                3, 3, 3, 67,
            ],
            [
                93, 254, 221, 59, 107, 212, 127, 111, 162, 142, 225, 93, 150, 157, 91, 176, 234,
                83, 119, 77, 72, 139, 218, 249, 223, 28, 110, 1, 36, 179, 239, 34,
            ],
        ],
        [
            [4; 32],
            [
                0, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
                4, 4, 4, 68,
            ],
            [
                172, 1, 178, 32, 158, 134, 53, 79, 184, 83, 35, 123, 93, 224, 244, 250, 177, 60,
                127, 203, 244, 51, 166, 28, 1, 147, 105, 97, 127, 236, 241, 11,
            ],
        ],
        [
            [5; 32],
            [
                0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
                5, 5, 5, 69,
            ],
            [
                80, 166, 20, 9, 177, 221, 208, 50, 94, 155, 22, 183, 0, 231, 25, 233, 119, 44, 7,
                0, 11, 27, 215, 120, 110, 144, 124, 101, 61, 32, 73, 93,
            ],
        ],
    ];

    for x in response {
        let keys = KeyPair::new(Some(x[0].to_vec()));
        assert_eq!(keys.prvk, x[1]);
        assert_eq!(keys.pubk, x[2]);
    }
}
