extern crate proc_macro;

mod ast;
mod derive;

use proc_macro::TokenStream;
use syn::{parse_macro_input, DeriveInput};

#[proc_macro_derive(EbmlSpecification, attributes(id, data_type))]
pub fn ebml_specification_derive(input: TokenStream) -> TokenStream {
    let input = parse_macro_input!(input as DeriveInput);
    
    derive::impl_ebml_specification_macro(&input)
        .unwrap_or_else(|err| err.to_compile_error())
        .into()
}