// Copyright 2018-2021 the Deno authors. All rights reserved. MIT license.
// Used for benchmarking Deno's tcp proxy performance.
import { copy } from "../../test_util/std/io/util.ts";

const addr = Deno.args[0] || "127.0.0.1:4500";
const originAddr = Deno.args[1] || "127.0.0.1:4501";

const [hostname, port] = addr.split(":");
const [originHostname, originPort] = originAddr.split(":");

const listener = Deno.listen({ hostname, port: Number(port) });

async function handle(conn: Deno.Conn): Promise<void> {
  const origin = await Deno.connect({
    hostname: originHostname,
    port: Number(originPort),
  });
  try {
    await Promise.all([copy(conn, origin), copy(origin, conn)]);
  } catch (e) {
    if (
      !(e instanceof Deno.errors.BrokenPipe) &&
      !(e instanceof Deno.errors.ConnectionReset)
    ) {
      throw e;
    }
  }
  conn.close();
  origin.close();
}

console.log(`Proxy listening on http://${addr}/`);
for await (const conn of listener) {
  handle(conn);
}
