use crate::spec::ArgType;

/// The error types for argument parsing.
///
/// If user inputs arguments incorrectly, [`ArgSpec::parse()`] will return [`Err(ParseError)`].
#[derive(Debug)]
pub enum ParseError {
  UnknownArgument(String),
  MissingParameter(String, ArgType),
  InvalidParameter(String, ArgType, String),
}

/// Convient [`Result`] type where [`E`] is [`ParseError`].
pub type Result<T> = std::result::Result<T, ParseError>;
