mod args;
mod errors;
mod spec;

#[cfg(test)]
mod tests {
  use super::errors::*;
  use super::spec::*;

  #[test]
  fn spec_builder() {
    let arg_spec = ArgSpec::build()
      .boolean("b")
      .integer("n")
      .unsigned_integer("u")
      .string("name")
      .done();

    assert!(arg_spec.has_arg("b", ArgType::Boolean));
    assert!(arg_spec.has_arg("n", ArgType::Integer));
    assert!(arg_spec.has_arg("u", ArgType::UInteger));
    assert!(arg_spec.has_arg("name", ArgType::String));
    assert!(!arg_spec.has_arg("none", ArgType::Boolean));
  }

  #[test]
  fn parse() -> Result<()> {
    let parse = ArgSpec::build()
      .boolean("b")
      .integer("n")
      .unsigned_integer("u")
      .string("name")
      .parse()?;
    assert_eq!(parse.loan_args().len(), 0);
    Ok(())
  }
}
