use crate::spec::ArgType;

#[derive(Debug)]
pub enum ParseError {
  UnknownArgument(String),
  MissingParameter(String, ArgType),
  InvalidParameter(String, ArgType, String),
}

pub type Result<T> = std::result::Result<T, ParseError>;
