use std::collections::HashMap;

#[derive(Debug)]
pub struct Args {
  bools: HashMap<String, bool>,
  ints: HashMap<String, i64>,
  uints: HashMap<String, u64>,
  strs: HashMap<String, String>,
  loan_args: Vec<String>,
}

impl Args {
  pub(crate) fn new(
    bools: HashMap<String, bool>,
    ints: HashMap<String, i64>,
    uints: HashMap<String, u64>,
    strs: HashMap<String, String>,
    loan_args: Vec<String>,
  ) -> Self {
    Args {
      bools,
      ints,
      uints,
      strs,
      loan_args,
    }
  }
  pub fn is_set(&self, name: impl Into<String>) -> bool {
    let n = name.into();
    self
      .bools
      .keys()
      .chain(self.ints.keys())
      .chain(self.uints.keys())
      .chain(self.strs.keys())
      .find(|&k| *k == n)
      .is_some()
  }
  pub fn boolean(&self, name: impl Into<String>) -> Option<&bool> {
    self.bools.get(&name.into())
  }
  pub fn integer(&self, name: impl Into<String>) -> Option<&i64> {
    self.ints.get(&name.into())
  }
  pub fn unsigned_integer(&self, name: impl Into<String>) -> Option<&u64> {
    self.uints.get(&name.into())
  }
  pub fn string(&self, name: impl Into<String>) -> Option<&String> {
    self.strs.get(&name.into())
  }
  pub fn loan_args(&self) -> &Vec<String> {
    &self.loan_args
  }
}
