use serde::Deserialize;
use std::fmt::Debug;

#[derive(Deserialize, Debug)]
pub struct Posts {
    posts: Vec<Post>,
}

#[derive(Deserialize, Debug)]
pub struct Post {
    id: u64,
    created_at: String,
    updated_at: String,
    file: PostFile,
    sample: Option<PostSample>,
    score: PostScore,
    tags: PostTags,
    locked_tags: Vec<String>,
    change_seq: i32,
    flags: PostFlags,
    rating: char,
    fav_count: i32,
    sources: Vec<String>,
    pools: Vec<i32>,
    relationships: PostRelationships,
    approver_id: Option<i32>,
    uploader_id: i32,
    description: String,
    comment_count: i32,
    is_favorited: bool,
    has_notes: bool,
}

#[derive(Deserialize, Debug)]
pub struct PostFile {
    width: i32,
    height: i32,
    ext: String,
    size: i32,
    md5: String,
    url: String,
}

#[derive(Deserialize, Debug)]
pub struct PostFlags {
    pending: bool,
    flagged: bool,
    note_locked: bool,
    status_locked: bool,
    rating_locked: bool,
    deleted: bool,
}

#[derive(Deserialize, Debug)]
pub struct PostPreview {
    width: i32,
    height: i32,
    url: String,
}

#[derive(Deserialize, Debug)]
pub struct PostSample {
    width: i32,
    height: i32,
    url: String,
}

#[derive(Deserialize, Debug)]
pub struct PostScore {
    up: i32,
    down: i32,
    total: i32,
}

#[derive(Deserialize, Debug)]
pub struct PostTags {
    general: Vec<String>,
    species: Vec<String>,
    character: Vec<String>,
    artist: Vec<String>,
    invalid: Vec<String>,
    lore: Vec<String>,
    meta: Vec<String>,
}

#[derive(Deserialize, Debug)]
pub struct PostRelationships {
    parent_id: Option<i32>,
    has_children: bool,
    has_active_children: bool,
}
