# e621-rs

## Install

Add latest the library to your Cargo.tml

[Cargo](https://crates.io/crates/e621-rs)
[Gitea](https://git.doggoat.de/dhalucario/e621-rs/)

## Example
Cargo.toml:

``` toml
...
[dependencies]
e621-rs = "0.1.2"
tokio = { version = "1.0", features = ["full"] }
```

main.rs
``` rust
use e621_rs::e621_client::Client;
use e621_rs::requests::PostsListOptions;

#[tokio::main]
async fn main() -> Result<(), Box<dyn std::error::Error>> {
    let client = Client::new(
        String::from("https://e621.net"),
        String::from("MyProject/1.0 (by username on e621)"),
        String::from("username"),
        String::from("apikey")
    ).unwrap();

    let res = client.post_list(
        PostsListOptions {
            limit: Some(32),
            tags: Some(String::from("lucario")),
            page: None
        }
    ).await;

    println!("{:?}", res);
    Ok(())
}
```
