use reqwest::StatusCode;
use std::fmt;

#[derive(Debug)]
pub struct UnsuccessfulResponseError {
    pub http_status_code: StatusCode,
    pub body: String,
}

impl std::error::Error for UnsuccessfulResponseError {}
impl fmt::Display for UnsuccessfulResponseError {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        write!(
            f,
            "Response was unsuccessful [{}]. Check https://e621.net/help/api for more information",
            &self.http_status_code
        )
    }
}
