use crate::errors::UnsuccessfulResponseError;
use crate::requests::*;
use crate::responses::posts::Posts;
use reqwest::StatusCode;
use reqwest::Url;
use std::error::Error;

pub struct Client {
    client: reqwest::Client,
    base_url: String,
    login: String,
    api_key: String,
}

impl Client {
    pub fn new(
        base_url: String,
        user_agent: String,
        login: String,
        api_key: String,
    ) -> Result<Client, Box<dyn Error>> {
        let client = reqwest::Client::builder().user_agent(&user_agent).build()?;

        Ok(Client {
            client,
            base_url,
            login,
            api_key,
        })
    }

    async fn post(
        &self,
        url_path: &str,
        params: String,
    ) -> Result<String, Box<dyn std::error::Error>> {
        let result = self
            .client
            .get(Url::parse(format!("{}{}", &self.base_url, url_path).as_str()).unwrap())
            .basic_auth(&self.login, Some(&self.api_key))
            .body(params)
            .send()
            .await?;

        if result.status() == StatusCode::OK {
            Ok(result.text().await?)
        } else {
            Err(Box::new(UnsuccessfulResponseError {
                http_status_code: result.status(),
                body: result.text().await?,
            }))
        }
    }

    /*pub async fn post_create(
        self,

    )*/

    pub async fn post_list(
        self,
        post_list_options: PostsListOptions,
    ) -> Result<Posts, Box<dyn Error>> {
        Ok(serde_json::from_str(
            self.post(
                "/posts.json",
                serde_urlencoded::to_string(post_list_options)?,
            )
            .await?
            .as_str(),
        )?)
    }


}
