
use std::fs;
use std::os::raw::c_int;

use log::*;

use crate::config::CONFIG;

const HUP: c_int = 1;

/// Sends the HUP signal (1) to the NSD daemon so it re-reads its config.
pub fn hup_nsd() {
    if let Ok(pid_data) = fs::read_to_string(&CONFIG.nsd_pid) {
        if let Ok(pid) = pid_data.trim().parse::<i32>() {
            unsafe {
                if libc::kill(pid, HUP) == 0 {
                    info!("HUP {}", pid);
                } else {
                    error!("HUP failed {}", pid);
                }
            }
        }
    } else {
        error!("could not read pid file {}", &CONFIG.nsd_pid);
    }
}