
#[macro_use]
extern crate lazy_static;
extern crate log;
extern crate log4rs;
extern crate sha2;
extern crate toml;

pub const HDR_LEN: usize = 4;
pub const IP_LEN: usize = 4;
pub const HASH_LEN: usize = 32;

pub const REQUEST: u8  = 1;
pub const RESPONSE: u8 = 2;
pub const CONFIRM: u8  = 3;
pub const CREATED: u8  = 4;

pub const CHANGE: u8  = 5;
pub const CHANGED: u8  = 6;
pub const HUP: u8  = 7;

pub const IP_REQUEST: [u8; 4]  = [23,REQUEST,0,0];
pub const IP_RESPONSE: [u8; 4] = [23,RESPONSE,0,0];
pub const IP_CONFIRM: [u8; 4]  = [23,CONFIRM,0,0];
pub const IP_CREATED: [u8; 4]  = [23,CREATED,0,0];
pub const ZONE_CHANGE: [u8; 4]  = [23,CHANGE,0,0];
pub const ZONE_CHANGED: [u8; 4]  = [23,CHANGED,0,0];
pub const ZONE_HUP: [u8; 4]  = [23,HUP,0,0];

pub mod config;
pub mod nsd;
pub mod packet;
pub mod zone;
pub mod util;