# dynnsd

A client and server for generating dynamic DNS entries.  

- The ability to give your home router a DNS name.

`dynnsd` is designed to help replace dyndns which was purchased by Oracle who subsequently sold domain registration to a third party.

Given the cheap price of virtual servers, and the good work of NLnetLabs its possible to run a pair of industrial strength DNS servers 
for about 5 bucks a month.

`dynnsd` provides the dynamic DNS part of the service, i.e. providing home routers with Internet valid DNS addresses.

A server behind a NATted home router runs the client indicating its IP address and dynnsd server code writes out a zone file
including an A record and asks `nsd` to re-read its config.

`dynnsd-client` sends its IP to both nsd instances separately so there is no need for zone transfer.  Its possible the instances get out of sync
but its also possible that neither have the correct IP.

## Dynamic DNS Protocol

Protocol consists of 4 messages between client and server.  Client runs on a home network, server runs on the same host as an `nsd` server.

![sequence diagram](doc/seq.png)

`dynnsd-client` sends an _ip_request_ message, it does not know its own IP address yet, `dynnsd-client` may be behind a NAT router and have its source IP and port changed.

When the `dynnsd` server receives an _ip_request_, it sends an _ip_reply_ including the client's source IP address.

When the `dynnsd-client` receives the _ip_reply_, it sends an _ip_confirm_ request to one or more `dynnsd` servers to indicate they should add the IP address
to DNS.

When a `dynnsd` server receives an _ip_confirm_ with an IP address that matches the source IP address, it creates a DNS A record.

    ; ddns
    homesrv      5m  IN  A     23.24.25.26

and HUPs `nsd`.

## Zone Change Protocol

`dynnsd` also supports a zone change message that changes the main zone file and HUPs `nsd`.

For example, to fail over the zone to a backup data center or place the zone in maintenance mode. Dynamic hosts are copied to the new
zone.

You can also send a ZONE_HUP to hup `nsd`, for example after rsyncing static zone file changes. 


## Messages

Messages are 72 byte UDP messages containing fixed length fields.

**IP_REQUEST**

- 4 bytes - 23.1.0.0 - header, magic_number, msg type, 0, 0
- 4 bytes - 0.0.0.0
- 32 bytes - random
- 32 bytes - sha256 hash

**IP_RESPONSE**

- 4 bytes - 23.2.0.0
- 4 bytes - src ip address (human readable byte order)
- 32 bytes - random data
- 32 bytes - sha256 hash

**IP_CONFIRM**

- 4 bytes - 23.3.0.0
- 4 bytes - src ip address
- 1 byte -  host_index, each dynnsd server supports up to 256 clients
- 23 bytes - random
- 8 bytes - minute of unix epoc (epoc / 60)
- 32 bytes - sha256 hash

**IP_CREATED**

- 4 bytes - 23.4.0.0
- 4 byte - host_index,0,0,0
- 32 bytes - random
- 32 bytes - sha256 hash

**ZONE_CHANGE**

- 4 bytes - 23.5.0.0 - header, magic_number, msg type, 0, 0
- 4 bytes - zone_index.0.0.0
- 32 bytes - random
- 32 bytes - sha256 hash

**ZONE_CHANGED**

- 4 bytes - 23.6.0.0 - header, magic_number, msg type, 0, 0
- 4 bytes - zone_index.0.0.0
- 32 bytes - random
- 32 bytes - sha256 hash

**ZONE_HUP**

- 4 bytes - 23.7.0.0 - header, magic_number, msg type, 0, 0
- 4 bytes - zone_index.0.0.0
- 32 bytes - random
- 32 bytes - sha256 hash
