# server configuration

Install an NSD server [NSD server](https://www.nlnetlabs.nl/projects/nsd/about/)

Create zone files in `/etc/nsd/`

For each `.zone` file that will have dynamic entries create a `.static.zone` file.

`dynnsd` will edit this file to add dynamic hosts

    ; start dynnsd
    
    myhost                           5m  IN  A     10.0.3.23
    otherhost                        5m  IN  A     10.0.3.23
    home                             5m  IN  A     10.0.3.23
    
    ; end dynnsd
    

The server running `nsd` should also start `/usr/sbin/dynnsd` in the same os, (or vm or lxc container).

`dynnsd` will look for `/run/nsd.pid` so that it can HUP the process when the config changes.

`dynnsd` server is configured with  `./etc/dynnsd.toml`,  N.B. `secret_string` will be randomly generated in the first install, this should be kept secret.

Notice the current directory `./etc`  not `/etc/`, this directory can be changed with `DYNNSD_CONF` variable.

e.g. `DYNNSD_CONF=/etc`

the entry 

    hostnames = ["home"]
    
Provides a static list of hostnames that can have dynamic IPs added.  For security reasons, it is not possible for clients to setup unconfigured names.
 

# client configuration

The client runs `dynnsd-client` periodically.

The client should run on cron or try to detect when its IP changes,  e.g. on router reboot.

Client is configured with `./etc/dynnsd-client.toml`  this should define the ip:port or dynnsd servers, there can be more than 1, typically DNS servers have 2 or 3 clones.

`secret_string` and `secret_iterations` must be the same as on the server.

`host_index` in the zero based index into the `hostnames` array on the server.

The client runs `dynnsd-client`, config is read from `./etc` 

N.B. the client does not have to know its own IP address, the server will work this out if the IP is natted from the incoming message.  

Naturally the IP address that finally reaches the dynnsd server should be the one that is publicly visible.


# Security

N.B. communication is UDP plain text over the Internet, the messages transfer IP addresses which are already visible in the IP packets.  
The messages are signed with the shared secret to ensure it not possible to incorrectly set an IP address for a host. 
