## If the dynamized trait isn't object safe you get a compile error

```rust compile_fail
trait ObjectUnsafe: Sized {}

#[dynamize::dynamize]
trait Trait: ObjectUnsafe {}
```

```rust compile_fail
trait ObjectUnsafe: Sized {}

#[dynamize::dynamize]
trait Trait {
    type A: ObjectUnsafe;

    fn f(&self) -> Self::A;
}
```

## Same-named method generics must have same trait bounds

Works:

```rust
#[dynamize::dynamize]
trait Trait {
    type A: std::error::Error;

    fn a<A: std::fmt::Display>(&self, a: A) -> Self::A;
    fn b<A: std::fmt::Display>(&self, a: A) -> Self::A;
}
```

```rust
#[dynamize::dynamize]
trait Trait {
    type A: std::error::Error;

    fn a<A>(&self, a: A) -> Self::A;
    fn b<B: std::fmt::Display>(&self, a: B) -> Self::A;
}
```


Fails:

```rust compile_fail
#[dynamize::dynamize]
trait Trait {
    type A: std::error::Error;

    fn a<A>(&self, a: A) -> Self::A;
    fn b<A: std::fmt::Display>(&self, a: A) -> Self::A;
}
```

## Where clause must not contain associated types in complex predicates

Works:

```rust
#[dynamize::dynamize]
trait TraitWithCallback {
    type A: Into<String>;

    fn a<G>(&self, a: G) where G: Fn(Self::A);
}
```

Fails:

```rust compile_fail
#[dynamize::dynamize]
trait TraitWithCallback {
    type A: Into<String>;

    fn a<G>(&self, a: G) where G: Into<Self::A>;
}
```

Fails:

```rust compile_fail
struct MyType<A>(A);
trait SomeTrait {}

#[dynamize::dynamize]
trait TraitWithCallback {
    type A: Into<String>;

    fn a<G>(&self, a: G) where MyType<Self::A>: SomeTrait;
}
```
