
extern crate dvcompute_utils;

use dvcompute_utils::collections::im::Queue;

#[test]
fn test_queue_iter() {
    let xs = Queue::empty();
    let xs = xs.push_back(1).push_back(2).push_back(3);
    let ys = xs.iter().collect::<Vec<usize>>();
    assert_eq!(ys, vec![1, 2, 3]);
}

#[test]
fn test_queue_pop() {
    let xs = Queue::empty();
    let xs = xs.push_back(1).push_back(2).push_back(3);
    if let Some((item, xs)) = xs.pop_front() {
        let ys = xs.iter().collect::<Vec<usize>>();
        assert_eq!(item, 1);
        assert_eq!(ys, vec![2, 3]);
    } else {
        panic!("Failed the pop_front() call");
    }
}

#[test]
fn test_queue_front() {
    let xs = Queue::empty();
    let xs = xs.push_back(1).push_back(2).push_back(3);
    if let Some(item) = xs.front() {
        assert_eq!(item, 1);
    } else {
        panic!("Failed the front() call");
    }
}

#[test]
fn test_queue_remove() {
    let xs = Queue::empty();
    let xs = xs.push_back(1).push_back(2).push_back(3);
    match xs.remove(2) {
        None => panic!("Failed the remove() method"),
        Some((item, xs)) => {
            let ys = xs.iter().collect::<Vec<usize>>();
            assert_eq!(item, 2);
            assert_eq!(ys, vec![1, 3]);
        }
    }
}

#[test]
fn test_queue_remove_front() {
    let xs = Queue::empty();
    let xs = xs.push_back(1).push_back(2).push_back(3);
    match xs.remove(1) {
        None => panic!("Failed the remove() method"),
        Some((item, xs)) => {
            let ys = xs.iter().collect::<Vec<usize>>();
            assert_eq!(item, 1);
            assert_eq!(ys, vec![2, 3]);
        }
    }
}

#[test]
fn test_queue_remove_back() {
    let xs = Queue::empty();
    let xs = xs.push_back(1).push_back(2).push_back(3);
    match xs.remove(3) {
        None => panic!("Failed the remove() method"),
        Some((item, xs)) => {
            let ys = xs.iter().collect::<Vec<usize>>();
            assert_eq!(item, 3);
            assert_eq!(ys, vec![1, 2]);
        }
    }
}

#[test]
fn test_list_remove_by() {
    let xs = Queue::empty();
    let xs = xs.push_back(1).push_back(2).push_back(3);
    match xs.remove_by(|x| *x == 2) {
        None => panic!("Failed the remove() method"),
        Some((item, xs)) => {
            let ys = xs.iter().collect::<Vec<usize>>();
            assert_eq!(item, 2);
            assert_eq!(ys, vec![1, 3]);
        }
    }
}
