
extern crate dvcompute_utils;

use std::rc::Rc;

use dvcompute_utils::collections::im::List;

#[test]
fn test_list_iter() {
    let xs = List::Cons(1, Rc::new(List::Cons(2, Rc::new(List::Cons(3, Rc::new(List::Nil))))));
    let ys = xs.iter().collect::<Vec<usize>>();
    assert_eq!(ys, vec![1, 2, 3]);
}

#[test]
fn test_list_remove_first() {
    let xs = List::Cons(1, Rc::new(List::Cons(2, Rc::new(List::Cons(3, Rc::new(List::Nil))))));
    match xs.remove(1) {
        None => panic!("Failed the remove() method"),
        Some((item, xs)) => {
            let ys = xs.iter().collect::<Vec<usize>>();
            assert_eq!(item, 1);
            assert_eq!(ys, vec![2, 3]);
        }
    }
}

#[test]
fn test_list_remove_middle() {
    let xs = List::Cons(1, Rc::new(List::Cons(2, Rc::new(List::Cons(3, Rc::new(List::Nil))))));
    match xs.remove(2) {
        None => panic!("Failed the remove() method"),
        Some((item, xs)) => {
            let ys = xs.iter().collect::<Vec<usize>>();
            assert_eq!(item, 2);
            assert_eq!(ys, vec![1, 3]);
        }
    }
}

#[test]
fn test_list_remove_last() {
    let xs = List::Cons(1, Rc::new(List::Cons(2, Rc::new(List::Cons(3, Rc::new(List::Nil))))));
    match xs.remove(3) {
        None => panic!("Failed the remove() method"),
        Some((item, xs)) => {
            let ys = xs.iter().collect::<Vec<usize>>();
            assert_eq!(item, 3);
            assert_eq!(ys, vec![1, 2]);
        }
    }
}

#[test]
fn test_list_remove_first_by() {
    let xs = List::Cons(1, Rc::new(List::Cons(2, Rc::new(List::Cons(3, Rc::new(List::Nil))))));
    match xs.remove_by(|x| *x == 1) {
        None => panic!("Failed the remove() method"),
        Some((item, xs)) => {
            let ys = xs.iter().collect::<Vec<usize>>();
            assert_eq!(item, 1);
            assert_eq!(ys, vec![2, 3]);
        }
    }
}

#[test]
fn test_list_remove_middle_by() {
    let xs = List::Cons(1, Rc::new(List::Cons(2, Rc::new(List::Cons(3, Rc::new(List::Nil))))));
    match xs.remove_by(|x| *x == 2) {
        None => panic!("Failed the remove() method"),
        Some((item, xs)) => {
            let ys = xs.iter().collect::<Vec<usize>>();
            assert_eq!(item, 2);
            assert_eq!(ys, vec![1, 3]);
        }
    }
}

#[test]
fn test_list_remove_last_by() {
    let xs = List::Cons(1, Rc::new(List::Cons(2, Rc::new(List::Cons(3, Rc::new(List::Nil))))));
    match xs.remove_by(|x| *x == 3) {
        None => panic!("Failed the remove() method"),
        Some((item, xs)) => {
            let ys = xs.iter().collect::<Vec<usize>>();
            assert_eq!(item, 3);
            assert_eq!(ys, vec![1, 2]);
        }
    }
}

#[test]
fn test_list_reverse() {
    let xs = List::Cons(1, Rc::new(List::Cons(2, Rc::new(List::Cons(3, Rc::new(List::Nil))))));
    let ys = xs.reversed().iter().collect::<Vec<usize>>();
    assert_eq!(ys, vec![3, 2, 1]);
}

#[test]
fn test_list_append() {
    let xs1 = List::Cons(1, Rc::new(List::Cons(2, Rc::new(List::Nil))));
    let xs2 = List::Cons(3, Rc::new(List::Cons(4, Rc::new(List::Nil))));
    let xs = xs1.append(Rc::new(xs2));
    let ys = xs.iter().collect::<Vec<usize>>();
    assert_eq!(ys, vec![1, 2, 3, 4]);
}
